from datetime import datetime
mlYyf=str
mlYyT=int
mlYyp=super
mlYye=False
mlYyN=isinstance
mlYyK=hash
mlYyw=True
mlYyA=list
mlYyG=map
mlYyP=None
from typing import Set
from localstack_ext.bootstrap.cpvcs.constants import(COMMIT_TXT_LAYOUT,REV_TXT_LAYOUT,STATE_TXT_LAYOUT,STATE_TXT_METADATA,VER_TXT_LAYOUT)
class CPVCSObj:
 def __init__(self,hash_ref:mlYyf):
  self.hash_ref:mlYyf=hash_ref
class StateFileRef(CPVCSObj):
 txt_layout=STATE_TXT_LAYOUT
 metadata_layout=STATE_TXT_METADATA
 def __init__(self,hash_ref:mlYyf,rel_path:mlYyf,file_name:mlYyf,size:mlYyT,service:mlYyf,region:mlYyf):
  mlYyp().__init__(hash_ref)
  self.rel_path:mlYyf=rel_path
  self.file_name:mlYyf=file_name
  self.size:mlYyT=size
  self.service:mlYyf=service
  self.region:mlYyf=region
 def __str__(self):
  return self.txt_layout.format(size=self.size,service=self.service,region=self.region,mlYyK=self.hash_ref,file_name=self.file_name,rel_path=self.rel_path)
 def __eq__(self,other):
  if not other:
   return mlYye
  if not mlYyN(other,StateFileRef):
   return mlYye
  return(self.hash_ref==other.hash_ref and self.region==other.region and self.service==self.service and self.file_name==other.file_name and self.size==other.size)
 def __hash__(self):
  return mlYyK((self.hash_ref,self.region,self.service,self.file_name,self.size))
 def congruent(self,other):
  if not other:
   return mlYye
  if not mlYyN(other,StateFileRef):
   return mlYye
  return(self.region==other.region and self.service==other.service and self.file_name==other.file_name and self.rel_path==other.rel_path)
 def any_congruence(self,others):
  for other in others:
   if self.congruent(other):
    return mlYyw
  return mlYye
 def metadata(self)->mlYyf:
  return self.metadata_layout.format(size=self.size,service=self.service,region=self.region)
class CPVCSNode(CPVCSObj):
 def __init__(self,hash_ref:mlYyf,state_files:Set[StateFileRef],parent_ptr:mlYyf):
  mlYyp().__init__(hash_ref)
  self.state_files:Set[StateFileRef]=state_files
  self.parent_ptr:mlYyf=parent_ptr
 def state_files_info(self)->mlYyf:
  return "\n".join(mlYyA(mlYyG(lambda state_file:mlYyf(state_file),self.state_files)))
class Commit:
 txt_layout=COMMIT_TXT_LAYOUT
 def __init__(self,tail_ptr:mlYyf,head_ptr:mlYyf,message:mlYyf,timestamp:mlYyf=mlYyf(datetime.now().timestamp()),delta_log_ptr:mlYyf=mlYyP):
  self.tail_ptr:mlYyf=tail_ptr
  self.head_ptr:mlYyf=head_ptr
  self.message:mlYyf=message
  self.timestamp:mlYyf=timestamp
  self.delta_log_ptr:mlYyf=delta_log_ptr
 def __str__(self):
  return self.txt_layout.format(tail_ptr=self.tail_ptr,head_ptr=self.head_ptr,message=self.message,timestamp=self.timestamp,log_hash=self.delta_log_ptr)
 def info_str(self,from_node:mlYyf,to_node:mlYyf)->mlYyf:
  return f"from: {from_node}, to: {to_node}, message: {self.message}, time: {datetime.fromtimestamp(float(self.timestamp))}"
class Revision(CPVCSNode):
 txt_layout=REV_TXT_LAYOUT
 def __init__(self,hash_ref:mlYyf,state_files:Set[StateFileRef],parent_ptr:mlYyf,creator:mlYyf,rid:mlYyf,revision_number:mlYyT,assoc_commit:Commit=mlYyP):
  mlYyp().__init__(hash_ref,state_files,parent_ptr)
  self.creator:mlYyf=creator
  self.rid:mlYyf=rid
  self.revision_number:mlYyT=revision_number
  self.assoc_commit=assoc_commit
 def __str__(self):
  return self.txt_layout.format(mlYyK=self.hash_ref,parent=self.parent_ptr,creator=self.creator,rid=self.rid,rev_no=self.revision_number,state_files=";".join(mlYyG(lambda state_file:mlYyf(state_file),self.state_files))if self.state_files else "",assoc_commit=mlYyf(self.assoc_commit))
class Version(CPVCSNode):
 txt_layout=VER_TXT_LAYOUT
 def __init__(self,hash_ref:mlYyf,state_files:Set[StateFileRef],parent_ptr:mlYyf,creator:mlYyf,comment:mlYyf,active_revision_ptr:mlYyf,outgoing_revision_ptrs:Set[mlYyf],incoming_revision_ptr:mlYyf,version_number:mlYyT):
  mlYyp().__init__(hash_ref,state_files,parent_ptr)
  self.creator=creator
  self.comment=comment
  self.active_revision_ptr=active_revision_ptr
  self.outgoing_revision_ptrs=outgoing_revision_ptrs
  self.incoming_revision_ptr=incoming_revision_ptr
  self.version_number=version_number
 def __str__(self):
  return VER_TXT_LAYOUT.format(mlYyK=self.hash_ref,parent=self.parent_ptr,creator=self.creator,comment=self.comment,version_number=self.version_number,active_revision=self.active_revision_ptr,outgoing_revisions=";".join(self.outgoing_revision_ptrs),incoming_revision=self.incoming_revision_ptr,state_files=";".join(mlYyG(lambda stat_file:mlYyf(stat_file),self.state_files))if self.state_files else "")
 def info_str(self):
  return f"{self.version_number}, {self.creator}, {self.comment}"
# Created by pyminifier (https://github.com/liftoff/pyminifier)
