# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mdformat_toc']

package_data = \
{'': ['*']}

install_requires = \
['mdformat>=0.6.3,<0.7.0']

entry_points = \
{'mdformat.parser_extension': ['toc = mdformat_toc.plugin']}

setup_kwargs = {
    'name': 'mdformat-toc',
    'version': '0.2.3',
    'description': 'Mdformat plugin to generate table of contents',
    'long_description': '[![Build Status](https://github.com/hukkinj1/mdformat-toc/workflows/Tests/badge.svg?branch=master)](https://github.com/hukkinj1/mdformat-toc/actions?query=workflow%3ATests+branch%3Amaster+event%3Apush)\n[![PyPI version](https://img.shields.io/pypi/v/mdformat-toc)](https://pypi.org/project/mdformat-toc)\n\n# mdformat-toc\n\n> Mdformat plugin to generate a table of contents\n\n**Table of Contents**  *generated with [mdformat-toc](https://github.com/hukkinj1/mdformat-toc)*\n\n<!-- mdformat-toc start --slug=github --no-anchors --maxlevel=6 --minlevel=2 -->\n\n- [Description](#description)\n- [Install](#install)\n- [Usage](#usage)\n  - [Configuration](#configuration)\n    - [Minimum and maximum heading levels](#minimum-and-maximum-heading-levels)\n    - [Disabling anchor generation](#disabling-anchor-generation)\n    - [Changing the slug function](#changing-the-slug-function)\n\n<!-- mdformat-toc end -->\n\n## Description\n\nMdformat-toc is an [mdformat](https://github.com/executablebooks/mdformat) plugin\nthat adds mdformat the capability to auto-generate a table of contents (ToC).\nThe ToC is generated in a user-specified location in the Markdown file.\n\nMdformat-toc, by default, creates an HTML anchor for each heading listed in the ToC.\nToC links should therefore be compatible with any well-behaved Markdown renderer (including GitLab\'s renderer).\n\nHTML anchor generation can be disabled, in which case a user should configure a slug function that is compatible with the Markdown renderer used (GitHub and GitLab slug functions are currently supported).\n\n## Install\n\n```bash\npip install mdformat-toc\n```\n\n## Usage\n\nAdd the following line to your Markdown file.\nA ToC will be generated in the location indicated by it.\n\n```markdown\n<!-- mdformat-toc start -->\n```\n\nAfter adding the indicator line, simply run\n\n```bash\nmdformat <filename>\n```\n\nand mdformat will generate a ToC.\n\n### Configuration\n\nArguments can be added to the indicator line to alter how the ToC is generated.\nAn indicator line with the default options would look like:\n\n```markdown\n<!-- mdformat-toc start --slug=github --maxlevel=6 --minlevel=1 -->\n```\n\nPlacing more than one indicator lines in a document is currently not supported.\n\n#### Minimum and maximum heading levels\n\nA user can configure a range of heading levels to be included in the ToC (and to be "anchored").\nFor instance, the following configuration will only list 2nd, 3rd and 4th level headings in the ToC:\n\n```markdown\n<!-- mdformat-toc start --minlevel=2 --maxlevel=4 -->\n```\n\n#### Disabling anchor generation\n\nBy default, an HTML anchor is appended to each heading.\nFor instance, the following heading\n\n```markdown\n# Some title\n```\n\nmight be formatted as\n\n```markdown\n# Some title<a name="some-title"></a>\n```\n\nThis ensures that ToC links do not rely on a Markdown renderer to create HTML anchors,\nand makes the links universally compatible.\n\nToC links are by default compatible with the anchors generated by GitHub\'s Markdown renderer.\nIf your Markdown is only hosted on GitHub, you can disable mdformat-toc\'s HTML anchor generation:\n\n```markdown\n<!-- mdformat-toc start --no-anchors -->\n```\n\n#### Changing the slug function\n\nMdformat-toc defaults to using GitHub\'s slug function.\n\nIf your Markdown is not hosted on GitHub you may want to use GitLab\'s slug function instead:\n\n```markdown\n<!-- mdformat-toc start --slug=gitlab --no-anchors -->\n```\n\n**NOTE:** Unlike GitLab, GitHub requires using its own slug function in order for ToC links to work expectedly.\nCreating HTML anchors and using a non-GitHub slug function is not GitHub compatible\nbecause GitHub\'s Markdown renderer modifies the HTML anchors mdformat-toc creates.\nThe default configuration\n(GitHub slug function and anchor generation)\nis the only configuration cross-compatible with GitHub and GitLab.\n',
    'author': 'Taneli Hukkinen',
    'author_email': 'hukkinj1@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/hukkinj1/mdformat-toc',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
