"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const aws_certificatemanager_1 = require("@aws-cdk/aws-certificatemanager");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const construct_hub_1 = require("../construct-hub");
const dummyAlarmAction = {
    highSeverity: 'arn:aws:sns:us-east-1:123456789012:mystack-mytopic-NZJ5JSMVGFIE',
};
test('minimal usage', () => {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Test');
    new construct_hub_1.ConstructHub(stack, 'ConstructHub', {
        alarmActions: dummyAlarmAction,
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('with domain', () => {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Test');
    const zone = aws_route53_1.PublicHostedZone.fromHostedZoneAttributes(stack, 'Zone', {
        hostedZoneId: 'ZONEID',
        zoneName: 'my.construct.hub',
    });
    const cert = new aws_certificatemanager_1.DnsValidatedCertificate(stack, 'Cert', { hostedZone: zone, domainName: zone.zoneName });
    new construct_hub_1.ConstructHub(stack, 'ConstructHub', {
        domain: {
            zone, cert,
        },
        alarmActions: dummyAlarmAction,
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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