# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cemm']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.0.0', 'yarl>=1.6.0']

setup_kwargs = {
    'name': 'cemm',
    'version': '0.3.0',
    'description': 'Asynchronous Python client for the CEMM devices',
    'long_description': '## Python - CEMM Client\n\n<!-- PROJECT SHIELDS -->\n[![GitHub Release][releases-shield]][releases]\n[![Python Versions][python-versions-shield]][pypi]\n![Project Stage][project-stage-shield]\n![Project Maintenance][maintenance-shield]\n[![License][license-shield]](LICENSE)\n\n[![GitHub Activity][commits-shield]][commits-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n[![GitHub Last Commit][last-commit-shield]][commits-url]\n\n[![Code Quality][code-quality-shield]][code-quality]\n[![Maintainability][maintainability-shield]][maintainability-url]\n[![Code Coverage][codecov-shield]][codecov-url]\n[![Build Status][build-shield]][build-url]\n\nAsynchronous Python client for the CEMM devices.\n\n## About\n\nA python package with which you can read the data from your [CEMM][cemm] device via a local API. You can use it to read your smart meter via the P1, read your water meter and gain insight into how much your solar panels are producing.\n\n## Installation\n\n```bash\npip install cemm\n```\n\n## Usage\n\n```py\nimport asyncio\n\nfrom cemm import CEMM\n\n\nasync def main():\n    """Show example on getting data from your CEMM device."""\n    async with CEMM(\n        host="example_host",\n    ) as client:\n        connections = await client.all_connections()\n        device = await client.device()\n        smartmeter = await client.smartpanel("p1")\n        water = await client.water("pulse-1")\n        solarpanel = await client.solarpanel("mb3")\n        print(connections)\n        print(device)\n        print(smartmeter)\n        print(water)\n        print(solarpanel)\n\n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(main())\n```\n\n## Data\n\nYou can read the following data with this package, the `power flow` entities can also give a negative value.\n\n### Connections\n\n- ID\n- Type\n- Alias\n\n### Device\n\n- Model\n- Mac address\n- Version\n- Core version\n\n### SmartMeter\n\n- Power Flow (W)\n- Gas Consumption (m3)\n- Energy Tariff Period\n- Energy Consumption - High / Low (kWh)\n- Energy Returned - High / Low (kWh)\n- Billed Energy - High / Low (kWh)\n\n### Water\n\n- Flow (liters)\n- Volume\n\n### Solarpanel\n\n- Power Flow (W)\n- Device Consumption - High / Low / Total (kWh)\n- Gross Production - High / Low / Total (kWh)\n- Net Production - High / Low / Total (kWh)\n\n## Contributing\n\nThis is an active open-source project. We are always open to people who want to\nuse the code or contribute to it.\n\nWe\'ve set up a separate document for our\n[contribution guidelines](CONTRIBUTING.md).\n\nThank you for being involved! :heart_eyes:\n\n## Setting up development environment\n\nThis Python project is fully managed using the [Poetry][poetry] dependency\nmanager.\n\nYou need at least:\n\n- Python 3.8+\n- [Poetry][poetry-install]\n\nInstall all packages, including all development requirements:\n\n```bash\npoetry install\n```\n\nPoetry creates by default an virtual environment where it installs all\nnecessary pip packages, to enter or exit the venv run the following commands:\n\n```bash\npoetry shell\nexit\n```\n\nSetup the pre-commit check, you must run this inside the virtual environment:\n\n```bash\npre-commit install\n```\n\n*Now you\'re all set to get started!*\n\nAs this repository uses the [pre-commit][pre-commit] framework, all changes\nare linted and tested with each commit. You can run all checks and tests\nmanually, using the following command:\n\n```bash\npoetry run pre-commit run --all-files\n```\n\nTo run just the Python tests:\n\n```bash\npoetry run pytest\n```\n\n## License\n\nMIT License\n\nCopyright (c) 2021 Klaas Schoute\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n\n[cemm]: https://cemm.nl\n\n<!-- MARKDOWN LINKS & IMAGES -->\n[build-shield]: https://github.com/klaasnicolaas/python-cemm/actions/workflows/tests.yaml/badge.svg\n[build-url]: https://github.com/klaasnicolaas/python-cemm/actions/workflows/tests.yaml\n[code-quality-shield]: https://img.shields.io/lgtm/grade/python/g/klaasnicolaas/python-cemm.svg?logo=lgtm&logoWidth=18\n[code-quality]: https://lgtm.com/projects/g/klaasnicolaas/python-cemm/context:python\n[commits-shield]: https://img.shields.io/github/commit-activity/y/klaasnicolaas/python-cemm.svg\n[commits-url]: https://github.com/klaasnicolaas/python-cemm/commits/main\n[codecov-shield]: https://codecov.io/gh/klaasnicolaas/python-cemm/branch/main/graph/badge.svg?token=VQTR24YFQ9\n[codecov-url]: https://codecov.io/gh/klaasnicolaas/python-cemm\n[forks-shield]: https://img.shields.io/github/forks/klaasnicolaas/python-cemm.svg\n[forks-url]: https://github.com/klaasnicolaas/python-cemm/network/members\n[issues-shield]: https://img.shields.io/github/issues/klaasnicolaas/python-cemm.svg\n[issues-url]: https://github.com/klaasnicolaas/python-cemm/issues\n[license-shield]: https://img.shields.io/github/license/klaasnicolaas/python-cemm.svg\n[last-commit-shield]: https://img.shields.io/github/last-commit/klaasnicolaas/python-cemm.svg\n[maintenance-shield]: https://img.shields.io/maintenance/yes/2021.svg\n[maintainability-shield]: https://api.codeclimate.com/v1/badges/82ca5d035a7ef3520b52/maintainability\n[maintainability-url]: https://codeclimate.com/github/klaasnicolaas/python-cemm/maintainability\n[project-stage-shield]: https://img.shields.io/badge/project%20stage-experimental-yellow.svg\n[pypi]: https://pypi.org/project/cemm/\n[python-versions-shield]: https://img.shields.io/pypi/pyversions/cemm\n[releases-shield]: https://img.shields.io/github/release/klaasnicolaas/python-cemm.svg\n[releases]: https://github.com/klaasnicolaas/python-cemm/releases\n[stars-shield]: https://img.shields.io/github/stars/klaasnicolaas/python-cemm.svg\n[stars-url]: https://github.com/klaasnicolaas/python-cemm/stargazers\n\n[energiewacht]: https://www.energiewacht.com/hoofdsite/home/nieuws/omnik-failliet/\n[poetry-install]: https://python-poetry.org/docs/#installation\n[poetry]: https://python-poetry.org\n[pre-commit]: https://pre-commit.com\n',
    'author': 'Klaas Schoute',
    'author_email': 'hello@student-techlife.com',
    'maintainer': 'Klaas Schoute',
    'maintainer_email': 'hello@student-techlife.com',
    'url': 'https://github.com/klaasnicolaas/python-cemm',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
