# -*- coding: utf-8 -*-
import io
import os
from setuptools import setup, find_packages


def read(*rnames):
    return io.open(
        os.path.join('.', *rnames), encoding="utf-8"
    ).read()

install_requires = [
    a.strip()
    for a in read('requirements/base.txt').splitlines()
    if a.strip() and not a.startswith(('#', '-'))
]

long_description = "\n\n".join(
    [
        read('README.rst'),
        read('docs', 'CHANGES.rst'),
    ]
)

setup(
    name='croniter',
    version='1.3.0',
    py_modules=['croniter', ],
    description=(
        'croniter provides iteration for datetime '
        'object with cron like format'
    ),
    long_description=long_description,
    author="Matsumoto Taichi, kiorky",
    author_email='taichino@gmail.com, kiorky@cryptelium.net',
    url='http://github.com/kiorky/croniter',
    keywords='datetime, iterator, cron',
    install_requires=install_requires,
    license="MIT License",
    python_requires='>=2.6, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*',
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: POSIX",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 2.6",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.4",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Topic :: Software Development :: Libraries :: Python Modules"],
    packages=find_packages('src', exclude=['tests*', '*.tests*']),
    package_dir={'': 'src'},
    include_package_data=True,
    exclude_package_data={'croniter': ['tests/*']},
)
