"""
    Ory APIs

    Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed with a valid Personal Access Token. Public APIs are mostly used in browsers.   # noqa: E501

    The version of the OpenAPI document: v0.0.1-alpha.148
    Contact: support@ory.sh
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ory_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from ory_client.exceptions import ApiAttributeError


def lazy_import():
    from ory_client.model.project_revision_hooks import ProjectRevisionHooks
    from ory_client.model.project_revision_identity_schemas import ProjectRevisionIdentitySchemas
    from ory_client.model.project_revision_third_party_login_providers import ProjectRevisionThirdPartyLoginProviders
    from ory_client.model.string_slice_json_format import StringSliceJSONFormat
    globals()['ProjectRevisionHooks'] = ProjectRevisionHooks
    globals()['ProjectRevisionIdentitySchemas'] = ProjectRevisionIdentitySchemas
    globals()['ProjectRevisionThirdPartyLoginProviders'] = ProjectRevisionThirdPartyLoginProviders
    globals()['StringSliceJSONFormat'] = StringSliceJSONFormat


class NormalizedProjectRevision(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'name': (str,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'kratos_cookies_same_site': (str,),  # noqa: E501
            'kratos_courier_smtp_connection_uri': (str,),  # noqa: E501
            'kratos_courier_smtp_from_address': (str,),  # noqa: E501
            'kratos_courier_smtp_from_name': (str,),  # noqa: E501
            'kratos_courier_smtp_headers': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'kratos_courier_templates_recovery_invalid_email_body_html': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_invalid_email_body_plaintext': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_invalid_email_subject': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_valid_email_body_html': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_valid_email_body_plaintext': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_valid_email_subject': (str,),  # noqa: E501
            'kratos_courier_templates_verification_invalid_email_body_html': (str,),  # noqa: E501
            'kratos_courier_templates_verification_invalid_email_body_plaintext': (str,),  # noqa: E501
            'kratos_courier_templates_verification_invalid_email_subject': (str,),  # noqa: E501
            'kratos_courier_templates_verification_valid_email_body_html': (str,),  # noqa: E501
            'kratos_courier_templates_verification_valid_email_body_plaintext': (str,),  # noqa: E501
            'kratos_courier_templates_verification_valid_email_subject': (str,),  # noqa: E501
            'kratos_identity_schemas': (ProjectRevisionIdentitySchemas,),  # noqa: E501
            'kratos_secrets_cipher': (StringSliceJSONFormat,),  # noqa: E501
            'kratos_secrets_cookie': (StringSliceJSONFormat,),  # noqa: E501
            'kratos_secrets_default': (StringSliceJSONFormat,),  # noqa: E501
            'kratos_selfservice_allowed_return_urls': (StringSliceJSONFormat,),  # noqa: E501
            'kratos_selfservice_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_error_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_hooks': (ProjectRevisionHooks,),  # noqa: E501
            'kratos_selfservice_flows_login_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_after_oidc_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_after_password_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_after_webauthn_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_logout_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_recovery_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_recovery_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_flows_recovery_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_recovery_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_after_oidc_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_after_password_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_enabled': (bool, none_type,),  # noqa: E501
            'kratos_selfservice_flows_registration_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_after_password_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_after_profile_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_privileged_session_max_age': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_required_aal': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_verification_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_verification_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_flows_verification_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_verification_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_methods_link_config_base_url': (str,),  # noqa: E501
            'kratos_selfservice_methods_link_config_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_methods_link_enabled': (bool, none_type,),  # noqa: E501
            'kratos_selfservice_methods_lookup_secret_enabled': (bool, none_type,),  # noqa: E501
            'kratos_selfservice_methods_oidc_config_base_redirect_uri': (str,),  # noqa: E501
            'kratos_selfservice_methods_oidc_config_providers': (ProjectRevisionThirdPartyLoginProviders,),  # noqa: E501
            'kratos_selfservice_methods_oidc_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_methods_password_config_haveibeenpwned_enabled': (bool, none_type,),  # noqa: E501
            'kratos_selfservice_methods_password_config_identifier_similarity_check_enabled': (bool, none_type,),  # noqa: E501
            'kratos_selfservice_methods_password_config_ignore_network_errors': (bool, none_type,),  # noqa: E501
            'kratos_selfservice_methods_password_config_max_breaches': (int,),  # noqa: E501
            'kratos_selfservice_methods_password_config_min_password_length': (int,),  # noqa: E501
            'kratos_selfservice_methods_password_enabled': (bool, none_type,),  # noqa: E501
            'kratos_selfservice_methods_profile_enabled': (bool, none_type,),  # noqa: E501
            'kratos_selfservice_methods_totp_config_issuer': (str,),  # noqa: E501
            'kratos_selfservice_methods_totp_enabled': (bool, none_type,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_passwordless': (bool,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_rp_display_name': (str,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_rp_icon': (str,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_rp_id': (str,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_rp_origin': (str,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_enabled': (bool, none_type,),  # noqa: E501
            'kratos_session_cookie_persistent': (bool, none_type,),  # noqa: E501
            'kratos_session_cookie_same_site': (str,),  # noqa: E501
            'kratos_session_lifespan': (str,),  # noqa: E501
            'kratos_session_whoami_required_aal': (str,),  # noqa: E501
            'project_id': (str,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'name': 'name',  # noqa: E501
        'created_at': 'created_at',  # noqa: E501
        'id': 'id',  # noqa: E501
        'kratos_cookies_same_site': 'kratos_cookies_same_site',  # noqa: E501
        'kratos_courier_smtp_connection_uri': 'kratos_courier_smtp_connection_uri',  # noqa: E501
        'kratos_courier_smtp_from_address': 'kratos_courier_smtp_from_address',  # noqa: E501
        'kratos_courier_smtp_from_name': 'kratos_courier_smtp_from_name',  # noqa: E501
        'kratos_courier_smtp_headers': 'kratos_courier_smtp_headers',  # noqa: E501
        'kratos_courier_templates_recovery_invalid_email_body_html': 'kratos_courier_templates_recovery_invalid_email_body_html',  # noqa: E501
        'kratos_courier_templates_recovery_invalid_email_body_plaintext': 'kratos_courier_templates_recovery_invalid_email_body_plaintext',  # noqa: E501
        'kratos_courier_templates_recovery_invalid_email_subject': 'kratos_courier_templates_recovery_invalid_email_subject',  # noqa: E501
        'kratos_courier_templates_recovery_valid_email_body_html': 'kratos_courier_templates_recovery_valid_email_body_html',  # noqa: E501
        'kratos_courier_templates_recovery_valid_email_body_plaintext': 'kratos_courier_templates_recovery_valid_email_body_plaintext',  # noqa: E501
        'kratos_courier_templates_recovery_valid_email_subject': 'kratos_courier_templates_recovery_valid_email_subject',  # noqa: E501
        'kratos_courier_templates_verification_invalid_email_body_html': 'kratos_courier_templates_verification_invalid_email_body_html',  # noqa: E501
        'kratos_courier_templates_verification_invalid_email_body_plaintext': 'kratos_courier_templates_verification_invalid_email_body_plaintext',  # noqa: E501
        'kratos_courier_templates_verification_invalid_email_subject': 'kratos_courier_templates_verification_invalid_email_subject',  # noqa: E501
        'kratos_courier_templates_verification_valid_email_body_html': 'kratos_courier_templates_verification_valid_email_body_html',  # noqa: E501
        'kratos_courier_templates_verification_valid_email_body_plaintext': 'kratos_courier_templates_verification_valid_email_body_plaintext',  # noqa: E501
        'kratos_courier_templates_verification_valid_email_subject': 'kratos_courier_templates_verification_valid_email_subject',  # noqa: E501
        'kratos_identity_schemas': 'kratos_identity_schemas',  # noqa: E501
        'kratos_secrets_cipher': 'kratos_secrets_cipher',  # noqa: E501
        'kratos_secrets_cookie': 'kratos_secrets_cookie',  # noqa: E501
        'kratos_secrets_default': 'kratos_secrets_default',  # noqa: E501
        'kratos_selfservice_allowed_return_urls': 'kratos_selfservice_allowed_return_urls',  # noqa: E501
        'kratos_selfservice_default_browser_return_url': 'kratos_selfservice_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_error_ui_url': 'kratos_selfservice_flows_error_ui_url',  # noqa: E501
        'kratos_selfservice_flows_hooks': 'kratos_selfservice_flows_hooks',  # noqa: E501
        'kratos_selfservice_flows_login_after_default_browser_return_url': 'kratos_selfservice_flows_login_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_login_after_oidc_default_browser_return_url': 'kratos_selfservice_flows_login_after_oidc_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_login_after_password_default_browser_return_url': 'kratos_selfservice_flows_login_after_password_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_login_after_webauthn_default_browser_return_url': 'kratos_selfservice_flows_login_after_webauthn_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_login_lifespan': 'kratos_selfservice_flows_login_lifespan',  # noqa: E501
        'kratos_selfservice_flows_login_ui_url': 'kratos_selfservice_flows_login_ui_url',  # noqa: E501
        'kratos_selfservice_flows_logout_after_default_browser_return_url': 'kratos_selfservice_flows_logout_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_recovery_after_default_browser_return_url': 'kratos_selfservice_flows_recovery_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_recovery_enabled': 'kratos_selfservice_flows_recovery_enabled',  # noqa: E501
        'kratos_selfservice_flows_recovery_lifespan': 'kratos_selfservice_flows_recovery_lifespan',  # noqa: E501
        'kratos_selfservice_flows_recovery_ui_url': 'kratos_selfservice_flows_recovery_ui_url',  # noqa: E501
        'kratos_selfservice_flows_registration_after_default_browser_return_url': 'kratos_selfservice_flows_registration_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_registration_after_oidc_default_browser_return_url': 'kratos_selfservice_flows_registration_after_oidc_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_registration_after_password_default_browser_return_url': 'kratos_selfservice_flows_registration_after_password_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url': 'kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_registration_enabled': 'kratos_selfservice_flows_registration_enabled',  # noqa: E501
        'kratos_selfservice_flows_registration_lifespan': 'kratos_selfservice_flows_registration_lifespan',  # noqa: E501
        'kratos_selfservice_flows_registration_ui_url': 'kratos_selfservice_flows_registration_ui_url',  # noqa: E501
        'kratos_selfservice_flows_settings_after_default_browser_return_url': 'kratos_selfservice_flows_settings_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_settings_after_password_default_browser_return_url': 'kratos_selfservice_flows_settings_after_password_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_settings_after_profile_default_browser_return_url': 'kratos_selfservice_flows_settings_after_profile_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_settings_lifespan': 'kratos_selfservice_flows_settings_lifespan',  # noqa: E501
        'kratos_selfservice_flows_settings_privileged_session_max_age': 'kratos_selfservice_flows_settings_privileged_session_max_age',  # noqa: E501
        'kratos_selfservice_flows_settings_required_aal': 'kratos_selfservice_flows_settings_required_aal',  # noqa: E501
        'kratos_selfservice_flows_settings_ui_url': 'kratos_selfservice_flows_settings_ui_url',  # noqa: E501
        'kratos_selfservice_flows_verification_after_default_browser_return_url': 'kratos_selfservice_flows_verification_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_verification_enabled': 'kratos_selfservice_flows_verification_enabled',  # noqa: E501
        'kratos_selfservice_flows_verification_lifespan': 'kratos_selfservice_flows_verification_lifespan',  # noqa: E501
        'kratos_selfservice_flows_verification_ui_url': 'kratos_selfservice_flows_verification_ui_url',  # noqa: E501
        'kratos_selfservice_methods_link_config_base_url': 'kratos_selfservice_methods_link_config_base_url',  # noqa: E501
        'kratos_selfservice_methods_link_config_lifespan': 'kratos_selfservice_methods_link_config_lifespan',  # noqa: E501
        'kratos_selfservice_methods_link_enabled': 'kratos_selfservice_methods_link_enabled',  # noqa: E501
        'kratos_selfservice_methods_lookup_secret_enabled': 'kratos_selfservice_methods_lookup_secret_enabled',  # noqa: E501
        'kratos_selfservice_methods_oidc_config_base_redirect_uri': 'kratos_selfservice_methods_oidc_config_base_redirect_uri',  # noqa: E501
        'kratos_selfservice_methods_oidc_config_providers': 'kratos_selfservice_methods_oidc_config_providers',  # noqa: E501
        'kratos_selfservice_methods_oidc_enabled': 'kratos_selfservice_methods_oidc_enabled',  # noqa: E501
        'kratos_selfservice_methods_password_config_haveibeenpwned_enabled': 'kratos_selfservice_methods_password_config_haveibeenpwned_enabled',  # noqa: E501
        'kratos_selfservice_methods_password_config_identifier_similarity_check_enabled': 'kratos_selfservice_methods_password_config_identifier_similarity_check_enabled',  # noqa: E501
        'kratos_selfservice_methods_password_config_ignore_network_errors': 'kratos_selfservice_methods_password_config_ignore_network_errors',  # noqa: E501
        'kratos_selfservice_methods_password_config_max_breaches': 'kratos_selfservice_methods_password_config_max_breaches',  # noqa: E501
        'kratos_selfservice_methods_password_config_min_password_length': 'kratos_selfservice_methods_password_config_min_password_length',  # noqa: E501
        'kratos_selfservice_methods_password_enabled': 'kratos_selfservice_methods_password_enabled',  # noqa: E501
        'kratos_selfservice_methods_profile_enabled': 'kratos_selfservice_methods_profile_enabled',  # noqa: E501
        'kratos_selfservice_methods_totp_config_issuer': 'kratos_selfservice_methods_totp_config_issuer',  # noqa: E501
        'kratos_selfservice_methods_totp_enabled': 'kratos_selfservice_methods_totp_enabled',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_passwordless': 'kratos_selfservice_methods_webauthn_config_passwordless',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_rp_display_name': 'kratos_selfservice_methods_webauthn_config_rp_display_name',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_rp_icon': 'kratos_selfservice_methods_webauthn_config_rp_icon',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_rp_id': 'kratos_selfservice_methods_webauthn_config_rp_id',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_rp_origin': 'kratos_selfservice_methods_webauthn_config_rp_origin',  # noqa: E501
        'kratos_selfservice_methods_webauthn_enabled': 'kratos_selfservice_methods_webauthn_enabled',  # noqa: E501
        'kratos_session_cookie_persistent': 'kratos_session_cookie_persistent',  # noqa: E501
        'kratos_session_cookie_same_site': 'kratos_session_cookie_same_site',  # noqa: E501
        'kratos_session_lifespan': 'kratos_session_lifespan',  # noqa: E501
        'kratos_session_whoami_required_aal': 'kratos_session_whoami_required_aal',  # noqa: E501
        'project_id': 'project_id',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
    }

    read_only_vars = {
        'created_at',  # noqa: E501
        'updated_at',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, name, *args, **kwargs):  # noqa: E501
        """NormalizedProjectRevision - a model defined in OpenAPI

        Args:
            name (str): The project's name.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            created_at (datetime): The Project's Revision Creation Date. [optional]  # noqa: E501
            id (str): [optional]  # noqa: E501
            kratos_cookies_same_site (str): Configures the Ory Kratos Cookie SameSite Attribute  This governs the \"cookies.same_site\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_connection_uri (str): Configures the Ory Kratos SMTP Connection URI  This governs the \"courier.smtp.connection_uri\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_from_address (str): Configures the Ory Kratos SMTP From Address  This governs the \"courier.smtp.from_address\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_from_name (str): Configures the Ory Kratos SMTP From Name  This governs the \"courier.smtp.from_name\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_headers ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): NullJSONRawMessage represents a json.RawMessage that works well with JSON, SQL, and Swagger and is NULLable-. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_body_html (str): Configures the Ory Kratos Invalid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_body_plaintext (str): Configures the Ory Kratos Invalid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_subject (str): Configures the Ory Kratos Invalid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_body_html (str): Configures the Ory Kratos Valid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_body_plaintext (str): Configures the Ory Kratos Valid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_subject (str): Configures the Ory Kratos Valid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.valid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_body_html (str): Configures the Ory Kratos Invalid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_body_plaintext (str): Configures the Ory Kratos Invalid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_subject (str): Configures the Ory Kratos Invalid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.invalid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_body_html (str): Configures the Ory Kratos Valid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.valid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_body_plaintext (str): Configures the Ory Kratos Valid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_subject (str): Configures the Ory Kratos Valid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.valid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_identity_schemas (ProjectRevisionIdentitySchemas): [optional]  # noqa: E501
            kratos_secrets_cipher (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_secrets_cookie (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_secrets_default (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_selfservice_allowed_return_urls (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_selfservice_default_browser_return_url (str): Configures the Ory Kratos Default Return URL  This governs the \"selfservice.allowed_return_urls\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_error_ui_url (str): Configures the Ory Kratos Error UI URL  This governs the \"selfservice.flows.error.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_hooks (ProjectRevisionHooks): [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_default_browser_return_url (str): Configures the Ory Kratos Login Default Return URL  This governs the \"selfservice.flows.login.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_oidc_default_browser_return_url (str): Configures the Ory Kratos Login After OIDC Default Return URL  This governs the \"selfservice.flows.login.after.oidc.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_password_default_browser_return_url (str): Configures the Ory Kratos Login After Password Default Return URL  This governs the \"selfservice.flows.login.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_webauthn_default_browser_return_url (str): Configures the Ory Kratos Login After WebAuthn Default Return URL  This governs the \"selfservice.flows.login.after.webauthn.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_lifespan (str): Configures the Ory Kratos Login Lifespan  This governs the \"selfservice.flows.login.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_ui_url (str): Configures the Ory Kratos Login UI URL  This governs the \"selfservice.flows.login.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_logout_after_default_browser_return_url (str): Configures the Ory Kratos Logout Default Return URL  This governs the \"selfservice.flows.logout.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_after_default_browser_return_url (str): Configures the Ory Kratos Recovery Default Return URL  This governs the \"selfservice.flows.recovery.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_enabled (bool): Configures the Ory Kratos Recovery Enabled Setting  This governs the \"selfservice.flows.recovery.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_lifespan (str): Configures the Ory Kratos Recovery Lifespan  This governs the \"selfservice.flows.recovery.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_ui_url (str): Configures the Ory Kratos Recovery UI URL  This governs the \"selfservice.flows.recovery.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_default_browser_return_url (str): Configures the Ory Kratos Registration Default Return URL  This governs the \"selfservice.flows.registration.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_oidc_default_browser_return_url (str): Configures the Ory Kratos Registration After OIDC Default Return URL  This governs the \"selfservice.flows.registration.after.oidc.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_password_default_browser_return_url (str): Configures the Ory Kratos Registration After Password Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url (str): Configures the Ory Kratos Registration After Password Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_flows_registration_lifespan (str): Configures the Ory Kratos Registration Lifespan  This governs the \"selfservice.flows.registration.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_ui_url (str): Configures the Ory Kratos Registration UI URL  This governs the \"selfservice.flows.registration.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL  This governs the \"selfservice.flows.settings.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_password_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL After Updating Passwords  This governs the \"selfservice.flows.settings.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_profile_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL After Updating Profiles  This governs the \"selfservice.flows.settings.after.profile.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_lifespan (str): Configures the Ory Kratos Settings Lifespan  This governs the \"selfservice.flows.settings.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_privileged_session_max_age (str): Configures the Ory Kratos Settings Privileged Session Max Age  This governs the \"selfservice.flows.settings.privileged_session_max_age\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_required_aal (str): Configures the Ory Kratos Settings Required AAL  This governs the \"selfservice.flows.settings.required_aal\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_ui_url (str): Configures the Ory Kratos Settings UI URL  This governs the \"selfservice.flows.settings.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_after_default_browser_return_url (str): Configures the Ory Kratos Verification Default Return URL  This governs the \"selfservice.flows.verification.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_enabled (bool): Configures the Ory Kratos Verification Enabled Setting  This governs the \"selfservice.flows.verification.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_lifespan (str): Configures the Ory Kratos Verification Lifespan  This governs the \"selfservice.flows.verification.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_ui_url (str): Configures the Ory Kratos Verification UI URL  This governs the \"selfservice.flows.verification.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_config_base_url (str): Configures the Base URL which Recovery, Verification, and Login Links Point to  It is recommended to leave this value empty. It will be appropriately configured to the best matching domain (e.g. when using custom domains) automatically.  This governs the \"selfservice.methods.link.config.base_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_config_lifespan (str): Configures whether Ory Kratos Link Method is enabled  This governs the \"selfservice.methods.link.config.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_lookup_secret_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_config_base_redirect_uri (str): Configures the Ory Kratos Third Party / OpenID Connect base redirect URI  This governs the \"selfservice.methods.oidc.config.base_redirect_uri\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_config_providers (ProjectRevisionThirdPartyLoginProviders): [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_enabled (bool): Configures whether Ory Kratos Third Party / OpenID Connect Login is enabled  This governs the \"selfservice.methods.oidc.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_haveibeenpwned_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_identifier_similarity_check_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_ignore_network_errors (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_max_breaches (int): Configures Ory Kratos Password Max Breaches Detection  This governs the \"selfservice.methods.password.config.max_breaches\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_min_password_length (int): Configures the minimum length of passwords.  This governs the \"selfservice.methods.password.config.min_password_length\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_profile_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_totp_config_issuer (str): Configures Ory Kratos TOTP Issuer  This governs the \"selfservice.methods.totp.config.issuer\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_totp_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_passwordless (bool): Configures whether Ory Kratos Webauthn is used for passwordless flows  This governs the \"selfservice.methods.webauthn.config.passwordless\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_display_name (str): Configures the Ory Kratos Webauthn RP Display Name  This governs the \"selfservice.methods.webauthn.config.rp.display_name\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_icon (str): Configures the Ory Kratos Webauthn RP Icon  This governs the \"selfservice.methods.webauthn.config.rp.icon\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_id (str): Configures the Ory Kratos Webauthn RP ID  This governs the \"selfservice.methods.webauthn.config.rp.id\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_origin (str): Configures the Ory Kratos Webauthn RP Origin  This governs the \"selfservice.methods.webauthn.config.rp.origin\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_session_cookie_persistent (bool, none_type): [optional]  # noqa: E501
            kratos_session_cookie_same_site (str): Configures the Ory Kratos Session Cookie SameSite Attribute  This governs the \"session.cookie.same_site\" setting.. [optional]  # noqa: E501
            kratos_session_lifespan (str): Configures the Ory Kratos Session Lifespan  This governs the \"session.lifespan\" setting.. [optional]  # noqa: E501
            kratos_session_whoami_required_aal (str): Configures the Ory Kratos Session Whoami AAL requirement  This governs the \"session.whoami.required_aal\" setting.. [optional]  # noqa: E501
            project_id (str): [optional]  # noqa: E501
            updated_at (datetime): Last Time Project's Revision was Updated. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, name, *args, **kwargs):  # noqa: E501
        """NormalizedProjectRevision - a model defined in OpenAPI

        Args:
            name (str): The project's name.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            created_at (datetime): The Project's Revision Creation Date. [optional]  # noqa: E501
            id (str): [optional]  # noqa: E501
            kratos_cookies_same_site (str): Configures the Ory Kratos Cookie SameSite Attribute  This governs the \"cookies.same_site\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_connection_uri (str): Configures the Ory Kratos SMTP Connection URI  This governs the \"courier.smtp.connection_uri\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_from_address (str): Configures the Ory Kratos SMTP From Address  This governs the \"courier.smtp.from_address\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_from_name (str): Configures the Ory Kratos SMTP From Name  This governs the \"courier.smtp.from_name\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_headers ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): NullJSONRawMessage represents a json.RawMessage that works well with JSON, SQL, and Swagger and is NULLable-. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_body_html (str): Configures the Ory Kratos Invalid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_body_plaintext (str): Configures the Ory Kratos Invalid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_subject (str): Configures the Ory Kratos Invalid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_body_html (str): Configures the Ory Kratos Valid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_body_plaintext (str): Configures the Ory Kratos Valid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_subject (str): Configures the Ory Kratos Valid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.valid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_body_html (str): Configures the Ory Kratos Invalid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_body_plaintext (str): Configures the Ory Kratos Invalid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_subject (str): Configures the Ory Kratos Invalid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.invalid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_body_html (str): Configures the Ory Kratos Valid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.valid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_body_plaintext (str): Configures the Ory Kratos Valid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_subject (str): Configures the Ory Kratos Valid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.valid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_identity_schemas (ProjectRevisionIdentitySchemas): [optional]  # noqa: E501
            kratos_secrets_cipher (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_secrets_cookie (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_secrets_default (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_selfservice_allowed_return_urls (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_selfservice_default_browser_return_url (str): Configures the Ory Kratos Default Return URL  This governs the \"selfservice.allowed_return_urls\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_error_ui_url (str): Configures the Ory Kratos Error UI URL  This governs the \"selfservice.flows.error.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_hooks (ProjectRevisionHooks): [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_default_browser_return_url (str): Configures the Ory Kratos Login Default Return URL  This governs the \"selfservice.flows.login.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_oidc_default_browser_return_url (str): Configures the Ory Kratos Login After OIDC Default Return URL  This governs the \"selfservice.flows.login.after.oidc.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_password_default_browser_return_url (str): Configures the Ory Kratos Login After Password Default Return URL  This governs the \"selfservice.flows.login.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_webauthn_default_browser_return_url (str): Configures the Ory Kratos Login After WebAuthn Default Return URL  This governs the \"selfservice.flows.login.after.webauthn.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_lifespan (str): Configures the Ory Kratos Login Lifespan  This governs the \"selfservice.flows.login.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_ui_url (str): Configures the Ory Kratos Login UI URL  This governs the \"selfservice.flows.login.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_logout_after_default_browser_return_url (str): Configures the Ory Kratos Logout Default Return URL  This governs the \"selfservice.flows.logout.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_after_default_browser_return_url (str): Configures the Ory Kratos Recovery Default Return URL  This governs the \"selfservice.flows.recovery.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_enabled (bool): Configures the Ory Kratos Recovery Enabled Setting  This governs the \"selfservice.flows.recovery.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_lifespan (str): Configures the Ory Kratos Recovery Lifespan  This governs the \"selfservice.flows.recovery.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_ui_url (str): Configures the Ory Kratos Recovery UI URL  This governs the \"selfservice.flows.recovery.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_default_browser_return_url (str): Configures the Ory Kratos Registration Default Return URL  This governs the \"selfservice.flows.registration.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_oidc_default_browser_return_url (str): Configures the Ory Kratos Registration After OIDC Default Return URL  This governs the \"selfservice.flows.registration.after.oidc.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_password_default_browser_return_url (str): Configures the Ory Kratos Registration After Password Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url (str): Configures the Ory Kratos Registration After Password Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_flows_registration_lifespan (str): Configures the Ory Kratos Registration Lifespan  This governs the \"selfservice.flows.registration.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_ui_url (str): Configures the Ory Kratos Registration UI URL  This governs the \"selfservice.flows.registration.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL  This governs the \"selfservice.flows.settings.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_password_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL After Updating Passwords  This governs the \"selfservice.flows.settings.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_profile_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL After Updating Profiles  This governs the \"selfservice.flows.settings.after.profile.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_lifespan (str): Configures the Ory Kratos Settings Lifespan  This governs the \"selfservice.flows.settings.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_privileged_session_max_age (str): Configures the Ory Kratos Settings Privileged Session Max Age  This governs the \"selfservice.flows.settings.privileged_session_max_age\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_required_aal (str): Configures the Ory Kratos Settings Required AAL  This governs the \"selfservice.flows.settings.required_aal\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_ui_url (str): Configures the Ory Kratos Settings UI URL  This governs the \"selfservice.flows.settings.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_after_default_browser_return_url (str): Configures the Ory Kratos Verification Default Return URL  This governs the \"selfservice.flows.verification.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_enabled (bool): Configures the Ory Kratos Verification Enabled Setting  This governs the \"selfservice.flows.verification.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_lifespan (str): Configures the Ory Kratos Verification Lifespan  This governs the \"selfservice.flows.verification.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_ui_url (str): Configures the Ory Kratos Verification UI URL  This governs the \"selfservice.flows.verification.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_config_base_url (str): Configures the Base URL which Recovery, Verification, and Login Links Point to  It is recommended to leave this value empty. It will be appropriately configured to the best matching domain (e.g. when using custom domains) automatically.  This governs the \"selfservice.methods.link.config.base_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_config_lifespan (str): Configures whether Ory Kratos Link Method is enabled  This governs the \"selfservice.methods.link.config.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_lookup_secret_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_config_base_redirect_uri (str): Configures the Ory Kratos Third Party / OpenID Connect base redirect URI  This governs the \"selfservice.methods.oidc.config.base_redirect_uri\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_config_providers (ProjectRevisionThirdPartyLoginProviders): [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_enabled (bool): Configures whether Ory Kratos Third Party / OpenID Connect Login is enabled  This governs the \"selfservice.methods.oidc.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_haveibeenpwned_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_identifier_similarity_check_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_ignore_network_errors (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_max_breaches (int): Configures Ory Kratos Password Max Breaches Detection  This governs the \"selfservice.methods.password.config.max_breaches\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_min_password_length (int): Configures the minimum length of passwords.  This governs the \"selfservice.methods.password.config.min_password_length\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_profile_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_totp_config_issuer (str): Configures Ory Kratos TOTP Issuer  This governs the \"selfservice.methods.totp.config.issuer\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_totp_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_passwordless (bool): Configures whether Ory Kratos Webauthn is used for passwordless flows  This governs the \"selfservice.methods.webauthn.config.passwordless\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_display_name (str): Configures the Ory Kratos Webauthn RP Display Name  This governs the \"selfservice.methods.webauthn.config.rp.display_name\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_icon (str): Configures the Ory Kratos Webauthn RP Icon  This governs the \"selfservice.methods.webauthn.config.rp.icon\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_id (str): Configures the Ory Kratos Webauthn RP ID  This governs the \"selfservice.methods.webauthn.config.rp.id\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_origin (str): Configures the Ory Kratos Webauthn RP Origin  This governs the \"selfservice.methods.webauthn.config.rp.origin\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_enabled (bool, none_type): [optional]  # noqa: E501
            kratos_session_cookie_persistent (bool, none_type): [optional]  # noqa: E501
            kratos_session_cookie_same_site (str): Configures the Ory Kratos Session Cookie SameSite Attribute  This governs the \"session.cookie.same_site\" setting.. [optional]  # noqa: E501
            kratos_session_lifespan (str): Configures the Ory Kratos Session Lifespan  This governs the \"session.lifespan\" setting.. [optional]  # noqa: E501
            kratos_session_whoami_required_aal (str): Configures the Ory Kratos Session Whoami AAL requirement  This governs the \"session.whoami.required_aal\" setting.. [optional]  # noqa: E501
            project_id (str): [optional]  # noqa: E501
            updated_at (datetime): Last Time Project's Revision was Updated. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
