/**
 * @stability stable
 */
export interface CFunctionProps {
    /**
     * Symbols to capture.
     *
     * @stability stable
     */
    readonly capture?: {
        [name: string]: any;
    };
    /**
     * Javascript code to execute.
     *
     * @default "true;"
     * @stability stable
     */
    readonly code?: string;
}
/**
 * @stability stable
 */
export interface ExecOptions {
    /**
     * Environment variables to bind to the child process.
     *
     * You can use `cfunction.env` to bind the original symbols.
     *
     * @default {}
     * @stability stable
     */
    readonly env?: {
        [name: string]: string;
    };
}
/**
 * @stability stable
 */
export declare class CFunction {
    /**
     * @stability stable
     */
    static exec(file: string, options?: ExecOptions): any;
    /**
     * The location of the function bundle (.js file).
     *
     * @stability stable
     */
    readonly outfile: string;
    /**
     * Environment variables that are expected to be available when the function is executed.
     *
     * @stability stable
     */
    readonly env: {
        [name: string]: string;
    };
    private readonly workdir;
    /**
     * @stability stable
     */
    constructor(props: CFunctionProps);
    /**
     * @stability stable
     */
    toJson(): any;
    private captureSymbols;
    private captureValue;
    private capturePrimitive;
    private captureObject;
    private captureArray;
}
