#
# Collective Knowledge (CK wrapper for CLBlast to enable collaborative optimization)
#
# See CK LICENSE.txt for licensing details
# See CK COPYRIGHT.txt for copyright details
#
# Developer: Grigori Fursin, Grigori.Fursin@cTuning.org, http://fursin.net
#

cfg={}  # Will be updated by CK (meta description of this module)
work={} # Will be updated by CK (temporal data)
ck=None # Will be updated by CK (initialized CK kernel) 

# Local settings

##############################################################################
# Initialize module

def init(i):
    """

    Input:  {}

    Output: {
              return       - return code =  0, if successful
                                         >  0, if error
              (error)      - error text if return > 0
            }

    """
    return {'return':0}

##############################################################################
# autotune CLBlast via CK

def autotune(i):
    """
    Input:  {
            }

    Output: {
              return       - return code =  0, if successful
                                         >  0, if error
              (error)      - error text if return > 0
            }

    """

    i['action']='crowdsource'
    i['module_uoa']=cfg['module_deps']['experiment.tune.opencl.clblast']
    i['local_autotuning']='yes'

    return ck.access(i)

##############################################################################
# crowdtune CLBlast via CK

def crowdtune(i):
    """
    Input:  {
            }

    Output: {
              return       - return code =  0, if successful
                                         >  0, if error
              (error)      - error text if return > 0
            }

    """

    i['action']='crowdsource'
    i['module_uoa']=cfg['module_deps']['experiment.tune.opencl.clblast']

    return ck.access(i)
