# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['deew']

package_data = \
{'': ['*']}

install_requires = \
['Unidecode>=1.3.4,<2.0.0',
 'packaging>=21.3,<22.0',
 'platformdirs>=2.5.2,<3.0.0',
 'requests>=2.28.1,<3.0.0',
 'rich>=12.5.1,<13.0.0',
 'toml>=0.10.2,<0.11.0',
 'xmltodict>=0.13.0,<0.14.0']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>=4.12.0,<5.0.0']}

entry_points = \
{'console_scripts': ['deew = deew.__main__:main']}

setup_kwargs = {
    'name': 'deew',
    'version': '2.8.3',
    'description': 'Dolby Encoding Engine Wrapper',
    'long_description': '[![builds](https://img.shields.io/github/workflow/status/pcroland/deew/Build%20and%20publish?logo=github&style=flat-square)](https://github.com/pcroland/deew/actions/workflows/build.yaml)\n[![github_release](https://img.shields.io/github/v/release/pcroland/deew?logo=github&color=70920c&style=flat-square)](https://github.com/pcroland/deew/releases)\n[![pypi_release](https://img.shields.io/pypi/v/deew?label=PyPI&logo=pypi&logoColor=ffffff&color=70920c&style=flat-square)](https://pypi.org/project/deew)\n[![pypi_downloads](https://img.shields.io/pypi/dm/deew?color=70920c&logo=pypi&logoColor=white&style=flat-square)](https://pypi.org/project/deew)\n[![license](https://img.shields.io/github/license/pcroland/deew?color=blueviolet&style=flat-square)](https://github.com/pcroland/deew/blob/master/LICENSE)\n\\\n[![telegram](https://img.shields.io/endpoint?color=1d93d2&style=flat-square&url=https://cadoth.net/tgmembercount%3Fchat_id=deew_support%26name=Discussion%2520and%2520Support)](https://t.me/deew_support)\n[![commits](https://img.shields.io/github/last-commit/pcroland/deew?color=355ab8&logo=github&style=flat-square)](https://github.com/pcroland/deew/commits/main)\n[![issues](https://img.shields.io/github/issues/pcroland/deew?color=355ab8&logo=github&style=flat-square)](https://github.com/pcroland/deew/issues)\n\\\n[![name](https://img.shields.io/badge/platform-win%20%7C%20linux%20%7C%20osx-eeeeee?style=flat-square)](https://github.com/pcroland/deew)\n[![name](https://img.shields.io/pypi/pyversions/deew?logo=Python&logoColor=eeeeee&color=eeeeee&style=flat-square)](https://github.com/pcroland/deew)\n[![name](https://img.shields.io/badge/DEE-5.1.0--5.2.1-green?logoColor=white&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAMCAYAAABr5z2BAAAA9ElEQVQokZXSzypFURQG8N89LsnEv1KGBp5CKU9wBygPIJ5AeYM7MjLAzMBAmRuYyszU3AOgG6GQpZ19OM69Tny1Wu39rVXfWt9qRcQaljCOUbygh3c/MYQJDOMZ9zhvYwEb+hG1n9aAmlaBkfzYwQo2cZUbqnGJdSxjP/eMiYi9+MRiRKjEWXzjpMZ1MnNUVORM1+R1ck6jrNa4qZJrD5irRFrUHW4aahRNJN7w2lTQpCBhBpN/VfBU4w5yTr53a1war0/BPK7zQW1lS0tsYxa7eMDcFxMRhxW7/ovjpOAUj9madMppabe/nHKyOvWkcXu4+AAd1Ju1TsOvFgAAAABJRU5ErkJggg==&color=eeeeee&style=flat-square)](https://customer.dolby.com/content-creation-and-delivery/dolby-encoding-engine-with-ac-4)\n<hr>\n<p align="center"><img width="192" src="https://raw.githubusercontent.com/pcroland/deew/main/logo/logo.svg"><br>Dolby Encoding Engine Wrapper</p>\n\n\n<p align="center"><a href="https://github.com/pcroland/deew/blob/main/README.md">English readme</a>\n • <a href="https://github.com/pcroland/deew/blob/main/README.hu.md">Magyar leírás</a></p>\n\n## DDP encoding has never been so easy!\n\n![img](https://telegra.ph/file/efd2a1d3519bdf87fca03.gif)\n<!---https://i.kek.sh/Mk3qQ0QGWUj.gif--->\n\n# Description\n- handles Dolby\'s XML input fuckery in the background, giving you a proper CLI interface\n- converts inputs to rf64 which DEE can use\n  - bit depth, number of channels and other infos are parsed from the source\n- an XML file will be generated for each input based on the settings\n- the script utilizes thread pooling for batch encoding (see config)\n- supports WSL path conversion for the Win version of DEE (see config)\n- in case of an invalid bitrate it will pick the closest allowed one\n- automatic sample rate conversion using ffmpeg\'s soxr resampler in case of an unsupported sample rate\n  - for dd/ddp unsupported rates will be converted to 48000\n  - for thd unsupported rates will be converted to 48000 if source sample rate is lower than 72000, otherwise will be converted to 96000\n- automatic channel swapping for 7.1 sources (DEE swaps Ls Rs with Lrs Rrs for some reason)\n- automatic dialnorm setting\n- automatically compensates for DEE\'s 256 sample delay (DD and DDP encoding)\n- checks if intermediate file is already created so you can encode different formats/bitrates using a single intermediate file, for example:\\\n  `deew -f dd -b 448 -i input -k`\\\n  `deew -f dd -b 640 -i input -k`\\\n  `deew -f ddp -i input`\n- works even with video inputs (first audio will be selected)\n- fancy terminal output using rich\n- versatile delay option that supports ms, s and also frame@fps formats\n- parsing delay from filenames\n\n# Requirements\n- Python *(you don\'t need it if you use a standalone build of deew)*\n- ffmpeg\n- ffprobe\n- Dolby Encoding Engine\n\n# Dolby Encoding Engine installation\n- install [DEE](https://customer.dolby.com/content-creation-and-delivery/dolby-encoding-engine-with-ac-4) (if you use macOS, install [DME](https://customer.dolby.com/content-creation-and-delivery/dolby-media-encoder-with-ac-4))\n  - for TrueHD encoding support you need the Windows version\n  - if you use WSL1 use the Windows version for better performance\n  - if you use the Windows version of DEE under Linux (and not from WSL) / macOS install `wine-binfmt`\n- place your `license.lic` file next to the DEE binary (`dee.exe` under Windows, `dee` under Linux/macOS)\n\n# deew installation\n### with standalone build (Windows/Linux):\n- grab the latest build from: [https://github.com/pcroland/deew/releases](https://github.com/pcroland/deew/releases)\n- run with: `deew`\\\n*(run the binary from terminal, doubleclicking it won\'t work)*\n- on the first run it will create a config file, choose where you want to keep it\n- updating: grab the latest build from: [https://github.com/pcroland/deew/releases](https://github.com/pcroland/deew/releases)\n\n### with Python environment (Windows/Linux/macOS):\n- install Python and pip if you don\'t have it already\n- run: `pip install deew`\n- run with: `deew`\n- on the first run it will create a config file\n- updating: `pip install deew --upgrade`\n\n# Setup system PATH variable\nIf you don\'t want to use full paths for the binaries in your config or when you use them from CLI, I suggest to setup system PATH variables\n### Windows:\n- open `cmd.exe` as administrator\n- run a `setx /m PATH "%PATH%;[location]"` command for each path that contains binaries\\\n  *(replace `[location]` with the path)*\n- for example:\n```bat\nsetx /m PATH "%PATH%;C:\\bin\\dee"\nsetx /m PATH "%PATH%;C:\\bin\\ffmpeg"\n```\n### Linux/macOS:\n- add a `PATH="[location]:$PATH"` line in your `~/.bashrc` or `~/.zshrc` file for each path that contains a binary\\\n  *(replace `[location]` with the path)*\n- for example:\n```sh\nPATH="/usr/local/bin/dee:$PATH"\nPATH="/usr/local/bin/ffmpeg:$PATH"\n```\n\n# Usage\n```\n❯ deew -h\ndeew 2.8.3\n\nUSAGE: deew [-h] [-v] [-i [INPUT ...]] [-o OUTPUT] [-f FORMAT] [-b BITRATE]\n            [-dm DOWNMIX] [-d DELAY] [-drc DRC] [-dn DIALNORM] [-in INSTANCES]\n            [-k] [-mo] [-fs] [-fb] [-lb] [-la] [-np] [-pl] [-cl] [-c] [-gc]\n\nFLAGS:\n  -h, --help                    show this help message.\n  -v, --version                 show version.\n  -i, --input [INPUT ...]       audio file(s) or folder(s)\n  -o, --output DIRECTORY        default: current directory\n                                specifies output directory\n  -f, --format FORMAT           options: dd / ddp / thd\n                                default: ddp\n  -b, --bitrate BITRATE         options: run -lb/--list-bitrates\n                                default: run -c/--config\n  -dm, --downmix CHANNELS       options: 1 / 2 / 6\n                                specifies downmix, only works for DD/DDP\n                                DD will be automatically downmixed to 5.1 in case of a 7.1 source\n  -d, --delay DELAY             examples: -5.1ms, +1,52s, -24@pal, +10@24000/1001\n                                default: 0ms or parsed from filename\n                                specifies delay as ms, s or frame@FPS\n                                FPS can be a number, division or ntsc / pal\n                                you have to specify negative values as -d=-0ms\n  -r, --drc DRC                 options: film_light / film_standard / music_light / music_standard / speech\n                                default: music_light (this is the closest to the missing none preset)\n                                specifies drc profile\n  -dn, --dialnorm DIALNORM      options: between -31 and 0 (in case of 0 DEE\'s measurement will be used)\n                                default: 0\n                                applied dialnorm value between\n  -in, --instances INSTANCES    examples: 1, 4, 50%\n                                default: 50%\n                                specifies how many encodes can run at the same time\n                                50% means 4 on a cpu with 8 threads\n                                one DEE can use 2 threads so 50% can utilize all threads\n                                (this option overwrites the config\'s number)\n  -k, --keeptemp                keep temp files\n  -mo, --measure-only           kills DEE when the dialnorm gets written to the progress bar\n                                this option overwrites format with ddp\n  -fs, --force-standard         force standard profile for 7.1 DDP encoding (384-1024 kbps)\n  -fb, --force-bluray           force bluray profile for 7.1 DDP encoding (768-1664 kbps)\n  -lb, --list-bitrates          list bitrates that DEE can do for DD and DDP encoding\n  -la, --long-argument          print ffmpeg and DEE arguments for each input\n  -np, --no-prompt              disables prompt\n  -pl, --print-logos            show all logo variants you can set in the config\n  -cl, --changelog              show changelog\n  -c, --config                  show config and config location(s)\n  -gc, --generate-config        generate a new config\n```\n# Examples\n`deew -i *thd`\\\nencode DDP\n\n`deew -b 768 -i *flac`\\\nencode DDP@768\n\n`deew -dm 2 -f dd -b 192 -i *.ec3`\\\nencode DD@192 with stereo downmixing\n\n`deew -f dd -b 448 -t 4 -i S01`\\\nencode DD@448 using 4 threads (input is a folder)\n\n`deew -f thd -i *w64`\\\nencode TrueHD\n\n`deew -f dd -i *dts -k`\\\n`deew -f ddp -i *dts`\\\nencode multiple formats/bitrates while creating the temp file only once\n\n# Discussion and Support\n[https://t.me/deew_support](https://t.me/deew_support)\n',
    'author': 'pcroland',
    'author_email': 'pcroland@protonmail.ch',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
