# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/06_cli.ipynb (unless otherwise specified).

__all__ = ['bump_version', 'nbdev_bump_version', 'nbdev_install_git_hooks', 'extract_tgz', 'nbdev_new']

# Cell
from .imports import *
from .export import *
from .sync import *
from .merge import *
from .export2html import *
from .clean import *
from .test import *
from fastcore.script import *
from ghapi.all import GhApi
from urllib.error import HTTPError


# Cell
def bump_version(version, part=2):
    version = version.split('.')
    version[part] = str(int(version[part]) + 1)
    for i in range(part+1, 3): version[i] = '0'
    return '.'.join(version)

# Cell
@call_parse
def nbdev_bump_version(part:Param("Part of version to bump", int)=2):
    "Increment version in `settings.py` by one"
    cfg = Config()
    print(f'Old version: {cfg.version}')
    cfg.d['version'] = bump_version(Config().version, part)
    cfg.save()
    update_version()
    print(f'New version: {cfg.version}')

# Cell
@call_parse
def nbdev_install_git_hooks():
    "Install git hooks to clean/trust notebooks automatically"
    try: path = Config().config_file.parent
    except: path = Path.cwd()
    hook_path = path/'.git'/'hooks'
    fn = hook_path/'post-merge'
    hook_path.mkdir(parents=True, exist_ok=True)
    #Trust notebooks after merge
    fn.write_text("#!/bin/bash\necho 'Trusting notebooks'\nnbdev_trust_nbs")
    os.chmod(fn, os.stat(fn).st_mode | stat.S_IEXEC)
    #Clean notebooks on commit/diff
    (path/'.gitconfig').write_text("""# Generated by nbdev_install_git_hooks
#
# If you need to disable this instrumentation do:
#   git config --local --unset include.path
#
# To restore the filter
#   git config --local include.path .gitconfig
#
# If you see notebooks not stripped, checked the filters are applied in .gitattributes
#
[filter "clean-nbs"]
        clean = nbdev_clean_nbs --read_input_stream True
        smudge = cat
        required = true
[diff "ipynb"]
        textconv = nbdev_clean_nbs --disp True --fname
""")
    cmd = "git config --local include.path ../.gitconfig"
    print(f"Executing: {cmd}")
    run(cmd)
    print("Success: hooks are installed and repo's .gitconfig is now trusted")
    try: nb_path = Config().path("nbs_path")
    except: nb_path = Path.cwd()
    (nb_path/'.gitattributes').write_text("**/*.ipynb filter=clean-nbs\n**/*.ipynb diff=ipynb\n")

# Cell
_template_git_repo = "https://github.com/fastai/nbdev_template.git"

# Cell
import tarfile

# Cell
def extract_tgz(url, dest='.'):
    with urlopen(url) as u: tarfile.open(mode='r:gz', fileobj=u).extractall(dest)

# Cell
#hide
def _get_branch(owner, repo, default='main'):
    api = GhApi(owner=owner, repo=repo, token=os.getenv('GITHUB_TOKEN'))
    try: return api.repos.get().default_branch
    except HTTPError:
        msg= [f"Could not access repo: {owner}/{repo} to find your default branch - `{default} assumed.\n",
              "Edit `settings.ini` if this is incorrect.\n"
              "In the future, you can allow nbdev to see private repos by setting the environment variable GITHUB_TOKEN as described here: https://nbdev.fast.ai/cli.html#Using-nbdev_new-with-private-repos \n",         ]
        print(''.join(msg))
        return default

# Cell
@call_parse
def nbdev_new():
    "Create a new nbdev project from the current git repo"
    url = run('git config --get remote.origin.url')
    if not url: raise Exception('This does not appear to be a cloned git directory with a remote')
    author = run('git config --get user.name').strip()
    email = run('git config --get user.email').strip()
    if not (author and email): raise Exception('User name and email not configured in git')

    # download and untar template, and optionally notebooks
    tgnm = urljson('https://api.github.com/repos/fastai/nbdev_template/releases/latest')['tag_name']
    FILES_URL = f"https://github.com/fastai/nbdev_template/archive/{tgnm}.tar.gz"
    extract_tgz(FILES_URL)
    path = Path()
    nbexists = True if first(path.glob('*.ipynb')) else False
    for o in (path/f'nbdev_template-{tgnm}').ls():
        if o.name == '00_core.ipynb':
            if not nbexists: shutil.move(str(o), './')
        elif not Path(f'./{o.name}').exists(): shutil.move(str(o), './')
    shutil.rmtree(f'nbdev_template-{tgnm}')

    # auto-config settings.ini from git
    settings_path = Path('settings.ini')
    settings = settings_path.read_text()
    owner,repo = repo_details(url)
    branch = _get_branch(owner, repo)
    settings = settings.format(lib_name=repo, user=owner, author=author, author_email=email, branch=branch)
    settings_path.write_text(settings)
    nbdev_install_git_hooks()