import re


class CommandConverter:
    def convert(self, command: dict):
        magic_command = self._detect_magic_command(command["command"])

        if magic_command:
            command_code = "# MAGIC " + command["command"].replace("\n", "\n# MAGIC ")
            command_code = command_code.replace("# MAGIC \n", "# MAGIC\n")

            return self._process_title(command_code, command)

        return self._process_title(command["command"], command)

    def _detect_magic_command(self, command_code: str):
        matches = re.match(r"^(%[a-z_]+)[\s]", command_code)

        if not matches:
            return None

        return matches.group(1)

    def _process_title(self, command_code: str, orig_command: dict):
        if not orig_command["commandTitle"]:
            return command_code

        show_command_title_string = "1" if orig_command["showCommandTitle"] is True else "0"

        return f'# DBTITLE {show_command_title_string},{orig_command["commandTitle"]}\n{command_code}'
