#!/usr/bin/env python3

from git_viewer.api_commands import Command


# Despite this being a class I do not use camel case because
# the name of the class is used as the name of the command.
class my_command(Command):

	"""
	Each time a command is executed a new instance of this command is created.

	This doc string is displayed in the help of this command.
	Lines ending with a colon after an empty line are formatted with %color.subtitle%.

	If you reference other commands you should place them in `...` so that they are
	recognized as commands and highlighting, insertion of keyboard shortcuts and
	linking to their help is possible.

	If you reference settings you should place them in %...% so that they are recognized
	as settings and they are listed in the auto generated section "mentioned settings".
	"""

	# By default the name of the class is used
	# but if the name of the command shall contain
	# characters which are not allowed in a python
	# class name you can set this attribute.
	name = "my-command"

	# Specify if and when this command is allowed to be executed
	# in a config file at startup, see the help of `config.load`.
	# If run_before_init and run_after_init are not specified
	# run_before_init is initialized to False and run_after_init to True.
	# If only one of the two is specified the other one is initialized to False.
	run_before_init = None
	run_after_init = None


	# -------  methods which you will want to override -------

	@classmethod
	def init_parser(cls, parser):
		"""
		Define the arguments which this command can take.
		see the help of argparse.ArgumentParser
		"""
		pass

	def execute(self, args):
		"""
		Do what the command is supposed to do.
		args: argparse.Namespace instance

		This class inherits from Runner defined in api_subprocess.py
		which you can use to run sub processes.

		You have access to the main application object as self.app
		but no interface has really been defined yet.
		You can take a look at the code for App in main.py
		but I cannot guarantee that nothing will ever change.
		"""
		pass


	# -------  methods which you might want to override -------

	@classmethod
	def init_help(cls, parser):
		"""
		In this method you can generate help
		which is inserted directly after the description.

		This method is called once
		when the help for this command is opened for the first time.
		"""
		super().init_help(parser)

		parser.description += "\n"
		parser.description += "\n"
		parser.description += "numbers from one to ten:\n"
		parser.description += "  " + ", ".join("%d"%i for i in range(1,11))

	@classmethod
	def init_help_lines(cls, parser):
		"""
		In this method you can add another section after the arguments sections
		in which it is possible to align broken lines.

		This method is called once
		when the help for this command is opened for the first time.

		This method modifies a list of strings (or AlignedLine instances).
		Each element in this list is placed in a separate widget.
		Whether two lines are placed in one or two widgets makes a difference if visual mode is enabled.
		"""
		super().init_help_lines(parser)
		out = cls.help_lines

		out.append("")
		out.append("another section:")
		out.append("This section is inserted after the sections")
		out.append("for positional arguments and optional arguments")
		out.append("which are auto generated by argparse.")
		out.append("")
		out.append(cls.AlignedLine("- {align_character}In this section it is possible to use the align character to specify an indentation for broken lines.".format(align_character=cls.app.align_character)))

	@classmethod
	def get_help(cls):
		"""
		This method is called every time the help for this command is opened.
		In this method you could show the current value of settings.
		It returns a list, see init_help_lines.
		Do not modify the list returned by super().get_help()!
		Make sure the things you want to change are changed on a separate list object.
		"""
		return super().get_help()
