# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client.facade import Type, ReturnMapping


class APIHostPortsResult(Type):
    _toSchema = {'servers': 'servers'}
    _toPy = {'servers': 'servers'}
    def __init__(self, servers=None, **unknown_fields):
        '''
        servers : typing.Sequence[~HostPort]
        '''
        servers_ = [HostPort.from_json(o) for o in servers or []]

        # Validate arguments against known Juju API types.
        if servers_ is not None and not isinstance(servers_, (bytes, str, list)):
            raise Exception("Expected servers_ to be a Sequence, received: {}".format(type(servers_)))

        self.servers = servers_
        self.unknown_fields = unknown_fields



class Action(Type):
    _toSchema = {'name': 'name', 'parameters': 'parameters', 'receiver': 'receiver', 'tag': 'tag'}
    _toPy = {'name': 'name', 'parameters': 'parameters', 'receiver': 'receiver', 'tag': 'tag'}
    def __init__(self, name=None, parameters=None, receiver=None, tag=None, **unknown_fields):
        '''
        name : str
        parameters : typing.Mapping[str, typing.Any]
        receiver : str
        tag : str
        '''
        name_ = name
        parameters_ = parameters
        receiver_ = receiver
        tag_ = tag

        # Validate arguments against known Juju API types.
        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if parameters_ is not None and not isinstance(parameters_, dict):
            raise Exception("Expected parameters_ to be a Mapping, received: {}".format(type(parameters_)))

        if receiver_ is not None and not isinstance(receiver_, (bytes, str)):
            raise Exception("Expected receiver_ to be a str, received: {}".format(type(receiver_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.name = name_
        self.parameters = parameters_
        self.receiver = receiver_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class ActionExecutionResult(Type):
    _toSchema = {'action_tag': 'action-tag', 'message': 'message', 'results': 'results', 'status': 'status'}
    _toPy = {'action-tag': 'action_tag', 'message': 'message', 'results': 'results', 'status': 'status'}
    def __init__(self, action_tag=None, message=None, results=None, status=None, **unknown_fields):
        '''
        action_tag : str
        message : str
        results : typing.Mapping[str, typing.Any]
        status : str
        '''
        action_tag_ = action_tag
        message_ = message
        results_ = results
        status_ = status

        # Validate arguments against known Juju API types.
        if action_tag_ is not None and not isinstance(action_tag_, (bytes, str)):
            raise Exception("Expected action_tag_ to be a str, received: {}".format(type(action_tag_)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if results_ is not None and not isinstance(results_, dict):
            raise Exception("Expected results_ to be a Mapping, received: {}".format(type(results_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.action_tag = action_tag_
        self.message = message_
        self.results = results_
        self.status = status_
        self.unknown_fields = unknown_fields



class ActionExecutionResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ActionExecutionResult]
        '''
        results_ = [ActionExecutionResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ActionMessage(Type):
    _toSchema = {'message': 'message', 'timestamp': 'timestamp'}
    _toPy = {'message': 'message', 'timestamp': 'timestamp'}
    def __init__(self, message=None, timestamp=None, **unknown_fields):
        '''
        message : str
        timestamp : str
        '''
        message_ = message
        timestamp_ = timestamp

        # Validate arguments against known Juju API types.
        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if timestamp_ is not None and not isinstance(timestamp_, (bytes, str)):
            raise Exception("Expected timestamp_ to be a str, received: {}".format(type(timestamp_)))

        self.message = message_
        self.timestamp = timestamp_
        self.unknown_fields = unknown_fields



class ActionMessageParams(Type):
    _toSchema = {'messages': 'messages'}
    _toPy = {'messages': 'messages'}
    def __init__(self, messages=None, **unknown_fields):
        '''
        messages : typing.Sequence[~EntityString]
        '''
        messages_ = [EntityString.from_json(o) for o in messages or []]

        # Validate arguments against known Juju API types.
        if messages_ is not None and not isinstance(messages_, (bytes, str, list)):
            raise Exception("Expected messages_ to be a Sequence, received: {}".format(type(messages_)))

        self.messages = messages_
        self.unknown_fields = unknown_fields



class ActionPruneArgs(Type):
    _toSchema = {'max_history_mb': 'max-history-mb', 'max_history_time': 'max-history-time'}
    _toPy = {'max-history-mb': 'max_history_mb', 'max-history-time': 'max_history_time'}
    def __init__(self, max_history_mb=None, max_history_time=None, **unknown_fields):
        '''
        max_history_mb : int
        max_history_time : int
        '''
        max_history_mb_ = max_history_mb
        max_history_time_ = max_history_time

        # Validate arguments against known Juju API types.
        if max_history_mb_ is not None and not isinstance(max_history_mb_, int):
            raise Exception("Expected max_history_mb_ to be a int, received: {}".format(type(max_history_mb_)))

        if max_history_time_ is not None and not isinstance(max_history_time_, int):
            raise Exception("Expected max_history_time_ to be a int, received: {}".format(type(max_history_time_)))

        self.max_history_mb = max_history_mb_
        self.max_history_time = max_history_time_
        self.unknown_fields = unknown_fields



class ActionResult(Type):
    _toSchema = {'action': 'action', 'completed': 'completed', 'enqueued': 'enqueued', 'error': 'error', 'log': 'log', 'message': 'message', 'output': 'output', 'started': 'started', 'status': 'status'}
    _toPy = {'action': 'action', 'completed': 'completed', 'enqueued': 'enqueued', 'error': 'error', 'log': 'log', 'message': 'message', 'output': 'output', 'started': 'started', 'status': 'status'}
    def __init__(self, action=None, completed=None, enqueued=None, error=None, log=None, message=None, output=None, started=None, status=None, **unknown_fields):
        '''
        action : Action
        completed : str
        enqueued : str
        error : Error
        log : typing.Sequence[~ActionMessage]
        message : str
        output : typing.Mapping[str, typing.Any]
        started : str
        status : str
        '''
        action_ = Action.from_json(action) if action else None
        completed_ = completed
        enqueued_ = enqueued
        error_ = Error.from_json(error) if error else None
        log_ = [ActionMessage.from_json(o) for o in log or []]
        message_ = message
        output_ = output
        started_ = started
        status_ = status

        # Validate arguments against known Juju API types.
        if action_ is not None and not isinstance(action_, (dict, Action)):
            raise Exception("Expected action_ to be a Action, received: {}".format(type(action_)))

        if completed_ is not None and not isinstance(completed_, (bytes, str)):
            raise Exception("Expected completed_ to be a str, received: {}".format(type(completed_)))

        if enqueued_ is not None and not isinstance(enqueued_, (bytes, str)):
            raise Exception("Expected enqueued_ to be a str, received: {}".format(type(enqueued_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if log_ is not None and not isinstance(log_, (bytes, str, list)):
            raise Exception("Expected log_ to be a Sequence, received: {}".format(type(log_)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if output_ is not None and not isinstance(output_, dict):
            raise Exception("Expected output_ to be a Mapping, received: {}".format(type(output_)))

        if started_ is not None and not isinstance(started_, (bytes, str)):
            raise Exception("Expected started_ to be a str, received: {}".format(type(started_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.action = action_
        self.completed = completed_
        self.enqueued = enqueued_
        self.error = error_
        self.log = log_
        self.message = message_
        self.output = output_
        self.started = started_
        self.status = status_
        self.unknown_fields = unknown_fields



class ActionResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ActionResult]
        '''
        results_ = [ActionResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ActionSpec(Type):
    _toSchema = {'description': 'description', 'params': 'params'}
    _toPy = {'description': 'description', 'params': 'params'}
    def __init__(self, description=None, params=None, **unknown_fields):
        '''
        description : str
        params : typing.Mapping[str, typing.Any]
        '''
        description_ = description
        params_ = params

        # Validate arguments against known Juju API types.
        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if params_ is not None and not isinstance(params_, dict):
            raise Exception("Expected params_ to be a Mapping, received: {}".format(type(params_)))

        self.description = description_
        self.params = params_
        self.unknown_fields = unknown_fields



class Actions(Type):
    _toSchema = {'actions': 'actions'}
    _toPy = {'actions': 'actions'}
    def __init__(self, actions=None, **unknown_fields):
        '''
        actions : typing.Sequence[~Action]
        '''
        actions_ = [Action.from_json(o) for o in actions or []]

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (bytes, str, list)):
            raise Exception("Expected actions_ to be a Sequence, received: {}".format(type(actions_)))

        self.actions = actions_
        self.unknown_fields = unknown_fields



class ActionsByName(Type):
    _toSchema = {'actions': 'actions', 'error': 'error', 'name': 'name'}
    _toPy = {'actions': 'actions', 'error': 'error', 'name': 'name'}
    def __init__(self, actions=None, error=None, name=None, **unknown_fields):
        '''
        actions : typing.Sequence[~ActionResult]
        error : Error
        name : str
        '''
        actions_ = [ActionResult.from_json(o) for o in actions or []]
        error_ = Error.from_json(error) if error else None
        name_ = name

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (bytes, str, list)):
            raise Exception("Expected actions_ to be a Sequence, received: {}".format(type(actions_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        self.actions = actions_
        self.error = error_
        self.name = name_
        self.unknown_fields = unknown_fields



class ActionsByNames(Type):
    _toSchema = {'actions': 'actions'}
    _toPy = {'actions': 'actions'}
    def __init__(self, actions=None, **unknown_fields):
        '''
        actions : typing.Sequence[~ActionsByName]
        '''
        actions_ = [ActionsByName.from_json(o) for o in actions or []]

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (bytes, str, list)):
            raise Exception("Expected actions_ to be a Sequence, received: {}".format(type(actions_)))

        self.actions = actions_
        self.unknown_fields = unknown_fields



class ActionsByReceiver(Type):
    _toSchema = {'actions': 'actions', 'error': 'error', 'receiver': 'receiver'}
    _toPy = {'actions': 'actions', 'error': 'error', 'receiver': 'receiver'}
    def __init__(self, actions=None, error=None, receiver=None, **unknown_fields):
        '''
        actions : typing.Sequence[~ActionResult]
        error : Error
        receiver : str
        '''
        actions_ = [ActionResult.from_json(o) for o in actions or []]
        error_ = Error.from_json(error) if error else None
        receiver_ = receiver

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (bytes, str, list)):
            raise Exception("Expected actions_ to be a Sequence, received: {}".format(type(actions_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if receiver_ is not None and not isinstance(receiver_, (bytes, str)):
            raise Exception("Expected receiver_ to be a str, received: {}".format(type(receiver_)))

        self.actions = actions_
        self.error = error_
        self.receiver = receiver_
        self.unknown_fields = unknown_fields



class ActionsByReceivers(Type):
    _toSchema = {'actions': 'actions'}
    _toPy = {'actions': 'actions'}
    def __init__(self, actions=None, **unknown_fields):
        '''
        actions : typing.Sequence[~ActionsByReceiver]
        '''
        actions_ = [ActionsByReceiver.from_json(o) for o in actions or []]

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (bytes, str, list)):
            raise Exception("Expected actions_ to be a Sequence, received: {}".format(type(actions_)))

        self.actions = actions_
        self.unknown_fields = unknown_fields



class AddApplicationOffer(Type):
    _toSchema = {'application_description': 'application-description', 'application_name': 'application-name', 'endpoints': 'endpoints', 'model_tag': 'model-tag', 'offer_name': 'offer-name'}
    _toPy = {'application-description': 'application_description', 'application-name': 'application_name', 'endpoints': 'endpoints', 'model-tag': 'model_tag', 'offer-name': 'offer_name'}
    def __init__(self, application_description=None, application_name=None, endpoints=None, model_tag=None, offer_name=None, **unknown_fields):
        '''
        application_description : str
        application_name : str
        endpoints : typing.Mapping[str, str]
        model_tag : str
        offer_name : str
        '''
        application_description_ = application_description
        application_name_ = application_name
        endpoints_ = endpoints
        model_tag_ = model_tag
        offer_name_ = offer_name

        # Validate arguments against known Juju API types.
        if application_description_ is not None and not isinstance(application_description_, (bytes, str)):
            raise Exception("Expected application_description_ to be a str, received: {}".format(type(application_description_)))

        if application_name_ is not None and not isinstance(application_name_, (bytes, str)):
            raise Exception("Expected application_name_ to be a str, received: {}".format(type(application_name_)))

        if endpoints_ is not None and not isinstance(endpoints_, dict):
            raise Exception("Expected endpoints_ to be a Mapping, received: {}".format(type(endpoints_)))

        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        if offer_name_ is not None and not isinstance(offer_name_, (bytes, str)):
            raise Exception("Expected offer_name_ to be a str, received: {}".format(type(offer_name_)))

        self.application_description = application_description_
        self.application_name = application_name_
        self.endpoints = endpoints_
        self.model_tag = model_tag_
        self.offer_name = offer_name_
        self.unknown_fields = unknown_fields



class AddApplicationOffers(Type):
    _toSchema = {'offers': 'Offers'}
    _toPy = {'Offers': 'offers'}
    def __init__(self, offers=None, **unknown_fields):
        '''
        offers : typing.Sequence[~AddApplicationOffer]
        '''
        offers_ = [AddApplicationOffer.from_json(o) for o in offers or []]

        # Validate arguments against known Juju API types.
        if offers_ is not None and not isinstance(offers_, (bytes, str, list)):
            raise Exception("Expected offers_ to be a Sequence, received: {}".format(type(offers_)))

        self.offers = offers_
        self.unknown_fields = unknown_fields



class AddApplicationUnits(Type):
    _toSchema = {'application': 'application', 'attach_storage': 'attach-storage', 'num_units': 'num-units', 'placement': 'placement', 'policy': 'policy'}
    _toPy = {'application': 'application', 'attach-storage': 'attach_storage', 'num-units': 'num_units', 'placement': 'placement', 'policy': 'policy'}
    def __init__(self, application=None, attach_storage=None, num_units=None, placement=None, policy=None, **unknown_fields):
        '''
        application : str
        attach_storage : typing.Sequence[str]
        num_units : int
        placement : typing.Sequence[~Placement]
        policy : str
        '''
        application_ = application
        attach_storage_ = attach_storage
        num_units_ = num_units
        placement_ = [Placement.from_json(o) for o in placement or []]
        policy_ = policy

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if attach_storage_ is not None and not isinstance(attach_storage_, (bytes, str, list)):
            raise Exception("Expected attach_storage_ to be a Sequence, received: {}".format(type(attach_storage_)))

        if num_units_ is not None and not isinstance(num_units_, int):
            raise Exception("Expected num_units_ to be a int, received: {}".format(type(num_units_)))

        if placement_ is not None and not isinstance(placement_, (bytes, str, list)):
            raise Exception("Expected placement_ to be a Sequence, received: {}".format(type(placement_)))

        if policy_ is not None and not isinstance(policy_, (bytes, str)):
            raise Exception("Expected policy_ to be a str, received: {}".format(type(policy_)))

        self.application = application_
        self.attach_storage = attach_storage_
        self.num_units = num_units_
        self.placement = placement_
        self.policy = policy_
        self.unknown_fields = unknown_fields



class AddApplicationUnitsResults(Type):
    _toSchema = {'units': 'units'}
    _toPy = {'units': 'units'}
    def __init__(self, units=None, **unknown_fields):
        '''
        units : typing.Sequence[str]
        '''
        units_ = units

        # Validate arguments against known Juju API types.
        if units_ is not None and not isinstance(units_, (bytes, str, list)):
            raise Exception("Expected units_ to be a Sequence, received: {}".format(type(units_)))

        self.units = units_
        self.unknown_fields = unknown_fields



class AddCharm(Type):
    _toSchema = {'channel': 'channel', 'force': 'force', 'url': 'url'}
    _toPy = {'channel': 'channel', 'force': 'force', 'url': 'url'}
    def __init__(self, channel=None, force=None, url=None, **unknown_fields):
        '''
        channel : str
        force : bool
        url : str
        '''
        channel_ = channel
        force_ = force
        url_ = url

        # Validate arguments against known Juju API types.
        if channel_ is not None and not isinstance(channel_, (bytes, str)):
            raise Exception("Expected channel_ to be a str, received: {}".format(type(channel_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if url_ is not None and not isinstance(url_, (bytes, str)):
            raise Exception("Expected url_ to be a str, received: {}".format(type(url_)))

        self.channel = channel_
        self.force = force_
        self.url = url_
        self.unknown_fields = unknown_fields



class AddCharmWithAuthorization(Type):
    _toSchema = {'channel': 'channel', 'force': 'force', 'macaroon': 'macaroon', 'url': 'url'}
    _toPy = {'channel': 'channel', 'force': 'force', 'macaroon': 'macaroon', 'url': 'url'}
    def __init__(self, channel=None, force=None, macaroon=None, url=None, **unknown_fields):
        '''
        channel : str
        force : bool
        macaroon : Macaroon
        url : str
        '''
        channel_ = channel
        force_ = force
        macaroon_ = Macaroon.from_json(macaroon) if macaroon else None
        url_ = url

        # Validate arguments against known Juju API types.
        if channel_ is not None and not isinstance(channel_, (bytes, str)):
            raise Exception("Expected channel_ to be a str, received: {}".format(type(channel_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if macaroon_ is not None and not isinstance(macaroon_, (dict, Macaroon)):
            raise Exception("Expected macaroon_ to be a Macaroon, received: {}".format(type(macaroon_)))

        if url_ is not None and not isinstance(url_, (bytes, str)):
            raise Exception("Expected url_ to be a str, received: {}".format(type(url_)))

        self.channel = channel_
        self.force = force_
        self.macaroon = macaroon_
        self.url = url_
        self.unknown_fields = unknown_fields



class AddCloudArgs(Type):
    _toSchema = {'cloud': 'cloud', 'force': 'force', 'name': 'name'}
    _toPy = {'cloud': 'cloud', 'force': 'force', 'name': 'name'}
    def __init__(self, cloud=None, force=None, name=None, **unknown_fields):
        '''
        cloud : Cloud
        force : bool
        name : str
        '''
        cloud_ = Cloud.from_json(cloud) if cloud else None
        force_ = force
        name_ = name

        # Validate arguments against known Juju API types.
        if cloud_ is not None and not isinstance(cloud_, (dict, Cloud)):
            raise Exception("Expected cloud_ to be a Cloud, received: {}".format(type(cloud_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        self.cloud = cloud_
        self.force = force_
        self.name = name_
        self.unknown_fields = unknown_fields



class AddMachineParams(Type):
    _toSchema = {'addresses': 'addresses', 'constraints': 'constraints', 'container_type': 'container-type', 'disks': 'disks', 'hardware_characteristics': 'hardware-characteristics', 'instance_id': 'instance-id', 'jobs': 'jobs', 'nonce': 'nonce', 'parent_id': 'parent-id', 'placement': 'placement', 'series': 'series'}
    _toPy = {'addresses': 'addresses', 'constraints': 'constraints', 'container-type': 'container_type', 'disks': 'disks', 'hardware-characteristics': 'hardware_characteristics', 'instance-id': 'instance_id', 'jobs': 'jobs', 'nonce': 'nonce', 'parent-id': 'parent_id', 'placement': 'placement', 'series': 'series'}
    def __init__(self, addresses=None, constraints=None, container_type=None, disks=None, hardware_characteristics=None, instance_id=None, jobs=None, nonce=None, parent_id=None, placement=None, series=None, **unknown_fields):
        '''
        addresses : typing.Sequence[~Address]
        constraints : Value
        container_type : str
        disks : typing.Sequence[~Constraints]
        hardware_characteristics : HardwareCharacteristics
        instance_id : str
        jobs : typing.Sequence[str]
        nonce : str
        parent_id : str
        placement : Placement
        series : str
        '''
        addresses_ = [Address.from_json(o) for o in addresses or []]
        constraints_ = Value.from_json(constraints) if constraints else None
        container_type_ = container_type
        disks_ = [Constraints.from_json(o) for o in disks or []]
        hardware_characteristics_ = HardwareCharacteristics.from_json(hardware_characteristics) if hardware_characteristics else None
        instance_id_ = instance_id
        jobs_ = jobs
        nonce_ = nonce
        parent_id_ = parent_id
        placement_ = Placement.from_json(placement) if placement else None
        series_ = series

        # Validate arguments against known Juju API types.
        if addresses_ is not None and not isinstance(addresses_, (bytes, str, list)):
            raise Exception("Expected addresses_ to be a Sequence, received: {}".format(type(addresses_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if container_type_ is not None and not isinstance(container_type_, (bytes, str)):
            raise Exception("Expected container_type_ to be a str, received: {}".format(type(container_type_)))

        if disks_ is not None and not isinstance(disks_, (bytes, str, list)):
            raise Exception("Expected disks_ to be a Sequence, received: {}".format(type(disks_)))

        if hardware_characteristics_ is not None and not isinstance(hardware_characteristics_, (dict, HardwareCharacteristics)):
            raise Exception("Expected hardware_characteristics_ to be a HardwareCharacteristics, received: {}".format(type(hardware_characteristics_)))

        if instance_id_ is not None and not isinstance(instance_id_, (bytes, str)):
            raise Exception("Expected instance_id_ to be a str, received: {}".format(type(instance_id_)))

        if jobs_ is not None and not isinstance(jobs_, (bytes, str, list)):
            raise Exception("Expected jobs_ to be a Sequence, received: {}".format(type(jobs_)))

        if nonce_ is not None and not isinstance(nonce_, (bytes, str)):
            raise Exception("Expected nonce_ to be a str, received: {}".format(type(nonce_)))

        if parent_id_ is not None and not isinstance(parent_id_, (bytes, str)):
            raise Exception("Expected parent_id_ to be a str, received: {}".format(type(parent_id_)))

        if placement_ is not None and not isinstance(placement_, (dict, Placement)):
            raise Exception("Expected placement_ to be a Placement, received: {}".format(type(placement_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        self.addresses = addresses_
        self.constraints = constraints_
        self.container_type = container_type_
        self.disks = disks_
        self.hardware_characteristics = hardware_characteristics_
        self.instance_id = instance_id_
        self.jobs = jobs_
        self.nonce = nonce_
        self.parent_id = parent_id_
        self.placement = placement_
        self.series = series_
        self.unknown_fields = unknown_fields



class AddMachines(Type):
    _toSchema = {'params': 'params'}
    _toPy = {'params': 'params'}
    def __init__(self, params=None, **unknown_fields):
        '''
        params : typing.Sequence[~AddMachineParams]
        '''
        params_ = [AddMachineParams.from_json(o) for o in params or []]

        # Validate arguments against known Juju API types.
        if params_ is not None and not isinstance(params_, (bytes, str, list)):
            raise Exception("Expected params_ to be a Sequence, received: {}".format(type(params_)))

        self.params = params_
        self.unknown_fields = unknown_fields



class AddMachinesResult(Type):
    _toSchema = {'error': 'error', 'machine': 'machine'}
    _toPy = {'error': 'error', 'machine': 'machine'}
    def __init__(self, error=None, machine=None, **unknown_fields):
        '''
        error : Error
        machine : str
        '''
        error_ = Error.from_json(error) if error else None
        machine_ = machine

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if machine_ is not None and not isinstance(machine_, (bytes, str)):
            raise Exception("Expected machine_ to be a str, received: {}".format(type(machine_)))

        self.error = error_
        self.machine = machine_
        self.unknown_fields = unknown_fields



class AddMachinesResults(Type):
    _toSchema = {'machines': 'machines'}
    _toPy = {'machines': 'machines'}
    def __init__(self, machines=None, **unknown_fields):
        '''
        machines : typing.Sequence[~AddMachinesResult]
        '''
        machines_ = [AddMachinesResult.from_json(o) for o in machines or []]

        # Validate arguments against known Juju API types.
        if machines_ is not None and not isinstance(machines_, (bytes, str, list)):
            raise Exception("Expected machines_ to be a Sequence, received: {}".format(type(machines_)))

        self.machines = machines_
        self.unknown_fields = unknown_fields



class AddPendingResourcesArgs(Type):
    _toSchema = {'addcharmwithauthorization': 'AddCharmWithAuthorization', 'channel': 'channel', 'entity': 'Entity', 'force': 'force', 'macaroon': 'macaroon', 'resources': 'resources', 'tag': 'tag', 'url': 'url'}
    _toPy = {'AddCharmWithAuthorization': 'addcharmwithauthorization', 'Entity': 'entity', 'channel': 'channel', 'force': 'force', 'macaroon': 'macaroon', 'resources': 'resources', 'tag': 'tag', 'url': 'url'}
    def __init__(self, addcharmwithauthorization=None, entity=None, channel=None, force=None, macaroon=None, resources=None, tag=None, url=None, **unknown_fields):
        '''
        addcharmwithauthorization : AddCharmWithAuthorization
        entity : Entity
        channel : str
        force : bool
        macaroon : Macaroon
        resources : typing.Sequence[~CharmResource]
        tag : str
        url : str
        '''
        addcharmwithauthorization_ = AddCharmWithAuthorization.from_json(addcharmwithauthorization) if addcharmwithauthorization else None
        entity_ = Entity.from_json(entity) if entity else None
        channel_ = channel
        force_ = force
        macaroon_ = Macaroon.from_json(macaroon) if macaroon else None
        resources_ = [CharmResource.from_json(o) for o in resources or []]
        tag_ = tag
        url_ = url

        # Validate arguments against known Juju API types.
        if addcharmwithauthorization_ is not None and not isinstance(addcharmwithauthorization_, (dict, AddCharmWithAuthorization)):
            raise Exception("Expected addcharmwithauthorization_ to be a AddCharmWithAuthorization, received: {}".format(type(addcharmwithauthorization_)))

        if entity_ is not None and not isinstance(entity_, (dict, Entity)):
            raise Exception("Expected entity_ to be a Entity, received: {}".format(type(entity_)))

        if channel_ is not None and not isinstance(channel_, (bytes, str)):
            raise Exception("Expected channel_ to be a str, received: {}".format(type(channel_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if macaroon_ is not None and not isinstance(macaroon_, (dict, Macaroon)):
            raise Exception("Expected macaroon_ to be a Macaroon, received: {}".format(type(macaroon_)))

        if resources_ is not None and not isinstance(resources_, (bytes, str, list)):
            raise Exception("Expected resources_ to be a Sequence, received: {}".format(type(resources_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if url_ is not None and not isinstance(url_, (bytes, str)):
            raise Exception("Expected url_ to be a str, received: {}".format(type(url_)))

        self.addcharmwithauthorization = addcharmwithauthorization_
        self.entity = entity_
        self.channel = channel_
        self.force = force_
        self.macaroon = macaroon_
        self.resources = resources_
        self.tag = tag_
        self.url = url_
        self.unknown_fields = unknown_fields



class AddPendingResourcesResult(Type):
    _toSchema = {'error': 'error', 'errorresult': 'ErrorResult', 'pending_ids': 'pending-ids'}
    _toPy = {'ErrorResult': 'errorresult', 'error': 'error', 'pending-ids': 'pending_ids'}
    def __init__(self, errorresult=None, error=None, pending_ids=None, **unknown_fields):
        '''
        errorresult : ErrorResult
        error : Error
        pending_ids : typing.Sequence[str]
        '''
        errorresult_ = ErrorResult.from_json(errorresult) if errorresult else None
        error_ = Error.from_json(error) if error else None
        pending_ids_ = pending_ids

        # Validate arguments against known Juju API types.
        if errorresult_ is not None and not isinstance(errorresult_, (dict, ErrorResult)):
            raise Exception("Expected errorresult_ to be a ErrorResult, received: {}".format(type(errorresult_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if pending_ids_ is not None and not isinstance(pending_ids_, (bytes, str, list)):
            raise Exception("Expected pending_ids_ to be a Sequence, received: {}".format(type(pending_ids_)))

        self.errorresult = errorresult_
        self.error = error_
        self.pending_ids = pending_ids_
        self.unknown_fields = unknown_fields



class AddRelation(Type):
    _toSchema = {'endpoints': 'endpoints', 'via_cidrs': 'via-cidrs'}
    _toPy = {'endpoints': 'endpoints', 'via-cidrs': 'via_cidrs'}
    def __init__(self, endpoints=None, via_cidrs=None, **unknown_fields):
        '''
        endpoints : typing.Sequence[str]
        via_cidrs : typing.Sequence[str]
        '''
        endpoints_ = endpoints
        via_cidrs_ = via_cidrs

        # Validate arguments against known Juju API types.
        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if via_cidrs_ is not None and not isinstance(via_cidrs_, (bytes, str, list)):
            raise Exception("Expected via_cidrs_ to be a Sequence, received: {}".format(type(via_cidrs_)))

        self.endpoints = endpoints_
        self.via_cidrs = via_cidrs_
        self.unknown_fields = unknown_fields



class AddRelationResults(Type):
    _toSchema = {'endpoints': 'endpoints'}
    _toPy = {'endpoints': 'endpoints'}
    def __init__(self, endpoints=None, **unknown_fields):
        '''
        endpoints : typing.Mapping[str, ~CharmRelation]
        '''
        endpoints_ = {k: CharmRelation.from_json(v) for k, v in (endpoints or dict()).items()}

        # Validate arguments against known Juju API types.
        if endpoints_ is not None and not isinstance(endpoints_, dict):
            raise Exception("Expected endpoints_ to be a Mapping, received: {}".format(type(endpoints_)))

        self.endpoints = endpoints_
        self.unknown_fields = unknown_fields



class AddStorageDetails(Type):
    _toSchema = {'storage_tags': 'storage-tags'}
    _toPy = {'storage-tags': 'storage_tags'}
    def __init__(self, storage_tags=None, **unknown_fields):
        '''
        storage_tags : typing.Sequence[str]
        '''
        storage_tags_ = storage_tags

        # Validate arguments against known Juju API types.
        if storage_tags_ is not None and not isinstance(storage_tags_, (bytes, str, list)):
            raise Exception("Expected storage_tags_ to be a Sequence, received: {}".format(type(storage_tags_)))

        self.storage_tags = storage_tags_
        self.unknown_fields = unknown_fields



class AddStorageResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : AddStorageDetails
        '''
        error_ = Error.from_json(error) if error else None
        result_ = AddStorageDetails.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, AddStorageDetails)):
            raise Exception("Expected result_ to be a AddStorageDetails, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class AddStorageResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~AddStorageResult]
        '''
        results_ = [AddStorageResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class AddSubnetParams(Type):
    _toSchema = {'cidr': 'cidr', 'provider_network_id': 'provider-network-id', 'space_tag': 'space-tag', 'subnet_provider_id': 'subnet-provider-id', 'vlan_tag': 'vlan-tag', 'zones': 'zones'}
    _toPy = {'cidr': 'cidr', 'provider-network-id': 'provider_network_id', 'space-tag': 'space_tag', 'subnet-provider-id': 'subnet_provider_id', 'vlan-tag': 'vlan_tag', 'zones': 'zones'}
    def __init__(self, cidr=None, provider_network_id=None, space_tag=None, subnet_provider_id=None, vlan_tag=None, zones=None, **unknown_fields):
        '''
        cidr : str
        provider_network_id : str
        space_tag : str
        subnet_provider_id : str
        vlan_tag : int
        zones : typing.Sequence[str]
        '''
        cidr_ = cidr
        provider_network_id_ = provider_network_id
        space_tag_ = space_tag
        subnet_provider_id_ = subnet_provider_id
        vlan_tag_ = vlan_tag
        zones_ = zones

        # Validate arguments against known Juju API types.
        if cidr_ is not None and not isinstance(cidr_, (bytes, str)):
            raise Exception("Expected cidr_ to be a str, received: {}".format(type(cidr_)))

        if provider_network_id_ is not None and not isinstance(provider_network_id_, (bytes, str)):
            raise Exception("Expected provider_network_id_ to be a str, received: {}".format(type(provider_network_id_)))

        if space_tag_ is not None and not isinstance(space_tag_, (bytes, str)):
            raise Exception("Expected space_tag_ to be a str, received: {}".format(type(space_tag_)))

        if subnet_provider_id_ is not None and not isinstance(subnet_provider_id_, (bytes, str)):
            raise Exception("Expected subnet_provider_id_ to be a str, received: {}".format(type(subnet_provider_id_)))

        if vlan_tag_ is not None and not isinstance(vlan_tag_, int):
            raise Exception("Expected vlan_tag_ to be a int, received: {}".format(type(vlan_tag_)))

        if zones_ is not None and not isinstance(zones_, (bytes, str, list)):
            raise Exception("Expected zones_ to be a Sequence, received: {}".format(type(zones_)))

        self.cidr = cidr_
        self.provider_network_id = provider_network_id_
        self.space_tag = space_tag_
        self.subnet_provider_id = subnet_provider_id_
        self.vlan_tag = vlan_tag_
        self.zones = zones_
        self.unknown_fields = unknown_fields



class AddSubnetsParams(Type):
    _toSchema = {'subnets': 'subnets'}
    _toPy = {'subnets': 'subnets'}
    def __init__(self, subnets=None, **unknown_fields):
        '''
        subnets : typing.Sequence[~AddSubnetParams]
        '''
        subnets_ = [AddSubnetParams.from_json(o) for o in subnets or []]

        # Validate arguments against known Juju API types.
        if subnets_ is not None and not isinstance(subnets_, (bytes, str, list)):
            raise Exception("Expected subnets_ to be a Sequence, received: {}".format(type(subnets_)))

        self.subnets = subnets_
        self.unknown_fields = unknown_fields



class AddUser(Type):
    _toSchema = {'display_name': 'display-name', 'password': 'password', 'username': 'username'}
    _toPy = {'display-name': 'display_name', 'password': 'password', 'username': 'username'}
    def __init__(self, display_name=None, password=None, username=None, **unknown_fields):
        '''
        display_name : str
        password : str
        username : str
        '''
        display_name_ = display_name
        password_ = password
        username_ = username

        # Validate arguments against known Juju API types.
        if display_name_ is not None and not isinstance(display_name_, (bytes, str)):
            raise Exception("Expected display_name_ to be a str, received: {}".format(type(display_name_)))

        if password_ is not None and not isinstance(password_, (bytes, str)):
            raise Exception("Expected password_ to be a str, received: {}".format(type(password_)))

        if username_ is not None and not isinstance(username_, (bytes, str)):
            raise Exception("Expected username_ to be a str, received: {}".format(type(username_)))

        self.display_name = display_name_
        self.password = password_
        self.username = username_
        self.unknown_fields = unknown_fields



class AddUserResult(Type):
    _toSchema = {'error': 'error', 'secret_key': 'secret-key', 'tag': 'tag'}
    _toPy = {'error': 'error', 'secret-key': 'secret_key', 'tag': 'tag'}
    def __init__(self, error=None, secret_key=None, tag=None, **unknown_fields):
        '''
        error : Error
        secret_key : typing.Sequence[int]
        tag : str
        '''
        error_ = Error.from_json(error) if error else None
        secret_key_ = secret_key
        tag_ = tag

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if secret_key_ is not None and not isinstance(secret_key_, (bytes, str, list)):
            raise Exception("Expected secret_key_ to be a Sequence, received: {}".format(type(secret_key_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.error = error_
        self.secret_key = secret_key_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class AddUserResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~AddUserResult]
        '''
        results_ = [AddUserResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class AddUsers(Type):
    _toSchema = {'users': 'users'}
    _toPy = {'users': 'users'}
    def __init__(self, users=None, **unknown_fields):
        '''
        users : typing.Sequence[~AddUser]
        '''
        users_ = [AddUser.from_json(o) for o in users or []]

        # Validate arguments against known Juju API types.
        if users_ is not None and not isinstance(users_, (bytes, str, list)):
            raise Exception("Expected users_ to be a Sequence, received: {}".format(type(users_)))

        self.users = users_
        self.unknown_fields = unknown_fields



class Address(Type):
    _toSchema = {'scope': 'scope', 'space_id': 'space-id', 'space_name': 'space-name', 'type_': 'type', 'value': 'value'}
    _toPy = {'scope': 'scope', 'space-id': 'space_id', 'space-name': 'space_name', 'type': 'type_', 'value': 'value'}
    def __init__(self, scope=None, space_id=None, space_name=None, type_=None, value=None, **unknown_fields):
        '''
        scope : str
        space_id : str
        space_name : str
        type_ : str
        value : str
        '''
        scope_ = scope
        space_id_ = space_id
        space_name_ = space_name
        type__ = type_
        value_ = value

        # Validate arguments against known Juju API types.
        if scope_ is not None and not isinstance(scope_, (bytes, str)):
            raise Exception("Expected scope_ to be a str, received: {}".format(type(scope_)))

        if space_id_ is not None and not isinstance(space_id_, (bytes, str)):
            raise Exception("Expected space_id_ to be a str, received: {}".format(type(space_id_)))

        if space_name_ is not None and not isinstance(space_name_, (bytes, str)):
            raise Exception("Expected space_name_ to be a str, received: {}".format(type(space_name_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if value_ is not None and not isinstance(value_, (bytes, str)):
            raise Exception("Expected value_ to be a str, received: {}".format(type(value_)))

        self.scope = scope_
        self.space_id = space_id_
        self.space_name = space_name_
        self.type_ = type__
        self.value = value_
        self.unknown_fields = unknown_fields



class AdoptResourcesArgs(Type):
    _toSchema = {'model_tag': 'model-tag', 'source_controller_version': 'source-controller-version'}
    _toPy = {'model-tag': 'model_tag', 'source-controller-version': 'source_controller_version'}
    def __init__(self, model_tag=None, source_controller_version=None, **unknown_fields):
        '''
        model_tag : str
        source_controller_version : Number
        '''
        model_tag_ = model_tag
        source_controller_version_ = Number.from_json(source_controller_version) if source_controller_version else None

        # Validate arguments against known Juju API types.
        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        if source_controller_version_ is not None and not isinstance(source_controller_version_, (dict, Number)):
            raise Exception("Expected source_controller_version_ to be a Number, received: {}".format(type(source_controller_version_)))

        self.model_tag = model_tag_
        self.source_controller_version = source_controller_version_
        self.unknown_fields = unknown_fields



class AgentGetEntitiesResult(Type):
    _toSchema = {'container_type': 'container-type', 'error': 'error', 'jobs': 'jobs', 'life': 'life'}
    _toPy = {'container-type': 'container_type', 'error': 'error', 'jobs': 'jobs', 'life': 'life'}
    def __init__(self, container_type=None, error=None, jobs=None, life=None, **unknown_fields):
        '''
        container_type : str
        error : Error
        jobs : typing.Sequence[str]
        life : str
        '''
        container_type_ = container_type
        error_ = Error.from_json(error) if error else None
        jobs_ = jobs
        life_ = life

        # Validate arguments against known Juju API types.
        if container_type_ is not None and not isinstance(container_type_, (bytes, str)):
            raise Exception("Expected container_type_ to be a str, received: {}".format(type(container_type_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if jobs_ is not None and not isinstance(jobs_, (bytes, str, list)):
            raise Exception("Expected jobs_ to be a Sequence, received: {}".format(type(jobs_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        self.container_type = container_type_
        self.error = error_
        self.jobs = jobs_
        self.life = life_
        self.unknown_fields = unknown_fields



class AgentGetEntitiesResults(Type):
    _toSchema = {'entities': 'entities'}
    _toPy = {'entities': 'entities'}
    def __init__(self, entities=None, **unknown_fields):
        '''
        entities : typing.Sequence[~AgentGetEntitiesResult]
        '''
        entities_ = [AgentGetEntitiesResult.from_json(o) for o in entities or []]

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        self.entities = entities_
        self.unknown_fields = unknown_fields



class AgentVersionResult(Type):
    _toSchema = {'version': 'version'}
    _toPy = {'version': 'version'}
    def __init__(self, version=None, **unknown_fields):
        '''
        version : Number
        '''
        version_ = Number.from_json(version) if version else None

        # Validate arguments against known Juju API types.
        if version_ is not None and not isinstance(version_, (dict, Number)):
            raise Exception("Expected version_ to be a Number, received: {}".format(type(version_)))

        self.version = version_
        self.unknown_fields = unknown_fields



class AllWatcherId(Type):
    _toSchema = {'watcher_id': 'watcher-id'}
    _toPy = {'watcher-id': 'watcher_id'}
    def __init__(self, watcher_id=None, **unknown_fields):
        '''
        watcher_id : str
        '''
        watcher_id_ = watcher_id

        # Validate arguments against known Juju API types.
        if watcher_id_ is not None and not isinstance(watcher_id_, (bytes, str)):
            raise Exception("Expected watcher_id_ to be a str, received: {}".format(type(watcher_id_)))

        self.watcher_id = watcher_id_
        self.unknown_fields = unknown_fields



class AllWatcherNextResults(Type):
    _toSchema = {'deltas': 'deltas'}
    _toPy = {'deltas': 'deltas'}
    def __init__(self, deltas=None, **unknown_fields):
        '''
        deltas : typing.Sequence[~Delta]
        '''
        deltas_ = [Delta.from_json(o) for o in deltas or []]

        # Validate arguments against known Juju API types.
        if deltas_ is not None and not isinstance(deltas_, (bytes, str, list)):
            raise Exception("Expected deltas_ to be a Sequence, received: {}".format(type(deltas_)))

        self.deltas = deltas_
        self.unknown_fields = unknown_fields



class AnnotationsGetResult(Type):
    _toSchema = {'annotations': 'annotations', 'entity': 'entity', 'error': 'error'}
    _toPy = {'annotations': 'annotations', 'entity': 'entity', 'error': 'error'}
    def __init__(self, annotations=None, entity=None, error=None, **unknown_fields):
        '''
        annotations : typing.Mapping[str, str]
        entity : str
        error : ErrorResult
        '''
        annotations_ = annotations
        entity_ = entity
        error_ = ErrorResult.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if annotations_ is not None and not isinstance(annotations_, dict):
            raise Exception("Expected annotations_ to be a Mapping, received: {}".format(type(annotations_)))

        if entity_ is not None and not isinstance(entity_, (bytes, str)):
            raise Exception("Expected entity_ to be a str, received: {}".format(type(entity_)))

        if error_ is not None and not isinstance(error_, (dict, ErrorResult)):
            raise Exception("Expected error_ to be a ErrorResult, received: {}".format(type(error_)))

        self.annotations = annotations_
        self.entity = entity_
        self.error = error_
        self.unknown_fields = unknown_fields



class AnnotationsGetResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~AnnotationsGetResult]
        '''
        results_ = [AnnotationsGetResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class AnnotationsSet(Type):
    _toSchema = {'annotations': 'annotations'}
    _toPy = {'annotations': 'annotations'}
    def __init__(self, annotations=None, **unknown_fields):
        '''
        annotations : typing.Sequence[~EntityAnnotations]
        '''
        annotations_ = [EntityAnnotations.from_json(o) for o in annotations or []]

        # Validate arguments against known Juju API types.
        if annotations_ is not None and not isinstance(annotations_, (bytes, str, list)):
            raise Exception("Expected annotations_ to be a Sequence, received: {}".format(type(annotations_)))

        self.annotations = annotations_
        self.unknown_fields = unknown_fields



class ApplicationCharm(Type):
    _toSchema = {'charm_modified_version': 'charm-modified-version', 'deployment_mode': 'deployment-mode', 'force_upgrade': 'force-upgrade', 'sha256': 'sha256', 'url': 'url'}
    _toPy = {'charm-modified-version': 'charm_modified_version', 'deployment-mode': 'deployment_mode', 'force-upgrade': 'force_upgrade', 'sha256': 'sha256', 'url': 'url'}
    def __init__(self, charm_modified_version=None, deployment_mode=None, force_upgrade=None, sha256=None, url=None, **unknown_fields):
        '''
        charm_modified_version : int
        deployment_mode : str
        force_upgrade : bool
        sha256 : str
        url : str
        '''
        charm_modified_version_ = charm_modified_version
        deployment_mode_ = deployment_mode
        force_upgrade_ = force_upgrade
        sha256_ = sha256
        url_ = url

        # Validate arguments against known Juju API types.
        if charm_modified_version_ is not None and not isinstance(charm_modified_version_, int):
            raise Exception("Expected charm_modified_version_ to be a int, received: {}".format(type(charm_modified_version_)))

        if deployment_mode_ is not None and not isinstance(deployment_mode_, (bytes, str)):
            raise Exception("Expected deployment_mode_ to be a str, received: {}".format(type(deployment_mode_)))

        if force_upgrade_ is not None and not isinstance(force_upgrade_, bool):
            raise Exception("Expected force_upgrade_ to be a bool, received: {}".format(type(force_upgrade_)))

        if sha256_ is not None and not isinstance(sha256_, (bytes, str)):
            raise Exception("Expected sha256_ to be a str, received: {}".format(type(sha256_)))

        if url_ is not None and not isinstance(url_, (bytes, str)):
            raise Exception("Expected url_ to be a str, received: {}".format(type(url_)))

        self.charm_modified_version = charm_modified_version_
        self.deployment_mode = deployment_mode_
        self.force_upgrade = force_upgrade_
        self.sha256 = sha256_
        self.url = url_
        self.unknown_fields = unknown_fields



class ApplicationCharmActionsResult(Type):
    _toSchema = {'actions': 'actions', 'application_tag': 'application-tag', 'error': 'error'}
    _toPy = {'actions': 'actions', 'application-tag': 'application_tag', 'error': 'error'}
    def __init__(self, actions=None, application_tag=None, error=None, **unknown_fields):
        '''
        actions : typing.Mapping[str, ~ActionSpec]
        application_tag : str
        error : Error
        '''
        actions_ = {k: ActionSpec.from_json(v) for k, v in (actions or dict()).items()}
        application_tag_ = application_tag
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, dict):
            raise Exception("Expected actions_ to be a Mapping, received: {}".format(type(actions_)))

        if application_tag_ is not None and not isinstance(application_tag_, (bytes, str)):
            raise Exception("Expected application_tag_ to be a str, received: {}".format(type(application_tag_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.actions = actions_
        self.application_tag = application_tag_
        self.error = error_
        self.unknown_fields = unknown_fields



class ApplicationCharmRelations(Type):
    _toSchema = {'application': 'application'}
    _toPy = {'application': 'application'}
    def __init__(self, application=None, **unknown_fields):
        '''
        application : str
        '''
        application_ = application

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        self.application = application_
        self.unknown_fields = unknown_fields



class ApplicationCharmRelationsResults(Type):
    _toSchema = {'charm_relations': 'charm-relations'}
    _toPy = {'charm-relations': 'charm_relations'}
    def __init__(self, charm_relations=None, **unknown_fields):
        '''
        charm_relations : typing.Sequence[str]
        '''
        charm_relations_ = charm_relations

        # Validate arguments against known Juju API types.
        if charm_relations_ is not None and not isinstance(charm_relations_, (bytes, str, list)):
            raise Exception("Expected charm_relations_ to be a Sequence, received: {}".format(type(charm_relations_)))

        self.charm_relations = charm_relations_
        self.unknown_fields = unknown_fields



class ApplicationCharmResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ApplicationCharm
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ApplicationCharm.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ApplicationCharm)):
            raise Exception("Expected result_ to be a ApplicationCharm, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ApplicationCharmResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ApplicationCharmResult]
        '''
        results_ = [ApplicationCharmResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ApplicationConfigSet(Type):
    _toSchema = {'application': 'application', 'config': 'config', 'generation': 'generation'}
    _toPy = {'application': 'application', 'config': 'config', 'generation': 'generation'}
    def __init__(self, application=None, config=None, generation=None, **unknown_fields):
        '''
        application : str
        config : typing.Mapping[str, str]
        generation : str
        '''
        application_ = application
        config_ = config
        generation_ = generation

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if generation_ is not None and not isinstance(generation_, (bytes, str)):
            raise Exception("Expected generation_ to be a str, received: {}".format(type(generation_)))

        self.application = application_
        self.config = config_
        self.generation = generation_
        self.unknown_fields = unknown_fields



class ApplicationConfigSetArgs(Type):
    _toSchema = {'args': 'Args'}
    _toPy = {'Args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~ApplicationConfigSet]
        '''
        args_ = [ApplicationConfigSet.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class ApplicationConfigUnsetArgs(Type):
    _toSchema = {'args': 'Args'}
    _toPy = {'Args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~ApplicationUnset]
        '''
        args_ = [ApplicationUnset.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class ApplicationConstraint(Type):
    _toSchema = {'constraints': 'constraints', 'error': 'error'}
    _toPy = {'constraints': 'constraints', 'error': 'error'}
    def __init__(self, constraints=None, error=None, **unknown_fields):
        '''
        constraints : Value
        error : Error
        '''
        constraints_ = Value.from_json(constraints) if constraints else None
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.constraints = constraints_
        self.error = error_
        self.unknown_fields = unknown_fields



class ApplicationDeploy(Type):
    _toSchema = {'application': 'application', 'attach_storage': 'attach-storage', 'channel': 'channel', 'charm_url': 'charm-url', 'config': 'config', 'config_yaml': 'config-yaml', 'constraints': 'constraints', 'devices': 'devices', 'endpoint_bindings': 'endpoint-bindings', 'num_units': 'num-units', 'placement': 'placement', 'policy': 'policy', 'resources': 'resources', 'series': 'series', 'storage': 'storage'}
    _toPy = {'application': 'application', 'attach-storage': 'attach_storage', 'channel': 'channel', 'charm-url': 'charm_url', 'config': 'config', 'config-yaml': 'config_yaml', 'constraints': 'constraints', 'devices': 'devices', 'endpoint-bindings': 'endpoint_bindings', 'num-units': 'num_units', 'placement': 'placement', 'policy': 'policy', 'resources': 'resources', 'series': 'series', 'storage': 'storage'}
    def __init__(self, application=None, attach_storage=None, channel=None, charm_url=None, config=None, config_yaml=None, constraints=None, devices=None, endpoint_bindings=None, num_units=None, placement=None, policy=None, resources=None, series=None, storage=None, **unknown_fields):
        '''
        application : str
        attach_storage : typing.Sequence[str]
        channel : str
        charm_url : str
        config : typing.Mapping[str, str]
        config_yaml : str
        constraints : Value
        devices : typing.Mapping[str, ~Constraints]
        endpoint_bindings : typing.Mapping[str, str]
        num_units : int
        placement : typing.Sequence[~Placement]
        policy : str
        resources : typing.Mapping[str, str]
        series : str
        storage : typing.Mapping[str, ~Constraints]
        '''
        application_ = application
        attach_storage_ = attach_storage
        channel_ = channel
        charm_url_ = charm_url
        config_ = config
        config_yaml_ = config_yaml
        constraints_ = Value.from_json(constraints) if constraints else None
        devices_ = {k: Constraints.from_json(v) for k, v in (devices or dict()).items()}
        endpoint_bindings_ = endpoint_bindings
        num_units_ = num_units
        placement_ = [Placement.from_json(o) for o in placement or []]
        policy_ = policy
        resources_ = resources
        series_ = series
        storage_ = {k: Constraints.from_json(v) for k, v in (storage or dict()).items()}

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if attach_storage_ is not None and not isinstance(attach_storage_, (bytes, str, list)):
            raise Exception("Expected attach_storage_ to be a Sequence, received: {}".format(type(attach_storage_)))

        if channel_ is not None and not isinstance(channel_, (bytes, str)):
            raise Exception("Expected channel_ to be a str, received: {}".format(type(channel_)))

        if charm_url_ is not None and not isinstance(charm_url_, (bytes, str)):
            raise Exception("Expected charm_url_ to be a str, received: {}".format(type(charm_url_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if config_yaml_ is not None and not isinstance(config_yaml_, (bytes, str)):
            raise Exception("Expected config_yaml_ to be a str, received: {}".format(type(config_yaml_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if devices_ is not None and not isinstance(devices_, dict):
            raise Exception("Expected devices_ to be a Mapping, received: {}".format(type(devices_)))

        if endpoint_bindings_ is not None and not isinstance(endpoint_bindings_, dict):
            raise Exception("Expected endpoint_bindings_ to be a Mapping, received: {}".format(type(endpoint_bindings_)))

        if num_units_ is not None and not isinstance(num_units_, int):
            raise Exception("Expected num_units_ to be a int, received: {}".format(type(num_units_)))

        if placement_ is not None and not isinstance(placement_, (bytes, str, list)):
            raise Exception("Expected placement_ to be a Sequence, received: {}".format(type(placement_)))

        if policy_ is not None and not isinstance(policy_, (bytes, str)):
            raise Exception("Expected policy_ to be a str, received: {}".format(type(policy_)))

        if resources_ is not None and not isinstance(resources_, dict):
            raise Exception("Expected resources_ to be a Mapping, received: {}".format(type(resources_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if storage_ is not None and not isinstance(storage_, dict):
            raise Exception("Expected storage_ to be a Mapping, received: {}".format(type(storage_)))

        self.application = application_
        self.attach_storage = attach_storage_
        self.channel = channel_
        self.charm_url = charm_url_
        self.config = config_
        self.config_yaml = config_yaml_
        self.constraints = constraints_
        self.devices = devices_
        self.endpoint_bindings = endpoint_bindings_
        self.num_units = num_units_
        self.placement = placement_
        self.policy = policy_
        self.resources = resources_
        self.series = series_
        self.storage = storage_
        self.unknown_fields = unknown_fields



class ApplicationDestroy(Type):
    _toSchema = {'application': 'application'}
    _toPy = {'application': 'application'}
    def __init__(self, application=None, **unknown_fields):
        '''
        application : str
        '''
        application_ = application

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        self.application = application_
        self.unknown_fields = unknown_fields



class ApplicationExpose(Type):
    _toSchema = {'application': 'application'}
    _toPy = {'application': 'application'}
    def __init__(self, application=None, **unknown_fields):
        '''
        application : str
        '''
        application_ = application

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        self.application = application_
        self.unknown_fields = unknown_fields



class ApplicationGet(Type):
    _toSchema = {'application': 'application', 'branch': 'branch'}
    _toPy = {'application': 'application', 'branch': 'branch'}
    def __init__(self, application=None, branch=None, **unknown_fields):
        '''
        application : str
        branch : str
        '''
        application_ = application
        branch_ = branch

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if branch_ is not None and not isinstance(branch_, (bytes, str)):
            raise Exception("Expected branch_ to be a str, received: {}".format(type(branch_)))

        self.application = application_
        self.branch = branch_
        self.unknown_fields = unknown_fields



class ApplicationGetArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~ApplicationGet]
        '''
        args_ = [ApplicationGet.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class ApplicationGetConfigResults(Type):
    _toSchema = {'results': 'Results'}
    _toPy = {'Results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ConfigResult]
        '''
        results_ = [ConfigResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ApplicationGetConstraintsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ApplicationConstraint]
        '''
        results_ = [ApplicationConstraint.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ApplicationGetResults(Type):
    _toSchema = {'application': 'application', 'application_config': 'application-config', 'channel': 'channel', 'charm': 'charm', 'config': 'config', 'constraints': 'constraints', 'endpoint_bindings': 'endpoint-bindings', 'series': 'series'}
    _toPy = {'application': 'application', 'application-config': 'application_config', 'channel': 'channel', 'charm': 'charm', 'config': 'config', 'constraints': 'constraints', 'endpoint-bindings': 'endpoint_bindings', 'series': 'series'}
    def __init__(self, application=None, application_config=None, channel=None, charm=None, config=None, constraints=None, endpoint_bindings=None, series=None, **unknown_fields):
        '''
        application : str
        application_config : typing.Mapping[str, typing.Any]
        channel : str
        charm : str
        config : typing.Mapping[str, typing.Any]
        constraints : Value
        endpoint_bindings : typing.Mapping[str, str]
        series : str
        '''
        application_ = application
        application_config_ = application_config
        channel_ = channel
        charm_ = charm
        config_ = config
        constraints_ = Value.from_json(constraints) if constraints else None
        endpoint_bindings_ = endpoint_bindings
        series_ = series

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if application_config_ is not None and not isinstance(application_config_, dict):
            raise Exception("Expected application_config_ to be a Mapping, received: {}".format(type(application_config_)))

        if channel_ is not None and not isinstance(channel_, (bytes, str)):
            raise Exception("Expected channel_ to be a str, received: {}".format(type(channel_)))

        if charm_ is not None and not isinstance(charm_, (bytes, str)):
            raise Exception("Expected charm_ to be a str, received: {}".format(type(charm_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if endpoint_bindings_ is not None and not isinstance(endpoint_bindings_, dict):
            raise Exception("Expected endpoint_bindings_ to be a Mapping, received: {}".format(type(endpoint_bindings_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        self.application = application_
        self.application_config = application_config_
        self.channel = channel_
        self.charm = charm_
        self.config = config_
        self.constraints = constraints_
        self.endpoint_bindings = endpoint_bindings_
        self.series = series_
        self.unknown_fields = unknown_fields



class ApplicationInfo(Type):
    _toSchema = {'channel': 'channel', 'charm': 'charm', 'constraints': 'constraints', 'endpoint_bindings': 'endpoint-bindings', 'exposed': 'exposed', 'principal': 'principal', 'remote': 'remote', 'series': 'series', 'tag': 'tag'}
    _toPy = {'channel': 'channel', 'charm': 'charm', 'constraints': 'constraints', 'endpoint-bindings': 'endpoint_bindings', 'exposed': 'exposed', 'principal': 'principal', 'remote': 'remote', 'series': 'series', 'tag': 'tag'}
    def __init__(self, channel=None, charm=None, constraints=None, endpoint_bindings=None, exposed=None, principal=None, remote=None, series=None, tag=None, **unknown_fields):
        '''
        channel : str
        charm : str
        constraints : Value
        endpoint_bindings : typing.Mapping[str, str]
        exposed : bool
        principal : bool
        remote : bool
        series : str
        tag : str
        '''
        channel_ = channel
        charm_ = charm
        constraints_ = Value.from_json(constraints) if constraints else None
        endpoint_bindings_ = endpoint_bindings
        exposed_ = exposed
        principal_ = principal
        remote_ = remote
        series_ = series
        tag_ = tag

        # Validate arguments against known Juju API types.
        if channel_ is not None and not isinstance(channel_, (bytes, str)):
            raise Exception("Expected channel_ to be a str, received: {}".format(type(channel_)))

        if charm_ is not None and not isinstance(charm_, (bytes, str)):
            raise Exception("Expected charm_ to be a str, received: {}".format(type(charm_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if endpoint_bindings_ is not None and not isinstance(endpoint_bindings_, dict):
            raise Exception("Expected endpoint_bindings_ to be a Mapping, received: {}".format(type(endpoint_bindings_)))

        if exposed_ is not None and not isinstance(exposed_, bool):
            raise Exception("Expected exposed_ to be a bool, received: {}".format(type(exposed_)))

        if principal_ is not None and not isinstance(principal_, bool):
            raise Exception("Expected principal_ to be a bool, received: {}".format(type(principal_)))

        if remote_ is not None and not isinstance(remote_, bool):
            raise Exception("Expected remote_ to be a bool, received: {}".format(type(remote_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.channel = channel_
        self.charm = charm_
        self.constraints = constraints_
        self.endpoint_bindings = endpoint_bindings_
        self.exposed = exposed_
        self.principal = principal_
        self.remote = remote_
        self.series = series_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class ApplicationInfoResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ApplicationResult
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ApplicationResult.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ApplicationResult)):
            raise Exception("Expected result_ to be a ApplicationResult, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ApplicationInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ApplicationInfoResult]
        '''
        results_ = [ApplicationInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ApplicationMergeBindings(Type):
    _toSchema = {'application_tag': 'application-tag', 'bindings': 'bindings', 'force': 'force'}
    _toPy = {'application-tag': 'application_tag', 'bindings': 'bindings', 'force': 'force'}
    def __init__(self, application_tag=None, bindings=None, force=None, **unknown_fields):
        '''
        application_tag : str
        bindings : typing.Mapping[str, str]
        force : bool
        '''
        application_tag_ = application_tag
        bindings_ = bindings
        force_ = force

        # Validate arguments against known Juju API types.
        if application_tag_ is not None and not isinstance(application_tag_, (bytes, str)):
            raise Exception("Expected application_tag_ to be a str, received: {}".format(type(application_tag_)))

        if bindings_ is not None and not isinstance(bindings_, dict):
            raise Exception("Expected bindings_ to be a Mapping, received: {}".format(type(bindings_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        self.application_tag = application_tag_
        self.bindings = bindings_
        self.force = force_
        self.unknown_fields = unknown_fields



class ApplicationMergeBindingsArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~ApplicationMergeBindings]
        '''
        args_ = [ApplicationMergeBindings.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class ApplicationMetricCredential(Type):
    _toSchema = {'application': 'application', 'metrics_credentials': 'metrics-credentials'}
    _toPy = {'application': 'application', 'metrics-credentials': 'metrics_credentials'}
    def __init__(self, application=None, metrics_credentials=None, **unknown_fields):
        '''
        application : str
        metrics_credentials : typing.Sequence[int]
        '''
        application_ = application
        metrics_credentials_ = metrics_credentials

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if metrics_credentials_ is not None and not isinstance(metrics_credentials_, (bytes, str, list)):
            raise Exception("Expected metrics_credentials_ to be a Sequence, received: {}".format(type(metrics_credentials_)))

        self.application = application_
        self.metrics_credentials = metrics_credentials_
        self.unknown_fields = unknown_fields



class ApplicationMetricCredentials(Type):
    _toSchema = {'creds': 'creds'}
    _toPy = {'creds': 'creds'}
    def __init__(self, creds=None, **unknown_fields):
        '''
        creds : typing.Sequence[~ApplicationMetricCredential]
        '''
        creds_ = [ApplicationMetricCredential.from_json(o) for o in creds or []]

        # Validate arguments against known Juju API types.
        if creds_ is not None and not isinstance(creds_, (bytes, str, list)):
            raise Exception("Expected creds_ to be a Sequence, received: {}".format(type(creds_)))

        self.creds = creds_
        self.unknown_fields = unknown_fields



class ApplicationOffer(Type):
    _toSchema = {'access': 'access', 'application_description': 'application-description', 'bindings': 'bindings', 'endpoints': 'endpoints', 'offer_name': 'offer-name', 'offer_url': 'offer-url', 'source_model_tag': 'source-model-tag', 'spaces': 'spaces'}
    _toPy = {'access': 'access', 'application-description': 'application_description', 'bindings': 'bindings', 'endpoints': 'endpoints', 'offer-name': 'offer_name', 'offer-url': 'offer_url', 'source-model-tag': 'source_model_tag', 'spaces': 'spaces'}
    def __init__(self, access=None, application_description=None, bindings=None, endpoints=None, offer_name=None, offer_url=None, source_model_tag=None, spaces=None, **unknown_fields):
        '''
        access : str
        application_description : str
        bindings : typing.Mapping[str, str]
        endpoints : typing.Sequence[~RemoteEndpoint]
        offer_name : str
        offer_url : str
        source_model_tag : str
        spaces : typing.Sequence[~RemoteSpace]
        '''
        access_ = access
        application_description_ = application_description
        bindings_ = bindings
        endpoints_ = [RemoteEndpoint.from_json(o) for o in endpoints or []]
        offer_name_ = offer_name
        offer_url_ = offer_url
        source_model_tag_ = source_model_tag
        spaces_ = [RemoteSpace.from_json(o) for o in spaces or []]

        # Validate arguments against known Juju API types.
        if access_ is not None and not isinstance(access_, (bytes, str)):
            raise Exception("Expected access_ to be a str, received: {}".format(type(access_)))

        if application_description_ is not None and not isinstance(application_description_, (bytes, str)):
            raise Exception("Expected application_description_ to be a str, received: {}".format(type(application_description_)))

        if bindings_ is not None and not isinstance(bindings_, dict):
            raise Exception("Expected bindings_ to be a Mapping, received: {}".format(type(bindings_)))

        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if offer_name_ is not None and not isinstance(offer_name_, (bytes, str)):
            raise Exception("Expected offer_name_ to be a str, received: {}".format(type(offer_name_)))

        if offer_url_ is not None and not isinstance(offer_url_, (bytes, str)):
            raise Exception("Expected offer_url_ to be a str, received: {}".format(type(offer_url_)))

        if source_model_tag_ is not None and not isinstance(source_model_tag_, (bytes, str)):
            raise Exception("Expected source_model_tag_ to be a str, received: {}".format(type(source_model_tag_)))

        if spaces_ is not None and not isinstance(spaces_, (bytes, str, list)):
            raise Exception("Expected spaces_ to be a Sequence, received: {}".format(type(spaces_)))

        self.access = access_
        self.application_description = application_description_
        self.bindings = bindings_
        self.endpoints = endpoints_
        self.offer_name = offer_name_
        self.offer_url = offer_url_
        self.source_model_tag = source_model_tag_
        self.spaces = spaces_
        self.unknown_fields = unknown_fields



class ApplicationOfferAdminDetails(Type):
    _toSchema = {'application_description': 'application-description', 'application_name': 'application-name', 'applicationofferdetails': 'ApplicationOfferDetails', 'bindings': 'bindings', 'charm_url': 'charm-url', 'connections': 'connections', 'endpoints': 'endpoints', 'offer_name': 'offer-name', 'offer_url': 'offer-url', 'offer_uuid': 'offer-uuid', 'source_model_tag': 'source-model-tag', 'spaces': 'spaces', 'users': 'users'}
    _toPy = {'ApplicationOfferDetails': 'applicationofferdetails', 'application-description': 'application_description', 'application-name': 'application_name', 'bindings': 'bindings', 'charm-url': 'charm_url', 'connections': 'connections', 'endpoints': 'endpoints', 'offer-name': 'offer_name', 'offer-url': 'offer_url', 'offer-uuid': 'offer_uuid', 'source-model-tag': 'source_model_tag', 'spaces': 'spaces', 'users': 'users'}
    def __init__(self, applicationofferdetails=None, application_description=None, application_name=None, bindings=None, charm_url=None, connections=None, endpoints=None, offer_name=None, offer_url=None, offer_uuid=None, source_model_tag=None, spaces=None, users=None, **unknown_fields):
        '''
        applicationofferdetails : ApplicationOfferDetails
        application_description : str
        application_name : str
        bindings : typing.Mapping[str, str]
        charm_url : str
        connections : typing.Sequence[~OfferConnection]
        endpoints : typing.Sequence[~RemoteEndpoint]
        offer_name : str
        offer_url : str
        offer_uuid : str
        source_model_tag : str
        spaces : typing.Sequence[~RemoteSpace]
        users : typing.Sequence[~OfferUserDetails]
        '''
        applicationofferdetails_ = ApplicationOfferDetails.from_json(applicationofferdetails) if applicationofferdetails else None
        application_description_ = application_description
        application_name_ = application_name
        bindings_ = bindings
        charm_url_ = charm_url
        connections_ = [OfferConnection.from_json(o) for o in connections or []]
        endpoints_ = [RemoteEndpoint.from_json(o) for o in endpoints or []]
        offer_name_ = offer_name
        offer_url_ = offer_url
        offer_uuid_ = offer_uuid
        source_model_tag_ = source_model_tag
        spaces_ = [RemoteSpace.from_json(o) for o in spaces or []]
        users_ = [OfferUserDetails.from_json(o) for o in users or []]

        # Validate arguments against known Juju API types.
        if applicationofferdetails_ is not None and not isinstance(applicationofferdetails_, (dict, ApplicationOfferDetails)):
            raise Exception("Expected applicationofferdetails_ to be a ApplicationOfferDetails, received: {}".format(type(applicationofferdetails_)))

        if application_description_ is not None and not isinstance(application_description_, (bytes, str)):
            raise Exception("Expected application_description_ to be a str, received: {}".format(type(application_description_)))

        if application_name_ is not None and not isinstance(application_name_, (bytes, str)):
            raise Exception("Expected application_name_ to be a str, received: {}".format(type(application_name_)))

        if bindings_ is not None and not isinstance(bindings_, dict):
            raise Exception("Expected bindings_ to be a Mapping, received: {}".format(type(bindings_)))

        if charm_url_ is not None and not isinstance(charm_url_, (bytes, str)):
            raise Exception("Expected charm_url_ to be a str, received: {}".format(type(charm_url_)))

        if connections_ is not None and not isinstance(connections_, (bytes, str, list)):
            raise Exception("Expected connections_ to be a Sequence, received: {}".format(type(connections_)))

        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if offer_name_ is not None and not isinstance(offer_name_, (bytes, str)):
            raise Exception("Expected offer_name_ to be a str, received: {}".format(type(offer_name_)))

        if offer_url_ is not None and not isinstance(offer_url_, (bytes, str)):
            raise Exception("Expected offer_url_ to be a str, received: {}".format(type(offer_url_)))

        if offer_uuid_ is not None and not isinstance(offer_uuid_, (bytes, str)):
            raise Exception("Expected offer_uuid_ to be a str, received: {}".format(type(offer_uuid_)))

        if source_model_tag_ is not None and not isinstance(source_model_tag_, (bytes, str)):
            raise Exception("Expected source_model_tag_ to be a str, received: {}".format(type(source_model_tag_)))

        if spaces_ is not None and not isinstance(spaces_, (bytes, str, list)):
            raise Exception("Expected spaces_ to be a Sequence, received: {}".format(type(spaces_)))

        if users_ is not None and not isinstance(users_, (bytes, str, list)):
            raise Exception("Expected users_ to be a Sequence, received: {}".format(type(users_)))

        self.applicationofferdetails = applicationofferdetails_
        self.application_description = application_description_
        self.application_name = application_name_
        self.bindings = bindings_
        self.charm_url = charm_url_
        self.connections = connections_
        self.endpoints = endpoints_
        self.offer_name = offer_name_
        self.offer_url = offer_url_
        self.offer_uuid = offer_uuid_
        self.source_model_tag = source_model_tag_
        self.spaces = spaces_
        self.users = users_
        self.unknown_fields = unknown_fields



class ApplicationOfferDetails(Type):
    _toSchema = {'application_description': 'application-description', 'bindings': 'bindings', 'endpoints': 'endpoints', 'offer_name': 'offer-name', 'offer_url': 'offer-url', 'offer_uuid': 'offer-uuid', 'source_model_tag': 'source-model-tag', 'spaces': 'spaces', 'users': 'users'}
    _toPy = {'application-description': 'application_description', 'bindings': 'bindings', 'endpoints': 'endpoints', 'offer-name': 'offer_name', 'offer-url': 'offer_url', 'offer-uuid': 'offer_uuid', 'source-model-tag': 'source_model_tag', 'spaces': 'spaces', 'users': 'users'}
    def __init__(self, application_description=None, bindings=None, endpoints=None, offer_name=None, offer_url=None, offer_uuid=None, source_model_tag=None, spaces=None, users=None, **unknown_fields):
        '''
        application_description : str
        bindings : typing.Mapping[str, str]
        endpoints : typing.Sequence[~RemoteEndpoint]
        offer_name : str
        offer_url : str
        offer_uuid : str
        source_model_tag : str
        spaces : typing.Sequence[~RemoteSpace]
        users : typing.Sequence[~OfferUserDetails]
        '''
        application_description_ = application_description
        bindings_ = bindings
        endpoints_ = [RemoteEndpoint.from_json(o) for o in endpoints or []]
        offer_name_ = offer_name
        offer_url_ = offer_url
        offer_uuid_ = offer_uuid
        source_model_tag_ = source_model_tag
        spaces_ = [RemoteSpace.from_json(o) for o in spaces or []]
        users_ = [OfferUserDetails.from_json(o) for o in users or []]

        # Validate arguments against known Juju API types.
        if application_description_ is not None and not isinstance(application_description_, (bytes, str)):
            raise Exception("Expected application_description_ to be a str, received: {}".format(type(application_description_)))

        if bindings_ is not None and not isinstance(bindings_, dict):
            raise Exception("Expected bindings_ to be a Mapping, received: {}".format(type(bindings_)))

        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if offer_name_ is not None and not isinstance(offer_name_, (bytes, str)):
            raise Exception("Expected offer_name_ to be a str, received: {}".format(type(offer_name_)))

        if offer_url_ is not None and not isinstance(offer_url_, (bytes, str)):
            raise Exception("Expected offer_url_ to be a str, received: {}".format(type(offer_url_)))

        if offer_uuid_ is not None and not isinstance(offer_uuid_, (bytes, str)):
            raise Exception("Expected offer_uuid_ to be a str, received: {}".format(type(offer_uuid_)))

        if source_model_tag_ is not None and not isinstance(source_model_tag_, (bytes, str)):
            raise Exception("Expected source_model_tag_ to be a str, received: {}".format(type(source_model_tag_)))

        if spaces_ is not None and not isinstance(spaces_, (bytes, str, list)):
            raise Exception("Expected spaces_ to be a Sequence, received: {}".format(type(spaces_)))

        if users_ is not None and not isinstance(users_, (bytes, str, list)):
            raise Exception("Expected users_ to be a Sequence, received: {}".format(type(users_)))

        self.application_description = application_description_
        self.bindings = bindings_
        self.endpoints = endpoints_
        self.offer_name = offer_name_
        self.offer_url = offer_url_
        self.offer_uuid = offer_uuid_
        self.source_model_tag = source_model_tag_
        self.spaces = spaces_
        self.users = users_
        self.unknown_fields = unknown_fields



class ApplicationOfferResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ApplicationOfferAdminDetails
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ApplicationOfferAdminDetails.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ApplicationOfferAdminDetails)):
            raise Exception("Expected result_ to be a ApplicationOfferAdminDetails, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ApplicationOfferStatus(Type):
    _toSchema = {'active_connected_count': 'active-connected-count', 'application_name': 'application-name', 'charm': 'charm', 'endpoints': 'endpoints', 'err': 'err', 'offer_name': 'offer-name', 'total_connected_count': 'total-connected-count'}
    _toPy = {'active-connected-count': 'active_connected_count', 'application-name': 'application_name', 'charm': 'charm', 'endpoints': 'endpoints', 'err': 'err', 'offer-name': 'offer_name', 'total-connected-count': 'total_connected_count'}
    def __init__(self, active_connected_count=None, application_name=None, charm=None, endpoints=None, err=None, offer_name=None, total_connected_count=None, **unknown_fields):
        '''
        active_connected_count : int
        application_name : str
        charm : str
        endpoints : typing.Mapping[str, ~RemoteEndpoint]
        err : Error
        offer_name : str
        total_connected_count : int
        '''
        active_connected_count_ = active_connected_count
        application_name_ = application_name
        charm_ = charm
        endpoints_ = {k: RemoteEndpoint.from_json(v) for k, v in (endpoints or dict()).items()}
        err_ = Error.from_json(err) if err else None
        offer_name_ = offer_name
        total_connected_count_ = total_connected_count

        # Validate arguments against known Juju API types.
        if active_connected_count_ is not None and not isinstance(active_connected_count_, int):
            raise Exception("Expected active_connected_count_ to be a int, received: {}".format(type(active_connected_count_)))

        if application_name_ is not None and not isinstance(application_name_, (bytes, str)):
            raise Exception("Expected application_name_ to be a str, received: {}".format(type(application_name_)))

        if charm_ is not None and not isinstance(charm_, (bytes, str)):
            raise Exception("Expected charm_ to be a str, received: {}".format(type(charm_)))

        if endpoints_ is not None and not isinstance(endpoints_, dict):
            raise Exception("Expected endpoints_ to be a Mapping, received: {}".format(type(endpoints_)))

        if err_ is not None and not isinstance(err_, (dict, Error)):
            raise Exception("Expected err_ to be a Error, received: {}".format(type(err_)))

        if offer_name_ is not None and not isinstance(offer_name_, (bytes, str)):
            raise Exception("Expected offer_name_ to be a str, received: {}".format(type(offer_name_)))

        if total_connected_count_ is not None and not isinstance(total_connected_count_, int):
            raise Exception("Expected total_connected_count_ to be a int, received: {}".format(type(total_connected_count_)))

        self.active_connected_count = active_connected_count_
        self.application_name = application_name_
        self.charm = charm_
        self.endpoints = endpoints_
        self.err = err_
        self.offer_name = offer_name_
        self.total_connected_count = total_connected_count_
        self.unknown_fields = unknown_fields



class ApplicationOffersResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ApplicationOfferResult]
        '''
        results_ = [ApplicationOfferResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ApplicationRelationsChange(Type):
    _toSchema = {'changed': 'changed', 'removed': 'removed'}
    _toPy = {'changed': 'changed', 'removed': 'removed'}
    def __init__(self, changed=None, removed=None, **unknown_fields):
        '''
        changed : typing.Sequence[~RelationChange]
        removed : typing.Sequence[int]
        '''
        changed_ = [RelationChange.from_json(o) for o in changed or []]
        removed_ = removed

        # Validate arguments against known Juju API types.
        if changed_ is not None and not isinstance(changed_, (bytes, str, list)):
            raise Exception("Expected changed_ to be a Sequence, received: {}".format(type(changed_)))

        if removed_ is not None and not isinstance(removed_, (bytes, str, list)):
            raise Exception("Expected removed_ to be a Sequence, received: {}".format(type(removed_)))

        self.changed = changed_
        self.removed = removed_
        self.unknown_fields = unknown_fields



class ApplicationRelationsWatchResult(Type):
    _toSchema = {'applicationrelationswatcherid': 'ApplicationRelationsWatcherId', 'changes': 'changes', 'error': 'error'}
    _toPy = {'ApplicationRelationsWatcherId': 'applicationrelationswatcherid', 'changes': 'changes', 'error': 'error'}
    def __init__(self, applicationrelationswatcherid=None, changes=None, error=None, **unknown_fields):
        '''
        applicationrelationswatcherid : str
        changes : ApplicationRelationsChange
        error : Error
        '''
        applicationrelationswatcherid_ = applicationrelationswatcherid
        changes_ = ApplicationRelationsChange.from_json(changes) if changes else None
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if applicationrelationswatcherid_ is not None and not isinstance(applicationrelationswatcherid_, (bytes, str)):
            raise Exception("Expected applicationrelationswatcherid_ to be a str, received: {}".format(type(applicationrelationswatcherid_)))

        if changes_ is not None and not isinstance(changes_, (dict, ApplicationRelationsChange)):
            raise Exception("Expected changes_ to be a ApplicationRelationsChange, received: {}".format(type(changes_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.applicationrelationswatcherid = applicationrelationswatcherid_
        self.changes = changes_
        self.error = error_
        self.unknown_fields = unknown_fields



class ApplicationResult(Type):
    _toSchema = {'channel': 'channel', 'charm': 'charm', 'constraints': 'constraints', 'endpoint_bindings': 'endpoint-bindings', 'exposed': 'exposed', 'principal': 'principal', 'remote': 'remote', 'series': 'series', 'tag': 'tag'}
    _toPy = {'channel': 'channel', 'charm': 'charm', 'constraints': 'constraints', 'endpoint-bindings': 'endpoint_bindings', 'exposed': 'exposed', 'principal': 'principal', 'remote': 'remote', 'series': 'series', 'tag': 'tag'}
    def __init__(self, channel=None, charm=None, constraints=None, endpoint_bindings=None, exposed=None, principal=None, remote=None, series=None, tag=None, **unknown_fields):
        '''
        channel : str
        charm : str
        constraints : Value
        endpoint_bindings : typing.Mapping[str, str]
        exposed : bool
        principal : bool
        remote : bool
        series : str
        tag : str
        '''
        channel_ = channel
        charm_ = charm
        constraints_ = Value.from_json(constraints) if constraints else None
        endpoint_bindings_ = endpoint_bindings
        exposed_ = exposed
        principal_ = principal
        remote_ = remote
        series_ = series
        tag_ = tag

        # Validate arguments against known Juju API types.
        if channel_ is not None and not isinstance(channel_, (bytes, str)):
            raise Exception("Expected channel_ to be a str, received: {}".format(type(channel_)))

        if charm_ is not None and not isinstance(charm_, (bytes, str)):
            raise Exception("Expected charm_ to be a str, received: {}".format(type(charm_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if endpoint_bindings_ is not None and not isinstance(endpoint_bindings_, dict):
            raise Exception("Expected endpoint_bindings_ to be a Mapping, received: {}".format(type(endpoint_bindings_)))

        if exposed_ is not None and not isinstance(exposed_, bool):
            raise Exception("Expected exposed_ to be a bool, received: {}".format(type(exposed_)))

        if principal_ is not None and not isinstance(principal_, bool):
            raise Exception("Expected principal_ to be a bool, received: {}".format(type(principal_)))

        if remote_ is not None and not isinstance(remote_, bool):
            raise Exception("Expected remote_ to be a bool, received: {}".format(type(remote_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.channel = channel_
        self.charm = charm_
        self.constraints = constraints_
        self.endpoint_bindings = endpoint_bindings_
        self.exposed = exposed_
        self.principal = principal_
        self.remote = remote_
        self.series = series_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class ApplicationSet(Type):
    _toSchema = {'application': 'application', 'branch': 'branch', 'options': 'options'}
    _toPy = {'application': 'application', 'branch': 'branch', 'options': 'options'}
    def __init__(self, application=None, branch=None, options=None, **unknown_fields):
        '''
        application : str
        branch : str
        options : typing.Mapping[str, str]
        '''
        application_ = application
        branch_ = branch
        options_ = options

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if branch_ is not None and not isinstance(branch_, (bytes, str)):
            raise Exception("Expected branch_ to be a str, received: {}".format(type(branch_)))

        if options_ is not None and not isinstance(options_, dict):
            raise Exception("Expected options_ to be a Mapping, received: {}".format(type(options_)))

        self.application = application_
        self.branch = branch_
        self.options = options_
        self.unknown_fields = unknown_fields



class ApplicationSetCharm(Type):
    _toSchema = {'application': 'application', 'channel': 'channel', 'charm_url': 'charm-url', 'config_settings': 'config-settings', 'config_settings_yaml': 'config-settings-yaml', 'endpoint_bindings': 'endpoint-bindings', 'force': 'force', 'force_series': 'force-series', 'force_units': 'force-units', 'generation': 'generation', 'resource_ids': 'resource-ids', 'storage_constraints': 'storage-constraints'}
    _toPy = {'application': 'application', 'channel': 'channel', 'charm-url': 'charm_url', 'config-settings': 'config_settings', 'config-settings-yaml': 'config_settings_yaml', 'endpoint-bindings': 'endpoint_bindings', 'force': 'force', 'force-series': 'force_series', 'force-units': 'force_units', 'generation': 'generation', 'resource-ids': 'resource_ids', 'storage-constraints': 'storage_constraints'}
    def __init__(self, application=None, channel=None, charm_url=None, config_settings=None, config_settings_yaml=None, endpoint_bindings=None, force=None, force_series=None, force_units=None, generation=None, resource_ids=None, storage_constraints=None, **unknown_fields):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping[str, str]
        config_settings_yaml : str
        endpoint_bindings : typing.Mapping[str, str]
        force : bool
        force_series : bool
        force_units : bool
        generation : str
        resource_ids : typing.Mapping[str, str]
        storage_constraints : typing.Mapping[str, ~StorageConstraints]
        '''
        application_ = application
        channel_ = channel
        charm_url_ = charm_url
        config_settings_ = config_settings
        config_settings_yaml_ = config_settings_yaml
        endpoint_bindings_ = endpoint_bindings
        force_ = force
        force_series_ = force_series
        force_units_ = force_units
        generation_ = generation
        resource_ids_ = resource_ids
        storage_constraints_ = {k: StorageConstraints.from_json(v) for k, v in (storage_constraints or dict()).items()}

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if channel_ is not None and not isinstance(channel_, (bytes, str)):
            raise Exception("Expected channel_ to be a str, received: {}".format(type(channel_)))

        if charm_url_ is not None and not isinstance(charm_url_, (bytes, str)):
            raise Exception("Expected charm_url_ to be a str, received: {}".format(type(charm_url_)))

        if config_settings_ is not None and not isinstance(config_settings_, dict):
            raise Exception("Expected config_settings_ to be a Mapping, received: {}".format(type(config_settings_)))

        if config_settings_yaml_ is not None and not isinstance(config_settings_yaml_, (bytes, str)):
            raise Exception("Expected config_settings_yaml_ to be a str, received: {}".format(type(config_settings_yaml_)))

        if endpoint_bindings_ is not None and not isinstance(endpoint_bindings_, dict):
            raise Exception("Expected endpoint_bindings_ to be a Mapping, received: {}".format(type(endpoint_bindings_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if force_series_ is not None and not isinstance(force_series_, bool):
            raise Exception("Expected force_series_ to be a bool, received: {}".format(type(force_series_)))

        if force_units_ is not None and not isinstance(force_units_, bool):
            raise Exception("Expected force_units_ to be a bool, received: {}".format(type(force_units_)))

        if generation_ is not None and not isinstance(generation_, (bytes, str)):
            raise Exception("Expected generation_ to be a str, received: {}".format(type(generation_)))

        if resource_ids_ is not None and not isinstance(resource_ids_, dict):
            raise Exception("Expected resource_ids_ to be a Mapping, received: {}".format(type(resource_ids_)))

        if storage_constraints_ is not None and not isinstance(storage_constraints_, dict):
            raise Exception("Expected storage_constraints_ to be a Mapping, received: {}".format(type(storage_constraints_)))

        self.application = application_
        self.channel = channel_
        self.charm_url = charm_url_
        self.config_settings = config_settings_
        self.config_settings_yaml = config_settings_yaml_
        self.endpoint_bindings = endpoint_bindings_
        self.force = force_
        self.force_series = force_series_
        self.force_units = force_units_
        self.generation = generation_
        self.resource_ids = resource_ids_
        self.storage_constraints = storage_constraints_
        self.unknown_fields = unknown_fields



class ApplicationSetCharmProfile(Type):
    _toSchema = {'application': 'application', 'charm_url': 'charm-url'}
    _toPy = {'application': 'application', 'charm-url': 'charm_url'}
    def __init__(self, application=None, charm_url=None, **unknown_fields):
        '''
        application : str
        charm_url : str
        '''
        application_ = application
        charm_url_ = charm_url

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if charm_url_ is not None and not isinstance(charm_url_, (bytes, str)):
            raise Exception("Expected charm_url_ to be a str, received: {}".format(type(charm_url_)))

        self.application = application_
        self.charm_url = charm_url_
        self.unknown_fields = unknown_fields



class ApplicationStatus(Type):
    _toSchema = {'can_upgrade_to': 'can-upgrade-to', 'charm': 'charm', 'charm_profile': 'charm-profile', 'charm_version': 'charm-version', 'endpoint_bindings': 'endpoint-bindings', 'err': 'err', 'exposed': 'exposed', 'int_': 'int', 'life': 'life', 'meter_statuses': 'meter-statuses', 'provider_id': 'provider-id', 'public_address': 'public-address', 'relations': 'relations', 'series': 'series', 'status': 'status', 'subordinate_to': 'subordinate-to', 'units': 'units', 'workload_version': 'workload-version'}
    _toPy = {'can-upgrade-to': 'can_upgrade_to', 'charm': 'charm', 'charm-profile': 'charm_profile', 'charm-version': 'charm_version', 'endpoint-bindings': 'endpoint_bindings', 'err': 'err', 'exposed': 'exposed', 'int': 'int_', 'life': 'life', 'meter-statuses': 'meter_statuses', 'provider-id': 'provider_id', 'public-address': 'public_address', 'relations': 'relations', 'series': 'series', 'status': 'status', 'subordinate-to': 'subordinate_to', 'units': 'units', 'workload-version': 'workload_version'}
    def __init__(self, can_upgrade_to=None, charm=None, charm_profile=None, charm_version=None, endpoint_bindings=None, err=None, exposed=None, int_=None, life=None, meter_statuses=None, provider_id=None, public_address=None, relations=None, series=None, status=None, subordinate_to=None, units=None, workload_version=None, **unknown_fields):
        '''
        can_upgrade_to : str
        charm : str
        charm_profile : str
        charm_version : str
        endpoint_bindings : typing.Mapping[str, str]
        err : Error
        exposed : bool
        int_ : int
        life : str
        meter_statuses : typing.Mapping[str, ~MeterStatus]
        provider_id : str
        public_address : str
        relations : typing.Mapping[str, typing.Sequence[str]]
        series : str
        status : DetailedStatus
        subordinate_to : typing.Sequence[str]
        units : typing.Mapping[str, ~UnitStatus]
        workload_version : str
        '''
        can_upgrade_to_ = can_upgrade_to
        charm_ = charm
        charm_profile_ = charm_profile
        charm_version_ = charm_version
        endpoint_bindings_ = endpoint_bindings
        err_ = Error.from_json(err) if err else None
        exposed_ = exposed
        int__ = int_
        life_ = life
        meter_statuses_ = {k: MeterStatus.from_json(v) for k, v in (meter_statuses or dict()).items()}
        provider_id_ = provider_id
        public_address_ = public_address
        relations_ = relations
        series_ = series
        status_ = DetailedStatus.from_json(status) if status else None
        subordinate_to_ = subordinate_to
        units_ = {k: UnitStatus.from_json(v) for k, v in (units or dict()).items()}
        workload_version_ = workload_version

        # Validate arguments against known Juju API types.
        if can_upgrade_to_ is not None and not isinstance(can_upgrade_to_, (bytes, str)):
            raise Exception("Expected can_upgrade_to_ to be a str, received: {}".format(type(can_upgrade_to_)))

        if charm_ is not None and not isinstance(charm_, (bytes, str)):
            raise Exception("Expected charm_ to be a str, received: {}".format(type(charm_)))

        if charm_profile_ is not None and not isinstance(charm_profile_, (bytes, str)):
            raise Exception("Expected charm_profile_ to be a str, received: {}".format(type(charm_profile_)))

        if charm_version_ is not None and not isinstance(charm_version_, (bytes, str)):
            raise Exception("Expected charm_version_ to be a str, received: {}".format(type(charm_version_)))

        if endpoint_bindings_ is not None and not isinstance(endpoint_bindings_, dict):
            raise Exception("Expected endpoint_bindings_ to be a Mapping, received: {}".format(type(endpoint_bindings_)))

        if err_ is not None and not isinstance(err_, (dict, Error)):
            raise Exception("Expected err_ to be a Error, received: {}".format(type(err_)))

        if exposed_ is not None and not isinstance(exposed_, bool):
            raise Exception("Expected exposed_ to be a bool, received: {}".format(type(exposed_)))

        if int__ is not None and not isinstance(int__, int):
            raise Exception("Expected int__ to be a int, received: {}".format(type(int__)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if meter_statuses_ is not None and not isinstance(meter_statuses_, dict):
            raise Exception("Expected meter_statuses_ to be a Mapping, received: {}".format(type(meter_statuses_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if public_address_ is not None and not isinstance(public_address_, (bytes, str)):
            raise Exception("Expected public_address_ to be a str, received: {}".format(type(public_address_)))

        if relations_ is not None and not isinstance(relations_, dict):
            raise Exception("Expected relations_ to be a Mapping, received: {}".format(type(relations_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if status_ is not None and not isinstance(status_, (dict, DetailedStatus)):
            raise Exception("Expected status_ to be a DetailedStatus, received: {}".format(type(status_)))

        if subordinate_to_ is not None and not isinstance(subordinate_to_, (bytes, str, list)):
            raise Exception("Expected subordinate_to_ to be a Sequence, received: {}".format(type(subordinate_to_)))

        if units_ is not None and not isinstance(units_, dict):
            raise Exception("Expected units_ to be a Mapping, received: {}".format(type(units_)))

        if workload_version_ is not None and not isinstance(workload_version_, (bytes, str)):
            raise Exception("Expected workload_version_ to be a str, received: {}".format(type(workload_version_)))

        self.can_upgrade_to = can_upgrade_to_
        self.charm = charm_
        self.charm_profile = charm_profile_
        self.charm_version = charm_version_
        self.endpoint_bindings = endpoint_bindings_
        self.err = err_
        self.exposed = exposed_
        self.int_ = int__
        self.life = life_
        self.meter_statuses = meter_statuses_
        self.provider_id = provider_id_
        self.public_address = public_address_
        self.relations = relations_
        self.series = series_
        self.status = status_
        self.subordinate_to = subordinate_to_
        self.units = units_
        self.workload_version = workload_version_
        self.unknown_fields = unknown_fields



class ApplicationStatusResult(Type):
    _toSchema = {'application': 'application', 'error': 'error', 'units': 'units'}
    _toPy = {'application': 'application', 'error': 'error', 'units': 'units'}
    def __init__(self, application=None, error=None, units=None, **unknown_fields):
        '''
        application : StatusResult
        error : Error
        units : typing.Mapping[str, ~StatusResult]
        '''
        application_ = StatusResult.from_json(application) if application else None
        error_ = Error.from_json(error) if error else None
        units_ = {k: StatusResult.from_json(v) for k, v in (units or dict()).items()}

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (dict, StatusResult)):
            raise Exception("Expected application_ to be a StatusResult, received: {}".format(type(application_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if units_ is not None and not isinstance(units_, dict):
            raise Exception("Expected units_ to be a Mapping, received: {}".format(type(units_)))

        self.application = application_
        self.error = error_
        self.units = units_
        self.unknown_fields = unknown_fields



class ApplicationStatusResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ApplicationStatusResult]
        '''
        results_ = [ApplicationStatusResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ApplicationTag(Type):
    _toSchema = {'name': 'Name'}
    _toPy = {'Name': 'name'}
    def __init__(self, name=None, **unknown_fields):
        '''
        name : str
        '''
        name_ = name

        # Validate arguments against known Juju API types.
        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        self.name = name_
        self.unknown_fields = unknown_fields



class ApplicationURLs(Type):
    _toSchema = {'application_urls': 'application-urls'}
    _toPy = {'application-urls': 'application_urls'}
    def __init__(self, application_urls=None, **unknown_fields):
        '''
        application_urls : typing.Sequence[str]
        '''
        application_urls_ = application_urls

        # Validate arguments against known Juju API types.
        if application_urls_ is not None and not isinstance(application_urls_, (bytes, str, list)):
            raise Exception("Expected application_urls_ to be a Sequence, received: {}".format(type(application_urls_)))

        self.application_urls = application_urls_
        self.unknown_fields = unknown_fields



class ApplicationUnexpose(Type):
    _toSchema = {'application': 'application'}
    _toPy = {'application': 'application'}
    def __init__(self, application=None, **unknown_fields):
        '''
        application : str
        '''
        application_ = application

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        self.application = application_
        self.unknown_fields = unknown_fields



class ApplicationUnitInfo(Type):
    _toSchema = {'provider_id': 'provider-id', 'unit_tag': 'unit-tag'}
    _toPy = {'provider-id': 'provider_id', 'unit-tag': 'unit_tag'}
    def __init__(self, provider_id=None, unit_tag=None, **unknown_fields):
        '''
        provider_id : str
        unit_tag : str
        '''
        provider_id_ = provider_id
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.provider_id = provider_id_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class ApplicationUnitParams(Type):
    _toSchema = {'address': 'address', 'data': 'data', 'filesystem_info': 'filesystem-info', 'info': 'info', 'ports': 'ports', 'provider_id': 'provider-id', 'stateful': 'stateful', 'status': 'status', 'unit_tag': 'unit-tag'}
    _toPy = {'address': 'address', 'data': 'data', 'filesystem-info': 'filesystem_info', 'info': 'info', 'ports': 'ports', 'provider-id': 'provider_id', 'stateful': 'stateful', 'status': 'status', 'unit-tag': 'unit_tag'}
    def __init__(self, address=None, data=None, filesystem_info=None, info=None, ports=None, provider_id=None, stateful=None, status=None, unit_tag=None, **unknown_fields):
        '''
        address : str
        data : typing.Mapping[str, typing.Any]
        filesystem_info : typing.Sequence[~KubernetesFilesystemInfo]
        info : str
        ports : typing.Sequence[str]
        provider_id : str
        stateful : bool
        status : str
        unit_tag : str
        '''
        address_ = address
        data_ = data
        filesystem_info_ = [KubernetesFilesystemInfo.from_json(o) for o in filesystem_info or []]
        info_ = info
        ports_ = ports
        provider_id_ = provider_id
        stateful_ = stateful
        status_ = status
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if address_ is not None and not isinstance(address_, (bytes, str)):
            raise Exception("Expected address_ to be a str, received: {}".format(type(address_)))

        if data_ is not None and not isinstance(data_, dict):
            raise Exception("Expected data_ to be a Mapping, received: {}".format(type(data_)))

        if filesystem_info_ is not None and not isinstance(filesystem_info_, (bytes, str, list)):
            raise Exception("Expected filesystem_info_ to be a Sequence, received: {}".format(type(filesystem_info_)))

        if info_ is not None and not isinstance(info_, (bytes, str)):
            raise Exception("Expected info_ to be a str, received: {}".format(type(info_)))

        if ports_ is not None and not isinstance(ports_, (bytes, str, list)):
            raise Exception("Expected ports_ to be a Sequence, received: {}".format(type(ports_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if stateful_ is not None and not isinstance(stateful_, bool):
            raise Exception("Expected stateful_ to be a bool, received: {}".format(type(stateful_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.address = address_
        self.data = data_
        self.filesystem_info = filesystem_info_
        self.info = info_
        self.ports = ports_
        self.provider_id = provider_id_
        self.stateful = stateful_
        self.status = status_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class ApplicationUnset(Type):
    _toSchema = {'application': 'application', 'branch': 'branch', 'options': 'options'}
    _toPy = {'application': 'application', 'branch': 'branch', 'options': 'options'}
    def __init__(self, application=None, branch=None, options=None, **unknown_fields):
        '''
        application : str
        branch : str
        options : typing.Sequence[str]
        '''
        application_ = application
        branch_ = branch
        options_ = options

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if branch_ is not None and not isinstance(branch_, (bytes, str)):
            raise Exception("Expected branch_ to be a str, received: {}".format(type(branch_)))

        if options_ is not None and not isinstance(options_, (bytes, str, list)):
            raise Exception("Expected options_ to be a Sequence, received: {}".format(type(options_)))

        self.application = application_
        self.branch = branch_
        self.options = options_
        self.unknown_fields = unknown_fields



class ApplicationUpdate(Type):
    _toSchema = {'application': 'application', 'charm_url': 'charm-url', 'constraints': 'constraints', 'force': 'force', 'force_charm_url': 'force-charm-url', 'force_series': 'force-series', 'generation': 'generation', 'min_units': 'min-units', 'settings': 'settings', 'settings_yaml': 'settings-yaml'}
    _toPy = {'application': 'application', 'charm-url': 'charm_url', 'constraints': 'constraints', 'force': 'force', 'force-charm-url': 'force_charm_url', 'force-series': 'force_series', 'generation': 'generation', 'min-units': 'min_units', 'settings': 'settings', 'settings-yaml': 'settings_yaml'}
    def __init__(self, application=None, charm_url=None, constraints=None, force=None, force_charm_url=None, force_series=None, generation=None, min_units=None, settings=None, settings_yaml=None, **unknown_fields):
        '''
        application : str
        charm_url : str
        constraints : Value
        force : bool
        force_charm_url : bool
        force_series : bool
        generation : str
        min_units : int
        settings : typing.Mapping[str, str]
        settings_yaml : str
        '''
        application_ = application
        charm_url_ = charm_url
        constraints_ = Value.from_json(constraints) if constraints else None
        force_ = force
        force_charm_url_ = force_charm_url
        force_series_ = force_series
        generation_ = generation
        min_units_ = min_units
        settings_ = settings
        settings_yaml_ = settings_yaml

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if charm_url_ is not None and not isinstance(charm_url_, (bytes, str)):
            raise Exception("Expected charm_url_ to be a str, received: {}".format(type(charm_url_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if force_charm_url_ is not None and not isinstance(force_charm_url_, bool):
            raise Exception("Expected force_charm_url_ to be a bool, received: {}".format(type(force_charm_url_)))

        if force_series_ is not None and not isinstance(force_series_, bool):
            raise Exception("Expected force_series_ to be a bool, received: {}".format(type(force_series_)))

        if generation_ is not None and not isinstance(generation_, (bytes, str)):
            raise Exception("Expected generation_ to be a str, received: {}".format(type(generation_)))

        if min_units_ is not None and not isinstance(min_units_, int):
            raise Exception("Expected min_units_ to be a int, received: {}".format(type(min_units_)))

        if settings_ is not None and not isinstance(settings_, dict):
            raise Exception("Expected settings_ to be a Mapping, received: {}".format(type(settings_)))

        if settings_yaml_ is not None and not isinstance(settings_yaml_, (bytes, str)):
            raise Exception("Expected settings_yaml_ to be a str, received: {}".format(type(settings_yaml_)))

        self.application = application_
        self.charm_url = charm_url_
        self.constraints = constraints_
        self.force = force_
        self.force_charm_url = force_charm_url_
        self.force_series = force_series_
        self.generation = generation_
        self.min_units = min_units_
        self.settings = settings_
        self.settings_yaml = settings_yaml_
        self.unknown_fields = unknown_fields



class ApplicationsCharmActionsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ApplicationCharmActionsResult]
        '''
        results_ = [ApplicationCharmActionsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ApplicationsDeploy(Type):
    _toSchema = {'applications': 'applications'}
    _toPy = {'applications': 'applications'}
    def __init__(self, applications=None, **unknown_fields):
        '''
        applications : typing.Sequence[~ApplicationDeploy]
        '''
        applications_ = [ApplicationDeploy.from_json(o) for o in applications or []]

        # Validate arguments against known Juju API types.
        if applications_ is not None and not isinstance(applications_, (bytes, str, list)):
            raise Exception("Expected applications_ to be a Sequence, received: {}".format(type(applications_)))

        self.applications = applications_
        self.unknown_fields = unknown_fields



class AuthUserInfo(Type):
    _toSchema = {'controller_access': 'controller-access', 'credentials': 'credentials', 'display_name': 'display-name', 'identity': 'identity', 'last_connection': 'last-connection', 'model_access': 'model-access'}
    _toPy = {'controller-access': 'controller_access', 'credentials': 'credentials', 'display-name': 'display_name', 'identity': 'identity', 'last-connection': 'last_connection', 'model-access': 'model_access'}
    def __init__(self, controller_access=None, credentials=None, display_name=None, identity=None, last_connection=None, model_access=None, **unknown_fields):
        '''
        controller_access : str
        credentials : str
        display_name : str
        identity : str
        last_connection : str
        model_access : str
        '''
        controller_access_ = controller_access
        credentials_ = credentials
        display_name_ = display_name
        identity_ = identity
        last_connection_ = last_connection
        model_access_ = model_access

        # Validate arguments against known Juju API types.
        if controller_access_ is not None and not isinstance(controller_access_, (bytes, str)):
            raise Exception("Expected controller_access_ to be a str, received: {}".format(type(controller_access_)))

        if credentials_ is not None and not isinstance(credentials_, (bytes, str)):
            raise Exception("Expected credentials_ to be a str, received: {}".format(type(credentials_)))

        if display_name_ is not None and not isinstance(display_name_, (bytes, str)):
            raise Exception("Expected display_name_ to be a str, received: {}".format(type(display_name_)))

        if identity_ is not None and not isinstance(identity_, (bytes, str)):
            raise Exception("Expected identity_ to be a str, received: {}".format(type(identity_)))

        if last_connection_ is not None and not isinstance(last_connection_, (bytes, str)):
            raise Exception("Expected last_connection_ to be a str, received: {}".format(type(last_connection_)))

        if model_access_ is not None and not isinstance(model_access_, (bytes, str)):
            raise Exception("Expected model_access_ to be a str, received: {}".format(type(model_access_)))

        self.controller_access = controller_access_
        self.credentials = credentials_
        self.display_name = display_name_
        self.identity = identity_
        self.last_connection = last_connection_
        self.model_access = model_access_
        self.unknown_fields = unknown_fields



class BackupsCreateArgs(Type):
    _toSchema = {'keep_copy': 'keep-copy', 'no_download': 'no-download', 'notes': 'notes'}
    _toPy = {'keep-copy': 'keep_copy', 'no-download': 'no_download', 'notes': 'notes'}
    def __init__(self, keep_copy=None, no_download=None, notes=None, **unknown_fields):
        '''
        keep_copy : bool
        no_download : bool
        notes : str
        '''
        keep_copy_ = keep_copy
        no_download_ = no_download
        notes_ = notes

        # Validate arguments against known Juju API types.
        if keep_copy_ is not None and not isinstance(keep_copy_, bool):
            raise Exception("Expected keep_copy_ to be a bool, received: {}".format(type(keep_copy_)))

        if no_download_ is not None and not isinstance(no_download_, bool):
            raise Exception("Expected no_download_ to be a bool, received: {}".format(type(no_download_)))

        if notes_ is not None and not isinstance(notes_, (bytes, str)):
            raise Exception("Expected notes_ to be a str, received: {}".format(type(notes_)))

        self.keep_copy = keep_copy_
        self.no_download = no_download_
        self.notes = notes_
        self.unknown_fields = unknown_fields



class BackupsInfoArgs(Type):
    _toSchema = {'id_': 'id'}
    _toPy = {'id': 'id_'}
    def __init__(self, id_=None, **unknown_fields):
        '''
        id_ : str
        '''
        id__ = id_

        # Validate arguments against known Juju API types.
        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        self.id_ = id__
        self.unknown_fields = unknown_fields



class BackupsListArgs(Type):
    _toSchema = {}
    _toPy = {}
    def __init__(self, **unknown_fields):
        '''

        '''
        self.unknown_fields = unknown_fields



class BackupsListResult(Type):
    _toSchema = {'list_': 'list'}
    _toPy = {'list': 'list_'}
    def __init__(self, list_=None, **unknown_fields):
        '''
        list_ : typing.Sequence[~BackupsMetadataResult]
        '''
        list__ = [BackupsMetadataResult.from_json(o) for o in list_ or []]

        # Validate arguments against known Juju API types.
        if list__ is not None and not isinstance(list__, (bytes, str, list)):
            raise Exception("Expected list__ to be a Sequence, received: {}".format(type(list__)))

        self.list_ = list__
        self.unknown_fields = unknown_fields



class BackupsMetadataResult(Type):
    _toSchema = {'ca_cert': 'ca-cert', 'ca_private_key': 'ca-private-key', 'checksum': 'checksum', 'checksum_format': 'checksum-format', 'controller_machine_id': 'controller-machine-id', 'controller_machine_inst_id': 'controller-machine-inst-id', 'controller_uuid': 'controller-uuid', 'filename': 'filename', 'finished': 'finished', 'format_version': 'format-version', 'ha_nodes': 'ha-nodes', 'hostname': 'hostname', 'id_': 'id', 'machine': 'machine', 'model': 'model', 'notes': 'notes', 'series': 'series', 'size': 'size', 'started': 'started', 'stored': 'stored', 'version': 'version'}
    _toPy = {'ca-cert': 'ca_cert', 'ca-private-key': 'ca_private_key', 'checksum': 'checksum', 'checksum-format': 'checksum_format', 'controller-machine-id': 'controller_machine_id', 'controller-machine-inst-id': 'controller_machine_inst_id', 'controller-uuid': 'controller_uuid', 'filename': 'filename', 'finished': 'finished', 'format-version': 'format_version', 'ha-nodes': 'ha_nodes', 'hostname': 'hostname', 'id': 'id_', 'machine': 'machine', 'model': 'model', 'notes': 'notes', 'series': 'series', 'size': 'size', 'started': 'started', 'stored': 'stored', 'version': 'version'}
    def __init__(self, ca_cert=None, ca_private_key=None, checksum=None, checksum_format=None, controller_machine_id=None, controller_machine_inst_id=None, controller_uuid=None, filename=None, finished=None, format_version=None, ha_nodes=None, hostname=None, id_=None, machine=None, model=None, notes=None, series=None, size=None, started=None, stored=None, version=None, **unknown_fields):
        '''
        ca_cert : str
        ca_private_key : str
        checksum : str
        checksum_format : str
        controller_machine_id : str
        controller_machine_inst_id : str
        controller_uuid : str
        filename : str
        finished : str
        format_version : int
        ha_nodes : int
        hostname : str
        id_ : str
        machine : str
        model : str
        notes : str
        series : str
        size : int
        started : str
        stored : str
        version : Number
        '''
        ca_cert_ = ca_cert
        ca_private_key_ = ca_private_key
        checksum_ = checksum
        checksum_format_ = checksum_format
        controller_machine_id_ = controller_machine_id
        controller_machine_inst_id_ = controller_machine_inst_id
        controller_uuid_ = controller_uuid
        filename_ = filename
        finished_ = finished
        format_version_ = format_version
        ha_nodes_ = ha_nodes
        hostname_ = hostname
        id__ = id_
        machine_ = machine
        model_ = model
        notes_ = notes
        series_ = series
        size_ = size
        started_ = started
        stored_ = stored
        version_ = Number.from_json(version) if version else None

        # Validate arguments against known Juju API types.
        if ca_cert_ is not None and not isinstance(ca_cert_, (bytes, str)):
            raise Exception("Expected ca_cert_ to be a str, received: {}".format(type(ca_cert_)))

        if ca_private_key_ is not None and not isinstance(ca_private_key_, (bytes, str)):
            raise Exception("Expected ca_private_key_ to be a str, received: {}".format(type(ca_private_key_)))

        if checksum_ is not None and not isinstance(checksum_, (bytes, str)):
            raise Exception("Expected checksum_ to be a str, received: {}".format(type(checksum_)))

        if checksum_format_ is not None and not isinstance(checksum_format_, (bytes, str)):
            raise Exception("Expected checksum_format_ to be a str, received: {}".format(type(checksum_format_)))

        if controller_machine_id_ is not None and not isinstance(controller_machine_id_, (bytes, str)):
            raise Exception("Expected controller_machine_id_ to be a str, received: {}".format(type(controller_machine_id_)))

        if controller_machine_inst_id_ is not None and not isinstance(controller_machine_inst_id_, (bytes, str)):
            raise Exception("Expected controller_machine_inst_id_ to be a str, received: {}".format(type(controller_machine_inst_id_)))

        if controller_uuid_ is not None and not isinstance(controller_uuid_, (bytes, str)):
            raise Exception("Expected controller_uuid_ to be a str, received: {}".format(type(controller_uuid_)))

        if filename_ is not None and not isinstance(filename_, (bytes, str)):
            raise Exception("Expected filename_ to be a str, received: {}".format(type(filename_)))

        if finished_ is not None and not isinstance(finished_, (bytes, str)):
            raise Exception("Expected finished_ to be a str, received: {}".format(type(finished_)))

        if format_version_ is not None and not isinstance(format_version_, int):
            raise Exception("Expected format_version_ to be a int, received: {}".format(type(format_version_)))

        if ha_nodes_ is not None and not isinstance(ha_nodes_, int):
            raise Exception("Expected ha_nodes_ to be a int, received: {}".format(type(ha_nodes_)))

        if hostname_ is not None and not isinstance(hostname_, (bytes, str)):
            raise Exception("Expected hostname_ to be a str, received: {}".format(type(hostname_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if machine_ is not None and not isinstance(machine_, (bytes, str)):
            raise Exception("Expected machine_ to be a str, received: {}".format(type(machine_)))

        if model_ is not None and not isinstance(model_, (bytes, str)):
            raise Exception("Expected model_ to be a str, received: {}".format(type(model_)))

        if notes_ is not None and not isinstance(notes_, (bytes, str)):
            raise Exception("Expected notes_ to be a str, received: {}".format(type(notes_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if started_ is not None and not isinstance(started_, (bytes, str)):
            raise Exception("Expected started_ to be a str, received: {}".format(type(started_)))

        if stored_ is not None and not isinstance(stored_, (bytes, str)):
            raise Exception("Expected stored_ to be a str, received: {}".format(type(stored_)))

        if version_ is not None and not isinstance(version_, (dict, Number)):
            raise Exception("Expected version_ to be a Number, received: {}".format(type(version_)))

        self.ca_cert = ca_cert_
        self.ca_private_key = ca_private_key_
        self.checksum = checksum_
        self.checksum_format = checksum_format_
        self.controller_machine_id = controller_machine_id_
        self.controller_machine_inst_id = controller_machine_inst_id_
        self.controller_uuid = controller_uuid_
        self.filename = filename_
        self.finished = finished_
        self.format_version = format_version_
        self.ha_nodes = ha_nodes_
        self.hostname = hostname_
        self.id_ = id__
        self.machine = machine_
        self.model = model_
        self.notes = notes_
        self.series = series_
        self.size = size_
        self.started = started_
        self.stored = stored_
        self.version = version_
        self.unknown_fields = unknown_fields



class BackupsRemoveArgs(Type):
    _toSchema = {'ids': 'ids'}
    _toPy = {'ids': 'ids'}
    def __init__(self, ids=None, **unknown_fields):
        '''
        ids : typing.Sequence[str]
        '''
        ids_ = ids

        # Validate arguments against known Juju API types.
        if ids_ is not None and not isinstance(ids_, (bytes, str, list)):
            raise Exception("Expected ids_ to be a Sequence, received: {}".format(type(ids_)))

        self.ids = ids_
        self.unknown_fields = unknown_fields



class Binary(Type):
    _toSchema = {'arch': 'Arch', 'build': 'Build', 'major': 'Major', 'minor': 'Minor', 'number': 'Number', 'patch': 'Patch', 'series': 'Series', 'tag': 'Tag'}
    _toPy = {'Arch': 'arch', 'Build': 'build', 'Major': 'major', 'Minor': 'minor', 'Number': 'number', 'Patch': 'patch', 'Series': 'series', 'Tag': 'tag'}
    def __init__(self, arch=None, build=None, major=None, minor=None, number=None, patch=None, series=None, tag=None, **unknown_fields):
        '''
        arch : str
        build : int
        major : int
        minor : int
        number : Number
        patch : int
        series : str
        tag : str
        '''
        arch_ = arch
        build_ = build
        major_ = major
        minor_ = minor
        number_ = Number.from_json(number) if number else None
        patch_ = patch
        series_ = series
        tag_ = tag

        # Validate arguments against known Juju API types.
        if arch_ is not None and not isinstance(arch_, (bytes, str)):
            raise Exception("Expected arch_ to be a str, received: {}".format(type(arch_)))

        if build_ is not None and not isinstance(build_, int):
            raise Exception("Expected build_ to be a int, received: {}".format(type(build_)))

        if major_ is not None and not isinstance(major_, int):
            raise Exception("Expected major_ to be a int, received: {}".format(type(major_)))

        if minor_ is not None and not isinstance(minor_, int):
            raise Exception("Expected minor_ to be a int, received: {}".format(type(minor_)))

        if number_ is not None and not isinstance(number_, (dict, Number)):
            raise Exception("Expected number_ to be a Number, received: {}".format(type(number_)))

        if patch_ is not None and not isinstance(patch_, int):
            raise Exception("Expected patch_ to be a int, received: {}".format(type(patch_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.arch = arch_
        self.build = build_
        self.major = major_
        self.minor = minor_
        self.number = number_
        self.patch = patch_
        self.series = series_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class Block(Type):
    _toSchema = {'id_': 'id', 'message': 'message', 'tag': 'tag', 'type_': 'type'}
    _toPy = {'id': 'id_', 'message': 'message', 'tag': 'tag', 'type': 'type_'}
    def __init__(self, id_=None, message=None, tag=None, type_=None, **unknown_fields):
        '''
        id_ : str
        message : str
        tag : str
        type_ : str
        '''
        id__ = id_
        message_ = message
        tag_ = tag
        type__ = type_

        # Validate arguments against known Juju API types.
        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.id_ = id__
        self.message = message_
        self.tag = tag_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class BlockDevice(Type):
    _toSchema = {'busaddress': 'BusAddress', 'devicelinks': 'DeviceLinks', 'devicename': 'DeviceName', 'filesystemtype': 'FilesystemType', 'hardwareid': 'HardwareId', 'inuse': 'InUse', 'label': 'Label', 'mountpoint': 'MountPoint', 'serialid': 'SerialId', 'size': 'Size', 'uuid': 'UUID', 'wwn': 'WWN'}
    _toPy = {'BusAddress': 'busaddress', 'DeviceLinks': 'devicelinks', 'DeviceName': 'devicename', 'FilesystemType': 'filesystemtype', 'HardwareId': 'hardwareid', 'InUse': 'inuse', 'Label': 'label', 'MountPoint': 'mountpoint', 'SerialId': 'serialid', 'Size': 'size', 'UUID': 'uuid', 'WWN': 'wwn'}
    def __init__(self, busaddress=None, devicelinks=None, devicename=None, filesystemtype=None, hardwareid=None, inuse=None, label=None, mountpoint=None, serialid=None, size=None, uuid=None, wwn=None, **unknown_fields):
        '''
        busaddress : str
        devicelinks : typing.Sequence[str]
        devicename : str
        filesystemtype : str
        hardwareid : str
        inuse : bool
        label : str
        mountpoint : str
        serialid : str
        size : int
        uuid : str
        wwn : str
        '''
        busaddress_ = busaddress
        devicelinks_ = devicelinks
        devicename_ = devicename
        filesystemtype_ = filesystemtype
        hardwareid_ = hardwareid
        inuse_ = inuse
        label_ = label
        mountpoint_ = mountpoint
        serialid_ = serialid
        size_ = size
        uuid_ = uuid
        wwn_ = wwn

        # Validate arguments against known Juju API types.
        if busaddress_ is not None and not isinstance(busaddress_, (bytes, str)):
            raise Exception("Expected busaddress_ to be a str, received: {}".format(type(busaddress_)))

        if devicelinks_ is not None and not isinstance(devicelinks_, (bytes, str, list)):
            raise Exception("Expected devicelinks_ to be a Sequence, received: {}".format(type(devicelinks_)))

        if devicename_ is not None and not isinstance(devicename_, (bytes, str)):
            raise Exception("Expected devicename_ to be a str, received: {}".format(type(devicename_)))

        if filesystemtype_ is not None and not isinstance(filesystemtype_, (bytes, str)):
            raise Exception("Expected filesystemtype_ to be a str, received: {}".format(type(filesystemtype_)))

        if hardwareid_ is not None and not isinstance(hardwareid_, (bytes, str)):
            raise Exception("Expected hardwareid_ to be a str, received: {}".format(type(hardwareid_)))

        if inuse_ is not None and not isinstance(inuse_, bool):
            raise Exception("Expected inuse_ to be a bool, received: {}".format(type(inuse_)))

        if label_ is not None and not isinstance(label_, (bytes, str)):
            raise Exception("Expected label_ to be a str, received: {}".format(type(label_)))

        if mountpoint_ is not None and not isinstance(mountpoint_, (bytes, str)):
            raise Exception("Expected mountpoint_ to be a str, received: {}".format(type(mountpoint_)))

        if serialid_ is not None and not isinstance(serialid_, (bytes, str)):
            raise Exception("Expected serialid_ to be a str, received: {}".format(type(serialid_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if uuid_ is not None and not isinstance(uuid_, (bytes, str)):
            raise Exception("Expected uuid_ to be a str, received: {}".format(type(uuid_)))

        if wwn_ is not None and not isinstance(wwn_, (bytes, str)):
            raise Exception("Expected wwn_ to be a str, received: {}".format(type(wwn_)))

        self.busaddress = busaddress_
        self.devicelinks = devicelinks_
        self.devicename = devicename_
        self.filesystemtype = filesystemtype_
        self.hardwareid = hardwareid_
        self.inuse = inuse_
        self.label = label_
        self.mountpoint = mountpoint_
        self.serialid = serialid_
        self.size = size_
        self.uuid = uuid_
        self.wwn = wwn_
        self.unknown_fields = unknown_fields



class BlockDeviceResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : BlockDevice
        '''
        error_ = Error.from_json(error) if error else None
        result_ = BlockDevice.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, BlockDevice)):
            raise Exception("Expected result_ to be a BlockDevice, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class BlockDeviceResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~BlockDeviceResult]
        '''
        results_ = [BlockDeviceResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class BlockResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : Block
        '''
        error_ = Error.from_json(error) if error else None
        result_ = Block.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, Block)):
            raise Exception("Expected result_ to be a Block, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class BlockResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~BlockResult]
        '''
        results_ = [BlockResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class BlockSwitchParams(Type):
    _toSchema = {'message': 'message', 'type_': 'type'}
    _toPy = {'message': 'message', 'type': 'type_'}
    def __init__(self, message=None, type_=None, **unknown_fields):
        '''
        message : str
        type_ : str
        '''
        message_ = message
        type__ = type_

        # Validate arguments against known Juju API types.
        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.message = message_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class BoolResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : bool
        '''
        error_ = Error.from_json(error) if error else None
        result_ = result

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, bool):
            raise Exception("Expected result_ to be a bool, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class BoolResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~BoolResult]
        '''
        results_ = [BoolResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class BranchArg(Type):
    _toSchema = {'branch': 'branch'}
    _toPy = {'branch': 'branch'}
    def __init__(self, branch=None, **unknown_fields):
        '''
        branch : str
        '''
        branch_ = branch

        # Validate arguments against known Juju API types.
        if branch_ is not None and not isinstance(branch_, (bytes, str)):
            raise Exception("Expected branch_ to be a str, received: {}".format(type(branch_)))

        self.branch = branch_
        self.unknown_fields = unknown_fields



class BranchInfoArgs(Type):
    _toSchema = {'branches': 'branches', 'detailed': 'detailed'}
    _toPy = {'branches': 'branches', 'detailed': 'detailed'}
    def __init__(self, branches=None, detailed=None, **unknown_fields):
        '''
        branches : typing.Sequence[str]
        detailed : bool
        '''
        branches_ = branches
        detailed_ = detailed

        # Validate arguments against known Juju API types.
        if branches_ is not None and not isinstance(branches_, (bytes, str, list)):
            raise Exception("Expected branches_ to be a Sequence, received: {}".format(type(branches_)))

        if detailed_ is not None and not isinstance(detailed_, bool):
            raise Exception("Expected detailed_ to be a bool, received: {}".format(type(detailed_)))

        self.branches = branches_
        self.detailed = detailed_
        self.unknown_fields = unknown_fields



class BranchResults(Type):
    _toSchema = {'error': 'error', 'generations': 'generations'}
    _toPy = {'error': 'error', 'generations': 'generations'}
    def __init__(self, error=None, generations=None, **unknown_fields):
        '''
        error : Error
        generations : typing.Sequence[~Generation]
        '''
        error_ = Error.from_json(error) if error else None
        generations_ = [Generation.from_json(o) for o in generations or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if generations_ is not None and not isinstance(generations_, (bytes, str, list)):
            raise Exception("Expected generations_ to be a Sequence, received: {}".format(type(generations_)))

        self.error = error_
        self.generations = generations_
        self.unknown_fields = unknown_fields



class BranchStatus(Type):
    _toSchema = {'assigned_units': 'assigned-units', 'created': 'created', 'created_by': 'created-by'}
    _toPy = {'assigned-units': 'assigned_units', 'created': 'created', 'created-by': 'created_by'}
    def __init__(self, assigned_units=None, created=None, created_by=None, **unknown_fields):
        '''
        assigned_units : typing.Mapping[str, typing.Sequence[str]]
        created : int
        created_by : str
        '''
        assigned_units_ = assigned_units
        created_ = created
        created_by_ = created_by

        # Validate arguments against known Juju API types.
        if assigned_units_ is not None and not isinstance(assigned_units_, dict):
            raise Exception("Expected assigned_units_ to be a Mapping, received: {}".format(type(assigned_units_)))

        if created_ is not None and not isinstance(created_, int):
            raise Exception("Expected created_ to be a int, received: {}".format(type(created_)))

        if created_by_ is not None and not isinstance(created_by_, (bytes, str)):
            raise Exception("Expected created_by_ to be a str, received: {}".format(type(created_by_)))

        self.assigned_units = assigned_units_
        self.created = created_
        self.created_by = created_by_
        self.unknown_fields = unknown_fields



class BranchTrackArg(Type):
    _toSchema = {'branch': 'branch', 'entities': 'entities', 'num_units': 'num-units'}
    _toPy = {'branch': 'branch', 'entities': 'entities', 'num-units': 'num_units'}
    def __init__(self, branch=None, entities=None, num_units=None, **unknown_fields):
        '''
        branch : str
        entities : typing.Sequence[~Entity]
        num_units : int
        '''
        branch_ = branch
        entities_ = [Entity.from_json(o) for o in entities or []]
        num_units_ = num_units

        # Validate arguments against known Juju API types.
        if branch_ is not None and not isinstance(branch_, (bytes, str)):
            raise Exception("Expected branch_ to be a str, received: {}".format(type(branch_)))

        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        if num_units_ is not None and not isinstance(num_units_, int):
            raise Exception("Expected num_units_ to be a int, received: {}".format(type(num_units_)))

        self.branch = branch_
        self.entities = entities_
        self.num_units = num_units_
        self.unknown_fields = unknown_fields



class BulkImportStorageParams(Type):
    _toSchema = {'storage': 'storage'}
    _toPy = {'storage': 'storage'}
    def __init__(self, storage=None, **unknown_fields):
        '''
        storage : typing.Sequence[~ImportStorageParams]
        '''
        storage_ = [ImportStorageParams.from_json(o) for o in storage or []]

        # Validate arguments against known Juju API types.
        if storage_ is not None and not isinstance(storage_, (bytes, str, list)):
            raise Exception("Expected storage_ to be a Sequence, received: {}".format(type(storage_)))

        self.storage = storage_
        self.unknown_fields = unknown_fields



class BundleChange(Type):
    _toSchema = {'args': 'args', 'id_': 'id', 'method': 'method', 'requires': 'requires'}
    _toPy = {'args': 'args', 'id': 'id_', 'method': 'method', 'requires': 'requires'}
    def __init__(self, args=None, id_=None, method=None, requires=None, **unknown_fields):
        '''
        args : typing.Sequence[typing.Any]
        id_ : str
        method : str
        requires : typing.Sequence[str]
        '''
        args_ = args
        id__ = id_
        method_ = method
        requires_ = requires

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if method_ is not None and not isinstance(method_, (bytes, str)):
            raise Exception("Expected method_ to be a str, received: {}".format(type(method_)))

        if requires_ is not None and not isinstance(requires_, (bytes, str, list)):
            raise Exception("Expected requires_ to be a Sequence, received: {}".format(type(requires_)))

        self.args = args_
        self.id_ = id__
        self.method = method_
        self.requires = requires_
        self.unknown_fields = unknown_fields



class BundleChangesMapArgs(Type):
    _toSchema = {'args': 'args', 'id_': 'id', 'method': 'method', 'requires': 'requires'}
    _toPy = {'args': 'args', 'id': 'id_', 'method': 'method', 'requires': 'requires'}
    def __init__(self, args=None, id_=None, method=None, requires=None, **unknown_fields):
        '''
        args : typing.Mapping[str, typing.Any]
        id_ : str
        method : str
        requires : typing.Sequence[str]
        '''
        args_ = args
        id__ = id_
        method_ = method
        requires_ = requires

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, dict):
            raise Exception("Expected args_ to be a Mapping, received: {}".format(type(args_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if method_ is not None and not isinstance(method_, (bytes, str)):
            raise Exception("Expected method_ to be a str, received: {}".format(type(method_)))

        if requires_ is not None and not isinstance(requires_, (bytes, str, list)):
            raise Exception("Expected requires_ to be a Sequence, received: {}".format(type(requires_)))

        self.args = args_
        self.id_ = id__
        self.method = method_
        self.requires = requires_
        self.unknown_fields = unknown_fields



class BundleChangesMapArgsResults(Type):
    _toSchema = {'changes': 'changes', 'errors': 'errors'}
    _toPy = {'changes': 'changes', 'errors': 'errors'}
    def __init__(self, changes=None, errors=None, **unknown_fields):
        '''
        changes : typing.Sequence[~BundleChangesMapArgs]
        errors : typing.Sequence[str]
        '''
        changes_ = [BundleChangesMapArgs.from_json(o) for o in changes or []]
        errors_ = errors

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        if errors_ is not None and not isinstance(errors_, (bytes, str, list)):
            raise Exception("Expected errors_ to be a Sequence, received: {}".format(type(errors_)))

        self.changes = changes_
        self.errors = errors_
        self.unknown_fields = unknown_fields



class BundleChangesParams(Type):
    _toSchema = {'bundleurl': 'bundleURL', 'yaml': 'yaml'}
    _toPy = {'bundleURL': 'bundleurl', 'yaml': 'yaml'}
    def __init__(self, bundleurl=None, yaml=None, **unknown_fields):
        '''
        bundleurl : str
        yaml : str
        '''
        bundleurl_ = bundleurl
        yaml_ = yaml

        # Validate arguments against known Juju API types.
        if bundleurl_ is not None and not isinstance(bundleurl_, (bytes, str)):
            raise Exception("Expected bundleurl_ to be a str, received: {}".format(type(bundleurl_)))

        if yaml_ is not None and not isinstance(yaml_, (bytes, str)):
            raise Exception("Expected yaml_ to be a str, received: {}".format(type(yaml_)))

        self.bundleurl = bundleurl_
        self.yaml = yaml_
        self.unknown_fields = unknown_fields



class BundleChangesResults(Type):
    _toSchema = {'changes': 'changes', 'errors': 'errors'}
    _toPy = {'changes': 'changes', 'errors': 'errors'}
    def __init__(self, changes=None, errors=None, **unknown_fields):
        '''
        changes : typing.Sequence[~BundleChange]
        errors : typing.Sequence[str]
        '''
        changes_ = [BundleChange.from_json(o) for o in changes or []]
        errors_ = errors

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        if errors_ is not None and not isinstance(errors_, (bytes, str, list)):
            raise Exception("Expected errors_ to be a Sequence, received: {}".format(type(errors_)))

        self.changes = changes_
        self.errors = errors_
        self.unknown_fields = unknown_fields



class BytesResult(Type):
    _toSchema = {'result': 'result'}
    _toPy = {'result': 'result'}
    def __init__(self, result=None, **unknown_fields):
        '''
        result : typing.Sequence[int]
        '''
        result_ = result

        # Validate arguments against known Juju API types.
        if result_ is not None and not isinstance(result_, (bytes, str, list)):
            raise Exception("Expected result_ to be a Sequence, received: {}".format(type(result_)))

        self.result = result_
        self.unknown_fields = unknown_fields



class CIDRParams(Type):
    _toSchema = {'cidrs': 'cidrs'}
    _toPy = {'cidrs': 'cidrs'}
    def __init__(self, cidrs=None, **unknown_fields):
        '''
        cidrs : typing.Sequence[str]
        '''
        cidrs_ = cidrs

        # Validate arguments against known Juju API types.
        if cidrs_ is not None and not isinstance(cidrs_, (bytes, str, list)):
            raise Exception("Expected cidrs_ to be a Sequence, received: {}".format(type(cidrs_)))

        self.cidrs = cidrs_
        self.unknown_fields = unknown_fields



class ChangeModelCredentialParams(Type):
    _toSchema = {'credential_tag': 'credential-tag', 'model_tag': 'model-tag'}
    _toPy = {'credential-tag': 'credential_tag', 'model-tag': 'model_tag'}
    def __init__(self, credential_tag=None, model_tag=None, **unknown_fields):
        '''
        credential_tag : str
        model_tag : str
        '''
        credential_tag_ = credential_tag
        model_tag_ = model_tag

        # Validate arguments against known Juju API types.
        if credential_tag_ is not None and not isinstance(credential_tag_, (bytes, str)):
            raise Exception("Expected credential_tag_ to be a str, received: {}".format(type(credential_tag_)))

        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        self.credential_tag = credential_tag_
        self.model_tag = model_tag_
        self.unknown_fields = unknown_fields



class ChangeModelCredentialsParams(Type):
    _toSchema = {'model_credentials': 'model-credentials'}
    _toPy = {'model-credentials': 'model_credentials'}
    def __init__(self, model_credentials=None, **unknown_fields):
        '''
        model_credentials : typing.Sequence[~ChangeModelCredentialParams]
        '''
        model_credentials_ = [ChangeModelCredentialParams.from_json(o) for o in model_credentials or []]

        # Validate arguments against known Juju API types.
        if model_credentials_ is not None and not isinstance(model_credentials_, (bytes, str, list)):
            raise Exception("Expected model_credentials_ to be a Sequence, received: {}".format(type(model_credentials_)))

        self.model_credentials = model_credentials_
        self.unknown_fields = unknown_fields



class Charm(Type):
    _toSchema = {'actions': 'actions', 'config': 'config', 'lxd_profile': 'lxd-profile', 'meta': 'meta', 'metrics': 'metrics', 'revision': 'revision', 'url': 'url'}
    _toPy = {'actions': 'actions', 'config': 'config', 'lxd-profile': 'lxd_profile', 'meta': 'meta', 'metrics': 'metrics', 'revision': 'revision', 'url': 'url'}
    def __init__(self, actions=None, config=None, lxd_profile=None, meta=None, metrics=None, revision=None, url=None, **unknown_fields):
        '''
        actions : CharmActions
        config : typing.Mapping[str, ~CharmOption]
        lxd_profile : CharmLXDProfile
        meta : CharmMeta
        metrics : CharmMetrics
        revision : int
        url : str
        '''
        actions_ = CharmActions.from_json(actions) if actions else None
        config_ = {k: CharmOption.from_json(v) for k, v in (config or dict()).items()}
        lxd_profile_ = CharmLXDProfile.from_json(lxd_profile) if lxd_profile else None
        meta_ = CharmMeta.from_json(meta) if meta else None
        metrics_ = CharmMetrics.from_json(metrics) if metrics else None
        revision_ = revision
        url_ = url

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (dict, CharmActions)):
            raise Exception("Expected actions_ to be a CharmActions, received: {}".format(type(actions_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if lxd_profile_ is not None and not isinstance(lxd_profile_, (dict, CharmLXDProfile)):
            raise Exception("Expected lxd_profile_ to be a CharmLXDProfile, received: {}".format(type(lxd_profile_)))

        if meta_ is not None and not isinstance(meta_, (dict, CharmMeta)):
            raise Exception("Expected meta_ to be a CharmMeta, received: {}".format(type(meta_)))

        if metrics_ is not None and not isinstance(metrics_, (dict, CharmMetrics)):
            raise Exception("Expected metrics_ to be a CharmMetrics, received: {}".format(type(metrics_)))

        if revision_ is not None and not isinstance(revision_, int):
            raise Exception("Expected revision_ to be a int, received: {}".format(type(revision_)))

        if url_ is not None and not isinstance(url_, (bytes, str)):
            raise Exception("Expected url_ to be a str, received: {}".format(type(url_)))

        self.actions = actions_
        self.config = config_
        self.lxd_profile = lxd_profile_
        self.meta = meta_
        self.metrics = metrics_
        self.revision = revision_
        self.url = url_
        self.unknown_fields = unknown_fields



class CharmActionSpec(Type):
    _toSchema = {'description': 'description', 'params': 'params'}
    _toPy = {'description': 'description', 'params': 'params'}
    def __init__(self, description=None, params=None, **unknown_fields):
        '''
        description : str
        params : typing.Mapping[str, typing.Any]
        '''
        description_ = description
        params_ = params

        # Validate arguments against known Juju API types.
        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if params_ is not None and not isinstance(params_, dict):
            raise Exception("Expected params_ to be a Mapping, received: {}".format(type(params_)))

        self.description = description_
        self.params = params_
        self.unknown_fields = unknown_fields



class CharmActions(Type):
    _toSchema = {'specs': 'specs'}
    _toPy = {'specs': 'specs'}
    def __init__(self, specs=None, **unknown_fields):
        '''
        specs : typing.Mapping[str, ~CharmActionSpec]
        '''
        specs_ = {k: CharmActionSpec.from_json(v) for k, v in (specs or dict()).items()}

        # Validate arguments against known Juju API types.
        if specs_ is not None and not isinstance(specs_, dict):
            raise Exception("Expected specs_ to be a Mapping, received: {}".format(type(specs_)))

        self.specs = specs_
        self.unknown_fields = unknown_fields



class CharmDevice(Type):
    _toSchema = {'countmax': 'CountMax', 'countmin': 'CountMin', 'description': 'Description', 'name': 'Name', 'type_': 'Type'}
    _toPy = {'CountMax': 'countmax', 'CountMin': 'countmin', 'Description': 'description', 'Name': 'name', 'Type': 'type_'}
    def __init__(self, countmax=None, countmin=None, description=None, name=None, type_=None, **unknown_fields):
        '''
        countmax : int
        countmin : int
        description : str
        name : str
        type_ : str
        '''
        countmax_ = countmax
        countmin_ = countmin
        description_ = description
        name_ = name
        type__ = type_

        # Validate arguments against known Juju API types.
        if countmax_ is not None and not isinstance(countmax_, int):
            raise Exception("Expected countmax_ to be a int, received: {}".format(type(countmax_)))

        if countmin_ is not None and not isinstance(countmin_, int):
            raise Exception("Expected countmin_ to be a int, received: {}".format(type(countmin_)))

        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.countmax = countmax_
        self.countmin = countmin_
        self.description = description_
        self.name = name_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CharmInfo(Type):
    _toSchema = {'actions': 'actions', 'config': 'config', 'lxd_profile': 'lxd-profile', 'meta': 'meta', 'metrics': 'metrics', 'revision': 'revision', 'url': 'url'}
    _toPy = {'actions': 'actions', 'config': 'config', 'lxd-profile': 'lxd_profile', 'meta': 'meta', 'metrics': 'metrics', 'revision': 'revision', 'url': 'url'}
    def __init__(self, actions=None, config=None, lxd_profile=None, meta=None, metrics=None, revision=None, url=None, **unknown_fields):
        '''
        actions : CharmActions
        config : typing.Mapping[str, ~CharmOption]
        lxd_profile : CharmLXDProfile
        meta : CharmMeta
        metrics : CharmMetrics
        revision : int
        url : str
        '''
        actions_ = CharmActions.from_json(actions) if actions else None
        config_ = {k: CharmOption.from_json(v) for k, v in (config or dict()).items()}
        lxd_profile_ = CharmLXDProfile.from_json(lxd_profile) if lxd_profile else None
        meta_ = CharmMeta.from_json(meta) if meta else None
        metrics_ = CharmMetrics.from_json(metrics) if metrics else None
        revision_ = revision
        url_ = url

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (dict, CharmActions)):
            raise Exception("Expected actions_ to be a CharmActions, received: {}".format(type(actions_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if lxd_profile_ is not None and not isinstance(lxd_profile_, (dict, CharmLXDProfile)):
            raise Exception("Expected lxd_profile_ to be a CharmLXDProfile, received: {}".format(type(lxd_profile_)))

        if meta_ is not None and not isinstance(meta_, (dict, CharmMeta)):
            raise Exception("Expected meta_ to be a CharmMeta, received: {}".format(type(meta_)))

        if metrics_ is not None and not isinstance(metrics_, (dict, CharmMetrics)):
            raise Exception("Expected metrics_ to be a CharmMetrics, received: {}".format(type(metrics_)))

        if revision_ is not None and not isinstance(revision_, int):
            raise Exception("Expected revision_ to be a int, received: {}".format(type(revision_)))

        if url_ is not None and not isinstance(url_, (bytes, str)):
            raise Exception("Expected url_ to be a str, received: {}".format(type(url_)))

        self.actions = actions_
        self.config = config_
        self.lxd_profile = lxd_profile_
        self.meta = meta_
        self.metrics = metrics_
        self.revision = revision_
        self.url = url_
        self.unknown_fields = unknown_fields



class CharmLXDProfile(Type):
    _toSchema = {'config': 'config', 'description': 'description', 'devices': 'devices'}
    _toPy = {'config': 'config', 'description': 'description', 'devices': 'devices'}
    def __init__(self, config=None, description=None, devices=None, **unknown_fields):
        '''
        config : typing.Mapping[str, str]
        description : str
        devices : typing.Mapping[str, typing.Any]
        '''
        config_ = config
        description_ = description
        devices_ = devices

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if devices_ is not None and not isinstance(devices_, dict):
            raise Exception("Expected devices_ to be a Mapping, received: {}".format(type(devices_)))

        self.config = config_
        self.description = description_
        self.devices = devices_
        self.unknown_fields = unknown_fields



class CharmMeta(Type):
    _toSchema = {'categories': 'categories', 'description': 'description', 'devices': 'devices', 'extra_bindings': 'extra-bindings', 'min_juju_version': 'min-juju-version', 'name': 'name', 'payload_classes': 'payload-classes', 'peers': 'peers', 'provides': 'provides', 'requires': 'requires', 'resources': 'resources', 'series': 'series', 'storage': 'storage', 'subordinate': 'subordinate', 'summary': 'summary', 'tags': 'tags', 'terms': 'terms'}
    _toPy = {'categories': 'categories', 'description': 'description', 'devices': 'devices', 'extra-bindings': 'extra_bindings', 'min-juju-version': 'min_juju_version', 'name': 'name', 'payload-classes': 'payload_classes', 'peers': 'peers', 'provides': 'provides', 'requires': 'requires', 'resources': 'resources', 'series': 'series', 'storage': 'storage', 'subordinate': 'subordinate', 'summary': 'summary', 'tags': 'tags', 'terms': 'terms'}
    def __init__(self, categories=None, description=None, devices=None, extra_bindings=None, min_juju_version=None, name=None, payload_classes=None, peers=None, provides=None, requires=None, resources=None, series=None, storage=None, subordinate=None, summary=None, tags=None, terms=None, **unknown_fields):
        '''
        categories : typing.Sequence[str]
        description : str
        devices : typing.Mapping[str, ~CharmDevice]
        extra_bindings : typing.Mapping[str, str]
        min_juju_version : str
        name : str
        payload_classes : typing.Mapping[str, ~CharmPayloadClass]
        peers : typing.Mapping[str, ~CharmRelation]
        provides : typing.Mapping[str, ~CharmRelation]
        requires : typing.Mapping[str, ~CharmRelation]
        resources : typing.Mapping[str, ~CharmResourceMeta]
        series : typing.Sequence[str]
        storage : typing.Mapping[str, ~CharmStorage]
        subordinate : bool
        summary : str
        tags : typing.Sequence[str]
        terms : typing.Sequence[str]
        '''
        categories_ = categories
        description_ = description
        devices_ = {k: CharmDevice.from_json(v) for k, v in (devices or dict()).items()}
        extra_bindings_ = extra_bindings
        min_juju_version_ = min_juju_version
        name_ = name
        payload_classes_ = {k: CharmPayloadClass.from_json(v) for k, v in (payload_classes or dict()).items()}
        peers_ = {k: CharmRelation.from_json(v) for k, v in (peers or dict()).items()}
        provides_ = {k: CharmRelation.from_json(v) for k, v in (provides or dict()).items()}
        requires_ = {k: CharmRelation.from_json(v) for k, v in (requires or dict()).items()}
        resources_ = {k: CharmResourceMeta.from_json(v) for k, v in (resources or dict()).items()}
        series_ = series
        storage_ = {k: CharmStorage.from_json(v) for k, v in (storage or dict()).items()}
        subordinate_ = subordinate
        summary_ = summary
        tags_ = tags
        terms_ = terms

        # Validate arguments against known Juju API types.
        if categories_ is not None and not isinstance(categories_, (bytes, str, list)):
            raise Exception("Expected categories_ to be a Sequence, received: {}".format(type(categories_)))

        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if devices_ is not None and not isinstance(devices_, dict):
            raise Exception("Expected devices_ to be a Mapping, received: {}".format(type(devices_)))

        if extra_bindings_ is not None and not isinstance(extra_bindings_, dict):
            raise Exception("Expected extra_bindings_ to be a Mapping, received: {}".format(type(extra_bindings_)))

        if min_juju_version_ is not None and not isinstance(min_juju_version_, (bytes, str)):
            raise Exception("Expected min_juju_version_ to be a str, received: {}".format(type(min_juju_version_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if payload_classes_ is not None and not isinstance(payload_classes_, dict):
            raise Exception("Expected payload_classes_ to be a Mapping, received: {}".format(type(payload_classes_)))

        if peers_ is not None and not isinstance(peers_, dict):
            raise Exception("Expected peers_ to be a Mapping, received: {}".format(type(peers_)))

        if provides_ is not None and not isinstance(provides_, dict):
            raise Exception("Expected provides_ to be a Mapping, received: {}".format(type(provides_)))

        if requires_ is not None and not isinstance(requires_, dict):
            raise Exception("Expected requires_ to be a Mapping, received: {}".format(type(requires_)))

        if resources_ is not None and not isinstance(resources_, dict):
            raise Exception("Expected resources_ to be a Mapping, received: {}".format(type(resources_)))

        if series_ is not None and not isinstance(series_, (bytes, str, list)):
            raise Exception("Expected series_ to be a Sequence, received: {}".format(type(series_)))

        if storage_ is not None and not isinstance(storage_, dict):
            raise Exception("Expected storage_ to be a Mapping, received: {}".format(type(storage_)))

        if subordinate_ is not None and not isinstance(subordinate_, bool):
            raise Exception("Expected subordinate_ to be a bool, received: {}".format(type(subordinate_)))

        if summary_ is not None and not isinstance(summary_, (bytes, str)):
            raise Exception("Expected summary_ to be a str, received: {}".format(type(summary_)))

        if tags_ is not None and not isinstance(tags_, (bytes, str, list)):
            raise Exception("Expected tags_ to be a Sequence, received: {}".format(type(tags_)))

        if terms_ is not None and not isinstance(terms_, (bytes, str, list)):
            raise Exception("Expected terms_ to be a Sequence, received: {}".format(type(terms_)))

        self.categories = categories_
        self.description = description_
        self.devices = devices_
        self.extra_bindings = extra_bindings_
        self.min_juju_version = min_juju_version_
        self.name = name_
        self.payload_classes = payload_classes_
        self.peers = peers_
        self.provides = provides_
        self.requires = requires_
        self.resources = resources_
        self.series = series_
        self.storage = storage_
        self.subordinate = subordinate_
        self.summary = summary_
        self.tags = tags_
        self.terms = terms_
        self.unknown_fields = unknown_fields



class CharmMetric(Type):
    _toSchema = {'description': 'description', 'type_': 'type'}
    _toPy = {'description': 'description', 'type': 'type_'}
    def __init__(self, description=None, type_=None, **unknown_fields):
        '''
        description : str
        type_ : str
        '''
        description_ = description
        type__ = type_

        # Validate arguments against known Juju API types.
        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.description = description_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CharmMetrics(Type):
    _toSchema = {'metrics': 'metrics', 'plan': 'plan'}
    _toPy = {'metrics': 'metrics', 'plan': 'plan'}
    def __init__(self, metrics=None, plan=None, **unknown_fields):
        '''
        metrics : typing.Mapping[str, ~CharmMetric]
        plan : CharmPlan
        '''
        metrics_ = {k: CharmMetric.from_json(v) for k, v in (metrics or dict()).items()}
        plan_ = CharmPlan.from_json(plan) if plan else None

        # Validate arguments against known Juju API types.
        if metrics_ is not None and not isinstance(metrics_, dict):
            raise Exception("Expected metrics_ to be a Mapping, received: {}".format(type(metrics_)))

        if plan_ is not None and not isinstance(plan_, (dict, CharmPlan)):
            raise Exception("Expected plan_ to be a CharmPlan, received: {}".format(type(plan_)))

        self.metrics = metrics_
        self.plan = plan_
        self.unknown_fields = unknown_fields



class CharmOption(Type):
    _toSchema = {'default': 'default', 'description': 'description', 'type_': 'type'}
    _toPy = {'default': 'default', 'description': 'description', 'type': 'type_'}
    def __init__(self, default=None, description=None, type_=None, **unknown_fields):
        '''
        default : Any
        description : str
        type_ : str
        '''
        default_ = default
        description_ = description
        type__ = type_

        # Validate arguments against known Juju API types.
        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.default = default_
        self.description = description_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CharmPayloadClass(Type):
    _toSchema = {'name': 'name', 'type_': 'type'}
    _toPy = {'name': 'name', 'type': 'type_'}
    def __init__(self, name=None, type_=None, **unknown_fields):
        '''
        name : str
        type_ : str
        '''
        name_ = name
        type__ = type_

        # Validate arguments against known Juju API types.
        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.name = name_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CharmPlan(Type):
    _toSchema = {'required': 'required'}
    _toPy = {'required': 'required'}
    def __init__(self, required=None, **unknown_fields):
        '''
        required : bool
        '''
        required_ = required

        # Validate arguments against known Juju API types.
        if required_ is not None and not isinstance(required_, bool):
            raise Exception("Expected required_ to be a bool, received: {}".format(type(required_)))

        self.required = required_
        self.unknown_fields = unknown_fields



class CharmProfilingInfoResult(Type):
    _toSchema = {'current_profiles': 'current-profiles', 'error': 'error', 'instance_id': 'instance-id', 'model_name': 'model-name', 'profile_changes': 'profile-changes'}
    _toPy = {'current-profiles': 'current_profiles', 'error': 'error', 'instance-id': 'instance_id', 'model-name': 'model_name', 'profile-changes': 'profile_changes'}
    def __init__(self, current_profiles=None, error=None, instance_id=None, model_name=None, profile_changes=None, **unknown_fields):
        '''
        current_profiles : typing.Sequence[str]
        error : Error
        instance_id : str
        model_name : str
        profile_changes : typing.Sequence[~ProfileInfoResult]
        '''
        current_profiles_ = current_profiles
        error_ = Error.from_json(error) if error else None
        instance_id_ = instance_id
        model_name_ = model_name
        profile_changes_ = [ProfileInfoResult.from_json(o) for o in profile_changes or []]

        # Validate arguments against known Juju API types.
        if current_profiles_ is not None and not isinstance(current_profiles_, (bytes, str, list)):
            raise Exception("Expected current_profiles_ to be a Sequence, received: {}".format(type(current_profiles_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if instance_id_ is not None and not isinstance(instance_id_, (bytes, str)):
            raise Exception("Expected instance_id_ to be a str, received: {}".format(type(instance_id_)))

        if model_name_ is not None and not isinstance(model_name_, (bytes, str)):
            raise Exception("Expected model_name_ to be a str, received: {}".format(type(model_name_)))

        if profile_changes_ is not None and not isinstance(profile_changes_, (bytes, str, list)):
            raise Exception("Expected profile_changes_ to be a Sequence, received: {}".format(type(profile_changes_)))

        self.current_profiles = current_profiles_
        self.error = error_
        self.instance_id = instance_id_
        self.model_name = model_name_
        self.profile_changes = profile_changes_
        self.unknown_fields = unknown_fields



class CharmRelation(Type):
    _toSchema = {'interface': 'interface', 'limit': 'limit', 'name': 'name', 'optional': 'optional', 'role': 'role', 'scope': 'scope'}
    _toPy = {'interface': 'interface', 'limit': 'limit', 'name': 'name', 'optional': 'optional', 'role': 'role', 'scope': 'scope'}
    def __init__(self, interface=None, limit=None, name=None, optional=None, role=None, scope=None, **unknown_fields):
        '''
        interface : str
        limit : int
        name : str
        optional : bool
        role : str
        scope : str
        '''
        interface_ = interface
        limit_ = limit
        name_ = name
        optional_ = optional
        role_ = role
        scope_ = scope

        # Validate arguments against known Juju API types.
        if interface_ is not None and not isinstance(interface_, (bytes, str)):
            raise Exception("Expected interface_ to be a str, received: {}".format(type(interface_)))

        if limit_ is not None and not isinstance(limit_, int):
            raise Exception("Expected limit_ to be a int, received: {}".format(type(limit_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if optional_ is not None and not isinstance(optional_, bool):
            raise Exception("Expected optional_ to be a bool, received: {}".format(type(optional_)))

        if role_ is not None and not isinstance(role_, (bytes, str)):
            raise Exception("Expected role_ to be a str, received: {}".format(type(role_)))

        if scope_ is not None and not isinstance(scope_, (bytes, str)):
            raise Exception("Expected scope_ to be a str, received: {}".format(type(scope_)))

        self.interface = interface_
        self.limit = limit_
        self.name = name_
        self.optional = optional_
        self.role = role_
        self.scope = scope_
        self.unknown_fields = unknown_fields



class CharmResource(Type):
    _toSchema = {'description': 'description', 'fingerprint': 'fingerprint', 'name': 'name', 'origin': 'origin', 'path': 'path', 'revision': 'revision', 'size': 'size', 'type_': 'type'}
    _toPy = {'description': 'description', 'fingerprint': 'fingerprint', 'name': 'name', 'origin': 'origin', 'path': 'path', 'revision': 'revision', 'size': 'size', 'type': 'type_'}
    def __init__(self, description=None, fingerprint=None, name=None, origin=None, path=None, revision=None, size=None, type_=None, **unknown_fields):
        '''
        description : str
        fingerprint : typing.Sequence[int]
        name : str
        origin : str
        path : str
        revision : int
        size : int
        type_ : str
        '''
        description_ = description
        fingerprint_ = fingerprint
        name_ = name
        origin_ = origin
        path_ = path
        revision_ = revision
        size_ = size
        type__ = type_

        # Validate arguments against known Juju API types.
        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if fingerprint_ is not None and not isinstance(fingerprint_, (bytes, str, list)):
            raise Exception("Expected fingerprint_ to be a Sequence, received: {}".format(type(fingerprint_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if origin_ is not None and not isinstance(origin_, (bytes, str)):
            raise Exception("Expected origin_ to be a str, received: {}".format(type(origin_)))

        if path_ is not None and not isinstance(path_, (bytes, str)):
            raise Exception("Expected path_ to be a str, received: {}".format(type(path_)))

        if revision_ is not None and not isinstance(revision_, int):
            raise Exception("Expected revision_ to be a int, received: {}".format(type(revision_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.description = description_
        self.fingerprint = fingerprint_
        self.name = name_
        self.origin = origin_
        self.path = path_
        self.revision = revision_
        self.size = size_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CharmResourceMeta(Type):
    _toSchema = {'description': 'description', 'name': 'name', 'path': 'path', 'type_': 'type'}
    _toPy = {'description': 'description', 'name': 'name', 'path': 'path', 'type': 'type_'}
    def __init__(self, description=None, name=None, path=None, type_=None, **unknown_fields):
        '''
        description : str
        name : str
        path : str
        type_ : str
        '''
        description_ = description
        name_ = name
        path_ = path
        type__ = type_

        # Validate arguments against known Juju API types.
        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if path_ is not None and not isinstance(path_, (bytes, str)):
            raise Exception("Expected path_ to be a str, received: {}".format(type(path_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.description = description_
        self.name = name_
        self.path = path_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CharmStorage(Type):
    _toSchema = {'count_max': 'count-max', 'count_min': 'count-min', 'description': 'description', 'location': 'location', 'minimum_size': 'minimum-size', 'name': 'name', 'properties': 'properties', 'read_only': 'read-only', 'shared': 'shared', 'type_': 'type'}
    _toPy = {'count-max': 'count_max', 'count-min': 'count_min', 'description': 'description', 'location': 'location', 'minimum-size': 'minimum_size', 'name': 'name', 'properties': 'properties', 'read-only': 'read_only', 'shared': 'shared', 'type': 'type_'}
    def __init__(self, count_max=None, count_min=None, description=None, location=None, minimum_size=None, name=None, properties=None, read_only=None, shared=None, type_=None, **unknown_fields):
        '''
        count_max : int
        count_min : int
        description : str
        location : str
        minimum_size : int
        name : str
        properties : typing.Sequence[str]
        read_only : bool
        shared : bool
        type_ : str
        '''
        count_max_ = count_max
        count_min_ = count_min
        description_ = description
        location_ = location
        minimum_size_ = minimum_size
        name_ = name
        properties_ = properties
        read_only_ = read_only
        shared_ = shared
        type__ = type_

        # Validate arguments against known Juju API types.
        if count_max_ is not None and not isinstance(count_max_, int):
            raise Exception("Expected count_max_ to be a int, received: {}".format(type(count_max_)))

        if count_min_ is not None and not isinstance(count_min_, int):
            raise Exception("Expected count_min_ to be a int, received: {}".format(type(count_min_)))

        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if location_ is not None and not isinstance(location_, (bytes, str)):
            raise Exception("Expected location_ to be a str, received: {}".format(type(location_)))

        if minimum_size_ is not None and not isinstance(minimum_size_, int):
            raise Exception("Expected minimum_size_ to be a int, received: {}".format(type(minimum_size_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if properties_ is not None and not isinstance(properties_, (bytes, str, list)):
            raise Exception("Expected properties_ to be a Sequence, received: {}".format(type(properties_)))

        if read_only_ is not None and not isinstance(read_only_, bool):
            raise Exception("Expected read_only_ to be a bool, received: {}".format(type(read_only_)))

        if shared_ is not None and not isinstance(shared_, bool):
            raise Exception("Expected shared_ to be a bool, received: {}".format(type(shared_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.count_max = count_max_
        self.count_min = count_min_
        self.description = description_
        self.location = location_
        self.minimum_size = minimum_size_
        self.name = name_
        self.properties = properties_
        self.read_only = read_only_
        self.shared = shared_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CharmURL(Type):
    _toSchema = {'url': 'url'}
    _toPy = {'url': 'url'}
    def __init__(self, url=None, **unknown_fields):
        '''
        url : str
        '''
        url_ = url

        # Validate arguments against known Juju API types.
        if url_ is not None and not isinstance(url_, (bytes, str)):
            raise Exception("Expected url_ to be a str, received: {}".format(type(url_)))

        self.url = url_
        self.unknown_fields = unknown_fields



class CharmURLs(Type):
    _toSchema = {'urls': 'urls'}
    _toPy = {'urls': 'urls'}
    def __init__(self, urls=None, **unknown_fields):
        '''
        urls : typing.Sequence[~CharmURL]
        '''
        urls_ = [CharmURL.from_json(o) for o in urls or []]

        # Validate arguments against known Juju API types.
        if urls_ is not None and not isinstance(urls_, (bytes, str, list)):
            raise Exception("Expected urls_ to be a Sequence, received: {}".format(type(urls_)))

        self.urls = urls_
        self.unknown_fields = unknown_fields



class CharmsList(Type):
    _toSchema = {'names': 'names'}
    _toPy = {'names': 'names'}
    def __init__(self, names=None, **unknown_fields):
        '''
        names : typing.Sequence[str]
        '''
        names_ = names

        # Validate arguments against known Juju API types.
        if names_ is not None and not isinstance(names_, (bytes, str, list)):
            raise Exception("Expected names_ to be a Sequence, received: {}".format(type(names_)))

        self.names = names_
        self.unknown_fields = unknown_fields



class CharmsListResult(Type):
    _toSchema = {'charm_urls': 'charm-urls'}
    _toPy = {'charm-urls': 'charm_urls'}
    def __init__(self, charm_urls=None, **unknown_fields):
        '''
        charm_urls : typing.Sequence[str]
        '''
        charm_urls_ = charm_urls

        # Validate arguments against known Juju API types.
        if charm_urls_ is not None and not isinstance(charm_urls_, (bytes, str, list)):
            raise Exception("Expected charm_urls_ to be a Sequence, received: {}".format(type(charm_urls_)))

        self.charm_urls = charm_urls_
        self.unknown_fields = unknown_fields



class ClaimLeadershipBulkParams(Type):
    _toSchema = {'params': 'params'}
    _toPy = {'params': 'params'}
    def __init__(self, params=None, **unknown_fields):
        '''
        params : typing.Sequence[~ClaimLeadershipParams]
        '''
        params_ = [ClaimLeadershipParams.from_json(o) for o in params or []]

        # Validate arguments against known Juju API types.
        if params_ is not None and not isinstance(params_, (bytes, str, list)):
            raise Exception("Expected params_ to be a Sequence, received: {}".format(type(params_)))

        self.params = params_
        self.unknown_fields = unknown_fields



class ClaimLeadershipBulkResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ErrorResult]
        '''
        results_ = [ErrorResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ClaimLeadershipParams(Type):
    _toSchema = {'application_tag': 'application-tag', 'duration': 'duration', 'unit_tag': 'unit-tag'}
    _toPy = {'application-tag': 'application_tag', 'duration': 'duration', 'unit-tag': 'unit_tag'}
    def __init__(self, application_tag=None, duration=None, unit_tag=None, **unknown_fields):
        '''
        application_tag : str
        duration : float
        unit_tag : str
        '''
        application_tag_ = application_tag
        duration_ = duration
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if application_tag_ is not None and not isinstance(application_tag_, (bytes, str)):
            raise Exception("Expected application_tag_ to be a str, received: {}".format(type(application_tag_)))

        if duration_ is not None and not isinstance(duration_, float):
            raise Exception("Expected duration_ to be a float, received: {}".format(type(duration_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.application_tag = application_tag_
        self.duration = duration_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class Cloud(Type):
    _toSchema = {'auth_types': 'auth-types', 'ca_certificates': 'ca-certificates', 'config': 'config', 'endpoint': 'endpoint', 'host_cloud_region': 'host-cloud-region', 'identity_endpoint': 'identity-endpoint', 'region_config': 'region-config', 'regions': 'regions', 'storage_endpoint': 'storage-endpoint', 'type_': 'type'}
    _toPy = {'auth-types': 'auth_types', 'ca-certificates': 'ca_certificates', 'config': 'config', 'endpoint': 'endpoint', 'host-cloud-region': 'host_cloud_region', 'identity-endpoint': 'identity_endpoint', 'region-config': 'region_config', 'regions': 'regions', 'storage-endpoint': 'storage_endpoint', 'type': 'type_'}
    def __init__(self, auth_types=None, ca_certificates=None, config=None, endpoint=None, host_cloud_region=None, identity_endpoint=None, region_config=None, regions=None, storage_endpoint=None, type_=None, **unknown_fields):
        '''
        auth_types : typing.Sequence[str]
        ca_certificates : typing.Sequence[str]
        config : typing.Mapping[str, typing.Any]
        endpoint : str
        host_cloud_region : str
        identity_endpoint : str
        region_config : typing.Mapping[str, typing.Any]
        regions : typing.Sequence[~CloudRegion]
        storage_endpoint : str
        type_ : str
        '''
        auth_types_ = auth_types
        ca_certificates_ = ca_certificates
        config_ = config
        endpoint_ = endpoint
        host_cloud_region_ = host_cloud_region
        identity_endpoint_ = identity_endpoint
        region_config_ = region_config
        regions_ = [CloudRegion.from_json(o) for o in regions or []]
        storage_endpoint_ = storage_endpoint
        type__ = type_

        # Validate arguments against known Juju API types.
        if auth_types_ is not None and not isinstance(auth_types_, (bytes, str, list)):
            raise Exception("Expected auth_types_ to be a Sequence, received: {}".format(type(auth_types_)))

        if ca_certificates_ is not None and not isinstance(ca_certificates_, (bytes, str, list)):
            raise Exception("Expected ca_certificates_ to be a Sequence, received: {}".format(type(ca_certificates_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if endpoint_ is not None and not isinstance(endpoint_, (bytes, str)):
            raise Exception("Expected endpoint_ to be a str, received: {}".format(type(endpoint_)))

        if host_cloud_region_ is not None and not isinstance(host_cloud_region_, (bytes, str)):
            raise Exception("Expected host_cloud_region_ to be a str, received: {}".format(type(host_cloud_region_)))

        if identity_endpoint_ is not None and not isinstance(identity_endpoint_, (bytes, str)):
            raise Exception("Expected identity_endpoint_ to be a str, received: {}".format(type(identity_endpoint_)))

        if region_config_ is not None and not isinstance(region_config_, dict):
            raise Exception("Expected region_config_ to be a Mapping, received: {}".format(type(region_config_)))

        if regions_ is not None and not isinstance(regions_, (bytes, str, list)):
            raise Exception("Expected regions_ to be a Sequence, received: {}".format(type(regions_)))

        if storage_endpoint_ is not None and not isinstance(storage_endpoint_, (bytes, str)):
            raise Exception("Expected storage_endpoint_ to be a str, received: {}".format(type(storage_endpoint_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.auth_types = auth_types_
        self.ca_certificates = ca_certificates_
        self.config = config_
        self.endpoint = endpoint_
        self.host_cloud_region = host_cloud_region_
        self.identity_endpoint = identity_endpoint_
        self.region_config = region_config_
        self.regions = regions_
        self.storage_endpoint = storage_endpoint_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CloudCredential(Type):
    _toSchema = {'attrs': 'attrs', 'auth_type': 'auth-type', 'redacted': 'redacted'}
    _toPy = {'attrs': 'attrs', 'auth-type': 'auth_type', 'redacted': 'redacted'}
    def __init__(self, attrs=None, auth_type=None, redacted=None, **unknown_fields):
        '''
        attrs : typing.Mapping[str, str]
        auth_type : str
        redacted : typing.Sequence[str]
        '''
        attrs_ = attrs
        auth_type_ = auth_type
        redacted_ = redacted

        # Validate arguments against known Juju API types.
        if attrs_ is not None and not isinstance(attrs_, dict):
            raise Exception("Expected attrs_ to be a Mapping, received: {}".format(type(attrs_)))

        if auth_type_ is not None and not isinstance(auth_type_, (bytes, str)):
            raise Exception("Expected auth_type_ to be a str, received: {}".format(type(auth_type_)))

        if redacted_ is not None and not isinstance(redacted_, (bytes, str, list)):
            raise Exception("Expected redacted_ to be a Sequence, received: {}".format(type(redacted_)))

        self.attrs = attrs_
        self.auth_type = auth_type_
        self.redacted = redacted_
        self.unknown_fields = unknown_fields



class CloudCredentialArg(Type):
    _toSchema = {'cloud_name': 'cloud-name', 'credential_name': 'credential-name'}
    _toPy = {'cloud-name': 'cloud_name', 'credential-name': 'credential_name'}
    def __init__(self, cloud_name=None, credential_name=None, **unknown_fields):
        '''
        cloud_name : str
        credential_name : str
        '''
        cloud_name_ = cloud_name
        credential_name_ = credential_name

        # Validate arguments against known Juju API types.
        if cloud_name_ is not None and not isinstance(cloud_name_, (bytes, str)):
            raise Exception("Expected cloud_name_ to be a str, received: {}".format(type(cloud_name_)))

        if credential_name_ is not None and not isinstance(credential_name_, (bytes, str)):
            raise Exception("Expected credential_name_ to be a str, received: {}".format(type(credential_name_)))

        self.cloud_name = cloud_name_
        self.credential_name = credential_name_
        self.unknown_fields = unknown_fields



class CloudCredentialArgs(Type):
    _toSchema = {'credentials': 'credentials', 'include_secrets': 'include-secrets'}
    _toPy = {'credentials': 'credentials', 'include-secrets': 'include_secrets'}
    def __init__(self, credentials=None, include_secrets=None, **unknown_fields):
        '''
        credentials : typing.Sequence[~CloudCredentialArg]
        include_secrets : bool
        '''
        credentials_ = [CloudCredentialArg.from_json(o) for o in credentials or []]
        include_secrets_ = include_secrets

        # Validate arguments against known Juju API types.
        if credentials_ is not None and not isinstance(credentials_, (bytes, str, list)):
            raise Exception("Expected credentials_ to be a Sequence, received: {}".format(type(credentials_)))

        if include_secrets_ is not None and not isinstance(include_secrets_, bool):
            raise Exception("Expected include_secrets_ to be a bool, received: {}".format(type(include_secrets_)))

        self.credentials = credentials_
        self.include_secrets = include_secrets_
        self.unknown_fields = unknown_fields



class CloudCredentialResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : CloudCredential
        '''
        error_ = Error.from_json(error) if error else None
        result_ = CloudCredential.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, CloudCredential)):
            raise Exception("Expected result_ to be a CloudCredential, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class CloudCredentialResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~CloudCredentialResult]
        '''
        results_ = [CloudCredentialResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class CloudDetails(Type):
    _toSchema = {'auth_types': 'auth-types', 'endpoint': 'endpoint', 'identity_endpoint': 'identity-endpoint', 'regions': 'regions', 'storage_endpoint': 'storage-endpoint', 'type_': 'type'}
    _toPy = {'auth-types': 'auth_types', 'endpoint': 'endpoint', 'identity-endpoint': 'identity_endpoint', 'regions': 'regions', 'storage-endpoint': 'storage_endpoint', 'type': 'type_'}
    def __init__(self, auth_types=None, endpoint=None, identity_endpoint=None, regions=None, storage_endpoint=None, type_=None, **unknown_fields):
        '''
        auth_types : typing.Sequence[str]
        endpoint : str
        identity_endpoint : str
        regions : typing.Sequence[~CloudRegion]
        storage_endpoint : str
        type_ : str
        '''
        auth_types_ = auth_types
        endpoint_ = endpoint
        identity_endpoint_ = identity_endpoint
        regions_ = [CloudRegion.from_json(o) for o in regions or []]
        storage_endpoint_ = storage_endpoint
        type__ = type_

        # Validate arguments against known Juju API types.
        if auth_types_ is not None and not isinstance(auth_types_, (bytes, str, list)):
            raise Exception("Expected auth_types_ to be a Sequence, received: {}".format(type(auth_types_)))

        if endpoint_ is not None and not isinstance(endpoint_, (bytes, str)):
            raise Exception("Expected endpoint_ to be a str, received: {}".format(type(endpoint_)))

        if identity_endpoint_ is not None and not isinstance(identity_endpoint_, (bytes, str)):
            raise Exception("Expected identity_endpoint_ to be a str, received: {}".format(type(identity_endpoint_)))

        if regions_ is not None and not isinstance(regions_, (bytes, str, list)):
            raise Exception("Expected regions_ to be a Sequence, received: {}".format(type(regions_)))

        if storage_endpoint_ is not None and not isinstance(storage_endpoint_, (bytes, str)):
            raise Exception("Expected storage_endpoint_ to be a str, received: {}".format(type(storage_endpoint_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.auth_types = auth_types_
        self.endpoint = endpoint_
        self.identity_endpoint = identity_endpoint_
        self.regions = regions_
        self.storage_endpoint = storage_endpoint_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CloudImageMetadata(Type):
    _toSchema = {'arch': 'arch', 'image_id': 'image-id', 'priority': 'priority', 'region': 'region', 'root_storage_size': 'root-storage-size', 'root_storage_type': 'root-storage-type', 'series': 'series', 'source': 'source', 'stream': 'stream', 'version': 'version', 'virt_type': 'virt-type'}
    _toPy = {'arch': 'arch', 'image-id': 'image_id', 'priority': 'priority', 'region': 'region', 'root-storage-size': 'root_storage_size', 'root-storage-type': 'root_storage_type', 'series': 'series', 'source': 'source', 'stream': 'stream', 'version': 'version', 'virt-type': 'virt_type'}
    def __init__(self, arch=None, image_id=None, priority=None, region=None, root_storage_size=None, root_storage_type=None, series=None, source=None, stream=None, version=None, virt_type=None, **unknown_fields):
        '''
        arch : str
        image_id : str
        priority : int
        region : str
        root_storage_size : int
        root_storage_type : str
        series : str
        source : str
        stream : str
        version : str
        virt_type : str
        '''
        arch_ = arch
        image_id_ = image_id
        priority_ = priority
        region_ = region
        root_storage_size_ = root_storage_size
        root_storage_type_ = root_storage_type
        series_ = series
        source_ = source
        stream_ = stream
        version_ = version
        virt_type_ = virt_type

        # Validate arguments against known Juju API types.
        if arch_ is not None and not isinstance(arch_, (bytes, str)):
            raise Exception("Expected arch_ to be a str, received: {}".format(type(arch_)))

        if image_id_ is not None and not isinstance(image_id_, (bytes, str)):
            raise Exception("Expected image_id_ to be a str, received: {}".format(type(image_id_)))

        if priority_ is not None and not isinstance(priority_, int):
            raise Exception("Expected priority_ to be a int, received: {}".format(type(priority_)))

        if region_ is not None and not isinstance(region_, (bytes, str)):
            raise Exception("Expected region_ to be a str, received: {}".format(type(region_)))

        if root_storage_size_ is not None and not isinstance(root_storage_size_, int):
            raise Exception("Expected root_storage_size_ to be a int, received: {}".format(type(root_storage_size_)))

        if root_storage_type_ is not None and not isinstance(root_storage_type_, (bytes, str)):
            raise Exception("Expected root_storage_type_ to be a str, received: {}".format(type(root_storage_type_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if source_ is not None and not isinstance(source_, (bytes, str)):
            raise Exception("Expected source_ to be a str, received: {}".format(type(source_)))

        if stream_ is not None and not isinstance(stream_, (bytes, str)):
            raise Exception("Expected stream_ to be a str, received: {}".format(type(stream_)))

        if version_ is not None and not isinstance(version_, (bytes, str)):
            raise Exception("Expected version_ to be a str, received: {}".format(type(version_)))

        if virt_type_ is not None and not isinstance(virt_type_, (bytes, str)):
            raise Exception("Expected virt_type_ to be a str, received: {}".format(type(virt_type_)))

        self.arch = arch_
        self.image_id = image_id_
        self.priority = priority_
        self.region = region_
        self.root_storage_size = root_storage_size_
        self.root_storage_type = root_storage_type_
        self.series = series_
        self.source = source_
        self.stream = stream_
        self.version = version_
        self.virt_type = virt_type_
        self.unknown_fields = unknown_fields



class CloudImageMetadataList(Type):
    _toSchema = {'metadata': 'metadata'}
    _toPy = {'metadata': 'metadata'}
    def __init__(self, metadata=None, **unknown_fields):
        '''
        metadata : typing.Sequence[~CloudImageMetadata]
        '''
        metadata_ = [CloudImageMetadata.from_json(o) for o in metadata or []]

        # Validate arguments against known Juju API types.
        if metadata_ is not None and not isinstance(metadata_, (bytes, str, list)):
            raise Exception("Expected metadata_ to be a Sequence, received: {}".format(type(metadata_)))

        self.metadata = metadata_
        self.unknown_fields = unknown_fields



class CloudInfo(Type):
    _toSchema = {'clouddetails': 'CloudDetails', 'users': 'users'}
    _toPy = {'CloudDetails': 'clouddetails', 'users': 'users'}
    def __init__(self, clouddetails=None, users=None, **unknown_fields):
        '''
        clouddetails : CloudDetails
        users : typing.Sequence[~CloudUserInfo]
        '''
        clouddetails_ = CloudDetails.from_json(clouddetails) if clouddetails else None
        users_ = [CloudUserInfo.from_json(o) for o in users or []]

        # Validate arguments against known Juju API types.
        if clouddetails_ is not None and not isinstance(clouddetails_, (dict, CloudDetails)):
            raise Exception("Expected clouddetails_ to be a CloudDetails, received: {}".format(type(clouddetails_)))

        if users_ is not None and not isinstance(users_, (bytes, str, list)):
            raise Exception("Expected users_ to be a Sequence, received: {}".format(type(users_)))

        self.clouddetails = clouddetails_
        self.users = users_
        self.unknown_fields = unknown_fields



class CloudInfoResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : CloudInfo
        '''
        error_ = Error.from_json(error) if error else None
        result_ = CloudInfo.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, CloudInfo)):
            raise Exception("Expected result_ to be a CloudInfo, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class CloudInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~CloudInfoResult]
        '''
        results_ = [CloudInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class CloudInstanceTypesConstraint(Type):
    _toSchema = {'cloud_tag': 'cloud-tag', 'constraints': 'constraints', 'region': 'region'}
    _toPy = {'cloud-tag': 'cloud_tag', 'constraints': 'constraints', 'region': 'region'}
    def __init__(self, cloud_tag=None, constraints=None, region=None, **unknown_fields):
        '''
        cloud_tag : str
        constraints : Value
        region : str
        '''
        cloud_tag_ = cloud_tag
        constraints_ = Value.from_json(constraints) if constraints else None
        region_ = region

        # Validate arguments against known Juju API types.
        if cloud_tag_ is not None and not isinstance(cloud_tag_, (bytes, str)):
            raise Exception("Expected cloud_tag_ to be a str, received: {}".format(type(cloud_tag_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if region_ is not None and not isinstance(region_, (bytes, str)):
            raise Exception("Expected region_ to be a str, received: {}".format(type(region_)))

        self.cloud_tag = cloud_tag_
        self.constraints = constraints_
        self.region = region_
        self.unknown_fields = unknown_fields



class CloudInstanceTypesConstraints(Type):
    _toSchema = {'constraints': 'constraints'}
    _toPy = {'constraints': 'constraints'}
    def __init__(self, constraints=None, **unknown_fields):
        '''
        constraints : typing.Sequence[~CloudInstanceTypesConstraint]
        '''
        constraints_ = [CloudInstanceTypesConstraint.from_json(o) for o in constraints or []]

        # Validate arguments against known Juju API types.
        if constraints_ is not None and not isinstance(constraints_, (bytes, str, list)):
            raise Exception("Expected constraints_ to be a Sequence, received: {}".format(type(constraints_)))

        self.constraints = constraints_
        self.unknown_fields = unknown_fields



class CloudRegion(Type):
    _toSchema = {'endpoint': 'endpoint', 'identity_endpoint': 'identity-endpoint', 'name': 'name', 'storage_endpoint': 'storage-endpoint'}
    _toPy = {'endpoint': 'endpoint', 'identity-endpoint': 'identity_endpoint', 'name': 'name', 'storage-endpoint': 'storage_endpoint'}
    def __init__(self, endpoint=None, identity_endpoint=None, name=None, storage_endpoint=None, **unknown_fields):
        '''
        endpoint : str
        identity_endpoint : str
        name : str
        storage_endpoint : str
        '''
        endpoint_ = endpoint
        identity_endpoint_ = identity_endpoint
        name_ = name
        storage_endpoint_ = storage_endpoint

        # Validate arguments against known Juju API types.
        if endpoint_ is not None and not isinstance(endpoint_, (bytes, str)):
            raise Exception("Expected endpoint_ to be a str, received: {}".format(type(endpoint_)))

        if identity_endpoint_ is not None and not isinstance(identity_endpoint_, (bytes, str)):
            raise Exception("Expected identity_endpoint_ to be a str, received: {}".format(type(identity_endpoint_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if storage_endpoint_ is not None and not isinstance(storage_endpoint_, (bytes, str)):
            raise Exception("Expected storage_endpoint_ to be a str, received: {}".format(type(storage_endpoint_)))

        self.endpoint = endpoint_
        self.identity_endpoint = identity_endpoint_
        self.name = name_
        self.storage_endpoint = storage_endpoint_
        self.unknown_fields = unknown_fields



class CloudResult(Type):
    _toSchema = {'cloud': 'cloud', 'error': 'error'}
    _toPy = {'cloud': 'cloud', 'error': 'error'}
    def __init__(self, cloud=None, error=None, **unknown_fields):
        '''
        cloud : Cloud
        error : Error
        '''
        cloud_ = Cloud.from_json(cloud) if cloud else None
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if cloud_ is not None and not isinstance(cloud_, (dict, Cloud)):
            raise Exception("Expected cloud_ to be a Cloud, received: {}".format(type(cloud_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.cloud = cloud_
        self.error = error_
        self.unknown_fields = unknown_fields



class CloudResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~CloudResult]
        '''
        results_ = [CloudResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class CloudSpec(Type):
    _toSchema = {'cacertificates': 'cacertificates', 'credential': 'credential', 'endpoint': 'endpoint', 'identity_endpoint': 'identity-endpoint', 'name': 'name', 'region': 'region', 'storage_endpoint': 'storage-endpoint', 'type_': 'type'}
    _toPy = {'cacertificates': 'cacertificates', 'credential': 'credential', 'endpoint': 'endpoint', 'identity-endpoint': 'identity_endpoint', 'name': 'name', 'region': 'region', 'storage-endpoint': 'storage_endpoint', 'type': 'type_'}
    def __init__(self, cacertificates=None, credential=None, endpoint=None, identity_endpoint=None, name=None, region=None, storage_endpoint=None, type_=None, **unknown_fields):
        '''
        cacertificates : typing.Sequence[str]
        credential : CloudCredential
        endpoint : str
        identity_endpoint : str
        name : str
        region : str
        storage_endpoint : str
        type_ : str
        '''
        cacertificates_ = cacertificates
        credential_ = CloudCredential.from_json(credential) if credential else None
        endpoint_ = endpoint
        identity_endpoint_ = identity_endpoint
        name_ = name
        region_ = region
        storage_endpoint_ = storage_endpoint
        type__ = type_

        # Validate arguments against known Juju API types.
        if cacertificates_ is not None and not isinstance(cacertificates_, (bytes, str, list)):
            raise Exception("Expected cacertificates_ to be a Sequence, received: {}".format(type(cacertificates_)))

        if credential_ is not None and not isinstance(credential_, (dict, CloudCredential)):
            raise Exception("Expected credential_ to be a CloudCredential, received: {}".format(type(credential_)))

        if endpoint_ is not None and not isinstance(endpoint_, (bytes, str)):
            raise Exception("Expected endpoint_ to be a str, received: {}".format(type(endpoint_)))

        if identity_endpoint_ is not None and not isinstance(identity_endpoint_, (bytes, str)):
            raise Exception("Expected identity_endpoint_ to be a str, received: {}".format(type(identity_endpoint_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if region_ is not None and not isinstance(region_, (bytes, str)):
            raise Exception("Expected region_ to be a str, received: {}".format(type(region_)))

        if storage_endpoint_ is not None and not isinstance(storage_endpoint_, (bytes, str)):
            raise Exception("Expected storage_endpoint_ to be a str, received: {}".format(type(storage_endpoint_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.cacertificates = cacertificates_
        self.credential = credential_
        self.endpoint = endpoint_
        self.identity_endpoint = identity_endpoint_
        self.name = name_
        self.region = region_
        self.storage_endpoint = storage_endpoint_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class CloudSpecResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : CloudSpec
        '''
        error_ = Error.from_json(error) if error else None
        result_ = CloudSpec.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, CloudSpec)):
            raise Exception("Expected result_ to be a CloudSpec, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class CloudSpecResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~CloudSpecResult]
        '''
        results_ = [CloudSpecResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class CloudUserInfo(Type):
    _toSchema = {'access': 'access', 'display_name': 'display-name', 'user': 'user'}
    _toPy = {'access': 'access', 'display-name': 'display_name', 'user': 'user'}
    def __init__(self, access=None, display_name=None, user=None, **unknown_fields):
        '''
        access : str
        display_name : str
        user : str
        '''
        access_ = access
        display_name_ = display_name
        user_ = user

        # Validate arguments against known Juju API types.
        if access_ is not None and not isinstance(access_, (bytes, str)):
            raise Exception("Expected access_ to be a str, received: {}".format(type(access_)))

        if display_name_ is not None and not isinstance(display_name_, (bytes, str)):
            raise Exception("Expected display_name_ to be a str, received: {}".format(type(display_name_)))

        if user_ is not None and not isinstance(user_, (bytes, str)):
            raise Exception("Expected user_ to be a str, received: {}".format(type(user_)))

        self.access = access_
        self.display_name = display_name_
        self.user = user_
        self.unknown_fields = unknown_fields



class CloudsResult(Type):
    _toSchema = {'clouds': 'clouds'}
    _toPy = {'clouds': 'clouds'}
    def __init__(self, clouds=None, **unknown_fields):
        '''
        clouds : typing.Mapping[str, ~Cloud]
        '''
        clouds_ = {k: Cloud.from_json(v) for k, v in (clouds or dict()).items()}

        # Validate arguments against known Juju API types.
        if clouds_ is not None and not isinstance(clouds_, dict):
            raise Exception("Expected clouds_ to be a Mapping, received: {}".format(type(clouds_)))

        self.clouds = clouds_
        self.unknown_fields = unknown_fields



class CommitHookChangesArg(Type):
    _toSchema = {'add_storage': 'add-storage', 'close_ports': 'close-ports', 'open_ports': 'open-ports', 'pod_spec': 'pod-spec', 'relation_unit_settings': 'relation-unit-settings', 'set_raw_k8s_spec': 'set-raw-k8s-spec', 'tag': 'tag', 'unit_state': 'unit-state', 'update_network_info': 'update-network-info'}
    _toPy = {'add-storage': 'add_storage', 'close-ports': 'close_ports', 'open-ports': 'open_ports', 'pod-spec': 'pod_spec', 'relation-unit-settings': 'relation_unit_settings', 'set-raw-k8s-spec': 'set_raw_k8s_spec', 'tag': 'tag', 'unit-state': 'unit_state', 'update-network-info': 'update_network_info'}
    def __init__(self, add_storage=None, close_ports=None, open_ports=None, pod_spec=None, relation_unit_settings=None, set_raw_k8s_spec=None, tag=None, unit_state=None, update_network_info=None, **unknown_fields):
        '''
        add_storage : typing.Sequence[~StorageAddParams]
        close_ports : typing.Sequence[~EntityPortRange]
        open_ports : typing.Sequence[~EntityPortRange]
        pod_spec : PodSpec
        relation_unit_settings : typing.Sequence[~RelationUnitSettings]
        set_raw_k8s_spec : PodSpec
        tag : str
        unit_state : SetUnitStateArg
        update_network_info : bool
        '''
        add_storage_ = [StorageAddParams.from_json(o) for o in add_storage or []]
        close_ports_ = [EntityPortRange.from_json(o) for o in close_ports or []]
        open_ports_ = [EntityPortRange.from_json(o) for o in open_ports or []]
        pod_spec_ = PodSpec.from_json(pod_spec) if pod_spec else None
        relation_unit_settings_ = [RelationUnitSettings.from_json(o) for o in relation_unit_settings or []]
        set_raw_k8s_spec_ = PodSpec.from_json(set_raw_k8s_spec) if set_raw_k8s_spec else None
        tag_ = tag
        unit_state_ = SetUnitStateArg.from_json(unit_state) if unit_state else None
        update_network_info_ = update_network_info

        # Validate arguments against known Juju API types.
        if add_storage_ is not None and not isinstance(add_storage_, (bytes, str, list)):
            raise Exception("Expected add_storage_ to be a Sequence, received: {}".format(type(add_storage_)))

        if close_ports_ is not None and not isinstance(close_ports_, (bytes, str, list)):
            raise Exception("Expected close_ports_ to be a Sequence, received: {}".format(type(close_ports_)))

        if open_ports_ is not None and not isinstance(open_ports_, (bytes, str, list)):
            raise Exception("Expected open_ports_ to be a Sequence, received: {}".format(type(open_ports_)))

        if pod_spec_ is not None and not isinstance(pod_spec_, (dict, PodSpec)):
            raise Exception("Expected pod_spec_ to be a PodSpec, received: {}".format(type(pod_spec_)))

        if relation_unit_settings_ is not None and not isinstance(relation_unit_settings_, (bytes, str, list)):
            raise Exception("Expected relation_unit_settings_ to be a Sequence, received: {}".format(type(relation_unit_settings_)))

        if set_raw_k8s_spec_ is not None and not isinstance(set_raw_k8s_spec_, (dict, PodSpec)):
            raise Exception("Expected set_raw_k8s_spec_ to be a PodSpec, received: {}".format(type(set_raw_k8s_spec_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if unit_state_ is not None and not isinstance(unit_state_, (dict, SetUnitStateArg)):
            raise Exception("Expected unit_state_ to be a SetUnitStateArg, received: {}".format(type(unit_state_)))

        if update_network_info_ is not None and not isinstance(update_network_info_, bool):
            raise Exception("Expected update_network_info_ to be a bool, received: {}".format(type(update_network_info_)))

        self.add_storage = add_storage_
        self.close_ports = close_ports_
        self.open_ports = open_ports_
        self.pod_spec = pod_spec_
        self.relation_unit_settings = relation_unit_settings_
        self.set_raw_k8s_spec = set_raw_k8s_spec_
        self.tag = tag_
        self.unit_state = unit_state_
        self.update_network_info = update_network_info_
        self.unknown_fields = unknown_fields



class CommitHookChangesArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~CommitHookChangesArg]
        '''
        args_ = [CommitHookChangesArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class ConfigResult(Type):
    _toSchema = {'config': 'config', 'error': 'error'}
    _toPy = {'config': 'config', 'error': 'error'}
    def __init__(self, config=None, error=None, **unknown_fields):
        '''
        config : typing.Mapping[str, typing.Any]
        error : Error
        '''
        config_ = config
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.config = config_
        self.error = error_
        self.unknown_fields = unknown_fields



class ConfigSettingsResult(Type):
    _toSchema = {'error': 'error', 'settings': 'settings'}
    _toPy = {'error': 'error', 'settings': 'settings'}
    def __init__(self, error=None, settings=None, **unknown_fields):
        '''
        error : Error
        settings : typing.Mapping[str, typing.Any]
        '''
        error_ = Error.from_json(error) if error else None
        settings_ = settings

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if settings_ is not None and not isinstance(settings_, dict):
            raise Exception("Expected settings_ to be a Mapping, received: {}".format(type(settings_)))

        self.error = error_
        self.settings = settings_
        self.unknown_fields = unknown_fields



class ConfigSettingsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ConfigSettingsResult]
        '''
        results_ = [ConfigSettingsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ConfigValue(Type):
    _toSchema = {'source': 'source', 'value': 'value'}
    _toPy = {'source': 'source', 'value': 'value'}
    def __init__(self, source=None, value=None, **unknown_fields):
        '''
        source : str
        value : Any
        '''
        source_ = source
        value_ = value

        # Validate arguments against known Juju API types.
        if source_ is not None and not isinstance(source_, (bytes, str)):
            raise Exception("Expected source_ to be a str, received: {}".format(type(source_)))

        self.source = source_
        self.value = value_
        self.unknown_fields = unknown_fields



class Constraints(Type):
    _toSchema = {'count': 'Count', 'pool': 'Pool', 'size': 'Size'}
    _toPy = {'Count': 'count', 'Pool': 'pool', 'Size': 'size'}
    def __init__(self, count=None, pool=None, size=None, **unknown_fields):
        '''
        count : int
        pool : str
        size : int
        '''
        count_ = count
        pool_ = pool
        size_ = size

        # Validate arguments against known Juju API types.
        if count_ is not None and not isinstance(count_, int):
            raise Exception("Expected count_ to be a int, received: {}".format(type(count_)))

        if pool_ is not None and not isinstance(pool_, (bytes, str)):
            raise Exception("Expected pool_ to be a str, received: {}".format(type(pool_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        self.count = count_
        self.pool = pool_
        self.size = size_
        self.unknown_fields = unknown_fields



class ConstraintsResult(Type):
    _toSchema = {'constraints': 'constraints', 'error': 'error'}
    _toPy = {'constraints': 'constraints', 'error': 'error'}
    def __init__(self, constraints=None, error=None, **unknown_fields):
        '''
        constraints : Value
        error : Error
        '''
        constraints_ = Value.from_json(constraints) if constraints else None
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.constraints = constraints_
        self.error = error_
        self.unknown_fields = unknown_fields



class ConstraintsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ConstraintsResult]
        '''
        results_ = [ConstraintsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ConsumeApplicationArg(Type):
    _toSchema = {'application_alias': 'application-alias', 'application_description': 'application-description', 'applicationofferdetails': 'ApplicationOfferDetails', 'bindings': 'bindings', 'endpoints': 'endpoints', 'external_controller': 'external-controller', 'macaroon': 'macaroon', 'offer_name': 'offer-name', 'offer_url': 'offer-url', 'offer_uuid': 'offer-uuid', 'source_model_tag': 'source-model-tag', 'spaces': 'spaces', 'users': 'users'}
    _toPy = {'ApplicationOfferDetails': 'applicationofferdetails', 'application-alias': 'application_alias', 'application-description': 'application_description', 'bindings': 'bindings', 'endpoints': 'endpoints', 'external-controller': 'external_controller', 'macaroon': 'macaroon', 'offer-name': 'offer_name', 'offer-url': 'offer_url', 'offer-uuid': 'offer_uuid', 'source-model-tag': 'source_model_tag', 'spaces': 'spaces', 'users': 'users'}
    def __init__(self, applicationofferdetails=None, application_alias=None, application_description=None, bindings=None, endpoints=None, external_controller=None, macaroon=None, offer_name=None, offer_url=None, offer_uuid=None, source_model_tag=None, spaces=None, users=None, **unknown_fields):
        '''
        applicationofferdetails : ApplicationOfferDetails
        application_alias : str
        application_description : str
        bindings : typing.Mapping[str, str]
        endpoints : typing.Sequence[~RemoteEndpoint]
        external_controller : ExternalControllerInfo
        macaroon : Macaroon
        offer_name : str
        offer_url : str
        offer_uuid : str
        source_model_tag : str
        spaces : typing.Sequence[~RemoteSpace]
        users : typing.Sequence[~OfferUserDetails]
        '''
        applicationofferdetails_ = ApplicationOfferDetails.from_json(applicationofferdetails) if applicationofferdetails else None
        application_alias_ = application_alias
        application_description_ = application_description
        bindings_ = bindings
        endpoints_ = [RemoteEndpoint.from_json(o) for o in endpoints or []]
        external_controller_ = ExternalControllerInfo.from_json(external_controller) if external_controller else None
        macaroon_ = Macaroon.from_json(macaroon) if macaroon else None
        offer_name_ = offer_name
        offer_url_ = offer_url
        offer_uuid_ = offer_uuid
        source_model_tag_ = source_model_tag
        spaces_ = [RemoteSpace.from_json(o) for o in spaces or []]
        users_ = [OfferUserDetails.from_json(o) for o in users or []]

        # Validate arguments against known Juju API types.
        if applicationofferdetails_ is not None and not isinstance(applicationofferdetails_, (dict, ApplicationOfferDetails)):
            raise Exception("Expected applicationofferdetails_ to be a ApplicationOfferDetails, received: {}".format(type(applicationofferdetails_)))

        if application_alias_ is not None and not isinstance(application_alias_, (bytes, str)):
            raise Exception("Expected application_alias_ to be a str, received: {}".format(type(application_alias_)))

        if application_description_ is not None and not isinstance(application_description_, (bytes, str)):
            raise Exception("Expected application_description_ to be a str, received: {}".format(type(application_description_)))

        if bindings_ is not None and not isinstance(bindings_, dict):
            raise Exception("Expected bindings_ to be a Mapping, received: {}".format(type(bindings_)))

        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if external_controller_ is not None and not isinstance(external_controller_, (dict, ExternalControllerInfo)):
            raise Exception("Expected external_controller_ to be a ExternalControllerInfo, received: {}".format(type(external_controller_)))

        if macaroon_ is not None and not isinstance(macaroon_, (dict, Macaroon)):
            raise Exception("Expected macaroon_ to be a Macaroon, received: {}".format(type(macaroon_)))

        if offer_name_ is not None and not isinstance(offer_name_, (bytes, str)):
            raise Exception("Expected offer_name_ to be a str, received: {}".format(type(offer_name_)))

        if offer_url_ is not None and not isinstance(offer_url_, (bytes, str)):
            raise Exception("Expected offer_url_ to be a str, received: {}".format(type(offer_url_)))

        if offer_uuid_ is not None and not isinstance(offer_uuid_, (bytes, str)):
            raise Exception("Expected offer_uuid_ to be a str, received: {}".format(type(offer_uuid_)))

        if source_model_tag_ is not None and not isinstance(source_model_tag_, (bytes, str)):
            raise Exception("Expected source_model_tag_ to be a str, received: {}".format(type(source_model_tag_)))

        if spaces_ is not None and not isinstance(spaces_, (bytes, str, list)):
            raise Exception("Expected spaces_ to be a Sequence, received: {}".format(type(spaces_)))

        if users_ is not None and not isinstance(users_, (bytes, str, list)):
            raise Exception("Expected users_ to be a Sequence, received: {}".format(type(users_)))

        self.applicationofferdetails = applicationofferdetails_
        self.application_alias = application_alias_
        self.application_description = application_description_
        self.bindings = bindings_
        self.endpoints = endpoints_
        self.external_controller = external_controller_
        self.macaroon = macaroon_
        self.offer_name = offer_name_
        self.offer_url = offer_url_
        self.offer_uuid = offer_uuid_
        self.source_model_tag = source_model_tag_
        self.spaces = spaces_
        self.users = users_
        self.unknown_fields = unknown_fields



class ConsumeApplicationArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~ConsumeApplicationArg]
        '''
        args_ = [ConsumeApplicationArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class ConsumeApplicationResult(Type):
    _toSchema = {'error': 'error', 'local_name': 'local-name'}
    _toPy = {'error': 'error', 'local-name': 'local_name'}
    def __init__(self, error=None, local_name=None, **unknown_fields):
        '''
        error : Error
        local_name : str
        '''
        error_ = Error.from_json(error) if error else None
        local_name_ = local_name

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if local_name_ is not None and not isinstance(local_name_, (bytes, str)):
            raise Exception("Expected local_name_ to be a str, received: {}".format(type(local_name_)))

        self.error = error_
        self.local_name = local_name_
        self.unknown_fields = unknown_fields



class ConsumeApplicationResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ConsumeApplicationResult]
        '''
        results_ = [ConsumeApplicationResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ConsumeOfferDetails(Type):
    _toSchema = {'external_controller': 'external-controller', 'macaroon': 'macaroon', 'offer': 'offer'}
    _toPy = {'external-controller': 'external_controller', 'macaroon': 'macaroon', 'offer': 'offer'}
    def __init__(self, external_controller=None, macaroon=None, offer=None, **unknown_fields):
        '''
        external_controller : ExternalControllerInfo
        macaroon : Macaroon
        offer : ApplicationOfferDetails
        '''
        external_controller_ = ExternalControllerInfo.from_json(external_controller) if external_controller else None
        macaroon_ = Macaroon.from_json(macaroon) if macaroon else None
        offer_ = ApplicationOfferDetails.from_json(offer) if offer else None

        # Validate arguments against known Juju API types.
        if external_controller_ is not None and not isinstance(external_controller_, (dict, ExternalControllerInfo)):
            raise Exception("Expected external_controller_ to be a ExternalControllerInfo, received: {}".format(type(external_controller_)))

        if macaroon_ is not None and not isinstance(macaroon_, (dict, Macaroon)):
            raise Exception("Expected macaroon_ to be a Macaroon, received: {}".format(type(macaroon_)))

        if offer_ is not None and not isinstance(offer_, (dict, ApplicationOfferDetails)):
            raise Exception("Expected offer_ to be a ApplicationOfferDetails, received: {}".format(type(offer_)))

        self.external_controller = external_controller_
        self.macaroon = macaroon_
        self.offer = offer_
        self.unknown_fields = unknown_fields



class ConsumeOfferDetailsResult(Type):
    _toSchema = {'consumeofferdetails': 'ConsumeOfferDetails', 'error': 'error', 'external_controller': 'external-controller', 'macaroon': 'macaroon', 'offer': 'offer'}
    _toPy = {'ConsumeOfferDetails': 'consumeofferdetails', 'error': 'error', 'external-controller': 'external_controller', 'macaroon': 'macaroon', 'offer': 'offer'}
    def __init__(self, consumeofferdetails=None, error=None, external_controller=None, macaroon=None, offer=None, **unknown_fields):
        '''
        consumeofferdetails : ConsumeOfferDetails
        error : Error
        external_controller : ExternalControllerInfo
        macaroon : Macaroon
        offer : ApplicationOfferDetails
        '''
        consumeofferdetails_ = ConsumeOfferDetails.from_json(consumeofferdetails) if consumeofferdetails else None
        error_ = Error.from_json(error) if error else None
        external_controller_ = ExternalControllerInfo.from_json(external_controller) if external_controller else None
        macaroon_ = Macaroon.from_json(macaroon) if macaroon else None
        offer_ = ApplicationOfferDetails.from_json(offer) if offer else None

        # Validate arguments against known Juju API types.
        if consumeofferdetails_ is not None and not isinstance(consumeofferdetails_, (dict, ConsumeOfferDetails)):
            raise Exception("Expected consumeofferdetails_ to be a ConsumeOfferDetails, received: {}".format(type(consumeofferdetails_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if external_controller_ is not None and not isinstance(external_controller_, (dict, ExternalControllerInfo)):
            raise Exception("Expected external_controller_ to be a ExternalControllerInfo, received: {}".format(type(external_controller_)))

        if macaroon_ is not None and not isinstance(macaroon_, (dict, Macaroon)):
            raise Exception("Expected macaroon_ to be a Macaroon, received: {}".format(type(macaroon_)))

        if offer_ is not None and not isinstance(offer_, (dict, ApplicationOfferDetails)):
            raise Exception("Expected offer_ to be a ApplicationOfferDetails, received: {}".format(type(offer_)))

        self.consumeofferdetails = consumeofferdetails_
        self.error = error_
        self.external_controller = external_controller_
        self.macaroon = macaroon_
        self.offer = offer_
        self.unknown_fields = unknown_fields



class ConsumeOfferDetailsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ConsumeOfferDetailsResult]
        '''
        results_ = [ConsumeOfferDetailsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ContainerConfig(Type):
    _toSchema = {'apt_mirror': 'apt-mirror', 'apt_proxy': 'apt-proxy', 'authorized_keys': 'authorized-keys', 'cloudinit_userdata': 'cloudinit-userdata', 'container_inherit_properties': 'container-inherit-properties', 'juju_proxy': 'juju-proxy', 'legacy_proxy': 'legacy-proxy', 'provider_type': 'provider-type', 'snap_proxy': 'snap-proxy', 'snap_store_assertions': 'snap-store-assertions', 'snap_store_proxy_id': 'snap-store-proxy-id', 'snap_store_proxy_url': 'snap-store-proxy-url', 'ssl_hostname_verification': 'ssl-hostname-verification', 'updatebehavior': 'UpdateBehavior'}
    _toPy = {'UpdateBehavior': 'updatebehavior', 'apt-mirror': 'apt_mirror', 'apt-proxy': 'apt_proxy', 'authorized-keys': 'authorized_keys', 'cloudinit-userdata': 'cloudinit_userdata', 'container-inherit-properties': 'container_inherit_properties', 'juju-proxy': 'juju_proxy', 'legacy-proxy': 'legacy_proxy', 'provider-type': 'provider_type', 'snap-proxy': 'snap_proxy', 'snap-store-assertions': 'snap_store_assertions', 'snap-store-proxy-id': 'snap_store_proxy_id', 'snap-store-proxy-url': 'snap_store_proxy_url', 'ssl-hostname-verification': 'ssl_hostname_verification'}
    def __init__(self, updatebehavior=None, apt_mirror=None, apt_proxy=None, authorized_keys=None, cloudinit_userdata=None, container_inherit_properties=None, juju_proxy=None, legacy_proxy=None, provider_type=None, snap_proxy=None, snap_store_assertions=None, snap_store_proxy_id=None, snap_store_proxy_url=None, ssl_hostname_verification=None, **unknown_fields):
        '''
        updatebehavior : UpdateBehavior
        apt_mirror : str
        apt_proxy : Settings
        authorized_keys : str
        cloudinit_userdata : typing.Mapping[str, typing.Any]
        container_inherit_properties : str
        juju_proxy : Settings
        legacy_proxy : Settings
        provider_type : str
        snap_proxy : Settings
        snap_store_assertions : str
        snap_store_proxy_id : str
        snap_store_proxy_url : str
        ssl_hostname_verification : bool
        '''
        updatebehavior_ = UpdateBehavior.from_json(updatebehavior) if updatebehavior else None
        apt_mirror_ = apt_mirror
        apt_proxy_ = Settings.from_json(apt_proxy) if apt_proxy else None
        authorized_keys_ = authorized_keys
        cloudinit_userdata_ = cloudinit_userdata
        container_inherit_properties_ = container_inherit_properties
        juju_proxy_ = Settings.from_json(juju_proxy) if juju_proxy else None
        legacy_proxy_ = Settings.from_json(legacy_proxy) if legacy_proxy else None
        provider_type_ = provider_type
        snap_proxy_ = Settings.from_json(snap_proxy) if snap_proxy else None
        snap_store_assertions_ = snap_store_assertions
        snap_store_proxy_id_ = snap_store_proxy_id
        snap_store_proxy_url_ = snap_store_proxy_url
        ssl_hostname_verification_ = ssl_hostname_verification

        # Validate arguments against known Juju API types.
        if updatebehavior_ is not None and not isinstance(updatebehavior_, (dict, UpdateBehavior)):
            raise Exception("Expected updatebehavior_ to be a UpdateBehavior, received: {}".format(type(updatebehavior_)))

        if apt_mirror_ is not None and not isinstance(apt_mirror_, (bytes, str)):
            raise Exception("Expected apt_mirror_ to be a str, received: {}".format(type(apt_mirror_)))

        if apt_proxy_ is not None and not isinstance(apt_proxy_, (dict, Settings)):
            raise Exception("Expected apt_proxy_ to be a Settings, received: {}".format(type(apt_proxy_)))

        if authorized_keys_ is not None and not isinstance(authorized_keys_, (bytes, str)):
            raise Exception("Expected authorized_keys_ to be a str, received: {}".format(type(authorized_keys_)))

        if cloudinit_userdata_ is not None and not isinstance(cloudinit_userdata_, dict):
            raise Exception("Expected cloudinit_userdata_ to be a Mapping, received: {}".format(type(cloudinit_userdata_)))

        if container_inherit_properties_ is not None and not isinstance(container_inherit_properties_, (bytes, str)):
            raise Exception("Expected container_inherit_properties_ to be a str, received: {}".format(type(container_inherit_properties_)))

        if juju_proxy_ is not None and not isinstance(juju_proxy_, (dict, Settings)):
            raise Exception("Expected juju_proxy_ to be a Settings, received: {}".format(type(juju_proxy_)))

        if legacy_proxy_ is not None and not isinstance(legacy_proxy_, (dict, Settings)):
            raise Exception("Expected legacy_proxy_ to be a Settings, received: {}".format(type(legacy_proxy_)))

        if provider_type_ is not None and not isinstance(provider_type_, (bytes, str)):
            raise Exception("Expected provider_type_ to be a str, received: {}".format(type(provider_type_)))

        if snap_proxy_ is not None and not isinstance(snap_proxy_, (dict, Settings)):
            raise Exception("Expected snap_proxy_ to be a Settings, received: {}".format(type(snap_proxy_)))

        if snap_store_assertions_ is not None and not isinstance(snap_store_assertions_, (bytes, str)):
            raise Exception("Expected snap_store_assertions_ to be a str, received: {}".format(type(snap_store_assertions_)))

        if snap_store_proxy_id_ is not None and not isinstance(snap_store_proxy_id_, (bytes, str)):
            raise Exception("Expected snap_store_proxy_id_ to be a str, received: {}".format(type(snap_store_proxy_id_)))

        if snap_store_proxy_url_ is not None and not isinstance(snap_store_proxy_url_, (bytes, str)):
            raise Exception("Expected snap_store_proxy_url_ to be a str, received: {}".format(type(snap_store_proxy_url_)))

        if ssl_hostname_verification_ is not None and not isinstance(ssl_hostname_verification_, bool):
            raise Exception("Expected ssl_hostname_verification_ to be a bool, received: {}".format(type(ssl_hostname_verification_)))

        self.updatebehavior = updatebehavior_
        self.apt_mirror = apt_mirror_
        self.apt_proxy = apt_proxy_
        self.authorized_keys = authorized_keys_
        self.cloudinit_userdata = cloudinit_userdata_
        self.container_inherit_properties = container_inherit_properties_
        self.juju_proxy = juju_proxy_
        self.legacy_proxy = legacy_proxy_
        self.provider_type = provider_type_
        self.snap_proxy = snap_proxy_
        self.snap_store_assertions = snap_store_assertions_
        self.snap_store_proxy_id = snap_store_proxy_id_
        self.snap_store_proxy_url = snap_store_proxy_url_
        self.ssl_hostname_verification = ssl_hostname_verification_
        self.unknown_fields = unknown_fields



class ContainerLXDProfile(Type):
    _toSchema = {'name': 'name', 'profile': 'profile'}
    _toPy = {'name': 'name', 'profile': 'profile'}
    def __init__(self, name=None, profile=None, **unknown_fields):
        '''
        name : str
        profile : CharmLXDProfile
        '''
        name_ = name
        profile_ = CharmLXDProfile.from_json(profile) if profile else None

        # Validate arguments against known Juju API types.
        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if profile_ is not None and not isinstance(profile_, (dict, CharmLXDProfile)):
            raise Exception("Expected profile_ to be a CharmLXDProfile, received: {}".format(type(profile_)))

        self.name = name_
        self.profile = profile_
        self.unknown_fields = unknown_fields



class ContainerManagerConfig(Type):
    _toSchema = {'config': 'config'}
    _toPy = {'config': 'config'}
    def __init__(self, config=None, **unknown_fields):
        '''
        config : typing.Mapping[str, str]
        '''
        config_ = config

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        self.config = config_
        self.unknown_fields = unknown_fields



class ContainerManagerConfigParams(Type):
    _toSchema = {'type_': 'type'}
    _toPy = {'type': 'type_'}
    def __init__(self, type_=None, **unknown_fields):
        '''
        type_ : str
        '''
        type__ = type_

        # Validate arguments against known Juju API types.
        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.type_ = type__
        self.unknown_fields = unknown_fields



class ContainerProfileResult(Type):
    _toSchema = {'error': 'error', 'lxd_profiles': 'lxd-profiles'}
    _toPy = {'error': 'error', 'lxd-profiles': 'lxd_profiles'}
    def __init__(self, error=None, lxd_profiles=None, **unknown_fields):
        '''
        error : Error
        lxd_profiles : typing.Sequence[~ContainerLXDProfile]
        '''
        error_ = Error.from_json(error) if error else None
        lxd_profiles_ = [ContainerLXDProfile.from_json(o) for o in lxd_profiles or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if lxd_profiles_ is not None and not isinstance(lxd_profiles_, (bytes, str, list)):
            raise Exception("Expected lxd_profiles_ to be a Sequence, received: {}".format(type(lxd_profiles_)))

        self.error = error_
        self.lxd_profiles = lxd_profiles_
        self.unknown_fields = unknown_fields



class ContainerProfileResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ContainerProfileResult]
        '''
        results_ = [ContainerProfileResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ContainerTypeResult(Type):
    _toSchema = {'container_type': 'container-type', 'error': 'error'}
    _toPy = {'container-type': 'container_type', 'error': 'error'}
    def __init__(self, container_type=None, error=None, **unknown_fields):
        '''
        container_type : str
        error : Error
        '''
        container_type_ = container_type
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if container_type_ is not None and not isinstance(container_type_, (bytes, str)):
            raise Exception("Expected container_type_ to be a str, received: {}".format(type(container_type_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.container_type = container_type_
        self.error = error_
        self.unknown_fields = unknown_fields



class ControllerAPIInfoResult(Type):
    _toSchema = {'addresses': 'addresses', 'cacert': 'cacert', 'error': 'error'}
    _toPy = {'addresses': 'addresses', 'cacert': 'cacert', 'error': 'error'}
    def __init__(self, addresses=None, cacert=None, error=None, **unknown_fields):
        '''
        addresses : typing.Sequence[str]
        cacert : str
        error : Error
        '''
        addresses_ = addresses
        cacert_ = cacert
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if addresses_ is not None and not isinstance(addresses_, (bytes, str, list)):
            raise Exception("Expected addresses_ to be a Sequence, received: {}".format(type(addresses_)))

        if cacert_ is not None and not isinstance(cacert_, (bytes, str)):
            raise Exception("Expected cacert_ to be a str, received: {}".format(type(cacert_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.addresses = addresses_
        self.cacert = cacert_
        self.error = error_
        self.unknown_fields = unknown_fields



class ControllerAPIInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ControllerAPIInfoResult]
        '''
        results_ = [ControllerAPIInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ControllerConfigResult(Type):
    _toSchema = {'config': 'config'}
    _toPy = {'config': 'config'}
    def __init__(self, config=None, **unknown_fields):
        '''
        config : typing.Mapping[str, typing.Any]
        '''
        config_ = config

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        self.config = config_
        self.unknown_fields = unknown_fields



class ControllerConfigSet(Type):
    _toSchema = {'config': 'config'}
    _toPy = {'config': 'config'}
    def __init__(self, config=None, **unknown_fields):
        '''
        config : typing.Mapping[str, typing.Any]
        '''
        config_ = config

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        self.config = config_
        self.unknown_fields = unknown_fields



class ControllerCredentialInfo(Type):
    _toSchema = {'content': 'content', 'models': 'models'}
    _toPy = {'content': 'content', 'models': 'models'}
    def __init__(self, content=None, models=None, **unknown_fields):
        '''
        content : CredentialContent
        models : typing.Sequence[~ModelAccess]
        '''
        content_ = CredentialContent.from_json(content) if content else None
        models_ = [ModelAccess.from_json(o) for o in models or []]

        # Validate arguments against known Juju API types.
        if content_ is not None and not isinstance(content_, (dict, CredentialContent)):
            raise Exception("Expected content_ to be a CredentialContent, received: {}".format(type(content_)))

        if models_ is not None and not isinstance(models_, (bytes, str, list)):
            raise Exception("Expected models_ to be a Sequence, received: {}".format(type(models_)))

        self.content = content_
        self.models = models_
        self.unknown_fields = unknown_fields



class ControllerVersionResults(Type):
    _toSchema = {'git_commit': 'git-commit', 'version': 'version'}
    _toPy = {'git-commit': 'git_commit', 'version': 'version'}
    def __init__(self, git_commit=None, version=None, **unknown_fields):
        '''
        git_commit : str
        version : str
        '''
        git_commit_ = git_commit
        version_ = version

        # Validate arguments against known Juju API types.
        if git_commit_ is not None and not isinstance(git_commit_, (bytes, str)):
            raise Exception("Expected git_commit_ to be a str, received: {}".format(type(git_commit_)))

        if version_ is not None and not isinstance(version_, (bytes, str)):
            raise Exception("Expected version_ to be a str, received: {}".format(type(version_)))

        self.git_commit = git_commit_
        self.version = version_
        self.unknown_fields = unknown_fields



class ControllersChangeResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ControllersChanges
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ControllersChanges.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ControllersChanges)):
            raise Exception("Expected result_ to be a ControllersChanges, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ControllersChangeResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ControllersChangeResult]
        '''
        results_ = [ControllersChangeResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ControllersChanges(Type):
    _toSchema = {'added': 'added', 'converted': 'converted', 'maintained': 'maintained', 'removed': 'removed'}
    _toPy = {'added': 'added', 'converted': 'converted', 'maintained': 'maintained', 'removed': 'removed'}
    def __init__(self, added=None, converted=None, maintained=None, removed=None, **unknown_fields):
        '''
        added : typing.Sequence[str]
        converted : typing.Sequence[str]
        maintained : typing.Sequence[str]
        removed : typing.Sequence[str]
        '''
        added_ = added
        converted_ = converted
        maintained_ = maintained
        removed_ = removed

        # Validate arguments against known Juju API types.
        if added_ is not None and not isinstance(added_, (bytes, str, list)):
            raise Exception("Expected added_ to be a Sequence, received: {}".format(type(added_)))

        if converted_ is not None and not isinstance(converted_, (bytes, str, list)):
            raise Exception("Expected converted_ to be a Sequence, received: {}".format(type(converted_)))

        if maintained_ is not None and not isinstance(maintained_, (bytes, str, list)):
            raise Exception("Expected maintained_ to be a Sequence, received: {}".format(type(maintained_)))

        if removed_ is not None and not isinstance(removed_, (bytes, str, list)):
            raise Exception("Expected removed_ to be a Sequence, received: {}".format(type(removed_)))

        self.added = added_
        self.converted = converted_
        self.maintained = maintained_
        self.removed = removed_
        self.unknown_fields = unknown_fields



class ControllersSpec(Type):
    _toSchema = {'constraints': 'constraints', 'num_controllers': 'num-controllers', 'placement': 'placement', 'series': 'series'}
    _toPy = {'constraints': 'constraints', 'num-controllers': 'num_controllers', 'placement': 'placement', 'series': 'series'}
    def __init__(self, constraints=None, num_controllers=None, placement=None, series=None, **unknown_fields):
        '''
        constraints : Value
        num_controllers : int
        placement : typing.Sequence[str]
        series : str
        '''
        constraints_ = Value.from_json(constraints) if constraints else None
        num_controllers_ = num_controllers
        placement_ = placement
        series_ = series

        # Validate arguments against known Juju API types.
        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if num_controllers_ is not None and not isinstance(num_controllers_, int):
            raise Exception("Expected num_controllers_ to be a int, received: {}".format(type(num_controllers_)))

        if placement_ is not None and not isinstance(placement_, (bytes, str, list)):
            raise Exception("Expected placement_ to be a Sequence, received: {}".format(type(placement_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        self.constraints = constraints_
        self.num_controllers = num_controllers_
        self.placement = placement_
        self.series = series_
        self.unknown_fields = unknown_fields



class ControllersSpecs(Type):
    _toSchema = {'specs': 'specs'}
    _toPy = {'specs': 'specs'}
    def __init__(self, specs=None, **unknown_fields):
        '''
        specs : typing.Sequence[~ControllersSpec]
        '''
        specs_ = [ControllersSpec.from_json(o) for o in specs or []]

        # Validate arguments against known Juju API types.
        if specs_ is not None and not isinstance(specs_, (bytes, str, list)):
            raise Exception("Expected specs_ to be a Sequence, received: {}".format(type(specs_)))

        self.specs = specs_
        self.unknown_fields = unknown_fields



class CreateSpaceParams(Type):
    _toSchema = {'cidrs': 'cidrs', 'provider_id': 'provider-id', 'public': 'public', 'space_tag': 'space-tag'}
    _toPy = {'cidrs': 'cidrs', 'provider-id': 'provider_id', 'public': 'public', 'space-tag': 'space_tag'}
    def __init__(self, cidrs=None, provider_id=None, public=None, space_tag=None, **unknown_fields):
        '''
        cidrs : typing.Sequence[str]
        provider_id : str
        public : bool
        space_tag : str
        '''
        cidrs_ = cidrs
        provider_id_ = provider_id
        public_ = public
        space_tag_ = space_tag

        # Validate arguments against known Juju API types.
        if cidrs_ is not None and not isinstance(cidrs_, (bytes, str, list)):
            raise Exception("Expected cidrs_ to be a Sequence, received: {}".format(type(cidrs_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if public_ is not None and not isinstance(public_, bool):
            raise Exception("Expected public_ to be a bool, received: {}".format(type(public_)))

        if space_tag_ is not None and not isinstance(space_tag_, (bytes, str)):
            raise Exception("Expected space_tag_ to be a str, received: {}".format(type(space_tag_)))

        self.cidrs = cidrs_
        self.provider_id = provider_id_
        self.public = public_
        self.space_tag = space_tag_
        self.unknown_fields = unknown_fields



class CreateSpacesParams(Type):
    _toSchema = {'spaces': 'spaces'}
    _toPy = {'spaces': 'spaces'}
    def __init__(self, spaces=None, **unknown_fields):
        '''
        spaces : typing.Sequence[~CreateSpaceParams]
        '''
        spaces_ = [CreateSpaceParams.from_json(o) for o in spaces or []]

        # Validate arguments against known Juju API types.
        if spaces_ is not None and not isinstance(spaces_, (bytes, str, list)):
            raise Exception("Expected spaces_ to be a Sequence, received: {}".format(type(spaces_)))

        self.spaces = spaces_
        self.unknown_fields = unknown_fields



class CredentialContent(Type):
    _toSchema = {'attrs': 'attrs', 'auth_type': 'auth-type', 'cloud': 'cloud', 'name': 'name', 'valid': 'valid'}
    _toPy = {'attrs': 'attrs', 'auth-type': 'auth_type', 'cloud': 'cloud', 'name': 'name', 'valid': 'valid'}
    def __init__(self, attrs=None, auth_type=None, cloud=None, name=None, valid=None, **unknown_fields):
        '''
        attrs : typing.Mapping[str, str]
        auth_type : str
        cloud : str
        name : str
        valid : bool
        '''
        attrs_ = attrs
        auth_type_ = auth_type
        cloud_ = cloud
        name_ = name
        valid_ = valid

        # Validate arguments against known Juju API types.
        if attrs_ is not None and not isinstance(attrs_, dict):
            raise Exception("Expected attrs_ to be a Mapping, received: {}".format(type(attrs_)))

        if auth_type_ is not None and not isinstance(auth_type_, (bytes, str)):
            raise Exception("Expected auth_type_ to be a str, received: {}".format(type(auth_type_)))

        if cloud_ is not None and not isinstance(cloud_, (bytes, str)):
            raise Exception("Expected cloud_ to be a str, received: {}".format(type(cloud_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if valid_ is not None and not isinstance(valid_, bool):
            raise Exception("Expected valid_ to be a bool, received: {}".format(type(valid_)))

        self.attrs = attrs_
        self.auth_type = auth_type_
        self.cloud = cloud_
        self.name = name_
        self.valid = valid_
        self.unknown_fields = unknown_fields



class CredentialContentResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ControllerCredentialInfo
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ControllerCredentialInfo.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ControllerCredentialInfo)):
            raise Exception("Expected result_ to be a ControllerCredentialInfo, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class CredentialContentResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~CredentialContentResult]
        '''
        results_ = [CredentialContentResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class Delta(Type):
    _toSchema = {'entity': 'entity', 'removed': 'removed'}
    _toPy = {'entity': 'entity', 'removed': 'removed'}
    def __init__(self, entity=None, removed=None, **unknown_fields):
        '''
        entity : Any
        removed : bool
        '''
        entity_ = entity
        removed_ = removed

        # Validate arguments against known Juju API types.
        if removed_ is not None and not isinstance(removed_, bool):
            raise Exception("Expected removed_ to be a bool, received: {}".format(type(removed_)))

        self.entity = entity_
        self.removed = removed_
        self.unknown_fields = unknown_fields



class DeployerConnectionValues(Type):
    _toSchema = {'api_addresses': 'api-addresses'}
    _toPy = {'api-addresses': 'api_addresses'}
    def __init__(self, api_addresses=None, **unknown_fields):
        '''
        api_addresses : typing.Sequence[str]
        '''
        api_addresses_ = api_addresses

        # Validate arguments against known Juju API types.
        if api_addresses_ is not None and not isinstance(api_addresses_, (bytes, str, list)):
            raise Exception("Expected api_addresses_ to be a Sequence, received: {}".format(type(api_addresses_)))

        self.api_addresses = api_addresses_
        self.unknown_fields = unknown_fields



class DestroyApplicationInfo(Type):
    _toSchema = {'destroyed_storage': 'destroyed-storage', 'destroyed_units': 'destroyed-units', 'detached_storage': 'detached-storage'}
    _toPy = {'destroyed-storage': 'destroyed_storage', 'destroyed-units': 'destroyed_units', 'detached-storage': 'detached_storage'}
    def __init__(self, destroyed_storage=None, destroyed_units=None, detached_storage=None, **unknown_fields):
        '''
        destroyed_storage : typing.Sequence[~Entity]
        destroyed_units : typing.Sequence[~Entity]
        detached_storage : typing.Sequence[~Entity]
        '''
        destroyed_storage_ = [Entity.from_json(o) for o in destroyed_storage or []]
        destroyed_units_ = [Entity.from_json(o) for o in destroyed_units or []]
        detached_storage_ = [Entity.from_json(o) for o in detached_storage or []]

        # Validate arguments against known Juju API types.
        if destroyed_storage_ is not None and not isinstance(destroyed_storage_, (bytes, str, list)):
            raise Exception("Expected destroyed_storage_ to be a Sequence, received: {}".format(type(destroyed_storage_)))

        if destroyed_units_ is not None and not isinstance(destroyed_units_, (bytes, str, list)):
            raise Exception("Expected destroyed_units_ to be a Sequence, received: {}".format(type(destroyed_units_)))

        if detached_storage_ is not None and not isinstance(detached_storage_, (bytes, str, list)):
            raise Exception("Expected detached_storage_ to be a Sequence, received: {}".format(type(detached_storage_)))

        self.destroyed_storage = destroyed_storage_
        self.destroyed_units = destroyed_units_
        self.detached_storage = detached_storage_
        self.unknown_fields = unknown_fields



class DestroyApplicationOffers(Type):
    _toSchema = {'force': 'force', 'offer_urls': 'offer-urls'}
    _toPy = {'force': 'force', 'offer-urls': 'offer_urls'}
    def __init__(self, force=None, offer_urls=None, **unknown_fields):
        '''
        force : bool
        offer_urls : typing.Sequence[str]
        '''
        force_ = force
        offer_urls_ = offer_urls

        # Validate arguments against known Juju API types.
        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if offer_urls_ is not None and not isinstance(offer_urls_, (bytes, str, list)):
            raise Exception("Expected offer_urls_ to be a Sequence, received: {}".format(type(offer_urls_)))

        self.force = force_
        self.offer_urls = offer_urls_
        self.unknown_fields = unknown_fields



class DestroyApplicationParams(Type):
    _toSchema = {'application_tag': 'application-tag', 'destroy_storage': 'destroy-storage', 'force': 'force', 'max_wait': 'max-wait'}
    _toPy = {'application-tag': 'application_tag', 'destroy-storage': 'destroy_storage', 'force': 'force', 'max-wait': 'max_wait'}
    def __init__(self, application_tag=None, destroy_storage=None, force=None, max_wait=None, **unknown_fields):
        '''
        application_tag : str
        destroy_storage : bool
        force : bool
        max_wait : int
        '''
        application_tag_ = application_tag
        destroy_storage_ = destroy_storage
        force_ = force
        max_wait_ = max_wait

        # Validate arguments against known Juju API types.
        if application_tag_ is not None and not isinstance(application_tag_, (bytes, str)):
            raise Exception("Expected application_tag_ to be a str, received: {}".format(type(application_tag_)))

        if destroy_storage_ is not None and not isinstance(destroy_storage_, bool):
            raise Exception("Expected destroy_storage_ to be a bool, received: {}".format(type(destroy_storage_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if max_wait_ is not None and not isinstance(max_wait_, int):
            raise Exception("Expected max_wait_ to be a int, received: {}".format(type(max_wait_)))

        self.application_tag = application_tag_
        self.destroy_storage = destroy_storage_
        self.force = force_
        self.max_wait = max_wait_
        self.unknown_fields = unknown_fields



class DestroyApplicationResult(Type):
    _toSchema = {'error': 'error', 'info': 'info'}
    _toPy = {'error': 'error', 'info': 'info'}
    def __init__(self, error=None, info=None, **unknown_fields):
        '''
        error : Error
        info : DestroyApplicationInfo
        '''
        error_ = Error.from_json(error) if error else None
        info_ = DestroyApplicationInfo.from_json(info) if info else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if info_ is not None and not isinstance(info_, (dict, DestroyApplicationInfo)):
            raise Exception("Expected info_ to be a DestroyApplicationInfo, received: {}".format(type(info_)))

        self.error = error_
        self.info = info_
        self.unknown_fields = unknown_fields



class DestroyApplicationResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~DestroyApplicationResult]
        '''
        results_ = [DestroyApplicationResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class DestroyApplicationUnits(Type):
    _toSchema = {'unit_names': 'unit-names'}
    _toPy = {'unit-names': 'unit_names'}
    def __init__(self, unit_names=None, **unknown_fields):
        '''
        unit_names : typing.Sequence[str]
        '''
        unit_names_ = unit_names

        # Validate arguments against known Juju API types.
        if unit_names_ is not None and not isinstance(unit_names_, (bytes, str, list)):
            raise Exception("Expected unit_names_ to be a Sequence, received: {}".format(type(unit_names_)))

        self.unit_names = unit_names_
        self.unknown_fields = unknown_fields



class DestroyApplicationsParams(Type):
    _toSchema = {'applications': 'applications'}
    _toPy = {'applications': 'applications'}
    def __init__(self, applications=None, **unknown_fields):
        '''
        applications : typing.Sequence[~DestroyApplicationParams]
        '''
        applications_ = [DestroyApplicationParams.from_json(o) for o in applications or []]

        # Validate arguments against known Juju API types.
        if applications_ is not None and not isinstance(applications_, (bytes, str, list)):
            raise Exception("Expected applications_ to be a Sequence, received: {}".format(type(applications_)))

        self.applications = applications_
        self.unknown_fields = unknown_fields



class DestroyConsumedApplicationParams(Type):
    _toSchema = {'application_tag': 'application-tag', 'force': 'force', 'max_wait': 'max-wait'}
    _toPy = {'application-tag': 'application_tag', 'force': 'force', 'max-wait': 'max_wait'}
    def __init__(self, application_tag=None, force=None, max_wait=None, **unknown_fields):
        '''
        application_tag : str
        force : bool
        max_wait : int
        '''
        application_tag_ = application_tag
        force_ = force
        max_wait_ = max_wait

        # Validate arguments against known Juju API types.
        if application_tag_ is not None and not isinstance(application_tag_, (bytes, str)):
            raise Exception("Expected application_tag_ to be a str, received: {}".format(type(application_tag_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if max_wait_ is not None and not isinstance(max_wait_, int):
            raise Exception("Expected max_wait_ to be a int, received: {}".format(type(max_wait_)))

        self.application_tag = application_tag_
        self.force = force_
        self.max_wait = max_wait_
        self.unknown_fields = unknown_fields



class DestroyConsumedApplicationsParams(Type):
    _toSchema = {'applications': 'applications'}
    _toPy = {'applications': 'applications'}
    def __init__(self, applications=None, **unknown_fields):
        '''
        applications : typing.Sequence[~DestroyConsumedApplicationParams]
        '''
        applications_ = [DestroyConsumedApplicationParams.from_json(o) for o in applications or []]

        # Validate arguments against known Juju API types.
        if applications_ is not None and not isinstance(applications_, (bytes, str, list)):
            raise Exception("Expected applications_ to be a Sequence, received: {}".format(type(applications_)))

        self.applications = applications_
        self.unknown_fields = unknown_fields



class DestroyControllerArgs(Type):
    _toSchema = {'destroy_models': 'destroy-models', 'destroy_storage': 'destroy-storage'}
    _toPy = {'destroy-models': 'destroy_models', 'destroy-storage': 'destroy_storage'}
    def __init__(self, destroy_models=None, destroy_storage=None, **unknown_fields):
        '''
        destroy_models : bool
        destroy_storage : bool
        '''
        destroy_models_ = destroy_models
        destroy_storage_ = destroy_storage

        # Validate arguments against known Juju API types.
        if destroy_models_ is not None and not isinstance(destroy_models_, bool):
            raise Exception("Expected destroy_models_ to be a bool, received: {}".format(type(destroy_models_)))

        if destroy_storage_ is not None and not isinstance(destroy_storage_, bool):
            raise Exception("Expected destroy_storage_ to be a bool, received: {}".format(type(destroy_storage_)))

        self.destroy_models = destroy_models_
        self.destroy_storage = destroy_storage_
        self.unknown_fields = unknown_fields



class DestroyMachineInfo(Type):
    _toSchema = {'destroyed_storage': 'destroyed-storage', 'destroyed_units': 'destroyed-units', 'detached_storage': 'detached-storage'}
    _toPy = {'destroyed-storage': 'destroyed_storage', 'destroyed-units': 'destroyed_units', 'detached-storage': 'detached_storage'}
    def __init__(self, destroyed_storage=None, destroyed_units=None, detached_storage=None, **unknown_fields):
        '''
        destroyed_storage : typing.Sequence[~Entity]
        destroyed_units : typing.Sequence[~Entity]
        detached_storage : typing.Sequence[~Entity]
        '''
        destroyed_storage_ = [Entity.from_json(o) for o in destroyed_storage or []]
        destroyed_units_ = [Entity.from_json(o) for o in destroyed_units or []]
        detached_storage_ = [Entity.from_json(o) for o in detached_storage or []]

        # Validate arguments against known Juju API types.
        if destroyed_storage_ is not None and not isinstance(destroyed_storage_, (bytes, str, list)):
            raise Exception("Expected destroyed_storage_ to be a Sequence, received: {}".format(type(destroyed_storage_)))

        if destroyed_units_ is not None and not isinstance(destroyed_units_, (bytes, str, list)):
            raise Exception("Expected destroyed_units_ to be a Sequence, received: {}".format(type(destroyed_units_)))

        if detached_storage_ is not None and not isinstance(detached_storage_, (bytes, str, list)):
            raise Exception("Expected detached_storage_ to be a Sequence, received: {}".format(type(detached_storage_)))

        self.destroyed_storage = destroyed_storage_
        self.destroyed_units = destroyed_units_
        self.detached_storage = detached_storage_
        self.unknown_fields = unknown_fields



class DestroyMachineResult(Type):
    _toSchema = {'error': 'error', 'info': 'info'}
    _toPy = {'error': 'error', 'info': 'info'}
    def __init__(self, error=None, info=None, **unknown_fields):
        '''
        error : Error
        info : DestroyMachineInfo
        '''
        error_ = Error.from_json(error) if error else None
        info_ = DestroyMachineInfo.from_json(info) if info else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if info_ is not None and not isinstance(info_, (dict, DestroyMachineInfo)):
            raise Exception("Expected info_ to be a DestroyMachineInfo, received: {}".format(type(info_)))

        self.error = error_
        self.info = info_
        self.unknown_fields = unknown_fields



class DestroyMachineResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~DestroyMachineResult]
        '''
        results_ = [DestroyMachineResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class DestroyMachines(Type):
    _toSchema = {'force': 'force', 'machine_names': 'machine-names'}
    _toPy = {'force': 'force', 'machine-names': 'machine_names'}
    def __init__(self, force=None, machine_names=None, **unknown_fields):
        '''
        force : bool
        machine_names : typing.Sequence[str]
        '''
        force_ = force
        machine_names_ = machine_names

        # Validate arguments against known Juju API types.
        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if machine_names_ is not None and not isinstance(machine_names_, (bytes, str, list)):
            raise Exception("Expected machine_names_ to be a Sequence, received: {}".format(type(machine_names_)))

        self.force = force_
        self.machine_names = machine_names_
        self.unknown_fields = unknown_fields



class DestroyMachinesParams(Type):
    _toSchema = {'force': 'force', 'keep': 'keep', 'machine_tags': 'machine-tags', 'max_wait': 'max-wait'}
    _toPy = {'force': 'force', 'keep': 'keep', 'machine-tags': 'machine_tags', 'max-wait': 'max_wait'}
    def __init__(self, force=None, keep=None, machine_tags=None, max_wait=None, **unknown_fields):
        '''
        force : bool
        keep : bool
        machine_tags : typing.Sequence[str]
        max_wait : int
        '''
        force_ = force
        keep_ = keep
        machine_tags_ = machine_tags
        max_wait_ = max_wait

        # Validate arguments against known Juju API types.
        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if keep_ is not None and not isinstance(keep_, bool):
            raise Exception("Expected keep_ to be a bool, received: {}".format(type(keep_)))

        if machine_tags_ is not None and not isinstance(machine_tags_, (bytes, str, list)):
            raise Exception("Expected machine_tags_ to be a Sequence, received: {}".format(type(machine_tags_)))

        if max_wait_ is not None and not isinstance(max_wait_, int):
            raise Exception("Expected max_wait_ to be a int, received: {}".format(type(max_wait_)))

        self.force = force_
        self.keep = keep_
        self.machine_tags = machine_tags_
        self.max_wait = max_wait_
        self.unknown_fields = unknown_fields



class DestroyModelParams(Type):
    _toSchema = {'destroy_storage': 'destroy-storage', 'force': 'force', 'max_wait': 'max-wait', 'model_tag': 'model-tag'}
    _toPy = {'destroy-storage': 'destroy_storage', 'force': 'force', 'max-wait': 'max_wait', 'model-tag': 'model_tag'}
    def __init__(self, destroy_storage=None, force=None, max_wait=None, model_tag=None, **unknown_fields):
        '''
        destroy_storage : bool
        force : bool
        max_wait : int
        model_tag : str
        '''
        destroy_storage_ = destroy_storage
        force_ = force
        max_wait_ = max_wait
        model_tag_ = model_tag

        # Validate arguments against known Juju API types.
        if destroy_storage_ is not None and not isinstance(destroy_storage_, bool):
            raise Exception("Expected destroy_storage_ to be a bool, received: {}".format(type(destroy_storage_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if max_wait_ is not None and not isinstance(max_wait_, int):
            raise Exception("Expected max_wait_ to be a int, received: {}".format(type(max_wait_)))

        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        self.destroy_storage = destroy_storage_
        self.force = force_
        self.max_wait = max_wait_
        self.model_tag = model_tag_
        self.unknown_fields = unknown_fields



class DestroyModelsParams(Type):
    _toSchema = {'models': 'models'}
    _toPy = {'models': 'models'}
    def __init__(self, models=None, **unknown_fields):
        '''
        models : typing.Sequence[~DestroyModelParams]
        '''
        models_ = [DestroyModelParams.from_json(o) for o in models or []]

        # Validate arguments against known Juju API types.
        if models_ is not None and not isinstance(models_, (bytes, str, list)):
            raise Exception("Expected models_ to be a Sequence, received: {}".format(type(models_)))

        self.models = models_
        self.unknown_fields = unknown_fields



class DestroyRelation(Type):
    _toSchema = {'endpoints': 'endpoints', 'force': 'force', 'max_wait': 'max-wait', 'relation_id': 'relation-id'}
    _toPy = {'endpoints': 'endpoints', 'force': 'force', 'max-wait': 'max_wait', 'relation-id': 'relation_id'}
    def __init__(self, endpoints=None, force=None, max_wait=None, relation_id=None, **unknown_fields):
        '''
        endpoints : typing.Sequence[str]
        force : bool
        max_wait : int
        relation_id : int
        '''
        endpoints_ = endpoints
        force_ = force
        max_wait_ = max_wait
        relation_id_ = relation_id

        # Validate arguments against known Juju API types.
        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if max_wait_ is not None and not isinstance(max_wait_, int):
            raise Exception("Expected max_wait_ to be a int, received: {}".format(type(max_wait_)))

        if relation_id_ is not None and not isinstance(relation_id_, int):
            raise Exception("Expected relation_id_ to be a int, received: {}".format(type(relation_id_)))

        self.endpoints = endpoints_
        self.force = force_
        self.max_wait = max_wait_
        self.relation_id = relation_id_
        self.unknown_fields = unknown_fields



class DestroyUnitInfo(Type):
    _toSchema = {'destroyed_storage': 'destroyed-storage', 'detached_storage': 'detached-storage'}
    _toPy = {'destroyed-storage': 'destroyed_storage', 'detached-storage': 'detached_storage'}
    def __init__(self, destroyed_storage=None, detached_storage=None, **unknown_fields):
        '''
        destroyed_storage : typing.Sequence[~Entity]
        detached_storage : typing.Sequence[~Entity]
        '''
        destroyed_storage_ = [Entity.from_json(o) for o in destroyed_storage or []]
        detached_storage_ = [Entity.from_json(o) for o in detached_storage or []]

        # Validate arguments against known Juju API types.
        if destroyed_storage_ is not None and not isinstance(destroyed_storage_, (bytes, str, list)):
            raise Exception("Expected destroyed_storage_ to be a Sequence, received: {}".format(type(destroyed_storage_)))

        if detached_storage_ is not None and not isinstance(detached_storage_, (bytes, str, list)):
            raise Exception("Expected detached_storage_ to be a Sequence, received: {}".format(type(detached_storage_)))

        self.destroyed_storage = destroyed_storage_
        self.detached_storage = detached_storage_
        self.unknown_fields = unknown_fields



class DestroyUnitParams(Type):
    _toSchema = {'destroy_storage': 'destroy-storage', 'force': 'force', 'max_wait': 'max-wait', 'unit_tag': 'unit-tag'}
    _toPy = {'destroy-storage': 'destroy_storage', 'force': 'force', 'max-wait': 'max_wait', 'unit-tag': 'unit_tag'}
    def __init__(self, destroy_storage=None, force=None, max_wait=None, unit_tag=None, **unknown_fields):
        '''
        destroy_storage : bool
        force : bool
        max_wait : int
        unit_tag : str
        '''
        destroy_storage_ = destroy_storage
        force_ = force
        max_wait_ = max_wait
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if destroy_storage_ is not None and not isinstance(destroy_storage_, bool):
            raise Exception("Expected destroy_storage_ to be a bool, received: {}".format(type(destroy_storage_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if max_wait_ is not None and not isinstance(max_wait_, int):
            raise Exception("Expected max_wait_ to be a int, received: {}".format(type(max_wait_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.destroy_storage = destroy_storage_
        self.force = force_
        self.max_wait = max_wait_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class DestroyUnitResult(Type):
    _toSchema = {'error': 'error', 'info': 'info'}
    _toPy = {'error': 'error', 'info': 'info'}
    def __init__(self, error=None, info=None, **unknown_fields):
        '''
        error : Error
        info : DestroyUnitInfo
        '''
        error_ = Error.from_json(error) if error else None
        info_ = DestroyUnitInfo.from_json(info) if info else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if info_ is not None and not isinstance(info_, (dict, DestroyUnitInfo)):
            raise Exception("Expected info_ to be a DestroyUnitInfo, received: {}".format(type(info_)))

        self.error = error_
        self.info = info_
        self.unknown_fields = unknown_fields



class DestroyUnitResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~DestroyUnitResult]
        '''
        results_ = [DestroyUnitResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class DestroyUnitsParams(Type):
    _toSchema = {'units': 'units'}
    _toPy = {'units': 'units'}
    def __init__(self, units=None, **unknown_fields):
        '''
        units : typing.Sequence[~DestroyUnitParams]
        '''
        units_ = [DestroyUnitParams.from_json(o) for o in units or []]

        # Validate arguments against known Juju API types.
        if units_ is not None and not isinstance(units_, (bytes, str, list)):
            raise Exception("Expected units_ to be a Sequence, received: {}".format(type(units_)))

        self.units = units_
        self.unknown_fields = unknown_fields



class DetailedStatus(Type):
    _toSchema = {'data': 'data', 'err': 'err', 'info': 'info', 'kind': 'kind', 'life': 'life', 'since': 'since', 'status': 'status', 'version': 'version'}
    _toPy = {'data': 'data', 'err': 'err', 'info': 'info', 'kind': 'kind', 'life': 'life', 'since': 'since', 'status': 'status', 'version': 'version'}
    def __init__(self, data=None, err=None, info=None, kind=None, life=None, since=None, status=None, version=None, **unknown_fields):
        '''
        data : typing.Mapping[str, typing.Any]
        err : Error
        info : str
        kind : str
        life : str
        since : str
        status : str
        version : str
        '''
        data_ = data
        err_ = Error.from_json(err) if err else None
        info_ = info
        kind_ = kind
        life_ = life
        since_ = since
        status_ = status
        version_ = version

        # Validate arguments against known Juju API types.
        if data_ is not None and not isinstance(data_, dict):
            raise Exception("Expected data_ to be a Mapping, received: {}".format(type(data_)))

        if err_ is not None and not isinstance(err_, (dict, Error)):
            raise Exception("Expected err_ to be a Error, received: {}".format(type(err_)))

        if info_ is not None and not isinstance(info_, (bytes, str)):
            raise Exception("Expected info_ to be a str, received: {}".format(type(info_)))

        if kind_ is not None and not isinstance(kind_, (bytes, str)):
            raise Exception("Expected kind_ to be a str, received: {}".format(type(kind_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if since_ is not None and not isinstance(since_, (bytes, str)):
            raise Exception("Expected since_ to be a str, received: {}".format(type(since_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if version_ is not None and not isinstance(version_, (bytes, str)):
            raise Exception("Expected version_ to be a str, received: {}".format(type(version_)))

        self.data = data_
        self.err = err_
        self.info = info_
        self.kind = kind_
        self.life = life_
        self.since = since_
        self.status = status_
        self.version = version_
        self.unknown_fields = unknown_fields



class DeviceBridgeInfo(Type):
    _toSchema = {'bridge_name': 'bridge-name', 'host_device_name': 'host-device-name', 'mac_address': 'mac-address'}
    _toPy = {'bridge-name': 'bridge_name', 'host-device-name': 'host_device_name', 'mac-address': 'mac_address'}
    def __init__(self, bridge_name=None, host_device_name=None, mac_address=None, **unknown_fields):
        '''
        bridge_name : str
        host_device_name : str
        mac_address : str
        '''
        bridge_name_ = bridge_name
        host_device_name_ = host_device_name
        mac_address_ = mac_address

        # Validate arguments against known Juju API types.
        if bridge_name_ is not None and not isinstance(bridge_name_, (bytes, str)):
            raise Exception("Expected bridge_name_ to be a str, received: {}".format(type(bridge_name_)))

        if host_device_name_ is not None and not isinstance(host_device_name_, (bytes, str)):
            raise Exception("Expected host_device_name_ to be a str, received: {}".format(type(host_device_name_)))

        if mac_address_ is not None and not isinstance(mac_address_, (bytes, str)):
            raise Exception("Expected mac_address_ to be a str, received: {}".format(type(mac_address_)))

        self.bridge_name = bridge_name_
        self.host_device_name = host_device_name_
        self.mac_address = mac_address_
        self.unknown_fields = unknown_fields



class DiscoverSpacesResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ProviderSpace]
        '''
        results_ = [ProviderSpace.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class DistributionGroupResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : typing.Sequence[str]
        '''
        error_ = Error.from_json(error) if error else None
        result_ = result

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (bytes, str, list)):
            raise Exception("Expected result_ to be a Sequence, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class DistributionGroupResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~DistributionGroupResult]
        '''
        results_ = [DistributionGroupResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class DumpModelRequest(Type):
    _toSchema = {'entities': 'entities', 'simplified': 'simplified'}
    _toPy = {'entities': 'entities', 'simplified': 'simplified'}
    def __init__(self, entities=None, simplified=None, **unknown_fields):
        '''
        entities : typing.Sequence[~Entity]
        simplified : bool
        '''
        entities_ = [Entity.from_json(o) for o in entities or []]
        simplified_ = simplified

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        if simplified_ is not None and not isinstance(simplified_, bool):
            raise Exception("Expected simplified_ to be a bool, received: {}".format(type(simplified_)))

        self.entities = entities_
        self.simplified = simplified_
        self.unknown_fields = unknown_fields



class Endpoint(Type):
    _toSchema = {'application_name': 'application-name', 'relation': 'relation'}
    _toPy = {'application-name': 'application_name', 'relation': 'relation'}
    def __init__(self, application_name=None, relation=None, **unknown_fields):
        '''
        application_name : str
        relation : CharmRelation
        '''
        application_name_ = application_name
        relation_ = CharmRelation.from_json(relation) if relation else None

        # Validate arguments against known Juju API types.
        if application_name_ is not None and not isinstance(application_name_, (bytes, str)):
            raise Exception("Expected application_name_ to be a str, received: {}".format(type(application_name_)))

        if relation_ is not None and not isinstance(relation_, (dict, CharmRelation)):
            raise Exception("Expected relation_ to be a CharmRelation, received: {}".format(type(relation_)))

        self.application_name = application_name_
        self.relation = relation_
        self.unknown_fields = unknown_fields



class EndpointFilterAttributes(Type):
    _toSchema = {'interface': 'interface', 'name': 'name', 'role': 'role'}
    _toPy = {'interface': 'interface', 'name': 'name', 'role': 'role'}
    def __init__(self, interface=None, name=None, role=None, **unknown_fields):
        '''
        interface : str
        name : str
        role : str
        '''
        interface_ = interface
        name_ = name
        role_ = role

        # Validate arguments against known Juju API types.
        if interface_ is not None and not isinstance(interface_, (bytes, str)):
            raise Exception("Expected interface_ to be a str, received: {}".format(type(interface_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if role_ is not None and not isinstance(role_, (bytes, str)):
            raise Exception("Expected role_ to be a str, received: {}".format(type(role_)))

        self.interface = interface_
        self.name = name_
        self.role = role_
        self.unknown_fields = unknown_fields



class EndpointRelationData(Type):
    _toSchema = {'applicationdata': 'ApplicationData', 'cross_model': 'cross-model', 'endpoint': 'endpoint', 'related_endpoint': 'related-endpoint', 'unit_relation_data': 'unit-relation-data'}
    _toPy = {'ApplicationData': 'applicationdata', 'cross-model': 'cross_model', 'endpoint': 'endpoint', 'related-endpoint': 'related_endpoint', 'unit-relation-data': 'unit_relation_data'}
    def __init__(self, applicationdata=None, cross_model=None, endpoint=None, related_endpoint=None, unit_relation_data=None, **unknown_fields):
        '''
        applicationdata : typing.Mapping[str, typing.Any]
        cross_model : bool
        endpoint : str
        related_endpoint : str
        unit_relation_data : typing.Mapping[str, ~RelationData]
        '''
        applicationdata_ = applicationdata
        cross_model_ = cross_model
        endpoint_ = endpoint
        related_endpoint_ = related_endpoint
        unit_relation_data_ = {k: RelationData.from_json(v) for k, v in (unit_relation_data or dict()).items()}

        # Validate arguments against known Juju API types.
        if applicationdata_ is not None and not isinstance(applicationdata_, dict):
            raise Exception("Expected applicationdata_ to be a Mapping, received: {}".format(type(applicationdata_)))

        if cross_model_ is not None and not isinstance(cross_model_, bool):
            raise Exception("Expected cross_model_ to be a bool, received: {}".format(type(cross_model_)))

        if endpoint_ is not None and not isinstance(endpoint_, (bytes, str)):
            raise Exception("Expected endpoint_ to be a str, received: {}".format(type(endpoint_)))

        if related_endpoint_ is not None and not isinstance(related_endpoint_, (bytes, str)):
            raise Exception("Expected related_endpoint_ to be a str, received: {}".format(type(related_endpoint_)))

        if unit_relation_data_ is not None and not isinstance(unit_relation_data_, dict):
            raise Exception("Expected unit_relation_data_ to be a Mapping, received: {}".format(type(unit_relation_data_)))

        self.applicationdata = applicationdata_
        self.cross_model = cross_model_
        self.endpoint = endpoint_
        self.related_endpoint = related_endpoint_
        self.unit_relation_data = unit_relation_data_
        self.unknown_fields = unknown_fields



class EndpointStatus(Type):
    _toSchema = {'application': 'application', 'name': 'name', 'role': 'role', 'subordinate': 'subordinate'}
    _toPy = {'application': 'application', 'name': 'name', 'role': 'role', 'subordinate': 'subordinate'}
    def __init__(self, application=None, name=None, role=None, subordinate=None, **unknown_fields):
        '''
        application : str
        name : str
        role : str
        subordinate : bool
        '''
        application_ = application
        name_ = name
        role_ = role
        subordinate_ = subordinate

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if role_ is not None and not isinstance(role_, (bytes, str)):
            raise Exception("Expected role_ to be a str, received: {}".format(type(role_)))

        if subordinate_ is not None and not isinstance(subordinate_, bool):
            raise Exception("Expected subordinate_ to be a bool, received: {}".format(type(subordinate_)))

        self.application = application_
        self.name = name_
        self.role = role_
        self.subordinate = subordinate_
        self.unknown_fields = unknown_fields



class EnqueuedActions(Type):
    _toSchema = {'actions': 'actions', 'operation': 'operation'}
    _toPy = {'actions': 'actions', 'operation': 'operation'}
    def __init__(self, actions=None, operation=None, **unknown_fields):
        '''
        actions : typing.Sequence[~StringResult]
        operation : str
        '''
        actions_ = [StringResult.from_json(o) for o in actions or []]
        operation_ = operation

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (bytes, str, list)):
            raise Exception("Expected actions_ to be a Sequence, received: {}".format(type(actions_)))

        if operation_ is not None and not isinstance(operation_, (bytes, str)):
            raise Exception("Expected operation_ to be a str, received: {}".format(type(operation_)))

        self.actions = actions_
        self.operation = operation_
        self.unknown_fields = unknown_fields



class Entities(Type):
    _toSchema = {'entities': 'entities'}
    _toPy = {'entities': 'entities'}
    def __init__(self, entities=None, **unknown_fields):
        '''
        entities : typing.Sequence[~Entity]
        '''
        entities_ = [Entity.from_json(o) for o in entities or []]

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        self.entities = entities_
        self.unknown_fields = unknown_fields



class EntitiesCharmURL(Type):
    _toSchema = {'entities': 'entities'}
    _toPy = {'entities': 'entities'}
    def __init__(self, entities=None, **unknown_fields):
        '''
        entities : typing.Sequence[~EntityCharmURL]
        '''
        entities_ = [EntityCharmURL.from_json(o) for o in entities or []]

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        self.entities = entities_
        self.unknown_fields = unknown_fields



class EntitiesPortRanges(Type):
    _toSchema = {'entities': 'entities'}
    _toPy = {'entities': 'entities'}
    def __init__(self, entities=None, **unknown_fields):
        '''
        entities : typing.Sequence[~EntityPortRange]
        '''
        entities_ = [EntityPortRange.from_json(o) for o in entities or []]

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        self.entities = entities_
        self.unknown_fields = unknown_fields



class EntitiesResult(Type):
    _toSchema = {'entities': 'entities', 'error': 'error'}
    _toPy = {'entities': 'entities', 'error': 'error'}
    def __init__(self, entities=None, error=None, **unknown_fields):
        '''
        entities : typing.Sequence[~Entity]
        error : Error
        '''
        entities_ = [Entity.from_json(o) for o in entities or []]
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.entities = entities_
        self.error = error_
        self.unknown_fields = unknown_fields



class EntitiesResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~EntitiesResult]
        '''
        results_ = [EntitiesResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class EntitiesVersion(Type):
    _toSchema = {'agent_tools': 'agent-tools'}
    _toPy = {'agent-tools': 'agent_tools'}
    def __init__(self, agent_tools=None, **unknown_fields):
        '''
        agent_tools : typing.Sequence[~EntityVersion]
        '''
        agent_tools_ = [EntityVersion.from_json(o) for o in agent_tools or []]

        # Validate arguments against known Juju API types.
        if agent_tools_ is not None and not isinstance(agent_tools_, (bytes, str, list)):
            raise Exception("Expected agent_tools_ to be a Sequence, received: {}".format(type(agent_tools_)))

        self.agent_tools = agent_tools_
        self.unknown_fields = unknown_fields



class EntitiesWatchResult(Type):
    _toSchema = {'changes': 'changes', 'error': 'error', 'watcher_id': 'watcher-id'}
    _toPy = {'changes': 'changes', 'error': 'error', 'watcher-id': 'watcher_id'}
    def __init__(self, changes=None, error=None, watcher_id=None, **unknown_fields):
        '''
        changes : typing.Sequence[str]
        error : Error
        watcher_id : str
        '''
        changes_ = changes
        error_ = Error.from_json(error) if error else None
        watcher_id_ = watcher_id

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if watcher_id_ is not None and not isinstance(watcher_id_, (bytes, str)):
            raise Exception("Expected watcher_id_ to be a str, received: {}".format(type(watcher_id_)))

        self.changes = changes_
        self.error = error_
        self.watcher_id = watcher_id_
        self.unknown_fields = unknown_fields



class Entity(Type):
    _toSchema = {'tag': 'tag'}
    _toPy = {'tag': 'tag'}
    def __init__(self, tag=None, **unknown_fields):
        '''
        tag : str
        '''
        tag_ = tag

        # Validate arguments against known Juju API types.
        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.tag = tag_
        self.unknown_fields = unknown_fields



class EntityAnnotations(Type):
    _toSchema = {'annotations': 'annotations', 'entity': 'entity'}
    _toPy = {'annotations': 'annotations', 'entity': 'entity'}
    def __init__(self, annotations=None, entity=None, **unknown_fields):
        '''
        annotations : typing.Mapping[str, str]
        entity : str
        '''
        annotations_ = annotations
        entity_ = entity

        # Validate arguments against known Juju API types.
        if annotations_ is not None and not isinstance(annotations_, dict):
            raise Exception("Expected annotations_ to be a Mapping, received: {}".format(type(annotations_)))

        if entity_ is not None and not isinstance(entity_, (bytes, str)):
            raise Exception("Expected entity_ to be a str, received: {}".format(type(entity_)))

        self.annotations = annotations_
        self.entity = entity_
        self.unknown_fields = unknown_fields



class EntityCharmURL(Type):
    _toSchema = {'charm_url': 'charm-url', 'tag': 'tag'}
    _toPy = {'charm-url': 'charm_url', 'tag': 'tag'}
    def __init__(self, charm_url=None, tag=None, **unknown_fields):
        '''
        charm_url : str
        tag : str
        '''
        charm_url_ = charm_url
        tag_ = tag

        # Validate arguments against known Juju API types.
        if charm_url_ is not None and not isinstance(charm_url_, (bytes, str)):
            raise Exception("Expected charm_url_ to be a str, received: {}".format(type(charm_url_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.charm_url = charm_url_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class EntityMacaroonArg(Type):
    _toSchema = {'macaroon': 'macaroon', 'tag': 'tag'}
    _toPy = {'macaroon': 'macaroon', 'tag': 'tag'}
    def __init__(self, macaroon=None, tag=None, **unknown_fields):
        '''
        macaroon : Macaroon
        tag : str
        '''
        macaroon_ = Macaroon.from_json(macaroon) if macaroon else None
        tag_ = tag

        # Validate arguments against known Juju API types.
        if macaroon_ is not None and not isinstance(macaroon_, (dict, Macaroon)):
            raise Exception("Expected macaroon_ to be a Macaroon, received: {}".format(type(macaroon_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.macaroon = macaroon_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class EntityMacaroonArgs(Type):
    _toSchema = {'args': 'Args'}
    _toPy = {'Args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~EntityMacaroonArg]
        '''
        args_ = [EntityMacaroonArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class EntityMetrics(Type):
    _toSchema = {'error': 'error', 'metrics': 'metrics'}
    _toPy = {'error': 'error', 'metrics': 'metrics'}
    def __init__(self, error=None, metrics=None, **unknown_fields):
        '''
        error : Error
        metrics : typing.Sequence[~MetricResult]
        '''
        error_ = Error.from_json(error) if error else None
        metrics_ = [MetricResult.from_json(o) for o in metrics or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if metrics_ is not None and not isinstance(metrics_, (bytes, str, list)):
            raise Exception("Expected metrics_ to be a Sequence, received: {}".format(type(metrics_)))

        self.error = error_
        self.metrics = metrics_
        self.unknown_fields = unknown_fields



class EntityPassword(Type):
    _toSchema = {'password': 'password', 'tag': 'tag'}
    _toPy = {'password': 'password', 'tag': 'tag'}
    def __init__(self, password=None, tag=None, **unknown_fields):
        '''
        password : str
        tag : str
        '''
        password_ = password
        tag_ = tag

        # Validate arguments against known Juju API types.
        if password_ is not None and not isinstance(password_, (bytes, str)):
            raise Exception("Expected password_ to be a str, received: {}".format(type(password_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.password = password_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class EntityPasswords(Type):
    _toSchema = {'changes': 'changes'}
    _toPy = {'changes': 'changes'}
    def __init__(self, changes=None, **unknown_fields):
        '''
        changes : typing.Sequence[~EntityPassword]
        '''
        changes_ = [EntityPassword.from_json(o) for o in changes or []]

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        self.changes = changes_
        self.unknown_fields = unknown_fields



class EntityPortRange(Type):
    _toSchema = {'from_port': 'from-port', 'protocol': 'protocol', 'tag': 'tag', 'to_port': 'to-port'}
    _toPy = {'from-port': 'from_port', 'protocol': 'protocol', 'tag': 'tag', 'to-port': 'to_port'}
    def __init__(self, from_port=None, protocol=None, tag=None, to_port=None, **unknown_fields):
        '''
        from_port : int
        protocol : str
        tag : str
        to_port : int
        '''
        from_port_ = from_port
        protocol_ = protocol
        tag_ = tag
        to_port_ = to_port

        # Validate arguments against known Juju API types.
        if from_port_ is not None and not isinstance(from_port_, int):
            raise Exception("Expected from_port_ to be a int, received: {}".format(type(from_port_)))

        if protocol_ is not None and not isinstance(protocol_, (bytes, str)):
            raise Exception("Expected protocol_ to be a str, received: {}".format(type(protocol_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if to_port_ is not None and not isinstance(to_port_, int):
            raise Exception("Expected to_port_ to be a int, received: {}".format(type(to_port_)))

        self.from_port = from_port_
        self.protocol = protocol_
        self.tag = tag_
        self.to_port = to_port_
        self.unknown_fields = unknown_fields



class EntityStatus(Type):
    _toSchema = {'data': 'data', 'info': 'info', 'since': 'since', 'status': 'status'}
    _toPy = {'data': 'data', 'info': 'info', 'since': 'since', 'status': 'status'}
    def __init__(self, data=None, info=None, since=None, status=None, **unknown_fields):
        '''
        data : typing.Mapping[str, typing.Any]
        info : str
        since : str
        status : str
        '''
        data_ = data
        info_ = info
        since_ = since
        status_ = status

        # Validate arguments against known Juju API types.
        if data_ is not None and not isinstance(data_, dict):
            raise Exception("Expected data_ to be a Mapping, received: {}".format(type(data_)))

        if info_ is not None and not isinstance(info_, (bytes, str)):
            raise Exception("Expected info_ to be a str, received: {}".format(type(info_)))

        if since_ is not None and not isinstance(since_, (bytes, str)):
            raise Exception("Expected since_ to be a str, received: {}".format(type(since_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.data = data_
        self.info = info_
        self.since = since_
        self.status = status_
        self.unknown_fields = unknown_fields



class EntityStatusArgs(Type):
    _toSchema = {'data': 'data', 'info': 'info', 'status': 'status', 'tag': 'tag'}
    _toPy = {'data': 'data', 'info': 'info', 'status': 'status', 'tag': 'tag'}
    def __init__(self, data=None, info=None, status=None, tag=None, **unknown_fields):
        '''
        data : typing.Mapping[str, typing.Any]
        info : str
        status : str
        tag : str
        '''
        data_ = data
        info_ = info
        status_ = status
        tag_ = tag

        # Validate arguments against known Juju API types.
        if data_ is not None and not isinstance(data_, dict):
            raise Exception("Expected data_ to be a Mapping, received: {}".format(type(data_)))

        if info_ is not None and not isinstance(info_, (bytes, str)):
            raise Exception("Expected info_ to be a str, received: {}".format(type(info_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.data = data_
        self.info = info_
        self.status = status_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class EntityString(Type):
    _toSchema = {'tag': 'tag', 'value': 'value'}
    _toPy = {'tag': 'tag', 'value': 'value'}
    def __init__(self, tag=None, value=None, **unknown_fields):
        '''
        tag : str
        value : str
        '''
        tag_ = tag
        value_ = value

        # Validate arguments against known Juju API types.
        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if value_ is not None and not isinstance(value_, (bytes, str)):
            raise Exception("Expected value_ to be a str, received: {}".format(type(value_)))

        self.tag = tag_
        self.value = value_
        self.unknown_fields = unknown_fields



class EntityVersion(Type):
    _toSchema = {'tag': 'tag', 'tools': 'tools'}
    _toPy = {'tag': 'tag', 'tools': 'tools'}
    def __init__(self, tag=None, tools=None, **unknown_fields):
        '''
        tag : str
        tools : Version
        '''
        tag_ = tag
        tools_ = Version.from_json(tools) if tools else None

        # Validate arguments against known Juju API types.
        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if tools_ is not None and not isinstance(tools_, (dict, Version)):
            raise Exception("Expected tools_ to be a Version, received: {}".format(type(tools_)))

        self.tag = tag_
        self.tools = tools_
        self.unknown_fields = unknown_fields



class EntityWorkloadVersion(Type):
    _toSchema = {'tag': 'tag', 'workload_version': 'workload-version'}
    _toPy = {'tag': 'tag', 'workload-version': 'workload_version'}
    def __init__(self, tag=None, workload_version=None, **unknown_fields):
        '''
        tag : str
        workload_version : str
        '''
        tag_ = tag
        workload_version_ = workload_version

        # Validate arguments against known Juju API types.
        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if workload_version_ is not None and not isinstance(workload_version_, (bytes, str)):
            raise Exception("Expected workload_version_ to be a str, received: {}".format(type(workload_version_)))

        self.tag = tag_
        self.workload_version = workload_version_
        self.unknown_fields = unknown_fields



class EntityWorkloadVersions(Type):
    _toSchema = {'entities': 'entities'}
    _toPy = {'entities': 'entities'}
    def __init__(self, entities=None, **unknown_fields):
        '''
        entities : typing.Sequence[~EntityWorkloadVersion]
        '''
        entities_ = [EntityWorkloadVersion.from_json(o) for o in entities or []]

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        self.entities = entities_
        self.unknown_fields = unknown_fields



class EnvListArgs(Type):
    _toSchema = {'patterns': 'patterns'}
    _toPy = {'patterns': 'patterns'}
    def __init__(self, patterns=None, **unknown_fields):
        '''
        patterns : typing.Sequence[str]
        '''
        patterns_ = patterns

        # Validate arguments against known Juju API types.
        if patterns_ is not None and not isinstance(patterns_, (bytes, str, list)):
            raise Exception("Expected patterns_ to be a Sequence, received: {}".format(type(patterns_)))

        self.patterns = patterns_
        self.unknown_fields = unknown_fields



class EnvListResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~Payload]
        '''
        results_ = [Payload.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class Error(Type):
    _toSchema = {'code': 'code', 'info': 'info', 'message': 'message'}
    _toPy = {'code': 'code', 'info': 'info', 'message': 'message'}
    def __init__(self, code=None, info=None, message=None, **unknown_fields):
        '''
        code : str
        info : typing.Mapping[str, typing.Any]
        message : str
        '''
        code_ = code
        info_ = info
        message_ = message

        # Validate arguments against known Juju API types.
        if code_ is not None and not isinstance(code_, (bytes, str)):
            raise Exception("Expected code_ to be a str, received: {}".format(type(code_)))

        if info_ is not None and not isinstance(info_, dict):
            raise Exception("Expected info_ to be a Mapping, received: {}".format(type(info_)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        self.code = code_
        self.info = info_
        self.message = message_
        self.unknown_fields = unknown_fields



class ErrorInfo(Type):
    _toSchema = {'macaroon': 'macaroon', 'macaroon_path': 'macaroon-path'}
    _toPy = {'macaroon': 'macaroon', 'macaroon-path': 'macaroon_path'}
    def __init__(self, macaroon=None, macaroon_path=None, **unknown_fields):
        '''
        macaroon : Macaroon
        macaroon_path : str
        '''
        macaroon_ = Macaroon.from_json(macaroon) if macaroon else None
        macaroon_path_ = macaroon_path

        # Validate arguments against known Juju API types.
        if macaroon_ is not None and not isinstance(macaroon_, (dict, Macaroon)):
            raise Exception("Expected macaroon_ to be a Macaroon, received: {}".format(type(macaroon_)))

        if macaroon_path_ is not None and not isinstance(macaroon_path_, (bytes, str)):
            raise Exception("Expected macaroon_path_ to be a str, received: {}".format(type(macaroon_path_)))

        self.macaroon = macaroon_
        self.macaroon_path = macaroon_path_
        self.unknown_fields = unknown_fields



class ErrorResult(Type):
    _toSchema = {'error': 'error'}
    _toPy = {'error': 'error'}
    def __init__(self, error=None, **unknown_fields):
        '''
        error : Error
        '''
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.error = error_
        self.unknown_fields = unknown_fields



class ErrorResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ErrorResult]
        '''
        results_ = [ErrorResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ExternalControllerInfo(Type):
    _toSchema = {'addrs': 'addrs', 'ca_cert': 'ca-cert', 'controller_alias': 'controller-alias', 'controller_tag': 'controller-tag'}
    _toPy = {'addrs': 'addrs', 'ca-cert': 'ca_cert', 'controller-alias': 'controller_alias', 'controller-tag': 'controller_tag'}
    def __init__(self, addrs=None, ca_cert=None, controller_alias=None, controller_tag=None, **unknown_fields):
        '''
        addrs : typing.Sequence[str]
        ca_cert : str
        controller_alias : str
        controller_tag : str
        '''
        addrs_ = addrs
        ca_cert_ = ca_cert
        controller_alias_ = controller_alias
        controller_tag_ = controller_tag

        # Validate arguments against known Juju API types.
        if addrs_ is not None and not isinstance(addrs_, (bytes, str, list)):
            raise Exception("Expected addrs_ to be a Sequence, received: {}".format(type(addrs_)))

        if ca_cert_ is not None and not isinstance(ca_cert_, (bytes, str)):
            raise Exception("Expected ca_cert_ to be a str, received: {}".format(type(ca_cert_)))

        if controller_alias_ is not None and not isinstance(controller_alias_, (bytes, str)):
            raise Exception("Expected controller_alias_ to be a str, received: {}".format(type(controller_alias_)))

        if controller_tag_ is not None and not isinstance(controller_tag_, (bytes, str)):
            raise Exception("Expected controller_tag_ to be a str, received: {}".format(type(controller_tag_)))

        self.addrs = addrs_
        self.ca_cert = ca_cert_
        self.controller_alias = controller_alias_
        self.controller_tag = controller_tag_
        self.unknown_fields = unknown_fields



class ExternalControllerInfoResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ExternalControllerInfo
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ExternalControllerInfo.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ExternalControllerInfo)):
            raise Exception("Expected result_ to be a ExternalControllerInfo, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ExternalControllerInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ExternalControllerInfoResult]
        '''
        results_ = [ExternalControllerInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class FanConfigEntry(Type):
    _toSchema = {'overlay': 'overlay', 'underlay': 'underlay'}
    _toPy = {'overlay': 'overlay', 'underlay': 'underlay'}
    def __init__(self, overlay=None, underlay=None, **unknown_fields):
        '''
        overlay : str
        underlay : str
        '''
        overlay_ = overlay
        underlay_ = underlay

        # Validate arguments against known Juju API types.
        if overlay_ is not None and not isinstance(overlay_, (bytes, str)):
            raise Exception("Expected overlay_ to be a str, received: {}".format(type(overlay_)))

        if underlay_ is not None and not isinstance(underlay_, (bytes, str)):
            raise Exception("Expected underlay_ to be a str, received: {}".format(type(underlay_)))

        self.overlay = overlay_
        self.underlay = underlay_
        self.unknown_fields = unknown_fields



class FanConfigResult(Type):
    _toSchema = {'fans': 'fans'}
    _toPy = {'fans': 'fans'}
    def __init__(self, fans=None, **unknown_fields):
        '''
        fans : typing.Sequence[~FanConfigEntry]
        '''
        fans_ = [FanConfigEntry.from_json(o) for o in fans or []]

        # Validate arguments against known Juju API types.
        if fans_ is not None and not isinstance(fans_, (bytes, str, list)):
            raise Exception("Expected fans_ to be a Sequence, received: {}".format(type(fans_)))

        self.fans = fans_
        self.unknown_fields = unknown_fields



class Filesystem(Type):
    _toSchema = {'filesystem_tag': 'filesystem-tag', 'info': 'info', 'volume_tag': 'volume-tag'}
    _toPy = {'filesystem-tag': 'filesystem_tag', 'info': 'info', 'volume-tag': 'volume_tag'}
    def __init__(self, filesystem_tag=None, info=None, volume_tag=None, **unknown_fields):
        '''
        filesystem_tag : str
        info : FilesystemInfo
        volume_tag : str
        '''
        filesystem_tag_ = filesystem_tag
        info_ = FilesystemInfo.from_json(info) if info else None
        volume_tag_ = volume_tag

        # Validate arguments against known Juju API types.
        if filesystem_tag_ is not None and not isinstance(filesystem_tag_, (bytes, str)):
            raise Exception("Expected filesystem_tag_ to be a str, received: {}".format(type(filesystem_tag_)))

        if info_ is not None and not isinstance(info_, (dict, FilesystemInfo)):
            raise Exception("Expected info_ to be a FilesystemInfo, received: {}".format(type(info_)))

        if volume_tag_ is not None and not isinstance(volume_tag_, (bytes, str)):
            raise Exception("Expected volume_tag_ to be a str, received: {}".format(type(volume_tag_)))

        self.filesystem_tag = filesystem_tag_
        self.info = info_
        self.volume_tag = volume_tag_
        self.unknown_fields = unknown_fields



class FilesystemAttachment(Type):
    _toSchema = {'filesystem_tag': 'filesystem-tag', 'info': 'info', 'machine_tag': 'machine-tag'}
    _toPy = {'filesystem-tag': 'filesystem_tag', 'info': 'info', 'machine-tag': 'machine_tag'}
    def __init__(self, filesystem_tag=None, info=None, machine_tag=None, **unknown_fields):
        '''
        filesystem_tag : str
        info : FilesystemAttachmentInfo
        machine_tag : str
        '''
        filesystem_tag_ = filesystem_tag
        info_ = FilesystemAttachmentInfo.from_json(info) if info else None
        machine_tag_ = machine_tag

        # Validate arguments against known Juju API types.
        if filesystem_tag_ is not None and not isinstance(filesystem_tag_, (bytes, str)):
            raise Exception("Expected filesystem_tag_ to be a str, received: {}".format(type(filesystem_tag_)))

        if info_ is not None and not isinstance(info_, (dict, FilesystemAttachmentInfo)):
            raise Exception("Expected info_ to be a FilesystemAttachmentInfo, received: {}".format(type(info_)))

        if machine_tag_ is not None and not isinstance(machine_tag_, (bytes, str)):
            raise Exception("Expected machine_tag_ to be a str, received: {}".format(type(machine_tag_)))

        self.filesystem_tag = filesystem_tag_
        self.info = info_
        self.machine_tag = machine_tag_
        self.unknown_fields = unknown_fields



class FilesystemAttachmentDetails(Type):
    _toSchema = {'filesystemattachmentinfo': 'FilesystemAttachmentInfo', 'life': 'life', 'mount_point': 'mount-point', 'read_only': 'read-only'}
    _toPy = {'FilesystemAttachmentInfo': 'filesystemattachmentinfo', 'life': 'life', 'mount-point': 'mount_point', 'read-only': 'read_only'}
    def __init__(self, filesystemattachmentinfo=None, life=None, mount_point=None, read_only=None, **unknown_fields):
        '''
        filesystemattachmentinfo : FilesystemAttachmentInfo
        life : str
        mount_point : str
        read_only : bool
        '''
        filesystemattachmentinfo_ = FilesystemAttachmentInfo.from_json(filesystemattachmentinfo) if filesystemattachmentinfo else None
        life_ = life
        mount_point_ = mount_point
        read_only_ = read_only

        # Validate arguments against known Juju API types.
        if filesystemattachmentinfo_ is not None and not isinstance(filesystemattachmentinfo_, (dict, FilesystemAttachmentInfo)):
            raise Exception("Expected filesystemattachmentinfo_ to be a FilesystemAttachmentInfo, received: {}".format(type(filesystemattachmentinfo_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if mount_point_ is not None and not isinstance(mount_point_, (bytes, str)):
            raise Exception("Expected mount_point_ to be a str, received: {}".format(type(mount_point_)))

        if read_only_ is not None and not isinstance(read_only_, bool):
            raise Exception("Expected read_only_ to be a bool, received: {}".format(type(read_only_)))

        self.filesystemattachmentinfo = filesystemattachmentinfo_
        self.life = life_
        self.mount_point = mount_point_
        self.read_only = read_only_
        self.unknown_fields = unknown_fields



class FilesystemAttachmentInfo(Type):
    _toSchema = {'mount_point': 'mount-point', 'read_only': 'read-only'}
    _toPy = {'mount-point': 'mount_point', 'read-only': 'read_only'}
    def __init__(self, mount_point=None, read_only=None, **unknown_fields):
        '''
        mount_point : str
        read_only : bool
        '''
        mount_point_ = mount_point
        read_only_ = read_only

        # Validate arguments against known Juju API types.
        if mount_point_ is not None and not isinstance(mount_point_, (bytes, str)):
            raise Exception("Expected mount_point_ to be a str, received: {}".format(type(mount_point_)))

        if read_only_ is not None and not isinstance(read_only_, bool):
            raise Exception("Expected read_only_ to be a bool, received: {}".format(type(read_only_)))

        self.mount_point = mount_point_
        self.read_only = read_only_
        self.unknown_fields = unknown_fields



class FilesystemAttachmentParams(Type):
    _toSchema = {'filesystem_id': 'filesystem-id', 'filesystem_tag': 'filesystem-tag', 'instance_id': 'instance-id', 'machine_tag': 'machine-tag', 'mount_point': 'mount-point', 'provider': 'provider', 'read_only': 'read-only'}
    _toPy = {'filesystem-id': 'filesystem_id', 'filesystem-tag': 'filesystem_tag', 'instance-id': 'instance_id', 'machine-tag': 'machine_tag', 'mount-point': 'mount_point', 'provider': 'provider', 'read-only': 'read_only'}
    def __init__(self, filesystem_id=None, filesystem_tag=None, instance_id=None, machine_tag=None, mount_point=None, provider=None, read_only=None, **unknown_fields):
        '''
        filesystem_id : str
        filesystem_tag : str
        instance_id : str
        machine_tag : str
        mount_point : str
        provider : str
        read_only : bool
        '''
        filesystem_id_ = filesystem_id
        filesystem_tag_ = filesystem_tag
        instance_id_ = instance_id
        machine_tag_ = machine_tag
        mount_point_ = mount_point
        provider_ = provider
        read_only_ = read_only

        # Validate arguments against known Juju API types.
        if filesystem_id_ is not None and not isinstance(filesystem_id_, (bytes, str)):
            raise Exception("Expected filesystem_id_ to be a str, received: {}".format(type(filesystem_id_)))

        if filesystem_tag_ is not None and not isinstance(filesystem_tag_, (bytes, str)):
            raise Exception("Expected filesystem_tag_ to be a str, received: {}".format(type(filesystem_tag_)))

        if instance_id_ is not None and not isinstance(instance_id_, (bytes, str)):
            raise Exception("Expected instance_id_ to be a str, received: {}".format(type(instance_id_)))

        if machine_tag_ is not None and not isinstance(machine_tag_, (bytes, str)):
            raise Exception("Expected machine_tag_ to be a str, received: {}".format(type(machine_tag_)))

        if mount_point_ is not None and not isinstance(mount_point_, (bytes, str)):
            raise Exception("Expected mount_point_ to be a str, received: {}".format(type(mount_point_)))

        if provider_ is not None and not isinstance(provider_, (bytes, str)):
            raise Exception("Expected provider_ to be a str, received: {}".format(type(provider_)))

        if read_only_ is not None and not isinstance(read_only_, bool):
            raise Exception("Expected read_only_ to be a bool, received: {}".format(type(read_only_)))

        self.filesystem_id = filesystem_id_
        self.filesystem_tag = filesystem_tag_
        self.instance_id = instance_id_
        self.machine_tag = machine_tag_
        self.mount_point = mount_point_
        self.provider = provider_
        self.read_only = read_only_
        self.unknown_fields = unknown_fields



class FilesystemAttachmentParamsResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : FilesystemAttachmentParams
        '''
        error_ = Error.from_json(error) if error else None
        result_ = FilesystemAttachmentParams.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, FilesystemAttachmentParams)):
            raise Exception("Expected result_ to be a FilesystemAttachmentParams, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class FilesystemAttachmentParamsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~FilesystemAttachmentParamsResult]
        '''
        results_ = [FilesystemAttachmentParamsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class FilesystemAttachmentResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : FilesystemAttachment
        '''
        error_ = Error.from_json(error) if error else None
        result_ = FilesystemAttachment.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, FilesystemAttachment)):
            raise Exception("Expected result_ to be a FilesystemAttachment, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class FilesystemAttachmentResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~FilesystemAttachmentResult]
        '''
        results_ = [FilesystemAttachmentResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class FilesystemAttachments(Type):
    _toSchema = {'filesystem_attachments': 'filesystem-attachments'}
    _toPy = {'filesystem-attachments': 'filesystem_attachments'}
    def __init__(self, filesystem_attachments=None, **unknown_fields):
        '''
        filesystem_attachments : typing.Sequence[~FilesystemAttachment]
        '''
        filesystem_attachments_ = [FilesystemAttachment.from_json(o) for o in filesystem_attachments or []]

        # Validate arguments against known Juju API types.
        if filesystem_attachments_ is not None and not isinstance(filesystem_attachments_, (bytes, str, list)):
            raise Exception("Expected filesystem_attachments_ to be a Sequence, received: {}".format(type(filesystem_attachments_)))

        self.filesystem_attachments = filesystem_attachments_
        self.unknown_fields = unknown_fields



class FilesystemDetails(Type):
    _toSchema = {'filesystem_tag': 'filesystem-tag', 'info': 'info', 'life': 'life', 'machine_attachments': 'machine-attachments', 'status': 'status', 'storage': 'storage', 'unit_attachments': 'unit-attachments', 'volume_tag': 'volume-tag'}
    _toPy = {'filesystem-tag': 'filesystem_tag', 'info': 'info', 'life': 'life', 'machine-attachments': 'machine_attachments', 'status': 'status', 'storage': 'storage', 'unit-attachments': 'unit_attachments', 'volume-tag': 'volume_tag'}
    def __init__(self, filesystem_tag=None, info=None, life=None, machine_attachments=None, status=None, storage=None, unit_attachments=None, volume_tag=None, **unknown_fields):
        '''
        filesystem_tag : str
        info : FilesystemInfo
        life : str
        machine_attachments : typing.Mapping[str, ~FilesystemAttachmentDetails]
        status : EntityStatus
        storage : StorageDetails
        unit_attachments : typing.Mapping[str, ~FilesystemAttachmentDetails]
        volume_tag : str
        '''
        filesystem_tag_ = filesystem_tag
        info_ = FilesystemInfo.from_json(info) if info else None
        life_ = life
        machine_attachments_ = {k: FilesystemAttachmentDetails.from_json(v) for k, v in (machine_attachments or dict()).items()}
        status_ = EntityStatus.from_json(status) if status else None
        storage_ = StorageDetails.from_json(storage) if storage else None
        unit_attachments_ = {k: FilesystemAttachmentDetails.from_json(v) for k, v in (unit_attachments or dict()).items()}
        volume_tag_ = volume_tag

        # Validate arguments against known Juju API types.
        if filesystem_tag_ is not None and not isinstance(filesystem_tag_, (bytes, str)):
            raise Exception("Expected filesystem_tag_ to be a str, received: {}".format(type(filesystem_tag_)))

        if info_ is not None and not isinstance(info_, (dict, FilesystemInfo)):
            raise Exception("Expected info_ to be a FilesystemInfo, received: {}".format(type(info_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if machine_attachments_ is not None and not isinstance(machine_attachments_, dict):
            raise Exception("Expected machine_attachments_ to be a Mapping, received: {}".format(type(machine_attachments_)))

        if status_ is not None and not isinstance(status_, (dict, EntityStatus)):
            raise Exception("Expected status_ to be a EntityStatus, received: {}".format(type(status_)))

        if storage_ is not None and not isinstance(storage_, (dict, StorageDetails)):
            raise Exception("Expected storage_ to be a StorageDetails, received: {}".format(type(storage_)))

        if unit_attachments_ is not None and not isinstance(unit_attachments_, dict):
            raise Exception("Expected unit_attachments_ to be a Mapping, received: {}".format(type(unit_attachments_)))

        if volume_tag_ is not None and not isinstance(volume_tag_, (bytes, str)):
            raise Exception("Expected volume_tag_ to be a str, received: {}".format(type(volume_tag_)))

        self.filesystem_tag = filesystem_tag_
        self.info = info_
        self.life = life_
        self.machine_attachments = machine_attachments_
        self.status = status_
        self.storage = storage_
        self.unit_attachments = unit_attachments_
        self.volume_tag = volume_tag_
        self.unknown_fields = unknown_fields



class FilesystemDetailsListResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : typing.Sequence[~FilesystemDetails]
        '''
        error_ = Error.from_json(error) if error else None
        result_ = [FilesystemDetails.from_json(o) for o in result or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (bytes, str, list)):
            raise Exception("Expected result_ to be a Sequence, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class FilesystemDetailsListResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~FilesystemDetailsListResult]
        '''
        results_ = [FilesystemDetailsListResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class FilesystemFilter(Type):
    _toSchema = {'machines': 'machines'}
    _toPy = {'machines': 'machines'}
    def __init__(self, machines=None, **unknown_fields):
        '''
        machines : typing.Sequence[str]
        '''
        machines_ = machines

        # Validate arguments against known Juju API types.
        if machines_ is not None and not isinstance(machines_, (bytes, str, list)):
            raise Exception("Expected machines_ to be a Sequence, received: {}".format(type(machines_)))

        self.machines = machines_
        self.unknown_fields = unknown_fields



class FilesystemFilters(Type):
    _toSchema = {'filters': 'filters'}
    _toPy = {'filters': 'filters'}
    def __init__(self, filters=None, **unknown_fields):
        '''
        filters : typing.Sequence[~FilesystemFilter]
        '''
        filters_ = [FilesystemFilter.from_json(o) for o in filters or []]

        # Validate arguments against known Juju API types.
        if filters_ is not None and not isinstance(filters_, (bytes, str, list)):
            raise Exception("Expected filters_ to be a Sequence, received: {}".format(type(filters_)))

        self.filters = filters_
        self.unknown_fields = unknown_fields



class FilesystemInfo(Type):
    _toSchema = {'filesystem_id': 'filesystem-id', 'pool': 'pool', 'size': 'size'}
    _toPy = {'filesystem-id': 'filesystem_id', 'pool': 'pool', 'size': 'size'}
    def __init__(self, filesystem_id=None, pool=None, size=None, **unknown_fields):
        '''
        filesystem_id : str
        pool : str
        size : int
        '''
        filesystem_id_ = filesystem_id
        pool_ = pool
        size_ = size

        # Validate arguments against known Juju API types.
        if filesystem_id_ is not None and not isinstance(filesystem_id_, (bytes, str)):
            raise Exception("Expected filesystem_id_ to be a str, received: {}".format(type(filesystem_id_)))

        if pool_ is not None and not isinstance(pool_, (bytes, str)):
            raise Exception("Expected pool_ to be a str, received: {}".format(type(pool_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        self.filesystem_id = filesystem_id_
        self.pool = pool_
        self.size = size_
        self.unknown_fields = unknown_fields



class FilesystemParams(Type):
    _toSchema = {'attachment': 'attachment', 'attributes': 'attributes', 'filesystem_tag': 'filesystem-tag', 'provider': 'provider', 'size': 'size', 'tags': 'tags', 'volume_tag': 'volume-tag'}
    _toPy = {'attachment': 'attachment', 'attributes': 'attributes', 'filesystem-tag': 'filesystem_tag', 'provider': 'provider', 'size': 'size', 'tags': 'tags', 'volume-tag': 'volume_tag'}
    def __init__(self, attachment=None, attributes=None, filesystem_tag=None, provider=None, size=None, tags=None, volume_tag=None, **unknown_fields):
        '''
        attachment : FilesystemAttachmentParams
        attributes : typing.Mapping[str, typing.Any]
        filesystem_tag : str
        provider : str
        size : int
        tags : typing.Mapping[str, str]
        volume_tag : str
        '''
        attachment_ = FilesystemAttachmentParams.from_json(attachment) if attachment else None
        attributes_ = attributes
        filesystem_tag_ = filesystem_tag
        provider_ = provider
        size_ = size
        tags_ = tags
        volume_tag_ = volume_tag

        # Validate arguments against known Juju API types.
        if attachment_ is not None and not isinstance(attachment_, (dict, FilesystemAttachmentParams)):
            raise Exception("Expected attachment_ to be a FilesystemAttachmentParams, received: {}".format(type(attachment_)))

        if attributes_ is not None and not isinstance(attributes_, dict):
            raise Exception("Expected attributes_ to be a Mapping, received: {}".format(type(attributes_)))

        if filesystem_tag_ is not None and not isinstance(filesystem_tag_, (bytes, str)):
            raise Exception("Expected filesystem_tag_ to be a str, received: {}".format(type(filesystem_tag_)))

        if provider_ is not None and not isinstance(provider_, (bytes, str)):
            raise Exception("Expected provider_ to be a str, received: {}".format(type(provider_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if tags_ is not None and not isinstance(tags_, dict):
            raise Exception("Expected tags_ to be a Mapping, received: {}".format(type(tags_)))

        if volume_tag_ is not None and not isinstance(volume_tag_, (bytes, str)):
            raise Exception("Expected volume_tag_ to be a str, received: {}".format(type(volume_tag_)))

        self.attachment = attachment_
        self.attributes = attributes_
        self.filesystem_tag = filesystem_tag_
        self.provider = provider_
        self.size = size_
        self.tags = tags_
        self.volume_tag = volume_tag_
        self.unknown_fields = unknown_fields



class FilesystemParamsResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : FilesystemParams
        '''
        error_ = Error.from_json(error) if error else None
        result_ = FilesystemParams.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, FilesystemParams)):
            raise Exception("Expected result_ to be a FilesystemParams, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class FilesystemParamsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~FilesystemParamsResult]
        '''
        results_ = [FilesystemParamsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class FilesystemResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : Filesystem
        '''
        error_ = Error.from_json(error) if error else None
        result_ = Filesystem.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, Filesystem)):
            raise Exception("Expected result_ to be a Filesystem, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class FilesystemResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~FilesystemResult]
        '''
        results_ = [FilesystemResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class Filesystems(Type):
    _toSchema = {'filesystems': 'filesystems'}
    _toPy = {'filesystems': 'filesystems'}
    def __init__(self, filesystems=None, **unknown_fields):
        '''
        filesystems : typing.Sequence[~Filesystem]
        '''
        filesystems_ = [Filesystem.from_json(o) for o in filesystems or []]

        # Validate arguments against known Juju API types.
        if filesystems_ is not None and not isinstance(filesystems_, (bytes, str, list)):
            raise Exception("Expected filesystems_ to be a Sequence, received: {}".format(type(filesystems_)))

        self.filesystems = filesystems_
        self.unknown_fields = unknown_fields



class FindActionsByNames(Type):
    _toSchema = {'names': 'names'}
    _toPy = {'names': 'names'}
    def __init__(self, names=None, **unknown_fields):
        '''
        names : typing.Sequence[str]
        '''
        names_ = names

        # Validate arguments against known Juju API types.
        if names_ is not None and not isinstance(names_, (bytes, str, list)):
            raise Exception("Expected names_ to be a Sequence, received: {}".format(type(names_)))

        self.names = names_
        self.unknown_fields = unknown_fields



class FindTags(Type):
    _toSchema = {'prefixes': 'prefixes'}
    _toPy = {'prefixes': 'prefixes'}
    def __init__(self, prefixes=None, **unknown_fields):
        '''
        prefixes : typing.Sequence[str]
        '''
        prefixes_ = prefixes

        # Validate arguments against known Juju API types.
        if prefixes_ is not None and not isinstance(prefixes_, (bytes, str, list)):
            raise Exception("Expected prefixes_ to be a Sequence, received: {}".format(type(prefixes_)))

        self.prefixes = prefixes_
        self.unknown_fields = unknown_fields



class FindTagsResults(Type):
    _toSchema = {'matches': 'matches'}
    _toPy = {'matches': 'matches'}
    def __init__(self, matches=None, **unknown_fields):
        '''
        matches : typing.Mapping[str, typing.Sequence[~Entity]]
        '''
        matches_ = {k: Entity.from_json(v) for k, v in (matches or dict()).items()}

        # Validate arguments against known Juju API types.
        if matches_ is not None and not isinstance(matches_, dict):
            raise Exception("Expected matches_ to be a Mapping, received: {}".format(type(matches_)))

        self.matches = matches_
        self.unknown_fields = unknown_fields



class FindToolsParams(Type):
    _toSchema = {'agentstream': 'agentstream', 'arch': 'arch', 'major': 'major', 'minor': 'minor', 'number': 'number', 'series': 'series'}
    _toPy = {'agentstream': 'agentstream', 'arch': 'arch', 'major': 'major', 'minor': 'minor', 'number': 'number', 'series': 'series'}
    def __init__(self, agentstream=None, arch=None, major=None, minor=None, number=None, series=None, **unknown_fields):
        '''
        agentstream : str
        arch : str
        major : int
        minor : int
        number : Number
        series : str
        '''
        agentstream_ = agentstream
        arch_ = arch
        major_ = major
        minor_ = minor
        number_ = Number.from_json(number) if number else None
        series_ = series

        # Validate arguments against known Juju API types.
        if agentstream_ is not None and not isinstance(agentstream_, (bytes, str)):
            raise Exception("Expected agentstream_ to be a str, received: {}".format(type(agentstream_)))

        if arch_ is not None and not isinstance(arch_, (bytes, str)):
            raise Exception("Expected arch_ to be a str, received: {}".format(type(arch_)))

        if major_ is not None and not isinstance(major_, int):
            raise Exception("Expected major_ to be a int, received: {}".format(type(major_)))

        if minor_ is not None and not isinstance(minor_, int):
            raise Exception("Expected minor_ to be a int, received: {}".format(type(minor_)))

        if number_ is not None and not isinstance(number_, (dict, Number)):
            raise Exception("Expected number_ to be a Number, received: {}".format(type(number_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        self.agentstream = agentstream_
        self.arch = arch_
        self.major = major_
        self.minor = minor_
        self.number = number_
        self.series = series_
        self.unknown_fields = unknown_fields



class FindToolsResult(Type):
    _toSchema = {'error': 'error', 'list_': 'list'}
    _toPy = {'error': 'error', 'list': 'list_'}
    def __init__(self, error=None, list_=None, **unknown_fields):
        '''
        error : Error
        list_ : typing.Sequence[~Tools]
        '''
        error_ = Error.from_json(error) if error else None
        list__ = [Tools.from_json(o) for o in list_ or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if list__ is not None and not isinstance(list__, (bytes, str, list)):
            raise Exception("Expected list__ to be a Sequence, received: {}".format(type(list__)))

        self.error = error_
        self.list_ = list__
        self.unknown_fields = unknown_fields



class FirewallRule(Type):
    _toSchema = {'known_service': 'known-service', 'whitelist_cidrs': 'whitelist-cidrs'}
    _toPy = {'known-service': 'known_service', 'whitelist-cidrs': 'whitelist_cidrs'}
    def __init__(self, known_service=None, whitelist_cidrs=None, **unknown_fields):
        '''
        known_service : str
        whitelist_cidrs : typing.Sequence[str]
        '''
        known_service_ = known_service
        whitelist_cidrs_ = whitelist_cidrs

        # Validate arguments against known Juju API types.
        if known_service_ is not None and not isinstance(known_service_, (bytes, str)):
            raise Exception("Expected known_service_ to be a str, received: {}".format(type(known_service_)))

        if whitelist_cidrs_ is not None and not isinstance(whitelist_cidrs_, (bytes, str, list)):
            raise Exception("Expected whitelist_cidrs_ to be a Sequence, received: {}".format(type(whitelist_cidrs_)))

        self.known_service = known_service_
        self.whitelist_cidrs = whitelist_cidrs_
        self.unknown_fields = unknown_fields



class FirewallRuleArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~FirewallRule]
        '''
        args_ = [FirewallRule.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class FullStatus(Type):
    _toSchema = {'applications': 'applications', 'branches': 'branches', 'controller_timestamp': 'controller-timestamp', 'machines': 'machines', 'model': 'model', 'offers': 'offers', 'relations': 'relations', 'remote_applications': 'remote-applications'}
    _toPy = {'applications': 'applications', 'branches': 'branches', 'controller-timestamp': 'controller_timestamp', 'machines': 'machines', 'model': 'model', 'offers': 'offers', 'relations': 'relations', 'remote-applications': 'remote_applications'}
    def __init__(self, applications=None, branches=None, controller_timestamp=None, machines=None, model=None, offers=None, relations=None, remote_applications=None, **unknown_fields):
        '''
        applications : typing.Mapping[str, ~ApplicationStatus]
        branches : typing.Mapping[str, ~BranchStatus]
        controller_timestamp : str
        machines : typing.Mapping[str, ~MachineStatus]
        model : ModelStatusInfo
        offers : typing.Mapping[str, ~ApplicationOfferStatus]
        relations : typing.Sequence[~RelationStatus]
        remote_applications : typing.Mapping[str, ~RemoteApplicationStatus]
        '''
        applications_ = {k: ApplicationStatus.from_json(v) for k, v in (applications or dict()).items()}
        branches_ = {k: BranchStatus.from_json(v) for k, v in (branches or dict()).items()}
        controller_timestamp_ = controller_timestamp
        machines_ = {k: MachineStatus.from_json(v) for k, v in (machines or dict()).items()}
        model_ = ModelStatusInfo.from_json(model) if model else None
        offers_ = {k: ApplicationOfferStatus.from_json(v) for k, v in (offers or dict()).items()}
        relations_ = [RelationStatus.from_json(o) for o in relations or []]
        remote_applications_ = {k: RemoteApplicationStatus.from_json(v) for k, v in (remote_applications or dict()).items()}

        # Validate arguments against known Juju API types.
        if applications_ is not None and not isinstance(applications_, dict):
            raise Exception("Expected applications_ to be a Mapping, received: {}".format(type(applications_)))

        if branches_ is not None and not isinstance(branches_, dict):
            raise Exception("Expected branches_ to be a Mapping, received: {}".format(type(branches_)))

        if controller_timestamp_ is not None and not isinstance(controller_timestamp_, (bytes, str)):
            raise Exception("Expected controller_timestamp_ to be a str, received: {}".format(type(controller_timestamp_)))

        if machines_ is not None and not isinstance(machines_, dict):
            raise Exception("Expected machines_ to be a Mapping, received: {}".format(type(machines_)))

        if model_ is not None and not isinstance(model_, (dict, ModelStatusInfo)):
            raise Exception("Expected model_ to be a ModelStatusInfo, received: {}".format(type(model_)))

        if offers_ is not None and not isinstance(offers_, dict):
            raise Exception("Expected offers_ to be a Mapping, received: {}".format(type(offers_)))

        if relations_ is not None and not isinstance(relations_, (bytes, str, list)):
            raise Exception("Expected relations_ to be a Sequence, received: {}".format(type(relations_)))

        if remote_applications_ is not None and not isinstance(remote_applications_, dict):
            raise Exception("Expected remote_applications_ to be a Mapping, received: {}".format(type(remote_applications_)))

        self.applications = applications_
        self.branches = branches_
        self.controller_timestamp = controller_timestamp_
        self.machines = machines_
        self.model = model_
        self.offers = offers_
        self.relations = relations_
        self.remote_applications = remote_applications_
        self.unknown_fields = unknown_fields



class Generation(Type):
    _toSchema = {'applications': 'applications', 'branch': 'branch', 'completed': 'completed', 'completed_by': 'completed-by', 'created': 'created', 'created_by': 'created-by', 'generation_id': 'generation-id'}
    _toPy = {'applications': 'applications', 'branch': 'branch', 'completed': 'completed', 'completed-by': 'completed_by', 'created': 'created', 'created-by': 'created_by', 'generation-id': 'generation_id'}
    def __init__(self, applications=None, branch=None, completed=None, completed_by=None, created=None, created_by=None, generation_id=None, **unknown_fields):
        '''
        applications : typing.Sequence[~GenerationApplication]
        branch : str
        completed : int
        completed_by : str
        created : int
        created_by : str
        generation_id : int
        '''
        applications_ = [GenerationApplication.from_json(o) for o in applications or []]
        branch_ = branch
        completed_ = completed
        completed_by_ = completed_by
        created_ = created
        created_by_ = created_by
        generation_id_ = generation_id

        # Validate arguments against known Juju API types.
        if applications_ is not None and not isinstance(applications_, (bytes, str, list)):
            raise Exception("Expected applications_ to be a Sequence, received: {}".format(type(applications_)))

        if branch_ is not None and not isinstance(branch_, (bytes, str)):
            raise Exception("Expected branch_ to be a str, received: {}".format(type(branch_)))

        if completed_ is not None and not isinstance(completed_, int):
            raise Exception("Expected completed_ to be a int, received: {}".format(type(completed_)))

        if completed_by_ is not None and not isinstance(completed_by_, (bytes, str)):
            raise Exception("Expected completed_by_ to be a str, received: {}".format(type(completed_by_)))

        if created_ is not None and not isinstance(created_, int):
            raise Exception("Expected created_ to be a int, received: {}".format(type(created_)))

        if created_by_ is not None and not isinstance(created_by_, (bytes, str)):
            raise Exception("Expected created_by_ to be a str, received: {}".format(type(created_by_)))

        if generation_id_ is not None and not isinstance(generation_id_, int):
            raise Exception("Expected generation_id_ to be a int, received: {}".format(type(generation_id_)))

        self.applications = applications_
        self.branch = branch_
        self.completed = completed_
        self.completed_by = completed_by_
        self.created = created_
        self.created_by = created_by_
        self.generation_id = generation_id_
        self.unknown_fields = unknown_fields



class GenerationApplication(Type):
    _toSchema = {'application': 'application', 'config': 'config', 'pending': 'pending', 'progress': 'progress', 'tracking': 'tracking'}
    _toPy = {'application': 'application', 'config': 'config', 'pending': 'pending', 'progress': 'progress', 'tracking': 'tracking'}
    def __init__(self, application=None, config=None, pending=None, progress=None, tracking=None, **unknown_fields):
        '''
        application : str
        config : typing.Mapping[str, typing.Any]
        pending : typing.Sequence[str]
        progress : str
        tracking : typing.Sequence[str]
        '''
        application_ = application
        config_ = config
        pending_ = pending
        progress_ = progress
        tracking_ = tracking

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if pending_ is not None and not isinstance(pending_, (bytes, str, list)):
            raise Exception("Expected pending_ to be a Sequence, received: {}".format(type(pending_)))

        if progress_ is not None and not isinstance(progress_, (bytes, str)):
            raise Exception("Expected progress_ to be a str, received: {}".format(type(progress_)))

        if tracking_ is not None and not isinstance(tracking_, (bytes, str, list)):
            raise Exception("Expected tracking_ to be a Sequence, received: {}".format(type(tracking_)))

        self.application = application_
        self.config = config_
        self.pending = pending_
        self.progress = progress_
        self.tracking = tracking_
        self.unknown_fields = unknown_fields



class GenerationId(Type):
    _toSchema = {'generation_id': 'generation-id'}
    _toPy = {'generation-id': 'generation_id'}
    def __init__(self, generation_id=None, **unknown_fields):
        '''
        generation_id : int
        '''
        generation_id_ = generation_id

        # Validate arguments against known Juju API types.
        if generation_id_ is not None and not isinstance(generation_id_, int):
            raise Exception("Expected generation_id_ to be a int, received: {}".format(type(generation_id_)))

        self.generation_id = generation_id_
        self.unknown_fields = unknown_fields



class GenerationResult(Type):
    _toSchema = {'error': 'error', 'generation': 'generation'}
    _toPy = {'error': 'error', 'generation': 'generation'}
    def __init__(self, error=None, generation=None, **unknown_fields):
        '''
        error : Error
        generation : Generation
        '''
        error_ = Error.from_json(error) if error else None
        generation_ = Generation.from_json(generation) if generation else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if generation_ is not None and not isinstance(generation_, (dict, Generation)):
            raise Exception("Expected generation_ to be a Generation, received: {}".format(type(generation_)))

        self.error = error_
        self.generation = generation_
        self.unknown_fields = unknown_fields



class GenerationResults(Type):
    _toSchema = {'error': 'error', 'generations': 'generations'}
    _toPy = {'error': 'error', 'generations': 'generations'}
    def __init__(self, error=None, generations=None, **unknown_fields):
        '''
        error : Error
        generations : typing.Sequence[~Generation]
        '''
        error_ = Error.from_json(error) if error else None
        generations_ = [Generation.from_json(o) for o in generations or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if generations_ is not None and not isinstance(generations_, (bytes, str, list)):
            raise Exception("Expected generations_ to be a Sequence, received: {}".format(type(generations_)))

        self.error = error_
        self.generations = generations_
        self.unknown_fields = unknown_fields



class GetApplicationConstraints(Type):
    _toSchema = {'application': 'application'}
    _toPy = {'application': 'application'}
    def __init__(self, application=None, **unknown_fields):
        '''
        application : str
        '''
        application_ = application

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        self.application = application_
        self.unknown_fields = unknown_fields



class GetConstraintsResults(Type):
    _toSchema = {'constraints': 'constraints'}
    _toPy = {'constraints': 'constraints'}
    def __init__(self, constraints=None, **unknown_fields):
        '''
        constraints : Value
        '''
        constraints_ = Value.from_json(constraints) if constraints else None

        # Validate arguments against known Juju API types.
        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        self.constraints = constraints_
        self.unknown_fields = unknown_fields



class GetLeadershipSettingsBulkResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~GetLeadershipSettingsResult]
        '''
        results_ = [GetLeadershipSettingsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class GetLeadershipSettingsResult(Type):
    _toSchema = {'error': 'error', 'settings': 'settings'}
    _toPy = {'error': 'error', 'settings': 'settings'}
    def __init__(self, error=None, settings=None, **unknown_fields):
        '''
        error : Error
        settings : typing.Mapping[str, str]
        '''
        error_ = Error.from_json(error) if error else None
        settings_ = settings

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if settings_ is not None and not isinstance(settings_, dict):
            raise Exception("Expected settings_ to be a Mapping, received: {}".format(type(settings_)))

        self.error = error_
        self.settings = settings_
        self.unknown_fields = unknown_fields



class GetTokenArg(Type):
    _toSchema = {'tag': 'tag'}
    _toPy = {'tag': 'tag'}
    def __init__(self, tag=None, **unknown_fields):
        '''
        tag : str
        '''
        tag_ = tag

        # Validate arguments against known Juju API types.
        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.tag = tag_
        self.unknown_fields = unknown_fields



class GetTokenArgs(Type):
    _toSchema = {'args': 'Args'}
    _toPy = {'Args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~GetTokenArg]
        '''
        args_ = [GetTokenArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class GoalState(Type):
    _toSchema = {'relations': 'relations', 'units': 'units'}
    _toPy = {'relations': 'relations', 'units': 'units'}
    def __init__(self, relations=None, units=None, **unknown_fields):
        '''
        relations : typing.Mapping[str, typing.Any]
        units : typing.Mapping[str, ~GoalStateStatus]
        '''
        relations_ = relations
        units_ = {k: GoalStateStatus.from_json(v) for k, v in (units or dict()).items()}

        # Validate arguments against known Juju API types.
        if relations_ is not None and not isinstance(relations_, dict):
            raise Exception("Expected relations_ to be a Mapping, received: {}".format(type(relations_)))

        if units_ is not None and not isinstance(units_, dict):
            raise Exception("Expected units_ to be a Mapping, received: {}".format(type(units_)))

        self.relations = relations_
        self.units = units_
        self.unknown_fields = unknown_fields



class GoalStateResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : GoalState
        '''
        error_ = Error.from_json(error) if error else None
        result_ = GoalState.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, GoalState)):
            raise Exception("Expected result_ to be a GoalState, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class GoalStateResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~GoalStateResult]
        '''
        results_ = [GoalStateResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class GoalStateStatus(Type):
    _toSchema = {'since': 'since', 'status': 'status'}
    _toPy = {'since': 'since', 'status': 'status'}
    def __init__(self, since=None, status=None, **unknown_fields):
        '''
        since : str
        status : str
        '''
        since_ = since
        status_ = status

        # Validate arguments against known Juju API types.
        if since_ is not None and not isinstance(since_, (bytes, str)):
            raise Exception("Expected since_ to be a str, received: {}".format(type(since_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.since = since_
        self.status = status_
        self.unknown_fields = unknown_fields



class HAMember(Type):
    _toSchema = {'public_address': 'public-address', 'series': 'series', 'tag': 'tag'}
    _toPy = {'public-address': 'public_address', 'series': 'series', 'tag': 'tag'}
    def __init__(self, public_address=None, series=None, tag=None, **unknown_fields):
        '''
        public_address : Address
        series : str
        tag : str
        '''
        public_address_ = Address.from_json(public_address) if public_address else None
        series_ = series
        tag_ = tag

        # Validate arguments against known Juju API types.
        if public_address_ is not None and not isinstance(public_address_, (dict, Address)):
            raise Exception("Expected public_address_ to be a Address, received: {}".format(type(public_address_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.public_address = public_address_
        self.series = series_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class HardwareCharacteristics(Type):
    _toSchema = {'arch': 'arch', 'availability_zone': 'availability-zone', 'cpu_cores': 'cpu-cores', 'cpu_power': 'cpu-power', 'mem': 'mem', 'root_disk': 'root-disk', 'root_disk_source': 'root-disk-source', 'tags': 'tags'}
    _toPy = {'arch': 'arch', 'availability-zone': 'availability_zone', 'cpu-cores': 'cpu_cores', 'cpu-power': 'cpu_power', 'mem': 'mem', 'root-disk': 'root_disk', 'root-disk-source': 'root_disk_source', 'tags': 'tags'}
    def __init__(self, arch=None, availability_zone=None, cpu_cores=None, cpu_power=None, mem=None, root_disk=None, root_disk_source=None, tags=None, **unknown_fields):
        '''
        arch : str
        availability_zone : str
        cpu_cores : int
        cpu_power : int
        mem : int
        root_disk : int
        root_disk_source : str
        tags : typing.Sequence[str]
        '''
        arch_ = arch
        availability_zone_ = availability_zone
        cpu_cores_ = cpu_cores
        cpu_power_ = cpu_power
        mem_ = mem
        root_disk_ = root_disk
        root_disk_source_ = root_disk_source
        tags_ = tags

        # Validate arguments against known Juju API types.
        if arch_ is not None and not isinstance(arch_, (bytes, str)):
            raise Exception("Expected arch_ to be a str, received: {}".format(type(arch_)))

        if availability_zone_ is not None and not isinstance(availability_zone_, (bytes, str)):
            raise Exception("Expected availability_zone_ to be a str, received: {}".format(type(availability_zone_)))

        if cpu_cores_ is not None and not isinstance(cpu_cores_, int):
            raise Exception("Expected cpu_cores_ to be a int, received: {}".format(type(cpu_cores_)))

        if cpu_power_ is not None and not isinstance(cpu_power_, int):
            raise Exception("Expected cpu_power_ to be a int, received: {}".format(type(cpu_power_)))

        if mem_ is not None and not isinstance(mem_, int):
            raise Exception("Expected mem_ to be a int, received: {}".format(type(mem_)))

        if root_disk_ is not None and not isinstance(root_disk_, int):
            raise Exception("Expected root_disk_ to be a int, received: {}".format(type(root_disk_)))

        if root_disk_source_ is not None and not isinstance(root_disk_source_, (bytes, str)):
            raise Exception("Expected root_disk_source_ to be a str, received: {}".format(type(root_disk_source_)))

        if tags_ is not None and not isinstance(tags_, (bytes, str, list)):
            raise Exception("Expected tags_ to be a Sequence, received: {}".format(type(tags_)))

        self.arch = arch_
        self.availability_zone = availability_zone_
        self.cpu_cores = cpu_cores_
        self.cpu_power = cpu_power_
        self.mem = mem_
        self.root_disk = root_disk_
        self.root_disk_source = root_disk_source_
        self.tags = tags_
        self.unknown_fields = unknown_fields



class History(Type):
    _toSchema = {'error': 'error', 'statuses': 'statuses'}
    _toPy = {'error': 'error', 'statuses': 'statuses'}
    def __init__(self, error=None, statuses=None, **unknown_fields):
        '''
        error : Error
        statuses : typing.Sequence[~DetailedStatus]
        '''
        error_ = Error.from_json(error) if error else None
        statuses_ = [DetailedStatus.from_json(o) for o in statuses or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if statuses_ is not None and not isinstance(statuses_, (bytes, str, list)):
            raise Exception("Expected statuses_ to be a Sequence, received: {}".format(type(statuses_)))

        self.error = error_
        self.statuses = statuses_
        self.unknown_fields = unknown_fields



class HostNetworkChange(Type):
    _toSchema = {'error': 'error', 'new_bridges': 'new-bridges', 'reconfigure_delay': 'reconfigure-delay'}
    _toPy = {'error': 'error', 'new-bridges': 'new_bridges', 'reconfigure-delay': 'reconfigure_delay'}
    def __init__(self, error=None, new_bridges=None, reconfigure_delay=None, **unknown_fields):
        '''
        error : Error
        new_bridges : typing.Sequence[~DeviceBridgeInfo]
        reconfigure_delay : int
        '''
        error_ = Error.from_json(error) if error else None
        new_bridges_ = [DeviceBridgeInfo.from_json(o) for o in new_bridges or []]
        reconfigure_delay_ = reconfigure_delay

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if new_bridges_ is not None and not isinstance(new_bridges_, (bytes, str, list)):
            raise Exception("Expected new_bridges_ to be a Sequence, received: {}".format(type(new_bridges_)))

        if reconfigure_delay_ is not None and not isinstance(reconfigure_delay_, int):
            raise Exception("Expected reconfigure_delay_ to be a int, received: {}".format(type(reconfigure_delay_)))

        self.error = error_
        self.new_bridges = new_bridges_
        self.reconfigure_delay = reconfigure_delay_
        self.unknown_fields = unknown_fields



class HostNetworkChangeResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~HostNetworkChange]
        '''
        results_ = [HostNetworkChange.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class HostPort(Type):
    _toSchema = {'address': 'Address', 'port': 'port', 'scope': 'scope', 'space_id': 'space-id', 'space_name': 'space-name', 'type_': 'type', 'value': 'value'}
    _toPy = {'Address': 'address', 'port': 'port', 'scope': 'scope', 'space-id': 'space_id', 'space-name': 'space_name', 'type': 'type_', 'value': 'value'}
    def __init__(self, address=None, port=None, scope=None, space_id=None, space_name=None, type_=None, value=None, **unknown_fields):
        '''
        address : Address
        port : int
        scope : str
        space_id : str
        space_name : str
        type_ : str
        value : str
        '''
        address_ = Address.from_json(address) if address else None
        port_ = port
        scope_ = scope
        space_id_ = space_id
        space_name_ = space_name
        type__ = type_
        value_ = value

        # Validate arguments against known Juju API types.
        if address_ is not None and not isinstance(address_, (dict, Address)):
            raise Exception("Expected address_ to be a Address, received: {}".format(type(address_)))

        if port_ is not None and not isinstance(port_, int):
            raise Exception("Expected port_ to be a int, received: {}".format(type(port_)))

        if scope_ is not None and not isinstance(scope_, (bytes, str)):
            raise Exception("Expected scope_ to be a str, received: {}".format(type(scope_)))

        if space_id_ is not None and not isinstance(space_id_, (bytes, str)):
            raise Exception("Expected space_id_ to be a str, received: {}".format(type(space_id_)))

        if space_name_ is not None and not isinstance(space_name_, (bytes, str)):
            raise Exception("Expected space_name_ to be a str, received: {}".format(type(space_name_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if value_ is not None and not isinstance(value_, (bytes, str)):
            raise Exception("Expected value_ to be a str, received: {}".format(type(value_)))

        self.address = address_
        self.port = port_
        self.scope = scope_
        self.space_id = space_id_
        self.space_name = space_name_
        self.type_ = type__
        self.value = value_
        self.unknown_fields = unknown_fields



class HostedModelConfig(Type):
    _toSchema = {'cloud_spec': 'cloud-spec', 'config': 'config', 'error': 'error', 'name': 'name', 'owner': 'owner'}
    _toPy = {'cloud-spec': 'cloud_spec', 'config': 'config', 'error': 'error', 'name': 'name', 'owner': 'owner'}
    def __init__(self, cloud_spec=None, config=None, error=None, name=None, owner=None, **unknown_fields):
        '''
        cloud_spec : CloudSpec
        config : typing.Mapping[str, typing.Any]
        error : Error
        name : str
        owner : str
        '''
        cloud_spec_ = CloudSpec.from_json(cloud_spec) if cloud_spec else None
        config_ = config
        error_ = Error.from_json(error) if error else None
        name_ = name
        owner_ = owner

        # Validate arguments against known Juju API types.
        if cloud_spec_ is not None and not isinstance(cloud_spec_, (dict, CloudSpec)):
            raise Exception("Expected cloud_spec_ to be a CloudSpec, received: {}".format(type(cloud_spec_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if owner_ is not None and not isinstance(owner_, (bytes, str)):
            raise Exception("Expected owner_ to be a str, received: {}".format(type(owner_)))

        self.cloud_spec = cloud_spec_
        self.config = config_
        self.error = error_
        self.name = name_
        self.owner = owner_
        self.unknown_fields = unknown_fields



class HostedModelConfigsResults(Type):
    _toSchema = {'models': 'models'}
    _toPy = {'models': 'models'}
    def __init__(self, models=None, **unknown_fields):
        '''
        models : typing.Sequence[~HostedModelConfig]
        '''
        models_ = [HostedModelConfig.from_json(o) for o in models or []]

        # Validate arguments against known Juju API types.
        if models_ is not None and not isinstance(models_, (bytes, str, list)):
            raise Exception("Expected models_ to be a Sequence, received: {}".format(type(models_)))

        self.models = models_
        self.unknown_fields = unknown_fields



class ImageFilterParams(Type):
    _toSchema = {'images': 'images'}
    _toPy = {'images': 'images'}
    def __init__(self, images=None, **unknown_fields):
        '''
        images : typing.Sequence[~ImageSpec]
        '''
        images_ = [ImageSpec.from_json(o) for o in images or []]

        # Validate arguments against known Juju API types.
        if images_ is not None and not isinstance(images_, (bytes, str, list)):
            raise Exception("Expected images_ to be a Sequence, received: {}".format(type(images_)))

        self.images = images_
        self.unknown_fields = unknown_fields



class ImageMetadata(Type):
    _toSchema = {'arch': 'arch', 'created': 'created', 'kind': 'kind', 'series': 'series', 'url': 'url'}
    _toPy = {'arch': 'arch', 'created': 'created', 'kind': 'kind', 'series': 'series', 'url': 'url'}
    def __init__(self, arch=None, created=None, kind=None, series=None, url=None, **unknown_fields):
        '''
        arch : str
        created : str
        kind : str
        series : str
        url : str
        '''
        arch_ = arch
        created_ = created
        kind_ = kind
        series_ = series
        url_ = url

        # Validate arguments against known Juju API types.
        if arch_ is not None and not isinstance(arch_, (bytes, str)):
            raise Exception("Expected arch_ to be a str, received: {}".format(type(arch_)))

        if created_ is not None and not isinstance(created_, (bytes, str)):
            raise Exception("Expected created_ to be a str, received: {}".format(type(created_)))

        if kind_ is not None and not isinstance(kind_, (bytes, str)):
            raise Exception("Expected kind_ to be a str, received: {}".format(type(kind_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if url_ is not None and not isinstance(url_, (bytes, str)):
            raise Exception("Expected url_ to be a str, received: {}".format(type(url_)))

        self.arch = arch_
        self.created = created_
        self.kind = kind_
        self.series = series_
        self.url = url_
        self.unknown_fields = unknown_fields



class ImageMetadataFilter(Type):
    _toSchema = {'arches': 'arches', 'region': 'region', 'root_storage_type': 'root-storage-type', 'series': 'series', 'stream': 'stream', 'virt_type': 'virt-type'}
    _toPy = {'arches': 'arches', 'region': 'region', 'root-storage-type': 'root_storage_type', 'series': 'series', 'stream': 'stream', 'virt-type': 'virt_type'}
    def __init__(self, arches=None, region=None, root_storage_type=None, series=None, stream=None, virt_type=None, **unknown_fields):
        '''
        arches : typing.Sequence[str]
        region : str
        root_storage_type : str
        series : typing.Sequence[str]
        stream : str
        virt_type : str
        '''
        arches_ = arches
        region_ = region
        root_storage_type_ = root_storage_type
        series_ = series
        stream_ = stream
        virt_type_ = virt_type

        # Validate arguments against known Juju API types.
        if arches_ is not None and not isinstance(arches_, (bytes, str, list)):
            raise Exception("Expected arches_ to be a Sequence, received: {}".format(type(arches_)))

        if region_ is not None and not isinstance(region_, (bytes, str)):
            raise Exception("Expected region_ to be a str, received: {}".format(type(region_)))

        if root_storage_type_ is not None and not isinstance(root_storage_type_, (bytes, str)):
            raise Exception("Expected root_storage_type_ to be a str, received: {}".format(type(root_storage_type_)))

        if series_ is not None and not isinstance(series_, (bytes, str, list)):
            raise Exception("Expected series_ to be a Sequence, received: {}".format(type(series_)))

        if stream_ is not None and not isinstance(stream_, (bytes, str)):
            raise Exception("Expected stream_ to be a str, received: {}".format(type(stream_)))

        if virt_type_ is not None and not isinstance(virt_type_, (bytes, str)):
            raise Exception("Expected virt_type_ to be a str, received: {}".format(type(virt_type_)))

        self.arches = arches_
        self.region = region_
        self.root_storage_type = root_storage_type_
        self.series = series_
        self.stream = stream_
        self.virt_type = virt_type_
        self.unknown_fields = unknown_fields



class ImageSpec(Type):
    _toSchema = {'arch': 'arch', 'kind': 'kind', 'series': 'series'}
    _toPy = {'arch': 'arch', 'kind': 'kind', 'series': 'series'}
    def __init__(self, arch=None, kind=None, series=None, **unknown_fields):
        '''
        arch : str
        kind : str
        series : str
        '''
        arch_ = arch
        kind_ = kind
        series_ = series

        # Validate arguments against known Juju API types.
        if arch_ is not None and not isinstance(arch_, (bytes, str)):
            raise Exception("Expected arch_ to be a str, received: {}".format(type(arch_)))

        if kind_ is not None and not isinstance(kind_, (bytes, str)):
            raise Exception("Expected kind_ to be a str, received: {}".format(type(kind_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        self.arch = arch_
        self.kind = kind_
        self.series = series_
        self.unknown_fields = unknown_fields



class ImportStorageDetails(Type):
    _toSchema = {'storage_tag': 'storage-tag'}
    _toPy = {'storage-tag': 'storage_tag'}
    def __init__(self, storage_tag=None, **unknown_fields):
        '''
        storage_tag : str
        '''
        storage_tag_ = storage_tag

        # Validate arguments against known Juju API types.
        if storage_tag_ is not None and not isinstance(storage_tag_, (bytes, str)):
            raise Exception("Expected storage_tag_ to be a str, received: {}".format(type(storage_tag_)))

        self.storage_tag = storage_tag_
        self.unknown_fields = unknown_fields



class ImportStorageParams(Type):
    _toSchema = {'kind': 'kind', 'pool': 'pool', 'provider_id': 'provider-id', 'storage_name': 'storage-name'}
    _toPy = {'kind': 'kind', 'pool': 'pool', 'provider-id': 'provider_id', 'storage-name': 'storage_name'}
    def __init__(self, kind=None, pool=None, provider_id=None, storage_name=None, **unknown_fields):
        '''
        kind : int
        pool : str
        provider_id : str
        storage_name : str
        '''
        kind_ = kind
        pool_ = pool
        provider_id_ = provider_id
        storage_name_ = storage_name

        # Validate arguments against known Juju API types.
        if kind_ is not None and not isinstance(kind_, int):
            raise Exception("Expected kind_ to be a int, received: {}".format(type(kind_)))

        if pool_ is not None and not isinstance(pool_, (bytes, str)):
            raise Exception("Expected pool_ to be a str, received: {}".format(type(pool_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if storage_name_ is not None and not isinstance(storage_name_, (bytes, str)):
            raise Exception("Expected storage_name_ to be a str, received: {}".format(type(storage_name_)))

        self.kind = kind_
        self.pool = pool_
        self.provider_id = provider_id_
        self.storage_name = storage_name_
        self.unknown_fields = unknown_fields



class ImportStorageResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ImportStorageDetails
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ImportStorageDetails.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ImportStorageDetails)):
            raise Exception("Expected result_ to be a ImportStorageDetails, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ImportStorageResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ImportStorageResult]
        '''
        results_ = [ImportStorageResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class IngressNetworksChangeEvent(Type):
    _toSchema = {'application_token': 'application-token', 'bakery_version': 'bakery-version', 'ingress_required': 'ingress-required', 'macaroons': 'macaroons', 'networks': 'networks', 'relation_token': 'relation-token'}
    _toPy = {'application-token': 'application_token', 'bakery-version': 'bakery_version', 'ingress-required': 'ingress_required', 'macaroons': 'macaroons', 'networks': 'networks', 'relation-token': 'relation_token'}
    def __init__(self, application_token=None, bakery_version=None, ingress_required=None, macaroons=None, networks=None, relation_token=None, **unknown_fields):
        '''
        application_token : str
        bakery_version : int
        ingress_required : bool
        macaroons : typing.Sequence[~Macaroon]
        networks : typing.Sequence[str]
        relation_token : str
        '''
        application_token_ = application_token
        bakery_version_ = bakery_version
        ingress_required_ = ingress_required
        macaroons_ = [Macaroon.from_json(o) for o in macaroons or []]
        networks_ = networks
        relation_token_ = relation_token

        # Validate arguments against known Juju API types.
        if application_token_ is not None and not isinstance(application_token_, (bytes, str)):
            raise Exception("Expected application_token_ to be a str, received: {}".format(type(application_token_)))

        if bakery_version_ is not None and not isinstance(bakery_version_, int):
            raise Exception("Expected bakery_version_ to be a int, received: {}".format(type(bakery_version_)))

        if ingress_required_ is not None and not isinstance(ingress_required_, bool):
            raise Exception("Expected ingress_required_ to be a bool, received: {}".format(type(ingress_required_)))

        if macaroons_ is not None and not isinstance(macaroons_, (bytes, str, list)):
            raise Exception("Expected macaroons_ to be a Sequence, received: {}".format(type(macaroons_)))

        if networks_ is not None and not isinstance(networks_, (bytes, str, list)):
            raise Exception("Expected networks_ to be a Sequence, received: {}".format(type(networks_)))

        if relation_token_ is not None and not isinstance(relation_token_, (bytes, str)):
            raise Exception("Expected relation_token_ to be a str, received: {}".format(type(relation_token_)))

        self.application_token = application_token_
        self.bakery_version = bakery_version_
        self.ingress_required = ingress_required_
        self.macaroons = macaroons_
        self.networks = networks_
        self.relation_token = relation_token_
        self.unknown_fields = unknown_fields



class IngressNetworksChanges(Type):
    _toSchema = {'changes': 'changes'}
    _toPy = {'changes': 'changes'}
    def __init__(self, changes=None, **unknown_fields):
        '''
        changes : typing.Sequence[~IngressNetworksChangeEvent]
        '''
        changes_ = [IngressNetworksChangeEvent.from_json(o) for o in changes or []]

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        self.changes = changes_
        self.unknown_fields = unknown_fields



class InitiateMigrationArgs(Type):
    _toSchema = {'specs': 'specs'}
    _toPy = {'specs': 'specs'}
    def __init__(self, specs=None, **unknown_fields):
        '''
        specs : typing.Sequence[~MigrationSpec]
        '''
        specs_ = [MigrationSpec.from_json(o) for o in specs or []]

        # Validate arguments against known Juju API types.
        if specs_ is not None and not isinstance(specs_, (bytes, str, list)):
            raise Exception("Expected specs_ to be a Sequence, received: {}".format(type(specs_)))

        self.specs = specs_
        self.unknown_fields = unknown_fields



class InitiateMigrationResult(Type):
    _toSchema = {'error': 'error', 'migration_id': 'migration-id', 'model_tag': 'model-tag'}
    _toPy = {'error': 'error', 'migration-id': 'migration_id', 'model-tag': 'model_tag'}
    def __init__(self, error=None, migration_id=None, model_tag=None, **unknown_fields):
        '''
        error : Error
        migration_id : str
        model_tag : str
        '''
        error_ = Error.from_json(error) if error else None
        migration_id_ = migration_id
        model_tag_ = model_tag

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if migration_id_ is not None and not isinstance(migration_id_, (bytes, str)):
            raise Exception("Expected migration_id_ to be a str, received: {}".format(type(migration_id_)))

        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        self.error = error_
        self.migration_id = migration_id_
        self.model_tag = model_tag_
        self.unknown_fields = unknown_fields



class InitiateMigrationResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~InitiateMigrationResult]
        '''
        results_ = [InitiateMigrationResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class InstanceInfo(Type):
    _toSchema = {'characteristics': 'characteristics', 'charm_profiles': 'charm-profiles', 'display_name': 'display-name', 'instance_id': 'instance-id', 'network_config': 'network-config', 'nonce': 'nonce', 'tag': 'tag', 'volume_attachments': 'volume-attachments', 'volumes': 'volumes'}
    _toPy = {'characteristics': 'characteristics', 'charm-profiles': 'charm_profiles', 'display-name': 'display_name', 'instance-id': 'instance_id', 'network-config': 'network_config', 'nonce': 'nonce', 'tag': 'tag', 'volume-attachments': 'volume_attachments', 'volumes': 'volumes'}
    def __init__(self, characteristics=None, charm_profiles=None, display_name=None, instance_id=None, network_config=None, nonce=None, tag=None, volume_attachments=None, volumes=None, **unknown_fields):
        '''
        characteristics : HardwareCharacteristics
        charm_profiles : typing.Sequence[str]
        display_name : str
        instance_id : str
        network_config : typing.Sequence[~NetworkConfig]
        nonce : str
        tag : str
        volume_attachments : typing.Mapping[str, ~VolumeAttachmentInfo]
        volumes : typing.Sequence[~Volume]
        '''
        characteristics_ = HardwareCharacteristics.from_json(characteristics) if characteristics else None
        charm_profiles_ = charm_profiles
        display_name_ = display_name
        instance_id_ = instance_id
        network_config_ = [NetworkConfig.from_json(o) for o in network_config or []]
        nonce_ = nonce
        tag_ = tag
        volume_attachments_ = {k: VolumeAttachmentInfo.from_json(v) for k, v in (volume_attachments or dict()).items()}
        volumes_ = [Volume.from_json(o) for o in volumes or []]

        # Validate arguments against known Juju API types.
        if characteristics_ is not None and not isinstance(characteristics_, (dict, HardwareCharacteristics)):
            raise Exception("Expected characteristics_ to be a HardwareCharacteristics, received: {}".format(type(characteristics_)))

        if charm_profiles_ is not None and not isinstance(charm_profiles_, (bytes, str, list)):
            raise Exception("Expected charm_profiles_ to be a Sequence, received: {}".format(type(charm_profiles_)))

        if display_name_ is not None and not isinstance(display_name_, (bytes, str)):
            raise Exception("Expected display_name_ to be a str, received: {}".format(type(display_name_)))

        if instance_id_ is not None and not isinstance(instance_id_, (bytes, str)):
            raise Exception("Expected instance_id_ to be a str, received: {}".format(type(instance_id_)))

        if network_config_ is not None and not isinstance(network_config_, (bytes, str, list)):
            raise Exception("Expected network_config_ to be a Sequence, received: {}".format(type(network_config_)))

        if nonce_ is not None and not isinstance(nonce_, (bytes, str)):
            raise Exception("Expected nonce_ to be a str, received: {}".format(type(nonce_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if volume_attachments_ is not None and not isinstance(volume_attachments_, dict):
            raise Exception("Expected volume_attachments_ to be a Mapping, received: {}".format(type(volume_attachments_)))

        if volumes_ is not None and not isinstance(volumes_, (bytes, str, list)):
            raise Exception("Expected volumes_ to be a Sequence, received: {}".format(type(volumes_)))

        self.characteristics = characteristics_
        self.charm_profiles = charm_profiles_
        self.display_name = display_name_
        self.instance_id = instance_id_
        self.network_config = network_config_
        self.nonce = nonce_
        self.tag = tag_
        self.volume_attachments = volume_attachments_
        self.volumes = volumes_
        self.unknown_fields = unknown_fields



class InstanceType(Type):
    _toSchema = {'arches': 'arches', 'cost': 'cost', 'cpu_cores': 'cpu-cores', 'deprecated': 'deprecated', 'memory': 'memory', 'name': 'name', 'root_disk': 'root-disk', 'virt_type': 'virt-type'}
    _toPy = {'arches': 'arches', 'cost': 'cost', 'cpu-cores': 'cpu_cores', 'deprecated': 'deprecated', 'memory': 'memory', 'name': 'name', 'root-disk': 'root_disk', 'virt-type': 'virt_type'}
    def __init__(self, arches=None, cost=None, cpu_cores=None, deprecated=None, memory=None, name=None, root_disk=None, virt_type=None, **unknown_fields):
        '''
        arches : typing.Sequence[str]
        cost : int
        cpu_cores : int
        deprecated : bool
        memory : int
        name : str
        root_disk : int
        virt_type : str
        '''
        arches_ = arches
        cost_ = cost
        cpu_cores_ = cpu_cores
        deprecated_ = deprecated
        memory_ = memory
        name_ = name
        root_disk_ = root_disk
        virt_type_ = virt_type

        # Validate arguments against known Juju API types.
        if arches_ is not None and not isinstance(arches_, (bytes, str, list)):
            raise Exception("Expected arches_ to be a Sequence, received: {}".format(type(arches_)))

        if cost_ is not None and not isinstance(cost_, int):
            raise Exception("Expected cost_ to be a int, received: {}".format(type(cost_)))

        if cpu_cores_ is not None and not isinstance(cpu_cores_, int):
            raise Exception("Expected cpu_cores_ to be a int, received: {}".format(type(cpu_cores_)))

        if deprecated_ is not None and not isinstance(deprecated_, bool):
            raise Exception("Expected deprecated_ to be a bool, received: {}".format(type(deprecated_)))

        if memory_ is not None and not isinstance(memory_, int):
            raise Exception("Expected memory_ to be a int, received: {}".format(type(memory_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if root_disk_ is not None and not isinstance(root_disk_, int):
            raise Exception("Expected root_disk_ to be a int, received: {}".format(type(root_disk_)))

        if virt_type_ is not None and not isinstance(virt_type_, (bytes, str)):
            raise Exception("Expected virt_type_ to be a str, received: {}".format(type(virt_type_)))

        self.arches = arches_
        self.cost = cost_
        self.cpu_cores = cpu_cores_
        self.deprecated = deprecated_
        self.memory = memory_
        self.name = name_
        self.root_disk = root_disk_
        self.virt_type = virt_type_
        self.unknown_fields = unknown_fields



class InstanceTypesResult(Type):
    _toSchema = {'cost_currency': 'cost-currency', 'cost_divisor': 'cost-divisor', 'cost_unit': 'cost-unit', 'error': 'error', 'instance_types': 'instance-types'}
    _toPy = {'cost-currency': 'cost_currency', 'cost-divisor': 'cost_divisor', 'cost-unit': 'cost_unit', 'error': 'error', 'instance-types': 'instance_types'}
    def __init__(self, cost_currency=None, cost_divisor=None, cost_unit=None, error=None, instance_types=None, **unknown_fields):
        '''
        cost_currency : str
        cost_divisor : int
        cost_unit : str
        error : Error
        instance_types : typing.Sequence[~InstanceType]
        '''
        cost_currency_ = cost_currency
        cost_divisor_ = cost_divisor
        cost_unit_ = cost_unit
        error_ = Error.from_json(error) if error else None
        instance_types_ = [InstanceType.from_json(o) for o in instance_types or []]

        # Validate arguments against known Juju API types.
        if cost_currency_ is not None and not isinstance(cost_currency_, (bytes, str)):
            raise Exception("Expected cost_currency_ to be a str, received: {}".format(type(cost_currency_)))

        if cost_divisor_ is not None and not isinstance(cost_divisor_, int):
            raise Exception("Expected cost_divisor_ to be a int, received: {}".format(type(cost_divisor_)))

        if cost_unit_ is not None and not isinstance(cost_unit_, (bytes, str)):
            raise Exception("Expected cost_unit_ to be a str, received: {}".format(type(cost_unit_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if instance_types_ is not None and not isinstance(instance_types_, (bytes, str, list)):
            raise Exception("Expected instance_types_ to be a Sequence, received: {}".format(type(instance_types_)))

        self.cost_currency = cost_currency_
        self.cost_divisor = cost_divisor_
        self.cost_unit = cost_unit_
        self.error = error_
        self.instance_types = instance_types_
        self.unknown_fields = unknown_fields



class InstanceTypesResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~InstanceTypesResult]
        '''
        results_ = [InstanceTypesResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class InstancesInfo(Type):
    _toSchema = {'machines': 'machines'}
    _toPy = {'machines': 'machines'}
    def __init__(self, machines=None, **unknown_fields):
        '''
        machines : typing.Sequence[~InstanceInfo]
        '''
        machines_ = [InstanceInfo.from_json(o) for o in machines or []]

        # Validate arguments against known Juju API types.
        if machines_ is not None and not isinstance(machines_, (bytes, str, list)):
            raise Exception("Expected machines_ to be a Sequence, received: {}".format(type(machines_)))

        self.machines = machines_
        self.unknown_fields = unknown_fields



class IntResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : int
        '''
        error_ = Error.from_json(error) if error else None
        result_ = result

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, int):
            raise Exception("Expected result_ to be a int, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class IntResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~IntResult]
        '''
        results_ = [IntResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class InterfaceAddress(Type):
    _toSchema = {'cidr': 'cidr', 'hostname': 'hostname', 'value': 'value'}
    _toPy = {'cidr': 'cidr', 'hostname': 'hostname', 'value': 'value'}
    def __init__(self, cidr=None, hostname=None, value=None, **unknown_fields):
        '''
        cidr : str
        hostname : str
        value : str
        '''
        cidr_ = cidr
        hostname_ = hostname
        value_ = value

        # Validate arguments against known Juju API types.
        if cidr_ is not None and not isinstance(cidr_, (bytes, str)):
            raise Exception("Expected cidr_ to be a str, received: {}".format(type(cidr_)))

        if hostname_ is not None and not isinstance(hostname_, (bytes, str)):
            raise Exception("Expected hostname_ to be a str, received: {}".format(type(hostname_)))

        if value_ is not None and not isinstance(value_, (bytes, str)):
            raise Exception("Expected value_ to be a str, received: {}".format(type(value_)))

        self.cidr = cidr_
        self.hostname = hostname_
        self.value = value_
        self.unknown_fields = unknown_fields



class InvalidateCredentialArg(Type):
    _toSchema = {'reason': 'reason'}
    _toPy = {'reason': 'reason'}
    def __init__(self, reason=None, **unknown_fields):
        '''
        reason : str
        '''
        reason_ = reason

        # Validate arguments against known Juju API types.
        if reason_ is not None and not isinstance(reason_, (bytes, str)):
            raise Exception("Expected reason_ to be a str, received: {}".format(type(reason_)))

        self.reason = reason_
        self.unknown_fields = unknown_fields



class IsMasterResult(Type):
    _toSchema = {'master': 'master'}
    _toPy = {'master': 'master'}
    def __init__(self, master=None, **unknown_fields):
        '''
        master : bool
        '''
        master_ = master

        # Validate arguments against known Juju API types.
        if master_ is not None and not isinstance(master_, bool):
            raise Exception("Expected master_ to be a bool, received: {}".format(type(master_)))

        self.master = master_
        self.unknown_fields = unknown_fields



class IsMeteredResult(Type):
    _toSchema = {'metered': 'metered'}
    _toPy = {'metered': 'metered'}
    def __init__(self, metered=None, **unknown_fields):
        '''
        metered : bool
        '''
        metered_ = metered

        # Validate arguments against known Juju API types.
        if metered_ is not None and not isinstance(metered_, bool):
            raise Exception("Expected metered_ to be a bool, received: {}".format(type(metered_)))

        self.metered = metered_
        self.unknown_fields = unknown_fields



class IssueOperatorCertificateResult(Type):
    _toSchema = {'ca_cert': 'ca-cert', 'cert': 'cert', 'error': 'error', 'private_key': 'private-key'}
    _toPy = {'ca-cert': 'ca_cert', 'cert': 'cert', 'error': 'error', 'private-key': 'private_key'}
    def __init__(self, ca_cert=None, cert=None, error=None, private_key=None, **unknown_fields):
        '''
        ca_cert : str
        cert : str
        error : Error
        private_key : str
        '''
        ca_cert_ = ca_cert
        cert_ = cert
        error_ = Error.from_json(error) if error else None
        private_key_ = private_key

        # Validate arguments against known Juju API types.
        if ca_cert_ is not None and not isinstance(ca_cert_, (bytes, str)):
            raise Exception("Expected ca_cert_ to be a str, received: {}".format(type(ca_cert_)))

        if cert_ is not None and not isinstance(cert_, (bytes, str)):
            raise Exception("Expected cert_ to be a str, received: {}".format(type(cert_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if private_key_ is not None and not isinstance(private_key_, (bytes, str)):
            raise Exception("Expected private_key_ to be a str, received: {}".format(type(private_key_)))

        self.ca_cert = ca_cert_
        self.cert = cert_
        self.error = error_
        self.private_key = private_key_
        self.unknown_fields = unknown_fields



class IssueOperatorCertificateResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~IssueOperatorCertificateResult]
        '''
        results_ = [IssueOperatorCertificateResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class JobsResult(Type):
    _toSchema = {'error': 'error', 'jobs': 'jobs'}
    _toPy = {'error': 'error', 'jobs': 'jobs'}
    def __init__(self, error=None, jobs=None, **unknown_fields):
        '''
        error : Error
        jobs : typing.Sequence[str]
        '''
        error_ = Error.from_json(error) if error else None
        jobs_ = jobs

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if jobs_ is not None and not isinstance(jobs_, (bytes, str, list)):
            raise Exception("Expected jobs_ to be a Sequence, received: {}".format(type(jobs_)))

        self.error = error_
        self.jobs = jobs_
        self.unknown_fields = unknown_fields



class JobsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~JobsResult]
        '''
        results_ = [JobsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class KnownServiceArgs(Type):
    _toSchema = {'known_services': 'known-services'}
    _toPy = {'known-services': 'known_services'}
    def __init__(self, known_services=None, **unknown_fields):
        '''
        known_services : typing.Sequence[str]
        '''
        known_services_ = known_services

        # Validate arguments against known Juju API types.
        if known_services_ is not None and not isinstance(known_services_, (bytes, str, list)):
            raise Exception("Expected known_services_ to be a Sequence, received: {}".format(type(known_services_)))

        self.known_services = known_services_
        self.unknown_fields = unknown_fields



class KubernetesDeploymentInfo(Type):
    _toSchema = {'deployment_type': 'deployment-type', 'service_type': 'service-type'}
    _toPy = {'deployment-type': 'deployment_type', 'service-type': 'service_type'}
    def __init__(self, deployment_type=None, service_type=None, **unknown_fields):
        '''
        deployment_type : str
        service_type : str
        '''
        deployment_type_ = deployment_type
        service_type_ = service_type

        # Validate arguments against known Juju API types.
        if deployment_type_ is not None and not isinstance(deployment_type_, (bytes, str)):
            raise Exception("Expected deployment_type_ to be a str, received: {}".format(type(deployment_type_)))

        if service_type_ is not None and not isinstance(service_type_, (bytes, str)):
            raise Exception("Expected service_type_ to be a str, received: {}".format(type(service_type_)))

        self.deployment_type = deployment_type_
        self.service_type = service_type_
        self.unknown_fields = unknown_fields



class KubernetesDeviceParams(Type):
    _toSchema = {'attributes': 'Attributes', 'count': 'Count', 'type_': 'Type'}
    _toPy = {'Attributes': 'attributes', 'Count': 'count', 'Type': 'type_'}
    def __init__(self, attributes=None, count=None, type_=None, **unknown_fields):
        '''
        attributes : typing.Mapping[str, str]
        count : int
        type_ : str
        '''
        attributes_ = attributes
        count_ = count
        type__ = type_

        # Validate arguments against known Juju API types.
        if attributes_ is not None and not isinstance(attributes_, dict):
            raise Exception("Expected attributes_ to be a Mapping, received: {}".format(type(attributes_)))

        if count_ is not None and not isinstance(count_, int):
            raise Exception("Expected count_ to be a int, received: {}".format(type(count_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        self.attributes = attributes_
        self.count = count_
        self.type_ = type__
        self.unknown_fields = unknown_fields



class KubernetesFilesystemAttachmentParams(Type):
    _toSchema = {'mount_point': 'mount-point', 'provider': 'provider', 'read_only': 'read-only'}
    _toPy = {'mount-point': 'mount_point', 'provider': 'provider', 'read-only': 'read_only'}
    def __init__(self, mount_point=None, provider=None, read_only=None, **unknown_fields):
        '''
        mount_point : str
        provider : str
        read_only : bool
        '''
        mount_point_ = mount_point
        provider_ = provider
        read_only_ = read_only

        # Validate arguments against known Juju API types.
        if mount_point_ is not None and not isinstance(mount_point_, (bytes, str)):
            raise Exception("Expected mount_point_ to be a str, received: {}".format(type(mount_point_)))

        if provider_ is not None and not isinstance(provider_, (bytes, str)):
            raise Exception("Expected provider_ to be a str, received: {}".format(type(provider_)))

        if read_only_ is not None and not isinstance(read_only_, bool):
            raise Exception("Expected read_only_ to be a bool, received: {}".format(type(read_only_)))

        self.mount_point = mount_point_
        self.provider = provider_
        self.read_only = read_only_
        self.unknown_fields = unknown_fields



class KubernetesFilesystemInfo(Type):
    _toSchema = {'data': 'data', 'filesystem_id': 'filesystem-id', 'info': 'info', 'mount_point': 'mount-point', 'pool': 'pool', 'read_only': 'read-only', 'size': 'size', 'status': 'status', 'storagename': 'storagename', 'volume': 'volume'}
    _toPy = {'data': 'data', 'filesystem-id': 'filesystem_id', 'info': 'info', 'mount-point': 'mount_point', 'pool': 'pool', 'read-only': 'read_only', 'size': 'size', 'status': 'status', 'storagename': 'storagename', 'volume': 'volume'}
    def __init__(self, data=None, filesystem_id=None, info=None, mount_point=None, pool=None, read_only=None, size=None, status=None, storagename=None, volume=None, **unknown_fields):
        '''
        data : typing.Mapping[str, typing.Any]
        filesystem_id : str
        info : str
        mount_point : str
        pool : str
        read_only : bool
        size : int
        status : str
        storagename : str
        volume : KubernetesVolumeInfo
        '''
        data_ = data
        filesystem_id_ = filesystem_id
        info_ = info
        mount_point_ = mount_point
        pool_ = pool
        read_only_ = read_only
        size_ = size
        status_ = status
        storagename_ = storagename
        volume_ = KubernetesVolumeInfo.from_json(volume) if volume else None

        # Validate arguments against known Juju API types.
        if data_ is not None and not isinstance(data_, dict):
            raise Exception("Expected data_ to be a Mapping, received: {}".format(type(data_)))

        if filesystem_id_ is not None and not isinstance(filesystem_id_, (bytes, str)):
            raise Exception("Expected filesystem_id_ to be a str, received: {}".format(type(filesystem_id_)))

        if info_ is not None and not isinstance(info_, (bytes, str)):
            raise Exception("Expected info_ to be a str, received: {}".format(type(info_)))

        if mount_point_ is not None and not isinstance(mount_point_, (bytes, str)):
            raise Exception("Expected mount_point_ to be a str, received: {}".format(type(mount_point_)))

        if pool_ is not None and not isinstance(pool_, (bytes, str)):
            raise Exception("Expected pool_ to be a str, received: {}".format(type(pool_)))

        if read_only_ is not None and not isinstance(read_only_, bool):
            raise Exception("Expected read_only_ to be a bool, received: {}".format(type(read_only_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if storagename_ is not None and not isinstance(storagename_, (bytes, str)):
            raise Exception("Expected storagename_ to be a str, received: {}".format(type(storagename_)))

        if volume_ is not None and not isinstance(volume_, (dict, KubernetesVolumeInfo)):
            raise Exception("Expected volume_ to be a KubernetesVolumeInfo, received: {}".format(type(volume_)))

        self.data = data_
        self.filesystem_id = filesystem_id_
        self.info = info_
        self.mount_point = mount_point_
        self.pool = pool_
        self.read_only = read_only_
        self.size = size_
        self.status = status_
        self.storagename = storagename_
        self.volume = volume_
        self.unknown_fields = unknown_fields



class KubernetesFilesystemParams(Type):
    _toSchema = {'attachment': 'attachment', 'attributes': 'attributes', 'provider': 'provider', 'size': 'size', 'storagename': 'storagename', 'tags': 'tags'}
    _toPy = {'attachment': 'attachment', 'attributes': 'attributes', 'provider': 'provider', 'size': 'size', 'storagename': 'storagename', 'tags': 'tags'}
    def __init__(self, attachment=None, attributes=None, provider=None, size=None, storagename=None, tags=None, **unknown_fields):
        '''
        attachment : KubernetesFilesystemAttachmentParams
        attributes : typing.Mapping[str, typing.Any]
        provider : str
        size : int
        storagename : str
        tags : typing.Mapping[str, str]
        '''
        attachment_ = KubernetesFilesystemAttachmentParams.from_json(attachment) if attachment else None
        attributes_ = attributes
        provider_ = provider
        size_ = size
        storagename_ = storagename
        tags_ = tags

        # Validate arguments against known Juju API types.
        if attachment_ is not None and not isinstance(attachment_, (dict, KubernetesFilesystemAttachmentParams)):
            raise Exception("Expected attachment_ to be a KubernetesFilesystemAttachmentParams, received: {}".format(type(attachment_)))

        if attributes_ is not None and not isinstance(attributes_, dict):
            raise Exception("Expected attributes_ to be a Mapping, received: {}".format(type(attributes_)))

        if provider_ is not None and not isinstance(provider_, (bytes, str)):
            raise Exception("Expected provider_ to be a str, received: {}".format(type(provider_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if storagename_ is not None and not isinstance(storagename_, (bytes, str)):
            raise Exception("Expected storagename_ to be a str, received: {}".format(type(storagename_)))

        if tags_ is not None and not isinstance(tags_, dict):
            raise Exception("Expected tags_ to be a Mapping, received: {}".format(type(tags_)))

        self.attachment = attachment_
        self.attributes = attributes_
        self.provider = provider_
        self.size = size_
        self.storagename = storagename_
        self.tags = tags_
        self.unknown_fields = unknown_fields



class KubernetesProvisioningInfo(Type):
    _toSchema = {'charm_modified_version': 'charm-modified-version', 'constraints': 'constraints', 'deployment_info': 'deployment-info', 'devices': 'devices', 'filesystems': 'filesystems', 'operator_image_path': 'operator-image-path', 'pod_spec': 'pod-spec', 'raw_k8s_spec': 'raw-k8s-spec', 'tags': 'tags', 'volumes': 'volumes'}
    _toPy = {'charm-modified-version': 'charm_modified_version', 'constraints': 'constraints', 'deployment-info': 'deployment_info', 'devices': 'devices', 'filesystems': 'filesystems', 'operator-image-path': 'operator_image_path', 'pod-spec': 'pod_spec', 'raw-k8s-spec': 'raw_k8s_spec', 'tags': 'tags', 'volumes': 'volumes'}
    def __init__(self, charm_modified_version=None, constraints=None, deployment_info=None, devices=None, filesystems=None, operator_image_path=None, pod_spec=None, raw_k8s_spec=None, tags=None, volumes=None, **unknown_fields):
        '''
        charm_modified_version : int
        constraints : Value
        deployment_info : KubernetesDeploymentInfo
        devices : typing.Sequence[~KubernetesDeviceParams]
        filesystems : typing.Sequence[~KubernetesFilesystemParams]
        operator_image_path : str
        pod_spec : str
        raw_k8s_spec : str
        tags : typing.Mapping[str, str]
        volumes : typing.Sequence[~KubernetesVolumeParams]
        '''
        charm_modified_version_ = charm_modified_version
        constraints_ = Value.from_json(constraints) if constraints else None
        deployment_info_ = KubernetesDeploymentInfo.from_json(deployment_info) if deployment_info else None
        devices_ = [KubernetesDeviceParams.from_json(o) for o in devices or []]
        filesystems_ = [KubernetesFilesystemParams.from_json(o) for o in filesystems or []]
        operator_image_path_ = operator_image_path
        pod_spec_ = pod_spec
        raw_k8s_spec_ = raw_k8s_spec
        tags_ = tags
        volumes_ = [KubernetesVolumeParams.from_json(o) for o in volumes or []]

        # Validate arguments against known Juju API types.
        if charm_modified_version_ is not None and not isinstance(charm_modified_version_, int):
            raise Exception("Expected charm_modified_version_ to be a int, received: {}".format(type(charm_modified_version_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if deployment_info_ is not None and not isinstance(deployment_info_, (dict, KubernetesDeploymentInfo)):
            raise Exception("Expected deployment_info_ to be a KubernetesDeploymentInfo, received: {}".format(type(deployment_info_)))

        if devices_ is not None and not isinstance(devices_, (bytes, str, list)):
            raise Exception("Expected devices_ to be a Sequence, received: {}".format(type(devices_)))

        if filesystems_ is not None and not isinstance(filesystems_, (bytes, str, list)):
            raise Exception("Expected filesystems_ to be a Sequence, received: {}".format(type(filesystems_)))

        if operator_image_path_ is not None and not isinstance(operator_image_path_, (bytes, str)):
            raise Exception("Expected operator_image_path_ to be a str, received: {}".format(type(operator_image_path_)))

        if pod_spec_ is not None and not isinstance(pod_spec_, (bytes, str)):
            raise Exception("Expected pod_spec_ to be a str, received: {}".format(type(pod_spec_)))

        if raw_k8s_spec_ is not None and not isinstance(raw_k8s_spec_, (bytes, str)):
            raise Exception("Expected raw_k8s_spec_ to be a str, received: {}".format(type(raw_k8s_spec_)))

        if tags_ is not None and not isinstance(tags_, dict):
            raise Exception("Expected tags_ to be a Mapping, received: {}".format(type(tags_)))

        if volumes_ is not None and not isinstance(volumes_, (bytes, str, list)):
            raise Exception("Expected volumes_ to be a Sequence, received: {}".format(type(volumes_)))

        self.charm_modified_version = charm_modified_version_
        self.constraints = constraints_
        self.deployment_info = deployment_info_
        self.devices = devices_
        self.filesystems = filesystems_
        self.operator_image_path = operator_image_path_
        self.pod_spec = pod_spec_
        self.raw_k8s_spec = raw_k8s_spec_
        self.tags = tags_
        self.volumes = volumes_
        self.unknown_fields = unknown_fields



class KubernetesProvisioningInfoResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : KubernetesProvisioningInfo
        '''
        error_ = Error.from_json(error) if error else None
        result_ = KubernetesProvisioningInfo.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, KubernetesProvisioningInfo)):
            raise Exception("Expected result_ to be a KubernetesProvisioningInfo, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class KubernetesProvisioningInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~KubernetesProvisioningInfoResult]
        '''
        results_ = [KubernetesProvisioningInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class KubernetesUpgradeArg(Type):
    _toSchema = {'agent_tag': 'agent-tag', 'version': 'version'}
    _toPy = {'agent-tag': 'agent_tag', 'version': 'version'}
    def __init__(self, agent_tag=None, version=None, **unknown_fields):
        '''
        agent_tag : str
        version : Number
        '''
        agent_tag_ = agent_tag
        version_ = Number.from_json(version) if version else None

        # Validate arguments against known Juju API types.
        if agent_tag_ is not None and not isinstance(agent_tag_, (bytes, str)):
            raise Exception("Expected agent_tag_ to be a str, received: {}".format(type(agent_tag_)))

        if version_ is not None and not isinstance(version_, (dict, Number)):
            raise Exception("Expected version_ to be a Number, received: {}".format(type(version_)))

        self.agent_tag = agent_tag_
        self.version = version_
        self.unknown_fields = unknown_fields



class KubernetesVolumeAttachmentParams(Type):
    _toSchema = {'provider': 'provider', 'read_only': 'read-only'}
    _toPy = {'provider': 'provider', 'read-only': 'read_only'}
    def __init__(self, provider=None, read_only=None, **unknown_fields):
        '''
        provider : str
        read_only : bool
        '''
        provider_ = provider
        read_only_ = read_only

        # Validate arguments against known Juju API types.
        if provider_ is not None and not isinstance(provider_, (bytes, str)):
            raise Exception("Expected provider_ to be a str, received: {}".format(type(provider_)))

        if read_only_ is not None and not isinstance(read_only_, bool):
            raise Exception("Expected read_only_ to be a bool, received: {}".format(type(read_only_)))

        self.provider = provider_
        self.read_only = read_only_
        self.unknown_fields = unknown_fields



class KubernetesVolumeInfo(Type):
    _toSchema = {'data': 'data', 'info': 'info', 'persistent': 'persistent', 'pool': 'pool', 'size': 'size', 'status': 'status', 'volume_id': 'volume-id'}
    _toPy = {'data': 'data', 'info': 'info', 'persistent': 'persistent', 'pool': 'pool', 'size': 'size', 'status': 'status', 'volume-id': 'volume_id'}
    def __init__(self, data=None, info=None, persistent=None, pool=None, size=None, status=None, volume_id=None, **unknown_fields):
        '''
        data : typing.Mapping[str, typing.Any]
        info : str
        persistent : bool
        pool : str
        size : int
        status : str
        volume_id : str
        '''
        data_ = data
        info_ = info
        persistent_ = persistent
        pool_ = pool
        size_ = size
        status_ = status
        volume_id_ = volume_id

        # Validate arguments against known Juju API types.
        if data_ is not None and not isinstance(data_, dict):
            raise Exception("Expected data_ to be a Mapping, received: {}".format(type(data_)))

        if info_ is not None and not isinstance(info_, (bytes, str)):
            raise Exception("Expected info_ to be a str, received: {}".format(type(info_)))

        if persistent_ is not None and not isinstance(persistent_, bool):
            raise Exception("Expected persistent_ to be a bool, received: {}".format(type(persistent_)))

        if pool_ is not None and not isinstance(pool_, (bytes, str)):
            raise Exception("Expected pool_ to be a str, received: {}".format(type(pool_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if volume_id_ is not None and not isinstance(volume_id_, (bytes, str)):
            raise Exception("Expected volume_id_ to be a str, received: {}".format(type(volume_id_)))

        self.data = data_
        self.info = info_
        self.persistent = persistent_
        self.pool = pool_
        self.size = size_
        self.status = status_
        self.volume_id = volume_id_
        self.unknown_fields = unknown_fields



class KubernetesVolumeParams(Type):
    _toSchema = {'attachment': 'attachment', 'attributes': 'attributes', 'provider': 'provider', 'size': 'size', 'storagename': 'storagename', 'tags': 'tags'}
    _toPy = {'attachment': 'attachment', 'attributes': 'attributes', 'provider': 'provider', 'size': 'size', 'storagename': 'storagename', 'tags': 'tags'}
    def __init__(self, attachment=None, attributes=None, provider=None, size=None, storagename=None, tags=None, **unknown_fields):
        '''
        attachment : KubernetesVolumeAttachmentParams
        attributes : typing.Mapping[str, typing.Any]
        provider : str
        size : int
        storagename : str
        tags : typing.Mapping[str, str]
        '''
        attachment_ = KubernetesVolumeAttachmentParams.from_json(attachment) if attachment else None
        attributes_ = attributes
        provider_ = provider
        size_ = size
        storagename_ = storagename
        tags_ = tags

        # Validate arguments against known Juju API types.
        if attachment_ is not None and not isinstance(attachment_, (dict, KubernetesVolumeAttachmentParams)):
            raise Exception("Expected attachment_ to be a KubernetesVolumeAttachmentParams, received: {}".format(type(attachment_)))

        if attributes_ is not None and not isinstance(attributes_, dict):
            raise Exception("Expected attributes_ to be a Mapping, received: {}".format(type(attributes_)))

        if provider_ is not None and not isinstance(provider_, (bytes, str)):
            raise Exception("Expected provider_ to be a str, received: {}".format(type(provider_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if storagename_ is not None and not isinstance(storagename_, (bytes, str)):
            raise Exception("Expected storagename_ to be a str, received: {}".format(type(storagename_)))

        if tags_ is not None and not isinstance(tags_, dict):
            raise Exception("Expected tags_ to be a Mapping, received: {}".format(type(tags_)))

        self.attachment = attachment_
        self.attributes = attributes_
        self.provider = provider_
        self.size = size_
        self.storagename = storagename_
        self.tags = tags_
        self.unknown_fields = unknown_fields



class LXDProfile(Type):
    _toSchema = {'config': 'config', 'description': 'description', 'devices': 'devices'}
    _toPy = {'config': 'config', 'description': 'description', 'devices': 'devices'}
    def __init__(self, config=None, description=None, devices=None, **unknown_fields):
        '''
        config : typing.Mapping[str, str]
        description : str
        devices : typing.Mapping[str, typing.Any]
        '''
        config_ = config
        description_ = description
        devices_ = devices

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if devices_ is not None and not isinstance(devices_, dict):
            raise Exception("Expected devices_ to be a Mapping, received: {}".format(type(devices_)))

        self.config = config_
        self.description = description_
        self.devices = devices_
        self.unknown_fields = unknown_fields



class LXDProfileUpgradeMessages(Type):
    _toSchema = {'application': 'application', 'watcher_id': 'watcher-id'}
    _toPy = {'application': 'application', 'watcher-id': 'watcher_id'}
    def __init__(self, application=None, watcher_id=None, **unknown_fields):
        '''
        application : Entity
        watcher_id : str
        '''
        application_ = Entity.from_json(application) if application else None
        watcher_id_ = watcher_id

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (dict, Entity)):
            raise Exception("Expected application_ to be a Entity, received: {}".format(type(application_)))

        if watcher_id_ is not None and not isinstance(watcher_id_, (bytes, str)):
            raise Exception("Expected watcher_id_ to be a str, received: {}".format(type(watcher_id_)))

        self.application = application_
        self.watcher_id = watcher_id_
        self.unknown_fields = unknown_fields



class LXDProfileUpgradeMessagesResult(Type):
    _toSchema = {'error': 'error', 'message': 'message', 'unit_name': 'unit-name'}
    _toPy = {'error': 'error', 'message': 'message', 'unit-name': 'unit_name'}
    def __init__(self, error=None, message=None, unit_name=None, **unknown_fields):
        '''
        error : Error
        message : str
        unit_name : str
        '''
        error_ = Error.from_json(error) if error else None
        message_ = message
        unit_name_ = unit_name

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if unit_name_ is not None and not isinstance(unit_name_, (bytes, str)):
            raise Exception("Expected unit_name_ to be a str, received: {}".format(type(unit_name_)))

        self.error = error_
        self.message = message_
        self.unit_name = unit_name_
        self.unknown_fields = unknown_fields



class LXDProfileUpgradeMessagesResults(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~LXDProfileUpgradeMessagesResult]
        '''
        args_ = [LXDProfileUpgradeMessagesResult.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class LifeResult(Type):
    _toSchema = {'error': 'error', 'life': 'life'}
    _toPy = {'error': 'error', 'life': 'life'}
    def __init__(self, error=None, life=None, **unknown_fields):
        '''
        error : Error
        life : str
        '''
        error_ = Error.from_json(error) if error else None
        life_ = life

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        self.error = error_
        self.life = life_
        self.unknown_fields = unknown_fields



class LifeResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~LifeResult]
        '''
        results_ = [LifeResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ListCloudImageMetadataResult(Type):
    _toSchema = {'result': 'result'}
    _toPy = {'result': 'result'}
    def __init__(self, result=None, **unknown_fields):
        '''
        result : typing.Sequence[~CloudImageMetadata]
        '''
        result_ = [CloudImageMetadata.from_json(o) for o in result or []]

        # Validate arguments against known Juju API types.
        if result_ is not None and not isinstance(result_, (bytes, str, list)):
            raise Exception("Expected result_ to be a Sequence, received: {}".format(type(result_)))

        self.result = result_
        self.unknown_fields = unknown_fields



class ListCloudInfo(Type):
    _toSchema = {'clouddetails': 'CloudDetails', 'user_access': 'user-access'}
    _toPy = {'CloudDetails': 'clouddetails', 'user-access': 'user_access'}
    def __init__(self, clouddetails=None, user_access=None, **unknown_fields):
        '''
        clouddetails : CloudDetails
        user_access : str
        '''
        clouddetails_ = CloudDetails.from_json(clouddetails) if clouddetails else None
        user_access_ = user_access

        # Validate arguments against known Juju API types.
        if clouddetails_ is not None and not isinstance(clouddetails_, (dict, CloudDetails)):
            raise Exception("Expected clouddetails_ to be a CloudDetails, received: {}".format(type(clouddetails_)))

        if user_access_ is not None and not isinstance(user_access_, (bytes, str)):
            raise Exception("Expected user_access_ to be a str, received: {}".format(type(user_access_)))

        self.clouddetails = clouddetails_
        self.user_access = user_access_
        self.unknown_fields = unknown_fields



class ListCloudInfoResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ListCloudInfo
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ListCloudInfo.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ListCloudInfo)):
            raise Exception("Expected result_ to be a ListCloudInfo, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ListCloudInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ListCloudInfoResult]
        '''
        results_ = [ListCloudInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ListCloudsRequest(Type):
    _toSchema = {'all_': 'all', 'user_tag': 'user-tag'}
    _toPy = {'all': 'all_', 'user-tag': 'user_tag'}
    def __init__(self, all_=None, user_tag=None, **unknown_fields):
        '''
        all_ : bool
        user_tag : str
        '''
        all__ = all_
        user_tag_ = user_tag

        # Validate arguments against known Juju API types.
        if all__ is not None and not isinstance(all__, bool):
            raise Exception("Expected all__ to be a bool, received: {}".format(type(all__)))

        if user_tag_ is not None and not isinstance(user_tag_, (bytes, str)):
            raise Exception("Expected user_tag_ to be a str, received: {}".format(type(user_tag_)))

        self.all_ = all__
        self.user_tag = user_tag_
        self.unknown_fields = unknown_fields



class ListFirewallRulesResults(Type):
    _toSchema = {'rules': 'Rules'}
    _toPy = {'Rules': 'rules'}
    def __init__(self, rules=None, **unknown_fields):
        '''
        rules : typing.Sequence[~FirewallRule]
        '''
        rules_ = [FirewallRule.from_json(o) for o in rules or []]

        # Validate arguments against known Juju API types.
        if rules_ is not None and not isinstance(rules_, (bytes, str, list)):
            raise Exception("Expected rules_ to be a Sequence, received: {}".format(type(rules_)))

        self.rules = rules_
        self.unknown_fields = unknown_fields



class ListImageResult(Type):
    _toSchema = {'result': 'result'}
    _toPy = {'result': 'result'}
    def __init__(self, result=None, **unknown_fields):
        '''
        result : typing.Sequence[~ImageMetadata]
        '''
        result_ = [ImageMetadata.from_json(o) for o in result or []]

        # Validate arguments against known Juju API types.
        if result_ is not None and not isinstance(result_, (bytes, str, list)):
            raise Exception("Expected result_ to be a Sequence, received: {}".format(type(result_)))

        self.result = result_
        self.unknown_fields = unknown_fields



class ListResourcesArgs(Type):
    _toSchema = {'entities': 'entities'}
    _toPy = {'entities': 'entities'}
    def __init__(self, entities=None, **unknown_fields):
        '''
        entities : typing.Sequence[~Entity]
        '''
        entities_ = [Entity.from_json(o) for o in entities or []]

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        self.entities = entities_
        self.unknown_fields = unknown_fields



class ListSSHKeys(Type):
    _toSchema = {'entities': 'entities', 'mode': 'mode'}
    _toPy = {'entities': 'entities', 'mode': 'mode'}
    def __init__(self, entities=None, mode=None, **unknown_fields):
        '''
        entities : Entities
        mode : bool
        '''
        entities_ = Entities.from_json(entities) if entities else None
        mode_ = mode

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (dict, Entities)):
            raise Exception("Expected entities_ to be a Entities, received: {}".format(type(entities_)))

        if mode_ is not None and not isinstance(mode_, bool):
            raise Exception("Expected mode_ to be a bool, received: {}".format(type(mode_)))

        self.entities = entities_
        self.mode = mode_
        self.unknown_fields = unknown_fields



class ListSpacesResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~Space]
        '''
        results_ = [Space.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ListSubnetsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~Subnet]
        '''
        results_ = [Subnet.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ListUnitResourcesArgs(Type):
    _toSchema = {'resource_names': 'resource-names'}
    _toPy = {'resource-names': 'resource_names'}
    def __init__(self, resource_names=None, **unknown_fields):
        '''
        resource_names : typing.Sequence[str]
        '''
        resource_names_ = resource_names

        # Validate arguments against known Juju API types.
        if resource_names_ is not None and not isinstance(resource_names_, (bytes, str, list)):
            raise Exception("Expected resource_names_ to be a Sequence, received: {}".format(type(resource_names_)))

        self.resource_names = resource_names_
        self.unknown_fields = unknown_fields



class LogForwardingGetLastSentParams(Type):
    _toSchema = {'ids': 'ids'}
    _toPy = {'ids': 'ids'}
    def __init__(self, ids=None, **unknown_fields):
        '''
        ids : typing.Sequence[~LogForwardingID]
        '''
        ids_ = [LogForwardingID.from_json(o) for o in ids or []]

        # Validate arguments against known Juju API types.
        if ids_ is not None and not isinstance(ids_, (bytes, str, list)):
            raise Exception("Expected ids_ to be a Sequence, received: {}".format(type(ids_)))

        self.ids = ids_
        self.unknown_fields = unknown_fields



class LogForwardingGetLastSentResult(Type):
    _toSchema = {'err': 'err', 'record_id': 'record-id', 'record_timestamp': 'record-timestamp'}
    _toPy = {'err': 'err', 'record-id': 'record_id', 'record-timestamp': 'record_timestamp'}
    def __init__(self, err=None, record_id=None, record_timestamp=None, **unknown_fields):
        '''
        err : Error
        record_id : int
        record_timestamp : int
        '''
        err_ = Error.from_json(err) if err else None
        record_id_ = record_id
        record_timestamp_ = record_timestamp

        # Validate arguments against known Juju API types.
        if err_ is not None and not isinstance(err_, (dict, Error)):
            raise Exception("Expected err_ to be a Error, received: {}".format(type(err_)))

        if record_id_ is not None and not isinstance(record_id_, int):
            raise Exception("Expected record_id_ to be a int, received: {}".format(type(record_id_)))

        if record_timestamp_ is not None and not isinstance(record_timestamp_, int):
            raise Exception("Expected record_timestamp_ to be a int, received: {}".format(type(record_timestamp_)))

        self.err = err_
        self.record_id = record_id_
        self.record_timestamp = record_timestamp_
        self.unknown_fields = unknown_fields



class LogForwardingGetLastSentResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~LogForwardingGetLastSentResult]
        '''
        results_ = [LogForwardingGetLastSentResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class LogForwardingID(Type):
    _toSchema = {'model': 'model', 'sink': 'sink'}
    _toPy = {'model': 'model', 'sink': 'sink'}
    def __init__(self, model=None, sink=None, **unknown_fields):
        '''
        model : str
        sink : str
        '''
        model_ = model
        sink_ = sink

        # Validate arguments against known Juju API types.
        if model_ is not None and not isinstance(model_, (bytes, str)):
            raise Exception("Expected model_ to be a str, received: {}".format(type(model_)))

        if sink_ is not None and not isinstance(sink_, (bytes, str)):
            raise Exception("Expected sink_ to be a str, received: {}".format(type(sink_)))

        self.model = model_
        self.sink = sink_
        self.unknown_fields = unknown_fields



class LogForwardingSetLastSentParam(Type):
    _toSchema = {'logforwardingid': 'LogForwardingID', 'model': 'model', 'record_id': 'record-id', 'record_timestamp': 'record-timestamp', 'sink': 'sink'}
    _toPy = {'LogForwardingID': 'logforwardingid', 'model': 'model', 'record-id': 'record_id', 'record-timestamp': 'record_timestamp', 'sink': 'sink'}
    def __init__(self, logforwardingid=None, model=None, record_id=None, record_timestamp=None, sink=None, **unknown_fields):
        '''
        logforwardingid : LogForwardingID
        model : str
        record_id : int
        record_timestamp : int
        sink : str
        '''
        logforwardingid_ = LogForwardingID.from_json(logforwardingid) if logforwardingid else None
        model_ = model
        record_id_ = record_id
        record_timestamp_ = record_timestamp
        sink_ = sink

        # Validate arguments against known Juju API types.
        if logforwardingid_ is not None and not isinstance(logforwardingid_, (dict, LogForwardingID)):
            raise Exception("Expected logforwardingid_ to be a LogForwardingID, received: {}".format(type(logforwardingid_)))

        if model_ is not None and not isinstance(model_, (bytes, str)):
            raise Exception("Expected model_ to be a str, received: {}".format(type(model_)))

        if record_id_ is not None and not isinstance(record_id_, int):
            raise Exception("Expected record_id_ to be a int, received: {}".format(type(record_id_)))

        if record_timestamp_ is not None and not isinstance(record_timestamp_, int):
            raise Exception("Expected record_timestamp_ to be a int, received: {}".format(type(record_timestamp_)))

        if sink_ is not None and not isinstance(sink_, (bytes, str)):
            raise Exception("Expected sink_ to be a str, received: {}".format(type(sink_)))

        self.logforwardingid = logforwardingid_
        self.model = model_
        self.record_id = record_id_
        self.record_timestamp = record_timestamp_
        self.sink = sink_
        self.unknown_fields = unknown_fields



class LogForwardingSetLastSentParams(Type):
    _toSchema = {'params': 'params'}
    _toPy = {'params': 'params'}
    def __init__(self, params=None, **unknown_fields):
        '''
        params : typing.Sequence[~LogForwardingSetLastSentParam]
        '''
        params_ = [LogForwardingSetLastSentParam.from_json(o) for o in params or []]

        # Validate arguments against known Juju API types.
        if params_ is not None and not isinstance(params_, (bytes, str, list)):
            raise Exception("Expected params_ to be a Sequence, received: {}".format(type(params_)))

        self.params = params_
        self.unknown_fields = unknown_fields



class LoginRequest(Type):
    _toSchema = {'auth_tag': 'auth-tag', 'bakery_version': 'bakery-version', 'cli_args': 'cli-args', 'credentials': 'credentials', 'macaroons': 'macaroons', 'nonce': 'nonce', 'user_data': 'user-data'}
    _toPy = {'auth-tag': 'auth_tag', 'bakery-version': 'bakery_version', 'cli-args': 'cli_args', 'credentials': 'credentials', 'macaroons': 'macaroons', 'nonce': 'nonce', 'user-data': 'user_data'}
    def __init__(self, auth_tag=None, bakery_version=None, cli_args=None, credentials=None, macaroons=None, nonce=None, user_data=None, **unknown_fields):
        '''
        auth_tag : str
        bakery_version : int
        cli_args : str
        credentials : str
        macaroons : typing.Sequence[~Macaroon]
        nonce : str
        user_data : str
        '''
        auth_tag_ = auth_tag
        bakery_version_ = bakery_version
        cli_args_ = cli_args
        credentials_ = credentials
        macaroons_ = [Macaroon.from_json(o) for o in macaroons or []]
        nonce_ = nonce
        user_data_ = user_data

        # Validate arguments against known Juju API types.
        if auth_tag_ is not None and not isinstance(auth_tag_, (bytes, str)):
            raise Exception("Expected auth_tag_ to be a str, received: {}".format(type(auth_tag_)))

        if bakery_version_ is not None and not isinstance(bakery_version_, int):
            raise Exception("Expected bakery_version_ to be a int, received: {}".format(type(bakery_version_)))

        if cli_args_ is not None and not isinstance(cli_args_, (bytes, str)):
            raise Exception("Expected cli_args_ to be a str, received: {}".format(type(cli_args_)))

        if credentials_ is not None and not isinstance(credentials_, (bytes, str)):
            raise Exception("Expected credentials_ to be a str, received: {}".format(type(credentials_)))

        if macaroons_ is not None and not isinstance(macaroons_, (bytes, str, list)):
            raise Exception("Expected macaroons_ to be a Sequence, received: {}".format(type(macaroons_)))

        if nonce_ is not None and not isinstance(nonce_, (bytes, str)):
            raise Exception("Expected nonce_ to be a str, received: {}".format(type(nonce_)))

        if user_data_ is not None and not isinstance(user_data_, (bytes, str)):
            raise Exception("Expected user_data_ to be a str, received: {}".format(type(user_data_)))

        self.auth_tag = auth_tag_
        self.bakery_version = bakery_version_
        self.cli_args = cli_args_
        self.credentials = credentials_
        self.macaroons = macaroons_
        self.nonce = nonce_
        self.user_data = user_data_
        self.unknown_fields = unknown_fields



class LoginResult(Type):
    _toSchema = {'bakery_discharge_required': 'bakery-discharge-required', 'controller_tag': 'controller-tag', 'discharge_required': 'discharge-required', 'discharge_required_error': 'discharge-required-error', 'facades': 'facades', 'model_tag': 'model-tag', 'public_dns_name': 'public-dns-name', 'server_version': 'server-version', 'servers': 'servers', 'user_info': 'user-info'}
    _toPy = {'bakery-discharge-required': 'bakery_discharge_required', 'controller-tag': 'controller_tag', 'discharge-required': 'discharge_required', 'discharge-required-error': 'discharge_required_error', 'facades': 'facades', 'model-tag': 'model_tag', 'public-dns-name': 'public_dns_name', 'server-version': 'server_version', 'servers': 'servers', 'user-info': 'user_info'}
    def __init__(self, bakery_discharge_required=None, controller_tag=None, discharge_required=None, discharge_required_error=None, facades=None, model_tag=None, public_dns_name=None, server_version=None, servers=None, user_info=None, **unknown_fields):
        '''
        bakery_discharge_required : Macaroon
        controller_tag : str
        discharge_required : Macaroon
        discharge_required_error : str
        facades : typing.Sequence[~FacadeVersions]
        model_tag : str
        public_dns_name : str
        server_version : str
        servers : typing.Sequence[~HostPort]
        user_info : AuthUserInfo
        '''
        bakery_discharge_required_ = Macaroon.from_json(bakery_discharge_required) if bakery_discharge_required else None
        controller_tag_ = controller_tag
        discharge_required_ = Macaroon.from_json(discharge_required) if discharge_required else None
        discharge_required_error_ = discharge_required_error
        facades_ = [FacadeVersions.from_json(o) for o in facades or []]
        model_tag_ = model_tag
        public_dns_name_ = public_dns_name
        server_version_ = server_version
        servers_ = [HostPort.from_json(o) for o in servers or []]
        user_info_ = AuthUserInfo.from_json(user_info) if user_info else None

        # Validate arguments against known Juju API types.
        if bakery_discharge_required_ is not None and not isinstance(bakery_discharge_required_, (dict, Macaroon)):
            raise Exception("Expected bakery_discharge_required_ to be a Macaroon, received: {}".format(type(bakery_discharge_required_)))

        if controller_tag_ is not None and not isinstance(controller_tag_, (bytes, str)):
            raise Exception("Expected controller_tag_ to be a str, received: {}".format(type(controller_tag_)))

        if discharge_required_ is not None and not isinstance(discharge_required_, (dict, Macaroon)):
            raise Exception("Expected discharge_required_ to be a Macaroon, received: {}".format(type(discharge_required_)))

        if discharge_required_error_ is not None and not isinstance(discharge_required_error_, (bytes, str)):
            raise Exception("Expected discharge_required_error_ to be a str, received: {}".format(type(discharge_required_error_)))

        if facades_ is not None and not isinstance(facades_, (bytes, str, list)):
            raise Exception("Expected facades_ to be a Sequence, received: {}".format(type(facades_)))

        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        if public_dns_name_ is not None and not isinstance(public_dns_name_, (bytes, str)):
            raise Exception("Expected public_dns_name_ to be a str, received: {}".format(type(public_dns_name_)))

        if server_version_ is not None and not isinstance(server_version_, (bytes, str)):
            raise Exception("Expected server_version_ to be a str, received: {}".format(type(server_version_)))

        if servers_ is not None and not isinstance(servers_, (bytes, str, list)):
            raise Exception("Expected servers_ to be a Sequence, received: {}".format(type(servers_)))

        if user_info_ is not None and not isinstance(user_info_, (dict, AuthUserInfo)):
            raise Exception("Expected user_info_ to be a AuthUserInfo, received: {}".format(type(user_info_)))

        self.bakery_discharge_required = bakery_discharge_required_
        self.controller_tag = controller_tag_
        self.discharge_required = discharge_required_
        self.discharge_required_error = discharge_required_error_
        self.facades = facades_
        self.model_tag = model_tag_
        self.public_dns_name = public_dns_name_
        self.server_version = server_version_
        self.servers = servers_
        self.user_info = user_info_
        self.unknown_fields = unknown_fields



class LookUpArg(Type):
    _toSchema = {'id_': 'id', 'name': 'name'}
    _toPy = {'id': 'id_', 'name': 'name'}
    def __init__(self, id_=None, name=None, **unknown_fields):
        '''
        id_ : str
        name : str
        '''
        id__ = id_
        name_ = name

        # Validate arguments against known Juju API types.
        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        self.id_ = id__
        self.name = name_
        self.unknown_fields = unknown_fields



class LookUpArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~LookUpArg]
        '''
        args_ = [LookUpArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class LookUpPayloadArg(Type):
    _toSchema = {'id_': 'id', 'name': 'name'}
    _toPy = {'id': 'id_', 'name': 'name'}
    def __init__(self, id_=None, name=None, **unknown_fields):
        '''
        id_ : str
        name : str
        '''
        id__ = id_
        name_ = name

        # Validate arguments against known Juju API types.
        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        self.id_ = id__
        self.name = name_
        self.unknown_fields = unknown_fields



class LookUpPayloadArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~LookUpPayloadArg]
        '''
        args_ = [LookUpPayloadArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class Macaroon(Type):
    _toSchema = {}
    _toPy = {}
    def __init__(self, **unknown_fields):
        '''

        '''
        self.unknown_fields = unknown_fields



class MacaroonResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : Macaroon
        '''
        error_ = Error.from_json(error) if error else None
        result_ = Macaroon.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, Macaroon)):
            raise Exception("Expected result_ to be a Macaroon, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class MacaroonResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~MacaroonResult]
        '''
        results_ = [MacaroonResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class MachineAddresses(Type):
    _toSchema = {'addresses': 'addresses', 'tag': 'tag'}
    _toPy = {'addresses': 'addresses', 'tag': 'tag'}
    def __init__(self, addresses=None, tag=None, **unknown_fields):
        '''
        addresses : typing.Sequence[~Address]
        tag : str
        '''
        addresses_ = [Address.from_json(o) for o in addresses or []]
        tag_ = tag

        # Validate arguments against known Juju API types.
        if addresses_ is not None and not isinstance(addresses_, (bytes, str, list)):
            raise Exception("Expected addresses_ to be a Sequence, received: {}".format(type(addresses_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.addresses = addresses_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class MachineAddressesResult(Type):
    _toSchema = {'addresses': 'addresses', 'error': 'error'}
    _toPy = {'addresses': 'addresses', 'error': 'error'}
    def __init__(self, addresses=None, error=None, **unknown_fields):
        '''
        addresses : typing.Sequence[~Address]
        error : Error
        '''
        addresses_ = [Address.from_json(o) for o in addresses or []]
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if addresses_ is not None and not isinstance(addresses_, (bytes, str, list)):
            raise Exception("Expected addresses_ to be a Sequence, received: {}".format(type(addresses_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.addresses = addresses_
        self.error = error_
        self.unknown_fields = unknown_fields



class MachineAddressesResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~MachineAddressesResult]
        '''
        results_ = [MachineAddressesResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class MachineBlockDevices(Type):
    _toSchema = {'block_devices': 'block-devices', 'machine': 'machine'}
    _toPy = {'block-devices': 'block_devices', 'machine': 'machine'}
    def __init__(self, block_devices=None, machine=None, **unknown_fields):
        '''
        block_devices : typing.Sequence[~BlockDevice]
        machine : str
        '''
        block_devices_ = [BlockDevice.from_json(o) for o in block_devices or []]
        machine_ = machine

        # Validate arguments against known Juju API types.
        if block_devices_ is not None and not isinstance(block_devices_, (bytes, str, list)):
            raise Exception("Expected block_devices_ to be a Sequence, received: {}".format(type(block_devices_)))

        if machine_ is not None and not isinstance(machine_, (bytes, str)):
            raise Exception("Expected machine_ to be a str, received: {}".format(type(machine_)))

        self.block_devices = block_devices_
        self.machine = machine_
        self.unknown_fields = unknown_fields



class MachineContainerResult(Type):
    _toSchema = {'container_types': 'container-types', 'determined': 'determined', 'error': 'error'}
    _toPy = {'container-types': 'container_types', 'determined': 'determined', 'error': 'error'}
    def __init__(self, container_types=None, determined=None, error=None, **unknown_fields):
        '''
        container_types : typing.Sequence[str]
        determined : bool
        error : Error
        '''
        container_types_ = container_types
        determined_ = determined
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if container_types_ is not None and not isinstance(container_types_, (bytes, str, list)):
            raise Exception("Expected container_types_ to be a Sequence, received: {}".format(type(container_types_)))

        if determined_ is not None and not isinstance(determined_, bool):
            raise Exception("Expected determined_ to be a bool, received: {}".format(type(determined_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.container_types = container_types_
        self.determined = determined_
        self.error = error_
        self.unknown_fields = unknown_fields



class MachineContainerResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~MachineContainerResult]
        '''
        results_ = [MachineContainerResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class MachineContainers(Type):
    _toSchema = {'container_types': 'container-types', 'machine_tag': 'machine-tag'}
    _toPy = {'container-types': 'container_types', 'machine-tag': 'machine_tag'}
    def __init__(self, container_types=None, machine_tag=None, **unknown_fields):
        '''
        container_types : typing.Sequence[str]
        machine_tag : str
        '''
        container_types_ = container_types
        machine_tag_ = machine_tag

        # Validate arguments against known Juju API types.
        if container_types_ is not None and not isinstance(container_types_, (bytes, str, list)):
            raise Exception("Expected container_types_ to be a Sequence, received: {}".format(type(container_types_)))

        if machine_tag_ is not None and not isinstance(machine_tag_, (bytes, str)):
            raise Exception("Expected machine_tag_ to be a str, received: {}".format(type(machine_tag_)))

        self.container_types = container_types_
        self.machine_tag = machine_tag_
        self.unknown_fields = unknown_fields



class MachineContainersParams(Type):
    _toSchema = {'params': 'params'}
    _toPy = {'params': 'params'}
    def __init__(self, params=None, **unknown_fields):
        '''
        params : typing.Sequence[~MachineContainers]
        '''
        params_ = [MachineContainers.from_json(o) for o in params or []]

        # Validate arguments against known Juju API types.
        if params_ is not None and not isinstance(params_, (bytes, str, list)):
            raise Exception("Expected params_ to be a Sequence, received: {}".format(type(params_)))

        self.params = params_
        self.unknown_fields = unknown_fields



class MachineHardware(Type):
    _toSchema = {'arch': 'arch', 'availability_zone': 'availability-zone', 'cores': 'cores', 'cpu_power': 'cpu-power', 'mem': 'mem', 'root_disk': 'root-disk', 'tags': 'tags'}
    _toPy = {'arch': 'arch', 'availability-zone': 'availability_zone', 'cores': 'cores', 'cpu-power': 'cpu_power', 'mem': 'mem', 'root-disk': 'root_disk', 'tags': 'tags'}
    def __init__(self, arch=None, availability_zone=None, cores=None, cpu_power=None, mem=None, root_disk=None, tags=None, **unknown_fields):
        '''
        arch : str
        availability_zone : str
        cores : int
        cpu_power : int
        mem : int
        root_disk : int
        tags : typing.Sequence[str]
        '''
        arch_ = arch
        availability_zone_ = availability_zone
        cores_ = cores
        cpu_power_ = cpu_power
        mem_ = mem
        root_disk_ = root_disk
        tags_ = tags

        # Validate arguments against known Juju API types.
        if arch_ is not None and not isinstance(arch_, (bytes, str)):
            raise Exception("Expected arch_ to be a str, received: {}".format(type(arch_)))

        if availability_zone_ is not None and not isinstance(availability_zone_, (bytes, str)):
            raise Exception("Expected availability_zone_ to be a str, received: {}".format(type(availability_zone_)))

        if cores_ is not None and not isinstance(cores_, int):
            raise Exception("Expected cores_ to be a int, received: {}".format(type(cores_)))

        if cpu_power_ is not None and not isinstance(cpu_power_, int):
            raise Exception("Expected cpu_power_ to be a int, received: {}".format(type(cpu_power_)))

        if mem_ is not None and not isinstance(mem_, int):
            raise Exception("Expected mem_ to be a int, received: {}".format(type(mem_)))

        if root_disk_ is not None and not isinstance(root_disk_, int):
            raise Exception("Expected root_disk_ to be a int, received: {}".format(type(root_disk_)))

        if tags_ is not None and not isinstance(tags_, (bytes, str, list)):
            raise Exception("Expected tags_ to be a Sequence, received: {}".format(type(tags_)))

        self.arch = arch_
        self.availability_zone = availability_zone_
        self.cores = cores_
        self.cpu_power = cpu_power_
        self.mem = mem_
        self.root_disk = root_disk_
        self.tags = tags_
        self.unknown_fields = unknown_fields



class MachineNetworkConfigResult(Type):
    _toSchema = {'error': 'error', 'info': 'info'}
    _toPy = {'error': 'error', 'info': 'info'}
    def __init__(self, error=None, info=None, **unknown_fields):
        '''
        error : Error
        info : typing.Sequence[~NetworkConfig]
        '''
        error_ = Error.from_json(error) if error else None
        info_ = [NetworkConfig.from_json(o) for o in info or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if info_ is not None and not isinstance(info_, (bytes, str, list)):
            raise Exception("Expected info_ to be a Sequence, received: {}".format(type(info_)))

        self.error = error_
        self.info = info_
        self.unknown_fields = unknown_fields



class MachineNetworkConfigResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~MachineNetworkConfigResult]
        '''
        results_ = [MachineNetworkConfigResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class MachinePortRange(Type):
    _toSchema = {'port_range': 'port-range', 'relation_tag': 'relation-tag', 'unit_tag': 'unit-tag'}
    _toPy = {'port-range': 'port_range', 'relation-tag': 'relation_tag', 'unit-tag': 'unit_tag'}
    def __init__(self, port_range=None, relation_tag=None, unit_tag=None, **unknown_fields):
        '''
        port_range : PortRange
        relation_tag : str
        unit_tag : str
        '''
        port_range_ = PortRange.from_json(port_range) if port_range else None
        relation_tag_ = relation_tag
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if port_range_ is not None and not isinstance(port_range_, (dict, PortRange)):
            raise Exception("Expected port_range_ to be a PortRange, received: {}".format(type(port_range_)))

        if relation_tag_ is not None and not isinstance(relation_tag_, (bytes, str)):
            raise Exception("Expected relation_tag_ to be a str, received: {}".format(type(relation_tag_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.port_range = port_range_
        self.relation_tag = relation_tag_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class MachinePorts(Type):
    _toSchema = {'machine_tag': 'machine-tag', 'subnet_tag': 'subnet-tag'}
    _toPy = {'machine-tag': 'machine_tag', 'subnet-tag': 'subnet_tag'}
    def __init__(self, machine_tag=None, subnet_tag=None, **unknown_fields):
        '''
        machine_tag : str
        subnet_tag : str
        '''
        machine_tag_ = machine_tag
        subnet_tag_ = subnet_tag

        # Validate arguments against known Juju API types.
        if machine_tag_ is not None and not isinstance(machine_tag_, (bytes, str)):
            raise Exception("Expected machine_tag_ to be a str, received: {}".format(type(machine_tag_)))

        if subnet_tag_ is not None and not isinstance(subnet_tag_, (bytes, str)):
            raise Exception("Expected subnet_tag_ to be a str, received: {}".format(type(subnet_tag_)))

        self.machine_tag = machine_tag_
        self.subnet_tag = subnet_tag_
        self.unknown_fields = unknown_fields



class MachinePortsParams(Type):
    _toSchema = {'params': 'params'}
    _toPy = {'params': 'params'}
    def __init__(self, params=None, **unknown_fields):
        '''
        params : typing.Sequence[~MachinePorts]
        '''
        params_ = [MachinePorts.from_json(o) for o in params or []]

        # Validate arguments against known Juju API types.
        if params_ is not None and not isinstance(params_, (bytes, str, list)):
            raise Exception("Expected params_ to be a Sequence, received: {}".format(type(params_)))

        self.params = params_
        self.unknown_fields = unknown_fields



class MachinePortsResult(Type):
    _toSchema = {'error': 'error', 'ports': 'ports'}
    _toPy = {'error': 'error', 'ports': 'ports'}
    def __init__(self, error=None, ports=None, **unknown_fields):
        '''
        error : Error
        ports : typing.Sequence[~MachinePortRange]
        '''
        error_ = Error.from_json(error) if error else None
        ports_ = [MachinePortRange.from_json(o) for o in ports or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if ports_ is not None and not isinstance(ports_, (bytes, str, list)):
            raise Exception("Expected ports_ to be a Sequence, received: {}".format(type(ports_)))

        self.error = error_
        self.ports = ports_
        self.unknown_fields = unknown_fields



class MachinePortsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~MachinePortsResult]
        '''
        results_ = [MachinePortsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class MachineStatus(Type):
    _toSchema = {'agent_status': 'agent-status', 'constraints': 'constraints', 'containers': 'containers', 'display_name': 'display-name', 'dns_name': 'dns-name', 'hardware': 'hardware', 'has_vote': 'has-vote', 'id_': 'id', 'instance_id': 'instance-id', 'instance_status': 'instance-status', 'ip_addresses': 'ip-addresses', 'jobs': 'jobs', 'lxd_profiles': 'lxd-profiles', 'modification_status': 'modification-status', 'network_interfaces': 'network-interfaces', 'primary_controller_machine': 'primary-controller-machine', 'series': 'series', 'wants_vote': 'wants-vote'}
    _toPy = {'agent-status': 'agent_status', 'constraints': 'constraints', 'containers': 'containers', 'display-name': 'display_name', 'dns-name': 'dns_name', 'hardware': 'hardware', 'has-vote': 'has_vote', 'id': 'id_', 'instance-id': 'instance_id', 'instance-status': 'instance_status', 'ip-addresses': 'ip_addresses', 'jobs': 'jobs', 'lxd-profiles': 'lxd_profiles', 'modification-status': 'modification_status', 'network-interfaces': 'network_interfaces', 'primary-controller-machine': 'primary_controller_machine', 'series': 'series', 'wants-vote': 'wants_vote'}
    def __init__(self, agent_status=None, constraints=None, containers=None, display_name=None, dns_name=None, hardware=None, has_vote=None, id_=None, instance_id=None, instance_status=None, ip_addresses=None, jobs=None, lxd_profiles=None, modification_status=None, network_interfaces=None, primary_controller_machine=None, series=None, wants_vote=None, **unknown_fields):
        '''
        agent_status : DetailedStatus
        constraints : str
        containers : typing.Mapping[str, ~MachineStatus]
        display_name : str
        dns_name : str
        hardware : str
        has_vote : bool
        id_ : str
        instance_id : str
        instance_status : DetailedStatus
        ip_addresses : typing.Sequence[str]
        jobs : typing.Sequence[str]
        lxd_profiles : typing.Mapping[str, ~LXDProfile]
        modification_status : DetailedStatus
        network_interfaces : typing.Mapping[str, ~NetworkInterface]
        primary_controller_machine : bool
        series : str
        wants_vote : bool
        '''
        agent_status_ = DetailedStatus.from_json(agent_status) if agent_status else None
        constraints_ = constraints
        containers_ = {k: MachineStatus.from_json(v) for k, v in (containers or dict()).items()}
        display_name_ = display_name
        dns_name_ = dns_name
        hardware_ = hardware
        has_vote_ = has_vote
        id__ = id_
        instance_id_ = instance_id
        instance_status_ = DetailedStatus.from_json(instance_status) if instance_status else None
        ip_addresses_ = ip_addresses
        jobs_ = jobs
        lxd_profiles_ = {k: LXDProfile.from_json(v) for k, v in (lxd_profiles or dict()).items()}
        modification_status_ = DetailedStatus.from_json(modification_status) if modification_status else None
        network_interfaces_ = {k: NetworkInterface.from_json(v) for k, v in (network_interfaces or dict()).items()}
        primary_controller_machine_ = primary_controller_machine
        series_ = series
        wants_vote_ = wants_vote

        # Validate arguments against known Juju API types.
        if agent_status_ is not None and not isinstance(agent_status_, (dict, DetailedStatus)):
            raise Exception("Expected agent_status_ to be a DetailedStatus, received: {}".format(type(agent_status_)))

        if constraints_ is not None and not isinstance(constraints_, (bytes, str)):
            raise Exception("Expected constraints_ to be a str, received: {}".format(type(constraints_)))

        if containers_ is not None and not isinstance(containers_, dict):
            raise Exception("Expected containers_ to be a Mapping, received: {}".format(type(containers_)))

        if display_name_ is not None and not isinstance(display_name_, (bytes, str)):
            raise Exception("Expected display_name_ to be a str, received: {}".format(type(display_name_)))

        if dns_name_ is not None and not isinstance(dns_name_, (bytes, str)):
            raise Exception("Expected dns_name_ to be a str, received: {}".format(type(dns_name_)))

        if hardware_ is not None and not isinstance(hardware_, (bytes, str)):
            raise Exception("Expected hardware_ to be a str, received: {}".format(type(hardware_)))

        if has_vote_ is not None and not isinstance(has_vote_, bool):
            raise Exception("Expected has_vote_ to be a bool, received: {}".format(type(has_vote_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if instance_id_ is not None and not isinstance(instance_id_, (bytes, str)):
            raise Exception("Expected instance_id_ to be a str, received: {}".format(type(instance_id_)))

        if instance_status_ is not None and not isinstance(instance_status_, (dict, DetailedStatus)):
            raise Exception("Expected instance_status_ to be a DetailedStatus, received: {}".format(type(instance_status_)))

        if ip_addresses_ is not None and not isinstance(ip_addresses_, (bytes, str, list)):
            raise Exception("Expected ip_addresses_ to be a Sequence, received: {}".format(type(ip_addresses_)))

        if jobs_ is not None and not isinstance(jobs_, (bytes, str, list)):
            raise Exception("Expected jobs_ to be a Sequence, received: {}".format(type(jobs_)))

        if lxd_profiles_ is not None and not isinstance(lxd_profiles_, dict):
            raise Exception("Expected lxd_profiles_ to be a Mapping, received: {}".format(type(lxd_profiles_)))

        if modification_status_ is not None and not isinstance(modification_status_, (dict, DetailedStatus)):
            raise Exception("Expected modification_status_ to be a DetailedStatus, received: {}".format(type(modification_status_)))

        if network_interfaces_ is not None and not isinstance(network_interfaces_, dict):
            raise Exception("Expected network_interfaces_ to be a Mapping, received: {}".format(type(network_interfaces_)))

        if primary_controller_machine_ is not None and not isinstance(primary_controller_machine_, bool):
            raise Exception("Expected primary_controller_machine_ to be a bool, received: {}".format(type(primary_controller_machine_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if wants_vote_ is not None and not isinstance(wants_vote_, bool):
            raise Exception("Expected wants_vote_ to be a bool, received: {}".format(type(wants_vote_)))

        self.agent_status = agent_status_
        self.constraints = constraints_
        self.containers = containers_
        self.display_name = display_name_
        self.dns_name = dns_name_
        self.hardware = hardware_
        self.has_vote = has_vote_
        self.id_ = id__
        self.instance_id = instance_id_
        self.instance_status = instance_status_
        self.ip_addresses = ip_addresses_
        self.jobs = jobs_
        self.lxd_profiles = lxd_profiles_
        self.modification_status = modification_status_
        self.network_interfaces = network_interfaces_
        self.primary_controller_machine = primary_controller_machine_
        self.series = series_
        self.wants_vote = wants_vote_
        self.unknown_fields = unknown_fields



class MachineStorageId(Type):
    _toSchema = {'attachment_tag': 'attachment-tag', 'machine_tag': 'machine-tag'}
    _toPy = {'attachment-tag': 'attachment_tag', 'machine-tag': 'machine_tag'}
    def __init__(self, attachment_tag=None, machine_tag=None, **unknown_fields):
        '''
        attachment_tag : str
        machine_tag : str
        '''
        attachment_tag_ = attachment_tag
        machine_tag_ = machine_tag

        # Validate arguments against known Juju API types.
        if attachment_tag_ is not None and not isinstance(attachment_tag_, (bytes, str)):
            raise Exception("Expected attachment_tag_ to be a str, received: {}".format(type(attachment_tag_)))

        if machine_tag_ is not None and not isinstance(machine_tag_, (bytes, str)):
            raise Exception("Expected machine_tag_ to be a str, received: {}".format(type(machine_tag_)))

        self.attachment_tag = attachment_tag_
        self.machine_tag = machine_tag_
        self.unknown_fields = unknown_fields



class MachineStorageIds(Type):
    _toSchema = {'ids': 'ids'}
    _toPy = {'ids': 'ids'}
    def __init__(self, ids=None, **unknown_fields):
        '''
        ids : typing.Sequence[~MachineStorageId]
        '''
        ids_ = [MachineStorageId.from_json(o) for o in ids or []]

        # Validate arguments against known Juju API types.
        if ids_ is not None and not isinstance(ids_, (bytes, str, list)):
            raise Exception("Expected ids_ to be a Sequence, received: {}".format(type(ids_)))

        self.ids = ids_
        self.unknown_fields = unknown_fields



class MachineStorageIdsWatchResult(Type):
    _toSchema = {'changes': 'changes', 'error': 'error', 'watcher_id': 'watcher-id'}
    _toPy = {'changes': 'changes', 'error': 'error', 'watcher-id': 'watcher_id'}
    def __init__(self, changes=None, error=None, watcher_id=None, **unknown_fields):
        '''
        changes : typing.Sequence[~MachineStorageId]
        error : Error
        watcher_id : str
        '''
        changes_ = [MachineStorageId.from_json(o) for o in changes or []]
        error_ = Error.from_json(error) if error else None
        watcher_id_ = watcher_id

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if watcher_id_ is not None and not isinstance(watcher_id_, (bytes, str)):
            raise Exception("Expected watcher_id_ to be a str, received: {}".format(type(watcher_id_)))

        self.changes = changes_
        self.error = error_
        self.watcher_id = watcher_id_
        self.unknown_fields = unknown_fields



class MachineStorageIdsWatchResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~MachineStorageIdsWatchResult]
        '''
        results_ = [MachineStorageIdsWatchResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class MapResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : typing.Mapping[str, typing.Any]
        '''
        error_ = Error.from_json(error) if error else None
        result_ = result

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, dict):
            raise Exception("Expected result_ to be a Mapping, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class MapResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~MapResult]
        '''
        results_ = [MapResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class MasterMigrationStatus(Type):
    _toSchema = {'migration_id': 'migration-id', 'phase': 'phase', 'phase_changed_time': 'phase-changed-time', 'spec': 'spec'}
    _toPy = {'migration-id': 'migration_id', 'phase': 'phase', 'phase-changed-time': 'phase_changed_time', 'spec': 'spec'}
    def __init__(self, migration_id=None, phase=None, phase_changed_time=None, spec=None, **unknown_fields):
        '''
        migration_id : str
        phase : str
        phase_changed_time : str
        spec : MigrationSpec
        '''
        migration_id_ = migration_id
        phase_ = phase
        phase_changed_time_ = phase_changed_time
        spec_ = MigrationSpec.from_json(spec) if spec else None

        # Validate arguments against known Juju API types.
        if migration_id_ is not None and not isinstance(migration_id_, (bytes, str)):
            raise Exception("Expected migration_id_ to be a str, received: {}".format(type(migration_id_)))

        if phase_ is not None and not isinstance(phase_, (bytes, str)):
            raise Exception("Expected phase_ to be a str, received: {}".format(type(phase_)))

        if phase_changed_time_ is not None and not isinstance(phase_changed_time_, (bytes, str)):
            raise Exception("Expected phase_changed_time_ to be a str, received: {}".format(type(phase_changed_time_)))

        if spec_ is not None and not isinstance(spec_, (dict, MigrationSpec)):
            raise Exception("Expected spec_ to be a MigrationSpec, received: {}".format(type(spec_)))

        self.migration_id = migration_id_
        self.phase = phase_
        self.phase_changed_time = phase_changed_time_
        self.spec = spec_
        self.unknown_fields = unknown_fields



class Member(Type):
    _toSchema = {'address': 'Address', 'arbiter': 'Arbiter', 'buildindexes': 'BuildIndexes', 'hidden': 'Hidden', 'id_': 'Id', 'priority': 'Priority', 'slavedelay': 'SlaveDelay', 'tags': 'Tags', 'votes': 'Votes'}
    _toPy = {'Address': 'address', 'Arbiter': 'arbiter', 'BuildIndexes': 'buildindexes', 'Hidden': 'hidden', 'Id': 'id_', 'Priority': 'priority', 'SlaveDelay': 'slavedelay', 'Tags': 'tags', 'Votes': 'votes'}
    def __init__(self, address=None, arbiter=None, buildindexes=None, hidden=None, id_=None, priority=None, slavedelay=None, tags=None, votes=None, **unknown_fields):
        '''
        address : str
        arbiter : bool
        buildindexes : bool
        hidden : bool
        id_ : int
        priority : float
        slavedelay : int
        tags : typing.Mapping[str, str]
        votes : int
        '''
        address_ = address
        arbiter_ = arbiter
        buildindexes_ = buildindexes
        hidden_ = hidden
        id__ = id_
        priority_ = priority
        slavedelay_ = slavedelay
        tags_ = tags
        votes_ = votes

        # Validate arguments against known Juju API types.
        if address_ is not None and not isinstance(address_, (bytes, str)):
            raise Exception("Expected address_ to be a str, received: {}".format(type(address_)))

        if arbiter_ is not None and not isinstance(arbiter_, bool):
            raise Exception("Expected arbiter_ to be a bool, received: {}".format(type(arbiter_)))

        if buildindexes_ is not None and not isinstance(buildindexes_, bool):
            raise Exception("Expected buildindexes_ to be a bool, received: {}".format(type(buildindexes_)))

        if hidden_ is not None and not isinstance(hidden_, bool):
            raise Exception("Expected hidden_ to be a bool, received: {}".format(type(hidden_)))

        if id__ is not None and not isinstance(id__, int):
            raise Exception("Expected id__ to be a int, received: {}".format(type(id__)))

        if priority_ is not None and not isinstance(priority_, float):
            raise Exception("Expected priority_ to be a float, received: {}".format(type(priority_)))

        if slavedelay_ is not None and not isinstance(slavedelay_, int):
            raise Exception("Expected slavedelay_ to be a int, received: {}".format(type(slavedelay_)))

        if tags_ is not None and not isinstance(tags_, dict):
            raise Exception("Expected tags_ to be a Mapping, received: {}".format(type(tags_)))

        if votes_ is not None and not isinstance(votes_, int):
            raise Exception("Expected votes_ to be a int, received: {}".format(type(votes_)))

        self.address = address_
        self.arbiter = arbiter_
        self.buildindexes = buildindexes_
        self.hidden = hidden_
        self.id_ = id__
        self.priority = priority_
        self.slavedelay = slavedelay_
        self.tags = tags_
        self.votes = votes_
        self.unknown_fields = unknown_fields



class MergeLeadershipSettingsBulkParams(Type):
    _toSchema = {'params': 'params'}
    _toPy = {'params': 'params'}
    def __init__(self, params=None, **unknown_fields):
        '''
        params : typing.Sequence[~MergeLeadershipSettingsParam]
        '''
        params_ = [MergeLeadershipSettingsParam.from_json(o) for o in params or []]

        # Validate arguments against known Juju API types.
        if params_ is not None and not isinstance(params_, (bytes, str, list)):
            raise Exception("Expected params_ to be a Sequence, received: {}".format(type(params_)))

        self.params = params_
        self.unknown_fields = unknown_fields



class MergeLeadershipSettingsParam(Type):
    _toSchema = {'application_tag': 'application-tag', 'settings': 'settings', 'unit_tag': 'unit-tag'}
    _toPy = {'application-tag': 'application_tag', 'settings': 'settings', 'unit-tag': 'unit_tag'}
    def __init__(self, application_tag=None, settings=None, unit_tag=None, **unknown_fields):
        '''
        application_tag : str
        settings : typing.Mapping[str, str]
        unit_tag : str
        '''
        application_tag_ = application_tag
        settings_ = settings
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if application_tag_ is not None and not isinstance(application_tag_, (bytes, str)):
            raise Exception("Expected application_tag_ to be a str, received: {}".format(type(application_tag_)))

        if settings_ is not None and not isinstance(settings_, dict):
            raise Exception("Expected settings_ to be a Mapping, received: {}".format(type(settings_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.application_tag = application_tag_
        self.settings = settings_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class MetadataImageIds(Type):
    _toSchema = {'image_ids': 'image-ids'}
    _toPy = {'image-ids': 'image_ids'}
    def __init__(self, image_ids=None, **unknown_fields):
        '''
        image_ids : typing.Sequence[str]
        '''
        image_ids_ = image_ids

        # Validate arguments against known Juju API types.
        if image_ids_ is not None and not isinstance(image_ids_, (bytes, str, list)):
            raise Exception("Expected image_ids_ to be a Sequence, received: {}".format(type(image_ids_)))

        self.image_ids = image_ids_
        self.unknown_fields = unknown_fields



class MetadataSaveParams(Type):
    _toSchema = {'metadata': 'metadata'}
    _toPy = {'metadata': 'metadata'}
    def __init__(self, metadata=None, **unknown_fields):
        '''
        metadata : typing.Sequence[~CloudImageMetadataList]
        '''
        metadata_ = [CloudImageMetadataList.from_json(o) for o in metadata or []]

        # Validate arguments against known Juju API types.
        if metadata_ is not None and not isinstance(metadata_, (bytes, str, list)):
            raise Exception("Expected metadata_ to be a Sequence, received: {}".format(type(metadata_)))

        self.metadata = metadata_
        self.unknown_fields = unknown_fields



class MeterStatus(Type):
    _toSchema = {'color': 'color', 'message': 'message'}
    _toPy = {'color': 'color', 'message': 'message'}
    def __init__(self, color=None, message=None, **unknown_fields):
        '''
        color : str
        message : str
        '''
        color_ = color
        message_ = message

        # Validate arguments against known Juju API types.
        if color_ is not None and not isinstance(color_, (bytes, str)):
            raise Exception("Expected color_ to be a str, received: {}".format(type(color_)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        self.color = color_
        self.message = message_
        self.unknown_fields = unknown_fields



class MeterStatusParam(Type):
    _toSchema = {'code': 'code', 'info': 'info', 'tag': 'tag'}
    _toPy = {'code': 'code', 'info': 'info', 'tag': 'tag'}
    def __init__(self, code=None, info=None, tag=None, **unknown_fields):
        '''
        code : str
        info : str
        tag : str
        '''
        code_ = code
        info_ = info
        tag_ = tag

        # Validate arguments against known Juju API types.
        if code_ is not None and not isinstance(code_, (bytes, str)):
            raise Exception("Expected code_ to be a str, received: {}".format(type(code_)))

        if info_ is not None and not isinstance(info_, (bytes, str)):
            raise Exception("Expected info_ to be a str, received: {}".format(type(info_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.code = code_
        self.info = info_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class MeterStatusParams(Type):
    _toSchema = {'statues': 'statues'}
    _toPy = {'statues': 'statues'}
    def __init__(self, statues=None, **unknown_fields):
        '''
        statues : typing.Sequence[~MeterStatusParam]
        '''
        statues_ = [MeterStatusParam.from_json(o) for o in statues or []]

        # Validate arguments against known Juju API types.
        if statues_ is not None and not isinstance(statues_, (bytes, str, list)):
            raise Exception("Expected statues_ to be a Sequence, received: {}".format(type(statues_)))

        self.statues = statues_
        self.unknown_fields = unknown_fields



class MeterStatusResult(Type):
    _toSchema = {'code': 'code', 'error': 'error', 'info': 'info'}
    _toPy = {'code': 'code', 'error': 'error', 'info': 'info'}
    def __init__(self, code=None, error=None, info=None, **unknown_fields):
        '''
        code : str
        error : Error
        info : str
        '''
        code_ = code
        error_ = Error.from_json(error) if error else None
        info_ = info

        # Validate arguments against known Juju API types.
        if code_ is not None and not isinstance(code_, (bytes, str)):
            raise Exception("Expected code_ to be a str, received: {}".format(type(code_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if info_ is not None and not isinstance(info_, (bytes, str)):
            raise Exception("Expected info_ to be a str, received: {}".format(type(info_)))

        self.code = code_
        self.error = error_
        self.info = info_
        self.unknown_fields = unknown_fields



class MeterStatusResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~MeterStatusResult]
        '''
        results_ = [MeterStatusResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class Metric(Type):
    _toSchema = {'key': 'key', 'labels': 'labels', 'time': 'time', 'value': 'value'}
    _toPy = {'key': 'key', 'labels': 'labels', 'time': 'time', 'value': 'value'}
    def __init__(self, key=None, labels=None, time=None, value=None, **unknown_fields):
        '''
        key : str
        labels : typing.Mapping[str, str]
        time : str
        value : str
        '''
        key_ = key
        labels_ = labels
        time_ = time
        value_ = value

        # Validate arguments against known Juju API types.
        if key_ is not None and not isinstance(key_, (bytes, str)):
            raise Exception("Expected key_ to be a str, received: {}".format(type(key_)))

        if labels_ is not None and not isinstance(labels_, dict):
            raise Exception("Expected labels_ to be a Mapping, received: {}".format(type(labels_)))

        if time_ is not None and not isinstance(time_, (bytes, str)):
            raise Exception("Expected time_ to be a str, received: {}".format(type(time_)))

        if value_ is not None and not isinstance(value_, (bytes, str)):
            raise Exception("Expected value_ to be a str, received: {}".format(type(value_)))

        self.key = key_
        self.labels = labels_
        self.time = time_
        self.value = value_
        self.unknown_fields = unknown_fields



class MetricBatch(Type):
    _toSchema = {'charm_url': 'charm-url', 'created': 'created', 'metrics': 'metrics', 'uuid': 'uuid'}
    _toPy = {'charm-url': 'charm_url', 'created': 'created', 'metrics': 'metrics', 'uuid': 'uuid'}
    def __init__(self, charm_url=None, created=None, metrics=None, uuid=None, **unknown_fields):
        '''
        charm_url : str
        created : str
        metrics : typing.Sequence[~Metric]
        uuid : str
        '''
        charm_url_ = charm_url
        created_ = created
        metrics_ = [Metric.from_json(o) for o in metrics or []]
        uuid_ = uuid

        # Validate arguments against known Juju API types.
        if charm_url_ is not None and not isinstance(charm_url_, (bytes, str)):
            raise Exception("Expected charm_url_ to be a str, received: {}".format(type(charm_url_)))

        if created_ is not None and not isinstance(created_, (bytes, str)):
            raise Exception("Expected created_ to be a str, received: {}".format(type(created_)))

        if metrics_ is not None and not isinstance(metrics_, (bytes, str, list)):
            raise Exception("Expected metrics_ to be a Sequence, received: {}".format(type(metrics_)))

        if uuid_ is not None and not isinstance(uuid_, (bytes, str)):
            raise Exception("Expected uuid_ to be a str, received: {}".format(type(uuid_)))

        self.charm_url = charm_url_
        self.created = created_
        self.metrics = metrics_
        self.uuid = uuid_
        self.unknown_fields = unknown_fields



class MetricBatchParam(Type):
    _toSchema = {'batch': 'batch', 'tag': 'tag'}
    _toPy = {'batch': 'batch', 'tag': 'tag'}
    def __init__(self, batch=None, tag=None, **unknown_fields):
        '''
        batch : MetricBatch
        tag : str
        '''
        batch_ = MetricBatch.from_json(batch) if batch else None
        tag_ = tag

        # Validate arguments against known Juju API types.
        if batch_ is not None and not isinstance(batch_, (dict, MetricBatch)):
            raise Exception("Expected batch_ to be a MetricBatch, received: {}".format(type(batch_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.batch = batch_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class MetricBatchParams(Type):
    _toSchema = {'batches': 'batches'}
    _toPy = {'batches': 'batches'}
    def __init__(self, batches=None, **unknown_fields):
        '''
        batches : typing.Sequence[~MetricBatchParam]
        '''
        batches_ = [MetricBatchParam.from_json(o) for o in batches or []]

        # Validate arguments against known Juju API types.
        if batches_ is not None and not isinstance(batches_, (bytes, str, list)):
            raise Exception("Expected batches_ to be a Sequence, received: {}".format(type(batches_)))

        self.batches = batches_
        self.unknown_fields = unknown_fields



class MetricResult(Type):
    _toSchema = {'key': 'key', 'labels': 'labels', 'time': 'time', 'unit': 'unit', 'value': 'value'}
    _toPy = {'key': 'key', 'labels': 'labels', 'time': 'time', 'unit': 'unit', 'value': 'value'}
    def __init__(self, key=None, labels=None, time=None, unit=None, value=None, **unknown_fields):
        '''
        key : str
        labels : typing.Mapping[str, str]
        time : str
        unit : str
        value : str
        '''
        key_ = key
        labels_ = labels
        time_ = time
        unit_ = unit
        value_ = value

        # Validate arguments against known Juju API types.
        if key_ is not None and not isinstance(key_, (bytes, str)):
            raise Exception("Expected key_ to be a str, received: {}".format(type(key_)))

        if labels_ is not None and not isinstance(labels_, dict):
            raise Exception("Expected labels_ to be a Mapping, received: {}".format(type(labels_)))

        if time_ is not None and not isinstance(time_, (bytes, str)):
            raise Exception("Expected time_ to be a str, received: {}".format(type(time_)))

        if unit_ is not None and not isinstance(unit_, (bytes, str)):
            raise Exception("Expected unit_ to be a str, received: {}".format(type(unit_)))

        if value_ is not None and not isinstance(value_, (bytes, str)):
            raise Exception("Expected value_ to be a str, received: {}".format(type(value_)))

        self.key = key_
        self.labels = labels_
        self.time = time_
        self.unit = unit_
        self.value = value_
        self.unknown_fields = unknown_fields



class MetricResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~EntityMetrics]
        '''
        results_ = [EntityMetrics.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class MigrationModelInfo(Type):
    _toSchema = {'agent_version': 'agent-version', 'controller_agent_version': 'controller-agent-version', 'name': 'name', 'owner_tag': 'owner-tag', 'uuid': 'uuid'}
    _toPy = {'agent-version': 'agent_version', 'controller-agent-version': 'controller_agent_version', 'name': 'name', 'owner-tag': 'owner_tag', 'uuid': 'uuid'}
    def __init__(self, agent_version=None, controller_agent_version=None, name=None, owner_tag=None, uuid=None, **unknown_fields):
        '''
        agent_version : Number
        controller_agent_version : Number
        name : str
        owner_tag : str
        uuid : str
        '''
        agent_version_ = Number.from_json(agent_version) if agent_version else None
        controller_agent_version_ = Number.from_json(controller_agent_version) if controller_agent_version else None
        name_ = name
        owner_tag_ = owner_tag
        uuid_ = uuid

        # Validate arguments against known Juju API types.
        if agent_version_ is not None and not isinstance(agent_version_, (dict, Number)):
            raise Exception("Expected agent_version_ to be a Number, received: {}".format(type(agent_version_)))

        if controller_agent_version_ is not None and not isinstance(controller_agent_version_, (dict, Number)):
            raise Exception("Expected controller_agent_version_ to be a Number, received: {}".format(type(controller_agent_version_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if owner_tag_ is not None and not isinstance(owner_tag_, (bytes, str)):
            raise Exception("Expected owner_tag_ to be a str, received: {}".format(type(owner_tag_)))

        if uuid_ is not None and not isinstance(uuid_, (bytes, str)):
            raise Exception("Expected uuid_ to be a str, received: {}".format(type(uuid_)))

        self.agent_version = agent_version_
        self.controller_agent_version = controller_agent_version_
        self.name = name_
        self.owner_tag = owner_tag_
        self.uuid = uuid_
        self.unknown_fields = unknown_fields



class MigrationSpec(Type):
    _toSchema = {'model_tag': 'model-tag', 'target_info': 'target-info'}
    _toPy = {'model-tag': 'model_tag', 'target-info': 'target_info'}
    def __init__(self, model_tag=None, target_info=None, **unknown_fields):
        '''
        model_tag : str
        target_info : MigrationTargetInfo
        '''
        model_tag_ = model_tag
        target_info_ = MigrationTargetInfo.from_json(target_info) if target_info else None

        # Validate arguments against known Juju API types.
        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        if target_info_ is not None and not isinstance(target_info_, (dict, MigrationTargetInfo)):
            raise Exception("Expected target_info_ to be a MigrationTargetInfo, received: {}".format(type(target_info_)))

        self.model_tag = model_tag_
        self.target_info = target_info_
        self.unknown_fields = unknown_fields



class MigrationStatus(Type):
    _toSchema = {'attempt': 'attempt', 'migration_id': 'migration-id', 'phase': 'phase', 'source_api_addrs': 'source-api-addrs', 'source_ca_cert': 'source-ca-cert', 'target_api_addrs': 'target-api-addrs', 'target_ca_cert': 'target-ca-cert'}
    _toPy = {'attempt': 'attempt', 'migration-id': 'migration_id', 'phase': 'phase', 'source-api-addrs': 'source_api_addrs', 'source-ca-cert': 'source_ca_cert', 'target-api-addrs': 'target_api_addrs', 'target-ca-cert': 'target_ca_cert'}
    def __init__(self, attempt=None, migration_id=None, phase=None, source_api_addrs=None, source_ca_cert=None, target_api_addrs=None, target_ca_cert=None, **unknown_fields):
        '''
        attempt : int
        migration_id : str
        phase : str
        source_api_addrs : typing.Sequence[str]
        source_ca_cert : str
        target_api_addrs : typing.Sequence[str]
        target_ca_cert : str
        '''
        attempt_ = attempt
        migration_id_ = migration_id
        phase_ = phase
        source_api_addrs_ = source_api_addrs
        source_ca_cert_ = source_ca_cert
        target_api_addrs_ = target_api_addrs
        target_ca_cert_ = target_ca_cert

        # Validate arguments against known Juju API types.
        if attempt_ is not None and not isinstance(attempt_, int):
            raise Exception("Expected attempt_ to be a int, received: {}".format(type(attempt_)))

        if migration_id_ is not None and not isinstance(migration_id_, (bytes, str)):
            raise Exception("Expected migration_id_ to be a str, received: {}".format(type(migration_id_)))

        if phase_ is not None and not isinstance(phase_, (bytes, str)):
            raise Exception("Expected phase_ to be a str, received: {}".format(type(phase_)))

        if source_api_addrs_ is not None and not isinstance(source_api_addrs_, (bytes, str, list)):
            raise Exception("Expected source_api_addrs_ to be a Sequence, received: {}".format(type(source_api_addrs_)))

        if source_ca_cert_ is not None and not isinstance(source_ca_cert_, (bytes, str)):
            raise Exception("Expected source_ca_cert_ to be a str, received: {}".format(type(source_ca_cert_)))

        if target_api_addrs_ is not None and not isinstance(target_api_addrs_, (bytes, str, list)):
            raise Exception("Expected target_api_addrs_ to be a Sequence, received: {}".format(type(target_api_addrs_)))

        if target_ca_cert_ is not None and not isinstance(target_ca_cert_, (bytes, str)):
            raise Exception("Expected target_ca_cert_ to be a str, received: {}".format(type(target_ca_cert_)))

        self.attempt = attempt_
        self.migration_id = migration_id_
        self.phase = phase_
        self.source_api_addrs = source_api_addrs_
        self.source_ca_cert = source_ca_cert_
        self.target_api_addrs = target_api_addrs_
        self.target_ca_cert = target_ca_cert_
        self.unknown_fields = unknown_fields



class MigrationTargetInfo(Type):
    _toSchema = {'addrs': 'addrs', 'auth_tag': 'auth-tag', 'ca_cert': 'ca-cert', 'controller_alias': 'controller-alias', 'controller_tag': 'controller-tag', 'macaroons': 'macaroons', 'password': 'password'}
    _toPy = {'addrs': 'addrs', 'auth-tag': 'auth_tag', 'ca-cert': 'ca_cert', 'controller-alias': 'controller_alias', 'controller-tag': 'controller_tag', 'macaroons': 'macaroons', 'password': 'password'}
    def __init__(self, addrs=None, auth_tag=None, ca_cert=None, controller_alias=None, controller_tag=None, macaroons=None, password=None, **unknown_fields):
        '''
        addrs : typing.Sequence[str]
        auth_tag : str
        ca_cert : str
        controller_alias : str
        controller_tag : str
        macaroons : str
        password : str
        '''
        addrs_ = addrs
        auth_tag_ = auth_tag
        ca_cert_ = ca_cert
        controller_alias_ = controller_alias
        controller_tag_ = controller_tag
        macaroons_ = macaroons
        password_ = password

        # Validate arguments against known Juju API types.
        if addrs_ is not None and not isinstance(addrs_, (bytes, str, list)):
            raise Exception("Expected addrs_ to be a Sequence, received: {}".format(type(addrs_)))

        if auth_tag_ is not None and not isinstance(auth_tag_, (bytes, str)):
            raise Exception("Expected auth_tag_ to be a str, received: {}".format(type(auth_tag_)))

        if ca_cert_ is not None and not isinstance(ca_cert_, (bytes, str)):
            raise Exception("Expected ca_cert_ to be a str, received: {}".format(type(ca_cert_)))

        if controller_alias_ is not None and not isinstance(controller_alias_, (bytes, str)):
            raise Exception("Expected controller_alias_ to be a str, received: {}".format(type(controller_alias_)))

        if controller_tag_ is not None and not isinstance(controller_tag_, (bytes, str)):
            raise Exception("Expected controller_tag_ to be a str, received: {}".format(type(controller_tag_)))

        if macaroons_ is not None and not isinstance(macaroons_, (bytes, str)):
            raise Exception("Expected macaroons_ to be a str, received: {}".format(type(macaroons_)))

        if password_ is not None and not isinstance(password_, (bytes, str)):
            raise Exception("Expected password_ to be a str, received: {}".format(type(password_)))

        self.addrs = addrs_
        self.auth_tag = auth_tag_
        self.ca_cert = ca_cert_
        self.controller_alias = controller_alias_
        self.controller_tag = controller_tag_
        self.macaroons = macaroons_
        self.password = password_
        self.unknown_fields = unknown_fields



class MinionReport(Type):
    _toSchema = {'migration_id': 'migration-id', 'phase': 'phase', 'success': 'success'}
    _toPy = {'migration-id': 'migration_id', 'phase': 'phase', 'success': 'success'}
    def __init__(self, migration_id=None, phase=None, success=None, **unknown_fields):
        '''
        migration_id : str
        phase : str
        success : bool
        '''
        migration_id_ = migration_id
        phase_ = phase
        success_ = success

        # Validate arguments against known Juju API types.
        if migration_id_ is not None and not isinstance(migration_id_, (bytes, str)):
            raise Exception("Expected migration_id_ to be a str, received: {}".format(type(migration_id_)))

        if phase_ is not None and not isinstance(phase_, (bytes, str)):
            raise Exception("Expected phase_ to be a str, received: {}".format(type(phase_)))

        if success_ is not None and not isinstance(success_, bool):
            raise Exception("Expected success_ to be a bool, received: {}".format(type(success_)))

        self.migration_id = migration_id_
        self.phase = phase_
        self.success = success_
        self.unknown_fields = unknown_fields



class MinionReports(Type):
    _toSchema = {'failed': 'failed', 'migration_id': 'migration-id', 'phase': 'phase', 'success_count': 'success-count', 'unknown_count': 'unknown-count', 'unknown_sample': 'unknown-sample'}
    _toPy = {'failed': 'failed', 'migration-id': 'migration_id', 'phase': 'phase', 'success-count': 'success_count', 'unknown-count': 'unknown_count', 'unknown-sample': 'unknown_sample'}
    def __init__(self, failed=None, migration_id=None, phase=None, success_count=None, unknown_count=None, unknown_sample=None, **unknown_fields):
        '''
        failed : typing.Sequence[str]
        migration_id : str
        phase : str
        success_count : int
        unknown_count : int
        unknown_sample : typing.Sequence[str]
        '''
        failed_ = failed
        migration_id_ = migration_id
        phase_ = phase
        success_count_ = success_count
        unknown_count_ = unknown_count
        unknown_sample_ = unknown_sample

        # Validate arguments against known Juju API types.
        if failed_ is not None and not isinstance(failed_, (bytes, str, list)):
            raise Exception("Expected failed_ to be a Sequence, received: {}".format(type(failed_)))

        if migration_id_ is not None and not isinstance(migration_id_, (bytes, str)):
            raise Exception("Expected migration_id_ to be a str, received: {}".format(type(migration_id_)))

        if phase_ is not None and not isinstance(phase_, (bytes, str)):
            raise Exception("Expected phase_ to be a str, received: {}".format(type(phase_)))

        if success_count_ is not None and not isinstance(success_count_, int):
            raise Exception("Expected success_count_ to be a int, received: {}".format(type(success_count_)))

        if unknown_count_ is not None and not isinstance(unknown_count_, int):
            raise Exception("Expected unknown_count_ to be a int, received: {}".format(type(unknown_count_)))

        if unknown_sample_ is not None and not isinstance(unknown_sample_, (bytes, str, list)):
            raise Exception("Expected unknown_sample_ to be a Sequence, received: {}".format(type(unknown_sample_)))

        self.failed = failed_
        self.migration_id = migration_id_
        self.phase = phase_
        self.success_count = success_count_
        self.unknown_count = unknown_count_
        self.unknown_sample = unknown_sample_
        self.unknown_fields = unknown_fields



class Model(Type):
    _toSchema = {'name': 'name', 'owner_tag': 'owner-tag', 'type_': 'type', 'uuid': 'uuid'}
    _toPy = {'name': 'name', 'owner-tag': 'owner_tag', 'type': 'type_', 'uuid': 'uuid'}
    def __init__(self, name=None, owner_tag=None, type_=None, uuid=None, **unknown_fields):
        '''
        name : str
        owner_tag : str
        type_ : str
        uuid : str
        '''
        name_ = name
        owner_tag_ = owner_tag
        type__ = type_
        uuid_ = uuid

        # Validate arguments against known Juju API types.
        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if owner_tag_ is not None and not isinstance(owner_tag_, (bytes, str)):
            raise Exception("Expected owner_tag_ to be a str, received: {}".format(type(owner_tag_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if uuid_ is not None and not isinstance(uuid_, (bytes, str)):
            raise Exception("Expected uuid_ to be a str, received: {}".format(type(uuid_)))

        self.name = name_
        self.owner_tag = owner_tag_
        self.type_ = type__
        self.uuid = uuid_
        self.unknown_fields = unknown_fields



class ModelAbstract(Type):
    _toSchema = {'admins': 'admins', 'annotations': 'annotations', 'cloud': 'cloud', 'controller': 'controller', 'credential': 'credential', 'messages': 'messages', 'name': 'name', 'region': 'region', 'removed': 'removed', 'size': 'size', 'status': 'status', 'uuid': 'uuid'}
    _toPy = {'admins': 'admins', 'annotations': 'annotations', 'cloud': 'cloud', 'controller': 'controller', 'credential': 'credential', 'messages': 'messages', 'name': 'name', 'region': 'region', 'removed': 'removed', 'size': 'size', 'status': 'status', 'uuid': 'uuid'}
    def __init__(self, admins=None, annotations=None, cloud=None, controller=None, credential=None, messages=None, name=None, region=None, removed=None, size=None, status=None, uuid=None, **unknown_fields):
        '''
        admins : typing.Sequence[str]
        annotations : typing.Mapping[str, str]
        cloud : str
        controller : str
        credential : str
        messages : typing.Sequence[~ModelSummaryMessage]
        name : str
        region : str
        removed : bool
        size : ModelSummarySize
        status : str
        uuid : str
        '''
        admins_ = admins
        annotations_ = annotations
        cloud_ = cloud
        controller_ = controller
        credential_ = credential
        messages_ = [ModelSummaryMessage.from_json(o) for o in messages or []]
        name_ = name
        region_ = region
        removed_ = removed
        size_ = ModelSummarySize.from_json(size) if size else None
        status_ = status
        uuid_ = uuid

        # Validate arguments against known Juju API types.
        if admins_ is not None and not isinstance(admins_, (bytes, str, list)):
            raise Exception("Expected admins_ to be a Sequence, received: {}".format(type(admins_)))

        if annotations_ is not None and not isinstance(annotations_, dict):
            raise Exception("Expected annotations_ to be a Mapping, received: {}".format(type(annotations_)))

        if cloud_ is not None and not isinstance(cloud_, (bytes, str)):
            raise Exception("Expected cloud_ to be a str, received: {}".format(type(cloud_)))

        if controller_ is not None and not isinstance(controller_, (bytes, str)):
            raise Exception("Expected controller_ to be a str, received: {}".format(type(controller_)))

        if credential_ is not None and not isinstance(credential_, (bytes, str)):
            raise Exception("Expected credential_ to be a str, received: {}".format(type(credential_)))

        if messages_ is not None and not isinstance(messages_, (bytes, str, list)):
            raise Exception("Expected messages_ to be a Sequence, received: {}".format(type(messages_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if region_ is not None and not isinstance(region_, (bytes, str)):
            raise Exception("Expected region_ to be a str, received: {}".format(type(region_)))

        if removed_ is not None and not isinstance(removed_, bool):
            raise Exception("Expected removed_ to be a bool, received: {}".format(type(removed_)))

        if size_ is not None and not isinstance(size_, (dict, ModelSummarySize)):
            raise Exception("Expected size_ to be a ModelSummarySize, received: {}".format(type(size_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if uuid_ is not None and not isinstance(uuid_, (bytes, str)):
            raise Exception("Expected uuid_ to be a str, received: {}".format(type(uuid_)))

        self.admins = admins_
        self.annotations = annotations_
        self.cloud = cloud_
        self.controller = controller_
        self.credential = credential_
        self.messages = messages_
        self.name = name_
        self.region = region_
        self.removed = removed_
        self.size = size_
        self.status = status_
        self.uuid = uuid_
        self.unknown_fields = unknown_fields



class ModelAccess(Type):
    _toSchema = {'access': 'access', 'model': 'model'}
    _toPy = {'access': 'access', 'model': 'model'}
    def __init__(self, access=None, model=None, **unknown_fields):
        '''
        access : str
        model : str
        '''
        access_ = access
        model_ = model

        # Validate arguments against known Juju API types.
        if access_ is not None and not isinstance(access_, (bytes, str)):
            raise Exception("Expected access_ to be a str, received: {}".format(type(access_)))

        if model_ is not None and not isinstance(model_, (bytes, str)):
            raise Exception("Expected model_ to be a str, received: {}".format(type(model_)))

        self.access = access_
        self.model = model_
        self.unknown_fields = unknown_fields



class ModelArgs(Type):
    _toSchema = {'model_tag': 'model-tag'}
    _toPy = {'model-tag': 'model_tag'}
    def __init__(self, model_tag=None, **unknown_fields):
        '''
        model_tag : str
        '''
        model_tag_ = model_tag

        # Validate arguments against known Juju API types.
        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        self.model_tag = model_tag_
        self.unknown_fields = unknown_fields



class ModelBlockInfo(Type):
    _toSchema = {'blocks': 'blocks', 'model_uuid': 'model-uuid', 'name': 'name', 'owner_tag': 'owner-tag'}
    _toPy = {'blocks': 'blocks', 'model-uuid': 'model_uuid', 'name': 'name', 'owner-tag': 'owner_tag'}
    def __init__(self, blocks=None, model_uuid=None, name=None, owner_tag=None, **unknown_fields):
        '''
        blocks : typing.Sequence[str]
        model_uuid : str
        name : str
        owner_tag : str
        '''
        blocks_ = blocks
        model_uuid_ = model_uuid
        name_ = name
        owner_tag_ = owner_tag

        # Validate arguments against known Juju API types.
        if blocks_ is not None and not isinstance(blocks_, (bytes, str, list)):
            raise Exception("Expected blocks_ to be a Sequence, received: {}".format(type(blocks_)))

        if model_uuid_ is not None and not isinstance(model_uuid_, (bytes, str)):
            raise Exception("Expected model_uuid_ to be a str, received: {}".format(type(model_uuid_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if owner_tag_ is not None and not isinstance(owner_tag_, (bytes, str)):
            raise Exception("Expected owner_tag_ to be a str, received: {}".format(type(owner_tag_)))

        self.blocks = blocks_
        self.model_uuid = model_uuid_
        self.name = name_
        self.owner_tag = owner_tag_
        self.unknown_fields = unknown_fields



class ModelBlockInfoList(Type):
    _toSchema = {'models': 'models'}
    _toPy = {'models': 'models'}
    def __init__(self, models=None, **unknown_fields):
        '''
        models : typing.Sequence[~ModelBlockInfo]
        '''
        models_ = [ModelBlockInfo.from_json(o) for o in models or []]

        # Validate arguments against known Juju API types.
        if models_ is not None and not isinstance(models_, (bytes, str, list)):
            raise Exception("Expected models_ to be a Sequence, received: {}".format(type(models_)))

        self.models = models_
        self.unknown_fields = unknown_fields



class ModelConfigResult(Type):
    _toSchema = {'config': 'config'}
    _toPy = {'config': 'config'}
    def __init__(self, config=None, **unknown_fields):
        '''
        config : typing.Mapping[str, typing.Any]
        '''
        config_ = config

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        self.config = config_
        self.unknown_fields = unknown_fields



class ModelConfigResults(Type):
    _toSchema = {'config': 'config'}
    _toPy = {'config': 'config'}
    def __init__(self, config=None, **unknown_fields):
        '''
        config : typing.Mapping[str, ~ConfigValue]
        '''
        config_ = {k: ConfigValue.from_json(v) for k, v in (config or dict()).items()}

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        self.config = config_
        self.unknown_fields = unknown_fields



class ModelCreateArgs(Type):
    _toSchema = {'cloud_tag': 'cloud-tag', 'config': 'config', 'credential': 'credential', 'name': 'name', 'owner_tag': 'owner-tag', 'region': 'region'}
    _toPy = {'cloud-tag': 'cloud_tag', 'config': 'config', 'credential': 'credential', 'name': 'name', 'owner-tag': 'owner_tag', 'region': 'region'}
    def __init__(self, cloud_tag=None, config=None, credential=None, name=None, owner_tag=None, region=None, **unknown_fields):
        '''
        cloud_tag : str
        config : typing.Mapping[str, typing.Any]
        credential : str
        name : str
        owner_tag : str
        region : str
        '''
        cloud_tag_ = cloud_tag
        config_ = config
        credential_ = credential
        name_ = name
        owner_tag_ = owner_tag
        region_ = region

        # Validate arguments against known Juju API types.
        if cloud_tag_ is not None and not isinstance(cloud_tag_, (bytes, str)):
            raise Exception("Expected cloud_tag_ to be a str, received: {}".format(type(cloud_tag_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if credential_ is not None and not isinstance(credential_, (bytes, str)):
            raise Exception("Expected credential_ to be a str, received: {}".format(type(credential_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if owner_tag_ is not None and not isinstance(owner_tag_, (bytes, str)):
            raise Exception("Expected owner_tag_ to be a str, received: {}".format(type(owner_tag_)))

        if region_ is not None and not isinstance(region_, (bytes, str)):
            raise Exception("Expected region_ to be a str, received: {}".format(type(region_)))

        self.cloud_tag = cloud_tag_
        self.config = config_
        self.credential = credential_
        self.name = name_
        self.owner_tag = owner_tag_
        self.region = region_
        self.unknown_fields = unknown_fields



class ModelCredential(Type):
    _toSchema = {'credential_tag': 'credential-tag', 'exists': 'exists', 'model_tag': 'model-tag', 'valid': 'valid'}
    _toPy = {'credential-tag': 'credential_tag', 'exists': 'exists', 'model-tag': 'model_tag', 'valid': 'valid'}
    def __init__(self, credential_tag=None, exists=None, model_tag=None, valid=None, **unknown_fields):
        '''
        credential_tag : str
        exists : bool
        model_tag : str
        valid : bool
        '''
        credential_tag_ = credential_tag
        exists_ = exists
        model_tag_ = model_tag
        valid_ = valid

        # Validate arguments against known Juju API types.
        if credential_tag_ is not None and not isinstance(credential_tag_, (bytes, str)):
            raise Exception("Expected credential_tag_ to be a str, received: {}".format(type(credential_tag_)))

        if exists_ is not None and not isinstance(exists_, bool):
            raise Exception("Expected exists_ to be a bool, received: {}".format(type(exists_)))

        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        if valid_ is not None and not isinstance(valid_, bool):
            raise Exception("Expected valid_ to be a bool, received: {}".format(type(valid_)))

        self.credential_tag = credential_tag_
        self.exists = exists_
        self.model_tag = model_tag_
        self.valid = valid_
        self.unknown_fields = unknown_fields



class ModelDefaultValues(Type):
    _toSchema = {'cloud_region': 'cloud-region', 'cloud_tag': 'cloud-tag', 'config': 'config'}
    _toPy = {'cloud-region': 'cloud_region', 'cloud-tag': 'cloud_tag', 'config': 'config'}
    def __init__(self, cloud_region=None, cloud_tag=None, config=None, **unknown_fields):
        '''
        cloud_region : str
        cloud_tag : str
        config : typing.Mapping[str, typing.Any]
        '''
        cloud_region_ = cloud_region
        cloud_tag_ = cloud_tag
        config_ = config

        # Validate arguments against known Juju API types.
        if cloud_region_ is not None and not isinstance(cloud_region_, (bytes, str)):
            raise Exception("Expected cloud_region_ to be a str, received: {}".format(type(cloud_region_)))

        if cloud_tag_ is not None and not isinstance(cloud_tag_, (bytes, str)):
            raise Exception("Expected cloud_tag_ to be a str, received: {}".format(type(cloud_tag_)))

        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        self.cloud_region = cloud_region_
        self.cloud_tag = cloud_tag_
        self.config = config_
        self.unknown_fields = unknown_fields



class ModelDefaults(Type):
    _toSchema = {'controller': 'controller', 'default': 'default', 'regions': 'regions'}
    _toPy = {'controller': 'controller', 'default': 'default', 'regions': 'regions'}
    def __init__(self, controller=None, default=None, regions=None, **unknown_fields):
        '''
        controller : Any
        default : Any
        regions : typing.Sequence[~RegionDefaults]
        '''
        controller_ = controller
        default_ = default
        regions_ = [RegionDefaults.from_json(o) for o in regions or []]

        # Validate arguments against known Juju API types.
        if regions_ is not None and not isinstance(regions_, (bytes, str, list)):
            raise Exception("Expected regions_ to be a Sequence, received: {}".format(type(regions_)))

        self.controller = controller_
        self.default = default_
        self.regions = regions_
        self.unknown_fields = unknown_fields



class ModelDefaultsResult(Type):
    _toSchema = {'config': 'config', 'error': 'error'}
    _toPy = {'config': 'config', 'error': 'error'}
    def __init__(self, config=None, error=None, **unknown_fields):
        '''
        config : typing.Mapping[str, ~ModelDefaults]
        error : Error
        '''
        config_ = {k: ModelDefaults.from_json(v) for k, v in (config or dict()).items()}
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.config = config_
        self.error = error_
        self.unknown_fields = unknown_fields



class ModelDefaultsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ModelDefaultsResult]
        '''
        results_ = [ModelDefaultsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ModelEntityCount(Type):
    _toSchema = {'count': 'count', 'entity': 'entity'}
    _toPy = {'count': 'count', 'entity': 'entity'}
    def __init__(self, count=None, entity=None, **unknown_fields):
        '''
        count : int
        entity : str
        '''
        count_ = count
        entity_ = entity

        # Validate arguments against known Juju API types.
        if count_ is not None and not isinstance(count_, int):
            raise Exception("Expected count_ to be a int, received: {}".format(type(count_)))

        if entity_ is not None and not isinstance(entity_, (bytes, str)):
            raise Exception("Expected entity_ to be a str, received: {}".format(type(entity_)))

        self.count = count_
        self.entity = entity_
        self.unknown_fields = unknown_fields



class ModelFilesystemInfo(Type):
    _toSchema = {'detachable': 'detachable', 'id_': 'id', 'message': 'message', 'provider_id': 'provider-id', 'status': 'status'}
    _toPy = {'detachable': 'detachable', 'id': 'id_', 'message': 'message', 'provider-id': 'provider_id', 'status': 'status'}
    def __init__(self, detachable=None, id_=None, message=None, provider_id=None, status=None, **unknown_fields):
        '''
        detachable : bool
        id_ : str
        message : str
        provider_id : str
        status : str
        '''
        detachable_ = detachable
        id__ = id_
        message_ = message
        provider_id_ = provider_id
        status_ = status

        # Validate arguments against known Juju API types.
        if detachable_ is not None and not isinstance(detachable_, bool):
            raise Exception("Expected detachable_ to be a bool, received: {}".format(type(detachable_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.detachable = detachable_
        self.id_ = id__
        self.message = message_
        self.provider_id = provider_id_
        self.status = status_
        self.unknown_fields = unknown_fields



class ModelInfo(Type):
    _toSchema = {'agent_version': 'agent-version', 'cloud_credential_tag': 'cloud-credential-tag', 'cloud_credential_validity': 'cloud-credential-validity', 'cloud_region': 'cloud-region', 'cloud_tag': 'cloud-tag', 'controller_uuid': 'controller-uuid', 'default_series': 'default-series', 'is_controller': 'is-controller', 'life': 'life', 'machines': 'machines', 'migration': 'migration', 'name': 'name', 'owner_tag': 'owner-tag', 'provider_type': 'provider-type', 'sla': 'sla', 'status': 'status', 'type_': 'type', 'users': 'users', 'uuid': 'uuid'}
    _toPy = {'agent-version': 'agent_version', 'cloud-credential-tag': 'cloud_credential_tag', 'cloud-credential-validity': 'cloud_credential_validity', 'cloud-region': 'cloud_region', 'cloud-tag': 'cloud_tag', 'controller-uuid': 'controller_uuid', 'default-series': 'default_series', 'is-controller': 'is_controller', 'life': 'life', 'machines': 'machines', 'migration': 'migration', 'name': 'name', 'owner-tag': 'owner_tag', 'provider-type': 'provider_type', 'sla': 'sla', 'status': 'status', 'type': 'type_', 'users': 'users', 'uuid': 'uuid'}
    def __init__(self, agent_version=None, cloud_credential_tag=None, cloud_credential_validity=None, cloud_region=None, cloud_tag=None, controller_uuid=None, default_series=None, is_controller=None, life=None, machines=None, migration=None, name=None, owner_tag=None, provider_type=None, sla=None, status=None, type_=None, users=None, uuid=None, **unknown_fields):
        '''
        agent_version : Number
        cloud_credential_tag : str
        cloud_credential_validity : bool
        cloud_region : str
        cloud_tag : str
        controller_uuid : str
        default_series : str
        is_controller : bool
        life : str
        machines : typing.Sequence[~ModelMachineInfo]
        migration : ModelMigrationStatus
        name : str
        owner_tag : str
        provider_type : str
        sla : ModelSLAInfo
        status : EntityStatus
        type_ : str
        users : typing.Sequence[~ModelUserInfo]
        uuid : str
        '''
        agent_version_ = Number.from_json(agent_version) if agent_version else None
        cloud_credential_tag_ = cloud_credential_tag
        cloud_credential_validity_ = cloud_credential_validity
        cloud_region_ = cloud_region
        cloud_tag_ = cloud_tag
        controller_uuid_ = controller_uuid
        default_series_ = default_series
        is_controller_ = is_controller
        life_ = life
        machines_ = [ModelMachineInfo.from_json(o) for o in machines or []]
        migration_ = ModelMigrationStatus.from_json(migration) if migration else None
        name_ = name
        owner_tag_ = owner_tag
        provider_type_ = provider_type
        sla_ = ModelSLAInfo.from_json(sla) if sla else None
        status_ = EntityStatus.from_json(status) if status else None
        type__ = type_
        users_ = [ModelUserInfo.from_json(o) for o in users or []]
        uuid_ = uuid

        # Validate arguments against known Juju API types.
        if agent_version_ is not None and not isinstance(agent_version_, (dict, Number)):
            raise Exception("Expected agent_version_ to be a Number, received: {}".format(type(agent_version_)))

        if cloud_credential_tag_ is not None and not isinstance(cloud_credential_tag_, (bytes, str)):
            raise Exception("Expected cloud_credential_tag_ to be a str, received: {}".format(type(cloud_credential_tag_)))

        if cloud_credential_validity_ is not None and not isinstance(cloud_credential_validity_, bool):
            raise Exception("Expected cloud_credential_validity_ to be a bool, received: {}".format(type(cloud_credential_validity_)))

        if cloud_region_ is not None and not isinstance(cloud_region_, (bytes, str)):
            raise Exception("Expected cloud_region_ to be a str, received: {}".format(type(cloud_region_)))

        if cloud_tag_ is not None and not isinstance(cloud_tag_, (bytes, str)):
            raise Exception("Expected cloud_tag_ to be a str, received: {}".format(type(cloud_tag_)))

        if controller_uuid_ is not None and not isinstance(controller_uuid_, (bytes, str)):
            raise Exception("Expected controller_uuid_ to be a str, received: {}".format(type(controller_uuid_)))

        if default_series_ is not None and not isinstance(default_series_, (bytes, str)):
            raise Exception("Expected default_series_ to be a str, received: {}".format(type(default_series_)))

        if is_controller_ is not None and not isinstance(is_controller_, bool):
            raise Exception("Expected is_controller_ to be a bool, received: {}".format(type(is_controller_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if machines_ is not None and not isinstance(machines_, (bytes, str, list)):
            raise Exception("Expected machines_ to be a Sequence, received: {}".format(type(machines_)))

        if migration_ is not None and not isinstance(migration_, (dict, ModelMigrationStatus)):
            raise Exception("Expected migration_ to be a ModelMigrationStatus, received: {}".format(type(migration_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if owner_tag_ is not None and not isinstance(owner_tag_, (bytes, str)):
            raise Exception("Expected owner_tag_ to be a str, received: {}".format(type(owner_tag_)))

        if provider_type_ is not None and not isinstance(provider_type_, (bytes, str)):
            raise Exception("Expected provider_type_ to be a str, received: {}".format(type(provider_type_)))

        if sla_ is not None and not isinstance(sla_, (dict, ModelSLAInfo)):
            raise Exception("Expected sla_ to be a ModelSLAInfo, received: {}".format(type(sla_)))

        if status_ is not None and not isinstance(status_, (dict, EntityStatus)):
            raise Exception("Expected status_ to be a EntityStatus, received: {}".format(type(status_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if users_ is not None and not isinstance(users_, (bytes, str, list)):
            raise Exception("Expected users_ to be a Sequence, received: {}".format(type(users_)))

        if uuid_ is not None and not isinstance(uuid_, (bytes, str)):
            raise Exception("Expected uuid_ to be a str, received: {}".format(type(uuid_)))

        self.agent_version = agent_version_
        self.cloud_credential_tag = cloud_credential_tag_
        self.cloud_credential_validity = cloud_credential_validity_
        self.cloud_region = cloud_region_
        self.cloud_tag = cloud_tag_
        self.controller_uuid = controller_uuid_
        self.default_series = default_series_
        self.is_controller = is_controller_
        self.life = life_
        self.machines = machines_
        self.migration = migration_
        self.name = name_
        self.owner_tag = owner_tag_
        self.provider_type = provider_type_
        self.sla = sla_
        self.status = status_
        self.type_ = type__
        self.users = users_
        self.uuid = uuid_
        self.unknown_fields = unknown_fields



class ModelInfoResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ModelInfo
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ModelInfo.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ModelInfo)):
            raise Exception("Expected result_ to be a ModelInfo, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ModelInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ModelInfoResult]
        '''
        results_ = [ModelInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ModelInstanceTypesConstraint(Type):
    _toSchema = {'value': 'value'}
    _toPy = {'value': 'value'}
    def __init__(self, value=None, **unknown_fields):
        '''
        value : Value
        '''
        value_ = Value.from_json(value) if value else None

        # Validate arguments against known Juju API types.
        if value_ is not None and not isinstance(value_, (dict, Value)):
            raise Exception("Expected value_ to be a Value, received: {}".format(type(value_)))

        self.value = value_
        self.unknown_fields = unknown_fields



class ModelInstanceTypesConstraints(Type):
    _toSchema = {'constraints': 'constraints'}
    _toPy = {'constraints': 'constraints'}
    def __init__(self, constraints=None, **unknown_fields):
        '''
        constraints : typing.Sequence[~ModelInstanceTypesConstraint]
        '''
        constraints_ = [ModelInstanceTypesConstraint.from_json(o) for o in constraints or []]

        # Validate arguments against known Juju API types.
        if constraints_ is not None and not isinstance(constraints_, (bytes, str, list)):
            raise Exception("Expected constraints_ to be a Sequence, received: {}".format(type(constraints_)))

        self.constraints = constraints_
        self.unknown_fields = unknown_fields



class ModelMachineInfo(Type):
    _toSchema = {'display_name': 'display-name', 'ha_primary': 'ha-primary', 'hardware': 'hardware', 'has_vote': 'has-vote', 'id_': 'id', 'instance_id': 'instance-id', 'message': 'message', 'status': 'status', 'wants_vote': 'wants-vote'}
    _toPy = {'display-name': 'display_name', 'ha-primary': 'ha_primary', 'hardware': 'hardware', 'has-vote': 'has_vote', 'id': 'id_', 'instance-id': 'instance_id', 'message': 'message', 'status': 'status', 'wants-vote': 'wants_vote'}
    def __init__(self, display_name=None, ha_primary=None, hardware=None, has_vote=None, id_=None, instance_id=None, message=None, status=None, wants_vote=None, **unknown_fields):
        '''
        display_name : str
        ha_primary : bool
        hardware : MachineHardware
        has_vote : bool
        id_ : str
        instance_id : str
        message : str
        status : str
        wants_vote : bool
        '''
        display_name_ = display_name
        ha_primary_ = ha_primary
        hardware_ = MachineHardware.from_json(hardware) if hardware else None
        has_vote_ = has_vote
        id__ = id_
        instance_id_ = instance_id
        message_ = message
        status_ = status
        wants_vote_ = wants_vote

        # Validate arguments against known Juju API types.
        if display_name_ is not None and not isinstance(display_name_, (bytes, str)):
            raise Exception("Expected display_name_ to be a str, received: {}".format(type(display_name_)))

        if ha_primary_ is not None and not isinstance(ha_primary_, bool):
            raise Exception("Expected ha_primary_ to be a bool, received: {}".format(type(ha_primary_)))

        if hardware_ is not None and not isinstance(hardware_, (dict, MachineHardware)):
            raise Exception("Expected hardware_ to be a MachineHardware, received: {}".format(type(hardware_)))

        if has_vote_ is not None and not isinstance(has_vote_, bool):
            raise Exception("Expected has_vote_ to be a bool, received: {}".format(type(has_vote_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if instance_id_ is not None and not isinstance(instance_id_, (bytes, str)):
            raise Exception("Expected instance_id_ to be a str, received: {}".format(type(instance_id_)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if wants_vote_ is not None and not isinstance(wants_vote_, bool):
            raise Exception("Expected wants_vote_ to be a bool, received: {}".format(type(wants_vote_)))

        self.display_name = display_name_
        self.ha_primary = ha_primary_
        self.hardware = hardware_
        self.has_vote = has_vote_
        self.id_ = id__
        self.instance_id = instance_id_
        self.message = message_
        self.status = status_
        self.wants_vote = wants_vote_
        self.unknown_fields = unknown_fields



class ModelMigrationStatus(Type):
    _toSchema = {'end': 'end', 'start': 'start', 'status': 'status'}
    _toPy = {'end': 'end', 'start': 'start', 'status': 'status'}
    def __init__(self, end=None, start=None, status=None, **unknown_fields):
        '''
        end : str
        start : str
        status : str
        '''
        end_ = end
        start_ = start
        status_ = status

        # Validate arguments against known Juju API types.
        if end_ is not None and not isinstance(end_, (bytes, str)):
            raise Exception("Expected end_ to be a str, received: {}".format(type(end_)))

        if start_ is not None and not isinstance(start_, (bytes, str)):
            raise Exception("Expected start_ to be a str, received: {}".format(type(start_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.end = end_
        self.start = start_
        self.status = status_
        self.unknown_fields = unknown_fields



class ModelOperatorInfo(Type):
    _toSchema = {'api_addresses': 'api-addresses', 'image_path': 'image-path', 'version': 'version'}
    _toPy = {'api-addresses': 'api_addresses', 'image-path': 'image_path', 'version': 'version'}
    def __init__(self, api_addresses=None, image_path=None, version=None, **unknown_fields):
        '''
        api_addresses : typing.Sequence[str]
        image_path : str
        version : Number
        '''
        api_addresses_ = api_addresses
        image_path_ = image_path
        version_ = Number.from_json(version) if version else None

        # Validate arguments against known Juju API types.
        if api_addresses_ is not None and not isinstance(api_addresses_, (bytes, str, list)):
            raise Exception("Expected api_addresses_ to be a Sequence, received: {}".format(type(api_addresses_)))

        if image_path_ is not None and not isinstance(image_path_, (bytes, str)):
            raise Exception("Expected image_path_ to be a str, received: {}".format(type(image_path_)))

        if version_ is not None and not isinstance(version_, (dict, Number)):
            raise Exception("Expected version_ to be a Number, received: {}".format(type(version_)))

        self.api_addresses = api_addresses_
        self.image_path = image_path_
        self.version = version_
        self.unknown_fields = unknown_fields



class ModelResult(Type):
    _toSchema = {'error': 'error', 'name': 'name', 'type_': 'type', 'uuid': 'uuid'}
    _toPy = {'error': 'error', 'name': 'name', 'type': 'type_', 'uuid': 'uuid'}
    def __init__(self, error=None, name=None, type_=None, uuid=None, **unknown_fields):
        '''
        error : Error
        name : str
        type_ : str
        uuid : str
        '''
        error_ = Error.from_json(error) if error else None
        name_ = name
        type__ = type_
        uuid_ = uuid

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if uuid_ is not None and not isinstance(uuid_, (bytes, str)):
            raise Exception("Expected uuid_ to be a str, received: {}".format(type(uuid_)))

        self.error = error_
        self.name = name_
        self.type_ = type__
        self.uuid = uuid_
        self.unknown_fields = unknown_fields



class ModelSLA(Type):
    _toSchema = {'creds': 'creds', 'level': 'level', 'modelslainfo': 'ModelSLAInfo', 'owner': 'owner'}
    _toPy = {'ModelSLAInfo': 'modelslainfo', 'creds': 'creds', 'level': 'level', 'owner': 'owner'}
    def __init__(self, modelslainfo=None, creds=None, level=None, owner=None, **unknown_fields):
        '''
        modelslainfo : ModelSLAInfo
        creds : typing.Sequence[int]
        level : str
        owner : str
        '''
        modelslainfo_ = ModelSLAInfo.from_json(modelslainfo) if modelslainfo else None
        creds_ = creds
        level_ = level
        owner_ = owner

        # Validate arguments against known Juju API types.
        if modelslainfo_ is not None and not isinstance(modelslainfo_, (dict, ModelSLAInfo)):
            raise Exception("Expected modelslainfo_ to be a ModelSLAInfo, received: {}".format(type(modelslainfo_)))

        if creds_ is not None and not isinstance(creds_, (bytes, str, list)):
            raise Exception("Expected creds_ to be a Sequence, received: {}".format(type(creds_)))

        if level_ is not None and not isinstance(level_, (bytes, str)):
            raise Exception("Expected level_ to be a str, received: {}".format(type(level_)))

        if owner_ is not None and not isinstance(owner_, (bytes, str)):
            raise Exception("Expected owner_ to be a str, received: {}".format(type(owner_)))

        self.modelslainfo = modelslainfo_
        self.creds = creds_
        self.level = level_
        self.owner = owner_
        self.unknown_fields = unknown_fields



class ModelSLAInfo(Type):
    _toSchema = {'level': 'level', 'owner': 'owner'}
    _toPy = {'level': 'level', 'owner': 'owner'}
    def __init__(self, level=None, owner=None, **unknown_fields):
        '''
        level : str
        owner : str
        '''
        level_ = level
        owner_ = owner

        # Validate arguments against known Juju API types.
        if level_ is not None and not isinstance(level_, (bytes, str)):
            raise Exception("Expected level_ to be a str, received: {}".format(type(level_)))

        if owner_ is not None and not isinstance(owner_, (bytes, str)):
            raise Exception("Expected owner_ to be a str, received: {}".format(type(owner_)))

        self.level = level_
        self.owner = owner_
        self.unknown_fields = unknown_fields



class ModelSequencesResult(Type):
    _toSchema = {'sequences': 'sequences'}
    _toPy = {'sequences': 'sequences'}
    def __init__(self, sequences=None, **unknown_fields):
        '''
        sequences : typing.Mapping[str, int]
        '''
        sequences_ = sequences

        # Validate arguments against known Juju API types.
        if sequences_ is not None and not isinstance(sequences_, dict):
            raise Exception("Expected sequences_ to be a Mapping, received: {}".format(type(sequences_)))

        self.sequences = sequences_
        self.unknown_fields = unknown_fields



class ModelSet(Type):
    _toSchema = {'config': 'config'}
    _toPy = {'config': 'config'}
    def __init__(self, config=None, **unknown_fields):
        '''
        config : typing.Mapping[str, typing.Any]
        '''
        config_ = config

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, dict):
            raise Exception("Expected config_ to be a Mapping, received: {}".format(type(config_)))

        self.config = config_
        self.unknown_fields = unknown_fields



class ModelStatus(Type):
    _toSchema = {'application_count': 'application-count', 'error': 'error', 'filesystems': 'filesystems', 'hosted_machine_count': 'hosted-machine-count', 'life': 'life', 'machines': 'machines', 'model_tag': 'model-tag', 'owner_tag': 'owner-tag', 'type_': 'type', 'unit_count': 'unit-count', 'volumes': 'volumes'}
    _toPy = {'application-count': 'application_count', 'error': 'error', 'filesystems': 'filesystems', 'hosted-machine-count': 'hosted_machine_count', 'life': 'life', 'machines': 'machines', 'model-tag': 'model_tag', 'owner-tag': 'owner_tag', 'type': 'type_', 'unit-count': 'unit_count', 'volumes': 'volumes'}
    def __init__(self, application_count=None, error=None, filesystems=None, hosted_machine_count=None, life=None, machines=None, model_tag=None, owner_tag=None, type_=None, unit_count=None, volumes=None, **unknown_fields):
        '''
        application_count : int
        error : Error
        filesystems : typing.Sequence[~ModelFilesystemInfo]
        hosted_machine_count : int
        life : str
        machines : typing.Sequence[~ModelMachineInfo]
        model_tag : str
        owner_tag : str
        type_ : str
        unit_count : int
        volumes : typing.Sequence[~ModelVolumeInfo]
        '''
        application_count_ = application_count
        error_ = Error.from_json(error) if error else None
        filesystems_ = [ModelFilesystemInfo.from_json(o) for o in filesystems or []]
        hosted_machine_count_ = hosted_machine_count
        life_ = life
        machines_ = [ModelMachineInfo.from_json(o) for o in machines or []]
        model_tag_ = model_tag
        owner_tag_ = owner_tag
        type__ = type_
        unit_count_ = unit_count
        volumes_ = [ModelVolumeInfo.from_json(o) for o in volumes or []]

        # Validate arguments against known Juju API types.
        if application_count_ is not None and not isinstance(application_count_, int):
            raise Exception("Expected application_count_ to be a int, received: {}".format(type(application_count_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if filesystems_ is not None and not isinstance(filesystems_, (bytes, str, list)):
            raise Exception("Expected filesystems_ to be a Sequence, received: {}".format(type(filesystems_)))

        if hosted_machine_count_ is not None and not isinstance(hosted_machine_count_, int):
            raise Exception("Expected hosted_machine_count_ to be a int, received: {}".format(type(hosted_machine_count_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if machines_ is not None and not isinstance(machines_, (bytes, str, list)):
            raise Exception("Expected machines_ to be a Sequence, received: {}".format(type(machines_)))

        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        if owner_tag_ is not None and not isinstance(owner_tag_, (bytes, str)):
            raise Exception("Expected owner_tag_ to be a str, received: {}".format(type(owner_tag_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if unit_count_ is not None and not isinstance(unit_count_, int):
            raise Exception("Expected unit_count_ to be a int, received: {}".format(type(unit_count_)))

        if volumes_ is not None and not isinstance(volumes_, (bytes, str, list)):
            raise Exception("Expected volumes_ to be a Sequence, received: {}".format(type(volumes_)))

        self.application_count = application_count_
        self.error = error_
        self.filesystems = filesystems_
        self.hosted_machine_count = hosted_machine_count_
        self.life = life_
        self.machines = machines_
        self.model_tag = model_tag_
        self.owner_tag = owner_tag_
        self.type_ = type__
        self.unit_count = unit_count_
        self.volumes = volumes_
        self.unknown_fields = unknown_fields



class ModelStatusInfo(Type):
    _toSchema = {'available_version': 'available-version', 'cloud_tag': 'cloud-tag', 'migration': 'migration', 'name': 'name', 'region': 'region', 'version': 'version'}
    _toPy = {'available-version': 'available_version', 'cloud-tag': 'cloud_tag', 'migration': 'migration', 'name': 'name', 'region': 'region', 'version': 'version'}
    def __init__(self, available_version=None, cloud_tag=None, migration=None, name=None, region=None, version=None, **unknown_fields):
        '''
        available_version : str
        cloud_tag : str
        migration : str
        name : str
        region : str
        version : str
        '''
        available_version_ = available_version
        cloud_tag_ = cloud_tag
        migration_ = migration
        name_ = name
        region_ = region
        version_ = version

        # Validate arguments against known Juju API types.
        if available_version_ is not None and not isinstance(available_version_, (bytes, str)):
            raise Exception("Expected available_version_ to be a str, received: {}".format(type(available_version_)))

        if cloud_tag_ is not None and not isinstance(cloud_tag_, (bytes, str)):
            raise Exception("Expected cloud_tag_ to be a str, received: {}".format(type(cloud_tag_)))

        if migration_ is not None and not isinstance(migration_, (bytes, str)):
            raise Exception("Expected migration_ to be a str, received: {}".format(type(migration_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if region_ is not None and not isinstance(region_, (bytes, str)):
            raise Exception("Expected region_ to be a str, received: {}".format(type(region_)))

        if version_ is not None and not isinstance(version_, (bytes, str)):
            raise Exception("Expected version_ to be a str, received: {}".format(type(version_)))

        self.available_version = available_version_
        self.cloud_tag = cloud_tag_
        self.migration = migration_
        self.name = name_
        self.region = region_
        self.version = version_
        self.unknown_fields = unknown_fields



class ModelStatusResults(Type):
    _toSchema = {'models': 'models'}
    _toPy = {'models': 'models'}
    def __init__(self, models=None, **unknown_fields):
        '''
        models : typing.Sequence[~ModelStatus]
        '''
        models_ = [ModelStatus.from_json(o) for o in models or []]

        # Validate arguments against known Juju API types.
        if models_ is not None and not isinstance(models_, (bytes, str, list)):
            raise Exception("Expected models_ to be a Sequence, received: {}".format(type(models_)))

        self.models = models_
        self.unknown_fields = unknown_fields



class ModelSummariesRequest(Type):
    _toSchema = {'all_': 'all', 'user_tag': 'user-tag'}
    _toPy = {'all': 'all_', 'user-tag': 'user_tag'}
    def __init__(self, all_=None, user_tag=None, **unknown_fields):
        '''
        all_ : bool
        user_tag : str
        '''
        all__ = all_
        user_tag_ = user_tag

        # Validate arguments against known Juju API types.
        if all__ is not None and not isinstance(all__, bool):
            raise Exception("Expected all__ to be a bool, received: {}".format(type(all__)))

        if user_tag_ is not None and not isinstance(user_tag_, (bytes, str)):
            raise Exception("Expected user_tag_ to be a str, received: {}".format(type(user_tag_)))

        self.all_ = all__
        self.user_tag = user_tag_
        self.unknown_fields = unknown_fields



class ModelSummary(Type):
    _toSchema = {'agent_version': 'agent-version', 'cloud_credential_tag': 'cloud-credential-tag', 'cloud_region': 'cloud-region', 'cloud_tag': 'cloud-tag', 'controller_uuid': 'controller-uuid', 'counts': 'counts', 'default_series': 'default-series', 'is_controller': 'is-controller', 'last_connection': 'last-connection', 'life': 'life', 'migration': 'migration', 'name': 'name', 'owner_tag': 'owner-tag', 'provider_type': 'provider-type', 'sla': 'sla', 'status': 'status', 'type_': 'type', 'user_access': 'user-access', 'uuid': 'uuid'}
    _toPy = {'agent-version': 'agent_version', 'cloud-credential-tag': 'cloud_credential_tag', 'cloud-region': 'cloud_region', 'cloud-tag': 'cloud_tag', 'controller-uuid': 'controller_uuid', 'counts': 'counts', 'default-series': 'default_series', 'is-controller': 'is_controller', 'last-connection': 'last_connection', 'life': 'life', 'migration': 'migration', 'name': 'name', 'owner-tag': 'owner_tag', 'provider-type': 'provider_type', 'sla': 'sla', 'status': 'status', 'type': 'type_', 'user-access': 'user_access', 'uuid': 'uuid'}
    def __init__(self, agent_version=None, cloud_credential_tag=None, cloud_region=None, cloud_tag=None, controller_uuid=None, counts=None, default_series=None, is_controller=None, last_connection=None, life=None, migration=None, name=None, owner_tag=None, provider_type=None, sla=None, status=None, type_=None, user_access=None, uuid=None, **unknown_fields):
        '''
        agent_version : Number
        cloud_credential_tag : str
        cloud_region : str
        cloud_tag : str
        controller_uuid : str
        counts : typing.Sequence[~ModelEntityCount]
        default_series : str
        is_controller : bool
        last_connection : str
        life : str
        migration : ModelMigrationStatus
        name : str
        owner_tag : str
        provider_type : str
        sla : ModelSLAInfo
        status : EntityStatus
        type_ : str
        user_access : str
        uuid : str
        '''
        agent_version_ = Number.from_json(agent_version) if agent_version else None
        cloud_credential_tag_ = cloud_credential_tag
        cloud_region_ = cloud_region
        cloud_tag_ = cloud_tag
        controller_uuid_ = controller_uuid
        counts_ = [ModelEntityCount.from_json(o) for o in counts or []]
        default_series_ = default_series
        is_controller_ = is_controller
        last_connection_ = last_connection
        life_ = life
        migration_ = ModelMigrationStatus.from_json(migration) if migration else None
        name_ = name
        owner_tag_ = owner_tag
        provider_type_ = provider_type
        sla_ = ModelSLAInfo.from_json(sla) if sla else None
        status_ = EntityStatus.from_json(status) if status else None
        type__ = type_
        user_access_ = user_access
        uuid_ = uuid

        # Validate arguments against known Juju API types.
        if agent_version_ is not None and not isinstance(agent_version_, (dict, Number)):
            raise Exception("Expected agent_version_ to be a Number, received: {}".format(type(agent_version_)))

        if cloud_credential_tag_ is not None and not isinstance(cloud_credential_tag_, (bytes, str)):
            raise Exception("Expected cloud_credential_tag_ to be a str, received: {}".format(type(cloud_credential_tag_)))

        if cloud_region_ is not None and not isinstance(cloud_region_, (bytes, str)):
            raise Exception("Expected cloud_region_ to be a str, received: {}".format(type(cloud_region_)))

        if cloud_tag_ is not None and not isinstance(cloud_tag_, (bytes, str)):
            raise Exception("Expected cloud_tag_ to be a str, received: {}".format(type(cloud_tag_)))

        if controller_uuid_ is not None and not isinstance(controller_uuid_, (bytes, str)):
            raise Exception("Expected controller_uuid_ to be a str, received: {}".format(type(controller_uuid_)))

        if counts_ is not None and not isinstance(counts_, (bytes, str, list)):
            raise Exception("Expected counts_ to be a Sequence, received: {}".format(type(counts_)))

        if default_series_ is not None and not isinstance(default_series_, (bytes, str)):
            raise Exception("Expected default_series_ to be a str, received: {}".format(type(default_series_)))

        if is_controller_ is not None and not isinstance(is_controller_, bool):
            raise Exception("Expected is_controller_ to be a bool, received: {}".format(type(is_controller_)))

        if last_connection_ is not None and not isinstance(last_connection_, (bytes, str)):
            raise Exception("Expected last_connection_ to be a str, received: {}".format(type(last_connection_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if migration_ is not None and not isinstance(migration_, (dict, ModelMigrationStatus)):
            raise Exception("Expected migration_ to be a ModelMigrationStatus, received: {}".format(type(migration_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if owner_tag_ is not None and not isinstance(owner_tag_, (bytes, str)):
            raise Exception("Expected owner_tag_ to be a str, received: {}".format(type(owner_tag_)))

        if provider_type_ is not None and not isinstance(provider_type_, (bytes, str)):
            raise Exception("Expected provider_type_ to be a str, received: {}".format(type(provider_type_)))

        if sla_ is not None and not isinstance(sla_, (dict, ModelSLAInfo)):
            raise Exception("Expected sla_ to be a ModelSLAInfo, received: {}".format(type(sla_)))

        if status_ is not None and not isinstance(status_, (dict, EntityStatus)):
            raise Exception("Expected status_ to be a EntityStatus, received: {}".format(type(status_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if user_access_ is not None and not isinstance(user_access_, (bytes, str)):
            raise Exception("Expected user_access_ to be a str, received: {}".format(type(user_access_)))

        if uuid_ is not None and not isinstance(uuid_, (bytes, str)):
            raise Exception("Expected uuid_ to be a str, received: {}".format(type(uuid_)))

        self.agent_version = agent_version_
        self.cloud_credential_tag = cloud_credential_tag_
        self.cloud_region = cloud_region_
        self.cloud_tag = cloud_tag_
        self.controller_uuid = controller_uuid_
        self.counts = counts_
        self.default_series = default_series_
        self.is_controller = is_controller_
        self.last_connection = last_connection_
        self.life = life_
        self.migration = migration_
        self.name = name_
        self.owner_tag = owner_tag_
        self.provider_type = provider_type_
        self.sla = sla_
        self.status = status_
        self.type_ = type__
        self.user_access = user_access_
        self.uuid = uuid_
        self.unknown_fields = unknown_fields



class ModelSummaryMessage(Type):
    _toSchema = {'agent': 'agent', 'message': 'message'}
    _toPy = {'agent': 'agent', 'message': 'message'}
    def __init__(self, agent=None, message=None, **unknown_fields):
        '''
        agent : str
        message : str
        '''
        agent_ = agent
        message_ = message

        # Validate arguments against known Juju API types.
        if agent_ is not None and not isinstance(agent_, (bytes, str)):
            raise Exception("Expected agent_ to be a str, received: {}".format(type(agent_)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        self.agent = agent_
        self.message = message_
        self.unknown_fields = unknown_fields



class ModelSummaryResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ModelSummary
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ModelSummary.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ModelSummary)):
            raise Exception("Expected result_ to be a ModelSummary, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ModelSummaryResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ModelSummaryResult]
        '''
        results_ = [ModelSummaryResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ModelSummarySize(Type):
    _toSchema = {'applications': 'applications', 'containers': 'containers', 'machines': 'machines', 'relations': 'relations', 'units': 'units'}
    _toPy = {'applications': 'applications', 'containers': 'containers', 'machines': 'machines', 'relations': 'relations', 'units': 'units'}
    def __init__(self, applications=None, containers=None, machines=None, relations=None, units=None, **unknown_fields):
        '''
        applications : int
        containers : int
        machines : int
        relations : int
        units : int
        '''
        applications_ = applications
        containers_ = containers
        machines_ = machines
        relations_ = relations
        units_ = units

        # Validate arguments against known Juju API types.
        if applications_ is not None and not isinstance(applications_, int):
            raise Exception("Expected applications_ to be a int, received: {}".format(type(applications_)))

        if containers_ is not None and not isinstance(containers_, int):
            raise Exception("Expected containers_ to be a int, received: {}".format(type(containers_)))

        if machines_ is not None and not isinstance(machines_, int):
            raise Exception("Expected machines_ to be a int, received: {}".format(type(machines_)))

        if relations_ is not None and not isinstance(relations_, int):
            raise Exception("Expected relations_ to be a int, received: {}".format(type(relations_)))

        if units_ is not None and not isinstance(units_, int):
            raise Exception("Expected units_ to be a int, received: {}".format(type(units_)))

        self.applications = applications_
        self.containers = containers_
        self.machines = machines_
        self.relations = relations_
        self.units = units_
        self.unknown_fields = unknown_fields



class ModelTag(Type):
    _toSchema = {}
    _toPy = {}
    def __init__(self, **unknown_fields):
        '''

        '''
        self.unknown_fields = unknown_fields



class ModelUnset(Type):
    _toSchema = {'keys': 'keys'}
    _toPy = {'keys': 'keys'}
    def __init__(self, keys=None, **unknown_fields):
        '''
        keys : typing.Sequence[str]
        '''
        keys_ = keys

        # Validate arguments against known Juju API types.
        if keys_ is not None and not isinstance(keys_, (bytes, str, list)):
            raise Exception("Expected keys_ to be a Sequence, received: {}".format(type(keys_)))

        self.keys = keys_
        self.unknown_fields = unknown_fields



class ModelUnsetKeys(Type):
    _toSchema = {'cloud_region': 'cloud-region', 'cloud_tag': 'cloud-tag', 'keys': 'keys'}
    _toPy = {'cloud-region': 'cloud_region', 'cloud-tag': 'cloud_tag', 'keys': 'keys'}
    def __init__(self, cloud_region=None, cloud_tag=None, keys=None, **unknown_fields):
        '''
        cloud_region : str
        cloud_tag : str
        keys : typing.Sequence[str]
        '''
        cloud_region_ = cloud_region
        cloud_tag_ = cloud_tag
        keys_ = keys

        # Validate arguments against known Juju API types.
        if cloud_region_ is not None and not isinstance(cloud_region_, (bytes, str)):
            raise Exception("Expected cloud_region_ to be a str, received: {}".format(type(cloud_region_)))

        if cloud_tag_ is not None and not isinstance(cloud_tag_, (bytes, str)):
            raise Exception("Expected cloud_tag_ to be a str, received: {}".format(type(cloud_tag_)))

        if keys_ is not None and not isinstance(keys_, (bytes, str, list)):
            raise Exception("Expected keys_ to be a Sequence, received: {}".format(type(keys_)))

        self.cloud_region = cloud_region_
        self.cloud_tag = cloud_tag_
        self.keys = keys_
        self.unknown_fields = unknown_fields



class ModelUserInfo(Type):
    _toSchema = {'access': 'access', 'display_name': 'display-name', 'last_connection': 'last-connection', 'user': 'user'}
    _toPy = {'access': 'access', 'display-name': 'display_name', 'last-connection': 'last_connection', 'user': 'user'}
    def __init__(self, access=None, display_name=None, last_connection=None, user=None, **unknown_fields):
        '''
        access : str
        display_name : str
        last_connection : str
        user : str
        '''
        access_ = access
        display_name_ = display_name
        last_connection_ = last_connection
        user_ = user

        # Validate arguments against known Juju API types.
        if access_ is not None and not isinstance(access_, (bytes, str)):
            raise Exception("Expected access_ to be a str, received: {}".format(type(access_)))

        if display_name_ is not None and not isinstance(display_name_, (bytes, str)):
            raise Exception("Expected display_name_ to be a str, received: {}".format(type(display_name_)))

        if last_connection_ is not None and not isinstance(last_connection_, (bytes, str)):
            raise Exception("Expected last_connection_ to be a str, received: {}".format(type(last_connection_)))

        if user_ is not None and not isinstance(user_, (bytes, str)):
            raise Exception("Expected user_ to be a str, received: {}".format(type(user_)))

        self.access = access_
        self.display_name = display_name_
        self.last_connection = last_connection_
        self.user = user_
        self.unknown_fields = unknown_fields



class ModelUserInfoResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ModelUserInfo
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ModelUserInfo.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ModelUserInfo)):
            raise Exception("Expected result_ to be a ModelUserInfo, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ModelUserInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ModelUserInfoResult]
        '''
        results_ = [ModelUserInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ModelVolumeInfo(Type):
    _toSchema = {'detachable': 'detachable', 'id_': 'id', 'message': 'message', 'provider_id': 'provider-id', 'status': 'status'}
    _toPy = {'detachable': 'detachable', 'id': 'id_', 'message': 'message', 'provider-id': 'provider_id', 'status': 'status'}
    def __init__(self, detachable=None, id_=None, message=None, provider_id=None, status=None, **unknown_fields):
        '''
        detachable : bool
        id_ : str
        message : str
        provider_id : str
        status : str
        '''
        detachable_ = detachable
        id__ = id_
        message_ = message
        provider_id_ = provider_id
        status_ = status

        # Validate arguments against known Juju API types.
        if detachable_ is not None and not isinstance(detachable_, bool):
            raise Exception("Expected detachable_ to be a bool, received: {}".format(type(detachable_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.detachable = detachable_
        self.id_ = id__
        self.message = message_
        self.provider_id = provider_id_
        self.status = status_
        self.unknown_fields = unknown_fields



class ModifyCloudAccess(Type):
    _toSchema = {'access': 'access', 'action': 'action', 'cloud_tag': 'cloud-tag', 'user_tag': 'user-tag'}
    _toPy = {'access': 'access', 'action': 'action', 'cloud-tag': 'cloud_tag', 'user-tag': 'user_tag'}
    def __init__(self, access=None, action=None, cloud_tag=None, user_tag=None, **unknown_fields):
        '''
        access : str
        action : str
        cloud_tag : str
        user_tag : str
        '''
        access_ = access
        action_ = action
        cloud_tag_ = cloud_tag
        user_tag_ = user_tag

        # Validate arguments against known Juju API types.
        if access_ is not None and not isinstance(access_, (bytes, str)):
            raise Exception("Expected access_ to be a str, received: {}".format(type(access_)))

        if action_ is not None and not isinstance(action_, (bytes, str)):
            raise Exception("Expected action_ to be a str, received: {}".format(type(action_)))

        if cloud_tag_ is not None and not isinstance(cloud_tag_, (bytes, str)):
            raise Exception("Expected cloud_tag_ to be a str, received: {}".format(type(cloud_tag_)))

        if user_tag_ is not None and not isinstance(user_tag_, (bytes, str)):
            raise Exception("Expected user_tag_ to be a str, received: {}".format(type(user_tag_)))

        self.access = access_
        self.action = action_
        self.cloud_tag = cloud_tag_
        self.user_tag = user_tag_
        self.unknown_fields = unknown_fields



class ModifyCloudAccessRequest(Type):
    _toSchema = {'changes': 'changes'}
    _toPy = {'changes': 'changes'}
    def __init__(self, changes=None, **unknown_fields):
        '''
        changes : typing.Sequence[~ModifyCloudAccess]
        '''
        changes_ = [ModifyCloudAccess.from_json(o) for o in changes or []]

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        self.changes = changes_
        self.unknown_fields = unknown_fields



class ModifyControllerAccess(Type):
    _toSchema = {'access': 'access', 'action': 'action', 'user_tag': 'user-tag'}
    _toPy = {'access': 'access', 'action': 'action', 'user-tag': 'user_tag'}
    def __init__(self, access=None, action=None, user_tag=None, **unknown_fields):
        '''
        access : str
        action : str
        user_tag : str
        '''
        access_ = access
        action_ = action
        user_tag_ = user_tag

        # Validate arguments against known Juju API types.
        if access_ is not None and not isinstance(access_, (bytes, str)):
            raise Exception("Expected access_ to be a str, received: {}".format(type(access_)))

        if action_ is not None and not isinstance(action_, (bytes, str)):
            raise Exception("Expected action_ to be a str, received: {}".format(type(action_)))

        if user_tag_ is not None and not isinstance(user_tag_, (bytes, str)):
            raise Exception("Expected user_tag_ to be a str, received: {}".format(type(user_tag_)))

        self.access = access_
        self.action = action_
        self.user_tag = user_tag_
        self.unknown_fields = unknown_fields



class ModifyControllerAccessRequest(Type):
    _toSchema = {'changes': 'changes'}
    _toPy = {'changes': 'changes'}
    def __init__(self, changes=None, **unknown_fields):
        '''
        changes : typing.Sequence[~ModifyControllerAccess]
        '''
        changes_ = [ModifyControllerAccess.from_json(o) for o in changes or []]

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        self.changes = changes_
        self.unknown_fields = unknown_fields



class ModifyModelAccess(Type):
    _toSchema = {'access': 'access', 'action': 'action', 'model_tag': 'model-tag', 'user_tag': 'user-tag'}
    _toPy = {'access': 'access', 'action': 'action', 'model-tag': 'model_tag', 'user-tag': 'user_tag'}
    def __init__(self, access=None, action=None, model_tag=None, user_tag=None, **unknown_fields):
        '''
        access : str
        action : str
        model_tag : str
        user_tag : str
        '''
        access_ = access
        action_ = action
        model_tag_ = model_tag
        user_tag_ = user_tag

        # Validate arguments against known Juju API types.
        if access_ is not None and not isinstance(access_, (bytes, str)):
            raise Exception("Expected access_ to be a str, received: {}".format(type(access_)))

        if action_ is not None and not isinstance(action_, (bytes, str)):
            raise Exception("Expected action_ to be a str, received: {}".format(type(action_)))

        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        if user_tag_ is not None and not isinstance(user_tag_, (bytes, str)):
            raise Exception("Expected user_tag_ to be a str, received: {}".format(type(user_tag_)))

        self.access = access_
        self.action = action_
        self.model_tag = model_tag_
        self.user_tag = user_tag_
        self.unknown_fields = unknown_fields



class ModifyModelAccessRequest(Type):
    _toSchema = {'changes': 'changes'}
    _toPy = {'changes': 'changes'}
    def __init__(self, changes=None, **unknown_fields):
        '''
        changes : typing.Sequence[~ModifyModelAccess]
        '''
        changes_ = [ModifyModelAccess.from_json(o) for o in changes or []]

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        self.changes = changes_
        self.unknown_fields = unknown_fields



class ModifyOfferAccess(Type):
    _toSchema = {'access': 'access', 'action': 'action', 'offer_url': 'offer-url', 'user_tag': 'user-tag'}
    _toPy = {'access': 'access', 'action': 'action', 'offer-url': 'offer_url', 'user-tag': 'user_tag'}
    def __init__(self, access=None, action=None, offer_url=None, user_tag=None, **unknown_fields):
        '''
        access : str
        action : str
        offer_url : str
        user_tag : str
        '''
        access_ = access
        action_ = action
        offer_url_ = offer_url
        user_tag_ = user_tag

        # Validate arguments against known Juju API types.
        if access_ is not None and not isinstance(access_, (bytes, str)):
            raise Exception("Expected access_ to be a str, received: {}".format(type(access_)))

        if action_ is not None and not isinstance(action_, (bytes, str)):
            raise Exception("Expected action_ to be a str, received: {}".format(type(action_)))

        if offer_url_ is not None and not isinstance(offer_url_, (bytes, str)):
            raise Exception("Expected offer_url_ to be a str, received: {}".format(type(offer_url_)))

        if user_tag_ is not None and not isinstance(user_tag_, (bytes, str)):
            raise Exception("Expected user_tag_ to be a str, received: {}".format(type(user_tag_)))

        self.access = access_
        self.action = action_
        self.offer_url = offer_url_
        self.user_tag = user_tag_
        self.unknown_fields = unknown_fields



class ModifyOfferAccessRequest(Type):
    _toSchema = {'changes': 'changes'}
    _toPy = {'changes': 'changes'}
    def __init__(self, changes=None, **unknown_fields):
        '''
        changes : typing.Sequence[~ModifyOfferAccess]
        '''
        changes_ = [ModifyOfferAccess.from_json(o) for o in changes or []]

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        self.changes = changes_
        self.unknown_fields = unknown_fields



class ModifyUserSSHKeys(Type):
    _toSchema = {'ssh_keys': 'ssh-keys', 'user': 'user'}
    _toPy = {'ssh-keys': 'ssh_keys', 'user': 'user'}
    def __init__(self, ssh_keys=None, user=None, **unknown_fields):
        '''
        ssh_keys : typing.Sequence[str]
        user : str
        '''
        ssh_keys_ = ssh_keys
        user_ = user

        # Validate arguments against known Juju API types.
        if ssh_keys_ is not None and not isinstance(ssh_keys_, (bytes, str, list)):
            raise Exception("Expected ssh_keys_ to be a Sequence, received: {}".format(type(ssh_keys_)))

        if user_ is not None and not isinstance(user_, (bytes, str)):
            raise Exception("Expected user_ to be a str, received: {}".format(type(user_)))

        self.ssh_keys = ssh_keys_
        self.user = user_
        self.unknown_fields = unknown_fields



class MongoUpgradeResults(Type):
    _toSchema = {'ha_members': 'ha-members', 'master': 'master', 'rs_members': 'rs-members'}
    _toPy = {'ha-members': 'ha_members', 'master': 'master', 'rs-members': 'rs_members'}
    def __init__(self, ha_members=None, master=None, rs_members=None, **unknown_fields):
        '''
        ha_members : typing.Sequence[~HAMember]
        master : HAMember
        rs_members : typing.Sequence[~Member]
        '''
        ha_members_ = [HAMember.from_json(o) for o in ha_members or []]
        master_ = HAMember.from_json(master) if master else None
        rs_members_ = [Member.from_json(o) for o in rs_members or []]

        # Validate arguments against known Juju API types.
        if ha_members_ is not None and not isinstance(ha_members_, (bytes, str, list)):
            raise Exception("Expected ha_members_ to be a Sequence, received: {}".format(type(ha_members_)))

        if master_ is not None and not isinstance(master_, (dict, HAMember)):
            raise Exception("Expected master_ to be a HAMember, received: {}".format(type(master_)))

        if rs_members_ is not None and not isinstance(rs_members_, (bytes, str, list)):
            raise Exception("Expected rs_members_ to be a Sequence, received: {}".format(type(rs_members_)))

        self.ha_members = ha_members_
        self.master = master_
        self.rs_members = rs_members_
        self.unknown_fields = unknown_fields



class MongoVersion(Type):
    _toSchema = {'engine': 'engine', 'major': 'major', 'minor': 'minor', 'patch': 'patch'}
    _toPy = {'engine': 'engine', 'major': 'major', 'minor': 'minor', 'patch': 'patch'}
    def __init__(self, engine=None, major=None, minor=None, patch=None, **unknown_fields):
        '''
        engine : str
        major : int
        minor : int
        patch : str
        '''
        engine_ = engine
        major_ = major
        minor_ = minor
        patch_ = patch

        # Validate arguments against known Juju API types.
        if engine_ is not None and not isinstance(engine_, (bytes, str)):
            raise Exception("Expected engine_ to be a str, received: {}".format(type(engine_)))

        if major_ is not None and not isinstance(major_, int):
            raise Exception("Expected major_ to be a int, received: {}".format(type(major_)))

        if minor_ is not None and not isinstance(minor_, int):
            raise Exception("Expected minor_ to be a int, received: {}".format(type(minor_)))

        if patch_ is not None and not isinstance(patch_, (bytes, str)):
            raise Exception("Expected patch_ to be a str, received: {}".format(type(patch_)))

        self.engine = engine_
        self.major = major_
        self.minor = minor_
        self.patch = patch_
        self.unknown_fields = unknown_fields



class MoveSubnetsParam(Type):
    _toSchema = {'force': 'force', 'space_tag': 'space-tag', 'subnets': 'subnets'}
    _toPy = {'force': 'force', 'space-tag': 'space_tag', 'subnets': 'subnets'}
    def __init__(self, force=None, space_tag=None, subnets=None, **unknown_fields):
        '''
        force : bool
        space_tag : str
        subnets : typing.Sequence[str]
        '''
        force_ = force
        space_tag_ = space_tag
        subnets_ = subnets

        # Validate arguments against known Juju API types.
        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if space_tag_ is not None and not isinstance(space_tag_, (bytes, str)):
            raise Exception("Expected space_tag_ to be a str, received: {}".format(type(space_tag_)))

        if subnets_ is not None and not isinstance(subnets_, (bytes, str, list)):
            raise Exception("Expected subnets_ to be a Sequence, received: {}".format(type(subnets_)))

        self.force = force_
        self.space_tag = space_tag_
        self.subnets = subnets_
        self.unknown_fields = unknown_fields



class MoveSubnetsParams(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~MoveSubnetsParam]
        '''
        args_ = [MoveSubnetsParam.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class MoveSubnetsResult(Type):
    _toSchema = {'error': 'error', 'moved_subnets': 'moved-subnets', 'new_space': 'new-space'}
    _toPy = {'error': 'error', 'moved-subnets': 'moved_subnets', 'new-space': 'new_space'}
    def __init__(self, error=None, moved_subnets=None, new_space=None, **unknown_fields):
        '''
        error : Error
        moved_subnets : typing.Sequence[~MovedSubnet]
        new_space : str
        '''
        error_ = Error.from_json(error) if error else None
        moved_subnets_ = [MovedSubnet.from_json(o) for o in moved_subnets or []]
        new_space_ = new_space

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if moved_subnets_ is not None and not isinstance(moved_subnets_, (bytes, str, list)):
            raise Exception("Expected moved_subnets_ to be a Sequence, received: {}".format(type(moved_subnets_)))

        if new_space_ is not None and not isinstance(new_space_, (bytes, str)):
            raise Exception("Expected new_space_ to be a str, received: {}".format(type(new_space_)))

        self.error = error_
        self.moved_subnets = moved_subnets_
        self.new_space = new_space_
        self.unknown_fields = unknown_fields



class MoveSubnetsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~MoveSubnetsResult]
        '''
        results_ = [MoveSubnetsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class MovedSubnet(Type):
    _toSchema = {'cidr': 'cidr', 'old_space': 'old-space', 'subnet': 'subnet'}
    _toPy = {'cidr': 'cidr', 'old-space': 'old_space', 'subnet': 'subnet'}
    def __init__(self, cidr=None, old_space=None, subnet=None, **unknown_fields):
        '''
        cidr : str
        old_space : str
        subnet : str
        '''
        cidr_ = cidr
        old_space_ = old_space
        subnet_ = subnet

        # Validate arguments against known Juju API types.
        if cidr_ is not None and not isinstance(cidr_, (bytes, str)):
            raise Exception("Expected cidr_ to be a str, received: {}".format(type(cidr_)))

        if old_space_ is not None and not isinstance(old_space_, (bytes, str)):
            raise Exception("Expected old_space_ to be a str, received: {}".format(type(old_space_)))

        if subnet_ is not None and not isinstance(subnet_, (bytes, str)):
            raise Exception("Expected subnet_ to be a str, received: {}".format(type(subnet_)))

        self.cidr = cidr_
        self.old_space = old_space_
        self.subnet = subnet_
        self.unknown_fields = unknown_fields



class NetworkConfig(Type):
    _toSchema = {'address': 'address', 'addresses': 'addresses', 'cidr': 'cidr', 'config_type': 'config-type', 'device_index': 'device-index', 'disabled': 'disabled', 'dns_search_domains': 'dns-search-domains', 'dns_servers': 'dns-servers', 'gateway_address': 'gateway-address', 'interface_name': 'interface-name', 'interface_type': 'interface-type', 'is_default_gateway': 'is-default-gateway', 'mac_address': 'mac-address', 'mtu': 'mtu', 'no_auto_start': 'no-auto-start', 'origin': 'origin', 'parent_interface_name': 'parent-interface-name', 'provider_address_id': 'provider-address-id', 'provider_id': 'provider-id', 'provider_network_id': 'provider-network-id', 'provider_space_id': 'provider-space-id', 'provider_subnet_id': 'provider-subnet-id', 'provider_vlan_id': 'provider-vlan-id', 'routes': 'routes', 'shadow_addresses': 'shadow-addresses', 'vlan_tag': 'vlan-tag'}
    _toPy = {'address': 'address', 'addresses': 'addresses', 'cidr': 'cidr', 'config-type': 'config_type', 'device-index': 'device_index', 'disabled': 'disabled', 'dns-search-domains': 'dns_search_domains', 'dns-servers': 'dns_servers', 'gateway-address': 'gateway_address', 'interface-name': 'interface_name', 'interface-type': 'interface_type', 'is-default-gateway': 'is_default_gateway', 'mac-address': 'mac_address', 'mtu': 'mtu', 'no-auto-start': 'no_auto_start', 'origin': 'origin', 'parent-interface-name': 'parent_interface_name', 'provider-address-id': 'provider_address_id', 'provider-id': 'provider_id', 'provider-network-id': 'provider_network_id', 'provider-space-id': 'provider_space_id', 'provider-subnet-id': 'provider_subnet_id', 'provider-vlan-id': 'provider_vlan_id', 'routes': 'routes', 'shadow-addresses': 'shadow_addresses', 'vlan-tag': 'vlan_tag'}
    def __init__(self, address=None, addresses=None, cidr=None, config_type=None, device_index=None, disabled=None, dns_search_domains=None, dns_servers=None, gateway_address=None, interface_name=None, interface_type=None, is_default_gateway=None, mac_address=None, mtu=None, no_auto_start=None, origin=None, parent_interface_name=None, provider_address_id=None, provider_id=None, provider_network_id=None, provider_space_id=None, provider_subnet_id=None, provider_vlan_id=None, routes=None, shadow_addresses=None, vlan_tag=None, **unknown_fields):
        '''
        address : str
        addresses : typing.Sequence[~Address]
        cidr : str
        config_type : str
        device_index : int
        disabled : bool
        dns_search_domains : typing.Sequence[str]
        dns_servers : typing.Sequence[str]
        gateway_address : str
        interface_name : str
        interface_type : str
        is_default_gateway : bool
        mac_address : str
        mtu : int
        no_auto_start : bool
        origin : str
        parent_interface_name : str
        provider_address_id : str
        provider_id : str
        provider_network_id : str
        provider_space_id : str
        provider_subnet_id : str
        provider_vlan_id : str
        routes : typing.Sequence[~NetworkRoute]
        shadow_addresses : typing.Sequence[~Address]
        vlan_tag : int
        '''
        address_ = address
        addresses_ = [Address.from_json(o) for o in addresses or []]
        cidr_ = cidr
        config_type_ = config_type
        device_index_ = device_index
        disabled_ = disabled
        dns_search_domains_ = dns_search_domains
        dns_servers_ = dns_servers
        gateway_address_ = gateway_address
        interface_name_ = interface_name
        interface_type_ = interface_type
        is_default_gateway_ = is_default_gateway
        mac_address_ = mac_address
        mtu_ = mtu
        no_auto_start_ = no_auto_start
        origin_ = origin
        parent_interface_name_ = parent_interface_name
        provider_address_id_ = provider_address_id
        provider_id_ = provider_id
        provider_network_id_ = provider_network_id
        provider_space_id_ = provider_space_id
        provider_subnet_id_ = provider_subnet_id
        provider_vlan_id_ = provider_vlan_id
        routes_ = [NetworkRoute.from_json(o) for o in routes or []]
        shadow_addresses_ = [Address.from_json(o) for o in shadow_addresses or []]
        vlan_tag_ = vlan_tag

        # Validate arguments against known Juju API types.
        if address_ is not None and not isinstance(address_, (bytes, str)):
            raise Exception("Expected address_ to be a str, received: {}".format(type(address_)))

        if addresses_ is not None and not isinstance(addresses_, (bytes, str, list)):
            raise Exception("Expected addresses_ to be a Sequence, received: {}".format(type(addresses_)))

        if cidr_ is not None and not isinstance(cidr_, (bytes, str)):
            raise Exception("Expected cidr_ to be a str, received: {}".format(type(cidr_)))

        if config_type_ is not None and not isinstance(config_type_, (bytes, str)):
            raise Exception("Expected config_type_ to be a str, received: {}".format(type(config_type_)))

        if device_index_ is not None and not isinstance(device_index_, int):
            raise Exception("Expected device_index_ to be a int, received: {}".format(type(device_index_)))

        if disabled_ is not None and not isinstance(disabled_, bool):
            raise Exception("Expected disabled_ to be a bool, received: {}".format(type(disabled_)))

        if dns_search_domains_ is not None and not isinstance(dns_search_domains_, (bytes, str, list)):
            raise Exception("Expected dns_search_domains_ to be a Sequence, received: {}".format(type(dns_search_domains_)))

        if dns_servers_ is not None and not isinstance(dns_servers_, (bytes, str, list)):
            raise Exception("Expected dns_servers_ to be a Sequence, received: {}".format(type(dns_servers_)))

        if gateway_address_ is not None and not isinstance(gateway_address_, (bytes, str)):
            raise Exception("Expected gateway_address_ to be a str, received: {}".format(type(gateway_address_)))

        if interface_name_ is not None and not isinstance(interface_name_, (bytes, str)):
            raise Exception("Expected interface_name_ to be a str, received: {}".format(type(interface_name_)))

        if interface_type_ is not None and not isinstance(interface_type_, (bytes, str)):
            raise Exception("Expected interface_type_ to be a str, received: {}".format(type(interface_type_)))

        if is_default_gateway_ is not None and not isinstance(is_default_gateway_, bool):
            raise Exception("Expected is_default_gateway_ to be a bool, received: {}".format(type(is_default_gateway_)))

        if mac_address_ is not None and not isinstance(mac_address_, (bytes, str)):
            raise Exception("Expected mac_address_ to be a str, received: {}".format(type(mac_address_)))

        if mtu_ is not None and not isinstance(mtu_, int):
            raise Exception("Expected mtu_ to be a int, received: {}".format(type(mtu_)))

        if no_auto_start_ is not None and not isinstance(no_auto_start_, bool):
            raise Exception("Expected no_auto_start_ to be a bool, received: {}".format(type(no_auto_start_)))

        if origin_ is not None and not isinstance(origin_, (bytes, str)):
            raise Exception("Expected origin_ to be a str, received: {}".format(type(origin_)))

        if parent_interface_name_ is not None and not isinstance(parent_interface_name_, (bytes, str)):
            raise Exception("Expected parent_interface_name_ to be a str, received: {}".format(type(parent_interface_name_)))

        if provider_address_id_ is not None and not isinstance(provider_address_id_, (bytes, str)):
            raise Exception("Expected provider_address_id_ to be a str, received: {}".format(type(provider_address_id_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if provider_network_id_ is not None and not isinstance(provider_network_id_, (bytes, str)):
            raise Exception("Expected provider_network_id_ to be a str, received: {}".format(type(provider_network_id_)))

        if provider_space_id_ is not None and not isinstance(provider_space_id_, (bytes, str)):
            raise Exception("Expected provider_space_id_ to be a str, received: {}".format(type(provider_space_id_)))

        if provider_subnet_id_ is not None and not isinstance(provider_subnet_id_, (bytes, str)):
            raise Exception("Expected provider_subnet_id_ to be a str, received: {}".format(type(provider_subnet_id_)))

        if provider_vlan_id_ is not None and not isinstance(provider_vlan_id_, (bytes, str)):
            raise Exception("Expected provider_vlan_id_ to be a str, received: {}".format(type(provider_vlan_id_)))

        if routes_ is not None and not isinstance(routes_, (bytes, str, list)):
            raise Exception("Expected routes_ to be a Sequence, received: {}".format(type(routes_)))

        if shadow_addresses_ is not None and not isinstance(shadow_addresses_, (bytes, str, list)):
            raise Exception("Expected shadow_addresses_ to be a Sequence, received: {}".format(type(shadow_addresses_)))

        if vlan_tag_ is not None and not isinstance(vlan_tag_, int):
            raise Exception("Expected vlan_tag_ to be a int, received: {}".format(type(vlan_tag_)))

        self.address = address_
        self.addresses = addresses_
        self.cidr = cidr_
        self.config_type = config_type_
        self.device_index = device_index_
        self.disabled = disabled_
        self.dns_search_domains = dns_search_domains_
        self.dns_servers = dns_servers_
        self.gateway_address = gateway_address_
        self.interface_name = interface_name_
        self.interface_type = interface_type_
        self.is_default_gateway = is_default_gateway_
        self.mac_address = mac_address_
        self.mtu = mtu_
        self.no_auto_start = no_auto_start_
        self.origin = origin_
        self.parent_interface_name = parent_interface_name_
        self.provider_address_id = provider_address_id_
        self.provider_id = provider_id_
        self.provider_network_id = provider_network_id_
        self.provider_space_id = provider_space_id_
        self.provider_subnet_id = provider_subnet_id_
        self.provider_vlan_id = provider_vlan_id_
        self.routes = routes_
        self.shadow_addresses = shadow_addresses_
        self.vlan_tag = vlan_tag_
        self.unknown_fields = unknown_fields



class NetworkInfo(Type):
    _toSchema = {'addresses': 'addresses', 'interface_name': 'interface-name', 'mac_address': 'mac-address'}
    _toPy = {'addresses': 'addresses', 'interface-name': 'interface_name', 'mac-address': 'mac_address'}
    def __init__(self, addresses=None, interface_name=None, mac_address=None, **unknown_fields):
        '''
        addresses : typing.Sequence[~InterfaceAddress]
        interface_name : str
        mac_address : str
        '''
        addresses_ = [InterfaceAddress.from_json(o) for o in addresses or []]
        interface_name_ = interface_name
        mac_address_ = mac_address

        # Validate arguments against known Juju API types.
        if addresses_ is not None and not isinstance(addresses_, (bytes, str, list)):
            raise Exception("Expected addresses_ to be a Sequence, received: {}".format(type(addresses_)))

        if interface_name_ is not None and not isinstance(interface_name_, (bytes, str)):
            raise Exception("Expected interface_name_ to be a str, received: {}".format(type(interface_name_)))

        if mac_address_ is not None and not isinstance(mac_address_, (bytes, str)):
            raise Exception("Expected mac_address_ to be a str, received: {}".format(type(mac_address_)))

        self.addresses = addresses_
        self.interface_name = interface_name_
        self.mac_address = mac_address_
        self.unknown_fields = unknown_fields



class NetworkInfoParams(Type):
    _toSchema = {'bindings': 'bindings', 'relation_id': 'relation-id', 'unit': 'unit'}
    _toPy = {'bindings': 'bindings', 'relation-id': 'relation_id', 'unit': 'unit'}
    def __init__(self, bindings=None, relation_id=None, unit=None, **unknown_fields):
        '''
        bindings : typing.Sequence[str]
        relation_id : int
        unit : str
        '''
        bindings_ = bindings
        relation_id_ = relation_id
        unit_ = unit

        # Validate arguments against known Juju API types.
        if bindings_ is not None and not isinstance(bindings_, (bytes, str, list)):
            raise Exception("Expected bindings_ to be a Sequence, received: {}".format(type(bindings_)))

        if relation_id_ is not None and not isinstance(relation_id_, int):
            raise Exception("Expected relation_id_ to be a int, received: {}".format(type(relation_id_)))

        if unit_ is not None and not isinstance(unit_, (bytes, str)):
            raise Exception("Expected unit_ to be a str, received: {}".format(type(unit_)))

        self.bindings = bindings_
        self.relation_id = relation_id_
        self.unit = unit_
        self.unknown_fields = unknown_fields



class NetworkInfoResult(Type):
    _toSchema = {'bind_addresses': 'bind-addresses', 'egress_subnets': 'egress-subnets', 'error': 'error', 'ingress_addresses': 'ingress-addresses'}
    _toPy = {'bind-addresses': 'bind_addresses', 'egress-subnets': 'egress_subnets', 'error': 'error', 'ingress-addresses': 'ingress_addresses'}
    def __init__(self, bind_addresses=None, egress_subnets=None, error=None, ingress_addresses=None, **unknown_fields):
        '''
        bind_addresses : typing.Sequence[~NetworkInfo]
        egress_subnets : typing.Sequence[str]
        error : Error
        ingress_addresses : typing.Sequence[str]
        '''
        bind_addresses_ = [NetworkInfo.from_json(o) for o in bind_addresses or []]
        egress_subnets_ = egress_subnets
        error_ = Error.from_json(error) if error else None
        ingress_addresses_ = ingress_addresses

        # Validate arguments against known Juju API types.
        if bind_addresses_ is not None and not isinstance(bind_addresses_, (bytes, str, list)):
            raise Exception("Expected bind_addresses_ to be a Sequence, received: {}".format(type(bind_addresses_)))

        if egress_subnets_ is not None and not isinstance(egress_subnets_, (bytes, str, list)):
            raise Exception("Expected egress_subnets_ to be a Sequence, received: {}".format(type(egress_subnets_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if ingress_addresses_ is not None and not isinstance(ingress_addresses_, (bytes, str, list)):
            raise Exception("Expected ingress_addresses_ to be a Sequence, received: {}".format(type(ingress_addresses_)))

        self.bind_addresses = bind_addresses_
        self.egress_subnets = egress_subnets_
        self.error = error_
        self.ingress_addresses = ingress_addresses_
        self.unknown_fields = unknown_fields



class NetworkInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Mapping[str, ~NetworkInfoResult]
        '''
        results_ = {k: NetworkInfoResult.from_json(v) for k, v in (results or dict()).items()}

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, dict):
            raise Exception("Expected results_ to be a Mapping, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class NetworkInterface(Type):
    _toSchema = {'dns_nameservers': 'dns-nameservers', 'gateway': 'gateway', 'ip_addresses': 'ip-addresses', 'is_up': 'is-up', 'mac_address': 'mac-address', 'space': 'space'}
    _toPy = {'dns-nameservers': 'dns_nameservers', 'gateway': 'gateway', 'ip-addresses': 'ip_addresses', 'is-up': 'is_up', 'mac-address': 'mac_address', 'space': 'space'}
    def __init__(self, dns_nameservers=None, gateway=None, ip_addresses=None, is_up=None, mac_address=None, space=None, **unknown_fields):
        '''
        dns_nameservers : typing.Sequence[str]
        gateway : str
        ip_addresses : typing.Sequence[str]
        is_up : bool
        mac_address : str
        space : str
        '''
        dns_nameservers_ = dns_nameservers
        gateway_ = gateway
        ip_addresses_ = ip_addresses
        is_up_ = is_up
        mac_address_ = mac_address
        space_ = space

        # Validate arguments against known Juju API types.
        if dns_nameservers_ is not None and not isinstance(dns_nameservers_, (bytes, str, list)):
            raise Exception("Expected dns_nameservers_ to be a Sequence, received: {}".format(type(dns_nameservers_)))

        if gateway_ is not None and not isinstance(gateway_, (bytes, str)):
            raise Exception("Expected gateway_ to be a str, received: {}".format(type(gateway_)))

        if ip_addresses_ is not None and not isinstance(ip_addresses_, (bytes, str, list)):
            raise Exception("Expected ip_addresses_ to be a Sequence, received: {}".format(type(ip_addresses_)))

        if is_up_ is not None and not isinstance(is_up_, bool):
            raise Exception("Expected is_up_ to be a bool, received: {}".format(type(is_up_)))

        if mac_address_ is not None and not isinstance(mac_address_, (bytes, str)):
            raise Exception("Expected mac_address_ to be a str, received: {}".format(type(mac_address_)))

        if space_ is not None and not isinstance(space_, (bytes, str)):
            raise Exception("Expected space_ to be a str, received: {}".format(type(space_)))

        self.dns_nameservers = dns_nameservers_
        self.gateway = gateway_
        self.ip_addresses = ip_addresses_
        self.is_up = is_up_
        self.mac_address = mac_address_
        self.space = space_
        self.unknown_fields = unknown_fields



class NetworkRoute(Type):
    _toSchema = {'destination_cidr': 'destination-cidr', 'gateway_ip': 'gateway-ip', 'metric': 'metric'}
    _toPy = {'destination-cidr': 'destination_cidr', 'gateway-ip': 'gateway_ip', 'metric': 'metric'}
    def __init__(self, destination_cidr=None, gateway_ip=None, metric=None, **unknown_fields):
        '''
        destination_cidr : str
        gateway_ip : str
        metric : int
        '''
        destination_cidr_ = destination_cidr
        gateway_ip_ = gateway_ip
        metric_ = metric

        # Validate arguments against known Juju API types.
        if destination_cidr_ is not None and not isinstance(destination_cidr_, (bytes, str)):
            raise Exception("Expected destination_cidr_ to be a str, received: {}".format(type(destination_cidr_)))

        if gateway_ip_ is not None and not isinstance(gateway_ip_, (bytes, str)):
            raise Exception("Expected gateway_ip_ to be a str, received: {}".format(type(gateway_ip_)))

        if metric_ is not None and not isinstance(metric_, int):
            raise Exception("Expected metric_ to be a int, received: {}".format(type(metric_)))

        self.destination_cidr = destination_cidr_
        self.gateway_ip = gateway_ip_
        self.metric = metric_
        self.unknown_fields = unknown_fields



class NotifyWatchResult(Type):
    _toSchema = {'error': 'error', 'notifywatcherid': 'NotifyWatcherId'}
    _toPy = {'NotifyWatcherId': 'notifywatcherid', 'error': 'error'}
    def __init__(self, notifywatcherid=None, error=None, **unknown_fields):
        '''
        notifywatcherid : str
        error : Error
        '''
        notifywatcherid_ = notifywatcherid
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if notifywatcherid_ is not None and not isinstance(notifywatcherid_, (bytes, str)):
            raise Exception("Expected notifywatcherid_ to be a str, received: {}".format(type(notifywatcherid_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.notifywatcherid = notifywatcherid_
        self.error = error_
        self.unknown_fields = unknown_fields



class NotifyWatchResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~NotifyWatchResult]
        '''
        results_ = [NotifyWatchResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class Number(Type):
    _toSchema = {'build': 'Build', 'major': 'Major', 'minor': 'Minor', 'patch': 'Patch', 'tag': 'Tag'}
    _toPy = {'Build': 'build', 'Major': 'major', 'Minor': 'minor', 'Patch': 'patch', 'Tag': 'tag'}
    def __init__(self, build=None, major=None, minor=None, patch=None, tag=None, **unknown_fields):
        '''
        build : int
        major : int
        minor : int
        patch : int
        tag : str
        '''
        build_ = build
        major_ = major
        minor_ = minor
        patch_ = patch
        tag_ = tag

        # Validate arguments against known Juju API types.
        if build_ is not None and not isinstance(build_, int):
            raise Exception("Expected build_ to be a int, received: {}".format(type(build_)))

        if major_ is not None and not isinstance(major_, int):
            raise Exception("Expected major_ to be a int, received: {}".format(type(major_)))

        if minor_ is not None and not isinstance(minor_, int):
            raise Exception("Expected minor_ to be a int, received: {}".format(type(minor_)))

        if patch_ is not None and not isinstance(patch_, int):
            raise Exception("Expected patch_ to be a int, received: {}".format(type(patch_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.build = build_
        self.major = major_
        self.minor = minor_
        self.patch = patch_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class OfferArg(Type):
    _toSchema = {'bakery_version': 'bakery-version', 'macaroons': 'macaroons', 'offer_uuid': 'offer-uuid'}
    _toPy = {'bakery-version': 'bakery_version', 'macaroons': 'macaroons', 'offer-uuid': 'offer_uuid'}
    def __init__(self, bakery_version=None, macaroons=None, offer_uuid=None, **unknown_fields):
        '''
        bakery_version : int
        macaroons : typing.Sequence[~Macaroon]
        offer_uuid : str
        '''
        bakery_version_ = bakery_version
        macaroons_ = [Macaroon.from_json(o) for o in macaroons or []]
        offer_uuid_ = offer_uuid

        # Validate arguments against known Juju API types.
        if bakery_version_ is not None and not isinstance(bakery_version_, int):
            raise Exception("Expected bakery_version_ to be a int, received: {}".format(type(bakery_version_)))

        if macaroons_ is not None and not isinstance(macaroons_, (bytes, str, list)):
            raise Exception("Expected macaroons_ to be a Sequence, received: {}".format(type(macaroons_)))

        if offer_uuid_ is not None and not isinstance(offer_uuid_, (bytes, str)):
            raise Exception("Expected offer_uuid_ to be a str, received: {}".format(type(offer_uuid_)))

        self.bakery_version = bakery_version_
        self.macaroons = macaroons_
        self.offer_uuid = offer_uuid_
        self.unknown_fields = unknown_fields



class OfferArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~OfferArg]
        '''
        args_ = [OfferArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class OfferConnection(Type):
    _toSchema = {'endpoint': 'endpoint', 'ingress_subnets': 'ingress-subnets', 'relation_id': 'relation-id', 'source_model_tag': 'source-model-tag', 'status': 'status', 'username': 'username'}
    _toPy = {'endpoint': 'endpoint', 'ingress-subnets': 'ingress_subnets', 'relation-id': 'relation_id', 'source-model-tag': 'source_model_tag', 'status': 'status', 'username': 'username'}
    def __init__(self, endpoint=None, ingress_subnets=None, relation_id=None, source_model_tag=None, status=None, username=None, **unknown_fields):
        '''
        endpoint : str
        ingress_subnets : typing.Sequence[str]
        relation_id : int
        source_model_tag : str
        status : EntityStatus
        username : str
        '''
        endpoint_ = endpoint
        ingress_subnets_ = ingress_subnets
        relation_id_ = relation_id
        source_model_tag_ = source_model_tag
        status_ = EntityStatus.from_json(status) if status else None
        username_ = username

        # Validate arguments against known Juju API types.
        if endpoint_ is not None and not isinstance(endpoint_, (bytes, str)):
            raise Exception("Expected endpoint_ to be a str, received: {}".format(type(endpoint_)))

        if ingress_subnets_ is not None and not isinstance(ingress_subnets_, (bytes, str, list)):
            raise Exception("Expected ingress_subnets_ to be a Sequence, received: {}".format(type(ingress_subnets_)))

        if relation_id_ is not None and not isinstance(relation_id_, int):
            raise Exception("Expected relation_id_ to be a int, received: {}".format(type(relation_id_)))

        if source_model_tag_ is not None and not isinstance(source_model_tag_, (bytes, str)):
            raise Exception("Expected source_model_tag_ to be a str, received: {}".format(type(source_model_tag_)))

        if status_ is not None and not isinstance(status_, (dict, EntityStatus)):
            raise Exception("Expected status_ to be a EntityStatus, received: {}".format(type(status_)))

        if username_ is not None and not isinstance(username_, (bytes, str)):
            raise Exception("Expected username_ to be a str, received: {}".format(type(username_)))

        self.endpoint = endpoint_
        self.ingress_subnets = ingress_subnets_
        self.relation_id = relation_id_
        self.source_model_tag = source_model_tag_
        self.status = status_
        self.username = username_
        self.unknown_fields = unknown_fields



class OfferFilter(Type):
    _toSchema = {'allowed_users': 'allowed-users', 'application_description': 'application-description', 'application_name': 'application-name', 'application_user': 'application-user', 'connected_users': 'connected-users', 'endpoints': 'endpoints', 'model_name': 'model-name', 'offer_name': 'offer-name', 'owner_name': 'owner-name'}
    _toPy = {'allowed-users': 'allowed_users', 'application-description': 'application_description', 'application-name': 'application_name', 'application-user': 'application_user', 'connected-users': 'connected_users', 'endpoints': 'endpoints', 'model-name': 'model_name', 'offer-name': 'offer_name', 'owner-name': 'owner_name'}
    def __init__(self, allowed_users=None, application_description=None, application_name=None, application_user=None, connected_users=None, endpoints=None, model_name=None, offer_name=None, owner_name=None, **unknown_fields):
        '''
        allowed_users : typing.Sequence[str]
        application_description : str
        application_name : str
        application_user : str
        connected_users : typing.Sequence[str]
        endpoints : typing.Sequence[~EndpointFilterAttributes]
        model_name : str
        offer_name : str
        owner_name : str
        '''
        allowed_users_ = allowed_users
        application_description_ = application_description
        application_name_ = application_name
        application_user_ = application_user
        connected_users_ = connected_users
        endpoints_ = [EndpointFilterAttributes.from_json(o) for o in endpoints or []]
        model_name_ = model_name
        offer_name_ = offer_name
        owner_name_ = owner_name

        # Validate arguments against known Juju API types.
        if allowed_users_ is not None and not isinstance(allowed_users_, (bytes, str, list)):
            raise Exception("Expected allowed_users_ to be a Sequence, received: {}".format(type(allowed_users_)))

        if application_description_ is not None and not isinstance(application_description_, (bytes, str)):
            raise Exception("Expected application_description_ to be a str, received: {}".format(type(application_description_)))

        if application_name_ is not None and not isinstance(application_name_, (bytes, str)):
            raise Exception("Expected application_name_ to be a str, received: {}".format(type(application_name_)))

        if application_user_ is not None and not isinstance(application_user_, (bytes, str)):
            raise Exception("Expected application_user_ to be a str, received: {}".format(type(application_user_)))

        if connected_users_ is not None and not isinstance(connected_users_, (bytes, str, list)):
            raise Exception("Expected connected_users_ to be a Sequence, received: {}".format(type(connected_users_)))

        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if model_name_ is not None and not isinstance(model_name_, (bytes, str)):
            raise Exception("Expected model_name_ to be a str, received: {}".format(type(model_name_)))

        if offer_name_ is not None and not isinstance(offer_name_, (bytes, str)):
            raise Exception("Expected offer_name_ to be a str, received: {}".format(type(offer_name_)))

        if owner_name_ is not None and not isinstance(owner_name_, (bytes, str)):
            raise Exception("Expected owner_name_ to be a str, received: {}".format(type(owner_name_)))

        self.allowed_users = allowed_users_
        self.application_description = application_description_
        self.application_name = application_name_
        self.application_user = application_user_
        self.connected_users = connected_users_
        self.endpoints = endpoints_
        self.model_name = model_name_
        self.offer_name = offer_name_
        self.owner_name = owner_name_
        self.unknown_fields = unknown_fields



class OfferFilters(Type):
    _toSchema = {'filters': 'Filters'}
    _toPy = {'Filters': 'filters'}
    def __init__(self, filters=None, **unknown_fields):
        '''
        filters : typing.Sequence[~OfferFilter]
        '''
        filters_ = [OfferFilter.from_json(o) for o in filters or []]

        # Validate arguments against known Juju API types.
        if filters_ is not None and not isinstance(filters_, (bytes, str, list)):
            raise Exception("Expected filters_ to be a Sequence, received: {}".format(type(filters_)))

        self.filters = filters_
        self.unknown_fields = unknown_fields



class OfferStatusChange(Type):
    _toSchema = {'offer_name': 'offer-name', 'status': 'status'}
    _toPy = {'offer-name': 'offer_name', 'status': 'status'}
    def __init__(self, offer_name=None, status=None, **unknown_fields):
        '''
        offer_name : str
        status : EntityStatus
        '''
        offer_name_ = offer_name
        status_ = EntityStatus.from_json(status) if status else None

        # Validate arguments against known Juju API types.
        if offer_name_ is not None and not isinstance(offer_name_, (bytes, str)):
            raise Exception("Expected offer_name_ to be a str, received: {}".format(type(offer_name_)))

        if status_ is not None and not isinstance(status_, (dict, EntityStatus)):
            raise Exception("Expected status_ to be a EntityStatus, received: {}".format(type(status_)))

        self.offer_name = offer_name_
        self.status = status_
        self.unknown_fields = unknown_fields



class OfferStatusWatchResult(Type):
    _toSchema = {'changes': 'changes', 'error': 'error', 'watcher_id': 'watcher-id'}
    _toPy = {'changes': 'changes', 'error': 'error', 'watcher-id': 'watcher_id'}
    def __init__(self, changes=None, error=None, watcher_id=None, **unknown_fields):
        '''
        changes : typing.Sequence[~OfferStatusChange]
        error : Error
        watcher_id : str
        '''
        changes_ = [OfferStatusChange.from_json(o) for o in changes or []]
        error_ = Error.from_json(error) if error else None
        watcher_id_ = watcher_id

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if watcher_id_ is not None and not isinstance(watcher_id_, (bytes, str)):
            raise Exception("Expected watcher_id_ to be a str, received: {}".format(type(watcher_id_)))

        self.changes = changes_
        self.error = error_
        self.watcher_id = watcher_id_
        self.unknown_fields = unknown_fields



class OfferStatusWatchResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~OfferStatusWatchResult]
        '''
        results_ = [OfferStatusWatchResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class OfferURLs(Type):
    _toSchema = {'bakery_version': 'bakery-version', 'offer_urls': 'offer-urls'}
    _toPy = {'bakery-version': 'bakery_version', 'offer-urls': 'offer_urls'}
    def __init__(self, bakery_version=None, offer_urls=None, **unknown_fields):
        '''
        bakery_version : int
        offer_urls : typing.Sequence[str]
        '''
        bakery_version_ = bakery_version
        offer_urls_ = offer_urls

        # Validate arguments against known Juju API types.
        if bakery_version_ is not None and not isinstance(bakery_version_, int):
            raise Exception("Expected bakery_version_ to be a int, received: {}".format(type(bakery_version_)))

        if offer_urls_ is not None and not isinstance(offer_urls_, (bytes, str, list)):
            raise Exception("Expected offer_urls_ to be a Sequence, received: {}".format(type(offer_urls_)))

        self.bakery_version = bakery_version_
        self.offer_urls = offer_urls_
        self.unknown_fields = unknown_fields



class OfferUserDetails(Type):
    _toSchema = {'access': 'access', 'display_name': 'display-name', 'user': 'user'}
    _toPy = {'access': 'access', 'display-name': 'display_name', 'user': 'user'}
    def __init__(self, access=None, display_name=None, user=None, **unknown_fields):
        '''
        access : str
        display_name : str
        user : str
        '''
        access_ = access
        display_name_ = display_name
        user_ = user

        # Validate arguments against known Juju API types.
        if access_ is not None and not isinstance(access_, (bytes, str)):
            raise Exception("Expected access_ to be a str, received: {}".format(type(access_)))

        if display_name_ is not None and not isinstance(display_name_, (bytes, str)):
            raise Exception("Expected display_name_ to be a str, received: {}".format(type(display_name_)))

        if user_ is not None and not isinstance(user_, (bytes, str)):
            raise Exception("Expected user_ to be a str, received: {}".format(type(user_)))

        self.access = access_
        self.display_name = display_name_
        self.user = user_
        self.unknown_fields = unknown_fields



class OperationQueryArgs(Type):
    _toSchema = {'actions': 'actions', 'applications': 'applications', 'limit': 'limit', 'offset': 'offset', 'status': 'status', 'units': 'units'}
    _toPy = {'actions': 'actions', 'applications': 'applications', 'limit': 'limit', 'offset': 'offset', 'status': 'status', 'units': 'units'}
    def __init__(self, actions=None, applications=None, limit=None, offset=None, status=None, units=None, **unknown_fields):
        '''
        actions : typing.Sequence[str]
        applications : typing.Sequence[str]
        limit : int
        offset : int
        status : typing.Sequence[str]
        units : typing.Sequence[str]
        '''
        actions_ = actions
        applications_ = applications
        limit_ = limit
        offset_ = offset
        status_ = status
        units_ = units

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (bytes, str, list)):
            raise Exception("Expected actions_ to be a Sequence, received: {}".format(type(actions_)))

        if applications_ is not None and not isinstance(applications_, (bytes, str, list)):
            raise Exception("Expected applications_ to be a Sequence, received: {}".format(type(applications_)))

        if limit_ is not None and not isinstance(limit_, int):
            raise Exception("Expected limit_ to be a int, received: {}".format(type(limit_)))

        if offset_ is not None and not isinstance(offset_, int):
            raise Exception("Expected offset_ to be a int, received: {}".format(type(offset_)))

        if status_ is not None and not isinstance(status_, (bytes, str, list)):
            raise Exception("Expected status_ to be a Sequence, received: {}".format(type(status_)))

        if units_ is not None and not isinstance(units_, (bytes, str, list)):
            raise Exception("Expected units_ to be a Sequence, received: {}".format(type(units_)))

        self.actions = actions_
        self.applications = applications_
        self.limit = limit_
        self.offset = offset_
        self.status = status_
        self.units = units_
        self.unknown_fields = unknown_fields



class OperationResult(Type):
    _toSchema = {'actions': 'actions', 'completed': 'completed', 'enqueued': 'enqueued', 'error': 'error', 'operation': 'operation', 'started': 'started', 'status': 'status', 'summary': 'summary'}
    _toPy = {'actions': 'actions', 'completed': 'completed', 'enqueued': 'enqueued', 'error': 'error', 'operation': 'operation', 'started': 'started', 'status': 'status', 'summary': 'summary'}
    def __init__(self, actions=None, completed=None, enqueued=None, error=None, operation=None, started=None, status=None, summary=None, **unknown_fields):
        '''
        actions : typing.Sequence[~ActionResult]
        completed : str
        enqueued : str
        error : Error
        operation : str
        started : str
        status : str
        summary : str
        '''
        actions_ = [ActionResult.from_json(o) for o in actions or []]
        completed_ = completed
        enqueued_ = enqueued
        error_ = Error.from_json(error) if error else None
        operation_ = operation
        started_ = started
        status_ = status
        summary_ = summary

        # Validate arguments against known Juju API types.
        if actions_ is not None and not isinstance(actions_, (bytes, str, list)):
            raise Exception("Expected actions_ to be a Sequence, received: {}".format(type(actions_)))

        if completed_ is not None and not isinstance(completed_, (bytes, str)):
            raise Exception("Expected completed_ to be a str, received: {}".format(type(completed_)))

        if enqueued_ is not None and not isinstance(enqueued_, (bytes, str)):
            raise Exception("Expected enqueued_ to be a str, received: {}".format(type(enqueued_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if operation_ is not None and not isinstance(operation_, (bytes, str)):
            raise Exception("Expected operation_ to be a str, received: {}".format(type(operation_)))

        if started_ is not None and not isinstance(started_, (bytes, str)):
            raise Exception("Expected started_ to be a str, received: {}".format(type(started_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if summary_ is not None and not isinstance(summary_, (bytes, str)):
            raise Exception("Expected summary_ to be a str, received: {}".format(type(summary_)))

        self.actions = actions_
        self.completed = completed_
        self.enqueued = enqueued_
        self.error = error_
        self.operation = operation_
        self.started = started_
        self.status = status_
        self.summary = summary_
        self.unknown_fields = unknown_fields



class OperationResults(Type):
    _toSchema = {'results': 'results', 'truncated': 'truncated'}
    _toPy = {'results': 'results', 'truncated': 'truncated'}
    def __init__(self, results=None, truncated=None, **unknown_fields):
        '''
        results : typing.Sequence[~OperationResult]
        truncated : bool
        '''
        results_ = [OperationResult.from_json(o) for o in results or []]
        truncated_ = truncated

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        if truncated_ is not None and not isinstance(truncated_, bool):
            raise Exception("Expected truncated_ to be a bool, received: {}".format(type(truncated_)))

        self.results = results_
        self.truncated = truncated_
        self.unknown_fields = unknown_fields



class OperatorProvisioningInfo(Type):
    _toSchema = {'api_addresses': 'api-addresses', 'charm_storage': 'charm-storage', 'error': 'error', 'image_path': 'image-path', 'tags': 'tags', 'version': 'version'}
    _toPy = {'api-addresses': 'api_addresses', 'charm-storage': 'charm_storage', 'error': 'error', 'image-path': 'image_path', 'tags': 'tags', 'version': 'version'}
    def __init__(self, api_addresses=None, charm_storage=None, error=None, image_path=None, tags=None, version=None, **unknown_fields):
        '''
        api_addresses : typing.Sequence[str]
        charm_storage : KubernetesFilesystemParams
        error : Error
        image_path : str
        tags : typing.Mapping[str, str]
        version : Number
        '''
        api_addresses_ = api_addresses
        charm_storage_ = KubernetesFilesystemParams.from_json(charm_storage) if charm_storage else None
        error_ = Error.from_json(error) if error else None
        image_path_ = image_path
        tags_ = tags
        version_ = Number.from_json(version) if version else None

        # Validate arguments against known Juju API types.
        if api_addresses_ is not None and not isinstance(api_addresses_, (bytes, str, list)):
            raise Exception("Expected api_addresses_ to be a Sequence, received: {}".format(type(api_addresses_)))

        if charm_storage_ is not None and not isinstance(charm_storage_, (dict, KubernetesFilesystemParams)):
            raise Exception("Expected charm_storage_ to be a KubernetesFilesystemParams, received: {}".format(type(charm_storage_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if image_path_ is not None and not isinstance(image_path_, (bytes, str)):
            raise Exception("Expected image_path_ to be a str, received: {}".format(type(image_path_)))

        if tags_ is not None and not isinstance(tags_, dict):
            raise Exception("Expected tags_ to be a Mapping, received: {}".format(type(tags_)))

        if version_ is not None and not isinstance(version_, (dict, Number)):
            raise Exception("Expected version_ to be a Number, received: {}".format(type(version_)))

        self.api_addresses = api_addresses_
        self.charm_storage = charm_storage_
        self.error = error_
        self.image_path = image_path_
        self.tags = tags_
        self.version = version_
        self.unknown_fields = unknown_fields



class OperatorProvisioningInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~OperatorProvisioningInfo]
        '''
        results_ = [OperatorProvisioningInfo.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class Payload(Type):
    _toSchema = {'class_': 'class', 'id_': 'id', 'labels': 'labels', 'machine': 'machine', 'status': 'status', 'type_': 'type', 'unit': 'unit'}
    _toPy = {'class': 'class_', 'id': 'id_', 'labels': 'labels', 'machine': 'machine', 'status': 'status', 'type': 'type_', 'unit': 'unit'}
    def __init__(self, class_=None, id_=None, labels=None, machine=None, status=None, type_=None, unit=None, **unknown_fields):
        '''
        class_ : str
        id_ : str
        labels : typing.Sequence[str]
        machine : str
        status : str
        type_ : str
        unit : str
        '''
        class__ = class_
        id__ = id_
        labels_ = labels
        machine_ = machine
        status_ = status
        type__ = type_
        unit_ = unit

        # Validate arguments against known Juju API types.
        if class__ is not None and not isinstance(class__, (bytes, str)):
            raise Exception("Expected class__ to be a str, received: {}".format(type(class__)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if labels_ is not None and not isinstance(labels_, (bytes, str, list)):
            raise Exception("Expected labels_ to be a Sequence, received: {}".format(type(labels_)))

        if machine_ is not None and not isinstance(machine_, (bytes, str)):
            raise Exception("Expected machine_ to be a str, received: {}".format(type(machine_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if unit_ is not None and not isinstance(unit_, (bytes, str)):
            raise Exception("Expected unit_ to be a str, received: {}".format(type(unit_)))

        self.class_ = class__
        self.id_ = id__
        self.labels = labels_
        self.machine = machine_
        self.status = status_
        self.type_ = type__
        self.unit = unit_
        self.unknown_fields = unknown_fields



class PayloadListArgs(Type):
    _toSchema = {'patterns': 'patterns'}
    _toPy = {'patterns': 'patterns'}
    def __init__(self, patterns=None, **unknown_fields):
        '''
        patterns : typing.Sequence[str]
        '''
        patterns_ = patterns

        # Validate arguments against known Juju API types.
        if patterns_ is not None and not isinstance(patterns_, (bytes, str, list)):
            raise Exception("Expected patterns_ to be a Sequence, received: {}".format(type(patterns_)))

        self.patterns = patterns_
        self.unknown_fields = unknown_fields



class PayloadListResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~Payload]
        '''
        results_ = [Payload.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class PayloadResult(Type):
    _toSchema = {'entity': 'Entity', 'error': 'error', 'not_found': 'not-found', 'payload': 'payload', 'tag': 'tag'}
    _toPy = {'Entity': 'entity', 'error': 'error', 'not-found': 'not_found', 'payload': 'payload', 'tag': 'tag'}
    def __init__(self, entity=None, error=None, not_found=None, payload=None, tag=None, **unknown_fields):
        '''
        entity : Entity
        error : Error
        not_found : bool
        payload : Payload
        tag : str
        '''
        entity_ = Entity.from_json(entity) if entity else None
        error_ = Error.from_json(error) if error else None
        not_found_ = not_found
        payload_ = Payload.from_json(payload) if payload else None
        tag_ = tag

        # Validate arguments against known Juju API types.
        if entity_ is not None and not isinstance(entity_, (dict, Entity)):
            raise Exception("Expected entity_ to be a Entity, received: {}".format(type(entity_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if not_found_ is not None and not isinstance(not_found_, bool):
            raise Exception("Expected not_found_ to be a bool, received: {}".format(type(not_found_)))

        if payload_ is not None and not isinstance(payload_, (dict, Payload)):
            raise Exception("Expected payload_ to be a Payload, received: {}".format(type(payload_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.entity = entity_
        self.error = error_
        self.not_found = not_found_
        self.payload = payload_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class PayloadResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~PayloadResult]
        '''
        results_ = [PayloadResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class PhaseResult(Type):
    _toSchema = {'error': 'error', 'phase': 'phase'}
    _toPy = {'error': 'error', 'phase': 'phase'}
    def __init__(self, error=None, phase=None, **unknown_fields):
        '''
        error : Error
        phase : str
        '''
        error_ = Error.from_json(error) if error else None
        phase_ = phase

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if phase_ is not None and not isinstance(phase_, (bytes, str)):
            raise Exception("Expected phase_ to be a str, received: {}".format(type(phase_)))

        self.error = error_
        self.phase = phase_
        self.unknown_fields = unknown_fields



class PhaseResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~PhaseResult]
        '''
        results_ = [PhaseResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class PinApplicationResult(Type):
    _toSchema = {'application_name': 'application-name', 'error': 'error'}
    _toPy = {'application-name': 'application_name', 'error': 'error'}
    def __init__(self, application_name=None, error=None, **unknown_fields):
        '''
        application_name : str
        error : Error
        '''
        application_name_ = application_name
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if application_name_ is not None and not isinstance(application_name_, (bytes, str)):
            raise Exception("Expected application_name_ to be a str, received: {}".format(type(application_name_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.application_name = application_name_
        self.error = error_
        self.unknown_fields = unknown_fields



class PinApplicationsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~PinApplicationResult]
        '''
        results_ = [PinApplicationResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class PinnedLeadershipResult(Type):
    _toSchema = {'result': 'result'}
    _toPy = {'result': 'result'}
    def __init__(self, result=None, **unknown_fields):
        '''
        result : typing.Mapping[str, typing.Sequence[str]]
        '''
        result_ = result

        # Validate arguments against known Juju API types.
        if result_ is not None and not isinstance(result_, dict):
            raise Exception("Expected result_ to be a Mapping, received: {}".format(type(result_)))

        self.result = result_
        self.unknown_fields = unknown_fields



class Placement(Type):
    _toSchema = {'directive': 'directive', 'scope': 'scope'}
    _toPy = {'directive': 'directive', 'scope': 'scope'}
    def __init__(self, directive=None, scope=None, **unknown_fields):
        '''
        directive : str
        scope : str
        '''
        directive_ = directive
        scope_ = scope

        # Validate arguments against known Juju API types.
        if directive_ is not None and not isinstance(directive_, (bytes, str)):
            raise Exception("Expected directive_ to be a str, received: {}".format(type(directive_)))

        if scope_ is not None and not isinstance(scope_, (bytes, str)):
            raise Exception("Expected scope_ to be a str, received: {}".format(type(scope_)))

        self.directive = directive_
        self.scope = scope_
        self.unknown_fields = unknown_fields



class PodSpec(Type):
    _toSchema = {'spec': 'spec', 'tag': 'tag'}
    _toPy = {'spec': 'spec', 'tag': 'tag'}
    def __init__(self, spec=None, tag=None, **unknown_fields):
        '''
        spec : str
        tag : str
        '''
        spec_ = spec
        tag_ = tag

        # Validate arguments against known Juju API types.
        if spec_ is not None and not isinstance(spec_, (bytes, str)):
            raise Exception("Expected spec_ to be a str, received: {}".format(type(spec_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.spec = spec_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class PortRange(Type):
    _toSchema = {'from_port': 'from-port', 'protocol': 'protocol', 'to_port': 'to-port'}
    _toPy = {'from-port': 'from_port', 'protocol': 'protocol', 'to-port': 'to_port'}
    def __init__(self, from_port=None, protocol=None, to_port=None, **unknown_fields):
        '''
        from_port : int
        protocol : str
        to_port : int
        '''
        from_port_ = from_port
        protocol_ = protocol
        to_port_ = to_port

        # Validate arguments against known Juju API types.
        if from_port_ is not None and not isinstance(from_port_, int):
            raise Exception("Expected from_port_ to be a int, received: {}".format(type(from_port_)))

        if protocol_ is not None and not isinstance(protocol_, (bytes, str)):
            raise Exception("Expected protocol_ to be a str, received: {}".format(type(protocol_)))

        if to_port_ is not None and not isinstance(to_port_, int):
            raise Exception("Expected to_port_ to be a int, received: {}".format(type(to_port_)))

        self.from_port = from_port_
        self.protocol = protocol_
        self.to_port = to_port_
        self.unknown_fields = unknown_fields



class PrivateAddress(Type):
    _toSchema = {'target': 'target'}
    _toPy = {'target': 'target'}
    def __init__(self, target=None, **unknown_fields):
        '''
        target : str
        '''
        target_ = target

        # Validate arguments against known Juju API types.
        if target_ is not None and not isinstance(target_, (bytes, str)):
            raise Exception("Expected target_ to be a str, received: {}".format(type(target_)))

        self.target = target_
        self.unknown_fields = unknown_fields



class PrivateAddressResults(Type):
    _toSchema = {'private_address': 'private-address'}
    _toPy = {'private-address': 'private_address'}
    def __init__(self, private_address=None, **unknown_fields):
        '''
        private_address : str
        '''
        private_address_ = private_address

        # Validate arguments against known Juju API types.
        if private_address_ is not None and not isinstance(private_address_, (bytes, str)):
            raise Exception("Expected private_address_ to be a str, received: {}".format(type(private_address_)))

        self.private_address = private_address_
        self.unknown_fields = unknown_fields



class ProcessRelations(Type):
    _toSchema = {'controller_alias': 'controller-alias'}
    _toPy = {'controller-alias': 'controller_alias'}
    def __init__(self, controller_alias=None, **unknown_fields):
        '''
        controller_alias : str
        '''
        controller_alias_ = controller_alias

        # Validate arguments against known Juju API types.
        if controller_alias_ is not None and not isinstance(controller_alias_, (bytes, str)):
            raise Exception("Expected controller_alias_ to be a str, received: {}".format(type(controller_alias_)))

        self.controller_alias = controller_alias_
        self.unknown_fields = unknown_fields



class ProfileChangeResult(Type):
    _toSchema = {'error': 'error', 'new_profile_name': 'new-profile-name', 'old_profile_name': 'old-profile-name', 'profile': 'profile', 'subordinate': 'subordinate'}
    _toPy = {'error': 'error', 'new-profile-name': 'new_profile_name', 'old-profile-name': 'old_profile_name', 'profile': 'profile', 'subordinate': 'subordinate'}
    def __init__(self, error=None, new_profile_name=None, old_profile_name=None, profile=None, subordinate=None, **unknown_fields):
        '''
        error : Error
        new_profile_name : str
        old_profile_name : str
        profile : CharmLXDProfile
        subordinate : bool
        '''
        error_ = Error.from_json(error) if error else None
        new_profile_name_ = new_profile_name
        old_profile_name_ = old_profile_name
        profile_ = CharmLXDProfile.from_json(profile) if profile else None
        subordinate_ = subordinate

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if new_profile_name_ is not None and not isinstance(new_profile_name_, (bytes, str)):
            raise Exception("Expected new_profile_name_ to be a str, received: {}".format(type(new_profile_name_)))

        if old_profile_name_ is not None and not isinstance(old_profile_name_, (bytes, str)):
            raise Exception("Expected old_profile_name_ to be a str, received: {}".format(type(old_profile_name_)))

        if profile_ is not None and not isinstance(profile_, (dict, CharmLXDProfile)):
            raise Exception("Expected profile_ to be a CharmLXDProfile, received: {}".format(type(profile_)))

        if subordinate_ is not None and not isinstance(subordinate_, bool):
            raise Exception("Expected subordinate_ to be a bool, received: {}".format(type(subordinate_)))

        self.error = error_
        self.new_profile_name = new_profile_name_
        self.old_profile_name = old_profile_name_
        self.profile = profile_
        self.subordinate = subordinate_
        self.unknown_fields = unknown_fields



class ProfileChangeResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ProfileChangeResult]
        '''
        results_ = [ProfileChangeResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ProfileInfoResult(Type):
    _toSchema = {'application_name': 'application-name', 'error': 'error', 'profile': 'profile', 'revision': 'revision'}
    _toPy = {'application-name': 'application_name', 'error': 'error', 'profile': 'profile', 'revision': 'revision'}
    def __init__(self, application_name=None, error=None, profile=None, revision=None, **unknown_fields):
        '''
        application_name : str
        error : Error
        profile : CharmLXDProfile
        revision : int
        '''
        application_name_ = application_name
        error_ = Error.from_json(error) if error else None
        profile_ = CharmLXDProfile.from_json(profile) if profile else None
        revision_ = revision

        # Validate arguments against known Juju API types.
        if application_name_ is not None and not isinstance(application_name_, (bytes, str)):
            raise Exception("Expected application_name_ to be a str, received: {}".format(type(application_name_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if profile_ is not None and not isinstance(profile_, (dict, CharmLXDProfile)):
            raise Exception("Expected profile_ to be a CharmLXDProfile, received: {}".format(type(profile_)))

        if revision_ is not None and not isinstance(revision_, int):
            raise Exception("Expected revision_ to be a int, received: {}".format(type(revision_)))

        self.application_name = application_name_
        self.error = error_
        self.profile = profile_
        self.revision = revision_
        self.unknown_fields = unknown_fields



class ProviderInterfaceInfo(Type):
    _toSchema = {'interface_name': 'interface-name', 'mac_address': 'mac-address', 'provider_id': 'provider-id'}
    _toPy = {'interface-name': 'interface_name', 'mac-address': 'mac_address', 'provider-id': 'provider_id'}
    def __init__(self, interface_name=None, mac_address=None, provider_id=None, **unknown_fields):
        '''
        interface_name : str
        mac_address : str
        provider_id : str
        '''
        interface_name_ = interface_name
        mac_address_ = mac_address
        provider_id_ = provider_id

        # Validate arguments against known Juju API types.
        if interface_name_ is not None and not isinstance(interface_name_, (bytes, str)):
            raise Exception("Expected interface_name_ to be a str, received: {}".format(type(interface_name_)))

        if mac_address_ is not None and not isinstance(mac_address_, (bytes, str)):
            raise Exception("Expected mac_address_ to be a str, received: {}".format(type(mac_address_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        self.interface_name = interface_name_
        self.mac_address = mac_address_
        self.provider_id = provider_id_
        self.unknown_fields = unknown_fields



class ProviderInterfaceInfoResult(Type):
    _toSchema = {'error': 'error', 'interfaces': 'interfaces', 'machine_tag': 'machine-tag'}
    _toPy = {'error': 'error', 'interfaces': 'interfaces', 'machine-tag': 'machine_tag'}
    def __init__(self, error=None, interfaces=None, machine_tag=None, **unknown_fields):
        '''
        error : Error
        interfaces : typing.Sequence[~ProviderInterfaceInfo]
        machine_tag : str
        '''
        error_ = Error.from_json(error) if error else None
        interfaces_ = [ProviderInterfaceInfo.from_json(o) for o in interfaces or []]
        machine_tag_ = machine_tag

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if interfaces_ is not None and not isinstance(interfaces_, (bytes, str, list)):
            raise Exception("Expected interfaces_ to be a Sequence, received: {}".format(type(interfaces_)))

        if machine_tag_ is not None and not isinstance(machine_tag_, (bytes, str)):
            raise Exception("Expected machine_tag_ to be a str, received: {}".format(type(machine_tag_)))

        self.error = error_
        self.interfaces = interfaces_
        self.machine_tag = machine_tag_
        self.unknown_fields = unknown_fields



class ProviderInterfaceInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ProviderInterfaceInfoResult]
        '''
        results_ = [ProviderInterfaceInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ProviderNetworkConfig(Type):
    _toSchema = {'config': 'config', 'tag': 'tag'}
    _toPy = {'config': 'config', 'tag': 'tag'}
    def __init__(self, config=None, tag=None, **unknown_fields):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        '''
        config_ = [NetworkConfig.from_json(o) for o in config or []]
        tag_ = tag

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, (bytes, str, list)):
            raise Exception("Expected config_ to be a Sequence, received: {}".format(type(config_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.config = config_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class ProviderSpace(Type):
    _toSchema = {'error': 'error', 'name': 'name', 'provider_id': 'provider-id', 'subnets': 'subnets'}
    _toPy = {'error': 'error', 'name': 'name', 'provider-id': 'provider_id', 'subnets': 'subnets'}
    def __init__(self, error=None, name=None, provider_id=None, subnets=None, **unknown_fields):
        '''
        error : Error
        name : str
        provider_id : str
        subnets : typing.Sequence[~Subnet]
        '''
        error_ = Error.from_json(error) if error else None
        name_ = name
        provider_id_ = provider_id
        subnets_ = [Subnet.from_json(o) for o in subnets or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if subnets_ is not None and not isinstance(subnets_, (bytes, str, list)):
            raise Exception("Expected subnets_ to be a Sequence, received: {}".format(type(subnets_)))

        self.error = error_
        self.name = name_
        self.provider_id = provider_id_
        self.subnets = subnets_
        self.unknown_fields = unknown_fields



class ProvisioningInfo(Type):
    _toSchema = {'charm_lxd_profiles': 'charm-lxd-profiles', 'cloudinit_userdata': 'cloudinit-userdata', 'constraints': 'constraints', 'controller_config': 'controller-config', 'endpoint_bindings': 'endpoint-bindings', 'image_metadata': 'image-metadata', 'jobs': 'jobs', 'placement': 'placement', 'series': 'series', 'subnets_to_zones': 'subnets-to-zones', 'tags': 'tags', 'volume_attachments': 'volume-attachments', 'volumes': 'volumes'}
    _toPy = {'charm-lxd-profiles': 'charm_lxd_profiles', 'cloudinit-userdata': 'cloudinit_userdata', 'constraints': 'constraints', 'controller-config': 'controller_config', 'endpoint-bindings': 'endpoint_bindings', 'image-metadata': 'image_metadata', 'jobs': 'jobs', 'placement': 'placement', 'series': 'series', 'subnets-to-zones': 'subnets_to_zones', 'tags': 'tags', 'volume-attachments': 'volume_attachments', 'volumes': 'volumes'}
    def __init__(self, charm_lxd_profiles=None, cloudinit_userdata=None, constraints=None, controller_config=None, endpoint_bindings=None, image_metadata=None, jobs=None, placement=None, series=None, subnets_to_zones=None, tags=None, volume_attachments=None, volumes=None, **unknown_fields):
        '''
        charm_lxd_profiles : typing.Sequence[str]
        cloudinit_userdata : typing.Mapping[str, typing.Any]
        constraints : Value
        controller_config : typing.Mapping[str, typing.Any]
        endpoint_bindings : typing.Mapping[str, str]
        image_metadata : typing.Sequence[~CloudImageMetadata]
        jobs : typing.Sequence[str]
        placement : str
        series : str
        subnets_to_zones : typing.Mapping[str, typing.Sequence[str]]
        tags : typing.Mapping[str, str]
        volume_attachments : typing.Sequence[~VolumeAttachmentParams]
        volumes : typing.Sequence[~VolumeParams]
        '''
        charm_lxd_profiles_ = charm_lxd_profiles
        cloudinit_userdata_ = cloudinit_userdata
        constraints_ = Value.from_json(constraints) if constraints else None
        controller_config_ = controller_config
        endpoint_bindings_ = endpoint_bindings
        image_metadata_ = [CloudImageMetadata.from_json(o) for o in image_metadata or []]
        jobs_ = jobs
        placement_ = placement
        series_ = series
        subnets_to_zones_ = subnets_to_zones
        tags_ = tags
        volume_attachments_ = [VolumeAttachmentParams.from_json(o) for o in volume_attachments or []]
        volumes_ = [VolumeParams.from_json(o) for o in volumes or []]

        # Validate arguments against known Juju API types.
        if charm_lxd_profiles_ is not None and not isinstance(charm_lxd_profiles_, (bytes, str, list)):
            raise Exception("Expected charm_lxd_profiles_ to be a Sequence, received: {}".format(type(charm_lxd_profiles_)))

        if cloudinit_userdata_ is not None and not isinstance(cloudinit_userdata_, dict):
            raise Exception("Expected cloudinit_userdata_ to be a Mapping, received: {}".format(type(cloudinit_userdata_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if controller_config_ is not None and not isinstance(controller_config_, dict):
            raise Exception("Expected controller_config_ to be a Mapping, received: {}".format(type(controller_config_)))

        if endpoint_bindings_ is not None and not isinstance(endpoint_bindings_, dict):
            raise Exception("Expected endpoint_bindings_ to be a Mapping, received: {}".format(type(endpoint_bindings_)))

        if image_metadata_ is not None and not isinstance(image_metadata_, (bytes, str, list)):
            raise Exception("Expected image_metadata_ to be a Sequence, received: {}".format(type(image_metadata_)))

        if jobs_ is not None and not isinstance(jobs_, (bytes, str, list)):
            raise Exception("Expected jobs_ to be a Sequence, received: {}".format(type(jobs_)))

        if placement_ is not None and not isinstance(placement_, (bytes, str)):
            raise Exception("Expected placement_ to be a str, received: {}".format(type(placement_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if subnets_to_zones_ is not None and not isinstance(subnets_to_zones_, dict):
            raise Exception("Expected subnets_to_zones_ to be a Mapping, received: {}".format(type(subnets_to_zones_)))

        if tags_ is not None and not isinstance(tags_, dict):
            raise Exception("Expected tags_ to be a Mapping, received: {}".format(type(tags_)))

        if volume_attachments_ is not None and not isinstance(volume_attachments_, (bytes, str, list)):
            raise Exception("Expected volume_attachments_ to be a Sequence, received: {}".format(type(volume_attachments_)))

        if volumes_ is not None and not isinstance(volumes_, (bytes, str, list)):
            raise Exception("Expected volumes_ to be a Sequence, received: {}".format(type(volumes_)))

        self.charm_lxd_profiles = charm_lxd_profiles_
        self.cloudinit_userdata = cloudinit_userdata_
        self.constraints = constraints_
        self.controller_config = controller_config_
        self.endpoint_bindings = endpoint_bindings_
        self.image_metadata = image_metadata_
        self.jobs = jobs_
        self.placement = placement_
        self.series = series_
        self.subnets_to_zones = subnets_to_zones_
        self.tags = tags_
        self.volume_attachments = volume_attachments_
        self.volumes = volumes_
        self.unknown_fields = unknown_fields



class ProvisioningInfoBase(Type):
    _toSchema = {'charm_lxd_profiles': 'charm-lxd-profiles', 'cloudinit_userdata': 'cloudinit-userdata', 'constraints': 'constraints', 'controller_config': 'controller-config', 'endpoint_bindings': 'endpoint-bindings', 'image_metadata': 'image-metadata', 'jobs': 'jobs', 'placement': 'placement', 'series': 'series', 'tags': 'tags', 'volume_attachments': 'volume-attachments', 'volumes': 'volumes'}
    _toPy = {'charm-lxd-profiles': 'charm_lxd_profiles', 'cloudinit-userdata': 'cloudinit_userdata', 'constraints': 'constraints', 'controller-config': 'controller_config', 'endpoint-bindings': 'endpoint_bindings', 'image-metadata': 'image_metadata', 'jobs': 'jobs', 'placement': 'placement', 'series': 'series', 'tags': 'tags', 'volume-attachments': 'volume_attachments', 'volumes': 'volumes'}
    def __init__(self, charm_lxd_profiles=None, cloudinit_userdata=None, constraints=None, controller_config=None, endpoint_bindings=None, image_metadata=None, jobs=None, placement=None, series=None, tags=None, volume_attachments=None, volumes=None, **unknown_fields):
        '''
        charm_lxd_profiles : typing.Sequence[str]
        cloudinit_userdata : typing.Mapping[str, typing.Any]
        constraints : Value
        controller_config : typing.Mapping[str, typing.Any]
        endpoint_bindings : typing.Mapping[str, str]
        image_metadata : typing.Sequence[~CloudImageMetadata]
        jobs : typing.Sequence[str]
        placement : str
        series : str
        tags : typing.Mapping[str, str]
        volume_attachments : typing.Sequence[~VolumeAttachmentParams]
        volumes : typing.Sequence[~VolumeParams]
        '''
        charm_lxd_profiles_ = charm_lxd_profiles
        cloudinit_userdata_ = cloudinit_userdata
        constraints_ = Value.from_json(constraints) if constraints else None
        controller_config_ = controller_config
        endpoint_bindings_ = endpoint_bindings
        image_metadata_ = [CloudImageMetadata.from_json(o) for o in image_metadata or []]
        jobs_ = jobs
        placement_ = placement
        series_ = series
        tags_ = tags
        volume_attachments_ = [VolumeAttachmentParams.from_json(o) for o in volume_attachments or []]
        volumes_ = [VolumeParams.from_json(o) for o in volumes or []]

        # Validate arguments against known Juju API types.
        if charm_lxd_profiles_ is not None and not isinstance(charm_lxd_profiles_, (bytes, str, list)):
            raise Exception("Expected charm_lxd_profiles_ to be a Sequence, received: {}".format(type(charm_lxd_profiles_)))

        if cloudinit_userdata_ is not None and not isinstance(cloudinit_userdata_, dict):
            raise Exception("Expected cloudinit_userdata_ to be a Mapping, received: {}".format(type(cloudinit_userdata_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if controller_config_ is not None and not isinstance(controller_config_, dict):
            raise Exception("Expected controller_config_ to be a Mapping, received: {}".format(type(controller_config_)))

        if endpoint_bindings_ is not None and not isinstance(endpoint_bindings_, dict):
            raise Exception("Expected endpoint_bindings_ to be a Mapping, received: {}".format(type(endpoint_bindings_)))

        if image_metadata_ is not None and not isinstance(image_metadata_, (bytes, str, list)):
            raise Exception("Expected image_metadata_ to be a Sequence, received: {}".format(type(image_metadata_)))

        if jobs_ is not None and not isinstance(jobs_, (bytes, str, list)):
            raise Exception("Expected jobs_ to be a Sequence, received: {}".format(type(jobs_)))

        if placement_ is not None and not isinstance(placement_, (bytes, str)):
            raise Exception("Expected placement_ to be a str, received: {}".format(type(placement_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if tags_ is not None and not isinstance(tags_, dict):
            raise Exception("Expected tags_ to be a Mapping, received: {}".format(type(tags_)))

        if volume_attachments_ is not None and not isinstance(volume_attachments_, (bytes, str, list)):
            raise Exception("Expected volume_attachments_ to be a Sequence, received: {}".format(type(volume_attachments_)))

        if volumes_ is not None and not isinstance(volumes_, (bytes, str, list)):
            raise Exception("Expected volumes_ to be a Sequence, received: {}".format(type(volumes_)))

        self.charm_lxd_profiles = charm_lxd_profiles_
        self.cloudinit_userdata = cloudinit_userdata_
        self.constraints = constraints_
        self.controller_config = controller_config_
        self.endpoint_bindings = endpoint_bindings_
        self.image_metadata = image_metadata_
        self.jobs = jobs_
        self.placement = placement_
        self.series = series_
        self.tags = tags_
        self.volume_attachments = volume_attachments_
        self.volumes = volumes_
        self.unknown_fields = unknown_fields



class ProvisioningInfoResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ProvisioningInfo
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ProvisioningInfo.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ProvisioningInfo)):
            raise Exception("Expected result_ to be a ProvisioningInfo, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ProvisioningInfoResultV10(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : ProvisioningInfoV10
        '''
        error_ = Error.from_json(error) if error else None
        result_ = ProvisioningInfoV10.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, ProvisioningInfoV10)):
            raise Exception("Expected result_ to be a ProvisioningInfoV10, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class ProvisioningInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ProvisioningInfoResult]
        '''
        results_ = [ProvisioningInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ProvisioningInfoResultsV10(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ProvisioningInfoResultV10]
        '''
        results_ = [ProvisioningInfoResultV10.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ProvisioningInfoV10(Type):
    _toSchema = {'charm_lxd_profiles': 'charm-lxd-profiles', 'cloudinit_userdata': 'cloudinit-userdata', 'constraints': 'constraints', 'controller_config': 'controller-config', 'endpoint_bindings': 'endpoint-bindings', 'image_metadata': 'image-metadata', 'jobs': 'jobs', 'placement': 'placement', 'provisioninginfobase': 'ProvisioningInfoBase', 'provisioningnetworktopology': 'ProvisioningNetworkTopology', 'series': 'series', 'space_subnets': 'space-subnets', 'subnet_zones': 'subnet-zones', 'tags': 'tags', 'volume_attachments': 'volume-attachments', 'volumes': 'volumes'}
    _toPy = {'ProvisioningInfoBase': 'provisioninginfobase', 'ProvisioningNetworkTopology': 'provisioningnetworktopology', 'charm-lxd-profiles': 'charm_lxd_profiles', 'cloudinit-userdata': 'cloudinit_userdata', 'constraints': 'constraints', 'controller-config': 'controller_config', 'endpoint-bindings': 'endpoint_bindings', 'image-metadata': 'image_metadata', 'jobs': 'jobs', 'placement': 'placement', 'series': 'series', 'space-subnets': 'space_subnets', 'subnet-zones': 'subnet_zones', 'tags': 'tags', 'volume-attachments': 'volume_attachments', 'volumes': 'volumes'}
    def __init__(self, provisioninginfobase=None, provisioningnetworktopology=None, charm_lxd_profiles=None, cloudinit_userdata=None, constraints=None, controller_config=None, endpoint_bindings=None, image_metadata=None, jobs=None, placement=None, series=None, space_subnets=None, subnet_zones=None, tags=None, volume_attachments=None, volumes=None, **unknown_fields):
        '''
        provisioninginfobase : ProvisioningInfoBase
        provisioningnetworktopology : ProvisioningNetworkTopology
        charm_lxd_profiles : typing.Sequence[str]
        cloudinit_userdata : typing.Mapping[str, typing.Any]
        constraints : Value
        controller_config : typing.Mapping[str, typing.Any]
        endpoint_bindings : typing.Mapping[str, str]
        image_metadata : typing.Sequence[~CloudImageMetadata]
        jobs : typing.Sequence[str]
        placement : str
        series : str
        space_subnets : typing.Mapping[str, typing.Sequence[str]]
        subnet_zones : typing.Mapping[str, typing.Sequence[str]]
        tags : typing.Mapping[str, str]
        volume_attachments : typing.Sequence[~VolumeAttachmentParams]
        volumes : typing.Sequence[~VolumeParams]
        '''
        provisioninginfobase_ = ProvisioningInfoBase.from_json(provisioninginfobase) if provisioninginfobase else None
        provisioningnetworktopology_ = ProvisioningNetworkTopology.from_json(provisioningnetworktopology) if provisioningnetworktopology else None
        charm_lxd_profiles_ = charm_lxd_profiles
        cloudinit_userdata_ = cloudinit_userdata
        constraints_ = Value.from_json(constraints) if constraints else None
        controller_config_ = controller_config
        endpoint_bindings_ = endpoint_bindings
        image_metadata_ = [CloudImageMetadata.from_json(o) for o in image_metadata or []]
        jobs_ = jobs
        placement_ = placement
        series_ = series
        space_subnets_ = space_subnets
        subnet_zones_ = subnet_zones
        tags_ = tags
        volume_attachments_ = [VolumeAttachmentParams.from_json(o) for o in volume_attachments or []]
        volumes_ = [VolumeParams.from_json(o) for o in volumes or []]

        # Validate arguments against known Juju API types.
        if provisioninginfobase_ is not None and not isinstance(provisioninginfobase_, (dict, ProvisioningInfoBase)):
            raise Exception("Expected provisioninginfobase_ to be a ProvisioningInfoBase, received: {}".format(type(provisioninginfobase_)))

        if provisioningnetworktopology_ is not None and not isinstance(provisioningnetworktopology_, (dict, ProvisioningNetworkTopology)):
            raise Exception("Expected provisioningnetworktopology_ to be a ProvisioningNetworkTopology, received: {}".format(type(provisioningnetworktopology_)))

        if charm_lxd_profiles_ is not None and not isinstance(charm_lxd_profiles_, (bytes, str, list)):
            raise Exception("Expected charm_lxd_profiles_ to be a Sequence, received: {}".format(type(charm_lxd_profiles_)))

        if cloudinit_userdata_ is not None and not isinstance(cloudinit_userdata_, dict):
            raise Exception("Expected cloudinit_userdata_ to be a Mapping, received: {}".format(type(cloudinit_userdata_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        if controller_config_ is not None and not isinstance(controller_config_, dict):
            raise Exception("Expected controller_config_ to be a Mapping, received: {}".format(type(controller_config_)))

        if endpoint_bindings_ is not None and not isinstance(endpoint_bindings_, dict):
            raise Exception("Expected endpoint_bindings_ to be a Mapping, received: {}".format(type(endpoint_bindings_)))

        if image_metadata_ is not None and not isinstance(image_metadata_, (bytes, str, list)):
            raise Exception("Expected image_metadata_ to be a Sequence, received: {}".format(type(image_metadata_)))

        if jobs_ is not None and not isinstance(jobs_, (bytes, str, list)):
            raise Exception("Expected jobs_ to be a Sequence, received: {}".format(type(jobs_)))

        if placement_ is not None and not isinstance(placement_, (bytes, str)):
            raise Exception("Expected placement_ to be a str, received: {}".format(type(placement_)))

        if series_ is not None and not isinstance(series_, (bytes, str)):
            raise Exception("Expected series_ to be a str, received: {}".format(type(series_)))

        if space_subnets_ is not None and not isinstance(space_subnets_, dict):
            raise Exception("Expected space_subnets_ to be a Mapping, received: {}".format(type(space_subnets_)))

        if subnet_zones_ is not None and not isinstance(subnet_zones_, dict):
            raise Exception("Expected subnet_zones_ to be a Mapping, received: {}".format(type(subnet_zones_)))

        if tags_ is not None and not isinstance(tags_, dict):
            raise Exception("Expected tags_ to be a Mapping, received: {}".format(type(tags_)))

        if volume_attachments_ is not None and not isinstance(volume_attachments_, (bytes, str, list)):
            raise Exception("Expected volume_attachments_ to be a Sequence, received: {}".format(type(volume_attachments_)))

        if volumes_ is not None and not isinstance(volumes_, (bytes, str, list)):
            raise Exception("Expected volumes_ to be a Sequence, received: {}".format(type(volumes_)))

        self.provisioninginfobase = provisioninginfobase_
        self.provisioningnetworktopology = provisioningnetworktopology_
        self.charm_lxd_profiles = charm_lxd_profiles_
        self.cloudinit_userdata = cloudinit_userdata_
        self.constraints = constraints_
        self.controller_config = controller_config_
        self.endpoint_bindings = endpoint_bindings_
        self.image_metadata = image_metadata_
        self.jobs = jobs_
        self.placement = placement_
        self.series = series_
        self.space_subnets = space_subnets_
        self.subnet_zones = subnet_zones_
        self.tags = tags_
        self.volume_attachments = volume_attachments_
        self.volumes = volumes_
        self.unknown_fields = unknown_fields



class ProvisioningNetworkTopology(Type):
    _toSchema = {'space_subnets': 'space-subnets', 'subnet_zones': 'subnet-zones'}
    _toPy = {'space-subnets': 'space_subnets', 'subnet-zones': 'subnet_zones'}
    def __init__(self, space_subnets=None, subnet_zones=None, **unknown_fields):
        '''
        space_subnets : typing.Mapping[str, typing.Sequence[str]]
        subnet_zones : typing.Mapping[str, typing.Sequence[str]]
        '''
        space_subnets_ = space_subnets
        subnet_zones_ = subnet_zones

        # Validate arguments against known Juju API types.
        if space_subnets_ is not None and not isinstance(space_subnets_, dict):
            raise Exception("Expected space_subnets_ to be a Mapping, received: {}".format(type(space_subnets_)))

        if subnet_zones_ is not None and not isinstance(subnet_zones_, dict):
            raise Exception("Expected subnet_zones_ to be a Mapping, received: {}".format(type(subnet_zones_)))

        self.space_subnets = space_subnets_
        self.subnet_zones = subnet_zones_
        self.unknown_fields = unknown_fields



class ProvisioningScriptParams(Type):
    _toSchema = {'data_dir': 'data-dir', 'disable_package_commands': 'disable-package-commands', 'machine_id': 'machine-id', 'nonce': 'nonce'}
    _toPy = {'data-dir': 'data_dir', 'disable-package-commands': 'disable_package_commands', 'machine-id': 'machine_id', 'nonce': 'nonce'}
    def __init__(self, data_dir=None, disable_package_commands=None, machine_id=None, nonce=None, **unknown_fields):
        '''
        data_dir : str
        disable_package_commands : bool
        machine_id : str
        nonce : str
        '''
        data_dir_ = data_dir
        disable_package_commands_ = disable_package_commands
        machine_id_ = machine_id
        nonce_ = nonce

        # Validate arguments against known Juju API types.
        if data_dir_ is not None and not isinstance(data_dir_, (bytes, str)):
            raise Exception("Expected data_dir_ to be a str, received: {}".format(type(data_dir_)))

        if disable_package_commands_ is not None and not isinstance(disable_package_commands_, bool):
            raise Exception("Expected disable_package_commands_ to be a bool, received: {}".format(type(disable_package_commands_)))

        if machine_id_ is not None and not isinstance(machine_id_, (bytes, str)):
            raise Exception("Expected machine_id_ to be a str, received: {}".format(type(machine_id_)))

        if nonce_ is not None and not isinstance(nonce_, (bytes, str)):
            raise Exception("Expected nonce_ to be a str, received: {}".format(type(nonce_)))

        self.data_dir = data_dir_
        self.disable_package_commands = disable_package_commands_
        self.machine_id = machine_id_
        self.nonce = nonce_
        self.unknown_fields = unknown_fields



class ProvisioningScriptResult(Type):
    _toSchema = {'script': 'script'}
    _toPy = {'script': 'script'}
    def __init__(self, script=None, **unknown_fields):
        '''
        script : str
        '''
        script_ = script

        # Validate arguments against known Juju API types.
        if script_ is not None and not isinstance(script_, (bytes, str)):
            raise Exception("Expected script_ to be a str, received: {}".format(type(script_)))

        self.script = script_
        self.unknown_fields = unknown_fields



class ProxyConfig(Type):
    _toSchema = {'ftp': 'ftp', 'http': 'http', 'https': 'https', 'no_proxy': 'no-proxy'}
    _toPy = {'ftp': 'ftp', 'http': 'http', 'https': 'https', 'no-proxy': 'no_proxy'}
    def __init__(self, ftp=None, http=None, https=None, no_proxy=None, **unknown_fields):
        '''
        ftp : str
        http : str
        https : str
        no_proxy : str
        '''
        ftp_ = ftp
        http_ = http
        https_ = https
        no_proxy_ = no_proxy

        # Validate arguments against known Juju API types.
        if ftp_ is not None and not isinstance(ftp_, (bytes, str)):
            raise Exception("Expected ftp_ to be a str, received: {}".format(type(ftp_)))

        if http_ is not None and not isinstance(http_, (bytes, str)):
            raise Exception("Expected http_ to be a str, received: {}".format(type(http_)))

        if https_ is not None and not isinstance(https_, (bytes, str)):
            raise Exception("Expected https_ to be a str, received: {}".format(type(https_)))

        if no_proxy_ is not None and not isinstance(no_proxy_, (bytes, str)):
            raise Exception("Expected no_proxy_ to be a str, received: {}".format(type(no_proxy_)))

        self.ftp = ftp_
        self.http = http_
        self.https = https_
        self.no_proxy = no_proxy_
        self.unknown_fields = unknown_fields



class ProxyConfigResult(Type):
    _toSchema = {'apt_proxy_settings': 'apt-proxy-settings', 'error': 'error', 'juju_proxy_settings': 'juju-proxy-settings', 'legacy_proxy_settings': 'legacy-proxy-settings', 'snap_proxy_settings': 'snap-proxy-settings', 'snap_store_assertions': 'snap-store-assertions', 'snap_store_id': 'snap-store-id', 'snap_store_proxy_url': 'snap-store-proxy-url'}
    _toPy = {'apt-proxy-settings': 'apt_proxy_settings', 'error': 'error', 'juju-proxy-settings': 'juju_proxy_settings', 'legacy-proxy-settings': 'legacy_proxy_settings', 'snap-proxy-settings': 'snap_proxy_settings', 'snap-store-assertions': 'snap_store_assertions', 'snap-store-id': 'snap_store_id', 'snap-store-proxy-url': 'snap_store_proxy_url'}
    def __init__(self, apt_proxy_settings=None, error=None, juju_proxy_settings=None, legacy_proxy_settings=None, snap_proxy_settings=None, snap_store_assertions=None, snap_store_id=None, snap_store_proxy_url=None, **unknown_fields):
        '''
        apt_proxy_settings : ProxyConfig
        error : Error
        juju_proxy_settings : ProxyConfig
        legacy_proxy_settings : ProxyConfig
        snap_proxy_settings : ProxyConfig
        snap_store_assertions : str
        snap_store_id : str
        snap_store_proxy_url : str
        '''
        apt_proxy_settings_ = ProxyConfig.from_json(apt_proxy_settings) if apt_proxy_settings else None
        error_ = Error.from_json(error) if error else None
        juju_proxy_settings_ = ProxyConfig.from_json(juju_proxy_settings) if juju_proxy_settings else None
        legacy_proxy_settings_ = ProxyConfig.from_json(legacy_proxy_settings) if legacy_proxy_settings else None
        snap_proxy_settings_ = ProxyConfig.from_json(snap_proxy_settings) if snap_proxy_settings else None
        snap_store_assertions_ = snap_store_assertions
        snap_store_id_ = snap_store_id
        snap_store_proxy_url_ = snap_store_proxy_url

        # Validate arguments against known Juju API types.
        if apt_proxy_settings_ is not None and not isinstance(apt_proxy_settings_, (dict, ProxyConfig)):
            raise Exception("Expected apt_proxy_settings_ to be a ProxyConfig, received: {}".format(type(apt_proxy_settings_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if juju_proxy_settings_ is not None and not isinstance(juju_proxy_settings_, (dict, ProxyConfig)):
            raise Exception("Expected juju_proxy_settings_ to be a ProxyConfig, received: {}".format(type(juju_proxy_settings_)))

        if legacy_proxy_settings_ is not None and not isinstance(legacy_proxy_settings_, (dict, ProxyConfig)):
            raise Exception("Expected legacy_proxy_settings_ to be a ProxyConfig, received: {}".format(type(legacy_proxy_settings_)))

        if snap_proxy_settings_ is not None and not isinstance(snap_proxy_settings_, (dict, ProxyConfig)):
            raise Exception("Expected snap_proxy_settings_ to be a ProxyConfig, received: {}".format(type(snap_proxy_settings_)))

        if snap_store_assertions_ is not None and not isinstance(snap_store_assertions_, (bytes, str)):
            raise Exception("Expected snap_store_assertions_ to be a str, received: {}".format(type(snap_store_assertions_)))

        if snap_store_id_ is not None and not isinstance(snap_store_id_, (bytes, str)):
            raise Exception("Expected snap_store_id_ to be a str, received: {}".format(type(snap_store_id_)))

        if snap_store_proxy_url_ is not None and not isinstance(snap_store_proxy_url_, (bytes, str)):
            raise Exception("Expected snap_store_proxy_url_ to be a str, received: {}".format(type(snap_store_proxy_url_)))

        self.apt_proxy_settings = apt_proxy_settings_
        self.error = error_
        self.juju_proxy_settings = juju_proxy_settings_
        self.legacy_proxy_settings = legacy_proxy_settings_
        self.snap_proxy_settings = snap_proxy_settings_
        self.snap_store_assertions = snap_store_assertions_
        self.snap_store_id = snap_store_id_
        self.snap_store_proxy_url = snap_store_proxy_url_
        self.unknown_fields = unknown_fields



class ProxyConfigResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ProxyConfigResult]
        '''
        results_ = [ProxyConfigResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class PublicAddress(Type):
    _toSchema = {'target': 'target'}
    _toPy = {'target': 'target'}
    def __init__(self, target=None, **unknown_fields):
        '''
        target : str
        '''
        target_ = target

        # Validate arguments against known Juju API types.
        if target_ is not None and not isinstance(target_, (bytes, str)):
            raise Exception("Expected target_ to be a str, received: {}".format(type(target_)))

        self.target = target_
        self.unknown_fields = unknown_fields



class PublicAddressResults(Type):
    _toSchema = {'public_address': 'public-address'}
    _toPy = {'public-address': 'public_address'}
    def __init__(self, public_address=None, **unknown_fields):
        '''
        public_address : str
        '''
        public_address_ = public_address

        # Validate arguments against known Juju API types.
        if public_address_ is not None and not isinstance(public_address_, (bytes, str)):
            raise Exception("Expected public_address_ to be a str, received: {}".format(type(public_address_)))

        self.public_address = public_address_
        self.unknown_fields = unknown_fields



class QueryApplicationOffersResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ApplicationOfferAdminDetails]
        '''
        results_ = [ApplicationOfferAdminDetails.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RebootActionResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : str
        '''
        error_ = Error.from_json(error) if error else None
        result_ = result

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (bytes, str)):
            raise Exception("Expected result_ to be a str, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class RebootActionResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RebootActionResult]
        '''
        results_ = [RebootActionResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RedirectInfoResult(Type):
    _toSchema = {'ca_cert': 'ca-cert', 'servers': 'servers'}
    _toPy = {'ca-cert': 'ca_cert', 'servers': 'servers'}
    def __init__(self, ca_cert=None, servers=None, **unknown_fields):
        '''
        ca_cert : str
        servers : typing.Sequence[~HostPort]
        '''
        ca_cert_ = ca_cert
        servers_ = [HostPort.from_json(o) for o in servers or []]

        # Validate arguments against known Juju API types.
        if ca_cert_ is not None and not isinstance(ca_cert_, (bytes, str)):
            raise Exception("Expected ca_cert_ to be a str, received: {}".format(type(ca_cert_)))

        if servers_ is not None and not isinstance(servers_, (bytes, str, list)):
            raise Exception("Expected servers_ to be a Sequence, received: {}".format(type(servers_)))

        self.ca_cert = ca_cert_
        self.servers = servers_
        self.unknown_fields = unknown_fields



class RegionDefaults(Type):
    _toSchema = {'region_name': 'region-name', 'value': 'value'}
    _toPy = {'region-name': 'region_name', 'value': 'value'}
    def __init__(self, region_name=None, value=None, **unknown_fields):
        '''
        region_name : str
        value : Any
        '''
        region_name_ = region_name
        value_ = value

        # Validate arguments against known Juju API types.
        if region_name_ is not None and not isinstance(region_name_, (bytes, str)):
            raise Exception("Expected region_name_ to be a str, received: {}".format(type(region_name_)))

        self.region_name = region_name_
        self.value = value_
        self.unknown_fields = unknown_fields



class RegisterRemoteRelationArg(Type):
    _toSchema = {'application_token': 'application-token', 'bakery_version': 'bakery-version', 'local_endpoint_name': 'local-endpoint-name', 'macaroons': 'macaroons', 'offer_uuid': 'offer-uuid', 'relation_token': 'relation-token', 'remote_endpoint': 'remote-endpoint', 'remote_space': 'remote-space', 'source_model_tag': 'source-model-tag'}
    _toPy = {'application-token': 'application_token', 'bakery-version': 'bakery_version', 'local-endpoint-name': 'local_endpoint_name', 'macaroons': 'macaroons', 'offer-uuid': 'offer_uuid', 'relation-token': 'relation_token', 'remote-endpoint': 'remote_endpoint', 'remote-space': 'remote_space', 'source-model-tag': 'source_model_tag'}
    def __init__(self, application_token=None, bakery_version=None, local_endpoint_name=None, macaroons=None, offer_uuid=None, relation_token=None, remote_endpoint=None, remote_space=None, source_model_tag=None, **unknown_fields):
        '''
        application_token : str
        bakery_version : int
        local_endpoint_name : str
        macaroons : typing.Sequence[~Macaroon]
        offer_uuid : str
        relation_token : str
        remote_endpoint : RemoteEndpoint
        remote_space : RemoteSpace
        source_model_tag : str
        '''
        application_token_ = application_token
        bakery_version_ = bakery_version
        local_endpoint_name_ = local_endpoint_name
        macaroons_ = [Macaroon.from_json(o) for o in macaroons or []]
        offer_uuid_ = offer_uuid
        relation_token_ = relation_token
        remote_endpoint_ = RemoteEndpoint.from_json(remote_endpoint) if remote_endpoint else None
        remote_space_ = RemoteSpace.from_json(remote_space) if remote_space else None
        source_model_tag_ = source_model_tag

        # Validate arguments against known Juju API types.
        if application_token_ is not None and not isinstance(application_token_, (bytes, str)):
            raise Exception("Expected application_token_ to be a str, received: {}".format(type(application_token_)))

        if bakery_version_ is not None and not isinstance(bakery_version_, int):
            raise Exception("Expected bakery_version_ to be a int, received: {}".format(type(bakery_version_)))

        if local_endpoint_name_ is not None and not isinstance(local_endpoint_name_, (bytes, str)):
            raise Exception("Expected local_endpoint_name_ to be a str, received: {}".format(type(local_endpoint_name_)))

        if macaroons_ is not None and not isinstance(macaroons_, (bytes, str, list)):
            raise Exception("Expected macaroons_ to be a Sequence, received: {}".format(type(macaroons_)))

        if offer_uuid_ is not None and not isinstance(offer_uuid_, (bytes, str)):
            raise Exception("Expected offer_uuid_ to be a str, received: {}".format(type(offer_uuid_)))

        if relation_token_ is not None and not isinstance(relation_token_, (bytes, str)):
            raise Exception("Expected relation_token_ to be a str, received: {}".format(type(relation_token_)))

        if remote_endpoint_ is not None and not isinstance(remote_endpoint_, (dict, RemoteEndpoint)):
            raise Exception("Expected remote_endpoint_ to be a RemoteEndpoint, received: {}".format(type(remote_endpoint_)))

        if remote_space_ is not None and not isinstance(remote_space_, (dict, RemoteSpace)):
            raise Exception("Expected remote_space_ to be a RemoteSpace, received: {}".format(type(remote_space_)))

        if source_model_tag_ is not None and not isinstance(source_model_tag_, (bytes, str)):
            raise Exception("Expected source_model_tag_ to be a str, received: {}".format(type(source_model_tag_)))

        self.application_token = application_token_
        self.bakery_version = bakery_version_
        self.local_endpoint_name = local_endpoint_name_
        self.macaroons = macaroons_
        self.offer_uuid = offer_uuid_
        self.relation_token = relation_token_
        self.remote_endpoint = remote_endpoint_
        self.remote_space = remote_space_
        self.source_model_tag = source_model_tag_
        self.unknown_fields = unknown_fields



class RegisterRemoteRelationArgs(Type):
    _toSchema = {'relations': 'relations'}
    _toPy = {'relations': 'relations'}
    def __init__(self, relations=None, **unknown_fields):
        '''
        relations : typing.Sequence[~RegisterRemoteRelationArg]
        '''
        relations_ = [RegisterRemoteRelationArg.from_json(o) for o in relations or []]

        # Validate arguments against known Juju API types.
        if relations_ is not None and not isinstance(relations_, (bytes, str, list)):
            raise Exception("Expected relations_ to be a Sequence, received: {}".format(type(relations_)))

        self.relations = relations_
        self.unknown_fields = unknown_fields



class RegisterRemoteRelationResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : RemoteRelationDetails
        '''
        error_ = Error.from_json(error) if error else None
        result_ = RemoteRelationDetails.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, RemoteRelationDetails)):
            raise Exception("Expected result_ to be a RemoteRelationDetails, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class RegisterRemoteRelationResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RegisterRemoteRelationResult]
        '''
        results_ = [RegisterRemoteRelationResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RelationChange(Type):
    _toSchema = {'changedunits': 'changedunits', 'departedunits': 'departedunits', 'id_': 'id', 'life': 'life'}
    _toPy = {'changedunits': 'changedunits', 'departedunits': 'departedunits', 'id': 'id_', 'life': 'life'}
    def __init__(self, changedunits=None, departedunits=None, id_=None, life=None, **unknown_fields):
        '''
        changedunits : typing.Mapping[str, ~RelationUnitChange]
        departedunits : typing.Sequence[str]
        id_ : int
        life : str
        '''
        changedunits_ = {k: RelationUnitChange.from_json(v) for k, v in (changedunits or dict()).items()}
        departedunits_ = departedunits
        id__ = id_
        life_ = life

        # Validate arguments against known Juju API types.
        if changedunits_ is not None and not isinstance(changedunits_, dict):
            raise Exception("Expected changedunits_ to be a Mapping, received: {}".format(type(changedunits_)))

        if departedunits_ is not None and not isinstance(departedunits_, (bytes, str, list)):
            raise Exception("Expected departedunits_ to be a Sequence, received: {}".format(type(departedunits_)))

        if id__ is not None and not isinstance(id__, int):
            raise Exception("Expected id__ to be a int, received: {}".format(type(id__)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        self.changedunits = changedunits_
        self.departedunits = departedunits_
        self.id_ = id__
        self.life = life_
        self.unknown_fields = unknown_fields



class RelationData(Type):
    _toSchema = {'inscope': 'InScope', 'unitdata': 'UnitData'}
    _toPy = {'InScope': 'inscope', 'UnitData': 'unitdata'}
    def __init__(self, inscope=None, unitdata=None, **unknown_fields):
        '''
        inscope : bool
        unitdata : typing.Mapping[str, typing.Any]
        '''
        inscope_ = inscope
        unitdata_ = unitdata

        # Validate arguments against known Juju API types.
        if inscope_ is not None and not isinstance(inscope_, bool):
            raise Exception("Expected inscope_ to be a bool, received: {}".format(type(inscope_)))

        if unitdata_ is not None and not isinstance(unitdata_, dict):
            raise Exception("Expected unitdata_ to be a Mapping, received: {}".format(type(unitdata_)))

        self.inscope = inscope_
        self.unitdata = unitdata_
        self.unknown_fields = unknown_fields



class RelationIds(Type):
    _toSchema = {'relation_ids': 'relation-ids'}
    _toPy = {'relation-ids': 'relation_ids'}
    def __init__(self, relation_ids=None, **unknown_fields):
        '''
        relation_ids : typing.Sequence[int]
        '''
        relation_ids_ = relation_ids

        # Validate arguments against known Juju API types.
        if relation_ids_ is not None and not isinstance(relation_ids_, (bytes, str, list)):
            raise Exception("Expected relation_ids_ to be a Sequence, received: {}".format(type(relation_ids_)))

        self.relation_ids = relation_ids_
        self.unknown_fields = unknown_fields



class RelationLifeSuspendedStatusChange(Type):
    _toSchema = {'key': 'key', 'life': 'life', 'suspended': 'suspended', 'suspended_reason': 'suspended-reason'}
    _toPy = {'key': 'key', 'life': 'life', 'suspended': 'suspended', 'suspended-reason': 'suspended_reason'}
    def __init__(self, key=None, life=None, suspended=None, suspended_reason=None, **unknown_fields):
        '''
        key : str
        life : str
        suspended : bool
        suspended_reason : str
        '''
        key_ = key
        life_ = life
        suspended_ = suspended
        suspended_reason_ = suspended_reason

        # Validate arguments against known Juju API types.
        if key_ is not None and not isinstance(key_, (bytes, str)):
            raise Exception("Expected key_ to be a str, received: {}".format(type(key_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if suspended_ is not None and not isinstance(suspended_, bool):
            raise Exception("Expected suspended_ to be a bool, received: {}".format(type(suspended_)))

        if suspended_reason_ is not None and not isinstance(suspended_reason_, (bytes, str)):
            raise Exception("Expected suspended_reason_ to be a str, received: {}".format(type(suspended_reason_)))

        self.key = key_
        self.life = life_
        self.suspended = suspended_
        self.suspended_reason = suspended_reason_
        self.unknown_fields = unknown_fields



class RelationLifeSuspendedStatusWatchResult(Type):
    _toSchema = {'changes': 'changes', 'error': 'error', 'watcher_id': 'watcher-id'}
    _toPy = {'changes': 'changes', 'error': 'error', 'watcher-id': 'watcher_id'}
    def __init__(self, changes=None, error=None, watcher_id=None, **unknown_fields):
        '''
        changes : typing.Sequence[~RelationLifeSuspendedStatusChange]
        error : Error
        watcher_id : str
        '''
        changes_ = [RelationLifeSuspendedStatusChange.from_json(o) for o in changes or []]
        error_ = Error.from_json(error) if error else None
        watcher_id_ = watcher_id

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if watcher_id_ is not None and not isinstance(watcher_id_, (bytes, str)):
            raise Exception("Expected watcher_id_ to be a str, received: {}".format(type(watcher_id_)))

        self.changes = changes_
        self.error = error_
        self.watcher_id = watcher_id_
        self.unknown_fields = unknown_fields



class RelationResult(Type):
    _toSchema = {'bool_': 'bool', 'endpoint': 'endpoint', 'error': 'error', 'id_': 'id', 'key': 'key', 'life': 'life', 'other_application': 'other-application'}
    _toPy = {'bool': 'bool_', 'endpoint': 'endpoint', 'error': 'error', 'id': 'id_', 'key': 'key', 'life': 'life', 'other-application': 'other_application'}
    def __init__(self, bool_=None, endpoint=None, error=None, id_=None, key=None, life=None, other_application=None, **unknown_fields):
        '''
        bool_ : bool
        endpoint : Endpoint
        error : Error
        id_ : int
        key : str
        life : str
        other_application : str
        '''
        bool__ = bool_
        endpoint_ = Endpoint.from_json(endpoint) if endpoint else None
        error_ = Error.from_json(error) if error else None
        id__ = id_
        key_ = key
        life_ = life
        other_application_ = other_application

        # Validate arguments against known Juju API types.
        if bool__ is not None and not isinstance(bool__, bool):
            raise Exception("Expected bool__ to be a bool, received: {}".format(type(bool__)))

        if endpoint_ is not None and not isinstance(endpoint_, (dict, Endpoint)):
            raise Exception("Expected endpoint_ to be a Endpoint, received: {}".format(type(endpoint_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if id__ is not None and not isinstance(id__, int):
            raise Exception("Expected id__ to be a int, received: {}".format(type(id__)))

        if key_ is not None and not isinstance(key_, (bytes, str)):
            raise Exception("Expected key_ to be a str, received: {}".format(type(key_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if other_application_ is not None and not isinstance(other_application_, (bytes, str)):
            raise Exception("Expected other_application_ to be a str, received: {}".format(type(other_application_)))

        self.bool_ = bool__
        self.endpoint = endpoint_
        self.error = error_
        self.id_ = id__
        self.key = key_
        self.life = life_
        self.other_application = other_application_
        self.unknown_fields = unknown_fields



class RelationResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RelationResult]
        '''
        results_ = [RelationResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RelationStatus(Type):
    _toSchema = {'endpoints': 'endpoints', 'id_': 'id', 'interface': 'interface', 'key': 'key', 'scope': 'scope', 'status': 'status'}
    _toPy = {'endpoints': 'endpoints', 'id': 'id_', 'interface': 'interface', 'key': 'key', 'scope': 'scope', 'status': 'status'}
    def __init__(self, endpoints=None, id_=None, interface=None, key=None, scope=None, status=None, **unknown_fields):
        '''
        endpoints : typing.Sequence[~EndpointStatus]
        id_ : int
        interface : str
        key : str
        scope : str
        status : DetailedStatus
        '''
        endpoints_ = [EndpointStatus.from_json(o) for o in endpoints or []]
        id__ = id_
        interface_ = interface
        key_ = key
        scope_ = scope
        status_ = DetailedStatus.from_json(status) if status else None

        # Validate arguments against known Juju API types.
        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if id__ is not None and not isinstance(id__, int):
            raise Exception("Expected id__ to be a int, received: {}".format(type(id__)))

        if interface_ is not None and not isinstance(interface_, (bytes, str)):
            raise Exception("Expected interface_ to be a str, received: {}".format(type(interface_)))

        if key_ is not None and not isinstance(key_, (bytes, str)):
            raise Exception("Expected key_ to be a str, received: {}".format(type(key_)))

        if scope_ is not None and not isinstance(scope_, (bytes, str)):
            raise Exception("Expected scope_ to be a str, received: {}".format(type(scope_)))

        if status_ is not None and not isinstance(status_, (dict, DetailedStatus)):
            raise Exception("Expected status_ to be a DetailedStatus, received: {}".format(type(status_)))

        self.endpoints = endpoints_
        self.id_ = id__
        self.interface = interface_
        self.key = key_
        self.scope = scope_
        self.status = status_
        self.unknown_fields = unknown_fields



class RelationStatusArg(Type):
    _toSchema = {'message': 'message', 'relation_id': 'relation-id', 'status': 'status', 'unit_tag': 'unit-tag'}
    _toPy = {'message': 'message', 'relation-id': 'relation_id', 'status': 'status', 'unit-tag': 'unit_tag'}
    def __init__(self, message=None, relation_id=None, status=None, unit_tag=None, **unknown_fields):
        '''
        message : str
        relation_id : int
        status : str
        unit_tag : str
        '''
        message_ = message
        relation_id_ = relation_id
        status_ = status
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if relation_id_ is not None and not isinstance(relation_id_, int):
            raise Exception("Expected relation_id_ to be a int, received: {}".format(type(relation_id_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.message = message_
        self.relation_id = relation_id_
        self.status = status_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class RelationStatusArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~RelationStatusArg]
        '''
        args_ = [RelationStatusArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class RelationStatusWatchResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RelationLifeSuspendedStatusWatchResult]
        '''
        results_ = [RelationLifeSuspendedStatusWatchResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RelationSuspendedArg(Type):
    _toSchema = {'message': 'message', 'relation_id': 'relation-id', 'suspended': 'suspended'}
    _toPy = {'message': 'message', 'relation-id': 'relation_id', 'suspended': 'suspended'}
    def __init__(self, message=None, relation_id=None, suspended=None, **unknown_fields):
        '''
        message : str
        relation_id : int
        suspended : bool
        '''
        message_ = message
        relation_id_ = relation_id
        suspended_ = suspended

        # Validate arguments against known Juju API types.
        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        if relation_id_ is not None and not isinstance(relation_id_, int):
            raise Exception("Expected relation_id_ to be a int, received: {}".format(type(relation_id_)))

        if suspended_ is not None and not isinstance(suspended_, bool):
            raise Exception("Expected suspended_ to be a bool, received: {}".format(type(suspended_)))

        self.message = message_
        self.relation_id = relation_id_
        self.suspended = suspended_
        self.unknown_fields = unknown_fields



class RelationSuspendedArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~RelationSuspendedArg]
        '''
        args_ = [RelationSuspendedArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class RelationUnit(Type):
    _toSchema = {'relation': 'relation', 'unit': 'unit'}
    _toPy = {'relation': 'relation', 'unit': 'unit'}
    def __init__(self, relation=None, unit=None, **unknown_fields):
        '''
        relation : str
        unit : str
        '''
        relation_ = relation
        unit_ = unit

        # Validate arguments against known Juju API types.
        if relation_ is not None and not isinstance(relation_, (bytes, str)):
            raise Exception("Expected relation_ to be a str, received: {}".format(type(relation_)))

        if unit_ is not None and not isinstance(unit_, (bytes, str)):
            raise Exception("Expected unit_ to be a str, received: {}".format(type(unit_)))

        self.relation = relation_
        self.unit = unit_
        self.unknown_fields = unknown_fields



class RelationUnitChange(Type):
    _toSchema = {'settings': 'settings'}
    _toPy = {'settings': 'settings'}
    def __init__(self, settings=None, **unknown_fields):
        '''
        settings : typing.Mapping[str, typing.Any]
        '''
        settings_ = settings

        # Validate arguments against known Juju API types.
        if settings_ is not None and not isinstance(settings_, dict):
            raise Exception("Expected settings_ to be a Mapping, received: {}".format(type(settings_)))

        self.settings = settings_
        self.unknown_fields = unknown_fields



class RelationUnitPair(Type):
    _toSchema = {'local_unit': 'local-unit', 'relation': 'relation', 'remote_unit': 'remote-unit'}
    _toPy = {'local-unit': 'local_unit', 'relation': 'relation', 'remote-unit': 'remote_unit'}
    def __init__(self, local_unit=None, relation=None, remote_unit=None, **unknown_fields):
        '''
        local_unit : str
        relation : str
        remote_unit : str
        '''
        local_unit_ = local_unit
        relation_ = relation
        remote_unit_ = remote_unit

        # Validate arguments against known Juju API types.
        if local_unit_ is not None and not isinstance(local_unit_, (bytes, str)):
            raise Exception("Expected local_unit_ to be a str, received: {}".format(type(local_unit_)))

        if relation_ is not None and not isinstance(relation_, (bytes, str)):
            raise Exception("Expected relation_ to be a str, received: {}".format(type(relation_)))

        if remote_unit_ is not None and not isinstance(remote_unit_, (bytes, str)):
            raise Exception("Expected remote_unit_ to be a str, received: {}".format(type(remote_unit_)))

        self.local_unit = local_unit_
        self.relation = relation_
        self.remote_unit = remote_unit_
        self.unknown_fields = unknown_fields



class RelationUnitPairs(Type):
    _toSchema = {'relation_unit_pairs': 'relation-unit-pairs'}
    _toPy = {'relation-unit-pairs': 'relation_unit_pairs'}
    def __init__(self, relation_unit_pairs=None, **unknown_fields):
        '''
        relation_unit_pairs : typing.Sequence[~RelationUnitPair]
        '''
        relation_unit_pairs_ = [RelationUnitPair.from_json(o) for o in relation_unit_pairs or []]

        # Validate arguments against known Juju API types.
        if relation_unit_pairs_ is not None and not isinstance(relation_unit_pairs_, (bytes, str, list)):
            raise Exception("Expected relation_unit_pairs_ to be a Sequence, received: {}".format(type(relation_unit_pairs_)))

        self.relation_unit_pairs = relation_unit_pairs_
        self.unknown_fields = unknown_fields



class RelationUnitSettings(Type):
    _toSchema = {'application_settings': 'application-settings', 'relation': 'relation', 'settings': 'settings', 'unit': 'unit'}
    _toPy = {'application-settings': 'application_settings', 'relation': 'relation', 'settings': 'settings', 'unit': 'unit'}
    def __init__(self, application_settings=None, relation=None, settings=None, unit=None, **unknown_fields):
        '''
        application_settings : typing.Mapping[str, str]
        relation : str
        settings : typing.Mapping[str, str]
        unit : str
        '''
        application_settings_ = application_settings
        relation_ = relation
        settings_ = settings
        unit_ = unit

        # Validate arguments against known Juju API types.
        if application_settings_ is not None and not isinstance(application_settings_, dict):
            raise Exception("Expected application_settings_ to be a Mapping, received: {}".format(type(application_settings_)))

        if relation_ is not None and not isinstance(relation_, (bytes, str)):
            raise Exception("Expected relation_ to be a str, received: {}".format(type(relation_)))

        if settings_ is not None and not isinstance(settings_, dict):
            raise Exception("Expected settings_ to be a Mapping, received: {}".format(type(settings_)))

        if unit_ is not None and not isinstance(unit_, (bytes, str)):
            raise Exception("Expected unit_ to be a str, received: {}".format(type(unit_)))

        self.application_settings = application_settings_
        self.relation = relation_
        self.settings = settings_
        self.unit = unit_
        self.unknown_fields = unknown_fields



class RelationUnitStatus(Type):
    _toSchema = {'in_scope': 'in-scope', 'relation_tag': 'relation-tag', 'suspended': 'suspended'}
    _toPy = {'in-scope': 'in_scope', 'relation-tag': 'relation_tag', 'suspended': 'suspended'}
    def __init__(self, in_scope=None, relation_tag=None, suspended=None, **unknown_fields):
        '''
        in_scope : bool
        relation_tag : str
        suspended : bool
        '''
        in_scope_ = in_scope
        relation_tag_ = relation_tag
        suspended_ = suspended

        # Validate arguments against known Juju API types.
        if in_scope_ is not None and not isinstance(in_scope_, bool):
            raise Exception("Expected in_scope_ to be a bool, received: {}".format(type(in_scope_)))

        if relation_tag_ is not None and not isinstance(relation_tag_, (bytes, str)):
            raise Exception("Expected relation_tag_ to be a str, received: {}".format(type(relation_tag_)))

        if suspended_ is not None and not isinstance(suspended_, bool):
            raise Exception("Expected suspended_ to be a bool, received: {}".format(type(suspended_)))

        self.in_scope = in_scope_
        self.relation_tag = relation_tag_
        self.suspended = suspended_
        self.unknown_fields = unknown_fields



class RelationUnitStatusResult(Type):
    _toSchema = {'error': 'error', 'results': 'results'}
    _toPy = {'error': 'error', 'results': 'results'}
    def __init__(self, error=None, results=None, **unknown_fields):
        '''
        error : Error
        results : typing.Sequence[~RelationUnitStatus]
        '''
        error_ = Error.from_json(error) if error else None
        results_ = [RelationUnitStatus.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.error = error_
        self.results = results_
        self.unknown_fields = unknown_fields



class RelationUnitStatusResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RelationUnitStatusResult]
        '''
        results_ = [RelationUnitStatusResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RelationUnits(Type):
    _toSchema = {'relation_units': 'relation-units'}
    _toPy = {'relation-units': 'relation_units'}
    def __init__(self, relation_units=None, **unknown_fields):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        '''
        relation_units_ = [RelationUnit.from_json(o) for o in relation_units or []]

        # Validate arguments against known Juju API types.
        if relation_units_ is not None and not isinstance(relation_units_, (bytes, str, list)):
            raise Exception("Expected relation_units_ to be a Sequence, received: {}".format(type(relation_units_)))

        self.relation_units = relation_units_
        self.unknown_fields = unknown_fields



class RelationUnitsChange(Type):
    _toSchema = {'app_changed': 'app-changed', 'changed': 'changed', 'departed': 'departed'}
    _toPy = {'app-changed': 'app_changed', 'changed': 'changed', 'departed': 'departed'}
    def __init__(self, app_changed=None, changed=None, departed=None, **unknown_fields):
        '''
        app_changed : typing.Mapping[str, int]
        changed : typing.Mapping[str, ~UnitSettings]
        departed : typing.Sequence[str]
        '''
        app_changed_ = app_changed
        changed_ = {k: UnitSettings.from_json(v) for k, v in (changed or dict()).items()}
        departed_ = departed

        # Validate arguments against known Juju API types.
        if app_changed_ is not None and not isinstance(app_changed_, dict):
            raise Exception("Expected app_changed_ to be a Mapping, received: {}".format(type(app_changed_)))

        if changed_ is not None and not isinstance(changed_, dict):
            raise Exception("Expected changed_ to be a Mapping, received: {}".format(type(changed_)))

        if departed_ is not None and not isinstance(departed_, (bytes, str, list)):
            raise Exception("Expected departed_ to be a Sequence, received: {}".format(type(departed_)))

        self.app_changed = app_changed_
        self.changed = changed_
        self.departed = departed_
        self.unknown_fields = unknown_fields



class RelationUnitsSettings(Type):
    _toSchema = {'relation_units': 'relation-units'}
    _toPy = {'relation-units': 'relation_units'}
    def __init__(self, relation_units=None, **unknown_fields):
        '''
        relation_units : typing.Sequence[~RelationUnitSettings]
        '''
        relation_units_ = [RelationUnitSettings.from_json(o) for o in relation_units or []]

        # Validate arguments against known Juju API types.
        if relation_units_ is not None and not isinstance(relation_units_, (bytes, str, list)):
            raise Exception("Expected relation_units_ to be a Sequence, received: {}".format(type(relation_units_)))

        self.relation_units = relation_units_
        self.unknown_fields = unknown_fields



class RelationUnitsWatchResult(Type):
    _toSchema = {'changes': 'changes', 'error': 'error', 'watcher_id': 'watcher-id'}
    _toPy = {'changes': 'changes', 'error': 'error', 'watcher-id': 'watcher_id'}
    def __init__(self, changes=None, error=None, watcher_id=None, **unknown_fields):
        '''
        changes : RelationUnitsChange
        error : Error
        watcher_id : str
        '''
        changes_ = RelationUnitsChange.from_json(changes) if changes else None
        error_ = Error.from_json(error) if error else None
        watcher_id_ = watcher_id

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (dict, RelationUnitsChange)):
            raise Exception("Expected changes_ to be a RelationUnitsChange, received: {}".format(type(changes_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if watcher_id_ is not None and not isinstance(watcher_id_, (bytes, str)):
            raise Exception("Expected watcher_id_ to be a str, received: {}".format(type(watcher_id_)))

        self.changes = changes_
        self.error = error_
        self.watcher_id = watcher_id_
        self.unknown_fields = unknown_fields



class RelationUnitsWatchResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RelationUnitsWatchResult]
        '''
        results_ = [RelationUnitsWatchResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RemoteApplication(Type):
    _toSchema = {'is_consumer_proxy': 'is-consumer-proxy', 'life': 'life', 'macaroon': 'macaroon', 'model_uuid': 'model-uuid', 'name': 'name', 'offer_uuid': 'offer-uuid', 'status': 'status'}
    _toPy = {'is-consumer-proxy': 'is_consumer_proxy', 'life': 'life', 'macaroon': 'macaroon', 'model-uuid': 'model_uuid', 'name': 'name', 'offer-uuid': 'offer_uuid', 'status': 'status'}
    def __init__(self, is_consumer_proxy=None, life=None, macaroon=None, model_uuid=None, name=None, offer_uuid=None, status=None, **unknown_fields):
        '''
        is_consumer_proxy : bool
        life : str
        macaroon : Macaroon
        model_uuid : str
        name : str
        offer_uuid : str
        status : str
        '''
        is_consumer_proxy_ = is_consumer_proxy
        life_ = life
        macaroon_ = Macaroon.from_json(macaroon) if macaroon else None
        model_uuid_ = model_uuid
        name_ = name
        offer_uuid_ = offer_uuid
        status_ = status

        # Validate arguments against known Juju API types.
        if is_consumer_proxy_ is not None and not isinstance(is_consumer_proxy_, bool):
            raise Exception("Expected is_consumer_proxy_ to be a bool, received: {}".format(type(is_consumer_proxy_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if macaroon_ is not None and not isinstance(macaroon_, (dict, Macaroon)):
            raise Exception("Expected macaroon_ to be a Macaroon, received: {}".format(type(macaroon_)))

        if model_uuid_ is not None and not isinstance(model_uuid_, (bytes, str)):
            raise Exception("Expected model_uuid_ to be a str, received: {}".format(type(model_uuid_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if offer_uuid_ is not None and not isinstance(offer_uuid_, (bytes, str)):
            raise Exception("Expected offer_uuid_ to be a str, received: {}".format(type(offer_uuid_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.is_consumer_proxy = is_consumer_proxy_
        self.life = life_
        self.macaroon = macaroon_
        self.model_uuid = model_uuid_
        self.name = name_
        self.offer_uuid = offer_uuid_
        self.status = status_
        self.unknown_fields = unknown_fields



class RemoteApplicationChange(Type):
    _toSchema = {'application_tag': 'application-tag', 'life': 'life', 'relations': 'relations'}
    _toPy = {'application-tag': 'application_tag', 'life': 'life', 'relations': 'relations'}
    def __init__(self, application_tag=None, life=None, relations=None, **unknown_fields):
        '''
        application_tag : str
        life : str
        relations : RemoteRelationsChange
        '''
        application_tag_ = application_tag
        life_ = life
        relations_ = RemoteRelationsChange.from_json(relations) if relations else None

        # Validate arguments against known Juju API types.
        if application_tag_ is not None and not isinstance(application_tag_, (bytes, str)):
            raise Exception("Expected application_tag_ to be a str, received: {}".format(type(application_tag_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if relations_ is not None and not isinstance(relations_, (dict, RemoteRelationsChange)):
            raise Exception("Expected relations_ to be a RemoteRelationsChange, received: {}".format(type(relations_)))

        self.application_tag = application_tag_
        self.life = life_
        self.relations = relations_
        self.unknown_fields = unknown_fields



class RemoteApplicationInfo(Type):
    _toSchema = {'description': 'description', 'endpoints': 'endpoints', 'icon_url_path': 'icon-url-path', 'model_tag': 'model-tag', 'name': 'name', 'offer_url': 'offer-url', 'source_model_label': 'source-model-label'}
    _toPy = {'description': 'description', 'endpoints': 'endpoints', 'icon-url-path': 'icon_url_path', 'model-tag': 'model_tag', 'name': 'name', 'offer-url': 'offer_url', 'source-model-label': 'source_model_label'}
    def __init__(self, description=None, endpoints=None, icon_url_path=None, model_tag=None, name=None, offer_url=None, source_model_label=None, **unknown_fields):
        '''
        description : str
        endpoints : typing.Sequence[~RemoteEndpoint]
        icon_url_path : str
        model_tag : str
        name : str
        offer_url : str
        source_model_label : str
        '''
        description_ = description
        endpoints_ = [RemoteEndpoint.from_json(o) for o in endpoints or []]
        icon_url_path_ = icon_url_path
        model_tag_ = model_tag
        name_ = name
        offer_url_ = offer_url
        source_model_label_ = source_model_label

        # Validate arguments against known Juju API types.
        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if icon_url_path_ is not None and not isinstance(icon_url_path_, (bytes, str)):
            raise Exception("Expected icon_url_path_ to be a str, received: {}".format(type(icon_url_path_)))

        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if offer_url_ is not None and not isinstance(offer_url_, (bytes, str)):
            raise Exception("Expected offer_url_ to be a str, received: {}".format(type(offer_url_)))

        if source_model_label_ is not None and not isinstance(source_model_label_, (bytes, str)):
            raise Exception("Expected source_model_label_ to be a str, received: {}".format(type(source_model_label_)))

        self.description = description_
        self.endpoints = endpoints_
        self.icon_url_path = icon_url_path_
        self.model_tag = model_tag_
        self.name = name_
        self.offer_url = offer_url_
        self.source_model_label = source_model_label_
        self.unknown_fields = unknown_fields



class RemoteApplicationInfoResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : RemoteApplicationInfo
        '''
        error_ = Error.from_json(error) if error else None
        result_ = RemoteApplicationInfo.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, RemoteApplicationInfo)):
            raise Exception("Expected result_ to be a RemoteApplicationInfo, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class RemoteApplicationInfoResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RemoteApplicationInfoResult]
        '''
        results_ = [RemoteApplicationInfoResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RemoteApplicationResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : RemoteApplication
        '''
        error_ = Error.from_json(error) if error else None
        result_ = RemoteApplication.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, RemoteApplication)):
            raise Exception("Expected result_ to be a RemoteApplication, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class RemoteApplicationResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RemoteApplicationResult]
        '''
        results_ = [RemoteApplicationResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RemoteApplicationStatus(Type):
    _toSchema = {'endpoints': 'endpoints', 'err': 'err', 'life': 'life', 'offer_name': 'offer-name', 'offer_url': 'offer-url', 'relations': 'relations', 'status': 'status'}
    _toPy = {'endpoints': 'endpoints', 'err': 'err', 'life': 'life', 'offer-name': 'offer_name', 'offer-url': 'offer_url', 'relations': 'relations', 'status': 'status'}
    def __init__(self, endpoints=None, err=None, life=None, offer_name=None, offer_url=None, relations=None, status=None, **unknown_fields):
        '''
        endpoints : typing.Sequence[~RemoteEndpoint]
        err : Error
        life : str
        offer_name : str
        offer_url : str
        relations : typing.Mapping[str, typing.Sequence[str]]
        status : DetailedStatus
        '''
        endpoints_ = [RemoteEndpoint.from_json(o) for o in endpoints or []]
        err_ = Error.from_json(err) if err else None
        life_ = life
        offer_name_ = offer_name
        offer_url_ = offer_url
        relations_ = relations
        status_ = DetailedStatus.from_json(status) if status else None

        # Validate arguments against known Juju API types.
        if endpoints_ is not None and not isinstance(endpoints_, (bytes, str, list)):
            raise Exception("Expected endpoints_ to be a Sequence, received: {}".format(type(endpoints_)))

        if err_ is not None and not isinstance(err_, (dict, Error)):
            raise Exception("Expected err_ to be a Error, received: {}".format(type(err_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if offer_name_ is not None and not isinstance(offer_name_, (bytes, str)):
            raise Exception("Expected offer_name_ to be a str, received: {}".format(type(offer_name_)))

        if offer_url_ is not None and not isinstance(offer_url_, (bytes, str)):
            raise Exception("Expected offer_url_ to be a str, received: {}".format(type(offer_url_)))

        if relations_ is not None and not isinstance(relations_, dict):
            raise Exception("Expected relations_ to be a Mapping, received: {}".format(type(relations_)))

        if status_ is not None and not isinstance(status_, (dict, DetailedStatus)):
            raise Exception("Expected status_ to be a DetailedStatus, received: {}".format(type(status_)))

        self.endpoints = endpoints_
        self.err = err_
        self.life = life_
        self.offer_name = offer_name_
        self.offer_url = offer_url_
        self.relations = relations_
        self.status = status_
        self.unknown_fields = unknown_fields



class RemoteApplicationWatchResult(Type):
    _toSchema = {'change': 'change', 'error': 'error', 'id_': 'id'}
    _toPy = {'change': 'change', 'error': 'error', 'id': 'id_'}
    def __init__(self, change=None, error=None, id_=None, **unknown_fields):
        '''
        change : RemoteApplicationChange
        error : Error
        id_ : str
        '''
        change_ = RemoteApplicationChange.from_json(change) if change else None
        error_ = Error.from_json(error) if error else None
        id__ = id_

        # Validate arguments against known Juju API types.
        if change_ is not None and not isinstance(change_, (dict, RemoteApplicationChange)):
            raise Exception("Expected change_ to be a RemoteApplicationChange, received: {}".format(type(change_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        self.change = change_
        self.error = error_
        self.id_ = id__
        self.unknown_fields = unknown_fields



class RemoteEndpoint(Type):
    _toSchema = {'interface': 'interface', 'limit': 'limit', 'name': 'name', 'role': 'role'}
    _toPy = {'interface': 'interface', 'limit': 'limit', 'name': 'name', 'role': 'role'}
    def __init__(self, interface=None, limit=None, name=None, role=None, **unknown_fields):
        '''
        interface : str
        limit : int
        name : str
        role : str
        '''
        interface_ = interface
        limit_ = limit
        name_ = name
        role_ = role

        # Validate arguments against known Juju API types.
        if interface_ is not None and not isinstance(interface_, (bytes, str)):
            raise Exception("Expected interface_ to be a str, received: {}".format(type(interface_)))

        if limit_ is not None and not isinstance(limit_, int):
            raise Exception("Expected limit_ to be a int, received: {}".format(type(limit_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if role_ is not None and not isinstance(role_, (bytes, str)):
            raise Exception("Expected role_ to be a str, received: {}".format(type(role_)))

        self.interface = interface_
        self.limit = limit_
        self.name = name_
        self.role = role_
        self.unknown_fields = unknown_fields



class RemoteEntityArg(Type):
    _toSchema = {'bakery_version': 'bakery-version', 'macaroons': 'macaroons', 'relation_token': 'relation-token'}
    _toPy = {'bakery-version': 'bakery_version', 'macaroons': 'macaroons', 'relation-token': 'relation_token'}
    def __init__(self, bakery_version=None, macaroons=None, relation_token=None, **unknown_fields):
        '''
        bakery_version : int
        macaroons : typing.Sequence[~Macaroon]
        relation_token : str
        '''
        bakery_version_ = bakery_version
        macaroons_ = [Macaroon.from_json(o) for o in macaroons or []]
        relation_token_ = relation_token

        # Validate arguments against known Juju API types.
        if bakery_version_ is not None and not isinstance(bakery_version_, int):
            raise Exception("Expected bakery_version_ to be a int, received: {}".format(type(bakery_version_)))

        if macaroons_ is not None and not isinstance(macaroons_, (bytes, str, list)):
            raise Exception("Expected macaroons_ to be a Sequence, received: {}".format(type(macaroons_)))

        if relation_token_ is not None and not isinstance(relation_token_, (bytes, str)):
            raise Exception("Expected relation_token_ to be a str, received: {}".format(type(relation_token_)))

        self.bakery_version = bakery_version_
        self.macaroons = macaroons_
        self.relation_token = relation_token_
        self.unknown_fields = unknown_fields



class RemoteEntityArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~RemoteEntityArg]
        '''
        args_ = [RemoteEntityArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class RemoteEntityId(Type):
    _toSchema = {'model_uuid': 'model-uuid', 'token': 'token'}
    _toPy = {'model-uuid': 'model_uuid', 'token': 'token'}
    def __init__(self, model_uuid=None, token=None, **unknown_fields):
        '''
        model_uuid : str
        token : str
        '''
        model_uuid_ = model_uuid
        token_ = token

        # Validate arguments against known Juju API types.
        if model_uuid_ is not None and not isinstance(model_uuid_, (bytes, str)):
            raise Exception("Expected model_uuid_ to be a str, received: {}".format(type(model_uuid_)))

        if token_ is not None and not isinstance(token_, (bytes, str)):
            raise Exception("Expected token_ to be a str, received: {}".format(type(token_)))

        self.model_uuid = model_uuid_
        self.token = token_
        self.unknown_fields = unknown_fields



class RemoteEntityTokenArg(Type):
    _toSchema = {'tag': 'tag', 'token': 'token'}
    _toPy = {'tag': 'tag', 'token': 'token'}
    def __init__(self, tag=None, token=None, **unknown_fields):
        '''
        tag : str
        token : str
        '''
        tag_ = tag
        token_ = token

        # Validate arguments against known Juju API types.
        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if token_ is not None and not isinstance(token_, (bytes, str)):
            raise Exception("Expected token_ to be a str, received: {}".format(type(token_)))

        self.tag = tag_
        self.token = token_
        self.unknown_fields = unknown_fields



class RemoteEntityTokenArgs(Type):
    _toSchema = {'args': 'Args'}
    _toPy = {'Args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~RemoteEntityTokenArg]
        '''
        args_ = [RemoteEntityTokenArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class RemoteRelation(Type):
    _toSchema = {'application_name': 'application-name', 'endpoint': 'endpoint', 'id_': 'id', 'key': 'key', 'life': 'life', 'remote_application_name': 'remote-application-name', 'remote_endpoint_name': 'remote-endpoint-name', 'source_model_uuid': 'source-model-uuid', 'suspended': 'suspended'}
    _toPy = {'application-name': 'application_name', 'endpoint': 'endpoint', 'id': 'id_', 'key': 'key', 'life': 'life', 'remote-application-name': 'remote_application_name', 'remote-endpoint-name': 'remote_endpoint_name', 'source-model-uuid': 'source_model_uuid', 'suspended': 'suspended'}
    def __init__(self, application_name=None, endpoint=None, id_=None, key=None, life=None, remote_application_name=None, remote_endpoint_name=None, source_model_uuid=None, suspended=None, **unknown_fields):
        '''
        application_name : str
        endpoint : RemoteEndpoint
        id_ : int
        key : str
        life : str
        remote_application_name : str
        remote_endpoint_name : str
        source_model_uuid : str
        suspended : bool
        '''
        application_name_ = application_name
        endpoint_ = RemoteEndpoint.from_json(endpoint) if endpoint else None
        id__ = id_
        key_ = key
        life_ = life
        remote_application_name_ = remote_application_name
        remote_endpoint_name_ = remote_endpoint_name
        source_model_uuid_ = source_model_uuid
        suspended_ = suspended

        # Validate arguments against known Juju API types.
        if application_name_ is not None and not isinstance(application_name_, (bytes, str)):
            raise Exception("Expected application_name_ to be a str, received: {}".format(type(application_name_)))

        if endpoint_ is not None and not isinstance(endpoint_, (dict, RemoteEndpoint)):
            raise Exception("Expected endpoint_ to be a RemoteEndpoint, received: {}".format(type(endpoint_)))

        if id__ is not None and not isinstance(id__, int):
            raise Exception("Expected id__ to be a int, received: {}".format(type(id__)))

        if key_ is not None and not isinstance(key_, (bytes, str)):
            raise Exception("Expected key_ to be a str, received: {}".format(type(key_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if remote_application_name_ is not None and not isinstance(remote_application_name_, (bytes, str)):
            raise Exception("Expected remote_application_name_ to be a str, received: {}".format(type(remote_application_name_)))

        if remote_endpoint_name_ is not None and not isinstance(remote_endpoint_name_, (bytes, str)):
            raise Exception("Expected remote_endpoint_name_ to be a str, received: {}".format(type(remote_endpoint_name_)))

        if source_model_uuid_ is not None and not isinstance(source_model_uuid_, (bytes, str)):
            raise Exception("Expected source_model_uuid_ to be a str, received: {}".format(type(source_model_uuid_)))

        if suspended_ is not None and not isinstance(suspended_, bool):
            raise Exception("Expected suspended_ to be a bool, received: {}".format(type(suspended_)))

        self.application_name = application_name_
        self.endpoint = endpoint_
        self.id_ = id__
        self.key = key_
        self.life = life_
        self.remote_application_name = remote_application_name_
        self.remote_endpoint_name = remote_endpoint_name_
        self.source_model_uuid = source_model_uuid_
        self.suspended = suspended_
        self.unknown_fields = unknown_fields



class RemoteRelationChange(Type):
    _toSchema = {'changed_units': 'changed-units', 'departed_units': 'departed-units', 'id_': 'id', 'life': 'life'}
    _toPy = {'changed-units': 'changed_units', 'departed-units': 'departed_units', 'id': 'id_', 'life': 'life'}
    def __init__(self, changed_units=None, departed_units=None, id_=None, life=None, **unknown_fields):
        '''
        changed_units : typing.Mapping[str, ~RemoteRelationUnitChange]
        departed_units : typing.Sequence[str]
        id_ : int
        life : str
        '''
        changed_units_ = {k: RemoteRelationUnitChange.from_json(v) for k, v in (changed_units or dict()).items()}
        departed_units_ = departed_units
        id__ = id_
        life_ = life

        # Validate arguments against known Juju API types.
        if changed_units_ is not None and not isinstance(changed_units_, dict):
            raise Exception("Expected changed_units_ to be a Mapping, received: {}".format(type(changed_units_)))

        if departed_units_ is not None and not isinstance(departed_units_, (bytes, str, list)):
            raise Exception("Expected departed_units_ to be a Sequence, received: {}".format(type(departed_units_)))

        if id__ is not None and not isinstance(id__, int):
            raise Exception("Expected id__ to be a int, received: {}".format(type(id__)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        self.changed_units = changed_units_
        self.departed_units = departed_units_
        self.id_ = id__
        self.life = life_
        self.unknown_fields = unknown_fields



class RemoteRelationChangeEvent(Type):
    _toSchema = {'application_settings': 'application-settings', 'application_token': 'application-token', 'bakery_version': 'bakery-version', 'changed_units': 'changed-units', 'departed_units': 'departed-units', 'force_cleanup': 'force-cleanup', 'life': 'life', 'macaroons': 'macaroons', 'relation_token': 'relation-token', 'suspended': 'suspended', 'suspended_reason': 'suspended-reason', 'unit_count': 'unit-count'}
    _toPy = {'application-settings': 'application_settings', 'application-token': 'application_token', 'bakery-version': 'bakery_version', 'changed-units': 'changed_units', 'departed-units': 'departed_units', 'force-cleanup': 'force_cleanup', 'life': 'life', 'macaroons': 'macaroons', 'relation-token': 'relation_token', 'suspended': 'suspended', 'suspended-reason': 'suspended_reason', 'unit-count': 'unit_count'}
    def __init__(self, application_settings=None, application_token=None, bakery_version=None, changed_units=None, departed_units=None, force_cleanup=None, life=None, macaroons=None, relation_token=None, suspended=None, suspended_reason=None, unit_count=None, **unknown_fields):
        '''
        application_settings : typing.Mapping[str, typing.Any]
        application_token : str
        bakery_version : int
        changed_units : typing.Sequence[~RemoteRelationUnitChange]
        departed_units : typing.Sequence[int]
        force_cleanup : bool
        life : str
        macaroons : typing.Sequence[~Macaroon]
        relation_token : str
        suspended : bool
        suspended_reason : str
        unit_count : int
        '''
        application_settings_ = application_settings
        application_token_ = application_token
        bakery_version_ = bakery_version
        changed_units_ = [RemoteRelationUnitChange.from_json(o) for o in changed_units or []]
        departed_units_ = departed_units
        force_cleanup_ = force_cleanup
        life_ = life
        macaroons_ = [Macaroon.from_json(o) for o in macaroons or []]
        relation_token_ = relation_token
        suspended_ = suspended
        suspended_reason_ = suspended_reason
        unit_count_ = unit_count

        # Validate arguments against known Juju API types.
        if application_settings_ is not None and not isinstance(application_settings_, dict):
            raise Exception("Expected application_settings_ to be a Mapping, received: {}".format(type(application_settings_)))

        if application_token_ is not None and not isinstance(application_token_, (bytes, str)):
            raise Exception("Expected application_token_ to be a str, received: {}".format(type(application_token_)))

        if bakery_version_ is not None and not isinstance(bakery_version_, int):
            raise Exception("Expected bakery_version_ to be a int, received: {}".format(type(bakery_version_)))

        if changed_units_ is not None and not isinstance(changed_units_, (bytes, str, list)):
            raise Exception("Expected changed_units_ to be a Sequence, received: {}".format(type(changed_units_)))

        if departed_units_ is not None and not isinstance(departed_units_, (bytes, str, list)):
            raise Exception("Expected departed_units_ to be a Sequence, received: {}".format(type(departed_units_)))

        if force_cleanup_ is not None and not isinstance(force_cleanup_, bool):
            raise Exception("Expected force_cleanup_ to be a bool, received: {}".format(type(force_cleanup_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if macaroons_ is not None and not isinstance(macaroons_, (bytes, str, list)):
            raise Exception("Expected macaroons_ to be a Sequence, received: {}".format(type(macaroons_)))

        if relation_token_ is not None and not isinstance(relation_token_, (bytes, str)):
            raise Exception("Expected relation_token_ to be a str, received: {}".format(type(relation_token_)))

        if suspended_ is not None and not isinstance(suspended_, bool):
            raise Exception("Expected suspended_ to be a bool, received: {}".format(type(suspended_)))

        if suspended_reason_ is not None and not isinstance(suspended_reason_, (bytes, str)):
            raise Exception("Expected suspended_reason_ to be a str, received: {}".format(type(suspended_reason_)))

        if unit_count_ is not None and not isinstance(unit_count_, int):
            raise Exception("Expected unit_count_ to be a int, received: {}".format(type(unit_count_)))

        self.application_settings = application_settings_
        self.application_token = application_token_
        self.bakery_version = bakery_version_
        self.changed_units = changed_units_
        self.departed_units = departed_units_
        self.force_cleanup = force_cleanup_
        self.life = life_
        self.macaroons = macaroons_
        self.relation_token = relation_token_
        self.suspended = suspended_
        self.suspended_reason = suspended_reason_
        self.unit_count = unit_count_
        self.unknown_fields = unknown_fields



class RemoteRelationDetails(Type):
    _toSchema = {'bakery_version': 'bakery-version', 'macaroon': 'macaroon', 'relation_token': 'relation-token'}
    _toPy = {'bakery-version': 'bakery_version', 'macaroon': 'macaroon', 'relation-token': 'relation_token'}
    def __init__(self, bakery_version=None, macaroon=None, relation_token=None, **unknown_fields):
        '''
        bakery_version : int
        macaroon : Macaroon
        relation_token : str
        '''
        bakery_version_ = bakery_version
        macaroon_ = Macaroon.from_json(macaroon) if macaroon else None
        relation_token_ = relation_token

        # Validate arguments against known Juju API types.
        if bakery_version_ is not None and not isinstance(bakery_version_, int):
            raise Exception("Expected bakery_version_ to be a int, received: {}".format(type(bakery_version_)))

        if macaroon_ is not None and not isinstance(macaroon_, (dict, Macaroon)):
            raise Exception("Expected macaroon_ to be a Macaroon, received: {}".format(type(macaroon_)))

        if relation_token_ is not None and not isinstance(relation_token_, (bytes, str)):
            raise Exception("Expected relation_token_ to be a str, received: {}".format(type(relation_token_)))

        self.bakery_version = bakery_version_
        self.macaroon = macaroon_
        self.relation_token = relation_token_
        self.unknown_fields = unknown_fields



class RemoteRelationResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : RemoteRelation
        '''
        error_ = Error.from_json(error) if error else None
        result_ = RemoteRelation.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, RemoteRelation)):
            raise Exception("Expected result_ to be a RemoteRelation, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class RemoteRelationResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RemoteRelationResult]
        '''
        results_ = [RemoteRelationResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RemoteRelationUnit(Type):
    _toSchema = {'macaroons': 'macaroons', 'relation_token': 'relation-token', 'unit': 'unit'}
    _toPy = {'macaroons': 'macaroons', 'relation-token': 'relation_token', 'unit': 'unit'}
    def __init__(self, macaroons=None, relation_token=None, unit=None, **unknown_fields):
        '''
        macaroons : typing.Sequence[~Macaroon]
        relation_token : str
        unit : str
        '''
        macaroons_ = [Macaroon.from_json(o) for o in macaroons or []]
        relation_token_ = relation_token
        unit_ = unit

        # Validate arguments against known Juju API types.
        if macaroons_ is not None and not isinstance(macaroons_, (bytes, str, list)):
            raise Exception("Expected macaroons_ to be a Sequence, received: {}".format(type(macaroons_)))

        if relation_token_ is not None and not isinstance(relation_token_, (bytes, str)):
            raise Exception("Expected relation_token_ to be a str, received: {}".format(type(relation_token_)))

        if unit_ is not None and not isinstance(unit_, (bytes, str)):
            raise Exception("Expected unit_ to be a str, received: {}".format(type(unit_)))

        self.macaroons = macaroons_
        self.relation_token = relation_token_
        self.unit = unit_
        self.unknown_fields = unknown_fields



class RemoteRelationUnitChange(Type):
    _toSchema = {'settings': 'settings', 'unit_id': 'unit-id'}
    _toPy = {'settings': 'settings', 'unit-id': 'unit_id'}
    def __init__(self, settings=None, unit_id=None, **unknown_fields):
        '''
        settings : typing.Mapping[str, typing.Any]
        unit_id : int
        '''
        settings_ = settings
        unit_id_ = unit_id

        # Validate arguments against known Juju API types.
        if settings_ is not None and not isinstance(settings_, dict):
            raise Exception("Expected settings_ to be a Mapping, received: {}".format(type(settings_)))

        if unit_id_ is not None and not isinstance(unit_id_, int):
            raise Exception("Expected unit_id_ to be a int, received: {}".format(type(unit_id_)))

        self.settings = settings_
        self.unit_id = unit_id_
        self.unknown_fields = unknown_fields



class RemoteRelationUnits(Type):
    _toSchema = {'relation_units': 'relation-units'}
    _toPy = {'relation-units': 'relation_units'}
    def __init__(self, relation_units=None, **unknown_fields):
        '''
        relation_units : typing.Sequence[~RemoteRelationUnit]
        '''
        relation_units_ = [RemoteRelationUnit.from_json(o) for o in relation_units or []]

        # Validate arguments against known Juju API types.
        if relation_units_ is not None and not isinstance(relation_units_, (bytes, str, list)):
            raise Exception("Expected relation_units_ to be a Sequence, received: {}".format(type(relation_units_)))

        self.relation_units = relation_units_
        self.unknown_fields = unknown_fields



class RemoteRelationWatchResult(Type):
    _toSchema = {'changes': 'changes', 'error': 'error', 'watcher_id': 'watcher-id'}
    _toPy = {'changes': 'changes', 'error': 'error', 'watcher-id': 'watcher_id'}
    def __init__(self, changes=None, error=None, watcher_id=None, **unknown_fields):
        '''
        changes : RemoteRelationChangeEvent
        error : Error
        watcher_id : str
        '''
        changes_ = RemoteRelationChangeEvent.from_json(changes) if changes else None
        error_ = Error.from_json(error) if error else None
        watcher_id_ = watcher_id

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (dict, RemoteRelationChangeEvent)):
            raise Exception("Expected changes_ to be a RemoteRelationChangeEvent, received: {}".format(type(changes_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if watcher_id_ is not None and not isinstance(watcher_id_, (bytes, str)):
            raise Exception("Expected watcher_id_ to be a str, received: {}".format(type(watcher_id_)))

        self.changes = changes_
        self.error = error_
        self.watcher_id = watcher_id_
        self.unknown_fields = unknown_fields



class RemoteRelationWatchResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RemoteRelationWatchResult]
        '''
        results_ = [RemoteRelationWatchResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RemoteRelationsChange(Type):
    _toSchema = {'changed': 'changed', 'initial': 'initial', 'removed': 'removed'}
    _toPy = {'changed': 'changed', 'initial': 'initial', 'removed': 'removed'}
    def __init__(self, changed=None, initial=None, removed=None, **unknown_fields):
        '''
        changed : typing.Sequence[~RemoteRelationChange]
        initial : bool
        removed : typing.Sequence[int]
        '''
        changed_ = [RemoteRelationChange.from_json(o) for o in changed or []]
        initial_ = initial
        removed_ = removed

        # Validate arguments against known Juju API types.
        if changed_ is not None and not isinstance(changed_, (bytes, str, list)):
            raise Exception("Expected changed_ to be a Sequence, received: {}".format(type(changed_)))

        if initial_ is not None and not isinstance(initial_, bool):
            raise Exception("Expected initial_ to be a bool, received: {}".format(type(initial_)))

        if removed_ is not None and not isinstance(removed_, (bytes, str, list)):
            raise Exception("Expected removed_ to be a Sequence, received: {}".format(type(removed_)))

        self.changed = changed_
        self.initial = initial_
        self.removed = removed_
        self.unknown_fields = unknown_fields



class RemoteRelationsChanges(Type):
    _toSchema = {'changes': 'changes'}
    _toPy = {'changes': 'changes'}
    def __init__(self, changes=None, **unknown_fields):
        '''
        changes : typing.Sequence[~RemoteRelationChangeEvent]
        '''
        changes_ = [RemoteRelationChangeEvent.from_json(o) for o in changes or []]

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        self.changes = changes_
        self.unknown_fields = unknown_fields



class RemoteRelationsWatchResult(Type):
    _toSchema = {'change': 'change', 'error': 'error', 'remoterelationswatcherid': 'RemoteRelationsWatcherId'}
    _toPy = {'RemoteRelationsWatcherId': 'remoterelationswatcherid', 'change': 'change', 'error': 'error'}
    def __init__(self, remoterelationswatcherid=None, change=None, error=None, **unknown_fields):
        '''
        remoterelationswatcherid : str
        change : RemoteRelationsChange
        error : Error
        '''
        remoterelationswatcherid_ = remoterelationswatcherid
        change_ = RemoteRelationsChange.from_json(change) if change else None
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if remoterelationswatcherid_ is not None and not isinstance(remoterelationswatcherid_, (bytes, str)):
            raise Exception("Expected remoterelationswatcherid_ to be a str, received: {}".format(type(remoterelationswatcherid_)))

        if change_ is not None and not isinstance(change_, (dict, RemoteRelationsChange)):
            raise Exception("Expected change_ to be a RemoteRelationsChange, received: {}".format(type(change_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.remoterelationswatcherid = remoterelationswatcherid_
        self.change = change_
        self.error = error_
        self.unknown_fields = unknown_fields



class RemoteSpace(Type):
    _toSchema = {'cloud_type': 'cloud-type', 'name': 'name', 'provider_attributes': 'provider-attributes', 'provider_id': 'provider-id', 'subnets': 'subnets'}
    _toPy = {'cloud-type': 'cloud_type', 'name': 'name', 'provider-attributes': 'provider_attributes', 'provider-id': 'provider_id', 'subnets': 'subnets'}
    def __init__(self, cloud_type=None, name=None, provider_attributes=None, provider_id=None, subnets=None, **unknown_fields):
        '''
        cloud_type : str
        name : str
        provider_attributes : typing.Mapping[str, typing.Any]
        provider_id : str
        subnets : typing.Sequence[~Subnet]
        '''
        cloud_type_ = cloud_type
        name_ = name
        provider_attributes_ = provider_attributes
        provider_id_ = provider_id
        subnets_ = [Subnet.from_json(o) for o in subnets or []]

        # Validate arguments against known Juju API types.
        if cloud_type_ is not None and not isinstance(cloud_type_, (bytes, str)):
            raise Exception("Expected cloud_type_ to be a str, received: {}".format(type(cloud_type_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if provider_attributes_ is not None and not isinstance(provider_attributes_, dict):
            raise Exception("Expected provider_attributes_ to be a Mapping, received: {}".format(type(provider_attributes_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if subnets_ is not None and not isinstance(subnets_, (bytes, str, list)):
            raise Exception("Expected subnets_ to be a Sequence, received: {}".format(type(subnets_)))

        self.cloud_type = cloud_type_
        self.name = name_
        self.provider_attributes = provider_attributes_
        self.provider_id = provider_id_
        self.subnets = subnets_
        self.unknown_fields = unknown_fields



class RemoveBlocksArgs(Type):
    _toSchema = {'all_': 'all'}
    _toPy = {'all': 'all_'}
    def __init__(self, all_=None, **unknown_fields):
        '''
        all_ : bool
        '''
        all__ = all_

        # Validate arguments against known Juju API types.
        if all__ is not None and not isinstance(all__, bool):
            raise Exception("Expected all__ to be a bool, received: {}".format(type(all__)))

        self.all_ = all__
        self.unknown_fields = unknown_fields



class RemoveFilesystemParams(Type):
    _toSchema = {'destroy': 'destroy', 'filesystem_id': 'filesystem-id', 'provider': 'provider'}
    _toPy = {'destroy': 'destroy', 'filesystem-id': 'filesystem_id', 'provider': 'provider'}
    def __init__(self, destroy=None, filesystem_id=None, provider=None, **unknown_fields):
        '''
        destroy : bool
        filesystem_id : str
        provider : str
        '''
        destroy_ = destroy
        filesystem_id_ = filesystem_id
        provider_ = provider

        # Validate arguments against known Juju API types.
        if destroy_ is not None and not isinstance(destroy_, bool):
            raise Exception("Expected destroy_ to be a bool, received: {}".format(type(destroy_)))

        if filesystem_id_ is not None and not isinstance(filesystem_id_, (bytes, str)):
            raise Exception("Expected filesystem_id_ to be a str, received: {}".format(type(filesystem_id_)))

        if provider_ is not None and not isinstance(provider_, (bytes, str)):
            raise Exception("Expected provider_ to be a str, received: {}".format(type(provider_)))

        self.destroy = destroy_
        self.filesystem_id = filesystem_id_
        self.provider = provider_
        self.unknown_fields = unknown_fields



class RemoveFilesystemParamsResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : RemoveFilesystemParams
        '''
        error_ = Error.from_json(error) if error else None
        result_ = RemoveFilesystemParams.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, RemoveFilesystemParams)):
            raise Exception("Expected result_ to be a RemoveFilesystemParams, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class RemoveFilesystemParamsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RemoveFilesystemParamsResult]
        '''
        results_ = [RemoveFilesystemParamsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RemoveSpaceParam(Type):
    _toSchema = {'dry_run': 'dry-run', 'force': 'force', 'space': 'space'}
    _toPy = {'dry-run': 'dry_run', 'force': 'force', 'space': 'space'}
    def __init__(self, dry_run=None, force=None, space=None, **unknown_fields):
        '''
        dry_run : bool
        force : bool
        space : Entity
        '''
        dry_run_ = dry_run
        force_ = force
        space_ = Entity.from_json(space) if space else None

        # Validate arguments against known Juju API types.
        if dry_run_ is not None and not isinstance(dry_run_, bool):
            raise Exception("Expected dry_run_ to be a bool, received: {}".format(type(dry_run_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if space_ is not None and not isinstance(space_, (dict, Entity)):
            raise Exception("Expected space_ to be a Entity, received: {}".format(type(space_)))

        self.dry_run = dry_run_
        self.force = force_
        self.space = space_
        self.unknown_fields = unknown_fields



class RemoveSpaceParams(Type):
    _toSchema = {'space_param': 'space-param'}
    _toPy = {'space-param': 'space_param'}
    def __init__(self, space_param=None, **unknown_fields):
        '''
        space_param : typing.Sequence[~RemoveSpaceParam]
        '''
        space_param_ = [RemoveSpaceParam.from_json(o) for o in space_param or []]

        # Validate arguments against known Juju API types.
        if space_param_ is not None and not isinstance(space_param_, (bytes, str, list)):
            raise Exception("Expected space_param_ to be a Sequence, received: {}".format(type(space_param_)))

        self.space_param = space_param_
        self.unknown_fields = unknown_fields



class RemoveSpaceResult(Type):
    _toSchema = {'bindings': 'bindings', 'constraints': 'constraints', 'controller_settings': 'controller-settings', 'error': 'error'}
    _toPy = {'bindings': 'bindings', 'constraints': 'constraints', 'controller-settings': 'controller_settings', 'error': 'error'}
    def __init__(self, bindings=None, constraints=None, controller_settings=None, error=None, **unknown_fields):
        '''
        bindings : typing.Sequence[~Entity]
        constraints : typing.Sequence[~Entity]
        controller_settings : typing.Sequence[str]
        error : Error
        '''
        bindings_ = [Entity.from_json(o) for o in bindings or []]
        constraints_ = [Entity.from_json(o) for o in constraints or []]
        controller_settings_ = controller_settings
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if bindings_ is not None and not isinstance(bindings_, (bytes, str, list)):
            raise Exception("Expected bindings_ to be a Sequence, received: {}".format(type(bindings_)))

        if constraints_ is not None and not isinstance(constraints_, (bytes, str, list)):
            raise Exception("Expected constraints_ to be a Sequence, received: {}".format(type(constraints_)))

        if controller_settings_ is not None and not isinstance(controller_settings_, (bytes, str, list)):
            raise Exception("Expected controller_settings_ to be a Sequence, received: {}".format(type(controller_settings_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.bindings = bindings_
        self.constraints = constraints_
        self.controller_settings = controller_settings_
        self.error = error_
        self.unknown_fields = unknown_fields



class RemoveSpaceResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RemoveSpaceResult]
        '''
        results_ = [RemoveSpaceResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RemoveStorage(Type):
    _toSchema = {'storage': 'storage'}
    _toPy = {'storage': 'storage'}
    def __init__(self, storage=None, **unknown_fields):
        '''
        storage : typing.Sequence[~RemoveStorageInstance]
        '''
        storage_ = [RemoveStorageInstance.from_json(o) for o in storage or []]

        # Validate arguments against known Juju API types.
        if storage_ is not None and not isinstance(storage_, (bytes, str, list)):
            raise Exception("Expected storage_ to be a Sequence, received: {}".format(type(storage_)))

        self.storage = storage_
        self.unknown_fields = unknown_fields



class RemoveStorageInstance(Type):
    _toSchema = {'destroy_attachments': 'destroy-attachments', 'destroy_storage': 'destroy-storage', 'force': 'force', 'max_wait': 'max-wait', 'tag': 'tag'}
    _toPy = {'destroy-attachments': 'destroy_attachments', 'destroy-storage': 'destroy_storage', 'force': 'force', 'max-wait': 'max_wait', 'tag': 'tag'}
    def __init__(self, destroy_attachments=None, destroy_storage=None, force=None, max_wait=None, tag=None, **unknown_fields):
        '''
        destroy_attachments : bool
        destroy_storage : bool
        force : bool
        max_wait : int
        tag : str
        '''
        destroy_attachments_ = destroy_attachments
        destroy_storage_ = destroy_storage
        force_ = force
        max_wait_ = max_wait
        tag_ = tag

        # Validate arguments against known Juju API types.
        if destroy_attachments_ is not None and not isinstance(destroy_attachments_, bool):
            raise Exception("Expected destroy_attachments_ to be a bool, received: {}".format(type(destroy_attachments_)))

        if destroy_storage_ is not None and not isinstance(destroy_storage_, bool):
            raise Exception("Expected destroy_storage_ to be a bool, received: {}".format(type(destroy_storage_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if max_wait_ is not None and not isinstance(max_wait_, int):
            raise Exception("Expected max_wait_ to be a int, received: {}".format(type(max_wait_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.destroy_attachments = destroy_attachments_
        self.destroy_storage = destroy_storage_
        self.force = force_
        self.max_wait = max_wait_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class RemoveVolumeParams(Type):
    _toSchema = {'destroy': 'destroy', 'provider': 'provider', 'volume_id': 'volume-id'}
    _toPy = {'destroy': 'destroy', 'provider': 'provider', 'volume-id': 'volume_id'}
    def __init__(self, destroy=None, provider=None, volume_id=None, **unknown_fields):
        '''
        destroy : bool
        provider : str
        volume_id : str
        '''
        destroy_ = destroy
        provider_ = provider
        volume_id_ = volume_id

        # Validate arguments against known Juju API types.
        if destroy_ is not None and not isinstance(destroy_, bool):
            raise Exception("Expected destroy_ to be a bool, received: {}".format(type(destroy_)))

        if provider_ is not None and not isinstance(provider_, (bytes, str)):
            raise Exception("Expected provider_ to be a str, received: {}".format(type(provider_)))

        if volume_id_ is not None and not isinstance(volume_id_, (bytes, str)):
            raise Exception("Expected volume_id_ to be a str, received: {}".format(type(volume_id_)))

        self.destroy = destroy_
        self.provider = provider_
        self.volume_id = volume_id_
        self.unknown_fields = unknown_fields



class RemoveVolumeParamsResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : RemoveVolumeParams
        '''
        error_ = Error.from_json(error) if error else None
        result_ = RemoveVolumeParams.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, RemoveVolumeParams)):
            raise Exception("Expected result_ to be a RemoveVolumeParams, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class RemoveVolumeParamsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RemoveVolumeParamsResult]
        '''
        results_ = [RemoveVolumeParamsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RenameSpaceParams(Type):
    _toSchema = {'from_space_tag': 'from-space-tag', 'to_space_tag': 'to-space-tag'}
    _toPy = {'from-space-tag': 'from_space_tag', 'to-space-tag': 'to_space_tag'}
    def __init__(self, from_space_tag=None, to_space_tag=None, **unknown_fields):
        '''
        from_space_tag : str
        to_space_tag : str
        '''
        from_space_tag_ = from_space_tag
        to_space_tag_ = to_space_tag

        # Validate arguments against known Juju API types.
        if from_space_tag_ is not None and not isinstance(from_space_tag_, (bytes, str)):
            raise Exception("Expected from_space_tag_ to be a str, received: {}".format(type(from_space_tag_)))

        if to_space_tag_ is not None and not isinstance(to_space_tag_, (bytes, str)):
            raise Exception("Expected to_space_tag_ to be a str, received: {}".format(type(to_space_tag_)))

        self.from_space_tag = from_space_tag_
        self.to_space_tag = to_space_tag_
        self.unknown_fields = unknown_fields



class RenameSpacesParams(Type):
    _toSchema = {'changes': 'changes'}
    _toPy = {'changes': 'changes'}
    def __init__(self, changes=None, **unknown_fields):
        '''
        changes : typing.Sequence[~RenameSpaceParams]
        '''
        changes_ = [RenameSpaceParams.from_json(o) for o in changes or []]

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        self.changes = changes_
        self.unknown_fields = unknown_fields



class ResolveCharmResult(Type):
    _toSchema = {'error': 'error', 'url': 'url'}
    _toPy = {'error': 'error', 'url': 'url'}
    def __init__(self, error=None, url=None, **unknown_fields):
        '''
        error : str
        url : str
        '''
        error_ = error
        url_ = url

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (bytes, str)):
            raise Exception("Expected error_ to be a str, received: {}".format(type(error_)))

        if url_ is not None and not isinstance(url_, (bytes, str)):
            raise Exception("Expected url_ to be a str, received: {}".format(type(url_)))

        self.error = error_
        self.url = url_
        self.unknown_fields = unknown_fields



class ResolveCharmResults(Type):
    _toSchema = {'urls': 'urls'}
    _toPy = {'urls': 'urls'}
    def __init__(self, urls=None, **unknown_fields):
        '''
        urls : typing.Sequence[~ResolveCharmResult]
        '''
        urls_ = [ResolveCharmResult.from_json(o) for o in urls or []]

        # Validate arguments against known Juju API types.
        if urls_ is not None and not isinstance(urls_, (bytes, str, list)):
            raise Exception("Expected urls_ to be a Sequence, received: {}".format(type(urls_)))

        self.urls = urls_
        self.unknown_fields = unknown_fields



class ResolveCharms(Type):
    _toSchema = {'references': 'references'}
    _toPy = {'references': 'references'}
    def __init__(self, references=None, **unknown_fields):
        '''
        references : typing.Sequence[str]
        '''
        references_ = references

        # Validate arguments against known Juju API types.
        if references_ is not None and not isinstance(references_, (bytes, str, list)):
            raise Exception("Expected references_ to be a Sequence, received: {}".format(type(references_)))

        self.references = references_
        self.unknown_fields = unknown_fields



class Resolved(Type):
    _toSchema = {'retry': 'retry', 'unit_name': 'unit-name'}
    _toPy = {'retry': 'retry', 'unit-name': 'unit_name'}
    def __init__(self, retry=None, unit_name=None, **unknown_fields):
        '''
        retry : bool
        unit_name : str
        '''
        retry_ = retry
        unit_name_ = unit_name

        # Validate arguments against known Juju API types.
        if retry_ is not None and not isinstance(retry_, bool):
            raise Exception("Expected retry_ to be a bool, received: {}".format(type(retry_)))

        if unit_name_ is not None and not isinstance(unit_name_, (bytes, str)):
            raise Exception("Expected unit_name_ to be a str, received: {}".format(type(unit_name_)))

        self.retry = retry_
        self.unit_name = unit_name_
        self.unknown_fields = unknown_fields



class ResolvedModeResult(Type):
    _toSchema = {'error': 'error', 'mode': 'mode'}
    _toPy = {'error': 'error', 'mode': 'mode'}
    def __init__(self, error=None, mode=None, **unknown_fields):
        '''
        error : Error
        mode : str
        '''
        error_ = Error.from_json(error) if error else None
        mode_ = mode

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if mode_ is not None and not isinstance(mode_, (bytes, str)):
            raise Exception("Expected mode_ to be a str, received: {}".format(type(mode_)))

        self.error = error_
        self.mode = mode_
        self.unknown_fields = unknown_fields



class ResolvedModeResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ResolvedModeResult]
        '''
        results_ = [ResolvedModeResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class Resource(Type):
    _toSchema = {'application': 'application', 'charmresource': 'CharmResource', 'description': 'description', 'fingerprint': 'fingerprint', 'id_': 'id', 'name': 'name', 'origin': 'origin', 'path': 'path', 'pending_id': 'pending-id', 'revision': 'revision', 'size': 'size', 'timestamp': 'timestamp', 'type_': 'type', 'username': 'username'}
    _toPy = {'CharmResource': 'charmresource', 'application': 'application', 'description': 'description', 'fingerprint': 'fingerprint', 'id': 'id_', 'name': 'name', 'origin': 'origin', 'path': 'path', 'pending-id': 'pending_id', 'revision': 'revision', 'size': 'size', 'timestamp': 'timestamp', 'type': 'type_', 'username': 'username'}
    def __init__(self, charmresource=None, application=None, description=None, fingerprint=None, id_=None, name=None, origin=None, path=None, pending_id=None, revision=None, size=None, timestamp=None, type_=None, username=None, **unknown_fields):
        '''
        charmresource : CharmResource
        application : str
        description : str
        fingerprint : typing.Sequence[int]
        id_ : str
        name : str
        origin : str
        path : str
        pending_id : str
        revision : int
        size : int
        timestamp : str
        type_ : str
        username : str
        '''
        charmresource_ = CharmResource.from_json(charmresource) if charmresource else None
        application_ = application
        description_ = description
        fingerprint_ = fingerprint
        id__ = id_
        name_ = name
        origin_ = origin
        path_ = path
        pending_id_ = pending_id
        revision_ = revision
        size_ = size
        timestamp_ = timestamp
        type__ = type_
        username_ = username

        # Validate arguments against known Juju API types.
        if charmresource_ is not None and not isinstance(charmresource_, (dict, CharmResource)):
            raise Exception("Expected charmresource_ to be a CharmResource, received: {}".format(type(charmresource_)))

        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if fingerprint_ is not None and not isinstance(fingerprint_, (bytes, str, list)):
            raise Exception("Expected fingerprint_ to be a Sequence, received: {}".format(type(fingerprint_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if origin_ is not None and not isinstance(origin_, (bytes, str)):
            raise Exception("Expected origin_ to be a str, received: {}".format(type(origin_)))

        if path_ is not None and not isinstance(path_, (bytes, str)):
            raise Exception("Expected path_ to be a str, received: {}".format(type(path_)))

        if pending_id_ is not None and not isinstance(pending_id_, (bytes, str)):
            raise Exception("Expected pending_id_ to be a str, received: {}".format(type(pending_id_)))

        if revision_ is not None and not isinstance(revision_, int):
            raise Exception("Expected revision_ to be a int, received: {}".format(type(revision_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if timestamp_ is not None and not isinstance(timestamp_, (bytes, str)):
            raise Exception("Expected timestamp_ to be a str, received: {}".format(type(timestamp_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if username_ is not None and not isinstance(username_, (bytes, str)):
            raise Exception("Expected username_ to be a str, received: {}".format(type(username_)))

        self.charmresource = charmresource_
        self.application = application_
        self.description = description_
        self.fingerprint = fingerprint_
        self.id_ = id__
        self.name = name_
        self.origin = origin_
        self.path = path_
        self.pending_id = pending_id_
        self.revision = revision_
        self.size = size_
        self.timestamp = timestamp_
        self.type_ = type__
        self.username = username_
        self.unknown_fields = unknown_fields



class ResourceResult(Type):
    _toSchema = {'errorresult': 'ErrorResult', 'resource': 'resource'}
    _toPy = {'ErrorResult': 'errorresult', 'resource': 'resource'}
    def __init__(self, errorresult=None, resource=None, **unknown_fields):
        '''
        errorresult : ErrorResult
        resource : Resource
        '''
        errorresult_ = ErrorResult.from_json(errorresult) if errorresult else None
        resource_ = Resource.from_json(resource) if resource else None

        # Validate arguments against known Juju API types.
        if errorresult_ is not None and not isinstance(errorresult_, (dict, ErrorResult)):
            raise Exception("Expected errorresult_ to be a ErrorResult, received: {}".format(type(errorresult_)))

        if resource_ is not None and not isinstance(resource_, (dict, Resource)):
            raise Exception("Expected resource_ to be a Resource, received: {}".format(type(resource_)))

        self.errorresult = errorresult_
        self.resource = resource_
        self.unknown_fields = unknown_fields



class ResourcesResult(Type):
    _toSchema = {'charm_store_resources': 'charm-store-resources', 'error': 'error', 'errorresult': 'ErrorResult', 'resources': 'resources', 'unit_resources': 'unit-resources'}
    _toPy = {'ErrorResult': 'errorresult', 'charm-store-resources': 'charm_store_resources', 'error': 'error', 'resources': 'resources', 'unit-resources': 'unit_resources'}
    def __init__(self, errorresult=None, charm_store_resources=None, error=None, resources=None, unit_resources=None, **unknown_fields):
        '''
        errorresult : ErrorResult
        charm_store_resources : typing.Sequence[~CharmResource]
        error : Error
        resources : typing.Sequence[~Resource]
        unit_resources : typing.Sequence[~UnitResources]
        '''
        errorresult_ = ErrorResult.from_json(errorresult) if errorresult else None
        charm_store_resources_ = [CharmResource.from_json(o) for o in charm_store_resources or []]
        error_ = Error.from_json(error) if error else None
        resources_ = [Resource.from_json(o) for o in resources or []]
        unit_resources_ = [UnitResources.from_json(o) for o in unit_resources or []]

        # Validate arguments against known Juju API types.
        if errorresult_ is not None and not isinstance(errorresult_, (dict, ErrorResult)):
            raise Exception("Expected errorresult_ to be a ErrorResult, received: {}".format(type(errorresult_)))

        if charm_store_resources_ is not None and not isinstance(charm_store_resources_, (bytes, str, list)):
            raise Exception("Expected charm_store_resources_ to be a Sequence, received: {}".format(type(charm_store_resources_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if resources_ is not None and not isinstance(resources_, (bytes, str, list)):
            raise Exception("Expected resources_ to be a Sequence, received: {}".format(type(resources_)))

        if unit_resources_ is not None and not isinstance(unit_resources_, (bytes, str, list)):
            raise Exception("Expected unit_resources_ to be a Sequence, received: {}".format(type(unit_resources_)))

        self.errorresult = errorresult_
        self.charm_store_resources = charm_store_resources_
        self.error = error_
        self.resources = resources_
        self.unit_resources = unit_resources_
        self.unknown_fields = unknown_fields



class ResourcesResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ResourcesResult]
        '''
        results_ = [ResourcesResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RestoreArgs(Type):
    _toSchema = {'backup_id': 'backup-id'}
    _toPy = {'backup-id': 'backup_id'}
    def __init__(self, backup_id=None, **unknown_fields):
        '''
        backup_id : str
        '''
        backup_id_ = backup_id

        # Validate arguments against known Juju API types.
        if backup_id_ is not None and not isinstance(backup_id_, (bytes, str)):
            raise Exception("Expected backup_id_ to be a str, received: {}".format(type(backup_id_)))

        self.backup_id = backup_id_
        self.unknown_fields = unknown_fields



class ResumeReplicationParams(Type):
    _toSchema = {'members': 'members'}
    _toPy = {'members': 'members'}
    def __init__(self, members=None, **unknown_fields):
        '''
        members : typing.Sequence[~Member]
        '''
        members_ = [Member.from_json(o) for o in members or []]

        # Validate arguments against known Juju API types.
        if members_ is not None and not isinstance(members_, (bytes, str, list)):
            raise Exception("Expected members_ to be a Sequence, received: {}".format(type(members_)))

        self.members = members_
        self.unknown_fields = unknown_fields



class RetryStrategy(Type):
    _toSchema = {'jitter_retry_time': 'jitter-retry-time', 'max_retry_time': 'max-retry-time', 'min_retry_time': 'min-retry-time', 'retry_time_factor': 'retry-time-factor', 'should_retry': 'should-retry'}
    _toPy = {'jitter-retry-time': 'jitter_retry_time', 'max-retry-time': 'max_retry_time', 'min-retry-time': 'min_retry_time', 'retry-time-factor': 'retry_time_factor', 'should-retry': 'should_retry'}
    def __init__(self, jitter_retry_time=None, max_retry_time=None, min_retry_time=None, retry_time_factor=None, should_retry=None, **unknown_fields):
        '''
        jitter_retry_time : bool
        max_retry_time : int
        min_retry_time : int
        retry_time_factor : int
        should_retry : bool
        '''
        jitter_retry_time_ = jitter_retry_time
        max_retry_time_ = max_retry_time
        min_retry_time_ = min_retry_time
        retry_time_factor_ = retry_time_factor
        should_retry_ = should_retry

        # Validate arguments against known Juju API types.
        if jitter_retry_time_ is not None and not isinstance(jitter_retry_time_, bool):
            raise Exception("Expected jitter_retry_time_ to be a bool, received: {}".format(type(jitter_retry_time_)))

        if max_retry_time_ is not None and not isinstance(max_retry_time_, int):
            raise Exception("Expected max_retry_time_ to be a int, received: {}".format(type(max_retry_time_)))

        if min_retry_time_ is not None and not isinstance(min_retry_time_, int):
            raise Exception("Expected min_retry_time_ to be a int, received: {}".format(type(min_retry_time_)))

        if retry_time_factor_ is not None and not isinstance(retry_time_factor_, int):
            raise Exception("Expected retry_time_factor_ to be a int, received: {}".format(type(retry_time_factor_)))

        if should_retry_ is not None and not isinstance(should_retry_, bool):
            raise Exception("Expected should_retry_ to be a bool, received: {}".format(type(should_retry_)))

        self.jitter_retry_time = jitter_retry_time_
        self.max_retry_time = max_retry_time_
        self.min_retry_time = min_retry_time_
        self.retry_time_factor = retry_time_factor_
        self.should_retry = should_retry_
        self.unknown_fields = unknown_fields



class RetryStrategyResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : RetryStrategy
        '''
        error_ = Error.from_json(error) if error else None
        result_ = RetryStrategy.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, RetryStrategy)):
            raise Exception("Expected result_ to be a RetryStrategy, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class RetryStrategyResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~RetryStrategyResult]
        '''
        results_ = [RetryStrategyResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class RevokeCredentialArg(Type):
    _toSchema = {'force': 'force', 'tag': 'tag'}
    _toPy = {'force': 'force', 'tag': 'tag'}
    def __init__(self, force=None, tag=None, **unknown_fields):
        '''
        force : bool
        tag : str
        '''
        force_ = force
        tag_ = tag

        # Validate arguments against known Juju API types.
        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.force = force_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class RevokeCredentialArgs(Type):
    _toSchema = {'credentials': 'credentials'}
    _toPy = {'credentials': 'credentials'}
    def __init__(self, credentials=None, **unknown_fields):
        '''
        credentials : typing.Sequence[~RevokeCredentialArg]
        '''
        credentials_ = [RevokeCredentialArg.from_json(o) for o in credentials or []]

        # Validate arguments against known Juju API types.
        if credentials_ is not None and not isinstance(credentials_, (bytes, str, list)):
            raise Exception("Expected credentials_ to be a Sequence, received: {}".format(type(credentials_)))

        self.credentials = credentials_
        self.unknown_fields = unknown_fields



class RunParams(Type):
    _toSchema = {'applications': 'applications', 'commands': 'commands', 'machines': 'machines', 'timeout': 'timeout', 'units': 'units', 'workload_context': 'workload-context'}
    _toPy = {'applications': 'applications', 'commands': 'commands', 'machines': 'machines', 'timeout': 'timeout', 'units': 'units', 'workload-context': 'workload_context'}
    def __init__(self, applications=None, commands=None, machines=None, timeout=None, units=None, workload_context=None, **unknown_fields):
        '''
        applications : typing.Sequence[str]
        commands : str
        machines : typing.Sequence[str]
        timeout : int
        units : typing.Sequence[str]
        workload_context : bool
        '''
        applications_ = applications
        commands_ = commands
        machines_ = machines
        timeout_ = timeout
        units_ = units
        workload_context_ = workload_context

        # Validate arguments against known Juju API types.
        if applications_ is not None and not isinstance(applications_, (bytes, str, list)):
            raise Exception("Expected applications_ to be a Sequence, received: {}".format(type(applications_)))

        if commands_ is not None and not isinstance(commands_, (bytes, str)):
            raise Exception("Expected commands_ to be a str, received: {}".format(type(commands_)))

        if machines_ is not None and not isinstance(machines_, (bytes, str, list)):
            raise Exception("Expected machines_ to be a Sequence, received: {}".format(type(machines_)))

        if timeout_ is not None and not isinstance(timeout_, int):
            raise Exception("Expected timeout_ to be a int, received: {}".format(type(timeout_)))

        if units_ is not None and not isinstance(units_, (bytes, str, list)):
            raise Exception("Expected units_ to be a Sequence, received: {}".format(type(units_)))

        if workload_context_ is not None and not isinstance(workload_context_, bool):
            raise Exception("Expected workload_context_ to be a bool, received: {}".format(type(workload_context_)))

        self.applications = applications_
        self.commands = commands_
        self.machines = machines_
        self.timeout = timeout_
        self.units = units_
        self.workload_context = workload_context_
        self.unknown_fields = unknown_fields



class SSHAddressResult(Type):
    _toSchema = {'address': 'address', 'error': 'error'}
    _toPy = {'address': 'address', 'error': 'error'}
    def __init__(self, address=None, error=None, **unknown_fields):
        '''
        address : str
        error : Error
        '''
        address_ = address
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if address_ is not None and not isinstance(address_, (bytes, str)):
            raise Exception("Expected address_ to be a str, received: {}".format(type(address_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.address = address_
        self.error = error_
        self.unknown_fields = unknown_fields



class SSHAddressResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~SSHAddressResult]
        '''
        results_ = [SSHAddressResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class SSHAddressesResult(Type):
    _toSchema = {'addresses': 'addresses', 'error': 'error'}
    _toPy = {'addresses': 'addresses', 'error': 'error'}
    def __init__(self, addresses=None, error=None, **unknown_fields):
        '''
        addresses : typing.Sequence[str]
        error : Error
        '''
        addresses_ = addresses
        error_ = Error.from_json(error) if error else None

        # Validate arguments against known Juju API types.
        if addresses_ is not None and not isinstance(addresses_, (bytes, str, list)):
            raise Exception("Expected addresses_ to be a Sequence, received: {}".format(type(addresses_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        self.addresses = addresses_
        self.error = error_
        self.unknown_fields = unknown_fields



class SSHAddressesResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~SSHAddressesResult]
        '''
        results_ = [SSHAddressesResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class SSHHostKeySet(Type):
    _toSchema = {'entity_keys': 'entity-keys'}
    _toPy = {'entity-keys': 'entity_keys'}
    def __init__(self, entity_keys=None, **unknown_fields):
        '''
        entity_keys : typing.Sequence[~SSHHostKeys]
        '''
        entity_keys_ = [SSHHostKeys.from_json(o) for o in entity_keys or []]

        # Validate arguments against known Juju API types.
        if entity_keys_ is not None and not isinstance(entity_keys_, (bytes, str, list)):
            raise Exception("Expected entity_keys_ to be a Sequence, received: {}".format(type(entity_keys_)))

        self.entity_keys = entity_keys_
        self.unknown_fields = unknown_fields



class SSHHostKeys(Type):
    _toSchema = {'public_keys': 'public-keys', 'tag': 'tag'}
    _toPy = {'public-keys': 'public_keys', 'tag': 'tag'}
    def __init__(self, public_keys=None, tag=None, **unknown_fields):
        '''
        public_keys : typing.Sequence[str]
        tag : str
        '''
        public_keys_ = public_keys
        tag_ = tag

        # Validate arguments against known Juju API types.
        if public_keys_ is not None and not isinstance(public_keys_, (bytes, str, list)):
            raise Exception("Expected public_keys_ to be a Sequence, received: {}".format(type(public_keys_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.public_keys = public_keys_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class SSHProxyResult(Type):
    _toSchema = {'use_proxy': 'use-proxy'}
    _toPy = {'use-proxy': 'use_proxy'}
    def __init__(self, use_proxy=None, **unknown_fields):
        '''
        use_proxy : bool
        '''
        use_proxy_ = use_proxy

        # Validate arguments against known Juju API types.
        if use_proxy_ is not None and not isinstance(use_proxy_, bool):
            raise Exception("Expected use_proxy_ to be a bool, received: {}".format(type(use_proxy_)))

        self.use_proxy = use_proxy_
        self.unknown_fields = unknown_fields



class SSHPublicKeysResult(Type):
    _toSchema = {'error': 'error', 'public_keys': 'public-keys'}
    _toPy = {'error': 'error', 'public-keys': 'public_keys'}
    def __init__(self, error=None, public_keys=None, **unknown_fields):
        '''
        error : Error
        public_keys : typing.Sequence[str]
        '''
        error_ = Error.from_json(error) if error else None
        public_keys_ = public_keys

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if public_keys_ is not None and not isinstance(public_keys_, (bytes, str, list)):
            raise Exception("Expected public_keys_ to be a Sequence, received: {}".format(type(public_keys_)))

        self.error = error_
        self.public_keys = public_keys_
        self.unknown_fields = unknown_fields



class SSHPublicKeysResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~SSHPublicKeysResult]
        '''
        results_ = [SSHPublicKeysResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ScaleApplicationInfo(Type):
    _toSchema = {'num_units': 'num-units'}
    _toPy = {'num-units': 'num_units'}
    def __init__(self, num_units=None, **unknown_fields):
        '''
        num_units : int
        '''
        num_units_ = num_units

        # Validate arguments against known Juju API types.
        if num_units_ is not None and not isinstance(num_units_, int):
            raise Exception("Expected num_units_ to be a int, received: {}".format(type(num_units_)))

        self.num_units = num_units_
        self.unknown_fields = unknown_fields



class ScaleApplicationParams(Type):
    _toSchema = {'application_tag': 'application-tag', 'force': 'force', 'scale': 'scale', 'scale_change': 'scale-change'}
    _toPy = {'application-tag': 'application_tag', 'force': 'force', 'scale': 'scale', 'scale-change': 'scale_change'}
    def __init__(self, application_tag=None, force=None, scale=None, scale_change=None, **unknown_fields):
        '''
        application_tag : str
        force : bool
        scale : int
        scale_change : int
        '''
        application_tag_ = application_tag
        force_ = force
        scale_ = scale
        scale_change_ = scale_change

        # Validate arguments against known Juju API types.
        if application_tag_ is not None and not isinstance(application_tag_, (bytes, str)):
            raise Exception("Expected application_tag_ to be a str, received: {}".format(type(application_tag_)))

        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if scale_ is not None and not isinstance(scale_, int):
            raise Exception("Expected scale_ to be a int, received: {}".format(type(scale_)))

        if scale_change_ is not None and not isinstance(scale_change_, int):
            raise Exception("Expected scale_change_ to be a int, received: {}".format(type(scale_change_)))

        self.application_tag = application_tag_
        self.force = force_
        self.scale = scale_
        self.scale_change = scale_change_
        self.unknown_fields = unknown_fields



class ScaleApplicationResult(Type):
    _toSchema = {'error': 'error', 'info': 'info'}
    _toPy = {'error': 'error', 'info': 'info'}
    def __init__(self, error=None, info=None, **unknown_fields):
        '''
        error : Error
        info : ScaleApplicationInfo
        '''
        error_ = Error.from_json(error) if error else None
        info_ = ScaleApplicationInfo.from_json(info) if info else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if info_ is not None and not isinstance(info_, (dict, ScaleApplicationInfo)):
            raise Exception("Expected info_ to be a ScaleApplicationInfo, received: {}".format(type(info_)))

        self.error = error_
        self.info = info_
        self.unknown_fields = unknown_fields



class ScaleApplicationResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ScaleApplicationResult]
        '''
        results_ = [ScaleApplicationResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ScaleApplicationsParams(Type):
    _toSchema = {'applications': 'applications'}
    _toPy = {'applications': 'applications'}
    def __init__(self, applications=None, **unknown_fields):
        '''
        applications : typing.Sequence[~ScaleApplicationParams]
        '''
        applications_ = [ScaleApplicationParams.from_json(o) for o in applications or []]

        # Validate arguments against known Juju API types.
        if applications_ is not None and not isinstance(applications_, (bytes, str, list)):
            raise Exception("Expected applications_ to be a Sequence, received: {}".format(type(applications_)))

        self.applications = applications_
        self.unknown_fields = unknown_fields



class SerializedModel(Type):
    _toSchema = {'bytes_': 'bytes', 'charms': 'charms', 'resources': 'resources', 'tools': 'tools'}
    _toPy = {'bytes': 'bytes_', 'charms': 'charms', 'resources': 'resources', 'tools': 'tools'}
    def __init__(self, bytes_=None, charms=None, resources=None, tools=None, **unknown_fields):
        '''
        bytes_ : typing.Sequence[int]
        charms : typing.Sequence[str]
        resources : typing.Sequence[~SerializedModelResource]
        tools : typing.Sequence[~SerializedModelTools]
        '''
        bytes__ = bytes_
        charms_ = charms
        resources_ = [SerializedModelResource.from_json(o) for o in resources or []]
        tools_ = [SerializedModelTools.from_json(o) for o in tools or []]

        # Validate arguments against known Juju API types.
        if bytes__ is not None and not isinstance(bytes__, (bytes, str, list)):
            raise Exception("Expected bytes__ to be a Sequence, received: {}".format(type(bytes__)))

        if charms_ is not None and not isinstance(charms_, (bytes, str, list)):
            raise Exception("Expected charms_ to be a Sequence, received: {}".format(type(charms_)))

        if resources_ is not None and not isinstance(resources_, (bytes, str, list)):
            raise Exception("Expected resources_ to be a Sequence, received: {}".format(type(resources_)))

        if tools_ is not None and not isinstance(tools_, (bytes, str, list)):
            raise Exception("Expected tools_ to be a Sequence, received: {}".format(type(tools_)))

        self.bytes_ = bytes__
        self.charms = charms_
        self.resources = resources_
        self.tools = tools_
        self.unknown_fields = unknown_fields



class SerializedModelResource(Type):
    _toSchema = {'application': 'application', 'application_revision': 'application-revision', 'charmstore_revision': 'charmstore-revision', 'name': 'name', 'unit_revisions': 'unit-revisions'}
    _toPy = {'application': 'application', 'application-revision': 'application_revision', 'charmstore-revision': 'charmstore_revision', 'name': 'name', 'unit-revisions': 'unit_revisions'}
    def __init__(self, application=None, application_revision=None, charmstore_revision=None, name=None, unit_revisions=None, **unknown_fields):
        '''
        application : str
        application_revision : SerializedModelResourceRevision
        charmstore_revision : SerializedModelResourceRevision
        name : str
        unit_revisions : typing.Mapping[str, ~SerializedModelResourceRevision]
        '''
        application_ = application
        application_revision_ = SerializedModelResourceRevision.from_json(application_revision) if application_revision else None
        charmstore_revision_ = SerializedModelResourceRevision.from_json(charmstore_revision) if charmstore_revision else None
        name_ = name
        unit_revisions_ = {k: SerializedModelResourceRevision.from_json(v) for k, v in (unit_revisions or dict()).items()}

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if application_revision_ is not None and not isinstance(application_revision_, (dict, SerializedModelResourceRevision)):
            raise Exception("Expected application_revision_ to be a SerializedModelResourceRevision, received: {}".format(type(application_revision_)))

        if charmstore_revision_ is not None and not isinstance(charmstore_revision_, (dict, SerializedModelResourceRevision)):
            raise Exception("Expected charmstore_revision_ to be a SerializedModelResourceRevision, received: {}".format(type(charmstore_revision_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if unit_revisions_ is not None and not isinstance(unit_revisions_, dict):
            raise Exception("Expected unit_revisions_ to be a Mapping, received: {}".format(type(unit_revisions_)))

        self.application = application_
        self.application_revision = application_revision_
        self.charmstore_revision = charmstore_revision_
        self.name = name_
        self.unit_revisions = unit_revisions_
        self.unknown_fields = unknown_fields



class SerializedModelResourceRevision(Type):
    _toSchema = {'description': 'description', 'fingerprint': 'fingerprint', 'origin': 'origin', 'path': 'path', 'revision': 'revision', 'size': 'size', 'timestamp': 'timestamp', 'type_': 'type', 'username': 'username'}
    _toPy = {'description': 'description', 'fingerprint': 'fingerprint', 'origin': 'origin', 'path': 'path', 'revision': 'revision', 'size': 'size', 'timestamp': 'timestamp', 'type': 'type_', 'username': 'username'}
    def __init__(self, description=None, fingerprint=None, origin=None, path=None, revision=None, size=None, timestamp=None, type_=None, username=None, **unknown_fields):
        '''
        description : str
        fingerprint : str
        origin : str
        path : str
        revision : int
        size : int
        timestamp : str
        type_ : str
        username : str
        '''
        description_ = description
        fingerprint_ = fingerprint
        origin_ = origin
        path_ = path
        revision_ = revision
        size_ = size
        timestamp_ = timestamp
        type__ = type_
        username_ = username

        # Validate arguments against known Juju API types.
        if description_ is not None and not isinstance(description_, (bytes, str)):
            raise Exception("Expected description_ to be a str, received: {}".format(type(description_)))

        if fingerprint_ is not None and not isinstance(fingerprint_, (bytes, str)):
            raise Exception("Expected fingerprint_ to be a str, received: {}".format(type(fingerprint_)))

        if origin_ is not None and not isinstance(origin_, (bytes, str)):
            raise Exception("Expected origin_ to be a str, received: {}".format(type(origin_)))

        if path_ is not None and not isinstance(path_, (bytes, str)):
            raise Exception("Expected path_ to be a str, received: {}".format(type(path_)))

        if revision_ is not None and not isinstance(revision_, int):
            raise Exception("Expected revision_ to be a int, received: {}".format(type(revision_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if timestamp_ is not None and not isinstance(timestamp_, (bytes, str)):
            raise Exception("Expected timestamp_ to be a str, received: {}".format(type(timestamp_)))

        if type__ is not None and not isinstance(type__, (bytes, str)):
            raise Exception("Expected type__ to be a str, received: {}".format(type(type__)))

        if username_ is not None and not isinstance(username_, (bytes, str)):
            raise Exception("Expected username_ to be a str, received: {}".format(type(username_)))

        self.description = description_
        self.fingerprint = fingerprint_
        self.origin = origin_
        self.path = path_
        self.revision = revision_
        self.size = size_
        self.timestamp = timestamp_
        self.type_ = type__
        self.username = username_
        self.unknown_fields = unknown_fields



class SerializedModelTools(Type):
    _toSchema = {'uri': 'uri', 'version': 'version'}
    _toPy = {'uri': 'uri', 'version': 'version'}
    def __init__(self, uri=None, version=None, **unknown_fields):
        '''
        uri : str
        version : str
        '''
        uri_ = uri
        version_ = version

        # Validate arguments against known Juju API types.
        if uri_ is not None and not isinstance(uri_, (bytes, str)):
            raise Exception("Expected uri_ to be a str, received: {}".format(type(uri_)))

        if version_ is not None and not isinstance(version_, (bytes, str)):
            raise Exception("Expected version_ to be a str, received: {}".format(type(version_)))

        self.uri = uri_
        self.version = version_
        self.unknown_fields = unknown_fields



class SetConstraints(Type):
    _toSchema = {'application': 'application', 'constraints': 'constraints'}
    _toPy = {'application': 'application', 'constraints': 'constraints'}
    def __init__(self, application=None, constraints=None, **unknown_fields):
        '''
        application : str
        constraints : Value
        '''
        application_ = application
        constraints_ = Value.from_json(constraints) if constraints else None

        # Validate arguments against known Juju API types.
        if application_ is not None and not isinstance(application_, (bytes, str)):
            raise Exception("Expected application_ to be a str, received: {}".format(type(application_)))

        if constraints_ is not None and not isinstance(constraints_, (dict, Value)):
            raise Exception("Expected constraints_ to be a Value, received: {}".format(type(constraints_)))

        self.application = application_
        self.constraints = constraints_
        self.unknown_fields = unknown_fields



class SetExternalControllerInfoParams(Type):
    _toSchema = {'info': 'info'}
    _toPy = {'info': 'info'}
    def __init__(self, info=None, **unknown_fields):
        '''
        info : ExternalControllerInfo
        '''
        info_ = ExternalControllerInfo.from_json(info) if info else None

        # Validate arguments against known Juju API types.
        if info_ is not None and not isinstance(info_, (dict, ExternalControllerInfo)):
            raise Exception("Expected info_ to be a ExternalControllerInfo, received: {}".format(type(info_)))

        self.info = info_
        self.unknown_fields = unknown_fields



class SetExternalControllersInfoParams(Type):
    _toSchema = {'controllers': 'controllers'}
    _toPy = {'controllers': 'controllers'}
    def __init__(self, controllers=None, **unknown_fields):
        '''
        controllers : typing.Sequence[~SetExternalControllerInfoParams]
        '''
        controllers_ = [SetExternalControllerInfoParams.from_json(o) for o in controllers or []]

        # Validate arguments against known Juju API types.
        if controllers_ is not None and not isinstance(controllers_, (bytes, str, list)):
            raise Exception("Expected controllers_ to be a Sequence, received: {}".format(type(controllers_)))

        self.controllers = controllers_
        self.unknown_fields = unknown_fields



class SetMachineBlockDevices(Type):
    _toSchema = {'machine_block_devices': 'machine-block-devices'}
    _toPy = {'machine-block-devices': 'machine_block_devices'}
    def __init__(self, machine_block_devices=None, **unknown_fields):
        '''
        machine_block_devices : typing.Sequence[~MachineBlockDevices]
        '''
        machine_block_devices_ = [MachineBlockDevices.from_json(o) for o in machine_block_devices or []]

        # Validate arguments against known Juju API types.
        if machine_block_devices_ is not None and not isinstance(machine_block_devices_, (bytes, str, list)):
            raise Exception("Expected machine_block_devices_ to be a Sequence, received: {}".format(type(machine_block_devices_)))

        self.machine_block_devices = machine_block_devices_
        self.unknown_fields = unknown_fields



class SetMachineNetworkConfig(Type):
    _toSchema = {'config': 'config', 'tag': 'tag'}
    _toPy = {'config': 'config', 'tag': 'tag'}
    def __init__(self, config=None, tag=None, **unknown_fields):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        '''
        config_ = [NetworkConfig.from_json(o) for o in config or []]
        tag_ = tag

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, (bytes, str, list)):
            raise Exception("Expected config_ to be a Sequence, received: {}".format(type(config_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.config = config_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class SetMachinesAddresses(Type):
    _toSchema = {'machine_addresses': 'machine-addresses'}
    _toPy = {'machine-addresses': 'machine_addresses'}
    def __init__(self, machine_addresses=None, **unknown_fields):
        '''
        machine_addresses : typing.Sequence[~MachineAddresses]
        '''
        machine_addresses_ = [MachineAddresses.from_json(o) for o in machine_addresses or []]

        # Validate arguments against known Juju API types.
        if machine_addresses_ is not None and not isinstance(machine_addresses_, (bytes, str, list)):
            raise Exception("Expected machine_addresses_ to be a Sequence, received: {}".format(type(machine_addresses_)))

        self.machine_addresses = machine_addresses_
        self.unknown_fields = unknown_fields



class SetMigrationPhaseArgs(Type):
    _toSchema = {'phase': 'phase'}
    _toPy = {'phase': 'phase'}
    def __init__(self, phase=None, **unknown_fields):
        '''
        phase : str
        '''
        phase_ = phase

        # Validate arguments against known Juju API types.
        if phase_ is not None and not isinstance(phase_, (bytes, str)):
            raise Exception("Expected phase_ to be a str, received: {}".format(type(phase_)))

        self.phase = phase_
        self.unknown_fields = unknown_fields



class SetMigrationStatusMessageArgs(Type):
    _toSchema = {'message': 'message'}
    _toPy = {'message': 'message'}
    def __init__(self, message=None, **unknown_fields):
        '''
        message : str
        '''
        message_ = message

        # Validate arguments against known Juju API types.
        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        self.message = message_
        self.unknown_fields = unknown_fields



class SetModelAgentVersion(Type):
    _toSchema = {'force': 'force', 'version': 'version'}
    _toPy = {'force': 'force', 'version': 'version'}
    def __init__(self, force=None, version=None, **unknown_fields):
        '''
        force : bool
        version : Number
        '''
        force_ = force
        version_ = Number.from_json(version) if version else None

        # Validate arguments against known Juju API types.
        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if version_ is not None and not isinstance(version_, (dict, Number)):
            raise Exception("Expected version_ to be a Number, received: {}".format(type(version_)))

        self.force = force_
        self.version = version_
        self.unknown_fields = unknown_fields



class SetModelDefaults(Type):
    _toSchema = {'config': 'config'}
    _toPy = {'config': 'config'}
    def __init__(self, config=None, **unknown_fields):
        '''
        config : typing.Sequence[~ModelDefaultValues]
        '''
        config_ = [ModelDefaultValues.from_json(o) for o in config or []]

        # Validate arguments against known Juju API types.
        if config_ is not None and not isinstance(config_, (bytes, str, list)):
            raise Exception("Expected config_ to be a Sequence, received: {}".format(type(config_)))

        self.config = config_
        self.unknown_fields = unknown_fields



class SetModelEnvironVersion(Type):
    _toSchema = {'model_tag': 'model-tag', 'version': 'version'}
    _toPy = {'model-tag': 'model_tag', 'version': 'version'}
    def __init__(self, model_tag=None, version=None, **unknown_fields):
        '''
        model_tag : str
        version : int
        '''
        model_tag_ = model_tag
        version_ = version

        # Validate arguments against known Juju API types.
        if model_tag_ is not None and not isinstance(model_tag_, (bytes, str)):
            raise Exception("Expected model_tag_ to be a str, received: {}".format(type(model_tag_)))

        if version_ is not None and not isinstance(version_, int):
            raise Exception("Expected version_ to be a int, received: {}".format(type(version_)))

        self.model_tag = model_tag_
        self.version = version_
        self.unknown_fields = unknown_fields



class SetModelEnvironVersions(Type):
    _toSchema = {'models': 'models'}
    _toPy = {'models': 'models'}
    def __init__(self, models=None, **unknown_fields):
        '''
        models : typing.Sequence[~SetModelEnvironVersion]
        '''
        models_ = [SetModelEnvironVersion.from_json(o) for o in models or []]

        # Validate arguments against known Juju API types.
        if models_ is not None and not isinstance(models_, (bytes, str, list)):
            raise Exception("Expected models_ to be a Sequence, received: {}".format(type(models_)))

        self.models = models_
        self.unknown_fields = unknown_fields



class SetPayloadStatusArg(Type):
    _toSchema = {'entity': 'Entity', 'status': 'status', 'tag': 'tag'}
    _toPy = {'Entity': 'entity', 'status': 'status', 'tag': 'tag'}
    def __init__(self, entity=None, status=None, tag=None, **unknown_fields):
        '''
        entity : Entity
        status : str
        tag : str
        '''
        entity_ = Entity.from_json(entity) if entity else None
        status_ = status
        tag_ = tag

        # Validate arguments against known Juju API types.
        if entity_ is not None and not isinstance(entity_, (dict, Entity)):
            raise Exception("Expected entity_ to be a Entity, received: {}".format(type(entity_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.entity = entity_
        self.status = status_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class SetPayloadStatusArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~SetPayloadStatusArg]
        '''
        args_ = [SetPayloadStatusArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class SetPodSpecParams(Type):
    _toSchema = {'specs': 'specs'}
    _toPy = {'specs': 'specs'}
    def __init__(self, specs=None, **unknown_fields):
        '''
        specs : typing.Sequence[~EntityString]
        '''
        specs_ = [EntityString.from_json(o) for o in specs or []]

        # Validate arguments against known Juju API types.
        if specs_ is not None and not isinstance(specs_, (bytes, str, list)):
            raise Exception("Expected specs_ to be a Sequence, received: {}".format(type(specs_)))

        self.specs = specs_
        self.unknown_fields = unknown_fields



class SetPodSpecParamsV2(Type):
    _toSchema = {'specs': 'specs'}
    _toPy = {'specs': 'specs'}
    def __init__(self, specs=None, **unknown_fields):
        '''
        specs : typing.Sequence[~PodSpec]
        '''
        specs_ = [PodSpec.from_json(o) for o in specs or []]

        # Validate arguments against known Juju API types.
        if specs_ is not None and not isinstance(specs_, (bytes, str, list)):
            raise Exception("Expected specs_ to be a Sequence, received: {}".format(type(specs_)))

        self.specs = specs_
        self.unknown_fields = unknown_fields



class SetProfileArg(Type):
    _toSchema = {'entity': 'entity', 'profiles': 'profiles'}
    _toPy = {'entity': 'entity', 'profiles': 'profiles'}
    def __init__(self, entity=None, profiles=None, **unknown_fields):
        '''
        entity : Entity
        profiles : typing.Sequence[str]
        '''
        entity_ = Entity.from_json(entity) if entity else None
        profiles_ = profiles

        # Validate arguments against known Juju API types.
        if entity_ is not None and not isinstance(entity_, (dict, Entity)):
            raise Exception("Expected entity_ to be a Entity, received: {}".format(type(entity_)))

        if profiles_ is not None and not isinstance(profiles_, (bytes, str, list)):
            raise Exception("Expected profiles_ to be a Sequence, received: {}".format(type(profiles_)))

        self.entity = entity_
        self.profiles = profiles_
        self.unknown_fields = unknown_fields



class SetProfileArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~SetProfileArg]
        '''
        args_ = [SetProfileArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class SetProfileUpgradeCompleteArg(Type):
    _toSchema = {'entity': 'entity', 'message': 'message'}
    _toPy = {'entity': 'entity', 'message': 'message'}
    def __init__(self, entity=None, message=None, **unknown_fields):
        '''
        entity : Entity
        message : str
        '''
        entity_ = Entity.from_json(entity) if entity else None
        message_ = message

        # Validate arguments against known Juju API types.
        if entity_ is not None and not isinstance(entity_, (dict, Entity)):
            raise Exception("Expected entity_ to be a Entity, received: {}".format(type(entity_)))

        if message_ is not None and not isinstance(message_, (bytes, str)):
            raise Exception("Expected message_ to be a str, received: {}".format(type(message_)))

        self.entity = entity_
        self.message = message_
        self.unknown_fields = unknown_fields



class SetProfileUpgradeCompleteArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~SetProfileUpgradeCompleteArg]
        '''
        args_ = [SetProfileUpgradeCompleteArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class SetProviderNetworkConfig(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~ProviderNetworkConfig]
        '''
        args_ = [ProviderNetworkConfig.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class SetProviderNetworkConfigResult(Type):
    _toSchema = {'addresses': 'addresses', 'error': 'error', 'modified': 'modified'}
    _toPy = {'addresses': 'addresses', 'error': 'error', 'modified': 'modified'}
    def __init__(self, addresses=None, error=None, modified=None, **unknown_fields):
        '''
        addresses : typing.Sequence[~Address]
        error : Error
        modified : bool
        '''
        addresses_ = [Address.from_json(o) for o in addresses or []]
        error_ = Error.from_json(error) if error else None
        modified_ = modified

        # Validate arguments against known Juju API types.
        if addresses_ is not None and not isinstance(addresses_, (bytes, str, list)):
            raise Exception("Expected addresses_ to be a Sequence, received: {}".format(type(addresses_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if modified_ is not None and not isinstance(modified_, bool):
            raise Exception("Expected modified_ to be a bool, received: {}".format(type(modified_)))

        self.addresses = addresses_
        self.error = error_
        self.modified = modified_
        self.unknown_fields = unknown_fields



class SetProviderNetworkConfigResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~SetProviderNetworkConfigResult]
        '''
        results_ = [SetProviderNetworkConfigResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class SetStatus(Type):
    _toSchema = {'entities': 'entities'}
    _toPy = {'entities': 'entities'}
    def __init__(self, entities=None, **unknown_fields):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        '''
        entities_ = [EntityStatusArgs.from_json(o) for o in entities or []]

        # Validate arguments against known Juju API types.
        if entities_ is not None and not isinstance(entities_, (bytes, str, list)):
            raise Exception("Expected entities_ to be a Sequence, received: {}".format(type(entities_)))

        self.entities = entities_
        self.unknown_fields = unknown_fields



class SetStatusArg(Type):
    _toSchema = {'entity': 'Entity', 'status': 'status'}
    _toPy = {'Entity': 'entity', 'status': 'status'}
    def __init__(self, entity=None, status=None, **unknown_fields):
        '''
        entity : Entity
        status : str
        '''
        entity_ = Entity.from_json(entity) if entity else None
        status_ = status

        # Validate arguments against known Juju API types.
        if entity_ is not None and not isinstance(entity_, (dict, Entity)):
            raise Exception("Expected entity_ to be a Entity, received: {}".format(type(entity_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.entity = entity_
        self.status = status_
        self.unknown_fields = unknown_fields



class SetStatusArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~SetStatusArg]
        '''
        args_ = [SetStatusArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class SetUnitStateArg(Type):
    _toSchema = {'charm_state': 'charm-state', 'meter_status_state': 'meter-status-state', 'relation_state': 'relation-state', 'storage_state': 'storage-state', 'tag': 'tag', 'uniter_state': 'uniter-state'}
    _toPy = {'charm-state': 'charm_state', 'meter-status-state': 'meter_status_state', 'relation-state': 'relation_state', 'storage-state': 'storage_state', 'tag': 'tag', 'uniter-state': 'uniter_state'}
    def __init__(self, charm_state=None, meter_status_state=None, relation_state=None, storage_state=None, tag=None, uniter_state=None, **unknown_fields):
        '''
        charm_state : typing.Mapping[str, str]
        meter_status_state : str
        relation_state : typing.Mapping[str, str]
        storage_state : str
        tag : str
        uniter_state : str
        '''
        charm_state_ = charm_state
        meter_status_state_ = meter_status_state
        relation_state_ = relation_state
        storage_state_ = storage_state
        tag_ = tag
        uniter_state_ = uniter_state

        # Validate arguments against known Juju API types.
        if charm_state_ is not None and not isinstance(charm_state_, dict):
            raise Exception("Expected charm_state_ to be a Mapping, received: {}".format(type(charm_state_)))

        if meter_status_state_ is not None and not isinstance(meter_status_state_, (bytes, str)):
            raise Exception("Expected meter_status_state_ to be a str, received: {}".format(type(meter_status_state_)))

        if relation_state_ is not None and not isinstance(relation_state_, dict):
            raise Exception("Expected relation_state_ to be a Mapping, received: {}".format(type(relation_state_)))

        if storage_state_ is not None and not isinstance(storage_state_, (bytes, str)):
            raise Exception("Expected storage_state_ to be a str, received: {}".format(type(storage_state_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        if uniter_state_ is not None and not isinstance(uniter_state_, (bytes, str)):
            raise Exception("Expected uniter_state_ to be a str, received: {}".format(type(uniter_state_)))

        self.charm_state = charm_state_
        self.meter_status_state = meter_status_state_
        self.relation_state = relation_state_
        self.storage_state = storage_state_
        self.tag = tag_
        self.uniter_state = uniter_state_
        self.unknown_fields = unknown_fields



class SetUnitStateArgs(Type):
    _toSchema = {'args': 'args'}
    _toPy = {'args': 'args'}
    def __init__(self, args=None, **unknown_fields):
        '''
        args : typing.Sequence[~SetUnitStateArg]
        '''
        args_ = [SetUnitStateArg.from_json(o) for o in args or []]

        # Validate arguments against known Juju API types.
        if args_ is not None and not isinstance(args_, (bytes, str, list)):
            raise Exception("Expected args_ to be a Sequence, received: {}".format(type(args_)))

        self.args = args_
        self.unknown_fields = unknown_fields



class Settings(Type):
    _toSchema = {'autonoproxy': 'AutoNoProxy', 'ftp': 'Ftp', 'http': 'Http', 'https': 'Https', 'noproxy': 'NoProxy'}
    _toPy = {'AutoNoProxy': 'autonoproxy', 'Ftp': 'ftp', 'Http': 'http', 'Https': 'https', 'NoProxy': 'noproxy'}
    def __init__(self, autonoproxy=None, ftp=None, http=None, https=None, noproxy=None, **unknown_fields):
        '''
        autonoproxy : str
        ftp : str
        http : str
        https : str
        noproxy : str
        '''
        autonoproxy_ = autonoproxy
        ftp_ = ftp
        http_ = http
        https_ = https
        noproxy_ = noproxy

        # Validate arguments against known Juju API types.
        if autonoproxy_ is not None and not isinstance(autonoproxy_, (bytes, str)):
            raise Exception("Expected autonoproxy_ to be a str, received: {}".format(type(autonoproxy_)))

        if ftp_ is not None and not isinstance(ftp_, (bytes, str)):
            raise Exception("Expected ftp_ to be a str, received: {}".format(type(ftp_)))

        if http_ is not None and not isinstance(http_, (bytes, str)):
            raise Exception("Expected http_ to be a str, received: {}".format(type(http_)))

        if https_ is not None and not isinstance(https_, (bytes, str)):
            raise Exception("Expected https_ to be a str, received: {}".format(type(https_)))

        if noproxy_ is not None and not isinstance(noproxy_, (bytes, str)):
            raise Exception("Expected noproxy_ to be a str, received: {}".format(type(noproxy_)))

        self.autonoproxy = autonoproxy_
        self.ftp = ftp_
        self.http = http_
        self.https = https_
        self.noproxy = noproxy_
        self.unknown_fields = unknown_fields



class SettingsResult(Type):
    _toSchema = {'error': 'error', 'settings': 'settings'}
    _toPy = {'error': 'error', 'settings': 'settings'}
    def __init__(self, error=None, settings=None, **unknown_fields):
        '''
        error : Error
        settings : typing.Mapping[str, str]
        '''
        error_ = Error.from_json(error) if error else None
        settings_ = settings

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if settings_ is not None and not isinstance(settings_, dict):
            raise Exception("Expected settings_ to be a Mapping, received: {}".format(type(settings_)))

        self.error = error_
        self.settings = settings_
        self.unknown_fields = unknown_fields



class SettingsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~SettingsResult]
        '''
        results_ = [SettingsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class ShowSpaceResult(Type):
    _toSchema = {'applications': 'applications', 'error': 'error', 'machine_count': 'machine-count', 'space': 'space'}
    _toPy = {'applications': 'applications', 'error': 'error', 'machine-count': 'machine_count', 'space': 'space'}
    def __init__(self, applications=None, error=None, machine_count=None, space=None, **unknown_fields):
        '''
        applications : typing.Sequence[str]
        error : Error
        machine_count : int
        space : Space
        '''
        applications_ = applications
        error_ = Error.from_json(error) if error else None
        machine_count_ = machine_count
        space_ = Space.from_json(space) if space else None

        # Validate arguments against known Juju API types.
        if applications_ is not None and not isinstance(applications_, (bytes, str, list)):
            raise Exception("Expected applications_ to be a Sequence, received: {}".format(type(applications_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if machine_count_ is not None and not isinstance(machine_count_, int):
            raise Exception("Expected machine_count_ to be a int, received: {}".format(type(machine_count_)))

        if space_ is not None and not isinstance(space_, (dict, Space)):
            raise Exception("Expected space_ to be a Space, received: {}".format(type(space_)))

        self.applications = applications_
        self.error = error_
        self.machine_count = machine_count_
        self.space = space_
        self.unknown_fields = unknown_fields



class ShowSpaceResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~ShowSpaceResult]
        '''
        results_ = [ShowSpaceResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class SingularClaim(Type):
    _toSchema = {'claimant_tag': 'claimant-tag', 'duration': 'duration', 'entity_tag': 'entity-tag'}
    _toPy = {'claimant-tag': 'claimant_tag', 'duration': 'duration', 'entity-tag': 'entity_tag'}
    def __init__(self, claimant_tag=None, duration=None, entity_tag=None, **unknown_fields):
        '''
        claimant_tag : str
        duration : int
        entity_tag : str
        '''
        claimant_tag_ = claimant_tag
        duration_ = duration
        entity_tag_ = entity_tag

        # Validate arguments against known Juju API types.
        if claimant_tag_ is not None and not isinstance(claimant_tag_, (bytes, str)):
            raise Exception("Expected claimant_tag_ to be a str, received: {}".format(type(claimant_tag_)))

        if duration_ is not None and not isinstance(duration_, int):
            raise Exception("Expected duration_ to be a int, received: {}".format(type(duration_)))

        if entity_tag_ is not None and not isinstance(entity_tag_, (bytes, str)):
            raise Exception("Expected entity_tag_ to be a str, received: {}".format(type(entity_tag_)))

        self.claimant_tag = claimant_tag_
        self.duration = duration_
        self.entity_tag = entity_tag_
        self.unknown_fields = unknown_fields



class SingularClaims(Type):
    _toSchema = {'claims': 'claims'}
    _toPy = {'claims': 'claims'}
    def __init__(self, claims=None, **unknown_fields):
        '''
        claims : typing.Sequence[~SingularClaim]
        '''
        claims_ = [SingularClaim.from_json(o) for o in claims or []]

        # Validate arguments against known Juju API types.
        if claims_ is not None and not isinstance(claims_, (bytes, str, list)):
            raise Exception("Expected claims_ to be a Sequence, received: {}".format(type(claims_)))

        self.claims = claims_
        self.unknown_fields = unknown_fields



class Space(Type):
    _toSchema = {'error': 'error', 'id_': 'id', 'name': 'name', 'subnets': 'subnets'}
    _toPy = {'error': 'error', 'id': 'id_', 'name': 'name', 'subnets': 'subnets'}
    def __init__(self, error=None, id_=None, name=None, subnets=None, **unknown_fields):
        '''
        error : Error
        id_ : str
        name : str
        subnets : typing.Sequence[~Subnet]
        '''
        error_ = Error.from_json(error) if error else None
        id__ = id_
        name_ = name
        subnets_ = [Subnet.from_json(o) for o in subnets or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if subnets_ is not None and not isinstance(subnets_, (bytes, str, list)):
            raise Exception("Expected subnets_ to be a Sequence, received: {}".format(type(subnets_)))

        self.error = error_
        self.id_ = id__
        self.name = name_
        self.subnets = subnets_
        self.unknown_fields = unknown_fields



class SpaceResult(Type):
    _toSchema = {'error': 'error', 'tag': 'tag'}
    _toPy = {'error': 'error', 'tag': 'tag'}
    def __init__(self, error=None, tag=None, **unknown_fields):
        '''
        error : Error
        tag : str
        '''
        error_ = Error.from_json(error) if error else None
        tag_ = tag

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.error = error_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class SpaceResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~SpaceResult]
        '''
        results_ = [SpaceResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StateServingInfo(Type):
    _toSchema = {'api_port': 'api-port', 'ca_private_key': 'ca-private-key', 'cert': 'cert', 'controller_api_port': 'controller-api-port', 'private_key': 'private-key', 'shared_secret': 'shared-secret', 'state_port': 'state-port', 'system_identity': 'system-identity'}
    _toPy = {'api-port': 'api_port', 'ca-private-key': 'ca_private_key', 'cert': 'cert', 'controller-api-port': 'controller_api_port', 'private-key': 'private_key', 'shared-secret': 'shared_secret', 'state-port': 'state_port', 'system-identity': 'system_identity'}
    def __init__(self, api_port=None, ca_private_key=None, cert=None, controller_api_port=None, private_key=None, shared_secret=None, state_port=None, system_identity=None, **unknown_fields):
        '''
        api_port : int
        ca_private_key : str
        cert : str
        controller_api_port : int
        private_key : str
        shared_secret : str
        state_port : int
        system_identity : str
        '''
        api_port_ = api_port
        ca_private_key_ = ca_private_key
        cert_ = cert
        controller_api_port_ = controller_api_port
        private_key_ = private_key
        shared_secret_ = shared_secret
        state_port_ = state_port
        system_identity_ = system_identity

        # Validate arguments against known Juju API types.
        if api_port_ is not None and not isinstance(api_port_, int):
            raise Exception("Expected api_port_ to be a int, received: {}".format(type(api_port_)))

        if ca_private_key_ is not None and not isinstance(ca_private_key_, (bytes, str)):
            raise Exception("Expected ca_private_key_ to be a str, received: {}".format(type(ca_private_key_)))

        if cert_ is not None and not isinstance(cert_, (bytes, str)):
            raise Exception("Expected cert_ to be a str, received: {}".format(type(cert_)))

        if controller_api_port_ is not None and not isinstance(controller_api_port_, int):
            raise Exception("Expected controller_api_port_ to be a int, received: {}".format(type(controller_api_port_)))

        if private_key_ is not None and not isinstance(private_key_, (bytes, str)):
            raise Exception("Expected private_key_ to be a str, received: {}".format(type(private_key_)))

        if shared_secret_ is not None and not isinstance(shared_secret_, (bytes, str)):
            raise Exception("Expected shared_secret_ to be a str, received: {}".format(type(shared_secret_)))

        if state_port_ is not None and not isinstance(state_port_, int):
            raise Exception("Expected state_port_ to be a int, received: {}".format(type(state_port_)))

        if system_identity_ is not None and not isinstance(system_identity_, (bytes, str)):
            raise Exception("Expected system_identity_ to be a str, received: {}".format(type(system_identity_)))

        self.api_port = api_port_
        self.ca_private_key = ca_private_key_
        self.cert = cert_
        self.controller_api_port = controller_api_port_
        self.private_key = private_key_
        self.shared_secret = shared_secret_
        self.state_port = state_port_
        self.system_identity = system_identity_
        self.unknown_fields = unknown_fields



class StatusHistoryFilter(Type):
    _toSchema = {'date': 'date', 'delta': 'delta', 'exclude': 'exclude', 'size': 'size'}
    _toPy = {'date': 'date', 'delta': 'delta', 'exclude': 'exclude', 'size': 'size'}
    def __init__(self, date=None, delta=None, exclude=None, size=None, **unknown_fields):
        '''
        date : str
        delta : int
        exclude : typing.Sequence[str]
        size : int
        '''
        date_ = date
        delta_ = delta
        exclude_ = exclude
        size_ = size

        # Validate arguments against known Juju API types.
        if date_ is not None and not isinstance(date_, (bytes, str)):
            raise Exception("Expected date_ to be a str, received: {}".format(type(date_)))

        if delta_ is not None and not isinstance(delta_, int):
            raise Exception("Expected delta_ to be a int, received: {}".format(type(delta_)))

        if exclude_ is not None and not isinstance(exclude_, (bytes, str, list)):
            raise Exception("Expected exclude_ to be a Sequence, received: {}".format(type(exclude_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        self.date = date_
        self.delta = delta_
        self.exclude = exclude_
        self.size = size_
        self.unknown_fields = unknown_fields



class StatusHistoryPruneArgs(Type):
    _toSchema = {'max_history_mb': 'max-history-mb', 'max_history_time': 'max-history-time'}
    _toPy = {'max-history-mb': 'max_history_mb', 'max-history-time': 'max_history_time'}
    def __init__(self, max_history_mb=None, max_history_time=None, **unknown_fields):
        '''
        max_history_mb : int
        max_history_time : int
        '''
        max_history_mb_ = max_history_mb
        max_history_time_ = max_history_time

        # Validate arguments against known Juju API types.
        if max_history_mb_ is not None and not isinstance(max_history_mb_, int):
            raise Exception("Expected max_history_mb_ to be a int, received: {}".format(type(max_history_mb_)))

        if max_history_time_ is not None and not isinstance(max_history_time_, int):
            raise Exception("Expected max_history_time_ to be a int, received: {}".format(type(max_history_time_)))

        self.max_history_mb = max_history_mb_
        self.max_history_time = max_history_time_
        self.unknown_fields = unknown_fields



class StatusHistoryRequest(Type):
    _toSchema = {'filter_': 'filter', 'historykind': 'historyKind', 'size': 'size', 'tag': 'tag'}
    _toPy = {'filter': 'filter_', 'historyKind': 'historykind', 'size': 'size', 'tag': 'tag'}
    def __init__(self, filter_=None, historykind=None, size=None, tag=None, **unknown_fields):
        '''
        filter_ : StatusHistoryFilter
        historykind : str
        size : int
        tag : str
        '''
        filter__ = StatusHistoryFilter.from_json(filter_) if filter_ else None
        historykind_ = historykind
        size_ = size
        tag_ = tag

        # Validate arguments against known Juju API types.
        if filter__ is not None and not isinstance(filter__, (dict, StatusHistoryFilter)):
            raise Exception("Expected filter__ to be a StatusHistoryFilter, received: {}".format(type(filter__)))

        if historykind_ is not None and not isinstance(historykind_, (bytes, str)):
            raise Exception("Expected historykind_ to be a str, received: {}".format(type(historykind_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        if tag_ is not None and not isinstance(tag_, (bytes, str)):
            raise Exception("Expected tag_ to be a str, received: {}".format(type(tag_)))

        self.filter_ = filter__
        self.historykind = historykind_
        self.size = size_
        self.tag = tag_
        self.unknown_fields = unknown_fields



class StatusHistoryRequests(Type):
    _toSchema = {'requests': 'requests'}
    _toPy = {'requests': 'requests'}
    def __init__(self, requests=None, **unknown_fields):
        '''
        requests : typing.Sequence[~StatusHistoryRequest]
        '''
        requests_ = [StatusHistoryRequest.from_json(o) for o in requests or []]

        # Validate arguments against known Juju API types.
        if requests_ is not None and not isinstance(requests_, (bytes, str, list)):
            raise Exception("Expected requests_ to be a Sequence, received: {}".format(type(requests_)))

        self.requests = requests_
        self.unknown_fields = unknown_fields



class StatusHistoryResult(Type):
    _toSchema = {'error': 'error', 'history': 'history'}
    _toPy = {'error': 'error', 'history': 'history'}
    def __init__(self, error=None, history=None, **unknown_fields):
        '''
        error : Error
        history : History
        '''
        error_ = Error.from_json(error) if error else None
        history_ = History.from_json(history) if history else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if history_ is not None and not isinstance(history_, (dict, History)):
            raise Exception("Expected history_ to be a History, received: {}".format(type(history_)))

        self.error = error_
        self.history = history_
        self.unknown_fields = unknown_fields



class StatusHistoryResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StatusHistoryResult]
        '''
        results_ = [StatusHistoryResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StatusParams(Type):
    _toSchema = {'patterns': 'patterns'}
    _toPy = {'patterns': 'patterns'}
    def __init__(self, patterns=None, **unknown_fields):
        '''
        patterns : typing.Sequence[str]
        '''
        patterns_ = patterns

        # Validate arguments against known Juju API types.
        if patterns_ is not None and not isinstance(patterns_, (bytes, str, list)):
            raise Exception("Expected patterns_ to be a Sequence, received: {}".format(type(patterns_)))

        self.patterns = patterns_
        self.unknown_fields = unknown_fields



class StatusResult(Type):
    _toSchema = {'data': 'data', 'error': 'error', 'id_': 'id', 'info': 'info', 'life': 'life', 'since': 'since', 'status': 'status'}
    _toPy = {'data': 'data', 'error': 'error', 'id': 'id_', 'info': 'info', 'life': 'life', 'since': 'since', 'status': 'status'}
    def __init__(self, data=None, error=None, id_=None, info=None, life=None, since=None, status=None, **unknown_fields):
        '''
        data : typing.Mapping[str, typing.Any]
        error : Error
        id_ : str
        info : str
        life : str
        since : str
        status : str
        '''
        data_ = data
        error_ = Error.from_json(error) if error else None
        id__ = id_
        info_ = info
        life_ = life
        since_ = since
        status_ = status

        # Validate arguments against known Juju API types.
        if data_ is not None and not isinstance(data_, dict):
            raise Exception("Expected data_ to be a Mapping, received: {}".format(type(data_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if info_ is not None and not isinstance(info_, (bytes, str)):
            raise Exception("Expected info_ to be a str, received: {}".format(type(info_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if since_ is not None and not isinstance(since_, (bytes, str)):
            raise Exception("Expected since_ to be a str, received: {}".format(type(since_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        self.data = data_
        self.error = error_
        self.id_ = id__
        self.info = info_
        self.life = life_
        self.since = since_
        self.status = status_
        self.unknown_fields = unknown_fields



class StatusResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StatusResult]
        '''
        results_ = [StatusResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StorageAddParams(Type):
    _toSchema = {'name': 'name', 'storage': 'storage', 'unit': 'unit'}
    _toPy = {'name': 'name', 'storage': 'storage', 'unit': 'unit'}
    def __init__(self, name=None, storage=None, unit=None, **unknown_fields):
        '''
        name : str
        storage : StorageConstraints
        unit : str
        '''
        name_ = name
        storage_ = StorageConstraints.from_json(storage) if storage else None
        unit_ = unit

        # Validate arguments against known Juju API types.
        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if storage_ is not None and not isinstance(storage_, (dict, StorageConstraints)):
            raise Exception("Expected storage_ to be a StorageConstraints, received: {}".format(type(storage_)))

        if unit_ is not None and not isinstance(unit_, (bytes, str)):
            raise Exception("Expected unit_ to be a str, received: {}".format(type(unit_)))

        self.name = name_
        self.storage = storage_
        self.unit = unit_
        self.unknown_fields = unknown_fields



class StorageAttachment(Type):
    _toSchema = {'kind': 'kind', 'life': 'life', 'location': 'location', 'owner_tag': 'owner-tag', 'storage_tag': 'storage-tag', 'unit_tag': 'unit-tag'}
    _toPy = {'kind': 'kind', 'life': 'life', 'location': 'location', 'owner-tag': 'owner_tag', 'storage-tag': 'storage_tag', 'unit-tag': 'unit_tag'}
    def __init__(self, kind=None, life=None, location=None, owner_tag=None, storage_tag=None, unit_tag=None, **unknown_fields):
        '''
        kind : int
        life : str
        location : str
        owner_tag : str
        storage_tag : str
        unit_tag : str
        '''
        kind_ = kind
        life_ = life
        location_ = location
        owner_tag_ = owner_tag
        storage_tag_ = storage_tag
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if kind_ is not None and not isinstance(kind_, int):
            raise Exception("Expected kind_ to be a int, received: {}".format(type(kind_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if location_ is not None and not isinstance(location_, (bytes, str)):
            raise Exception("Expected location_ to be a str, received: {}".format(type(location_)))

        if owner_tag_ is not None and not isinstance(owner_tag_, (bytes, str)):
            raise Exception("Expected owner_tag_ to be a str, received: {}".format(type(owner_tag_)))

        if storage_tag_ is not None and not isinstance(storage_tag_, (bytes, str)):
            raise Exception("Expected storage_tag_ to be a str, received: {}".format(type(storage_tag_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.kind = kind_
        self.life = life_
        self.location = location_
        self.owner_tag = owner_tag_
        self.storage_tag = storage_tag_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class StorageAttachmentDetails(Type):
    _toSchema = {'life': 'life', 'location': 'location', 'machine_tag': 'machine-tag', 'storage_tag': 'storage-tag', 'unit_tag': 'unit-tag'}
    _toPy = {'life': 'life', 'location': 'location', 'machine-tag': 'machine_tag', 'storage-tag': 'storage_tag', 'unit-tag': 'unit_tag'}
    def __init__(self, life=None, location=None, machine_tag=None, storage_tag=None, unit_tag=None, **unknown_fields):
        '''
        life : str
        location : str
        machine_tag : str
        storage_tag : str
        unit_tag : str
        '''
        life_ = life
        location_ = location
        machine_tag_ = machine_tag
        storage_tag_ = storage_tag
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if location_ is not None and not isinstance(location_, (bytes, str)):
            raise Exception("Expected location_ to be a str, received: {}".format(type(location_)))

        if machine_tag_ is not None and not isinstance(machine_tag_, (bytes, str)):
            raise Exception("Expected machine_tag_ to be a str, received: {}".format(type(machine_tag_)))

        if storage_tag_ is not None and not isinstance(storage_tag_, (bytes, str)):
            raise Exception("Expected storage_tag_ to be a str, received: {}".format(type(storage_tag_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.life = life_
        self.location = location_
        self.machine_tag = machine_tag_
        self.storage_tag = storage_tag_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class StorageAttachmentId(Type):
    _toSchema = {'storage_tag': 'storage-tag', 'unit_tag': 'unit-tag'}
    _toPy = {'storage-tag': 'storage_tag', 'unit-tag': 'unit_tag'}
    def __init__(self, storage_tag=None, unit_tag=None, **unknown_fields):
        '''
        storage_tag : str
        unit_tag : str
        '''
        storage_tag_ = storage_tag
        unit_tag_ = unit_tag

        # Validate arguments against known Juju API types.
        if storage_tag_ is not None and not isinstance(storage_tag_, (bytes, str)):
            raise Exception("Expected storage_tag_ to be a str, received: {}".format(type(storage_tag_)))

        if unit_tag_ is not None and not isinstance(unit_tag_, (bytes, str)):
            raise Exception("Expected unit_tag_ to be a str, received: {}".format(type(unit_tag_)))

        self.storage_tag = storage_tag_
        self.unit_tag = unit_tag_
        self.unknown_fields = unknown_fields



class StorageAttachmentIds(Type):
    _toSchema = {'ids': 'ids'}
    _toPy = {'ids': 'ids'}
    def __init__(self, ids=None, **unknown_fields):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        '''
        ids_ = [StorageAttachmentId.from_json(o) for o in ids or []]

        # Validate arguments against known Juju API types.
        if ids_ is not None and not isinstance(ids_, (bytes, str, list)):
            raise Exception("Expected ids_ to be a Sequence, received: {}".format(type(ids_)))

        self.ids = ids_
        self.unknown_fields = unknown_fields



class StorageAttachmentIdsResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : StorageAttachmentIds
        '''
        error_ = Error.from_json(error) if error else None
        result_ = StorageAttachmentIds.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, StorageAttachmentIds)):
            raise Exception("Expected result_ to be a StorageAttachmentIds, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class StorageAttachmentIdsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StorageAttachmentIdsResult]
        '''
        results_ = [StorageAttachmentIdsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StorageAttachmentResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : StorageAttachment
        '''
        error_ = Error.from_json(error) if error else None
        result_ = StorageAttachment.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, StorageAttachment)):
            raise Exception("Expected result_ to be a StorageAttachment, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class StorageAttachmentResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StorageAttachmentResult]
        '''
        results_ = [StorageAttachmentResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StorageConstraints(Type):
    _toSchema = {'count': 'count', 'pool': 'pool', 'size': 'size'}
    _toPy = {'count': 'count', 'pool': 'pool', 'size': 'size'}
    def __init__(self, count=None, pool=None, size=None, **unknown_fields):
        '''
        count : int
        pool : str
        size : int
        '''
        count_ = count
        pool_ = pool
        size_ = size

        # Validate arguments against known Juju API types.
        if count_ is not None and not isinstance(count_, int):
            raise Exception("Expected count_ to be a int, received: {}".format(type(count_)))

        if pool_ is not None and not isinstance(pool_, (bytes, str)):
            raise Exception("Expected pool_ to be a str, received: {}".format(type(pool_)))

        if size_ is not None and not isinstance(size_, int):
            raise Exception("Expected size_ to be a int, received: {}".format(type(size_)))

        self.count = count_
        self.pool = pool_
        self.size = size_
        self.unknown_fields = unknown_fields



class StorageDetachmentParams(Type):
    _toSchema = {'force': 'force', 'ids': 'ids', 'max_wait': 'max-wait'}
    _toPy = {'force': 'force', 'ids': 'ids', 'max-wait': 'max_wait'}
    def __init__(self, force=None, ids=None, max_wait=None, **unknown_fields):
        '''
        force : bool
        ids : StorageAttachmentIds
        max_wait : int
        '''
        force_ = force
        ids_ = StorageAttachmentIds.from_json(ids) if ids else None
        max_wait_ = max_wait

        # Validate arguments against known Juju API types.
        if force_ is not None and not isinstance(force_, bool):
            raise Exception("Expected force_ to be a bool, received: {}".format(type(force_)))

        if ids_ is not None and not isinstance(ids_, (dict, StorageAttachmentIds)):
            raise Exception("Expected ids_ to be a StorageAttachmentIds, received: {}".format(type(ids_)))

        if max_wait_ is not None and not isinstance(max_wait_, int):
            raise Exception("Expected max_wait_ to be a int, received: {}".format(type(max_wait_)))

        self.force = force_
        self.ids = ids_
        self.max_wait = max_wait_
        self.unknown_fields = unknown_fields



class StorageDetails(Type):
    _toSchema = {'attachments': 'attachments', 'kind': 'kind', 'life': 'life', 'owner_tag': 'owner-tag', 'persistent': 'persistent', 'status': 'status', 'storage_tag': 'storage-tag'}
    _toPy = {'attachments': 'attachments', 'kind': 'kind', 'life': 'life', 'owner-tag': 'owner_tag', 'persistent': 'persistent', 'status': 'status', 'storage-tag': 'storage_tag'}
    def __init__(self, attachments=None, kind=None, life=None, owner_tag=None, persistent=None, status=None, storage_tag=None, **unknown_fields):
        '''
        attachments : typing.Mapping[str, ~StorageAttachmentDetails]
        kind : int
        life : str
        owner_tag : str
        persistent : bool
        status : EntityStatus
        storage_tag : str
        '''
        attachments_ = {k: StorageAttachmentDetails.from_json(v) for k, v in (attachments or dict()).items()}
        kind_ = kind
        life_ = life
        owner_tag_ = owner_tag
        persistent_ = persistent
        status_ = EntityStatus.from_json(status) if status else None
        storage_tag_ = storage_tag

        # Validate arguments against known Juju API types.
        if attachments_ is not None and not isinstance(attachments_, dict):
            raise Exception("Expected attachments_ to be a Mapping, received: {}".format(type(attachments_)))

        if kind_ is not None and not isinstance(kind_, int):
            raise Exception("Expected kind_ to be a int, received: {}".format(type(kind_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if owner_tag_ is not None and not isinstance(owner_tag_, (bytes, str)):
            raise Exception("Expected owner_tag_ to be a str, received: {}".format(type(owner_tag_)))

        if persistent_ is not None and not isinstance(persistent_, bool):
            raise Exception("Expected persistent_ to be a bool, received: {}".format(type(persistent_)))

        if status_ is not None and not isinstance(status_, (dict, EntityStatus)):
            raise Exception("Expected status_ to be a EntityStatus, received: {}".format(type(status_)))

        if storage_tag_ is not None and not isinstance(storage_tag_, (bytes, str)):
            raise Exception("Expected storage_tag_ to be a str, received: {}".format(type(storage_tag_)))

        self.attachments = attachments_
        self.kind = kind_
        self.life = life_
        self.owner_tag = owner_tag_
        self.persistent = persistent_
        self.status = status_
        self.storage_tag = storage_tag_
        self.unknown_fields = unknown_fields



class StorageDetailsListResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : typing.Sequence[~StorageDetails]
        '''
        error_ = Error.from_json(error) if error else None
        result_ = [StorageDetails.from_json(o) for o in result or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (bytes, str, list)):
            raise Exception("Expected result_ to be a Sequence, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class StorageDetailsListResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StorageDetailsListResult]
        '''
        results_ = [StorageDetailsListResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StorageDetailsResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : StorageDetails
        '''
        error_ = Error.from_json(error) if error else None
        result_ = StorageDetails.from_json(result) if result else None

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (dict, StorageDetails)):
            raise Exception("Expected result_ to be a StorageDetails, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class StorageDetailsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StorageDetailsResult]
        '''
        results_ = [StorageDetailsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StorageFilter(Type):
    _toSchema = {}
    _toPy = {}
    def __init__(self, **unknown_fields):
        '''

        '''
        self.unknown_fields = unknown_fields



class StorageFilters(Type):
    _toSchema = {'filters': 'filters'}
    _toPy = {'filters': 'filters'}
    def __init__(self, filters=None, **unknown_fields):
        '''
        filters : typing.Sequence[~StorageFilter]
        '''
        filters_ = [StorageFilter.from_json(o) for o in filters or []]

        # Validate arguments against known Juju API types.
        if filters_ is not None and not isinstance(filters_, (bytes, str, list)):
            raise Exception("Expected filters_ to be a Sequence, received: {}".format(type(filters_)))

        self.filters = filters_
        self.unknown_fields = unknown_fields



class StoragePool(Type):
    _toSchema = {'attrs': 'attrs', 'name': 'name', 'provider': 'provider'}
    _toPy = {'attrs': 'attrs', 'name': 'name', 'provider': 'provider'}
    def __init__(self, attrs=None, name=None, provider=None, **unknown_fields):
        '''
        attrs : typing.Mapping[str, typing.Any]
        name : str
        provider : str
        '''
        attrs_ = attrs
        name_ = name
        provider_ = provider

        # Validate arguments against known Juju API types.
        if attrs_ is not None and not isinstance(attrs_, dict):
            raise Exception("Expected attrs_ to be a Mapping, received: {}".format(type(attrs_)))

        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        if provider_ is not None and not isinstance(provider_, (bytes, str)):
            raise Exception("Expected provider_ to be a str, received: {}".format(type(provider_)))

        self.attrs = attrs_
        self.name = name_
        self.provider = provider_
        self.unknown_fields = unknown_fields



class StoragePoolArgs(Type):
    _toSchema = {'pools': 'pools'}
    _toPy = {'pools': 'pools'}
    def __init__(self, pools=None, **unknown_fields):
        '''
        pools : typing.Sequence[~StoragePool]
        '''
        pools_ = [StoragePool.from_json(o) for o in pools or []]

        # Validate arguments against known Juju API types.
        if pools_ is not None and not isinstance(pools_, (bytes, str, list)):
            raise Exception("Expected pools_ to be a Sequence, received: {}".format(type(pools_)))

        self.pools = pools_
        self.unknown_fields = unknown_fields



class StoragePoolDeleteArg(Type):
    _toSchema = {'name': 'name'}
    _toPy = {'name': 'name'}
    def __init__(self, name=None, **unknown_fields):
        '''
        name : str
        '''
        name_ = name

        # Validate arguments against known Juju API types.
        if name_ is not None and not isinstance(name_, (bytes, str)):
            raise Exception("Expected name_ to be a str, received: {}".format(type(name_)))

        self.name = name_
        self.unknown_fields = unknown_fields



class StoragePoolDeleteArgs(Type):
    _toSchema = {'pools': 'pools'}
    _toPy = {'pools': 'pools'}
    def __init__(self, pools=None, **unknown_fields):
        '''
        pools : typing.Sequence[~StoragePoolDeleteArg]
        '''
        pools_ = [StoragePoolDeleteArg.from_json(o) for o in pools or []]

        # Validate arguments against known Juju API types.
        if pools_ is not None and not isinstance(pools_, (bytes, str, list)):
            raise Exception("Expected pools_ to be a Sequence, received: {}".format(type(pools_)))

        self.pools = pools_
        self.unknown_fields = unknown_fields



class StoragePoolFilter(Type):
    _toSchema = {'names': 'names', 'providers': 'providers'}
    _toPy = {'names': 'names', 'providers': 'providers'}
    def __init__(self, names=None, providers=None, **unknown_fields):
        '''
        names : typing.Sequence[str]
        providers : typing.Sequence[str]
        '''
        names_ = names
        providers_ = providers

        # Validate arguments against known Juju API types.
        if names_ is not None and not isinstance(names_, (bytes, str, list)):
            raise Exception("Expected names_ to be a Sequence, received: {}".format(type(names_)))

        if providers_ is not None and not isinstance(providers_, (bytes, str, list)):
            raise Exception("Expected providers_ to be a Sequence, received: {}".format(type(providers_)))

        self.names = names_
        self.providers = providers_
        self.unknown_fields = unknown_fields



class StoragePoolFilters(Type):
    _toSchema = {'filters': 'filters'}
    _toPy = {'filters': 'filters'}
    def __init__(self, filters=None, **unknown_fields):
        '''
        filters : typing.Sequence[~StoragePoolFilter]
        '''
        filters_ = [StoragePoolFilter.from_json(o) for o in filters or []]

        # Validate arguments against known Juju API types.
        if filters_ is not None and not isinstance(filters_, (bytes, str, list)):
            raise Exception("Expected filters_ to be a Sequence, received: {}".format(type(filters_)))

        self.filters = filters_
        self.unknown_fields = unknown_fields



class StoragePoolsResult(Type):
    _toSchema = {'error': 'error', 'storage_pools': 'storage-pools'}
    _toPy = {'error': 'error', 'storage-pools': 'storage_pools'}
    def __init__(self, error=None, storage_pools=None, **unknown_fields):
        '''
        error : Error
        storage_pools : typing.Sequence[~StoragePool]
        '''
        error_ = Error.from_json(error) if error else None
        storage_pools_ = [StoragePool.from_json(o) for o in storage_pools or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if storage_pools_ is not None and not isinstance(storage_pools_, (bytes, str, list)):
            raise Exception("Expected storage_pools_ to be a Sequence, received: {}".format(type(storage_pools_)))

        self.error = error_
        self.storage_pools = storage_pools_
        self.unknown_fields = unknown_fields



class StoragePoolsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StoragePoolsResult]
        '''
        results_ = [StoragePoolsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StoragesAddParams(Type):
    _toSchema = {'storages': 'storages'}
    _toPy = {'storages': 'storages'}
    def __init__(self, storages=None, **unknown_fields):
        '''
        storages : typing.Sequence[~StorageAddParams]
        '''
        storages_ = [StorageAddParams.from_json(o) for o in storages or []]

        # Validate arguments against known Juju API types.
        if storages_ is not None and not isinstance(storages_, (bytes, str, list)):
            raise Exception("Expected storages_ to be a Sequence, received: {}".format(type(storages_)))

        self.storages = storages_
        self.unknown_fields = unknown_fields



class StringBoolResult(Type):
    _toSchema = {'error': 'error', 'ok': 'ok', 'result': 'result'}
    _toPy = {'error': 'error', 'ok': 'ok', 'result': 'result'}
    def __init__(self, error=None, ok=None, result=None, **unknown_fields):
        '''
        error : Error
        ok : bool
        result : str
        '''
        error_ = Error.from_json(error) if error else None
        ok_ = ok
        result_ = result

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if ok_ is not None and not isinstance(ok_, bool):
            raise Exception("Expected ok_ to be a bool, received: {}".format(type(ok_)))

        if result_ is not None and not isinstance(result_, (bytes, str)):
            raise Exception("Expected result_ to be a str, received: {}".format(type(result_)))

        self.error = error_
        self.ok = ok_
        self.result = result_
        self.unknown_fields = unknown_fields



class StringBoolResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StringBoolResult]
        '''
        results_ = [StringBoolResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StringResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : str
        '''
        error_ = Error.from_json(error) if error else None
        result_ = result

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (bytes, str)):
            raise Exception("Expected result_ to be a str, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class StringResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StringResult]
        '''
        results_ = [StringResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StringsResult(Type):
    _toSchema = {'error': 'error', 'result': 'result'}
    _toPy = {'error': 'error', 'result': 'result'}
    def __init__(self, error=None, result=None, **unknown_fields):
        '''
        error : Error
        result : typing.Sequence[str]
        '''
        error_ = Error.from_json(error) if error else None
        result_ = result

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if result_ is not None and not isinstance(result_, (bytes, str, list)):
            raise Exception("Expected result_ to be a Sequence, received: {}".format(type(result_)))

        self.error = error_
        self.result = result_
        self.unknown_fields = unknown_fields



class StringsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StringsResult]
        '''
        results_ = [StringsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class StringsWatchResult(Type):
    _toSchema = {'changes': 'changes', 'error': 'error', 'watcher_id': 'watcher-id'}
    _toPy = {'changes': 'changes', 'error': 'error', 'watcher-id': 'watcher_id'}
    def __init__(self, changes=None, error=None, watcher_id=None, **unknown_fields):
        '''
        changes : typing.Sequence[str]
        error : Error
        watcher_id : str
        '''
        changes_ = changes
        error_ = Error.from_json(error) if error else None
        watcher_id_ = watcher_id

        # Validate arguments against known Juju API types.
        if changes_ is not None and not isinstance(changes_, (bytes, str, list)):
            raise Exception("Expected changes_ to be a Sequence, received: {}".format(type(changes_)))

        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if watcher_id_ is not None and not isinstance(watcher_id_, (bytes, str)):
            raise Exception("Expected watcher_id_ to be a str, received: {}".format(type(watcher_id_)))

        self.changes = changes_
        self.error = error_
        self.watcher_id = watcher_id_
        self.unknown_fields = unknown_fields



class StringsWatchResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~StringsWatchResult]
        '''
        results_ = [StringsWatchResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class Subnet(Type):
    _toSchema = {'cidr': 'cidr', 'life': 'life', 'provider_id': 'provider-id', 'provider_network_id': 'provider-network-id', 'provider_space_id': 'provider-space-id', 'space_tag': 'space-tag', 'status': 'status', 'vlan_tag': 'vlan-tag', 'zones': 'zones'}
    _toPy = {'cidr': 'cidr', 'life': 'life', 'provider-id': 'provider_id', 'provider-network-id': 'provider_network_id', 'provider-space-id': 'provider_space_id', 'space-tag': 'space_tag', 'status': 'status', 'vlan-tag': 'vlan_tag', 'zones': 'zones'}
    def __init__(self, cidr=None, life=None, provider_id=None, provider_network_id=None, provider_space_id=None, space_tag=None, status=None, vlan_tag=None, zones=None, **unknown_fields):
        '''
        cidr : str
        life : str
        provider_id : str
        provider_network_id : str
        provider_space_id : str
        space_tag : str
        status : str
        vlan_tag : int
        zones : typing.Sequence[str]
        '''
        cidr_ = cidr
        life_ = life
        provider_id_ = provider_id
        provider_network_id_ = provider_network_id
        provider_space_id_ = provider_space_id
        space_tag_ = space_tag
        status_ = status
        vlan_tag_ = vlan_tag
        zones_ = zones

        # Validate arguments against known Juju API types.
        if cidr_ is not None and not isinstance(cidr_, (bytes, str)):
            raise Exception("Expected cidr_ to be a str, received: {}".format(type(cidr_)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if provider_network_id_ is not None and not isinstance(provider_network_id_, (bytes, str)):
            raise Exception("Expected provider_network_id_ to be a str, received: {}".format(type(provider_network_id_)))

        if provider_space_id_ is not None and not isinstance(provider_space_id_, (bytes, str)):
            raise Exception("Expected provider_space_id_ to be a str, received: {}".format(type(provider_space_id_)))

        if space_tag_ is not None and not isinstance(space_tag_, (bytes, str)):
            raise Exception("Expected space_tag_ to be a str, received: {}".format(type(space_tag_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if vlan_tag_ is not None and not isinstance(vlan_tag_, int):
            raise Exception("Expected vlan_tag_ to be a int, received: {}".format(type(vlan_tag_)))

        if zones_ is not None and not isinstance(zones_, (bytes, str, list)):
            raise Exception("Expected zones_ to be a Sequence, received: {}".format(type(zones_)))

        self.cidr = cidr_
        self.life = life_
        self.provider_id = provider_id_
        self.provider_network_id = provider_network_id_
        self.provider_space_id = provider_space_id_
        self.space_tag = space_tag_
        self.status = status_
        self.vlan_tag = vlan_tag_
        self.zones = zones_
        self.unknown_fields = unknown_fields



class SubnetV2(Type):
    _toSchema = {'cidr': 'cidr', 'id_': 'id', 'life': 'life', 'provider_id': 'provider-id', 'provider_network_id': 'provider-network-id', 'provider_space_id': 'provider-space-id', 'space_tag': 'space-tag', 'status': 'status', 'subnet': 'Subnet', 'vlan_tag': 'vlan-tag', 'zones': 'zones'}
    _toPy = {'Subnet': 'subnet', 'cidr': 'cidr', 'id': 'id_', 'life': 'life', 'provider-id': 'provider_id', 'provider-network-id': 'provider_network_id', 'provider-space-id': 'provider_space_id', 'space-tag': 'space_tag', 'status': 'status', 'vlan-tag': 'vlan_tag', 'zones': 'zones'}
    def __init__(self, subnet=None, cidr=None, id_=None, life=None, provider_id=None, provider_network_id=None, provider_space_id=None, space_tag=None, status=None, vlan_tag=None, zones=None, **unknown_fields):
        '''
        subnet : Subnet
        cidr : str
        id_ : str
        life : str
        provider_id : str
        provider_network_id : str
        provider_space_id : str
        space_tag : str
        status : str
        vlan_tag : int
        zones : typing.Sequence[str]
        '''
        subnet_ = Subnet.from_json(subnet) if subnet else None
        cidr_ = cidr
        id__ = id_
        life_ = life
        provider_id_ = provider_id
        provider_network_id_ = provider_network_id
        provider_space_id_ = provider_space_id
        space_tag_ = space_tag
        status_ = status
        vlan_tag_ = vlan_tag
        zones_ = zones

        # Validate arguments against known Juju API types.
        if subnet_ is not None and not isinstance(subnet_, (dict, Subnet)):
            raise Exception("Expected subnet_ to be a Subnet, received: {}".format(type(subnet_)))

        if cidr_ is not None and not isinstance(cidr_, (bytes, str)):
            raise Exception("Expected cidr_ to be a str, received: {}".format(type(cidr_)))

        if id__ is not None and not isinstance(id__, (bytes, str)):
            raise Exception("Expected id__ to be a str, received: {}".format(type(id__)))

        if life_ is not None and not isinstance(life_, (bytes, str)):
            raise Exception("Expected life_ to be a str, received: {}".format(type(life_)))

        if provider_id_ is not None and not isinstance(provider_id_, (bytes, str)):
            raise Exception("Expected provider_id_ to be a str, received: {}".format(type(provider_id_)))

        if provider_network_id_ is not None and not isinstance(provider_network_id_, (bytes, str)):
            raise Exception("Expected provider_network_id_ to be a str, received: {}".format(type(provider_network_id_)))

        if provider_space_id_ is not None and not isinstance(provider_space_id_, (bytes, str)):
            raise Exception("Expected provider_space_id_ to be a str, received: {}".format(type(provider_space_id_)))

        if space_tag_ is not None and not isinstance(space_tag_, (bytes, str)):
            raise Exception("Expected space_tag_ to be a str, received: {}".format(type(space_tag_)))

        if status_ is not None and not isinstance(status_, (bytes, str)):
            raise Exception("Expected status_ to be a str, received: {}".format(type(status_)))

        if vlan_tag_ is not None and not isinstance(vlan_tag_, int):
            raise Exception("Expected vlan_tag_ to be a int, received: {}".format(type(vlan_tag_)))

        if zones_ is not None and not isinstance(zones_, (bytes, str, list)):
            raise Exception("Expected zones_ to be a Sequence, received: {}".format(type(zones_)))

        self.subnet = subnet_
        self.cidr = cidr_
        self.id_ = id__
        self.life = life_
        self.provider_id = provider_id_
        self.provider_network_id = provider_network_id_
        self.provider_space_id = provider_space_id_
        self.space_tag = space_tag_
        self.status = status_
        self.vlan_tag = vlan_tag_
        self.zones = zones_
        self.unknown_fields = unknown_fields



class SubnetsFilters(Type):
    _toSchema = {'space_tag': 'space-tag', 'zone': 'zone'}
    _toPy = {'space-tag': 'space_tag', 'zone': 'zone'}
    def __init__(self, space_tag=None, zone=None, **unknown_fields):
        '''
        space_tag : str
        zone : str
        '''
        space_tag_ = space_tag
        zone_ = zone

        # Validate arguments against known Juju API types.
        if space_tag_ is not None and not isinstance(space_tag_, (bytes, str)):
            raise Exception("Expected space_tag_ to be a str, received: {}".format(type(space_tag_)))

        if zone_ is not None and not isinstance(zone_, (bytes, str)):
            raise Exception("Expected zone_ to be a str, received: {}".format(type(zone_)))

        self.space_tag = space_tag_
        self.zone = zone_
        self.unknown_fields = unknown_fields



class SubnetsResult(Type):
    _toSchema = {'error': 'error', 'subnets': 'subnets'}
    _toPy = {'error': 'error', 'subnets': 'subnets'}
    def __init__(self, error=None, subnets=None, **unknown_fields):
        '''
        error : Error
        subnets : typing.Sequence[~SubnetV2]
        '''
        error_ = Error.from_json(error) if error else None
        subnets_ = [SubnetV2.from_json(o) for o in subnets or []]

        # Validate arguments against known Juju API types.
        if error_ is not None and not isinstance(error_, (dict, Error)):
            raise Exception("Expected error_ to be a Error, received: {}".format(type(error_)))

        if subnets_ is not None and not isinstance(subnets_, (bytes, str, list)):
            raise Exception("Expected subnets_ to be a Sequence, received: {}".format(type(subnets_)))

        self.error = error_
        self.subnets = subnets_
        self.unknown_fields = unknown_fields



class SubnetsResults(Type):
    _toSchema = {'results': 'results'}
    _toPy = {'results': 'results'}
    def __init__(self, results=None, **unknown_fields):
        '''
        results : typing.Sequence[~SubnetsResult]
        '''
        results_ = [SubnetsResult.from_json(o) for o in results or []]

        # Validate arguments against known Juju API types.
        if results_ is not None and not isinstance(results_, (bytes, str, list)):
            raise Exception("Expected results_ to be a Sequence, received: {}".format(type(results_)))

        self.results = results_
        self.unknown_fields = unknown_fields



class SummaryWatcherID(Type):
    _toSchema = {'watcher_id': 'watcher-id'}
    _toPy = {'watcher-id': 'watcher_id'}
    def __init__(self, watcher_id=None, **unknown_fields):
        '''
        watcher_id : str
        '''
        watcher_id_ = watcher_id

        # Validate arguments against 