# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client.facade import Type, ReturnMapping
from juju.client._definitions import *


class ApplicationFacade(Type):
    name = 'Application'
    version = 9
    schema =     {'definitions': {'AddApplicationUnits': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'attach-storage': {'items': {'type': 'string'},
                                                                               'type': 'array'},
                                                            'num-units': {'type': 'integer'},
                                                            'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                          'type': 'array'},
                                                            'policy': {'type': 'string'}},
                                             'required': ['application',
                                                          'num-units',
                                                          'placement'],
                                             'type': 'object'},
                     'AddApplicationUnitsResults': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'AddRelation': {'additionalProperties': False,
                                     'properties': {'endpoints': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                    'via-cidrs': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                     'required': ['endpoints'],
                                     'type': 'object'},
                     'AddRelationResults': {'additionalProperties': False,
                                            'properties': {'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                                         'type': 'object'}},
                                            'required': ['endpoints'],
                                            'type': 'object'},
                     'ApplicationCharmRelations': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'ApplicationCharmRelationsResults': {'additionalProperties': False,
                                                          'properties': {'charm-relations': {'items': {'type': 'string'},
                                                                                             'type': 'array'}},
                                                          'required': ['charm-relations'],
                                                          'type': 'object'},
                     'ApplicationConfigSet': {'additionalProperties': False,
                                              'properties': {'application': {'type': 'string'},
                                                             'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                             'generation': {'type': 'string'}},
                                              'required': ['application',
                                                           'generation',
                                                           'config'],
                                              'type': 'object'},
                     'ApplicationConfigSetArgs': {'additionalProperties': False,
                                                  'properties': {'Args': {'items': {'$ref': '#/definitions/ApplicationConfigSet'},
                                                                          'type': 'array'}},
                                                  'required': ['Args'],
                                                  'type': 'object'},
                     'ApplicationConfigUnsetArgs': {'additionalProperties': False,
                                                    'properties': {'Args': {'items': {'$ref': '#/definitions/ApplicationUnset'},
                                                                            'type': 'array'}},
                                                    'required': ['Args'],
                                                    'type': 'object'},
                     'ApplicationConstraint': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                              'error': {'$ref': '#/definitions/Error'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'ApplicationDeploy': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'attach-storage': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                          'channel': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                          'config-yaml': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'devices': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'num-units': {'type': 'integer'},
                                                          'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                        'type': 'array'},
                                                          'policy': {'type': 'string'},
                                                          'resources': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'}},
                                           'required': ['application',
                                                        'series',
                                                        'charm-url',
                                                        'channel',
                                                        'num-units',
                                                        'config-yaml',
                                                        'constraints'],
                                           'type': 'object'},
                     'ApplicationDestroy': {'additionalProperties': False,
                                            'properties': {'application': {'type': 'string'}},
                                            'required': ['application'],
                                            'type': 'object'},
                     'ApplicationExpose': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'}},
                                           'required': ['application'],
                                           'type': 'object'},
                     'ApplicationGet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'branch': {'type': 'string'}},
                                        'required': ['application', 'branch'],
                                        'type': 'object'},
                     'ApplicationGetArgs': {'additionalProperties': False,
                                            'properties': {'args': {'items': {'$ref': '#/definitions/ApplicationGet'},
                                                                    'type': 'array'}},
                                            'required': ['args'],
                                            'type': 'object'},
                     'ApplicationGetConfigResults': {'additionalProperties': False,
                                                     'properties': {'Results': {'items': {'$ref': '#/definitions/ConfigResult'},
                                                                                'type': 'array'}},
                                                     'required': ['Results'],
                                                     'type': 'object'},
                     'ApplicationGetConstraintsResults': {'additionalProperties': False,
                                                          'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationConstraint'},
                                                                                     'type': 'array'}},
                                                          'required': ['results'],
                                                          'type': 'object'},
                     'ApplicationGetResults': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'application-config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                  'type': 'object'}},
                                                                                     'type': 'object'},
                                                              'channel': {'type': 'string'},
                                                              'charm': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'constraints': {'$ref': '#/definitions/Value'},
                                                              'series': {'type': 'string'}},
                                               'required': ['application',
                                                            'charm',
                                                            'config',
                                                            'constraints',
                                                            'series',
                                                            'channel'],
                                               'type': 'object'},
                     'ApplicationInfo': {'additionalProperties': False,
                                         'properties': {'channel': {'type': 'string'},
                                                        'charm': {'type': 'string'},
                                                        'constraints': {'$ref': '#/definitions/Value'},
                                                        'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                              'type': 'object'},
                                                        'exposed': {'type': 'boolean'},
                                                        'principal': {'type': 'boolean'},
                                                        'remote': {'type': 'boolean'},
                                                        'series': {'type': 'string'},
                                                        'tag': {'type': 'string'}},
                                         'required': ['tag',
                                                      'principal',
                                                      'exposed',
                                                      'remote'],
                                         'type': 'object'},
                     'ApplicationInfoResult': {'additionalProperties': False,
                                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                                              'result': {'$ref': '#/definitions/ApplicationInfo'}},
                                               'type': 'object'},
                     'ApplicationInfoResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationInfoResult'},
                                                                           'type': 'array'}},
                                                'required': ['results'],
                                                'type': 'object'},
                     'ApplicationMetricCredential': {'additionalProperties': False,
                                                     'properties': {'application': {'type': 'string'},
                                                                    'metrics-credentials': {'items': {'type': 'integer'},
                                                                                            'type': 'array'}},
                                                     'required': ['application',
                                                                  'metrics-credentials'],
                                                     'type': 'object'},
                     'ApplicationMetricCredentials': {'additionalProperties': False,
                                                      'properties': {'creds': {'items': {'$ref': '#/definitions/ApplicationMetricCredential'},
                                                                               'type': 'array'}},
                                                      'required': ['creds'],
                                                      'type': 'object'},
                     'ApplicationOfferDetails': {'additionalProperties': False,
                                                 'properties': {'application-description': {'type': 'string'},
                                                                'bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                                'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                              'type': 'array'},
                                                                'offer-name': {'type': 'string'},
                                                                'offer-url': {'type': 'string'},
                                                                'offer-uuid': {'type': 'string'},
                                                                'source-model-tag': {'type': 'string'},
                                                                'spaces': {'items': {'$ref': '#/definitions/RemoteSpace'},
                                                                           'type': 'array'},
                                                                'users': {'items': {'$ref': '#/definitions/OfferUserDetails'},
                                                                          'type': 'array'}},
                                                 'required': ['source-model-tag',
                                                              'offer-uuid',
                                                              'offer-url',
                                                              'offer-name',
                                                              'application-description'],
                                                 'type': 'object'},
                     'ApplicationSet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'branch': {'type': 'string'},
                                                       'options': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'}},
                                        'required': ['application',
                                                     'branch',
                                                     'options'],
                                        'type': 'object'},
                     'ApplicationSetCharm': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'channel': {'type': 'string'},
                                                            'charm-url': {'type': 'string'},
                                                            'config-settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                            'config-settings-yaml': {'type': 'string'},
                                                            'force': {'type': 'boolean'},
                                                            'force-series': {'type': 'boolean'},
                                                            'force-units': {'type': 'boolean'},
                                                            'generation': {'type': 'string'},
                                                            'resource-ids': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                            'storage-constraints': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageConstraints'}},
                                                                                    'type': 'object'}},
                                             'required': ['application',
                                                          'generation',
                                                          'charm-url',
                                                          'channel',
                                                          'force',
                                                          'force-units',
                                                          'force-series'],
                                             'type': 'object'},
                     'ApplicationUnexpose': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'}},
                                             'required': ['application'],
                                             'type': 'object'},
                     'ApplicationUnset': {'additionalProperties': False,
                                          'properties': {'application': {'type': 'string'},
                                                         'branch': {'type': 'string'},
                                                         'options': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['application',
                                                       'branch',
                                                       'options'],
                                          'type': 'object'},
                     'ApplicationUpdate': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'force': {'type': 'boolean'},
                                                          'force-charm-url': {'type': 'boolean'},
                                                          'force-series': {'type': 'boolean'},
                                                          'generation': {'type': 'string'},
                                                          'min-units': {'type': 'integer'},
                                                          'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                       'type': 'object'},
                                                          'settings-yaml': {'type': 'string'}},
                                           'required': ['application',
                                                        'charm-url',
                                                        'force-charm-url',
                                                        'force-series',
                                                        'force',
                                                        'settings-yaml',
                                                        'generation'],
                                           'type': 'object'},
                     'ApplicationsDeploy': {'additionalProperties': False,
                                            'properties': {'applications': {'items': {'$ref': '#/definitions/ApplicationDeploy'},
                                                                            'type': 'array'}},
                                            'required': ['applications'],
                                            'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'ConfigResult': {'additionalProperties': False,
                                      'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'}},
                                      'required': ['config'],
                                      'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'ConsumeApplicationArg': {'additionalProperties': False,
                                               'properties': {'ApplicationOfferDetails': {'$ref': '#/definitions/ApplicationOfferDetails'},
                                                              'application-alias': {'type': 'string'},
                                                              'application-description': {'type': 'string'},
                                                              'bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                           'type': 'object'},
                                                              'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                            'type': 'array'},
                                                              'external-controller': {'$ref': '#/definitions/ExternalControllerInfo'},
                                                              'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                              'offer-name': {'type': 'string'},
                                                              'offer-url': {'type': 'string'},
                                                              'offer-uuid': {'type': 'string'},
                                                              'source-model-tag': {'type': 'string'},
                                                              'spaces': {'items': {'$ref': '#/definitions/RemoteSpace'},
                                                                         'type': 'array'},
                                                              'users': {'items': {'$ref': '#/definitions/OfferUserDetails'},
                                                                        'type': 'array'}},
                                               'required': ['source-model-tag',
                                                            'offer-uuid',
                                                            'offer-url',
                                                            'offer-name',
                                                            'application-description',
                                                            'ApplicationOfferDetails'],
                                               'type': 'object'},
                     'ConsumeApplicationArgs': {'additionalProperties': False,
                                                'properties': {'args': {'items': {'$ref': '#/definitions/ConsumeApplicationArg'},
                                                                        'type': 'array'}},
                                                'type': 'object'},
                     'DestroyApplicationInfo': {'additionalProperties': False,
                                                'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                     'type': 'array'},
                                                               'destroyed-units': {'items': {'$ref': '#/definitions/Entity'},
                                                                                   'type': 'array'},
                                                               'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                    'type': 'array'}},
                                                'type': 'object'},
                     'DestroyApplicationParams': {'additionalProperties': False,
                                                  'properties': {'application-tag': {'type': 'string'},
                                                                 'destroy-storage': {'type': 'boolean'},
                                                                 'force': {'type': 'boolean'},
                                                                 'max-wait': {'type': 'integer'}},
                                                  'required': ['application-tag',
                                                               'force'],
                                                  'type': 'object'},
                     'DestroyApplicationResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'info': {'$ref': '#/definitions/DestroyApplicationInfo'}},
                                                  'type': 'object'},
                     'DestroyApplicationResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/DestroyApplicationResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'DestroyApplicationUnits': {'additionalProperties': False,
                                                 'properties': {'unit-names': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                 'required': ['unit-names'],
                                                 'type': 'object'},
                     'DestroyApplicationsParams': {'additionalProperties': False,
                                                   'properties': {'applications': {'items': {'$ref': '#/definitions/DestroyApplicationParams'},
                                                                                   'type': 'array'}},
                                                   'required': ['applications'],
                                                   'type': 'object'},
                     'DestroyConsumedApplicationParams': {'additionalProperties': False,
                                                          'properties': {'application-tag': {'type': 'string'}},
                                                          'required': ['application-tag'],
                                                          'type': 'object'},
                     'DestroyConsumedApplicationsParams': {'additionalProperties': False,
                                                           'properties': {'applications': {'items': {'$ref': '#/definitions/DestroyConsumedApplicationParams'},
                                                                                           'type': 'array'}},
                                                           'required': ['applications'],
                                                           'type': 'object'},
                     'DestroyRelation': {'additionalProperties': False,
                                         'properties': {'endpoints': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                        'force': {'type': 'boolean'},
                                                        'max-wait': {'type': 'integer'},
                                                        'relation-id': {'type': 'integer'}},
                                         'required': ['relation-id'],
                                         'type': 'object'},
                     'DestroyUnitInfo': {'additionalProperties': False,
                                         'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                              'type': 'array'},
                                                        'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                             'type': 'array'}},
                                         'type': 'object'},
                     'DestroyUnitParams': {'additionalProperties': False,
                                           'properties': {'destroy-storage': {'type': 'boolean'},
                                                          'force': {'type': 'boolean'},
                                                          'max-wait': {'type': 'integer'},
                                                          'unit-tag': {'type': 'string'}},
                                           'required': ['unit-tag', 'force'],
                                           'type': 'object'},
                     'DestroyUnitResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'$ref': '#/definitions/DestroyUnitInfo'}},
                                           'type': 'object'},
                     'DestroyUnitResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/DestroyUnitResult'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'DestroyUnitsParams': {'additionalProperties': False,
                                            'properties': {'units': {'items': {'$ref': '#/definitions/DestroyUnitParams'},
                                                                     'type': 'array'}},
                                            'required': ['units'],
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ExternalControllerInfo': {'additionalProperties': False,
                                                'properties': {'addrs': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                               'ca-cert': {'type': 'string'},
                                                               'controller-alias': {'type': 'string'},
                                                               'controller-tag': {'type': 'string'}},
                                                'required': ['controller-tag',
                                                             'controller-alias',
                                                             'addrs',
                                                             'ca-cert'],
                                                'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'OfferUserDetails': {'additionalProperties': False,
                                          'properties': {'access': {'type': 'string'},
                                                         'display-name': {'type': 'string'},
                                                         'user': {'type': 'string'}},
                                          'required': ['user',
                                                       'display-name',
                                                       'access'],
                                          'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'RelationSuspendedArg': {'additionalProperties': False,
                                              'properties': {'message': {'type': 'string'},
                                                             'relation-id': {'type': 'integer'},
                                                             'suspended': {'type': 'boolean'}},
                                              'required': ['relation-id',
                                                           'message',
                                                           'suspended'],
                                              'type': 'object'},
                     'RelationSuspendedArgs': {'additionalProperties': False,
                                               'properties': {'args': {'items': {'$ref': '#/definitions/RelationSuspendedArg'},
                                                                       'type': 'array'}},
                                               'required': ['args'],
                                               'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'RemoteSpace': {'additionalProperties': False,
                                     'properties': {'cloud-type': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'provider-attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                         'type': 'object'}},
                                                                            'type': 'object'},
                                                    'provider-id': {'type': 'string'},
                                                    'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                'type': 'array'}},
                                     'required': ['cloud-type',
                                                  'name',
                                                  'provider-id',
                                                  'provider-attributes',
                                                  'subnets'],
                                     'type': 'object'},
                     'ScaleApplicationInfo': {'additionalProperties': False,
                                              'properties': {'num-units': {'type': 'integer'}},
                                              'required': ['num-units'],
                                              'type': 'object'},
                     'ScaleApplicationParams': {'additionalProperties': False,
                                                'properties': {'application-tag': {'type': 'string'},
                                                               'force': {'type': 'boolean'},
                                                               'scale': {'type': 'integer'},
                                                               'scale-change': {'type': 'integer'}},
                                                'required': ['application-tag',
                                                             'scale',
                                                             'force'],
                                                'type': 'object'},
                     'ScaleApplicationResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'info': {'$ref': '#/definitions/ScaleApplicationInfo'}},
                                                'type': 'object'},
                     'ScaleApplicationResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ScaleApplicationResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'ScaleApplicationsParams': {'additionalProperties': False,
                                                 'properties': {'applications': {'items': {'$ref': '#/definitions/ScaleApplicationParams'},
                                                                                 'type': 'array'}},
                                                 'required': ['applications'],
                                                 'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'UnitsResolved': {'additionalProperties': False,
                                       'properties': {'all': {'type': 'boolean'},
                                                      'retry': {'type': 'boolean'},
                                                      'tags': {'$ref': '#/definitions/Entities'}},
                                       'type': 'object'},
                     'UpdateSeriesArg': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'series': {'type': 'string'},
                                                        'tag': {'$ref': '#/definitions/Entity'}},
                                         'required': ['tag', 'force', 'series'],
                                         'type': 'object'},
                     'UpdateSeriesArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/UpdateSeriesArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'AddRelation': {'properties': {'Params': {'$ref': '#/definitions/AddRelation'},
                                                   'Result': {'$ref': '#/definitions/AddRelationResults'}},
                                    'type': 'object'},
                    'AddUnits': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationUnits'},
                                                'Result': {'$ref': '#/definitions/AddApplicationUnitsResults'}},
                                 'type': 'object'},
                    'ApplicationsInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/ApplicationInfoResults'}},
                                         'type': 'object'},
                    'CharmConfig': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGetArgs'},
                                                   'Result': {'$ref': '#/definitions/ApplicationGetConfigResults'}},
                                    'type': 'object'},
                    'CharmRelations': {'properties': {'Params': {'$ref': '#/definitions/ApplicationCharmRelations'},
                                                      'Result': {'$ref': '#/definitions/ApplicationCharmRelationsResults'}},
                                       'type': 'object'},
                    'Consume': {'properties': {'Params': {'$ref': '#/definitions/ConsumeApplicationArgs'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'Deploy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationsDeploy'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationDestroy'}},
                                'type': 'object'},
                    'DestroyApplication': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationsParams'},
                                                          'Result': {'$ref': '#/definitions/DestroyApplicationResults'}},
                                           'type': 'object'},
                    'DestroyConsumedApplications': {'properties': {'Params': {'$ref': '#/definitions/DestroyConsumedApplicationsParams'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'DestroyRelation': {'properties': {'Params': {'$ref': '#/definitions/DestroyRelation'}},
                                        'type': 'object'},
                    'DestroyUnit': {'properties': {'Params': {'$ref': '#/definitions/DestroyUnitsParams'},
                                                   'Result': {'$ref': '#/definitions/DestroyUnitResults'}},
                                    'type': 'object'},
                    'DestroyUnits': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationUnits'}},
                                     'type': 'object'},
                    'Expose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationExpose'}},
                               'type': 'object'},
                    'Get': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                           'Result': {'$ref': '#/definitions/ApplicationGetResults'}},
                            'type': 'object'},
                    'GetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                                   'Result': {'$ref': '#/definitions/StringResult'}},
                                    'type': 'object'},
                    'GetConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ApplicationGetConfigResults'}},
                                  'type': 'object'},
                    'GetConstraints': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/ApplicationGetConstraintsResults'}},
                                       'type': 'object'},
                    'ResolveUnitErrors': {'properties': {'Params': {'$ref': '#/definitions/UnitsResolved'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'ScaleApplications': {'properties': {'Params': {'$ref': '#/definitions/ScaleApplicationsParams'},
                                                         'Result': {'$ref': '#/definitions/ScaleApplicationResults'}},
                                          'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSet'}},
                            'type': 'object'},
                    'SetApplicationsConfig': {'properties': {'Params': {'$ref': '#/definitions/ApplicationConfigSetArgs'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'SetCharm': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharm'}},
                                 'type': 'object'},
                    'SetConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                       'type': 'object'},
                    'SetMetricCredentials': {'properties': {'Params': {'$ref': '#/definitions/ApplicationMetricCredentials'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'SetRelationsSuspended': {'properties': {'Params': {'$ref': '#/definitions/RelationSuspendedArgs'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'Unexpose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnexpose'}},
                                 'type': 'object'},
                    'Unset': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnset'}},
                              'type': 'object'},
                    'UnsetApplicationsConfig': {'properties': {'Params': {'$ref': '#/definitions/ApplicationConfigUnsetArgs'},
                                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                'type': 'object'},
                    'Update': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUpdate'}},
                               'type': 'object'},
                    'UpdateApplicationSeries': {'properties': {'Params': {'$ref': '#/definitions/UpdateSeriesArgs'},
                                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddRelationResults)
    async def AddRelation(self, endpoints=None, via_cidrs=None):
        '''
        endpoints : typing.Sequence[str]
        via_cidrs : typing.Sequence[str]
        Returns -> AddRelationResults
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        if via_cidrs is not None and not isinstance(via_cidrs, (bytes, str, list)):
            raise Exception("Expected via_cidrs to be a Sequence, received: {}".format(type(via_cidrs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddRelation',
                   version=9,
                   params=_params)
        _params['endpoints'] = endpoints
        _params['via-cidrs'] = via_cidrs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddApplicationUnitsResults)
    async def AddUnits(self, application=None, attach_storage=None, num_units=None, placement=None, policy=None):
        '''
        application : str
        attach_storage : typing.Sequence[str]
        num_units : int
        placement : typing.Sequence[~Placement]
        policy : str
        Returns -> AddApplicationUnitsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if attach_storage is not None and not isinstance(attach_storage, (bytes, str, list)):
            raise Exception("Expected attach_storage to be a Sequence, received: {}".format(type(attach_storage)))

        if num_units is not None and not isinstance(num_units, int):
            raise Exception("Expected num_units to be a int, received: {}".format(type(num_units)))

        if placement is not None and not isinstance(placement, (bytes, str, list)):
            raise Exception("Expected placement to be a Sequence, received: {}".format(type(placement)))

        if policy is not None and not isinstance(policy, (bytes, str)):
            raise Exception("Expected policy to be a str, received: {}".format(type(policy)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddUnits',
                   version=9,
                   params=_params)
        _params['application'] = application
        _params['attach-storage'] = attach_storage
        _params['num-units'] = num_units
        _params['placement'] = placement
        _params['policy'] = policy
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationInfoResults)
    async def ApplicationsInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='ApplicationsInfo',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetConfigResults)
    async def CharmConfig(self, args=None):
        '''
        args : typing.Sequence[~ApplicationGet]
        Returns -> ApplicationGetConfigResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmConfig',
                   version=9,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmRelationsResults)
    async def CharmRelations(self, application=None):
        '''
        application : str
        Returns -> ApplicationCharmRelationsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmRelations',
                   version=9,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Consume(self, args=None):
        '''
        args : typing.Sequence[~ConsumeApplicationArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Consume',
                   version=9,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Deploy(self, applications=None):
        '''
        applications : typing.Sequence[~ApplicationDeploy]
        Returns -> ErrorResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Deploy',
                   version=9,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Destroy(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Destroy',
                   version=9,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyApplicationResults)
    async def DestroyApplication(self, applications=None):
        '''
        applications : typing.Sequence[~DestroyApplicationParams]
        Returns -> DestroyApplicationResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyApplication',
                   version=9,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyConsumedApplications(self, applications=None):
        '''
        applications : typing.Sequence[~DestroyConsumedApplicationParams]
        Returns -> ErrorResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyConsumedApplications',
                   version=9,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyRelation(self, endpoints=None, force=None, max_wait=None, relation_id=None):
        '''
        endpoints : typing.Sequence[str]
        force : bool
        max_wait : int
        relation_id : int
        Returns -> None
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if max_wait is not None and not isinstance(max_wait, int):
            raise Exception("Expected max_wait to be a int, received: {}".format(type(max_wait)))

        if relation_id is not None and not isinstance(relation_id, int):
            raise Exception("Expected relation_id to be a int, received: {}".format(type(relation_id)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyRelation',
                   version=9,
                   params=_params)
        _params['endpoints'] = endpoints
        _params['force'] = force
        _params['max-wait'] = max_wait
        _params['relation-id'] = relation_id
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyUnitResults)
    async def DestroyUnit(self, units=None):
        '''
        units : typing.Sequence[~DestroyUnitParams]
        Returns -> DestroyUnitResults
        '''
        if units is not None and not isinstance(units, (bytes, str, list)):
            raise Exception("Expected units to be a Sequence, received: {}".format(type(units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnit',
                   version=9,
                   params=_params)
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyUnits(self, unit_names=None):
        '''
        unit_names : typing.Sequence[str]
        Returns -> None
        '''
        if unit_names is not None and not isinstance(unit_names, (bytes, str, list)):
            raise Exception("Expected unit_names to be a Sequence, received: {}".format(type(unit_names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnits',
                   version=9,
                   params=_params)
        _params['unit-names'] = unit_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Expose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Expose',
                   version=9,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetResults)
    async def Get(self, application=None, branch=None):
        '''
        application : str
        branch : str
        Returns -> ApplicationGetResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Get',
                   version=9,
                   params=_params)
        _params['application'] = application
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def GetCharmURL(self, application=None, branch=None):
        '''
        application : str
        branch : str
        Returns -> StringResult
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetCharmURL',
                   version=9,
                   params=_params)
        _params['application'] = application
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetConfigResults)
    async def GetConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationGetConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConfig',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetConstraintsResults)
    async def GetConstraints(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationGetConstraintsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConstraints',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ResolveUnitErrors(self, all_=None, retry=None, tags=None):
        '''
        all_ : bool
        retry : bool
        tags : Entities
        Returns -> ErrorResults
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        if retry is not None and not isinstance(retry, bool):
            raise Exception("Expected retry to be a bool, received: {}".format(type(retry)))

        if tags is not None and not isinstance(tags, (dict, Entities)):
            raise Exception("Expected tags to be a Entities, received: {}".format(type(tags)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='ResolveUnitErrors',
                   version=9,
                   params=_params)
        _params['all'] = all_
        _params['retry'] = retry
        _params['tags'] = tags
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ScaleApplicationResults)
    async def ScaleApplications(self, applications=None):
        '''
        applications : typing.Sequence[~ScaleApplicationParams]
        Returns -> ScaleApplicationResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='ScaleApplications',
                   version=9,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Set(self, application=None, branch=None, options=None):
        '''
        application : str
        branch : str
        options : typing.Mapping[str, str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        if options is not None and not isinstance(options, dict):
            raise Exception("Expected options to be a Mapping, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Set',
                   version=9,
                   params=_params)
        _params['application'] = application
        _params['branch'] = branch
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetApplicationsConfig(self, args=None):
        '''
        args : typing.Sequence[~ApplicationConfigSet]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetApplicationsConfig',
                   version=9,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharm(self, application=None, channel=None, charm_url=None, config_settings=None, config_settings_yaml=None, force=None, force_series=None, force_units=None, generation=None, resource_ids=None, storage_constraints=None):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping[str, str]
        config_settings_yaml : str
        force : bool
        force_series : bool
        force_units : bool
        generation : str
        resource_ids : typing.Mapping[str, str]
        storage_constraints : typing.Mapping[str, ~StorageConstraints]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if config_settings is not None and not isinstance(config_settings, dict):
            raise Exception("Expected config_settings to be a Mapping, received: {}".format(type(config_settings)))

        if config_settings_yaml is not None and not isinstance(config_settings_yaml, (bytes, str)):
            raise Exception("Expected config_settings_yaml to be a str, received: {}".format(type(config_settings_yaml)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if force_units is not None and not isinstance(force_units, bool):
            raise Exception("Expected force_units to be a bool, received: {}".format(type(force_units)))

        if generation is not None and not isinstance(generation, (bytes, str)):
            raise Exception("Expected generation to be a str, received: {}".format(type(generation)))

        if resource_ids is not None and not isinstance(resource_ids, dict):
            raise Exception("Expected resource_ids to be a Mapping, received: {}".format(type(resource_ids)))

        if storage_constraints is not None and not isinstance(storage_constraints, dict):
            raise Exception("Expected storage_constraints to be a Mapping, received: {}".format(type(storage_constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetCharm',
                   version=9,
                   params=_params)
        _params['application'] = application
        _params['channel'] = channel
        _params['charm-url'] = charm_url
        _params['config-settings'] = config_settings
        _params['config-settings-yaml'] = config_settings_yaml
        _params['force'] = force
        _params['force-series'] = force_series
        _params['force-units'] = force_units
        _params['generation'] = generation
        _params['resource-ids'] = resource_ids
        _params['storage-constraints'] = storage_constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetConstraints(self, application=None, constraints=None):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetConstraints',
                   version=9,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMetricCredentials(self, creds=None):
        '''
        creds : typing.Sequence[~ApplicationMetricCredential]
        Returns -> ErrorResults
        '''
        if creds is not None and not isinstance(creds, (bytes, str, list)):
            raise Exception("Expected creds to be a Sequence, received: {}".format(type(creds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetMetricCredentials',
                   version=9,
                   params=_params)
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetRelationsSuspended(self, args=None):
        '''
        args : typing.Sequence[~RelationSuspendedArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetRelationsSuspended',
                   version=9,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unexpose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unexpose',
                   version=9,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unset(self, application=None, branch=None, options=None):
        '''
        application : str
        branch : str
        options : typing.Sequence[str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        if options is not None and not isinstance(options, (bytes, str, list)):
            raise Exception("Expected options to be a Sequence, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unset',
                   version=9,
                   params=_params)
        _params['application'] = application
        _params['branch'] = branch
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UnsetApplicationsConfig(self, args=None):
        '''
        args : typing.Sequence[~ApplicationUnset]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='UnsetApplicationsConfig',
                   version=9,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Update(self, application=None, charm_url=None, constraints=None, force=None, force_charm_url=None, force_series=None, generation=None, min_units=None, settings=None, settings_yaml=None):
        '''
        application : str
        charm_url : str
        constraints : Value
        force : bool
        force_charm_url : bool
        force_series : bool
        generation : str
        min_units : int
        settings : typing.Mapping[str, str]
        settings_yaml : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if force_charm_url is not None and not isinstance(force_charm_url, bool):
            raise Exception("Expected force_charm_url to be a bool, received: {}".format(type(force_charm_url)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if generation is not None and not isinstance(generation, (bytes, str)):
            raise Exception("Expected generation to be a str, received: {}".format(type(generation)))

        if min_units is not None and not isinstance(min_units, int):
            raise Exception("Expected min_units to be a int, received: {}".format(type(min_units)))

        if settings is not None and not isinstance(settings, dict):
            raise Exception("Expected settings to be a Mapping, received: {}".format(type(settings)))

        if settings_yaml is not None and not isinstance(settings_yaml, (bytes, str)):
            raise Exception("Expected settings_yaml to be a str, received: {}".format(type(settings_yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Update',
                   version=9,
                   params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        _params['constraints'] = constraints
        _params['force'] = force
        _params['force-charm-url'] = force_charm_url
        _params['force-series'] = force_series
        _params['generation'] = generation
        _params['min-units'] = min_units
        _params['settings'] = settings
        _params['settings-yaml'] = settings_yaml
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateApplicationSeries(self, args=None):
        '''
        args : typing.Sequence[~UpdateSeriesArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='UpdateApplicationSeries',
                   version=9,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



class ControllerFacade(Type):
    name = 'Controller'
    version = 9
    schema =     {'definitions': {'AllWatcherId': {'additionalProperties': False,
                                      'properties': {'watcher-id': {'type': 'string'}},
                                      'required': ['watcher-id'],
                                      'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'cacertificates': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                  'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'CloudSpecResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudSpecResult'},
                                                                     'type': 'array'}},
                                          'type': 'object'},
                     'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'ControllerConfigSet': {'additionalProperties': False,
                                             'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                    'type': 'object'}},
                                                                       'type': 'object'}},
                                             'required': ['config'],
                                             'type': 'object'},
                     'ControllerVersionResults': {'additionalProperties': False,
                                                  'properties': {'git-commit': {'type': 'string'},
                                                                 'version': {'type': 'string'}},
                                                  'required': ['version',
                                                               'git-commit'],
                                                  'type': 'object'},
                     'DestroyControllerArgs': {'additionalProperties': False,
                                               'properties': {'destroy-models': {'type': 'boolean'},
                                                              'destroy-storage': {'type': 'boolean'}},
                                               'required': ['destroy-models'],
                                               'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostedModelConfig': {'additionalProperties': False,
                                           'properties': {'cloud-spec': {'$ref': '#/definitions/CloudSpec'},
                                                          'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'name': {'type': 'string'},
                                                          'owner': {'type': 'string'}},
                                           'required': ['name', 'owner'],
                                           'type': 'object'},
                     'HostedModelConfigsResults': {'additionalProperties': False,
                                                   'properties': {'models': {'items': {'$ref': '#/definitions/HostedModelConfig'},
                                                                             'type': 'array'}},
                                                   'required': ['models'],
                                                   'type': 'object'},
                     'InitiateMigrationArgs': {'additionalProperties': False,
                                               'properties': {'specs': {'items': {'$ref': '#/definitions/MigrationSpec'},
                                                                        'type': 'array'}},
                                               'required': ['specs'],
                                               'type': 'object'},
                     'InitiateMigrationResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'migration-id': {'type': 'string'},
                                                                'model-tag': {'type': 'string'}},
                                                 'required': ['model-tag',
                                                              'migration-id'],
                                                 'type': 'object'},
                     'InitiateMigrationResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/InitiateMigrationResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MigrationSpec': {'additionalProperties': False,
                                       'properties': {'model-tag': {'type': 'string'},
                                                      'target-info': {'$ref': '#/definitions/MigrationTargetInfo'}},
                                       'required': ['model-tag', 'target-info'],
                                       'type': 'object'},
                     'MigrationTargetInfo': {'additionalProperties': False,
                                             'properties': {'addrs': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                            'auth-tag': {'type': 'string'},
                                                            'ca-cert': {'type': 'string'},
                                                            'controller-alias': {'type': 'string'},
                                                            'controller-tag': {'type': 'string'},
                                                            'macaroons': {'type': 'string'},
                                                            'password': {'type': 'string'}},
                                             'required': ['controller-tag',
                                                          'addrs',
                                                          'ca-cert',
                                                          'auth-tag'],
                                             'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'type': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'type', 'owner-tag'],
                               'type': 'object'},
                     'ModelBlockInfo': {'additionalProperties': False,
                                        'properties': {'blocks': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                       'model-uuid': {'type': 'string'},
                                                       'name': {'type': 'string'},
                                                       'owner-tag': {'type': 'string'}},
                                        'required': ['name',
                                                     'model-uuid',
                                                     'owner-tag',
                                                     'blocks'],
                                        'type': 'object'},
                     'ModelBlockInfoList': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelBlockInfo'},
                                                                      'type': 'array'}},
                                            'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelFilesystemInfo': {'additionalProperties': False,
                                             'properties': {'detachable': {'type': 'boolean'},
                                                            'id': {'type': 'string'},
                                                            'message': {'type': 'string'},
                                                            'provider-id': {'type': 'string'},
                                                            'status': {'type': 'string'}},
                                             'required': ['id'],
                                             'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'display-name': {'type': 'string'},
                                                         'ha-primary': {'type': 'boolean'},
                                                         'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'message': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'filesystems': {'items': {'$ref': '#/definitions/ModelFilesystemInfo'},
                                                                    'type': 'array'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'},
                                                    'type': {'type': 'string'},
                                                    'unit-count': {'type': 'integer'},
                                                    'volumes': {'items': {'$ref': '#/definitions/ModelVolumeInfo'},
                                                                'type': 'array'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'type',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'unit-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelTag': {'additionalProperties': False, 'type': 'object'},
                     'ModelVolumeInfo': {'additionalProperties': False,
                                         'properties': {'detachable': {'type': 'boolean'},
                                                        'id': {'type': 'string'},
                                                        'message': {'type': 'string'},
                                                        'provider-id': {'type': 'string'},
                                                        'status': {'type': 'string'}},
                                         'required': ['id'],
                                         'type': 'object'},
                     'ModifyControllerAccess': {'additionalProperties': False,
                                                'properties': {'access': {'type': 'string'},
                                                               'action': {'type': 'string'},
                                                               'user-tag': {'type': 'string'}},
                                                'required': ['user-tag',
                                                             'action',
                                                             'access'],
                                                'type': 'object'},
                     'ModifyControllerAccessRequest': {'additionalProperties': False,
                                                       'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyControllerAccess'},
                                                                                  'type': 'array'}},
                                                       'required': ['changes'],
                                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'RemoveBlocksArgs': {'additionalProperties': False,
                                          'properties': {'all': {'type': 'boolean'}},
                                          'required': ['all'],
                                          'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'SummaryWatcherID': {'additionalProperties': False,
                                          'properties': {'watcher-id': {'type': 'string'}},
                                          'required': ['watcher-id'],
                                          'type': 'object'},
                     'UserAccess': {'additionalProperties': False,
                                    'properties': {'access': {'type': 'string'},
                                                   'user-tag': {'type': 'string'}},
                                    'required': ['user-tag', 'access'],
                                    'type': 'object'},
                     'UserAccessResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/UserAccess'}},
                                          'type': 'object'},
                     'UserAccessResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/UserAccessResult'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'AllModels': {'description': 'AllModels allows controller '
                                                 'administrators to get the list '
                                                 'of all the\n'
                                                 'models in the controller.',
                                  'properties': {'Result': {'$ref': '#/definitions/UserModelList'}},
                                  'type': 'object'},
                    'CloudSpec': {'description': "CloudSpec returns the model's "
                                                 'cloud spec.',
                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudSpecResults'}},
                                  'type': 'object'},
                    'ConfigSet': {'description': 'ConfigSet changes the value of '
                                                 'specified controller '
                                                 'configuration\n'
                                                 'settings. Only some settings can '
                                                 'be changed after bootstrap.\n'
                                                 "Settings that aren't specified "
                                                 'in the params are left '
                                                 'unchanged.',
                                  'properties': {'Params': {'$ref': '#/definitions/ControllerConfigSet'}},
                                  'type': 'object'},
                    'ControllerAPIInfoForModels': {'description': 'ControllerAPIInfoForModels '
                                                                  'returns the '
                                                                  'controller api '
                                                                  'connection '
                                                                  'details for the '
                                                                  'specified '
                                                                  'models.',
                                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'description': 'ControllerConfig returns '
                                                        "the controller's "
                                                        'configuration.',
                                         'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'ControllerVersion': {'description': 'ControllerVersion '
                                                         'returns the version '
                                                         'information associated '
                                                         'with this\n'
                                                         'controller binary.\n'
                                                         '\n'
                                                         'NOTE: the implementation '
                                                         'intentionally does not '
                                                         'check for '
                                                         'SuperuserAccess\n'
                                                         'as the Version is known '
                                                         'even to users with login '
                                                         'access.',
                                          'properties': {'Result': {'$ref': '#/definitions/ControllerVersionResults'}},
                                          'type': 'object'},
                    'DestroyController': {'description': 'DestroyController '
                                                         'destroys the '
                                                         'controller.\n'
                                                         '\n'
                                                         'If the args specify the '
                                                         'destruction of the '
                                                         'models, this method '
                                                         'will\n'
                                                         'attempt to do so. '
                                                         'Otherwise, if the '
                                                         'controller has any '
                                                         'non-empty,\n'
                                                         'non-Dead hosted models, '
                                                         'then an error with the '
                                                         'code\n'
                                                         'params.CodeHasHostedModels '
                                                         'will be transmitted.',
                                          'properties': {'Params': {'$ref': '#/definitions/DestroyControllerArgs'}},
                                          'type': 'object'},
                    'GetCloudSpec': {'description': 'GetCloudSpec constructs the '
                                                    'CloudSpec for a validated and '
                                                    'authorized model.',
                                     'properties': {'Params': {'$ref': '#/definitions/ModelTag'},
                                                    'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                     'type': 'object'},
                    'GetControllerAccess': {'description': 'GetControllerAccess '
                                                           'returns the level of '
                                                           'access the specified '
                                                           'users\n'
                                                           'have on the '
                                                           'controller.',
                                            'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/UserAccessResults'}},
                                            'type': 'object'},
                    'HostedModelConfigs': {'description': 'HostedModelConfigs '
                                                          'returns all the '
                                                          'information that the '
                                                          'client needs in\n'
                                                          'order to connect '
                                                          'directly with the host '
                                                          "model's provider and "
                                                          'destroy it\n'
                                                          'directly.',
                                           'properties': {'Result': {'$ref': '#/definitions/HostedModelConfigsResults'}},
                                           'type': 'object'},
                    'IdentityProviderURL': {'description': 'IdentityProviderURL '
                                                           'returns the URL of the '
                                                           'configured external '
                                                           'identity\n'
                                                           'provider for this '
                                                           'controller or an empty '
                                                           'string if no external '
                                                           'identity\n'
                                                           'provider has been '
                                                           'configured when the '
                                                           'controller was '
                                                           'bootstrapped.\n'
                                                           '\n'
                                                           'NOTE: the '
                                                           'implementation '
                                                           'intentionally does not '
                                                           'check for '
                                                           'SuperuserAccess\n'
                                                           'as the URL is known '
                                                           'even to users with '
                                                           'login access.',
                                            'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                            'type': 'object'},
                    'InitiateMigration': {'description': 'InitiateMigration '
                                                         'attempts to begin the '
                                                         'migration of one or\n'
                                                         'more models to other '
                                                         'controllers.',
                                          'properties': {'Params': {'$ref': '#/definitions/InitiateMigrationArgs'},
                                                         'Result': {'$ref': '#/definitions/InitiateMigrationResults'}},
                                          'type': 'object'},
                    'ListBlockedModels': {'description': 'ListBlockedModels '
                                                         'returns a list of all '
                                                         'models on the '
                                                         'controller\n'
                                                         'which have a block in '
                                                         'place.  The resulting '
                                                         'slice is sorted by '
                                                         'model\n'
                                                         'name, then owner. '
                                                         'Callers must be '
                                                         'controller '
                                                         'administrators to '
                                                         'retrieve the\n'
                                                         'list.',
                                          'properties': {'Result': {'$ref': '#/definitions/ModelBlockInfoList'}},
                                          'type': 'object'},
                    'ModelConfig': {'description': 'ModelConfig returns the model '
                                                   'config for the controller\n'
                                                   'model.  For information on the '
                                                   'current model, use\n'
                                                   'client.ModelGet',
                                    'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                    'type': 'object'},
                    'ModelStatus': {'description': 'ModelStatus returns a summary '
                                                   'of the model.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyControllerAccess': {'description': 'ModifyControllerAccess '
                                                              'changes the model '
                                                              'access granted to '
                                                              'users.',
                                               'properties': {'Params': {'$ref': '#/definitions/ModifyControllerAccessRequest'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'MongoVersion': {'description': 'MongoVersion allows the '
                                                    'introspection of the mongo '
                                                    'version per controller',
                                     'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'RemoveBlocks': {'description': 'RemoveBlocks removes all the '
                                                    'blocks in the controller.',
                                     'properties': {'Params': {'$ref': '#/definitions/RemoveBlocksArgs'}},
                                     'type': 'object'},
                    'WatchAllModelSummaries': {'description': 'WatchAllModelSummaries '
                                                              'starts watching the '
                                                              'summary updates '
                                                              'from the cache.\n'
                                                              'This method is '
                                                              'superuser access '
                                                              'only, and watches '
                                                              'all models in the\n'
                                                              'controller.',
                                               'properties': {'Result': {'$ref': '#/definitions/SummaryWatcherID'}},
                                               'type': 'object'},
                    'WatchAllModels': {'description': 'WatchAllModels starts '
                                                      'watching events for all '
                                                      'models in the\n'
                                                      'controller. The returned '
                                                      'AllWatcherId should be used '
                                                      'with Next on the\n'
                                                      'AllModelWatcher endpoint to '
                                                      'receive deltas.',
                                       'properties': {'Result': {'$ref': '#/definitions/AllWatcherId'}},
                                       'type': 'object'},
                    'WatchCloudSpecsChanges': {'description': 'WatchCloudSpecsChanges '
                                                              'returns a watcher '
                                                              'for cloud spec '
                                                              'changes.',
                                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                               'type': 'object'},
                    'WatchModelSummaries': {'description': 'WatchModelSummaries '
                                                           'starts watching the '
                                                           'summary updates from '
                                                           'the cache.\n'
                                                           'Only models that the '
                                                           'user has access to are '
                                                           'returned.',
                                            'properties': {'Result': {'$ref': '#/definitions/SummaryWatcherID'}},
                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(UserModelList)
    async def AllModels(self):
        '''
        AllModels allows controller administrators to get the list of all the
        models in the controller.


        Returns -> UserModelList
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='AllModels',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResults)
    async def CloudSpec(self, entities=None):
        '''
        CloudSpec returns the model's cloud spec.

        entities : typing.Sequence[~Entity]
        Returns -> CloudSpecResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='CloudSpec',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ConfigSet(self, config=None):
        '''
        ConfigSet changes the value of specified controller configuration
        settings. Only some settings can be changed after bootstrap.
        Settings that aren't specified in the params are left unchanged.

        config : typing.Mapping[str, typing.Any]
        Returns -> None
        '''
        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ConfigSet',
                   version=9,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        ControllerAPIInfoForModels returns the controller api connection details for the specified models.

        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ControllerAPIInfoForModels',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''
        ControllerConfig returns the controller's configuration.


        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ControllerConfig',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerVersionResults)
    async def ControllerVersion(self):
        '''
        ControllerVersion returns the version information associated with this
        controller binary.

        NOTE: the implementation intentionally does not check for SuperuserAccess
        as the Version is known even to users with login access.


        Returns -> ControllerVersionResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ControllerVersion',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyController(self, destroy_models=None, destroy_storage=None):
        '''
        DestroyController destroys the controller.

        If the args specify the destruction of the models, this method will
        attempt to do so. Otherwise, if the controller has any non-empty,
        non-Dead hosted models, then an error with the code
        params.CodeHasHostedModels will be transmitted.

        destroy_models : bool
        destroy_storage : bool
        Returns -> None
        '''
        if destroy_models is not None and not isinstance(destroy_models, bool):
            raise Exception("Expected destroy_models to be a bool, received: {}".format(type(destroy_models)))

        if destroy_storage is not None and not isinstance(destroy_storage, bool):
            raise Exception("Expected destroy_storage to be a bool, received: {}".format(type(destroy_storage)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='DestroyController',
                   version=9,
                   params=_params)
        _params['destroy-models'] = destroy_models
        _params['destroy-storage'] = destroy_storage
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def GetCloudSpec(self):
        '''
        GetCloudSpec constructs the CloudSpec for a validated and authorized model.


        Returns -> CloudSpecResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='GetCloudSpec',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserAccessResults)
    async def GetControllerAccess(self, entities=None):
        '''
        GetControllerAccess returns the level of access the specified users
        have on the controller.

        entities : typing.Sequence[~Entity]
        Returns -> UserAccessResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='GetControllerAccess',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(HostedModelConfigsResults)
    async def HostedModelConfigs(self):
        '''
        HostedModelConfigs returns all the information that the client needs in
        order to connect directly with the host model's provider and destroy it
        directly.


        Returns -> HostedModelConfigsResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='HostedModelConfigs',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def IdentityProviderURL(self):
        '''
        IdentityProviderURL returns the URL of the configured external identity
        provider for this controller or an empty string if no external identity
        provider has been configured when the controller was bootstrapped.

        NOTE: the implementation intentionally does not check for SuperuserAccess
        as the URL is known even to users with login access.


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='IdentityProviderURL',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InitiateMigrationResults)
    async def InitiateMigration(self, specs=None):
        '''
        InitiateMigration attempts to begin the migration of one or
        more models to other controllers.

        specs : typing.Sequence[~MigrationSpec]
        Returns -> InitiateMigrationResults
        '''
        if specs is not None and not isinstance(specs, (bytes, str, list)):
            raise Exception("Expected specs to be a Sequence, received: {}".format(type(specs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='InitiateMigration',
                   version=9,
                   params=_params)
        _params['specs'] = specs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelBlockInfoList)
    async def ListBlockedModels(self):
        '''
        ListBlockedModels returns a list of all models on the controller
        which have a block in place.  The resulting slice is sorted by model
        name, then owner. Callers must be controller administrators to retrieve the
        list.


        Returns -> ModelBlockInfoList
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ListBlockedModels',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResults)
    async def ModelConfig(self):
        '''
        ModelConfig returns the model config for the controller
        model.  For information on the current model, use
        client.ModelGet


        Returns -> ModelConfigResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModelConfig',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities=None):
        '''
        ModelStatus returns a summary of the model.

        entities : typing.Sequence[~Entity]
        Returns -> ModelStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModelStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyControllerAccess(self, changes=None):
        '''
        ModifyControllerAccess changes the model access granted to users.

        changes : typing.Sequence[~ModifyControllerAccess]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModifyControllerAccess',
                   version=9,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def MongoVersion(self):
        '''
        MongoVersion allows the introspection of the mongo version per controller


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='MongoVersion',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def RemoveBlocks(self, all_=None):
        '''
        RemoveBlocks removes all the blocks in the controller.

        all_ : bool
        Returns -> None
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='RemoveBlocks',
                   version=9,
                   params=_params)
        _params['all'] = all_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SummaryWatcherID)
    async def WatchAllModelSummaries(self):
        '''
        WatchAllModelSummaries starts watching the summary updates from the cache.
        This method is superuser access only, and watches all models in the
        controller.


        Returns -> SummaryWatcherID
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='WatchAllModelSummaries',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AllWatcherId)
    async def WatchAllModels(self):
        '''
        WatchAllModels starts watching events for all models in the
        controller. The returned AllWatcherId should be used with Next on the
        AllModelWatcher endpoint to receive deltas.


        Returns -> AllWatcherId
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='WatchAllModels',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchCloudSpecsChanges(self, entities=None):
        '''
        WatchCloudSpecsChanges returns a watcher for cloud spec changes.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='WatchCloudSpecsChanges',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SummaryWatcherID)
    async def WatchModelSummaries(self):
        '''
        WatchModelSummaries starts watching the summary updates from the cache.
        Only models that the user has access to are returned.


        Returns -> SummaryWatcherID
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='WatchModelSummaries',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ProvisionerFacade(Type):
    name = 'Provisioner'
    version = 9
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Patch': {'type': 'integer'},
                                               'Series': {'type': 'string'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build',
                                             'Number',
                                             'Series',
                                             'Arch'],
                                'type': 'object'},
                     'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'CharmLXDProfile': {'additionalProperties': False,
                                         'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'},
                                                        'description': {'type': 'string'},
                                                        'devices': {'patternProperties': {'.*': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'}},
                                         'required': ['config',
                                                      'description',
                                                      'devices'],
                                         'type': 'object'},
                     'CloudImageMetadata': {'additionalProperties': False,
                                            'properties': {'arch': {'type': 'string'},
                                                           'image-id': {'type': 'string'},
                                                           'priority': {'type': 'integer'},
                                                           'region': {'type': 'string'},
                                                           'root-storage-size': {'type': 'integer'},
                                                           'root-storage-type': {'type': 'string'},
                                                           'series': {'type': 'string'},
                                                           'source': {'type': 'string'},
                                                           'stream': {'type': 'string'},
                                                           'version': {'type': 'string'},
                                                           'virt-type': {'type': 'string'}},
                                            'required': ['image-id',
                                                         'region',
                                                         'version',
                                                         'series',
                                                         'arch',
                                                         'source',
                                                         'priority'],
                                            'type': 'object'},
                     'ConstraintsResult': {'additionalProperties': False,
                                           'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['constraints'],
                                           'type': 'object'},
                     'ConstraintsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/ConstraintsResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ContainerConfig': {'additionalProperties': False,
                                         'properties': {'UpdateBehavior': {'$ref': '#/definitions/UpdateBehavior'},
                                                        'apt-mirror': {'type': 'string'},
                                                        'apt-proxy': {'$ref': '#/definitions/Settings'},
                                                        'authorized-keys': {'type': 'string'},
                                                        'cloudinit-userdata': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                            'type': 'object'}},
                                                                               'type': 'object'},
                                                        'container-inherit-properties': {'type': 'string'},
                                                        'juju-proxy': {'$ref': '#/definitions/Settings'},
                                                        'legacy-proxy': {'$ref': '#/definitions/Settings'},
                                                        'provider-type': {'type': 'string'},
                                                        'snap-proxy': {'$ref': '#/definitions/Settings'},
                                                        'snap-store-assertions': {'type': 'string'},
                                                        'snap-store-proxy-id': {'type': 'string'},
                                                        'snap-store-proxy-url': {'type': 'string'},
                                                        'ssl-hostname-verification': {'type': 'boolean'}},
                                         'required': ['provider-type',
                                                      'authorized-keys',
                                                      'ssl-hostname-verification',
                                                      'legacy-proxy',
                                                      'juju-proxy',
                                                      'apt-proxy',
                                                      'snap-proxy',
                                                      'snap-store-assertions',
                                                      'snap-store-proxy-id',
                                                      'snap-store-proxy-url',
                                                      'apt-mirror',
                                                      'UpdateBehavior'],
                                         'type': 'object'},
                     'ContainerLXDProfile': {'additionalProperties': False,
                                             'properties': {'name': {'type': 'string'},
                                                            'profile': {'$ref': '#/definitions/CharmLXDProfile'}},
                                             'required': ['profile', 'name'],
                                             'type': 'object'},
                     'ContainerManagerConfig': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'ContainerManagerConfigParams': {'additionalProperties': False,
                                                      'properties': {'type': {'type': 'string'}},
                                                      'required': ['type'],
                                                      'type': 'object'},
                     'ContainerProfileResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'lxd-profiles': {'items': {'$ref': '#/definitions/ContainerLXDProfile'},
                                                                                'type': 'array'}},
                                                'type': 'object'},
                     'ContainerProfileResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ContainerProfileResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'DeviceBridgeInfo': {'additionalProperties': False,
                                          'properties': {'bridge-name': {'type': 'string'},
                                                         'host-device-name': {'type': 'string'},
                                                         'mac-address': {'type': 'string'}},
                                          'required': ['host-device-name',
                                                       'bridge-name',
                                                       'mac-address'],
                                          'type': 'object'},
                     'DistributionGroupResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'DistributionGroupResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/DistributionGroupResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FindToolsParams': {'additionalProperties': False,
                                         'properties': {'agentstream': {'type': 'string'},
                                                        'arch': {'type': 'string'},
                                                        'major': {'type': 'integer'},
                                                        'minor': {'type': 'integer'},
                                                        'number': {'$ref': '#/definitions/Number'},
                                                        'series': {'type': 'string'}},
                                         'required': ['number',
                                                      'major',
                                                      'minor',
                                                      'arch',
                                                      'series',
                                                      'agentstream'],
                                         'type': 'object'},
                     'FindToolsResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'list': {'items': {'$ref': '#/definitions/Tools'},
                                                                 'type': 'array'}},
                                         'required': ['list'],
                                         'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'root-disk-source': {'type': 'string'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'HostNetworkChange': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'new-bridges': {'items': {'$ref': '#/definitions/DeviceBridgeInfo'},
                                                                          'type': 'array'},
                                                          'reconfigure-delay': {'type': 'integer'}},
                                           'required': ['new-bridges',
                                                        'reconfigure-delay'],
                                           'type': 'object'},
                     'HostNetworkChangeResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/HostNetworkChange'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'InstanceInfo': {'additionalProperties': False,
                                      'properties': {'characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                     'charm-profiles': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                     'display-name': {'type': 'string'},
                                                     'instance-id': {'type': 'string'},
                                                     'network-config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                        'type': 'array'},
                                                     'nonce': {'type': 'string'},
                                                     'tag': {'type': 'string'},
                                                     'volume-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentInfo'}},
                                                                            'type': 'object'},
                                                     'volumes': {'items': {'$ref': '#/definitions/Volume'},
                                                                 'type': 'array'}},
                                      'required': ['tag',
                                                   'instance-id',
                                                   'display-name',
                                                   'nonce',
                                                   'characteristics',
                                                   'volumes',
                                                   'volume-attachments',
                                                   'network-config',
                                                   'charm-profiles'],
                                      'type': 'object'},
                     'InstancesInfo': {'additionalProperties': False,
                                       'properties': {'machines': {'items': {'$ref': '#/definitions/InstanceInfo'},
                                                                   'type': 'array'}},
                                       'required': ['machines'],
                                       'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'MachineContainerResult': {'additionalProperties': False,
                                                'properties': {'container-types': {'items': {'type': 'string'},
                                                                                   'type': 'array'},
                                                               'determined': {'type': 'boolean'},
                                                               'error': {'$ref': '#/definitions/Error'}},
                                                'required': ['container-types',
                                                             'determined'],
                                                'type': 'object'},
                     'MachineContainerResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/MachineContainerResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'MachineContainers': {'additionalProperties': False,
                                           'properties': {'container-types': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                          'machine-tag': {'type': 'string'}},
                                           'required': ['machine-tag',
                                                        'container-types'],
                                           'type': 'object'},
                     'MachineContainersParams': {'additionalProperties': False,
                                                 'properties': {'params': {'items': {'$ref': '#/definitions/MachineContainers'},
                                                                           'type': 'array'}},
                                                 'required': ['params'],
                                                 'type': 'object'},
                     'MachineNetworkConfigResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'info': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                            'type': 'array'}},
                                                    'required': ['info'],
                                                    'type': 'object'},
                     'MachineNetworkConfigResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/MachineNetworkConfigResult'},
                                                                                'type': 'array'}},
                                                     'required': ['results'],
                                                     'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'is-default-gateway': {'type': 'boolean'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-network-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-network-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'ProvisioningInfo': {'additionalProperties': False,
                                          'properties': {'charm-lxd-profiles': {'items': {'type': 'string'},
                                                                                'type': 'array'},
                                                         'cloudinit-userdata': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                             'type': 'object'}},
                                                                                'type': 'object'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'controller-config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                            'type': 'object'}},
                                                                               'type': 'object'},
                                                         'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                               'type': 'object'},
                                                         'image-metadata': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                            'type': 'array'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'placement': {'type': 'string'},
                                                         'series': {'type': 'string'},
                                                         'subnets-to-zones': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                           'type': 'array'}},
                                                                              'type': 'object'},
                                                         'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                         'volume-attachments': {'items': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                                                'type': 'array'},
                                                         'volumes': {'items': {'$ref': '#/definitions/VolumeParams'},
                                                                     'type': 'array'}},
                                          'required': ['constraints',
                                                       'series',
                                                       'placement',
                                                       'jobs'],
                                          'type': 'object'},
                     'ProvisioningInfoResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/ProvisioningInfo'}},
                                                'required': ['result'],
                                                'type': 'object'},
                     'ProvisioningInfoResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ProvisioningInfoResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'SetMachineNetworkConfig': {'additionalProperties': False,
                                                 'properties': {'config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                           'type': 'array'},
                                                                'tag': {'type': 'string'}},
                                                 'required': ['tag', 'config'],
                                                 'type': 'object'},
                     'SetProfileArg': {'additionalProperties': False,
                                       'properties': {'entity': {'$ref': '#/definitions/Entity'},
                                                      'profiles': {'items': {'type': 'string'},
                                                                   'type': 'array'}},
                                       'required': ['entity', 'profiles'],
                                       'type': 'object'},
                     'SetProfileArgs': {'additionalProperties': False,
                                        'properties': {'args': {'items': {'$ref': '#/definitions/SetProfileArg'},
                                                                'type': 'array'}},
                                        'required': ['args'],
                                        'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'Settings': {'additionalProperties': False,
                                  'properties': {'AutoNoProxy': {'type': 'string'},
                                                 'Ftp': {'type': 'string'},
                                                 'Http': {'type': 'string'},
                                                 'Https': {'type': 'string'},
                                                 'NoProxy': {'type': 'string'}},
                                  'required': ['Http',
                                               'Https',
                                               'Ftp',
                                               'NoProxy',
                                               'AutoNoProxy'],
                                  'type': 'object'},
                     'StatusResult': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'id': {'type': 'string'},
                                                     'info': {'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['id',
                                                   'life',
                                                   'status',
                                                   'info',
                                                   'data',
                                                   'since'],
                                      'type': 'object'},
                     'StatusResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StatusResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'ToolsResult': {'additionalProperties': False,
                                     'properties': {'disable-ssl-hostname-verification': {'type': 'boolean'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'tools': {'items': {'$ref': '#/definitions/Tools'},
                                                              'type': 'array'}},
                                     'required': ['tools',
                                                  'disable-ssl-hostname-verification'],
                                     'type': 'object'},
                     'ToolsResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ToolsResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'UpdateBehavior': {'additionalProperties': False,
                                        'properties': {'enable-os-refresh-update': {'type': 'boolean'},
                                                       'enable-os-upgrade': {'type': 'boolean'}},
                                        'required': ['enable-os-refresh-update',
                                                     'enable-os-upgrade'],
                                        'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'},
                     'Volume': {'additionalProperties': False,
                                'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                               'volume-tag': {'type': 'string'}},
                                'required': ['volume-tag', 'info'],
                                'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentParams': {'additionalProperties': False,
                                                'properties': {'instance-id': {'type': 'string'},
                                                               'machine-tag': {'type': 'string'},
                                                               'provider': {'type': 'string'},
                                                               'read-only': {'type': 'boolean'},
                                                               'volume-id': {'type': 'string'},
                                                               'volume-tag': {'type': 'string'}},
                                                'required': ['volume-tag',
                                                             'machine-tag',
                                                             'provider'],
                                                'type': 'object'},
                     'VolumeAttachmentPlanInfo': {'additionalProperties': False,
                                                  'properties': {'device-attributes': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                       'type': 'object'},
                                                                 'device-type': {'type': 'string'}},
                                                  'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'},
                     'VolumeParams': {'additionalProperties': False,
                                      'properties': {'attachment': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                     'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'},
                                                     'provider': {'type': 'string'},
                                                     'size': {'type': 'integer'},
                                                     'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                              'type': 'object'},
                                                     'volume-tag': {'type': 'string'}},
                                      'required': ['volume-tag',
                                                   'size',
                                                   'provider'],
                                      'type': 'object'},
                     'WatchContainer': {'additionalProperties': False,
                                        'properties': {'container-type': {'type': 'string'},
                                                       'machine-tag': {'type': 'string'}},
                                        'required': ['machine-tag',
                                                     'container-type'],
                                        'type': 'object'},
                     'WatchContainers': {'additionalProperties': False,
                                         'properties': {'params': {'items': {'$ref': '#/definitions/WatchContainer'},
                                                                   'type': 'array'}},
                                         'required': ['params'],
                                         'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'AvailabilityZone': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringResults'}},
                                         'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'Constraints': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ConstraintsResults'}},
                                    'type': 'object'},
                    'ContainerConfig': {'properties': {'Result': {'$ref': '#/definitions/ContainerConfig'}},
                                        'type': 'object'},
                    'ContainerManagerConfig': {'properties': {'Params': {'$ref': '#/definitions/ContainerManagerConfigParams'},
                                                              'Result': {'$ref': '#/definitions/ContainerManagerConfig'}},
                                               'type': 'object'},
                    'ControllerAPIInfoForModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'DistributionGroup': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/DistributionGroupResults'}},
                                          'type': 'object'},
                    'DistributionGroupByMachineId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                    'Result': {'$ref': '#/definitions/StringsResults'}},
                                                     'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FindTools': {'properties': {'Params': {'$ref': '#/definitions/FindToolsParams'},
                                                 'Result': {'$ref': '#/definitions/FindToolsResult'}},
                                  'type': 'object'},
                    'GetContainerInterfaceInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/MachineNetworkConfigResults'}},
                                                  'type': 'object'},
                    'GetContainerProfileInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/ContainerProfileResults'}},
                                                'type': 'object'},
                    'HostChangesForContainers': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/HostNetworkChangeResults'}},
                                                 'type': 'object'},
                    'InstanceId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'InstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StatusResults'}},
                                       'type': 'object'},
                    'KeepInstance': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/BoolResults'}},
                                     'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'MachinesWithTransientErrors': {'properties': {'Result': {'$ref': '#/definitions/StatusResults'}},
                                                    'type': 'object'},
                    'MarkMachinesForRemoval': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'PrepareContainerInterfaceInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                     'Result': {'$ref': '#/definitions/MachineNetworkConfigResults'}},
                                                      'type': 'object'},
                    'ProvisioningInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/ProvisioningInfoResults'}},
                                         'type': 'object'},
                    'ReleaseContainerAddresses': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                  'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Series': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StringResults'}},
                               'type': 'object'},
                    'SetCharmProfiles': {'properties': {'Params': {'$ref': '#/definitions/SetProfileArgs'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'SetHostMachineNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                    'type': 'object'},
                    'SetInstanceInfo': {'properties': {'Params': {'$ref': '#/definitions/InstancesInfo'},
                                                       'Result': {'$ref': '#/definitions/ErrorResults'}},
                                        'type': 'object'},
                    'SetInstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetModificationStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'SetObservedNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                 'type': 'object'},
                    'SetPasswords': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'SetProviderNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetSupportedContainers': {'properties': {'Params': {'$ref': '#/definitions/MachineContainersParams'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'StateAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                       'type': 'object'},
                    'Status': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StatusResults'}},
                               'type': 'object'},
                    'SupportedContainers': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/MachineContainerResults'}},
                                            'type': 'object'},
                    'Tools': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/ToolsResults'}},
                              'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchAllContainers': {'properties': {'Params': {'$ref': '#/definitions/WatchContainers'},
                                                          'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                           'type': 'object'},
                    'WatchContainers': {'properties': {'Params': {'$ref': '#/definitions/WatchContainers'},
                                                       'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                        'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchMachineErrorRetry': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                               'type': 'object'},
                    'WatchModelMachines': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='APIAddresses',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='APIHostPorts',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def AvailabilityZone(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='AvailabilityZone',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> BytesResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='CACert',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConstraintsResults)
    async def Constraints(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ConstraintsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Constraints',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerConfig)
    async def ContainerConfig(self):
        '''

        Returns -> ContainerConfig
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ContainerConfig',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerManagerConfig)
    async def ContainerManagerConfig(self, type_=None):
        '''
        type_ : str
        Returns -> ContainerManagerConfig
        '''
        if type_ is not None and not isinstance(type_, (bytes, str)):
            raise Exception("Expected type_ to be a str, received: {}".format(type(type_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ContainerManagerConfig',
                   version=9,
                   params=_params)
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ControllerAPIInfoForModels',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ControllerConfig',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DistributionGroupResults)
    async def DistributionGroup(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> DistributionGroupResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='DistributionGroup',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def DistributionGroupByMachineId(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='DistributionGroupByMachineId',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='EnsureDead',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindToolsResult)
    async def FindTools(self, agentstream=None, arch=None, major=None, minor=None, number=None, series=None):
        '''
        agentstream : str
        arch : str
        major : int
        minor : int
        number : Number
        series : str
        Returns -> FindToolsResult
        '''
        if agentstream is not None and not isinstance(agentstream, (bytes, str)):
            raise Exception("Expected agentstream to be a str, received: {}".format(type(agentstream)))

        if arch is not None and not isinstance(arch, (bytes, str)):
            raise Exception("Expected arch to be a str, received: {}".format(type(arch)))

        if major is not None and not isinstance(major, int):
            raise Exception("Expected major to be a int, received: {}".format(type(major)))

        if minor is not None and not isinstance(minor, int):
            raise Exception("Expected minor to be a int, received: {}".format(type(minor)))

        if number is not None and not isinstance(number, (dict, Number)):
            raise Exception("Expected number to be a Number, received: {}".format(type(number)))

        if series is not None and not isinstance(series, (bytes, str)):
            raise Exception("Expected series to be a str, received: {}".format(type(series)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='FindTools',
                   version=9,
                   params=_params)
        _params['agentstream'] = agentstream
        _params['arch'] = arch
        _params['major'] = major
        _params['minor'] = minor
        _params['number'] = number
        _params['series'] = series
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineNetworkConfigResults)
    async def GetContainerInterfaceInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachineNetworkConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='GetContainerInterfaceInfo',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerProfileResults)
    async def GetContainerProfileInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ContainerProfileResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='GetContainerProfileInfo',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(HostNetworkChangeResults)
    async def HostChangesForContainers(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> HostNetworkChangeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='HostChangesForContainers',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='InstanceId',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def InstanceStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='InstanceStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResults)
    async def KeepInstance(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> BoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='KeepInstance',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Life',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def MachinesWithTransientErrors(self):
        '''

        Returns -> StatusResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='MachinesWithTransientErrors',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def MarkMachinesForRemoval(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='MarkMachinesForRemoval',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ModelConfig',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ModelUUID',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineNetworkConfigResults)
    async def PrepareContainerInterfaceInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachineNetworkConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='PrepareContainerInterfaceInfo',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProvisioningInfoResults)
    async def ProvisioningInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ProvisioningInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ProvisioningInfo',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ReleaseContainerAddresses(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ReleaseContainerAddresses',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Remove',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def Series(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Series',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetCharmProfiles(self, args=None):
        '''
        args : typing.Sequence[~SetProfileArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetCharmProfiles',
                   version=9,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetHostMachineNetworkConfig(self, config=None, tag=None):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetHostMachineNetworkConfig',
                   version=9,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceInfo(self, machines=None):
        '''
        machines : typing.Sequence[~InstanceInfo]
        Returns -> ErrorResults
        '''
        if machines is not None and not isinstance(machines, (bytes, str, list)):
            raise Exception("Expected machines to be a Sequence, received: {}".format(type(machines)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetInstanceInfo',
                   version=9,
                   params=_params)
        _params['machines'] = machines
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetInstanceStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModificationStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetModificationStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetObservedNetworkConfig(self, config=None, tag=None):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetObservedNetworkConfig',
                   version=9,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes=None):
        '''
        changes : typing.Sequence[~EntityPassword]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetPasswords',
                   version=9,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetProviderNetworkConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetProviderNetworkConfig',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetSupportedContainers(self, params=None):
        '''
        params : typing.Sequence[~MachineContainers]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetSupportedContainers',
                   version=9,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResult)
    async def StateAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='StateAddresses',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def Status(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Status',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineContainerResults)
    async def SupportedContainers(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachineContainerResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SupportedContainers',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ToolsResults)
    async def Tools(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ToolsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Tools',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='UpdateStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchAPIHostPorts',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchAllContainers(self, params=None):
        '''
        params : typing.Sequence[~WatchContainer]
        Returns -> StringsWatchResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchAllContainers',
                   version=9,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchContainers(self, params=None):
        '''
        params : typing.Sequence[~WatchContainer]
        Returns -> StringsWatchResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchContainers',
                   version=9,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchForModelConfigChanges',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchMachineErrorRetry(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchMachineErrorRetry',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachines(self):
        '''

        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchModelMachines',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class UniterFacade(Type):
    name = 'Uniter'
    version = 9
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionExecutionResult': {'additionalProperties': False,
                                               'properties': {'action-tag': {'type': 'string'},
                                                              'message': {'type': 'string'},
                                                              'results': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'},
                                                              'status': {'type': 'string'}},
                                               'required': ['action-tag', 'status'],
                                               'type': 'object'},
                     'ActionExecutionResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/ActionExecutionResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'ApplicationStatusResult': {'additionalProperties': False,
                                                 'properties': {'application': {'$ref': '#/definitions/StatusResult'},
                                                                'error': {'$ref': '#/definitions/Error'},
                                                                'units': {'patternProperties': {'.*': {'$ref': '#/definitions/StatusResult'}},
                                                                          'type': 'object'}},
                                                 'required': ['application',
                                                              'units'],
                                                 'type': 'object'},
                     'ApplicationStatusResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationStatusResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'CharmURL': {'additionalProperties': False,
                                  'properties': {'url': {'type': 'string'}},
                                  'required': ['url'],
                                  'type': 'object'},
                     'CharmURLs': {'additionalProperties': False,
                                   'properties': {'urls': {'items': {'$ref': '#/definitions/CharmURL'},
                                                           'type': 'array'}},
                                   'required': ['urls'],
                                   'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'cacertificates': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                  'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'ConfigSettingsResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                              'required': ['settings'],
                                              'type': 'object'},
                     'ConfigSettingsResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/ConfigSettingsResult'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'Endpoint': {'additionalProperties': False,
                                  'properties': {'application-name': {'type': 'string'},
                                                 'relation': {'$ref': '#/definitions/CharmRelation'}},
                                  'required': ['application-name', 'relation'],
                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesCharmURL': {'additionalProperties': False,
                                          'properties': {'entities': {'items': {'$ref': '#/definitions/EntityCharmURL'},
                                                                      'type': 'array'}},
                                          'required': ['entities'],
                                          'type': 'object'},
                     'EntitiesPortRanges': {'additionalProperties': False,
                                            'properties': {'entities': {'items': {'$ref': '#/definitions/EntityPortRange'},
                                                                        'type': 'array'}},
                                            'required': ['entities'],
                                            'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityCharmURL': {'additionalProperties': False,
                                        'properties': {'charm-url': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'charm-url'],
                                        'type': 'object'},
                     'EntityPortRange': {'additionalProperties': False,
                                         'properties': {'from-port': {'type': 'integer'},
                                                        'protocol': {'type': 'string'},
                                                        'tag': {'type': 'string'},
                                                        'to-port': {'type': 'integer'}},
                                         'required': ['tag',
                                                      'protocol',
                                                      'from-port',
                                                      'to-port'],
                                         'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'EntityString': {'additionalProperties': False,
                                      'properties': {'tag': {'type': 'string'},
                                                     'value': {'type': 'string'}},
                                      'required': ['tag', 'value'],
                                      'type': 'object'},
                     'EntityWorkloadVersion': {'additionalProperties': False,
                                               'properties': {'tag': {'type': 'string'},
                                                              'workload-version': {'type': 'string'}},
                                               'required': ['tag',
                                                            'workload-version'],
                                               'type': 'object'},
                     'EntityWorkloadVersions': {'additionalProperties': False,
                                                'properties': {'entities': {'items': {'$ref': '#/definitions/EntityWorkloadVersion'},
                                                                            'type': 'array'}},
                                                'required': ['entities'],
                                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetLeadershipSettingsBulkResults': {'additionalProperties': False,
                                                          'properties': {'results': {'items': {'$ref': '#/definitions/GetLeadershipSettingsResult'},
                                                                                     'type': 'array'}},
                                                          'required': ['results'],
                                                          'type': 'object'},
                     'GetLeadershipSettingsResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                 'type': 'object'}},
                                                     'required': ['settings'],
                                                     'type': 'object'},
                     'GoalState': {'additionalProperties': False,
                                   'properties': {'relations': {'patternProperties': {'.*': {'patternProperties': {'.*': {'$ref': '#/definitions/GoalStateStatus'}},
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                  'units': {'patternProperties': {'.*': {'$ref': '#/definitions/GoalStateStatus'}},
                                                            'type': 'object'}},
                                   'required': ['units', 'relations'],
                                   'type': 'object'},
                     'GoalStateResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/GoalState'}},
                                         'required': ['result', 'error'],
                                         'type': 'object'},
                     'GoalStateResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/GoalStateResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'GoalStateStatus': {'additionalProperties': False,
                                         'properties': {'since': {'format': 'date-time',
                                                                  'type': 'string'},
                                                        'status': {'type': 'string'}},
                                         'required': ['status', 'since'],
                                         'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'IntResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'type': 'integer'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'IntResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/IntResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'InterfaceAddress': {'additionalProperties': False,
                                          'properties': {'cidr': {'type': 'string'},
                                                         'hostname': {'type': 'string'},
                                                         'value': {'type': 'string'}},
                                          'required': ['hostname', 'value', 'cidr'],
                                          'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachinePortRange': {'additionalProperties': False,
                                          'properties': {'port-range': {'$ref': '#/definitions/PortRange'},
                                                         'relation-tag': {'type': 'string'},
                                                         'unit-tag': {'type': 'string'}},
                                          'required': ['unit-tag',
                                                       'relation-tag',
                                                       'port-range'],
                                          'type': 'object'},
                     'MachinePortsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'ports': {'items': {'$ref': '#/definitions/MachinePortRange'},
                                                                     'type': 'array'}},
                                            'required': ['ports'],
                                            'type': 'object'},
                     'MachinePortsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/MachinePortsResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'MergeLeadershipSettingsBulkParams': {'additionalProperties': False,
                                                           'properties': {'params': {'items': {'$ref': '#/definitions/MergeLeadershipSettingsParam'},
                                                                                     'type': 'array'}},
                                                           'required': ['params'],
                                                           'type': 'object'},
                     'MergeLeadershipSettingsParam': {'additionalProperties': False,
                                                      'properties': {'application-tag': {'type': 'string'},
                                                                     'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                  'type': 'object'},
                                                                     'unit-tag': {'type': 'string'}},
                                                      'required': ['settings'],
                                                      'type': 'object'},
                     'MeterStatusResult': {'additionalProperties': False,
                                           'properties': {'code': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'type': 'string'}},
                                           'required': ['code', 'info'],
                                           'type': 'object'},
                     'MeterStatusResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/MeterStatusResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Metric': {'additionalProperties': False,
                                'properties': {'key': {'type': 'string'},
                                               'labels': {'patternProperties': {'.*': {'type': 'string'}},
                                                          'type': 'object'},
                                               'time': {'format': 'date-time',
                                                        'type': 'string'},
                                               'value': {'type': 'string'}},
                                'required': ['key', 'value', 'time'],
                                'type': 'object'},
                     'MetricBatch': {'additionalProperties': False,
                                     'properties': {'charm-url': {'type': 'string'},
                                                    'created': {'format': 'date-time',
                                                                'type': 'string'},
                                                    'metrics': {'items': {'$ref': '#/definitions/Metric'},
                                                                'type': 'array'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['uuid',
                                                  'charm-url',
                                                  'created',
                                                  'metrics'],
                                     'type': 'object'},
                     'MetricBatchParam': {'additionalProperties': False,
                                          'properties': {'batch': {'$ref': '#/definitions/MetricBatch'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'batch'],
                                          'type': 'object'},
                     'MetricBatchParams': {'additionalProperties': False,
                                           'properties': {'batches': {'items': {'$ref': '#/definitions/MetricBatchParam'},
                                                                      'type': 'array'}},
                                           'required': ['batches'],
                                           'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ModelResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'name': {'type': 'string'},
                                                    'type': {'type': 'string'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['name', 'uuid', 'type'],
                                     'type': 'object'},
                     'NetworkInfo': {'additionalProperties': False,
                                     'properties': {'addresses': {'items': {'$ref': '#/definitions/InterfaceAddress'},
                                                                  'type': 'array'},
                                                    'interface-name': {'type': 'string'},
                                                    'mac-address': {'type': 'string'}},
                                     'required': ['mac-address',
                                                  'interface-name',
                                                  'addresses'],
                                     'type': 'object'},
                     'NetworkInfoParams': {'additionalProperties': False,
                                           'properties': {'bindings': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                          'relation-id': {'type': 'integer'},
                                                          'unit': {'type': 'string'}},
                                           'required': ['unit', 'bindings'],
                                           'type': 'object'},
                     'NetworkInfoResult': {'additionalProperties': False,
                                           'properties': {'bind-addresses': {'items': {'$ref': '#/definitions/NetworkInfo'},
                                                                             'type': 'array'},
                                                          'egress-subnets': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'ingress-addresses': {'items': {'type': 'string'},
                                                                                'type': 'array'}},
                                           'type': 'object'},
                     'NetworkInfoResults': {'additionalProperties': False,
                                            'properties': {'results': {'patternProperties': {'.*': {'$ref': '#/definitions/NetworkInfoResult'}},
                                                                       'type': 'object'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'PortRange': {'additionalProperties': False,
                                   'properties': {'from-port': {'type': 'integer'},
                                                  'protocol': {'type': 'string'},
                                                  'to-port': {'type': 'integer'}},
                                   'required': ['from-port', 'to-port', 'protocol'],
                                   'type': 'object'},
                     'RelationIds': {'additionalProperties': False,
                                     'properties': {'relation-ids': {'items': {'type': 'integer'},
                                                                     'type': 'array'}},
                                     'required': ['relation-ids'],
                                     'type': 'object'},
                     'RelationResult': {'additionalProperties': False,
                                        'properties': {'bool': {'type': 'boolean'},
                                                       'endpoint': {'$ref': '#/definitions/Endpoint'},
                                                       'error': {'$ref': '#/definitions/Error'},
                                                       'id': {'type': 'integer'},
                                                       'key': {'type': 'string'},
                                                       'life': {'type': 'string'},
                                                       'other-application': {'type': 'string'}},
                                        'required': ['life',
                                                     'id',
                                                     'key',
                                                     'endpoint'],
                                        'type': 'object'},
                     'RelationResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/RelationResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'RelationStatusArg': {'additionalProperties': False,
                                           'properties': {'message': {'type': 'string'},
                                                          'relation-id': {'type': 'integer'},
                                                          'status': {'type': 'string'},
                                                          'unit-tag': {'type': 'string'}},
                                           'required': ['unit-tag',
                                                        'relation-id',
                                                        'status',
                                                        'message'],
                                           'type': 'object'},
                     'RelationStatusArgs': {'additionalProperties': False,
                                            'properties': {'args': {'items': {'$ref': '#/definitions/RelationStatusArg'},
                                                                    'type': 'array'}},
                                            'required': ['args'],
                                            'type': 'object'},
                     'RelationUnit': {'additionalProperties': False,
                                      'properties': {'relation': {'type': 'string'},
                                                     'unit': {'type': 'string'}},
                                      'required': ['relation', 'unit'],
                                      'type': 'object'},
                     'RelationUnitPair': {'additionalProperties': False,
                                          'properties': {'local-unit': {'type': 'string'},
                                                         'relation': {'type': 'string'},
                                                         'remote-unit': {'type': 'string'}},
                                          'required': ['relation',
                                                       'local-unit',
                                                       'remote-unit'],
                                          'type': 'object'},
                     'RelationUnitPairs': {'additionalProperties': False,
                                           'properties': {'relation-unit-pairs': {'items': {'$ref': '#/definitions/RelationUnitPair'},
                                                                                  'type': 'array'}},
                                           'required': ['relation-unit-pairs'],
                                           'type': 'object'},
                     'RelationUnitSettings': {'additionalProperties': False,
                                              'properties': {'relation': {'type': 'string'},
                                                             'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'},
                                                             'unit': {'type': 'string'}},
                                              'required': ['relation',
                                                           'unit',
                                                           'settings'],
                                              'type': 'object'},
                     'RelationUnitStatus': {'additionalProperties': False,
                                            'properties': {'in-scope': {'type': 'boolean'},
                                                           'relation-tag': {'type': 'string'},
                                                           'suspended': {'type': 'boolean'}},
                                            'required': ['relation-tag',
                                                         'in-scope',
                                                         'suspended'],
                                            'type': 'object'},
                     'RelationUnitStatusResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'results': {'items': {'$ref': '#/definitions/RelationUnitStatus'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'RelationUnitStatusResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/RelationUnitStatusResult'},
                                                                              'type': 'array'}},
                                                   'required': ['results'],
                                                   'type': 'object'},
                     'RelationUnits': {'additionalProperties': False,
                                       'properties': {'relation-units': {'items': {'$ref': '#/definitions/RelationUnit'},
                                                                         'type': 'array'}},
                                       'required': ['relation-units'],
                                       'type': 'object'},
                     'RelationUnitsChange': {'additionalProperties': False,
                                             'properties': {'changed': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitSettings'}},
                                                                        'type': 'object'},
                                                            'departed': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                             'required': ['changed'],
                                             'type': 'object'},
                     'RelationUnitsSettings': {'additionalProperties': False,
                                               'properties': {'relation-units': {'items': {'$ref': '#/definitions/RelationUnitSettings'},
                                                                                 'type': 'array'}},
                                               'required': ['relation-units'],
                                               'type': 'object'},
                     'RelationUnitsWatchResult': {'additionalProperties': False,
                                                  'properties': {'changes': {'$ref': '#/definitions/RelationUnitsChange'},
                                                                 'error': {'$ref': '#/definitions/Error'},
                                                                 'watcher-id': {'type': 'string'}},
                                                  'required': ['watcher-id',
                                                               'changes'],
                                                  'type': 'object'},
                     'RelationUnitsWatchResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/RelationUnitsWatchResult'},
                                                                              'type': 'array'}},
                                                   'required': ['results'],
                                                   'type': 'object'},
                     'ResolvedModeResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'mode': {'type': 'string'}},
                                            'required': ['mode'],
                                            'type': 'object'},
                     'ResolvedModeResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/ResolvedModeResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'SetPodSpecParams': {'additionalProperties': False,
                                          'properties': {'specs': {'items': {'$ref': '#/definitions/EntityString'},
                                                                   'type': 'array'}},
                                          'required': ['specs'],
                                          'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'SettingsResult': {'additionalProperties': False,
                                        'properties': {'error': {'$ref': '#/definitions/Error'},
                                                       'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                    'type': 'object'}},
                                        'required': ['settings'],
                                        'type': 'object'},
                     'SettingsResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/SettingsResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'StatusResult': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'id': {'type': 'string'},
                                                     'info': {'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['id',
                                                   'life',
                                                   'status',
                                                   'info',
                                                   'data',
                                                   'since'],
                                      'type': 'object'},
                     'StatusResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StatusResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StorageAddParams': {'additionalProperties': False,
                                          'properties': {'name': {'type': 'string'},
                                                         'storage': {'$ref': '#/definitions/StorageConstraints'},
                                                         'unit': {'type': 'string'}},
                                          'required': ['unit', 'name', 'storage'],
                                          'type': 'object'},
                     'StorageAttachment': {'additionalProperties': False,
                                           'properties': {'kind': {'type': 'integer'},
                                                          'life': {'type': 'string'},
                                                          'location': {'type': 'string'},
                                                          'owner-tag': {'type': 'string'},
                                                          'storage-tag': {'type': 'string'},
                                                          'unit-tag': {'type': 'string'}},
                                           'required': ['storage-tag',
                                                        'owner-tag',
                                                        'unit-tag',
                                                        'kind',
                                                        'location',
                                                        'life'],
                                           'type': 'object'},
                     'StorageAttachmentId': {'additionalProperties': False,
                                             'properties': {'storage-tag': {'type': 'string'},
                                                            'unit-tag': {'type': 'string'}},
                                             'required': ['storage-tag',
                                                          'unit-tag'],
                                             'type': 'object'},
                     'StorageAttachmentIds': {'additionalProperties': False,
                                              'properties': {'ids': {'items': {'$ref': '#/definitions/StorageAttachmentId'},
                                                                     'type': 'array'}},
                                              'required': ['ids'],
                                              'type': 'object'},
                     'StorageAttachmentIdsResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'result': {'$ref': '#/definitions/StorageAttachmentIds'}},
                                                    'required': ['result'],
                                                    'type': 'object'},
                     'StorageAttachmentIdsResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/StorageAttachmentIdsResult'},
                                                                                'type': 'array'}},
                                                     'type': 'object'},
                     'StorageAttachmentResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/StorageAttachment'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'StorageAttachmentResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/StorageAttachmentResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StoragesAddParams': {'additionalProperties': False,
                                           'properties': {'storages': {'items': {'$ref': '#/definitions/StorageAddParams'},
                                                                       'type': 'array'}},
                                           'required': ['storages'],
                                           'type': 'object'},
                     'StringBoolResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'ok': {'type': 'boolean'},
                                                         'result': {'type': 'string'}},
                                          'required': ['result', 'ok'],
                                          'type': 'object'},
                     'StringBoolResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/StringBoolResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'UnitRefreshResult': {'additionalProperties': False,
                                           'properties': {'Error': {'$ref': '#/definitions/Error'},
                                                          'Life': {'type': 'string'},
                                                          'Resolved': {'type': 'string'}},
                                           'required': ['Life',
                                                        'Resolved',
                                                        'Error'],
                                           'type': 'object'},
                     'UnitRefreshResults': {'additionalProperties': False,
                                            'properties': {'Results': {'items': {'$ref': '#/definitions/UnitRefreshResult'},
                                                                       'type': 'array'}},
                                            'required': ['Results'],
                                            'type': 'object'},
                     'UnitSettings': {'additionalProperties': False,
                                      'properties': {'version': {'type': 'integer'}},
                                      'required': ['version'],
                                      'type': 'object'},
                     'UpgradeSeriesStatusParam': {'additionalProperties': False,
                                                  'properties': {'entity': {'$ref': '#/definitions/Entity'},
                                                                 'message': {'type': 'string'},
                                                                 'status': {'type': 'string'}},
                                                  'required': ['entity',
                                                               'status',
                                                               'message'],
                                                  'type': 'object'},
                     'UpgradeSeriesStatusParams': {'additionalProperties': False,
                                                   'properties': {'params': {'items': {'$ref': '#/definitions/UpgradeSeriesStatusParam'},
                                                                             'type': 'array'}},
                                                   'required': ['params'],
                                                   'type': 'object'},
                     'UpgradeSeriesStatusResult': {'additionalProperties': False,
                                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                  'status': {'type': 'string'}},
                                                   'type': 'object'},
                     'UpgradeSeriesStatusResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/UpgradeSeriesStatusResult'},
                                                                               'type': 'array'}},
                                                    'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'Actions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'AddMetricBatches': {'properties': {'Params': {'$ref': '#/definitions/MetricBatchParams'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'AddUnitStorage': {'properties': {'Params': {'$ref': '#/definitions/StoragesAddParams'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'AllMachinePorts': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/MachinePortsResults'}},
                                        'type': 'object'},
                    'ApplicationStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ApplicationStatusResults'}},
                                          'type': 'object'},
                    'AssignedMachine': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/StringResults'}},
                                        'type': 'object'},
                    'AvailabilityZone': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringResults'}},
                                         'type': 'object'},
                    'BeginActions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'CharmArchiveSha256': {'properties': {'Params': {'$ref': '#/definitions/CharmURLs'},
                                                          'Result': {'$ref': '#/definitions/StringResults'}},
                                           'type': 'object'},
                    'CharmModifiedVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                            'Result': {'$ref': '#/definitions/IntResults'}},
                                             'type': 'object'},
                    'CharmURL': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                'Result': {'$ref': '#/definitions/StringBoolResults'}},
                                 'type': 'object'},
                    'ClearResolved': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'ClosePorts': {'properties': {'Params': {'$ref': '#/definitions/EntitiesPortRanges'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'CloudSpec': {'properties': {'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                  'type': 'object'},
                    'ConfigSettings': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/ConfigSettingsResults'}},
                                       'type': 'object'},
                    'CurrentModel': {'properties': {'Result': {'$ref': '#/definitions/ModelResult'}},
                                     'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'DestroyAllSubordinates': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'DestroyUnitStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                      'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'EnterScope': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FinishActions': {'properties': {'Params': {'$ref': '#/definitions/ActionExecutionResults'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'GetMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/MeterStatusResults'}},
                                       'type': 'object'},
                    'GetPrincipal': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/StringBoolResults'}},
                                     'type': 'object'},
                    'GoalStates': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/GoalStateResults'}},
                                   'type': 'object'},
                    'HasSubordinates': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/BoolResults'}},
                                        'type': 'object'},
                    'LeaveScope': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'Merge': {'properties': {'Params': {'$ref': '#/definitions/MergeLeadershipSettingsBulkParams'},
                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                              'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'NetworkInfo': {'properties': {'Params': {'$ref': '#/definitions/NetworkInfoParams'},
                                                   'Result': {'$ref': '#/definitions/NetworkInfoResults'}},
                                    'type': 'object'},
                    'OpenPorts': {'properties': {'Params': {'$ref': '#/definitions/EntitiesPortRanges'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StringResults'}},
                                       'type': 'object'},
                    'ProviderType': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/StringResults'}},
                                      'type': 'object'},
                    'Read': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/GetLeadershipSettingsBulkResults'}},
                             'type': 'object'},
                    'ReadRemoteSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnitPairs'},
                                                          'Result': {'$ref': '#/definitions/SettingsResults'}},
                                           'type': 'object'},
                    'ReadSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                    'Result': {'$ref': '#/definitions/SettingsResults'}},
                                     'type': 'object'},
                    'Refresh': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/UnitRefreshResults'}},
                                'type': 'object'},
                    'Relation': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                'Result': {'$ref': '#/definitions/RelationResults'}},
                                 'type': 'object'},
                    'RelationById': {'properties': {'Params': {'$ref': '#/definitions/RelationIds'},
                                                    'Result': {'$ref': '#/definitions/RelationResults'}},
                                     'type': 'object'},
                    'RelationsStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/RelationUnitStatusResults'}},
                                        'type': 'object'},
                    'RemoveStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'RequestReboot': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'Resolved': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                'Result': {'$ref': '#/definitions/ResolvedModeResults'}},
                                 'type': 'object'},
                    'SLALevel': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                 'type': 'object'},
                    'SetAgentStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'SetApplicationStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'SetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/EntitiesCharmURL'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'SetPodSpec': {'properties': {'Params': {'$ref': '#/definitions/SetPodSpecParams'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'SetRelationStatus': {'properties': {'Params': {'$ref': '#/definitions/RelationStatusArgs'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetUnitStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'SetUpgradeSeriesUnitStatus': {'properties': {'Params': {'$ref': '#/definitions/UpgradeSeriesStatusParams'},
                                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                   'type': 'object'},
                    'SetWorkloadVersion': {'properties': {'Params': {'$ref': '#/definitions/EntityWorkloadVersions'},
                                                          'Result': {'$ref': '#/definitions/ErrorResults'}},
                                           'type': 'object'},
                    'StorageAttachmentLife': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                             'Result': {'$ref': '#/definitions/LifeResults'}},
                                              'type': 'object'},
                    'StorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                          'Result': {'$ref': '#/definitions/StorageAttachmentResults'}},
                                           'type': 'object'},
                    'UnitStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StatusResults'}},
                                   'type': 'object'},
                    'UnitStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/StorageAttachmentIdsResults'}},
                                               'type': 'object'},
                    'UpdateSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnitsSettings'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'UpgradeSeriesUnitStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/UpgradeSeriesStatusResults'}},
                                                'type': 'object'},
                    'Watch': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchActionNotifications': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                 'type': 'object'},
                    'WatchConfigSettingsHash': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchLeadershipSettings': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                'type': 'object'},
                    'WatchMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                         'type': 'object'},
                    'WatchRelationUnits': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                          'Result': {'$ref': '#/definitions/RelationUnitsWatchResults'}},
                                           'type': 'object'},
                    'WatchStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                               'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                'type': 'object'},
                    'WatchTrustConfigSettingsHash': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                    'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                     'type': 'object'},
                    'WatchUnitAddressesHash': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                               'type': 'object'},
                    'WatchUnitRelations': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                           'type': 'object'},
                    'WatchUnitStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                   'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                    'type': 'object'},
                    'WatchUpgradeSeriesNotifications': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                       'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                        'type': 'object'},
                    'WorkloadVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/StringResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='APIAddresses',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='APIHostPorts',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Actions(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ActionResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Actions',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def AddMetricBatches(self, batches=None):
        '''
        batches : typing.Sequence[~MetricBatchParam]
        Returns -> ErrorResults
        '''
        if batches is not None and not isinstance(batches, (bytes, str, list)):
            raise Exception("Expected batches to be a Sequence, received: {}".format(type(batches)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AddMetricBatches',
                   version=9,
                   params=_params)
        _params['batches'] = batches
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def AddUnitStorage(self, storages=None):
        '''
        storages : typing.Sequence[~StorageAddParams]
        Returns -> ErrorResults
        '''
        if storages is not None and not isinstance(storages, (bytes, str, list)):
            raise Exception("Expected storages to be a Sequence, received: {}".format(type(storages)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AddUnitStorage',
                   version=9,
                   params=_params)
        _params['storages'] = storages
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachinePortsResults)
    async def AllMachinePorts(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachinePortsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AllMachinePorts',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationStatusResults)
    async def ApplicationStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ApplicationStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def AssignedMachine(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AssignedMachine',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def AvailabilityZone(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AvailabilityZone',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def BeginActions(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='BeginActions',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def CharmArchiveSha256(self, urls=None):
        '''
        urls : typing.Sequence[~CharmURL]
        Returns -> StringResults
        '''
        if urls is not None and not isinstance(urls, (bytes, str, list)):
            raise Exception("Expected urls to be a Sequence, received: {}".format(type(urls)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CharmArchiveSha256',
                   version=9,
                   params=_params)
        _params['urls'] = urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IntResults)
    async def CharmModifiedVersion(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> IntResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CharmModifiedVersion',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringBoolResults)
    async def CharmURL(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringBoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CharmURL',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ClearResolved(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ClearResolved',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ClosePorts(self, entities=None):
        '''
        entities : typing.Sequence[~EntityPortRange]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ClosePorts',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def CloudSpec(self):
        '''

        Returns -> CloudSpecResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CloudSpec',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConfigSettingsResults)
    async def ConfigSettings(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ConfigSettingsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ConfigSettings',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelResult)
    async def CurrentModel(self):
        '''

        Returns -> ModelResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CurrentModel',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Destroy(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Destroy',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyAllSubordinates(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='DestroyAllSubordinates',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyUnitStorageAttachments(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='DestroyUnitStorageAttachments',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='EnsureDead',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnterScope(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> ErrorResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='EnterScope',
                   version=9,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def FinishActions(self, results=None):
        '''
        results : typing.Sequence[~ActionExecutionResult]
        Returns -> ErrorResults
        '''
        if results is not None and not isinstance(results, (bytes, str, list)):
            raise Exception("Expected results to be a Sequence, received: {}".format(type(results)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='FinishActions',
                   version=9,
                   params=_params)
        _params['results'] = results
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MeterStatusResults)
    async def GetMeterStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MeterStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='GetMeterStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringBoolResults)
    async def GetPrincipal(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringBoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='GetPrincipal',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GoalStateResults)
    async def GoalStates(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> GoalStateResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='GoalStates',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResults)
    async def HasSubordinates(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> BoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='HasSubordinates',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def LeaveScope(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> ErrorResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='LeaveScope',
                   version=9,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Life',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Merge(self, params=None):
        '''
        params : typing.Sequence[~MergeLeadershipSettingsParam]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Merge',
                   version=9,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ModelConfig',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ModelUUID',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NetworkInfoResults)
    async def NetworkInfo(self, bindings=None, relation_id=None, unit=None):
        '''
        bindings : typing.Sequence[str]
        relation_id : int
        unit : str
        Returns -> NetworkInfoResults
        '''
        if bindings is not None and not isinstance(bindings, (bytes, str, list)):
            raise Exception("Expected bindings to be a Sequence, received: {}".format(type(bindings)))

        if relation_id is not None and not isinstance(relation_id, int):
            raise Exception("Expected relation_id to be a int, received: {}".format(type(relation_id)))

        if unit is not None and not isinstance(unit, (bytes, str)):
            raise Exception("Expected unit to be a str, received: {}".format(type(unit)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='NetworkInfo',
                   version=9,
                   params=_params)
        _params['bindings'] = bindings
        _params['relation-id'] = relation_id
        _params['unit'] = unit
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def OpenPorts(self, entities=None):
        '''
        entities : typing.Sequence[~EntityPortRange]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='OpenPorts',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def PrivateAddress(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='PrivateAddress',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ProviderType(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ProviderType',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def PublicAddress(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='PublicAddress',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetLeadershipSettingsBulkResults)
    async def Read(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> GetLeadershipSettingsBulkResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Read',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SettingsResults)
    async def ReadRemoteSettings(self, relation_unit_pairs=None):
        '''
        relation_unit_pairs : typing.Sequence[~RelationUnitPair]
        Returns -> SettingsResults
        '''
        if relation_unit_pairs is not None and not isinstance(relation_unit_pairs, (bytes, str, list)):
            raise Exception("Expected relation_unit_pairs to be a Sequence, received: {}".format(type(relation_unit_pairs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ReadRemoteSettings',
                   version=9,
                   params=_params)
        _params['relation-unit-pairs'] = relation_unit_pairs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SettingsResults)
    async def ReadSettings(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> SettingsResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ReadSettings',
                   version=9,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UnitRefreshResults)
    async def Refresh(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> UnitRefreshResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Refresh',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationResults)
    async def Relation(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> RelationResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Relation',
                   version=9,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationResults)
    async def RelationById(self, relation_ids=None):
        '''
        relation_ids : typing.Sequence[int]
        Returns -> RelationResults
        '''
        if relation_ids is not None and not isinstance(relation_ids, (bytes, str, list)):
            raise Exception("Expected relation_ids to be a Sequence, received: {}".format(type(relation_ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RelationById',
                   version=9,
                   params=_params)
        _params['relation-ids'] = relation_ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationUnitStatusResults)
    async def RelationsStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> RelationUnitStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RelationsStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveStorageAttachments(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> ErrorResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RemoveStorageAttachments',
                   version=9,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RequestReboot(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RequestReboot',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ResolvedModeResults)
    async def Resolved(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ResolvedModeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Resolved',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def SLALevel(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SLALevel',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetAgentStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetAgentStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetApplicationStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetApplicationStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetCharmURL(self, entities=None):
        '''
        entities : typing.Sequence[~EntityCharmURL]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetCharmURL',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPodSpec(self, specs=None):
        '''
        specs : typing.Sequence[~EntityString]
        Returns -> ErrorResults
        '''
        if specs is not None and not isinstance(specs, (bytes, str, list)):
            raise Exception("Expected specs to be a Sequence, received: {}".format(type(specs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetPodSpec',
                   version=9,
                   params=_params)
        _params['specs'] = specs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetRelationStatus(self, args=None):
        '''
        args : typing.Sequence[~RelationStatusArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetRelationStatus',
                   version=9,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetUnitStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetUnitStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetUpgradeSeriesUnitStatus(self, params=None):
        '''
        params : typing.Sequence[~UpgradeSeriesStatusParam]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetUpgradeSeriesUnitStatus',
                   version=9,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetWorkloadVersion(self, entities=None):
        '''
        entities : typing.Sequence[~EntityWorkloadVersion]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetWorkloadVersion',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def StorageAttachmentLife(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> LifeResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='StorageAttachmentLife',
                   version=9,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageAttachmentResults)
    async def StorageAttachments(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> StorageAttachmentResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='StorageAttachments',
                   version=9,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def UnitStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UnitStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageAttachmentIdsResults)
    async def UnitStorageAttachments(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StorageAttachmentIdsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UnitStorageAttachments',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateSettings(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnitSettings]
        Returns -> ErrorResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UpdateSettings',
                   version=9,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpgradeSeriesStatusResults)
    async def UpgradeSeriesUnitStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> UpgradeSeriesStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UpgradeSeriesUnitStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Watch',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchAPIHostPorts',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchActionNotifications(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchActionNotifications',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchConfigSettingsHash(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchConfigSettingsHash',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchForModelConfigChanges',
                   version=9,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchLeadershipSettings(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchLeadershipSettings',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMeterStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchMeterStatus',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationUnitsWatchResults)
    async def WatchRelationUnits(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> RelationUnitsWatchResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchRelationUnits',
                   version=9,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchStorageAttachments(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> NotifyWatchResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchStorageAttachments',
                   version=9,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchTrustConfigSettingsHash(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchTrustConfigSettingsHash',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchUnitAddressesHash(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchUnitAddressesHash',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchUnitRelations(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchUnitRelations',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchUnitStorageAttachments(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchUnitStorageAttachments',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchUpgradeSeriesNotifications(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchUpgradeSeriesNotifications',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def WorkloadVersion(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WorkloadVersion',
                   version=9,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply


