# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client.facade import Type, ReturnMapping
from juju.client._definitions import *


class ApplicationFacade(Type):
    name = 'Application'
    version = 8
    schema =     {'definitions': {'AddApplicationUnits': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'attach-storage': {'items': {'type': 'string'},
                                                                               'type': 'array'},
                                                            'num-units': {'type': 'integer'},
                                                            'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                          'type': 'array'},
                                                            'policy': {'type': 'string'}},
                                             'required': ['application',
                                                          'num-units',
                                                          'placement'],
                                             'type': 'object'},
                     'AddApplicationUnitsResults': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'AddRelation': {'additionalProperties': False,
                                     'properties': {'endpoints': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                    'via-cidrs': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                     'required': ['endpoints'],
                                     'type': 'object'},
                     'AddRelationResults': {'additionalProperties': False,
                                            'properties': {'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                                         'type': 'object'}},
                                            'required': ['endpoints'],
                                            'type': 'object'},
                     'ApplicationCharmRelations': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'ApplicationCharmRelationsResults': {'additionalProperties': False,
                                                          'properties': {'charm-relations': {'items': {'type': 'string'},
                                                                                             'type': 'array'}},
                                                          'required': ['charm-relations'],
                                                          'type': 'object'},
                     'ApplicationConfigSet': {'additionalProperties': False,
                                              'properties': {'application': {'type': 'string'},
                                                             'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'}},
                                              'required': ['application', 'config'],
                                              'type': 'object'},
                     'ApplicationConfigSetArgs': {'additionalProperties': False,
                                                  'properties': {'Args': {'items': {'$ref': '#/definitions/ApplicationConfigSet'},
                                                                          'type': 'array'}},
                                                  'required': ['Args'],
                                                  'type': 'object'},
                     'ApplicationConfigUnsetArgs': {'additionalProperties': False,
                                                    'properties': {'Args': {'items': {'$ref': '#/definitions/ApplicationUnset'},
                                                                            'type': 'array'}},
                                                    'required': ['Args'],
                                                    'type': 'object'},
                     'ApplicationConstraint': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                              'error': {'$ref': '#/definitions/Error'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'ApplicationDeploy': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'attach-storage': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                          'channel': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                          'config-yaml': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'devices': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'num-units': {'type': 'integer'},
                                                          'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                        'type': 'array'},
                                                          'policy': {'type': 'string'},
                                                          'resources': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'}},
                                           'required': ['application',
                                                        'series',
                                                        'charm-url',
                                                        'channel',
                                                        'num-units',
                                                        'config-yaml',
                                                        'constraints'],
                                           'type': 'object'},
                     'ApplicationDestroy': {'additionalProperties': False,
                                            'properties': {'application': {'type': 'string'}},
                                            'required': ['application'],
                                            'type': 'object'},
                     'ApplicationExpose': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'}},
                                           'required': ['application'],
                                           'type': 'object'},
                     'ApplicationGet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'}},
                                        'required': ['application'],
                                        'type': 'object'},
                     'ApplicationGetConfigResults': {'additionalProperties': False,
                                                     'properties': {'Results': {'items': {'$ref': '#/definitions/ConfigResult'},
                                                                                'type': 'array'}},
                                                     'required': ['Results'],
                                                     'type': 'object'},
                     'ApplicationGetConstraintsResults': {'additionalProperties': False,
                                                          'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationConstraint'},
                                                                                     'type': 'array'}},
                                                          'required': ['results'],
                                                          'type': 'object'},
                     'ApplicationGetResults': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'application-config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                  'type': 'object'}},
                                                                                     'type': 'object'},
                                                              'charm': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'constraints': {'$ref': '#/definitions/Value'},
                                                              'series': {'type': 'string'}},
                                               'required': ['application',
                                                            'charm',
                                                            'config',
                                                            'constraints',
                                                            'series'],
                                               'type': 'object'},
                     'ApplicationMetricCredential': {'additionalProperties': False,
                                                     'properties': {'application': {'type': 'string'},
                                                                    'metrics-credentials': {'items': {'type': 'integer'},
                                                                                            'type': 'array'}},
                                                     'required': ['application',
                                                                  'metrics-credentials'],
                                                     'type': 'object'},
                     'ApplicationMetricCredentials': {'additionalProperties': False,
                                                      'properties': {'creds': {'items': {'$ref': '#/definitions/ApplicationMetricCredential'},
                                                                               'type': 'array'}},
                                                      'required': ['creds'],
                                                      'type': 'object'},
                     'ApplicationOfferDetails': {'additionalProperties': False,
                                                 'properties': {'application-description': {'type': 'string'},
                                                                'bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                                'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                              'type': 'array'},
                                                                'offer-name': {'type': 'string'},
                                                                'offer-url': {'type': 'string'},
                                                                'offer-uuid': {'type': 'string'},
                                                                'source-model-tag': {'type': 'string'},
                                                                'spaces': {'items': {'$ref': '#/definitions/RemoteSpace'},
                                                                           'type': 'array'},
                                                                'users': {'items': {'$ref': '#/definitions/OfferUserDetails'},
                                                                          'type': 'array'}},
                                                 'required': ['source-model-tag',
                                                              'offer-uuid',
                                                              'offer-url',
                                                              'offer-name',
                                                              'application-description'],
                                                 'type': 'object'},
                     'ApplicationSet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'options': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'}},
                                        'required': ['application', 'options'],
                                        'type': 'object'},
                     'ApplicationSetCharm': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'channel': {'type': 'string'},
                                                            'charm-url': {'type': 'string'},
                                                            'config-settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                            'config-settings-yaml': {'type': 'string'},
                                                            'force': {'type': 'boolean'},
                                                            'force-series': {'type': 'boolean'},
                                                            'force-units': {'type': 'boolean'},
                                                            'resource-ids': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                            'storage-constraints': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageConstraints'}},
                                                                                    'type': 'object'}},
                                             'required': ['application',
                                                          'charm-url',
                                                          'channel',
                                                          'force',
                                                          'force-units',
                                                          'force-series'],
                                             'type': 'object'},
                     'ApplicationSetCharmProfile': {'additionalProperties': False,
                                                    'properties': {'application': {'type': 'string'},
                                                                   'charm-url': {'type': 'string'}},
                                                    'required': ['application',
                                                                 'charm-url'],
                                                    'type': 'object'},
                     'ApplicationUnexpose': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'}},
                                             'required': ['application'],
                                             'type': 'object'},
                     'ApplicationUnset': {'additionalProperties': False,
                                          'properties': {'application': {'type': 'string'},
                                                         'options': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['application', 'options'],
                                          'type': 'object'},
                     'ApplicationUpdate': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'force': {'type': 'boolean'},
                                                          'force-charm-url': {'type': 'boolean'},
                                                          'force-series': {'type': 'boolean'},
                                                          'min-units': {'type': 'integer'},
                                                          'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                       'type': 'object'},
                                                          'settings-yaml': {'type': 'string'}},
                                           'required': ['application',
                                                        'charm-url',
                                                        'force-charm-url',
                                                        'force-series',
                                                        'force',
                                                        'settings-yaml'],
                                           'type': 'object'},
                     'ApplicationsDeploy': {'additionalProperties': False,
                                            'properties': {'applications': {'items': {'$ref': '#/definitions/ApplicationDeploy'},
                                                                            'type': 'array'}},
                                            'required': ['applications'],
                                            'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'ConfigResult': {'additionalProperties': False,
                                      'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'}},
                                      'required': ['config'],
                                      'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'ConsumeApplicationArg': {'additionalProperties': False,
                                               'properties': {'ApplicationOfferDetails': {'$ref': '#/definitions/ApplicationOfferDetails'},
                                                              'application-alias': {'type': 'string'},
                                                              'external-controller': {'$ref': '#/definitions/ExternalControllerInfo'},
                                                              'macaroon': {'$ref': '#/definitions/Macaroon'}},
                                               'required': ['ApplicationOfferDetails'],
                                               'type': 'object'},
                     'ConsumeApplicationArgs': {'additionalProperties': False,
                                                'properties': {'args': {'items': {'$ref': '#/definitions/ConsumeApplicationArg'},
                                                                        'type': 'array'}},
                                                'type': 'object'},
                     'DestroyApplicationInfo': {'additionalProperties': False,
                                                'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                     'type': 'array'},
                                                               'destroyed-units': {'items': {'$ref': '#/definitions/Entity'},
                                                                                   'type': 'array'},
                                                               'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                    'type': 'array'}},
                                                'type': 'object'},
                     'DestroyApplicationParams': {'additionalProperties': False,
                                                  'properties': {'application-tag': {'type': 'string'},
                                                                 'destroy-storage': {'type': 'boolean'}},
                                                  'required': ['application-tag'],
                                                  'type': 'object'},
                     'DestroyApplicationResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'info': {'$ref': '#/definitions/DestroyApplicationInfo'}},
                                                  'type': 'object'},
                     'DestroyApplicationResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/DestroyApplicationResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'DestroyApplicationUnits': {'additionalProperties': False,
                                                 'properties': {'unit-names': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                 'required': ['unit-names'],
                                                 'type': 'object'},
                     'DestroyApplicationsParams': {'additionalProperties': False,
                                                   'properties': {'applications': {'items': {'$ref': '#/definitions/DestroyApplicationParams'},
                                                                                   'type': 'array'}},
                                                   'required': ['applications'],
                                                   'type': 'object'},
                     'DestroyConsumedApplicationParams': {'additionalProperties': False,
                                                          'properties': {'application-tag': {'type': 'string'}},
                                                          'required': ['application-tag'],
                                                          'type': 'object'},
                     'DestroyConsumedApplicationsParams': {'additionalProperties': False,
                                                           'properties': {'applications': {'items': {'$ref': '#/definitions/DestroyConsumedApplicationParams'},
                                                                                           'type': 'array'}},
                                                           'required': ['applications'],
                                                           'type': 'object'},
                     'DestroyRelation': {'additionalProperties': False,
                                         'properties': {'endpoints': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                        'relation-id': {'type': 'integer'}},
                                         'required': ['relation-id'],
                                         'type': 'object'},
                     'DestroyUnitInfo': {'additionalProperties': False,
                                         'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                              'type': 'array'},
                                                        'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                             'type': 'array'}},
                                         'type': 'object'},
                     'DestroyUnitParams': {'additionalProperties': False,
                                           'properties': {'destroy-storage': {'type': 'boolean'},
                                                          'unit-tag': {'type': 'string'}},
                                           'required': ['unit-tag'],
                                           'type': 'object'},
                     'DestroyUnitResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'$ref': '#/definitions/DestroyUnitInfo'}},
                                           'type': 'object'},
                     'DestroyUnitResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/DestroyUnitResult'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'DestroyUnitsParams': {'additionalProperties': False,
                                            'properties': {'units': {'items': {'$ref': '#/definitions/DestroyUnitParams'},
                                                                     'type': 'array'}},
                                            'required': ['units'],
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ExternalControllerInfo': {'additionalProperties': False,
                                                'properties': {'addrs': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                               'ca-cert': {'type': 'string'},
                                                               'controller-alias': {'type': 'string'},
                                                               'controller-tag': {'type': 'string'}},
                                                'required': ['controller-tag',
                                                             'controller-alias',
                                                             'addrs',
                                                             'ca-cert'],
                                                'type': 'object'},
                     'LXDProfileUpgradeMessages': {'additionalProperties': False,
                                                   'properties': {'application': {'$ref': '#/definitions/Entity'},
                                                                  'watcher-id': {'type': 'string'}},
                                                   'required': ['application',
                                                                'watcher-id'],
                                                   'type': 'object'},
                     'LXDProfileUpgradeMessagesResult': {'additionalProperties': False,
                                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                        'message': {'type': 'string'},
                                                                        'unit-name': {'type': 'string'}},
                                                         'required': ['unit-name',
                                                                      'message'],
                                                         'type': 'object'},
                     'LXDProfileUpgradeMessagesResults': {'additionalProperties': False,
                                                          'properties': {'args': {'items': {'$ref': '#/definitions/LXDProfileUpgradeMessagesResult'},
                                                                                  'type': 'array'}},
                                                          'required': ['args'],
                                                          'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'OfferUserDetails': {'additionalProperties': False,
                                          'properties': {'access': {'type': 'string'},
                                                         'display-name': {'type': 'string'},
                                                         'user': {'type': 'string'}},
                                          'required': ['user',
                                                       'display-name',
                                                       'access'],
                                          'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'RelationSuspendedArg': {'additionalProperties': False,
                                              'properties': {'message': {'type': 'string'},
                                                             'relation-id': {'type': 'integer'},
                                                             'suspended': {'type': 'boolean'}},
                                              'required': ['relation-id',
                                                           'message',
                                                           'suspended'],
                                              'type': 'object'},
                     'RelationSuspendedArgs': {'additionalProperties': False,
                                               'properties': {'args': {'items': {'$ref': '#/definitions/RelationSuspendedArg'},
                                                                       'type': 'array'}},
                                               'required': ['args'],
                                               'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'RemoteSpace': {'additionalProperties': False,
                                     'properties': {'cloud-type': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'provider-attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                         'type': 'object'}},
                                                                            'type': 'object'},
                                                    'provider-id': {'type': 'string'},
                                                    'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                'type': 'array'}},
                                     'required': ['cloud-type',
                                                  'name',
                                                  'provider-id',
                                                  'provider-attributes',
                                                  'subnets'],
                                     'type': 'object'},
                     'ScaleApplicationInfo': {'additionalProperties': False,
                                              'properties': {'num-units': {'type': 'integer'}},
                                              'required': ['num-units'],
                                              'type': 'object'},
                     'ScaleApplicationParams': {'additionalProperties': False,
                                                'properties': {'application-tag': {'type': 'string'},
                                                               'scale': {'type': 'integer'},
                                                               'scale-change': {'type': 'integer'}},
                                                'required': ['application-tag',
                                                             'scale'],
                                                'type': 'object'},
                     'ScaleApplicationResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'info': {'$ref': '#/definitions/ScaleApplicationInfo'}},
                                                'type': 'object'},
                     'ScaleApplicationResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ScaleApplicationResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'ScaleApplicationsParams': {'additionalProperties': False,
                                                 'properties': {'applications': {'items': {'$ref': '#/definitions/ScaleApplicationParams'},
                                                                                 'type': 'array'}},
                                                 'required': ['applications'],
                                                 'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'UnitsResolved': {'additionalProperties': False,
                                       'properties': {'all': {'type': 'boolean'},
                                                      'retry': {'type': 'boolean'},
                                                      'tags': {'$ref': '#/definitions/Entities'}},
                                       'type': 'object'},
                     'UpdateSeriesArg': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'series': {'type': 'string'},
                                                        'tag': {'$ref': '#/definitions/Entity'}},
                                         'required': ['tag', 'force', 'series'],
                                         'type': 'object'},
                     'UpdateSeriesArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/UpdateSeriesArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'AddRelation': {'properties': {'Params': {'$ref': '#/definitions/AddRelation'},
                                                   'Result': {'$ref': '#/definitions/AddRelationResults'}},
                                    'type': 'object'},
                    'AddUnits': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationUnits'},
                                                'Result': {'$ref': '#/definitions/AddApplicationUnitsResults'}},
                                 'type': 'object'},
                    'CharmConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ApplicationGetConfigResults'}},
                                    'type': 'object'},
                    'CharmRelations': {'properties': {'Params': {'$ref': '#/definitions/ApplicationCharmRelations'},
                                                      'Result': {'$ref': '#/definitions/ApplicationCharmRelationsResults'}},
                                       'type': 'object'},
                    'Consume': {'properties': {'Params': {'$ref': '#/definitions/ConsumeApplicationArgs'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'Deploy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationsDeploy'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationDestroy'}},
                                'type': 'object'},
                    'DestroyApplication': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationsParams'},
                                                          'Result': {'$ref': '#/definitions/DestroyApplicationResults'}},
                                           'type': 'object'},
                    'DestroyConsumedApplications': {'properties': {'Params': {'$ref': '#/definitions/DestroyConsumedApplicationsParams'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'DestroyRelation': {'properties': {'Params': {'$ref': '#/definitions/DestroyRelation'}},
                                        'type': 'object'},
                    'DestroyUnit': {'properties': {'Params': {'$ref': '#/definitions/DestroyUnitsParams'},
                                                   'Result': {'$ref': '#/definitions/DestroyUnitResults'}},
                                    'type': 'object'},
                    'DestroyUnits': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationUnits'}},
                                     'type': 'object'},
                    'Expose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationExpose'}},
                               'type': 'object'},
                    'Get': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                           'Result': {'$ref': '#/definitions/ApplicationGetResults'}},
                            'type': 'object'},
                    'GetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                                   'Result': {'$ref': '#/definitions/StringResult'}},
                                    'type': 'object'},
                    'GetConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ApplicationGetConfigResults'}},
                                  'type': 'object'},
                    'GetConstraints': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/ApplicationGetConstraintsResults'}},
                                       'type': 'object'},
                    'GetLXDProfileUpgradeMessages': {'properties': {'Params': {'$ref': '#/definitions/LXDProfileUpgradeMessages'},
                                                                    'Result': {'$ref': '#/definitions/LXDProfileUpgradeMessagesResults'}},
                                                     'type': 'object'},
                    'ResolveUnitErrors': {'properties': {'Params': {'$ref': '#/definitions/UnitsResolved'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'ScaleApplications': {'properties': {'Params': {'$ref': '#/definitions/ScaleApplicationsParams'},
                                                         'Result': {'$ref': '#/definitions/ScaleApplicationResults'}},
                                          'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSet'}},
                            'type': 'object'},
                    'SetApplicationsConfig': {'properties': {'Params': {'$ref': '#/definitions/ApplicationConfigSetArgs'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'SetCharm': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharm'}},
                                 'type': 'object'},
                    'SetCharmProfile': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharmProfile'}},
                                        'type': 'object'},
                    'SetConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                       'type': 'object'},
                    'SetMetricCredentials': {'properties': {'Params': {'$ref': '#/definitions/ApplicationMetricCredentials'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'SetRelationsSuspended': {'properties': {'Params': {'$ref': '#/definitions/RelationSuspendedArgs'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'Unexpose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnexpose'}},
                                 'type': 'object'},
                    'Unset': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnset'}},
                              'type': 'object'},
                    'UnsetApplicationsConfig': {'properties': {'Params': {'$ref': '#/definitions/ApplicationConfigUnsetArgs'},
                                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                'type': 'object'},
                    'Update': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUpdate'}},
                               'type': 'object'},
                    'UpdateApplicationSeries': {'properties': {'Params': {'$ref': '#/definitions/UpdateSeriesArgs'},
                                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                'type': 'object'},
                    'WatchLXDProfileUpgradeNotifications': {'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                                           'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddRelationResults)
    async def AddRelation(self, endpoints=None, via_cidrs=None):
        '''
        endpoints : typing.Sequence[str]
        via_cidrs : typing.Sequence[str]
        Returns -> AddRelationResults
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        if via_cidrs is not None and not isinstance(via_cidrs, (bytes, str, list)):
            raise Exception("Expected via_cidrs to be a Sequence, received: {}".format(type(via_cidrs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddRelation',
                   version=8,
                   params=_params)
        _params['endpoints'] = endpoints
        _params['via-cidrs'] = via_cidrs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddApplicationUnitsResults)
    async def AddUnits(self, application=None, attach_storage=None, num_units=None, placement=None, policy=None):
        '''
        application : str
        attach_storage : typing.Sequence[str]
        num_units : int
        placement : typing.Sequence[~Placement]
        policy : str
        Returns -> AddApplicationUnitsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if attach_storage is not None and not isinstance(attach_storage, (bytes, str, list)):
            raise Exception("Expected attach_storage to be a Sequence, received: {}".format(type(attach_storage)))

        if num_units is not None and not isinstance(num_units, int):
            raise Exception("Expected num_units to be a int, received: {}".format(type(num_units)))

        if placement is not None and not isinstance(placement, (bytes, str, list)):
            raise Exception("Expected placement to be a Sequence, received: {}".format(type(placement)))

        if policy is not None and not isinstance(policy, (bytes, str)):
            raise Exception("Expected policy to be a str, received: {}".format(type(policy)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddUnits',
                   version=8,
                   params=_params)
        _params['application'] = application
        _params['attach-storage'] = attach_storage
        _params['num-units'] = num_units
        _params['placement'] = placement
        _params['policy'] = policy
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetConfigResults)
    async def CharmConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationGetConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmConfig',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmRelationsResults)
    async def CharmRelations(self, application=None):
        '''
        application : str
        Returns -> ApplicationCharmRelationsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmRelations',
                   version=8,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Consume(self, args=None):
        '''
        args : typing.Sequence[~ConsumeApplicationArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Consume',
                   version=8,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Deploy(self, applications=None):
        '''
        applications : typing.Sequence[~ApplicationDeploy]
        Returns -> ErrorResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Deploy',
                   version=8,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Destroy(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Destroy',
                   version=8,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyApplicationResults)
    async def DestroyApplication(self, applications=None):
        '''
        applications : typing.Sequence[~DestroyApplicationParams]
        Returns -> DestroyApplicationResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyApplication',
                   version=8,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyConsumedApplications(self, applications=None):
        '''
        applications : typing.Sequence[~DestroyConsumedApplicationParams]
        Returns -> ErrorResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyConsumedApplications',
                   version=8,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyRelation(self, endpoints=None, relation_id=None):
        '''
        endpoints : typing.Sequence[str]
        relation_id : int
        Returns -> None
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        if relation_id is not None and not isinstance(relation_id, int):
            raise Exception("Expected relation_id to be a int, received: {}".format(type(relation_id)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyRelation',
                   version=8,
                   params=_params)
        _params['endpoints'] = endpoints
        _params['relation-id'] = relation_id
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyUnitResults)
    async def DestroyUnit(self, units=None):
        '''
        units : typing.Sequence[~DestroyUnitParams]
        Returns -> DestroyUnitResults
        '''
        if units is not None and not isinstance(units, (bytes, str, list)):
            raise Exception("Expected units to be a Sequence, received: {}".format(type(units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnit',
                   version=8,
                   params=_params)
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyUnits(self, unit_names=None):
        '''
        unit_names : typing.Sequence[str]
        Returns -> None
        '''
        if unit_names is not None and not isinstance(unit_names, (bytes, str, list)):
            raise Exception("Expected unit_names to be a Sequence, received: {}".format(type(unit_names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnits',
                   version=8,
                   params=_params)
        _params['unit-names'] = unit_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Expose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Expose',
                   version=8,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetResults)
    async def Get(self, application=None):
        '''
        application : str
        Returns -> ApplicationGetResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Get',
                   version=8,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def GetCharmURL(self, application=None):
        '''
        application : str
        Returns -> StringResult
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetCharmURL',
                   version=8,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetConfigResults)
    async def GetConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationGetConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConfig',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetConstraintsResults)
    async def GetConstraints(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationGetConstraintsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConstraints',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LXDProfileUpgradeMessagesResults)
    async def GetLXDProfileUpgradeMessages(self, application=None, watcher_id=None):
        '''
        application : Entity
        watcher_id : str
        Returns -> LXDProfileUpgradeMessagesResults
        '''
        if application is not None and not isinstance(application, (dict, Entity)):
            raise Exception("Expected application to be a Entity, received: {}".format(type(application)))

        if watcher_id is not None and not isinstance(watcher_id, (bytes, str)):
            raise Exception("Expected watcher_id to be a str, received: {}".format(type(watcher_id)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetLXDProfileUpgradeMessages',
                   version=8,
                   params=_params)
        _params['application'] = application
        _params['watcher-id'] = watcher_id
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ResolveUnitErrors(self, all_=None, retry=None, tags=None):
        '''
        all_ : bool
        retry : bool
        tags : Entities
        Returns -> ErrorResults
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        if retry is not None and not isinstance(retry, bool):
            raise Exception("Expected retry to be a bool, received: {}".format(type(retry)))

        if tags is not None and not isinstance(tags, (dict, Entities)):
            raise Exception("Expected tags to be a Entities, received: {}".format(type(tags)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='ResolveUnitErrors',
                   version=8,
                   params=_params)
        _params['all'] = all_
        _params['retry'] = retry
        _params['tags'] = tags
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ScaleApplicationResults)
    async def ScaleApplications(self, applications=None):
        '''
        applications : typing.Sequence[~ScaleApplicationParams]
        Returns -> ScaleApplicationResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='ScaleApplications',
                   version=8,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Set(self, application=None, options=None):
        '''
        application : str
        options : typing.Mapping[str, str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if options is not None and not isinstance(options, dict):
            raise Exception("Expected options to be a Mapping, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Set',
                   version=8,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetApplicationsConfig(self, args=None):
        '''
        args : typing.Sequence[~ApplicationConfigSet]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetApplicationsConfig',
                   version=8,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharm(self, application=None, channel=None, charm_url=None, config_settings=None, config_settings_yaml=None, force=None, force_series=None, force_units=None, resource_ids=None, storage_constraints=None):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping[str, str]
        config_settings_yaml : str
        force : bool
        force_series : bool
        force_units : bool
        resource_ids : typing.Mapping[str, str]
        storage_constraints : typing.Mapping[str, ~StorageConstraints]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if config_settings is not None and not isinstance(config_settings, dict):
            raise Exception("Expected config_settings to be a Mapping, received: {}".format(type(config_settings)))

        if config_settings_yaml is not None and not isinstance(config_settings_yaml, (bytes, str)):
            raise Exception("Expected config_settings_yaml to be a str, received: {}".format(type(config_settings_yaml)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if force_units is not None and not isinstance(force_units, bool):
            raise Exception("Expected force_units to be a bool, received: {}".format(type(force_units)))

        if resource_ids is not None and not isinstance(resource_ids, dict):
            raise Exception("Expected resource_ids to be a Mapping, received: {}".format(type(resource_ids)))

        if storage_constraints is not None and not isinstance(storage_constraints, dict):
            raise Exception("Expected storage_constraints to be a Mapping, received: {}".format(type(storage_constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetCharm',
                   version=8,
                   params=_params)
        _params['application'] = application
        _params['channel'] = channel
        _params['charm-url'] = charm_url
        _params['config-settings'] = config_settings
        _params['config-settings-yaml'] = config_settings_yaml
        _params['force'] = force
        _params['force-series'] = force_series
        _params['force-units'] = force_units
        _params['resource-ids'] = resource_ids
        _params['storage-constraints'] = storage_constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharmProfile(self, application=None, charm_url=None):
        '''
        application : str
        charm_url : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetCharmProfile',
                   version=8,
                   params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetConstraints(self, application=None, constraints=None):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetConstraints',
                   version=8,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMetricCredentials(self, creds=None):
        '''
        creds : typing.Sequence[~ApplicationMetricCredential]
        Returns -> ErrorResults
        '''
        if creds is not None and not isinstance(creds, (bytes, str, list)):
            raise Exception("Expected creds to be a Sequence, received: {}".format(type(creds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetMetricCredentials',
                   version=8,
                   params=_params)
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetRelationsSuspended(self, args=None):
        '''
        args : typing.Sequence[~RelationSuspendedArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetRelationsSuspended',
                   version=8,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unexpose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unexpose',
                   version=8,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unset(self, application=None, options=None):
        '''
        application : str
        options : typing.Sequence[str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if options is not None and not isinstance(options, (bytes, str, list)):
            raise Exception("Expected options to be a Sequence, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unset',
                   version=8,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UnsetApplicationsConfig(self, args=None):
        '''
        args : typing.Sequence[~ApplicationUnset]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='UnsetApplicationsConfig',
                   version=8,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Update(self, application=None, charm_url=None, constraints=None, force=None, force_charm_url=None, force_series=None, min_units=None, settings=None, settings_yaml=None):
        '''
        application : str
        charm_url : str
        constraints : Value
        force : bool
        force_charm_url : bool
        force_series : bool
        min_units : int
        settings : typing.Mapping[str, str]
        settings_yaml : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if force_charm_url is not None and not isinstance(force_charm_url, bool):
            raise Exception("Expected force_charm_url to be a bool, received: {}".format(type(force_charm_url)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if min_units is not None and not isinstance(min_units, int):
            raise Exception("Expected min_units to be a int, received: {}".format(type(min_units)))

        if settings is not None and not isinstance(settings, dict):
            raise Exception("Expected settings to be a Mapping, received: {}".format(type(settings)))

        if settings_yaml is not None and not isinstance(settings_yaml, (bytes, str)):
            raise Exception("Expected settings_yaml to be a str, received: {}".format(type(settings_yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Update',
                   version=8,
                   params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        _params['constraints'] = constraints
        _params['force'] = force
        _params['force-charm-url'] = force_charm_url
        _params['force-series'] = force_series
        _params['min-units'] = min_units
        _params['settings'] = settings
        _params['settings-yaml'] = settings_yaml
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateApplicationSeries(self, args=None):
        '''
        args : typing.Sequence[~UpdateSeriesArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='UpdateApplicationSeries',
                   version=8,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchLXDProfileUpgradeNotifications(self, tag=None):
        '''
        tag : str
        Returns -> NotifyWatchResult
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='WatchLXDProfileUpgradeNotifications',
                   version=8,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



class ControllerFacade(Type):
    name = 'Controller'
    version = 8
    schema =     {'definitions': {'AllWatcherId': {'additionalProperties': False,
                                      'properties': {'watcher-id': {'type': 'string'}},
                                      'required': ['watcher-id'],
                                      'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'cacertificates': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                  'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'CloudSpecResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudSpecResult'},
                                                                     'type': 'array'}},
                                          'type': 'object'},
                     'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'ControllerConfigSet': {'additionalProperties': False,
                                             'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                    'type': 'object'}},
                                                                       'type': 'object'}},
                                             'required': ['config'],
                                             'type': 'object'},
                     'ControllerVersionResults': {'additionalProperties': False,
                                                  'properties': {'git-commit': {'type': 'string'},
                                                                 'version': {'type': 'string'}},
                                                  'required': ['version',
                                                               'git-commit'],
                                                  'type': 'object'},
                     'DestroyControllerArgs': {'additionalProperties': False,
                                               'properties': {'destroy-models': {'type': 'boolean'},
                                                              'destroy-storage': {'type': 'boolean'}},
                                               'required': ['destroy-models'],
                                               'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostedModelConfig': {'additionalProperties': False,
                                           'properties': {'cloud-spec': {'$ref': '#/definitions/CloudSpec'},
                                                          'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'name': {'type': 'string'},
                                                          'owner': {'type': 'string'}},
                                           'required': ['name', 'owner'],
                                           'type': 'object'},
                     'HostedModelConfigsResults': {'additionalProperties': False,
                                                   'properties': {'models': {'items': {'$ref': '#/definitions/HostedModelConfig'},
                                                                             'type': 'array'}},
                                                   'required': ['models'],
                                                   'type': 'object'},
                     'InitiateMigrationArgs': {'additionalProperties': False,
                                               'properties': {'specs': {'items': {'$ref': '#/definitions/MigrationSpec'},
                                                                        'type': 'array'}},
                                               'required': ['specs'],
                                               'type': 'object'},
                     'InitiateMigrationResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'migration-id': {'type': 'string'},
                                                                'model-tag': {'type': 'string'}},
                                                 'required': ['model-tag',
                                                              'migration-id'],
                                                 'type': 'object'},
                     'InitiateMigrationResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/InitiateMigrationResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MigrationSpec': {'additionalProperties': False,
                                       'properties': {'model-tag': {'type': 'string'},
                                                      'target-info': {'$ref': '#/definitions/MigrationTargetInfo'}},
                                       'required': ['model-tag', 'target-info'],
                                       'type': 'object'},
                     'MigrationTargetInfo': {'additionalProperties': False,
                                             'properties': {'addrs': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                            'auth-tag': {'type': 'string'},
                                                            'ca-cert': {'type': 'string'},
                                                            'controller-alias': {'type': 'string'},
                                                            'controller-tag': {'type': 'string'},
                                                            'macaroons': {'type': 'string'},
                                                            'password': {'type': 'string'}},
                                             'required': ['controller-tag',
                                                          'addrs',
                                                          'ca-cert',
                                                          'auth-tag'],
                                             'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'type': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'type', 'owner-tag'],
                               'type': 'object'},
                     'ModelBlockInfo': {'additionalProperties': False,
                                        'properties': {'blocks': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                       'model-uuid': {'type': 'string'},
                                                       'name': {'type': 'string'},
                                                       'owner-tag': {'type': 'string'}},
                                        'required': ['name',
                                                     'model-uuid',
                                                     'owner-tag',
                                                     'blocks'],
                                        'type': 'object'},
                     'ModelBlockInfoList': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelBlockInfo'},
                                                                      'type': 'array'}},
                                            'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelFilesystemInfo': {'additionalProperties': False,
                                             'properties': {'detachable': {'type': 'boolean'},
                                                            'id': {'type': 'string'},
                                                            'message': {'type': 'string'},
                                                            'provider-id': {'type': 'string'},
                                                            'status': {'type': 'string'}},
                                             'required': ['id'],
                                             'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'display-name': {'type': 'string'},
                                                         'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'message': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'filesystems': {'items': {'$ref': '#/definitions/ModelFilesystemInfo'},
                                                                    'type': 'array'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'},
                                                    'type': {'type': 'string'},
                                                    'unit-count': {'type': 'integer'},
                                                    'volumes': {'items': {'$ref': '#/definitions/ModelVolumeInfo'},
                                                                'type': 'array'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'type',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'unit-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelTag': {'additionalProperties': False, 'type': 'object'},
                     'ModelVolumeInfo': {'additionalProperties': False,
                                         'properties': {'detachable': {'type': 'boolean'},
                                                        'id': {'type': 'string'},
                                                        'message': {'type': 'string'},
                                                        'provider-id': {'type': 'string'},
                                                        'status': {'type': 'string'}},
                                         'required': ['id'],
                                         'type': 'object'},
                     'ModifyControllerAccess': {'additionalProperties': False,
                                                'properties': {'access': {'type': 'string'},
                                                               'action': {'type': 'string'},
                                                               'user-tag': {'type': 'string'}},
                                                'required': ['user-tag',
                                                             'action',
                                                             'access'],
                                                'type': 'object'},
                     'ModifyControllerAccessRequest': {'additionalProperties': False,
                                                       'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyControllerAccess'},
                                                                                  'type': 'array'}},
                                                       'required': ['changes'],
                                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'RemoveBlocksArgs': {'additionalProperties': False,
                                          'properties': {'all': {'type': 'boolean'}},
                                          'required': ['all'],
                                          'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'UserAccess': {'additionalProperties': False,
                                    'properties': {'access': {'type': 'string'},
                                                   'user-tag': {'type': 'string'}},
                                    'required': ['user-tag', 'access'],
                                    'type': 'object'},
                     'UserAccessResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/UserAccess'}},
                                          'type': 'object'},
                     'UserAccessResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/UserAccessResult'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'AllModels': {'properties': {'Result': {'$ref': '#/definitions/UserModelList'}},
                                  'type': 'object'},
                    'CloudSpec': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudSpecResults'}},
                                  'type': 'object'},
                    'ConfigSet': {'properties': {'Params': {'$ref': '#/definitions/ControllerConfigSet'}},
                                  'type': 'object'},
                    'ControllerAPIInfoForModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'ControllerVersion': {'properties': {'Result': {'$ref': '#/definitions/ControllerVersionResults'}},
                                          'type': 'object'},
                    'DestroyController': {'properties': {'Params': {'$ref': '#/definitions/DestroyControllerArgs'}},
                                          'type': 'object'},
                    'GetCloudSpec': {'properties': {'Params': {'$ref': '#/definitions/ModelTag'},
                                                    'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                     'type': 'object'},
                    'GetControllerAccess': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/UserAccessResults'}},
                                            'type': 'object'},
                    'HostedModelConfigs': {'properties': {'Result': {'$ref': '#/definitions/HostedModelConfigsResults'}},
                                           'type': 'object'},
                    'IdentityProviderURL': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                            'type': 'object'},
                    'InitiateMigration': {'properties': {'Params': {'$ref': '#/definitions/InitiateMigrationArgs'},
                                                         'Result': {'$ref': '#/definitions/InitiateMigrationResults'}},
                                          'type': 'object'},
                    'ListBlockedModels': {'properties': {'Result': {'$ref': '#/definitions/ModelBlockInfoList'}},
                                          'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                    'type': 'object'},
                    'ModelStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyControllerAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyControllerAccessRequest'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'MongoVersion': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'RemoveBlocks': {'properties': {'Params': {'$ref': '#/definitions/RemoveBlocksArgs'}},
                                     'type': 'object'},
                    'WatchAllModels': {'properties': {'Result': {'$ref': '#/definitions/AllWatcherId'}},
                                       'type': 'object'},
                    'WatchCloudSpecsChanges': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(UserModelList)
    async def AllModels(self):
        '''

        Returns -> UserModelList
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='AllModels',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResults)
    async def CloudSpec(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> CloudSpecResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='CloudSpec',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ConfigSet(self, config=None):
        '''
        config : typing.Mapping[str, typing.Any]
        Returns -> None
        '''
        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ConfigSet',
                   version=8,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ControllerAPIInfoForModels',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ControllerConfig',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerVersionResults)
    async def ControllerVersion(self):
        '''

        Returns -> ControllerVersionResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ControllerVersion',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyController(self, destroy_models=None, destroy_storage=None):
        '''
        destroy_models : bool
        destroy_storage : bool
        Returns -> None
        '''
        if destroy_models is not None and not isinstance(destroy_models, bool):
            raise Exception("Expected destroy_models to be a bool, received: {}".format(type(destroy_models)))

        if destroy_storage is not None and not isinstance(destroy_storage, bool):
            raise Exception("Expected destroy_storage to be a bool, received: {}".format(type(destroy_storage)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='DestroyController',
                   version=8,
                   params=_params)
        _params['destroy-models'] = destroy_models
        _params['destroy-storage'] = destroy_storage
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def GetCloudSpec(self):
        '''

        Returns -> CloudSpecResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='GetCloudSpec',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserAccessResults)
    async def GetControllerAccess(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> UserAccessResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='GetControllerAccess',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(HostedModelConfigsResults)
    async def HostedModelConfigs(self):
        '''

        Returns -> HostedModelConfigsResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='HostedModelConfigs',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def IdentityProviderURL(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='IdentityProviderURL',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InitiateMigrationResults)
    async def InitiateMigration(self, specs=None):
        '''
        specs : typing.Sequence[~MigrationSpec]
        Returns -> InitiateMigrationResults
        '''
        if specs is not None and not isinstance(specs, (bytes, str, list)):
            raise Exception("Expected specs to be a Sequence, received: {}".format(type(specs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='InitiateMigration',
                   version=8,
                   params=_params)
        _params['specs'] = specs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelBlockInfoList)
    async def ListBlockedModels(self):
        '''

        Returns -> ModelBlockInfoList
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ListBlockedModels',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResults)
    async def ModelConfig(self):
        '''

        Returns -> ModelConfigResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModelConfig',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ModelStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModelStatus',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyControllerAccess(self, changes=None):
        '''
        changes : typing.Sequence[~ModifyControllerAccess]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModifyControllerAccess',
                   version=8,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def MongoVersion(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='MongoVersion',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def RemoveBlocks(self, all_=None):
        '''
        all_ : bool
        Returns -> None
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='RemoveBlocks',
                   version=8,
                   params=_params)
        _params['all'] = all_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AllWatcherId)
    async def WatchAllModels(self):
        '''

        Returns -> AllWatcherId
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='WatchAllModels',
                   version=8,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchCloudSpecsChanges(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='WatchCloudSpecsChanges',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class ModelManagerFacade(Type):
    name = 'ModelManager'
    version = 8
    schema =     {'definitions': {'ChangeModelCredentialParams': {'additionalProperties': False,
                                                     'properties': {'credential-tag': {'type': 'string'},
                                                                    'model-tag': {'type': 'string'}},
                                                     'required': ['model-tag',
                                                                  'credential-tag'],
                                                     'type': 'object'},
                     'ChangeModelCredentialsParams': {'additionalProperties': False,
                                                      'properties': {'model-credentials': {'items': {'$ref': '#/definitions/ChangeModelCredentialParams'},
                                                                                           'type': 'array'}},
                                                      'required': ['model-credentials'],
                                                      'type': 'object'},
                     'DestroyModelParams': {'additionalProperties': False,
                                            'properties': {'destroy-storage': {'type': 'boolean'},
                                                           'force': {'type': 'boolean'},
                                                           'max-wait': {'type': 'integer'},
                                                           'model-tag': {'type': 'string'}},
                                            'required': ['model-tag'],
                                            'type': 'object'},
                     'DestroyModelsParams': {'additionalProperties': False,
                                             'properties': {'models': {'items': {'$ref': '#/definitions/DestroyModelParams'},
                                                                       'type': 'array'}},
                                             'required': ['models'],
                                             'type': 'object'},
                     'DumpModelRequest': {'additionalProperties': False,
                                          'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                      'type': 'array'},
                                                         'simplified': {'type': 'boolean'}},
                                          'required': ['entities', 'simplified'],
                                          'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MapResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                          'type': 'object'}},
                                                             'type': 'object'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'MapResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/MapResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'type': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'type', 'owner-tag'],
                               'type': 'object'},
                     'ModelCreateArgs': {'additionalProperties': False,
                                         'properties': {'cloud-tag': {'type': 'string'},
                                                        'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                'type': 'object'}},
                                                                   'type': 'object'},
                                                        'credential': {'type': 'string'},
                                                        'name': {'type': 'string'},
                                                        'owner-tag': {'type': 'string'},
                                                        'region': {'type': 'string'}},
                                         'required': ['name', 'owner-tag'],
                                         'type': 'object'},
                     'ModelDefaultValues': {'additionalProperties': False,
                                            'properties': {'cloud-region': {'type': 'string'},
                                                           'cloud-tag': {'type': 'string'},
                                                           'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                   'type': 'object'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelDefaults': {'additionalProperties': False,
                                       'properties': {'controller': {'additionalProperties': True,
                                                                     'type': 'object'},
                                                      'default': {'additionalProperties': True,
                                                                  'type': 'object'},
                                                      'regions': {'items': {'$ref': '#/definitions/RegionDefaults'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ModelDefaultsResult': {'additionalProperties': False,
                                             'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ModelDefaults'}},
                                                                       'type': 'object'},
                                                            'error': {'$ref': '#/definitions/Error'}},
                                             'required': ['config'],
                                             'type': 'object'},
                     'ModelDefaultsResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ModelDefaultsResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ModelEntityCount': {'additionalProperties': False,
                                          'properties': {'count': {'type': 'integer'},
                                                         'entity': {'type': 'string'}},
                                          'required': ['entity', 'count'],
                                          'type': 'object'},
                     'ModelFilesystemInfo': {'additionalProperties': False,
                                             'properties': {'detachable': {'type': 'boolean'},
                                                            'id': {'type': 'string'},
                                                            'message': {'type': 'string'},
                                                            'provider-id': {'type': 'string'},
                                                            'status': {'type': 'string'}},
                                             'required': ['id'],
                                             'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-credential-validity': {'type': 'boolean'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'is-controller': {'type': 'boolean'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'type': {'type': 'string'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'type',
                                                'uuid',
                                                'controller-uuid',
                                                'is-controller',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelInfoResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/ModelInfo'}},
                                         'type': 'object'},
                     'ModelInfoResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/ModelInfoResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'display-name': {'type': 'string'},
                                                         'ha-primary': {'type': 'boolean'},
                                                         'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'message': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'filesystems': {'items': {'$ref': '#/definitions/ModelFilesystemInfo'},
                                                                    'type': 'array'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'},
                                                    'type': {'type': 'string'},
                                                    'unit-count': {'type': 'integer'},
                                                    'volumes': {'items': {'$ref': '#/definitions/ModelVolumeInfo'},
                                                                'type': 'array'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'type',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'unit-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelSummariesRequest': {'additionalProperties': False,
                                               'properties': {'all': {'type': 'boolean'},
                                                              'user-tag': {'type': 'string'}},
                                               'required': ['user-tag'],
                                               'type': 'object'},
                     'ModelSummary': {'additionalProperties': False,
                                      'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                     'cloud-credential-tag': {'type': 'string'},
                                                     'cloud-region': {'type': 'string'},
                                                     'cloud-tag': {'type': 'string'},
                                                     'controller-uuid': {'type': 'string'},
                                                     'counts': {'items': {'$ref': '#/definitions/ModelEntityCount'},
                                                                'type': 'array'},
                                                     'default-series': {'type': 'string'},
                                                     'is-controller': {'type': 'boolean'},
                                                     'last-connection': {'format': 'date-time',
                                                                         'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                     'name': {'type': 'string'},
                                                     'owner-tag': {'type': 'string'},
                                                     'provider-type': {'type': 'string'},
                                                     'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                     'status': {'$ref': '#/definitions/EntityStatus'},
                                                     'type': {'type': 'string'},
                                                     'user-access': {'type': 'string'},
                                                     'uuid': {'type': 'string'}},
                                      'required': ['name',
                                                   'uuid',
                                                   'type',
                                                   'controller-uuid',
                                                   'is-controller',
                                                   'cloud-tag',
                                                   'owner-tag',
                                                   'life',
                                                   'user-access',
                                                   'last-connection',
                                                   'counts',
                                                   'sla',
                                                   'agent-version'],
                                      'type': 'object'},
                     'ModelSummaryResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'result': {'$ref': '#/definitions/ModelSummary'}},
                                            'type': 'object'},
                     'ModelSummaryResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/ModelSummaryResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'ModelUnsetKeys': {'additionalProperties': False,
                                        'properties': {'cloud-region': {'type': 'string'},
                                                       'cloud-tag': {'type': 'string'},
                                                       'keys': {'items': {'type': 'string'},
                                                                'type': 'array'}},
                                        'required': ['keys'],
                                        'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModelVolumeInfo': {'additionalProperties': False,
                                         'properties': {'detachable': {'type': 'boolean'},
                                                        'id': {'type': 'string'},
                                                        'message': {'type': 'string'},
                                                        'provider-id': {'type': 'string'},
                                                        'status': {'type': 'string'}},
                                         'required': ['id'],
                                         'type': 'object'},
                     'ModifyModelAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'model-tag': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'action',
                                                        'access',
                                                        'model-tag'],
                                           'type': 'object'},
                     'ModifyModelAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyModelAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RegionDefaults': {'additionalProperties': False,
                                        'properties': {'region-name': {'type': 'string'},
                                                       'value': {'additionalProperties': True,
                                                                 'type': 'object'}},
                                        'required': ['region-name', 'value'],
                                        'type': 'object'},
                     'SetModelDefaults': {'additionalProperties': False,
                                          'properties': {'config': {'items': {'$ref': '#/definitions/ModelDefaultValues'},
                                                                    'type': 'array'}},
                                          'required': ['config'],
                                          'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'UnsetModelDefaults': {'additionalProperties': False,
                                            'properties': {'keys': {'items': {'$ref': '#/definitions/ModelUnsetKeys'},
                                                                    'type': 'array'}},
                                            'required': ['keys'],
                                            'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'ChangeModelCredential': {'description': 'ChangeModelCredentials '
                                                             'changes cloud '
                                                             'credential reference '
                                                             'for models.\n'
                                                             'These new cloud '
                                                             'credentials must '
                                                             'already exist on the '
                                                             'controller.',
                                              'properties': {'Params': {'$ref': '#/definitions/ChangeModelCredentialsParams'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'CreateModel': {'description': 'CreateModel creates a new '
                                                   'model using the account and\n'
                                                   'model config specified in the '
                                                   'args.',
                                    'properties': {'Params': {'$ref': '#/definitions/ModelCreateArgs'},
                                                   'Result': {'$ref': '#/definitions/ModelInfo'}},
                                    'type': 'object'},
                    'DestroyModels': {'description': 'DestroyModels will try to '
                                                     'destroy the specified '
                                                     'models.\n'
                                                     'If there is a block on '
                                                     'destruction, this method '
                                                     'will return an error.\n'
                                                     'From ModelManager v7 '
                                                     'onwards, DestroyModels gains '
                                                     "'force' and 'max-wait' "
                                                     'parameters.',
                                      'properties': {'Params': {'$ref': '#/definitions/DestroyModelsParams'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'DumpModels': {'description': 'DumpModels will export the '
                                                  'models into the database '
                                                  'agnostic\n'
                                                  'representation. The user needs '
                                                  'to either be a controller '
                                                  'admin, or have\n'
                                                  'admin privileges on the model '
                                                  'itself.',
                                   'properties': {'Params': {'$ref': '#/definitions/DumpModelRequest'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'DumpModelsDB': {'description': 'DumpModelsDB will gather all '
                                                    'documents from all model '
                                                    'collections\n'
                                                    'for the specified model. The '
                                                    'map result contains a map of '
                                                    'collection\n'
                                                    'names to lists of documents '
                                                    'represented as maps.',
                                     'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/MapResults'}},
                                     'type': 'object'},
                    'ListModelSummaries': {'description': 'ListModelSummaries '
                                                          'returns models that the '
                                                          'specified user\n'
                                                          'has access to in the '
                                                          'current server.  '
                                                          'Controller admins '
                                                          '(superuser)\n'
                                                          'can list models for any '
                                                          'user.  Other users\n'
                                                          'can only ask about '
                                                          'their own models.',
                                           'properties': {'Params': {'$ref': '#/definitions/ModelSummariesRequest'},
                                                          'Result': {'$ref': '#/definitions/ModelSummaryResults'}},
                                           'type': 'object'},
                    'ListModels': {'description': 'ListModels returns the models '
                                                  'that the specified user\n'
                                                  'has access to in the current '
                                                  'server.  Controller admins '
                                                  '(superuser)\n'
                                                  'can list models for any user.  '
                                                  'Other users\n'
                                                  'can only ask about their own '
                                                  'models.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                  'Result': {'$ref': '#/definitions/UserModelList'}},
                                   'type': 'object'},
                    'ModelDefaultsForClouds': {'description': 'ModelDefaults '
                                                              'returns the default '
                                                              'config values for '
                                                              'the specified '
                                                              'clouds.',
                                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ModelDefaultsResults'}},
                                               'type': 'object'},
                    'ModelInfo': {'description': 'ModelInfo returns information '
                                                 'about the specified models.',
                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ModelInfoResults'}},
                                  'type': 'object'},
                    'ModelStatus': {'description': 'ModelStatus returns a summary '
                                                   'of the model.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyModelAccess': {'description': 'ModifyModelAccess '
                                                         'changes the model access '
                                                         'granted to users.',
                                          'properties': {'Params': {'$ref': '#/definitions/ModifyModelAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetModelDefaults': {'description': 'SetModelDefaults writes '
                                                        'new values for the '
                                                        'specified default model '
                                                        'settings.',
                                         'properties': {'Params': {'$ref': '#/definitions/SetModelDefaults'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'UnsetModelDefaults': {'description': 'UnsetModelDefaults '
                                                          'removes the specified '
                                                          'default model settings.',
                                           'properties': {'Params': {'$ref': '#/definitions/UnsetModelDefaults'},
                                                          'Result': {'$ref': '#/definitions/ErrorResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ChangeModelCredential(self, model_credentials=None):
        '''
        ChangeModelCredentials changes cloud credential reference for models.
        These new cloud credentials must already exist on the controller.

        model_credentials : typing.Sequence[~ChangeModelCredentialParams]
        Returns -> ErrorResults
        '''
        if model_credentials is not None and not isinstance(model_credentials, (bytes, str, list)):
            raise Exception("Expected model_credentials to be a Sequence, received: {}".format(type(model_credentials)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ChangeModelCredential',
                   version=8,
                   params=_params)
        _params['model-credentials'] = model_credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfo)
    async def CreateModel(self, cloud_tag=None, config=None, credential=None, name=None, owner_tag=None, region=None):
        '''
        CreateModel creates a new model using the account and
        model config specified in the args.

        cloud_tag : str
        config : typing.Mapping[str, typing.Any]
        credential : str
        name : str
        owner_tag : str
        region : str
        Returns -> ModelInfo
        '''
        if cloud_tag is not None and not isinstance(cloud_tag, (bytes, str)):
            raise Exception("Expected cloud_tag to be a str, received: {}".format(type(cloud_tag)))

        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        if credential is not None and not isinstance(credential, (bytes, str)):
            raise Exception("Expected credential to be a str, received: {}".format(type(credential)))

        if name is not None and not isinstance(name, (bytes, str)):
            raise Exception("Expected name to be a str, received: {}".format(type(name)))

        if owner_tag is not None and not isinstance(owner_tag, (bytes, str)):
            raise Exception("Expected owner_tag to be a str, received: {}".format(type(owner_tag)))

        if region is not None and not isinstance(region, (bytes, str)):
            raise Exception("Expected region to be a str, received: {}".format(type(region)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='CreateModel',
                   version=8,
                   params=_params)
        _params['cloud-tag'] = cloud_tag
        _params['config'] = config
        _params['credential'] = credential
        _params['name'] = name
        _params['owner-tag'] = owner_tag
        _params['region'] = region
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyModels(self, models=None):
        '''
        DestroyModels will try to destroy the specified models.
        If there is a block on destruction, this method will return an error.
        From ModelManager v7 onwards, DestroyModels gains 'force' and 'max-wait' parameters.

        models : typing.Sequence[~DestroyModelParams]
        Returns -> ErrorResults
        '''
        if models is not None and not isinstance(models, (bytes, str, list)):
            raise Exception("Expected models to be a Sequence, received: {}".format(type(models)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DestroyModels',
                   version=8,
                   params=_params)
        _params['models'] = models
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def DumpModels(self, entities=None, simplified=None):
        '''
        DumpModels will export the models into the database agnostic
        representation. The user needs to either be a controller admin, or have
        admin privileges on the model itself.

        entities : typing.Sequence[~Entity]
        simplified : bool
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        if simplified is not None and not isinstance(simplified, bool):
            raise Exception("Expected simplified to be a bool, received: {}".format(type(simplified)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModels',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        _params['simplified'] = simplified
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MapResults)
    async def DumpModelsDB(self, entities=None):
        '''
        DumpModelsDB will gather all documents from all model collections
        for the specified model. The map result contains a map of collection
        names to lists of documents represented as maps.

        entities : typing.Sequence[~Entity]
        Returns -> MapResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModelsDB',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelSummaryResults)
    async def ListModelSummaries(self, all_=None, user_tag=None):
        '''
        ListModelSummaries returns models that the specified user
        has access to in the current server.  Controller admins (superuser)
        can list models for any user.  Other users
        can only ask about their own models.

        all_ : bool
        user_tag : str
        Returns -> ModelSummaryResults
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        if user_tag is not None and not isinstance(user_tag, (bytes, str)):
            raise Exception("Expected user_tag to be a str, received: {}".format(type(user_tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ListModelSummaries',
                   version=8,
                   params=_params)
        _params['all'] = all_
        _params['user-tag'] = user_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserModelList)
    async def ListModels(self, tag=None):
        '''
        ListModels returns the models that the specified user
        has access to in the current server.  Controller admins (superuser)
        can list models for any user.  Other users
        can only ask about their own models.

        tag : str
        Returns -> UserModelList
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ListModels',
                   version=8,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelDefaultsResults)
    async def ModelDefaultsForClouds(self, entities=None):
        '''
        ModelDefaults returns the default config values for the specified clouds.

        entities : typing.Sequence[~Entity]
        Returns -> ModelDefaultsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelDefaultsForClouds',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfoResults)
    async def ModelInfo(self, entities=None):
        '''
        ModelInfo returns information about the specified models.

        entities : typing.Sequence[~Entity]
        Returns -> ModelInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelInfo',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities=None):
        '''
        ModelStatus returns a summary of the model.

        entities : typing.Sequence[~Entity]
        Returns -> ModelStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelStatus',
                   version=8,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyModelAccess(self, changes=None):
        '''
        ModifyModelAccess changes the model access granted to users.

        changes : typing.Sequence[~ModifyModelAccess]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModifyModelAccess',
                   version=8,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModelDefaults(self, config=None):
        '''
        SetModelDefaults writes new values for the specified default model settings.

        config : typing.Sequence[~ModelDefaultValues]
        Returns -> ErrorResults
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='SetModelDefaults',
                   version=8,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UnsetModelDefaults(self, keys=None):
        '''
        UnsetModelDefaults removes the specified default model settings.

        keys : typing.Sequence[~ModelUnsetKeys]
        Returns -> ErrorResults
        '''
        if keys is not None and not isinstance(keys, (bytes, str, list)):
            raise Exception("Expected keys to be a Sequence, received: {}".format(type(keys)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='UnsetModelDefaults',
                   version=8,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply


