# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client.facade import Type, ReturnMapping
from juju.client._definitions import *


class CloudFacade(Type):
    name = 'Cloud'
    version = 7
    schema =     {'definitions': {'AddCloudArgs': {'additionalProperties': False,
                                      'properties': {'cloud': {'$ref': '#/definitions/Cloud'},
                                                     'force': {'type': 'boolean'},
                                                     'name': {'type': 'string'}},
                                      'required': ['cloud', 'name'],
                                      'type': 'object'},
                     'Cloud': {'additionalProperties': False,
                               'properties': {'auth-types': {'items': {'type': 'string'},
                                                             'type': 'array'},
                                              'ca-certificates': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                      'type': 'object'}},
                                                         'type': 'object'},
                                              'endpoint': {'type': 'string'},
                                              'host-cloud-region': {'type': 'string'},
                                              'identity-endpoint': {'type': 'string'},
                                              'region-config': {'patternProperties': {'.*': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                          'type': 'object'}},
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                              'regions': {'items': {'$ref': '#/definitions/CloudRegion'},
                                                          'type': 'array'},
                                              'storage-endpoint': {'type': 'string'},
                                              'type': {'type': 'string'}},
                               'required': ['type'],
                               'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudCredentialArg': {'additionalProperties': False,
                                            'properties': {'cloud-name': {'type': 'string'},
                                                           'credential-name': {'type': 'string'}},
                                            'required': ['cloud-name',
                                                         'credential-name'],
                                            'type': 'object'},
                     'CloudCredentialArgs': {'additionalProperties': False,
                                             'properties': {'credentials': {'items': {'$ref': '#/definitions/CloudCredentialArg'},
                                                                            'type': 'array'},
                                                            'include-secrets': {'type': 'boolean'}},
                                             'required': ['include-secrets'],
                                             'type': 'object'},
                     'CloudCredentialResult': {'additionalProperties': False,
                                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                                              'result': {'$ref': '#/definitions/CloudCredential'}},
                                               'type': 'object'},
                     'CloudCredentialResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/CloudCredentialResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'CloudDetails': {'additionalProperties': False,
                                      'properties': {'auth-types': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                     'endpoint': {'type': 'string'},
                                                     'identity-endpoint': {'type': 'string'},
                                                     'regions': {'items': {'$ref': '#/definitions/CloudRegion'},
                                                                 'type': 'array'},
                                                     'storage-endpoint': {'type': 'string'},
                                                     'type': {'type': 'string'}},
                                      'required': ['type'],
                                      'type': 'object'},
                     'CloudInfo': {'additionalProperties': False,
                                   'properties': {'CloudDetails': {'$ref': '#/definitions/CloudDetails'},
                                                  'users': {'items': {'$ref': '#/definitions/CloudUserInfo'},
                                                            'type': 'array'}},
                                   'required': ['CloudDetails', 'users'],
                                   'type': 'object'},
                     'CloudInfoResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudInfo'}},
                                         'type': 'object'},
                     'CloudInfoResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudInfoResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'CloudInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'cloud-tag': {'type': 'string'},
                                                                     'constraints': {'$ref': '#/definitions/Value'},
                                                                     'region': {'type': 'string'}},
                                                      'required': ['cloud-tag',
                                                                   'region'],
                                                      'type': 'object'},
                     'CloudInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/CloudInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'CloudRegion': {'additionalProperties': False,
                                     'properties': {'endpoint': {'type': 'string'},
                                                    'identity-endpoint': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'storage-endpoint': {'type': 'string'}},
                                     'required': ['name'],
                                     'type': 'object'},
                     'CloudResult': {'additionalProperties': False,
                                     'properties': {'cloud': {'$ref': '#/definitions/Cloud'},
                                                    'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'CloudResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/CloudResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'CloudUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'access'],
                                       'type': 'object'},
                     'CloudsResult': {'additionalProperties': False,
                                      'properties': {'clouds': {'patternProperties': {'.*': {'$ref': '#/definitions/Cloud'}},
                                                                'type': 'object'}},
                                      'type': 'object'},
                     'ControllerCredentialInfo': {'additionalProperties': False,
                                                  'properties': {'content': {'$ref': '#/definitions/CredentialContent'},
                                                                 'models': {'items': {'$ref': '#/definitions/ModelAccess'},
                                                                            'type': 'array'}},
                                                  'type': 'object'},
                     'CredentialContent': {'additionalProperties': False,
                                           'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                    'type': 'object'},
                                                          'auth-type': {'type': 'string'},
                                                          'cloud': {'type': 'string'},
                                                          'name': {'type': 'string'},
                                                          'valid': {'type': 'boolean'}},
                                           'required': ['name',
                                                        'cloud',
                                                        'auth-type'],
                                           'type': 'object'},
                     'CredentialContentResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/ControllerCredentialInfo'}},
                                                 'type': 'object'},
                     'CredentialContentResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/CredentialContentResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ListCloudInfo': {'additionalProperties': False,
                                       'properties': {'CloudDetails': {'$ref': '#/definitions/CloudDetails'},
                                                      'user-access': {'type': 'string'}},
                                       'required': ['CloudDetails', 'user-access'],
                                       'type': 'object'},
                     'ListCloudInfoResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ListCloudInfo'}},
                                             'type': 'object'},
                     'ListCloudInfoResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ListCloudInfoResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ListCloudsRequest': {'additionalProperties': False,
                                           'properties': {'all': {'type': 'boolean'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag'],
                                           'type': 'object'},
                     'ModelAccess': {'additionalProperties': False,
                                     'properties': {'access': {'type': 'string'},
                                                    'model': {'type': 'string'}},
                                     'type': 'object'},
                     'ModifyCloudAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'cloud-tag': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'cloud-tag',
                                                        'action',
                                                        'access'],
                                           'type': 'object'},
                     'ModifyCloudAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyCloudAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'RevokeCredentialArg': {'additionalProperties': False,
                                             'properties': {'force': {'type': 'boolean'},
                                                            'tag': {'type': 'string'}},
                                             'required': ['tag', 'force'],
                                             'type': 'object'},
                     'RevokeCredentialArgs': {'additionalProperties': False,
                                              'properties': {'credentials': {'items': {'$ref': '#/definitions/RevokeCredentialArg'},
                                                                             'type': 'array'}},
                                              'required': ['credentials'],
                                              'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'TaggedCredential': {'additionalProperties': False,
                                          'properties': {'credential': {'$ref': '#/definitions/CloudCredential'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'credential'],
                                          'type': 'object'},
                     'TaggedCredentials': {'additionalProperties': False,
                                           'properties': {'credentials': {'items': {'$ref': '#/definitions/TaggedCredential'},
                                                                          'type': 'array'}},
                                           'type': 'object'},
                     'UpdateCloudArgs': {'additionalProperties': False,
                                         'properties': {'clouds': {'items': {'$ref': '#/definitions/AddCloudArgs'},
                                                                   'type': 'array'}},
                                         'required': ['clouds'],
                                         'type': 'object'},
                     'UpdateCredentialArgs': {'additionalProperties': False,
                                              'properties': {'credentials': {'items': {'$ref': '#/definitions/TaggedCredential'},
                                                                             'type': 'array'},
                                                             'force': {'type': 'boolean'}},
                                              'required': ['credentials', 'force'],
                                              'type': 'object'},
                     'UpdateCredentialModelResult': {'additionalProperties': False,
                                                     'properties': {'errors': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                               'type': 'array'},
                                                                    'name': {'type': 'string'},
                                                                    'uuid': {'type': 'string'}},
                                                     'required': ['uuid', 'name'],
                                                     'type': 'object'},
                     'UpdateCredentialResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'models': {'items': {'$ref': '#/definitions/UpdateCredentialModelResult'},
                                                                          'type': 'array'},
                                                               'tag': {'type': 'string'}},
                                                'required': ['tag'],
                                                'type': 'object'},
                     'UpdateCredentialResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/UpdateCredentialResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'UserCloud': {'additionalProperties': False,
                                   'properties': {'cloud-tag': {'type': 'string'},
                                                  'user-tag': {'type': 'string'}},
                                   'required': ['user-tag', 'cloud-tag'],
                                   'type': 'object'},
                     'UserClouds': {'additionalProperties': False,
                                    'properties': {'user-clouds': {'items': {'$ref': '#/definitions/UserCloud'},
                                                                   'type': 'array'}},
                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'AddCloud': {'description': 'AddCloud adds a new cloud, '
                                                'different from the one managed by '
                                                'the controller.',
                                 'properties': {'Params': {'$ref': '#/definitions/AddCloudArgs'}},
                                 'type': 'object'},
                    'AddCredentials': {'description': 'AddCredentials adds new '
                                                      'credentials.\n'
                                                      'In contrast to '
                                                      'UpdateCredentials() below, '
                                                      'the new credentials can be\n'
                                                      'for a cloud that the '
                                                      'controller does not manage '
                                                      '(this is required\n'
                                                      'for CAAS models)',
                                       'properties': {'Params': {'$ref': '#/definitions/TaggedCredentials'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'CheckCredentialsModels': {'description': 'CheckCredentialsModels '
                                                              'validates supplied '
                                                              "cloud credentials' "
                                                              'content against\n'
                                                              'models that '
                                                              'currently use these '
                                                              'credentials.\n'
                                                              'If there are any '
                                                              'models that are '
                                                              'using a credential '
                                                              'and these models or '
                                                              'their\n'
                                                              'cloud instances are '
                                                              'not going to be '
                                                              'accessible with '
                                                              'corresponding '
                                                              'credential,\n'
                                                              'there will be '
                                                              'detailed validation '
                                                              'errors per model.\n'
                                                              "There's no Juju API "
                                                              'client which uses '
                                                              'this, but JAAS '
                                                              'does,',
                                               'properties': {'Params': {'$ref': '#/definitions/TaggedCredentials'},
                                                              'Result': {'$ref': '#/definitions/UpdateCredentialResults'}},
                                               'type': 'object'},
                    'Cloud': {'description': 'Cloud returns the cloud definitions '
                                             'for the specified clouds.',
                              'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/CloudResults'}},
                              'type': 'object'},
                    'CloudInfo': {'description': 'CloudInfo returns information '
                                                 'about the specified clouds.',
                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudInfoResults'}},
                                  'type': 'object'},
                    'Clouds': {'description': 'Clouds returns the definitions of '
                                              'all clouds supported by the '
                                              'controller\n'
                                              'that the logged in user can see.',
                               'properties': {'Result': {'$ref': '#/definitions/CloudsResult'}},
                               'type': 'object'},
                    'Credential': {'description': 'Credential returns the '
                                                  'specified cloud credential for '
                                                  'each tag, minus secrets.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/CloudCredentialResults'}},
                                   'type': 'object'},
                    'CredentialContents': {'description': 'CredentialContents '
                                                          'returns the specified '
                                                          'cloud credentials,\n'
                                                          'including the secrets '
                                                          'if requested.\n'
                                                          'If no specific '
                                                          'credential name/cloud '
                                                          'was passed in, all '
                                                          'credentials for this '
                                                          'user\n'
                                                          'are returned.\n'
                                                          'Only credential owner '
                                                          'can see its contents as '
                                                          'well as what models use '
                                                          'it.\n'
                                                          'Controller admin has no '
                                                          'special superpowers '
                                                          'here and is treated the '
                                                          'same as all other '
                                                          'users.',
                                           'properties': {'Params': {'$ref': '#/definitions/CloudCredentialArgs'},
                                                          'Result': {'$ref': '#/definitions/CredentialContentResults'}},
                                           'type': 'object'},
                    'InstanceTypes': {'description': 'InstanceTypes returns '
                                                     'instance type information '
                                                     'for the cloud and region\n'
                                                     'in which the current model '
                                                     'is deployed.',
                                      'properties': {'Params': {'$ref': '#/definitions/CloudInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'},
                    'ListCloudInfo': {'description': 'ListCloudInfo returns clouds '
                                                     'that the specified user has '
                                                     'access to.\n'
                                                     'Controller admins '
                                                     '(superuser) can list clouds '
                                                     'for any user.\n'
                                                     'Other users can only ask '
                                                     'about their own clouds.',
                                      'properties': {'Params': {'$ref': '#/definitions/ListCloudsRequest'},
                                                     'Result': {'$ref': '#/definitions/ListCloudInfoResults'}},
                                      'type': 'object'},
                    'ModifyCloudAccess': {'description': 'ModifyCloudAccess '
                                                         'changes the model access '
                                                         'granted to users.',
                                          'properties': {'Params': {'$ref': '#/definitions/ModifyCloudAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'RemoveClouds': {'description': 'RemoveClouds removes the '
                                                    'specified clouds from the '
                                                    'controller.\n'
                                                    'If a cloud is in use (has '
                                                    'models deployed to it), the '
                                                    'removal will fail.',
                                     'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'RevokeCredentialsCheckModels': {'description': 'RevokeCredentialsCheckModels '
                                                                    'revokes a set '
                                                                    'of cloud '
                                                                    'credentials.\n'
                                                                    'If the '
                                                                    'credentials '
                                                                    'are used by '
                                                                    'any of the '
                                                                    'models, the '
                                                                    'credential '
                                                                    'deletion will '
                                                                    'be aborted.\n'
                                                                    'If '
                                                                    'credential-in-use '
                                                                    'needs to be '
                                                                    'revoked '
                                                                    'nonetheless, '
                                                                    'this method '
                                                                    'allows the '
                                                                    'use of force.',
                                                     'properties': {'Params': {'$ref': '#/definitions/RevokeCredentialArgs'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                     'type': 'object'},
                    'UpdateCloud': {'description': 'UpdateCloud updates an '
                                                   'existing cloud that the '
                                                   'controller knows about.',
                                    'properties': {'Params': {'$ref': '#/definitions/UpdateCloudArgs'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'UpdateCredentialsCheckModels': {'description': 'UpdateCredentialsCheckModels '
                                                                    'updates a set '
                                                                    'of cloud '
                                                                    "credentials' "
                                                                    'content.\n'
                                                                    'If there are '
                                                                    'any models '
                                                                    'that are '
                                                                    'using a '
                                                                    'credential '
                                                                    'and these '
                                                                    'models\n'
                                                                    'are not going '
                                                                    'to be visible '
                                                                    'with updated '
                                                                    'credential '
                                                                    'content,\n'
                                                                    'there will be '
                                                                    'detailed '
                                                                    'validation '
                                                                    'errors per '
                                                                    'model.  Such '
                                                                    'model errors '
                                                                    'are returned\n'
                                                                    'separately '
                                                                    'and do not '
                                                                    'contribute to '
                                                                    'the overall '
                                                                    'method error '
                                                                    'status.\n'
                                                                    'Controller '
                                                                    'admins can '
                                                                    "'force' an "
                                                                    'update of the '
                                                                    'credential\n'
                                                                    'regardless of '
                                                                    'whether it is '
                                                                    'deemed valid '
                                                                    'or not.',
                                                     'properties': {'Params': {'$ref': '#/definitions/UpdateCredentialArgs'},
                                                                    'Result': {'$ref': '#/definitions/UpdateCredentialResults'}},
                                                     'type': 'object'},
                    'UserCredentials': {'description': 'UserCredentials returns '
                                                       'the cloud credentials for '
                                                       'a set of users.',
                                        'properties': {'Params': {'$ref': '#/definitions/UserClouds'},
                                                       'Result': {'$ref': '#/definitions/StringsResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def AddCloud(self, cloud=None, force=None, name=None):
        '''
        AddCloud adds a new cloud, different from the one managed by the controller.

        cloud : Cloud
        force : bool
        name : str
        Returns -> None
        '''
        if cloud is not None and not isinstance(cloud, (dict, Cloud)):
            raise Exception("Expected cloud to be a Cloud, received: {}".format(type(cloud)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if name is not None and not isinstance(name, (bytes, str)):
            raise Exception("Expected name to be a str, received: {}".format(type(name)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='AddCloud',
                   version=7,
                   params=_params)
        _params['cloud'] = cloud
        _params['force'] = force
        _params['name'] = name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def AddCredentials(self, credentials=None):
        '''
        AddCredentials adds new credentials.
        In contrast to UpdateCredentials() below, the new credentials can be
        for a cloud that the controller does not manage (this is required
        for CAAS models)

        credentials : typing.Sequence[~TaggedCredential]
        Returns -> ErrorResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='AddCredentials',
                   version=7,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpdateCredentialResults)
    async def CheckCredentialsModels(self, credentials=None):
        '''
        CheckCredentialsModels validates supplied cloud credentials' content against
        models that currently use these credentials.
        If there are any models that are using a credential and these models or their
        cloud instances are not going to be accessible with corresponding credential,
        there will be detailed validation errors per model.
        There's no Juju API client which uses this, but JAAS does,

        credentials : typing.Sequence[~TaggedCredential]
        Returns -> UpdateCredentialResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='CheckCredentialsModels',
                   version=7,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudResults)
    async def Cloud(self, entities=None):
        '''
        Cloud returns the cloud definitions for the specified clouds.

        entities : typing.Sequence[~Entity]
        Returns -> CloudResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Cloud',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudInfoResults)
    async def CloudInfo(self, entities=None):
        '''
        CloudInfo returns information about the specified clouds.

        entities : typing.Sequence[~Entity]
        Returns -> CloudInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='CloudInfo',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudsResult)
    async def Clouds(self):
        '''
        Clouds returns the definitions of all clouds supported by the controller
        that the logged in user can see.


        Returns -> CloudsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Clouds',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudCredentialResults)
    async def Credential(self, entities=None):
        '''
        Credential returns the specified cloud credential for each tag, minus secrets.

        entities : typing.Sequence[~Entity]
        Returns -> CloudCredentialResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Credential',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CredentialContentResults)
    async def CredentialContents(self, credentials=None, include_secrets=None):
        '''
        CredentialContents returns the specified cloud credentials,
        including the secrets if requested.
        If no specific credential name/cloud was passed in, all credentials for this user
        are returned.
        Only credential owner can see its contents as well as what models use it.
        Controller admin has no special superpowers here and is treated the same as all other users.

        credentials : typing.Sequence[~CloudCredentialArg]
        include_secrets : bool
        Returns -> CredentialContentResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        if include_secrets is not None and not isinstance(include_secrets, bool):
            raise Exception("Expected include_secrets to be a bool, received: {}".format(type(include_secrets)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='CredentialContents',
                   version=7,
                   params=_params)
        _params['credentials'] = credentials
        _params['include-secrets'] = include_secrets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints=None):
        '''
        InstanceTypes returns instance type information for the cloud and region
        in which the current model is deployed.

        constraints : typing.Sequence[~CloudInstanceTypesConstraint]
        Returns -> InstanceTypesResults
        '''
        if constraints is not None and not isinstance(constraints, (bytes, str, list)):
            raise Exception("Expected constraints to be a Sequence, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='InstanceTypes',
                   version=7,
                   params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListCloudInfoResults)
    async def ListCloudInfo(self, all_=None, user_tag=None):
        '''
        ListCloudInfo returns clouds that the specified user has access to.
        Controller admins (superuser) can list clouds for any user.
        Other users can only ask about their own clouds.

        all_ : bool
        user_tag : str
        Returns -> ListCloudInfoResults
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        if user_tag is not None and not isinstance(user_tag, (bytes, str)):
            raise Exception("Expected user_tag to be a str, received: {}".format(type(user_tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='ListCloudInfo',
                   version=7,
                   params=_params)
        _params['all'] = all_
        _params['user-tag'] = user_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyCloudAccess(self, changes=None):
        '''
        ModifyCloudAccess changes the model access granted to users.

        changes : typing.Sequence[~ModifyCloudAccess]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='ModifyCloudAccess',
                   version=7,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveClouds(self, entities=None):
        '''
        RemoveClouds removes the specified clouds from the controller.
        If a cloud is in use (has models deployed to it), the removal will fail.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='RemoveClouds',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RevokeCredentialsCheckModels(self, credentials=None):
        '''
        RevokeCredentialsCheckModels revokes a set of cloud credentials.
        If the credentials are used by any of the models, the credential deletion will be aborted.
        If credential-in-use needs to be revoked nonetheless, this method allows the use of force.

        credentials : typing.Sequence[~RevokeCredentialArg]
        Returns -> ErrorResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='RevokeCredentialsCheckModels',
                   version=7,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateCloud(self, clouds=None):
        '''
        UpdateCloud updates an existing cloud that the controller knows about.

        clouds : typing.Sequence[~AddCloudArgs]
        Returns -> ErrorResults
        '''
        if clouds is not None and not isinstance(clouds, (bytes, str, list)):
            raise Exception("Expected clouds to be a Sequence, received: {}".format(type(clouds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UpdateCloud',
                   version=7,
                   params=_params)
        _params['clouds'] = clouds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpdateCredentialResults)
    async def UpdateCredentialsCheckModels(self, credentials=None, force=None):
        '''
        UpdateCredentialsCheckModels updates a set of cloud credentials' content.
        If there are any models that are using a credential and these models
        are not going to be visible with updated credential content,
        there will be detailed validation errors per model.  Such model errors are returned
        separately and do not contribute to the overall method error status.
        Controller admins can 'force' an update of the credential
        regardless of whether it is deemed valid or not.

        credentials : typing.Sequence[~TaggedCredential]
        force : bool
        Returns -> UpdateCredentialResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UpdateCredentialsCheckModels',
                   version=7,
                   params=_params)
        _params['credentials'] = credentials
        _params['force'] = force
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def UserCredentials(self, user_clouds=None):
        '''
        UserCredentials returns the cloud credentials for a set of users.

        user_clouds : typing.Sequence[~UserCloud]
        Returns -> StringsResults
        '''
        if user_clouds is not None and not isinstance(user_clouds, (bytes, str, list)):
            raise Exception("Expected user_clouds to be a Sequence, received: {}".format(type(user_clouds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UserCredentials',
                   version=7,
                   params=_params)
        _params['user-clouds'] = user_clouds
        reply = await self.rpc(msg)
        return reply



class ControllerFacade(Type):
    name = 'Controller'
    version = 7
    schema =     {'definitions': {'AllWatcherId': {'additionalProperties': False,
                                      'properties': {'watcher-id': {'type': 'string'}},
                                      'required': ['watcher-id'],
                                      'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'cacertificates': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                  'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'CloudSpecResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudSpecResult'},
                                                                     'type': 'array'}},
                                          'type': 'object'},
                     'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'ControllerConfigSet': {'additionalProperties': False,
                                             'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                    'type': 'object'}},
                                                                       'type': 'object'}},
                                             'required': ['config'],
                                             'type': 'object'},
                     'DestroyControllerArgs': {'additionalProperties': False,
                                               'properties': {'destroy-models': {'type': 'boolean'},
                                                              'destroy-storage': {'type': 'boolean'}},
                                               'required': ['destroy-models'],
                                               'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostedModelConfig': {'additionalProperties': False,
                                           'properties': {'cloud-spec': {'$ref': '#/definitions/CloudSpec'},
                                                          'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'name': {'type': 'string'},
                                                          'owner': {'type': 'string'}},
                                           'required': ['name', 'owner'],
                                           'type': 'object'},
                     'HostedModelConfigsResults': {'additionalProperties': False,
                                                   'properties': {'models': {'items': {'$ref': '#/definitions/HostedModelConfig'},
                                                                             'type': 'array'}},
                                                   'required': ['models'],
                                                   'type': 'object'},
                     'InitiateMigrationArgs': {'additionalProperties': False,
                                               'properties': {'specs': {'items': {'$ref': '#/definitions/MigrationSpec'},
                                                                        'type': 'array'}},
                                               'required': ['specs'],
                                               'type': 'object'},
                     'InitiateMigrationResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'migration-id': {'type': 'string'},
                                                                'model-tag': {'type': 'string'}},
                                                 'required': ['model-tag',
                                                              'migration-id'],
                                                 'type': 'object'},
                     'InitiateMigrationResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/InitiateMigrationResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MigrationSpec': {'additionalProperties': False,
                                       'properties': {'model-tag': {'type': 'string'},
                                                      'target-info': {'$ref': '#/definitions/MigrationTargetInfo'}},
                                       'required': ['model-tag', 'target-info'],
                                       'type': 'object'},
                     'MigrationTargetInfo': {'additionalProperties': False,
                                             'properties': {'addrs': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                            'auth-tag': {'type': 'string'},
                                                            'ca-cert': {'type': 'string'},
                                                            'controller-alias': {'type': 'string'},
                                                            'controller-tag': {'type': 'string'},
                                                            'macaroons': {'type': 'string'},
                                                            'password': {'type': 'string'}},
                                             'required': ['controller-tag',
                                                          'addrs',
                                                          'ca-cert',
                                                          'auth-tag'],
                                             'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'type': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'type', 'owner-tag'],
                               'type': 'object'},
                     'ModelBlockInfo': {'additionalProperties': False,
                                        'properties': {'blocks': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                       'model-uuid': {'type': 'string'},
                                                       'name': {'type': 'string'},
                                                       'owner-tag': {'type': 'string'}},
                                        'required': ['name',
                                                     'model-uuid',
                                                     'owner-tag',
                                                     'blocks'],
                                        'type': 'object'},
                     'ModelBlockInfoList': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelBlockInfo'},
                                                                      'type': 'array'}},
                                            'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelFilesystemInfo': {'additionalProperties': False,
                                             'properties': {'detachable': {'type': 'boolean'},
                                                            'id': {'type': 'string'},
                                                            'message': {'type': 'string'},
                                                            'provider-id': {'type': 'string'},
                                                            'status': {'type': 'string'}},
                                             'required': ['id'],
                                             'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'display-name': {'type': 'string'},
                                                         'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'message': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'filesystems': {'items': {'$ref': '#/definitions/ModelFilesystemInfo'},
                                                                    'type': 'array'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'},
                                                    'type': {'type': 'string'},
                                                    'unit-count': {'type': 'integer'},
                                                    'volumes': {'items': {'$ref': '#/definitions/ModelVolumeInfo'},
                                                                'type': 'array'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'type',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'unit-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelTag': {'additionalProperties': False, 'type': 'object'},
                     'ModelVolumeInfo': {'additionalProperties': False,
                                         'properties': {'detachable': {'type': 'boolean'},
                                                        'id': {'type': 'string'},
                                                        'message': {'type': 'string'},
                                                        'provider-id': {'type': 'string'},
                                                        'status': {'type': 'string'}},
                                         'required': ['id'],
                                         'type': 'object'},
                     'ModifyControllerAccess': {'additionalProperties': False,
                                                'properties': {'access': {'type': 'string'},
                                                               'action': {'type': 'string'},
                                                               'user-tag': {'type': 'string'}},
                                                'required': ['user-tag',
                                                             'action',
                                                             'access'],
                                                'type': 'object'},
                     'ModifyControllerAccessRequest': {'additionalProperties': False,
                                                       'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyControllerAccess'},
                                                                                  'type': 'array'}},
                                                       'required': ['changes'],
                                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'RemoveBlocksArgs': {'additionalProperties': False,
                                          'properties': {'all': {'type': 'boolean'}},
                                          'required': ['all'],
                                          'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'UserAccess': {'additionalProperties': False,
                                    'properties': {'access': {'type': 'string'},
                                                   'user-tag': {'type': 'string'}},
                                    'required': ['user-tag', 'access'],
                                    'type': 'object'},
                     'UserAccessResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/UserAccess'}},
                                          'type': 'object'},
                     'UserAccessResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/UserAccessResult'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'AllModels': {'properties': {'Result': {'$ref': '#/definitions/UserModelList'}},
                                  'type': 'object'},
                    'CloudSpec': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudSpecResults'}},
                                  'type': 'object'},
                    'ConfigSet': {'properties': {'Params': {'$ref': '#/definitions/ControllerConfigSet'}},
                                  'type': 'object'},
                    'ControllerAPIInfoForModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'DestroyController': {'properties': {'Params': {'$ref': '#/definitions/DestroyControllerArgs'}},
                                          'type': 'object'},
                    'GetCloudSpec': {'properties': {'Params': {'$ref': '#/definitions/ModelTag'},
                                                    'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                     'type': 'object'},
                    'GetControllerAccess': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/UserAccessResults'}},
                                            'type': 'object'},
                    'HostedModelConfigs': {'properties': {'Result': {'$ref': '#/definitions/HostedModelConfigsResults'}},
                                           'type': 'object'},
                    'IdentityProviderURL': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                            'type': 'object'},
                    'InitiateMigration': {'properties': {'Params': {'$ref': '#/definitions/InitiateMigrationArgs'},
                                                         'Result': {'$ref': '#/definitions/InitiateMigrationResults'}},
                                          'type': 'object'},
                    'ListBlockedModels': {'properties': {'Result': {'$ref': '#/definitions/ModelBlockInfoList'}},
                                          'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                    'type': 'object'},
                    'ModelStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyControllerAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyControllerAccessRequest'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'MongoVersion': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'RemoveBlocks': {'properties': {'Params': {'$ref': '#/definitions/RemoveBlocksArgs'}},
                                     'type': 'object'},
                    'WatchAllModels': {'properties': {'Result': {'$ref': '#/definitions/AllWatcherId'}},
                                       'type': 'object'},
                    'WatchCloudSpecsChanges': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(UserModelList)
    async def AllModels(self):
        '''

        Returns -> UserModelList
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='AllModels',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResults)
    async def CloudSpec(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> CloudSpecResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='CloudSpec',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ConfigSet(self, config=None):
        '''
        config : typing.Mapping[str, typing.Any]
        Returns -> None
        '''
        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ConfigSet',
                   version=7,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ControllerAPIInfoForModels',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ControllerConfig',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyController(self, destroy_models=None, destroy_storage=None):
        '''
        destroy_models : bool
        destroy_storage : bool
        Returns -> None
        '''
        if destroy_models is not None and not isinstance(destroy_models, bool):
            raise Exception("Expected destroy_models to be a bool, received: {}".format(type(destroy_models)))

        if destroy_storage is not None and not isinstance(destroy_storage, bool):
            raise Exception("Expected destroy_storage to be a bool, received: {}".format(type(destroy_storage)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='DestroyController',
                   version=7,
                   params=_params)
        _params['destroy-models'] = destroy_models
        _params['destroy-storage'] = destroy_storage
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def GetCloudSpec(self):
        '''

        Returns -> CloudSpecResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='GetCloudSpec',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserAccessResults)
    async def GetControllerAccess(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> UserAccessResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='GetControllerAccess',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(HostedModelConfigsResults)
    async def HostedModelConfigs(self):
        '''

        Returns -> HostedModelConfigsResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='HostedModelConfigs',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def IdentityProviderURL(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='IdentityProviderURL',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InitiateMigrationResults)
    async def InitiateMigration(self, specs=None):
        '''
        specs : typing.Sequence[~MigrationSpec]
        Returns -> InitiateMigrationResults
        '''
        if specs is not None and not isinstance(specs, (bytes, str, list)):
            raise Exception("Expected specs to be a Sequence, received: {}".format(type(specs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='InitiateMigration',
                   version=7,
                   params=_params)
        _params['specs'] = specs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelBlockInfoList)
    async def ListBlockedModels(self):
        '''

        Returns -> ModelBlockInfoList
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ListBlockedModels',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResults)
    async def ModelConfig(self):
        '''

        Returns -> ModelConfigResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModelConfig',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ModelStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModelStatus',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyControllerAccess(self, changes=None):
        '''
        changes : typing.Sequence[~ModifyControllerAccess]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='ModifyControllerAccess',
                   version=7,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def MongoVersion(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='MongoVersion',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def RemoveBlocks(self, all_=None):
        '''
        all_ : bool
        Returns -> None
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='RemoveBlocks',
                   version=7,
                   params=_params)
        _params['all'] = all_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AllWatcherId)
    async def WatchAllModels(self):
        '''

        Returns -> AllWatcherId
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='WatchAllModels',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchCloudSpecsChanges(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Controller',
                   request='WatchCloudSpecsChanges',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class ModelManagerFacade(Type):
    name = 'ModelManager'
    version = 7
    schema =     {'definitions': {'ChangeModelCredentialParams': {'additionalProperties': False,
                                                     'properties': {'credential-tag': {'type': 'string'},
                                                                    'model-tag': {'type': 'string'}},
                                                     'required': ['model-tag',
                                                                  'credential-tag'],
                                                     'type': 'object'},
                     'ChangeModelCredentialsParams': {'additionalProperties': False,
                                                      'properties': {'model-credentials': {'items': {'$ref': '#/definitions/ChangeModelCredentialParams'},
                                                                                           'type': 'array'}},
                                                      'required': ['model-credentials'],
                                                      'type': 'object'},
                     'DestroyModelParams': {'additionalProperties': False,
                                            'properties': {'destroy-storage': {'type': 'boolean'},
                                                           'force': {'type': 'boolean'},
                                                           'max-wait': {'type': 'integer'},
                                                           'model-tag': {'type': 'string'}},
                                            'required': ['model-tag'],
                                            'type': 'object'},
                     'DestroyModelsParams': {'additionalProperties': False,
                                             'properties': {'models': {'items': {'$ref': '#/definitions/DestroyModelParams'},
                                                                       'type': 'array'}},
                                             'required': ['models'],
                                             'type': 'object'},
                     'DumpModelRequest': {'additionalProperties': False,
                                          'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                      'type': 'array'},
                                                         'simplified': {'type': 'boolean'}},
                                          'required': ['entities', 'simplified'],
                                          'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MapResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                          'type': 'object'}},
                                                             'type': 'object'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'MapResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/MapResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'type': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'type', 'owner-tag'],
                               'type': 'object'},
                     'ModelCreateArgs': {'additionalProperties': False,
                                         'properties': {'cloud-tag': {'type': 'string'},
                                                        'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                'type': 'object'}},
                                                                   'type': 'object'},
                                                        'credential': {'type': 'string'},
                                                        'name': {'type': 'string'},
                                                        'owner-tag': {'type': 'string'},
                                                        'region': {'type': 'string'}},
                                         'required': ['name', 'owner-tag'],
                                         'type': 'object'},
                     'ModelDefaultValues': {'additionalProperties': False,
                                            'properties': {'cloud-region': {'type': 'string'},
                                                           'cloud-tag': {'type': 'string'},
                                                           'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                   'type': 'object'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelDefaults': {'additionalProperties': False,
                                       'properties': {'controller': {'additionalProperties': True,
                                                                     'type': 'object'},
                                                      'default': {'additionalProperties': True,
                                                                  'type': 'object'},
                                                      'regions': {'items': {'$ref': '#/definitions/RegionDefaults'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ModelDefaultsResult': {'additionalProperties': False,
                                             'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ModelDefaults'}},
                                                                       'type': 'object'},
                                                            'error': {'$ref': '#/definitions/Error'}},
                                             'required': ['config'],
                                             'type': 'object'},
                     'ModelDefaultsResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ModelDefaultsResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ModelEntityCount': {'additionalProperties': False,
                                          'properties': {'count': {'type': 'integer'},
                                                         'entity': {'type': 'string'}},
                                          'required': ['entity', 'count'],
                                          'type': 'object'},
                     'ModelFilesystemInfo': {'additionalProperties': False,
                                             'properties': {'detachable': {'type': 'boolean'},
                                                            'id': {'type': 'string'},
                                                            'message': {'type': 'string'},
                                                            'provider-id': {'type': 'string'},
                                                            'status': {'type': 'string'}},
                                             'required': ['id'],
                                             'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'is-controller': {'type': 'boolean'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'type': {'type': 'string'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'type',
                                                'uuid',
                                                'controller-uuid',
                                                'is-controller',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelInfoResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/ModelInfo'}},
                                         'type': 'object'},
                     'ModelInfoResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/ModelInfoResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'display-name': {'type': 'string'},
                                                         'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'message': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'filesystems': {'items': {'$ref': '#/definitions/ModelFilesystemInfo'},
                                                                    'type': 'array'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'},
                                                    'type': {'type': 'string'},
                                                    'unit-count': {'type': 'integer'},
                                                    'volumes': {'items': {'$ref': '#/definitions/ModelVolumeInfo'},
                                                                'type': 'array'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'type',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'unit-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelSummariesRequest': {'additionalProperties': False,
                                               'properties': {'all': {'type': 'boolean'},
                                                              'user-tag': {'type': 'string'}},
                                               'required': ['user-tag'],
                                               'type': 'object'},
                     'ModelSummary': {'additionalProperties': False,
                                      'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                     'cloud-credential-tag': {'type': 'string'},
                                                     'cloud-region': {'type': 'string'},
                                                     'cloud-tag': {'type': 'string'},
                                                     'controller-uuid': {'type': 'string'},
                                                     'counts': {'items': {'$ref': '#/definitions/ModelEntityCount'},
                                                                'type': 'array'},
                                                     'default-series': {'type': 'string'},
                                                     'is-controller': {'type': 'boolean'},
                                                     'last-connection': {'format': 'date-time',
                                                                         'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                     'name': {'type': 'string'},
                                                     'owner-tag': {'type': 'string'},
                                                     'provider-type': {'type': 'string'},
                                                     'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                     'status': {'$ref': '#/definitions/EntityStatus'},
                                                     'type': {'type': 'string'},
                                                     'user-access': {'type': 'string'},
                                                     'uuid': {'type': 'string'}},
                                      'required': ['name',
                                                   'uuid',
                                                   'type',
                                                   'controller-uuid',
                                                   'is-controller',
                                                   'cloud-tag',
                                                   'owner-tag',
                                                   'life',
                                                   'user-access',
                                                   'last-connection',
                                                   'counts',
                                                   'sla',
                                                   'agent-version'],
                                      'type': 'object'},
                     'ModelSummaryResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'result': {'$ref': '#/definitions/ModelSummary'}},
                                            'type': 'object'},
                     'ModelSummaryResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/ModelSummaryResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'ModelUnsetKeys': {'additionalProperties': False,
                                        'properties': {'cloud-region': {'type': 'string'},
                                                       'cloud-tag': {'type': 'string'},
                                                       'keys': {'items': {'type': 'string'},
                                                                'type': 'array'}},
                                        'required': ['keys'],
                                        'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModelVolumeInfo': {'additionalProperties': False,
                                         'properties': {'detachable': {'type': 'boolean'},
                                                        'id': {'type': 'string'},
                                                        'message': {'type': 'string'},
                                                        'provider-id': {'type': 'string'},
                                                        'status': {'type': 'string'}},
                                         'required': ['id'],
                                         'type': 'object'},
                     'ModifyModelAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'model-tag': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'action',
                                                        'access',
                                                        'model-tag'],
                                           'type': 'object'},
                     'ModifyModelAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyModelAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RegionDefaults': {'additionalProperties': False,
                                        'properties': {'region-name': {'type': 'string'},
                                                       'value': {'additionalProperties': True,
                                                                 'type': 'object'}},
                                        'required': ['region-name', 'value'],
                                        'type': 'object'},
                     'SetModelDefaults': {'additionalProperties': False,
                                          'properties': {'config': {'items': {'$ref': '#/definitions/ModelDefaultValues'},
                                                                    'type': 'array'}},
                                          'required': ['config'],
                                          'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'UnsetModelDefaults': {'additionalProperties': False,
                                            'properties': {'keys': {'items': {'$ref': '#/definitions/ModelUnsetKeys'},
                                                                    'type': 'array'}},
                                            'required': ['keys'],
                                            'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'ChangeModelCredential': {'properties': {'Params': {'$ref': '#/definitions/ChangeModelCredentialsParams'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'CreateModel': {'properties': {'Params': {'$ref': '#/definitions/ModelCreateArgs'},
                                                   'Result': {'$ref': '#/definitions/ModelInfo'}},
                                    'type': 'object'},
                    'DestroyModels': {'properties': {'Params': {'$ref': '#/definitions/DestroyModelsParams'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'DumpModels': {'properties': {'Params': {'$ref': '#/definitions/DumpModelRequest'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'DumpModelsDB': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/MapResults'}},
                                     'type': 'object'},
                    'ListModelSummaries': {'properties': {'Params': {'$ref': '#/definitions/ModelSummariesRequest'},
                                                          'Result': {'$ref': '#/definitions/ModelSummaryResults'}},
                                           'type': 'object'},
                    'ListModels': {'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                  'Result': {'$ref': '#/definitions/UserModelList'}},
                                   'type': 'object'},
                    'ModelDefaultsForClouds': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ModelDefaultsResults'}},
                                               'type': 'object'},
                    'ModelInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ModelInfoResults'}},
                                  'type': 'object'},
                    'ModelStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyModelAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyModelAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/SetModelDefaults'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'UnsetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/UnsetModelDefaults'},
                                                          'Result': {'$ref': '#/definitions/ErrorResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ChangeModelCredential(self, model_credentials=None):
        '''
        model_credentials : typing.Sequence[~ChangeModelCredentialParams]
        Returns -> ErrorResults
        '''
        if model_credentials is not None and not isinstance(model_credentials, (bytes, str, list)):
            raise Exception("Expected model_credentials to be a Sequence, received: {}".format(type(model_credentials)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ChangeModelCredential',
                   version=7,
                   params=_params)
        _params['model-credentials'] = model_credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfo)
    async def CreateModel(self, cloud_tag=None, config=None, credential=None, name=None, owner_tag=None, region=None):
        '''
        cloud_tag : str
        config : typing.Mapping[str, typing.Any]
        credential : str
        name : str
        owner_tag : str
        region : str
        Returns -> ModelInfo
        '''
        if cloud_tag is not None and not isinstance(cloud_tag, (bytes, str)):
            raise Exception("Expected cloud_tag to be a str, received: {}".format(type(cloud_tag)))

        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        if credential is not None and not isinstance(credential, (bytes, str)):
            raise Exception("Expected credential to be a str, received: {}".format(type(credential)))

        if name is not None and not isinstance(name, (bytes, str)):
            raise Exception("Expected name to be a str, received: {}".format(type(name)))

        if owner_tag is not None and not isinstance(owner_tag, (bytes, str)):
            raise Exception("Expected owner_tag to be a str, received: {}".format(type(owner_tag)))

        if region is not None and not isinstance(region, (bytes, str)):
            raise Exception("Expected region to be a str, received: {}".format(type(region)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='CreateModel',
                   version=7,
                   params=_params)
        _params['cloud-tag'] = cloud_tag
        _params['config'] = config
        _params['credential'] = credential
        _params['name'] = name
        _params['owner-tag'] = owner_tag
        _params['region'] = region
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyModels(self, models=None):
        '''
        models : typing.Sequence[~DestroyModelParams]
        Returns -> ErrorResults
        '''
        if models is not None and not isinstance(models, (bytes, str, list)):
            raise Exception("Expected models to be a Sequence, received: {}".format(type(models)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DestroyModels',
                   version=7,
                   params=_params)
        _params['models'] = models
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def DumpModels(self, entities=None, simplified=None):
        '''
        entities : typing.Sequence[~Entity]
        simplified : bool
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        if simplified is not None and not isinstance(simplified, bool):
            raise Exception("Expected simplified to be a bool, received: {}".format(type(simplified)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModels',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        _params['simplified'] = simplified
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MapResults)
    async def DumpModelsDB(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MapResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModelsDB',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelSummaryResults)
    async def ListModelSummaries(self, all_=None, user_tag=None):
        '''
        all_ : bool
        user_tag : str
        Returns -> ModelSummaryResults
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        if user_tag is not None and not isinstance(user_tag, (bytes, str)):
            raise Exception("Expected user_tag to be a str, received: {}".format(type(user_tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ListModelSummaries',
                   version=7,
                   params=_params)
        _params['all'] = all_
        _params['user-tag'] = user_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserModelList)
    async def ListModels(self, tag=None):
        '''
        tag : str
        Returns -> UserModelList
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ListModels',
                   version=7,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelDefaultsResults)
    async def ModelDefaultsForClouds(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ModelDefaultsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelDefaultsForClouds',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfoResults)
    async def ModelInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ModelInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelInfo',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ModelStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelStatus',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyModelAccess(self, changes=None):
        '''
        changes : typing.Sequence[~ModifyModelAccess]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModifyModelAccess',
                   version=7,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModelDefaults(self, config=None):
        '''
        config : typing.Sequence[~ModelDefaultValues]
        Returns -> ErrorResults
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='SetModelDefaults',
                   version=7,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UnsetModelDefaults(self, keys=None):
        '''
        keys : typing.Sequence[~ModelUnsetKeys]
        Returns -> ErrorResults
        '''
        if keys is not None and not isinstance(keys, (bytes, str, list)):
            raise Exception("Expected keys to be a Sequence, received: {}".format(type(keys)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='UnsetModelDefaults',
                   version=7,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



class ProvisionerFacade(Type):
    name = 'Provisioner'
    version = 7
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Series': {'type': 'string'}},
                                'required': ['Number', 'Series', 'Arch'],
                                'type': 'object'},
                     'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'CharmLXDProfile': {'additionalProperties': False,
                                         'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'},
                                                        'description': {'type': 'string'},
                                                        'devices': {'patternProperties': {'.*': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'}},
                                         'required': ['config',
                                                      'description',
                                                      'devices'],
                                         'type': 'object'},
                     'CloudImageMetadata': {'additionalProperties': False,
                                            'properties': {'arch': {'type': 'string'},
                                                           'image-id': {'type': 'string'},
                                                           'priority': {'type': 'integer'},
                                                           'region': {'type': 'string'},
                                                           'root-storage-size': {'type': 'integer'},
                                                           'root-storage-type': {'type': 'string'},
                                                           'series': {'type': 'string'},
                                                           'source': {'type': 'string'},
                                                           'stream': {'type': 'string'},
                                                           'version': {'type': 'string'},
                                                           'virt-type': {'type': 'string'}},
                                            'required': ['image-id',
                                                         'region',
                                                         'version',
                                                         'series',
                                                         'arch',
                                                         'source',
                                                         'priority'],
                                            'type': 'object'},
                     'ConstraintsResult': {'additionalProperties': False,
                                           'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['constraints'],
                                           'type': 'object'},
                     'ConstraintsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/ConstraintsResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ContainerConfig': {'additionalProperties': False,
                                         'properties': {'UpdateBehavior': {'$ref': '#/definitions/UpdateBehavior'},
                                                        'apt-mirror': {'type': 'string'},
                                                        'apt-proxy': {'$ref': '#/definitions/Settings'},
                                                        'authorized-keys': {'type': 'string'},
                                                        'cloudinit-userdata': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                            'type': 'object'}},
                                                                               'type': 'object'},
                                                        'container-inherit-properties': {'type': 'string'},
                                                        'juju-proxy': {'$ref': '#/definitions/Settings'},
                                                        'legacy-proxy': {'$ref': '#/definitions/Settings'},
                                                        'provider-type': {'type': 'string'},
                                                        'snap-proxy': {'$ref': '#/definitions/Settings'},
                                                        'ssl-hostname-verification': {'type': 'boolean'}},
                                         'required': ['provider-type',
                                                      'authorized-keys',
                                                      'ssl-hostname-verification',
                                                      'legacy-proxy',
                                                      'juju-proxy',
                                                      'apt-proxy',
                                                      'snap-proxy',
                                                      'apt-mirror',
                                                      'UpdateBehavior'],
                                         'type': 'object'},
                     'ContainerLXDProfile': {'additionalProperties': False,
                                             'properties': {'name': {'type': 'string'},
                                                            'profile': {'$ref': '#/definitions/CharmLXDProfile'}},
                                             'required': ['profile', 'name'],
                                             'type': 'object'},
                     'ContainerManagerConfig': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'ContainerManagerConfigParams': {'additionalProperties': False,
                                                      'properties': {'type': {'type': 'string'}},
                                                      'required': ['type'],
                                                      'type': 'object'},
                     'ContainerProfileResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'lxd-profiles': {'items': {'$ref': '#/definitions/ContainerLXDProfile'},
                                                                                'type': 'array'}},
                                                'type': 'object'},
                     'ContainerProfileResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ContainerProfileResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'DeviceBridgeInfo': {'additionalProperties': False,
                                          'properties': {'bridge-name': {'type': 'string'},
                                                         'host-device-name': {'type': 'string'},
                                                         'mac-address': {'type': 'string'}},
                                          'required': ['host-device-name',
                                                       'bridge-name',
                                                       'mac-address'],
                                          'type': 'object'},
                     'DistributionGroupResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'DistributionGroupResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/DistributionGroupResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FindToolsParams': {'additionalProperties': False,
                                         'properties': {'agentstream': {'type': 'string'},
                                                        'arch': {'type': 'string'},
                                                        'major': {'type': 'integer'},
                                                        'minor': {'type': 'integer'},
                                                        'number': {'$ref': '#/definitions/Number'},
                                                        'series': {'type': 'string'}},
                                         'required': ['number',
                                                      'major',
                                                      'minor',
                                                      'arch',
                                                      'series',
                                                      'agentstream'],
                                         'type': 'object'},
                     'FindToolsResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'list': {'items': {'$ref': '#/definitions/Tools'},
                                                                 'type': 'array'}},
                                         'required': ['list'],
                                         'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'HostNetworkChange': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'new-bridges': {'items': {'$ref': '#/definitions/DeviceBridgeInfo'},
                                                                          'type': 'array'},
                                                          'reconfigure-delay': {'type': 'integer'}},
                                           'required': ['new-bridges',
                                                        'reconfigure-delay'],
                                           'type': 'object'},
                     'HostNetworkChangeResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/HostNetworkChange'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'InstanceInfo': {'additionalProperties': False,
                                      'properties': {'characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                     'charm-profiles': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                     'instance-id': {'type': 'string'},
                                                     'network-config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                        'type': 'array'},
                                                     'nonce': {'type': 'string'},
                                                     'tag': {'type': 'string'},
                                                     'volume-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentInfo'}},
                                                                            'type': 'object'},
                                                     'volumes': {'items': {'$ref': '#/definitions/Volume'},
                                                                 'type': 'array'}},
                                      'required': ['tag',
                                                   'instance-id',
                                                   'nonce',
                                                   'characteristics',
                                                   'volumes',
                                                   'volume-attachments',
                                                   'network-config',
                                                   'charm-profiles'],
                                      'type': 'object'},
                     'InstancesInfo': {'additionalProperties': False,
                                       'properties': {'machines': {'items': {'$ref': '#/definitions/InstanceInfo'},
                                                                   'type': 'array'}},
                                       'required': ['machines'],
                                       'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineContainers': {'additionalProperties': False,
                                           'properties': {'container-types': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                          'machine-tag': {'type': 'string'}},
                                           'required': ['machine-tag',
                                                        'container-types'],
                                           'type': 'object'},
                     'MachineContainersParams': {'additionalProperties': False,
                                                 'properties': {'params': {'items': {'$ref': '#/definitions/MachineContainers'},
                                                                           'type': 'array'}},
                                                 'required': ['params'],
                                                 'type': 'object'},
                     'MachineNetworkConfigResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'info': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                            'type': 'array'}},
                                                    'required': ['info'],
                                                    'type': 'object'},
                     'MachineNetworkConfigResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/MachineNetworkConfigResult'},
                                                                                'type': 'array'}},
                                                     'required': ['results'],
                                                     'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'is-default-gateway': {'type': 'boolean'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'ProfileChangeResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'new-profile-name': {'type': 'string'},
                                                            'old-profile-name': {'type': 'string'},
                                                            'profile': {'$ref': '#/definitions/CharmLXDProfile'},
                                                            'subordinate': {'type': 'boolean'}},
                                             'type': 'object'},
                     'ProfileChangeResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ProfileChangeResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ProvisioningInfo': {'additionalProperties': False,
                                          'properties': {'charm-lxd-profiles': {'items': {'type': 'string'},
                                                                                'type': 'array'},
                                                         'cloudinit-userdata': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                             'type': 'object'}},
                                                                                'type': 'object'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'controller-config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                            'type': 'object'}},
                                                                               'type': 'object'},
                                                         'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                               'type': 'object'},
                                                         'image-metadata': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                            'type': 'array'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'placement': {'type': 'string'},
                                                         'series': {'type': 'string'},
                                                         'subnets-to-zones': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                           'type': 'array'}},
                                                                              'type': 'object'},
                                                         'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                         'volume-attachments': {'items': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                                                'type': 'array'},
                                                         'volumes': {'items': {'$ref': '#/definitions/VolumeParams'},
                                                                     'type': 'array'}},
                                          'required': ['constraints',
                                                       'series',
                                                       'placement',
                                                       'jobs'],
                                          'type': 'object'},
                     'ProvisioningInfoResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/ProvisioningInfo'}},
                                                'required': ['result'],
                                                'type': 'object'},
                     'ProvisioningInfoResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ProvisioningInfoResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'SetMachineNetworkConfig': {'additionalProperties': False,
                                                 'properties': {'config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                           'type': 'array'},
                                                                'tag': {'type': 'string'}},
                                                 'required': ['tag', 'config'],
                                                 'type': 'object'},
                     'SetProfileArg': {'additionalProperties': False,
                                       'properties': {'entity': {'$ref': '#/definitions/Entity'},
                                                      'profiles': {'items': {'type': 'string'},
                                                                   'type': 'array'}},
                                       'required': ['entity', 'profiles'],
                                       'type': 'object'},
                     'SetProfileArgs': {'additionalProperties': False,
                                        'properties': {'args': {'items': {'$ref': '#/definitions/SetProfileArg'},
                                                                'type': 'array'}},
                                        'required': ['args'],
                                        'type': 'object'},
                     'SetProfileUpgradeCompleteArg': {'additionalProperties': False,
                                                      'properties': {'entity': {'$ref': '#/definitions/Entity'},
                                                                     'message': {'type': 'string'}},
                                                      'required': ['entity',
                                                                   'message'],
                                                      'type': 'object'},
                     'SetProfileUpgradeCompleteArgs': {'additionalProperties': False,
                                                       'properties': {'args': {'items': {'$ref': '#/definitions/SetProfileUpgradeCompleteArg'},
                                                                               'type': 'array'}},
                                                       'required': ['args'],
                                                       'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'Settings': {'additionalProperties': False,
                                  'properties': {'AutoNoProxy': {'type': 'string'},
                                                 'Ftp': {'type': 'string'},
                                                 'Http': {'type': 'string'},
                                                 'Https': {'type': 'string'},
                                                 'NoProxy': {'type': 'string'}},
                                  'required': ['Http',
                                               'Https',
                                               'Ftp',
                                               'NoProxy',
                                               'AutoNoProxy'],
                                  'type': 'object'},
                     'StatusResult': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'id': {'type': 'string'},
                                                     'info': {'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['id',
                                                   'life',
                                                   'status',
                                                   'info',
                                                   'data',
                                                   'since'],
                                      'type': 'object'},
                     'StatusResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StatusResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'ToolsResult': {'additionalProperties': False,
                                     'properties': {'disable-ssl-hostname-verification': {'type': 'boolean'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'tools': {'items': {'$ref': '#/definitions/Tools'},
                                                              'type': 'array'}},
                                     'required': ['tools',
                                                  'disable-ssl-hostname-verification'],
                                     'type': 'object'},
                     'ToolsResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ToolsResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'UpdateBehavior': {'additionalProperties': False,
                                        'properties': {'enable-os-refresh-update': {'type': 'boolean'},
                                                       'enable-os-upgrade': {'type': 'boolean'}},
                                        'required': ['enable-os-refresh-update',
                                                     'enable-os-upgrade'],
                                        'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'},
                     'Volume': {'additionalProperties': False,
                                'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                               'volume-tag': {'type': 'string'}},
                                'required': ['volume-tag', 'info'],
                                'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentParams': {'additionalProperties': False,
                                                'properties': {'instance-id': {'type': 'string'},
                                                               'machine-tag': {'type': 'string'},
                                                               'provider': {'type': 'string'},
                                                               'read-only': {'type': 'boolean'},
                                                               'volume-id': {'type': 'string'},
                                                               'volume-tag': {'type': 'string'}},
                                                'required': ['volume-tag',
                                                             'machine-tag',
                                                             'provider'],
                                                'type': 'object'},
                     'VolumeAttachmentPlanInfo': {'additionalProperties': False,
                                                  'properties': {'device-attributes': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                       'type': 'object'},
                                                                 'device-type': {'type': 'string'}},
                                                  'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'},
                     'VolumeParams': {'additionalProperties': False,
                                      'properties': {'attachment': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                     'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'},
                                                     'provider': {'type': 'string'},
                                                     'size': {'type': 'integer'},
                                                     'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                              'type': 'object'},
                                                     'volume-tag': {'type': 'string'}},
                                      'required': ['volume-tag',
                                                   'size',
                                                   'provider'],
                                      'type': 'object'},
                     'WatchContainer': {'additionalProperties': False,
                                        'properties': {'container-type': {'type': 'string'},
                                                       'machine-tag': {'type': 'string'}},
                                        'required': ['machine-tag',
                                                     'container-type'],
                                        'type': 'object'},
                     'WatchContainers': {'additionalProperties': False,
                                         'properties': {'params': {'items': {'$ref': '#/definitions/WatchContainer'},
                                                                   'type': 'array'}},
                                         'required': ['params'],
                                         'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'AvailabilityZone': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringResults'}},
                                         'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'CharmProfileChangeInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ProfileChangeResults'}},
                                               'type': 'object'},
                    'Constraints': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ConstraintsResults'}},
                                    'type': 'object'},
                    'ContainerConfig': {'properties': {'Result': {'$ref': '#/definitions/ContainerConfig'}},
                                        'type': 'object'},
                    'ContainerManagerConfig': {'properties': {'Params': {'$ref': '#/definitions/ContainerManagerConfigParams'},
                                                              'Result': {'$ref': '#/definitions/ContainerManagerConfig'}},
                                               'type': 'object'},
                    'ControllerAPIInfoForModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'DistributionGroup': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/DistributionGroupResults'}},
                                          'type': 'object'},
                    'DistributionGroupByMachineId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                    'Result': {'$ref': '#/definitions/StringsResults'}},
                                                     'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FindTools': {'properties': {'Params': {'$ref': '#/definitions/FindToolsParams'},
                                                 'Result': {'$ref': '#/definitions/FindToolsResult'}},
                                  'type': 'object'},
                    'GetContainerInterfaceInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/MachineNetworkConfigResults'}},
                                                  'type': 'object'},
                    'GetContainerProfileInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/ContainerProfileResults'}},
                                                'type': 'object'},
                    'HostChangesForContainers': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/HostNetworkChangeResults'}},
                                                 'type': 'object'},
                    'InstanceId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'InstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StatusResults'}},
                                       'type': 'object'},
                    'KeepInstance': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/BoolResults'}},
                                     'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'MachinesWithTransientErrors': {'properties': {'Result': {'$ref': '#/definitions/StatusResults'}},
                                                    'type': 'object'},
                    'MarkMachinesForRemoval': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'PrepareContainerInterfaceInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                     'Result': {'$ref': '#/definitions/MachineNetworkConfigResults'}},
                                                      'type': 'object'},
                    'ProvisioningInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/ProvisioningInfoResults'}},
                                         'type': 'object'},
                    'ReleaseContainerAddresses': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                  'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'RemoveUpgradeCharmProfileData': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                      'type': 'object'},
                    'Series': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StringResults'}},
                               'type': 'object'},
                    'SetCharmProfiles': {'properties': {'Params': {'$ref': '#/definitions/SetProfileArgs'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'SetHostMachineNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                    'type': 'object'},
                    'SetInstanceInfo': {'properties': {'Params': {'$ref': '#/definitions/InstancesInfo'},
                                                       'Result': {'$ref': '#/definitions/ErrorResults'}},
                                        'type': 'object'},
                    'SetInstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetObservedNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                 'type': 'object'},
                    'SetPasswords': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'SetProviderNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetSupportedContainers': {'properties': {'Params': {'$ref': '#/definitions/MachineContainersParams'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'SetUpgradeCharmProfileComplete': {'properties': {'Params': {'$ref': '#/definitions/SetProfileUpgradeCompleteArgs'},
                                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                       'type': 'object'},
                    'StateAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                       'type': 'object'},
                    'Status': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StatusResults'}},
                               'type': 'object'},
                    'Tools': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/ToolsResults'}},
                              'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchAllContainers': {'properties': {'Params': {'$ref': '#/definitions/WatchContainers'},
                                                          'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                           'type': 'object'},
                    'WatchContainers': {'properties': {'Params': {'$ref': '#/definitions/WatchContainers'},
                                                       'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                        'type': 'object'},
                    'WatchContainersCharmProfiles': {'properties': {'Params': {'$ref': '#/definitions/WatchContainers'},
                                                                    'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                     'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchMachineErrorRetry': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                               'type': 'object'},
                    'WatchModelMachines': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                           'type': 'object'},
                    'WatchModelMachinesCharmProfiles': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='APIAddresses',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='APIHostPorts',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def AvailabilityZone(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='AvailabilityZone',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> BytesResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='CACert',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProfileChangeResults)
    async def CharmProfileChangeInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ProfileChangeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='CharmProfileChangeInfo',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConstraintsResults)
    async def Constraints(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ConstraintsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Constraints',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerConfig)
    async def ContainerConfig(self):
        '''

        Returns -> ContainerConfig
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ContainerConfig',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerManagerConfig)
    async def ContainerManagerConfig(self, type_=None):
        '''
        type_ : str
        Returns -> ContainerManagerConfig
        '''
        if type_ is not None and not isinstance(type_, (bytes, str)):
            raise Exception("Expected type_ to be a str, received: {}".format(type(type_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ContainerManagerConfig',
                   version=7,
                   params=_params)
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ControllerAPIInfoForModels',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ControllerConfig',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DistributionGroupResults)
    async def DistributionGroup(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> DistributionGroupResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='DistributionGroup',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def DistributionGroupByMachineId(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='DistributionGroupByMachineId',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='EnsureDead',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindToolsResult)
    async def FindTools(self, agentstream=None, arch=None, major=None, minor=None, number=None, series=None):
        '''
        agentstream : str
        arch : str
        major : int
        minor : int
        number : Number
        series : str
        Returns -> FindToolsResult
        '''
        if agentstream is not None and not isinstance(agentstream, (bytes, str)):
            raise Exception("Expected agentstream to be a str, received: {}".format(type(agentstream)))

        if arch is not None and not isinstance(arch, (bytes, str)):
            raise Exception("Expected arch to be a str, received: {}".format(type(arch)))

        if major is not None and not isinstance(major, int):
            raise Exception("Expected major to be a int, received: {}".format(type(major)))

        if minor is not None and not isinstance(minor, int):
            raise Exception("Expected minor to be a int, received: {}".format(type(minor)))

        if number is not None and not isinstance(number, (dict, Number)):
            raise Exception("Expected number to be a Number, received: {}".format(type(number)))

        if series is not None and not isinstance(series, (bytes, str)):
            raise Exception("Expected series to be a str, received: {}".format(type(series)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='FindTools',
                   version=7,
                   params=_params)
        _params['agentstream'] = agentstream
        _params['arch'] = arch
        _params['major'] = major
        _params['minor'] = minor
        _params['number'] = number
        _params['series'] = series
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineNetworkConfigResults)
    async def GetContainerInterfaceInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachineNetworkConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='GetContainerInterfaceInfo',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerProfileResults)
    async def GetContainerProfileInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ContainerProfileResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='GetContainerProfileInfo',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(HostNetworkChangeResults)
    async def HostChangesForContainers(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> HostNetworkChangeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='HostChangesForContainers',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='InstanceId',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def InstanceStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='InstanceStatus',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResults)
    async def KeepInstance(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> BoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='KeepInstance',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Life',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def MachinesWithTransientErrors(self):
        '''

        Returns -> StatusResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='MachinesWithTransientErrors',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def MarkMachinesForRemoval(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='MarkMachinesForRemoval',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ModelConfig',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ModelUUID',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineNetworkConfigResults)
    async def PrepareContainerInterfaceInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachineNetworkConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='PrepareContainerInterfaceInfo',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProvisioningInfoResults)
    async def ProvisioningInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ProvisioningInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ProvisioningInfo',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ReleaseContainerAddresses(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ReleaseContainerAddresses',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Remove',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveUpgradeCharmProfileData(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='RemoveUpgradeCharmProfileData',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def Series(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Series',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetCharmProfiles(self, args=None):
        '''
        args : typing.Sequence[~SetProfileArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetCharmProfiles',
                   version=7,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetHostMachineNetworkConfig(self, config=None, tag=None):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetHostMachineNetworkConfig',
                   version=7,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceInfo(self, machines=None):
        '''
        machines : typing.Sequence[~InstanceInfo]
        Returns -> ErrorResults
        '''
        if machines is not None and not isinstance(machines, (bytes, str, list)):
            raise Exception("Expected machines to be a Sequence, received: {}".format(type(machines)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetInstanceInfo',
                   version=7,
                   params=_params)
        _params['machines'] = machines
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetInstanceStatus',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetObservedNetworkConfig(self, config=None, tag=None):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetObservedNetworkConfig',
                   version=7,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes=None):
        '''
        changes : typing.Sequence[~EntityPassword]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetPasswords',
                   version=7,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetProviderNetworkConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetProviderNetworkConfig',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetStatus',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetSupportedContainers(self, params=None):
        '''
        params : typing.Sequence[~MachineContainers]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetSupportedContainers',
                   version=7,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetUpgradeCharmProfileComplete(self, args=None):
        '''
        args : typing.Sequence[~SetProfileUpgradeCompleteArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetUpgradeCharmProfileComplete',
                   version=7,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResult)
    async def StateAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='StateAddresses',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def Status(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Status',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ToolsResults)
    async def Tools(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ToolsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Tools',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='UpdateStatus',
                   version=7,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchAPIHostPorts',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchAllContainers(self, params=None):
        '''
        params : typing.Sequence[~WatchContainer]
        Returns -> StringsWatchResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchAllContainers',
                   version=7,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchContainers(self, params=None):
        '''
        params : typing.Sequence[~WatchContainer]
        Returns -> StringsWatchResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchContainers',
                   version=7,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchContainersCharmProfiles(self, params=None):
        '''
        params : typing.Sequence[~WatchContainer]
        Returns -> StringsWatchResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchContainersCharmProfiles',
                   version=7,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchForModelConfigChanges',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchMachineErrorRetry(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchMachineErrorRetry',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachines(self):
        '''

        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchModelMachines',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachinesCharmProfiles(self):
        '''

        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchModelMachinesCharmProfiles',
                   version=7,
                   params=_params)

        reply = await self.rpc(msg)
        return reply


