# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client.facade import Type, ReturnMapping
from juju.client._definitions import *


class ActionFacade(Type):
    name = 'Action'
    version = 6
    schema =     {'definitions': {'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionMessage': {'additionalProperties': False,
                                       'properties': {'message': {'type': 'string'},
                                                      'timestamp': {'format': 'date-time',
                                                                    'type': 'string'}},
                                       'required': ['timestamp', 'message'],
                                       'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'log': {'items': {'$ref': '#/definitions/ActionMessage'},
                                                             'type': 'array'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ActionSpec': {'additionalProperties': False,
                                    'properties': {'description': {'type': 'string'},
                                                   'params': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'}},
                                    'required': ['description', 'params'],
                                    'type': 'object'},
                     'Actions': {'additionalProperties': False,
                                 'properties': {'actions': {'items': {'$ref': '#/definitions/Action'},
                                                            'type': 'array'}},
                                 'type': 'object'},
                     'ActionsByName': {'additionalProperties': False,
                                       'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'},
                                                      'error': {'$ref': '#/definitions/Error'},
                                                      'name': {'type': 'string'}},
                                       'type': 'object'},
                     'ActionsByNames': {'additionalProperties': False,
                                        'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByName'},
                                                                   'type': 'array'}},
                                        'type': 'object'},
                     'ActionsByReceiver': {'additionalProperties': False,
                                           'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                      'type': 'array'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'receiver': {'type': 'string'}},
                                           'type': 'object'},
                     'ActionsByReceivers': {'additionalProperties': False,
                                            'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByReceiver'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'ApplicationCharmActionsResult': {'additionalProperties': False,
                                                       'properties': {'actions': {'patternProperties': {'.*': {'$ref': '#/definitions/ActionSpec'}},
                                                                                  'type': 'object'},
                                                                      'application-tag': {'type': 'string'},
                                                                      'error': {'$ref': '#/definitions/Error'}},
                                                       'type': 'object'},
                     'ApplicationsCharmActionsResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationCharmActionsResult'},
                                                                                    'type': 'array'}},
                                                         'type': 'object'},
                     'EnqueuedActions': {'additionalProperties': False,
                                         'properties': {'actions': {'items': {'$ref': '#/definitions/StringResult'},
                                                                    'type': 'array'},
                                                        'operation': {'type': 'string'}},
                                         'required': ['operation'],
                                         'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'FindActionsByNames': {'additionalProperties': False,
                                            'properties': {'names': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                            'type': 'object'},
                     'FindTags': {'additionalProperties': False,
                                  'properties': {'prefixes': {'items': {'type': 'string'},
                                                              'type': 'array'}},
                                  'required': ['prefixes'],
                                  'type': 'object'},
                     'FindTagsResults': {'additionalProperties': False,
                                         'properties': {'matches': {'patternProperties': {'.*': {'items': {'$ref': '#/definitions/Entity'},
                                                                                                 'type': 'array'}},
                                                                    'type': 'object'}},
                                         'required': ['matches'],
                                         'type': 'object'},
                     'OperationQueryArgs': {'additionalProperties': False,
                                            'properties': {'actions': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'applications': {'items': {'type': 'string'},
                                                                            'type': 'array'},
                                                           'limit': {'type': 'integer'},
                                                           'offset': {'type': 'integer'},
                                                           'status': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                           'units': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                            'type': 'object'},
                     'OperationResult': {'additionalProperties': False,
                                         'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                    'type': 'array'},
                                                        'completed': {'format': 'date-time',
                                                                      'type': 'string'},
                                                        'enqueued': {'format': 'date-time',
                                                                     'type': 'string'},
                                                        'error': {'$ref': '#/definitions/Error'},
                                                        'operation': {'type': 'string'},
                                                        'started': {'format': 'date-time',
                                                                    'type': 'string'},
                                                        'status': {'type': 'string'},
                                                        'summary': {'type': 'string'}},
                                         'required': ['operation', 'summary'],
                                         'type': 'object'},
                     'OperationResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/OperationResult'},
                                                                     'type': 'array'},
                                                         'truncated': {'type': 'boolean'}},
                                          'type': 'object'},
                     'RunParams': {'additionalProperties': False,
                                   'properties': {'applications': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                  'commands': {'type': 'string'},
                                                  'machines': {'items': {'type': 'string'},
                                                               'type': 'array'},
                                                  'timeout': {'type': 'integer'},
                                                  'units': {'items': {'type': 'string'},
                                                            'type': 'array'},
                                                  'workload-context': {'type': 'boolean'}},
                                   'required': ['commands', 'timeout'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'}},
     'properties': {'Actions': {'description': 'Actions takes a list of '
                                               'ActionTags, and returns the full '
                                               'Action for\n'
                                               'each ID.',
                                'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'ApplicationsCharmsActions': {'description': 'ApplicationsCharmsActions '
                                                                 'returns a slice '
                                                                 'of charm Actions '
                                                                 'for a slice of\n'
                                                                 'services.',
                                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/ApplicationsCharmActionsResults'}},
                                                  'type': 'object'},
                    'Cancel': {'description': 'Cancel attempts to cancel enqueued '
                                              'Actions from running.',
                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ActionResults'}},
                               'type': 'object'},
                    'Enqueue': {'description': 'Enqueue takes a list of Actions '
                                               'and queues them up to be executed '
                                               'by\n'
                                               'the designated ActionReceiver, '
                                               'returning the params.Action for '
                                               'each\n'
                                               'enqueued Action, or an error if '
                                               'there was a problem enqueueing '
                                               'the\n'
                                               'Action.',
                                'properties': {'Params': {'$ref': '#/definitions/Actions'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'EnqueueOperation': {'description': 'EnqueueOperation takes a '
                                                        'list of Actions and '
                                                        'queues them up to be '
                                                        'executed as\n'
                                                        'an operation, each action '
                                                        'running as a task on the '
                                                        'the designated '
                                                        'ActionReceiver.\n'
                                                        'We return the ID of the '
                                                        'overall operation and '
                                                        'each individual task.',
                                         'properties': {'Params': {'$ref': '#/definitions/Actions'},
                                                        'Result': {'$ref': '#/definitions/EnqueuedActions'}},
                                         'type': 'object'},
                    'FindActionTagsByPrefix': {'description': 'FindActionTagsByPrefix '
                                                              'takes a list of '
                                                              'string prefixes and '
                                                              'finds\n'
                                                              'corresponding '
                                                              'ActionTags that '
                                                              'match that prefix.\n'
                                                              'TODO(juju3) - '
                                                              'rename API method '
                                                              'since we only need '
                                                              'prefix matching for '
                                                              'UUIDs',
                                               'properties': {'Params': {'$ref': '#/definitions/FindTags'},
                                                              'Result': {'$ref': '#/definitions/FindTagsResults'}},
                                               'type': 'object'},
                    'FindActionsByNames': {'properties': {'Params': {'$ref': '#/definitions/FindActionsByNames'},
                                                          'Result': {'$ref': '#/definitions/ActionsByNames'}},
                                           'type': 'object'},
                    'ListAll': {'description': 'ListAll takes a list of Entities '
                                               'representing ActionReceivers and\n'
                                               'returns all of the Actions that '
                                               'have been enqueued or run by each '
                                               'of\n'
                                               'those Entities.',
                                'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                'type': 'object'},
                    'ListCompleted': {'description': 'ListCompleted takes a list '
                                                     'of Entities representing '
                                                     'ActionReceivers\n'
                                                     'and returns all of the '
                                                     'Actions that have been run '
                                                     'on each of those\n'
                                                     'Entities.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                      'type': 'object'},
                    'ListOperations': {'description': 'ListOperations fetches the '
                                                      'called actions for '
                                                      'specified apps/units.',
                                       'properties': {'Params': {'$ref': '#/definitions/OperationQueryArgs'},
                                                      'Result': {'$ref': '#/definitions/OperationResults'}},
                                       'type': 'object'},
                    'ListPending': {'description': 'ListPending takes a list of '
                                                   'Entities representing '
                                                   'ActionReceivers\n'
                                                   'and returns all of the Actions '
                                                   'that are enqueued for each of '
                                                   'those\n'
                                                   'Entities.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'ListRunning': {'description': 'ListRunning takes a list of '
                                                   'Entities representing '
                                                   'ActionReceivers and\n'
                                                   'returns all of the Actions '
                                                   'that have are running on each '
                                                   'of those\n'
                                                   'Entities.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'Operations': {'description': 'Operations fetches the '
                                                  'specified operation ids.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/OperationResults'}},
                                   'type': 'object'},
                    'Run': {'description': 'Run the commands specified on the '
                                           'machines identified through the\n'
                                           'list of machines, units and services.',
                            'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                           'Result': {'$ref': '#/definitions/ActionResults'}},
                            'type': 'object'},
                    'RunOnAllMachines': {'description': 'RunOnAllMachines attempts '
                                                        'to run the specified '
                                                        'command on all the '
                                                        'machines.',
                                         'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                                        'Result': {'$ref': '#/definitions/ActionResults'}},
                                         'type': 'object'},
                    'WatchActionsProgress': {'description': 'WatchActionsProgress '
                                                            'creates a watcher '
                                                            'that reports on '
                                                            'action log messages.',
                                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                            'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ActionResults)
    async def Actions(self, entities=None):
        '''
        Actions takes a list of ActionTags, and returns the full Action for
        each ID.

        entities : typing.Sequence[~Entity]
        Returns -> ActionResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Actions',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationsCharmActionsResults)
    async def ApplicationsCharmsActions(self, entities=None):
        '''
        ApplicationsCharmsActions returns a slice of charm Actions for a slice of
        services.

        entities : typing.Sequence[~Entity]
        Returns -> ApplicationsCharmActionsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ApplicationsCharmsActions',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Cancel(self, entities=None):
        '''
        Cancel attempts to cancel enqueued Actions from running.

        entities : typing.Sequence[~Entity]
        Returns -> ActionResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Cancel',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Enqueue(self, actions=None):
        '''
        Enqueue takes a list of Actions and queues them up to be executed by
        the designated ActionReceiver, returning the params.Action for each
        enqueued Action, or an error if there was a problem enqueueing the
        Action.

        actions : typing.Sequence[~Action]
        Returns -> ActionResults
        '''
        if actions is not None and not isinstance(actions, (bytes, str, list)):
            raise Exception("Expected actions to be a Sequence, received: {}".format(type(actions)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Enqueue',
                   version=6,
                   params=_params)
        _params['actions'] = actions
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(EnqueuedActions)
    async def EnqueueOperation(self, actions=None):
        '''
        EnqueueOperation takes a list of Actions and queues them up to be executed as
        an operation, each action running as a task on the the designated ActionReceiver.
        We return the ID of the overall operation and each individual task.

        actions : typing.Sequence[~Action]
        Returns -> EnqueuedActions
        '''
        if actions is not None and not isinstance(actions, (bytes, str, list)):
            raise Exception("Expected actions to be a Sequence, received: {}".format(type(actions)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='EnqueueOperation',
                   version=6,
                   params=_params)
        _params['actions'] = actions
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindTagsResults)
    async def FindActionTagsByPrefix(self, prefixes=None):
        '''
        FindActionTagsByPrefix takes a list of string prefixes and finds
        corresponding ActionTags that match that prefix.
        TODO(juju3) - rename API method since we only need prefix matching for UUIDs

        prefixes : typing.Sequence[str]
        Returns -> FindTagsResults
        '''
        if prefixes is not None and not isinstance(prefixes, (bytes, str, list)):
            raise Exception("Expected prefixes to be a Sequence, received: {}".format(type(prefixes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='FindActionTagsByPrefix',
                   version=6,
                   params=_params)
        _params['prefixes'] = prefixes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByNames)
    async def FindActionsByNames(self, names=None):
        '''
        names : typing.Sequence[str]
        Returns -> ActionsByNames
        '''
        if names is not None and not isinstance(names, (bytes, str, list)):
            raise Exception("Expected names to be a Sequence, received: {}".format(type(names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='FindActionsByNames',
                   version=6,
                   params=_params)
        _params['names'] = names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListAll(self, entities=None):
        '''
        ListAll takes a list of Entities representing ActionReceivers and
        returns all of the Actions that have been enqueued or run by each of
        those Entities.

        entities : typing.Sequence[~Entity]
        Returns -> ActionsByReceivers
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListAll',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListCompleted(self, entities=None):
        '''
        ListCompleted takes a list of Entities representing ActionReceivers
        and returns all of the Actions that have been run on each of those
        Entities.

        entities : typing.Sequence[~Entity]
        Returns -> ActionsByReceivers
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListCompleted',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(OperationResults)
    async def ListOperations(self, actions=None, applications=None, limit=None, offset=None, status=None, units=None):
        '''
        ListOperations fetches the called actions for specified apps/units.

        actions : typing.Sequence[str]
        applications : typing.Sequence[str]
        limit : int
        offset : int
        status : typing.Sequence[str]
        units : typing.Sequence[str]
        Returns -> OperationResults
        '''
        if actions is not None and not isinstance(actions, (bytes, str, list)):
            raise Exception("Expected actions to be a Sequence, received: {}".format(type(actions)))

        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        if limit is not None and not isinstance(limit, int):
            raise Exception("Expected limit to be a int, received: {}".format(type(limit)))

        if offset is not None and not isinstance(offset, int):
            raise Exception("Expected offset to be a int, received: {}".format(type(offset)))

        if status is not None and not isinstance(status, (bytes, str, list)):
            raise Exception("Expected status to be a Sequence, received: {}".format(type(status)))

        if units is not None and not isinstance(units, (bytes, str, list)):
            raise Exception("Expected units to be a Sequence, received: {}".format(type(units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListOperations',
                   version=6,
                   params=_params)
        _params['actions'] = actions
        _params['applications'] = applications
        _params['limit'] = limit
        _params['offset'] = offset
        _params['status'] = status
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListPending(self, entities=None):
        '''
        ListPending takes a list of Entities representing ActionReceivers
        and returns all of the Actions that are enqueued for each of those
        Entities.

        entities : typing.Sequence[~Entity]
        Returns -> ActionsByReceivers
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListPending',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListRunning(self, entities=None):
        '''
        ListRunning takes a list of Entities representing ActionReceivers and
        returns all of the Actions that have are running on each of those
        Entities.

        entities : typing.Sequence[~Entity]
        Returns -> ActionsByReceivers
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListRunning',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(OperationResults)
    async def Operations(self, entities=None):
        '''
        Operations fetches the specified operation ids.

        entities : typing.Sequence[~Entity]
        Returns -> OperationResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Operations',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Run(self, applications=None, commands=None, machines=None, timeout=None, units=None, workload_context=None):
        '''
        Run the commands specified on the machines identified through the
        list of machines, units and services.

        applications : typing.Sequence[str]
        commands : str
        machines : typing.Sequence[str]
        timeout : int
        units : typing.Sequence[str]
        workload_context : bool
        Returns -> ActionResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        if commands is not None and not isinstance(commands, (bytes, str)):
            raise Exception("Expected commands to be a str, received: {}".format(type(commands)))

        if machines is not None and not isinstance(machines, (bytes, str, list)):
            raise Exception("Expected machines to be a Sequence, received: {}".format(type(machines)))

        if timeout is not None and not isinstance(timeout, int):
            raise Exception("Expected timeout to be a int, received: {}".format(type(timeout)))

        if units is not None and not isinstance(units, (bytes, str, list)):
            raise Exception("Expected units to be a Sequence, received: {}".format(type(units)))

        if workload_context is not None and not isinstance(workload_context, bool):
            raise Exception("Expected workload_context to be a bool, received: {}".format(type(workload_context)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Run',
                   version=6,
                   params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        _params['workload-context'] = workload_context
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def RunOnAllMachines(self, applications=None, commands=None, machines=None, timeout=None, units=None, workload_context=None):
        '''
        RunOnAllMachines attempts to run the specified command on all the machines.

        applications : typing.Sequence[str]
        commands : str
        machines : typing.Sequence[str]
        timeout : int
        units : typing.Sequence[str]
        workload_context : bool
        Returns -> ActionResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        if commands is not None and not isinstance(commands, (bytes, str)):
            raise Exception("Expected commands to be a str, received: {}".format(type(commands)))

        if machines is not None and not isinstance(machines, (bytes, str, list)):
            raise Exception("Expected machines to be a Sequence, received: {}".format(type(machines)))

        if timeout is not None and not isinstance(timeout, int):
            raise Exception("Expected timeout to be a int, received: {}".format(type(timeout)))

        if units is not None and not isinstance(units, (bytes, str, list)):
            raise Exception("Expected units to be a Sequence, received: {}".format(type(units)))

        if workload_context is not None and not isinstance(workload_context, bool):
            raise Exception("Expected workload_context to be a bool, received: {}".format(type(workload_context)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='RunOnAllMachines',
                   version=6,
                   params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        _params['workload-context'] = workload_context
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchActionsProgress(self, entities=None):
        '''
        WatchActionsProgress creates a watcher that reports on action log messages.

        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='WatchActionsProgress',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class CloudFacade(Type):
    name = 'Cloud'
    version = 6
    schema =     {'definitions': {'AddCloudArgs': {'additionalProperties': False,
                                      'properties': {'cloud': {'$ref': '#/definitions/Cloud'},
                                                     'force': {'type': 'boolean'},
                                                     'name': {'type': 'string'}},
                                      'required': ['cloud', 'name'],
                                      'type': 'object'},
                     'Cloud': {'additionalProperties': False,
                               'properties': {'auth-types': {'items': {'type': 'string'},
                                                             'type': 'array'},
                                              'ca-certificates': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                      'type': 'object'}},
                                                         'type': 'object'},
                                              'endpoint': {'type': 'string'},
                                              'host-cloud-region': {'type': 'string'},
                                              'identity-endpoint': {'type': 'string'},
                                              'region-config': {'patternProperties': {'.*': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                          'type': 'object'}},
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                              'regions': {'items': {'$ref': '#/definitions/CloudRegion'},
                                                          'type': 'array'},
                                              'storage-endpoint': {'type': 'string'},
                                              'type': {'type': 'string'}},
                               'required': ['type'],
                               'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudCredentialArg': {'additionalProperties': False,
                                            'properties': {'cloud-name': {'type': 'string'},
                                                           'credential-name': {'type': 'string'}},
                                            'required': ['cloud-name',
                                                         'credential-name'],
                                            'type': 'object'},
                     'CloudCredentialArgs': {'additionalProperties': False,
                                             'properties': {'credentials': {'items': {'$ref': '#/definitions/CloudCredentialArg'},
                                                                            'type': 'array'},
                                                            'include-secrets': {'type': 'boolean'}},
                                             'required': ['include-secrets'],
                                             'type': 'object'},
                     'CloudCredentialResult': {'additionalProperties': False,
                                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                                              'result': {'$ref': '#/definitions/CloudCredential'}},
                                               'type': 'object'},
                     'CloudCredentialResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/CloudCredentialResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'CloudDetails': {'additionalProperties': False,
                                      'properties': {'auth-types': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                     'endpoint': {'type': 'string'},
                                                     'identity-endpoint': {'type': 'string'},
                                                     'regions': {'items': {'$ref': '#/definitions/CloudRegion'},
                                                                 'type': 'array'},
                                                     'storage-endpoint': {'type': 'string'},
                                                     'type': {'type': 'string'}},
                                      'required': ['type'],
                                      'type': 'object'},
                     'CloudInfo': {'additionalProperties': False,
                                   'properties': {'CloudDetails': {'$ref': '#/definitions/CloudDetails'},
                                                  'users': {'items': {'$ref': '#/definitions/CloudUserInfo'},
                                                            'type': 'array'}},
                                   'required': ['CloudDetails', 'users'],
                                   'type': 'object'},
                     'CloudInfoResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudInfo'}},
                                         'type': 'object'},
                     'CloudInfoResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudInfoResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'CloudInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'cloud-tag': {'type': 'string'},
                                                                     'constraints': {'$ref': '#/definitions/Value'},
                                                                     'region': {'type': 'string'}},
                                                      'required': ['cloud-tag',
                                                                   'region'],
                                                      'type': 'object'},
                     'CloudInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/CloudInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'CloudRegion': {'additionalProperties': False,
                                     'properties': {'endpoint': {'type': 'string'},
                                                    'identity-endpoint': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'storage-endpoint': {'type': 'string'}},
                                     'required': ['name'],
                                     'type': 'object'},
                     'CloudResult': {'additionalProperties': False,
                                     'properties': {'cloud': {'$ref': '#/definitions/Cloud'},
                                                    'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'CloudResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/CloudResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'CloudUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'access'],
                                       'type': 'object'},
                     'CloudsResult': {'additionalProperties': False,
                                      'properties': {'clouds': {'patternProperties': {'.*': {'$ref': '#/definitions/Cloud'}},
                                                                'type': 'object'}},
                                      'type': 'object'},
                     'ControllerCredentialInfo': {'additionalProperties': False,
                                                  'properties': {'content': {'$ref': '#/definitions/CredentialContent'},
                                                                 'models': {'items': {'$ref': '#/definitions/ModelAccess'},
                                                                            'type': 'array'}},
                                                  'type': 'object'},
                     'CredentialContent': {'additionalProperties': False,
                                           'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                    'type': 'object'},
                                                          'auth-type': {'type': 'string'},
                                                          'cloud': {'type': 'string'},
                                                          'name': {'type': 'string'},
                                                          'valid': {'type': 'boolean'}},
                                           'required': ['name',
                                                        'cloud',
                                                        'auth-type'],
                                           'type': 'object'},
                     'CredentialContentResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/ControllerCredentialInfo'}},
                                                 'type': 'object'},
                     'CredentialContentResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/CredentialContentResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ListCloudInfo': {'additionalProperties': False,
                                       'properties': {'CloudDetails': {'$ref': '#/definitions/CloudDetails'},
                                                      'user-access': {'type': 'string'}},
                                       'required': ['CloudDetails', 'user-access'],
                                       'type': 'object'},
                     'ListCloudInfoResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ListCloudInfo'}},
                                             'type': 'object'},
                     'ListCloudInfoResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ListCloudInfoResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ListCloudsRequest': {'additionalProperties': False,
                                           'properties': {'all': {'type': 'boolean'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag'],
                                           'type': 'object'},
                     'ModelAccess': {'additionalProperties': False,
                                     'properties': {'access': {'type': 'string'},
                                                    'model': {'type': 'string'}},
                                     'type': 'object'},
                     'ModifyCloudAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'cloud-tag': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'cloud-tag',
                                                        'action',
                                                        'access'],
                                           'type': 'object'},
                     'ModifyCloudAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyCloudAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'RevokeCredentialArg': {'additionalProperties': False,
                                             'properties': {'force': {'type': 'boolean'},
                                                            'tag': {'type': 'string'}},
                                             'required': ['tag', 'force'],
                                             'type': 'object'},
                     'RevokeCredentialArgs': {'additionalProperties': False,
                                              'properties': {'credentials': {'items': {'$ref': '#/definitions/RevokeCredentialArg'},
                                                                             'type': 'array'}},
                                              'required': ['credentials'],
                                              'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'TaggedCredential': {'additionalProperties': False,
                                          'properties': {'credential': {'$ref': '#/definitions/CloudCredential'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'credential'],
                                          'type': 'object'},
                     'TaggedCredentials': {'additionalProperties': False,
                                           'properties': {'credentials': {'items': {'$ref': '#/definitions/TaggedCredential'},
                                                                          'type': 'array'}},
                                           'type': 'object'},
                     'UpdateCloudArgs': {'additionalProperties': False,
                                         'properties': {'clouds': {'items': {'$ref': '#/definitions/AddCloudArgs'},
                                                                   'type': 'array'}},
                                         'required': ['clouds'],
                                         'type': 'object'},
                     'UpdateCredentialArgs': {'additionalProperties': False,
                                              'properties': {'credentials': {'items': {'$ref': '#/definitions/TaggedCredential'},
                                                                             'type': 'array'},
                                                             'force': {'type': 'boolean'}},
                                              'required': ['credentials', 'force'],
                                              'type': 'object'},
                     'UpdateCredentialModelResult': {'additionalProperties': False,
                                                     'properties': {'errors': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                               'type': 'array'},
                                                                    'name': {'type': 'string'},
                                                                    'uuid': {'type': 'string'}},
                                                     'required': ['uuid', 'name'],
                                                     'type': 'object'},
                     'UpdateCredentialResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'models': {'items': {'$ref': '#/definitions/UpdateCredentialModelResult'},
                                                                          'type': 'array'},
                                                               'tag': {'type': 'string'}},
                                                'required': ['tag'],
                                                'type': 'object'},
                     'UpdateCredentialResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/UpdateCredentialResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'UserCloud': {'additionalProperties': False,
                                   'properties': {'cloud-tag': {'type': 'string'},
                                                  'user-tag': {'type': 'string'}},
                                   'required': ['user-tag', 'cloud-tag'],
                                   'type': 'object'},
                     'UserClouds': {'additionalProperties': False,
                                    'properties': {'user-clouds': {'items': {'$ref': '#/definitions/UserCloud'},
                                                                   'type': 'array'}},
                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'AddCloud': {'properties': {'Params': {'$ref': '#/definitions/AddCloudArgs'}},
                                 'type': 'object'},
                    'AddCredentials': {'properties': {'Params': {'$ref': '#/definitions/TaggedCredentials'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'CheckCredentialsModels': {'properties': {'Params': {'$ref': '#/definitions/TaggedCredentials'},
                                                              'Result': {'$ref': '#/definitions/UpdateCredentialResults'}},
                                               'type': 'object'},
                    'Cloud': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/CloudResults'}},
                              'type': 'object'},
                    'CloudInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudInfoResults'}},
                                  'type': 'object'},
                    'Clouds': {'properties': {'Result': {'$ref': '#/definitions/CloudsResult'}},
                               'type': 'object'},
                    'Credential': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/CloudCredentialResults'}},
                                   'type': 'object'},
                    'CredentialContents': {'properties': {'Params': {'$ref': '#/definitions/CloudCredentialArgs'},
                                                          'Result': {'$ref': '#/definitions/CredentialContentResults'}},
                                           'type': 'object'},
                    'InstanceTypes': {'properties': {'Params': {'$ref': '#/definitions/CloudInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'},
                    'ListCloudInfo': {'properties': {'Params': {'$ref': '#/definitions/ListCloudsRequest'},
                                                     'Result': {'$ref': '#/definitions/ListCloudInfoResults'}},
                                      'type': 'object'},
                    'ModifyCloudAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyCloudAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'RemoveClouds': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'RevokeCredentialsCheckModels': {'properties': {'Params': {'$ref': '#/definitions/RevokeCredentialArgs'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                     'type': 'object'},
                    'UpdateCloud': {'properties': {'Params': {'$ref': '#/definitions/UpdateCloudArgs'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'UpdateCredentialsCheckModels': {'properties': {'Params': {'$ref': '#/definitions/UpdateCredentialArgs'},
                                                                    'Result': {'$ref': '#/definitions/UpdateCredentialResults'}},
                                                     'type': 'object'},
                    'UserCredentials': {'properties': {'Params': {'$ref': '#/definitions/UserClouds'},
                                                       'Result': {'$ref': '#/definitions/StringsResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def AddCloud(self, cloud=None, force=None, name=None):
        '''
        cloud : Cloud
        force : bool
        name : str
        Returns -> None
        '''
        if cloud is not None and not isinstance(cloud, (dict, Cloud)):
            raise Exception("Expected cloud to be a Cloud, received: {}".format(type(cloud)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if name is not None and not isinstance(name, (bytes, str)):
            raise Exception("Expected name to be a str, received: {}".format(type(name)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='AddCloud',
                   version=6,
                   params=_params)
        _params['cloud'] = cloud
        _params['force'] = force
        _params['name'] = name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def AddCredentials(self, credentials=None):
        '''
        credentials : typing.Sequence[~TaggedCredential]
        Returns -> ErrorResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='AddCredentials',
                   version=6,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpdateCredentialResults)
    async def CheckCredentialsModels(self, credentials=None):
        '''
        credentials : typing.Sequence[~TaggedCredential]
        Returns -> UpdateCredentialResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='CheckCredentialsModels',
                   version=6,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudResults)
    async def Cloud(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> CloudResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Cloud',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudInfoResults)
    async def CloudInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> CloudInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='CloudInfo',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudsResult)
    async def Clouds(self):
        '''

        Returns -> CloudsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Clouds',
                   version=6,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudCredentialResults)
    async def Credential(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> CloudCredentialResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Credential',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CredentialContentResults)
    async def CredentialContents(self, credentials=None, include_secrets=None):
        '''
        credentials : typing.Sequence[~CloudCredentialArg]
        include_secrets : bool
        Returns -> CredentialContentResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        if include_secrets is not None and not isinstance(include_secrets, bool):
            raise Exception("Expected include_secrets to be a bool, received: {}".format(type(include_secrets)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='CredentialContents',
                   version=6,
                   params=_params)
        _params['credentials'] = credentials
        _params['include-secrets'] = include_secrets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints=None):
        '''
        constraints : typing.Sequence[~CloudInstanceTypesConstraint]
        Returns -> InstanceTypesResults
        '''
        if constraints is not None and not isinstance(constraints, (bytes, str, list)):
            raise Exception("Expected constraints to be a Sequence, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='InstanceTypes',
                   version=6,
                   params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListCloudInfoResults)
    async def ListCloudInfo(self, all_=None, user_tag=None):
        '''
        all_ : bool
        user_tag : str
        Returns -> ListCloudInfoResults
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        if user_tag is not None and not isinstance(user_tag, (bytes, str)):
            raise Exception("Expected user_tag to be a str, received: {}".format(type(user_tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='ListCloudInfo',
                   version=6,
                   params=_params)
        _params['all'] = all_
        _params['user-tag'] = user_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyCloudAccess(self, changes=None):
        '''
        changes : typing.Sequence[~ModifyCloudAccess]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='ModifyCloudAccess',
                   version=6,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveClouds(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='RemoveClouds',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RevokeCredentialsCheckModels(self, credentials=None):
        '''
        credentials : typing.Sequence[~RevokeCredentialArg]
        Returns -> ErrorResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='RevokeCredentialsCheckModels',
                   version=6,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateCloud(self, clouds=None):
        '''
        clouds : typing.Sequence[~AddCloudArgs]
        Returns -> ErrorResults
        '''
        if clouds is not None and not isinstance(clouds, (bytes, str, list)):
            raise Exception("Expected clouds to be a Sequence, received: {}".format(type(clouds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UpdateCloud',
                   version=6,
                   params=_params)
        _params['clouds'] = clouds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpdateCredentialResults)
    async def UpdateCredentialsCheckModels(self, credentials=None, force=None):
        '''
        credentials : typing.Sequence[~TaggedCredential]
        force : bool
        Returns -> UpdateCredentialResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UpdateCredentialsCheckModels',
                   version=6,
                   params=_params)
        _params['credentials'] = credentials
        _params['force'] = force
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def UserCredentials(self, user_clouds=None):
        '''
        user_clouds : typing.Sequence[~UserCloud]
        Returns -> StringsResults
        '''
        if user_clouds is not None and not isinstance(user_clouds, (bytes, str, list)):
            raise Exception("Expected user_clouds to be a Sequence, received: {}".format(type(user_clouds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UserCredentials',
                   version=6,
                   params=_params)
        _params['user-clouds'] = user_clouds
        reply = await self.rpc(msg)
        return reply



class MachineManagerFacade(Type):
    name = 'MachineManager'
    version = 6
    schema =     {'definitions': {'AddMachineParams': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'container-type': {'type': 'string'},
                                                         'disks': {'items': {'$ref': '#/definitions/Constraints'},
                                                                   'type': 'array'},
                                                         'hardware-characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                         'instance-id': {'type': 'string'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'nonce': {'type': 'string'},
                                                         'parent-id': {'type': 'string'},
                                                         'placement': {'$ref': '#/definitions/Placement'},
                                                         'series': {'type': 'string'}},
                                          'required': ['series',
                                                       'constraints',
                                                       'jobs',
                                                       'parent-id',
                                                       'container-type',
                                                       'instance-id',
                                                       'nonce',
                                                       'hardware-characteristics',
                                                       'addresses'],
                                          'type': 'object'},
                     'AddMachines': {'additionalProperties': False,
                                     'properties': {'params': {'items': {'$ref': '#/definitions/AddMachineParams'},
                                                               'type': 'array'}},
                                     'required': ['params'],
                                     'type': 'object'},
                     'AddMachinesResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'machine': {'type': 'string'}},
                                           'required': ['machine'],
                                           'type': 'object'},
                     'AddMachinesResults': {'additionalProperties': False,
                                            'properties': {'machines': {'items': {'$ref': '#/definitions/AddMachinesResult'},
                                                                        'type': 'array'}},
                                            'required': ['machines'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyMachineInfo': {'additionalProperties': False,
                                            'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                 'type': 'array'},
                                                           'destroyed-units': {'items': {'$ref': '#/definitions/Entity'},
                                                                               'type': 'array'},
                                                           'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                'type': 'array'}},
                                            'type': 'object'},
                     'DestroyMachineResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'info': {'$ref': '#/definitions/DestroyMachineInfo'}},
                                              'type': 'object'},
                     'DestroyMachineResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/DestroyMachineResult'},
                                                                          'type': 'array'}},
                                               'type': 'object'},
                     'DestroyMachinesParams': {'additionalProperties': False,
                                               'properties': {'force': {'type': 'boolean'},
                                                              'keep': {'type': 'boolean'},
                                                              'machine-tags': {'items': {'type': 'string'},
                                                                               'type': 'array'},
                                                              'max-wait': {'type': 'integer'}},
                                               'required': ['machine-tags'],
                                               'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'root-disk-source': {'type': 'string'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'ModelInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'value': {'$ref': '#/definitions/Value'}},
                                                      'type': 'object'},
                     'ModelInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/ModelInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'UpdateSeriesArg': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'series': {'type': 'string'},
                                                        'tag': {'$ref': '#/definitions/Entity'}},
                                         'required': ['tag', 'force', 'series'],
                                         'type': 'object'},
                     'UpdateSeriesArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/UpdateSeriesArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'UpgradeSeriesNotificationParam': {'additionalProperties': False,
                                                        'properties': {'entity': {'$ref': '#/definitions/Entity'},
                                                                       'watcher-id': {'type': 'string'}},
                                                        'required': ['entity',
                                                                     'watcher-id'],
                                                        'type': 'object'},
                     'UpgradeSeriesNotificationParams': {'additionalProperties': False,
                                                         'properties': {'params': {'items': {'$ref': '#/definitions/UpgradeSeriesNotificationParam'},
                                                                                   'type': 'array'}},
                                                         'required': ['params'],
                                                         'type': 'object'},
                     'UpgradeSeriesUnitsResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'unit-names': {'items': {'type': 'string'},
                                                                                'type': 'array'}},
                                                  'required': ['unit-names'],
                                                  'type': 'object'},
                     'UpgradeSeriesUnitsResults': {'additionalProperties': False,
                                                   'properties': {'Results': {'items': {'$ref': '#/definitions/UpgradeSeriesUnitsResult'},
                                                                              'type': 'array'}},
                                                   'required': ['Results'],
                                                   'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'AddMachines': {'description': 'AddMachines adds new machines '
                                                   'with the supplied parameters.',
                                    'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                   'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                    'type': 'object'},
                    'DestroyMachine': {'description': 'DestroyMachine removes a '
                                                      'set of machines from the '
                                                      'model.',
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/DestroyMachineResults'}},
                                       'type': 'object'},
                    'DestroyMachineWithParams': {'description': 'DestroyMachineWithParams '
                                                                'removes a set of '
                                                                'machines from the '
                                                                'model.',
                                                 'properties': {'Params': {'$ref': '#/definitions/DestroyMachinesParams'},
                                                                'Result': {'$ref': '#/definitions/DestroyMachineResults'}},
                                                 'type': 'object'},
                    'ForceDestroyMachine': {'description': 'ForceDestroyMachine '
                                                           'forcibly removes a set '
                                                           'of machines from the '
                                                           'model.\n'
                                                           'TODO (anastasiamac '
                                                           '2019-4-24) From Juju '
                                                           '3.0 this call will be '
                                                           'removed in favour of '
                                                           'DestroyMachinesWithParams.\n'
                                                           'Also from ModelManger '
                                                           'v6 this call is less '
                                                           'useful as it does not '
                                                           'support MaxWait '
                                                           'customisation.',
                                            'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/DestroyMachineResults'}},
                                            'type': 'object'},
                    'GetUpgradeSeriesMessages': {'description': 'GetUpgradeSeriesMessages '
                                                                'returns all new '
                                                                'messages '
                                                                'associated with '
                                                                'upgrade\n'
                                                                'series events. '
                                                                'Messages that '
                                                                'have already been '
                                                                'retrieved once '
                                                                'are not\n'
                                                                'returned by this '
                                                                'method.',
                                                 'properties': {'Params': {'$ref': '#/definitions/UpgradeSeriesNotificationParams'},
                                                                'Result': {'$ref': '#/definitions/StringsResults'}},
                                                 'type': 'object'},
                    'InstanceTypes': {'description': 'InstanceTypes returns '
                                                     'instance type information '
                                                     'for the cloud and region\n'
                                                     'in which the current model '
                                                     'is deployed.',
                                      'properties': {'Params': {'$ref': '#/definitions/ModelInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'},
                    'UpgradeSeriesComplete': {'description': 'UpgradeSeriesComplete '
                                                             'marks a machine as '
                                                             'having completed a '
                                                             'managed series '
                                                             'upgrade.',
                                              'properties': {'Params': {'$ref': '#/definitions/UpdateSeriesArg'},
                                                             'Result': {'$ref': '#/definitions/ErrorResult'}},
                                              'type': 'object'},
                    'UpgradeSeriesPrepare': {'description': 'UpgradeSeriesPrepare '
                                                            'prepares a machine '
                                                            'for a OS series '
                                                            'upgrade.',
                                             'properties': {'Params': {'$ref': '#/definitions/UpdateSeriesArg'},
                                                            'Result': {'$ref': '#/definitions/ErrorResult'}},
                                             'type': 'object'},
                    'UpgradeSeriesValidate': {'description': 'UpgradeSeriesValidate '
                                                             'validates that the '
                                                             'incoming arguments '
                                                             'correspond to a\n'
                                                             'valid series upgrade '
                                                             'for the target '
                                                             'machine.\n'
                                                             'If they do, a list '
                                                             "of the machine's "
                                                             'current units is '
                                                             'returned for use in\n'
                                                             'soliciting user '
                                                             'confirmation of the '
                                                             'command.',
                                              'properties': {'Params': {'$ref': '#/definitions/UpdateSeriesArgs'},
                                                             'Result': {'$ref': '#/definitions/UpgradeSeriesUnitsResults'}},
                                              'type': 'object'},
                    'WatchUpgradeSeriesNotifications': {'description': 'WatchUpgradeSeriesNotifications '
                                                                       'returns a '
                                                                       'watcher '
                                                                       'that fires '
                                                                       'on upgrade '
                                                                       'series '
                                                                       'events.',
                                                        'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                       'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddMachinesResults)
    async def AddMachines(self, params=None):
        '''
        AddMachines adds new machines with the supplied parameters.

        params : typing.Sequence[~AddMachineParams]
        Returns -> AddMachinesResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='AddMachines',
                   version=6,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyMachineResults)
    async def DestroyMachine(self, entities=None):
        '''
        DestroyMachine removes a set of machines from the model.

        entities : typing.Sequence[~Entity]
        Returns -> DestroyMachineResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='DestroyMachine',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyMachineResults)
    async def DestroyMachineWithParams(self, force=None, keep=None, machine_tags=None, max_wait=None):
        '''
        DestroyMachineWithParams removes a set of machines from the model.

        force : bool
        keep : bool
        machine_tags : typing.Sequence[str]
        max_wait : int
        Returns -> DestroyMachineResults
        '''
        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if keep is not None and not isinstance(keep, bool):
            raise Exception("Expected keep to be a bool, received: {}".format(type(keep)))

        if machine_tags is not None and not isinstance(machine_tags, (bytes, str, list)):
            raise Exception("Expected machine_tags to be a Sequence, received: {}".format(type(machine_tags)))

        if max_wait is not None and not isinstance(max_wait, int):
            raise Exception("Expected max_wait to be a int, received: {}".format(type(max_wait)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='DestroyMachineWithParams',
                   version=6,
                   params=_params)
        _params['force'] = force
        _params['keep'] = keep
        _params['machine-tags'] = machine_tags
        _params['max-wait'] = max_wait
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyMachineResults)
    async def ForceDestroyMachine(self, entities=None):
        '''
        ForceDestroyMachine forcibly removes a set of machines from the model.
        TODO (anastasiamac 2019-4-24) From Juju 3.0 this call will be removed in favour of DestroyMachinesWithParams.
        Also from ModelManger v6 this call is less useful as it does not support MaxWait customisation.

        entities : typing.Sequence[~Entity]
        Returns -> DestroyMachineResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='ForceDestroyMachine',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def GetUpgradeSeriesMessages(self, params=None):
        '''
        GetUpgradeSeriesMessages returns all new messages associated with upgrade
        series events. Messages that have already been retrieved once are not
        returned by this method.

        params : typing.Sequence[~UpgradeSeriesNotificationParam]
        Returns -> StringsResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='GetUpgradeSeriesMessages',
                   version=6,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints=None):
        '''
        InstanceTypes returns instance type information for the cloud and region
        in which the current model is deployed.

        constraints : typing.Sequence[~ModelInstanceTypesConstraint]
        Returns -> InstanceTypesResults
        '''
        if constraints is not None and not isinstance(constraints, (bytes, str, list)):
            raise Exception("Expected constraints to be a Sequence, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='InstanceTypes',
                   version=6,
                   params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def UpgradeSeriesComplete(self, force=None, series=None, tag=None):
        '''
        UpgradeSeriesComplete marks a machine as having completed a managed series upgrade.

        force : bool
        series : str
        tag : Entity
        Returns -> ErrorResult
        '''
        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if series is not None and not isinstance(series, (bytes, str)):
            raise Exception("Expected series to be a str, received: {}".format(type(series)))

        if tag is not None and not isinstance(tag, (dict, Entity)):
            raise Exception("Expected tag to be a Entity, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='UpgradeSeriesComplete',
                   version=6,
                   params=_params)
        _params['force'] = force
        _params['series'] = series
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def UpgradeSeriesPrepare(self, force=None, series=None, tag=None):
        '''
        UpgradeSeriesPrepare prepares a machine for a OS series upgrade.

        force : bool
        series : str
        tag : Entity
        Returns -> ErrorResult
        '''
        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if series is not None and not isinstance(series, (bytes, str)):
            raise Exception("Expected series to be a str, received: {}".format(type(series)))

        if tag is not None and not isinstance(tag, (dict, Entity)):
            raise Exception("Expected tag to be a Entity, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='UpgradeSeriesPrepare',
                   version=6,
                   params=_params)
        _params['force'] = force
        _params['series'] = series
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpgradeSeriesUnitsResults)
    async def UpgradeSeriesValidate(self, args=None):
        '''
        UpgradeSeriesValidate validates that the incoming arguments correspond to a
        valid series upgrade for the target machine.
        If they do, a list of the machine's current units is returned for use in
        soliciting user confirmation of the command.

        args : typing.Sequence[~UpdateSeriesArg]
        Returns -> UpgradeSeriesUnitsResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='UpgradeSeriesValidate',
                   version=6,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchUpgradeSeriesNotifications(self, entities=None):
        '''
        WatchUpgradeSeriesNotifications returns a watcher that fires on upgrade series events.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='WatchUpgradeSeriesNotifications',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SpacesFacade(Type):
    name = 'Spaces'
    version = 6
    schema =     {'definitions': {'CreateSpaceParams': {'additionalProperties': False,
                                           'properties': {'cidrs': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                          'provider-id': {'type': 'string'},
                                                          'public': {'type': 'boolean'},
                                                          'space-tag': {'type': 'string'}},
                                           'required': ['cidrs',
                                                        'space-tag',
                                                        'public'],
                                           'type': 'object'},
                     'CreateSpacesParams': {'additionalProperties': False,
                                            'properties': {'spaces': {'items': {'$ref': '#/definitions/CreateSpaceParams'},
                                                                      'type': 'array'}},
                                            'required': ['spaces'],
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSpacesResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/Space'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'MoveSubnetsParam': {'additionalProperties': False,
                                          'properties': {'force': {'type': 'boolean'},
                                                         'space-tag': {'type': 'string'},
                                                         'subnets': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['subnets',
                                                       'space-tag',
                                                       'force'],
                                          'type': 'object'},
                     'MoveSubnetsParams': {'additionalProperties': False,
                                           'properties': {'args': {'items': {'$ref': '#/definitions/MoveSubnetsParam'},
                                                                   'type': 'array'}},
                                           'required': ['args'],
                                           'type': 'object'},
                     'MoveSubnetsResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'moved-subnets': {'items': {'$ref': '#/definitions/MovedSubnet'},
                                                                            'type': 'array'},
                                                          'new-space': {'type': 'string'}},
                                           'required': ['new-space'],
                                           'type': 'object'},
                     'MoveSubnetsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/MoveSubnetsResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'MovedSubnet': {'additionalProperties': False,
                                     'properties': {'cidr': {'type': 'string'},
                                                    'old-space': {'type': 'string'},
                                                    'subnet': {'type': 'string'}},
                                     'required': ['subnet', 'old-space', 'cidr'],
                                     'type': 'object'},
                     'RemoveSpaceParam': {'additionalProperties': False,
                                          'properties': {'dry-run': {'type': 'boolean'},
                                                         'force': {'type': 'boolean'},
                                                         'space': {'$ref': '#/definitions/Entity'}},
                                          'required': ['space'],
                                          'type': 'object'},
                     'RemoveSpaceParams': {'additionalProperties': False,
                                           'properties': {'space-param': {'items': {'$ref': '#/definitions/RemoveSpaceParam'},
                                                                          'type': 'array'}},
                                           'required': ['space-param'],
                                           'type': 'object'},
                     'RemoveSpaceResult': {'additionalProperties': False,
                                           'properties': {'bindings': {'items': {'$ref': '#/definitions/Entity'},
                                                                       'type': 'array'},
                                                          'constraints': {'items': {'$ref': '#/definitions/Entity'},
                                                                          'type': 'array'},
                                                          'controller-settings': {'items': {'type': 'string'},
                                                                                  'type': 'array'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'type': 'object'},
                     'RemoveSpaceResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/RemoveSpaceResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'RenameSpaceParams': {'additionalProperties': False,
                                           'properties': {'from-space-tag': {'type': 'string'},
                                                          'to-space-tag': {'type': 'string'}},
                                           'required': ['from-space-tag',
                                                        'to-space-tag'],
                                           'type': 'object'},
                     'RenameSpacesParams': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'$ref': '#/definitions/RenameSpaceParams'},
                                                                       'type': 'array'}},
                                            'required': ['changes'],
                                            'type': 'object'},
                     'ShowSpaceResult': {'additionalProperties': False,
                                         'properties': {'applications': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                        'error': {'$ref': '#/definitions/Error'},
                                                        'machine-count': {'type': 'integer'},
                                                        'space': {'$ref': '#/definitions/Space'}},
                                         'required': ['space',
                                                      'applications',
                                                      'machine-count'],
                                         'type': 'object'},
                     'ShowSpaceResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/ShowSpaceResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'Space': {'additionalProperties': False,
                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                              'id': {'type': 'string'},
                                              'name': {'type': 'string'},
                                              'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                          'type': 'array'}},
                               'required': ['id', 'name', 'subnets'],
                               'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'}},
     'properties': {'CreateSpaces': {'description': 'CreateSpaces creates a new '
                                                    'Juju network space, '
                                                    'associating the\n'
                                                    'specified subnets with it '
                                                    '(optional; can be empty).',
                                     'properties': {'Params': {'$ref': '#/definitions/CreateSpacesParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListSpaces': {'description': 'ListSpaces lists all the '
                                                  'available spaces and their '
                                                  'associated subnets.',
                                   'properties': {'Result': {'$ref': '#/definitions/ListSpacesResults'}},
                                   'type': 'object'},
                    'MoveSubnets': {'description': 'MoveSubnets ensures that the '
                                                   'input subnets are in the input '
                                                   'space.',
                                    'properties': {'Params': {'$ref': '#/definitions/MoveSubnetsParams'},
                                                   'Result': {'$ref': '#/definitions/MoveSubnetsResults'}},
                                    'type': 'object'},
                    'ReloadSpaces': {'description': 'ReloadSpaces refreshes spaces '
                                                    'from substrate',
                                     'type': 'object'},
                    'RemoveSpace': {'description': 'RemoveSpace removes a space.\n'
                                                   'Returns SpaceResults if '
                                                   'entities/settings are found '
                                                   'which makes the deletion not '
                                                   'possible.',
                                    'properties': {'Params': {'$ref': '#/definitions/RemoveSpaceParams'},
                                                   'Result': {'$ref': '#/definitions/RemoveSpaceResults'}},
                                    'type': 'object'},
                    'RenameSpace': {'description': 'RenameSpace renames a space.',
                                    'properties': {'Params': {'$ref': '#/definitions/RenameSpacesParams'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'ShowSpace': {'description': 'ShowSpace shows the spaces for a '
                                                 'set of given entities.',
                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ShowSpaceResults'}},
                                  'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def CreateSpaces(self, spaces=None):
        '''
        CreateSpaces creates a new Juju network space, associating the
        specified subnets with it (optional; can be empty).

        spaces : typing.Sequence[~CreateSpaceParams]
        Returns -> ErrorResults
        '''
        if spaces is not None and not isinstance(spaces, (bytes, str, list)):
            raise Exception("Expected spaces to be a Sequence, received: {}".format(type(spaces)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='CreateSpaces',
                   version=6,
                   params=_params)
        _params['spaces'] = spaces
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSpacesResults)
    async def ListSpaces(self):
        '''
        ListSpaces lists all the available spaces and their associated subnets.


        Returns -> ListSpacesResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='ListSpaces',
                   version=6,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MoveSubnetsResults)
    async def MoveSubnets(self, args=None):
        '''
        MoveSubnets ensures that the input subnets are in the input space.

        args : typing.Sequence[~MoveSubnetsParam]
        Returns -> MoveSubnetsResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='MoveSubnets',
                   version=6,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ReloadSpaces(self):
        '''
        ReloadSpaces refreshes spaces from substrate


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='ReloadSpaces',
                   version=6,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoveSpaceResults)
    async def RemoveSpace(self, space_param=None):
        '''
        RemoveSpace removes a space.
        Returns SpaceResults if entities/settings are found which makes the deletion not possible.

        space_param : typing.Sequence[~RemoveSpaceParam]
        Returns -> RemoveSpaceResults
        '''
        if space_param is not None and not isinstance(space_param, (bytes, str, list)):
            raise Exception("Expected space_param to be a Sequence, received: {}".format(type(space_param)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='RemoveSpace',
                   version=6,
                   params=_params)
        _params['space-param'] = space_param
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RenameSpace(self, changes=None):
        '''
        RenameSpace renames a space.

        changes : typing.Sequence[~RenameSpaceParams]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='RenameSpace',
                   version=6,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ShowSpaceResults)
    async def ShowSpace(self, entities=None):
        '''
        ShowSpace shows the spaces for a set of given entities.

        entities : typing.Sequence[~Entity]
        Returns -> ShowSpaceResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='ShowSpace',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class StorageFacade(Type):
    name = 'Storage'
    version = 6
    schema =     {'definitions': {'AddStorageDetails': {'additionalProperties': False,
                                           'properties': {'storage-tags': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                           'required': ['storage-tags'],
                                           'type': 'object'},
                     'AddStorageResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/AddStorageDetails'}},
                                          'type': 'object'},
                     'AddStorageResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/AddStorageResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'BulkImportStorageParams': {'additionalProperties': False,
                                                 'properties': {'storage': {'items': {'$ref': '#/definitions/ImportStorageParams'},
                                                                            'type': 'array'}},
                                                 'required': ['storage'],
                                                 'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FilesystemAttachmentDetails': {'additionalProperties': False,
                                                     'properties': {'FilesystemAttachmentInfo': {'$ref': '#/definitions/FilesystemAttachmentInfo'},
                                                                    'life': {'type': 'string'},
                                                                    'mount-point': {'type': 'string'},
                                                                    'read-only': {'type': 'boolean'}},
                                                     'required': ['FilesystemAttachmentInfo'],
                                                     'type': 'object'},
                     'FilesystemAttachmentInfo': {'additionalProperties': False,
                                                  'properties': {'mount-point': {'type': 'string'},
                                                                 'read-only': {'type': 'boolean'}},
                                                  'type': 'object'},
                     'FilesystemDetails': {'additionalProperties': False,
                                           'properties': {'filesystem-tag': {'type': 'string'},
                                                          'info': {'$ref': '#/definitions/FilesystemInfo'},
                                                          'life': {'type': 'string'},
                                                          'machine-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/FilesystemAttachmentDetails'}},
                                                                                  'type': 'object'},
                                                          'status': {'$ref': '#/definitions/EntityStatus'},
                                                          'storage': {'$ref': '#/definitions/StorageDetails'},
                                                          'unit-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/FilesystemAttachmentDetails'}},
                                                                               'type': 'object'},
                                                          'volume-tag': {'type': 'string'}},
                                           'required': ['filesystem-tag',
                                                        'info',
                                                        'status'],
                                           'type': 'object'},
                     'FilesystemDetailsListResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'result': {'items': {'$ref': '#/definitions/FilesystemDetails'},
                                                                               'type': 'array'}},
                                                     'type': 'object'},
                     'FilesystemDetailsListResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemDetailsListResult'},
                                                                                 'type': 'array'}},
                                                      'type': 'object'},
                     'FilesystemFilter': {'additionalProperties': False,
                                          'properties': {'machines': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                          'type': 'object'},
                     'FilesystemFilters': {'additionalProperties': False,
                                           'properties': {'filters': {'items': {'$ref': '#/definitions/FilesystemFilter'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'FilesystemInfo': {'additionalProperties': False,
                                        'properties': {'filesystem-id': {'type': 'string'},
                                                       'pool': {'type': 'string'},
                                                       'size': {'type': 'integer'}},
                                        'required': ['filesystem-id',
                                                     'pool',
                                                     'size'],
                                        'type': 'object'},
                     'ImportStorageDetails': {'additionalProperties': False,
                                              'properties': {'storage-tag': {'type': 'string'}},
                                              'required': ['storage-tag'],
                                              'type': 'object'},
                     'ImportStorageParams': {'additionalProperties': False,
                                             'properties': {'kind': {'type': 'integer'},
                                                            'pool': {'type': 'string'},
                                                            'provider-id': {'type': 'string'},
                                                            'storage-name': {'type': 'string'}},
                                             'required': ['kind',
                                                          'pool',
                                                          'provider-id',
                                                          'storage-name'],
                                             'type': 'object'},
                     'ImportStorageResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ImportStorageDetails'}},
                                             'type': 'object'},
                     'ImportStorageResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ImportStorageResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'RemoveStorage': {'additionalProperties': False,
                                       'properties': {'storage': {'items': {'$ref': '#/definitions/RemoveStorageInstance'},
                                                                  'type': 'array'}},
                                       'required': ['storage'],
                                       'type': 'object'},
                     'RemoveStorageInstance': {'additionalProperties': False,
                                               'properties': {'destroy-attachments': {'type': 'boolean'},
                                                              'destroy-storage': {'type': 'boolean'},
                                                              'force': {'type': 'boolean'},
                                                              'max-wait': {'type': 'integer'},
                                                              'tag': {'type': 'string'}},
                                               'required': ['tag'],
                                               'type': 'object'},
                     'StorageAddParams': {'additionalProperties': False,
                                          'properties': {'name': {'type': 'string'},
                                                         'storage': {'$ref': '#/definitions/StorageConstraints'},
                                                         'unit': {'type': 'string'}},
                                          'required': ['unit', 'name', 'storage'],
                                          'type': 'object'},
                     'StorageAttachmentDetails': {'additionalProperties': False,
                                                  'properties': {'life': {'type': 'string'},
                                                                 'location': {'type': 'string'},
                                                                 'machine-tag': {'type': 'string'},
                                                                 'storage-tag': {'type': 'string'},
                                                                 'unit-tag': {'type': 'string'}},
                                                  'required': ['storage-tag',
                                                               'unit-tag',
                                                               'machine-tag'],
                                                  'type': 'object'},
                     'StorageAttachmentId': {'additionalProperties': False,
                                             'properties': {'storage-tag': {'type': 'string'},
                                                            'unit-tag': {'type': 'string'}},
                                             'required': ['storage-tag',
                                                          'unit-tag'],
                                             'type': 'object'},
                     'StorageAttachmentIds': {'additionalProperties': False,
                                              'properties': {'ids': {'items': {'$ref': '#/definitions/StorageAttachmentId'},
                                                                     'type': 'array'}},
                                              'required': ['ids'],
                                              'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StorageDetachmentParams': {'additionalProperties': False,
                                                 'properties': {'force': {'type': 'boolean'},
                                                                'ids': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                                'max-wait': {'type': 'integer'}},
                                                 'required': ['ids'],
                                                 'type': 'object'},
                     'StorageDetails': {'additionalProperties': False,
                                        'properties': {'attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageAttachmentDetails'}},
                                                                       'type': 'object'},
                                                       'kind': {'type': 'integer'},
                                                       'life': {'type': 'string'},
                                                       'owner-tag': {'type': 'string'},
                                                       'persistent': {'type': 'boolean'},
                                                       'status': {'$ref': '#/definitions/EntityStatus'},
                                                       'storage-tag': {'type': 'string'}},
                                        'required': ['storage-tag',
                                                     'owner-tag',
                                                     'kind',
                                                     'status',
                                                     'persistent'],
                                        'type': 'object'},
                     'StorageDetailsListResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'result': {'items': {'$ref': '#/definitions/StorageDetails'},
                                                                            'type': 'array'}},
                                                  'type': 'object'},
                     'StorageDetailsListResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/StorageDetailsListResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'StorageDetailsResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'result': {'$ref': '#/definitions/StorageDetails'}},
                                              'type': 'object'},
                     'StorageDetailsResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/StorageDetailsResult'},
                                                                          'type': 'array'}},
                                               'type': 'object'},
                     'StorageFilter': {'additionalProperties': False,
                                       'type': 'object'},
                     'StorageFilters': {'additionalProperties': False,
                                        'properties': {'filters': {'items': {'$ref': '#/definitions/StorageFilter'},
                                                                   'type': 'array'}},
                                        'type': 'object'},
                     'StoragePool': {'additionalProperties': False,
                                     'properties': {'attrs': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                    'name': {'type': 'string'},
                                                    'provider': {'type': 'string'}},
                                     'required': ['name', 'provider', 'attrs'],
                                     'type': 'object'},
                     'StoragePoolArgs': {'additionalProperties': False,
                                         'properties': {'pools': {'items': {'$ref': '#/definitions/StoragePool'},
                                                                  'type': 'array'}},
                                         'required': ['pools'],
                                         'type': 'object'},
                     'StoragePoolDeleteArg': {'additionalProperties': False,
                                              'properties': {'name': {'type': 'string'}},
                                              'required': ['name'],
                                              'type': 'object'},
                     'StoragePoolDeleteArgs': {'additionalProperties': False,
                                               'properties': {'pools': {'items': {'$ref': '#/definitions/StoragePoolDeleteArg'},
                                                                        'type': 'array'}},
                                               'required': ['pools'],
                                               'type': 'object'},
                     'StoragePoolFilter': {'additionalProperties': False,
                                           'properties': {'names': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                          'providers': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                           'type': 'object'},
                     'StoragePoolFilters': {'additionalProperties': False,
                                            'properties': {'filters': {'items': {'$ref': '#/definitions/StoragePoolFilter'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'StoragePoolsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'storage-pools': {'items': {'$ref': '#/definitions/StoragePool'},
                                                                             'type': 'array'}},
                                            'type': 'object'},
                     'StoragePoolsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StoragePoolsResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'},
                     'StoragesAddParams': {'additionalProperties': False,
                                           'properties': {'storages': {'items': {'$ref': '#/definitions/StorageAddParams'},
                                                                       'type': 'array'}},
                                           'required': ['storages'],
                                           'type': 'object'},
                     'VolumeAttachmentDetails': {'additionalProperties': False,
                                                 'properties': {'VolumeAttachmentInfo': {'$ref': '#/definitions/VolumeAttachmentInfo'},
                                                                'bus-address': {'type': 'string'},
                                                                'device-link': {'type': 'string'},
                                                                'device-name': {'type': 'string'},
                                                                'life': {'type': 'string'},
                                                                'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                                'read-only': {'type': 'boolean'}},
                                                 'required': ['VolumeAttachmentInfo'],
                                                 'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentPlanInfo': {'additionalProperties': False,
                                                  'properties': {'device-attributes': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                       'type': 'object'},
                                                                 'device-type': {'type': 'string'}},
                                                  'type': 'object'},
                     'VolumeDetails': {'additionalProperties': False,
                                       'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                                      'life': {'type': 'string'},
                                                      'machine-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentDetails'}},
                                                                              'type': 'object'},
                                                      'status': {'$ref': '#/definitions/EntityStatus'},
                                                      'storage': {'$ref': '#/definitions/StorageDetails'},
                                                      'unit-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentDetails'}},
                                                                           'type': 'object'},
                                                      'volume-tag': {'type': 'string'}},
                                       'required': ['volume-tag', 'info', 'status'],
                                       'type': 'object'},
                     'VolumeDetailsListResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'items': {'$ref': '#/definitions/VolumeDetails'},
                                                                           'type': 'array'}},
                                                 'type': 'object'},
                     'VolumeDetailsListResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/VolumeDetailsListResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'VolumeFilter': {'additionalProperties': False,
                                      'properties': {'machines': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'type': 'object'},
                     'VolumeFilters': {'additionalProperties': False,
                                       'properties': {'filters': {'items': {'$ref': '#/definitions/VolumeFilter'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'}},
     'properties': {'AddToUnit': {'description': 'AddToUnit validates and creates '
                                                 'additional storage instances for '
                                                 'units.\n'
                                                 'A "CHANGE" block can block this '
                                                 'operation.',
                                  'properties': {'Params': {'$ref': '#/definitions/StoragesAddParams'},
                                                 'Result': {'$ref': '#/definitions/AddStorageResults'}},
                                  'type': 'object'},
                    'Attach': {'description': 'Attach attaches existing storage '
                                              'instances to units.\n'
                                              'A "CHANGE" block can block this '
                                              'operation.',
                               'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'CreatePool': {'description': 'CreatePool creates a new pool '
                                                  'with specified parameters.',
                                   'properties': {'Params': {'$ref': '#/definitions/StoragePoolArgs'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'DetachStorage': {'description': 'DetachStorage sets the '
                                                     'specified storage '
                                                     'attachments to Dying, unless '
                                                     'they are\n'
                                                     'already Dying or Dead. Any '
                                                     'associated, persistent '
                                                     'storage will remain\n'
                                                     'alive. This call can be '
                                                     'forced.',
                                      'properties': {'Params': {'$ref': '#/definitions/StorageDetachmentParams'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'Import': {'description': 'Import imports existing storage '
                                              'into the model.\n'
                                              'A "CHANGE" block can block this '
                                              'operation.',
                               'properties': {'Params': {'$ref': '#/definitions/BulkImportStorageParams'},
                                              'Result': {'$ref': '#/definitions/ImportStorageResults'}},
                               'type': 'object'},
                    'ListFilesystems': {'description': 'ListFilesystems returns a '
                                                       'list of filesystems in the '
                                                       'environment matching\n'
                                                       'the provided filter. Each '
                                                       'result describes a '
                                                       'filesystem in detail, '
                                                       'including\n'
                                                       "the filesystem's "
                                                       'attachments.',
                                        'properties': {'Params': {'$ref': '#/definitions/FilesystemFilters'},
                                                       'Result': {'$ref': '#/definitions/FilesystemDetailsListResults'}},
                                        'type': 'object'},
                    'ListPools': {'description': 'ListPools returns a list of '
                                                 'pools.\n'
                                                 'If filter is provided, returned '
                                                 'list only contains pools that '
                                                 'match\n'
                                                 'the filter.\n'
                                                 'Pools can be filtered on names '
                                                 'and provider types.\n'
                                                 'If both names and types are '
                                                 'provided as filter,\n'
                                                 'pools that match either are '
                                                 'returned.\n'
                                                 'This method lists union of pools '
                                                 'and environment provider types.\n'
                                                 'If no filter is provided, all '
                                                 'pools are returned.',
                                  'properties': {'Params': {'$ref': '#/definitions/StoragePoolFilters'},
                                                 'Result': {'$ref': '#/definitions/StoragePoolsResults'}},
                                  'type': 'object'},
                    'ListStorageDetails': {'description': 'ListStorageDetails '
                                                          'returns storage '
                                                          'matching a filter.',
                                           'properties': {'Params': {'$ref': '#/definitions/StorageFilters'},
                                                          'Result': {'$ref': '#/definitions/StorageDetailsListResults'}},
                                           'type': 'object'},
                    'ListVolumes': {'description': 'ListVolumes lists volumes with '
                                                   'the given filters. Each filter '
                                                   'produces\n'
                                                   'an independent list of '
                                                   'volumes, or an error if the '
                                                   'filter is invalid\n'
                                                   'or the volumes could not be '
                                                   'listed.',
                                    'properties': {'Params': {'$ref': '#/definitions/VolumeFilters'},
                                                   'Result': {'$ref': '#/definitions/VolumeDetailsListResults'}},
                                    'type': 'object'},
                    'Remove': {'description': 'Remove sets the specified storage '
                                              'entities to Dying, unless they are\n'
                                              'already Dying or Dead, such that '
                                              'the storage will eventually be '
                                              'removed\n'
                                              'from the model. If the arguments '
                                              'specify that the storage should be\n'
                                              'destroyed, then the associated '
                                              'cloud storage will be destroyed '
                                              'first;\n'
                                              'otherwise it will only be released '
                                              "from Juju's control.",
                               'properties': {'Params': {'$ref': '#/definitions/RemoveStorage'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'RemovePool': {'description': 'RemovePool deletes the named '
                                                  'pool',
                                   'properties': {'Params': {'$ref': '#/definitions/StoragePoolDeleteArgs'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'StorageDetails': {'description': 'StorageDetails retrieves '
                                                      'and returns detailed '
                                                      'information about desired\n'
                                                      'storage identified by '
                                                      'supplied tags. If specified '
                                                      'storage cannot be\n'
                                                      'retrieved, individual error '
                                                      'is returned instead of '
                                                      'storage information.',
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StorageDetailsResults'}},
                                       'type': 'object'},
                    'UpdatePool': {'description': 'UpdatePool deletes the named '
                                                  'pool',
                                   'properties': {'Params': {'$ref': '#/definitions/StoragePoolArgs'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddStorageResults)
    async def AddToUnit(self, storages=None):
        '''
        AddToUnit validates and creates additional storage instances for units.
        A "CHANGE" block can block this operation.

        storages : typing.Sequence[~StorageAddParams]
        Returns -> AddStorageResults
        '''
        if storages is not None and not isinstance(storages, (bytes, str, list)):
            raise Exception("Expected storages to be a Sequence, received: {}".format(type(storages)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='AddToUnit',
                   version=6,
                   params=_params)
        _params['storages'] = storages
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Attach(self, ids=None):
        '''
        Attach attaches existing storage instances to units.
        A "CHANGE" block can block this operation.

        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> ErrorResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Attach',
                   version=6,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def CreatePool(self, pools=None):
        '''
        CreatePool creates a new pool with specified parameters.

        pools : typing.Sequence[~StoragePool]
        Returns -> ErrorResults
        '''
        if pools is not None and not isinstance(pools, (bytes, str, list)):
            raise Exception("Expected pools to be a Sequence, received: {}".format(type(pools)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='CreatePool',
                   version=6,
                   params=_params)
        _params['pools'] = pools
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DetachStorage(self, force=None, ids=None, max_wait=None):
        '''
        DetachStorage sets the specified storage attachments to Dying, unless they are
        already Dying or Dead. Any associated, persistent storage will remain
        alive. This call can be forced.

        force : bool
        ids : StorageAttachmentIds
        max_wait : int
        Returns -> ErrorResults
        '''
        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if ids is not None and not isinstance(ids, (dict, StorageAttachmentIds)):
            raise Exception("Expected ids to be a StorageAttachmentIds, received: {}".format(type(ids)))

        if max_wait is not None and not isinstance(max_wait, int):
            raise Exception("Expected max_wait to be a int, received: {}".format(type(max_wait)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='DetachStorage',
                   version=6,
                   params=_params)
        _params['force'] = force
        _params['ids'] = ids
        _params['max-wait'] = max_wait
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ImportStorageResults)
    async def Import(self, storage=None):
        '''
        Import imports existing storage into the model.
        A "CHANGE" block can block this operation.

        storage : typing.Sequence[~ImportStorageParams]
        Returns -> ImportStorageResults
        '''
        if storage is not None and not isinstance(storage, (bytes, str, list)):
            raise Exception("Expected storage to be a Sequence, received: {}".format(type(storage)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Import',
                   version=6,
                   params=_params)
        _params['storage'] = storage
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemDetailsListResults)
    async def ListFilesystems(self, filters=None):
        '''
        ListFilesystems returns a list of filesystems in the environment matching
        the provided filter. Each result describes a filesystem in detail, including
        the filesystem's attachments.

        filters : typing.Sequence[~FilesystemFilter]
        Returns -> FilesystemDetailsListResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListFilesystems',
                   version=6,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StoragePoolsResults)
    async def ListPools(self, filters=None):
        '''
        ListPools returns a list of pools.
        If filter is provided, returned list only contains pools that match
        the filter.
        Pools can be filtered on names and provider types.
        If both names and types are provided as filter,
        pools that match either are returned.
        This method lists union of pools and environment provider types.
        If no filter is provided, all pools are returned.

        filters : typing.Sequence[~StoragePoolFilter]
        Returns -> StoragePoolsResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListPools',
                   version=6,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageDetailsListResults)
    async def ListStorageDetails(self, filters=None):
        '''
        ListStorageDetails returns storage matching a filter.

        filters : typing.Sequence[~StorageFilter]
        Returns -> StorageDetailsListResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListStorageDetails',
                   version=6,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeDetailsListResults)
    async def ListVolumes(self, filters=None):
        '''
        ListVolumes lists volumes with the given filters. Each filter produces
        an independent list of volumes, or an error if the filter is invalid
        or the volumes could not be listed.

        filters : typing.Sequence[~VolumeFilter]
        Returns -> VolumeDetailsListResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListVolumes',
                   version=6,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, storage=None):
        '''
        Remove sets the specified storage entities to Dying, unless they are
        already Dying or Dead, such that the storage will eventually be removed
        from the model. If the arguments specify that the storage should be
        destroyed, then the associated cloud storage will be destroyed first;
        otherwise it will only be released from Juju's control.

        storage : typing.Sequence[~RemoveStorageInstance]
        Returns -> ErrorResults
        '''
        if storage is not None and not isinstance(storage, (bytes, str, list)):
            raise Exception("Expected storage to be a Sequence, received: {}".format(type(storage)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Remove',
                   version=6,
                   params=_params)
        _params['storage'] = storage
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemovePool(self, pools=None):
        '''
        RemovePool deletes the named pool

        pools : typing.Sequence[~StoragePoolDeleteArg]
        Returns -> ErrorResults
        '''
        if pools is not None and not isinstance(pools, (bytes, str, list)):
            raise Exception("Expected pools to be a Sequence, received: {}".format(type(pools)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='RemovePool',
                   version=6,
                   params=_params)
        _params['pools'] = pools
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageDetailsResults)
    async def StorageDetails(self, entities=None):
        '''
        StorageDetails retrieves and returns detailed information about desired
        storage identified by supplied tags. If specified storage cannot be
        retrieved, individual error is returned instead of storage information.

        entities : typing.Sequence[~Entity]
        Returns -> StorageDetailsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='StorageDetails',
                   version=6,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdatePool(self, pools=None):
        '''
        UpdatePool deletes the named pool

        pools : typing.Sequence[~StoragePool]
        Returns -> ErrorResults
        '''
        if pools is not None and not isinstance(pools, (bytes, str, list)):
            raise Exception("Expected pools to be a Sequence, received: {}".format(type(pools)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='UpdatePool',
                   version=6,
                   params=_params)
        _params['pools'] = pools
        reply = await self.rpc(msg)
        return reply


