# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client.facade import Type, ReturnMapping
from juju.client._definitions import *


class ApplicationFacade(Type):
    name = 'Application'
    version = 4
    schema =     {'definitions': {'AddApplicationUnits': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'num-units': {'type': 'integer'},
                                                            'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                          'type': 'array'}},
                                             'required': ['application',
                                                          'num-units',
                                                          'placement'],
                                             'type': 'object'},
                     'AddApplicationUnitsResults': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'AddRelation': {'additionalProperties': False,
                                     'properties': {'endpoints': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                     'required': ['endpoints'],
                                     'type': 'object'},
                     'AddRelationResults': {'additionalProperties': False,
                                            'properties': {'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                                         'type': 'object'}},
                                            'required': ['endpoints'],
                                            'type': 'object'},
                     'ApplicationCharmRelations': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'ApplicationCharmRelationsResults': {'additionalProperties': False,
                                                          'properties': {'charm-relations': {'items': {'type': 'string'},
                                                                                             'type': 'array'}},
                                                          'required': ['charm-relations'],
                                                          'type': 'object'},
                     'ApplicationDeploy': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'channel': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                          'config-yaml': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'num-units': {'type': 'integer'},
                                                          'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                        'type': 'array'},
                                                          'resources': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'}},
                                           'required': ['application',
                                                        'series',
                                                        'charm-url',
                                                        'channel',
                                                        'num-units',
                                                        'config-yaml',
                                                        'constraints'],
                                           'type': 'object'},
                     'ApplicationDestroy': {'additionalProperties': False,
                                            'properties': {'application': {'type': 'string'}},
                                            'required': ['application'],
                                            'type': 'object'},
                     'ApplicationExpose': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'}},
                                           'required': ['application'],
                                           'type': 'object'},
                     'ApplicationGet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'}},
                                        'required': ['application'],
                                        'type': 'object'},
                     'ApplicationGetResults': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'charm': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'constraints': {'$ref': '#/definitions/Value'},
                                                              'series': {'type': 'string'}},
                                               'required': ['application',
                                                            'charm',
                                                            'config',
                                                            'constraints',
                                                            'series'],
                                               'type': 'object'},
                     'ApplicationMetricCredential': {'additionalProperties': False,
                                                     'properties': {'application': {'type': 'string'},
                                                                    'metrics-credentials': {'items': {'type': 'integer'},
                                                                                            'type': 'array'}},
                                                     'required': ['application',
                                                                  'metrics-credentials'],
                                                     'type': 'object'},
                     'ApplicationMetricCredentials': {'additionalProperties': False,
                                                      'properties': {'creds': {'items': {'$ref': '#/definitions/ApplicationMetricCredential'},
                                                                               'type': 'array'}},
                                                      'required': ['creds'],
                                                      'type': 'object'},
                     'ApplicationSet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'options': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'}},
                                        'required': ['application', 'options'],
                                        'type': 'object'},
                     'ApplicationSetCharm': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'channel': {'type': 'string'},
                                                            'charm-url': {'type': 'string'},
                                                            'config-settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                            'config-settings-yaml': {'type': 'string'},
                                                            'force-series': {'type': 'boolean'},
                                                            'force-units': {'type': 'boolean'},
                                                            'resource-ids': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                            'storage-constraints': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageConstraints'}},
                                                                                    'type': 'object'}},
                                             'required': ['application',
                                                          'charm-url',
                                                          'channel',
                                                          'force-units',
                                                          'force-series'],
                                             'type': 'object'},
                     'ApplicationURLs': {'additionalProperties': False,
                                         'properties': {'application-urls': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                         'type': 'object'},
                     'ApplicationUnexpose': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'}},
                                             'required': ['application'],
                                             'type': 'object'},
                     'ApplicationUnset': {'additionalProperties': False,
                                          'properties': {'application': {'type': 'string'},
                                                         'options': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['application', 'options'],
                                          'type': 'object'},
                     'ApplicationUpdate': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'force-charm-url': {'type': 'boolean'},
                                                          'force-series': {'type': 'boolean'},
                                                          'min-units': {'type': 'integer'},
                                                          'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                       'type': 'object'},
                                                          'settings-yaml': {'type': 'string'}},
                                           'required': ['application',
                                                        'charm-url',
                                                        'force-charm-url',
                                                        'force-series',
                                                        'settings-yaml'],
                                           'type': 'object'},
                     'ApplicationsDeploy': {'additionalProperties': False,
                                            'properties': {'applications': {'items': {'$ref': '#/definitions/ApplicationDeploy'},
                                                                            'type': 'array'}},
                                            'required': ['applications'],
                                            'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'ConsumeApplicationArg': {'additionalProperties': False,
                                               'properties': {'application-alias': {'type': 'string'},
                                                              'application-url': {'type': 'string'}},
                                               'required': ['application-url'],
                                               'type': 'object'},
                     'ConsumeApplicationArgs': {'additionalProperties': False,
                                                'properties': {'args': {'items': {'$ref': '#/definitions/ConsumeApplicationArg'},
                                                                        'type': 'array'}},
                                                'type': 'object'},
                     'ConsumeApplicationResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'local-name': {'type': 'string'}},
                                                  'type': 'object'},
                     'ConsumeApplicationResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/ConsumeApplicationResult'},
                                                                              'type': 'array'}},
                                                   'required': ['results'],
                                                   'type': 'object'},
                     'DestroyApplicationInfo': {'additionalProperties': False,
                                                'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                     'type': 'array'},
                                                               'destroyed-units': {'items': {'$ref': '#/definitions/Entity'},
                                                                                   'type': 'array'},
                                                               'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                    'type': 'array'}},
                                                'type': 'object'},
                     'DestroyApplicationResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'info': {'$ref': '#/definitions/DestroyApplicationInfo'}},
                                                  'type': 'object'},
                     'DestroyApplicationResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/DestroyApplicationResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'DestroyApplicationUnits': {'additionalProperties': False,
                                                 'properties': {'unit-names': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                 'required': ['unit-names'],
                                                 'type': 'object'},
                     'DestroyRelation': {'additionalProperties': False,
                                         'properties': {'endpoints': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                         'required': ['endpoints'],
                                         'type': 'object'},
                     'DestroyUnitInfo': {'additionalProperties': False,
                                         'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                              'type': 'array'},
                                                        'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                             'type': 'array'}},
                                         'type': 'object'},
                     'DestroyUnitResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'$ref': '#/definitions/DestroyUnitInfo'}},
                                           'type': 'object'},
                     'DestroyUnitResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/DestroyUnitResult'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetApplicationConstraints': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'RemoteApplicationInfo': {'additionalProperties': False,
                                               'properties': {'application-url': {'type': 'string'},
                                                              'description': {'type': 'string'},
                                                              'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                            'type': 'array'},
                                                              'icon-url-path': {'type': 'string'},
                                                              'model-tag': {'type': 'string'},
                                                              'name': {'type': 'string'},
                                                              'source-model-label': {'type': 'string'}},
                                               'required': ['model-tag',
                                                            'name',
                                                            'description',
                                                            'application-url',
                                                            'endpoints',
                                                            'icon-url-path'],
                                               'type': 'object'},
                     'RemoteApplicationInfoResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'result': {'$ref': '#/definitions/RemoteApplicationInfo'}},
                                                     'type': 'object'},
                     'RemoteApplicationInfoResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/RemoteApplicationInfoResult'},
                                                                                 'type': 'array'}},
                                                      'required': ['results'],
                                                      'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'},
                                                       'scope': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit',
                                                     'scope'],
                                        'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddRelation': {'properties': {'Params': {'$ref': '#/definitions/AddRelation'},
                                                   'Result': {'$ref': '#/definitions/AddRelationResults'}},
                                    'type': 'object'},
                    'AddUnits': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationUnits'},
                                                'Result': {'$ref': '#/definitions/AddApplicationUnitsResults'}},
                                 'type': 'object'},
                    'CharmRelations': {'properties': {'Params': {'$ref': '#/definitions/ApplicationCharmRelations'},
                                                      'Result': {'$ref': '#/definitions/ApplicationCharmRelationsResults'}},
                                       'type': 'object'},
                    'Consume': {'properties': {'Params': {'$ref': '#/definitions/ConsumeApplicationArgs'},
                                               'Result': {'$ref': '#/definitions/ConsumeApplicationResults'}},
                                'type': 'object'},
                    'Deploy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationsDeploy'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationDestroy'}},
                                'type': 'object'},
                    'DestroyApplication': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/DestroyApplicationResults'}},
                                           'type': 'object'},
                    'DestroyRelation': {'properties': {'Params': {'$ref': '#/definitions/DestroyRelation'}},
                                        'type': 'object'},
                    'DestroyUnit': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/DestroyUnitResults'}},
                                    'type': 'object'},
                    'DestroyUnits': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationUnits'}},
                                     'type': 'object'},
                    'Expose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationExpose'}},
                               'type': 'object'},
                    'Get': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                           'Result': {'$ref': '#/definitions/ApplicationGetResults'}},
                            'type': 'object'},
                    'GetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                                   'Result': {'$ref': '#/definitions/StringResult'}},
                                    'type': 'object'},
                    'GetConstraints': {'properties': {'Params': {'$ref': '#/definitions/GetApplicationConstraints'},
                                                      'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                       'type': 'object'},
                    'RemoteApplicationInfo': {'properties': {'Params': {'$ref': '#/definitions/ApplicationURLs'},
                                                             'Result': {'$ref': '#/definitions/RemoteApplicationInfoResults'}},
                                              'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSet'}},
                            'type': 'object'},
                    'SetCharm': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharm'}},
                                 'type': 'object'},
                    'SetConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                       'type': 'object'},
                    'SetMetricCredentials': {'properties': {'Params': {'$ref': '#/definitions/ApplicationMetricCredentials'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'Unexpose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnexpose'}},
                                 'type': 'object'},
                    'Unset': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnset'}},
                              'type': 'object'},
                    'Update': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUpdate'}},
                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddRelationResults)
    async def AddRelation(self, endpoints=None):
        '''
        endpoints : typing.Sequence[str]
        Returns -> AddRelationResults
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddRelation',
                   version=4,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddApplicationUnitsResults)
    async def AddUnits(self, application=None, num_units=None, placement=None):
        '''
        application : str
        num_units : int
        placement : typing.Sequence[~Placement]
        Returns -> AddApplicationUnitsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if num_units is not None and not isinstance(num_units, int):
            raise Exception("Expected num_units to be a int, received: {}".format(type(num_units)))

        if placement is not None and not isinstance(placement, (bytes, str, list)):
            raise Exception("Expected placement to be a Sequence, received: {}".format(type(placement)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddUnits',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['num-units'] = num_units
        _params['placement'] = placement
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmRelationsResults)
    async def CharmRelations(self, application=None):
        '''
        application : str
        Returns -> ApplicationCharmRelationsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmRelations',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConsumeApplicationResults)
    async def Consume(self, args=None):
        '''
        args : typing.Sequence[~ConsumeApplicationArg]
        Returns -> ConsumeApplicationResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Consume',
                   version=4,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Deploy(self, applications=None):
        '''
        applications : typing.Sequence[~ApplicationDeploy]
        Returns -> ErrorResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Deploy',
                   version=4,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Destroy(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Destroy',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyApplicationResults)
    async def DestroyApplication(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> DestroyApplicationResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyApplication',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyRelation(self, endpoints=None):
        '''
        endpoints : typing.Sequence[str]
        Returns -> None
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyRelation',
                   version=4,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyUnitResults)
    async def DestroyUnit(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> DestroyUnitResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnit',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyUnits(self, unit_names=None):
        '''
        unit_names : typing.Sequence[str]
        Returns -> None
        '''
        if unit_names is not None and not isinstance(unit_names, (bytes, str, list)):
            raise Exception("Expected unit_names to be a Sequence, received: {}".format(type(unit_names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnits',
                   version=4,
                   params=_params)
        _params['unit-names'] = unit_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Expose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Expose',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetResults)
    async def Get(self, application=None):
        '''
        application : str
        Returns -> ApplicationGetResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Get',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def GetCharmURL(self, application=None):
        '''
        application : str
        Returns -> StringResult
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetCharmURL',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetConstraints(self, application=None):
        '''
        application : str
        Returns -> GetConstraintsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConstraints',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteApplicationInfoResults)
    async def RemoteApplicationInfo(self, application_urls=None):
        '''
        application_urls : typing.Sequence[str]
        Returns -> RemoteApplicationInfoResults
        '''
        if application_urls is not None and not isinstance(application_urls, (bytes, str, list)):
            raise Exception("Expected application_urls to be a Sequence, received: {}".format(type(application_urls)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='RemoteApplicationInfo',
                   version=4,
                   params=_params)
        _params['application-urls'] = application_urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Set(self, application=None, options=None):
        '''
        application : str
        options : typing.Mapping[str, str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if options is not None and not isinstance(options, dict):
            raise Exception("Expected options to be a Mapping, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Set',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharm(self, application=None, channel=None, charm_url=None, config_settings=None, config_settings_yaml=None, force_series=None, force_units=None, resource_ids=None, storage_constraints=None):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping[str, str]
        config_settings_yaml : str
        force_series : bool
        force_units : bool
        resource_ids : typing.Mapping[str, str]
        storage_constraints : typing.Mapping[str, ~StorageConstraints]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if config_settings is not None and not isinstance(config_settings, dict):
            raise Exception("Expected config_settings to be a Mapping, received: {}".format(type(config_settings)))

        if config_settings_yaml is not None and not isinstance(config_settings_yaml, (bytes, str)):
            raise Exception("Expected config_settings_yaml to be a str, received: {}".format(type(config_settings_yaml)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if force_units is not None and not isinstance(force_units, bool):
            raise Exception("Expected force_units to be a bool, received: {}".format(type(force_units)))

        if resource_ids is not None and not isinstance(resource_ids, dict):
            raise Exception("Expected resource_ids to be a Mapping, received: {}".format(type(resource_ids)))

        if storage_constraints is not None and not isinstance(storage_constraints, dict):
            raise Exception("Expected storage_constraints to be a Mapping, received: {}".format(type(storage_constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetCharm',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['channel'] = channel
        _params['charm-url'] = charm_url
        _params['config-settings'] = config_settings
        _params['config-settings-yaml'] = config_settings_yaml
        _params['force-series'] = force_series
        _params['force-units'] = force_units
        _params['resource-ids'] = resource_ids
        _params['storage-constraints'] = storage_constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetConstraints(self, application=None, constraints=None):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetConstraints',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMetricCredentials(self, creds=None):
        '''
        creds : typing.Sequence[~ApplicationMetricCredential]
        Returns -> ErrorResults
        '''
        if creds is not None and not isinstance(creds, (bytes, str, list)):
            raise Exception("Expected creds to be a Sequence, received: {}".format(type(creds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetMetricCredentials',
                   version=4,
                   params=_params)
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unexpose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unexpose',
                   version=4,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unset(self, application=None, options=None):
        '''
        application : str
        options : typing.Sequence[str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if options is not None and not isinstance(options, (bytes, str, list)):
            raise Exception("Expected options to be a Sequence, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unset',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Update(self, application=None, charm_url=None, constraints=None, force_charm_url=None, force_series=None, min_units=None, settings=None, settings_yaml=None):
        '''
        application : str
        charm_url : str
        constraints : Value
        force_charm_url : bool
        force_series : bool
        min_units : int
        settings : typing.Mapping[str, str]
        settings_yaml : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        if force_charm_url is not None and not isinstance(force_charm_url, bool):
            raise Exception("Expected force_charm_url to be a bool, received: {}".format(type(force_charm_url)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if min_units is not None and not isinstance(min_units, int):
            raise Exception("Expected min_units to be a int, received: {}".format(type(min_units)))

        if settings is not None and not isinstance(settings, dict):
            raise Exception("Expected settings to be a Mapping, received: {}".format(type(settings)))

        if settings_yaml is not None and not isinstance(settings_yaml, (bytes, str)):
            raise Exception("Expected settings_yaml to be a str, received: {}".format(type(settings_yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Update',
                   version=4,
                   params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        _params['constraints'] = constraints
        _params['force-charm-url'] = force_charm_url
        _params['force-series'] = force_series
        _params['min-units'] = min_units
        _params['settings'] = settings
        _params['settings-yaml'] = settings_yaml
        reply = await self.rpc(msg)
        return reply



class BundleFacade(Type):
    name = 'Bundle'
    version = 4
    schema =     {'definitions': {'BundleChange': {'additionalProperties': False,
                                      'properties': {'args': {'items': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                              'type': 'array'},
                                                     'id': {'type': 'string'},
                                                     'method': {'type': 'string'},
                                                     'requires': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['id',
                                                   'method',
                                                   'args',
                                                   'requires'],
                                      'type': 'object'},
                     'BundleChangesMapArgs': {'additionalProperties': False,
                                              'properties': {'args': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                   'type': 'object'}},
                                                                      'type': 'object'},
                                                             'id': {'type': 'string'},
                                                             'method': {'type': 'string'},
                                                             'requires': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                              'required': ['id',
                                                           'method',
                                                           'args',
                                                           'requires'],
                                              'type': 'object'},
                     'BundleChangesMapArgsResults': {'additionalProperties': False,
                                                     'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChangesMapArgs'},
                                                                                'type': 'array'},
                                                                    'errors': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                     'type': 'object'},
                     'BundleChangesParams': {'additionalProperties': False,
                                             'properties': {'bundleURL': {'type': 'string'},
                                                            'yaml': {'type': 'string'}},
                                             'required': ['yaml', 'bundleURL'],
                                             'type': 'object'},
                     'BundleChangesResults': {'additionalProperties': False,
                                              'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChange'},
                                                                         'type': 'array'},
                                                             'errors': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                              'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'}},
     'properties': {'ExportBundle': {'description': 'ExportBundle exports the '
                                                    'current model configuration '
                                                    'as bundle.',
                                     'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'GetChanges': {'description': 'GetChanges returns the list of '
                                                  'changes required to deploy the '
                                                  'given bundle\n'
                                                  'data. The changes are sorted by '
                                                  'requirements, so that they can '
                                                  'be applied in\n'
                                                  'order.\n'
                                                  'GetChanges has been superseded '
                                                  'in favour of GetChangesMapArgs. '
                                                  "It's\n"
                                                  'preferable to use that new '
                                                  'method to add new functionality '
                                                  'and move clients\n'
                                                  'away from this one.',
                                   'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                  'Result': {'$ref': '#/definitions/BundleChangesResults'}},
                                   'type': 'object'},
                    'GetChangesMapArgs': {'description': 'GetChangesMapArgs '
                                                         'returns the list of '
                                                         'changes required to '
                                                         'deploy the given\n'
                                                         'bundle data. The changes '
                                                         'are sorted by '
                                                         'requirements, so that '
                                                         'they can be\n'
                                                         'applied in order.\n'
                                                         'V4 GetChangesMapArgs is '
                                                         'not supported on '
                                                         'anything less than v4',
                                          'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                         'Result': {'$ref': '#/definitions/BundleChangesMapArgsResults'}},
                                          'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringResult)
    async def ExportBundle(self):
        '''
        ExportBundle exports the current model configuration as bundle.


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Bundle',
                   request='ExportBundle',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BundleChangesResults)
    async def GetChanges(self, bundleurl=None, yaml=None):
        '''
        GetChanges returns the list of changes required to deploy the given bundle
        data. The changes are sorted by requirements, so that they can be applied in
        order.
        GetChanges has been superseded in favour of GetChangesMapArgs. It's
        preferable to use that new method to add new functionality and move clients
        away from this one.

        bundleurl : str
        yaml : str
        Returns -> BundleChangesResults
        '''
        if bundleurl is not None and not isinstance(bundleurl, (bytes, str)):
            raise Exception("Expected bundleurl to be a str, received: {}".format(type(bundleurl)))

        if yaml is not None and not isinstance(yaml, (bytes, str)):
            raise Exception("Expected yaml to be a str, received: {}".format(type(yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Bundle',
                   request='GetChanges',
                   version=4,
                   params=_params)
        _params['bundleURL'] = bundleurl
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BundleChangesMapArgsResults)
    async def GetChangesMapArgs(self, bundleurl=None, yaml=None):
        '''
        GetChangesMapArgs returns the list of changes required to deploy the given
        bundle data. The changes are sorted by requirements, so that they can be
        applied in order.
        V4 GetChangesMapArgs is not supported on anything less than v4

        bundleurl : str
        yaml : str
        Returns -> BundleChangesMapArgsResults
        '''
        if bundleurl is not None and not isinstance(bundleurl, (bytes, str)):
            raise Exception("Expected bundleurl to be a str, received: {}".format(type(bundleurl)))

        if yaml is not None and not isinstance(yaml, (bytes, str)):
            raise Exception("Expected yaml to be a str, received: {}".format(type(yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Bundle',
                   request='GetChangesMapArgs',
                   version=4,
                   params=_params)
        _params['bundleURL'] = bundleurl
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



class InstancePollerFacade(Type):
    name = 'InstancePoller'
    version = 4
    schema =     {'definitions': {'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'MachineAddresses': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'addresses'],
                                          'type': 'object'},
                     'MachineAddressesResult': {'additionalProperties': False,
                                                'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                             'type': 'array'},
                                                               'error': {'$ref': '#/definitions/Error'}},
                                                'required': ['addresses'],
                                                'type': 'object'},
                     'MachineAddressesResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/MachineAddressesResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                    'type': 'array'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'is-default-gateway': {'type': 'boolean'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'origin': {'type': 'string'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-network-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'shadow-addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                           'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-network-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'ProviderNetworkConfig': {'additionalProperties': False,
                                               'properties': {'config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                         'type': 'array'},
                                                              'tag': {'type': 'string'}},
                                               'required': ['tag', 'config'],
                                               'type': 'object'},
                     'SetMachinesAddresses': {'additionalProperties': False,
                                              'properties': {'machine-addresses': {'items': {'$ref': '#/definitions/MachineAddresses'},
                                                                                   'type': 'array'}},
                                              'required': ['machine-addresses'],
                                              'type': 'object'},
                     'SetProviderNetworkConfig': {'additionalProperties': False,
                                                  'properties': {'args': {'items': {'$ref': '#/definitions/ProviderNetworkConfig'},
                                                                          'type': 'array'}},
                                                  'required': ['args'],
                                                  'type': 'object'},
                     'SetProviderNetworkConfigResult': {'additionalProperties': False,
                                                        'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                                     'type': 'array'},
                                                                       'error': {'$ref': '#/definitions/Error'},
                                                                       'modified': {'type': 'boolean'}},
                                                        'required': ['addresses',
                                                                     'modified'],
                                                        'type': 'object'},
                     'SetProviderNetworkConfigResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/SetProviderNetworkConfigResult'},
                                                                                    'type': 'array'}},
                                                         'required': ['results'],
                                                         'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StatusResult': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'id': {'type': 'string'},
                                                     'info': {'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['id',
                                                   'life',
                                                   'status',
                                                   'info',
                                                   'data',
                                                   'since'],
                                      'type': 'object'},
                     'StatusResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StatusResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'AreManuallyProvisioned': {'description': 'AreManuallyProvisioned '
                                                              'returns whether '
                                                              'each given entity '
                                                              'is\n'
                                                              'manually '
                                                              'provisioned or not. '
                                                              'Only machine tags '
                                                              'are accepted.',
                                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/BoolResults'}},
                                               'type': 'object'},
                    'InstanceId': {'description': 'InstanceId returns the provider '
                                                  'specific instance id for each '
                                                  'given\n'
                                                  'machine or an '
                                                  'CodeNotProvisioned error, if '
                                                  'not set.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'InstanceStatus': {'description': 'InstanceStatus returns the '
                                                      'instance status for each '
                                                      'given entity.\n'
                                                      'Only machine tags are '
                                                      'accepted.',
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StatusResults'}},
                                       'type': 'object'},
                    'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelConfig': {'description': 'ModelConfig returns the '
                                                   "current model's configuration.",
                                    'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ProviderAddresses': {'description': 'ProviderAddresses '
                                                         'returns the list of all '
                                                         'known provider '
                                                         'addresses\n'
                                                         'for each given entity. '
                                                         'Only machine tags are '
                                                         'accepted.',
                                          'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/MachineAddressesResults'}},
                                          'type': 'object'},
                    'SetInstanceStatus': {'description': 'SetInstanceStatus '
                                                         'updates the instance '
                                                         'status for each given '
                                                         'entity.\n'
                                                         'Only machine tags are '
                                                         'accepted.',
                                          'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetProviderAddresses': {'description': 'SetProviderAddresses '
                                                            'updates the list of '
                                                            'known provider '
                                                            'addresses\n'
                                                            'for each given '
                                                            'entity. Only machine '
                                                            'tags are accepted.',
                                             'properties': {'Params': {'$ref': '#/definitions/SetMachinesAddresses'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'SetProviderNetworkConfig': {'description': 'SetProviderNetworkConfig '
                                                                'updates the '
                                                                'provider '
                                                                'addresses for one '
                                                                'or more\n'
                                                                'machines.\n'
                                                                '\n'
                                                                "What's more, if "
                                                                'the client '
                                                                'request includes '
                                                                'provider-specific '
                                                                'IDs (e.g.\n'
                                                                'network, subnet '
                                                                'or address IDs), '
                                                                'this method will '
                                                                'also iterate any '
                                                                'present\n'
                                                                'link layer '
                                                                'devices (and '
                                                                'their addresses) '
                                                                'and merge in any '
                                                                'missing\n'
                                                                'provider-specific '
                                                                'information.',
                                                 'properties': {'Params': {'$ref': '#/definitions/SetProviderNetworkConfig'},
                                                                'Result': {'$ref': '#/definitions/SetProviderNetworkConfigResults'}},
                                                 'type': 'object'},
                    'Status': {'description': 'Status returns the status of each '
                                              'given entity.',
                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StatusResults'}},
                               'type': 'object'},
                    'WatchForModelConfigChanges': {'description': 'WatchForModelConfigChanges '
                                                                  'returns a '
                                                                  'NotifyWatcher '
                                                                  'that observes\n'
                                                                  'changes to the '
                                                                  'model '
                                                                  'configuration.\n'
                                                                  'Note that '
                                                                  'although the '
                                                                  'NotifyWatchResult '
                                                                  'contains an '
                                                                  'Error field,\n'
                                                                  "it's not used "
                                                                  'because we are '
                                                                  'only returning '
                                                                  'a single '
                                                                  'watcher,\n'
                                                                  'so we use the '
                                                                  'regular error '
                                                                  'return.',
                                                   'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchModelMachineStartTimes': {'description': 'WatchModelMachineStartTimes '
                                                                   'watches the '
                                                                   'non-container '
                                                                   'machines in '
                                                                   'the model\n'
                                                                   'for changes to '
                                                                   'the Life or '
                                                                   'AgentStartTime '
                                                                   'fields and '
                                                                   'reports them '
                                                                   'as a batch.',
                                                    'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                                    'type': 'object'},
                    'WatchModelMachines': {'description': 'WatchModelMachines '
                                                          'returns a '
                                                          'StringsWatcher that '
                                                          'notifies of\n'
                                                          'changes to the life '
                                                          'cycles of the top level '
                                                          'machines in the '
                                                          'current\n'
                                                          'model.',
                                           'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BoolResults)
    async def AreManuallyProvisioned(self, entities=None):
        '''
        AreManuallyProvisioned returns whether each given entity is
        manually provisioned or not. Only machine tags are accepted.

        entities : typing.Sequence[~Entity]
        Returns -> BoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='AreManuallyProvisioned',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities=None):
        '''
        InstanceId returns the provider specific instance id for each given
        machine or an CodeNotProvisioned error, if not set.

        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='InstanceId',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def InstanceStatus(self, entities=None):
        '''
        InstanceStatus returns the instance status for each given entity.
        Only machine tags are accepted.

        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='InstanceStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='Life',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''
        ModelConfig returns the current model's configuration.


        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='ModelConfig',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineAddressesResults)
    async def ProviderAddresses(self, entities=None):
        '''
        ProviderAddresses returns the list of all known provider addresses
        for each given entity. Only machine tags are accepted.

        entities : typing.Sequence[~Entity]
        Returns -> MachineAddressesResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='ProviderAddresses',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceStatus(self, entities=None):
        '''
        SetInstanceStatus updates the instance status for each given entity.
        Only machine tags are accepted.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='SetInstanceStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetProviderAddresses(self, machine_addresses=None):
        '''
        SetProviderAddresses updates the list of known provider addresses
        for each given entity. Only machine tags are accepted.

        machine_addresses : typing.Sequence[~MachineAddresses]
        Returns -> ErrorResults
        '''
        if machine_addresses is not None and not isinstance(machine_addresses, (bytes, str, list)):
            raise Exception("Expected machine_addresses to be a Sequence, received: {}".format(type(machine_addresses)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='SetProviderAddresses',
                   version=4,
                   params=_params)
        _params['machine-addresses'] = machine_addresses
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SetProviderNetworkConfigResults)
    async def SetProviderNetworkConfig(self, args=None):
        '''
        SetProviderNetworkConfig updates the provider addresses for one or more
        machines.

        What's more, if the client request includes provider-specific IDs (e.g.
        network, subnet or address IDs), this method will also iterate any present
        link layer devices (and their addresses) and merge in any missing
        provider-specific information.

        args : typing.Sequence[~ProviderNetworkConfig]
        Returns -> SetProviderNetworkConfigResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='SetProviderNetworkConfig',
                   version=4,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def Status(self, entities=None):
        '''
        Status returns the status of each given entity.

        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='Status',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''
        WatchForModelConfigChanges returns a NotifyWatcher that observes
        changes to the model configuration.
        Note that although the NotifyWatchResult contains an Error field,
        it's not used because we are only returning a single watcher,
        so we use the regular error return.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='WatchForModelConfigChanges',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachineStartTimes(self):
        '''
        WatchModelMachineStartTimes watches the non-container machines in the model
        for changes to the Life or AgentStartTime fields and reports them as a batch.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='WatchModelMachineStartTimes',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachines(self):
        '''
        WatchModelMachines returns a StringsWatcher that notifies of
        changes to the life cycles of the top level machines in the current
        model.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstancePoller',
                   request='WatchModelMachines',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class MachinerFacade(Type):
    name = 'Machiner'
    version = 4
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'JobsResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'jobs': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['jobs'],
                                    'type': 'object'},
                     'JobsResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/JobsResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'MachineAddresses': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'addresses'],
                                          'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                    'type': 'array'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'is-default-gateway': {'type': 'boolean'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'origin': {'type': 'string'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-network-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'shadow-addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                           'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-network-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetMachineNetworkConfig': {'additionalProperties': False,
                                                 'properties': {'config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                           'type': 'array'},
                                                                'tag': {'type': 'string'}},
                                                 'required': ['tag', 'config'],
                                                 'type': 'object'},
                     'SetMachinesAddresses': {'additionalProperties': False,
                                              'properties': {'machine-addresses': {'items': {'$ref': '#/definitions/MachineAddresses'},
                                                                                   'type': 'array'}},
                                              'required': ['machine-addresses'],
                                              'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'}},
     'properties': {'APIAddresses': {'description': 'APIAddresses returns the list '
                                                    'of addresses used to connect '
                                                    'to the API.',
                                     'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'description': 'APIHostPorts returns the API '
                                                    'server addresses.',
                                     'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'EnsureDead': {'description': 'EnsureDead calls EnsureDead on '
                                                  'each given entity from state. '
                                                  'It\n'
                                                  'will fail if the entity is not '
                                                  "present. If it's Alive, nothing "
                                                  'will\n'
                                                  'happen (see state/EnsureDead() '
                                                  'for units or machines).',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'Jobs': {'description': 'Jobs returns the jobs assigned to the '
                                            'given entities.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/JobsResults'}},
                             'type': 'object'},
                    'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelUUID': {'description': 'ModelUUID returns the model UUID '
                                                 'to connect to the model\n'
                                                 'that the current connection is '
                                                 'for.',
                                  'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'RecordAgentStartTime': {'description': 'RecordAgentStartTime '
                                                            'updates the agent '
                                                            'start time field in '
                                                            'the machine doc.',
                                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'SetMachineAddresses': {'properties': {'Params': {'$ref': '#/definitions/SetMachinesAddresses'},
                                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                                            'type': 'object'},
                    'SetObservedNetworkConfig': {'description': 'SetObservedNetworkConfig '
                                                                'reads the network '
                                                                'config for the '
                                                                'machine\n'
                                                                'identified by the '
                                                                'input args.\n'
                                                                'This config is '
                                                                'merged with the '
                                                                'new network '
                                                                'config supplied '
                                                                'in the\n'
                                                                'same args and '
                                                                'updated if it has '
                                                                'changed.',
                                                 'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                 'type': 'object'},
                    'SetStatus': {'description': 'SetStatus sets the status of '
                                                 'each given entity.',
                                  'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'UpdateStatus': {'description': 'UpdateStatus updates the '
                                                    'status data of each given '
                                                    'entity.\n'
                                                    'TODO(fwereade): WTF. This '
                                                    'method exists *only* for the '
                                                    'convenience of the\n'
                                                    '*client* API -- and is itself '
                                                    'completely broken -- but we '
                                                    'still expose it\n'
                                                    'in every facade with a '
                                                    'StatusSetter? FFS.',
                                     'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'Watch': {'description': 'Watch starts an NotifyWatcher for '
                                             'each given entity.',
                              'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchAPIHostPorts': {'description': 'WatchAPIHostPorts '
                                                         'watches the API server '
                                                         'addresses.',
                                          'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''
        APIAddresses returns the list of addresses used to connect to the API.


        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='APIAddresses',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''
        APIHostPorts returns the API server addresses.


        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='APIHostPorts',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities=None):
        '''
        EnsureDead calls EnsureDead on each given entity from state. It
        will fail if the entity is not present. If it's Alive, nothing will
        happen (see state/EnsureDead() for units or machines).

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='EnsureDead',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(JobsResults)
    async def Jobs(self, entities=None):
        '''
        Jobs returns the jobs assigned to the given entities.

        entities : typing.Sequence[~Entity]
        Returns -> JobsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='Jobs',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='Life',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''
        ModelUUID returns the model UUID to connect to the model
        that the current connection is for.


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='ModelUUID',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RecordAgentStartTime(self, entities=None):
        '''
        RecordAgentStartTime updates the agent start time field in the machine doc.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='RecordAgentStartTime',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMachineAddresses(self, machine_addresses=None):
        '''
        machine_addresses : typing.Sequence[~MachineAddresses]
        Returns -> ErrorResults
        '''
        if machine_addresses is not None and not isinstance(machine_addresses, (bytes, str, list)):
            raise Exception("Expected machine_addresses to be a Sequence, received: {}".format(type(machine_addresses)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetMachineAddresses',
                   version=4,
                   params=_params)
        _params['machine-addresses'] = machine_addresses
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetObservedNetworkConfig(self, config=None, tag=None):
        '''
        SetObservedNetworkConfig reads the network config for the machine
        identified by the input args.
        This config is merged with the new network config supplied in the
        same args and updated if it has changed.

        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetObservedNetworkConfig',
                   version=4,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        SetStatus sets the status of each given entity.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities=None):
        '''
        UpdateStatus updates the status data of each given entity.
        TODO(fwereade): WTF. This method exists *only* for the convenience of the
        *client* API -- and is itself completely broken -- but we still expose it
        in every facade with a StatusSetter? FFS.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='UpdateStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities=None):
        '''
        Watch starts an NotifyWatcher for each given entity.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='Watch',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''
        WatchAPIHostPorts watches the API server addresses.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='WatchAPIHostPorts',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ModelGenerationFacade(Type):
    name = 'ModelGeneration'
    version = 4
    schema =     {'definitions': {'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BranchArg': {'additionalProperties': False,
                                   'properties': {'branch': {'type': 'string'}},
                                   'required': ['branch'],
                                   'type': 'object'},
                     'BranchInfoArgs': {'additionalProperties': False,
                                        'properties': {'branches': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                       'detailed': {'type': 'boolean'}},
                                        'required': ['branches', 'detailed'],
                                        'type': 'object'},
                     'BranchResults': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'generations': {'items': {'$ref': '#/definitions/Generation'},
                                                                      'type': 'array'}},
                                       'required': ['generations'],
                                       'type': 'object'},
                     'BranchTrackArg': {'additionalProperties': False,
                                        'properties': {'branch': {'type': 'string'},
                                                       'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                    'type': 'array'},
                                                       'num-units': {'type': 'integer'}},
                                        'required': ['branch', 'entities'],
                                        'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Generation': {'additionalProperties': False,
                                    'properties': {'applications': {'items': {'$ref': '#/definitions/GenerationApplication'},
                                                                    'type': 'array'},
                                                   'branch': {'type': 'string'},
                                                   'completed': {'type': 'integer'},
                                                   'completed-by': {'type': 'string'},
                                                   'created': {'type': 'integer'},
                                                   'created-by': {'type': 'string'},
                                                   'generation-id': {'type': 'integer'}},
                                    'required': ['branch',
                                                 'created',
                                                 'created-by',
                                                 'applications'],
                                    'type': 'object'},
                     'GenerationApplication': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'pending': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                              'progress': {'type': 'string'},
                                                              'tracking': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                               'required': ['application',
                                                            'progress',
                                                            'config'],
                                               'type': 'object'},
                     'GenerationId': {'additionalProperties': False,
                                      'properties': {'generation-id': {'type': 'integer'}},
                                      'required': ['generation-id'],
                                      'type': 'object'},
                     'GenerationResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'generation': {'$ref': '#/definitions/Generation'}},
                                          'required': ['generation'],
                                          'type': 'object'},
                     'IntResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'type': 'integer'}},
                                   'required': ['result'],
                                   'type': 'object'}},
     'properties': {'AbortBranch': {'description': 'AbortBranch aborts the input '
                                                   'branch, marking it complete.  '
                                                   'However no\n'
                                                   'changes are made applicable to '
                                                   'the whole model.  No units may '
                                                   'be assigned\n'
                                                   'to the branch when aborting.',
                                    'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                   'Result': {'$ref': '#/definitions/ErrorResult'}},
                                    'type': 'object'},
                    'AddBranch': {'description': 'AddBranch adds a new branch with '
                                                 'the input name to the model.',
                                  'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                 'Result': {'$ref': '#/definitions/ErrorResult'}},
                                  'type': 'object'},
                    'BranchInfo': {'description': 'BranchInfo will return details '
                                                  'of branch identified by the '
                                                  'input argument,\n'
                                                  'including units on the branch '
                                                  'and the configuration disjoint '
                                                  'with the\n'
                                                  'master generation.\n'
                                                  'An error is returned if no '
                                                  'in-flight branch matching in '
                                                  'input is found.',
                                   'properties': {'Params': {'$ref': '#/definitions/BranchInfoArgs'},
                                                  'Result': {'$ref': '#/definitions/BranchResults'}},
                                   'type': 'object'},
                    'CommitBranch': {'description': 'CommitBranch commits the '
                                                    'input branch, making its '
                                                    'changes applicable to\n'
                                                    'the whole model and marking '
                                                    'it complete.',
                                     'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                    'Result': {'$ref': '#/definitions/IntResult'}},
                                     'type': 'object'},
                    'HasActiveBranch': {'description': 'HasActiveBranch returns a '
                                                       'true result if the input '
                                                       'model has an "in-flight"\n'
                                                       'branch matching the input '
                                                       'name.',
                                        'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                       'Result': {'$ref': '#/definitions/BoolResult'}},
                                        'type': 'object'},
                    'ListCommits': {'description': 'ListCommits will return the '
                                                   'commits, hence only branches '
                                                   'with generation_id higher than '
                                                   '0',
                                    'properties': {'Result': {'$ref': '#/definitions/BranchResults'}},
                                    'type': 'object'},
                    'ShowCommit': {'description': 'ShowCommit will return details '
                                                  'a commit given by its '
                                                  'generationId\n'
                                                  'An error is returned if either '
                                                  'no branch can be found '
                                                  'corresponding to the generation '
                                                  'id.\n'
                                                  'Or the generation id given is '
                                                  'below 1.',
                                   'properties': {'Params': {'$ref': '#/definitions/GenerationId'},
                                                  'Result': {'$ref': '#/definitions/GenerationResult'}},
                                   'type': 'object'},
                    'TrackBranch': {'description': 'TrackBranch marks the input '
                                                   'units and/or applications as '
                                                   'tracking the input\n'
                                                   'branch, causing them to '
                                                   'realise changes made under '
                                                   'that branch.',
                                    'properties': {'Params': {'$ref': '#/definitions/BranchTrackArg'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def AbortBranch(self, branch=None):
        '''
        AbortBranch aborts the input branch, marking it complete.  However no
        changes are made applicable to the whole model.  No units may be assigned
        to the branch when aborting.

        branch : str
        Returns -> ErrorResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='AbortBranch',
                   version=4,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def AddBranch(self, branch=None):
        '''
        AddBranch adds a new branch with the input name to the model.

        branch : str
        Returns -> ErrorResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='AddBranch',
                   version=4,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BranchResults)
    async def BranchInfo(self, branches=None, detailed=None):
        '''
        BranchInfo will return details of branch identified by the input argument,
        including units on the branch and the configuration disjoint with the
        master generation.
        An error is returned if no in-flight branch matching in input is found.

        branches : typing.Sequence[str]
        detailed : bool
        Returns -> BranchResults
        '''
        if branches is not None and not isinstance(branches, (bytes, str, list)):
            raise Exception("Expected branches to be a Sequence, received: {}".format(type(branches)))

        if detailed is not None and not isinstance(detailed, bool):
            raise Exception("Expected detailed to be a bool, received: {}".format(type(detailed)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='BranchInfo',
                   version=4,
                   params=_params)
        _params['branches'] = branches
        _params['detailed'] = detailed
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IntResult)
    async def CommitBranch(self, branch=None):
        '''
        CommitBranch commits the input branch, making its changes applicable to
        the whole model and marking it complete.

        branch : str
        Returns -> IntResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='CommitBranch',
                   version=4,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResult)
    async def HasActiveBranch(self, branch=None):
        '''
        HasActiveBranch returns a true result if the input model has an "in-flight"
        branch matching the input name.

        branch : str
        Returns -> BoolResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='HasActiveBranch',
                   version=4,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BranchResults)
    async def ListCommits(self):
        '''
        ListCommits will return the commits, hence only branches with generation_id higher than 0


        Returns -> BranchResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='ListCommits',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GenerationResult)
    async def ShowCommit(self, generation_id=None):
        '''
        ShowCommit will return details a commit given by its generationId
        An error is returned if either no branch can be found corresponding to the generation id.
        Or the generation id given is below 1.

        generation_id : int
        Returns -> GenerationResult
        '''
        if generation_id is not None and not isinstance(generation_id, int):
            raise Exception("Expected generation_id to be a int, received: {}".format(type(generation_id)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='ShowCommit',
                   version=4,
                   params=_params)
        _params['generation-id'] = generation_id
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def TrackBranch(self, branch=None, entities=None, num_units=None):
        '''
        TrackBranch marks the input units and/or applications as tracking the input
        branch, causing them to realise changes made under that branch.

        branch : str
        entities : typing.Sequence[~Entity]
        num_units : int
        Returns -> ErrorResults
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        if num_units is not None and not isinstance(num_units, int):
            raise Exception("Expected num_units to be a int, received: {}".format(type(num_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='TrackBranch',
                   version=4,
                   params=_params)
        _params['branch'] = branch
        _params['entities'] = entities
        _params['num-units'] = num_units
        reply = await self.rpc(msg)
        return reply



class StorageFacade(Type):
    name = 'Storage'
    version = 4
    schema =     {'definitions': {'AddStorageDetails': {'additionalProperties': False,
                                           'properties': {'storage-tags': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                           'required': ['storage-tags'],
                                           'type': 'object'},
                     'AddStorageResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/AddStorageDetails'}},
                                          'type': 'object'},
                     'AddStorageResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/AddStorageResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'BulkImportStorageParams': {'additionalProperties': False,
                                                 'properties': {'storage': {'items': {'$ref': '#/definitions/ImportStorageParams'},
                                                                            'type': 'array'}},
                                                 'required': ['storage'],
                                                 'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FilesystemAttachmentDetails': {'additionalProperties': False,
                                                     'properties': {'FilesystemAttachmentInfo': {'$ref': '#/definitions/FilesystemAttachmentInfo'},
                                                                    'life': {'type': 'string'}},
                                                     'required': ['FilesystemAttachmentInfo'],
                                                     'type': 'object'},
                     'FilesystemAttachmentInfo': {'additionalProperties': False,
                                                  'properties': {'mount-point': {'type': 'string'},
                                                                 'read-only': {'type': 'boolean'}},
                                                  'type': 'object'},
                     'FilesystemDetails': {'additionalProperties': False,
                                           'properties': {'filesystem-tag': {'type': 'string'},
                                                          'info': {'$ref': '#/definitions/FilesystemInfo'},
                                                          'life': {'type': 'string'},
                                                          'machine-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/FilesystemAttachmentDetails'}},
                                                                                  'type': 'object'},
                                                          'status': {'$ref': '#/definitions/EntityStatus'},
                                                          'storage': {'$ref': '#/definitions/StorageDetails'},
                                                          'unit-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/FilesystemAttachmentDetails'}},
                                                                               'type': 'object'},
                                                          'volume-tag': {'type': 'string'}},
                                           'required': ['filesystem-tag',
                                                        'info',
                                                        'status'],
                                           'type': 'object'},
                     'FilesystemDetailsListResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'result': {'items': {'$ref': '#/definitions/FilesystemDetails'},
                                                                               'type': 'array'}},
                                                     'type': 'object'},
                     'FilesystemDetailsListResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemDetailsListResult'},
                                                                                 'type': 'array'}},
                                                      'type': 'object'},
                     'FilesystemFilter': {'additionalProperties': False,
                                          'properties': {'machines': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                          'type': 'object'},
                     'FilesystemFilters': {'additionalProperties': False,
                                           'properties': {'filters': {'items': {'$ref': '#/definitions/FilesystemFilter'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'FilesystemInfo': {'additionalProperties': False,
                                        'properties': {'filesystem-id': {'type': 'string'},
                                                       'pool': {'type': 'string'},
                                                       'size': {'type': 'integer'}},
                                        'required': ['filesystem-id',
                                                     'pool',
                                                     'size'],
                                        'type': 'object'},
                     'ImportStorageDetails': {'additionalProperties': False,
                                              'properties': {'storage-tag': {'type': 'string'}},
                                              'required': ['storage-tag'],
                                              'type': 'object'},
                     'ImportStorageParams': {'additionalProperties': False,
                                             'properties': {'kind': {'type': 'integer'},
                                                            'pool': {'type': 'string'},
                                                            'provider-id': {'type': 'string'},
                                                            'storage-name': {'type': 'string'}},
                                             'required': ['kind',
                                                          'pool',
                                                          'provider-id',
                                                          'storage-name'],
                                             'type': 'object'},
                     'ImportStorageResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ImportStorageDetails'}},
                                             'type': 'object'},
                     'ImportStorageResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ImportStorageResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RemoveStorage': {'additionalProperties': False,
                                       'properties': {'storage': {'items': {'$ref': '#/definitions/RemoveStorageInstance'},
                                                                  'type': 'array'}},
                                       'required': ['storage'],
                                       'type': 'object'},
                     'RemoveStorageInstance': {'additionalProperties': False,
                                               'properties': {'destroy-attachments': {'type': 'boolean'},
                                                              'destroy-storage': {'type': 'boolean'},
                                                              'tag': {'type': 'string'}},
                                               'required': ['tag'],
                                               'type': 'object'},
                     'StorageAddParams': {'additionalProperties': False,
                                          'properties': {'name': {'type': 'string'},
                                                         'storage': {'$ref': '#/definitions/StorageConstraints'},
                                                         'unit': {'type': 'string'}},
                                          'required': ['unit', 'name', 'storage'],
                                          'type': 'object'},
                     'StorageAttachmentDetails': {'additionalProperties': False,
                                                  'properties': {'life': {'type': 'string'},
                                                                 'location': {'type': 'string'},
                                                                 'machine-tag': {'type': 'string'},
                                                                 'storage-tag': {'type': 'string'},
                                                                 'unit-tag': {'type': 'string'}},
                                                  'required': ['storage-tag',
                                                               'unit-tag',
                                                               'machine-tag'],
                                                  'type': 'object'},
                     'StorageAttachmentId': {'additionalProperties': False,
                                             'properties': {'storage-tag': {'type': 'string'},
                                                            'unit-tag': {'type': 'string'}},
                                             'required': ['storage-tag',
                                                          'unit-tag'],
                                             'type': 'object'},
                     'StorageAttachmentIds': {'additionalProperties': False,
                                              'properties': {'ids': {'items': {'$ref': '#/definitions/StorageAttachmentId'},
                                                                     'type': 'array'}},
                                              'required': ['ids'],
                                              'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StorageDetails': {'additionalProperties': False,
                                        'properties': {'attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageAttachmentDetails'}},
                                                                       'type': 'object'},
                                                       'kind': {'type': 'integer'},
                                                       'life': {'type': 'string'},
                                                       'owner-tag': {'type': 'string'},
                                                       'persistent': {'type': 'boolean'},
                                                       'status': {'$ref': '#/definitions/EntityStatus'},
                                                       'storage-tag': {'type': 'string'}},
                                        'required': ['storage-tag',
                                                     'owner-tag',
                                                     'kind',
                                                     'status',
                                                     'persistent'],
                                        'type': 'object'},
                     'StorageDetailsListResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'result': {'items': {'$ref': '#/definitions/StorageDetails'},
                                                                            'type': 'array'}},
                                                  'type': 'object'},
                     'StorageDetailsListResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/StorageDetailsListResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'StorageDetailsResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'result': {'$ref': '#/definitions/StorageDetails'}},
                                              'type': 'object'},
                     'StorageDetailsResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/StorageDetailsResult'},
                                                                          'type': 'array'}},
                                               'type': 'object'},
                     'StorageFilter': {'additionalProperties': False,
                                       'type': 'object'},
                     'StorageFilters': {'additionalProperties': False,
                                        'properties': {'filters': {'items': {'$ref': '#/definitions/StorageFilter'},
                                                                   'type': 'array'}},
                                        'type': 'object'},
                     'StoragePool': {'additionalProperties': False,
                                     'properties': {'attrs': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                    'name': {'type': 'string'},
                                                    'provider': {'type': 'string'}},
                                     'required': ['name', 'provider', 'attrs'],
                                     'type': 'object'},
                     'StoragePoolFilter': {'additionalProperties': False,
                                           'properties': {'names': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                          'providers': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                           'type': 'object'},
                     'StoragePoolFilters': {'additionalProperties': False,
                                            'properties': {'filters': {'items': {'$ref': '#/definitions/StoragePoolFilter'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'StoragePoolsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'storage-pools': {'items': {'$ref': '#/definitions/StoragePool'},
                                                                             'type': 'array'}},
                                            'type': 'object'},
                     'StoragePoolsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StoragePoolsResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'},
                     'StoragesAddParams': {'additionalProperties': False,
                                           'properties': {'storages': {'items': {'$ref': '#/definitions/StorageAddParams'},
                                                                       'type': 'array'}},
                                           'required': ['storages'],
                                           'type': 'object'},
                     'VolumeAttachmentDetails': {'additionalProperties': False,
                                                 'properties': {'VolumeAttachmentInfo': {'$ref': '#/definitions/VolumeAttachmentInfo'},
                                                                'life': {'type': 'string'}},
                                                 'required': ['VolumeAttachmentInfo'],
                                                 'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentPlanInfo': {'additionalProperties': False,
                                                  'properties': {'device-attributes': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                       'type': 'object'},
                                                                 'device-type': {'type': 'string'}},
                                                  'type': 'object'},
                     'VolumeDetails': {'additionalProperties': False,
                                       'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                                      'life': {'type': 'string'},
                                                      'machine-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentDetails'}},
                                                                              'type': 'object'},
                                                      'status': {'$ref': '#/definitions/EntityStatus'},
                                                      'storage': {'$ref': '#/definitions/StorageDetails'},
                                                      'unit-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentDetails'}},
                                                                           'type': 'object'},
                                                      'volume-tag': {'type': 'string'}},
                                       'required': ['volume-tag', 'info', 'status'],
                                       'type': 'object'},
                     'VolumeDetailsListResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'items': {'$ref': '#/definitions/VolumeDetails'},
                                                                           'type': 'array'}},
                                                 'type': 'object'},
                     'VolumeDetailsListResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/VolumeDetailsListResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'VolumeFilter': {'additionalProperties': False,
                                      'properties': {'machines': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'type': 'object'},
                     'VolumeFilters': {'additionalProperties': False,
                                       'properties': {'filters': {'items': {'$ref': '#/definitions/VolumeFilter'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'}},
     'properties': {'AddToUnit': {'properties': {'Params': {'$ref': '#/definitions/StoragesAddParams'},
                                                 'Result': {'$ref': '#/definitions/AddStorageResults'}},
                                  'type': 'object'},
                    'Attach': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'CreatePool': {'properties': {'Params': {'$ref': '#/definitions/StoragePool'}},
                                   'type': 'object'},
                    'Detach': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Import': {'properties': {'Params': {'$ref': '#/definitions/BulkImportStorageParams'},
                                              'Result': {'$ref': '#/definitions/ImportStorageResults'}},
                               'type': 'object'},
                    'ListFilesystems': {'properties': {'Params': {'$ref': '#/definitions/FilesystemFilters'},
                                                       'Result': {'$ref': '#/definitions/FilesystemDetailsListResults'}},
                                        'type': 'object'},
                    'ListPools': {'properties': {'Params': {'$ref': '#/definitions/StoragePoolFilters'},
                                                 'Result': {'$ref': '#/definitions/StoragePoolsResults'}},
                                  'type': 'object'},
                    'ListStorageDetails': {'properties': {'Params': {'$ref': '#/definitions/StorageFilters'},
                                                          'Result': {'$ref': '#/definitions/StorageDetailsListResults'}},
                                           'type': 'object'},
                    'ListVolumes': {'properties': {'Params': {'$ref': '#/definitions/VolumeFilters'},
                                                   'Result': {'$ref': '#/definitions/VolumeDetailsListResults'}},
                                    'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/RemoveStorage'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'StorageDetails': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StorageDetailsResults'}},
                                       'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddStorageResults)
    async def AddToUnit(self, storages=None):
        '''
        storages : typing.Sequence[~StorageAddParams]
        Returns -> AddStorageResults
        '''
        if storages is not None and not isinstance(storages, (bytes, str, list)):
            raise Exception("Expected storages to be a Sequence, received: {}".format(type(storages)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='AddToUnit',
                   version=4,
                   params=_params)
        _params['storages'] = storages
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Attach(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> ErrorResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Attach',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def CreatePool(self, attrs=None, name=None, provider=None):
        '''
        attrs : typing.Mapping[str, typing.Any]
        name : str
        provider : str
        Returns -> None
        '''
        if attrs is not None and not isinstance(attrs, dict):
            raise Exception("Expected attrs to be a Mapping, received: {}".format(type(attrs)))

        if name is not None and not isinstance(name, (bytes, str)):
            raise Exception("Expected name to be a str, received: {}".format(type(name)))

        if provider is not None and not isinstance(provider, (bytes, str)):
            raise Exception("Expected provider to be a str, received: {}".format(type(provider)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='CreatePool',
                   version=4,
                   params=_params)
        _params['attrs'] = attrs
        _params['name'] = name
        _params['provider'] = provider
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Detach(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> ErrorResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Detach',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ImportStorageResults)
    async def Import(self, storage=None):
        '''
        storage : typing.Sequence[~ImportStorageParams]
        Returns -> ImportStorageResults
        '''
        if storage is not None and not isinstance(storage, (bytes, str, list)):
            raise Exception("Expected storage to be a Sequence, received: {}".format(type(storage)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Import',
                   version=4,
                   params=_params)
        _params['storage'] = storage
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemDetailsListResults)
    async def ListFilesystems(self, filters=None):
        '''
        filters : typing.Sequence[~FilesystemFilter]
        Returns -> FilesystemDetailsListResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListFilesystems',
                   version=4,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StoragePoolsResults)
    async def ListPools(self, filters=None):
        '''
        filters : typing.Sequence[~StoragePoolFilter]
        Returns -> StoragePoolsResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListPools',
                   version=4,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageDetailsListResults)
    async def ListStorageDetails(self, filters=None):
        '''
        filters : typing.Sequence[~StorageFilter]
        Returns -> StorageDetailsListResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListStorageDetails',
                   version=4,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeDetailsListResults)
    async def ListVolumes(self, filters=None):
        '''
        filters : typing.Sequence[~VolumeFilter]
        Returns -> VolumeDetailsListResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='ListVolumes',
                   version=4,
                   params=_params)
        _params['filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, storage=None):
        '''
        storage : typing.Sequence[~RemoveStorageInstance]
        Returns -> ErrorResults
        '''
        if storage is not None and not isinstance(storage, (bytes, str, list)):
            raise Exception("Expected storage to be a Sequence, received: {}".format(type(storage)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='Remove',
                   version=4,
                   params=_params)
        _params['storage'] = storage
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageDetailsResults)
    async def StorageDetails(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StorageDetailsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Storage',
                   request='StorageDetails',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class StorageProvisionerFacade(Type):
    name = 'StorageProvisioner'
    version = 4
    schema =     {'definitions': {'BlockDevice': {'additionalProperties': False,
                                     'properties': {'BusAddress': {'type': 'string'},
                                                    'DeviceLinks': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                    'DeviceName': {'type': 'string'},
                                                    'FilesystemType': {'type': 'string'},
                                                    'HardwareId': {'type': 'string'},
                                                    'InUse': {'type': 'boolean'},
                                                    'Label': {'type': 'string'},
                                                    'MountPoint': {'type': 'string'},
                                                    'SerialId': {'type': 'string'},
                                                    'Size': {'type': 'integer'},
                                                    'UUID': {'type': 'string'},
                                                    'WWN': {'type': 'string'}},
                                     'required': ['DeviceName',
                                                  'DeviceLinks',
                                                  'Label',
                                                  'UUID',
                                                  'HardwareId',
                                                  'WWN',
                                                  'BusAddress',
                                                  'Size',
                                                  'FilesystemType',
                                                  'InUse',
                                                  'MountPoint',
                                                  'SerialId'],
                                     'type': 'object'},
                     'BlockDeviceResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'result': {'$ref': '#/definitions/BlockDevice'}},
                                           'required': ['result'],
                                           'type': 'object'},
                     'BlockDeviceResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/BlockDeviceResult'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Filesystem': {'additionalProperties': False,
                                    'properties': {'filesystem-tag': {'type': 'string'},
                                                   'info': {'$ref': '#/definitions/FilesystemInfo'},
                                                   'volume-tag': {'type': 'string'}},
                                    'required': ['filesystem-tag', 'info'],
                                    'type': 'object'},
                     'FilesystemAttachment': {'additionalProperties': False,
                                              'properties': {'filesystem-tag': {'type': 'string'},
                                                             'info': {'$ref': '#/definitions/FilesystemAttachmentInfo'},
                                                             'machine-tag': {'type': 'string'}},
                                              'required': ['filesystem-tag',
                                                           'machine-tag',
                                                           'info'],
                                              'type': 'object'},
                     'FilesystemAttachmentInfo': {'additionalProperties': False,
                                                  'properties': {'mount-point': {'type': 'string'},
                                                                 'read-only': {'type': 'boolean'}},
                                                  'type': 'object'},
                     'FilesystemAttachmentParams': {'additionalProperties': False,
                                                    'properties': {'filesystem-id': {'type': 'string'},
                                                                   'filesystem-tag': {'type': 'string'},
                                                                   'instance-id': {'type': 'string'},
                                                                   'machine-tag': {'type': 'string'},
                                                                   'mount-point': {'type': 'string'},
                                                                   'provider': {'type': 'string'},
                                                                   'read-only': {'type': 'boolean'}},
                                                    'required': ['filesystem-tag',
                                                                 'machine-tag',
                                                                 'provider'],
                                                    'type': 'object'},
                     'FilesystemAttachmentParamsResult': {'additionalProperties': False,
                                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                         'result': {'$ref': '#/definitions/FilesystemAttachmentParams'}},
                                                          'required': ['result'],
                                                          'type': 'object'},
                     'FilesystemAttachmentParamsResults': {'additionalProperties': False,
                                                           'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemAttachmentParamsResult'},
                                                                                      'type': 'array'}},
                                                           'type': 'object'},
                     'FilesystemAttachmentResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'result': {'$ref': '#/definitions/FilesystemAttachment'}},
                                                    'required': ['result'],
                                                    'type': 'object'},
                     'FilesystemAttachmentResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemAttachmentResult'},
                                                                                'type': 'array'}},
                                                     'type': 'object'},
                     'FilesystemAttachments': {'additionalProperties': False,
                                               'properties': {'filesystem-attachments': {'items': {'$ref': '#/definitions/FilesystemAttachment'},
                                                                                         'type': 'array'}},
                                               'required': ['filesystem-attachments'],
                                               'type': 'object'},
                     'FilesystemInfo': {'additionalProperties': False,
                                        'properties': {'filesystem-id': {'type': 'string'},
                                                       'pool': {'type': 'string'},
                                                       'size': {'type': 'integer'}},
                                        'required': ['filesystem-id',
                                                     'pool',
                                                     'size'],
                                        'type': 'object'},
                     'FilesystemParams': {'additionalProperties': False,
                                          'properties': {'attachment': {'$ref': '#/definitions/FilesystemAttachmentParams'},
                                                         'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                     'type': 'object'}},
                                                                        'type': 'object'},
                                                         'filesystem-tag': {'type': 'string'},
                                                         'provider': {'type': 'string'},
                                                         'size': {'type': 'integer'},
                                                         'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                         'volume-tag': {'type': 'string'}},
                                          'required': ['filesystem-tag',
                                                       'size',
                                                       'provider'],
                                          'type': 'object'},
                     'FilesystemParamsResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/FilesystemParams'}},
                                                'required': ['result'],
                                                'type': 'object'},
                     'FilesystemParamsResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemParamsResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'FilesystemResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'result': {'$ref': '#/definitions/Filesystem'}},
                                          'required': ['result'],
                                          'type': 'object'},
                     'FilesystemResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/FilesystemResult'},
                                                                      'type': 'array'}},
                                           'type': 'object'},
                     'Filesystems': {'additionalProperties': False,
                                     'properties': {'filesystems': {'items': {'$ref': '#/definitions/Filesystem'},
                                                                    'type': 'array'}},
                                     'required': ['filesystems'],
                                     'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIds': {'additionalProperties': False,
                                           'properties': {'ids': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                  'type': 'array'}},
                                           'required': ['ids'],
                                           'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'},
                     'MachineStorageIdsWatchResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/MachineStorageIdsWatchResult'},
                                                                                  'type': 'array'}},
                                                       'required': ['results'],
                                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'RemoveFilesystemParams': {'additionalProperties': False,
                                                'properties': {'destroy': {'type': 'boolean'},
                                                               'filesystem-id': {'type': 'string'},
                                                               'provider': {'type': 'string'}},
                                                'required': ['provider',
                                                             'filesystem-id'],
                                                'type': 'object'},
                     'RemoveFilesystemParamsResult': {'additionalProperties': False,
                                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                     'result': {'$ref': '#/definitions/RemoveFilesystemParams'}},
                                                      'required': ['result'],
                                                      'type': 'object'},
                     'RemoveFilesystemParamsResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/RemoveFilesystemParamsResult'},
                                                                                  'type': 'array'}},
                                                       'type': 'object'},
                     'RemoveVolumeParams': {'additionalProperties': False,
                                            'properties': {'destroy': {'type': 'boolean'},
                                                           'provider': {'type': 'string'},
                                                           'volume-id': {'type': 'string'}},
                                            'required': ['provider', 'volume-id'],
                                            'type': 'object'},
                     'RemoveVolumeParamsResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'result': {'$ref': '#/definitions/RemoveVolumeParams'}},
                                                  'required': ['result'],
                                                  'type': 'object'},
                     'RemoveVolumeParamsResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/RemoveVolumeParamsResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Volume': {'additionalProperties': False,
                                'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                               'volume-tag': {'type': 'string'}},
                                'required': ['volume-tag', 'info'],
                                'type': 'object'},
                     'VolumeAttachment': {'additionalProperties': False,
                                          'properties': {'info': {'$ref': '#/definitions/VolumeAttachmentInfo'},
                                                         'machine-tag': {'type': 'string'},
                                                         'volume-tag': {'type': 'string'}},
                                          'required': ['volume-tag',
                                                       'machine-tag',
                                                       'info'],
                                          'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentParams': {'additionalProperties': False,
                                                'properties': {'instance-id': {'type': 'string'},
                                                               'machine-tag': {'type': 'string'},
                                                               'provider': {'type': 'string'},
                                                               'read-only': {'type': 'boolean'},
                                                               'volume-id': {'type': 'string'},
                                                               'volume-tag': {'type': 'string'}},
                                                'required': ['volume-tag',
                                                             'machine-tag',
                                                             'provider'],
                                                'type': 'object'},
                     'VolumeAttachmentParamsResult': {'additionalProperties': False,
                                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                     'result': {'$ref': '#/definitions/VolumeAttachmentParams'}},
                                                      'required': ['result'],
                                                      'type': 'object'},
                     'VolumeAttachmentParamsResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/VolumeAttachmentParamsResult'},
                                                                                  'type': 'array'}},
                                                       'type': 'object'},
                     'VolumeAttachmentPlan': {'additionalProperties': False,
                                              'properties': {'block-device': {'$ref': '#/definitions/BlockDevice'},
                                                             'life': {'type': 'string'},
                                                             'machine-tag': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'volume-tag': {'type': 'string'}},
                                              'required': ['volume-tag',
                                                           'machine-tag',
                                                           'plan-info'],
                                              'type': 'object'},
                     'VolumeAttachmentPlanInfo': {'additionalProperties': False,
                                                  'properties': {'device-attributes': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                       'type': 'object'},
                                                                 'device-type': {'type': 'string'}},
                                                  'type': 'object'},
                     'VolumeAttachmentPlanResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'result': {'$ref': '#/definitions/VolumeAttachmentPlan'}},
                                                    'required': ['result'],
                                                    'type': 'object'},
                     'VolumeAttachmentPlanResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/VolumeAttachmentPlanResult'},
                                                                                'type': 'array'}},
                                                     'type': 'object'},
                     'VolumeAttachmentPlans': {'additionalProperties': False,
                                               'properties': {'volume-plans': {'items': {'$ref': '#/definitions/VolumeAttachmentPlan'},
                                                                               'type': 'array'}},
                                               'required': ['volume-plans'],
                                               'type': 'object'},
                     'VolumeAttachmentResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/VolumeAttachment'}},
                                                'required': ['result'],
                                                'type': 'object'},
                     'VolumeAttachmentResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/VolumeAttachmentResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'VolumeAttachments': {'additionalProperties': False,
                                           'properties': {'volume-attachments': {'items': {'$ref': '#/definitions/VolumeAttachment'},
                                                                                 'type': 'array'}},
                                           'required': ['volume-attachments'],
                                           'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'},
                     'VolumeParams': {'additionalProperties': False,
                                      'properties': {'attachment': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                     'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'},
                                                     'provider': {'type': 'string'},
                                                     'size': {'type': 'integer'},
                                                     'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                              'type': 'object'},
                                                     'volume-tag': {'type': 'string'}},
                                      'required': ['volume-tag',
                                                   'size',
                                                   'provider'],
                                      'type': 'object'},
                     'VolumeParamsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'result': {'$ref': '#/definitions/VolumeParams'}},
                                            'required': ['result'],
                                            'type': 'object'},
                     'VolumeParamsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/VolumeParamsResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'},
                     'VolumeResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'$ref': '#/definitions/Volume'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'VolumeResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/VolumeResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'Volumes': {'additionalProperties': False,
                                 'properties': {'volumes': {'items': {'$ref': '#/definitions/Volume'},
                                                            'type': 'array'}},
                                 'required': ['volumes'],
                                 'type': 'object'}},
     'properties': {'AttachmentLife': {'description': 'AttachmentLife returns the '
                                                      'lifecycle state of each '
                                                      'specified machine\n'
                                                      'storage attachment.',
                                       'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                      'Result': {'$ref': '#/definitions/LifeResults'}},
                                       'type': 'object'},
                    'CreateVolumeAttachmentPlans': {'properties': {'Params': {'$ref': '#/definitions/VolumeAttachmentPlans'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'EnsureDead': {'description': 'EnsureDead calls EnsureDead on '
                                                  'each given entity from state. '
                                                  'It\n'
                                                  'will fail if the entity is not '
                                                  "present. If it's Alive, nothing "
                                                  'will\n'
                                                  'happen (see state/EnsureDead() '
                                                  'for units or machines).',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FilesystemAttachmentParams': {'description': 'FilesystemAttachmentParams '
                                                                  'returns the '
                                                                  'parameters for '
                                                                  'creating the '
                                                                  'filesystem\n'
                                                                  'attachments '
                                                                  'with the '
                                                                  'specified IDs.',
                                                   'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                                  'Result': {'$ref': '#/definitions/FilesystemAttachmentParamsResults'}},
                                                   'type': 'object'},
                    'FilesystemAttachments': {'description': 'FilesystemAttachments '
                                                             'returns details of '
                                                             'filesystem '
                                                             'attachments with the '
                                                             'specified IDs.',
                                              'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                             'Result': {'$ref': '#/definitions/FilesystemAttachmentResults'}},
                                              'type': 'object'},
                    'FilesystemParams': {'description': 'FilesystemParams returns '
                                                        'the parameters for '
                                                        'creating the filesystems\n'
                                                        'with the specified tags.',
                                         'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/FilesystemParamsResults'}},
                                         'type': 'object'},
                    'Filesystems': {'description': 'Filesystems returns details of '
                                                   'filesystems with the specified '
                                                   'tags.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/FilesystemResults'}},
                                    'type': 'object'},
                    'InstanceId': {'description': 'InstanceId returns the provider '
                                                  'specific instance id for each '
                                                  'given\n'
                                                  'machine or an '
                                                  'CodeNotProvisioned error, if '
                                                  'not set.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'Remove': {'description': 'Remove removes volumes and '
                                              'filesystems from state.',
                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'RemoveAttachment': {'description': 'RemoveAttachments removes '
                                                        'the specified machine '
                                                        'storage attachments\n'
                                                        'from state.',
                                         'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'RemoveFilesystemParams': {'description': 'RemoveFilesystemParams '
                                                              'returns the '
                                                              'parameters for '
                                                              'destroying or\n'
                                                              'releasing the '
                                                              'filesystems with '
                                                              'the specified tags.',
                                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/RemoveFilesystemParamsResults'}},
                                               'type': 'object'},
                    'RemoveVolumeAttachmentPlan': {'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                   'type': 'object'},
                    'RemoveVolumeParams': {'description': 'RemoveVolumeParams '
                                                          'returns the parameters '
                                                          'for destroying\n'
                                                          'or releasing the '
                                                          'volumes with the '
                                                          'specified tags.',
                                           'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/RemoveVolumeParamsResults'}},
                                           'type': 'object'},
                    'SetFilesystemAttachmentInfo': {'description': 'SetFilesystemAttachmentInfo '
                                                                   'records the '
                                                                   'details of '
                                                                   'newly '
                                                                   'provisioned '
                                                                   'filesystem\n'
                                                                   'attachments.',
                                                    'properties': {'Params': {'$ref': '#/definitions/FilesystemAttachments'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'SetFilesystemInfo': {'description': 'SetFilesystemInfo '
                                                         'records the details of '
                                                         'newly provisioned '
                                                         'filesystems.',
                                          'properties': {'Params': {'$ref': '#/definitions/Filesystems'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetStatus': {'description': 'SetStatus sets the status of '
                                                 'each given entity.',
                                  'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetVolumeAttachmentInfo': {'description': 'SetVolumeAttachmentInfo '
                                                               'records the '
                                                               'details of newly '
                                                               'provisioned '
                                                               'volume\n'
                                                               'attachments.',
                                                'properties': {'Params': {'$ref': '#/definitions/VolumeAttachments'},
                                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                'type': 'object'},
                    'SetVolumeAttachmentPlanBlockInfo': {'properties': {'Params': {'$ref': '#/definitions/VolumeAttachmentPlans'},
                                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                         'type': 'object'},
                    'SetVolumeInfo': {'description': 'SetVolumeInfo records the '
                                                     'details of newly provisioned '
                                                     'volumes.',
                                      'properties': {'Params': {'$ref': '#/definitions/Volumes'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'UpdateStatus': {'description': 'UpdateStatus updates the '
                                                    'status data of each given '
                                                    'entity.\n'
                                                    'TODO(fwereade): WTF. This '
                                                    'method exists *only* for the '
                                                    'convenience of the\n'
                                                    '*client* API -- and is itself '
                                                    'completely broken -- but we '
                                                    'still expose it\n'
                                                    'in every facade with a '
                                                    'StatusSetter? FFS.',
                                     'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'VolumeAttachmentParams': {'description': 'VolumeAttachmentParams '
                                                              'returns the '
                                                              'parameters for '
                                                              'creating the '
                                                              'volume\n'
                                                              'attachments with '
                                                              'the specified IDs.',
                                               'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                              'Result': {'$ref': '#/definitions/VolumeAttachmentParamsResults'}},
                                               'type': 'object'},
                    'VolumeAttachmentPlans': {'description': 'VolumeAttachmentPlans '
                                                             'returns details of '
                                                             'volume attachment '
                                                             'plans with the '
                                                             'specified IDs.',
                                              'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                             'Result': {'$ref': '#/definitions/VolumeAttachmentPlanResults'}},
                                              'type': 'object'},
                    'VolumeAttachments': {'description': 'VolumeAttachments '
                                                         'returns details of '
                                                         'volume attachments with '
                                                         'the specified IDs.',
                                          'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                         'Result': {'$ref': '#/definitions/VolumeAttachmentResults'}},
                                          'type': 'object'},
                    'VolumeBlockDevices': {'description': 'VolumeBlockDevices '
                                                          'returns details of the '
                                                          'block devices '
                                                          'corresponding to the\n'
                                                          'volume attachments with '
                                                          'the specified IDs.',
                                           'properties': {'Params': {'$ref': '#/definitions/MachineStorageIds'},
                                                          'Result': {'$ref': '#/definitions/BlockDeviceResults'}},
                                           'type': 'object'},
                    'VolumeParams': {'description': 'VolumeParams returns the '
                                                    'parameters for creating or '
                                                    'destroying\n'
                                                    'the volumes with the '
                                                    'specified tags.',
                                     'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/VolumeParamsResults'}},
                                     'type': 'object'},
                    'Volumes': {'description': 'Volumes returns details of volumes '
                                               'with the specified tags.',
                                'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/VolumeResults'}},
                                'type': 'object'},
                    'WatchApplications': {'description': 'WatchApplications starts '
                                                         'a StringsWatcher to '
                                                         'watch CAAS applications\n'
                                                         'deployed to this model.',
                                          'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                          'type': 'object'},
                    'WatchBlockDevices': {'description': 'WatchBlockDevices '
                                                         'watches for changes to '
                                                         "the specified machines' "
                                                         'block devices.',
                                          'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                          'type': 'object'},
                    'WatchFilesystemAttachments': {'description': 'WatchFilesystemAttachments '
                                                                  'watches for '
                                                                  'changes to '
                                                                  'filesystem '
                                                                  'attachments\n'
                                                                  'scoped to the '
                                                                  'entity with the '
                                                                  'tag passed to '
                                                                  'NewState.',
                                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResults'}},
                                                   'type': 'object'},
                    'WatchFilesystems': {'description': 'WatchFilesystems watches '
                                                        'for changes to '
                                                        'filesystems scoped\n'
                                                        'to the entity with the '
                                                        'tag passed to NewState.',
                                         'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                         'type': 'object'},
                    'WatchMachines': {'description': 'WatchMachines watches for '
                                                     'changes to the specified '
                                                     'machines.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                      'type': 'object'},
                    'WatchVolumeAttachmentPlans': {'description': 'WatchVolumeAttachmentPlans '
                                                                  'watches for '
                                                                  'changes to '
                                                                  'volume '
                                                                  'attachments for '
                                                                  'a machine for '
                                                                  'the purpose of '
                                                                  'allowing\n'
                                                                  'that machine to '
                                                                  'run any '
                                                                  'initialization '
                                                                  'needed, for '
                                                                  'that volume to '
                                                                  'actually appear '
                                                                  'as a block '
                                                                  'device (ie: '
                                                                  'iSCSI)',
                                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResults'}},
                                                   'type': 'object'},
                    'WatchVolumeAttachments': {'description': 'WatchVolumeAttachments '
                                                              'watches for changes '
                                                              'to volume '
                                                              'attachments scoped '
                                                              'to\n'
                                                              'the entity with the '
                                                              'tag passed to '
                                                              'NewState.',
                                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResults'}},
                                               'type': 'object'},
                    'WatchVolumes': {'description': 'WatchVolumes watches for '
                                                    'changes to volumes scoped to '
                                                    'the\n'
                                                    'entity with the tag passed to '
                                                    'NewState.',
                                     'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                     'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(LifeResults)
    async def AttachmentLife(self, ids=None):
        '''
        AttachmentLife returns the lifecycle state of each specified machine
        storage attachment.

        ids : typing.Sequence[~MachineStorageId]
        Returns -> LifeResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='AttachmentLife',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def CreateVolumeAttachmentPlans(self, volume_plans=None):
        '''
        volume_plans : typing.Sequence[~VolumeAttachmentPlan]
        Returns -> ErrorResults
        '''
        if volume_plans is not None and not isinstance(volume_plans, (bytes, str, list)):
            raise Exception("Expected volume_plans to be a Sequence, received: {}".format(type(volume_plans)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='CreateVolumeAttachmentPlans',
                   version=4,
                   params=_params)
        _params['volume-plans'] = volume_plans
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities=None):
        '''
        EnsureDead calls EnsureDead on each given entity from state. It
        will fail if the entity is not present. If it's Alive, nothing will
        happen (see state/EnsureDead() for units or machines).

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='EnsureDead',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemAttachmentParamsResults)
    async def FilesystemAttachmentParams(self, ids=None):
        '''
        FilesystemAttachmentParams returns the parameters for creating the filesystem
        attachments with the specified IDs.

        ids : typing.Sequence[~MachineStorageId]
        Returns -> FilesystemAttachmentParamsResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='FilesystemAttachmentParams',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemAttachmentResults)
    async def FilesystemAttachments(self, ids=None):
        '''
        FilesystemAttachments returns details of filesystem attachments with the specified IDs.

        ids : typing.Sequence[~MachineStorageId]
        Returns -> FilesystemAttachmentResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='FilesystemAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemParamsResults)
    async def FilesystemParams(self, entities=None):
        '''
        FilesystemParams returns the parameters for creating the filesystems
        with the specified tags.

        entities : typing.Sequence[~Entity]
        Returns -> FilesystemParamsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='FilesystemParams',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FilesystemResults)
    async def Filesystems(self, entities=None):
        '''
        Filesystems returns details of filesystems with the specified tags.

        entities : typing.Sequence[~Entity]
        Returns -> FilesystemResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Filesystems',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities=None):
        '''
        InstanceId returns the provider specific instance id for each given
        machine or an CodeNotProvisioned error, if not set.

        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='InstanceId',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Life',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities=None):
        '''
        Remove removes volumes and filesystems from state.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Remove',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveAttachment(self, ids=None):
        '''
        RemoveAttachments removes the specified machine storage attachments
        from state.

        ids : typing.Sequence[~MachineStorageId]
        Returns -> ErrorResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='RemoveAttachment',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoveFilesystemParamsResults)
    async def RemoveFilesystemParams(self, entities=None):
        '''
        RemoveFilesystemParams returns the parameters for destroying or
        releasing the filesystems with the specified tags.

        entities : typing.Sequence[~Entity]
        Returns -> RemoveFilesystemParamsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='RemoveFilesystemParams',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveVolumeAttachmentPlan(self, ids=None):
        '''
        ids : typing.Sequence[~MachineStorageId]
        Returns -> ErrorResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='RemoveVolumeAttachmentPlan',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoveVolumeParamsResults)
    async def RemoveVolumeParams(self, entities=None):
        '''
        RemoveVolumeParams returns the parameters for destroying
        or releasing the volumes with the specified tags.

        entities : typing.Sequence[~Entity]
        Returns -> RemoveVolumeParamsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='RemoveVolumeParams',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetFilesystemAttachmentInfo(self, filesystem_attachments=None):
        '''
        SetFilesystemAttachmentInfo records the details of newly provisioned filesystem
        attachments.

        filesystem_attachments : typing.Sequence[~FilesystemAttachment]
        Returns -> ErrorResults
        '''
        if filesystem_attachments is not None and not isinstance(filesystem_attachments, (bytes, str, list)):
            raise Exception("Expected filesystem_attachments to be a Sequence, received: {}".format(type(filesystem_attachments)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetFilesystemAttachmentInfo',
                   version=4,
                   params=_params)
        _params['filesystem-attachments'] = filesystem_attachments
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetFilesystemInfo(self, filesystems=None):
        '''
        SetFilesystemInfo records the details of newly provisioned filesystems.

        filesystems : typing.Sequence[~Filesystem]
        Returns -> ErrorResults
        '''
        if filesystems is not None and not isinstance(filesystems, (bytes, str, list)):
            raise Exception("Expected filesystems to be a Sequence, received: {}".format(type(filesystems)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetFilesystemInfo',
                   version=4,
                   params=_params)
        _params['filesystems'] = filesystems
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        SetStatus sets the status of each given entity.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetVolumeAttachmentInfo(self, volume_attachments=None):
        '''
        SetVolumeAttachmentInfo records the details of newly provisioned volume
        attachments.

        volume_attachments : typing.Sequence[~VolumeAttachment]
        Returns -> ErrorResults
        '''
        if volume_attachments is not None and not isinstance(volume_attachments, (bytes, str, list)):
            raise Exception("Expected volume_attachments to be a Sequence, received: {}".format(type(volume_attachments)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetVolumeAttachmentInfo',
                   version=4,
                   params=_params)
        _params['volume-attachments'] = volume_attachments
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetVolumeAttachmentPlanBlockInfo(self, volume_plans=None):
        '''
        volume_plans : typing.Sequence[~VolumeAttachmentPlan]
        Returns -> ErrorResults
        '''
        if volume_plans is not None and not isinstance(volume_plans, (bytes, str, list)):
            raise Exception("Expected volume_plans to be a Sequence, received: {}".format(type(volume_plans)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetVolumeAttachmentPlanBlockInfo',
                   version=4,
                   params=_params)
        _params['volume-plans'] = volume_plans
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetVolumeInfo(self, volumes=None):
        '''
        SetVolumeInfo records the details of newly provisioned volumes.

        volumes : typing.Sequence[~Volume]
        Returns -> ErrorResults
        '''
        if volumes is not None and not isinstance(volumes, (bytes, str, list)):
            raise Exception("Expected volumes to be a Sequence, received: {}".format(type(volumes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='SetVolumeInfo',
                   version=4,
                   params=_params)
        _params['volumes'] = volumes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities=None):
        '''
        UpdateStatus updates the status data of each given entity.
        TODO(fwereade): WTF. This method exists *only* for the convenience of the
        *client* API -- and is itself completely broken -- but we still expose it
        in every facade with a StatusSetter? FFS.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='UpdateStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeAttachmentParamsResults)
    async def VolumeAttachmentParams(self, ids=None):
        '''
        VolumeAttachmentParams returns the parameters for creating the volume
        attachments with the specified IDs.

        ids : typing.Sequence[~MachineStorageId]
        Returns -> VolumeAttachmentParamsResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeAttachmentParams',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeAttachmentPlanResults)
    async def VolumeAttachmentPlans(self, ids=None):
        '''
        VolumeAttachmentPlans returns details of volume attachment plans with the specified IDs.

        ids : typing.Sequence[~MachineStorageId]
        Returns -> VolumeAttachmentPlanResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeAttachmentPlans',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeAttachmentResults)
    async def VolumeAttachments(self, ids=None):
        '''
        VolumeAttachments returns details of volume attachments with the specified IDs.

        ids : typing.Sequence[~MachineStorageId]
        Returns -> VolumeAttachmentResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BlockDeviceResults)
    async def VolumeBlockDevices(self, ids=None):
        '''
        VolumeBlockDevices returns details of the block devices corresponding to the
        volume attachments with the specified IDs.

        ids : typing.Sequence[~MachineStorageId]
        Returns -> BlockDeviceResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeBlockDevices',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeParamsResults)
    async def VolumeParams(self, entities=None):
        '''
        VolumeParams returns the parameters for creating or destroying
        the volumes with the specified tags.

        entities : typing.Sequence[~Entity]
        Returns -> VolumeParamsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='VolumeParams',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(VolumeResults)
    async def Volumes(self, entities=None):
        '''
        Volumes returns details of volumes with the specified tags.

        entities : typing.Sequence[~Entity]
        Returns -> VolumeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='Volumes',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchApplications(self):
        '''
        WatchApplications starts a StringsWatcher to watch CAAS applications
        deployed to this model.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchApplications',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchBlockDevices(self, entities=None):
        '''
        WatchBlockDevices watches for changes to the specified machines' block devices.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchBlockDevices',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineStorageIdsWatchResults)
    async def WatchFilesystemAttachments(self, entities=None):
        '''
        WatchFilesystemAttachments watches for changes to filesystem attachments
        scoped to the entity with the tag passed to NewState.

        entities : typing.Sequence[~Entity]
        Returns -> MachineStorageIdsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchFilesystemAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchFilesystems(self, entities=None):
        '''
        WatchFilesystems watches for changes to filesystems scoped
        to the entity with the tag passed to NewState.

        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchFilesystems',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMachines(self, entities=None):
        '''
        WatchMachines watches for changes to the specified machines.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchMachines',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineStorageIdsWatchResults)
    async def WatchVolumeAttachmentPlans(self, entities=None):
        '''
        WatchVolumeAttachmentPlans watches for changes to volume attachments for a machine for the purpose of allowing
        that machine to run any initialization needed, for that volume to actually appear as a block device (ie: iSCSI)

        entities : typing.Sequence[~Entity]
        Returns -> MachineStorageIdsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchVolumeAttachmentPlans',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineStorageIdsWatchResults)
    async def WatchVolumeAttachments(self, entities=None):
        '''
        WatchVolumeAttachments watches for changes to volume attachments scoped to
        the entity with the tag passed to NewState.

        entities : typing.Sequence[~Entity]
        Returns -> MachineStorageIdsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchVolumeAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchVolumes(self, entities=None):
        '''
        WatchVolumes watches for changes to volumes scoped to the
        entity with the tag passed to NewState.

        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StorageProvisioner',
                   request='WatchVolumes',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SubnetsFacade(Type):
    name = 'Subnets'
    version = 4
    schema =     {'definitions': {'AddSubnetParams': {'additionalProperties': False,
                                         'properties': {'cidr': {'type': 'string'},
                                                        'provider-network-id': {'type': 'string'},
                                                        'space-tag': {'type': 'string'},
                                                        'subnet-provider-id': {'type': 'string'},
                                                        'vlan-tag': {'type': 'integer'},
                                                        'zones': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                         'required': ['space-tag'],
                                         'type': 'object'},
                     'AddSubnetsParams': {'additionalProperties': False,
                                          'properties': {'subnets': {'items': {'$ref': '#/definitions/AddSubnetParams'},
                                                                     'type': 'array'}},
                                          'required': ['subnets'],
                                          'type': 'object'},
                     'CIDRParams': {'additionalProperties': False,
                                    'properties': {'cidrs': {'items': {'type': 'string'},
                                                             'type': 'array'}},
                                    'required': ['cidrs'],
                                    'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSubnetsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/Subnet'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'SubnetV2': {'additionalProperties': False,
                                  'properties': {'Subnet': {'$ref': '#/definitions/Subnet'},
                                                 'cidr': {'type': 'string'},
                                                 'id': {'type': 'string'},
                                                 'life': {'type': 'string'},
                                                 'provider-id': {'type': 'string'},
                                                 'provider-network-id': {'type': 'string'},
                                                 'provider-space-id': {'type': 'string'},
                                                 'space-tag': {'type': 'string'},
                                                 'status': {'type': 'string'},
                                                 'vlan-tag': {'type': 'integer'},
                                                 'zones': {'items': {'type': 'string'},
                                                           'type': 'array'}},
                                  'required': ['cidr',
                                               'vlan-tag',
                                               'life',
                                               'space-tag',
                                               'zones',
                                               'Subnet'],
                                  'type': 'object'},
                     'SubnetsFilters': {'additionalProperties': False,
                                        'properties': {'space-tag': {'type': 'string'},
                                                       'zone': {'type': 'string'}},
                                        'type': 'object'},
                     'SubnetsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'subnets': {'items': {'$ref': '#/definitions/SubnetV2'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'SubnetsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/SubnetsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'ZoneResult': {'additionalProperties': False,
                                    'properties': {'available': {'type': 'boolean'},
                                                   'error': {'$ref': '#/definitions/Error'},
                                                   'name': {'type': 'string'}},
                                    'required': ['name', 'available'],
                                    'type': 'object'},
                     'ZoneResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/ZoneResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'}},
     'properties': {'AddSubnets': {'description': 'AddSubnets adds existing '
                                                  'subnets to Juju.',
                                   'properties': {'Params': {'$ref': '#/definitions/AddSubnetsParams'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'AllZones': {'description': 'AllZones returns all availability '
                                                'zones known to Juju. If a\n'
                                                'zone is unusable, unavailable, or '
                                                'deprecated the Available\n'
                                                'field will be false.',
                                 'properties': {'Result': {'$ref': '#/definitions/ZoneResults'}},
                                 'type': 'object'},
                    'ListSubnets': {'description': 'ListSubnets returns the '
                                                   'matching subnets after '
                                                   'applying\n'
                                                   'optional filters.',
                                    'properties': {'Params': {'$ref': '#/definitions/SubnetsFilters'},
                                                   'Result': {'$ref': '#/definitions/ListSubnetsResults'}},
                                    'type': 'object'},
                    'SubnetsByCIDR': {'description': 'SubnetsByCIDR returns the '
                                                     'collection of subnets '
                                                     'matching each CIDR in the '
                                                     'input.',
                                      'properties': {'Params': {'$ref': '#/definitions/CIDRParams'},
                                                     'Result': {'$ref': '#/definitions/SubnetsResults'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddSubnets(self, subnets=None):
        '''
        AddSubnets adds existing subnets to Juju.

        subnets : typing.Sequence[~AddSubnetParams]
        Returns -> ErrorResults
        '''
        if subnets is not None and not isinstance(subnets, (bytes, str, list)):
            raise Exception("Expected subnets to be a Sequence, received: {}".format(type(subnets)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='AddSubnets',
                   version=4,
                   params=_params)
        _params['subnets'] = subnets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ZoneResults)
    async def AllZones(self):
        '''
        AllZones returns all availability zones known to Juju. If a
        zone is unusable, unavailable, or deprecated the Available
        field will be false.


        Returns -> ZoneResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='AllZones',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSubnetsResults)
    async def ListSubnets(self, space_tag=None, zone=None):
        '''
        ListSubnets returns the matching subnets after applying
        optional filters.

        space_tag : str
        zone : str
        Returns -> ListSubnetsResults
        '''
        if space_tag is not None and not isinstance(space_tag, (bytes, str)):
            raise Exception("Expected space_tag to be a str, received: {}".format(type(space_tag)))

        if zone is not None and not isinstance(zone, (bytes, str)):
            raise Exception("Expected zone to be a str, received: {}".format(type(zone)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='ListSubnets',
                   version=4,
                   params=_params)
        _params['space-tag'] = space_tag
        _params['zone'] = zone
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SubnetsResults)
    async def SubnetsByCIDR(self, cidrs=None):
        '''
        SubnetsByCIDR returns the collection of subnets matching each CIDR in the input.

        cidrs : typing.Sequence[str]
        Returns -> SubnetsResults
        '''
        if cidrs is not None and not isinstance(cidrs, (bytes, str, list)):
            raise Exception("Expected cidrs to be a Sequence, received: {}".format(type(cidrs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='SubnetsByCIDR',
                   version=4,
                   params=_params)
        _params['cidrs'] = cidrs
        reply = await self.rpc(msg)
        return reply



class UniterFacade(Type):
    name = 'Uniter'
    version = 4
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionExecutionResult': {'additionalProperties': False,
                                               'properties': {'action-tag': {'type': 'string'},
                                                              'message': {'type': 'string'},
                                                              'results': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'},
                                                              'status': {'type': 'string'}},
                                               'required': ['action-tag', 'status'],
                                               'type': 'object'},
                     'ActionExecutionResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/ActionExecutionResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'ApplicationStatusResult': {'additionalProperties': False,
                                                 'properties': {'application': {'$ref': '#/definitions/StatusResult'},
                                                                'error': {'$ref': '#/definitions/Error'},
                                                                'units': {'patternProperties': {'.*': {'$ref': '#/definitions/StatusResult'}},
                                                                          'type': 'object'}},
                                                 'required': ['application',
                                                              'units'],
                                                 'type': 'object'},
                     'ApplicationStatusResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationStatusResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'CharmURL': {'additionalProperties': False,
                                  'properties': {'url': {'type': 'string'}},
                                  'required': ['url'],
                                  'type': 'object'},
                     'CharmURLs': {'additionalProperties': False,
                                   'properties': {'urls': {'items': {'$ref': '#/definitions/CharmURL'},
                                                           'type': 'array'}},
                                   'required': ['urls'],
                                   'type': 'object'},
                     'ConfigSettingsResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                              'required': ['settings'],
                                              'type': 'object'},
                     'ConfigSettingsResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/ConfigSettingsResult'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'Endpoint': {'additionalProperties': False,
                                  'properties': {'application-name': {'type': 'string'},
                                                 'relation': {'$ref': '#/definitions/CharmRelation'}},
                                  'required': ['application-name', 'relation'],
                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesCharmURL': {'additionalProperties': False,
                                          'properties': {'entities': {'items': {'$ref': '#/definitions/EntityCharmURL'},
                                                                      'type': 'array'}},
                                          'required': ['entities'],
                                          'type': 'object'},
                     'EntitiesPortRanges': {'additionalProperties': False,
                                            'properties': {'entities': {'items': {'$ref': '#/definitions/EntityPortRange'},
                                                                        'type': 'array'}},
                                            'required': ['entities'],
                                            'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityCharmURL': {'additionalProperties': False,
                                        'properties': {'charm-url': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'charm-url'],
                                        'type': 'object'},
                     'EntityPortRange': {'additionalProperties': False,
                                         'properties': {'from-port': {'type': 'integer'},
                                                        'protocol': {'type': 'string'},
                                                        'tag': {'type': 'string'},
                                                        'to-port': {'type': 'integer'}},
                                         'required': ['tag',
                                                      'protocol',
                                                      'from-port',
                                                      'to-port'],
                                         'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'EntityWorkloadVersion': {'additionalProperties': False,
                                               'properties': {'tag': {'type': 'string'},
                                                              'workload-version': {'type': 'string'}},
                                               'required': ['tag',
                                                            'workload-version'],
                                               'type': 'object'},
                     'EntityWorkloadVersions': {'additionalProperties': False,
                                                'properties': {'entities': {'items': {'$ref': '#/definitions/EntityWorkloadVersion'},
                                                                            'type': 'array'}},
                                                'required': ['entities'],
                                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetLeadershipSettingsBulkResults': {'additionalProperties': False,
                                                          'properties': {'results': {'items': {'$ref': '#/definitions/GetLeadershipSettingsResult'},
                                                                                     'type': 'array'}},
                                                          'required': ['results'],
                                                          'type': 'object'},
                     'GetLeadershipSettingsResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                 'type': 'object'}},
                                                     'required': ['settings'],
                                                     'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'IntResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'type': 'integer'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'IntResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/IntResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachinePortRange': {'additionalProperties': False,
                                          'properties': {'port-range': {'$ref': '#/definitions/PortRange'},
                                                         'relation-tag': {'type': 'string'},
                                                         'unit-tag': {'type': 'string'}},
                                          'required': ['unit-tag',
                                                       'relation-tag',
                                                       'port-range'],
                                          'type': 'object'},
                     'MachinePortsResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'ports': {'items': {'$ref': '#/definitions/MachinePortRange'},
                                                                     'type': 'array'}},
                                            'required': ['ports'],
                                            'type': 'object'},
                     'MachinePortsResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/MachinePortsResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'MergeLeadershipSettingsBulkParams': {'additionalProperties': False,
                                                           'properties': {'params': {'items': {'$ref': '#/definitions/MergeLeadershipSettingsParam'},
                                                                                     'type': 'array'}},
                                                           'required': ['params'],
                                                           'type': 'object'},
                     'MergeLeadershipSettingsParam': {'additionalProperties': False,
                                                      'properties': {'application-tag': {'type': 'string'},
                                                                     'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                  'type': 'object'}},
                                                      'required': ['application-tag',
                                                                   'settings'],
                                                      'type': 'object'},
                     'MeterStatusResult': {'additionalProperties': False,
                                           'properties': {'code': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'type': 'string'}},
                                           'required': ['code', 'info'],
                                           'type': 'object'},
                     'MeterStatusResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/MeterStatusResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Metric': {'additionalProperties': False,
                                'properties': {'key': {'type': 'string'},
                                               'time': {'format': 'date-time',
                                                        'type': 'string'},
                                               'value': {'type': 'string'}},
                                'required': ['key', 'value', 'time'],
                                'type': 'object'},
                     'MetricBatch': {'additionalProperties': False,
                                     'properties': {'charm-url': {'type': 'string'},
                                                    'created': {'format': 'date-time',
                                                                'type': 'string'},
                                                    'metrics': {'items': {'$ref': '#/definitions/Metric'},
                                                                'type': 'array'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['uuid',
                                                  'charm-url',
                                                  'created',
                                                  'metrics'],
                                     'type': 'object'},
                     'MetricBatchParam': {'additionalProperties': False,
                                          'properties': {'batch': {'$ref': '#/definitions/MetricBatch'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'batch'],
                                          'type': 'object'},
                     'MetricBatchParams': {'additionalProperties': False,
                                           'properties': {'batches': {'items': {'$ref': '#/definitions/MetricBatchParam'},
                                                                      'type': 'array'}},
                                           'required': ['batches'],
                                           'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ModelResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'name': {'type': 'string'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['name', 'uuid'],
                                     'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'PortRange': {'additionalProperties': False,
                                   'properties': {'from-port': {'type': 'integer'},
                                                  'protocol': {'type': 'string'},
                                                  'to-port': {'type': 'integer'}},
                                   'required': ['from-port', 'to-port', 'protocol'],
                                   'type': 'object'},
                     'RelationIds': {'additionalProperties': False,
                                     'properties': {'relation-ids': {'items': {'type': 'integer'},
                                                                     'type': 'array'}},
                                     'required': ['relation-ids'],
                                     'type': 'object'},
                     'RelationResult': {'additionalProperties': False,
                                        'properties': {'endpoint': {'$ref': '#/definitions/Endpoint'},
                                                       'error': {'$ref': '#/definitions/Error'},
                                                       'id': {'type': 'integer'},
                                                       'key': {'type': 'string'},
                                                       'life': {'type': 'string'}},
                                        'required': ['life',
                                                     'id',
                                                     'key',
                                                     'endpoint'],
                                        'type': 'object'},
                     'RelationResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/RelationResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'RelationUnit': {'additionalProperties': False,
                                      'properties': {'relation': {'type': 'string'},
                                                     'unit': {'type': 'string'}},
                                      'required': ['relation', 'unit'],
                                      'type': 'object'},
                     'RelationUnitPair': {'additionalProperties': False,
                                          'properties': {'local-unit': {'type': 'string'},
                                                         'relation': {'type': 'string'},
                                                         'remote-unit': {'type': 'string'}},
                                          'required': ['relation',
                                                       'local-unit',
                                                       'remote-unit'],
                                          'type': 'object'},
                     'RelationUnitPairs': {'additionalProperties': False,
                                           'properties': {'relation-unit-pairs': {'items': {'$ref': '#/definitions/RelationUnitPair'},
                                                                                  'type': 'array'}},
                                           'required': ['relation-unit-pairs'],
                                           'type': 'object'},
                     'RelationUnitSettings': {'additionalProperties': False,
                                              'properties': {'relation': {'type': 'string'},
                                                             'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'},
                                                             'unit': {'type': 'string'}},
                                              'required': ['relation',
                                                           'unit',
                                                           'settings'],
                                              'type': 'object'},
                     'RelationUnits': {'additionalProperties': False,
                                       'properties': {'relation-units': {'items': {'$ref': '#/definitions/RelationUnit'},
                                                                         'type': 'array'}},
                                       'required': ['relation-units'],
                                       'type': 'object'},
                     'RelationUnitsChange': {'additionalProperties': False,
                                             'properties': {'changed': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitSettings'}},
                                                                        'type': 'object'},
                                                            'departed': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                             'required': ['changed'],
                                             'type': 'object'},
                     'RelationUnitsSettings': {'additionalProperties': False,
                                               'properties': {'relation-units': {'items': {'$ref': '#/definitions/RelationUnitSettings'},
                                                                                 'type': 'array'}},
                                               'required': ['relation-units'],
                                               'type': 'object'},
                     'RelationUnitsWatchResult': {'additionalProperties': False,
                                                  'properties': {'changes': {'$ref': '#/definitions/RelationUnitsChange'},
                                                                 'error': {'$ref': '#/definitions/Error'},
                                                                 'watcher-id': {'type': 'string'}},
                                                  'required': ['watcher-id',
                                                               'changes'],
                                                  'type': 'object'},
                     'RelationUnitsWatchResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/RelationUnitsWatchResult'},
                                                                              'type': 'array'}},
                                                   'required': ['results'],
                                                   'type': 'object'},
                     'ResolvedModeResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'mode': {'type': 'string'}},
                                            'required': ['mode'],
                                            'type': 'object'},
                     'ResolvedModeResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/ResolvedModeResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'SettingsResult': {'additionalProperties': False,
                                        'properties': {'error': {'$ref': '#/definitions/Error'},
                                                       'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                    'type': 'object'}},
                                        'required': ['settings'],
                                        'type': 'object'},
                     'SettingsResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/SettingsResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'StatusResult': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'id': {'type': 'string'},
                                                     'info': {'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['id',
                                                   'life',
                                                   'status',
                                                   'info',
                                                   'data',
                                                   'since'],
                                      'type': 'object'},
                     'StatusResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StatusResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StorageAddParams': {'additionalProperties': False,
                                          'properties': {'name': {'type': 'string'},
                                                         'storage': {'$ref': '#/definitions/StorageConstraints'},
                                                         'unit': {'type': 'string'}},
                                          'required': ['unit', 'name', 'storage'],
                                          'type': 'object'},
                     'StorageAttachment': {'additionalProperties': False,
                                           'properties': {'kind': {'type': 'integer'},
                                                          'life': {'type': 'string'},
                                                          'location': {'type': 'string'},
                                                          'owner-tag': {'type': 'string'},
                                                          'storage-tag': {'type': 'string'},
                                                          'unit-tag': {'type': 'string'}},
                                           'required': ['storage-tag',
                                                        'owner-tag',
                                                        'unit-tag',
                                                        'kind',
                                                        'location',
                                                        'life'],
                                           'type': 'object'},
                     'StorageAttachmentId': {'additionalProperties': False,
                                             'properties': {'storage-tag': {'type': 'string'},
                                                            'unit-tag': {'type': 'string'}},
                                             'required': ['storage-tag',
                                                          'unit-tag'],
                                             'type': 'object'},
                     'StorageAttachmentIds': {'additionalProperties': False,
                                              'properties': {'ids': {'items': {'$ref': '#/definitions/StorageAttachmentId'},
                                                                     'type': 'array'}},
                                              'required': ['ids'],
                                              'type': 'object'},
                     'StorageAttachmentIdsResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'result': {'$ref': '#/definitions/StorageAttachmentIds'}},
                                                    'required': ['result'],
                                                    'type': 'object'},
                     'StorageAttachmentIdsResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/StorageAttachmentIdsResult'},
                                                                                'type': 'array'}},
                                                     'type': 'object'},
                     'StorageAttachmentResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/StorageAttachment'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'StorageAttachmentResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/StorageAttachmentResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StoragesAddParams': {'additionalProperties': False,
                                           'properties': {'storages': {'items': {'$ref': '#/definitions/StorageAddParams'},
                                                                       'type': 'array'}},
                                           'required': ['storages'],
                                           'type': 'object'},
                     'StringBoolResult': {'additionalProperties': False,
                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                         'ok': {'type': 'boolean'},
                                                         'result': {'type': 'string'}},
                                          'required': ['result', 'ok'],
                                          'type': 'object'},
                     'StringBoolResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/StringBoolResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'UnitNetworkConfig': {'additionalProperties': False,
                                           'properties': {'binding-name': {'type': 'string'},
                                                          'unit-tag': {'type': 'string'}},
                                           'required': ['unit-tag', 'binding-name'],
                                           'type': 'object'},
                     'UnitNetworkConfigResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'info': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                         'type': 'array'}},
                                                 'required': ['info'],
                                                 'type': 'object'},
                     'UnitNetworkConfigResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/UnitNetworkConfigResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'UnitSettings': {'additionalProperties': False,
                                      'properties': {'version': {'type': 'integer'}},
                                      'required': ['version'],
                                      'type': 'object'},
                     'UnitsNetworkConfig': {'additionalProperties': False,
                                            'properties': {'args': {'items': {'$ref': '#/definitions/UnitNetworkConfig'},
                                                                    'type': 'array'}},
                                            'required': ['args'],
                                            'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'Actions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'AddMetricBatches': {'properties': {'Params': {'$ref': '#/definitions/MetricBatchParams'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'AddUnitStorage': {'properties': {'Params': {'$ref': '#/definitions/StoragesAddParams'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'AllMachinePorts': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/MachinePortsResults'}},
                                        'type': 'object'},
                    'ApplicationStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ApplicationStatusResults'}},
                                          'type': 'object'},
                    'AssignedMachine': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/StringResults'}},
                                        'type': 'object'},
                    'AvailabilityZone': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringResults'}},
                                         'type': 'object'},
                    'BeginActions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'CharmArchiveSha256': {'properties': {'Params': {'$ref': '#/definitions/CharmURLs'},
                                                          'Result': {'$ref': '#/definitions/StringResults'}},
                                           'type': 'object'},
                    'CharmModifiedVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                            'Result': {'$ref': '#/definitions/IntResults'}},
                                             'type': 'object'},
                    'CharmURL': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                'Result': {'$ref': '#/definitions/StringBoolResults'}},
                                 'type': 'object'},
                    'ClearResolved': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'ClosePorts': {'properties': {'Params': {'$ref': '#/definitions/EntitiesPortRanges'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'ConfigSettings': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/ConfigSettingsResults'}},
                                       'type': 'object'},
                    'CurrentModel': {'properties': {'Result': {'$ref': '#/definitions/ModelResult'}},
                                     'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'DestroyAllSubordinates': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'DestroyUnitStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                      'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'EnterScope': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FinishActions': {'properties': {'Params': {'$ref': '#/definitions/ActionExecutionResults'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'GetMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/MeterStatusResults'}},
                                       'type': 'object'},
                    'GetPrincipal': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/StringBoolResults'}},
                                     'type': 'object'},
                    'HasSubordinates': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/BoolResults'}},
                                        'type': 'object'},
                    'JoinedRelations': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/StringsResults'}},
                                        'type': 'object'},
                    'LeaveScope': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'Merge': {'properties': {'Params': {'$ref': '#/definitions/MergeLeadershipSettingsBulkParams'},
                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                              'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'NetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/UnitsNetworkConfig'},
                                                     'Result': {'$ref': '#/definitions/UnitNetworkConfigResults'}},
                                      'type': 'object'},
                    'OpenPorts': {'properties': {'Params': {'$ref': '#/definitions/EntitiesPortRanges'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StringResults'}},
                                       'type': 'object'},
                    'ProviderType': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/StringResults'}},
                                      'type': 'object'},
                    'Read': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/GetLeadershipSettingsBulkResults'}},
                             'type': 'object'},
                    'ReadRemoteSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnitPairs'},
                                                          'Result': {'$ref': '#/definitions/SettingsResults'}},
                                           'type': 'object'},
                    'ReadSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                    'Result': {'$ref': '#/definitions/SettingsResults'}},
                                     'type': 'object'},
                    'Relation': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                'Result': {'$ref': '#/definitions/RelationResults'}},
                                 'type': 'object'},
                    'RelationById': {'properties': {'Params': {'$ref': '#/definitions/RelationIds'},
                                                    'Result': {'$ref': '#/definitions/RelationResults'}},
                                     'type': 'object'},
                    'RemoveStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'RequestReboot': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'Resolved': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                'Result': {'$ref': '#/definitions/ResolvedModeResults'}},
                                 'type': 'object'},
                    'SetAgentStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'SetApplicationStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'SetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/EntitiesCharmURL'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetUnitStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'SetWorkloadVersion': {'properties': {'Params': {'$ref': '#/definitions/EntityWorkloadVersions'},
                                                          'Result': {'$ref': '#/definitions/ErrorResults'}},
                                           'type': 'object'},
                    'StorageAttachmentLife': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                             'Result': {'$ref': '#/definitions/LifeResults'}},
                                              'type': 'object'},
                    'StorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                          'Result': {'$ref': '#/definitions/StorageAttachmentResults'}},
                                           'type': 'object'},
                    'UnitStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StatusResults'}},
                                   'type': 'object'},
                    'UnitStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/StorageAttachmentIdsResults'}},
                                               'type': 'object'},
                    'UpdateSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnitsSettings'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'Watch': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchActionNotifications': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                 'type': 'object'},
                    'WatchApplicationRelations': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                  'type': 'object'},
                    'WatchConfigSettings': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                            'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchLeadershipSettings': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                'type': 'object'},
                    'WatchMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                         'type': 'object'},
                    'WatchRelationUnits': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                          'Result': {'$ref': '#/definitions/RelationUnitsWatchResults'}},
                                           'type': 'object'},
                    'WatchStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/StorageAttachmentIds'},
                                                               'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                'type': 'object'},
                    'WatchUnitAddresses': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                           'type': 'object'},
                    'WatchUnitStorageAttachments': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                   'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                    'type': 'object'},
                    'WorkloadVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/StringResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='APIAddresses',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='APIHostPorts',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Actions(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ActionResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Actions',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def AddMetricBatches(self, batches=None):
        '''
        batches : typing.Sequence[~MetricBatchParam]
        Returns -> ErrorResults
        '''
        if batches is not None and not isinstance(batches, (bytes, str, list)):
            raise Exception("Expected batches to be a Sequence, received: {}".format(type(batches)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AddMetricBatches',
                   version=4,
                   params=_params)
        _params['batches'] = batches
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def AddUnitStorage(self, storages=None):
        '''
        storages : typing.Sequence[~StorageAddParams]
        Returns -> ErrorResults
        '''
        if storages is not None and not isinstance(storages, (bytes, str, list)):
            raise Exception("Expected storages to be a Sequence, received: {}".format(type(storages)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AddUnitStorage',
                   version=4,
                   params=_params)
        _params['storages'] = storages
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachinePortsResults)
    async def AllMachinePorts(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachinePortsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AllMachinePorts',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationStatusResults)
    async def ApplicationStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ApplicationStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def AssignedMachine(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AssignedMachine',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def AvailabilityZone(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='AvailabilityZone',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def BeginActions(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='BeginActions',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> BytesResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CACert',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def CharmArchiveSha256(self, urls=None):
        '''
        urls : typing.Sequence[~CharmURL]
        Returns -> StringResults
        '''
        if urls is not None and not isinstance(urls, (bytes, str, list)):
            raise Exception("Expected urls to be a Sequence, received: {}".format(type(urls)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CharmArchiveSha256',
                   version=4,
                   params=_params)
        _params['urls'] = urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IntResults)
    async def CharmModifiedVersion(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> IntResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CharmModifiedVersion',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringBoolResults)
    async def CharmURL(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringBoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CharmURL',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ClearResolved(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ClearResolved',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ClosePorts(self, entities=None):
        '''
        entities : typing.Sequence[~EntityPortRange]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ClosePorts',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConfigSettingsResults)
    async def ConfigSettings(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ConfigSettingsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ConfigSettings',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelResult)
    async def CurrentModel(self):
        '''

        Returns -> ModelResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='CurrentModel',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Destroy(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Destroy',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyAllSubordinates(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='DestroyAllSubordinates',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyUnitStorageAttachments(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='DestroyUnitStorageAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='EnsureDead',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnterScope(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> ErrorResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='EnterScope',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def FinishActions(self, results=None):
        '''
        results : typing.Sequence[~ActionExecutionResult]
        Returns -> ErrorResults
        '''
        if results is not None and not isinstance(results, (bytes, str, list)):
            raise Exception("Expected results to be a Sequence, received: {}".format(type(results)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='FinishActions',
                   version=4,
                   params=_params)
        _params['results'] = results
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MeterStatusResults)
    async def GetMeterStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MeterStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='GetMeterStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringBoolResults)
    async def GetPrincipal(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringBoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='GetPrincipal',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResults)
    async def HasSubordinates(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> BoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='HasSubordinates',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def JoinedRelations(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='JoinedRelations',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def LeaveScope(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> ErrorResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='LeaveScope',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Life',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Merge(self, params=None):
        '''
        params : typing.Sequence[~MergeLeadershipSettingsParam]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Merge',
                   version=4,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ModelConfig',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ModelUUID',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UnitNetworkConfigResults)
    async def NetworkConfig(self, args=None):
        '''
        args : typing.Sequence[~UnitNetworkConfig]
        Returns -> UnitNetworkConfigResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='NetworkConfig',
                   version=4,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def OpenPorts(self, entities=None):
        '''
        entities : typing.Sequence[~EntityPortRange]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='OpenPorts',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def PrivateAddress(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='PrivateAddress',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ProviderType(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ProviderType',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def PublicAddress(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='PublicAddress',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetLeadershipSettingsBulkResults)
    async def Read(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> GetLeadershipSettingsBulkResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Read',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SettingsResults)
    async def ReadRemoteSettings(self, relation_unit_pairs=None):
        '''
        relation_unit_pairs : typing.Sequence[~RelationUnitPair]
        Returns -> SettingsResults
        '''
        if relation_unit_pairs is not None and not isinstance(relation_unit_pairs, (bytes, str, list)):
            raise Exception("Expected relation_unit_pairs to be a Sequence, received: {}".format(type(relation_unit_pairs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ReadRemoteSettings',
                   version=4,
                   params=_params)
        _params['relation-unit-pairs'] = relation_unit_pairs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SettingsResults)
    async def ReadSettings(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> SettingsResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='ReadSettings',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationResults)
    async def Relation(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> RelationResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Relation',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationResults)
    async def RelationById(self, relation_ids=None):
        '''
        relation_ids : typing.Sequence[int]
        Returns -> RelationResults
        '''
        if relation_ids is not None and not isinstance(relation_ids, (bytes, str, list)):
            raise Exception("Expected relation_ids to be a Sequence, received: {}".format(type(relation_ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RelationById',
                   version=4,
                   params=_params)
        _params['relation-ids'] = relation_ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveStorageAttachments(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> ErrorResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RemoveStorageAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RequestReboot(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='RequestReboot',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ResolvedModeResults)
    async def Resolved(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ResolvedModeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Resolved',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetAgentStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetAgentStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetApplicationStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetApplicationStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetCharmURL(self, entities=None):
        '''
        entities : typing.Sequence[~EntityCharmURL]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetCharmURL',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetUnitStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetUnitStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetWorkloadVersion(self, entities=None):
        '''
        entities : typing.Sequence[~EntityWorkloadVersion]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='SetWorkloadVersion',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def StorageAttachmentLife(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> LifeResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='StorageAttachmentLife',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageAttachmentResults)
    async def StorageAttachments(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> StorageAttachmentResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='StorageAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def UnitStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UnitStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StorageAttachmentIdsResults)
    async def UnitStorageAttachments(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StorageAttachmentIdsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UnitStorageAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateSettings(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnitSettings]
        Returns -> ErrorResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='UpdateSettings',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='Watch',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchAPIHostPorts',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchActionNotifications(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchActionNotifications',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchApplicationRelations(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchApplicationRelations',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchConfigSettings(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchConfigSettings',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchForModelConfigChanges',
                   version=4,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchLeadershipSettings(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchLeadershipSettings',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMeterStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchMeterStatus',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationUnitsWatchResults)
    async def WatchRelationUnits(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> RelationUnitsWatchResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchRelationUnits',
                   version=4,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchStorageAttachments(self, ids=None):
        '''
        ids : typing.Sequence[~StorageAttachmentId]
        Returns -> NotifyWatchResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchStorageAttachments',
                   version=4,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchUnitAddresses(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchUnitAddresses',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchUnitStorageAttachments(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WatchUnitStorageAttachments',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def WorkloadVersion(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Uniter',
                   request='WorkloadVersion',
                   version=4,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply


