# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client.facade import Type, ReturnMapping
from juju.client._definitions import *


class ActionFacade(Type):
    name = 'Action'
    version = 2
    schema =     {'definitions': {'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ActionSpec': {'additionalProperties': False,
                                    'properties': {'description': {'type': 'string'},
                                                   'params': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'}},
                                    'required': ['description', 'params'],
                                    'type': 'object'},
                     'Actions': {'additionalProperties': False,
                                 'properties': {'actions': {'items': {'$ref': '#/definitions/Action'},
                                                            'type': 'array'}},
                                 'type': 'object'},
                     'ActionsByName': {'additionalProperties': False,
                                       'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'},
                                                      'error': {'$ref': '#/definitions/Error'},
                                                      'name': {'type': 'string'}},
                                       'type': 'object'},
                     'ActionsByNames': {'additionalProperties': False,
                                        'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByName'},
                                                                   'type': 'array'}},
                                        'type': 'object'},
                     'ActionsByReceiver': {'additionalProperties': False,
                                           'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                      'type': 'array'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'receiver': {'type': 'string'}},
                                           'type': 'object'},
                     'ActionsByReceivers': {'additionalProperties': False,
                                            'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByReceiver'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'ApplicationCharmActionsResult': {'additionalProperties': False,
                                                       'properties': {'actions': {'patternProperties': {'.*': {'$ref': '#/definitions/ActionSpec'}},
                                                                                  'type': 'object'},
                                                                      'application-tag': {'type': 'string'},
                                                                      'error': {'$ref': '#/definitions/Error'}},
                                                       'type': 'object'},
                     'ApplicationsCharmActionsResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationCharmActionsResult'},
                                                                                    'type': 'array'}},
                                                         'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'FindActionsByNames': {'additionalProperties': False,
                                            'properties': {'names': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                            'type': 'object'},
                     'FindTags': {'additionalProperties': False,
                                  'properties': {'prefixes': {'items': {'type': 'string'},
                                                              'type': 'array'}},
                                  'required': ['prefixes'],
                                  'type': 'object'},
                     'FindTagsResults': {'additionalProperties': False,
                                         'properties': {'matches': {'patternProperties': {'.*': {'items': {'$ref': '#/definitions/Entity'},
                                                                                                 'type': 'array'}},
                                                                    'type': 'object'}},
                                         'required': ['matches'],
                                         'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RunParams': {'additionalProperties': False,
                                   'properties': {'applications': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                  'commands': {'type': 'string'},
                                                  'machines': {'items': {'type': 'string'},
                                                               'type': 'array'},
                                                  'timeout': {'type': 'integer'},
                                                  'units': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                   'required': ['commands', 'timeout'],
                                   'type': 'object'}},
     'properties': {'Actions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'ApplicationsCharmsActions': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/ApplicationsCharmActionsResults'}},
                                                  'type': 'object'},
                    'Cancel': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ActionResults'}},
                               'type': 'object'},
                    'Enqueue': {'properties': {'Params': {'$ref': '#/definitions/Actions'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'FindActionTagsByPrefix': {'properties': {'Params': {'$ref': '#/definitions/FindTags'},
                                                              'Result': {'$ref': '#/definitions/FindTagsResults'}},
                                               'type': 'object'},
                    'FindActionsByNames': {'properties': {'Params': {'$ref': '#/definitions/FindActionsByNames'},
                                                          'Result': {'$ref': '#/definitions/ActionsByNames'}},
                                           'type': 'object'},
                    'ListAll': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                'type': 'object'},
                    'ListCompleted': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                      'type': 'object'},
                    'ListPending': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'ListRunning': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                    'type': 'object'},
                    'Run': {'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                           'Result': {'$ref': '#/definitions/ActionResults'}},
                            'type': 'object'},
                    'RunOnAllMachines': {'properties': {'Params': {'$ref': '#/definitions/RunParams'},
                                                        'Result': {'$ref': '#/definitions/ActionResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ActionResults)
    async def Actions(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ActionResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Actions',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationsCharmActionsResults)
    async def ApplicationsCharmsActions(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationsCharmActionsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ApplicationsCharmsActions',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Cancel(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ActionResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Cancel',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Enqueue(self, actions=None):
        '''
        actions : typing.Sequence[~Action]
        Returns -> ActionResults
        '''
        if actions is not None and not isinstance(actions, (bytes, str, list)):
            raise Exception("Expected actions to be a Sequence, received: {}".format(type(actions)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Enqueue',
                   version=2,
                   params=_params)
        _params['actions'] = actions
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindTagsResults)
    async def FindActionTagsByPrefix(self, prefixes=None):
        '''
        prefixes : typing.Sequence[str]
        Returns -> FindTagsResults
        '''
        if prefixes is not None and not isinstance(prefixes, (bytes, str, list)):
            raise Exception("Expected prefixes to be a Sequence, received: {}".format(type(prefixes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='FindActionTagsByPrefix',
                   version=2,
                   params=_params)
        _params['prefixes'] = prefixes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByNames)
    async def FindActionsByNames(self, names=None):
        '''
        names : typing.Sequence[str]
        Returns -> ActionsByNames
        '''
        if names is not None and not isinstance(names, (bytes, str, list)):
            raise Exception("Expected names to be a Sequence, received: {}".format(type(names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='FindActionsByNames',
                   version=2,
                   params=_params)
        _params['names'] = names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListAll(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ActionsByReceivers
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListAll',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListCompleted(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ActionsByReceivers
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListCompleted',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListPending(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ActionsByReceivers
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListPending',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def ListRunning(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ActionsByReceivers
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='ListRunning',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def Run(self, applications=None, commands=None, machines=None, timeout=None, units=None):
        '''
        applications : typing.Sequence[str]
        commands : str
        machines : typing.Sequence[str]
        timeout : int
        units : typing.Sequence[str]
        Returns -> ActionResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        if commands is not None and not isinstance(commands, (bytes, str)):
            raise Exception("Expected commands to be a str, received: {}".format(type(commands)))

        if machines is not None and not isinstance(machines, (bytes, str, list)):
            raise Exception("Expected machines to be a Sequence, received: {}".format(type(machines)))

        if timeout is not None and not isinstance(timeout, int):
            raise Exception("Expected timeout to be a int, received: {}".format(type(timeout)))

        if units is not None and not isinstance(units, (bytes, str, list)):
            raise Exception("Expected units to be a Sequence, received: {}".format(type(units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='Run',
                   version=2,
                   params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionResults)
    async def RunOnAllMachines(self, applications=None, commands=None, machines=None, timeout=None, units=None):
        '''
        applications : typing.Sequence[str]
        commands : str
        machines : typing.Sequence[str]
        timeout : int
        units : typing.Sequence[str]
        Returns -> ActionResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        if commands is not None and not isinstance(commands, (bytes, str)):
            raise Exception("Expected commands to be a str, received: {}".format(type(commands)))

        if machines is not None and not isinstance(machines, (bytes, str, list)):
            raise Exception("Expected machines to be a Sequence, received: {}".format(type(machines)))

        if timeout is not None and not isinstance(timeout, int):
            raise Exception("Expected timeout to be a int, received: {}".format(type(timeout)))

        if units is not None and not isinstance(units, (bytes, str, list)):
            raise Exception("Expected units to be a Sequence, received: {}".format(type(units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Action',
                   request='RunOnAllMachines',
                   version=2,
                   params=_params)
        _params['applications'] = applications
        _params['commands'] = commands
        _params['machines'] = machines
        _params['timeout'] = timeout
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



class AgentFacade(Type):
    name = 'Agent'
    version = 2
    schema =     {'definitions': {'AgentGetEntitiesResult': {'additionalProperties': False,
                                                'properties': {'container-type': {'type': 'string'},
                                                               'error': {'$ref': '#/definitions/Error'},
                                                               'jobs': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                               'life': {'type': 'string'}},
                                                'required': ['life',
                                                             'jobs',
                                                             'container-type'],
                                                'type': 'object'},
                     'AgentGetEntitiesResults': {'additionalProperties': False,
                                                 'properties': {'entities': {'items': {'$ref': '#/definitions/AgentGetEntitiesResult'},
                                                                             'type': 'array'}},
                                                 'required': ['entities'],
                                                 'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'cacertificates': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                  'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'CloudSpecResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudSpecResult'},
                                                                     'type': 'array'}},
                                          'type': 'object'},
                     'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'IsMasterResult': {'additionalProperties': False,
                                        'properties': {'master': {'type': 'boolean'}},
                                        'required': ['master'],
                                        'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ModelTag': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'StateServingInfo': {'additionalProperties': False,
                                          'properties': {'api-port': {'type': 'integer'},
                                                         'ca-private-key': {'type': 'string'},
                                                         'cert': {'type': 'string'},
                                                         'controller-api-port': {'type': 'integer'},
                                                         'private-key': {'type': 'string'},
                                                         'shared-secret': {'type': 'string'},
                                                         'state-port': {'type': 'integer'},
                                                         'system-identity': {'type': 'string'}},
                                          'required': ['api-port',
                                                       'state-port',
                                                       'cert',
                                                       'private-key',
                                                       'ca-private-key',
                                                       'shared-secret',
                                                       'system-identity'],
                                          'type': 'object'}},
     'properties': {'ClearReboot': {'description': 'ClearReboot will clear the '
                                                   'reboot flag on provided '
                                                   'machines, if it exists.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'CloudSpec': {'description': "CloudSpec returns the model's "
                                                 'cloud spec.',
                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudSpecResults'}},
                                  'type': 'object'},
                    'ControllerAPIInfoForModels': {'description': 'ControllerAPIInfoForModels '
                                                                  'returns the '
                                                                  'controller api '
                                                                  'connection '
                                                                  'details for the '
                                                                  'specified '
                                                                  'models.',
                                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'description': 'ControllerConfig returns '
                                                        "the controller's "
                                                        'configuration.',
                                         'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'GetCloudSpec': {'description': 'GetCloudSpec constructs the '
                                                    'CloudSpec for a validated and '
                                                    'authorized model.',
                                     'properties': {'Params': {'$ref': '#/definitions/ModelTag'},
                                                    'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                     'type': 'object'},
                    'GetEntities': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/AgentGetEntitiesResults'}},
                                    'type': 'object'},
                    'IsMaster': {'properties': {'Result': {'$ref': '#/definitions/IsMasterResult'}},
                                 'type': 'object'},
                    'ModelConfig': {'description': 'ModelConfig returns the '
                                                   "current model's configuration.",
                                    'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'SetPasswords': {'description': 'SetPasswords sets the given '
                                                    'password for each supplied '
                                                    'entity, if possible.',
                                     'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'StateServingInfo': {'properties': {'Result': {'$ref': '#/definitions/StateServingInfo'}},
                                         'type': 'object'},
                    'WatchCloudSpecsChanges': {'description': 'WatchCloudSpecsChanges '
                                                              'returns a watcher '
                                                              'for cloud spec '
                                                              'changes.',
                                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                               'type': 'object'},
                    'WatchCredentials': {'description': 'WatchCredentials watches '
                                                        'for changes to the '
                                                        'specified credentials.',
                                         'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                         'type': 'object'},
                    'WatchForModelConfigChanges': {'description': 'WatchForModelConfigChanges '
                                                                  'returns a '
                                                                  'NotifyWatcher '
                                                                  'that observes\n'
                                                                  'changes to the '
                                                                  'model '
                                                                  'configuration.\n'
                                                                  'Note that '
                                                                  'although the '
                                                                  'NotifyWatchResult '
                                                                  'contains an '
                                                                  'Error field,\n'
                                                                  "it's not used "
                                                                  'because we are '
                                                                  'only returning '
                                                                  'a single '
                                                                  'watcher,\n'
                                                                  'so we use the '
                                                                  'regular error '
                                                                  'return.',
                                                   'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ClearReboot(self, entities=None):
        '''
        ClearReboot will clear the reboot flag on provided machines, if it exists.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='ClearReboot',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResults)
    async def CloudSpec(self, entities=None):
        '''
        CloudSpec returns the model's cloud spec.

        entities : typing.Sequence[~Entity]
        Returns -> CloudSpecResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='CloudSpec',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        ControllerAPIInfoForModels returns the controller api connection details for the specified models.

        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='ControllerAPIInfoForModels',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''
        ControllerConfig returns the controller's configuration.


        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='ControllerConfig',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def GetCloudSpec(self):
        '''
        GetCloudSpec constructs the CloudSpec for a validated and authorized model.


        Returns -> CloudSpecResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='GetCloudSpec',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AgentGetEntitiesResults)
    async def GetEntities(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> AgentGetEntitiesResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='GetEntities',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IsMasterResult)
    async def IsMaster(self):
        '''

        Returns -> IsMasterResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='IsMaster',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''
        ModelConfig returns the current model's configuration.


        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='ModelConfig',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes=None):
        '''
        SetPasswords sets the given password for each supplied entity, if possible.

        changes : typing.Sequence[~EntityPassword]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='SetPasswords',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StateServingInfo)
    async def StateServingInfo(self):
        '''

        Returns -> StateServingInfo
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='StateServingInfo',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchCloudSpecsChanges(self, entities=None):
        '''
        WatchCloudSpecsChanges returns a watcher for cloud spec changes.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='WatchCloudSpecsChanges',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchCredentials(self, entities=None):
        '''
        WatchCredentials watches for changes to the specified credentials.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='WatchCredentials',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''
        WatchForModelConfigChanges returns a NotifyWatcher that observes
        changes to the model configuration.
        Note that although the NotifyWatchResult contains an Error field,
        it's not used because we are only returning a single watcher,
        so we use the regular error return.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Agent',
                   request='WatchForModelConfigChanges',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class AllModelWatcherFacade(Type):
    name = 'AllModelWatcher'
    version = 2
    schema =     {'definitions': {'AllWatcherNextResults': {'additionalProperties': False,
                                               'properties': {'deltas': {'items': {'$ref': '#/definitions/Delta'},
                                                                         'type': 'array'}},
                                               'required': ['deltas'],
                                               'type': 'object'},
                     'Delta': {'additionalProperties': False,
                               'properties': {'entity': {'additionalProperties': True,
                                                         'type': 'object'},
                                              'removed': {'type': 'boolean'}},
                               'required': ['removed', 'entity'],
                               'type': 'object'}},
     'properties': {'Next': {'description': 'Next will return the current state of '
                                            'everything on the first call\n'
                                            'and subsequent calls will',
                             'properties': {'Result': {'$ref': '#/definitions/AllWatcherNextResults'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AllWatcherNextResults)
    async def Next(self):
        '''
        Next will return the current state of everything on the first call
        and subsequent calls will


        Returns -> AllWatcherNextResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllModelWatcher',
                   request='Next',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllModelWatcher',
                   request='Stop',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class AnnotationsFacade(Type):
    name = 'Annotations'
    version = 2
    schema =     {'definitions': {'AnnotationsGetResult': {'additionalProperties': False,
                                              'properties': {'annotations': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                             'entity': {'type': 'string'},
                                                             'error': {'$ref': '#/definitions/ErrorResult'}},
                                              'required': ['entity', 'annotations'],
                                              'type': 'object'},
                     'AnnotationsGetResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/AnnotationsGetResult'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'AnnotationsSet': {'additionalProperties': False,
                                        'properties': {'annotations': {'items': {'$ref': '#/definitions/EntityAnnotations'},
                                                                       'type': 'array'}},
                                        'required': ['annotations'],
                                        'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityAnnotations': {'additionalProperties': False,
                                           'properties': {'annotations': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'},
                                                          'entity': {'type': 'string'}},
                                           'required': ['entity', 'annotations'],
                                           'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'}},
     'properties': {'Get': {'description': 'Get returns annotations for given '
                                           'entities.\n'
                                           'If annotations cannot be retrieved for '
                                           'a given entity, an error is returned.\n'
                                           'Each entity is treated independently '
                                           'and, hence, will fail or succeed '
                                           'independently.',
                            'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                           'Result': {'$ref': '#/definitions/AnnotationsGetResults'}},
                            'type': 'object'},
                    'Set': {'description': 'Set stores annotations for given '
                                           'entities',
                            'properties': {'Params': {'$ref': '#/definitions/AnnotationsSet'},
                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AnnotationsGetResults)
    async def Get(self, entities=None):
        '''
        Get returns annotations for given entities.
        If annotations cannot be retrieved for a given entity, an error is returned.
        Each entity is treated independently and, hence, will fail or succeed independently.

        entities : typing.Sequence[~Entity]
        Returns -> AnnotationsGetResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Annotations',
                   request='Get',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Set(self, annotations=None):
        '''
        Set stores annotations for given entities

        annotations : typing.Sequence[~EntityAnnotations]
        Returns -> ErrorResults
        '''
        if annotations is not None and not isinstance(annotations, (bytes, str, list)):
            raise Exception("Expected annotations to be a Sequence, received: {}".format(type(annotations)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Annotations',
                   request='Set',
                   version=2,
                   params=_params)
        _params['annotations'] = annotations
        reply = await self.rpc(msg)
        return reply



class ApplicationFacade(Type):
    name = 'Application'
    version = 2
    schema =     {'definitions': {'AddApplicationUnits': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'num-units': {'type': 'integer'},
                                                            'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                          'type': 'array'}},
                                             'required': ['application',
                                                          'num-units',
                                                          'placement'],
                                             'type': 'object'},
                     'AddApplicationUnitsResults': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'AddRelation': {'additionalProperties': False,
                                     'properties': {'endpoints': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                     'required': ['endpoints'],
                                     'type': 'object'},
                     'AddRelationResults': {'additionalProperties': False,
                                            'properties': {'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                                         'type': 'object'}},
                                            'required': ['endpoints'],
                                            'type': 'object'},
                     'ApplicationCharmRelations': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'ApplicationCharmRelationsResults': {'additionalProperties': False,
                                                          'properties': {'charm-relations': {'items': {'type': 'string'},
                                                                                             'type': 'array'}},
                                                          'required': ['charm-relations'],
                                                          'type': 'object'},
                     'ApplicationDeploy': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'channel': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                          'config-yaml': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'num-units': {'type': 'integer'},
                                                          'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                        'type': 'array'},
                                                          'resources': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'}},
                                           'required': ['application',
                                                        'series',
                                                        'charm-url',
                                                        'channel',
                                                        'num-units',
                                                        'config-yaml',
                                                        'constraints'],
                                           'type': 'object'},
                     'ApplicationDestroy': {'additionalProperties': False,
                                            'properties': {'application': {'type': 'string'}},
                                            'required': ['application'],
                                            'type': 'object'},
                     'ApplicationExpose': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'}},
                                           'required': ['application'],
                                           'type': 'object'},
                     'ApplicationGet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'}},
                                        'required': ['application'],
                                        'type': 'object'},
                     'ApplicationGetResults': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'charm': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'constraints': {'$ref': '#/definitions/Value'},
                                                              'series': {'type': 'string'}},
                                               'required': ['application',
                                                            'charm',
                                                            'config',
                                                            'constraints',
                                                            'series'],
                                               'type': 'object'},
                     'ApplicationMetricCredential': {'additionalProperties': False,
                                                     'properties': {'application': {'type': 'string'},
                                                                    'metrics-credentials': {'items': {'type': 'integer'},
                                                                                            'type': 'array'}},
                                                     'required': ['application',
                                                                  'metrics-credentials'],
                                                     'type': 'object'},
                     'ApplicationMetricCredentials': {'additionalProperties': False,
                                                      'properties': {'creds': {'items': {'$ref': '#/definitions/ApplicationMetricCredential'},
                                                                               'type': 'array'}},
                                                      'required': ['creds'],
                                                      'type': 'object'},
                     'ApplicationSet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'options': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'}},
                                        'required': ['application', 'options'],
                                        'type': 'object'},
                     'ApplicationSetCharm': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'channel': {'type': 'string'},
                                                            'charm-url': {'type': 'string'},
                                                            'config-settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                            'config-settings-yaml': {'type': 'string'},
                                                            'force-series': {'type': 'boolean'},
                                                            'force-units': {'type': 'boolean'},
                                                            'resource-ids': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                            'storage-constraints': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageConstraints'}},
                                                                                    'type': 'object'}},
                                             'required': ['application',
                                                          'charm-url',
                                                          'channel',
                                                          'force-units',
                                                          'force-series'],
                                             'type': 'object'},
                     'ApplicationUnexpose': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'}},
                                             'required': ['application'],
                                             'type': 'object'},
                     'ApplicationUnset': {'additionalProperties': False,
                                          'properties': {'application': {'type': 'string'},
                                                         'options': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['application', 'options'],
                                          'type': 'object'},
                     'ApplicationUpdate': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'force-charm-url': {'type': 'boolean'},
                                                          'force-series': {'type': 'boolean'},
                                                          'min-units': {'type': 'integer'},
                                                          'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                       'type': 'object'},
                                                          'settings-yaml': {'type': 'string'}},
                                           'required': ['application',
                                                        'charm-url',
                                                        'force-charm-url',
                                                        'force-series',
                                                        'settings-yaml'],
                                           'type': 'object'},
                     'ApplicationsDeploy': {'additionalProperties': False,
                                            'properties': {'applications': {'items': {'$ref': '#/definitions/ApplicationDeploy'},
                                                                            'type': 'array'}},
                                            'required': ['applications'],
                                            'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyApplicationUnits': {'additionalProperties': False,
                                                 'properties': {'unit-names': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                 'required': ['unit-names'],
                                                 'type': 'object'},
                     'DestroyRelation': {'additionalProperties': False,
                                         'properties': {'endpoints': {'items': {'type': 'string'},
                                                                      'type': 'array'}},
                                         'required': ['endpoints'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetApplicationConstraints': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddRelation': {'properties': {'Params': {'$ref': '#/definitions/AddRelation'},
                                                   'Result': {'$ref': '#/definitions/AddRelationResults'}},
                                    'type': 'object'},
                    'AddUnits': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationUnits'},
                                                'Result': {'$ref': '#/definitions/AddApplicationUnitsResults'}},
                                 'type': 'object'},
                    'CharmRelations': {'properties': {'Params': {'$ref': '#/definitions/ApplicationCharmRelations'},
                                                      'Result': {'$ref': '#/definitions/ApplicationCharmRelationsResults'}},
                                       'type': 'object'},
                    'Deploy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationsDeploy'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationDestroy'}},
                                'type': 'object'},
                    'DestroyRelation': {'properties': {'Params': {'$ref': '#/definitions/DestroyRelation'}},
                                        'type': 'object'},
                    'DestroyUnits': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationUnits'}},
                                     'type': 'object'},
                    'Expose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationExpose'}},
                               'type': 'object'},
                    'Get': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                           'Result': {'$ref': '#/definitions/ApplicationGetResults'}},
                            'type': 'object'},
                    'GetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                                   'Result': {'$ref': '#/definitions/StringResult'}},
                                    'type': 'object'},
                    'GetConstraints': {'properties': {'Params': {'$ref': '#/definitions/GetApplicationConstraints'},
                                                      'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                       'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSet'}},
                            'type': 'object'},
                    'SetCharm': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharm'}},
                                 'type': 'object'},
                    'SetConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                       'type': 'object'},
                    'SetMetricCredentials': {'properties': {'Params': {'$ref': '#/definitions/ApplicationMetricCredentials'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'Unexpose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnexpose'}},
                                 'type': 'object'},
                    'Unset': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnset'}},
                              'type': 'object'},
                    'Update': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUpdate'}},
                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddRelationResults)
    async def AddRelation(self, endpoints=None):
        '''
        endpoints : typing.Sequence[str]
        Returns -> AddRelationResults
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddRelation',
                   version=2,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddApplicationUnitsResults)
    async def AddUnits(self, application=None, num_units=None, placement=None):
        '''
        application : str
        num_units : int
        placement : typing.Sequence[~Placement]
        Returns -> AddApplicationUnitsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if num_units is not None and not isinstance(num_units, int):
            raise Exception("Expected num_units to be a int, received: {}".format(type(num_units)))

        if placement is not None and not isinstance(placement, (bytes, str, list)):
            raise Exception("Expected placement to be a Sequence, received: {}".format(type(placement)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddUnits',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['num-units'] = num_units
        _params['placement'] = placement
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmRelationsResults)
    async def CharmRelations(self, application=None):
        '''
        application : str
        Returns -> ApplicationCharmRelationsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmRelations',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Deploy(self, applications=None):
        '''
        applications : typing.Sequence[~ApplicationDeploy]
        Returns -> ErrorResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Deploy',
                   version=2,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Destroy(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Destroy',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyRelation(self, endpoints=None):
        '''
        endpoints : typing.Sequence[str]
        Returns -> None
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyRelation',
                   version=2,
                   params=_params)
        _params['endpoints'] = endpoints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyUnits(self, unit_names=None):
        '''
        unit_names : typing.Sequence[str]
        Returns -> None
        '''
        if unit_names is not None and not isinstance(unit_names, (bytes, str, list)):
            raise Exception("Expected unit_names to be a Sequence, received: {}".format(type(unit_names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnits',
                   version=2,
                   params=_params)
        _params['unit-names'] = unit_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Expose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Expose',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetResults)
    async def Get(self, application=None):
        '''
        application : str
        Returns -> ApplicationGetResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Get',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def GetCharmURL(self, application=None):
        '''
        application : str
        Returns -> StringResult
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetCharmURL',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetConstraints(self, application=None):
        '''
        application : str
        Returns -> GetConstraintsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConstraints',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Set(self, application=None, options=None):
        '''
        application : str
        options : typing.Mapping[str, str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if options is not None and not isinstance(options, dict):
            raise Exception("Expected options to be a Mapping, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Set',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharm(self, application=None, channel=None, charm_url=None, config_settings=None, config_settings_yaml=None, force_series=None, force_units=None, resource_ids=None, storage_constraints=None):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping[str, str]
        config_settings_yaml : str
        force_series : bool
        force_units : bool
        resource_ids : typing.Mapping[str, str]
        storage_constraints : typing.Mapping[str, ~StorageConstraints]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if config_settings is not None and not isinstance(config_settings, dict):
            raise Exception("Expected config_settings to be a Mapping, received: {}".format(type(config_settings)))

        if config_settings_yaml is not None and not isinstance(config_settings_yaml, (bytes, str)):
            raise Exception("Expected config_settings_yaml to be a str, received: {}".format(type(config_settings_yaml)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if force_units is not None and not isinstance(force_units, bool):
            raise Exception("Expected force_units to be a bool, received: {}".format(type(force_units)))

        if resource_ids is not None and not isinstance(resource_ids, dict):
            raise Exception("Expected resource_ids to be a Mapping, received: {}".format(type(resource_ids)))

        if storage_constraints is not None and not isinstance(storage_constraints, dict):
            raise Exception("Expected storage_constraints to be a Mapping, received: {}".format(type(storage_constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetCharm',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['channel'] = channel
        _params['charm-url'] = charm_url
        _params['config-settings'] = config_settings
        _params['config-settings-yaml'] = config_settings_yaml
        _params['force-series'] = force_series
        _params['force-units'] = force_units
        _params['resource-ids'] = resource_ids
        _params['storage-constraints'] = storage_constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetConstraints(self, application=None, constraints=None):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetConstraints',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMetricCredentials(self, creds=None):
        '''
        creds : typing.Sequence[~ApplicationMetricCredential]
        Returns -> ErrorResults
        '''
        if creds is not None and not isinstance(creds, (bytes, str, list)):
            raise Exception("Expected creds to be a Sequence, received: {}".format(type(creds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetMetricCredentials',
                   version=2,
                   params=_params)
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unexpose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unexpose',
                   version=2,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unset(self, application=None, options=None):
        '''
        application : str
        options : typing.Sequence[str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if options is not None and not isinstance(options, (bytes, str, list)):
            raise Exception("Expected options to be a Sequence, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unset',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Update(self, application=None, charm_url=None, constraints=None, force_charm_url=None, force_series=None, min_units=None, settings=None, settings_yaml=None):
        '''
        application : str
        charm_url : str
        constraints : Value
        force_charm_url : bool
        force_series : bool
        min_units : int
        settings : typing.Mapping[str, str]
        settings_yaml : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        if force_charm_url is not None and not isinstance(force_charm_url, bool):
            raise Exception("Expected force_charm_url to be a bool, received: {}".format(type(force_charm_url)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if min_units is not None and not isinstance(min_units, int):
            raise Exception("Expected min_units to be a int, received: {}".format(type(min_units)))

        if settings is not None and not isinstance(settings, dict):
            raise Exception("Expected settings to be a Mapping, received: {}".format(type(settings)))

        if settings_yaml is not None and not isinstance(settings_yaml, (bytes, str)):
            raise Exception("Expected settings_yaml to be a str, received: {}".format(type(settings_yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Update',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        _params['constraints'] = constraints
        _params['force-charm-url'] = force_charm_url
        _params['force-series'] = force_series
        _params['min-units'] = min_units
        _params['settings'] = settings
        _params['settings-yaml'] = settings_yaml
        reply = await self.rpc(msg)
        return reply



class ApplicationOffersFacade(Type):
    name = 'ApplicationOffers'
    version = 2
    schema =     {'definitions': {'AddApplicationOffer': {'additionalProperties': False,
                                             'properties': {'application-description': {'type': 'string'},
                                                            'application-name': {'type': 'string'},
                                                            'endpoints': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'},
                                                            'model-tag': {'type': 'string'},
                                                            'offer-name': {'type': 'string'}},
                                             'required': ['model-tag',
                                                          'offer-name',
                                                          'application-name',
                                                          'application-description',
                                                          'endpoints'],
                                             'type': 'object'},
                     'AddApplicationOffers': {'additionalProperties': False,
                                              'properties': {'Offers': {'items': {'$ref': '#/definitions/AddApplicationOffer'},
                                                                        'type': 'array'}},
                                              'required': ['Offers'],
                                              'type': 'object'},
                     'ApplicationOfferAdminDetails': {'additionalProperties': False,
                                                      'properties': {'ApplicationOfferDetails': {'$ref': '#/definitions/ApplicationOfferDetails'},
                                                                     'application-description': {'type': 'string'},
                                                                     'application-name': {'type': 'string'},
                                                                     'bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                  'type': 'object'},
                                                                     'charm-url': {'type': 'string'},
                                                                     'connections': {'items': {'$ref': '#/definitions/OfferConnection'},
                                                                                     'type': 'array'},
                                                                     'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                                   'type': 'array'},
                                                                     'offer-name': {'type': 'string'},
                                                                     'offer-url': {'type': 'string'},
                                                                     'offer-uuid': {'type': 'string'},
                                                                     'source-model-tag': {'type': 'string'},
                                                                     'spaces': {'items': {'$ref': '#/definitions/RemoteSpace'},
                                                                                'type': 'array'},
                                                                     'users': {'items': {'$ref': '#/definitions/OfferUserDetails'},
                                                                               'type': 'array'}},
                                                      'required': ['source-model-tag',
                                                                   'offer-uuid',
                                                                   'offer-url',
                                                                   'offer-name',
                                                                   'application-description',
                                                                   'ApplicationOfferDetails',
                                                                   'application-name',
                                                                   'charm-url'],
                                                      'type': 'object'},
                     'ApplicationOfferDetails': {'additionalProperties': False,
                                                 'properties': {'application-description': {'type': 'string'},
                                                                'bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                                'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                              'type': 'array'},
                                                                'offer-name': {'type': 'string'},
                                                                'offer-url': {'type': 'string'},
                                                                'offer-uuid': {'type': 'string'},
                                                                'source-model-tag': {'type': 'string'},
                                                                'spaces': {'items': {'$ref': '#/definitions/RemoteSpace'},
                                                                           'type': 'array'},
                                                                'users': {'items': {'$ref': '#/definitions/OfferUserDetails'},
                                                                          'type': 'array'}},
                                                 'required': ['source-model-tag',
                                                              'offer-uuid',
                                                              'offer-url',
                                                              'offer-name',
                                                              'application-description'],
                                                 'type': 'object'},
                     'ApplicationOfferResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/ApplicationOfferAdminDetails'}},
                                                'type': 'object'},
                     'ApplicationOffersResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationOfferResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'ConsumeOfferDetails': {'additionalProperties': False,
                                             'properties': {'external-controller': {'$ref': '#/definitions/ExternalControllerInfo'},
                                                            'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                            'offer': {'$ref': '#/definitions/ApplicationOfferDetails'}},
                                             'type': 'object'},
                     'ConsumeOfferDetailsResult': {'additionalProperties': False,
                                                   'properties': {'ConsumeOfferDetails': {'$ref': '#/definitions/ConsumeOfferDetails'},
                                                                  'error': {'$ref': '#/definitions/Error'},
                                                                  'external-controller': {'$ref': '#/definitions/ExternalControllerInfo'},
                                                                  'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                                  'offer': {'$ref': '#/definitions/ApplicationOfferDetails'}},
                                                   'required': ['ConsumeOfferDetails'],
                                                   'type': 'object'},
                     'ConsumeOfferDetailsResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/ConsumeOfferDetailsResult'},
                                                                               'type': 'array'}},
                                                    'type': 'object'},
                     'DestroyApplicationOffers': {'additionalProperties': False,
                                                  'properties': {'force': {'type': 'boolean'},
                                                                 'offer-urls': {'items': {'type': 'string'},
                                                                                'type': 'array'}},
                                                  'required': ['offer-urls'],
                                                  'type': 'object'},
                     'EndpointFilterAttributes': {'additionalProperties': False,
                                                  'properties': {'interface': {'type': 'string'},
                                                                 'name': {'type': 'string'},
                                                                 'role': {'type': 'string'}},
                                                  'required': ['role',
                                                               'interface',
                                                               'name'],
                                                  'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ExternalControllerInfo': {'additionalProperties': False,
                                                'properties': {'addrs': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                               'ca-cert': {'type': 'string'},
                                                               'controller-alias': {'type': 'string'},
                                                               'controller-tag': {'type': 'string'}},
                                                'required': ['controller-tag',
                                                             'controller-alias',
                                                             'addrs',
                                                             'ca-cert'],
                                                'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModifyOfferAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'offer-url': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'action',
                                                        'access',
                                                        'offer-url'],
                                           'type': 'object'},
                     'ModifyOfferAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyOfferAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'OfferConnection': {'additionalProperties': False,
                                         'properties': {'endpoint': {'type': 'string'},
                                                        'ingress-subnets': {'items': {'type': 'string'},
                                                                            'type': 'array'},
                                                        'relation-id': {'type': 'integer'},
                                                        'source-model-tag': {'type': 'string'},
                                                        'status': {'$ref': '#/definitions/EntityStatus'},
                                                        'username': {'type': 'string'}},
                                         'required': ['source-model-tag',
                                                      'relation-id',
                                                      'username',
                                                      'endpoint',
                                                      'status',
                                                      'ingress-subnets'],
                                         'type': 'object'},
                     'OfferFilter': {'additionalProperties': False,
                                     'properties': {'allowed-users': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                    'application-description': {'type': 'string'},
                                                    'application-name': {'type': 'string'},
                                                    'application-user': {'type': 'string'},
                                                    'connected-users': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                    'endpoints': {'items': {'$ref': '#/definitions/EndpointFilterAttributes'},
                                                                  'type': 'array'},
                                                    'model-name': {'type': 'string'},
                                                    'offer-name': {'type': 'string'},
                                                    'owner-name': {'type': 'string'}},
                                     'required': ['owner-name',
                                                  'model-name',
                                                  'offer-name',
                                                  'application-name',
                                                  'application-description',
                                                  'application-user',
                                                  'endpoints',
                                                  'connected-users',
                                                  'allowed-users'],
                                     'type': 'object'},
                     'OfferFilters': {'additionalProperties': False,
                                      'properties': {'Filters': {'items': {'$ref': '#/definitions/OfferFilter'},
                                                                 'type': 'array'}},
                                      'required': ['Filters'],
                                      'type': 'object'},
                     'OfferURLs': {'additionalProperties': False,
                                   'properties': {'bakery-version': {'type': 'integer'},
                                                  'offer-urls': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                   'type': 'object'},
                     'OfferUserDetails': {'additionalProperties': False,
                                          'properties': {'access': {'type': 'string'},
                                                         'display-name': {'type': 'string'},
                                                         'user': {'type': 'string'}},
                                          'required': ['user',
                                                       'display-name',
                                                       'access'],
                                          'type': 'object'},
                     'QueryApplicationOffersResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationOfferAdminDetails'},
                                                                                  'type': 'array'}},
                                                       'required': ['results'],
                                                       'type': 'object'},
                     'RemoteApplicationInfo': {'additionalProperties': False,
                                               'properties': {'description': {'type': 'string'},
                                                              'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                            'type': 'array'},
                                                              'icon-url-path': {'type': 'string'},
                                                              'model-tag': {'type': 'string'},
                                                              'name': {'type': 'string'},
                                                              'offer-url': {'type': 'string'},
                                                              'source-model-label': {'type': 'string'}},
                                               'required': ['model-tag',
                                                            'name',
                                                            'description',
                                                            'offer-url',
                                                            'endpoints',
                                                            'icon-url-path'],
                                               'type': 'object'},
                     'RemoteApplicationInfoResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'result': {'$ref': '#/definitions/RemoteApplicationInfo'}},
                                                     'type': 'object'},
                     'RemoteApplicationInfoResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/RemoteApplicationInfoResult'},
                                                                                 'type': 'array'}},
                                                      'required': ['results'],
                                                      'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'RemoteSpace': {'additionalProperties': False,
                                     'properties': {'cloud-type': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'provider-attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                         'type': 'object'}},
                                                                            'type': 'object'},
                                                    'provider-id': {'type': 'string'},
                                                    'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                'type': 'array'}},
                                     'required': ['cloud-type',
                                                  'name',
                                                  'provider-id',
                                                  'provider-attributes',
                                                  'subnets'],
                                     'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'}},
     'properties': {'ApplicationOffers': {'description': 'ApplicationOffers gets '
                                                         'details about remote '
                                                         'applications that match '
                                                         'given URLs.',
                                          'properties': {'Params': {'$ref': '#/definitions/OfferURLs'},
                                                         'Result': {'$ref': '#/definitions/ApplicationOffersResults'}},
                                          'type': 'object'},
                    'DestroyOffers': {'description': 'DestroyOffers removes the '
                                                     'offers specified by the '
                                                     'given URLs, forcing if '
                                                     'necessary.',
                                      'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationOffers'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'FindApplicationOffers': {'description': 'FindApplicationOffers '
                                                             'gets details about '
                                                             'remote applications '
                                                             'that match given '
                                                             'filter.',
                                              'properties': {'Params': {'$ref': '#/definitions/OfferFilters'},
                                                             'Result': {'$ref': '#/definitions/QueryApplicationOffersResults'}},
                                              'type': 'object'},
                    'GetConsumeDetails': {'description': 'GetConsumeDetails '
                                                         'returns the details '
                                                         'necessary to pass to '
                                                         'another model to\n'
                                                         'consume the specified '
                                                         'offers represented by '
                                                         'the urls.',
                                          'properties': {'Params': {'$ref': '#/definitions/OfferURLs'},
                                                         'Result': {'$ref': '#/definitions/ConsumeOfferDetailsResults'}},
                                          'type': 'object'},
                    'ListApplicationOffers': {'description': 'ListApplicationOffers '
                                                             'gets deployed '
                                                             'details about '
                                                             'application offers '
                                                             'that match given '
                                                             'filter.\n'
                                                             'The results contain '
                                                             'details about the '
                                                             'deployed '
                                                             'applications such as '
                                                             'connection count.',
                                              'properties': {'Params': {'$ref': '#/definitions/OfferFilters'},
                                                             'Result': {'$ref': '#/definitions/QueryApplicationOffersResults'}},
                                              'type': 'object'},
                    'ModifyOfferAccess': {'description': 'ModifyOfferAccess '
                                                         'changes the application '
                                                         'offer access granted to '
                                                         'users.',
                                          'properties': {'Params': {'$ref': '#/definitions/ModifyOfferAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'Offer': {'description': 'Offer makes application endpoints '
                                             'available for consumption at a '
                                             'specified URL.',
                              'properties': {'Params': {'$ref': '#/definitions/AddApplicationOffers'},
                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                              'type': 'object'},
                    'RemoteApplicationInfo': {'description': 'RemoteApplicationInfo '
                                                             'returns information '
                                                             'about the requested '
                                                             'remote application.\n'
                                                             'This call currently '
                                                             'has no client side '
                                                             'API, only there for '
                                                             'the GUI at this '
                                                             'stage.',
                                              'properties': {'Params': {'$ref': '#/definitions/OfferURLs'},
                                                             'Result': {'$ref': '#/definitions/RemoteApplicationInfoResults'}},
                                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ApplicationOffersResults)
    async def ApplicationOffers(self, bakery_version=None, offer_urls=None):
        '''
        ApplicationOffers gets details about remote applications that match given URLs.

        bakery_version : int
        offer_urls : typing.Sequence[str]
        Returns -> ApplicationOffersResults
        '''
        if bakery_version is not None and not isinstance(bakery_version, int):
            raise Exception("Expected bakery_version to be a int, received: {}".format(type(bakery_version)))

        if offer_urls is not None and not isinstance(offer_urls, (bytes, str, list)):
            raise Exception("Expected offer_urls to be a Sequence, received: {}".format(type(offer_urls)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='ApplicationOffers',
                   version=2,
                   params=_params)
        _params['bakery-version'] = bakery_version
        _params['offer-urls'] = offer_urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyOffers(self, force=None, offer_urls=None):
        '''
        DestroyOffers removes the offers specified by the given URLs, forcing if necessary.

        force : bool
        offer_urls : typing.Sequence[str]
        Returns -> ErrorResults
        '''
        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if offer_urls is not None and not isinstance(offer_urls, (bytes, str, list)):
            raise Exception("Expected offer_urls to be a Sequence, received: {}".format(type(offer_urls)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='DestroyOffers',
                   version=2,
                   params=_params)
        _params['force'] = force
        _params['offer-urls'] = offer_urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(QueryApplicationOffersResults)
    async def FindApplicationOffers(self, filters=None):
        '''
        FindApplicationOffers gets details about remote applications that match given filter.

        filters : typing.Sequence[~OfferFilter]
        Returns -> QueryApplicationOffersResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='FindApplicationOffers',
                   version=2,
                   params=_params)
        _params['Filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConsumeOfferDetailsResults)
    async def GetConsumeDetails(self, bakery_version=None, offer_urls=None):
        '''
        GetConsumeDetails returns the details necessary to pass to another model to
        consume the specified offers represented by the urls.

        bakery_version : int
        offer_urls : typing.Sequence[str]
        Returns -> ConsumeOfferDetailsResults
        '''
        if bakery_version is not None and not isinstance(bakery_version, int):
            raise Exception("Expected bakery_version to be a int, received: {}".format(type(bakery_version)))

        if offer_urls is not None and not isinstance(offer_urls, (bytes, str, list)):
            raise Exception("Expected offer_urls to be a Sequence, received: {}".format(type(offer_urls)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='GetConsumeDetails',
                   version=2,
                   params=_params)
        _params['bakery-version'] = bakery_version
        _params['offer-urls'] = offer_urls
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(QueryApplicationOffersResults)
    async def ListApplicationOffers(self, filters=None):
        '''
        ListApplicationOffers gets deployed details about application offers that match given filter.
        The results contain details about the deployed applications such as connection count.

        filters : typing.Sequence[~OfferFilter]
        Returns -> QueryApplicationOffersResults
        '''
        if filters is not None and not isinstance(filters, (bytes, str, list)):
            raise Exception("Expected filters to be a Sequence, received: {}".format(type(filters)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='ListApplicationOffers',
                   version=2,
                   params=_params)
        _params['Filters'] = filters
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyOfferAccess(self, changes=None):
        '''
        ModifyOfferAccess changes the application offer access granted to users.

        changes : typing.Sequence[~ModifyOfferAccess]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='ModifyOfferAccess',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Offer(self, offers=None):
        '''
        Offer makes application endpoints available for consumption at a specified URL.

        offers : typing.Sequence[~AddApplicationOffer]
        Returns -> ErrorResults
        '''
        if offers is not None and not isinstance(offers, (bytes, str, list)):
            raise Exception("Expected offers to be a Sequence, received: {}".format(type(offers)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='Offer',
                   version=2,
                   params=_params)
        _params['Offers'] = offers
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteApplicationInfoResults)
    async def RemoteApplicationInfo(self, bakery_version=None, offer_urls=None):
        '''
        RemoteApplicationInfo returns information about the requested remote application.
        This call currently has no client side API, only there for the GUI at this stage.

        bakery_version : int
        offer_urls : typing.Sequence[str]
        Returns -> RemoteApplicationInfoResults
        '''
        if bakery_version is not None and not isinstance(bakery_version, int):
            raise Exception("Expected bakery_version to be a int, received: {}".format(type(bakery_version)))

        if offer_urls is not None and not isinstance(offer_urls, (bytes, str, list)):
            raise Exception("Expected offer_urls to be a Sequence, received: {}".format(type(offer_urls)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationOffers',
                   request='RemoteApplicationInfo',
                   version=2,
                   params=_params)
        _params['bakery-version'] = bakery_version
        _params['offer-urls'] = offer_urls
        reply = await self.rpc(msg)
        return reply



class BackupsFacade(Type):
    name = 'Backups'
    version = 2
    schema =     {'definitions': {'BackupsCreateArgs': {'additionalProperties': False,
                                           'properties': {'keep-copy': {'type': 'boolean'},
                                                          'no-download': {'type': 'boolean'},
                                                          'notes': {'type': 'string'}},
                                           'required': ['notes',
                                                        'keep-copy',
                                                        'no-download'],
                                           'type': 'object'},
                     'BackupsInfoArgs': {'additionalProperties': False,
                                         'properties': {'id': {'type': 'string'}},
                                         'required': ['id'],
                                         'type': 'object'},
                     'BackupsListArgs': {'additionalProperties': False,
                                         'type': 'object'},
                     'BackupsListResult': {'additionalProperties': False,
                                           'properties': {'list': {'items': {'$ref': '#/definitions/BackupsMetadataResult'},
                                                                   'type': 'array'}},
                                           'required': ['list'],
                                           'type': 'object'},
                     'BackupsMetadataResult': {'additionalProperties': False,
                                               'properties': {'ca-cert': {'type': 'string'},
                                                              'ca-private-key': {'type': 'string'},
                                                              'checksum': {'type': 'string'},
                                                              'checksum-format': {'type': 'string'},
                                                              'controller-machine-id': {'type': 'string'},
                                                              'controller-machine-inst-id': {'type': 'string'},
                                                              'controller-uuid': {'type': 'string'},
                                                              'filename': {'type': 'string'},
                                                              'finished': {'format': 'date-time',
                                                                           'type': 'string'},
                                                              'format-version': {'type': 'integer'},
                                                              'ha-nodes': {'type': 'integer'},
                                                              'hostname': {'type': 'string'},
                                                              'id': {'type': 'string'},
                                                              'machine': {'type': 'string'},
                                                              'model': {'type': 'string'},
                                                              'notes': {'type': 'string'},
                                                              'series': {'type': 'string'},
                                                              'size': {'type': 'integer'},
                                                              'started': {'format': 'date-time',
                                                                          'type': 'string'},
                                                              'stored': {'format': 'date-time',
                                                                         'type': 'string'},
                                                              'version': {'$ref': '#/definitions/Number'}},
                                               'required': ['id',
                                                            'checksum',
                                                            'checksum-format',
                                                            'size',
                                                            'stored',
                                                            'started',
                                                            'finished',
                                                            'notes',
                                                            'model',
                                                            'machine',
                                                            'hostname',
                                                            'version',
                                                            'series',
                                                            'ca-cert',
                                                            'ca-private-key',
                                                            'filename',
                                                            'format-version',
                                                            'controller-uuid',
                                                            'controller-machine-id',
                                                            'controller-machine-inst-id',
                                                            'ha-nodes'],
                                               'type': 'object'},
                     'BackupsRemoveArgs': {'additionalProperties': False,
                                           'properties': {'ids': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                           'required': ['ids'],
                                           'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RestoreArgs': {'additionalProperties': False,
                                     'properties': {'backup-id': {'type': 'string'}},
                                     'required': ['backup-id'],
                                     'type': 'object'}},
     'properties': {'Create': {'properties': {'Params': {'$ref': '#/definitions/BackupsCreateArgs'},
                                              'Result': {'$ref': '#/definitions/BackupsMetadataResult'}},
                               'type': 'object'},
                    'FinishRestore': {'description': 'FinishRestore implements the '
                                                     'server side of '
                                                     'Backups.FinishRestore.',
                                      'type': 'object'},
                    'Info': {'description': 'Info provides the implementation of '
                                            'the API method.',
                             'properties': {'Params': {'$ref': '#/definitions/BackupsInfoArgs'},
                                            'Result': {'$ref': '#/definitions/BackupsMetadataResult'}},
                             'type': 'object'},
                    'List': {'description': 'List provides the implementation of '
                                            'the API method.',
                             'properties': {'Params': {'$ref': '#/definitions/BackupsListArgs'},
                                            'Result': {'$ref': '#/definitions/BackupsListResult'}},
                             'type': 'object'},
                    'PrepareRestore': {'description': 'PrepareRestore implements '
                                                      'the server side of '
                                                      'Backups.PrepareRestore.',
                                       'type': 'object'},
                    'Remove': {'description': 'Remove deletes the backups defined '
                                              'by ID from the database.',
                               'properties': {'Params': {'$ref': '#/definitions/BackupsRemoveArgs'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Restore': {'description': 'Restore implements the server side '
                                               'of Backups.Restore.',
                                'properties': {'Params': {'$ref': '#/definitions/RestoreArgs'}},
                                'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BackupsMetadataResult)
    async def Create(self, keep_copy=None, no_download=None, notes=None):
        '''
        keep_copy : bool
        no_download : bool
        notes : str
        Returns -> BackupsMetadataResult
        '''
        if keep_copy is not None and not isinstance(keep_copy, bool):
            raise Exception("Expected keep_copy to be a bool, received: {}".format(type(keep_copy)))

        if no_download is not None and not isinstance(no_download, bool):
            raise Exception("Expected no_download to be a bool, received: {}".format(type(no_download)))

        if notes is not None and not isinstance(notes, (bytes, str)):
            raise Exception("Expected notes to be a str, received: {}".format(type(notes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Create',
                   version=2,
                   params=_params)
        _params['keep-copy'] = keep_copy
        _params['no-download'] = no_download
        _params['notes'] = notes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def FinishRestore(self):
        '''
        FinishRestore implements the server side of Backups.FinishRestore.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='FinishRestore',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BackupsMetadataResult)
    async def Info(self, id_=None):
        '''
        Info provides the implementation of the API method.

        id_ : str
        Returns -> BackupsMetadataResult
        '''
        if id_ is not None and not isinstance(id_, (bytes, str)):
            raise Exception("Expected id_ to be a str, received: {}".format(type(id_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Info',
                   version=2,
                   params=_params)
        _params['id'] = id_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BackupsListResult)
    async def List(self):
        '''
        List provides the implementation of the API method.


        Returns -> BackupsListResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='List',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def PrepareRestore(self):
        '''
        PrepareRestore implements the server side of Backups.PrepareRestore.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='PrepareRestore',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, ids=None):
        '''
        Remove deletes the backups defined by ID from the database.

        ids : typing.Sequence[str]
        Returns -> ErrorResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Remove',
                   version=2,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Restore(self, backup_id=None):
        '''
        Restore implements the server side of Backups.Restore.

        backup_id : str
        Returns -> None
        '''
        if backup_id is not None and not isinstance(backup_id, (bytes, str)):
            raise Exception("Expected backup_id to be a str, received: {}".format(type(backup_id)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Restore',
                   version=2,
                   params=_params)
        _params['backup-id'] = backup_id
        reply = await self.rpc(msg)
        return reply



class BlockFacade(Type):
    name = 'Block'
    version = 2
    schema =     {'definitions': {'Block': {'additionalProperties': False,
                               'properties': {'id': {'type': 'string'},
                                              'message': {'type': 'string'},
                                              'tag': {'type': 'string'},
                                              'type': {'type': 'string'}},
                               'required': ['id', 'tag', 'type'],
                               'type': 'object'},
                     'BlockResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'result': {'$ref': '#/definitions/Block'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'BlockResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/BlockResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'BlockSwitchParams': {'additionalProperties': False,
                                           'properties': {'message': {'type': 'string'},
                                                          'type': {'type': 'string'}},
                                           'required': ['type'],
                                           'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'}},
     'properties': {'List': {'description': 'List implements Block.List().',
                             'properties': {'Result': {'$ref': '#/definitions/BlockResults'}},
                             'type': 'object'},
                    'SwitchBlockOff': {'description': 'SwitchBlockOff implements '
                                                      'Block.SwitchBlockOff().',
                                       'properties': {'Params': {'$ref': '#/definitions/BlockSwitchParams'},
                                                      'Result': {'$ref': '#/definitions/ErrorResult'}},
                                       'type': 'object'},
                    'SwitchBlockOn': {'description': 'SwitchBlockOn implements '
                                                     'Block.SwitchBlockOn().',
                                      'properties': {'Params': {'$ref': '#/definitions/BlockSwitchParams'},
                                                     'Result': {'$ref': '#/definitions/ErrorResult'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BlockResults)
    async def List(self):
        '''
        List implements Block.List().


        Returns -> BlockResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Block',
                   request='List',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def SwitchBlockOff(self, message=None, type_=None):
        '''
        SwitchBlockOff implements Block.SwitchBlockOff().

        message : str
        type_ : str
        Returns -> ErrorResult
        '''
        if message is not None and not isinstance(message, (bytes, str)):
            raise Exception("Expected message to be a str, received: {}".format(type(message)))

        if type_ is not None and not isinstance(type_, (bytes, str)):
            raise Exception("Expected type_ to be a str, received: {}".format(type(type_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Block',
                   request='SwitchBlockOff',
                   version=2,
                   params=_params)
        _params['message'] = message
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def SwitchBlockOn(self, message=None, type_=None):
        '''
        SwitchBlockOn implements Block.SwitchBlockOn().

        message : str
        type_ : str
        Returns -> ErrorResult
        '''
        if message is not None and not isinstance(message, (bytes, str)):
            raise Exception("Expected message to be a str, received: {}".format(type(message)))

        if type_ is not None and not isinstance(type_, (bytes, str)):
            raise Exception("Expected type_ to be a str, received: {}".format(type(type_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Block',
                   request='SwitchBlockOn',
                   version=2,
                   params=_params)
        _params['message'] = message
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



class BundleFacade(Type):
    name = 'Bundle'
    version = 2
    schema =     {'definitions': {'BundleChange': {'additionalProperties': False,
                                      'properties': {'args': {'items': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                              'type': 'array'},
                                                     'id': {'type': 'string'},
                                                     'method': {'type': 'string'},
                                                     'requires': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['id',
                                                   'method',
                                                   'args',
                                                   'requires'],
                                      'type': 'object'},
                     'BundleChangesParams': {'additionalProperties': False,
                                             'properties': {'bundleURL': {'type': 'string'},
                                                            'yaml': {'type': 'string'}},
                                             'required': ['yaml', 'bundleURL'],
                                             'type': 'object'},
                     'BundleChangesResults': {'additionalProperties': False,
                                              'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChange'},
                                                                         'type': 'array'},
                                                             'errors': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                              'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'}},
     'properties': {'ExportBundle': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'GetChanges': {'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                  'Result': {'$ref': '#/definitions/BundleChangesResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringResult)
    async def ExportBundle(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Bundle',
                   request='ExportBundle',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BundleChangesResults)
    async def GetChanges(self, bundleurl=None, yaml=None):
        '''
        bundleurl : str
        yaml : str
        Returns -> BundleChangesResults
        '''
        if bundleurl is not None and not isinstance(bundleurl, (bytes, str)):
            raise Exception("Expected bundleurl to be a str, received: {}".format(type(bundleurl)))

        if yaml is not None and not isinstance(yaml, (bytes, str)):
            raise Exception("Expected yaml to be a str, received: {}".format(type(yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Bundle',
                   request='GetChanges',
                   version=2,
                   params=_params)
        _params['bundleURL'] = bundleurl
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



class CharmRevisionUpdaterFacade(Type):
    name = 'CharmRevisionUpdater'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'}},
     'properties': {'UpdateLatestRevisions': {'description': 'UpdateLatestRevisions '
                                                             'retrieves the latest '
                                                             'revision information '
                                                             'from the charm store '
                                                             'for all deployed '
                                                             'charms\n'
                                                             'and records this '
                                                             'information in '
                                                             'state.',
                                              'properties': {'Result': {'$ref': '#/definitions/ErrorResult'}},
                                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def UpdateLatestRevisions(self):
        '''
        UpdateLatestRevisions retrieves the latest revision information from the charm store for all deployed charms
        and records this information in state.


        Returns -> ErrorResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CharmRevisionUpdater',
                   request='UpdateLatestRevisions',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CharmsFacade(Type):
    name = 'Charms'
    version = 2
    schema =     {'definitions': {'Charm': {'additionalProperties': False,
                               'properties': {'actions': {'$ref': '#/definitions/CharmActions'},
                                              'config': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmOption'}},
                                                         'type': 'object'},
                                              'lxd-profile': {'$ref': '#/definitions/CharmLXDProfile'},
                                              'meta': {'$ref': '#/definitions/CharmMeta'},
                                              'metrics': {'$ref': '#/definitions/CharmMetrics'},
                                              'revision': {'type': 'integer'},
                                              'url': {'type': 'string'}},
                               'required': ['revision', 'url', 'config'],
                               'type': 'object'},
                     'CharmActionSpec': {'additionalProperties': False,
                                         'properties': {'description': {'type': 'string'},
                                                        'params': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                'type': 'object'}},
                                                                   'type': 'object'}},
                                         'required': ['description', 'params'],
                                         'type': 'object'},
                     'CharmActions': {'additionalProperties': False,
                                      'properties': {'specs': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmActionSpec'}},
                                                               'type': 'object'}},
                                      'type': 'object'},
                     'CharmDevice': {'additionalProperties': False,
                                     'properties': {'CountMax': {'type': 'integer'},
                                                    'CountMin': {'type': 'integer'},
                                                    'Description': {'type': 'string'},
                                                    'Name': {'type': 'string'},
                                                    'Type': {'type': 'string'}},
                                     'required': ['Name',
                                                  'Description',
                                                  'Type',
                                                  'CountMin',
                                                  'CountMax'],
                                     'type': 'object'},
                     'CharmLXDProfile': {'additionalProperties': False,
                                         'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'},
                                                        'description': {'type': 'string'},
                                                        'devices': {'patternProperties': {'.*': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'}},
                                         'required': ['config',
                                                      'description',
                                                      'devices'],
                                         'type': 'object'},
                     'CharmMeta': {'additionalProperties': False,
                                   'properties': {'categories': {'items': {'type': 'string'},
                                                                 'type': 'array'},
                                                  'description': {'type': 'string'},
                                                  'devices': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmDevice'}},
                                                              'type': 'object'},
                                                  'extra-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                  'min-juju-version': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'payload-classes': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmPayloadClass'}},
                                                                      'type': 'object'},
                                                  'peers': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                            'type': 'object'},
                                                  'provides': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                               'type': 'object'},
                                                  'requires': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                               'type': 'object'},
                                                  'resources': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmResourceMeta'}},
                                                                'type': 'object'},
                                                  'series': {'items': {'type': 'string'},
                                                             'type': 'array'},
                                                  'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmStorage'}},
                                                              'type': 'object'},
                                                  'subordinate': {'type': 'boolean'},
                                                  'summary': {'type': 'string'},
                                                  'tags': {'items': {'type': 'string'},
                                                           'type': 'array'},
                                                  'terms': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                   'required': ['name',
                                                'summary',
                                                'description',
                                                'subordinate'],
                                   'type': 'object'},
                     'CharmMetric': {'additionalProperties': False,
                                     'properties': {'description': {'type': 'string'},
                                                    'type': {'type': 'string'}},
                                     'required': ['type', 'description'],
                                     'type': 'object'},
                     'CharmMetrics': {'additionalProperties': False,
                                      'properties': {'metrics': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmMetric'}},
                                                                 'type': 'object'},
                                                     'plan': {'$ref': '#/definitions/CharmPlan'}},
                                      'required': ['metrics', 'plan'],
                                      'type': 'object'},
                     'CharmOption': {'additionalProperties': False,
                                     'properties': {'default': {'additionalProperties': True,
                                                                'type': 'object'},
                                                    'description': {'type': 'string'},
                                                    'type': {'type': 'string'}},
                                     'required': ['type'],
                                     'type': 'object'},
                     'CharmPayloadClass': {'additionalProperties': False,
                                           'properties': {'name': {'type': 'string'},
                                                          'type': {'type': 'string'}},
                                           'required': ['name', 'type'],
                                           'type': 'object'},
                     'CharmPlan': {'additionalProperties': False,
                                   'properties': {'required': {'type': 'boolean'}},
                                   'required': ['required'],
                                   'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'CharmResourceMeta': {'additionalProperties': False,
                                           'properties': {'description': {'type': 'string'},
                                                          'name': {'type': 'string'},
                                                          'path': {'type': 'string'},
                                                          'type': {'type': 'string'}},
                                           'required': ['name',
                                                        'type',
                                                        'path',
                                                        'description'],
                                           'type': 'object'},
                     'CharmStorage': {'additionalProperties': False,
                                      'properties': {'count-max': {'type': 'integer'},
                                                     'count-min': {'type': 'integer'},
                                                     'description': {'type': 'string'},
                                                     'location': {'type': 'string'},
                                                     'minimum-size': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'properties': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                     'read-only': {'type': 'boolean'},
                                                     'shared': {'type': 'boolean'},
                                                     'type': {'type': 'string'}},
                                      'required': ['name',
                                                   'description',
                                                   'type',
                                                   'shared',
                                                   'read-only',
                                                   'count-min',
                                                   'count-max',
                                                   'minimum-size'],
                                      'type': 'object'},
                     'CharmURL': {'additionalProperties': False,
                                  'properties': {'url': {'type': 'string'}},
                                  'required': ['url'],
                                  'type': 'object'},
                     'CharmsList': {'additionalProperties': False,
                                    'properties': {'names': {'items': {'type': 'string'},
                                                             'type': 'array'}},
                                    'required': ['names'],
                                    'type': 'object'},
                     'CharmsListResult': {'additionalProperties': False,
                                          'properties': {'charm-urls': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                          'required': ['charm-urls'],
                                          'type': 'object'},
                     'IsMeteredResult': {'additionalProperties': False,
                                         'properties': {'metered': {'type': 'boolean'}},
                                         'required': ['metered'],
                                         'type': 'object'}},
     'properties': {'CharmInfo': {'description': 'CharmInfo returns information '
                                                 'about the requested charm.\n'
                                                 'NOTE: thumper 2016-06-29, this '
                                                 'is not a bulk call and probably '
                                                 'should be.',
                                  'properties': {'Params': {'$ref': '#/definitions/CharmURL'},
                                                 'Result': {'$ref': '#/definitions/Charm'}},
                                  'type': 'object'},
                    'IsMetered': {'description': 'IsMetered returns whether or not '
                                                 'the charm is metered.',
                                  'properties': {'Params': {'$ref': '#/definitions/CharmURL'},
                                                 'Result': {'$ref': '#/definitions/IsMeteredResult'}},
                                  'type': 'object'},
                    'List': {'description': 'List returns a list of charm URLs '
                                            'currently in the state.\n'
                                            'If supplied parameter contains any '
                                            'names, the result will be filtered\n'
                                            'to return only the charms with '
                                            'supplied names.',
                             'properties': {'Params': {'$ref': '#/definitions/CharmsList'},
                                            'Result': {'$ref': '#/definitions/CharmsListResult'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(Charm)
    async def CharmInfo(self, url=None):
        '''
        CharmInfo returns information about the requested charm.
        NOTE: thumper 2016-06-29, this is not a bulk call and probably should be.

        url : str
        Returns -> Charm
        '''
        if url is not None and not isinstance(url, (bytes, str)):
            raise Exception("Expected url to be a str, received: {}".format(type(url)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Charms',
                   request='CharmInfo',
                   version=2,
                   params=_params)
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IsMeteredResult)
    async def IsMetered(self, url=None):
        '''
        IsMetered returns whether or not the charm is metered.

        url : str
        Returns -> IsMeteredResult
        '''
        if url is not None and not isinstance(url, (bytes, str)):
            raise Exception("Expected url to be a str, received: {}".format(type(url)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Charms',
                   request='IsMetered',
                   version=2,
                   params=_params)
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CharmsListResult)
    async def List(self, names=None):
        '''
        List returns a list of charm URLs currently in the state.
        If supplied parameter contains any names, the result will be filtered
        to return only the charms with supplied names.

        names : typing.Sequence[str]
        Returns -> CharmsListResult
        '''
        if names is not None and not isinstance(names, (bytes, str, list)):
            raise Exception("Expected names to be a Sequence, received: {}".format(type(names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Charms',
                   request='List',
                   version=2,
                   params=_params)
        _params['names'] = names
        reply = await self.rpc(msg)
        return reply



class CleanerFacade(Type):
    name = 'Cleaner'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'}},
     'properties': {'Cleanup': {'description': 'Cleanup triggers a state cleanup',
                                'type': 'object'},
                    'WatchCleanups': {'description': 'WatchChanges watches for '
                                                     'cleanups to be perfomed in '
                                                     'state',
                                      'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Cleanup(self):
        '''
        Cleanup triggers a state cleanup


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cleaner',
                   request='Cleanup',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchCleanups(self):
        '''
        WatchChanges watches for cleanups to be perfomed in state


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cleaner',
                   request='WatchCleanups',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ClientFacade(Type):
    name = 'Client'
    version = 2
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'AddCharm': {'additionalProperties': False,
                                  'properties': {'channel': {'type': 'string'},
                                                 'force': {'type': 'boolean'},
                                                 'url': {'type': 'string'}},
                                  'required': ['url', 'channel', 'force'],
                                  'type': 'object'},
                     'AddCharmWithAuthorization': {'additionalProperties': False,
                                                   'properties': {'channel': {'type': 'string'},
                                                                  'force': {'type': 'boolean'},
                                                                  'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                                  'url': {'type': 'string'}},
                                                   'required': ['url',
                                                                'channel',
                                                                'macaroon',
                                                                'force'],
                                                   'type': 'object'},
                     'AddMachineParams': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'container-type': {'type': 'string'},
                                                         'disks': {'items': {'$ref': '#/definitions/Constraints'},
                                                                   'type': 'array'},
                                                         'hardware-characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                         'instance-id': {'type': 'string'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'nonce': {'type': 'string'},
                                                         'parent-id': {'type': 'string'},
                                                         'placement': {'$ref': '#/definitions/Placement'},
                                                         'series': {'type': 'string'}},
                                          'required': ['series',
                                                       'constraints',
                                                       'jobs',
                                                       'parent-id',
                                                       'container-type',
                                                       'instance-id',
                                                       'nonce',
                                                       'hardware-characteristics',
                                                       'addresses'],
                                          'type': 'object'},
                     'AddMachines': {'additionalProperties': False,
                                     'properties': {'params': {'items': {'$ref': '#/definitions/AddMachineParams'},
                                                               'type': 'array'}},
                                     'required': ['params'],
                                     'type': 'object'},
                     'AddMachinesResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'machine': {'type': 'string'}},
                                           'required': ['machine'],
                                           'type': 'object'},
                     'AddMachinesResults': {'additionalProperties': False,
                                            'properties': {'machines': {'items': {'$ref': '#/definitions/AddMachinesResult'},
                                                                        'type': 'array'}},
                                            'required': ['machines'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'AgentVersionResult': {'additionalProperties': False,
                                            'properties': {'version': {'$ref': '#/definitions/Number'}},
                                            'required': ['version'],
                                            'type': 'object'},
                     'AllWatcherId': {'additionalProperties': False,
                                      'properties': {'watcher-id': {'type': 'string'}},
                                      'required': ['watcher-id'],
                                      'type': 'object'},
                     'ApplicationOfferStatus': {'additionalProperties': False,
                                                'properties': {'active-connected-count': {'type': 'integer'},
                                                               'application-name': {'type': 'string'},
                                                               'charm': {'type': 'string'},
                                                               'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteEndpoint'}},
                                                                             'type': 'object'},
                                                               'err': {'$ref': '#/definitions/Error'},
                                                               'offer-name': {'type': 'string'},
                                                               'total-connected-count': {'type': 'integer'}},
                                                'required': ['offer-name',
                                                             'application-name',
                                                             'charm',
                                                             'endpoints',
                                                             'active-connected-count',
                                                             'total-connected-count'],
                                                'type': 'object'},
                     'ApplicationStatus': {'additionalProperties': False,
                                           'properties': {'can-upgrade-to': {'type': 'string'},
                                                          'charm': {'type': 'string'},
                                                          'charm-profile': {'type': 'string'},
                                                          'charm-version': {'type': 'string'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'err': {'$ref': '#/definitions/Error'},
                                                          'exposed': {'type': 'boolean'},
                                                          'int': {'type': 'integer'},
                                                          'life': {'type': 'string'},
                                                          'meter-statuses': {'patternProperties': {'.*': {'$ref': '#/definitions/MeterStatus'}},
                                                                             'type': 'object'},
                                                          'provider-id': {'type': 'string'},
                                                          'public-address': {'type': 'string'},
                                                          'relations': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                     'type': 'array'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'status': {'$ref': '#/definitions/DetailedStatus'},
                                                          'subordinate-to': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                          'units': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitStatus'}},
                                                                    'type': 'object'},
                                                          'workload-version': {'type': 'string'}},
                                           'required': ['charm',
                                                        'series',
                                                        'exposed',
                                                        'life',
                                                        'relations',
                                                        'can-upgrade-to',
                                                        'subordinate-to',
                                                        'units',
                                                        'meter-statuses',
                                                        'status',
                                                        'workload-version',
                                                        'charm-version',
                                                        'charm-profile',
                                                        'endpoint-bindings',
                                                        'public-address'],
                                           'type': 'object'},
                     'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Patch': {'type': 'integer'},
                                               'Series': {'type': 'string'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build',
                                             'Number',
                                             'Series',
                                             'Arch'],
                                'type': 'object'},
                     'BranchStatus': {'additionalProperties': False,
                                      'properties': {'assigned-units': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                     'type': 'array'}},
                                                                        'type': 'object'},
                                                     'created': {'type': 'integer'},
                                                     'created-by': {'type': 'string'}},
                                      'required': ['assigned-units',
                                                   'created',
                                                   'created-by'],
                                      'type': 'object'},
                     'BundleChange': {'additionalProperties': False,
                                      'properties': {'args': {'items': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                              'type': 'array'},
                                                     'id': {'type': 'string'},
                                                     'method': {'type': 'string'},
                                                     'requires': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['id',
                                                   'method',
                                                   'args',
                                                   'requires'],
                                      'type': 'object'},
                     'BundleChangesParams': {'additionalProperties': False,
                                             'properties': {'bundleURL': {'type': 'string'},
                                                            'yaml': {'type': 'string'}},
                                             'required': ['yaml', 'bundleURL'],
                                             'type': 'object'},
                     'BundleChangesResults': {'additionalProperties': False,
                                              'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChange'},
                                                                         'type': 'array'},
                                                             'errors': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                              'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyMachines': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'machine-names': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                         'required': ['machine-names', 'force'],
                                         'type': 'object'},
                     'DetailedStatus': {'additionalProperties': False,
                                        'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                       'err': {'$ref': '#/definitions/Error'},
                                                       'info': {'type': 'string'},
                                                       'kind': {'type': 'string'},
                                                       'life': {'type': 'string'},
                                                       'since': {'format': 'date-time',
                                                                 'type': 'string'},
                                                       'status': {'type': 'string'},
                                                       'version': {'type': 'string'}},
                                        'required': ['status',
                                                     'info',
                                                     'data',
                                                     'since',
                                                     'kind',
                                                     'version',
                                                     'life'],
                                        'type': 'object'},
                     'EndpointStatus': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'},
                                                       'subordinate': {'type': 'boolean'}},
                                        'required': ['application',
                                                     'name',
                                                     'role',
                                                     'subordinate'],
                                        'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FindToolsParams': {'additionalProperties': False,
                                         'properties': {'agentstream': {'type': 'string'},
                                                        'arch': {'type': 'string'},
                                                        'major': {'type': 'integer'},
                                                        'minor': {'type': 'integer'},
                                                        'number': {'$ref': '#/definitions/Number'},
                                                        'series': {'type': 'string'}},
                                         'required': ['number',
                                                      'major',
                                                      'minor',
                                                      'arch',
                                                      'series',
                                                      'agentstream'],
                                         'type': 'object'},
                     'FindToolsResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'list': {'items': {'$ref': '#/definitions/Tools'},
                                                                 'type': 'array'}},
                                         'required': ['list'],
                                         'type': 'object'},
                     'FullStatus': {'additionalProperties': False,
                                    'properties': {'applications': {'patternProperties': {'.*': {'$ref': '#/definitions/ApplicationStatus'}},
                                                                    'type': 'object'},
                                                   'branches': {'patternProperties': {'.*': {'$ref': '#/definitions/BranchStatus'}},
                                                                'type': 'object'},
                                                   'controller-timestamp': {'format': 'date-time',
                                                                            'type': 'string'},
                                                   'machines': {'patternProperties': {'.*': {'$ref': '#/definitions/MachineStatus'}},
                                                                'type': 'object'},
                                                   'model': {'$ref': '#/definitions/ModelStatusInfo'},
                                                   'offers': {'patternProperties': {'.*': {'$ref': '#/definitions/ApplicationOfferStatus'}},
                                                              'type': 'object'},
                                                   'relations': {'items': {'$ref': '#/definitions/RelationStatus'},
                                                                 'type': 'array'},
                                                   'remote-applications': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteApplicationStatus'}},
                                                                           'type': 'object'}},
                                    'required': ['model',
                                                 'machines',
                                                 'applications',
                                                 'remote-applications',
                                                 'offers',
                                                 'relations',
                                                 'controller-timestamp',
                                                 'branches'],
                                    'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'root-disk-source': {'type': 'string'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'History': {'additionalProperties': False,
                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                'statuses': {'items': {'$ref': '#/definitions/DetailedStatus'},
                                                             'type': 'array'}},
                                 'required': ['statuses'],
                                 'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'LXDProfile': {'additionalProperties': False,
                                    'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                              'type': 'object'},
                                                   'description': {'type': 'string'},
                                                   'devices': {'patternProperties': {'.*': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                            'type': 'object'}},
                                                               'type': 'object'}},
                                    'required': ['config',
                                                 'description',
                                                 'devices'],
                                    'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MachineStatus': {'additionalProperties': False,
                                       'properties': {'agent-status': {'$ref': '#/definitions/DetailedStatus'},
                                                      'constraints': {'type': 'string'},
                                                      'containers': {'patternProperties': {'.*': {'$ref': '#/definitions/MachineStatus'}},
                                                                     'type': 'object'},
                                                      'display-name': {'type': 'string'},
                                                      'dns-name': {'type': 'string'},
                                                      'hardware': {'type': 'string'},
                                                      'has-vote': {'type': 'boolean'},
                                                      'id': {'type': 'string'},
                                                      'instance-id': {'type': 'string'},
                                                      'instance-status': {'$ref': '#/definitions/DetailedStatus'},
                                                      'ip-addresses': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                      'jobs': {'items': {'type': 'string'},
                                                               'type': 'array'},
                                                      'lxd-profiles': {'patternProperties': {'.*': {'$ref': '#/definitions/LXDProfile'}},
                                                                       'type': 'object'},
                                                      'modification-status': {'$ref': '#/definitions/DetailedStatus'},
                                                      'network-interfaces': {'patternProperties': {'.*': {'$ref': '#/definitions/NetworkInterface'}},
                                                                             'type': 'object'},
                                                      'primary-controller-machine': {'type': 'boolean'},
                                                      'series': {'type': 'string'},
                                                      'wants-vote': {'type': 'boolean'}},
                                       'required': ['agent-status',
                                                    'instance-status',
                                                    'modification-status',
                                                    'dns-name',
                                                    'instance-id',
                                                    'display-name',
                                                    'series',
                                                    'id',
                                                    'containers',
                                                    'constraints',
                                                    'hardware',
                                                    'jobs',
                                                    'has-vote',
                                                    'wants-vote'],
                                       'type': 'object'},
                     'MeterStatus': {'additionalProperties': False,
                                     'properties': {'color': {'type': 'string'},
                                                    'message': {'type': 'string'}},
                                     'required': ['color', 'message'],
                                     'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-credential-validity': {'type': 'boolean'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'is-controller': {'type': 'boolean'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'type': {'type': 'string'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'type',
                                                'uuid',
                                                'controller-uuid',
                                                'is-controller',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'display-name': {'type': 'string'},
                                                         'ha-primary': {'type': 'boolean'},
                                                         'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'message': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLA': {'additionalProperties': False,
                                  'properties': {'ModelSLAInfo': {'$ref': '#/definitions/ModelSLAInfo'},
                                                 'creds': {'items': {'type': 'integer'},
                                                           'type': 'array'},
                                                 'level': {'type': 'string'},
                                                 'owner': {'type': 'string'}},
                                  'required': ['level',
                                               'owner',
                                               'ModelSLAInfo',
                                               'creds'],
                                  'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelSet': {'additionalProperties': False,
                                  'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                         'type': 'object'}},
                                                            'type': 'object'}},
                                  'required': ['config'],
                                  'type': 'object'},
                     'ModelStatusInfo': {'additionalProperties': False,
                                         'properties': {'available-version': {'type': 'string'},
                                                        'cloud-tag': {'type': 'string'},
                                                        'meter-status': {'$ref': '#/definitions/MeterStatus'},
                                                        'model-status': {'$ref': '#/definitions/DetailedStatus'},
                                                        'name': {'type': 'string'},
                                                        'region': {'type': 'string'},
                                                        'sla': {'type': 'string'},
                                                        'type': {'type': 'string'},
                                                        'version': {'type': 'string'}},
                                         'required': ['name',
                                                      'type',
                                                      'cloud-tag',
                                                      'version',
                                                      'available-version',
                                                      'model-status',
                                                      'meter-status',
                                                      'sla'],
                                         'type': 'object'},
                     'ModelUnset': {'additionalProperties': False,
                                    'properties': {'keys': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['keys'],
                                    'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModelUserInfoResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ModelUserInfo'}},
                                             'type': 'object'},
                     'ModelUserInfoResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ModelUserInfoResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'NetworkInterface': {'additionalProperties': False,
                                          'properties': {'dns-nameservers': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                         'gateway': {'type': 'string'},
                                                         'ip-addresses': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                         'is-up': {'type': 'boolean'},
                                                         'mac-address': {'type': 'string'},
                                                         'space': {'type': 'string'}},
                                          'required': ['ip-addresses',
                                                       'mac-address',
                                                       'is-up'],
                                          'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'PrivateAddress': {'additionalProperties': False,
                                        'properties': {'target': {'type': 'string'}},
                                        'required': ['target'],
                                        'type': 'object'},
                     'PrivateAddressResults': {'additionalProperties': False,
                                               'properties': {'private-address': {'type': 'string'}},
                                               'required': ['private-address'],
                                               'type': 'object'},
                     'ProvisioningScriptParams': {'additionalProperties': False,
                                                  'properties': {'data-dir': {'type': 'string'},
                                                                 'disable-package-commands': {'type': 'boolean'},
                                                                 'machine-id': {'type': 'string'},
                                                                 'nonce': {'type': 'string'}},
                                                  'required': ['machine-id',
                                                               'nonce',
                                                               'data-dir',
                                                               'disable-package-commands'],
                                                  'type': 'object'},
                     'ProvisioningScriptResult': {'additionalProperties': False,
                                                  'properties': {'script': {'type': 'string'}},
                                                  'required': ['script'],
                                                  'type': 'object'},
                     'PublicAddress': {'additionalProperties': False,
                                       'properties': {'target': {'type': 'string'}},
                                       'required': ['target'],
                                       'type': 'object'},
                     'PublicAddressResults': {'additionalProperties': False,
                                              'properties': {'public-address': {'type': 'string'}},
                                              'required': ['public-address'],
                                              'type': 'object'},
                     'RelationStatus': {'additionalProperties': False,
                                        'properties': {'endpoints': {'items': {'$ref': '#/definitions/EndpointStatus'},
                                                                     'type': 'array'},
                                                       'id': {'type': 'integer'},
                                                       'interface': {'type': 'string'},
                                                       'key': {'type': 'string'},
                                                       'scope': {'type': 'string'},
                                                       'status': {'$ref': '#/definitions/DetailedStatus'}},
                                        'required': ['id',
                                                     'key',
                                                     'interface',
                                                     'scope',
                                                     'endpoints',
                                                     'status'],
                                        'type': 'object'},
                     'RemoteApplicationStatus': {'additionalProperties': False,
                                                 'properties': {'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                              'type': 'array'},
                                                                'err': {'$ref': '#/definitions/Error'},
                                                                'life': {'type': 'string'},
                                                                'offer-name': {'type': 'string'},
                                                                'offer-url': {'type': 'string'},
                                                                'relations': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                           'type': 'array'}},
                                                                              'type': 'object'},
                                                                'status': {'$ref': '#/definitions/DetailedStatus'}},
                                                 'required': ['offer-url',
                                                              'offer-name',
                                                              'endpoints',
                                                              'life',
                                                              'relations',
                                                              'status'],
                                                 'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'ResolveCharmResult': {'additionalProperties': False,
                                            'properties': {'error': {'type': 'string'},
                                                           'url': {'type': 'string'}},
                                            'type': 'object'},
                     'ResolveCharmResults': {'additionalProperties': False,
                                             'properties': {'urls': {'items': {'$ref': '#/definitions/ResolveCharmResult'},
                                                                     'type': 'array'}},
                                             'required': ['urls'],
                                             'type': 'object'},
                     'ResolveCharms': {'additionalProperties': False,
                                       'properties': {'references': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                       'required': ['references'],
                                       'type': 'object'},
                     'Resolved': {'additionalProperties': False,
                                  'properties': {'retry': {'type': 'boolean'},
                                                 'unit-name': {'type': 'string'}},
                                  'required': ['unit-name', 'retry'],
                                  'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'SetModelAgentVersion': {'additionalProperties': False,
                                              'properties': {'force': {'type': 'boolean'},
                                                             'version': {'$ref': '#/definitions/Number'}},
                                              'required': ['version'],
                                              'type': 'object'},
                     'StatusHistoryFilter': {'additionalProperties': False,
                                             'properties': {'date': {'format': 'date-time',
                                                                     'type': 'string'},
                                                            'delta': {'type': 'integer'},
                                                            'exclude': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                            'size': {'type': 'integer'}},
                                             'required': ['size',
                                                          'date',
                                                          'delta',
                                                          'exclude'],
                                             'type': 'object'},
                     'StatusHistoryRequest': {'additionalProperties': False,
                                              'properties': {'filter': {'$ref': '#/definitions/StatusHistoryFilter'},
                                                             'historyKind': {'type': 'string'},
                                                             'size': {'type': 'integer'},
                                                             'tag': {'type': 'string'}},
                                              'required': ['historyKind',
                                                           'size',
                                                           'filter',
                                                           'tag'],
                                              'type': 'object'},
                     'StatusHistoryRequests': {'additionalProperties': False,
                                               'properties': {'requests': {'items': {'$ref': '#/definitions/StatusHistoryRequest'},
                                                                           'type': 'array'}},
                                               'required': ['requests'],
                                               'type': 'object'},
                     'StatusHistoryResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'history': {'$ref': '#/definitions/History'}},
                                             'required': ['history'],
                                             'type': 'object'},
                     'StatusHistoryResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/StatusHistoryResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'StatusParams': {'additionalProperties': False,
                                      'properties': {'patterns': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['patterns'],
                                      'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'UnitStatus': {'additionalProperties': False,
                                    'properties': {'address': {'type': 'string'},
                                                   'agent-status': {'$ref': '#/definitions/DetailedStatus'},
                                                   'charm': {'type': 'string'},
                                                   'leader': {'type': 'boolean'},
                                                   'machine': {'type': 'string'},
                                                   'opened-ports': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                   'provider-id': {'type': 'string'},
                                                   'public-address': {'type': 'string'},
                                                   'subordinates': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitStatus'}},
                                                                    'type': 'object'},
                                                   'workload-status': {'$ref': '#/definitions/DetailedStatus'},
                                                   'workload-version': {'type': 'string'}},
                                    'required': ['agent-status',
                                                 'workload-status',
                                                 'workload-version',
                                                 'machine',
                                                 'opened-ports',
                                                 'public-address',
                                                 'charm',
                                                 'subordinates'],
                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'APIHostPorts': {'description': 'APIHostPorts returns the API '
                                                    'host/port addresses stored in '
                                                    'state.',
                                     'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'AbortCurrentUpgrade': {'description': 'AbortCurrentUpgrade '
                                                           'aborts and archives '
                                                           'the current upgrade\n'
                                                           'synchronisation '
                                                           'record, if any.',
                                            'type': 'object'},
                    'AddCharm': {'properties': {'Params': {'$ref': '#/definitions/AddCharm'}},
                                 'type': 'object'},
                    'AddCharmWithAuthorization': {'description': 'AddCharmWithAuthorization '
                                                                 'adds the given '
                                                                 'charm URL (which '
                                                                 'must include '
                                                                 'revision) to\n'
                                                                 'the model, if it '
                                                                 'does not exist '
                                                                 'yet. Local '
                                                                 'charms are not\n'
                                                                 'supported, only '
                                                                 'charm store '
                                                                 'URLs. See also '
                                                                 'AddLocalCharm().\n'
                                                                 '\n'
                                                                 'The '
                                                                 'authorization '
                                                                 'macaroon, '
                                                                 'args.CharmStoreMacaroon, '
                                                                 'may be\n'
                                                                 'omitted, in '
                                                                 'which case this '
                                                                 'call is '
                                                                 'equivalent to '
                                                                 'AddCharm.',
                                                  'properties': {'Params': {'$ref': '#/definitions/AddCharmWithAuthorization'}},
                                                  'type': 'object'},
                    'AddMachines': {'description': 'AddMachines adds new machines '
                                                   'with the supplied parameters.',
                                    'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                   'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                    'type': 'object'},
                    'AddMachinesV2': {'description': 'AddMachinesV2 adds new '
                                                     'machines with the supplied '
                                                     'parameters.',
                                      'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                     'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                      'type': 'object'},
                    'AgentVersion': {'description': 'AgentVersion returns the '
                                                    'current version that the API '
                                                    'server is running.',
                                     'properties': {'Result': {'$ref': '#/definitions/AgentVersionResult'}},
                                     'type': 'object'},
                    'CACert': {'description': 'CACert returns the certificate used '
                                              'to validate the state connection.',
                               'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'DestroyMachines': {'description': 'DestroyMachines removes a '
                                                       'given set of machines.',
                                        'properties': {'Params': {'$ref': '#/definitions/DestroyMachines'}},
                                        'type': 'object'},
                    'FindTools': {'description': 'FindTools returns a List '
                                                 'containing all tools matching '
                                                 'the given parameters.',
                                  'properties': {'Params': {'$ref': '#/definitions/FindToolsParams'},
                                                 'Result': {'$ref': '#/definitions/FindToolsResult'}},
                                  'type': 'object'},
                    'FullStatus': {'description': 'FullStatus gives the '
                                                  'information needed for juju '
                                                  'status over the api',
                                   'properties': {'Params': {'$ref': '#/definitions/StatusParams'},
                                                  'Result': {'$ref': '#/definitions/FullStatus'}},
                                   'type': 'object'},
                    'GetBundleChanges': {'description': 'GetBundleChanges returns '
                                                        'the list of changes '
                                                        'required to deploy the '
                                                        'given\n'
                                                        'bundle data. The changes '
                                                        'are sorted by '
                                                        'requirements, so that '
                                                        'they can be\n'
                                                        'applied in order.\n'
                                                        'This call is deprecated, '
                                                        'clients should use the '
                                                        'GetChanges endpoint on '
                                                        'the\n'
                                                        'Bundle facade.\n'
                                                        'Note: any new feature in '
                                                        'the future like devices '
                                                        'will never be supported '
                                                        'here.',
                                         'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                        'Result': {'$ref': '#/definitions/BundleChangesResults'}},
                                         'type': 'object'},
                    'GetModelConstraints': {'description': 'GetModelConstraints '
                                                           'returns the '
                                                           'constraints for the '
                                                           'model.',
                                            'properties': {'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                            'type': 'object'},
                    'InjectMachines': {'description': 'InjectMachines injects a '
                                                      'machine into state with '
                                                      'provisioned status.',
                                       'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                      'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                       'type': 'object'},
                    'ModelGet': {'description': 'ModelGet implements the '
                                                'server-side part of the\n'
                                                'model-config CLI command.',
                                 'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                 'type': 'object'},
                    'ModelInfo': {'description': 'ModelInfo returns information '
                                                 'about the current model.',
                                  'properties': {'Result': {'$ref': '#/definitions/ModelInfo'}},
                                  'type': 'object'},
                    'ModelSet': {'description': 'ModelSet implements the '
                                                'server-side part of the\n'
                                                'set-model-config CLI command.',
                                 'properties': {'Params': {'$ref': '#/definitions/ModelSet'}},
                                 'type': 'object'},
                    'ModelUnset': {'description': 'ModelUnset implements the '
                                                  'server-side part of the\n'
                                                  'set-model-config CLI command.',
                                   'properties': {'Params': {'$ref': '#/definitions/ModelUnset'}},
                                   'type': 'object'},
                    'ModelUserInfo': {'description': 'ModelUserInfo returns '
                                                     'information on all users in '
                                                     'the model.',
                                      'properties': {'Result': {'$ref': '#/definitions/ModelUserInfoResults'}},
                                      'type': 'object'},
                    'PrivateAddress': {'description': 'PrivateAddress implements '
                                                      'the server side of '
                                                      'Client.PrivateAddress.',
                                       'properties': {'Params': {'$ref': '#/definitions/PrivateAddress'},
                                                      'Result': {'$ref': '#/definitions/PrivateAddressResults'}},
                                       'type': 'object'},
                    'ProvisioningScript': {'description': 'ProvisioningScript '
                                                          'returns a shell script '
                                                          'that, when run,\n'
                                                          'provisions a machine '
                                                          'agent on the machine '
                                                          'executing the script.',
                                           'properties': {'Params': {'$ref': '#/definitions/ProvisioningScriptParams'},
                                                          'Result': {'$ref': '#/definitions/ProvisioningScriptResult'}},
                                           'type': 'object'},
                    'PublicAddress': {'description': 'PublicAddress implements the '
                                                     'server side of '
                                                     'Client.PublicAddress.',
                                      'properties': {'Params': {'$ref': '#/definitions/PublicAddress'},
                                                     'Result': {'$ref': '#/definitions/PublicAddressResults'}},
                                      'type': 'object'},
                    'ResolveCharms': {'description': 'ResolveCharm resolves the '
                                                     'best available charm URLs '
                                                     'with series, for charm\n'
                                                     'locations without a series '
                                                     'specified.',
                                      'properties': {'Params': {'$ref': '#/definitions/ResolveCharms'},
                                                     'Result': {'$ref': '#/definitions/ResolveCharmResults'}},
                                      'type': 'object'},
                    'Resolved': {'description': 'Resolved implements the server '
                                                'side of Client.Resolved.',
                                 'properties': {'Params': {'$ref': '#/definitions/Resolved'}},
                                 'type': 'object'},
                    'RetryProvisioning': {'description': 'RetryProvisioning marks '
                                                         'a provisioning error as '
                                                         'transient on the '
                                                         'machines.',
                                          'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SLALevel': {'description': 'SLALevel returns the current sla '
                                                'level for the model.',
                                 'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                 'type': 'object'},
                    'SetModelAgentVersion': {'description': 'SetModelAgentVersion '
                                                            'sets the model agent '
                                                            'version.',
                                             'properties': {'Params': {'$ref': '#/definitions/SetModelAgentVersion'}},
                                             'type': 'object'},
                    'SetModelConstraints': {'description': 'SetModelConstraints '
                                                           'sets the constraints '
                                                           'for the model.',
                                            'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                            'type': 'object'},
                    'SetSLALevel': {'description': 'SetSLALevel sets the sla level '
                                                   'on the model.',
                                    'properties': {'Params': {'$ref': '#/definitions/ModelSLA'}},
                                    'type': 'object'},
                    'StatusHistory': {'description': 'StatusHistory returns a '
                                                     'slice of past statuses for '
                                                     'several entities.',
                                      'properties': {'Params': {'$ref': '#/definitions/StatusHistoryRequests'},
                                                     'Result': {'$ref': '#/definitions/StatusHistoryResults'}},
                                      'type': 'object'},
                    'WatchAll': {'description': 'WatchAll initiates a watcher for '
                                                'entities in the connected model.',
                                 'properties': {'Result': {'$ref': '#/definitions/AllWatcherId'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''
        APIHostPorts returns the API host/port addresses stored in state.


        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='APIHostPorts',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AbortCurrentUpgrade(self):
        '''
        AbortCurrentUpgrade aborts and archives the current upgrade
        synchronisation record, if any.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AbortCurrentUpgrade',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AddCharm(self, channel=None, force=None, url=None):
        '''
        channel : str
        force : bool
        url : str
        Returns -> None
        '''
        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if url is not None and not isinstance(url, (bytes, str)):
            raise Exception("Expected url to be a str, received: {}".format(type(url)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddCharm',
                   version=2,
                   params=_params)
        _params['channel'] = channel
        _params['force'] = force
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AddCharmWithAuthorization(self, channel=None, force=None, macaroon=None, url=None):
        '''
        AddCharmWithAuthorization adds the given charm URL (which must include revision) to
        the model, if it does not exist yet. Local charms are not
        supported, only charm store URLs. See also AddLocalCharm().

        The authorization macaroon, args.CharmStoreMacaroon, may be
        omitted, in which case this call is equivalent to AddCharm.

        channel : str
        force : bool
        macaroon : Macaroon
        url : str
        Returns -> None
        '''
        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if macaroon is not None and not isinstance(macaroon, (dict, Macaroon)):
            raise Exception("Expected macaroon to be a Macaroon, received: {}".format(type(macaroon)))

        if url is not None and not isinstance(url, (bytes, str)):
            raise Exception("Expected url to be a str, received: {}".format(type(url)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddCharmWithAuthorization',
                   version=2,
                   params=_params)
        _params['channel'] = channel
        _params['force'] = force
        _params['macaroon'] = macaroon
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def AddMachines(self, params=None):
        '''
        AddMachines adds new machines with the supplied parameters.

        params : typing.Sequence[~AddMachineParams]
        Returns -> AddMachinesResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddMachines',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def AddMachinesV2(self, params=None):
        '''
        AddMachinesV2 adds new machines with the supplied parameters.

        params : typing.Sequence[~AddMachineParams]
        Returns -> AddMachinesResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddMachinesV2',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AgentVersionResult)
    async def AgentVersion(self):
        '''
        AgentVersion returns the current version that the API server is running.


        Returns -> AgentVersionResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AgentVersion',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''
        CACert returns the certificate used to validate the state connection.


        Returns -> BytesResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='CACert',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyMachines(self, force=None, machine_names=None):
        '''
        DestroyMachines removes a given set of machines.

        force : bool
        machine_names : typing.Sequence[str]
        Returns -> None
        '''
        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if machine_names is not None and not isinstance(machine_names, (bytes, str, list)):
            raise Exception("Expected machine_names to be a Sequence, received: {}".format(type(machine_names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='DestroyMachines',
                   version=2,
                   params=_params)
        _params['force'] = force
        _params['machine-names'] = machine_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindToolsResult)
    async def FindTools(self, agentstream=None, arch=None, major=None, minor=None, number=None, series=None):
        '''
        FindTools returns a List containing all tools matching the given parameters.

        agentstream : str
        arch : str
        major : int
        minor : int
        number : Number
        series : str
        Returns -> FindToolsResult
        '''
        if agentstream is not None and not isinstance(agentstream, (bytes, str)):
            raise Exception("Expected agentstream to be a str, received: {}".format(type(agentstream)))

        if arch is not None and not isinstance(arch, (bytes, str)):
            raise Exception("Expected arch to be a str, received: {}".format(type(arch)))

        if major is not None and not isinstance(major, int):
            raise Exception("Expected major to be a int, received: {}".format(type(major)))

        if minor is not None and not isinstance(minor, int):
            raise Exception("Expected minor to be a int, received: {}".format(type(minor)))

        if number is not None and not isinstance(number, (dict, Number)):
            raise Exception("Expected number to be a Number, received: {}".format(type(number)))

        if series is not None and not isinstance(series, (bytes, str)):
            raise Exception("Expected series to be a str, received: {}".format(type(series)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='FindTools',
                   version=2,
                   params=_params)
        _params['agentstream'] = agentstream
        _params['arch'] = arch
        _params['major'] = major
        _params['minor'] = minor
        _params['number'] = number
        _params['series'] = series
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FullStatus)
    async def FullStatus(self, patterns=None):
        '''
        FullStatus gives the information needed for juju status over the api

        patterns : typing.Sequence[str]
        Returns -> FullStatus
        '''
        if patterns is not None and not isinstance(patterns, (bytes, str, list)):
            raise Exception("Expected patterns to be a Sequence, received: {}".format(type(patterns)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='FullStatus',
                   version=2,
                   params=_params)
        _params['patterns'] = patterns
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BundleChangesResults)
    async def GetBundleChanges(self, bundleurl=None, yaml=None):
        '''
        GetBundleChanges returns the list of changes required to deploy the given
        bundle data. The changes are sorted by requirements, so that they can be
        applied in order.
        This call is deprecated, clients should use the GetChanges endpoint on the
        Bundle facade.
        Note: any new feature in the future like devices will never be supported here.

        bundleurl : str
        yaml : str
        Returns -> BundleChangesResults
        '''
        if bundleurl is not None and not isinstance(bundleurl, (bytes, str)):
            raise Exception("Expected bundleurl to be a str, received: {}".format(type(bundleurl)))

        if yaml is not None and not isinstance(yaml, (bytes, str)):
            raise Exception("Expected yaml to be a str, received: {}".format(type(yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='GetBundleChanges',
                   version=2,
                   params=_params)
        _params['bundleURL'] = bundleurl
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetModelConstraints(self):
        '''
        GetModelConstraints returns the constraints for the model.


        Returns -> GetConstraintsResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='GetModelConstraints',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def InjectMachines(self, params=None):
        '''
        InjectMachines injects a machine into state with provisioned status.

        params : typing.Sequence[~AddMachineParams]
        Returns -> AddMachinesResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='InjectMachines',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResults)
    async def ModelGet(self):
        '''
        ModelGet implements the server-side part of the
        model-config CLI command.


        Returns -> ModelConfigResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelGet',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfo)
    async def ModelInfo(self):
        '''
        ModelInfo returns information about the current model.


        Returns -> ModelInfo
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelInfo',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelSet(self, config=None):
        '''
        ModelSet implements the server-side part of the
        set-model-config CLI command.

        config : typing.Mapping[str, typing.Any]
        Returns -> None
        '''
        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelSet',
                   version=2,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelUnset(self, keys=None):
        '''
        ModelUnset implements the server-side part of the
        set-model-config CLI command.

        keys : typing.Sequence[str]
        Returns -> None
        '''
        if keys is not None and not isinstance(keys, (bytes, str, list)):
            raise Exception("Expected keys to be a Sequence, received: {}".format(type(keys)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelUnset',
                   version=2,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelUserInfoResults)
    async def ModelUserInfo(self):
        '''
        ModelUserInfo returns information on all users in the model.


        Returns -> ModelUserInfoResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelUserInfo',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PrivateAddressResults)
    async def PrivateAddress(self, target=None):
        '''
        PrivateAddress implements the server side of Client.PrivateAddress.

        target : str
        Returns -> PrivateAddressResults
        '''
        if target is not None and not isinstance(target, (bytes, str)):
            raise Exception("Expected target to be a str, received: {}".format(type(target)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='PrivateAddress',
                   version=2,
                   params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProvisioningScriptResult)
    async def ProvisioningScript(self, data_dir=None, disable_package_commands=None, machine_id=None, nonce=None):
        '''
        ProvisioningScript returns a shell script that, when run,
        provisions a machine agent on the machine executing the script.

        data_dir : str
        disable_package_commands : bool
        machine_id : str
        nonce : str
        Returns -> ProvisioningScriptResult
        '''
        if data_dir is not None and not isinstance(data_dir, (bytes, str)):
            raise Exception("Expected data_dir to be a str, received: {}".format(type(data_dir)))

        if disable_package_commands is not None and not isinstance(disable_package_commands, bool):
            raise Exception("Expected disable_package_commands to be a bool, received: {}".format(type(disable_package_commands)))

        if machine_id is not None and not isinstance(machine_id, (bytes, str)):
            raise Exception("Expected machine_id to be a str, received: {}".format(type(machine_id)))

        if nonce is not None and not isinstance(nonce, (bytes, str)):
            raise Exception("Expected nonce to be a str, received: {}".format(type(nonce)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ProvisioningScript',
                   version=2,
                   params=_params)
        _params['data-dir'] = data_dir
        _params['disable-package-commands'] = disable_package_commands
        _params['machine-id'] = machine_id
        _params['nonce'] = nonce
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PublicAddressResults)
    async def PublicAddress(self, target=None):
        '''
        PublicAddress implements the server side of Client.PublicAddress.

        target : str
        Returns -> PublicAddressResults
        '''
        if target is not None and not isinstance(target, (bytes, str)):
            raise Exception("Expected target to be a str, received: {}".format(type(target)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='PublicAddress',
                   version=2,
                   params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ResolveCharmResults)
    async def ResolveCharms(self, references=None):
        '''
        ResolveCharm resolves the best available charm URLs with series, for charm
        locations without a series specified.

        references : typing.Sequence[str]
        Returns -> ResolveCharmResults
        '''
        if references is not None and not isinstance(references, (bytes, str, list)):
            raise Exception("Expected references to be a Sequence, received: {}".format(type(references)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ResolveCharms',
                   version=2,
                   params=_params)
        _params['references'] = references
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Resolved(self, retry=None, unit_name=None):
        '''
        Resolved implements the server side of Client.Resolved.

        retry : bool
        unit_name : str
        Returns -> None
        '''
        if retry is not None and not isinstance(retry, bool):
            raise Exception("Expected retry to be a bool, received: {}".format(type(retry)))

        if unit_name is not None and not isinstance(unit_name, (bytes, str)):
            raise Exception("Expected unit_name to be a str, received: {}".format(type(unit_name)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='Resolved',
                   version=2,
                   params=_params)
        _params['retry'] = retry
        _params['unit-name'] = unit_name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RetryProvisioning(self, entities=None):
        '''
        RetryProvisioning marks a provisioning error as transient on the machines.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='RetryProvisioning',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def SLALevel(self):
        '''
        SLALevel returns the current sla level for the model.


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SLALevel',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetModelAgentVersion(self, force=None, version=None):
        '''
        SetModelAgentVersion sets the model agent version.

        force : bool
        version : Number
        Returns -> None
        '''
        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if version is not None and not isinstance(version, (dict, Number)):
            raise Exception("Expected version to be a Number, received: {}".format(type(version)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SetModelAgentVersion',
                   version=2,
                   params=_params)
        _params['force'] = force
        _params['version'] = version
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetModelConstraints(self, application=None, constraints=None):
        '''
        SetModelConstraints sets the constraints for the model.

        application : str
        constraints : Value
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SetModelConstraints',
                   version=2,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetSLALevel(self, modelslainfo=None, creds=None, level=None, owner=None):
        '''
        SetSLALevel sets the sla level on the model.

        modelslainfo : ModelSLAInfo
        creds : typing.Sequence[int]
        level : str
        owner : str
        Returns -> None
        '''
        if modelslainfo is not None and not isinstance(modelslainfo, (dict, ModelSLAInfo)):
            raise Exception("Expected modelslainfo to be a ModelSLAInfo, received: {}".format(type(modelslainfo)))

        if creds is not None and not isinstance(creds, (bytes, str, list)):
            raise Exception("Expected creds to be a Sequence, received: {}".format(type(creds)))

        if level is not None and not isinstance(level, (bytes, str)):
            raise Exception("Expected level to be a str, received: {}".format(type(level)))

        if owner is not None and not isinstance(owner, (bytes, str)):
            raise Exception("Expected owner to be a str, received: {}".format(type(owner)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SetSLALevel',
                   version=2,
                   params=_params)
        _params['ModelSLAInfo'] = modelslainfo
        _params['creds'] = creds
        _params['level'] = level
        _params['owner'] = owner
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusHistoryResults)
    async def StatusHistory(self, requests=None):
        '''
        StatusHistory returns a slice of past statuses for several entities.

        requests : typing.Sequence[~StatusHistoryRequest]
        Returns -> StatusHistoryResults
        '''
        if requests is not None and not isinstance(requests, (bytes, str, list)):
            raise Exception("Expected requests to be a Sequence, received: {}".format(type(requests)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='StatusHistory',
                   version=2,
                   params=_params)
        _params['requests'] = requests
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AllWatcherId)
    async def WatchAll(self):
        '''
        WatchAll initiates a watcher for entities in the connected model.


        Returns -> AllWatcherId
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='WatchAll',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CredentialValidatorFacade(Type):
    name = 'CredentialValidator'
    version = 2
    schema =     {'definitions': {'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'InvalidateCredentialArg': {'additionalProperties': False,
                                                 'properties': {'reason': {'type': 'string'}},
                                                 'type': 'object'},
                     'ModelCredential': {'additionalProperties': False,
                                         'properties': {'credential-tag': {'type': 'string'},
                                                        'exists': {'type': 'boolean'},
                                                        'model-tag': {'type': 'string'},
                                                        'valid': {'type': 'boolean'}},
                                         'required': ['model-tag',
                                                      'credential-tag'],
                                         'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'}},
     'properties': {'InvalidateModelCredential': {'description': 'InvalidateModelCredential '
                                                                 'marks the cloud '
                                                                 'credential for '
                                                                 'this model as '
                                                                 'invalid.',
                                                  'properties': {'Params': {'$ref': '#/definitions/InvalidateCredentialArg'},
                                                                 'Result': {'$ref': '#/definitions/ErrorResult'}},
                                                  'type': 'object'},
                    'ModelCredential': {'description': 'ModelCredential returns '
                                                       'cloud credential '
                                                       'information for a  model.',
                                        'properties': {'Result': {'$ref': '#/definitions/ModelCredential'}},
                                        'type': 'object'},
                    'WatchCredential': {'description': 'WatchCredential returns a '
                                                       'NotifyWatcher that '
                                                       'observes\n'
                                                       'changes to a given cloud '
                                                       'credential.',
                                        'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                       'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                        'type': 'object'},
                    'WatchModelCredential': {'description': 'WatchModelCredential '
                                                            'returns a '
                                                            'NotifyWatcher that '
                                                            'watches what cloud '
                                                            'credential a model '
                                                            'uses.',
                                             'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def InvalidateModelCredential(self, reason=None):
        '''
        InvalidateModelCredential marks the cloud credential for this model as invalid.

        reason : str
        Returns -> ErrorResult
        '''
        if reason is not None and not isinstance(reason, (bytes, str)):
            raise Exception("Expected reason to be a str, received: {}".format(type(reason)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CredentialValidator',
                   request='InvalidateModelCredential',
                   version=2,
                   params=_params)
        _params['reason'] = reason
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelCredential)
    async def ModelCredential(self):
        '''
        ModelCredential returns cloud credential information for a  model.


        Returns -> ModelCredential
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CredentialValidator',
                   request='ModelCredential',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchCredential(self, tag=None):
        '''
        WatchCredential returns a NotifyWatcher that observes
        changes to a given cloud credential.

        tag : str
        Returns -> NotifyWatchResult
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CredentialValidator',
                   request='WatchCredential',
                   version=2,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchModelCredential(self):
        '''
        WatchModelCredential returns a NotifyWatcher that watches what cloud credential a model uses.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CredentialValidator',
                   request='WatchModelCredential',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CrossModelRelationsFacade(Type):
    name = 'CrossModelRelations'
    version = 2
    schema =     {'definitions': {'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'IngressNetworksChangeEvent': {'additionalProperties': False,
                                                    'properties': {'application-token': {'type': 'string'},
                                                                   'bakery-version': {'type': 'integer'},
                                                                   'ingress-required': {'type': 'boolean'},
                                                                   'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                                 'type': 'array'},
                                                                   'networks': {'items': {'type': 'string'},
                                                                                'type': 'array'},
                                                                   'relation-token': {'type': 'string'}},
                                                    'required': ['relation-token',
                                                                 'application-token',
                                                                 'ingress-required'],
                                                    'type': 'object'},
                     'IngressNetworksChanges': {'additionalProperties': False,
                                                'properties': {'changes': {'items': {'$ref': '#/definitions/IngressNetworksChangeEvent'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'OfferArg': {'additionalProperties': False,
                                  'properties': {'bakery-version': {'type': 'integer'},
                                                 'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                               'type': 'array'},
                                                 'offer-uuid': {'type': 'string'}},
                                  'required': ['offer-uuid'],
                                  'type': 'object'},
                     'OfferArgs': {'additionalProperties': False,
                                   'properties': {'args': {'items': {'$ref': '#/definitions/OfferArg'},
                                                           'type': 'array'}},
                                   'required': ['args'],
                                   'type': 'object'},
                     'OfferStatusChange': {'additionalProperties': False,
                                           'properties': {'offer-name': {'type': 'string'},
                                                          'status': {'$ref': '#/definitions/EntityStatus'}},
                                           'required': ['offer-name', 'status'],
                                           'type': 'object'},
                     'OfferStatusWatchResult': {'additionalProperties': False,
                                                'properties': {'changes': {'items': {'$ref': '#/definitions/OfferStatusChange'},
                                                                           'type': 'array'},
                                                               'error': {'$ref': '#/definitions/Error'},
                                                               'watcher-id': {'type': 'string'}},
                                                'required': ['watcher-id',
                                                             'changes'],
                                                'type': 'object'},
                     'OfferStatusWatchResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/OfferStatusWatchResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'RegisterRemoteRelationArg': {'additionalProperties': False,
                                                   'properties': {'application-token': {'type': 'string'},
                                                                  'bakery-version': {'type': 'integer'},
                                                                  'local-endpoint-name': {'type': 'string'},
                                                                  'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                                'type': 'array'},
                                                                  'offer-uuid': {'type': 'string'},
                                                                  'relation-token': {'type': 'string'},
                                                                  'remote-endpoint': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                  'remote-space': {'$ref': '#/definitions/RemoteSpace'},
                                                                  'source-model-tag': {'type': 'string'}},
                                                   'required': ['application-token',
                                                                'source-model-tag',
                                                                'relation-token',
                                                                'remote-endpoint',
                                                                'remote-space',
                                                                'offer-uuid',
                                                                'local-endpoint-name'],
                                                   'type': 'object'},
                     'RegisterRemoteRelationArgs': {'additionalProperties': False,
                                                    'properties': {'relations': {'items': {'$ref': '#/definitions/RegisterRemoteRelationArg'},
                                                                                 'type': 'array'}},
                                                    'required': ['relations'],
                                                    'type': 'object'},
                     'RegisterRemoteRelationResult': {'additionalProperties': False,
                                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                     'result': {'$ref': '#/definitions/RemoteRelationDetails'}},
                                                      'type': 'object'},
                     'RegisterRemoteRelationResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/RegisterRemoteRelationResult'},
                                                                                  'type': 'array'}},
                                                       'type': 'object'},
                     'RelationLifeSuspendedStatusChange': {'additionalProperties': False,
                                                           'properties': {'key': {'type': 'string'},
                                                                          'life': {'type': 'string'},
                                                                          'suspended': {'type': 'boolean'},
                                                                          'suspended-reason': {'type': 'string'}},
                                                           'required': ['key',
                                                                        'life',
                                                                        'suspended',
                                                                        'suspended-reason'],
                                                           'type': 'object'},
                     'RelationLifeSuspendedStatusWatchResult': {'additionalProperties': False,
                                                                'properties': {'changes': {'items': {'$ref': '#/definitions/RelationLifeSuspendedStatusChange'},
                                                                                           'type': 'array'},
                                                                               'error': {'$ref': '#/definitions/Error'},
                                                                               'watcher-id': {'type': 'string'}},
                                                                'required': ['watcher-id',
                                                                             'changes'],
                                                                'type': 'object'},
                     'RelationStatusWatchResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/RelationLifeSuspendedStatusWatchResult'},
                                                                               'type': 'array'}},
                                                    'required': ['results'],
                                                    'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'RemoteEntityArg': {'additionalProperties': False,
                                         'properties': {'bakery-version': {'type': 'integer'},
                                                        'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                      'type': 'array'},
                                                        'relation-token': {'type': 'string'}},
                                         'required': ['relation-token'],
                                         'type': 'object'},
                     'RemoteEntityArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/RemoteEntityArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'RemoteRelationChangeEvent': {'additionalProperties': False,
                                                   'properties': {'application-settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                        'type': 'object'}},
                                                                                           'type': 'object'},
                                                                  'application-token': {'type': 'string'},
                                                                  'bakery-version': {'type': 'integer'},
                                                                  'changed-units': {'items': {'$ref': '#/definitions/RemoteRelationUnitChange'},
                                                                                    'type': 'array'},
                                                                  'departed-units': {'items': {'type': 'integer'},
                                                                                     'type': 'array'},
                                                                  'force-cleanup': {'type': 'boolean'},
                                                                  'life': {'type': 'string'},
                                                                  'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                                'type': 'array'},
                                                                  'relation-token': {'type': 'string'},
                                                                  'suspended': {'type': 'boolean'},
                                                                  'suspended-reason': {'type': 'string'},
                                                                  'unit-count': {'type': 'integer'}},
                                                   'required': ['relation-token',
                                                                'application-token',
                                                                'life'],
                                                   'type': 'object'},
                     'RemoteRelationDetails': {'additionalProperties': False,
                                               'properties': {'bakery-version': {'type': 'integer'},
                                                              'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                              'relation-token': {'type': 'string'}},
                                               'required': ['relation-token'],
                                               'type': 'object'},
                     'RemoteRelationUnitChange': {'additionalProperties': False,
                                                  'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                                 'unit-id': {'type': 'integer'}},
                                                  'required': ['unit-id'],
                                                  'type': 'object'},
                     'RemoteRelationWatchResult': {'additionalProperties': False,
                                                   'properties': {'changes': {'$ref': '#/definitions/RemoteRelationChangeEvent'},
                                                                  'error': {'$ref': '#/definitions/Error'},
                                                                  'watcher-id': {'type': 'string'}},
                                                   'required': ['watcher-id',
                                                                'changes'],
                                                   'type': 'object'},
                     'RemoteRelationWatchResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/RemoteRelationWatchResult'},
                                                                               'type': 'array'}},
                                                    'required': ['results'],
                                                    'type': 'object'},
                     'RemoteRelationsChanges': {'additionalProperties': False,
                                                'properties': {'changes': {'items': {'$ref': '#/definitions/RemoteRelationChangeEvent'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'RemoteSpace': {'additionalProperties': False,
                                     'properties': {'cloud-type': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'provider-attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                         'type': 'object'}},
                                                                            'type': 'object'},
                                                    'provider-id': {'type': 'string'},
                                                    'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                'type': 'array'}},
                                     'required': ['cloud-type',
                                                  'name',
                                                  'provider-id',
                                                  'provider-attributes',
                                                  'subnets'],
                                     'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'}},
     'properties': {'PublishIngressNetworkChanges': {'description': 'PublishIngressNetworkChanges '
                                                                    'publishes '
                                                                    'changes to '
                                                                    'the required\n'
                                                                    'ingress '
                                                                    'addresses to '
                                                                    'the model '
                                                                    'hosting the '
                                                                    'offer in the '
                                                                    'relation.',
                                                     'properties': {'Params': {'$ref': '#/definitions/IngressNetworksChanges'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                     'type': 'object'},
                    'PublishRelationChanges': {'description': 'PublishRelationChanges '
                                                              'publishes relation '
                                                              'changes to the\n'
                                                              'model hosting the '
                                                              'remote application '
                                                              'involved in the '
                                                              'relation.',
                                               'properties': {'Params': {'$ref': '#/definitions/RemoteRelationsChanges'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'RegisterRemoteRelations': {'description': 'RegisterRemoteRelationArgs '
                                                               'sets up the model '
                                                               'to participate\n'
                                                               'in the specified '
                                                               'relations. This '
                                                               'operation is '
                                                               'idempotent.',
                                                'properties': {'Params': {'$ref': '#/definitions/RegisterRemoteRelationArgs'},
                                                               'Result': {'$ref': '#/definitions/RegisterRemoteRelationResults'}},
                                                'type': 'object'},
                    'WatchEgressAddressesForRelations': {'description': 'WatchEgressAddressesForRelations '
                                                                        'creates a '
                                                                        'watcher '
                                                                        'that '
                                                                        'notifies '
                                                                        'when '
                                                                        'addresses, '
                                                                        'from '
                                                                        'which\n'
                                                                        'connections '
                                                                        'will '
                                                                        'originate '
                                                                        'for the '
                                                                        'relation, '
                                                                        'change.\n'
                                                                        'Each '
                                                                        'event '
                                                                        'contains '
                                                                        'the '
                                                                        'entire '
                                                                        'set of '
                                                                        'addresses '
                                                                        'which are '
                                                                        'required '
                                                                        'for '
                                                                        'ingress '
                                                                        'for the '
                                                                        'relation.',
                                                         'properties': {'Params': {'$ref': '#/definitions/RemoteEntityArgs'},
                                                                        'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                         'type': 'object'},
                    'WatchOfferStatus': {'description': 'WatchOfferStatus starts '
                                                        'an OfferStatusWatcher '
                                                        'for\n'
                                                        'watching the status of an '
                                                        'offer.',
                                         'properties': {'Params': {'$ref': '#/definitions/OfferArgs'},
                                                        'Result': {'$ref': '#/definitions/OfferStatusWatchResults'}},
                                         'type': 'object'},
                    'WatchRelationChanges': {'description': 'WatchRelationChanges '
                                                            'starts a '
                                                            'RemoteRelationChangesWatcher '
                                                            'for each\n'
                                                            'specified relation, '
                                                            'returning the watcher '
                                                            'IDs and initial '
                                                            'values,\n'
                                                            'or an error if the '
                                                            'remote relations '
                                                            "couldn't be watched.",
                                             'properties': {'Params': {'$ref': '#/definitions/RemoteEntityArgs'},
                                                            'Result': {'$ref': '#/definitions/RemoteRelationWatchResults'}},
                                             'type': 'object'},
                    'WatchRelationsSuspendedStatus': {'description': 'WatchRelationsSuspendedStatus '
                                                                     'starts a '
                                                                     'RelationStatusWatcher '
                                                                     'for\n'
                                                                     'watching the '
                                                                     'life and '
                                                                     'suspended '
                                                                     'status of a '
                                                                     'relation.',
                                                      'properties': {'Params': {'$ref': '#/definitions/RemoteEntityArgs'},
                                                                     'Result': {'$ref': '#/definitions/RelationStatusWatchResults'}},
                                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def PublishIngressNetworkChanges(self, changes=None):
        '''
        PublishIngressNetworkChanges publishes changes to the required
        ingress addresses to the model hosting the offer in the relation.

        changes : typing.Sequence[~IngressNetworksChangeEvent]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='PublishIngressNetworkChanges',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def PublishRelationChanges(self, changes=None):
        '''
        PublishRelationChanges publishes relation changes to the
        model hosting the remote application involved in the relation.

        changes : typing.Sequence[~RemoteRelationChangeEvent]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='PublishRelationChanges',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RegisterRemoteRelationResults)
    async def RegisterRemoteRelations(self, relations=None):
        '''
        RegisterRemoteRelationArgs sets up the model to participate
        in the specified relations. This operation is idempotent.

        relations : typing.Sequence[~RegisterRemoteRelationArg]
        Returns -> RegisterRemoteRelationResults
        '''
        if relations is not None and not isinstance(relations, (bytes, str, list)):
            raise Exception("Expected relations to be a Sequence, received: {}".format(type(relations)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='RegisterRemoteRelations',
                   version=2,
                   params=_params)
        _params['relations'] = relations
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchEgressAddressesForRelations(self, args=None):
        '''
        WatchEgressAddressesForRelations creates a watcher that notifies when addresses, from which
        connections will originate for the relation, change.
        Each event contains the entire set of addresses which are required for ingress for the relation.

        args : typing.Sequence[~RemoteEntityArg]
        Returns -> StringsWatchResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='WatchEgressAddressesForRelations',
                   version=2,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(OfferStatusWatchResults)
    async def WatchOfferStatus(self, args=None):
        '''
        WatchOfferStatus starts an OfferStatusWatcher for
        watching the status of an offer.

        args : typing.Sequence[~OfferArg]
        Returns -> OfferStatusWatchResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='WatchOfferStatus',
                   version=2,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteRelationWatchResults)
    async def WatchRelationChanges(self, args=None):
        '''
        WatchRelationChanges starts a RemoteRelationChangesWatcher for each
        specified relation, returning the watcher IDs and initial values,
        or an error if the remote relations couldn't be watched.

        args : typing.Sequence[~RemoteEntityArg]
        Returns -> RemoteRelationWatchResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='WatchRelationChanges',
                   version=2,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationStatusWatchResults)
    async def WatchRelationsSuspendedStatus(self, args=None):
        '''
        WatchRelationsSuspendedStatus starts a RelationStatusWatcher for
        watching the life and suspended status of a relation.

        args : typing.Sequence[~RemoteEntityArg]
        Returns -> RelationStatusWatchResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='WatchRelationsSuspendedStatus',
                   version=2,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



class DiscoverSpacesFacade(Type):
    name = 'DiscoverSpaces'
    version = 2
    schema =     {'definitions': {'AddSubnetParams': {'additionalProperties': False,
                                         'properties': {'provider-network-id': {'type': 'string'},
                                                        'space-tag': {'type': 'string'},
                                                        'subnet-provider-id': {'type': 'string'},
                                                        'subnet-tag': {'type': 'string'},
                                                        'vlan-tag': {'type': 'integer'},
                                                        'zones': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                         'required': ['space-tag'],
                                         'type': 'object'},
                     'AddSubnetsParams': {'additionalProperties': False,
                                          'properties': {'subnets': {'items': {'$ref': '#/definitions/AddSubnetParams'},
                                                                     'type': 'array'}},
                                          'required': ['subnets'],
                                          'type': 'object'},
                     'CreateSpaceParams': {'additionalProperties': False,
                                           'properties': {'provider-id': {'type': 'string'},
                                                          'public': {'type': 'boolean'},
                                                          'space-tag': {'type': 'string'},
                                                          'subnet-tags': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                           'required': ['subnet-tags',
                                                        'space-tag',
                                                        'public'],
                                           'type': 'object'},
                     'CreateSpacesParams': {'additionalProperties': False,
                                            'properties': {'spaces': {'items': {'$ref': '#/definitions/CreateSpaceParams'},
                                                                      'type': 'array'}},
                                            'required': ['spaces'],
                                            'type': 'object'},
                     'DiscoverSpacesResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/ProviderSpace'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSubnetsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/Subnet'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ProviderSpace': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'name': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                  'type': 'array'}},
                                       'required': ['name',
                                                    'provider-id',
                                                    'subnets'],
                                       'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'SubnetsFilters': {'additionalProperties': False,
                                        'properties': {'space-tag': {'type': 'string'},
                                                       'zone': {'type': 'string'}},
                                        'type': 'object'}},
     'properties': {'AddSubnets': {'properties': {'Params': {'$ref': '#/definitions/AddSubnetsParams'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'CreateSpaces': {'properties': {'Params': {'$ref': '#/definitions/CreateSpacesParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListSpaces': {'properties': {'Result': {'$ref': '#/definitions/DiscoverSpacesResults'}},
                                   'type': 'object'},
                    'ListSubnets': {'properties': {'Params': {'$ref': '#/definitions/SubnetsFilters'},
                                                   'Result': {'$ref': '#/definitions/ListSubnetsResults'}},
                                    'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddSubnets(self, subnets=None):
        '''
        subnets : typing.Sequence[~AddSubnetParams]
        Returns -> ErrorResults
        '''
        if subnets is not None and not isinstance(subnets, (bytes, str, list)):
            raise Exception("Expected subnets to be a Sequence, received: {}".format(type(subnets)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='AddSubnets',
                   version=2,
                   params=_params)
        _params['subnets'] = subnets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def CreateSpaces(self, spaces=None):
        '''
        spaces : typing.Sequence[~CreateSpaceParams]
        Returns -> ErrorResults
        '''
        if spaces is not None and not isinstance(spaces, (bytes, str, list)):
            raise Exception("Expected spaces to be a Sequence, received: {}".format(type(spaces)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='CreateSpaces',
                   version=2,
                   params=_params)
        _params['spaces'] = spaces
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DiscoverSpacesResults)
    async def ListSpaces(self):
        '''

        Returns -> DiscoverSpacesResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='ListSpaces',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSubnetsResults)
    async def ListSubnets(self, space_tag=None, zone=None):
        '''
        space_tag : str
        zone : str
        Returns -> ListSubnetsResults
        '''
        if space_tag is not None and not isinstance(space_tag, (bytes, str)):
            raise Exception("Expected space_tag to be a str, received: {}".format(type(space_tag)))

        if zone is not None and not isinstance(zone, (bytes, str)):
            raise Exception("Expected zone to be a str, received: {}".format(type(zone)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='ListSubnets',
                   version=2,
                   params=_params)
        _params['space-tag'] = space_tag
        _params['zone'] = zone
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiscoverSpaces',
                   request='ModelConfig',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class DiskManagerFacade(Type):
    name = 'DiskManager'
    version = 2
    schema =     {'definitions': {'BlockDevice': {'additionalProperties': False,
                                     'properties': {'BusAddress': {'type': 'string'},
                                                    'DeviceLinks': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                    'DeviceName': {'type': 'string'},
                                                    'FilesystemType': {'type': 'string'},
                                                    'HardwareId': {'type': 'string'},
                                                    'InUse': {'type': 'boolean'},
                                                    'Label': {'type': 'string'},
                                                    'MountPoint': {'type': 'string'},
                                                    'SerialId': {'type': 'string'},
                                                    'Size': {'type': 'integer'},
                                                    'UUID': {'type': 'string'},
                                                    'WWN': {'type': 'string'}},
                                     'required': ['DeviceName',
                                                  'DeviceLinks',
                                                  'Label',
                                                  'UUID',
                                                  'HardwareId',
                                                  'WWN',
                                                  'BusAddress',
                                                  'Size',
                                                  'FilesystemType',
                                                  'InUse',
                                                  'MountPoint',
                                                  'SerialId'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'MachineBlockDevices': {'additionalProperties': False,
                                             'properties': {'block-devices': {'items': {'$ref': '#/definitions/BlockDevice'},
                                                                              'type': 'array'},
                                                            'machine': {'type': 'string'}},
                                             'required': ['machine'],
                                             'type': 'object'},
                     'SetMachineBlockDevices': {'additionalProperties': False,
                                                'properties': {'machine-block-devices': {'items': {'$ref': '#/definitions/MachineBlockDevices'},
                                                                                         'type': 'array'}},
                                                'required': ['machine-block-devices'],
                                                'type': 'object'}},
     'properties': {'SetMachineBlockDevices': {'properties': {'Params': {'$ref': '#/definitions/SetMachineBlockDevices'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def SetMachineBlockDevices(self, machine_block_devices=None):
        '''
        machine_block_devices : typing.Sequence[~MachineBlockDevices]
        Returns -> ErrorResults
        '''
        if machine_block_devices is not None and not isinstance(machine_block_devices, (bytes, str, list)):
            raise Exception("Expected machine_block_devices to be a Sequence, received: {}".format(type(machine_block_devices)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='DiskManager',
                   request='SetMachineBlockDevices',
                   version=2,
                   params=_params)
        _params['machine-block-devices'] = machine_block_devices
        reply = await self.rpc(msg)
        return reply



class EntityWatcherFacade(Type):
    name = 'EntityWatcher'
    version = 2
    schema =     {'definitions': {'EntitiesWatchResult': {'additionalProperties': False,
                                             'properties': {'changes': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'watcher-id': {'type': 'string'}},
                                             'required': ['watcher-id'],
                                             'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'}},
     'properties': {'Next': {'description': 'Next returns when a change has '
                                            'occurred to an entity of the\n'
                                            'collection being watched since the '
                                            'most recent call to Next\n'
                                            'or the Watch call that created the '
                                            'srvEntitiesWatcher.',
                             'properties': {'Result': {'$ref': '#/definitions/EntitiesWatchResult'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(EntitiesWatchResult)
    async def Next(self):
        '''
        Next returns when a change has occurred to an entity of the
        collection being watched since the most recent call to Next
        or the Watch call that created the srvEntitiesWatcher.


        Returns -> EntitiesWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='EntityWatcher',
                   request='Next',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='EntityWatcher',
                   request='Stop',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class FilesystemAttachmentsWatcherFacade(Type):
    name = 'FilesystemAttachmentsWatcher'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'}},
     'properties': {'Next': {'description': 'Next returns when a change has '
                                            'occurred to an entity of the\n'
                                            'collection being watched since the '
                                            'most recent call to Next\n'
                                            'or the Watch call that created the '
                                            'srvMachineStorageIdsWatcher.',
                             'properties': {'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MachineStorageIdsWatchResult)
    async def Next(self):
        '''
        Next returns when a change has occurred to an entity of the
        collection being watched since the most recent call to Next
        or the Watch call that created the srvMachineStorageIdsWatcher.


        Returns -> MachineStorageIdsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FilesystemAttachmentsWatcher',
                   request='Next',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FilesystemAttachmentsWatcher',
                   request='Stop',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class HighAvailabilityFacade(Type):
    name = 'HighAvailability'
    version = 2
    schema =     {'definitions': {'ControllersChangeResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/ControllersChanges'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'ControllersChangeResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllersChangeResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllersChanges': {'additionalProperties': False,
                                            'properties': {'added': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                           'converted': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                           'maintained': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                           'removed': {'items': {'type': 'string'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'ControllersSpec': {'additionalProperties': False,
                                         'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                        'num-controllers': {'type': 'integer'},
                                                        'placement': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                        'series': {'type': 'string'}},
                                         'required': ['num-controllers'],
                                         'type': 'object'},
                     'ControllersSpecs': {'additionalProperties': False,
                                          'properties': {'specs': {'items': {'$ref': '#/definitions/ControllersSpec'},
                                                                   'type': 'array'}},
                                          'required': ['specs'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'EnableHA': {'description': 'EnableHA adds controller machines '
                                                'as necessary to ensure the\n'
                                                'controller has the number of '
                                                'machines specified.',
                                 'properties': {'Params': {'$ref': '#/definitions/ControllersSpecs'},
                                                'Result': {'$ref': '#/definitions/ControllersChangeResults'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ControllersChangeResults)
    async def EnableHA(self, specs=None):
        '''
        EnableHA adds controller machines as necessary to ensure the
        controller has the number of machines specified.

        specs : typing.Sequence[~ControllersSpec]
        Returns -> ControllersChangeResults
        '''
        if specs is not None and not isinstance(specs, (bytes, str, list)):
            raise Exception("Expected specs to be a Sequence, received: {}".format(type(specs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='HighAvailability',
                   request='EnableHA',
                   version=2,
                   params=_params)
        _params['specs'] = specs
        reply = await self.rpc(msg)
        return reply



class ImageManagerFacade(Type):
    name = 'ImageManager'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ImageFilterParams': {'additionalProperties': False,
                                           'properties': {'images': {'items': {'$ref': '#/definitions/ImageSpec'},
                                                                     'type': 'array'}},
                                           'required': ['images'],
                                           'type': 'object'},
                     'ImageMetadata': {'additionalProperties': False,
                                       'properties': {'arch': {'type': 'string'},
                                                      'created': {'format': 'date-time',
                                                                  'type': 'string'},
                                                      'kind': {'type': 'string'},
                                                      'series': {'type': 'string'},
                                                      'url': {'type': 'string'}},
                                       'required': ['kind',
                                                    'arch',
                                                    'series',
                                                    'url',
                                                    'created'],
                                       'type': 'object'},
                     'ImageSpec': {'additionalProperties': False,
                                   'properties': {'arch': {'type': 'string'},
                                                  'kind': {'type': 'string'},
                                                  'series': {'type': 'string'}},
                                   'required': ['kind', 'arch', 'series'],
                                   'type': 'object'},
                     'ListImageResult': {'additionalProperties': False,
                                         'properties': {'result': {'items': {'$ref': '#/definitions/ImageMetadata'},
                                                                   'type': 'array'}},
                                         'required': ['result'],
                                         'type': 'object'}},
     'properties': {'DeleteImages': {'description': 'DeleteImages deletes the '
                                                    'images matching the specified '
                                                    'filter.',
                                     'properties': {'Params': {'$ref': '#/definitions/ImageFilterParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListImages': {'description': 'ListImages returns images '
                                                  'matching the specified filter.',
                                   'properties': {'Params': {'$ref': '#/definitions/ImageFilterParams'},
                                                  'Result': {'$ref': '#/definitions/ListImageResult'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def DeleteImages(self, images=None):
        '''
        DeleteImages deletes the images matching the specified filter.

        images : typing.Sequence[~ImageSpec]
        Returns -> ErrorResults
        '''
        if images is not None and not isinstance(images, (bytes, str, list)):
            raise Exception("Expected images to be a Sequence, received: {}".format(type(images)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageManager',
                   request='DeleteImages',
                   version=2,
                   params=_params)
        _params['images'] = images
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListImageResult)
    async def ListImages(self, images=None):
        '''
        ListImages returns images matching the specified filter.

        images : typing.Sequence[~ImageSpec]
        Returns -> ListImageResult
        '''
        if images is not None and not isinstance(images, (bytes, str, list)):
            raise Exception("Expected images to be a Sequence, received: {}".format(type(images)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageManager',
                   request='ListImages',
                   version=2,
                   params=_params)
        _params['images'] = images
        reply = await self.rpc(msg)
        return reply



class ImageMetadataFacade(Type):
    name = 'ImageMetadata'
    version = 2
    schema =     {'definitions': {'CloudImageMetadata': {'additionalProperties': False,
                                            'properties': {'arch': {'type': 'string'},
                                                           'image-id': {'type': 'string'},
                                                           'priority': {'type': 'integer'},
                                                           'region': {'type': 'string'},
                                                           'root-storage-size': {'type': 'integer'},
                                                           'root-storage-type': {'type': 'string'},
                                                           'series': {'type': 'string'},
                                                           'source': {'type': 'string'},
                                                           'stream': {'type': 'string'},
                                                           'version': {'type': 'string'},
                                                           'virt-type': {'type': 'string'}},
                                            'required': ['image-id',
                                                         'region',
                                                         'version',
                                                         'series',
                                                         'arch',
                                                         'source',
                                                         'priority'],
                                            'type': 'object'},
                     'CloudImageMetadataList': {'additionalProperties': False,
                                                'properties': {'metadata': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                            'type': 'array'}},
                                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ImageMetadataFilter': {'additionalProperties': False,
                                             'properties': {'arches': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                            'region': {'type': 'string'},
                                                            'root-storage-type': {'type': 'string'},
                                                            'series': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                            'stream': {'type': 'string'},
                                                            'virt-type': {'type': 'string'}},
                                             'type': 'object'},
                     'ListCloudImageMetadataResult': {'additionalProperties': False,
                                                      'properties': {'result': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                                'type': 'array'}},
                                                      'required': ['result'],
                                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MetadataImageIds': {'additionalProperties': False,
                                          'properties': {'image-ids': {'items': {'type': 'string'},
                                                                       'type': 'array'}},
                                          'required': ['image-ids'],
                                          'type': 'object'},
                     'MetadataSaveParams': {'additionalProperties': False,
                                            'properties': {'metadata': {'items': {'$ref': '#/definitions/CloudImageMetadataList'},
                                                                        'type': 'array'}},
                                            'type': 'object'}},
     'properties': {'Delete': {'properties': {'Params': {'$ref': '#/definitions/MetadataImageIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'List': {'properties': {'Params': {'$ref': '#/definitions/ImageMetadataFilter'},
                                            'Result': {'$ref': '#/definitions/ListCloudImageMetadataResult'}},
                             'type': 'object'},
                    'Save': {'properties': {'Params': {'$ref': '#/definitions/MetadataSaveParams'},
                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                             'type': 'object'},
                    'UpdateFromPublishedImages': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Delete(self, image_ids=None):
        '''
        image_ids : typing.Sequence[str]
        Returns -> ErrorResults
        '''
        if image_ids is not None and not isinstance(image_ids, (bytes, str, list)):
            raise Exception("Expected image_ids to be a Sequence, received: {}".format(type(image_ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata',
                   request='Delete',
                   version=2,
                   params=_params)
        _params['image-ids'] = image_ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListCloudImageMetadataResult)
    async def List(self, arches=None, region=None, root_storage_type=None, series=None, stream=None, virt_type=None):
        '''
        arches : typing.Sequence[str]
        region : str
        root_storage_type : str
        series : typing.Sequence[str]
        stream : str
        virt_type : str
        Returns -> ListCloudImageMetadataResult
        '''
        if arches is not None and not isinstance(arches, (bytes, str, list)):
            raise Exception("Expected arches to be a Sequence, received: {}".format(type(arches)))

        if region is not None and not isinstance(region, (bytes, str)):
            raise Exception("Expected region to be a str, received: {}".format(type(region)))

        if root_storage_type is not None and not isinstance(root_storage_type, (bytes, str)):
            raise Exception("Expected root_storage_type to be a str, received: {}".format(type(root_storage_type)))

        if series is not None and not isinstance(series, (bytes, str, list)):
            raise Exception("Expected series to be a Sequence, received: {}".format(type(series)))

        if stream is not None and not isinstance(stream, (bytes, str)):
            raise Exception("Expected stream to be a str, received: {}".format(type(stream)))

        if virt_type is not None and not isinstance(virt_type, (bytes, str)):
            raise Exception("Expected virt_type to be a str, received: {}".format(type(virt_type)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata',
                   request='List',
                   version=2,
                   params=_params)
        _params['arches'] = arches
        _params['region'] = region
        _params['root-storage-type'] = root_storage_type
        _params['series'] = series
        _params['stream'] = stream
        _params['virt-type'] = virt_type
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Save(self, metadata=None):
        '''
        metadata : typing.Sequence[~CloudImageMetadataList]
        Returns -> ErrorResults
        '''
        if metadata is not None and not isinstance(metadata, (bytes, str, list)):
            raise Exception("Expected metadata to be a Sequence, received: {}".format(type(metadata)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata',
                   request='Save',
                   version=2,
                   params=_params)
        _params['metadata'] = metadata
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def UpdateFromPublishedImages(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadata',
                   request='UpdateFromPublishedImages',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class InstanceMutaterFacade(Type):
    name = 'InstanceMutater'
    version = 2
    schema =     {'definitions': {'CharmLXDProfile': {'additionalProperties': False,
                                         'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'},
                                                        'description': {'type': 'string'},
                                                        'devices': {'patternProperties': {'.*': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'}},
                                         'required': ['config',
                                                      'description',
                                                      'devices'],
                                         'type': 'object'},
                     'CharmProfilingInfoResult': {'additionalProperties': False,
                                                  'properties': {'current-profiles': {'items': {'type': 'string'},
                                                                                      'type': 'array'},
                                                                 'error': {'$ref': '#/definitions/Error'},
                                                                 'instance-id': {'type': 'string'},
                                                                 'model-name': {'type': 'string'},
                                                                 'profile-changes': {'items': {'$ref': '#/definitions/ProfileInfoResult'},
                                                                                     'type': 'array'}},
                                                  'required': ['instance-id',
                                                               'model-name',
                                                               'profile-changes',
                                                               'current-profiles',
                                                               'error'],
                                                  'type': 'object'},
                     'ContainerTypeResult': {'additionalProperties': False,
                                             'properties': {'container-type': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'}},
                                             'required': ['container-type',
                                                          'error'],
                                             'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ProfileInfoResult': {'additionalProperties': False,
                                           'properties': {'application-name': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'profile': {'$ref': '#/definitions/CharmLXDProfile'},
                                                          'revision': {'type': 'integer'}},
                                           'type': 'object'},
                     'SetProfileArg': {'additionalProperties': False,
                                       'properties': {'entity': {'$ref': '#/definitions/Entity'},
                                                      'profiles': {'items': {'type': 'string'},
                                                                   'type': 'array'}},
                                       'required': ['entity', 'profiles'],
                                       'type': 'object'},
                     'SetProfileArgs': {'additionalProperties': False,
                                        'properties': {'args': {'items': {'$ref': '#/definitions/SetProfileArg'},
                                                                'type': 'array'}},
                                        'required': ['args'],
                                        'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'CharmProfilingInfo': {'description': 'CharmProfilingInfo '
                                                          'returns info to update '
                                                          'lxd profiles on the '
                                                          'machine. If\n'
                                                          'the machine is not '
                                                          'provisioned, no profile '
                                                          'change info will be '
                                                          'returned,\n'
                                                          'nor will an error.',
                                           'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                          'Result': {'$ref': '#/definitions/CharmProfilingInfoResult'}},
                                           'type': 'object'},
                    'ContainerType': {'description': 'ContainerType returns the '
                                                     'container type of a machine.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                     'Result': {'$ref': '#/definitions/ContainerTypeResult'}},
                                      'type': 'object'},
                    'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'SetCharmProfiles': {'description': 'SetCharmProfiles records '
                                                        'the given slice of charm '
                                                        'profile names.',
                                         'properties': {'Params': {'$ref': '#/definitions/SetProfileArgs'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'SetModificationStatus': {'description': 'SetModificationStatus '
                                                             'updates the instance '
                                                             'whilst changes are '
                                                             'occurring. This\n'
                                                             'is different from '
                                                             'SetStatus and '
                                                             'SetInstanceStatus, '
                                                             'by the fact this '
                                                             'holds\n'
                                                             'information about '
                                                             'the ongoing changes '
                                                             'that are happening '
                                                             'to instances.\n'
                                                             'Consider LXD Profile '
                                                             'updates that can '
                                                             'modify a instance, '
                                                             'but may not cause\n'
                                                             'the instance to be '
                                                             'placed into a error '
                                                             'state. This '
                                                             'modification status\n'
                                                             'serves the purpose '
                                                             'of highlighting that '
                                                             'to the operator.\n'
                                                             'Only machine tags '
                                                             'are accepted.',
                                              'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'WatchContainers': {'description': 'WatchContainers starts a '
                                                       'watcher to track '
                                                       'Containers on a given\n'
                                                       'machine.',
                                        'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                       'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                        'type': 'object'},
                    'WatchLXDProfileVerificationNeeded': {'description': 'WatchLXDProfileVerificationNeeded '
                                                                         'starts a '
                                                                         'watcher '
                                                                         'to track '
                                                                         'Applications '
                                                                         'with\n'
                                                                         'LXD '
                                                                         'Profiles.',
                                                          'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                         'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                          'type': 'object'},
                    'WatchMachines': {'description': 'WatchMachines starts a '
                                                     'watcher to track machines.\n'
                                                     'WatchMachines does not '
                                                     'consume the initial event of '
                                                     'the watch response, as\n'
                                                     'that returns the initial set '
                                                     'of machines that are '
                                                     'currently available.',
                                      'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(CharmProfilingInfoResult)
    async def CharmProfilingInfo(self, tag=None):
        '''
        CharmProfilingInfo returns info to update lxd profiles on the machine. If
        the machine is not provisioned, no profile change info will be returned,
        nor will an error.

        tag : str
        Returns -> CharmProfilingInfoResult
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstanceMutater',
                   request='CharmProfilingInfo',
                   version=2,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerTypeResult)
    async def ContainerType(self, tag=None):
        '''
        ContainerType returns the container type of a machine.

        tag : str
        Returns -> ContainerTypeResult
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstanceMutater',
                   request='ContainerType',
                   version=2,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstanceMutater',
                   request='Life',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetCharmProfiles(self, args=None):
        '''
        SetCharmProfiles records the given slice of charm profile names.

        args : typing.Sequence[~SetProfileArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstanceMutater',
                   request='SetCharmProfiles',
                   version=2,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModificationStatus(self, entities=None):
        '''
        SetModificationStatus updates the instance whilst changes are occurring. This
        is different from SetStatus and SetInstanceStatus, by the fact this holds
        information about the ongoing changes that are happening to instances.
        Consider LXD Profile updates that can modify a instance, but may not cause
        the instance to be placed into a error state. This modification status
        serves the purpose of highlighting that to the operator.
        Only machine tags are accepted.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstanceMutater',
                   request='SetModificationStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchContainers(self, tag=None):
        '''
        WatchContainers starts a watcher to track Containers on a given
        machine.

        tag : str
        Returns -> StringsWatchResult
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstanceMutater',
                   request='WatchContainers',
                   version=2,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchLXDProfileVerificationNeeded(self, entities=None):
        '''
        WatchLXDProfileVerificationNeeded starts a watcher to track Applications with
        LXD Profiles.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstanceMutater',
                   request='WatchLXDProfileVerificationNeeded',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchMachines(self):
        '''
        WatchMachines starts a watcher to track machines.
        WatchMachines does not consume the initial event of the watch response, as
        that returns the initial set of machines that are currently available.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='InstanceMutater',
                   request='WatchMachines',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class LeadershipServiceFacade(Type):
    name = 'LeadershipService'
    version = 2
    schema =     {'definitions': {'ApplicationTag': {'additionalProperties': False,
                                        'properties': {'Name': {'type': 'string'}},
                                        'required': ['Name'],
                                        'type': 'object'},
                     'ClaimLeadershipBulkParams': {'additionalProperties': False,
                                                   'properties': {'params': {'items': {'$ref': '#/definitions/ClaimLeadershipParams'},
                                                                             'type': 'array'}},
                                                   'required': ['params'],
                                                   'type': 'object'},
                     'ClaimLeadershipBulkResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                               'type': 'array'}},
                                                    'required': ['results'],
                                                    'type': 'object'},
                     'ClaimLeadershipParams': {'additionalProperties': False,
                                               'properties': {'application-tag': {'type': 'string'},
                                                              'duration': {'type': 'number'},
                                                              'unit-tag': {'type': 'string'}},
                                               'required': ['application-tag',
                                                            'unit-tag',
                                                            'duration'],
                                               'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'}},
     'properties': {'BlockUntilLeadershipReleased': {'description': 'BlockUntilLeadershipReleased '
                                                                    'blocks the '
                                                                    'caller until '
                                                                    'leadership '
                                                                    'is\n'
                                                                    'released for '
                                                                    'the given '
                                                                    'service.',
                                                     'properties': {'Params': {'$ref': '#/definitions/ApplicationTag'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResult'}},
                                                     'type': 'object'},
                    'ClaimLeadership': {'description': 'ClaimLeadership makes a '
                                                       'leadership claim with the '
                                                       'given parameters.',
                                        'properties': {'Params': {'$ref': '#/definitions/ClaimLeadershipBulkParams'},
                                                       'Result': {'$ref': '#/definitions/ClaimLeadershipBulkResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def BlockUntilLeadershipReleased(self, name=None):
        '''
        BlockUntilLeadershipReleased blocks the caller until leadership is
        released for the given service.

        name : str
        Returns -> ErrorResult
        '''
        if name is not None and not isinstance(name, (bytes, str)):
            raise Exception("Expected name to be a str, received: {}".format(type(name)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LeadershipService',
                   request='BlockUntilLeadershipReleased',
                   version=2,
                   params=_params)
        _params['Name'] = name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ClaimLeadershipBulkResults)
    async def ClaimLeadership(self, params=None):
        '''
        ClaimLeadership makes a leadership claim with the given parameters.

        params : typing.Sequence[~ClaimLeadershipParams]
        Returns -> ClaimLeadershipBulkResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LeadershipService',
                   request='ClaimLeadership',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



class MachineManagerFacade(Type):
    name = 'MachineManager'
    version = 2
    schema =     {'definitions': {'AddMachineParams': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'container-type': {'type': 'string'},
                                                         'disks': {'items': {'$ref': '#/definitions/Constraints'},
                                                                   'type': 'array'},
                                                         'hardware-characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                         'instance-id': {'type': 'string'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'nonce': {'type': 'string'},
                                                         'parent-id': {'type': 'string'},
                                                         'placement': {'$ref': '#/definitions/Placement'},
                                                         'series': {'type': 'string'}},
                                          'required': ['series',
                                                       'constraints',
                                                       'jobs',
                                                       'parent-id',
                                                       'container-type',
                                                       'instance-id',
                                                       'nonce',
                                                       'hardware-characteristics',
                                                       'addresses'],
                                          'type': 'object'},
                     'AddMachines': {'additionalProperties': False,
                                     'properties': {'params': {'items': {'$ref': '#/definitions/AddMachineParams'},
                                                               'type': 'array'}},
                                     'required': ['params'],
                                     'type': 'object'},
                     'AddMachinesResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'machine': {'type': 'string'}},
                                           'required': ['machine'],
                                           'type': 'object'},
                     'AddMachinesResults': {'additionalProperties': False,
                                            'properties': {'machines': {'items': {'$ref': '#/definitions/AddMachinesResult'},
                                                                        'type': 'array'}},
                                            'required': ['machines'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'value': {'$ref': '#/definitions/Value'}},
                                                      'type': 'object'},
                     'ModelInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/ModelInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'AddMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                   'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                    'type': 'object'},
                    'InstanceTypes': {'properties': {'Params': {'$ref': '#/definitions/ModelInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddMachinesResults)
    async def AddMachines(self, params=None):
        '''
        params : typing.Sequence[~AddMachineParams]
        Returns -> AddMachinesResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='AddMachines',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints=None):
        '''
        constraints : typing.Sequence[~ModelInstanceTypesConstraint]
        Returns -> InstanceTypesResults
        '''
        if constraints is not None and not isinstance(constraints, (bytes, str, list)):
            raise Exception("Expected constraints to be a Sequence, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineManager',
                   request='InstanceTypes',
                   version=2,
                   params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



class MachinerFacade(Type):
    name = 'Machiner'
    version = 2
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'JobsResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'jobs': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['jobs'],
                                    'type': 'object'},
                     'JobsResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/JobsResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'MachineAddresses': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'addresses'],
                                          'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                    'type': 'array'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'is-default-gateway': {'type': 'boolean'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'origin': {'type': 'string'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-network-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'shadow-addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                           'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-network-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetMachineNetworkConfig': {'additionalProperties': False,
                                                 'properties': {'config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                           'type': 'array'},
                                                                'tag': {'type': 'string'}},
                                                 'required': ['tag', 'config'],
                                                 'type': 'object'},
                     'SetMachinesAddresses': {'additionalProperties': False,
                                              'properties': {'machine-addresses': {'items': {'$ref': '#/definitions/MachineAddresses'},
                                                                                   'type': 'array'}},
                                              'required': ['machine-addresses'],
                                              'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'Jobs': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/JobsResults'}},
                             'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'RecordAgentStartTime': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'SetMachineAddresses': {'properties': {'Params': {'$ref': '#/definitions/SetMachinesAddresses'},
                                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                                            'type': 'object'},
                    'SetObservedNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                 'type': 'object'},
                    'SetProviderNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'Watch': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='APIAddresses',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='APIHostPorts',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='EnsureDead',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(JobsResults)
    async def Jobs(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> JobsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='Jobs',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='Life',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='ModelUUID',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RecordAgentStartTime(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='RecordAgentStartTime',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMachineAddresses(self, machine_addresses=None):
        '''
        machine_addresses : typing.Sequence[~MachineAddresses]
        Returns -> ErrorResults
        '''
        if machine_addresses is not None and not isinstance(machine_addresses, (bytes, str, list)):
            raise Exception("Expected machine_addresses to be a Sequence, received: {}".format(type(machine_addresses)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetMachineAddresses',
                   version=2,
                   params=_params)
        _params['machine-addresses'] = machine_addresses
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetObservedNetworkConfig(self, config=None, tag=None):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetObservedNetworkConfig',
                   version=2,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetProviderNetworkConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetProviderNetworkConfig',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='UpdateStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='Watch',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='WatchAPIHostPorts',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class MeterStatusFacade(Type):
    name = 'MeterStatus'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'MeterStatusResult': {'additionalProperties': False,
                                           'properties': {'code': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'type': 'string'}},
                                           'required': ['code', 'info'],
                                           'type': 'object'},
                     'MeterStatusResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/MeterStatusResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetUnitStateArg': {'additionalProperties': False,
                                         'properties': {'charm-state': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                        'meter-status-state': {'type': 'string'},
                                                        'relation-state': {'patternProperties': {'.*': {'type': 'string'}},
                                                                           'type': 'object'},
                                                        'storage-state': {'type': 'string'},
                                                        'tag': {'type': 'string'},
                                                        'uniter-state': {'type': 'string'}},
                                         'required': ['tag'],
                                         'type': 'object'},
                     'SetUnitStateArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/SetUnitStateArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'UnitStateResult': {'additionalProperties': False,
                                         'properties': {'charm-state': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                        'error': {'$ref': '#/definitions/Error'},
                                                        'meter-status-state': {'type': 'string'},
                                                        'relation-state': {'patternProperties': {'.*': {'type': 'string'}},
                                                                           'type': 'object'},
                                                        'storage-state': {'type': 'string'},
                                                        'uniter-state': {'type': 'string'}},
                                         'type': 'object'},
                     'UnitStateResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/UnitStateResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'}},
     'properties': {'GetMeterStatus': {'description': 'GetMeterStatus returns '
                                                      'meter status information '
                                                      'for each unit.',
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/MeterStatusResults'}},
                                       'type': 'object'},
                    'SetState': {'description': 'SetState sets the state persisted '
                                                'by the charm running in this '
                                                'unit\n'
                                                'and the state internal to the '
                                                'uniter for this unit.',
                                 'properties': {'Params': {'$ref': '#/definitions/SetUnitStateArgs'},
                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                 'type': 'object'},
                    'State': {'description': 'State returns the state persisted by '
                                             'the charm running in this unit\n'
                                             'and the state internal to the uniter '
                                             'for this unit.',
                              'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/UnitStateResults'}},
                              'type': 'object'},
                    'WatchMeterStatus': {'description': 'WatchMeterStatus returns '
                                                        'a NotifyWatcher for '
                                                        'observing changes\n'
                                                        "to each unit's meter "
                                                        'status.',
                                         'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MeterStatusResults)
    async def GetMeterStatus(self, entities=None):
        '''
        GetMeterStatus returns meter status information for each unit.

        entities : typing.Sequence[~Entity]
        Returns -> MeterStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MeterStatus',
                   request='GetMeterStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetState(self, args=None):
        '''
        SetState sets the state persisted by the charm running in this unit
        and the state internal to the uniter for this unit.

        args : typing.Sequence[~SetUnitStateArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MeterStatus',
                   request='SetState',
                   version=2,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UnitStateResults)
    async def State(self, entities=None):
        '''
        State returns the state persisted by the charm running in this unit
        and the state internal to the uniter for this unit.

        entities : typing.Sequence[~Entity]
        Returns -> UnitStateResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MeterStatus',
                   request='State',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMeterStatus(self, entities=None):
        '''
        WatchMeterStatus returns a NotifyWatcher for observing changes
        to each unit's meter status.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MeterStatus',
                   request='WatchMeterStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MetricsAdderFacade(Type):
    name = 'MetricsAdder'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Metric': {'additionalProperties': False,
                                'properties': {'key': {'type': 'string'},
                                               'labels': {'patternProperties': {'.*': {'type': 'string'}},
                                                          'type': 'object'},
                                               'time': {'format': 'date-time',
                                                        'type': 'string'},
                                               'value': {'type': 'string'}},
                                'required': ['key', 'value', 'time'],
                                'type': 'object'},
                     'MetricBatch': {'additionalProperties': False,
                                     'properties': {'charm-url': {'type': 'string'},
                                                    'created': {'format': 'date-time',
                                                                'type': 'string'},
                                                    'metrics': {'items': {'$ref': '#/definitions/Metric'},
                                                                'type': 'array'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['uuid',
                                                  'charm-url',
                                                  'created',
                                                  'metrics'],
                                     'type': 'object'},
                     'MetricBatchParam': {'additionalProperties': False,
                                          'properties': {'batch': {'$ref': '#/definitions/MetricBatch'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'batch'],
                                          'type': 'object'},
                     'MetricBatchParams': {'additionalProperties': False,
                                           'properties': {'batches': {'items': {'$ref': '#/definitions/MetricBatchParam'},
                                                                      'type': 'array'}},
                                           'required': ['batches'],
                                           'type': 'object'}},
     'properties': {'AddMetricBatches': {'description': 'AddMetricBatches '
                                                        'implements the '
                                                        'MetricsAdder interface.',
                                         'properties': {'Params': {'$ref': '#/definitions/MetricBatchParams'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddMetricBatches(self, batches=None):
        '''
        AddMetricBatches implements the MetricsAdder interface.

        batches : typing.Sequence[~MetricBatchParam]
        Returns -> ErrorResults
        '''
        if batches is not None and not isinstance(batches, (bytes, str, list)):
            raise Exception("Expected batches to be a Sequence, received: {}".format(type(batches)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsAdder',
                   request='AddMetricBatches',
                   version=2,
                   params=_params)
        _params['batches'] = batches
        reply = await self.rpc(msg)
        return reply



class MetricsDebugFacade(Type):
    name = 'MetricsDebug'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityMetrics': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'metrics': {'items': {'$ref': '#/definitions/MetricResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'MeterStatusParam': {'additionalProperties': False,
                                          'properties': {'code': {'type': 'string'},
                                                         'info': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'code'],
                                          'type': 'object'},
                     'MeterStatusParams': {'additionalProperties': False,
                                           'properties': {'statues': {'items': {'$ref': '#/definitions/MeterStatusParam'},
                                                                      'type': 'array'}},
                                           'required': ['statues'],
                                           'type': 'object'},
                     'MetricResult': {'additionalProperties': False,
                                      'properties': {'key': {'type': 'string'},
                                                     'labels': {'patternProperties': {'.*': {'type': 'string'}},
                                                                'type': 'object'},
                                                     'time': {'format': 'date-time',
                                                              'type': 'string'},
                                                     'unit': {'type': 'string'},
                                                     'value': {'type': 'string'}},
                                      'required': ['time',
                                                   'key',
                                                   'value',
                                                   'unit',
                                                   'labels'],
                                      'type': 'object'},
                     'MetricResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/EntityMetrics'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'}},
     'properties': {'GetMetrics': {'description': 'GetMetrics returns all metrics '
                                                  'stored by the state server.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/MetricResults'}},
                                   'type': 'object'},
                    'SetMeterStatus': {'description': 'SetMeterStatus sets meter '
                                                      'statuses for entities.',
                                       'properties': {'Params': {'$ref': '#/definitions/MeterStatusParams'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MetricResults)
    async def GetMetrics(self, entities=None):
        '''
        GetMetrics returns all metrics stored by the state server.

        entities : typing.Sequence[~Entity]
        Returns -> MetricResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsDebug',
                   request='GetMetrics',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMeterStatus(self, statues=None):
        '''
        SetMeterStatus sets meter statuses for entities.

        statues : typing.Sequence[~MeterStatusParam]
        Returns -> ErrorResults
        '''
        if statues is not None and not isinstance(statues, (bytes, str, list)):
            raise Exception("Expected statues to be a Sequence, received: {}".format(type(statues)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsDebug',
                   request='SetMeterStatus',
                   version=2,
                   params=_params)
        _params['statues'] = statues
        reply = await self.rpc(msg)
        return reply



class MigrationMasterFacade(Type):
    name = 'MigrationMaster'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'MasterMigrationStatus': {'additionalProperties': False,
                                               'properties': {'migration-id': {'type': 'string'},
                                                              'phase': {'type': 'string'},
                                                              'phase-changed-time': {'format': 'date-time',
                                                                                     'type': 'string'},
                                                              'spec': {'$ref': '#/definitions/MigrationSpec'}},
                                               'required': ['spec',
                                                            'migration-id',
                                                            'phase',
                                                            'phase-changed-time'],
                                               'type': 'object'},
                     'MigrationModelInfo': {'additionalProperties': False,
                                            'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                           'controller-agent-version': {'$ref': '#/definitions/Number'},
                                                           'name': {'type': 'string'},
                                                           'owner-tag': {'type': 'string'},
                                                           'uuid': {'type': 'string'}},
                                            'required': ['uuid',
                                                         'name',
                                                         'owner-tag',
                                                         'agent-version',
                                                         'controller-agent-version'],
                                            'type': 'object'},
                     'MigrationSpec': {'additionalProperties': False,
                                       'properties': {'model-tag': {'type': 'string'},
                                                      'target-info': {'$ref': '#/definitions/MigrationTargetInfo'}},
                                       'required': ['model-tag', 'target-info'],
                                       'type': 'object'},
                     'MigrationTargetInfo': {'additionalProperties': False,
                                             'properties': {'addrs': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                            'auth-tag': {'type': 'string'},
                                                            'ca-cert': {'type': 'string'},
                                                            'controller-alias': {'type': 'string'},
                                                            'controller-tag': {'type': 'string'},
                                                            'macaroons': {'type': 'string'},
                                                            'password': {'type': 'string'}},
                                             'required': ['controller-tag',
                                                          'addrs',
                                                          'ca-cert',
                                                          'auth-tag'],
                                             'type': 'object'},
                     'MinionReports': {'additionalProperties': False,
                                       'properties': {'failed': {'items': {'type': 'string'},
                                                                 'type': 'array'},
                                                      'migration-id': {'type': 'string'},
                                                      'phase': {'type': 'string'},
                                                      'success-count': {'type': 'integer'},
                                                      'unknown-count': {'type': 'integer'},
                                                      'unknown-sample': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                       'required': ['migration-id',
                                                    'phase',
                                                    'success-count',
                                                    'unknown-count',
                                                    'unknown-sample',
                                                    'failed'],
                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'ProcessRelations': {'additionalProperties': False,
                                          'properties': {'controller-alias': {'type': 'string'}},
                                          'required': ['controller-alias'],
                                          'type': 'object'},
                     'SerializedModel': {'additionalProperties': False,
                                         'properties': {'bytes': {'items': {'type': 'integer'},
                                                                  'type': 'array'},
                                                        'charms': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                        'resources': {'items': {'$ref': '#/definitions/SerializedModelResource'},
                                                                      'type': 'array'},
                                                        'tools': {'items': {'$ref': '#/definitions/SerializedModelTools'},
                                                                  'type': 'array'}},
                                         'required': ['bytes',
                                                      'charms',
                                                      'tools',
                                                      'resources'],
                                         'type': 'object'},
                     'SerializedModelResource': {'additionalProperties': False,
                                                 'properties': {'application': {'type': 'string'},
                                                                'application-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'charmstore-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'name': {'type': 'string'},
                                                                'unit-revisions': {'patternProperties': {'.*': {'$ref': '#/definitions/SerializedModelResourceRevision'}},
                                                                                   'type': 'object'}},
                                                 'required': ['application',
                                                              'name',
                                                              'application-revision',
                                                              'charmstore-revision',
                                                              'unit-revisions'],
                                                 'type': 'object'},
                     'SerializedModelResourceRevision': {'additionalProperties': False,
                                                         'properties': {'description': {'type': 'string'},
                                                                        'fingerprint': {'type': 'string'},
                                                                        'origin': {'type': 'string'},
                                                                        'path': {'type': 'string'},
                                                                        'revision': {'type': 'integer'},
                                                                        'size': {'type': 'integer'},
                                                                        'timestamp': {'format': 'date-time',
                                                                                      'type': 'string'},
                                                                        'type': {'type': 'string'},
                                                                        'username': {'type': 'string'}},
                                                         'required': ['revision',
                                                                      'type',
                                                                      'path',
                                                                      'description',
                                                                      'origin',
                                                                      'fingerprint',
                                                                      'size',
                                                                      'timestamp'],
                                                         'type': 'object'},
                     'SerializedModelTools': {'additionalProperties': False,
                                              'properties': {'uri': {'type': 'string'},
                                                             'version': {'type': 'string'}},
                                              'required': ['version', 'uri'],
                                              'type': 'object'},
                     'SetMigrationPhaseArgs': {'additionalProperties': False,
                                               'properties': {'phase': {'type': 'string'}},
                                               'required': ['phase'],
                                               'type': 'object'},
                     'SetMigrationStatusMessageArgs': {'additionalProperties': False,
                                                       'properties': {'message': {'type': 'string'}},
                                                       'required': ['message'],
                                                       'type': 'object'}},
     'properties': {'Export': {'description': 'Export serializes the model '
                                              'associated with the API connection.',
                               'properties': {'Result': {'$ref': '#/definitions/SerializedModel'}},
                               'type': 'object'},
                    'MigrationStatus': {'description': 'MigrationStatus returns '
                                                       'the details and progress '
                                                       'of the latest\n'
                                                       'model migration.',
                                        'properties': {'Result': {'$ref': '#/definitions/MasterMigrationStatus'}},
                                        'type': 'object'},
                    'MinionReports': {'description': 'MinionReports returns '
                                                     'details of the reports made '
                                                     'by migration\n'
                                                     'minions to the controller '
                                                     'for the current migration '
                                                     'phase.',
                                      'properties': {'Result': {'$ref': '#/definitions/MinionReports'}},
                                      'type': 'object'},
                    'ModelInfo': {'description': 'ModelInfo returns essential '
                                                 'information about the model to '
                                                 'be\n'
                                                 'migrated.',
                                  'properties': {'Result': {'$ref': '#/definitions/MigrationModelInfo'}},
                                  'type': 'object'},
                    'Prechecks': {'description': 'Prechecks performs pre-migration '
                                                 'checks on the model and\n'
                                                 '(source) controller.',
                                  'type': 'object'},
                    'ProcessRelations': {'description': 'ProcessRelations '
                                                        'processes any relations '
                                                        'that need updating after '
                                                        'an export.\n'
                                                        'This should help fix any '
                                                        'remoteApplications that '
                                                        'have been migrated.',
                                         'properties': {'Params': {'$ref': '#/definitions/ProcessRelations'}},
                                         'type': 'object'},
                    'Reap': {'description': 'Reap removes all documents for the '
                                            'model associated with the API\n'
                                            'connection.',
                             'type': 'object'},
                    'SetPhase': {'description': 'SetPhase sets the phase of the '
                                                'active model migration. The '
                                                'provided\n'
                                                'phase must be a valid phase '
                                                'value, for example QUIESCE" or\n'
                                                '"ABORT". See the core/migration '
                                                'package for the complete list.',
                                 'properties': {'Params': {'$ref': '#/definitions/SetMigrationPhaseArgs'}},
                                 'type': 'object'},
                    'SetStatusMessage': {'description': 'SetStatusMessage sets a '
                                                        'human readable status '
                                                        'message containing\n'
                                                        'information about the '
                                                        "migration's progress. "
                                                        'This will be shown in\n'
                                                        'status output shown to '
                                                        'the end user.',
                                         'properties': {'Params': {'$ref': '#/definitions/SetMigrationStatusMessageArgs'}},
                                         'type': 'object'},
                    'Watch': {'description': 'Watch starts watching for an active '
                                             'migration for the model\n'
                                             'associated with the API connection. '
                                             'The returned id should be used\n'
                                             'with the NotifyWatcher facade to '
                                             'receive events.',
                              'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                              'type': 'object'},
                    'WatchMinionReports': {'description': 'WatchMinionReports sets '
                                                          'up a watcher which '
                                                          'reports when a report\n'
                                                          'for a migration minion '
                                                          'has arrived.',
                                           'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(SerializedModel)
    async def Export(self):
        '''
        Export serializes the model associated with the API connection.


        Returns -> SerializedModel
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='Export',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MasterMigrationStatus)
    async def MigrationStatus(self):
        '''
        MigrationStatus returns the details and progress of the latest
        model migration.


        Returns -> MasterMigrationStatus
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='MigrationStatus',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MinionReports)
    async def MinionReports(self):
        '''
        MinionReports returns details of the reports made by migration
        minions to the controller for the current migration phase.


        Returns -> MinionReports
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='MinionReports',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MigrationModelInfo)
    async def ModelInfo(self):
        '''
        ModelInfo returns essential information about the model to be
        migrated.


        Returns -> MigrationModelInfo
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='ModelInfo',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Prechecks(self):
        '''
        Prechecks performs pre-migration checks on the model and
        (source) controller.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='Prechecks',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ProcessRelations(self, controller_alias=None):
        '''
        ProcessRelations processes any relations that need updating after an export.
        This should help fix any remoteApplications that have been migrated.

        controller_alias : str
        Returns -> None
        '''
        if controller_alias is not None and not isinstance(controller_alias, (bytes, str)):
            raise Exception("Expected controller_alias to be a str, received: {}".format(type(controller_alias)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='ProcessRelations',
                   version=2,
                   params=_params)
        _params['controller-alias'] = controller_alias
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Reap(self):
        '''
        Reap removes all documents for the model associated with the API
        connection.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='Reap',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetPhase(self, phase=None):
        '''
        SetPhase sets the phase of the active model migration. The provided
        phase must be a valid phase value, for example QUIESCE" or
        "ABORT". See the core/migration package for the complete list.

        phase : str
        Returns -> None
        '''
        if phase is not None and not isinstance(phase, (bytes, str)):
            raise Exception("Expected phase to be a str, received: {}".format(type(phase)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='SetPhase',
                   version=2,
                   params=_params)
        _params['phase'] = phase
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetStatusMessage(self, message=None):
        '''
        SetStatusMessage sets a human readable status message containing
        information about the migration's progress. This will be shown in
        status output shown to the end user.

        message : str
        Returns -> None
        '''
        if message is not None and not isinstance(message, (bytes, str)):
            raise Exception("Expected message to be a str, received: {}".format(type(message)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='SetStatusMessage',
                   version=2,
                   params=_params)
        _params['message'] = message
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def Watch(self):
        '''
        Watch starts watching for an active migration for the model
        associated with the API connection. The returned id should be used
        with the NotifyWatcher facade to receive events.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='Watch',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchMinionReports(self):
        '''
        WatchMinionReports sets up a watcher which reports when a report
        for a migration minion has arrived.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='WatchMinionReports',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ModelConfigFacade(Type):
    name = 'ModelConfig'
    version = 2
    schema =     {'definitions': {'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelSLA': {'additionalProperties': False,
                                  'properties': {'ModelSLAInfo': {'$ref': '#/definitions/ModelSLAInfo'},
                                                 'creds': {'items': {'type': 'integer'},
                                                           'type': 'array'},
                                                 'level': {'type': 'string'},
                                                 'owner': {'type': 'string'}},
                                  'required': ['level',
                                               'owner',
                                               'ModelSLAInfo',
                                               'creds'],
                                  'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelSequencesResult': {'additionalProperties': False,
                                              'properties': {'sequences': {'patternProperties': {'.*': {'type': 'integer'}},
                                                                           'type': 'object'}},
                                              'required': ['sequences'],
                                              'type': 'object'},
                     'ModelSet': {'additionalProperties': False,
                                  'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                         'type': 'object'}},
                                                            'type': 'object'}},
                                  'required': ['config'],
                                  'type': 'object'},
                     'ModelUnset': {'additionalProperties': False,
                                    'properties': {'keys': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['keys'],
                                    'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'}},
     'properties': {'ModelGet': {'description': 'ModelGet implements the '
                                                'server-side part of the\n'
                                                'model-config CLI command.',
                                 'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                 'type': 'object'},
                    'ModelSet': {'description': 'ModelSet implements the '
                                                'server-side part of the\n'
                                                'set-model-config CLI command.',
                                 'properties': {'Params': {'$ref': '#/definitions/ModelSet'}},
                                 'type': 'object'},
                    'ModelUnset': {'description': 'ModelUnset implements the '
                                                  'server-side part of the\n'
                                                  'set-model-config CLI command.',
                                   'properties': {'Params': {'$ref': '#/definitions/ModelUnset'}},
                                   'type': 'object'},
                    'SLALevel': {'description': 'SLALevel returns the current sla '
                                                'level for the model.',
                                 'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                 'type': 'object'},
                    'Sequences': {'description': "Sequences returns the model's "
                                                 'sequence names and next values.',
                                  'properties': {'Result': {'$ref': '#/definitions/ModelSequencesResult'}},
                                  'type': 'object'},
                    'SetSLALevel': {'description': 'SetSLALevel sets the sla level '
                                                   'on the model.',
                                    'properties': {'Params': {'$ref': '#/definitions/ModelSLA'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResults)
    async def ModelGet(self):
        '''
        ModelGet implements the server-side part of the
        model-config CLI command.


        Returns -> ModelConfigResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='ModelGet',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelSet(self, config=None):
        '''
        ModelSet implements the server-side part of the
        set-model-config CLI command.

        config : typing.Mapping[str, typing.Any]
        Returns -> None
        '''
        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='ModelSet',
                   version=2,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelUnset(self, keys=None):
        '''
        ModelUnset implements the server-side part of the
        set-model-config CLI command.

        keys : typing.Sequence[str]
        Returns -> None
        '''
        if keys is not None and not isinstance(keys, (bytes, str, list)):
            raise Exception("Expected keys to be a Sequence, received: {}".format(type(keys)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='ModelUnset',
                   version=2,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def SLALevel(self):
        '''
        SLALevel returns the current sla level for the model.


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='SLALevel',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelSequencesResult)
    async def Sequences(self):
        '''
        Sequences returns the model's sequence names and next values.


        Returns -> ModelSequencesResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='Sequences',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetSLALevel(self, modelslainfo=None, creds=None, level=None, owner=None):
        '''
        SetSLALevel sets the sla level on the model.

        modelslainfo : ModelSLAInfo
        creds : typing.Sequence[int]
        level : str
        owner : str
        Returns -> None
        '''
        if modelslainfo is not None and not isinstance(modelslainfo, (dict, ModelSLAInfo)):
            raise Exception("Expected modelslainfo to be a ModelSLAInfo, received: {}".format(type(modelslainfo)))

        if creds is not None and not isinstance(creds, (bytes, str, list)):
            raise Exception("Expected creds to be a Sequence, received: {}".format(type(creds)))

        if level is not None and not isinstance(level, (bytes, str)):
            raise Exception("Expected level to be a str, received: {}".format(type(level)))

        if owner is not None and not isinstance(owner, (bytes, str)):
            raise Exception("Expected owner to be a str, received: {}".format(type(owner)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='SetSLALevel',
                   version=2,
                   params=_params)
        _params['ModelSLAInfo'] = modelslainfo
        _params['creds'] = creds
        _params['level'] = level
        _params['owner'] = owner
        reply = await self.rpc(msg)
        return reply



class ModelGenerationFacade(Type):
    name = 'ModelGeneration'
    version = 2
    schema =     {'definitions': {'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BranchArg': {'additionalProperties': False,
                                   'properties': {'branch': {'type': 'string'}},
                                   'required': ['branch'],
                                   'type': 'object'},
                     'BranchInfoArgs': {'additionalProperties': False,
                                        'properties': {'branches': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                       'detailed': {'type': 'boolean'}},
                                        'required': ['branches', 'detailed'],
                                        'type': 'object'},
                     'BranchTrackArg': {'additionalProperties': False,
                                        'properties': {'branch': {'type': 'string'},
                                                       'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                    'type': 'array'}},
                                        'required': ['branch', 'entities'],
                                        'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Generation': {'additionalProperties': False,
                                    'properties': {'applications': {'items': {'$ref': '#/definitions/GenerationApplication'},
                                                                    'type': 'array'},
                                                   'branch': {'type': 'string'},
                                                   'created': {'type': 'integer'},
                                                   'created-by': {'type': 'string'}},
                                    'required': ['branch',
                                                 'created',
                                                 'created-by',
                                                 'applications'],
                                    'type': 'object'},
                     'GenerationApplication': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'pending': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                              'progress': {'type': 'string'},
                                                              'tracking': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                               'required': ['application',
                                                            'progress',
                                                            'config'],
                                               'type': 'object'},
                     'GenerationResults': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'generations': {'items': {'$ref': '#/definitions/Generation'},
                                                                          'type': 'array'}},
                                           'required': ['generations'],
                                           'type': 'object'},
                     'IntResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'type': 'integer'}},
                                   'required': ['result'],
                                   'type': 'object'}},
     'properties': {'AbortBranch': {'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                   'Result': {'$ref': '#/definitions/ErrorResult'}},
                                    'type': 'object'},
                    'AddBranch': {'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                 'Result': {'$ref': '#/definitions/ErrorResult'}},
                                  'type': 'object'},
                    'BranchInfo': {'properties': {'Params': {'$ref': '#/definitions/BranchInfoArgs'},
                                                  'Result': {'$ref': '#/definitions/GenerationResults'}},
                                   'type': 'object'},
                    'CommitBranch': {'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                    'Result': {'$ref': '#/definitions/IntResult'}},
                                     'type': 'object'},
                    'HasActiveBranch': {'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                       'Result': {'$ref': '#/definitions/BoolResult'}},
                                        'type': 'object'},
                    'TrackBranch': {'properties': {'Params': {'$ref': '#/definitions/BranchTrackArg'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def AbortBranch(self, branch=None):
        '''
        branch : str
        Returns -> ErrorResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='AbortBranch',
                   version=2,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResult)
    async def AddBranch(self, branch=None):
        '''
        branch : str
        Returns -> ErrorResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='AddBranch',
                   version=2,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GenerationResults)
    async def BranchInfo(self, branches=None, detailed=None):
        '''
        branches : typing.Sequence[str]
        detailed : bool
        Returns -> GenerationResults
        '''
        if branches is not None and not isinstance(branches, (bytes, str, list)):
            raise Exception("Expected branches to be a Sequence, received: {}".format(type(branches)))

        if detailed is not None and not isinstance(detailed, bool):
            raise Exception("Expected detailed to be a bool, received: {}".format(type(detailed)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='BranchInfo',
                   version=2,
                   params=_params)
        _params['branches'] = branches
        _params['detailed'] = detailed
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IntResult)
    async def CommitBranch(self, branch=None):
        '''
        branch : str
        Returns -> IntResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='CommitBranch',
                   version=2,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResult)
    async def HasActiveBranch(self, branch=None):
        '''
        branch : str
        Returns -> BoolResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='HasActiveBranch',
                   version=2,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def TrackBranch(self, branch=None, entities=None):
        '''
        branch : str
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='TrackBranch',
                   version=2,
                   params=_params)
        _params['branch'] = branch
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class ModelManagerFacade(Type):
    name = 'ModelManager'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MapResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                          'type': 'object'}},
                                                             'type': 'object'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'MapResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/MapResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'Model': {'additionalProperties': False,
                               'properties': {'name': {'type': 'string'},
                                              'owner-tag': {'type': 'string'},
                                              'uuid': {'type': 'string'}},
                               'required': ['name', 'uuid', 'owner-tag'],
                               'type': 'object'},
                     'ModelCreateArgs': {'additionalProperties': False,
                                         'properties': {'cloud-tag': {'type': 'string'},
                                                        'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                'type': 'object'}},
                                                                   'type': 'object'},
                                                        'credential': {'type': 'string'},
                                                        'name': {'type': 'string'},
                                                        'owner-tag': {'type': 'string'},
                                                        'region': {'type': 'string'}},
                                         'required': ['name', 'owner-tag'],
                                         'type': 'object'},
                     'ModelDefaultValues': {'additionalProperties': False,
                                            'properties': {'cloud-region': {'type': 'string'},
                                                           'cloud-tag': {'type': 'string'},
                                                           'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                   'type': 'object'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelDefaults': {'additionalProperties': False,
                                       'properties': {'controller': {'additionalProperties': True,
                                                                     'type': 'object'},
                                                      'default': {'additionalProperties': True,
                                                                  'type': 'object'},
                                                      'regions': {'items': {'$ref': '#/definitions/RegionDefaults'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ModelDefaultsResult': {'additionalProperties': False,
                                             'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ModelDefaults'}},
                                                                       'type': 'object'}},
                                             'required': ['config'],
                                             'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'uuid',
                                                'controller-uuid',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelInfoResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/ModelInfo'}},
                                         'type': 'object'},
                     'ModelInfoResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/ModelInfoResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelStatus': {'additionalProperties': False,
                                     'properties': {'application-count': {'type': 'integer'},
                                                    'hosted-machine-count': {'type': 'integer'},
                                                    'life': {'type': 'string'},
                                                    'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                                 'type': 'array'},
                                                    'model-tag': {'type': 'string'},
                                                    'owner-tag': {'type': 'string'}},
                                     'required': ['model-tag',
                                                  'life',
                                                  'hosted-machine-count',
                                                  'application-count',
                                                  'owner-tag'],
                                     'type': 'object'},
                     'ModelStatusResults': {'additionalProperties': False,
                                            'properties': {'models': {'items': {'$ref': '#/definitions/ModelStatus'},
                                                                      'type': 'array'}},
                                            'required': ['models'],
                                            'type': 'object'},
                     'ModelUnsetKeys': {'additionalProperties': False,
                                        'properties': {'cloud-region': {'type': 'string'},
                                                       'cloud-tag': {'type': 'string'},
                                                       'keys': {'items': {'type': 'string'},
                                                                'type': 'array'}},
                                        'required': ['keys'],
                                        'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModifyModelAccess': {'additionalProperties': False,
                                           'properties': {'access': {'type': 'string'},
                                                          'action': {'type': 'string'},
                                                          'model-tag': {'type': 'string'},
                                                          'user-tag': {'type': 'string'}},
                                           'required': ['user-tag',
                                                        'action',
                                                        'access',
                                                        'model-tag'],
                                           'type': 'object'},
                     'ModifyModelAccessRequest': {'additionalProperties': False,
                                                  'properties': {'changes': {'items': {'$ref': '#/definitions/ModifyModelAccess'},
                                                                             'type': 'array'}},
                                                  'required': ['changes'],
                                                  'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RegionDefaults': {'additionalProperties': False,
                                        'properties': {'region-name': {'type': 'string'},
                                                       'value': {'additionalProperties': True,
                                                                 'type': 'object'}},
                                        'required': ['region-name', 'value'],
                                        'type': 'object'},
                     'SetModelDefaults': {'additionalProperties': False,
                                          'properties': {'config': {'items': {'$ref': '#/definitions/ModelDefaultValues'},
                                                                    'type': 'array'}},
                                          'required': ['config'],
                                          'type': 'object'},
                     'UnsetModelDefaults': {'additionalProperties': False,
                                            'properties': {'keys': {'items': {'$ref': '#/definitions/ModelUnsetKeys'},
                                                                    'type': 'array'}},
                                            'required': ['keys'],
                                            'type': 'object'},
                     'UserModel': {'additionalProperties': False,
                                   'properties': {'last-connection': {'format': 'date-time',
                                                                      'type': 'string'},
                                                  'model': {'$ref': '#/definitions/Model'}},
                                   'required': ['model', 'last-connection'],
                                   'type': 'object'},
                     'UserModelList': {'additionalProperties': False,
                                       'properties': {'user-models': {'items': {'$ref': '#/definitions/UserModel'},
                                                                      'type': 'array'}},
                                       'required': ['user-models'],
                                       'type': 'object'}},
     'properties': {'CreateModel': {'properties': {'Params': {'$ref': '#/definitions/ModelCreateArgs'},
                                                   'Result': {'$ref': '#/definitions/ModelInfo'}},
                                    'type': 'object'},
                    'DestroyModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'DumpModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/MapResults'}},
                                   'type': 'object'},
                    'DumpModelsDB': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/MapResults'}},
                                     'type': 'object'},
                    'ListModels': {'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                  'Result': {'$ref': '#/definitions/UserModelList'}},
                                   'type': 'object'},
                    'ModelDefaults': {'properties': {'Result': {'$ref': '#/definitions/ModelDefaultsResult'}},
                                      'type': 'object'},
                    'ModelInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ModelInfoResults'}},
                                  'type': 'object'},
                    'ModelStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ModelStatusResults'}},
                                    'type': 'object'},
                    'ModifyModelAccess': {'properties': {'Params': {'$ref': '#/definitions/ModifyModelAccessRequest'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/SetModelDefaults'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'UnsetModelDefaults': {'properties': {'Params': {'$ref': '#/definitions/UnsetModelDefaults'},
                                                          'Result': {'$ref': '#/definitions/ErrorResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelInfo)
    async def CreateModel(self, cloud_tag=None, config=None, credential=None, name=None, owner_tag=None, region=None):
        '''
        cloud_tag : str
        config : typing.Mapping[str, typing.Any]
        credential : str
        name : str
        owner_tag : str
        region : str
        Returns -> ModelInfo
        '''
        if cloud_tag is not None and not isinstance(cloud_tag, (bytes, str)):
            raise Exception("Expected cloud_tag to be a str, received: {}".format(type(cloud_tag)))

        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        if credential is not None and not isinstance(credential, (bytes, str)):
            raise Exception("Expected credential to be a str, received: {}".format(type(credential)))

        if name is not None and not isinstance(name, (bytes, str)):
            raise Exception("Expected name to be a str, received: {}".format(type(name)))

        if owner_tag is not None and not isinstance(owner_tag, (bytes, str)):
            raise Exception("Expected owner_tag to be a str, received: {}".format(type(owner_tag)))

        if region is not None and not isinstance(region, (bytes, str)):
            raise Exception("Expected region to be a str, received: {}".format(type(region)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='CreateModel',
                   version=2,
                   params=_params)
        _params['cloud-tag'] = cloud_tag
        _params['config'] = config
        _params['credential'] = credential
        _params['name'] = name
        _params['owner-tag'] = owner_tag
        _params['region'] = region
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyModels(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DestroyModels',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MapResults)
    async def DumpModels(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MapResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModels',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MapResults)
    async def DumpModelsDB(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MapResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='DumpModelsDB',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserModelList)
    async def ListModels(self, tag=None):
        '''
        tag : str
        Returns -> UserModelList
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ListModels',
                   version=2,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelDefaultsResult)
    async def ModelDefaults(self):
        '''

        Returns -> ModelDefaultsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelDefaults',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfoResults)
    async def ModelInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ModelInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelInfo',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelStatusResults)
    async def ModelStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ModelStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModelStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ModifyModelAccess(self, changes=None):
        '''
        changes : typing.Sequence[~ModifyModelAccess]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='ModifyModelAccess',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModelDefaults(self, config=None):
        '''
        config : typing.Sequence[~ModelDefaultValues]
        Returns -> ErrorResults
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='SetModelDefaults',
                   version=2,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UnsetModelDefaults(self, keys=None):
        '''
        keys : typing.Sequence[~ModelUnsetKeys]
        Returns -> ErrorResults
        '''
        if keys is not None and not isinstance(keys, (bytes, str, list)):
            raise Exception("Expected keys to be a Sequence, received: {}".format(type(keys)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelManager',
                   request='UnsetModelDefaults',
                   version=2,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



class ProxyUpdaterFacade(Type):
    name = 'ProxyUpdater'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ProxyConfig': {'additionalProperties': False,
                                     'properties': {'ftp': {'type': 'string'},
                                                    'http': {'type': 'string'},
                                                    'https': {'type': 'string'},
                                                    'no-proxy': {'type': 'string'}},
                                     'required': ['http',
                                                  'https',
                                                  'ftp',
                                                  'no-proxy'],
                                     'type': 'object'},
                     'ProxyConfigResult': {'additionalProperties': False,
                                           'properties': {'apt-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'juju-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'legacy-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'snap-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'snap-store-assertions': {'type': 'string'},
                                                          'snap-store-id': {'type': 'string'},
                                                          'snap-store-proxy-url': {'type': 'string'}},
                                           'required': ['legacy-proxy-settings',
                                                        'juju-proxy-settings'],
                                           'type': 'object'},
                     'ProxyConfigResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/ProxyConfigResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'ProxyConfig': {'description': 'ProxyConfig returns the proxy '
                                                   'settings for the current '
                                                   'model.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ProxyConfigResults'}},
                                    'type': 'object'},
                    'WatchForProxyConfigAndAPIHostPortChanges': {'description': 'WatchForProxyConfigAndAPIHostPortChanges '
                                                                                'watches '
                                                                                'for '
                                                                                'cleanups '
                                                                                'to '
                                                                                'be '
                                                                                'perfomed '
                                                                                'in '
                                                                                'state',
                                                                 'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                                'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ProxyConfigResults)
    async def ProxyConfig(self, entities=None):
        '''
        ProxyConfig returns the proxy settings for the current model.

        entities : typing.Sequence[~Entity]
        Returns -> ProxyConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ProxyUpdater',
                   request='ProxyConfig',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchForProxyConfigAndAPIHostPortChanges(self, entities=None):
        '''
        WatchForProxyConfigAndAPIHostPortChanges watches for cleanups to be perfomed in state

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ProxyUpdater',
                   request='WatchForProxyConfigAndAPIHostPortChanges',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class RebootFacade(Type):
    name = 'Reboot'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'RebootActionResult': {'additionalProperties': False,
                                            'properties': {'error': {'$ref': '#/definitions/Error'},
                                                           'result': {'type': 'string'}},
                                            'type': 'object'},
                     'RebootActionResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/RebootActionResult'},
                                                                        'type': 'array'}},
                                             'type': 'object'}},
     'properties': {'ClearReboot': {'description': 'ClearReboot will clear the '
                                                   'reboot flag on provided '
                                                   'machines, if it exists.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'GetRebootAction': {'description': 'GetRebootAction returns '
                                                       'the action a machine agent '
                                                       'should take.\n'
                                                       'If a reboot flag is set on '
                                                       'the machine, then that '
                                                       'machine is\n'
                                                       'expected to reboot '
                                                       '(params.ShouldReboot).\n'
                                                       'a reboot flag set on the '
                                                       'machine parent or '
                                                       'grandparent, will\n'
                                                       'cause the machine to '
                                                       'shutdown '
                                                       '(params.ShouldShutdown).\n'
                                                       'If no reboot flag is set, '
                                                       'the machine should do '
                                                       'nothing '
                                                       '(params.ShouldDoNothing).',
                                        'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/RebootActionResults'}},
                                        'type': 'object'},
                    'RequestReboot': {'description': 'RequestReboot sets the '
                                                     'reboot flag on the provided '
                                                     'machines',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'WatchForRebootEvent': {'description': 'WatchForRebootEvent '
                                                           'starts a watcher to '
                                                           'track if there is a '
                                                           'new\n'
                                                           'reboot request on the '
                                                           'machines ID or any of '
                                                           'its parents (in case '
                                                           'we are a container).',
                                            'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ClearReboot(self, entities=None):
        '''
        ClearReboot will clear the reboot flag on provided machines, if it exists.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot',
                   request='ClearReboot',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RebootActionResults)
    async def GetRebootAction(self, entities=None):
        '''
        GetRebootAction returns the action a machine agent should take.
        If a reboot flag is set on the machine, then that machine is
        expected to reboot (params.ShouldReboot).
        a reboot flag set on the machine parent or grandparent, will
        cause the machine to shutdown (params.ShouldShutdown).
        If no reboot flag is set, the machine should do nothing (params.ShouldDoNothing).

        entities : typing.Sequence[~Entity]
        Returns -> RebootActionResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot',
                   request='GetRebootAction',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RequestReboot(self, entities=None):
        '''
        RequestReboot sets the reboot flag on the provided machines

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot',
                   request='RequestReboot',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForRebootEvent(self):
        '''
        WatchForRebootEvent starts a watcher to track if there is a new
        reboot request on the machines ID or any of its parents (in case we are a container).


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Reboot',
                   request='WatchForRebootEvent',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class RemoteRelationsFacade(Type):
    name = 'RemoteRelations'
    version = 2
    schema =     {'definitions': {'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityMacaroonArg': {'additionalProperties': False,
                                           'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                          'tag': {'type': 'string'}},
                                           'required': ['macaroon', 'tag'],
                                           'type': 'object'},
                     'EntityMacaroonArgs': {'additionalProperties': False,
                                            'properties': {'Args': {'items': {'$ref': '#/definitions/EntityMacaroonArg'},
                                                                    'type': 'array'}},
                                            'required': ['Args'],
                                            'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ExternalControllerInfo': {'additionalProperties': False,
                                                'properties': {'addrs': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                               'ca-cert': {'type': 'string'},
                                                               'controller-alias': {'type': 'string'},
                                                               'controller-tag': {'type': 'string'}},
                                                'required': ['controller-tag',
                                                             'controller-alias',
                                                             'addrs',
                                                             'ca-cert'],
                                                'type': 'object'},
                     'GetTokenArg': {'additionalProperties': False,
                                     'properties': {'tag': {'type': 'string'}},
                                     'required': ['tag'],
                                     'type': 'object'},
                     'GetTokenArgs': {'additionalProperties': False,
                                      'properties': {'Args': {'items': {'$ref': '#/definitions/GetTokenArg'},
                                                              'type': 'array'}},
                                      'required': ['Args'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RemoteApplication': {'additionalProperties': False,
                                           'properties': {'is-consumer-proxy': {'type': 'boolean'},
                                                          'life': {'type': 'string'},
                                                          'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                          'model-uuid': {'type': 'string'},
                                                          'name': {'type': 'string'},
                                                          'offer-uuid': {'type': 'string'},
                                                          'status': {'type': 'string'}},
                                           'required': ['name',
                                                        'offer-uuid',
                                                        'model-uuid',
                                                        'is-consumer-proxy'],
                                           'type': 'object'},
                     'RemoteApplicationResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/RemoteApplication'}},
                                                 'type': 'object'},
                     'RemoteApplicationResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/RemoteApplicationResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'RemoteEntityTokenArg': {'additionalProperties': False,
                                              'properties': {'tag': {'type': 'string'},
                                                             'token': {'type': 'string'}},
                                              'required': ['tag'],
                                              'type': 'object'},
                     'RemoteEntityTokenArgs': {'additionalProperties': False,
                                               'properties': {'Args': {'items': {'$ref': '#/definitions/RemoteEntityTokenArg'},
                                                                       'type': 'array'}},
                                               'required': ['Args'],
                                               'type': 'object'},
                     'RemoteRelation': {'additionalProperties': False,
                                        'properties': {'application-name': {'type': 'string'},
                                                       'endpoint': {'$ref': '#/definitions/RemoteEndpoint'},
                                                       'id': {'type': 'integer'},
                                                       'key': {'type': 'string'},
                                                       'life': {'type': 'string'},
                                                       'remote-application-name': {'type': 'string'},
                                                       'remote-endpoint-name': {'type': 'string'},
                                                       'source-model-uuid': {'type': 'string'},
                                                       'suspended': {'type': 'boolean'}},
                                        'required': ['life',
                                                     'suspended',
                                                     'id',
                                                     'key',
                                                     'application-name',
                                                     'endpoint',
                                                     'remote-application-name',
                                                     'remote-endpoint-name',
                                                     'source-model-uuid'],
                                        'type': 'object'},
                     'RemoteRelationChangeEvent': {'additionalProperties': False,
                                                   'properties': {'application-settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                        'type': 'object'}},
                                                                                           'type': 'object'},
                                                                  'application-token': {'type': 'string'},
                                                                  'bakery-version': {'type': 'integer'},
                                                                  'changed-units': {'items': {'$ref': '#/definitions/RemoteRelationUnitChange'},
                                                                                    'type': 'array'},
                                                                  'departed-units': {'items': {'type': 'integer'},
                                                                                     'type': 'array'},
                                                                  'force-cleanup': {'type': 'boolean'},
                                                                  'life': {'type': 'string'},
                                                                  'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                                'type': 'array'},
                                                                  'relation-token': {'type': 'string'},
                                                                  'suspended': {'type': 'boolean'},
                                                                  'suspended-reason': {'type': 'string'},
                                                                  'unit-count': {'type': 'integer'}},
                                                   'required': ['relation-token',
                                                                'application-token',
                                                                'life'],
                                                   'type': 'object'},
                     'RemoteRelationResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'result': {'$ref': '#/definitions/RemoteRelation'}},
                                              'type': 'object'},
                     'RemoteRelationResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/RemoteRelationResult'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'RemoteRelationUnitChange': {'additionalProperties': False,
                                                  'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                                 'unit-id': {'type': 'integer'}},
                                                  'required': ['unit-id'],
                                                  'type': 'object'},
                     'RemoteRelationWatchResult': {'additionalProperties': False,
                                                   'properties': {'changes': {'$ref': '#/definitions/RemoteRelationChangeEvent'},
                                                                  'error': {'$ref': '#/definitions/Error'},
                                                                  'watcher-id': {'type': 'string'}},
                                                   'required': ['watcher-id',
                                                                'changes'],
                                                   'type': 'object'},
                     'RemoteRelationWatchResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/RemoteRelationWatchResult'},
                                                                               'type': 'array'}},
                                                    'required': ['results'],
                                                    'type': 'object'},
                     'RemoteRelationsChanges': {'additionalProperties': False,
                                                'properties': {'changes': {'items': {'$ref': '#/definitions/RemoteRelationChangeEvent'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'TokenResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'token': {'type': 'string'}},
                                     'type': 'object'},
                     'TokenResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/TokenResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'UpdateControllerForModel': {'additionalProperties': False,
                                                  'properties': {'info': {'$ref': '#/definitions/ExternalControllerInfo'},
                                                                 'model-tag': {'type': 'string'}},
                                                  'required': ['model-tag', 'info'],
                                                  'type': 'object'},
                     'UpdateControllersForModelsParams': {'additionalProperties': False,
                                                          'properties': {'changes': {'items': {'$ref': '#/definitions/UpdateControllerForModel'},
                                                                                     'type': 'array'}},
                                                          'required': ['changes'],
                                                          'type': 'object'}},
     'properties': {'ConsumeRemoteRelationChanges': {'description': 'ConsumeRemoteRelationChanges '
                                                                    'consumes '
                                                                    'changes to '
                                                                    'settings '
                                                                    'originating\n'
                                                                    'from the '
                                                                    'remote/offering '
                                                                    'side of '
                                                                    'relations.',
                                                     'properties': {'Params': {'$ref': '#/definitions/RemoteRelationsChanges'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                     'type': 'object'},
                    'ControllerAPIInfoForModels': {'description': 'ControllerAPIInfoForModels '
                                                                  'returns the '
                                                                  'controller api '
                                                                  'connection '
                                                                  'details for the '
                                                                  'specified '
                                                                  'models.',
                                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'description': 'ControllerConfig returns '
                                                        "the controller's "
                                                        'configuration.',
                                         'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'ExportEntities': {'description': 'ExportEntities allocates '
                                                      'unique, remote entity IDs '
                                                      'for the given entities in '
                                                      'the local model.',
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/TokenResults'}},
                                       'type': 'object'},
                    'GetTokens': {'description': 'GetTokens returns the token '
                                                 'associated with the entities '
                                                 'with the given tags for the '
                                                 'given models.',
                                  'properties': {'Params': {'$ref': '#/definitions/GetTokenArgs'},
                                                 'Result': {'$ref': '#/definitions/StringResults'}},
                                  'type': 'object'},
                    'ImportRemoteEntities': {'description': 'ImportRemoteEntities '
                                                            'adds entities to the '
                                                            'remote entities '
                                                            'collection with the '
                                                            'specified opaque '
                                                            'tokens.',
                                             'properties': {'Params': {'$ref': '#/definitions/RemoteEntityTokenArgs'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'Relations': {'description': 'Relations returns information '
                                                 'about the cross-model relations '
                                                 'with the specified keys\n'
                                                 'in the local model.',
                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/RemoteRelationResults'}},
                                  'type': 'object'},
                    'RemoteApplications': {'description': 'RemoteApplications '
                                                          'returns the current '
                                                          'state of the remote '
                                                          'applications with\n'
                                                          'the specified names in '
                                                          'the local model.',
                                           'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/RemoteApplicationResults'}},
                                           'type': 'object'},
                    'SaveMacaroons': {'description': 'SaveMacaroons saves the '
                                                     'macaroons for the given '
                                                     'entities.',
                                      'properties': {'Params': {'$ref': '#/definitions/EntityMacaroonArgs'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'SetRemoteApplicationsStatus': {'description': 'SetRemoteApplicationsStatus '
                                                                   'sets the '
                                                                   'status for the '
                                                                   'specified '
                                                                   'remote '
                                                                   'applications.',
                                                    'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'UpdateControllersForModels': {'description': 'UpdateControllersForModels '
                                                                  'changes the '
                                                                  'external '
                                                                  'controller '
                                                                  'records for '
                                                                  'the\n'
                                                                  'associated '
                                                                  'model entities. '
                                                                  'This is used '
                                                                  'when the remote '
                                                                  'relations '
                                                                  'worker gets\n'
                                                                  'redirected '
                                                                  'following '
                                                                  'migration of an '
                                                                  'offering model.',
                                                   'properties': {'Params': {'$ref': '#/definitions/UpdateControllersForModelsParams'},
                                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                   'type': 'object'},
                    'WatchLocalRelationChanges': {'description': 'WatchLocalRelationChanges '
                                                                 'starts a '
                                                                 'RemoteRelationWatcher '
                                                                 'for each\n'
                                                                 'specified '
                                                                 'relation, '
                                                                 'returning the '
                                                                 'watcher IDs and '
                                                                 'initial values,\n'
                                                                 'or an error if '
                                                                 'the remote '
                                                                 'relations '
                                                                 "couldn't be "
                                                                 'watched.',
                                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/RemoteRelationWatchResults'}},
                                                  'type': 'object'},
                    'WatchRemoteApplicationRelations': {'description': 'WatchRemoteApplicationRelations '
                                                                       'starts a '
                                                                       'StringsWatcher '
                                                                       'for '
                                                                       'watching '
                                                                       'the '
                                                                       'relations '
                                                                       'of\n'
                                                                       'each '
                                                                       'specified '
                                                                       'application '
                                                                       'in the '
                                                                       'local '
                                                                       'model, and '
                                                                       'returns '
                                                                       'the '
                                                                       'watcher '
                                                                       'IDs\n'
                                                                       'and '
                                                                       'initial '
                                                                       'values, or '
                                                                       'an error '
                                                                       'if the '
                                                                       "services' "
                                                                       'relations '
                                                                       'could not '
                                                                       'be\n'
                                                                       'watched.',
                                                        'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                       'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                        'type': 'object'},
                    'WatchRemoteApplications': {'description': 'WatchRemoteApplications '
                                                               'starts a strings '
                                                               'watcher that '
                                                               'notifies of the '
                                                               'addition,\n'
                                                               'removal, and '
                                                               'lifecycle changes '
                                                               'of remote '
                                                               'applications in '
                                                               'the model; and\n'
                                                               'returns the '
                                                               'watcher ID and '
                                                               'initial IDs of '
                                                               'remote '
                                                               'applications, or '
                                                               'an error if\n'
                                                               'watching failed.',
                                                'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                                'type': 'object'},
                    'WatchRemoteRelations': {'description': 'WatchRemoteRelations '
                                                            'starts a strings '
                                                            'watcher that notifies '
                                                            'of the addition,\n'
                                                            'removal, and '
                                                            'lifecycle changes of '
                                                            'remote relations in '
                                                            'the model; and\n'
                                                            'returns the watcher '
                                                            'ID and initial IDs of '
                                                            'remote relations, or '
                                                            'an error if\n'
                                                            'watching failed.',
                                             'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ConsumeRemoteRelationChanges(self, changes=None):
        '''
        ConsumeRemoteRelationChanges consumes changes to settings originating
        from the remote/offering side of relations.

        changes : typing.Sequence[~RemoteRelationChangeEvent]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ConsumeRemoteRelationChanges',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        ControllerAPIInfoForModels returns the controller api connection details for the specified models.

        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ControllerAPIInfoForModels',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''
        ControllerConfig returns the controller's configuration.


        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ControllerConfig',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(TokenResults)
    async def ExportEntities(self, entities=None):
        '''
        ExportEntities allocates unique, remote entity IDs for the given entities in the local model.

        entities : typing.Sequence[~Entity]
        Returns -> TokenResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ExportEntities',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def GetTokens(self, args=None):
        '''
        GetTokens returns the token associated with the entities with the given tags for the given models.

        args : typing.Sequence[~GetTokenArg]
        Returns -> StringResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='GetTokens',
                   version=2,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ImportRemoteEntities(self, args=None):
        '''
        ImportRemoteEntities adds entities to the remote entities collection with the specified opaque tokens.

        args : typing.Sequence[~RemoteEntityTokenArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ImportRemoteEntities',
                   version=2,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteRelationResults)
    async def Relations(self, entities=None):
        '''
        Relations returns information about the cross-model relations with the specified keys
        in the local model.

        entities : typing.Sequence[~Entity]
        Returns -> RemoteRelationResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='Relations',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteApplicationResults)
    async def RemoteApplications(self, entities=None):
        '''
        RemoteApplications returns the current state of the remote applications with
        the specified names in the local model.

        entities : typing.Sequence[~Entity]
        Returns -> RemoteApplicationResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='RemoteApplications',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SaveMacaroons(self, args=None):
        '''
        SaveMacaroons saves the macaroons for the given entities.

        args : typing.Sequence[~EntityMacaroonArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='SaveMacaroons',
                   version=2,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetRemoteApplicationsStatus(self, entities=None):
        '''
        SetRemoteApplicationsStatus sets the status for the specified remote applications.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='SetRemoteApplicationsStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateControllersForModels(self, changes=None):
        '''
        UpdateControllersForModels changes the external controller records for the
        associated model entities. This is used when the remote relations worker gets
        redirected following migration of an offering model.

        changes : typing.Sequence[~UpdateControllerForModel]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='UpdateControllersForModels',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteRelationWatchResults)
    async def WatchLocalRelationChanges(self, entities=None):
        '''
        WatchLocalRelationChanges starts a RemoteRelationWatcher for each
        specified relation, returning the watcher IDs and initial values,
        or an error if the remote relations couldn't be watched.

        entities : typing.Sequence[~Entity]
        Returns -> RemoteRelationWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='WatchLocalRelationChanges',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchRemoteApplicationRelations(self, entities=None):
        '''
        WatchRemoteApplicationRelations starts a StringsWatcher for watching the relations of
        each specified application in the local model, and returns the watcher IDs
        and initial values, or an error if the services' relations could not be
        watched.

        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='WatchRemoteApplicationRelations',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchRemoteApplications(self):
        '''
        WatchRemoteApplications starts a strings watcher that notifies of the addition,
        removal, and lifecycle changes of remote applications in the model; and
        returns the watcher ID and initial IDs of remote applications, or an error if
        watching failed.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='WatchRemoteApplications',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchRemoteRelations(self):
        '''
        WatchRemoteRelations starts a strings watcher that notifies of the addition,
        removal, and lifecycle changes of remote relations in the model; and
        returns the watcher ID and initial IDs of remote relations, or an error if
        watching failed.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='WatchRemoteRelations',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ResumerFacade(Type):
    name = 'Resumer'
    version = 2
    schema =     {'properties': {'ResumeTransactions': {'type': 'object'}}, 'type': 'object'}
    

    @ReturnMapping(None)
    async def ResumeTransactions(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Resumer',
                   request='ResumeTransactions',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class SSHClientFacade(Type):
    name = 'SSHClient'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'SSHAddressResult': {'additionalProperties': False,
                                          'properties': {'address': {'type': 'string'},
                                                         'error': {'$ref': '#/definitions/Error'}},
                                          'type': 'object'},
                     'SSHAddressResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/SSHAddressResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'SSHAddressesResult': {'additionalProperties': False,
                                            'properties': {'addresses': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'}},
                                            'required': ['addresses'],
                                            'type': 'object'},
                     'SSHAddressesResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/SSHAddressesResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'SSHProxyResult': {'additionalProperties': False,
                                        'properties': {'use-proxy': {'type': 'boolean'}},
                                        'required': ['use-proxy'],
                                        'type': 'object'},
                     'SSHPublicKeysResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'public-keys': {'items': {'type': 'string'},
                                                                            'type': 'array'}},
                                             'type': 'object'},
                     'SSHPublicKeysResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/SSHPublicKeysResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'}},
     'properties': {'AllAddresses': {'description': 'AllAddresses reports all '
                                                    'addresses that might have SSH '
                                                    'listening for each given\n'
                                                    'entity in args. Machines and '
                                                    'units are supported as entity '
                                                    'types.\n'
                                                    'TODO(wpk): 2017-05-17 This is '
                                                    'a temporary solution, we '
                                                    'should not fetch environ '
                                                    'here\n'
                                                    'but get the addresses from '
                                                    'state. We will be changing it '
                                                    'since we want to have '
                                                    'space-aware\n'
                                                    'SSH settings.',
                                     'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/SSHAddressesResults'}},
                                     'type': 'object'},
                    'PrivateAddress': {'description': 'PrivateAddress reports the '
                                                      'preferred private network '
                                                      'address for one or\n'
                                                      'more entities. Machines and '
                                                      'units are supported.',
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                       'type': 'object'},
                    'Proxy': {'description': 'Proxy returns whether SSH '
                                             'connections should be proxied '
                                             'through the\n'
                                             'controller hosts for the model '
                                             'associated with the API connection.',
                              'properties': {'Result': {'$ref': '#/definitions/SSHProxyResult'}},
                              'type': 'object'},
                    'PublicAddress': {'description': 'PublicAddress reports the '
                                                     'preferred public network '
                                                     'address for one\n'
                                                     'or more entities. Machines '
                                                     'and units are suppored.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                      'type': 'object'},
                    'PublicKeys': {'description': 'PublicKeys returns the public '
                                                  'SSH hosts for one or more\n'
                                                  'entities. Machines and units '
                                                  'are supported.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/SSHPublicKeysResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(SSHAddressesResults)
    async def AllAddresses(self, entities=None):
        '''
        AllAddresses reports all addresses that might have SSH listening for each given
        entity in args. Machines and units are supported as entity types.
        TODO(wpk): 2017-05-17 This is a temporary solution, we should not fetch environ here
        but get the addresses from state. We will be changing it since we want to have space-aware
        SSH settings.

        entities : typing.Sequence[~Entity]
        Returns -> SSHAddressesResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='AllAddresses',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHAddressResults)
    async def PrivateAddress(self, entities=None):
        '''
        PrivateAddress reports the preferred private network address for one or
        more entities. Machines and units are supported.

        entities : typing.Sequence[~Entity]
        Returns -> SSHAddressResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='PrivateAddress',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHProxyResult)
    async def Proxy(self):
        '''
        Proxy returns whether SSH connections should be proxied through the
        controller hosts for the model associated with the API connection.


        Returns -> SSHProxyResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='Proxy',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHAddressResults)
    async def PublicAddress(self, entities=None):
        '''
        PublicAddress reports the preferred public network address for one
        or more entities. Machines and units are suppored.

        entities : typing.Sequence[~Entity]
        Returns -> SSHAddressResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='PublicAddress',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHPublicKeysResults)
    async def PublicKeys(self, entities=None):
        '''
        PublicKeys returns the public SSH hosts for one or more
        entities. Machines and units are supported.

        entities : typing.Sequence[~Entity]
        Returns -> SSHPublicKeysResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='PublicKeys',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SingularFacade(Type):
    name = 'Singular'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'SingularClaim': {'additionalProperties': False,
                                       'properties': {'claimant-tag': {'type': 'string'},
                                                      'duration': {'type': 'integer'},
                                                      'entity-tag': {'type': 'string'}},
                                       'required': ['entity-tag',
                                                    'claimant-tag',
                                                    'duration'],
                                       'type': 'object'},
                     'SingularClaims': {'additionalProperties': False,
                                        'properties': {'claims': {'items': {'$ref': '#/definitions/SingularClaim'},
                                                                  'type': 'array'}},
                                        'required': ['claims'],
                                        'type': 'object'}},
     'properties': {'Claim': {'description': 'Claim makes the supplied '
                                             'singular-controller lease requests. '
                                             '(In practice,\n'
                                             'any requests not for the '
                                             "connection's model or controller, or "
                                             'not on behalf\n'
                                             'of the connected ModelManager '
                                             'machine, will be rejected.)',
                              'properties': {'Params': {'$ref': '#/definitions/SingularClaims'},
                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                              'type': 'object'},
                    'Wait': {'description': 'Wait waits for the '
                                            'singular-controller lease to expire '
                                            'for all supplied\n'
                                            'entities. (In practice, any requests '
                                            'that do not refer to the '
                                            "connection's\n"
                                            'model or controller will be '
                                            'rejected.)',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Claim(self, claims=None):
        '''
        Claim makes the supplied singular-controller lease requests. (In practice,
        any requests not for the connection's model or controller, or not on behalf
        of the connected ModelManager machine, will be rejected.)

        claims : typing.Sequence[~SingularClaim]
        Returns -> ErrorResults
        '''
        if claims is not None and not isinstance(claims, (bytes, str, list)):
            raise Exception("Expected claims to be a Sequence, received: {}".format(type(claims)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Singular',
                   request='Claim',
                   version=2,
                   params=_params)
        _params['claims'] = claims
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Wait(self, entities=None):
        '''
        Wait waits for the singular-controller lease to expire for all supplied
        entities. (In practice, any requests that do not refer to the connection's
        model or controller will be rejected.)

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Singular',
                   request='Wait',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SpacesFacade(Type):
    name = 'Spaces'
    version = 2
    schema =     {'definitions': {'CreateSpaceParams': {'additionalProperties': False,
                                           'properties': {'provider-id': {'type': 'string'},
                                                          'public': {'type': 'boolean'},
                                                          'space-tag': {'type': 'string'},
                                                          'subnet-tags': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                           'required': ['subnet-tags',
                                                        'space-tag',
                                                        'public'],
                                           'type': 'object'},
                     'CreateSpacesParams': {'additionalProperties': False,
                                            'properties': {'spaces': {'items': {'$ref': '#/definitions/CreateSpaceParams'},
                                                                      'type': 'array'}},
                                            'required': ['spaces'],
                                            'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSpacesResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/Space'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Space': {'additionalProperties': False,
                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                              'name': {'type': 'string'},
                                              'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                          'type': 'array'}},
                               'required': ['name', 'subnets'],
                               'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'}},
     'properties': {'CreateSpaces': {'properties': {'Params': {'$ref': '#/definitions/CreateSpacesParams'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'ListSpaces': {'properties': {'Result': {'$ref': '#/definitions/ListSpacesResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def CreateSpaces(self, spaces=None):
        '''
        spaces : typing.Sequence[~CreateSpaceParams]
        Returns -> ErrorResults
        '''
        if spaces is not None and not isinstance(spaces, (bytes, str, list)):
            raise Exception("Expected spaces to be a Sequence, received: {}".format(type(spaces)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='CreateSpaces',
                   version=2,
                   params=_params)
        _params['spaces'] = spaces
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSpacesResults)
    async def ListSpaces(self):
        '''

        Returns -> ListSpacesResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Spaces',
                   request='ListSpaces',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class StatusHistoryFacade(Type):
    name = 'StatusHistory'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'StatusHistoryPruneArgs': {'additionalProperties': False,
                                                'properties': {'max-history-mb': {'type': 'integer'},
                                                               'max-history-time': {'type': 'integer'}},
                                                'required': ['max-history-time',
                                                             'max-history-mb'],
                                                'type': 'object'}},
     'properties': {'ModelConfig': {'description': 'ModelConfig returns the '
                                                   "current model's configuration.",
                                    'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'Prune': {'description': 'Prune endpoint removes status '
                                             'history entries until\n'
                                             'only the ones newer than now - '
                                             'p.MaxHistoryTime remain and\n'
                                             'the history is smaller than '
                                             'p.MaxHistoryMB.',
                              'properties': {'Params': {'$ref': '#/definitions/StatusHistoryPruneArgs'}},
                              'type': 'object'},
                    'WatchForModelConfigChanges': {'description': 'WatchForModelConfigChanges '
                                                                  'returns a '
                                                                  'NotifyWatcher '
                                                                  'that observes\n'
                                                                  'changes to the '
                                                                  'model '
                                                                  'configuration.\n'
                                                                  'Note that '
                                                                  'although the '
                                                                  'NotifyWatchResult '
                                                                  'contains an '
                                                                  'Error field,\n'
                                                                  "it's not used "
                                                                  'because we are '
                                                                  'only returning '
                                                                  'a single '
                                                                  'watcher,\n'
                                                                  'so we use the '
                                                                  'regular error '
                                                                  'return.',
                                                   'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''
        ModelConfig returns the current model's configuration.


        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StatusHistory',
                   request='ModelConfig',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Prune(self, max_history_mb=None, max_history_time=None):
        '''
        Prune endpoint removes status history entries until
        only the ones newer than now - p.MaxHistoryTime remain and
        the history is smaller than p.MaxHistoryMB.

        max_history_mb : int
        max_history_time : int
        Returns -> None
        '''
        if max_history_mb is not None and not isinstance(max_history_mb, int):
            raise Exception("Expected max_history_mb to be a int, received: {}".format(type(max_history_mb)))

        if max_history_time is not None and not isinstance(max_history_time, int):
            raise Exception("Expected max_history_time to be a int, received: {}".format(type(max_history_time)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StatusHistory',
                   request='Prune',
                   version=2,
                   params=_params)
        _params['max-history-mb'] = max_history_mb
        _params['max-history-time'] = max_history_time
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''
        WatchForModelConfigChanges returns a NotifyWatcher that observes
        changes to the model configuration.
        Note that although the NotifyWatchResult contains an Error field,
        it's not used because we are only returning a single watcher,
        so we use the regular error return.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StatusHistory',
                   request='WatchForModelConfigChanges',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class SubnetsFacade(Type):
    name = 'Subnets'
    version = 2
    schema =     {'definitions': {'AddSubnetParams': {'additionalProperties': False,
                                         'properties': {'provider-network-id': {'type': 'string'},
                                                        'space-tag': {'type': 'string'},
                                                        'subnet-provider-id': {'type': 'string'},
                                                        'subnet-tag': {'type': 'string'},
                                                        'vlan-tag': {'type': 'integer'},
                                                        'zones': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                         'required': ['space-tag'],
                                         'type': 'object'},
                     'AddSubnetsParams': {'additionalProperties': False,
                                          'properties': {'subnets': {'items': {'$ref': '#/definitions/AddSubnetParams'},
                                                                     'type': 'array'}},
                                          'required': ['subnets'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSubnetsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/Subnet'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SpaceResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'tag': {'type': 'string'}},
                                     'required': ['tag'],
                                     'type': 'object'},
                     'SpaceResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/SpaceResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'SubnetsFilters': {'additionalProperties': False,
                                        'properties': {'space-tag': {'type': 'string'},
                                                       'zone': {'type': 'string'}},
                                        'type': 'object'},
                     'ZoneResult': {'additionalProperties': False,
                                    'properties': {'available': {'type': 'boolean'},
                                                   'error': {'$ref': '#/definitions/Error'},
                                                   'name': {'type': 'string'}},
                                    'required': ['name', 'available'],
                                    'type': 'object'},
                     'ZoneResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/ZoneResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'}},
     'properties': {'AddSubnets': {'properties': {'Params': {'$ref': '#/definitions/AddSubnetsParams'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'AllSpaces': {'properties': {'Result': {'$ref': '#/definitions/SpaceResults'}},
                                  'type': 'object'},
                    'AllZones': {'properties': {'Result': {'$ref': '#/definitions/ZoneResults'}},
                                 'type': 'object'},
                    'ListSubnets': {'properties': {'Params': {'$ref': '#/definitions/SubnetsFilters'},
                                                   'Result': {'$ref': '#/definitions/ListSubnetsResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddSubnets(self, subnets=None):
        '''
        subnets : typing.Sequence[~AddSubnetParams]
        Returns -> ErrorResults
        '''
        if subnets is not None and not isinstance(subnets, (bytes, str, list)):
            raise Exception("Expected subnets to be a Sequence, received: {}".format(type(subnets)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='AddSubnets',
                   version=2,
                   params=_params)
        _params['subnets'] = subnets
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SpaceResults)
    async def AllSpaces(self):
        '''

        Returns -> SpaceResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='AllSpaces',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ZoneResults)
    async def AllZones(self):
        '''

        Returns -> ZoneResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='AllZones',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListSubnetsResults)
    async def ListSubnets(self, space_tag=None, zone=None):
        '''
        space_tag : str
        zone : str
        Returns -> ListSubnetsResults
        '''
        if space_tag is not None and not isinstance(space_tag, (bytes, str)):
            raise Exception("Expected space_tag to be a str, received: {}".format(type(space_tag)))

        if zone is not None and not isinstance(zone, (bytes, str)):
            raise Exception("Expected zone to be a str, received: {}".format(type(zone)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Subnets',
                   request='ListSubnets',
                   version=2,
                   params=_params)
        _params['space-tag'] = space_tag
        _params['zone'] = zone
        reply = await self.rpc(msg)
        return reply



class UpgradeSeriesFacade(Type):
    name = 'UpgradeSeries'
    version = 2
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesResult': {'additionalProperties': False,
                                        'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                    'type': 'array'},
                                                       'error': {'$ref': '#/definitions/Error'}},
                                        'required': ['entities'],
                                        'type': 'object'},
                     'EntitiesResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/EntitiesResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'PinApplicationResult': {'additionalProperties': False,
                                              'properties': {'application-name': {'type': 'string'},
                                                             'error': {'$ref': '#/definitions/Error'}},
                                              'required': ['application-name'],
                                              'type': 'object'},
                     'PinApplicationsResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/PinApplicationResult'},
                                                                           'type': 'array'}},
                                                'required': ['results'],
                                                'type': 'object'},
                     'PinnedLeadershipResult': {'additionalProperties': False,
                                                'properties': {'result': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                       'type': 'array'}},
                                                                          'type': 'object'}},
                                                'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'UpdateSeriesArg': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'series': {'type': 'string'},
                                                        'tag': {'$ref': '#/definitions/Entity'}},
                                         'required': ['tag', 'force', 'series'],
                                         'type': 'object'},
                     'UpdateSeriesArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/UpdateSeriesArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'UpgradeSeriesStartUnitCompletionParam': {'additionalProperties': False,
                                                               'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                                           'type': 'array'},
                                                                              'message': {'type': 'string'}},
                                                               'required': ['entities',
                                                                            'message'],
                                                               'type': 'object'},
                     'UpgradeSeriesStatusParam': {'additionalProperties': False,
                                                  'properties': {'entity': {'$ref': '#/definitions/Entity'},
                                                                 'message': {'type': 'string'},
                                                                 'status': {'type': 'string'}},
                                                  'required': ['entity',
                                                               'status',
                                                               'message'],
                                                  'type': 'object'},
                     'UpgradeSeriesStatusParams': {'additionalProperties': False,
                                                   'properties': {'params': {'items': {'$ref': '#/definitions/UpgradeSeriesStatusParam'},
                                                                             'type': 'array'}},
                                                   'required': ['params'],
                                                   'type': 'object'},
                     'UpgradeSeriesStatusResult': {'additionalProperties': False,
                                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                  'status': {'type': 'string'}},
                                                   'type': 'object'},
                     'UpgradeSeriesStatusResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/UpgradeSeriesStatusResult'},
                                                                               'type': 'array'}},
                                                    'type': 'object'}},
     'properties': {'CurrentSeries': {'description': 'CurrentSeries returns what '
                                                     'Juju thinks the current '
                                                     'series of the machine is.\n'
                                                     'Note that a machine could '
                                                     'have been upgraded '
                                                     'out-of-band by running\n'
                                                     'do-release-upgrade outside '
                                                     'of the upgrade-series '
                                                     'workflow,\n'
                                                     'making this value incorrect.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/StringResults'}},
                                      'type': 'object'},
                    'FinishUpgradeSeries': {'description': 'FinishUpgradeSeries is '
                                                           'the last action in the '
                                                           'upgrade workflow and '
                                                           'is\n'
                                                           'called after all '
                                                           'machine and unit '
                                                           'statuses are '
                                                           '"completed".\n'
                                                           'It updates the machine '
                                                           'series to reflect the '
                                                           'completed upgrade, '
                                                           'then\n'
                                                           'removes the '
                                                           'upgrade-series lock.',
                                            'properties': {'Params': {'$ref': '#/definitions/UpdateSeriesArgs'},
                                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                                            'type': 'object'},
                    'MachineStatus': {'description': 'MachineStatus gets the '
                                                     'current upgrade-series '
                                                     'status of a machine.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/UpgradeSeriesStatusResults'}},
                                      'type': 'object'},
                    'PinMachineApplications': {'description': 'PinMachineApplications '
                                                              'pins leadership for '
                                                              'applications '
                                                              'represented by '
                                                              'units\n'
                                                              'running on the '
                                                              "auth'd machine.",
                                               'properties': {'Result': {'$ref': '#/definitions/PinApplicationsResults'}},
                                               'type': 'object'},
                    'PinnedLeadership': {'description': 'PinnedLeadership returns '
                                                        'all pinned applications '
                                                        'and the entities that\n'
                                                        'require their pinned '
                                                        'behaviour, for leadership '
                                                        'in the current model.',
                                         'properties': {'Result': {'$ref': '#/definitions/PinnedLeadershipResult'}},
                                         'type': 'object'},
                    'SetMachineStatus': {'description': 'SetMachineStatus sets the '
                                                        'current upgrade-series '
                                                        'status of a machine.',
                                         'properties': {'Params': {'$ref': '#/definitions/UpgradeSeriesStatusParams'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'SetUpgradeSeriesUnitStatus': {'description': 'SetUpgradeSeriesUnitStatus '
                                                                  'sets the '
                                                                  'upgrade series '
                                                                  'status of the '
                                                                  'unit.\n'
                                                                  'If no upgrade '
                                                                  'is in progress '
                                                                  'an error is '
                                                                  'returned '
                                                                  'instead.',
                                                   'properties': {'Params': {'$ref': '#/definitions/UpgradeSeriesStatusParams'},
                                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                   'type': 'object'},
                    'StartUnitCompletion': {'description': 'StartUnitCompletion '
                                                           'starts the upgrade '
                                                           'series completion '
                                                           'phase for all '
                                                           'subordinate\n'
                                                           'units of a given '
                                                           'machine.',
                                            'properties': {'Params': {'$ref': '#/definitions/UpgradeSeriesStartUnitCompletionParam'},
                                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                                            'type': 'object'},
                    'TargetSeries': {'description': 'TargetSeries returns the '
                                                    'series that a machine has '
                                                    'been locked\n'
                                                    'for upgrading to.',
                                     'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/StringResults'}},
                                     'type': 'object'},
                    'UnitsCompleted': {'description': 'UnitsCompleted returns the '
                                                      'units running on this '
                                                      'machine that have '
                                                      'completed\n'
                                                      'the upgrade-series workflow '
                                                      'and are in their normal '
                                                      'running state.',
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/EntitiesResults'}},
                                       'type': 'object'},
                    'UnitsPrepared': {'description': 'UnitsPrepared returns the '
                                                     'units running on this '
                                                     'machine that have completed\n'
                                                     'their upgrade-series '
                                                     'preparation, and are ready '
                                                     'to be stopped and have '
                                                     'their\n'
                                                     'unit agent services '
                                                     'converted for the target '
                                                     'series.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/EntitiesResults'}},
                                      'type': 'object'},
                    'UnpinMachineApplications': {'description': 'UnpinMachineApplications '
                                                                'unpins leadership '
                                                                'for applications '
                                                                'represented by\n'
                                                                'units running on '
                                                                "the auth'd "
                                                                'machine.',
                                                 'properties': {'Result': {'$ref': '#/definitions/PinApplicationsResults'}},
                                                 'type': 'object'},
                    'UpgradeSeriesUnitStatus': {'description': 'UpgradeSeriesUnitStatus '
                                                               'returns the '
                                                               'current '
                                                               'preparation status '
                                                               'of an\n'
                                                               'upgrading unit.\n'
                                                               'If no series '
                                                               'upgrade is in '
                                                               'progress an error '
                                                               'is returned '
                                                               'instead.',
                                                'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/UpgradeSeriesStatusResults'}},
                                                'type': 'object'},
                    'WatchUpgradeSeriesNotifications': {'description': 'WatchUpgradeSeriesNotifications '
                                                                       'returns a '
                                                                       'NotifyWatcher '
                                                                       'for '
                                                                       'observing '
                                                                       'changes to '
                                                                       'upgrade '
                                                                       'series '
                                                                       'locks.',
                                                        'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                       'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringResults)
    async def CurrentSeries(self, entities=None):
        '''
        CurrentSeries returns what Juju thinks the current series of the machine is.
        Note that a machine could have been upgraded out-of-band by running
        do-release-upgrade outside of the upgrade-series workflow,
        making this value incorrect.

        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='CurrentSeries',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def FinishUpgradeSeries(self, args=None):
        '''
        FinishUpgradeSeries is the last action in the upgrade workflow and is
        called after all machine and unit statuses are "completed".
        It updates the machine series to reflect the completed upgrade, then
        removes the upgrade-series lock.

        args : typing.Sequence[~UpdateSeriesArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='FinishUpgradeSeries',
                   version=2,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpgradeSeriesStatusResults)
    async def MachineStatus(self, entities=None):
        '''
        MachineStatus gets the current upgrade-series status of a machine.

        entities : typing.Sequence[~Entity]
        Returns -> UpgradeSeriesStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='MachineStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PinApplicationsResults)
    async def PinMachineApplications(self):
        '''
        PinMachineApplications pins leadership for applications represented by units
        running on the auth'd machine.


        Returns -> PinApplicationsResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='PinMachineApplications',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PinnedLeadershipResult)
    async def PinnedLeadership(self):
        '''
        PinnedLeadership returns all pinned applications and the entities that
        require their pinned behaviour, for leadership in the current model.


        Returns -> PinnedLeadershipResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='PinnedLeadership',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMachineStatus(self, params=None):
        '''
        SetMachineStatus sets the current upgrade-series status of a machine.

        params : typing.Sequence[~UpgradeSeriesStatusParam]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='SetMachineStatus',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetUpgradeSeriesUnitStatus(self, params=None):
        '''
        SetUpgradeSeriesUnitStatus sets the upgrade series status of the unit.
        If no upgrade is in progress an error is returned instead.

        params : typing.Sequence[~UpgradeSeriesStatusParam]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='SetUpgradeSeriesUnitStatus',
                   version=2,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def StartUnitCompletion(self, entities=None, message=None):
        '''
        StartUnitCompletion starts the upgrade series completion phase for all subordinate
        units of a given machine.

        entities : typing.Sequence[~Entity]
        message : str
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        if message is not None and not isinstance(message, (bytes, str)):
            raise Exception("Expected message to be a str, received: {}".format(type(message)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='StartUnitCompletion',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        _params['message'] = message
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def TargetSeries(self, entities=None):
        '''
        TargetSeries returns the series that a machine has been locked
        for upgrading to.

        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='TargetSeries',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(EntitiesResults)
    async def UnitsCompleted(self, entities=None):
        '''
        UnitsCompleted returns the units running on this machine that have completed
        the upgrade-series workflow and are in their normal running state.

        entities : typing.Sequence[~Entity]
        Returns -> EntitiesResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='UnitsCompleted',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(EntitiesResults)
    async def UnitsPrepared(self, entities=None):
        '''
        UnitsPrepared returns the units running on this machine that have completed
        their upgrade-series preparation, and are ready to be stopped and have their
        unit agent services converted for the target series.

        entities : typing.Sequence[~Entity]
        Returns -> EntitiesResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='UnitsPrepared',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PinApplicationsResults)
    async def UnpinMachineApplications(self):
        '''
        UnpinMachineApplications unpins leadership for applications represented by
        units running on the auth'd machine.


        Returns -> PinApplicationsResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='UnpinMachineApplications',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpgradeSeriesStatusResults)
    async def UpgradeSeriesUnitStatus(self, entities=None):
        '''
        UpgradeSeriesUnitStatus returns the current preparation status of an
        upgrading unit.
        If no series upgrade is in progress an error is returned instead.

        entities : typing.Sequence[~Entity]
        Returns -> UpgradeSeriesStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='UpgradeSeriesUnitStatus',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchUpgradeSeriesNotifications(self, entities=None):
        '''
        WatchUpgradeSeriesNotifications returns a NotifyWatcher for observing changes to upgrade series locks.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='WatchUpgradeSeriesNotifications',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class UpgradeStepsFacade(Type):
    name = 'UpgradeSteps'
    version = 2
    schema =     {'definitions': {'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'SetUnitStateArg': {'additionalProperties': False,
                                         'properties': {'charm-state': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                        'meter-status-state': {'type': 'string'},
                                                        'relation-state': {'patternProperties': {'.*': {'type': 'string'}},
                                                                           'type': 'object'},
                                                        'storage-state': {'type': 'string'},
                                                        'tag': {'type': 'string'},
                                                        'uniter-state': {'type': 'string'}},
                                         'required': ['tag'],
                                         'type': 'object'},
                     'SetUnitStateArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/SetUnitStateArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'}},
     'properties': {'ResetKVMMachineModificationStatusIdle': {'description': 'ResetKVMMachineModificationStatusIdle '
                                                                             'sets '
                                                                             'the '
                                                                             'modification '
                                                                             'status\n'
                                                                             'of a '
                                                                             'kvm '
                                                                             'machine '
                                                                             'to '
                                                                             'idle '
                                                                             'if '
                                                                             'it '
                                                                             'is '
                                                                             'in '
                                                                             'an '
                                                                             'error '
                                                                             'state '
                                                                             'before '
                                                                             'upgrade.\n'
                                                                             'Related '
                                                                             'to '
                                                                             'lp:1829393.',
                                                              'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                                             'Result': {'$ref': '#/definitions/ErrorResult'}},
                                                              'type': 'object'},
                    'WriteAgentState': {'description': 'WriteAgentState writes the '
                                                       'agent state for the set of '
                                                       'units provided. This\n'
                                                       'call presently deals with '
                                                       'the state for the unit '
                                                       'agent.',
                                        'properties': {'Params': {'$ref': '#/definitions/SetUnitStateArgs'},
                                                       'Result': {'$ref': '#/definitions/ErrorResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def ResetKVMMachineModificationStatusIdle(self, tag=None):
        '''
        ResetKVMMachineModificationStatusIdle sets the modification status
        of a kvm machine to idle if it is in an error state before upgrade.
        Related to lp:1829393.

        tag : str
        Returns -> ErrorResult
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSteps',
                   request='ResetKVMMachineModificationStatusIdle',
                   version=2,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def WriteAgentState(self, args=None):
        '''
        WriteAgentState writes the agent state for the set of units provided. This
        call presently deals with the state for the unit agent.

        args : typing.Sequence[~SetUnitStateArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSteps',
                   request='WriteAgentState',
                   version=2,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



class UserManagerFacade(Type):
    name = 'UserManager'
    version = 2
    schema =     {'definitions': {'AddUser': {'additionalProperties': False,
                                 'properties': {'display-name': {'type': 'string'},
                                                'password': {'type': 'string'},
                                                'username': {'type': 'string'}},
                                 'required': ['username', 'display-name'],
                                 'type': 'object'},
                     'AddUserResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'secret-key': {'items': {'type': 'integer'},
                                                                     'type': 'array'},
                                                      'tag': {'type': 'string'}},
                                       'type': 'object'},
                     'AddUserResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/AddUserResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'AddUsers': {'additionalProperties': False,
                                  'properties': {'users': {'items': {'$ref': '#/definitions/AddUser'},
                                                           'type': 'array'}},
                                  'required': ['users'],
                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'UserInfo': {'additionalProperties': False,
                                  'properties': {'access': {'type': 'string'},
                                                 'created-by': {'type': 'string'},
                                                 'date-created': {'format': 'date-time',
                                                                  'type': 'string'},
                                                 'disabled': {'type': 'boolean'},
                                                 'display-name': {'type': 'string'},
                                                 'last-connection': {'format': 'date-time',
                                                                     'type': 'string'},
                                                 'username': {'type': 'string'}},
                                  'required': ['username',
                                               'display-name',
                                               'access',
                                               'created-by',
                                               'date-created',
                                               'disabled'],
                                  'type': 'object'},
                     'UserInfoRequest': {'additionalProperties': False,
                                         'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                     'type': 'array'},
                                                        'include-disabled': {'type': 'boolean'}},
                                         'required': ['entities',
                                                      'include-disabled'],
                                         'type': 'object'},
                     'UserInfoResult': {'additionalProperties': False,
                                        'properties': {'error': {'$ref': '#/definitions/Error'},
                                                       'result': {'$ref': '#/definitions/UserInfo'}},
                                        'type': 'object'},
                     'UserInfoResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/UserInfoResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'}},
     'properties': {'AddUser': {'description': 'AddUser adds a user with a '
                                               'username, and either a password '
                                               'or\n'
                                               'a randomly generated secret key '
                                               'which will be returned.',
                                'properties': {'Params': {'$ref': '#/definitions/AddUsers'},
                                               'Result': {'$ref': '#/definitions/AddUserResults'}},
                                'type': 'object'},
                    'DisableUser': {'description': 'DisableUser disables one or '
                                                   'more users.  If the user is '
                                                   'already disabled,\n'
                                                   'the action is considered a '
                                                   'success.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'EnableUser': {'description': 'EnableUser enables one or more '
                                                  'users.  If the user is already '
                                                  'enabled,\n'
                                                  'the action is considered a '
                                                  'success.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'RemoveUser': {'description': 'RemoveUser permanently removes '
                                                  'a user from the current '
                                                  'controller for each\n'
                                                  'entity provided. While the user '
                                                  'is permanently removed we keep '
                                                  "it's\n"
                                                  'information around for auditing '
                                                  'purposes.\n'
                                                  'TODO(redir): Add information '
                                                  'about getting deleted user '
                                                  'information when we\n'
                                                  'add that capability.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'ResetPassword': {'description': 'ResetPassword resets '
                                                     'password for supplied users '
                                                     'by\n'
                                                     'invalidating current '
                                                     'passwords (if any) and '
                                                     'generating\n'
                                                     'new random secret keys which '
                                                     'will be returned.\n'
                                                     'Users cannot reset their own '
                                                     'password.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/AddUserResults'}},
                                      'type': 'object'},
                    'SetPassword': {'description': 'SetPassword changes the stored '
                                                   'password for the specified '
                                                   'users.',
                                    'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'UserInfo': {'description': 'UserInfo returns information on a '
                                                'user.',
                                 'properties': {'Params': {'$ref': '#/definitions/UserInfoRequest'},
                                                'Result': {'$ref': '#/definitions/UserInfoResults'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddUserResults)
    async def AddUser(self, users=None):
        '''
        AddUser adds a user with a username, and either a password or
        a randomly generated secret key which will be returned.

        users : typing.Sequence[~AddUser]
        Returns -> AddUserResults
        '''
        if users is not None and not isinstance(users, (bytes, str, list)):
            raise Exception("Expected users to be a Sequence, received: {}".format(type(users)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='AddUser',
                   version=2,
                   params=_params)
        _params['users'] = users
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DisableUser(self, entities=None):
        '''
        DisableUser disables one or more users.  If the user is already disabled,
        the action is considered a success.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='DisableUser',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnableUser(self, entities=None):
        '''
        EnableUser enables one or more users.  If the user is already enabled,
        the action is considered a success.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='EnableUser',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveUser(self, entities=None):
        '''
        RemoveUser permanently removes a user from the current controller for each
        entity provided. While the user is permanently removed we keep it's
        information around for auditing purposes.
        TODO(redir): Add information about getting deleted user information when we
        add that capability.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='RemoveUser',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddUserResults)
    async def ResetPassword(self, entities=None):
        '''
        ResetPassword resets password for supplied users by
        invalidating current passwords (if any) and generating
        new random secret keys which will be returned.
        Users cannot reset their own password.

        entities : typing.Sequence[~Entity]
        Returns -> AddUserResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='ResetPassword',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPassword(self, changes=None):
        '''
        SetPassword changes the stored password for the specified users.

        changes : typing.Sequence[~EntityPassword]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='SetPassword',
                   version=2,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserInfoResults)
    async def UserInfo(self, entities=None, include_disabled=None):
        '''
        UserInfo returns information on a user.

        entities : typing.Sequence[~Entity]
        include_disabled : bool
        Returns -> UserInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        if include_disabled is not None and not isinstance(include_disabled, bool):
            raise Exception("Expected include_disabled to be a bool, received: {}".format(type(include_disabled)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='UserInfo',
                   version=2,
                   params=_params)
        _params['entities'] = entities
        _params['include-disabled'] = include_disabled
        reply = await self.rpc(msg)
        return reply



class VolumeAttachmentsWatcherFacade(Type):
    name = 'VolumeAttachmentsWatcher'
    version = 2
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'}},
     'properties': {'Next': {'description': 'Next returns when a change has '
                                            'occurred to an entity of the\n'
                                            'collection being watched since the '
                                            'most recent call to Next\n'
                                            'or the Watch call that created the '
                                            'srvMachineStorageIdsWatcher.',
                             'properties': {'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MachineStorageIdsWatchResult)
    async def Next(self):
        '''
        Next returns when a change has occurred to an entity of the
        collection being watched since the most recent call to Next
        or the Watch call that created the srvMachineStorageIdsWatcher.


        Returns -> MachineStorageIdsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='VolumeAttachmentsWatcher',
                   request='Next',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='VolumeAttachmentsWatcher',
                   request='Stop',
                   version=2,
                   params=_params)

        reply = await self.rpc(msg)
        return reply


