# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client.facade import Type, ReturnMapping
from juju.client._definitions import *


class ApplicationFacade(Type):
    name = 'Application'
    version = 10
    schema =     {'definitions': {'AddApplicationUnits': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'attach-storage': {'items': {'type': 'string'},
                                                                               'type': 'array'},
                                                            'num-units': {'type': 'integer'},
                                                            'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                          'type': 'array'},
                                                            'policy': {'type': 'string'}},
                                             'required': ['application',
                                                          'num-units',
                                                          'placement'],
                                             'type': 'object'},
                     'AddApplicationUnitsResults': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'type': 'string'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'AddRelation': {'additionalProperties': False,
                                     'properties': {'endpoints': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                    'via-cidrs': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                     'required': ['endpoints'],
                                     'type': 'object'},
                     'AddRelationResults': {'additionalProperties': False,
                                            'properties': {'endpoints': {'patternProperties': {'.*': {'$ref': '#/definitions/CharmRelation'}},
                                                                         'type': 'object'}},
                                            'required': ['endpoints'],
                                            'type': 'object'},
                     'ApplicationCharmRelations': {'additionalProperties': False,
                                                   'properties': {'application': {'type': 'string'}},
                                                   'required': ['application'],
                                                   'type': 'object'},
                     'ApplicationCharmRelationsResults': {'additionalProperties': False,
                                                          'properties': {'charm-relations': {'items': {'type': 'string'},
                                                                                             'type': 'array'}},
                                                          'required': ['charm-relations'],
                                                          'type': 'object'},
                     'ApplicationConfigSet': {'additionalProperties': False,
                                              'properties': {'application': {'type': 'string'},
                                                             'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                             'generation': {'type': 'string'}},
                                              'required': ['application',
                                                           'generation',
                                                           'config'],
                                              'type': 'object'},
                     'ApplicationConfigSetArgs': {'additionalProperties': False,
                                                  'properties': {'Args': {'items': {'$ref': '#/definitions/ApplicationConfigSet'},
                                                                          'type': 'array'}},
                                                  'required': ['Args'],
                                                  'type': 'object'},
                     'ApplicationConfigUnsetArgs': {'additionalProperties': False,
                                                    'properties': {'Args': {'items': {'$ref': '#/definitions/ApplicationUnset'},
                                                                            'type': 'array'}},
                                                    'required': ['Args'],
                                                    'type': 'object'},
                     'ApplicationConstraint': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                              'error': {'$ref': '#/definitions/Error'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'ApplicationDeploy': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'attach-storage': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                          'channel': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                          'config-yaml': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'devices': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'},
                                                          'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                          'num-units': {'type': 'integer'},
                                                          'placement': {'items': {'$ref': '#/definitions/Placement'},
                                                                        'type': 'array'},
                                                          'policy': {'type': 'string'},
                                                          'resources': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'storage': {'patternProperties': {'.*': {'$ref': '#/definitions/Constraints'}},
                                                                      'type': 'object'}},
                                           'required': ['application',
                                                        'series',
                                                        'charm-url',
                                                        'channel',
                                                        'num-units',
                                                        'config-yaml',
                                                        'constraints'],
                                           'type': 'object'},
                     'ApplicationDestroy': {'additionalProperties': False,
                                            'properties': {'application': {'type': 'string'}},
                                            'required': ['application'],
                                            'type': 'object'},
                     'ApplicationExpose': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'}},
                                           'required': ['application'],
                                           'type': 'object'},
                     'ApplicationGet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'branch': {'type': 'string'}},
                                        'required': ['application', 'branch'],
                                        'type': 'object'},
                     'ApplicationGetArgs': {'additionalProperties': False,
                                            'properties': {'args': {'items': {'$ref': '#/definitions/ApplicationGet'},
                                                                    'type': 'array'}},
                                            'required': ['args'],
                                            'type': 'object'},
                     'ApplicationGetConfigResults': {'additionalProperties': False,
                                                     'properties': {'Results': {'items': {'$ref': '#/definitions/ConfigResult'},
                                                                                'type': 'array'}},
                                                     'required': ['Results'],
                                                     'type': 'object'},
                     'ApplicationGetConstraintsResults': {'additionalProperties': False,
                                                          'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationConstraint'},
                                                                                     'type': 'array'}},
                                                          'required': ['results'],
                                                          'type': 'object'},
                     'ApplicationGetResults': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'application-config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                  'type': 'object'}},
                                                                                     'type': 'object'},
                                                              'channel': {'type': 'string'},
                                                              'charm': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'constraints': {'$ref': '#/definitions/Value'},
                                                              'series': {'type': 'string'}},
                                               'required': ['application',
                                                            'charm',
                                                            'config',
                                                            'constraints',
                                                            'series',
                                                            'channel'],
                                               'type': 'object'},
                     'ApplicationInfo': {'additionalProperties': False,
                                         'properties': {'channel': {'type': 'string'},
                                                        'charm': {'type': 'string'},
                                                        'constraints': {'$ref': '#/definitions/Value'},
                                                        'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                              'type': 'object'},
                                                        'exposed': {'type': 'boolean'},
                                                        'principal': {'type': 'boolean'},
                                                        'remote': {'type': 'boolean'},
                                                        'series': {'type': 'string'},
                                                        'tag': {'type': 'string'}},
                                         'required': ['tag',
                                                      'principal',
                                                      'exposed',
                                                      'remote'],
                                         'type': 'object'},
                     'ApplicationInfoResult': {'additionalProperties': False,
                                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                                              'result': {'$ref': '#/definitions/ApplicationInfo'}},
                                               'type': 'object'},
                     'ApplicationInfoResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationInfoResult'},
                                                                           'type': 'array'}},
                                                'required': ['results'],
                                                'type': 'object'},
                     'ApplicationMetricCredential': {'additionalProperties': False,
                                                     'properties': {'application': {'type': 'string'},
                                                                    'metrics-credentials': {'items': {'type': 'integer'},
                                                                                            'type': 'array'}},
                                                     'required': ['application',
                                                                  'metrics-credentials'],
                                                     'type': 'object'},
                     'ApplicationMetricCredentials': {'additionalProperties': False,
                                                      'properties': {'creds': {'items': {'$ref': '#/definitions/ApplicationMetricCredential'},
                                                                               'type': 'array'}},
                                                      'required': ['creds'],
                                                      'type': 'object'},
                     'ApplicationOfferDetails': {'additionalProperties': False,
                                                 'properties': {'application-description': {'type': 'string'},
                                                                'bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                                'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                              'type': 'array'},
                                                                'offer-name': {'type': 'string'},
                                                                'offer-url': {'type': 'string'},
                                                                'offer-uuid': {'type': 'string'},
                                                                'source-model-tag': {'type': 'string'},
                                                                'spaces': {'items': {'$ref': '#/definitions/RemoteSpace'},
                                                                           'type': 'array'},
                                                                'users': {'items': {'$ref': '#/definitions/OfferUserDetails'},
                                                                          'type': 'array'}},
                                                 'required': ['source-model-tag',
                                                              'offer-uuid',
                                                              'offer-url',
                                                              'offer-name',
                                                              'application-description'],
                                                 'type': 'object'},
                     'ApplicationSet': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'branch': {'type': 'string'},
                                                       'options': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'}},
                                        'required': ['application',
                                                     'branch',
                                                     'options'],
                                        'type': 'object'},
                     'ApplicationSetCharm': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'},
                                                            'channel': {'type': 'string'},
                                                            'charm-url': {'type': 'string'},
                                                            'config-settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                'type': 'object'},
                                                            'config-settings-yaml': {'type': 'string'},
                                                            'force': {'type': 'boolean'},
                                                            'force-series': {'type': 'boolean'},
                                                            'force-units': {'type': 'boolean'},
                                                            'generation': {'type': 'string'},
                                                            'resource-ids': {'patternProperties': {'.*': {'type': 'string'}},
                                                                             'type': 'object'},
                                                            'storage-constraints': {'patternProperties': {'.*': {'$ref': '#/definitions/StorageConstraints'}},
                                                                                    'type': 'object'}},
                                             'required': ['application',
                                                          'generation',
                                                          'charm-url',
                                                          'channel',
                                                          'force',
                                                          'force-units',
                                                          'force-series'],
                                             'type': 'object'},
                     'ApplicationUnexpose': {'additionalProperties': False,
                                             'properties': {'application': {'type': 'string'}},
                                             'required': ['application'],
                                             'type': 'object'},
                     'ApplicationUnset': {'additionalProperties': False,
                                          'properties': {'application': {'type': 'string'},
                                                         'branch': {'type': 'string'},
                                                         'options': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                          'required': ['application',
                                                       'branch',
                                                       'options'],
                                          'type': 'object'},
                     'ApplicationUpdate': {'additionalProperties': False,
                                           'properties': {'application': {'type': 'string'},
                                                          'charm-url': {'type': 'string'},
                                                          'constraints': {'$ref': '#/definitions/Value'},
                                                          'force': {'type': 'boolean'},
                                                          'force-charm-url': {'type': 'boolean'},
                                                          'force-series': {'type': 'boolean'},
                                                          'generation': {'type': 'string'},
                                                          'min-units': {'type': 'integer'},
                                                          'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                       'type': 'object'},
                                                          'settings-yaml': {'type': 'string'}},
                                           'required': ['application',
                                                        'charm-url',
                                                        'force-charm-url',
                                                        'force-series',
                                                        'force',
                                                        'settings-yaml',
                                                        'generation'],
                                           'type': 'object'},
                     'ApplicationsDeploy': {'additionalProperties': False,
                                            'properties': {'applications': {'items': {'$ref': '#/definitions/ApplicationDeploy'},
                                                                            'type': 'array'}},
                                            'required': ['applications'],
                                            'type': 'object'},
                     'CharmRelation': {'additionalProperties': False,
                                       'properties': {'interface': {'type': 'string'},
                                                      'limit': {'type': 'integer'},
                                                      'name': {'type': 'string'},
                                                      'optional': {'type': 'boolean'},
                                                      'role': {'type': 'string'},
                                                      'scope': {'type': 'string'}},
                                       'required': ['name',
                                                    'role',
                                                    'interface',
                                                    'optional',
                                                    'limit',
                                                    'scope'],
                                       'type': 'object'},
                     'ConfigResult': {'additionalProperties': False,
                                      'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'}},
                                      'required': ['config'],
                                      'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'ConsumeApplicationArg': {'additionalProperties': False,
                                               'properties': {'ApplicationOfferDetails': {'$ref': '#/definitions/ApplicationOfferDetails'},
                                                              'application-alias': {'type': 'string'},
                                                              'external-controller': {'$ref': '#/definitions/ExternalControllerInfo'},
                                                              'macaroon': {'$ref': '#/definitions/Macaroon'}},
                                               'required': ['ApplicationOfferDetails'],
                                               'type': 'object'},
                     'ConsumeApplicationArgs': {'additionalProperties': False,
                                                'properties': {'args': {'items': {'$ref': '#/definitions/ConsumeApplicationArg'},
                                                                        'type': 'array'}},
                                                'type': 'object'},
                     'DestroyApplicationInfo': {'additionalProperties': False,
                                                'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                     'type': 'array'},
                                                               'destroyed-units': {'items': {'$ref': '#/definitions/Entity'},
                                                                                   'type': 'array'},
                                                               'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                                    'type': 'array'}},
                                                'type': 'object'},
                     'DestroyApplicationParams': {'additionalProperties': False,
                                                  'properties': {'application-tag': {'type': 'string'},
                                                                 'destroy-storage': {'type': 'boolean'},
                                                                 'force': {'type': 'boolean'},
                                                                 'max-wait': {'type': 'integer'}},
                                                  'required': ['application-tag',
                                                               'force'],
                                                  'type': 'object'},
                     'DestroyApplicationResult': {'additionalProperties': False,
                                                  'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                 'info': {'$ref': '#/definitions/DestroyApplicationInfo'}},
                                                  'type': 'object'},
                     'DestroyApplicationResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/DestroyApplicationResult'},
                                                                              'type': 'array'}},
                                                   'type': 'object'},
                     'DestroyApplicationUnits': {'additionalProperties': False,
                                                 'properties': {'unit-names': {'items': {'type': 'string'},
                                                                               'type': 'array'}},
                                                 'required': ['unit-names'],
                                                 'type': 'object'},
                     'DestroyApplicationsParams': {'additionalProperties': False,
                                                   'properties': {'applications': {'items': {'$ref': '#/definitions/DestroyApplicationParams'},
                                                                                   'type': 'array'}},
                                                   'required': ['applications'],
                                                   'type': 'object'},
                     'DestroyConsumedApplicationParams': {'additionalProperties': False,
                                                          'properties': {'application-tag': {'type': 'string'},
                                                                         'force': {'type': 'boolean'},
                                                                         'max-wait': {'type': 'integer'}},
                                                          'required': ['application-tag'],
                                                          'type': 'object'},
                     'DestroyConsumedApplicationsParams': {'additionalProperties': False,
                                                           'properties': {'applications': {'items': {'$ref': '#/definitions/DestroyConsumedApplicationParams'},
                                                                                           'type': 'array'}},
                                                           'required': ['applications'],
                                                           'type': 'object'},
                     'DestroyRelation': {'additionalProperties': False,
                                         'properties': {'endpoints': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                        'force': {'type': 'boolean'},
                                                        'max-wait': {'type': 'integer'},
                                                        'relation-id': {'type': 'integer'}},
                                         'required': ['relation-id'],
                                         'type': 'object'},
                     'DestroyUnitInfo': {'additionalProperties': False,
                                         'properties': {'destroyed-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                              'type': 'array'},
                                                        'detached-storage': {'items': {'$ref': '#/definitions/Entity'},
                                                                             'type': 'array'}},
                                         'type': 'object'},
                     'DestroyUnitParams': {'additionalProperties': False,
                                           'properties': {'destroy-storage': {'type': 'boolean'},
                                                          'force': {'type': 'boolean'},
                                                          'max-wait': {'type': 'integer'},
                                                          'unit-tag': {'type': 'string'}},
                                           'required': ['unit-tag', 'force'],
                                           'type': 'object'},
                     'DestroyUnitResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'$ref': '#/definitions/DestroyUnitInfo'}},
                                           'type': 'object'},
                     'DestroyUnitResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/DestroyUnitResult'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'DestroyUnitsParams': {'additionalProperties': False,
                                            'properties': {'units': {'items': {'$ref': '#/definitions/DestroyUnitParams'},
                                                                     'type': 'array'}},
                                            'required': ['units'],
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ExternalControllerInfo': {'additionalProperties': False,
                                                'properties': {'addrs': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                               'ca-cert': {'type': 'string'},
                                                               'controller-alias': {'type': 'string'},
                                                               'controller-tag': {'type': 'string'}},
                                                'required': ['controller-tag',
                                                             'controller-alias',
                                                             'addrs',
                                                             'ca-cert'],
                                                'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'OfferUserDetails': {'additionalProperties': False,
                                          'properties': {'access': {'type': 'string'},
                                                         'display-name': {'type': 'string'},
                                                         'user': {'type': 'string'}},
                                          'required': ['user',
                                                       'display-name',
                                                       'access'],
                                          'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'RelationSuspendedArg': {'additionalProperties': False,
                                              'properties': {'message': {'type': 'string'},
                                                             'relation-id': {'type': 'integer'},
                                                             'suspended': {'type': 'boolean'}},
                                              'required': ['relation-id',
                                                           'message',
                                                           'suspended'],
                                              'type': 'object'},
                     'RelationSuspendedArgs': {'additionalProperties': False,
                                               'properties': {'args': {'items': {'$ref': '#/definitions/RelationSuspendedArg'},
                                                                       'type': 'array'}},
                                               'required': ['args'],
                                               'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'RemoteSpace': {'additionalProperties': False,
                                     'properties': {'cloud-type': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'provider-attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                         'type': 'object'}},
                                                                            'type': 'object'},
                                                    'provider-id': {'type': 'string'},
                                                    'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                'type': 'array'}},
                                     'required': ['cloud-type',
                                                  'name',
                                                  'provider-id',
                                                  'provider-attributes',
                                                  'subnets'],
                                     'type': 'object'},
                     'ScaleApplicationInfo': {'additionalProperties': False,
                                              'properties': {'num-units': {'type': 'integer'}},
                                              'required': ['num-units'],
                                              'type': 'object'},
                     'ScaleApplicationParams': {'additionalProperties': False,
                                                'properties': {'application-tag': {'type': 'string'},
                                                               'force': {'type': 'boolean'},
                                                               'scale': {'type': 'integer'},
                                                               'scale-change': {'type': 'integer'}},
                                                'required': ['application-tag',
                                                             'scale',
                                                             'force'],
                                                'type': 'object'},
                     'ScaleApplicationResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'info': {'$ref': '#/definitions/ScaleApplicationInfo'}},
                                                'type': 'object'},
                     'ScaleApplicationResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ScaleApplicationResult'},
                                                                            'type': 'array'}},
                                                 'type': 'object'},
                     'ScaleApplicationsParams': {'additionalProperties': False,
                                                 'properties': {'applications': {'items': {'$ref': '#/definitions/ScaleApplicationParams'},
                                                                                 'type': 'array'}},
                                                 'required': ['applications'],
                                                 'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'StorageConstraints': {'additionalProperties': False,
                                            'properties': {'count': {'type': 'integer'},
                                                           'pool': {'type': 'string'},
                                                           'size': {'type': 'integer'}},
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'UnitsResolved': {'additionalProperties': False,
                                       'properties': {'all': {'type': 'boolean'},
                                                      'retry': {'type': 'boolean'},
                                                      'tags': {'$ref': '#/definitions/Entities'}},
                                       'type': 'object'},
                     'UpdateSeriesArg': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'series': {'type': 'string'},
                                                        'tag': {'$ref': '#/definitions/Entity'}},
                                         'required': ['tag', 'force', 'series'],
                                         'type': 'object'},
                     'UpdateSeriesArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/UpdateSeriesArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'AddRelation': {'properties': {'Params': {'$ref': '#/definitions/AddRelation'},
                                                   'Result': {'$ref': '#/definitions/AddRelationResults'}},
                                    'type': 'object'},
                    'AddUnits': {'properties': {'Params': {'$ref': '#/definitions/AddApplicationUnits'},
                                                'Result': {'$ref': '#/definitions/AddApplicationUnitsResults'}},
                                 'type': 'object'},
                    'ApplicationsInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/ApplicationInfoResults'}},
                                         'type': 'object'},
                    'CharmConfig': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGetArgs'},
                                                   'Result': {'$ref': '#/definitions/ApplicationGetConfigResults'}},
                                    'type': 'object'},
                    'CharmRelations': {'properties': {'Params': {'$ref': '#/definitions/ApplicationCharmRelations'},
                                                      'Result': {'$ref': '#/definitions/ApplicationCharmRelationsResults'}},
                                       'type': 'object'},
                    'Consume': {'properties': {'Params': {'$ref': '#/definitions/ConsumeApplicationArgs'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'Deploy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationsDeploy'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Destroy': {'properties': {'Params': {'$ref': '#/definitions/ApplicationDestroy'}},
                                'type': 'object'},
                    'DestroyApplication': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationsParams'},
                                                          'Result': {'$ref': '#/definitions/DestroyApplicationResults'}},
                                           'type': 'object'},
                    'DestroyConsumedApplications': {'properties': {'Params': {'$ref': '#/definitions/DestroyConsumedApplicationsParams'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'DestroyRelation': {'properties': {'Params': {'$ref': '#/definitions/DestroyRelation'}},
                                        'type': 'object'},
                    'DestroyUnit': {'properties': {'Params': {'$ref': '#/definitions/DestroyUnitsParams'},
                                                   'Result': {'$ref': '#/definitions/DestroyUnitResults'}},
                                    'type': 'object'},
                    'DestroyUnits': {'properties': {'Params': {'$ref': '#/definitions/DestroyApplicationUnits'}},
                                     'type': 'object'},
                    'Expose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationExpose'}},
                               'type': 'object'},
                    'Get': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                           'Result': {'$ref': '#/definitions/ApplicationGetResults'}},
                            'type': 'object'},
                    'GetCharmURL': {'properties': {'Params': {'$ref': '#/definitions/ApplicationGet'},
                                                   'Result': {'$ref': '#/definitions/StringResult'}},
                                    'type': 'object'},
                    'GetConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/ApplicationGetConfigResults'}},
                                  'type': 'object'},
                    'GetConstraints': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/ApplicationGetConstraintsResults'}},
                                       'type': 'object'},
                    'ResolveUnitErrors': {'properties': {'Params': {'$ref': '#/definitions/UnitsResolved'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'ScaleApplications': {'properties': {'Params': {'$ref': '#/definitions/ScaleApplicationsParams'},
                                                         'Result': {'$ref': '#/definitions/ScaleApplicationResults'}},
                                          'type': 'object'},
                    'Set': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSet'}},
                            'type': 'object'},
                    'SetApplicationsConfig': {'properties': {'Params': {'$ref': '#/definitions/ApplicationConfigSetArgs'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'SetCharm': {'properties': {'Params': {'$ref': '#/definitions/ApplicationSetCharm'}},
                                 'type': 'object'},
                    'SetConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                       'type': 'object'},
                    'SetMetricCredentials': {'properties': {'Params': {'$ref': '#/definitions/ApplicationMetricCredentials'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'SetRelationsSuspended': {'properties': {'Params': {'$ref': '#/definitions/RelationSuspendedArgs'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'Unexpose': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnexpose'}},
                                 'type': 'object'},
                    'Unset': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUnset'}},
                              'type': 'object'},
                    'UnsetApplicationsConfig': {'properties': {'Params': {'$ref': '#/definitions/ApplicationConfigUnsetArgs'},
                                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                'type': 'object'},
                    'Update': {'properties': {'Params': {'$ref': '#/definitions/ApplicationUpdate'}},
                               'type': 'object'},
                    'UpdateApplicationSeries': {'properties': {'Params': {'$ref': '#/definitions/UpdateSeriesArgs'},
                                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddRelationResults)
    async def AddRelation(self, endpoints=None, via_cidrs=None):
        '''
        endpoints : typing.Sequence[str]
        via_cidrs : typing.Sequence[str]
        Returns -> AddRelationResults
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        if via_cidrs is not None and not isinstance(via_cidrs, (bytes, str, list)):
            raise Exception("Expected via_cidrs to be a Sequence, received: {}".format(type(via_cidrs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddRelation',
                   version=10,
                   params=_params)
        _params['endpoints'] = endpoints
        _params['via-cidrs'] = via_cidrs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddApplicationUnitsResults)
    async def AddUnits(self, application=None, attach_storage=None, num_units=None, placement=None, policy=None):
        '''
        application : str
        attach_storage : typing.Sequence[str]
        num_units : int
        placement : typing.Sequence[~Placement]
        policy : str
        Returns -> AddApplicationUnitsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if attach_storage is not None and not isinstance(attach_storage, (bytes, str, list)):
            raise Exception("Expected attach_storage to be a Sequence, received: {}".format(type(attach_storage)))

        if num_units is not None and not isinstance(num_units, int):
            raise Exception("Expected num_units to be a int, received: {}".format(type(num_units)))

        if placement is not None and not isinstance(placement, (bytes, str, list)):
            raise Exception("Expected placement to be a Sequence, received: {}".format(type(placement)))

        if policy is not None and not isinstance(policy, (bytes, str)):
            raise Exception("Expected policy to be a str, received: {}".format(type(policy)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='AddUnits',
                   version=10,
                   params=_params)
        _params['application'] = application
        _params['attach-storage'] = attach_storage
        _params['num-units'] = num_units
        _params['placement'] = placement
        _params['policy'] = policy
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationInfoResults)
    async def ApplicationsInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='ApplicationsInfo',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetConfigResults)
    async def CharmConfig(self, args=None):
        '''
        args : typing.Sequence[~ApplicationGet]
        Returns -> ApplicationGetConfigResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmConfig',
                   version=10,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmRelationsResults)
    async def CharmRelations(self, application=None):
        '''
        application : str
        Returns -> ApplicationCharmRelationsResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='CharmRelations',
                   version=10,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Consume(self, args=None):
        '''
        args : typing.Sequence[~ConsumeApplicationArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Consume',
                   version=10,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Deploy(self, applications=None):
        '''
        applications : typing.Sequence[~ApplicationDeploy]
        Returns -> ErrorResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Deploy',
                   version=10,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Destroy(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Destroy',
                   version=10,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyApplicationResults)
    async def DestroyApplication(self, applications=None):
        '''
        applications : typing.Sequence[~DestroyApplicationParams]
        Returns -> DestroyApplicationResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyApplication',
                   version=10,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DestroyConsumedApplications(self, applications=None):
        '''
        applications : typing.Sequence[~DestroyConsumedApplicationParams]
        Returns -> ErrorResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyConsumedApplications',
                   version=10,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyRelation(self, endpoints=None, force=None, max_wait=None, relation_id=None):
        '''
        endpoints : typing.Sequence[str]
        force : bool
        max_wait : int
        relation_id : int
        Returns -> None
        '''
        if endpoints is not None and not isinstance(endpoints, (bytes, str, list)):
            raise Exception("Expected endpoints to be a Sequence, received: {}".format(type(endpoints)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if max_wait is not None and not isinstance(max_wait, int):
            raise Exception("Expected max_wait to be a int, received: {}".format(type(max_wait)))

        if relation_id is not None and not isinstance(relation_id, int):
            raise Exception("Expected relation_id to be a int, received: {}".format(type(relation_id)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyRelation',
                   version=10,
                   params=_params)
        _params['endpoints'] = endpoints
        _params['force'] = force
        _params['max-wait'] = max_wait
        _params['relation-id'] = relation_id
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DestroyUnitResults)
    async def DestroyUnit(self, units=None):
        '''
        units : typing.Sequence[~DestroyUnitParams]
        Returns -> DestroyUnitResults
        '''
        if units is not None and not isinstance(units, (bytes, str, list)):
            raise Exception("Expected units to be a Sequence, received: {}".format(type(units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnit',
                   version=10,
                   params=_params)
        _params['units'] = units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyUnits(self, unit_names=None):
        '''
        unit_names : typing.Sequence[str]
        Returns -> None
        '''
        if unit_names is not None and not isinstance(unit_names, (bytes, str, list)):
            raise Exception("Expected unit_names to be a Sequence, received: {}".format(type(unit_names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='DestroyUnits',
                   version=10,
                   params=_params)
        _params['unit-names'] = unit_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Expose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Expose',
                   version=10,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetResults)
    async def Get(self, application=None, branch=None):
        '''
        application : str
        branch : str
        Returns -> ApplicationGetResults
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Get',
                   version=10,
                   params=_params)
        _params['application'] = application
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def GetCharmURL(self, application=None, branch=None):
        '''
        application : str
        branch : str
        Returns -> StringResult
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetCharmURL',
                   version=10,
                   params=_params)
        _params['application'] = application
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetConfigResults)
    async def GetConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationGetConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConfig',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationGetConstraintsResults)
    async def GetConstraints(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ApplicationGetConstraintsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='GetConstraints',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ResolveUnitErrors(self, all_=None, retry=None, tags=None):
        '''
        all_ : bool
        retry : bool
        tags : Entities
        Returns -> ErrorResults
        '''
        if all_ is not None and not isinstance(all_, bool):
            raise Exception("Expected all_ to be a bool, received: {}".format(type(all_)))

        if retry is not None and not isinstance(retry, bool):
            raise Exception("Expected retry to be a bool, received: {}".format(type(retry)))

        if tags is not None and not isinstance(tags, (dict, Entities)):
            raise Exception("Expected tags to be a Entities, received: {}".format(type(tags)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='ResolveUnitErrors',
                   version=10,
                   params=_params)
        _params['all'] = all_
        _params['retry'] = retry
        _params['tags'] = tags
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ScaleApplicationResults)
    async def ScaleApplications(self, applications=None):
        '''
        applications : typing.Sequence[~ScaleApplicationParams]
        Returns -> ScaleApplicationResults
        '''
        if applications is not None and not isinstance(applications, (bytes, str, list)):
            raise Exception("Expected applications to be a Sequence, received: {}".format(type(applications)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='ScaleApplications',
                   version=10,
                   params=_params)
        _params['applications'] = applications
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Set(self, application=None, branch=None, options=None):
        '''
        application : str
        branch : str
        options : typing.Mapping[str, str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        if options is not None and not isinstance(options, dict):
            raise Exception("Expected options to be a Mapping, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Set',
                   version=10,
                   params=_params)
        _params['application'] = application
        _params['branch'] = branch
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetApplicationsConfig(self, args=None):
        '''
        args : typing.Sequence[~ApplicationConfigSet]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetApplicationsConfig',
                   version=10,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetCharm(self, application=None, channel=None, charm_url=None, config_settings=None, config_settings_yaml=None, force=None, force_series=None, force_units=None, generation=None, resource_ids=None, storage_constraints=None):
        '''
        application : str
        channel : str
        charm_url : str
        config_settings : typing.Mapping[str, str]
        config_settings_yaml : str
        force : bool
        force_series : bool
        force_units : bool
        generation : str
        resource_ids : typing.Mapping[str, str]
        storage_constraints : typing.Mapping[str, ~StorageConstraints]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if config_settings is not None and not isinstance(config_settings, dict):
            raise Exception("Expected config_settings to be a Mapping, received: {}".format(type(config_settings)))

        if config_settings_yaml is not None and not isinstance(config_settings_yaml, (bytes, str)):
            raise Exception("Expected config_settings_yaml to be a str, received: {}".format(type(config_settings_yaml)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if force_units is not None and not isinstance(force_units, bool):
            raise Exception("Expected force_units to be a bool, received: {}".format(type(force_units)))

        if generation is not None and not isinstance(generation, (bytes, str)):
            raise Exception("Expected generation to be a str, received: {}".format(type(generation)))

        if resource_ids is not None and not isinstance(resource_ids, dict):
            raise Exception("Expected resource_ids to be a Mapping, received: {}".format(type(resource_ids)))

        if storage_constraints is not None and not isinstance(storage_constraints, dict):
            raise Exception("Expected storage_constraints to be a Mapping, received: {}".format(type(storage_constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetCharm',
                   version=10,
                   params=_params)
        _params['application'] = application
        _params['channel'] = channel
        _params['charm-url'] = charm_url
        _params['config-settings'] = config_settings
        _params['config-settings-yaml'] = config_settings_yaml
        _params['force'] = force
        _params['force-series'] = force_series
        _params['force-units'] = force_units
        _params['generation'] = generation
        _params['resource-ids'] = resource_ids
        _params['storage-constraints'] = storage_constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetConstraints(self, application=None, constraints=None):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetConstraints',
                   version=10,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMetricCredentials(self, creds=None):
        '''
        creds : typing.Sequence[~ApplicationMetricCredential]
        Returns -> ErrorResults
        '''
        if creds is not None and not isinstance(creds, (bytes, str, list)):
            raise Exception("Expected creds to be a Sequence, received: {}".format(type(creds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetMetricCredentials',
                   version=10,
                   params=_params)
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetRelationsSuspended(self, args=None):
        '''
        args : typing.Sequence[~RelationSuspendedArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='SetRelationsSuspended',
                   version=10,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unexpose(self, application=None):
        '''
        application : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unexpose',
                   version=10,
                   params=_params)
        _params['application'] = application
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Unset(self, application=None, branch=None, options=None):
        '''
        application : str
        branch : str
        options : typing.Sequence[str]
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        if options is not None and not isinstance(options, (bytes, str, list)):
            raise Exception("Expected options to be a Sequence, received: {}".format(type(options)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Unset',
                   version=10,
                   params=_params)
        _params['application'] = application
        _params['branch'] = branch
        _params['options'] = options
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UnsetApplicationsConfig(self, args=None):
        '''
        args : typing.Sequence[~ApplicationUnset]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='UnsetApplicationsConfig',
                   version=10,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Update(self, application=None, charm_url=None, constraints=None, force=None, force_charm_url=None, force_series=None, generation=None, min_units=None, settings=None, settings_yaml=None):
        '''
        application : str
        charm_url : str
        constraints : Value
        force : bool
        force_charm_url : bool
        force_series : bool
        generation : str
        min_units : int
        settings : typing.Mapping[str, str]
        settings_yaml : str
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if charm_url is not None and not isinstance(charm_url, (bytes, str)):
            raise Exception("Expected charm_url to be a str, received: {}".format(type(charm_url)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if force_charm_url is not None and not isinstance(force_charm_url, bool):
            raise Exception("Expected force_charm_url to be a bool, received: {}".format(type(force_charm_url)))

        if force_series is not None and not isinstance(force_series, bool):
            raise Exception("Expected force_series to be a bool, received: {}".format(type(force_series)))

        if generation is not None and not isinstance(generation, (bytes, str)):
            raise Exception("Expected generation to be a str, received: {}".format(type(generation)))

        if min_units is not None and not isinstance(min_units, int):
            raise Exception("Expected min_units to be a int, received: {}".format(type(min_units)))

        if settings is not None and not isinstance(settings, dict):
            raise Exception("Expected settings to be a Mapping, received: {}".format(type(settings)))

        if settings_yaml is not None and not isinstance(settings_yaml, (bytes, str)):
            raise Exception("Expected settings_yaml to be a str, received: {}".format(type(settings_yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='Update',
                   version=10,
                   params=_params)
        _params['application'] = application
        _params['charm-url'] = charm_url
        _params['constraints'] = constraints
        _params['force'] = force
        _params['force-charm-url'] = force_charm_url
        _params['force-series'] = force_series
        _params['generation'] = generation
        _params['min-units'] = min_units
        _params['settings'] = settings
        _params['settings-yaml'] = settings_yaml
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateApplicationSeries(self, args=None):
        '''
        args : typing.Sequence[~UpdateSeriesArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Application',
                   request='UpdateApplicationSeries',
                   version=10,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



class ProvisionerFacade(Type):
    name = 'Provisioner'
    version = 10
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Patch': {'type': 'integer'},
                                               'Series': {'type': 'string'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build',
                                             'Number',
                                             'Series',
                                             'Arch'],
                                'type': 'object'},
                     'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'CharmLXDProfile': {'additionalProperties': False,
                                         'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                   'type': 'object'},
                                                        'description': {'type': 'string'},
                                                        'devices': {'patternProperties': {'.*': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'}},
                                         'required': ['config',
                                                      'description',
                                                      'devices'],
                                         'type': 'object'},
                     'CloudImageMetadata': {'additionalProperties': False,
                                            'properties': {'arch': {'type': 'string'},
                                                           'image-id': {'type': 'string'},
                                                           'priority': {'type': 'integer'},
                                                           'region': {'type': 'string'},
                                                           'root-storage-size': {'type': 'integer'},
                                                           'root-storage-type': {'type': 'string'},
                                                           'series': {'type': 'string'},
                                                           'source': {'type': 'string'},
                                                           'stream': {'type': 'string'},
                                                           'version': {'type': 'string'},
                                                           'virt-type': {'type': 'string'}},
                                            'required': ['image-id',
                                                         'region',
                                                         'version',
                                                         'series',
                                                         'arch',
                                                         'source',
                                                         'priority'],
                                            'type': 'object'},
                     'ConstraintsResult': {'additionalProperties': False,
                                           'properties': {'constraints': {'$ref': '#/definitions/Value'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['constraints'],
                                           'type': 'object'},
                     'ConstraintsResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/ConstraintsResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ContainerConfig': {'additionalProperties': False,
                                         'properties': {'UpdateBehavior': {'$ref': '#/definitions/UpdateBehavior'},
                                                        'apt-mirror': {'type': 'string'},
                                                        'apt-proxy': {'$ref': '#/definitions/Settings'},
                                                        'authorized-keys': {'type': 'string'},
                                                        'cloudinit-userdata': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                            'type': 'object'}},
                                                                               'type': 'object'},
                                                        'container-inherit-properties': {'type': 'string'},
                                                        'juju-proxy': {'$ref': '#/definitions/Settings'},
                                                        'legacy-proxy': {'$ref': '#/definitions/Settings'},
                                                        'provider-type': {'type': 'string'},
                                                        'snap-proxy': {'$ref': '#/definitions/Settings'},
                                                        'snap-store-assertions': {'type': 'string'},
                                                        'snap-store-proxy-id': {'type': 'string'},
                                                        'snap-store-proxy-url': {'type': 'string'},
                                                        'ssl-hostname-verification': {'type': 'boolean'}},
                                         'required': ['provider-type',
                                                      'authorized-keys',
                                                      'ssl-hostname-verification',
                                                      'legacy-proxy',
                                                      'juju-proxy',
                                                      'apt-proxy',
                                                      'snap-proxy',
                                                      'snap-store-assertions',
                                                      'snap-store-proxy-id',
                                                      'snap-store-proxy-url',
                                                      'apt-mirror',
                                                      'UpdateBehavior'],
                                         'type': 'object'},
                     'ContainerLXDProfile': {'additionalProperties': False,
                                             'properties': {'name': {'type': 'string'},
                                                            'profile': {'$ref': '#/definitions/CharmLXDProfile'}},
                                             'required': ['profile', 'name'],
                                             'type': 'object'},
                     'ContainerManagerConfig': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'ContainerManagerConfigParams': {'additionalProperties': False,
                                                      'properties': {'type': {'type': 'string'}},
                                                      'required': ['type'],
                                                      'type': 'object'},
                     'ContainerProfileResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'lxd-profiles': {'items': {'$ref': '#/definitions/ContainerLXDProfile'},
                                                                                'type': 'array'}},
                                                'type': 'object'},
                     'ContainerProfileResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ContainerProfileResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'DeviceBridgeInfo': {'additionalProperties': False,
                                          'properties': {'bridge-name': {'type': 'string'},
                                                         'host-device-name': {'type': 'string'},
                                                         'mac-address': {'type': 'string'}},
                                          'required': ['host-device-name',
                                                       'bridge-name',
                                                       'mac-address'],
                                          'type': 'object'},
                     'DistributionGroupResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                                 'required': ['result'],
                                                 'type': 'object'},
                     'DistributionGroupResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/DistributionGroupResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FindToolsParams': {'additionalProperties': False,
                                         'properties': {'agentstream': {'type': 'string'},
                                                        'arch': {'type': 'string'},
                                                        'major': {'type': 'integer'},
                                                        'minor': {'type': 'integer'},
                                                        'number': {'$ref': '#/definitions/Number'},
                                                        'series': {'type': 'string'}},
                                         'required': ['number',
                                                      'major',
                                                      'minor',
                                                      'arch',
                                                      'series',
                                                      'agentstream'],
                                         'type': 'object'},
                     'FindToolsResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'list': {'items': {'$ref': '#/definitions/Tools'},
                                                                 'type': 'array'}},
                                         'required': ['list'],
                                         'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'root-disk-source': {'type': 'string'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'HostNetworkChange': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'new-bridges': {'items': {'$ref': '#/definitions/DeviceBridgeInfo'},
                                                                          'type': 'array'},
                                                          'reconfigure-delay': {'type': 'integer'}},
                                           'required': ['new-bridges',
                                                        'reconfigure-delay'],
                                           'type': 'object'},
                     'HostNetworkChangeResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/HostNetworkChange'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'InstanceInfo': {'additionalProperties': False,
                                      'properties': {'characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                     'charm-profiles': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                     'display-name': {'type': 'string'},
                                                     'instance-id': {'type': 'string'},
                                                     'network-config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                        'type': 'array'},
                                                     'nonce': {'type': 'string'},
                                                     'tag': {'type': 'string'},
                                                     'volume-attachments': {'patternProperties': {'.*': {'$ref': '#/definitions/VolumeAttachmentInfo'}},
                                                                            'type': 'object'},
                                                     'volumes': {'items': {'$ref': '#/definitions/Volume'},
                                                                 'type': 'array'}},
                                      'required': ['tag',
                                                   'instance-id',
                                                   'display-name',
                                                   'nonce',
                                                   'characteristics',
                                                   'volumes',
                                                   'volume-attachments',
                                                   'network-config',
                                                   'charm-profiles'],
                                      'type': 'object'},
                     'InstancesInfo': {'additionalProperties': False,
                                       'properties': {'machines': {'items': {'$ref': '#/definitions/InstanceInfo'},
                                                                   'type': 'array'}},
                                       'required': ['machines'],
                                       'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'MachineContainerResult': {'additionalProperties': False,
                                                'properties': {'container-types': {'items': {'type': 'string'},
                                                                                   'type': 'array'},
                                                               'determined': {'type': 'boolean'},
                                                               'error': {'$ref': '#/definitions/Error'}},
                                                'required': ['container-types',
                                                             'determined'],
                                                'type': 'object'},
                     'MachineContainerResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/MachineContainerResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'MachineContainers': {'additionalProperties': False,
                                           'properties': {'container-types': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                          'machine-tag': {'type': 'string'}},
                                           'required': ['machine-tag',
                                                        'container-types'],
                                           'type': 'object'},
                     'MachineContainersParams': {'additionalProperties': False,
                                                 'properties': {'params': {'items': {'$ref': '#/definitions/MachineContainers'},
                                                                           'type': 'array'}},
                                                 'required': ['params'],
                                                 'type': 'object'},
                     'MachineNetworkConfigResult': {'additionalProperties': False,
                                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                   'info': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                            'type': 'array'}},
                                                    'required': ['info'],
                                                    'type': 'object'},
                     'MachineNetworkConfigResults': {'additionalProperties': False,
                                                     'properties': {'results': {'items': {'$ref': '#/definitions/MachineNetworkConfigResult'},
                                                                                'type': 'array'}},
                                                     'required': ['results'],
                                                     'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                    'type': 'array'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'is-default-gateway': {'type': 'boolean'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'origin': {'type': 'string'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-network-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'shadow-addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                           'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-network-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'ProvisioningInfoBase': {'additionalProperties': False,
                                              'properties': {'charm-lxd-profiles': {'items': {'type': 'string'},
                                                                                    'type': 'array'},
                                                             'cloudinit-userdata': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                 'type': 'object'}},
                                                                                    'type': 'object'},
                                                             'constraints': {'$ref': '#/definitions/Value'},
                                                             'controller-config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                'type': 'object'}},
                                                                                   'type': 'object'},
                                                             'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                   'type': 'object'},
                                                             'image-metadata': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                                'type': 'array'},
                                                             'jobs': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                             'placement': {'type': 'string'},
                                                             'series': {'type': 'string'},
                                                             'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                      'type': 'object'},
                                                             'volume-attachments': {'items': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                                                    'type': 'array'},
                                                             'volumes': {'items': {'$ref': '#/definitions/VolumeParams'},
                                                                         'type': 'array'}},
                                              'required': ['constraints',
                                                           'series',
                                                           'placement',
                                                           'jobs'],
                                              'type': 'object'},
                     'ProvisioningInfoResultV10': {'additionalProperties': False,
                                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                  'result': {'$ref': '#/definitions/ProvisioningInfoV10'}},
                                                   'required': ['result'],
                                                   'type': 'object'},
                     'ProvisioningInfoResultsV10': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/ProvisioningInfoResultV10'},
                                                                               'type': 'array'}},
                                                    'required': ['results'],
                                                    'type': 'object'},
                     'ProvisioningInfoV10': {'additionalProperties': False,
                                             'properties': {'ProvisioningInfoBase': {'$ref': '#/definitions/ProvisioningInfoBase'},
                                                            'ProvisioningNetworkTopology': {'$ref': '#/definitions/ProvisioningNetworkTopology'},
                                                            'charm-lxd-profiles': {'items': {'type': 'string'},
                                                                                   'type': 'array'},
                                                            'cloudinit-userdata': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                'type': 'object'}},
                                                                                   'type': 'object'},
                                                            'constraints': {'$ref': '#/definitions/Value'},
                                                            'controller-config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                               'type': 'object'}},
                                                                                  'type': 'object'},
                                                            'endpoint-bindings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                  'type': 'object'},
                                                            'image-metadata': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                               'type': 'array'},
                                                            'jobs': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                            'placement': {'type': 'string'},
                                                            'series': {'type': 'string'},
                                                            'space-subnets': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                           'type': 'array'}},
                                                                              'type': 'object'},
                                                            'subnet-zones': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                          'type': 'array'}},
                                                                             'type': 'object'},
                                                            'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                     'type': 'object'},
                                                            'volume-attachments': {'items': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                                                   'type': 'array'},
                                                            'volumes': {'items': {'$ref': '#/definitions/VolumeParams'},
                                                                        'type': 'array'}},
                                             'required': ['constraints',
                                                          'series',
                                                          'placement',
                                                          'jobs',
                                                          'ProvisioningInfoBase',
                                                          'subnet-zones',
                                                          'space-subnets',
                                                          'ProvisioningNetworkTopology'],
                                             'type': 'object'},
                     'ProvisioningNetworkTopology': {'additionalProperties': False,
                                                     'properties': {'space-subnets': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                                   'type': 'array'}},
                                                                                      'type': 'object'},
                                                                    'subnet-zones': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                                  'type': 'array'}},
                                                                                     'type': 'object'}},
                                                     'required': ['subnet-zones',
                                                                  'space-subnets'],
                                                     'type': 'object'},
                     'SetMachineNetworkConfig': {'additionalProperties': False,
                                                 'properties': {'config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                           'type': 'array'},
                                                                'tag': {'type': 'string'}},
                                                 'required': ['tag', 'config'],
                                                 'type': 'object'},
                     'SetProfileArg': {'additionalProperties': False,
                                       'properties': {'entity': {'$ref': '#/definitions/Entity'},
                                                      'profiles': {'items': {'type': 'string'},
                                                                   'type': 'array'}},
                                       'required': ['entity', 'profiles'],
                                       'type': 'object'},
                     'SetProfileArgs': {'additionalProperties': False,
                                        'properties': {'args': {'items': {'$ref': '#/definitions/SetProfileArg'},
                                                                'type': 'array'}},
                                        'required': ['args'],
                                        'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'Settings': {'additionalProperties': False,
                                  'properties': {'AutoNoProxy': {'type': 'string'},
                                                 'Ftp': {'type': 'string'},
                                                 'Http': {'type': 'string'},
                                                 'Https': {'type': 'string'},
                                                 'NoProxy': {'type': 'string'}},
                                  'required': ['Http',
                                               'Https',
                                               'Ftp',
                                               'NoProxy',
                                               'AutoNoProxy'],
                                  'type': 'object'},
                     'StatusResult': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'id': {'type': 'string'},
                                                     'info': {'type': 'string'},
                                                     'life': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['id',
                                                   'life',
                                                   'status',
                                                   'info',
                                                   'data',
                                                   'since'],
                                      'type': 'object'},
                     'StatusResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StatusResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'ToolsResult': {'additionalProperties': False,
                                     'properties': {'disable-ssl-hostname-verification': {'type': 'boolean'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'tools': {'items': {'$ref': '#/definitions/Tools'},
                                                              'type': 'array'}},
                                     'required': ['tools',
                                                  'disable-ssl-hostname-verification'],
                                     'type': 'object'},
                     'ToolsResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ToolsResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'UpdateBehavior': {'additionalProperties': False,
                                        'properties': {'enable-os-refresh-update': {'type': 'boolean'},
                                                       'enable-os-upgrade': {'type': 'boolean'}},
                                        'required': ['enable-os-refresh-update',
                                                     'enable-os-upgrade'],
                                        'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'},
                     'Volume': {'additionalProperties': False,
                                'properties': {'info': {'$ref': '#/definitions/VolumeInfo'},
                                               'volume-tag': {'type': 'string'}},
                                'required': ['volume-tag', 'info'],
                                'type': 'object'},
                     'VolumeAttachmentInfo': {'additionalProperties': False,
                                              'properties': {'bus-address': {'type': 'string'},
                                                             'device-link': {'type': 'string'},
                                                             'device-name': {'type': 'string'},
                                                             'plan-info': {'$ref': '#/definitions/VolumeAttachmentPlanInfo'},
                                                             'read-only': {'type': 'boolean'}},
                                              'type': 'object'},
                     'VolumeAttachmentParams': {'additionalProperties': False,
                                                'properties': {'instance-id': {'type': 'string'},
                                                               'machine-tag': {'type': 'string'},
                                                               'provider': {'type': 'string'},
                                                               'read-only': {'type': 'boolean'},
                                                               'volume-id': {'type': 'string'},
                                                               'volume-tag': {'type': 'string'}},
                                                'required': ['volume-tag',
                                                             'machine-tag',
                                                             'provider'],
                                                'type': 'object'},
                     'VolumeAttachmentPlanInfo': {'additionalProperties': False,
                                                  'properties': {'device-attributes': {'patternProperties': {'.*': {'type': 'string'}},
                                                                                       'type': 'object'},
                                                                 'device-type': {'type': 'string'}},
                                                  'type': 'object'},
                     'VolumeInfo': {'additionalProperties': False,
                                    'properties': {'hardware-id': {'type': 'string'},
                                                   'persistent': {'type': 'boolean'},
                                                   'pool': {'type': 'string'},
                                                   'size': {'type': 'integer'},
                                                   'volume-id': {'type': 'string'},
                                                   'wwn': {'type': 'string'}},
                                    'required': ['volume-id', 'size', 'persistent'],
                                    'type': 'object'},
                     'VolumeParams': {'additionalProperties': False,
                                      'properties': {'attachment': {'$ref': '#/definitions/VolumeAttachmentParams'},
                                                     'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                 'type': 'object'}},
                                                                    'type': 'object'},
                                                     'provider': {'type': 'string'},
                                                     'size': {'type': 'integer'},
                                                     'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                              'type': 'object'},
                                                     'volume-tag': {'type': 'string'}},
                                      'required': ['volume-tag',
                                                   'size',
                                                   'provider'],
                                      'type': 'object'},
                     'WatchContainer': {'additionalProperties': False,
                                        'properties': {'container-type': {'type': 'string'},
                                                       'machine-tag': {'type': 'string'}},
                                        'required': ['machine-tag',
                                                     'container-type'],
                                        'type': 'object'},
                     'WatchContainers': {'additionalProperties': False,
                                         'properties': {'params': {'items': {'$ref': '#/definitions/WatchContainer'},
                                                                   'type': 'array'}},
                                         'required': ['params'],
                                         'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'AvailabilityZone': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/StringResults'}},
                                         'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'Constraints': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ConstraintsResults'}},
                                    'type': 'object'},
                    'ContainerConfig': {'properties': {'Result': {'$ref': '#/definitions/ContainerConfig'}},
                                        'type': 'object'},
                    'ContainerManagerConfig': {'properties': {'Params': {'$ref': '#/definitions/ContainerManagerConfigParams'},
                                                              'Result': {'$ref': '#/definitions/ContainerManagerConfig'}},
                                               'type': 'object'},
                    'ControllerAPIInfoForModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'DistributionGroup': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/DistributionGroupResults'}},
                                          'type': 'object'},
                    'DistributionGroupByMachineId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                    'Result': {'$ref': '#/definitions/StringsResults'}},
                                                     'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'FindTools': {'properties': {'Params': {'$ref': '#/definitions/FindToolsParams'},
                                                 'Result': {'$ref': '#/definitions/FindToolsResult'}},
                                  'type': 'object'},
                    'GetContainerInterfaceInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/MachineNetworkConfigResults'}},
                                                  'type': 'object'},
                    'GetContainerProfileInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/ContainerProfileResults'}},
                                                'type': 'object'},
                    'HostChangesForContainers': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/HostNetworkChangeResults'}},
                                                 'type': 'object'},
                    'InstanceId': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringResults'}},
                                   'type': 'object'},
                    'InstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StatusResults'}},
                                       'type': 'object'},
                    'KeepInstance': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/BoolResults'}},
                                     'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'MachinesWithTransientErrors': {'properties': {'Result': {'$ref': '#/definitions/StatusResults'}},
                                                    'type': 'object'},
                    'MarkMachinesForRemoval': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'ModelConfig': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'PrepareContainerInterfaceInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                     'Result': {'$ref': '#/definitions/MachineNetworkConfigResults'}},
                                                      'type': 'object'},
                    'ProvisioningInfo': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/ProvisioningInfoResultsV10'}},
                                         'type': 'object'},
                    'ReleaseContainerAddresses': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                  'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'Series': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StringResults'}},
                               'type': 'object'},
                    'SetCharmProfiles': {'properties': {'Params': {'$ref': '#/definitions/SetProfileArgs'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'SetHostMachineNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                    'type': 'object'},
                    'SetInstanceInfo': {'properties': {'Params': {'$ref': '#/definitions/InstancesInfo'},
                                                       'Result': {'$ref': '#/definitions/ErrorResults'}},
                                        'type': 'object'},
                    'SetInstanceStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SetModificationStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                                              'type': 'object'},
                    'SetObservedNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                 'type': 'object'},
                    'SetPasswords': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'SetProviderNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetSupportedContainers': {'properties': {'Params': {'$ref': '#/definitions/MachineContainersParams'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'StateAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                       'type': 'object'},
                    'Status': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/StatusResults'}},
                               'type': 'object'},
                    'SupportedContainers': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/MachineContainerResults'}},
                                            'type': 'object'},
                    'Tools': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/ToolsResults'}},
                              'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchAllContainers': {'properties': {'Params': {'$ref': '#/definitions/WatchContainers'},
                                                          'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                           'type': 'object'},
                    'WatchContainers': {'properties': {'Params': {'$ref': '#/definitions/WatchContainers'},
                                                       'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                        'type': 'object'},
                    'WatchForModelConfigChanges': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'},
                    'WatchMachineErrorRetry': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                               'type': 'object'},
                    'WatchModelMachineStartTimes': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                                    'type': 'object'},
                    'WatchModelMachines': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='APIAddresses',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='APIHostPorts',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def AvailabilityZone(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='AvailabilityZone',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> BytesResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='CACert',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ConstraintsResults)
    async def Constraints(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ConstraintsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Constraints',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerConfig)
    async def ContainerConfig(self):
        '''

        Returns -> ContainerConfig
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ContainerConfig',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerManagerConfig)
    async def ContainerManagerConfig(self, type_=None):
        '''
        type_ : str
        Returns -> ContainerManagerConfig
        '''
        if type_ is not None and not isinstance(type_, (bytes, str)):
            raise Exception("Expected type_ to be a str, received: {}".format(type(type_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ContainerManagerConfig',
                   version=10,
                   params=_params)
        _params['type'] = type_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ControllerAPIInfoForModels',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ControllerConfig',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DistributionGroupResults)
    async def DistributionGroup(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> DistributionGroupResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='DistributionGroup',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def DistributionGroupByMachineId(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='DistributionGroupByMachineId',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='EnsureDead',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindToolsResult)
    async def FindTools(self, agentstream=None, arch=None, major=None, minor=None, number=None, series=None):
        '''
        agentstream : str
        arch : str
        major : int
        minor : int
        number : Number
        series : str
        Returns -> FindToolsResult
        '''
        if agentstream is not None and not isinstance(agentstream, (bytes, str)):
            raise Exception("Expected agentstream to be a str, received: {}".format(type(agentstream)))

        if arch is not None and not isinstance(arch, (bytes, str)):
            raise Exception("Expected arch to be a str, received: {}".format(type(arch)))

        if major is not None and not isinstance(major, int):
            raise Exception("Expected major to be a int, received: {}".format(type(major)))

        if minor is not None and not isinstance(minor, int):
            raise Exception("Expected minor to be a int, received: {}".format(type(minor)))

        if number is not None and not isinstance(number, (dict, Number)):
            raise Exception("Expected number to be a Number, received: {}".format(type(number)))

        if series is not None and not isinstance(series, (bytes, str)):
            raise Exception("Expected series to be a str, received: {}".format(type(series)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='FindTools',
                   version=10,
                   params=_params)
        _params['agentstream'] = agentstream
        _params['arch'] = arch
        _params['major'] = major
        _params['minor'] = minor
        _params['number'] = number
        _params['series'] = series
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineNetworkConfigResults)
    async def GetContainerInterfaceInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachineNetworkConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='GetContainerInterfaceInfo',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ContainerProfileResults)
    async def GetContainerProfileInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ContainerProfileResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='GetContainerProfileInfo',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(HostNetworkChangeResults)
    async def HostChangesForContainers(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> HostNetworkChangeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='HostChangesForContainers',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def InstanceId(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='InstanceId',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def InstanceStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='InstanceStatus',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResults)
    async def KeepInstance(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> BoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='KeepInstance',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Life',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def MachinesWithTransientErrors(self):
        '''

        Returns -> StatusResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='MachinesWithTransientErrors',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def MarkMachinesForRemoval(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='MarkMachinesForRemoval',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''

        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ModelConfig',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ModelUUID',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineNetworkConfigResults)
    async def PrepareContainerInterfaceInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachineNetworkConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='PrepareContainerInterfaceInfo',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProvisioningInfoResultsV10)
    async def ProvisioningInfo(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ProvisioningInfoResultsV10
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ProvisioningInfo',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ReleaseContainerAddresses(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='ReleaseContainerAddresses',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Remove',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def Series(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Series',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetCharmProfiles(self, args=None):
        '''
        args : typing.Sequence[~SetProfileArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetCharmProfiles',
                   version=10,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetHostMachineNetworkConfig(self, config=None, tag=None):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetHostMachineNetworkConfig',
                   version=10,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceInfo(self, machines=None):
        '''
        machines : typing.Sequence[~InstanceInfo]
        Returns -> ErrorResults
        '''
        if machines is not None and not isinstance(machines, (bytes, str, list)):
            raise Exception("Expected machines to be a Sequence, received: {}".format(type(machines)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetInstanceInfo',
                   version=10,
                   params=_params)
        _params['machines'] = machines
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetInstanceStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetInstanceStatus',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModificationStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetModificationStatus',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetObservedNetworkConfig(self, config=None, tag=None):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetObservedNetworkConfig',
                   version=10,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes=None):
        '''
        changes : typing.Sequence[~EntityPassword]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetPasswords',
                   version=10,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetProviderNetworkConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetProviderNetworkConfig',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetStatus',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetSupportedContainers(self, params=None):
        '''
        params : typing.Sequence[~MachineContainers]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SetSupportedContainers',
                   version=10,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResult)
    async def StateAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='StateAddresses',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusResults)
    async def Status(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Status',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MachineContainerResults)
    async def SupportedContainers(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MachineContainerResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='SupportedContainers',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ToolsResults)
    async def Tools(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ToolsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='Tools',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='UpdateStatus',
                   version=10,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchAPIHostPorts',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchAllContainers(self, params=None):
        '''
        params : typing.Sequence[~WatchContainer]
        Returns -> StringsWatchResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchAllContainers',
                   version=10,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchContainers(self, params=None):
        '''
        params : typing.Sequence[~WatchContainer]
        Returns -> StringsWatchResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchContainers',
                   version=10,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchForModelConfigChanges',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchMachineErrorRetry(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchMachineErrorRetry',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachineStartTimes(self):
        '''

        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchModelMachineStartTimes',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchModelMachines(self):
        '''

        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Provisioner',
                   request='WatchModelMachines',
                   version=10,
                   params=_params)

        reply = await self.rpc(msg)
        return reply


