# DO NOT CHANGE THIS FILE! This file is auto-generated by facade.py.
# Changes will be overwritten/lost when the file is regenerated.

from juju.client.facade import Type, ReturnMapping
from juju.client._definitions import *


class ActionPrunerFacade(Type):
    name = 'ActionPruner'
    version = 1
    schema =     {'definitions': {'ActionPruneArgs': {'additionalProperties': False,
                                         'properties': {'max-history-mb': {'type': 'integer'},
                                                        'max-history-time': {'type': 'integer'}},
                                         'required': ['max-history-time',
                                                      'max-history-mb'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'}},
     'properties': {'ModelConfig': {'description': 'ModelConfig returns the '
                                                   "current model's configuration.",
                                    'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'Prune': {'properties': {'Params': {'$ref': '#/definitions/ActionPruneArgs'}},
                              'type': 'object'},
                    'WatchForModelConfigChanges': {'description': 'WatchForModelConfigChanges '
                                                                  'returns a '
                                                                  'NotifyWatcher '
                                                                  'that observes\n'
                                                                  'changes to the '
                                                                  'model '
                                                                  'configuration.\n'
                                                                  'Note that '
                                                                  'although the '
                                                                  'NotifyWatchResult '
                                                                  'contains an '
                                                                  'Error field,\n'
                                                                  "it's not used "
                                                                  'because we are '
                                                                  'only returning '
                                                                  'a single '
                                                                  'watcher,\n'
                                                                  'so we use the '
                                                                  'regular error '
                                                                  'return.',
                                                   'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''
        ModelConfig returns the current model's configuration.


        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ActionPruner',
                   request='ModelConfig',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Prune(self, max_history_mb=None, max_history_time=None):
        '''
        max_history_mb : int
        max_history_time : int
        Returns -> None
        '''
        if max_history_mb is not None and not isinstance(max_history_mb, int):
            raise Exception("Expected max_history_mb to be a int, received: {}".format(type(max_history_mb)))

        if max_history_time is not None and not isinstance(max_history_time, int):
            raise Exception("Expected max_history_time to be a int, received: {}".format(type(max_history_time)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ActionPruner',
                   request='Prune',
                   version=1,
                   params=_params)
        _params['max-history-mb'] = max_history_mb
        _params['max-history-time'] = max_history_time
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''
        WatchForModelConfigChanges returns a NotifyWatcher that observes
        changes to the model configuration.
        Note that although the NotifyWatchResult contains an Error field,
        it's not used because we are only returning a single watcher,
        so we use the regular error return.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ActionPruner',
                   request='WatchForModelConfigChanges',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class AgentToolsFacade(Type):
    name = 'AgentTools'
    version = 1
    schema =     {'properties': {'UpdateToolsAvailable': {'description': 'UpdateToolsAvailable '
                                                            'invokes a lookup and '
                                                            'further update in '
                                                            'environ\n'
                                                            'for new patches of '
                                                            'the current tool '
                                                            'versions.',
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def UpdateToolsAvailable(self):
        '''
        UpdateToolsAvailable invokes a lookup and further update in environ
        for new patches of the current tool versions.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AgentTools',
                   request='UpdateToolsAvailable',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class AllWatcherFacade(Type):
    name = 'AllWatcher'
    version = 1
    schema =     {'definitions': {'AllWatcherNextResults': {'additionalProperties': False,
                                               'properties': {'deltas': {'items': {'$ref': '#/definitions/Delta'},
                                                                         'type': 'array'}},
                                               'required': ['deltas'],
                                               'type': 'object'},
                     'Delta': {'additionalProperties': False,
                               'properties': {'entity': {'additionalProperties': True,
                                                         'type': 'object'},
                                              'removed': {'type': 'boolean'}},
                               'required': ['removed', 'entity'],
                               'type': 'object'}},
     'properties': {'Next': {'description': 'Next will return the current state of '
                                            'everything on the first call\n'
                                            'and subsequent calls will',
                             'properties': {'Result': {'$ref': '#/definitions/AllWatcherNextResults'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AllWatcherNextResults)
    async def Next(self):
        '''
        Next will return the current state of everything on the first call
        and subsequent calls will


        Returns -> AllWatcherNextResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='AllWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ApplicationRelationsWatcherFacade(Type):
    name = 'ApplicationRelationsWatcher'
    version = 1
    schema =     {'definitions': {'ApplicationRelationsChange': {'additionalProperties': False,
                                                    'properties': {'changed': {'items': {'$ref': '#/definitions/RelationChange'},
                                                                               'type': 'array'},
                                                                   'removed': {'items': {'type': 'integer'},
                                                                               'type': 'array'}},
                                                    'type': 'object'},
                     'ApplicationRelationsWatchResult': {'additionalProperties': False,
                                                         'properties': {'ApplicationRelationsWatcherId': {'type': 'string'},
                                                                        'changes': {'$ref': '#/definitions/ApplicationRelationsChange'},
                                                                        'error': {'$ref': '#/definitions/Error'}},
                                                         'required': ['ApplicationRelationsWatcherId'],
                                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RelationChange': {'additionalProperties': False,
                                        'properties': {'changedunits': {'patternProperties': {'.*': {'$ref': '#/definitions/RelationUnitChange'}},
                                                                        'type': 'object'},
                                                       'departedunits': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                       'id': {'type': 'integer'},
                                                       'life': {'type': 'string'}},
                                        'required': ['id', 'life'],
                                        'type': 'object'},
                     'RelationUnitChange': {'additionalProperties': False,
                                            'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                     'type': 'object'}},
                                                                        'type': 'object'}},
                                            'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/ApplicationRelationsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ApplicationRelationsWatchResult)
    async def Next(self):
        '''

        Returns -> ApplicationRelationsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationRelationsWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationRelationsWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ApplicationScalerFacade(Type):
    name = 'ApplicationScaler'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'Rescale': {'description': 'Rescale causes any supplied '
                                               'services to be scaled up to their\n'
                                               'minimum size.',
                                'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'Watch': {'description': 'Watch returns a watcher that sends '
                                             'the names of services whose\n'
                                             'unit count may be below their '
                                             'configured minimum.',
                              'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Rescale(self, entities=None):
        '''
        Rescale causes any supplied services to be scaled up to their
        minimum size.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationScaler',
                   request='Rescale',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def Watch(self):
        '''
        Watch returns a watcher that sends the names of services whose
        unit count may be below their configured minimum.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ApplicationScaler',
                   request='Watch',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class BackupsFacade(Type):
    name = 'Backups'
    version = 1
    schema =     {'definitions': {'BackupsCreateArgs': {'additionalProperties': False,
                                           'properties': {'notes': {'type': 'string'}},
                                           'required': ['notes'],
                                           'type': 'object'},
                     'BackupsInfoArgs': {'additionalProperties': False,
                                         'properties': {'id': {'type': 'string'}},
                                         'required': ['id'],
                                         'type': 'object'},
                     'BackupsListArgs': {'additionalProperties': False,
                                         'type': 'object'},
                     'BackupsListResult': {'additionalProperties': False,
                                           'properties': {'list': {'items': {'$ref': '#/definitions/BackupsMetadataResult'},
                                                                   'type': 'array'}},
                                           'required': ['list'],
                                           'type': 'object'},
                     'BackupsMetadataResult': {'additionalProperties': False,
                                               'properties': {'ca-cert': {'type': 'string'},
                                                              'ca-private-key': {'type': 'string'},
                                                              'checksum': {'type': 'string'},
                                                              'checksum-format': {'type': 'string'},
                                                              'finished': {'format': 'date-time',
                                                                           'type': 'string'},
                                                              'hostname': {'type': 'string'},
                                                              'id': {'type': 'string'},
                                                              'machine': {'type': 'string'},
                                                              'model': {'type': 'string'},
                                                              'notes': {'type': 'string'},
                                                              'series': {'type': 'string'},
                                                              'size': {'type': 'integer'},
                                                              'started': {'format': 'date-time',
                                                                          'type': 'string'},
                                                              'stored': {'format': 'date-time',
                                                                         'type': 'string'},
                                                              'version': {'$ref': '#/definitions/Number'}},
                                               'required': ['id',
                                                            'checksum',
                                                            'checksum-format',
                                                            'size',
                                                            'stored',
                                                            'started',
                                                            'finished',
                                                            'notes',
                                                            'model',
                                                            'machine',
                                                            'hostname',
                                                            'version',
                                                            'series',
                                                            'ca-cert',
                                                            'ca-private-key'],
                                               'type': 'object'},
                     'BackupsRemoveArgs': {'additionalProperties': False,
                                           'properties': {'id': {'type': 'string'}},
                                           'required': ['id'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'RestoreArgs': {'additionalProperties': False,
                                     'properties': {'backup-id': {'type': 'string'}},
                                     'required': ['backup-id'],
                                     'type': 'object'}},
     'properties': {'Create': {'properties': {'Params': {'$ref': '#/definitions/BackupsCreateArgs'},
                                              'Result': {'$ref': '#/definitions/BackupsMetadataResult'}},
                               'type': 'object'},
                    'FinishRestore': {'type': 'object'},
                    'Info': {'properties': {'Params': {'$ref': '#/definitions/BackupsInfoArgs'},
                                            'Result': {'$ref': '#/definitions/BackupsMetadataResult'}},
                             'type': 'object'},
                    'List': {'properties': {'Params': {'$ref': '#/definitions/BackupsListArgs'},
                                            'Result': {'$ref': '#/definitions/BackupsListResult'}},
                             'type': 'object'},
                    'PrepareRestore': {'type': 'object'},
                    'Remove': {'properties': {'Params': {'$ref': '#/definitions/BackupsRemoveArgs'}},
                               'type': 'object'},
                    'Restore': {'properties': {'Params': {'$ref': '#/definitions/RestoreArgs'}},
                                'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BackupsMetadataResult)
    async def Create(self, notes=None):
        '''
        notes : str
        Returns -> BackupsMetadataResult
        '''
        if notes is not None and not isinstance(notes, (bytes, str)):
            raise Exception("Expected notes to be a str, received: {}".format(type(notes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Create',
                   version=1,
                   params=_params)
        _params['notes'] = notes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def FinishRestore(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='FinishRestore',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BackupsMetadataResult)
    async def Info(self, id_=None):
        '''
        id_ : str
        Returns -> BackupsMetadataResult
        '''
        if id_ is not None and not isinstance(id_, (bytes, str)):
            raise Exception("Expected id_ to be a str, received: {}".format(type(id_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Info',
                   version=1,
                   params=_params)
        _params['id'] = id_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BackupsListResult)
    async def List(self):
        '''

        Returns -> BackupsListResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='List',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def PrepareRestore(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='PrepareRestore',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Remove(self, id_=None):
        '''
        id_ : str
        Returns -> None
        '''
        if id_ is not None and not isinstance(id_, (bytes, str)):
            raise Exception("Expected id_ to be a str, received: {}".format(type(id_)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Remove',
                   version=1,
                   params=_params)
        _params['id'] = id_
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Restore(self, backup_id=None):
        '''
        backup_id : str
        Returns -> None
        '''
        if backup_id is not None and not isinstance(backup_id, (bytes, str)):
            raise Exception("Expected backup_id to be a str, received: {}".format(type(backup_id)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Backups',
                   request='Restore',
                   version=1,
                   params=_params)
        _params['backup-id'] = backup_id
        reply = await self.rpc(msg)
        return reply



class BundleFacade(Type):
    name = 'Bundle'
    version = 1
    schema =     {'definitions': {'BundleChange': {'additionalProperties': False,
                                      'properties': {'args': {'items': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                              'type': 'array'},
                                                     'id': {'type': 'string'},
                                                     'method': {'type': 'string'},
                                                     'requires': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['id',
                                                   'method',
                                                   'args',
                                                   'requires'],
                                      'type': 'object'},
                     'BundleChangesParams': {'additionalProperties': False,
                                             'properties': {'yaml': {'type': 'string'}},
                                             'required': ['yaml'],
                                             'type': 'object'},
                     'BundleChangesResults': {'additionalProperties': False,
                                              'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChange'},
                                                                         'type': 'array'},
                                                             'errors': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                              'type': 'object'}},
     'properties': {'GetChanges': {'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                  'Result': {'$ref': '#/definitions/BundleChangesResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(BundleChangesResults)
    async def GetChanges(self, yaml=None):
        '''
        yaml : str
        Returns -> BundleChangesResults
        '''
        if yaml is not None and not isinstance(yaml, (bytes, str)):
            raise Exception("Expected yaml to be a str, received: {}".format(type(yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Bundle',
                   request='GetChanges',
                   version=1,
                   params=_params)
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



class CAASAdmissionFacade(Type):
    name = 'CAASAdmission'
    version = 1
    schema =     {'definitions': {'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'}},
     'properties': {'ControllerAPIInfoForModels': {'description': 'ControllerAPIInfoForModels '
                                                                  'returns the '
                                                                  'controller api '
                                                                  'connection '
                                                                  'details for the '
                                                                  'specified '
                                                                  'models.',
                                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'description': 'ControllerConfig returns '
                                                        "the controller's "
                                                        'configuration.',
                                         'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        ControllerAPIInfoForModels returns the controller api connection details for the specified models.

        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASAdmission',
                   request='ControllerAPIInfoForModels',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''
        ControllerConfig returns the controller's configuration.


        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASAdmission',
                   request='ControllerConfig',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CAASAgentFacade(Type):
    name = 'CAASAgent'
    version = 1
    schema =     {'definitions': {'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudSpec': {'additionalProperties': False,
                                   'properties': {'cacertificates': {'items': {'type': 'string'},
                                                                     'type': 'array'},
                                                  'credential': {'$ref': '#/definitions/CloudCredential'},
                                                  'endpoint': {'type': 'string'},
                                                  'identity-endpoint': {'type': 'string'},
                                                  'name': {'type': 'string'},
                                                  'region': {'type': 'string'},
                                                  'storage-endpoint': {'type': 'string'},
                                                  'type': {'type': 'string'}},
                                   'required': ['type', 'name'],
                                   'type': 'object'},
                     'CloudSpecResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'result': {'$ref': '#/definitions/CloudSpec'}},
                                         'type': 'object'},
                     'CloudSpecResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/CloudSpecResult'},
                                                                     'type': 'array'}},
                                          'type': 'object'},
                     'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'ModelTag': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'CloudSpec': {'description': "CloudSpec returns the model's "
                                                 'cloud spec.',
                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/CloudSpecResults'}},
                                  'type': 'object'},
                    'ControllerAPIInfoForModels': {'description': 'ControllerAPIInfoForModels '
                                                                  'returns the '
                                                                  'controller api '
                                                                  'connection '
                                                                  'details for the '
                                                                  'specified '
                                                                  'models.',
                                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'description': 'ControllerConfig returns '
                                                        "the controller's "
                                                        'configuration.',
                                         'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'GetCloudSpec': {'description': 'GetCloudSpec constructs the '
                                                    'CloudSpec for a validated and '
                                                    'authorized model.',
                                     'properties': {'Params': {'$ref': '#/definitions/ModelTag'},
                                                    'Result': {'$ref': '#/definitions/CloudSpecResult'}},
                                     'type': 'object'},
                    'ModelConfig': {'description': 'ModelConfig returns the '
                                                   "current model's configuration.",
                                    'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'WatchCloudSpecsChanges': {'description': 'WatchCloudSpecsChanges '
                                                              'returns a watcher '
                                                              'for cloud spec '
                                                              'changes.',
                                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                               'type': 'object'},
                    'WatchForModelConfigChanges': {'description': 'WatchForModelConfigChanges '
                                                                  'returns a '
                                                                  'NotifyWatcher '
                                                                  'that observes\n'
                                                                  'changes to the '
                                                                  'model '
                                                                  'configuration.\n'
                                                                  'Note that '
                                                                  'although the '
                                                                  'NotifyWatchResult '
                                                                  'contains an '
                                                                  'Error field,\n'
                                                                  "it's not used "
                                                                  'because we are '
                                                                  'only returning '
                                                                  'a single '
                                                                  'watcher,\n'
                                                                  'so we use the '
                                                                  'regular error '
                                                                  'return.',
                                                   'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(CloudSpecResults)
    async def CloudSpec(self, entities=None):
        '''
        CloudSpec returns the model's cloud spec.

        entities : typing.Sequence[~Entity]
        Returns -> CloudSpecResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASAgent',
                   request='CloudSpec',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        ControllerAPIInfoForModels returns the controller api connection details for the specified models.

        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASAgent',
                   request='ControllerAPIInfoForModels',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''
        ControllerConfig returns the controller's configuration.


        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASAgent',
                   request='ControllerConfig',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudSpecResult)
    async def GetCloudSpec(self):
        '''
        GetCloudSpec constructs the CloudSpec for a validated and authorized model.


        Returns -> CloudSpecResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASAgent',
                   request='GetCloudSpec',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''
        ModelConfig returns the current model's configuration.


        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASAgent',
                   request='ModelConfig',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchCloudSpecsChanges(self, entities=None):
        '''
        WatchCloudSpecsChanges returns a watcher for cloud spec changes.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASAgent',
                   request='WatchCloudSpecsChanges',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForModelConfigChanges(self):
        '''
        WatchForModelConfigChanges returns a NotifyWatcher that observes
        changes to the model configuration.
        Note that although the NotifyWatchResult contains an Error field,
        it's not used because we are only returning a single watcher,
        so we use the regular error return.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASAgent',
                   request='WatchForModelConfigChanges',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CAASFirewallerFacade(Type):
    name = 'CAASFirewaller'
    version = 1
    schema =     {'definitions': {'ApplicationGetConfigResults': {'additionalProperties': False,
                                                     'properties': {'Results': {'items': {'$ref': '#/definitions/ConfigResult'},
                                                                                'type': 'array'}},
                                                     'required': ['Results'],
                                                     'type': 'object'},
                     'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BoolResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/BoolResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'ConfigResult': {'additionalProperties': False,
                                      'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'}},
                                      'required': ['config'],
                                      'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'ApplicationsConfig': {'description': 'ApplicationsConfig '
                                                          'returns the config for '
                                                          'the specified '
                                                          'applications.',
                                           'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/ApplicationGetConfigResults'}},
                                           'type': 'object'},
                    'IsExposed': {'description': 'IsExposed returns whether the '
                                                 'specified applications are '
                                                 'exposed.',
                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/BoolResults'}},
                                  'type': 'object'},
                    'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'Watch': {'description': 'Watch starts an NotifyWatcher for '
                                             'each given entity.',
                              'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchApplications': {'description': 'WatchApplications starts '
                                                         'a StringsWatcher to '
                                                         'watch CAAS applications\n'
                                                         'deployed to this model.',
                                          'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                          'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ApplicationGetConfigResults)
    async def ApplicationsConfig(self, entities=None):
        '''
        ApplicationsConfig returns the config for the specified applications.

        entities : typing.Sequence[~Entity]
        Returns -> ApplicationGetConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASFirewaller',
                   request='ApplicationsConfig',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResults)
    async def IsExposed(self, entities=None):
        '''
        IsExposed returns whether the specified applications are exposed.

        entities : typing.Sequence[~Entity]
        Returns -> BoolResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASFirewaller',
                   request='IsExposed',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASFirewaller',
                   request='Life',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities=None):
        '''
        Watch starts an NotifyWatcher for each given entity.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASFirewaller',
                   request='Watch',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchApplications(self):
        '''
        WatchApplications starts a StringsWatcher to watch CAAS applications
        deployed to this model.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASFirewaller',
                   request='WatchApplications',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CAASModelOperatorFacade(Type):
    name = 'CAASModelOperator'
    version = 1
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'ModelOperatorInfo': {'additionalProperties': False,
                                           'properties': {'api-addresses': {'items': {'type': 'string'},
                                                                            'type': 'array'},
                                                          'image-path': {'type': 'string'},
                                                          'version': {'$ref': '#/definitions/Number'}},
                                           'required': ['api-addresses',
                                                        'image-path',
                                                        'version'],
                                           'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'}},
     'properties': {'APIAddresses': {'description': 'APIAddresses returns the list '
                                                    'of addresses used to connect '
                                                    'to the API.',
                                     'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'description': 'APIHostPorts returns the API '
                                                    'server addresses.',
                                     'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'ModelOperatorProvisioningInfo': {'description': 'ModelOperatorProvisioningInfo '
                                                                     'returns the '
                                                                     'information '
                                                                     'needed for '
                                                                     'provisioning\n'
                                                                     'a new model '
                                                                     'operator '
                                                                     'into a caas '
                                                                     'cluster.',
                                                      'properties': {'Result': {'$ref': '#/definitions/ModelOperatorInfo'}},
                                                      'type': 'object'},
                    'ModelUUID': {'description': 'ModelUUID returns the model UUID '
                                                 'to connect to the model\n'
                                                 'that the current connection is '
                                                 'for.',
                                  'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'SetPasswords': {'description': 'SetPasswords sets the given '
                                                    'password for each supplied '
                                                    'entity, if possible.',
                                     'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchAPIHostPorts': {'description': 'WatchAPIHostPorts '
                                                         'watches the API server '
                                                         'addresses.',
                                          'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''
        APIAddresses returns the list of addresses used to connect to the API.


        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASModelOperator',
                   request='APIAddresses',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''
        APIHostPorts returns the API server addresses.


        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASModelOperator',
                   request='APIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelOperatorInfo)
    async def ModelOperatorProvisioningInfo(self):
        '''
        ModelOperatorProvisioningInfo returns the information needed for provisioning
        a new model operator into a caas cluster.


        Returns -> ModelOperatorInfo
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASModelOperator',
                   request='ModelOperatorProvisioningInfo',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''
        ModelUUID returns the model UUID to connect to the model
        that the current connection is for.


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASModelOperator',
                   request='ModelUUID',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes=None):
        '''
        SetPasswords sets the given password for each supplied entity, if possible.

        changes : typing.Sequence[~EntityPassword]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASModelOperator',
                   request='SetPasswords',
                   version=1,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''
        WatchAPIHostPorts watches the API server addresses.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASModelOperator',
                   request='WatchAPIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CAASOperatorFacade(Type):
    name = 'CAASOperator'
    version = 1
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'ApplicationCharm': {'additionalProperties': False,
                                          'properties': {'charm-modified-version': {'type': 'integer'},
                                                         'deployment-mode': {'type': 'string'},
                                                         'force-upgrade': {'type': 'boolean'},
                                                         'sha256': {'type': 'string'},
                                                         'url': {'type': 'string'}},
                                          'required': ['url',
                                                       'sha256',
                                                       'charm-modified-version'],
                                          'type': 'object'},
                     'ApplicationCharmResult': {'additionalProperties': False,
                                                'properties': {'error': {'$ref': '#/definitions/Error'},
                                                               'result': {'$ref': '#/definitions/ApplicationCharm'}},
                                                'type': 'object'},
                     'ApplicationCharmResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/ApplicationCharmResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Patch': {'type': 'integer'},
                                               'Series': {'type': 'string'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build',
                                             'Number',
                                             'Series',
                                             'Arch'],
                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesVersion': {'additionalProperties': False,
                                         'properties': {'agent-tools': {'items': {'$ref': '#/definitions/EntityVersion'},
                                                                        'type': 'array'}},
                                         'required': ['agent-tools'],
                                         'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'EntityString': {'additionalProperties': False,
                                      'properties': {'tag': {'type': 'string'},
                                                     'value': {'type': 'string'}},
                                      'required': ['tag', 'value'],
                                      'type': 'object'},
                     'EntityVersion': {'additionalProperties': False,
                                       'properties': {'tag': {'type': 'string'},
                                                      'tools': {'$ref': '#/definitions/Version'}},
                                       'required': ['tag', 'tools'],
                                       'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'ModelResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'name': {'type': 'string'},
                                                    'type': {'type': 'string'},
                                                    'uuid': {'type': 'string'}},
                                     'required': ['name', 'uuid', 'type'],
                                     'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'SetPodSpecParams': {'additionalProperties': False,
                                          'properties': {'specs': {'items': {'$ref': '#/definitions/EntityString'},
                                                                   'type': 'array'}},
                                          'required': ['specs'],
                                          'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Version': {'additionalProperties': False,
                                 'properties': {'version': {'$ref': '#/definitions/Binary'}},
                                 'required': ['version'],
                                 'type': 'object'},
                     'WatchContainerStartArg': {'additionalProperties': False,
                                                'properties': {'container': {'type': 'string'},
                                                               'entity': {'$ref': '#/definitions/Entity'}},
                                                'required': ['entity'],
                                                'type': 'object'},
                     'WatchContainerStartArgs': {'additionalProperties': False,
                                                 'properties': {'args': {'items': {'$ref': '#/definitions/WatchContainerStartArg'},
                                                                         'type': 'array'}},
                                                 'required': ['args'],
                                                 'type': 'object'}},
     'properties': {'APIAddresses': {'description': 'APIAddresses returns the list '
                                                    'of addresses used to connect '
                                                    'to the API.',
                                     'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'description': 'APIHostPorts returns the API '
                                                    'server addresses.',
                                     'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'Charm': {'description': 'Charm returns the charm info for all '
                                             'given applications.',
                              'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/ApplicationCharmResults'}},
                              'type': 'object'},
                    'CurrentModel': {'description': 'CurrentModel returns the name '
                                                    'and UUID for the current juju '
                                                    'model.',
                                     'properties': {'Result': {'$ref': '#/definitions/ModelResult'}},
                                     'type': 'object'},
                    'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelUUID': {'description': 'ModelUUID returns the model UUID '
                                                 'to connect to the model\n'
                                                 'that the current connection is '
                                                 'for.',
                                  'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'Remove': {'description': 'Remove removes every given entity '
                                              'from state, calling EnsureDead\n'
                                              'first, then Remove. It will fail if '
                                              'the entity is not present.',
                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'SetPodSpec': {'description': 'SetPodSpec sets the container '
                                                  'specs for a set of '
                                                  'applications.\n'
                                                  'TODO(juju3) - remove',
                                   'properties': {'Params': {'$ref': '#/definitions/SetPodSpecParams'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'SetStatus': {'description': 'SetStatus sets the status of '
                                                 'each given entity.',
                                  'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'SetTools': {'description': 'SetTools updates the recorded '
                                                'tools version for the agents.',
                                 'properties': {'Params': {'$ref': '#/definitions/EntitiesVersion'},
                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                 'type': 'object'},
                    'Watch': {'description': 'Watch starts an NotifyWatcher for '
                                             'each given entity.',
                              'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchAPIHostPorts': {'description': 'WatchAPIHostPorts '
                                                         'watches the API server '
                                                         'addresses.',
                                          'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchContainerStart': {'description': 'WatchContainerStart '
                                                           'starts a StringWatcher '
                                                           'to watch for container '
                                                           'start events\n'
                                                           'on the CAAS api for a '
                                                           'specific application '
                                                           'and container.',
                                            'properties': {'Params': {'$ref': '#/definitions/WatchContainerStartArgs'},
                                                           'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                            'type': 'object'},
                    'WatchUnits': {'description': 'WatchUnits starts a '
                                                  'StringsWatcher to watch changes '
                                                  'to the\n'
                                                  'lifecycle states of units for '
                                                  'the specified applications in\n'
                                                  'this model.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''
        APIAddresses returns the list of addresses used to connect to the API.


        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='APIAddresses',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''
        APIHostPorts returns the API server addresses.


        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='APIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ApplicationCharmResults)
    async def Charm(self, entities=None):
        '''
        Charm returns the charm info for all given applications.

        entities : typing.Sequence[~Entity]
        Returns -> ApplicationCharmResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='Charm',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelResult)
    async def CurrentModel(self):
        '''
        CurrentModel returns the name and UUID for the current juju model.


        Returns -> ModelResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='CurrentModel',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='Life',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''
        ModelUUID returns the model UUID to connect to the model
        that the current connection is for.


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='ModelUUID',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities=None):
        '''
        Remove removes every given entity from state, calling EnsureDead
        first, then Remove. It will fail if the entity is not present.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='Remove',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPodSpec(self, specs=None):
        '''
        SetPodSpec sets the container specs for a set of applications.
        TODO(juju3) - remove

        specs : typing.Sequence[~EntityString]
        Returns -> ErrorResults
        '''
        if specs is not None and not isinstance(specs, (bytes, str, list)):
            raise Exception("Expected specs to be a Sequence, received: {}".format(type(specs)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='SetPodSpec',
                   version=1,
                   params=_params)
        _params['specs'] = specs
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        SetStatus sets the status of each given entity.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='SetStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetTools(self, agent_tools=None):
        '''
        SetTools updates the recorded tools version for the agents.

        agent_tools : typing.Sequence[~EntityVersion]
        Returns -> ErrorResults
        '''
        if agent_tools is not None and not isinstance(agent_tools, (bytes, str, list)):
            raise Exception("Expected agent_tools to be a Sequence, received: {}".format(type(agent_tools)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='SetTools',
                   version=1,
                   params=_params)
        _params['agent-tools'] = agent_tools
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities=None):
        '''
        Watch starts an NotifyWatcher for each given entity.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='Watch',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''
        WatchAPIHostPorts watches the API server addresses.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='WatchAPIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchContainerStart(self, args=None):
        '''
        WatchContainerStart starts a StringWatcher to watch for container start events
        on the CAAS api for a specific application and container.

        args : typing.Sequence[~WatchContainerStartArg]
        Returns -> StringsWatchResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='WatchContainerStart',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchUnits(self, entities=None):
        '''
        WatchUnits starts a StringsWatcher to watch changes to the
        lifecycle states of units for the specified applications in
        this model.

        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperator',
                   request='WatchUnits',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class CAASOperatorProvisionerFacade(Type):
    name = 'CAASOperatorProvisioner'
    version = 1
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'IssueOperatorCertificateResult': {'additionalProperties': False,
                                                        'properties': {'ca-cert': {'type': 'string'},
                                                                       'cert': {'type': 'string'},
                                                                       'error': {'$ref': '#/definitions/Error'},
                                                                       'private-key': {'type': 'string'}},
                                                        'required': ['ca-cert',
                                                                     'cert',
                                                                     'private-key'],
                                                        'type': 'object'},
                     'IssueOperatorCertificateResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/IssueOperatorCertificateResult'},
                                                                                    'type': 'array'}},
                                                         'required': ['results'],
                                                         'type': 'object'},
                     'KubernetesFilesystemAttachmentParams': {'additionalProperties': False,
                                                              'properties': {'mount-point': {'type': 'string'},
                                                                             'provider': {'type': 'string'},
                                                                             'read-only': {'type': 'boolean'}},
                                                              'required': ['provider'],
                                                              'type': 'object'},
                     'KubernetesFilesystemParams': {'additionalProperties': False,
                                                    'properties': {'attachment': {'$ref': '#/definitions/KubernetesFilesystemAttachmentParams'},
                                                                   'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                               'type': 'object'}},
                                                                                  'type': 'object'},
                                                                   'provider': {'type': 'string'},
                                                                   'size': {'type': 'integer'},
                                                                   'storagename': {'type': 'string'},
                                                                   'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                            'type': 'object'}},
                                                    'required': ['storagename',
                                                                 'size',
                                                                 'provider'],
                                                    'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'OperatorProvisioningInfo': {'additionalProperties': False,
                                                  'properties': {'api-addresses': {'items': {'type': 'string'},
                                                                                   'type': 'array'},
                                                                 'charm-storage': {'$ref': '#/definitions/KubernetesFilesystemParams'},
                                                                 'error': {'$ref': '#/definitions/Error'},
                                                                 'image-path': {'type': 'string'},
                                                                 'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                          'type': 'object'},
                                                                 'version': {'$ref': '#/definitions/Number'}},
                                                  'required': ['image-path',
                                                               'version',
                                                               'api-addresses'],
                                                  'type': 'object'},
                     'OperatorProvisioningInfoResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/OperatorProvisioningInfo'},
                                                                                    'type': 'array'}},
                                                         'required': ['results'],
                                                         'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'APIAddresses': {'description': 'APIAddresses returns the list '
                                                    'of addresses used to connect '
                                                    'to the API.',
                                     'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'description': 'APIHostPorts returns the API '
                                                    'server addresses.',
                                     'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'IssueOperatorCertificate': {'description': 'IssueOperatorCertificate '
                                                                'issues an x509 '
                                                                'certificate for '
                                                                'use by the '
                                                                'specified '
                                                                'application '
                                                                'operator.',
                                                 'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/IssueOperatorCertificateResults'}},
                                                 'type': 'object'},
                    'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelUUID': {'description': 'ModelUUID returns the model UUID '
                                                 'to connect to the model\n'
                                                 'that the current connection is '
                                                 'for.',
                                  'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'OperatorProvisioningInfo': {'description': 'OperatorProvisioningInfo '
                                                                'returns the info '
                                                                'needed to '
                                                                'provision an '
                                                                'operator.',
                                                 'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/OperatorProvisioningInfoResults'}},
                                                 'type': 'object'},
                    'SetPasswords': {'description': 'SetPasswords sets the given '
                                                    'password for each supplied '
                                                    'entity, if possible.',
                                     'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchAPIHostPorts': {'description': 'WatchAPIHostPorts '
                                                         'watches the API server '
                                                         'addresses.',
                                          'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchApplications': {'description': 'WatchApplications starts '
                                                         'a StringsWatcher to '
                                                         'watch CAAS applications\n'
                                                         'deployed to this model.',
                                          'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                          'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''
        APIAddresses returns the list of addresses used to connect to the API.


        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorProvisioner',
                   request='APIAddresses',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''
        APIHostPorts returns the API server addresses.


        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorProvisioner',
                   request='APIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IssueOperatorCertificateResults)
    async def IssueOperatorCertificate(self, entities=None):
        '''
        IssueOperatorCertificate issues an x509 certificate for use by the specified application operator.

        entities : typing.Sequence[~Entity]
        Returns -> IssueOperatorCertificateResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorProvisioner',
                   request='IssueOperatorCertificate',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorProvisioner',
                   request='Life',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''
        ModelUUID returns the model UUID to connect to the model
        that the current connection is for.


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorProvisioner',
                   request='ModelUUID',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(OperatorProvisioningInfoResults)
    async def OperatorProvisioningInfo(self, entities=None):
        '''
        OperatorProvisioningInfo returns the info needed to provision an operator.

        entities : typing.Sequence[~Entity]
        Returns -> OperatorProvisioningInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorProvisioner',
                   request='OperatorProvisioningInfo',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes=None):
        '''
        SetPasswords sets the given password for each supplied entity, if possible.

        changes : typing.Sequence[~EntityPassword]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorProvisioner',
                   request='SetPasswords',
                   version=1,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''
        WatchAPIHostPorts watches the API server addresses.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorProvisioner',
                   request='WatchAPIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchApplications(self):
        '''
        WatchApplications starts a StringsWatcher to watch CAAS applications
        deployed to this model.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorProvisioner',
                   request='WatchApplications',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CAASOperatorUpgraderFacade(Type):
    name = 'CAASOperatorUpgrader'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'KubernetesUpgradeArg': {'additionalProperties': False,
                                              'properties': {'agent-tag': {'type': 'string'},
                                                             'version': {'$ref': '#/definitions/Number'}},
                                              'required': ['agent-tag', 'version'],
                                              'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'}},
     'properties': {'UpgradeOperator': {'description': 'UpgradeOperator upgrades '
                                                       'the operator for the '
                                                       'specified agents.',
                                        'properties': {'Params': {'$ref': '#/definitions/KubernetesUpgradeArg'},
                                                       'Result': {'$ref': '#/definitions/ErrorResult'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def UpgradeOperator(self, agent_tag=None, version=None):
        '''
        UpgradeOperator upgrades the operator for the specified agents.

        agent_tag : str
        version : Number
        Returns -> ErrorResult
        '''
        if agent_tag is not None and not isinstance(agent_tag, (bytes, str)):
            raise Exception("Expected agent_tag to be a str, received: {}".format(type(agent_tag)))

        if version is not None and not isinstance(version, (dict, Number)):
            raise Exception("Expected version to be a Number, received: {}".format(type(version)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASOperatorUpgrader',
                   request='UpgradeOperator',
                   version=1,
                   params=_params)
        _params['agent-tag'] = agent_tag
        _params['version'] = version
        reply = await self.rpc(msg)
        return reply



class CAASUnitProvisionerFacade(Type):
    name = 'CAASUnitProvisioner'
    version = 1
    schema =     {'definitions': {'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'ApplicationGetConfigResults': {'additionalProperties': False,
                                                     'properties': {'Results': {'items': {'$ref': '#/definitions/ConfigResult'},
                                                                                'type': 'array'}},
                                                     'required': ['Results'],
                                                     'type': 'object'},
                     'ApplicationUnitInfo': {'additionalProperties': False,
                                             'properties': {'provider-id': {'type': 'string'},
                                                            'unit-tag': {'type': 'string'}},
                                             'required': ['provider-id',
                                                          'unit-tag'],
                                             'type': 'object'},
                     'ApplicationUnitParams': {'additionalProperties': False,
                                               'properties': {'address': {'type': 'string'},
                                                              'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                    'type': 'object'}},
                                                                       'type': 'object'},
                                                              'filesystem-info': {'items': {'$ref': '#/definitions/KubernetesFilesystemInfo'},
                                                                                  'type': 'array'},
                                                              'info': {'type': 'string'},
                                                              'ports': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                              'provider-id': {'type': 'string'},
                                                              'stateful': {'type': 'boolean'},
                                                              'status': {'type': 'string'},
                                                              'unit-tag': {'type': 'string'}},
                                               'required': ['provider-id',
                                                            'unit-tag',
                                                            'address',
                                                            'ports',
                                                            'status',
                                                            'info'],
                                               'type': 'object'},
                     'ConfigResult': {'additionalProperties': False,
                                      'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'error': {'$ref': '#/definitions/Error'}},
                                      'required': ['config'],
                                      'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'IntResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'type': 'integer'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'IntResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/IntResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'KubernetesDeploymentInfo': {'additionalProperties': False,
                                                  'properties': {'deployment-type': {'type': 'string'},
                                                                 'service-type': {'type': 'string'}},
                                                  'required': ['deployment-type',
                                                               'service-type'],
                                                  'type': 'object'},
                     'KubernetesDeviceParams': {'additionalProperties': False,
                                                'properties': {'Attributes': {'patternProperties': {'.*': {'type': 'string'}},
                                                                              'type': 'object'},
                                                               'Count': {'type': 'integer'},
                                                               'Type': {'type': 'string'}},
                                                'required': ['Type',
                                                             'Count',
                                                             'Attributes'],
                                                'type': 'object'},
                     'KubernetesFilesystemAttachmentParams': {'additionalProperties': False,
                                                              'properties': {'mount-point': {'type': 'string'},
                                                                             'provider': {'type': 'string'},
                                                                             'read-only': {'type': 'boolean'}},
                                                              'required': ['provider'],
                                                              'type': 'object'},
                     'KubernetesFilesystemInfo': {'additionalProperties': False,
                                                  'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'},
                                                                 'filesystem-id': {'type': 'string'},
                                                                 'info': {'type': 'string'},
                                                                 'mount-point': {'type': 'string'},
                                                                 'pool': {'type': 'string'},
                                                                 'read-only': {'type': 'boolean'},
                                                                 'size': {'type': 'integer'},
                                                                 'status': {'type': 'string'},
                                                                 'storagename': {'type': 'string'},
                                                                 'volume': {'$ref': '#/definitions/KubernetesVolumeInfo'}},
                                                  'required': ['storagename',
                                                               'pool',
                                                               'size',
                                                               'filesystem-id',
                                                               'status',
                                                               'info',
                                                               'volume'],
                                                  'type': 'object'},
                     'KubernetesFilesystemParams': {'additionalProperties': False,
                                                    'properties': {'attachment': {'$ref': '#/definitions/KubernetesFilesystemAttachmentParams'},
                                                                   'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                               'type': 'object'}},
                                                                                  'type': 'object'},
                                                                   'provider': {'type': 'string'},
                                                                   'size': {'type': 'integer'},
                                                                   'storagename': {'type': 'string'},
                                                                   'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                            'type': 'object'}},
                                                    'required': ['storagename',
                                                                 'size',
                                                                 'provider'],
                                                    'type': 'object'},
                     'KubernetesProvisioningInfo': {'additionalProperties': False,
                                                    'properties': {'charm-modified-version': {'type': 'integer'},
                                                                   'constraints': {'$ref': '#/definitions/Value'},
                                                                   'deployment-info': {'$ref': '#/definitions/KubernetesDeploymentInfo'},
                                                                   'devices': {'items': {'$ref': '#/definitions/KubernetesDeviceParams'},
                                                                               'type': 'array'},
                                                                   'filesystems': {'items': {'$ref': '#/definitions/KubernetesFilesystemParams'},
                                                                                   'type': 'array'},
                                                                   'operator-image-path': {'type': 'string'},
                                                                   'pod-spec': {'type': 'string'},
                                                                   'raw-k8s-spec': {'type': 'string'},
                                                                   'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                            'type': 'object'},
                                                                   'volumes': {'items': {'$ref': '#/definitions/KubernetesVolumeParams'},
                                                                               'type': 'array'}},
                                                    'required': ['pod-spec',
                                                                 'constraints'],
                                                    'type': 'object'},
                     'KubernetesProvisioningInfoResult': {'additionalProperties': False,
                                                          'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                         'result': {'$ref': '#/definitions/KubernetesProvisioningInfo'}},
                                                          'required': ['result'],
                                                          'type': 'object'},
                     'KubernetesProvisioningInfoResults': {'additionalProperties': False,
                                                           'properties': {'results': {'items': {'$ref': '#/definitions/KubernetesProvisioningInfoResult'},
                                                                                      'type': 'array'}},
                                                           'required': ['results'],
                                                           'type': 'object'},
                     'KubernetesVolumeAttachmentParams': {'additionalProperties': False,
                                                          'properties': {'provider': {'type': 'string'},
                                                                         'read-only': {'type': 'boolean'}},
                                                          'required': ['provider'],
                                                          'type': 'object'},
                     'KubernetesVolumeInfo': {'additionalProperties': False,
                                              'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                   'type': 'object'}},
                                                                      'type': 'object'},
                                                             'info': {'type': 'string'},
                                                             'persistent': {'type': 'boolean'},
                                                             'pool': {'type': 'string'},
                                                             'size': {'type': 'integer'},
                                                             'status': {'type': 'string'},
                                                             'volume-id': {'type': 'string'}},
                                              'required': ['volume-id',
                                                           'size',
                                                           'persistent',
                                                           'status',
                                                           'info'],
                                              'type': 'object'},
                     'KubernetesVolumeParams': {'additionalProperties': False,
                                                'properties': {'attachment': {'$ref': '#/definitions/KubernetesVolumeAttachmentParams'},
                                                               'attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                               'provider': {'type': 'string'},
                                                               'size': {'type': 'integer'},
                                                               'storagename': {'type': 'string'},
                                                               'tags': {'patternProperties': {'.*': {'type': 'string'}},
                                                                        'type': 'object'}},
                                                'required': ['storagename',
                                                             'size',
                                                             'provider'],
                                                'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'UpdateApplicationServiceArg': {'additionalProperties': False,
                                                     'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                                  'type': 'array'},
                                                                    'application-tag': {'type': 'string'},
                                                                    'generation': {'type': 'integer'},
                                                                    'provider-id': {'type': 'string'},
                                                                    'scale': {'type': 'integer'}},
                                                     'required': ['application-tag',
                                                                  'provider-id',
                                                                  'addresses'],
                                                     'type': 'object'},
                     'UpdateApplicationServiceArgs': {'additionalProperties': False,
                                                      'properties': {'args': {'items': {'$ref': '#/definitions/UpdateApplicationServiceArg'},
                                                                              'type': 'array'}},
                                                      'required': ['args'],
                                                      'type': 'object'},
                     'UpdateApplicationUnitArgs': {'additionalProperties': False,
                                                   'properties': {'args': {'items': {'$ref': '#/definitions/UpdateApplicationUnits'},
                                                                           'type': 'array'}},
                                                   'required': ['args'],
                                                   'type': 'object'},
                     'UpdateApplicationUnitResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'info': {'$ref': '#/definitions/UpdateApplicationUnitsInfo'}},
                                                     'type': 'object'},
                     'UpdateApplicationUnitResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/UpdateApplicationUnitResult'},
                                                                                 'type': 'array'}},
                                                      'required': ['results'],
                                                      'type': 'object'},
                     'UpdateApplicationUnits': {'additionalProperties': False,
                                                'properties': {'application-tag': {'type': 'string'},
                                                               'generation': {'type': 'integer'},
                                                               'scale': {'type': 'integer'},
                                                               'status': {'$ref': '#/definitions/EntityStatus'},
                                                               'units': {'items': {'$ref': '#/definitions/ApplicationUnitParams'},
                                                                         'type': 'array'}},
                                                'required': ['application-tag',
                                                             'units'],
                                                'type': 'object'},
                     'UpdateApplicationUnitsInfo': {'additionalProperties': False,
                                                    'properties': {'units': {'items': {'$ref': '#/definitions/ApplicationUnitInfo'},
                                                                             'type': 'array'}},
                                                    'required': ['units'],
                                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'root-disk-source': {'type': 'string'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'},
                                              'zones': {'items': {'type': 'string'},
                                                        'type': 'array'}},
                               'type': 'object'}},
     'properties': {'ApplicationsConfig': {'description': 'ApplicationsConfig '
                                                          'returns the config for '
                                                          'the specified '
                                                          'applications.',
                                           'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/ApplicationGetConfigResults'}},
                                           'type': 'object'},
                    'ApplicationsScale': {'description': 'ApplicationsScale '
                                                         'returns the scaling info '
                                                         'for specified '
                                                         'applications in this '
                                                         'model.',
                                          'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/IntResults'}},
                                          'type': 'object'},
                    'ClearApplicationsResources': {'description': 'ClearApplicationsResources '
                                                                  'clears the '
                                                                  'flags which '
                                                                  'indicate\n'
                                                                  'applications '
                                                                  'still have '
                                                                  'resources in '
                                                                  'the cluster.',
                                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                   'type': 'object'},
                    'DeploymentMode': {'description': 'DeploymentMode returns the '
                                                      'deployment mode of the '
                                                      "given applications' charms.",
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StringResults'}},
                                       'type': 'object'},
                    'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ProvisioningInfo': {'description': 'ProvisioningInfo returns '
                                                        'the provisioning info for '
                                                        'specified applications in '
                                                        'this model.',
                                         'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/KubernetesProvisioningInfoResults'}},
                                         'type': 'object'},
                    'SetOperatorStatus': {'description': 'SetOperatorStatus '
                                                         'updates the operator '
                                                         'status for each given '
                                                         'application.',
                                          'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'UpdateApplicationsService': {'description': 'UpdateApplicationsService '
                                                                 'updates the Juju '
                                                                 'data model to '
                                                                 'reflect the '
                                                                 'given\n'
                                                                 'service details '
                                                                 'of the specified '
                                                                 'application.',
                                                  'properties': {'Params': {'$ref': '#/definitions/UpdateApplicationServiceArgs'},
                                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                  'type': 'object'},
                    'UpdateApplicationsUnits': {'description': 'UpdateApplicationsUnits '
                                                               'updates the Juju '
                                                               'data model to '
                                                               'reflect the given\n'
                                                               'units of the '
                                                               'specified '
                                                               'application.',
                                                'properties': {'Params': {'$ref': '#/definitions/UpdateApplicationUnitArgs'},
                                                               'Result': {'$ref': '#/definitions/UpdateApplicationUnitResults'}},
                                                'type': 'object'},
                    'WatchApplications': {'description': 'WatchApplications starts '
                                                         'a StringsWatcher to '
                                                         'watch CAAS applications\n'
                                                         'deployed to this model.',
                                          'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                          'type': 'object'},
                    'WatchApplicationsScale': {'description': 'WatchApplicationsScale '
                                                              'starts a '
                                                              'NotifyWatcher to '
                                                              'watch changes\n'
                                                              'to the '
                                                              "applications' "
                                                              'scale.',
                                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                               'type': 'object'},
                    'WatchPodSpec': {'description': 'WatchPodSpec starts a '
                                                    'NotifyWatcher to watch '
                                                    'changes to the\n'
                                                    'pod spec for specified units '
                                                    'in this model.',
                                     'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                     'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ApplicationGetConfigResults)
    async def ApplicationsConfig(self, entities=None):
        '''
        ApplicationsConfig returns the config for the specified applications.

        entities : typing.Sequence[~Entity]
        Returns -> ApplicationGetConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='ApplicationsConfig',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IntResults)
    async def ApplicationsScale(self, entities=None):
        '''
        ApplicationsScale returns the scaling info for specified applications in this model.

        entities : typing.Sequence[~Entity]
        Returns -> IntResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='ApplicationsScale',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ClearApplicationsResources(self, entities=None):
        '''
        ClearApplicationsResources clears the flags which indicate
        applications still have resources in the cluster.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='ClearApplicationsResources',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def DeploymentMode(self, entities=None):
        '''
        DeploymentMode returns the deployment mode of the given applications' charms.

        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='DeploymentMode',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='Life',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(KubernetesProvisioningInfoResults)
    async def ProvisioningInfo(self, entities=None):
        '''
        ProvisioningInfo returns the provisioning info for specified applications in this model.

        entities : typing.Sequence[~Entity]
        Returns -> KubernetesProvisioningInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='ProvisioningInfo',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetOperatorStatus(self, entities=None):
        '''
        SetOperatorStatus updates the operator status for each given application.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='SetOperatorStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateApplicationsService(self, args=None):
        '''
        UpdateApplicationsService updates the Juju data model to reflect the given
        service details of the specified application.

        args : typing.Sequence[~UpdateApplicationServiceArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='UpdateApplicationsService',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpdateApplicationUnitResults)
    async def UpdateApplicationsUnits(self, args=None):
        '''
        UpdateApplicationsUnits updates the Juju data model to reflect the given
        units of the specified application.

        args : typing.Sequence[~UpdateApplicationUnits]
        Returns -> UpdateApplicationUnitResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='UpdateApplicationsUnits',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchApplications(self):
        '''
        WatchApplications starts a StringsWatcher to watch CAAS applications
        deployed to this model.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='WatchApplications',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchApplicationsScale(self, entities=None):
        '''
        WatchApplicationsScale starts a NotifyWatcher to watch changes
        to the applications' scale.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='WatchApplicationsScale',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchPodSpec(self, entities=None):
        '''
        WatchPodSpec starts a NotifyWatcher to watch changes to the
        pod spec for specified units in this model.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CAASUnitProvisioner',
                   request='WatchPodSpec',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class ClientFacade(Type):
    name = 'Client'
    version = 1
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'AddCharm': {'additionalProperties': False,
                                  'properties': {'channel': {'type': 'string'},
                                                 'url': {'type': 'string'}},
                                  'required': ['url', 'channel'],
                                  'type': 'object'},
                     'AddCharmWithAuthorization': {'additionalProperties': False,
                                                   'properties': {'channel': {'type': 'string'},
                                                                  'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                                  'url': {'type': 'string'}},
                                                   'required': ['url',
                                                                'channel',
                                                                'macaroon'],
                                                   'type': 'object'},
                     'AddMachineParams': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'constraints': {'$ref': '#/definitions/Value'},
                                                         'container-type': {'type': 'string'},
                                                         'disks': {'items': {'$ref': '#/definitions/Constraints'},
                                                                   'type': 'array'},
                                                         'hardware-characteristics': {'$ref': '#/definitions/HardwareCharacteristics'},
                                                         'instance-id': {'type': 'string'},
                                                         'jobs': {'items': {'type': 'string'},
                                                                  'type': 'array'},
                                                         'nonce': {'type': 'string'},
                                                         'parent-id': {'type': 'string'},
                                                         'placement': {'$ref': '#/definitions/Placement'},
                                                         'series': {'type': 'string'}},
                                          'required': ['series',
                                                       'constraints',
                                                       'jobs',
                                                       'parent-id',
                                                       'container-type',
                                                       'instance-id',
                                                       'nonce',
                                                       'hardware-characteristics',
                                                       'addresses'],
                                          'type': 'object'},
                     'AddMachines': {'additionalProperties': False,
                                     'properties': {'params': {'items': {'$ref': '#/definitions/AddMachineParams'},
                                                               'type': 'array'}},
                                     'required': ['params'],
                                     'type': 'object'},
                     'AddMachinesResult': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'machine': {'type': 'string'}},
                                           'required': ['machine'],
                                           'type': 'object'},
                     'AddMachinesResults': {'additionalProperties': False,
                                            'properties': {'machines': {'items': {'$ref': '#/definitions/AddMachinesResult'},
                                                                        'type': 'array'}},
                                            'required': ['machines'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'AgentVersionResult': {'additionalProperties': False,
                                            'properties': {'version': {'$ref': '#/definitions/Number'}},
                                            'required': ['version'],
                                            'type': 'object'},
                     'AllWatcherId': {'additionalProperties': False,
                                      'properties': {'watcher-id': {'type': 'string'}},
                                      'required': ['watcher-id'],
                                      'type': 'object'},
                     'ApplicationStatus': {'additionalProperties': False,
                                           'properties': {'can-upgrade-to': {'type': 'string'},
                                                          'charm': {'type': 'string'},
                                                          'err': {'additionalProperties': True,
                                                                  'type': 'object'},
                                                          'exposed': {'type': 'boolean'},
                                                          'life': {'type': 'string'},
                                                          'meter-statuses': {'patternProperties': {'.*': {'$ref': '#/definitions/MeterStatus'}},
                                                                             'type': 'object'},
                                                          'relations': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                     'type': 'array'}},
                                                                        'type': 'object'},
                                                          'series': {'type': 'string'},
                                                          'status': {'$ref': '#/definitions/DetailedStatus'},
                                                          'subordinate-to': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                          'units': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitStatus'}},
                                                                    'type': 'object'},
                                                          'workload-version': {'type': 'string'}},
                                           'required': ['charm',
                                                        'series',
                                                        'exposed',
                                                        'life',
                                                        'relations',
                                                        'can-upgrade-to',
                                                        'subordinate-to',
                                                        'units',
                                                        'meter-statuses',
                                                        'status',
                                                        'workload-version'],
                                           'type': 'object'},
                     'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Series': {'type': 'string'}},
                                'required': ['Number', 'Series', 'Arch'],
                                'type': 'object'},
                     'BundleChange': {'additionalProperties': False,
                                      'properties': {'args': {'items': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                              'type': 'array'},
                                                     'id': {'type': 'string'},
                                                     'method': {'type': 'string'},
                                                     'requires': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['id',
                                                   'method',
                                                   'args',
                                                   'requires'],
                                      'type': 'object'},
                     'BundleChangesParams': {'additionalProperties': False,
                                             'properties': {'yaml': {'type': 'string'}},
                                             'required': ['yaml'],
                                             'type': 'object'},
                     'BundleChangesResults': {'additionalProperties': False,
                                              'properties': {'changes': {'items': {'$ref': '#/definitions/BundleChange'},
                                                                         'type': 'array'},
                                                             'errors': {'items': {'type': 'string'},
                                                                        'type': 'array'}},
                                              'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'Constraints': {'additionalProperties': False,
                                     'properties': {'Count': {'type': 'integer'},
                                                    'Pool': {'type': 'string'},
                                                    'Size': {'type': 'integer'}},
                                     'required': ['Pool', 'Size', 'Count'],
                                     'type': 'object'},
                     'DestroyMachines': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'machine-names': {'items': {'type': 'string'},
                                                                          'type': 'array'}},
                                         'required': ['machine-names', 'force'],
                                         'type': 'object'},
                     'DetailedStatus': {'additionalProperties': False,
                                        'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                       'err': {'additionalProperties': True,
                                                               'type': 'object'},
                                                       'info': {'type': 'string'},
                                                       'kind': {'type': 'string'},
                                                       'life': {'type': 'string'},
                                                       'since': {'format': 'date-time',
                                                                 'type': 'string'},
                                                       'status': {'type': 'string'},
                                                       'version': {'type': 'string'}},
                                        'required': ['status',
                                                     'info',
                                                     'data',
                                                     'since',
                                                     'kind',
                                                     'version',
                                                     'life'],
                                        'type': 'object'},
                     'EndpointStatus': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'},
                                                       'subordinate': {'type': 'boolean'}},
                                        'required': ['application',
                                                     'name',
                                                     'role',
                                                     'subordinate'],
                                        'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FindToolsParams': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'major': {'type': 'integer'},
                                                        'minor': {'type': 'integer'},
                                                        'number': {'$ref': '#/definitions/Number'},
                                                        'series': {'type': 'string'}},
                                         'required': ['number',
                                                      'major',
                                                      'minor',
                                                      'arch',
                                                      'series'],
                                         'type': 'object'},
                     'FindToolsResult': {'additionalProperties': False,
                                         'properties': {'error': {'$ref': '#/definitions/Error'},
                                                        'list': {'items': {'$ref': '#/definitions/Tools'},
                                                                 'type': 'array'}},
                                         'required': ['list'],
                                         'type': 'object'},
                     'FullStatus': {'additionalProperties': False,
                                    'properties': {'applications': {'patternProperties': {'.*': {'$ref': '#/definitions/ApplicationStatus'}},
                                                                    'type': 'object'},
                                                   'machines': {'patternProperties': {'.*': {'$ref': '#/definitions/MachineStatus'}},
                                                                'type': 'object'},
                                                   'model': {'$ref': '#/definitions/ModelStatusInfo'},
                                                   'relations': {'items': {'$ref': '#/definitions/RelationStatus'},
                                                                 'type': 'array'},
                                                   'remote-applications': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteApplicationStatus'}},
                                                                           'type': 'object'}},
                                    'required': ['model',
                                                 'machines',
                                                 'applications',
                                                 'remote-applications',
                                                 'relations'],
                                    'type': 'object'},
                     'GetConstraintsResults': {'additionalProperties': False,
                                               'properties': {'constraints': {'$ref': '#/definitions/Value'}},
                                               'required': ['constraints'],
                                               'type': 'object'},
                     'HardwareCharacteristics': {'additionalProperties': False,
                                                 'properties': {'arch': {'type': 'string'},
                                                                'availability-zone': {'type': 'string'},
                                                                'cpu-cores': {'type': 'integer'},
                                                                'cpu-power': {'type': 'integer'},
                                                                'mem': {'type': 'integer'},
                                                                'root-disk': {'type': 'integer'},
                                                                'tags': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                                 'type': 'object'},
                     'History': {'additionalProperties': False,
                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                'statuses': {'items': {'$ref': '#/definitions/DetailedStatus'},
                                                             'type': 'array'}},
                                 'required': ['statuses'],
                                 'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'}},
                                  'required': ['Address', 'port'],
                                  'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'MachineHardware': {'additionalProperties': False,
                                         'properties': {'arch': {'type': 'string'},
                                                        'availability-zone': {'type': 'string'},
                                                        'cores': {'type': 'integer'},
                                                        'cpu-power': {'type': 'integer'},
                                                        'mem': {'type': 'integer'},
                                                        'root-disk': {'type': 'integer'},
                                                        'tags': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                         'type': 'object'},
                     'MachineStatus': {'additionalProperties': False,
                                       'properties': {'agent-status': {'$ref': '#/definitions/DetailedStatus'},
                                                      'constraints': {'type': 'string'},
                                                      'containers': {'patternProperties': {'.*': {'$ref': '#/definitions/MachineStatus'}},
                                                                     'type': 'object'},
                                                      'dns-name': {'type': 'string'},
                                                      'hardware': {'type': 'string'},
                                                      'has-vote': {'type': 'boolean'},
                                                      'id': {'type': 'string'},
                                                      'instance-id': {'type': 'string'},
                                                      'instance-status': {'$ref': '#/definitions/DetailedStatus'},
                                                      'ip-addresses': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                      'jobs': {'items': {'type': 'string'},
                                                               'type': 'array'},
                                                      'network-interfaces': {'patternProperties': {'.*': {'$ref': '#/definitions/NetworkInterface'}},
                                                                             'type': 'object'},
                                                      'series': {'type': 'string'},
                                                      'wants-vote': {'type': 'boolean'}},
                                       'required': ['agent-status',
                                                    'instance-status',
                                                    'dns-name',
                                                    'instance-id',
                                                    'series',
                                                    'id',
                                                    'containers',
                                                    'constraints',
                                                    'hardware',
                                                    'jobs',
                                                    'has-vote',
                                                    'wants-vote'],
                                       'type': 'object'},
                     'MeterStatus': {'additionalProperties': False,
                                     'properties': {'color': {'type': 'string'},
                                                    'message': {'type': 'string'}},
                                     'required': ['color', 'message'],
                                     'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelInfo': {'additionalProperties': False,
                                   'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                  'cloud-credential-tag': {'type': 'string'},
                                                  'cloud-region': {'type': 'string'},
                                                  'cloud-tag': {'type': 'string'},
                                                  'controller-uuid': {'type': 'string'},
                                                  'default-series': {'type': 'string'},
                                                  'life': {'type': 'string'},
                                                  'machines': {'items': {'$ref': '#/definitions/ModelMachineInfo'},
                                                               'type': 'array'},
                                                  'migration': {'$ref': '#/definitions/ModelMigrationStatus'},
                                                  'name': {'type': 'string'},
                                                  'owner-tag': {'type': 'string'},
                                                  'provider-type': {'type': 'string'},
                                                  'sla': {'$ref': '#/definitions/ModelSLAInfo'},
                                                  'status': {'$ref': '#/definitions/EntityStatus'},
                                                  'users': {'items': {'$ref': '#/definitions/ModelUserInfo'},
                                                            'type': 'array'},
                                                  'uuid': {'type': 'string'}},
                                   'required': ['name',
                                                'uuid',
                                                'controller-uuid',
                                                'cloud-tag',
                                                'owner-tag',
                                                'life',
                                                'users',
                                                'machines',
                                                'sla',
                                                'agent-version'],
                                   'type': 'object'},
                     'ModelMachineInfo': {'additionalProperties': False,
                                          'properties': {'hardware': {'$ref': '#/definitions/MachineHardware'},
                                                         'has-vote': {'type': 'boolean'},
                                                         'id': {'type': 'string'},
                                                         'instance-id': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'wants-vote': {'type': 'boolean'}},
                                          'required': ['id'],
                                          'type': 'object'},
                     'ModelMigrationStatus': {'additionalProperties': False,
                                              'properties': {'end': {'format': 'date-time',
                                                                     'type': 'string'},
                                                             'start': {'format': 'date-time',
                                                                       'type': 'string'},
                                                             'status': {'type': 'string'}},
                                              'required': ['status', 'start'],
                                              'type': 'object'},
                     'ModelSLA': {'additionalProperties': False,
                                  'properties': {'ModelSLAInfo': {'$ref': '#/definitions/ModelSLAInfo'},
                                                 'creds': {'items': {'type': 'integer'},
                                                           'type': 'array'}},
                                  'required': ['ModelSLAInfo', 'creds'],
                                  'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelSet': {'additionalProperties': False,
                                  'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                         'type': 'object'}},
                                                            'type': 'object'}},
                                  'required': ['config'],
                                  'type': 'object'},
                     'ModelStatusInfo': {'additionalProperties': False,
                                         'properties': {'available-version': {'type': 'string'},
                                                        'cloud-tag': {'type': 'string'},
                                                        'meter-status': {'$ref': '#/definitions/MeterStatus'},
                                                        'model-status': {'$ref': '#/definitions/DetailedStatus'},
                                                        'name': {'type': 'string'},
                                                        'region': {'type': 'string'},
                                                        'sla': {'type': 'string'},
                                                        'version': {'type': 'string'}},
                                         'required': ['name',
                                                      'cloud-tag',
                                                      'version',
                                                      'available-version',
                                                      'model-status',
                                                      'meter-status',
                                                      'sla'],
                                         'type': 'object'},
                     'ModelUnset': {'additionalProperties': False,
                                    'properties': {'keys': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['keys'],
                                    'type': 'object'},
                     'ModelUserInfo': {'additionalProperties': False,
                                       'properties': {'access': {'type': 'string'},
                                                      'display-name': {'type': 'string'},
                                                      'last-connection': {'format': 'date-time',
                                                                          'type': 'string'},
                                                      'user': {'type': 'string'}},
                                       'required': ['user',
                                                    'display-name',
                                                    'last-connection',
                                                    'access'],
                                       'type': 'object'},
                     'ModelUserInfoResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/ModelUserInfo'}},
                                             'type': 'object'},
                     'ModelUserInfoResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/ModelUserInfoResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'NetworkInterface': {'additionalProperties': False,
                                          'properties': {'dns-nameservers': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                         'gateway': {'type': 'string'},
                                                         'ip-addresses': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                         'is-up': {'type': 'boolean'},
                                                         'mac-address': {'type': 'string'},
                                                         'space': {'type': 'string'}},
                                          'required': ['ip-addresses',
                                                       'mac-address',
                                                       'is-up'],
                                          'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'Placement': {'additionalProperties': False,
                                   'properties': {'directive': {'type': 'string'},
                                                  'scope': {'type': 'string'}},
                                   'required': ['scope', 'directive'],
                                   'type': 'object'},
                     'PrivateAddress': {'additionalProperties': False,
                                        'properties': {'target': {'type': 'string'}},
                                        'required': ['target'],
                                        'type': 'object'},
                     'PrivateAddressResults': {'additionalProperties': False,
                                               'properties': {'private-address': {'type': 'string'}},
                                               'required': ['private-address'],
                                               'type': 'object'},
                     'ProvisioningScriptParams': {'additionalProperties': False,
                                                  'properties': {'data-dir': {'type': 'string'},
                                                                 'disable-package-commands': {'type': 'boolean'},
                                                                 'machine-id': {'type': 'string'},
                                                                 'nonce': {'type': 'string'}},
                                                  'required': ['machine-id',
                                                               'nonce',
                                                               'data-dir',
                                                               'disable-package-commands'],
                                                  'type': 'object'},
                     'ProvisioningScriptResult': {'additionalProperties': False,
                                                  'properties': {'script': {'type': 'string'}},
                                                  'required': ['script'],
                                                  'type': 'object'},
                     'PublicAddress': {'additionalProperties': False,
                                       'properties': {'target': {'type': 'string'}},
                                       'required': ['target'],
                                       'type': 'object'},
                     'PublicAddressResults': {'additionalProperties': False,
                                              'properties': {'public-address': {'type': 'string'}},
                                              'required': ['public-address'],
                                              'type': 'object'},
                     'RelationStatus': {'additionalProperties': False,
                                        'properties': {'endpoints': {'items': {'$ref': '#/definitions/EndpointStatus'},
                                                                     'type': 'array'},
                                                       'id': {'type': 'integer'},
                                                       'interface': {'type': 'string'},
                                                       'key': {'type': 'string'},
                                                       'scope': {'type': 'string'}},
                                        'required': ['id',
                                                     'key',
                                                     'interface',
                                                     'scope',
                                                     'endpoints'],
                                        'type': 'object'},
                     'RemoteApplicationStatus': {'additionalProperties': False,
                                                 'properties': {'application-name': {'type': 'string'},
                                                                'application-url': {'type': 'string'},
                                                                'endpoints': {'items': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                              'type': 'array'},
                                                                'err': {'additionalProperties': True,
                                                                        'type': 'object'},
                                                                'life': {'type': 'string'},
                                                                'relations': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                           'type': 'array'}},
                                                                              'type': 'object'},
                                                                'status': {'$ref': '#/definitions/DetailedStatus'}},
                                                 'required': ['application-url',
                                                              'application-name',
                                                              'endpoints',
                                                              'life',
                                                              'relations',
                                                              'status'],
                                                 'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'},
                                                       'scope': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit',
                                                     'scope'],
                                        'type': 'object'},
                     'ResolveCharmResult': {'additionalProperties': False,
                                            'properties': {'error': {'type': 'string'},
                                                           'url': {'type': 'string'}},
                                            'type': 'object'},
                     'ResolveCharmResults': {'additionalProperties': False,
                                             'properties': {'urls': {'items': {'$ref': '#/definitions/ResolveCharmResult'},
                                                                     'type': 'array'}},
                                             'required': ['urls'],
                                             'type': 'object'},
                     'ResolveCharms': {'additionalProperties': False,
                                       'properties': {'references': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                       'required': ['references'],
                                       'type': 'object'},
                     'Resolved': {'additionalProperties': False,
                                  'properties': {'retry': {'type': 'boolean'},
                                                 'unit-name': {'type': 'string'}},
                                  'required': ['unit-name', 'retry'],
                                  'type': 'object'},
                     'SetConstraints': {'additionalProperties': False,
                                        'properties': {'application': {'type': 'string'},
                                                       'constraints': {'$ref': '#/definitions/Value'}},
                                        'required': ['application', 'constraints'],
                                        'type': 'object'},
                     'SetModelAgentVersion': {'additionalProperties': False,
                                              'properties': {'version': {'$ref': '#/definitions/Number'}},
                                              'required': ['version'],
                                              'type': 'object'},
                     'StatusHistoryFilter': {'additionalProperties': False,
                                             'properties': {'date': {'format': 'date-time',
                                                                     'type': 'string'},
                                                            'delta': {'type': 'integer'},
                                                            'exclude': {'items': {'type': 'string'},
                                                                        'type': 'array'},
                                                            'size': {'type': 'integer'}},
                                             'required': ['size',
                                                          'date',
                                                          'delta',
                                                          'exclude'],
                                             'type': 'object'},
                     'StatusHistoryRequest': {'additionalProperties': False,
                                              'properties': {'filter': {'$ref': '#/definitions/StatusHistoryFilter'},
                                                             'historyKind': {'type': 'string'},
                                                             'size': {'type': 'integer'},
                                                             'tag': {'type': 'string'}},
                                              'required': ['historyKind',
                                                           'size',
                                                           'filter',
                                                           'tag'],
                                              'type': 'object'},
                     'StatusHistoryRequests': {'additionalProperties': False,
                                               'properties': {'requests': {'items': {'$ref': '#/definitions/StatusHistoryRequest'},
                                                                           'type': 'array'}},
                                               'required': ['requests'],
                                               'type': 'object'},
                     'StatusHistoryResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'history': {'$ref': '#/definitions/History'}},
                                             'required': ['history'],
                                             'type': 'object'},
                     'StatusHistoryResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/StatusHistoryResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'StatusParams': {'additionalProperties': False,
                                      'properties': {'patterns': {'items': {'type': 'string'},
                                                                  'type': 'array'}},
                                      'required': ['patterns'],
                                      'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'UnitStatus': {'additionalProperties': False,
                                    'properties': {'agent-status': {'$ref': '#/definitions/DetailedStatus'},
                                                   'charm': {'type': 'string'},
                                                   'leader': {'type': 'boolean'},
                                                   'machine': {'type': 'string'},
                                                   'opened-ports': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                   'public-address': {'type': 'string'},
                                                   'subordinates': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitStatus'}},
                                                                    'type': 'object'},
                                                   'workload-status': {'$ref': '#/definitions/DetailedStatus'},
                                                   'workload-version': {'type': 'string'}},
                                    'required': ['agent-status',
                                                 'workload-status',
                                                 'workload-version',
                                                 'machine',
                                                 'opened-ports',
                                                 'public-address',
                                                 'charm',
                                                 'subordinates'],
                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'AbortCurrentUpgrade': {'type': 'object'},
                    'AddCharm': {'properties': {'Params': {'$ref': '#/definitions/AddCharm'}},
                                 'type': 'object'},
                    'AddCharmWithAuthorization': {'properties': {'Params': {'$ref': '#/definitions/AddCharmWithAuthorization'}},
                                                  'type': 'object'},
                    'AddMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                   'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                    'type': 'object'},
                    'AddMachinesV2': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                     'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                      'type': 'object'},
                    'AgentVersion': {'properties': {'Result': {'$ref': '#/definitions/AgentVersionResult'}},
                                     'type': 'object'},
                    'CACert': {'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'DestroyMachines': {'properties': {'Params': {'$ref': '#/definitions/DestroyMachines'}},
                                        'type': 'object'},
                    'FindTools': {'properties': {'Params': {'$ref': '#/definitions/FindToolsParams'},
                                                 'Result': {'$ref': '#/definitions/FindToolsResult'}},
                                  'type': 'object'},
                    'FullStatus': {'properties': {'Params': {'$ref': '#/definitions/StatusParams'},
                                                  'Result': {'$ref': '#/definitions/FullStatus'}},
                                   'type': 'object'},
                    'GetBundleChanges': {'properties': {'Params': {'$ref': '#/definitions/BundleChangesParams'},
                                                        'Result': {'$ref': '#/definitions/BundleChangesResults'}},
                                         'type': 'object'},
                    'GetModelConstraints': {'properties': {'Result': {'$ref': '#/definitions/GetConstraintsResults'}},
                                            'type': 'object'},
                    'InjectMachines': {'properties': {'Params': {'$ref': '#/definitions/AddMachines'},
                                                      'Result': {'$ref': '#/definitions/AddMachinesResults'}},
                                       'type': 'object'},
                    'ModelGet': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                 'type': 'object'},
                    'ModelInfo': {'properties': {'Result': {'$ref': '#/definitions/ModelInfo'}},
                                  'type': 'object'},
                    'ModelSet': {'properties': {'Params': {'$ref': '#/definitions/ModelSet'}},
                                 'type': 'object'},
                    'ModelUnset': {'properties': {'Params': {'$ref': '#/definitions/ModelUnset'}},
                                   'type': 'object'},
                    'ModelUserInfo': {'properties': {'Result': {'$ref': '#/definitions/ModelUserInfoResults'}},
                                      'type': 'object'},
                    'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/PrivateAddress'},
                                                      'Result': {'$ref': '#/definitions/PrivateAddressResults'}},
                                       'type': 'object'},
                    'ProvisioningScript': {'properties': {'Params': {'$ref': '#/definitions/ProvisioningScriptParams'},
                                                          'Result': {'$ref': '#/definitions/ProvisioningScriptResult'}},
                                           'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/PublicAddress'},
                                                     'Result': {'$ref': '#/definitions/PublicAddressResults'}},
                                      'type': 'object'},
                    'ResolveCharms': {'properties': {'Params': {'$ref': '#/definitions/ResolveCharms'},
                                                     'Result': {'$ref': '#/definitions/ResolveCharmResults'}},
                                      'type': 'object'},
                    'Resolved': {'properties': {'Params': {'$ref': '#/definitions/Resolved'}},
                                 'type': 'object'},
                    'RetryProvisioning': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SLALevel': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                 'type': 'object'},
                    'SetModelAgentVersion': {'properties': {'Params': {'$ref': '#/definitions/SetModelAgentVersion'}},
                                             'type': 'object'},
                    'SetModelConstraints': {'properties': {'Params': {'$ref': '#/definitions/SetConstraints'}},
                                            'type': 'object'},
                    'SetSLALevel': {'properties': {'Params': {'$ref': '#/definitions/ModelSLA'}},
                                    'type': 'object'},
                    'StatusHistory': {'properties': {'Params': {'$ref': '#/definitions/StatusHistoryRequests'},
                                                     'Result': {'$ref': '#/definitions/StatusHistoryResults'}},
                                      'type': 'object'},
                    'WatchAll': {'properties': {'Result': {'$ref': '#/definitions/AllWatcherId'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='APIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AbortCurrentUpgrade(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AbortCurrentUpgrade',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AddCharm(self, channel=None, url=None):
        '''
        channel : str
        url : str
        Returns -> None
        '''
        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if url is not None and not isinstance(url, (bytes, str)):
            raise Exception("Expected url to be a str, received: {}".format(type(url)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddCharm',
                   version=1,
                   params=_params)
        _params['channel'] = channel
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AddCharmWithAuthorization(self, channel=None, macaroon=None, url=None):
        '''
        channel : str
        macaroon : Macaroon
        url : str
        Returns -> None
        '''
        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if macaroon is not None and not isinstance(macaroon, (dict, Macaroon)):
            raise Exception("Expected macaroon to be a Macaroon, received: {}".format(type(macaroon)))

        if url is not None and not isinstance(url, (bytes, str)):
            raise Exception("Expected url to be a str, received: {}".format(type(url)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddCharmWithAuthorization',
                   version=1,
                   params=_params)
        _params['channel'] = channel
        _params['macaroon'] = macaroon
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def AddMachines(self, params=None):
        '''
        params : typing.Sequence[~AddMachineParams]
        Returns -> AddMachinesResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddMachines',
                   version=1,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def AddMachinesV2(self, params=None):
        '''
        params : typing.Sequence[~AddMachineParams]
        Returns -> AddMachinesResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AddMachinesV2',
                   version=1,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AgentVersionResult)
    async def AgentVersion(self):
        '''

        Returns -> AgentVersionResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='AgentVersion',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''

        Returns -> BytesResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='CACert',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def DestroyMachines(self, force=None, machine_names=None):
        '''
        force : bool
        machine_names : typing.Sequence[str]
        Returns -> None
        '''
        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if machine_names is not None and not isinstance(machine_names, (bytes, str, list)):
            raise Exception("Expected machine_names to be a Sequence, received: {}".format(type(machine_names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='DestroyMachines',
                   version=1,
                   params=_params)
        _params['force'] = force
        _params['machine-names'] = machine_names
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FindToolsResult)
    async def FindTools(self, arch=None, major=None, minor=None, number=None, series=None):
        '''
        arch : str
        major : int
        minor : int
        number : Number
        series : str
        Returns -> FindToolsResult
        '''
        if arch is not None and not isinstance(arch, (bytes, str)):
            raise Exception("Expected arch to be a str, received: {}".format(type(arch)))

        if major is not None and not isinstance(major, int):
            raise Exception("Expected major to be a int, received: {}".format(type(major)))

        if minor is not None and not isinstance(minor, int):
            raise Exception("Expected minor to be a int, received: {}".format(type(minor)))

        if number is not None and not isinstance(number, (dict, Number)):
            raise Exception("Expected number to be a Number, received: {}".format(type(number)))

        if series is not None and not isinstance(series, (bytes, str)):
            raise Exception("Expected series to be a str, received: {}".format(type(series)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='FindTools',
                   version=1,
                   params=_params)
        _params['arch'] = arch
        _params['major'] = major
        _params['minor'] = minor
        _params['number'] = number
        _params['series'] = series
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(FullStatus)
    async def FullStatus(self, patterns=None):
        '''
        patterns : typing.Sequence[str]
        Returns -> FullStatus
        '''
        if patterns is not None and not isinstance(patterns, (bytes, str, list)):
            raise Exception("Expected patterns to be a Sequence, received: {}".format(type(patterns)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='FullStatus',
                   version=1,
                   params=_params)
        _params['patterns'] = patterns
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BundleChangesResults)
    async def GetBundleChanges(self, yaml=None):
        '''
        yaml : str
        Returns -> BundleChangesResults
        '''
        if yaml is not None and not isinstance(yaml, (bytes, str)):
            raise Exception("Expected yaml to be a str, received: {}".format(type(yaml)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='GetBundleChanges',
                   version=1,
                   params=_params)
        _params['yaml'] = yaml
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GetConstraintsResults)
    async def GetModelConstraints(self):
        '''

        Returns -> GetConstraintsResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='GetModelConstraints',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AddMachinesResults)
    async def InjectMachines(self, params=None):
        '''
        params : typing.Sequence[~AddMachineParams]
        Returns -> AddMachinesResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='InjectMachines',
                   version=1,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelConfigResults)
    async def ModelGet(self):
        '''

        Returns -> ModelConfigResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelGet',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelInfo)
    async def ModelInfo(self):
        '''

        Returns -> ModelInfo
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelInfo',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelSet(self, config=None):
        '''
        config : typing.Mapping[str, typing.Any]
        Returns -> None
        '''
        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelSet',
                   version=1,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelUnset(self, keys=None):
        '''
        keys : typing.Sequence[str]
        Returns -> None
        '''
        if keys is not None and not isinstance(keys, (bytes, str, list)):
            raise Exception("Expected keys to be a Sequence, received: {}".format(type(keys)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelUnset',
                   version=1,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ModelUserInfoResults)
    async def ModelUserInfo(self):
        '''

        Returns -> ModelUserInfoResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ModelUserInfo',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PrivateAddressResults)
    async def PrivateAddress(self, target=None):
        '''
        target : str
        Returns -> PrivateAddressResults
        '''
        if target is not None and not isinstance(target, (bytes, str)):
            raise Exception("Expected target to be a str, received: {}".format(type(target)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='PrivateAddress',
                   version=1,
                   params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProvisioningScriptResult)
    async def ProvisioningScript(self, data_dir=None, disable_package_commands=None, machine_id=None, nonce=None):
        '''
        data_dir : str
        disable_package_commands : bool
        machine_id : str
        nonce : str
        Returns -> ProvisioningScriptResult
        '''
        if data_dir is not None and not isinstance(data_dir, (bytes, str)):
            raise Exception("Expected data_dir to be a str, received: {}".format(type(data_dir)))

        if disable_package_commands is not None and not isinstance(disable_package_commands, bool):
            raise Exception("Expected disable_package_commands to be a bool, received: {}".format(type(disable_package_commands)))

        if machine_id is not None and not isinstance(machine_id, (bytes, str)):
            raise Exception("Expected machine_id to be a str, received: {}".format(type(machine_id)))

        if nonce is not None and not isinstance(nonce, (bytes, str)):
            raise Exception("Expected nonce to be a str, received: {}".format(type(nonce)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ProvisioningScript',
                   version=1,
                   params=_params)
        _params['data-dir'] = data_dir
        _params['disable-package-commands'] = disable_package_commands
        _params['machine-id'] = machine_id
        _params['nonce'] = nonce
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PublicAddressResults)
    async def PublicAddress(self, target=None):
        '''
        target : str
        Returns -> PublicAddressResults
        '''
        if target is not None and not isinstance(target, (bytes, str)):
            raise Exception("Expected target to be a str, received: {}".format(type(target)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='PublicAddress',
                   version=1,
                   params=_params)
        _params['target'] = target
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ResolveCharmResults)
    async def ResolveCharms(self, references=None):
        '''
        references : typing.Sequence[str]
        Returns -> ResolveCharmResults
        '''
        if references is not None and not isinstance(references, (bytes, str, list)):
            raise Exception("Expected references to be a Sequence, received: {}".format(type(references)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='ResolveCharms',
                   version=1,
                   params=_params)
        _params['references'] = references
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Resolved(self, retry=None, unit_name=None):
        '''
        retry : bool
        unit_name : str
        Returns -> None
        '''
        if retry is not None and not isinstance(retry, bool):
            raise Exception("Expected retry to be a bool, received: {}".format(type(retry)))

        if unit_name is not None and not isinstance(unit_name, (bytes, str)):
            raise Exception("Expected unit_name to be a str, received: {}".format(type(unit_name)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='Resolved',
                   version=1,
                   params=_params)
        _params['retry'] = retry
        _params['unit-name'] = unit_name
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RetryProvisioning(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='RetryProvisioning',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def SLALevel(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SLALevel',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetModelAgentVersion(self, version=None):
        '''
        version : Number
        Returns -> None
        '''
        if version is not None and not isinstance(version, (dict, Number)):
            raise Exception("Expected version to be a Number, received: {}".format(type(version)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SetModelAgentVersion',
                   version=1,
                   params=_params)
        _params['version'] = version
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetModelConstraints(self, application=None, constraints=None):
        '''
        application : str
        constraints : Value
        Returns -> None
        '''
        if application is not None and not isinstance(application, (bytes, str)):
            raise Exception("Expected application to be a str, received: {}".format(type(application)))

        if constraints is not None and not isinstance(constraints, (dict, Value)):
            raise Exception("Expected constraints to be a Value, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SetModelConstraints',
                   version=1,
                   params=_params)
        _params['application'] = application
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetSLALevel(self, modelslainfo=None, creds=None):
        '''
        modelslainfo : ModelSLAInfo
        creds : typing.Sequence[int]
        Returns -> None
        '''
        if modelslainfo is not None and not isinstance(modelslainfo, (dict, ModelSLAInfo)):
            raise Exception("Expected modelslainfo to be a ModelSLAInfo, received: {}".format(type(modelslainfo)))

        if creds is not None and not isinstance(creds, (bytes, str, list)):
            raise Exception("Expected creds to be a Sequence, received: {}".format(type(creds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='SetSLALevel',
                   version=1,
                   params=_params)
        _params['ModelSLAInfo'] = modelslainfo
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StatusHistoryResults)
    async def StatusHistory(self, requests=None):
        '''
        requests : typing.Sequence[~StatusHistoryRequest]
        Returns -> StatusHistoryResults
        '''
        if requests is not None and not isinstance(requests, (bytes, str, list)):
            raise Exception("Expected requests to be a Sequence, received: {}".format(type(requests)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='StatusHistory',
                   version=1,
                   params=_params)
        _params['requests'] = requests
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(AllWatcherId)
    async def WatchAll(self):
        '''

        Returns -> AllWatcherId
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Client',
                   request='WatchAll',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CloudFacade(Type):
    name = 'Cloud'
    version = 1
    schema =     {'definitions': {'Cloud': {'additionalProperties': False,
                               'properties': {'auth-types': {'items': {'type': 'string'},
                                                             'type': 'array'},
                                              'endpoint': {'type': 'string'},
                                              'identity-endpoint': {'type': 'string'},
                                              'regions': {'items': {'$ref': '#/definitions/CloudRegion'},
                                                          'type': 'array'},
                                              'storage-endpoint': {'type': 'string'},
                                              'type': {'type': 'string'}},
                               'required': ['type'],
                               'type': 'object'},
                     'CloudCredential': {'additionalProperties': False,
                                         'properties': {'attrs': {'patternProperties': {'.*': {'type': 'string'}},
                                                                  'type': 'object'},
                                                        'auth-type': {'type': 'string'},
                                                        'redacted': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['auth-type'],
                                         'type': 'object'},
                     'CloudCredentialResult': {'additionalProperties': False,
                                               'properties': {'error': {'$ref': '#/definitions/Error'},
                                                              'result': {'$ref': '#/definitions/CloudCredential'}},
                                               'type': 'object'},
                     'CloudCredentialResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/CloudCredentialResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'CloudInstanceTypesConstraint': {'additionalProperties': False,
                                                      'properties': {'cloud-tag': {'type': 'string'},
                                                                     'constraints': {'$ref': '#/definitions/Value'},
                                                                     'region': {'type': 'string'}},
                                                      'required': ['cloud-tag',
                                                                   'region'],
                                                      'type': 'object'},
                     'CloudInstanceTypesConstraints': {'additionalProperties': False,
                                                       'properties': {'constraints': {'items': {'$ref': '#/definitions/CloudInstanceTypesConstraint'},
                                                                                      'type': 'array'}},
                                                       'required': ['constraints'],
                                                       'type': 'object'},
                     'CloudRegion': {'additionalProperties': False,
                                     'properties': {'endpoint': {'type': 'string'},
                                                    'identity-endpoint': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'storage-endpoint': {'type': 'string'}},
                                     'required': ['name'],
                                     'type': 'object'},
                     'CloudResult': {'additionalProperties': False,
                                     'properties': {'cloud': {'$ref': '#/definitions/Cloud'},
                                                    'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'CloudResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/CloudResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'CloudsResult': {'additionalProperties': False,
                                      'properties': {'clouds': {'patternProperties': {'.*': {'$ref': '#/definitions/Cloud'}},
                                                                'type': 'object'}},
                                      'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'InstanceType': {'additionalProperties': False,
                                      'properties': {'arches': {'items': {'type': 'string'},
                                                                'type': 'array'},
                                                     'cost': {'type': 'integer'},
                                                     'cpu-cores': {'type': 'integer'},
                                                     'deprecated': {'type': 'boolean'},
                                                     'memory': {'type': 'integer'},
                                                     'name': {'type': 'string'},
                                                     'root-disk': {'type': 'integer'},
                                                     'virt-type': {'type': 'string'}},
                                      'required': ['arches', 'cpu-cores', 'memory'],
                                      'type': 'object'},
                     'InstanceTypesResult': {'additionalProperties': False,
                                             'properties': {'cost-currency': {'type': 'string'},
                                                            'cost-divisor': {'type': 'integer'},
                                                            'cost-unit': {'type': 'string'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'instance-types': {'items': {'$ref': '#/definitions/InstanceType'},
                                                                               'type': 'array'}},
                                             'type': 'object'},
                     'InstanceTypesResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/InstanceTypesResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'UpdateCloudCredential': {'additionalProperties': False,
                                               'properties': {'credential': {'$ref': '#/definitions/CloudCredential'},
                                                              'tag': {'type': 'string'}},
                                               'required': ['tag', 'credential'],
                                               'type': 'object'},
                     'UpdateCloudCredentials': {'additionalProperties': False,
                                                'properties': {'credentials': {'items': {'$ref': '#/definitions/UpdateCloudCredential'},
                                                                               'type': 'array'}},
                                                'type': 'object'},
                     'UserCloud': {'additionalProperties': False,
                                   'properties': {'cloud-tag': {'type': 'string'},
                                                  'user-tag': {'type': 'string'}},
                                   'required': ['user-tag', 'cloud-tag'],
                                   'type': 'object'},
                     'UserClouds': {'additionalProperties': False,
                                    'properties': {'user-clouds': {'items': {'$ref': '#/definitions/UserCloud'},
                                                                   'type': 'array'}},
                                    'type': 'object'},
                     'Value': {'additionalProperties': False,
                               'properties': {'arch': {'type': 'string'},
                                              'container': {'type': 'string'},
                                              'cores': {'type': 'integer'},
                                              'cpu-power': {'type': 'integer'},
                                              'instance-type': {'type': 'string'},
                                              'mem': {'type': 'integer'},
                                              'root-disk': {'type': 'integer'},
                                              'spaces': {'items': {'type': 'string'},
                                                         'type': 'array'},
                                              'tags': {'items': {'type': 'string'},
                                                       'type': 'array'},
                                              'virt-type': {'type': 'string'}},
                               'type': 'object'}},
     'properties': {'Cloud': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/CloudResults'}},
                              'type': 'object'},
                    'Clouds': {'properties': {'Result': {'$ref': '#/definitions/CloudsResult'}},
                               'type': 'object'},
                    'Credential': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/CloudCredentialResults'}},
                                   'type': 'object'},
                    'DefaultCloud': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                     'type': 'object'},
                    'InstanceTypes': {'properties': {'Params': {'$ref': '#/definitions/CloudInstanceTypesConstraints'},
                                                     'Result': {'$ref': '#/definitions/InstanceTypesResults'}},
                                      'type': 'object'},
                    'RevokeCredentials': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'UpdateCredentials': {'properties': {'Params': {'$ref': '#/definitions/UpdateCloudCredentials'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'UserCredentials': {'properties': {'Params': {'$ref': '#/definitions/UserClouds'},
                                                       'Result': {'$ref': '#/definitions/StringsResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(CloudResults)
    async def Cloud(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> CloudResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Cloud',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudsResult)
    async def Clouds(self):
        '''

        Returns -> CloudsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Clouds',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(CloudCredentialResults)
    async def Credential(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> CloudCredentialResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='Credential',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def DefaultCloud(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='DefaultCloud',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(InstanceTypesResults)
    async def InstanceTypes(self, constraints=None):
        '''
        constraints : typing.Sequence[~CloudInstanceTypesConstraint]
        Returns -> InstanceTypesResults
        '''
        if constraints is not None and not isinstance(constraints, (bytes, str, list)):
            raise Exception("Expected constraints to be a Sequence, received: {}".format(type(constraints)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='InstanceTypes',
                   version=1,
                   params=_params)
        _params['constraints'] = constraints
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RevokeCredentials(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='RevokeCredentials',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateCredentials(self, credentials=None):
        '''
        credentials : typing.Sequence[~UpdateCloudCredential]
        Returns -> ErrorResults
        '''
        if credentials is not None and not isinstance(credentials, (bytes, str, list)):
            raise Exception("Expected credentials to be a Sequence, received: {}".format(type(credentials)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UpdateCredentials',
                   version=1,
                   params=_params)
        _params['credentials'] = credentials
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def UserCredentials(self, user_clouds=None):
        '''
        user_clouds : typing.Sequence[~UserCloud]
        Returns -> StringsResults
        '''
        if user_clouds is not None and not isinstance(user_clouds, (bytes, str, list)):
            raise Exception("Expected user_clouds to be a Sequence, received: {}".format(type(user_clouds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Cloud',
                   request='UserCredentials',
                   version=1,
                   params=_params)
        _params['user-clouds'] = user_clouds
        reply = await self.rpc(msg)
        return reply



class CredentialManagerFacade(Type):
    name = 'CredentialManager'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'InvalidateCredentialArg': {'additionalProperties': False,
                                                 'properties': {'reason': {'type': 'string'}},
                                                 'type': 'object'}},
     'properties': {'InvalidateModelCredential': {'description': 'InvalidateModelCredential '
                                                                 'marks the cloud '
                                                                 'credential for '
                                                                 'this model as '
                                                                 'invalid.',
                                                  'properties': {'Params': {'$ref': '#/definitions/InvalidateCredentialArg'},
                                                                 'Result': {'$ref': '#/definitions/ErrorResult'}},
                                                  'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def InvalidateModelCredential(self, reason=None):
        '''
        InvalidateModelCredential marks the cloud credential for this model as invalid.

        reason : str
        Returns -> ErrorResult
        '''
        if reason is not None and not isinstance(reason, (bytes, str)):
            raise Exception("Expected reason to be a str, received: {}".format(type(reason)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CredentialManager',
                   request='InvalidateModelCredential',
                   version=1,
                   params=_params)
        _params['reason'] = reason
        reply = await self.rpc(msg)
        return reply



class CrossControllerFacade(Type):
    name = 'CrossController'
    version = 1
    schema =     {'definitions': {'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'ControllerInfo': {'description': 'ControllerInfo returns the '
                                                      'API info for the '
                                                      'controller.',
                                       'properties': {'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                       'type': 'object'},
                    'WatchControllerInfo': {'description': 'WatchControllerInfo '
                                                           'creates a watcher that '
                                                           'notifies when the API '
                                                           'info\n'
                                                           'for the controller '
                                                           'changes.',
                                            'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerInfo(self):
        '''
        ControllerInfo returns the API info for the controller.


        Returns -> ControllerAPIInfoResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossController',
                   request='ControllerInfo',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchControllerInfo(self):
        '''
        WatchControllerInfo creates a watcher that notifies when the API info
        for the controller changes.


        Returns -> NotifyWatchResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossController',
                   request='WatchControllerInfo',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class CrossModelRelationsFacade(Type):
    name = 'CrossModelRelations'
    version = 1
    schema =     {'definitions': {'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'IngressNetworksChangeEvent': {'additionalProperties': False,
                                                    'properties': {'application-token': {'type': 'string'},
                                                                   'ingress-required': {'type': 'boolean'},
                                                                   'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                                 'type': 'array'},
                                                                   'networks': {'items': {'type': 'string'},
                                                                                'type': 'array'},
                                                                   'relation-token': {'type': 'string'}},
                                                    'required': ['relation-token',
                                                                 'application-token',
                                                                 'ingress-required'],
                                                    'type': 'object'},
                     'IngressNetworksChanges': {'additionalProperties': False,
                                                'properties': {'changes': {'items': {'$ref': '#/definitions/IngressNetworksChangeEvent'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'OfferArg': {'additionalProperties': False,
                                  'properties': {'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                               'type': 'array'},
                                                 'offer-uuid': {'type': 'string'}},
                                  'required': ['offer-uuid'],
                                  'type': 'object'},
                     'OfferArgs': {'additionalProperties': False,
                                   'properties': {'args': {'items': {'$ref': '#/definitions/OfferArg'},
                                                           'type': 'array'}},
                                   'required': ['args'],
                                   'type': 'object'},
                     'OfferStatusChange': {'additionalProperties': False,
                                           'properties': {'offer-name': {'type': 'string'},
                                                          'status': {'$ref': '#/definitions/EntityStatus'}},
                                           'required': ['offer-name', 'status'],
                                           'type': 'object'},
                     'OfferStatusWatchResult': {'additionalProperties': False,
                                                'properties': {'changes': {'items': {'$ref': '#/definitions/OfferStatusChange'},
                                                                           'type': 'array'},
                                                               'error': {'$ref': '#/definitions/Error'},
                                                               'watcher-id': {'type': 'string'}},
                                                'required': ['watcher-id',
                                                             'changes'],
                                                'type': 'object'},
                     'OfferStatusWatchResults': {'additionalProperties': False,
                                                 'properties': {'results': {'items': {'$ref': '#/definitions/OfferStatusWatchResult'},
                                                                            'type': 'array'}},
                                                 'required': ['results'],
                                                 'type': 'object'},
                     'RegisterRemoteRelationArg': {'additionalProperties': False,
                                                   'properties': {'application-token': {'type': 'string'},
                                                                  'local-endpoint-name': {'type': 'string'},
                                                                  'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                                'type': 'array'},
                                                                  'offer-uuid': {'type': 'string'},
                                                                  'relation-token': {'type': 'string'},
                                                                  'remote-endpoint': {'$ref': '#/definitions/RemoteEndpoint'},
                                                                  'remote-space': {'$ref': '#/definitions/RemoteSpace'},
                                                                  'source-model-tag': {'type': 'string'}},
                                                   'required': ['application-token',
                                                                'source-model-tag',
                                                                'relation-token',
                                                                'remote-endpoint',
                                                                'remote-space',
                                                                'offer-uuid',
                                                                'local-endpoint-name'],
                                                   'type': 'object'},
                     'RegisterRemoteRelationArgs': {'additionalProperties': False,
                                                    'properties': {'relations': {'items': {'$ref': '#/definitions/RegisterRemoteRelationArg'},
                                                                                 'type': 'array'}},
                                                    'required': ['relations'],
                                                    'type': 'object'},
                     'RegisterRemoteRelationResult': {'additionalProperties': False,
                                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                     'result': {'$ref': '#/definitions/RemoteRelationDetails'}},
                                                      'type': 'object'},
                     'RegisterRemoteRelationResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/RegisterRemoteRelationResult'},
                                                                                  'type': 'array'}},
                                                       'type': 'object'},
                     'RelationLifeSuspendedStatusChange': {'additionalProperties': False,
                                                           'properties': {'key': {'type': 'string'},
                                                                          'life': {'type': 'string'},
                                                                          'suspended': {'type': 'boolean'},
                                                                          'suspended-reason': {'type': 'string'}},
                                                           'required': ['key',
                                                                        'life',
                                                                        'suspended',
                                                                        'suspended-reason'],
                                                           'type': 'object'},
                     'RelationLifeSuspendedStatusWatchResult': {'additionalProperties': False,
                                                                'properties': {'changes': {'items': {'$ref': '#/definitions/RelationLifeSuspendedStatusChange'},
                                                                                           'type': 'array'},
                                                                               'error': {'$ref': '#/definitions/Error'},
                                                                               'watcher-id': {'type': 'string'}},
                                                                'required': ['watcher-id',
                                                                             'changes'],
                                                                'type': 'object'},
                     'RelationStatusWatchResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/RelationLifeSuspendedStatusWatchResult'},
                                                                               'type': 'array'}},
                                                    'required': ['results'],
                                                    'type': 'object'},
                     'RelationUnitsChange': {'additionalProperties': False,
                                             'properties': {'app-changed': {'patternProperties': {'.*': {'type': 'integer'}},
                                                                            'type': 'object'},
                                                            'changed': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitSettings'}},
                                                                        'type': 'object'},
                                                            'departed': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                             'required': ['changed'],
                                             'type': 'object'},
                     'RelationUnitsWatchResult': {'additionalProperties': False,
                                                  'properties': {'changes': {'$ref': '#/definitions/RelationUnitsChange'},
                                                                 'error': {'$ref': '#/definitions/Error'},
                                                                 'watcher-id': {'type': 'string'}},
                                                  'required': ['watcher-id',
                                                               'changes'],
                                                  'type': 'object'},
                     'RelationUnitsWatchResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/RelationUnitsWatchResult'},
                                                                              'type': 'array'}},
                                                   'required': ['results'],
                                                   'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'RemoteEntityArg': {'additionalProperties': False,
                                         'properties': {'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                      'type': 'array'},
                                                        'relation-token': {'type': 'string'}},
                                         'required': ['relation-token'],
                                         'type': 'object'},
                     'RemoteEntityArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/RemoteEntityArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'RemoteRelationChangeEvent': {'additionalProperties': False,
                                                   'properties': {'application-token': {'type': 'string'},
                                                                  'changed-units': {'items': {'$ref': '#/definitions/RemoteRelationUnitChange'},
                                                                                    'type': 'array'},
                                                                  'departed-units': {'items': {'type': 'integer'},
                                                                                     'type': 'array'},
                                                                  'force-cleanup': {'type': 'boolean'},
                                                                  'life': {'type': 'string'},
                                                                  'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                                'type': 'array'},
                                                                  'relation-token': {'type': 'string'},
                                                                  'suspended': {'type': 'boolean'},
                                                                  'suspended-reason': {'type': 'string'}},
                                                   'required': ['relation-token',
                                                                'application-token',
                                                                'life'],
                                                   'type': 'object'},
                     'RemoteRelationDetails': {'additionalProperties': False,
                                               'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                              'relation-token': {'type': 'string'}},
                                               'required': ['relation-token'],
                                               'type': 'object'},
                     'RemoteRelationUnit': {'additionalProperties': False,
                                            'properties': {'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                         'type': 'array'},
                                                           'relation-token': {'type': 'string'},
                                                           'unit': {'type': 'string'}},
                                            'required': ['relation-token', 'unit'],
                                            'type': 'object'},
                     'RemoteRelationUnitChange': {'additionalProperties': False,
                                                  'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                                 'unit-id': {'type': 'integer'}},
                                                  'required': ['unit-id'],
                                                  'type': 'object'},
                     'RemoteRelationUnits': {'additionalProperties': False,
                                             'properties': {'relation-units': {'items': {'$ref': '#/definitions/RemoteRelationUnit'},
                                                                               'type': 'array'}},
                                             'required': ['relation-units'],
                                             'type': 'object'},
                     'RemoteRelationsChanges': {'additionalProperties': False,
                                                'properties': {'changes': {'items': {'$ref': '#/definitions/RemoteRelationChangeEvent'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'RemoteSpace': {'additionalProperties': False,
                                     'properties': {'cloud-type': {'type': 'string'},
                                                    'name': {'type': 'string'},
                                                    'provider-attributes': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                         'type': 'object'}},
                                                                            'type': 'object'},
                                                    'provider-id': {'type': 'string'},
                                                    'subnets': {'items': {'$ref': '#/definitions/Subnet'},
                                                                'type': 'array'}},
                                     'required': ['cloud-type',
                                                  'name',
                                                  'provider-id',
                                                  'provider-attributes',
                                                  'subnets'],
                                     'type': 'object'},
                     'SettingsResult': {'additionalProperties': False,
                                        'properties': {'error': {'$ref': '#/definitions/Error'},
                                                       'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                    'type': 'object'}},
                                        'required': ['settings'],
                                        'type': 'object'},
                     'SettingsResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/SettingsResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'Subnet': {'additionalProperties': False,
                                'properties': {'cidr': {'type': 'string'},
                                               'life': {'type': 'string'},
                                               'provider-id': {'type': 'string'},
                                               'provider-network-id': {'type': 'string'},
                                               'provider-space-id': {'type': 'string'},
                                               'space-tag': {'type': 'string'},
                                               'status': {'type': 'string'},
                                               'vlan-tag': {'type': 'integer'},
                                               'zones': {'items': {'type': 'string'},
                                                         'type': 'array'}},
                                'required': ['cidr',
                                             'vlan-tag',
                                             'life',
                                             'space-tag',
                                             'zones'],
                                'type': 'object'},
                     'UnitSettings': {'additionalProperties': False,
                                      'properties': {'version': {'type': 'integer'}},
                                      'required': ['version'],
                                      'type': 'object'}},
     'properties': {'PublishIngressNetworkChanges': {'properties': {'Params': {'$ref': '#/definitions/IngressNetworksChanges'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                     'type': 'object'},
                    'PublishRelationChanges': {'properties': {'Params': {'$ref': '#/definitions/RemoteRelationsChanges'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'RegisterRemoteRelations': {'properties': {'Params': {'$ref': '#/definitions/RegisterRemoteRelationArgs'},
                                                               'Result': {'$ref': '#/definitions/RegisterRemoteRelationResults'}},
                                                'type': 'object'},
                    'RelationUnitSettings': {'properties': {'Params': {'$ref': '#/definitions/RemoteRelationUnits'},
                                                            'Result': {'$ref': '#/definitions/SettingsResults'}},
                                             'type': 'object'},
                    'WatchEgressAddressesForRelations': {'properties': {'Params': {'$ref': '#/definitions/RemoteEntityArgs'},
                                                                        'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                         'type': 'object'},
                    'WatchOfferStatus': {'properties': {'Params': {'$ref': '#/definitions/OfferArgs'},
                                                        'Result': {'$ref': '#/definitions/OfferStatusWatchResults'}},
                                         'type': 'object'},
                    'WatchRelationUnits': {'properties': {'Params': {'$ref': '#/definitions/RemoteEntityArgs'},
                                                          'Result': {'$ref': '#/definitions/RelationUnitsWatchResults'}},
                                           'type': 'object'},
                    'WatchRelationsSuspendedStatus': {'properties': {'Params': {'$ref': '#/definitions/RemoteEntityArgs'},
                                                                     'Result': {'$ref': '#/definitions/RelationStatusWatchResults'}},
                                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def PublishIngressNetworkChanges(self, changes=None):
        '''
        changes : typing.Sequence[~IngressNetworksChangeEvent]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='PublishIngressNetworkChanges',
                   version=1,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def PublishRelationChanges(self, changes=None):
        '''
        changes : typing.Sequence[~RemoteRelationChangeEvent]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='PublishRelationChanges',
                   version=1,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RegisterRemoteRelationResults)
    async def RegisterRemoteRelations(self, relations=None):
        '''
        relations : typing.Sequence[~RegisterRemoteRelationArg]
        Returns -> RegisterRemoteRelationResults
        '''
        if relations is not None and not isinstance(relations, (bytes, str, list)):
            raise Exception("Expected relations to be a Sequence, received: {}".format(type(relations)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='RegisterRemoteRelations',
                   version=1,
                   params=_params)
        _params['relations'] = relations
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SettingsResults)
    async def RelationUnitSettings(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RemoteRelationUnit]
        Returns -> SettingsResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='RelationUnitSettings',
                   version=1,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchEgressAddressesForRelations(self, args=None):
        '''
        args : typing.Sequence[~RemoteEntityArg]
        Returns -> StringsWatchResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='WatchEgressAddressesForRelations',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(OfferStatusWatchResults)
    async def WatchOfferStatus(self, args=None):
        '''
        args : typing.Sequence[~OfferArg]
        Returns -> OfferStatusWatchResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='WatchOfferStatus',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationUnitsWatchResults)
    async def WatchRelationUnits(self, args=None):
        '''
        args : typing.Sequence[~RemoteEntityArg]
        Returns -> RelationUnitsWatchResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='WatchRelationUnits',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationStatusWatchResults)
    async def WatchRelationsSuspendedStatus(self, args=None):
        '''
        args : typing.Sequence[~RemoteEntityArg]
        Returns -> RelationStatusWatchResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='CrossModelRelations',
                   request='WatchRelationsSuspendedStatus',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



class DeployerFacade(Type):
    name = 'Deployer'
    version = 1
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'DeployerConnectionValues': {'additionalProperties': False,
                                                  'properties': {'api-addresses': {'items': {'type': 'string'},
                                                                                   'type': 'array'}},
                                                  'required': ['api-addresses'],
                                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'}},
     'properties': {'APIAddresses': {'description': 'APIAddresses returns the list '
                                                    'of addresses used to connect '
                                                    'to the API.',
                                     'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'description': 'APIHostPorts returns the API '
                                                    'server addresses.',
                                     'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'ConnectionInfo': {'description': 'ConnectionInfo returns all '
                                                      'the address information '
                                                      'that the\n'
                                                      'deployer task needs in one '
                                                      'call.',
                                       'properties': {'Result': {'$ref': '#/definitions/DeployerConnectionValues'}},
                                       'type': 'object'},
                    'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelUUID': {'description': 'ModelUUID returns the model UUID '
                                                 'to connect to the model\n'
                                                 'that the current connection is '
                                                 'for.',
                                  'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'Remove': {'description': 'Remove removes every given entity '
                                              'from state, calling EnsureDead\n'
                                              'first, then Remove. It will fail if '
                                              'the entity is not present.',
                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'SetPasswords': {'description': 'SetPasswords sets the given '
                                                    'password for each supplied '
                                                    'entity, if possible.',
                                     'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'SetStatus': {'description': 'SetStatus sets the status of the '
                                                 'specified entities.',
                                  'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'UpdateStatus': {'description': 'UpdateStatus updates the '
                                                    'status data of each given '
                                                    'entity.\n'
                                                    'TODO(fwereade): WTF. This '
                                                    'method exists *only* for the '
                                                    'convenience of the\n'
                                                    '*client* API -- and is itself '
                                                    'completely broken -- but we '
                                                    'still expose it\n'
                                                    'in every facade with a '
                                                    'StatusSetter? FFS.',
                                     'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchAPIHostPorts': {'description': 'WatchAPIHostPorts '
                                                         'watches the API server '
                                                         'addresses.',
                                          'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'},
                    'WatchUnits': {'description': 'WatchUnits starts a '
                                                  'StringsWatcher to watch all '
                                                  'units belonging to\n'
                                                  'to any entity (machine or '
                                                  'service) passed in args.',
                                   'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''
        APIAddresses returns the list of addresses used to connect to the API.


        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='APIAddresses',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''
        APIHostPorts returns the API server addresses.


        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='APIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(DeployerConnectionValues)
    async def ConnectionInfo(self):
        '''
        ConnectionInfo returns all the address information that the
        deployer task needs in one call.


        Returns -> DeployerConnectionValues
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='ConnectionInfo',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='Life',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''
        ModelUUID returns the model UUID to connect to the model
        that the current connection is for.


        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='ModelUUID',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Remove(self, entities=None):
        '''
        Remove removes every given entity from state, calling EnsureDead
        first, then Remove. It will fail if the entity is not present.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='Remove',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPasswords(self, changes=None):
        '''
        SetPasswords sets the given password for each supplied entity, if possible.

        changes : typing.Sequence[~EntityPassword]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='SetPasswords',
                   version=1,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        SetStatus sets the status of the specified entities.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='SetStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities=None):
        '''
        UpdateStatus updates the status data of each given entity.
        TODO(fwereade): WTF. This method exists *only* for the convenience of the
        *client* API -- and is itself completely broken -- but we still expose it
        in every facade with a StatusSetter? FFS.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='UpdateStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''
        WatchAPIHostPorts watches the API server addresses.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='WatchAPIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchUnits(self, entities=None):
        '''
        WatchUnits starts a StringsWatcher to watch all units belonging to
        to any entity (machine or service) passed in args.

        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Deployer',
                   request='WatchUnits',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class ExternalControllerUpdaterFacade(Type):
    name = 'ExternalControllerUpdater'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ExternalControllerInfo': {'additionalProperties': False,
                                                'properties': {'addrs': {'items': {'type': 'string'},
                                                                         'type': 'array'},
                                                               'ca-cert': {'type': 'string'},
                                                               'controller-alias': {'type': 'string'},
                                                               'controller-tag': {'type': 'string'}},
                                                'required': ['controller-tag',
                                                             'controller-alias',
                                                             'addrs',
                                                             'ca-cert'],
                                                'type': 'object'},
                     'ExternalControllerInfoResult': {'additionalProperties': False,
                                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                     'result': {'$ref': '#/definitions/ExternalControllerInfo'}},
                                                      'required': ['result',
                                                                   'error'],
                                                      'type': 'object'},
                     'ExternalControllerInfoResults': {'additionalProperties': False,
                                                       'properties': {'results': {'items': {'$ref': '#/definitions/ExternalControllerInfoResult'},
                                                                                  'type': 'array'}},
                                                       'required': ['results'],
                                                       'type': 'object'},
                     'SetExternalControllerInfoParams': {'additionalProperties': False,
                                                         'properties': {'info': {'$ref': '#/definitions/ExternalControllerInfo'}},
                                                         'required': ['info'],
                                                         'type': 'object'},
                     'SetExternalControllersInfoParams': {'additionalProperties': False,
                                                          'properties': {'controllers': {'items': {'$ref': '#/definitions/SetExternalControllerInfoParams'},
                                                                                         'type': 'array'}},
                                                          'required': ['controllers'],
                                                          'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'}},
     'properties': {'ExternalControllerInfo': {'description': 'ExternalControllerInfo '
                                                              'returns the info '
                                                              'for the specified '
                                                              'external '
                                                              'controllers.',
                                               'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                              'Result': {'$ref': '#/definitions/ExternalControllerInfoResults'}},
                                               'type': 'object'},
                    'SetExternalControllerInfo': {'description': 'SetExternalControllerInfo '
                                                                 'saves the info '
                                                                 'for the '
                                                                 'specified '
                                                                 'external '
                                                                 'controllers.',
                                                  'properties': {'Params': {'$ref': '#/definitions/SetExternalControllersInfoParams'},
                                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                  'type': 'object'},
                    'WatchExternalControllers': {'description': 'WatchExternalControllers '
                                                                'watches for the '
                                                                'addition and '
                                                                'removal of '
                                                                'external\n'
                                                                'controller '
                                                                'records to the '
                                                                'local '
                                                                "controller's "
                                                                'database.',
                                                 'properties': {'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ExternalControllerInfoResults)
    async def ExternalControllerInfo(self, entities=None):
        '''
        ExternalControllerInfo returns the info for the specified external controllers.

        entities : typing.Sequence[~Entity]
        Returns -> ExternalControllerInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ExternalControllerUpdater',
                   request='ExternalControllerInfo',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetExternalControllerInfo(self, controllers=None):
        '''
        SetExternalControllerInfo saves the info for the specified external controllers.

        controllers : typing.Sequence[~SetExternalControllerInfoParams]
        Returns -> ErrorResults
        '''
        if controllers is not None and not isinstance(controllers, (bytes, str, list)):
            raise Exception("Expected controllers to be a Sequence, received: {}".format(type(controllers)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ExternalControllerUpdater',
                   request='SetExternalControllerInfo',
                   version=1,
                   params=_params)
        _params['controllers'] = controllers
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchExternalControllers(self):
        '''
        WatchExternalControllers watches for the addition and removal of external
        controller records to the local controller's database.


        Returns -> StringsWatchResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ExternalControllerUpdater',
                   request='WatchExternalControllers',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class FanConfigurerFacade(Type):
    name = 'FanConfigurer'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'FanConfigEntry': {'additionalProperties': False,
                                        'properties': {'overlay': {'type': 'string'},
                                                       'underlay': {'type': 'string'}},
                                        'required': ['underlay', 'overlay'],
                                        'type': 'object'},
                     'FanConfigResult': {'additionalProperties': False,
                                         'properties': {'fans': {'items': {'$ref': '#/definitions/FanConfigEntry'},
                                                                 'type': 'array'}},
                                         'required': ['fans'],
                                         'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'}},
     'properties': {'FanConfig': {'description': 'FanConfig returns current FAN '
                                                 'configuration.',
                                  'properties': {'Result': {'$ref': '#/definitions/FanConfigResult'}},
                                  'type': 'object'},
                    'WatchForFanConfigChanges': {'description': 'WatchForFanConfigChanges '
                                                                'returns a '
                                                                'NotifyWatcher '
                                                                'that observes\n'
                                                                'changes to the '
                                                                'FAN '
                                                                'configuration.\n'
                                                                'so we use the '
                                                                'regular error '
                                                                'return.\n'
                                                                'TODO(wpk) '
                                                                '2017-09-21 We '
                                                                'should use Model '
                                                                'directly, and '
                                                                'watch only for '
                                                                'FanConfig '
                                                                'changes.',
                                                 'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(FanConfigResult)
    async def FanConfig(self):
        '''
        FanConfig returns current FAN configuration.


        Returns -> FanConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FanConfigurer',
                   request='FanConfig',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchForFanConfigChanges(self):
        '''
        WatchForFanConfigChanges returns a NotifyWatcher that observes
        changes to the FAN configuration.
        so we use the regular error return.
        TODO(wpk) 2017-09-21 We should use Model directly, and watch only for FanConfig changes.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FanConfigurer',
                   request='WatchForFanConfigChanges',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class FirewallRulesFacade(Type):
    name = 'FirewallRules'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'FirewallRule': {'additionalProperties': False,
                                      'properties': {'known-service': {'type': 'string'},
                                                     'whitelist-cidrs': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                      'required': ['known-service'],
                                      'type': 'object'},
                     'FirewallRuleArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/FirewallRule'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'ListFirewallRulesResults': {'additionalProperties': False,
                                                  'properties': {'Rules': {'items': {'$ref': '#/definitions/FirewallRule'},
                                                                           'type': 'array'}},
                                                  'required': ['Rules'],
                                                  'type': 'object'}},
     'properties': {'ListFirewallRules': {'description': 'ListFirewallRules '
                                                         'returns all the firewall '
                                                         'rules.',
                                          'properties': {'Result': {'$ref': '#/definitions/ListFirewallRulesResults'}},
                                          'type': 'object'},
                    'SetFirewallRules': {'description': 'SetFirewallRules creates '
                                                        'or updates the specified '
                                                        'firewall rules.',
                                         'properties': {'Params': {'$ref': '#/definitions/FirewallRuleArgs'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ListFirewallRulesResults)
    async def ListFirewallRules(self):
        '''
        ListFirewallRules returns all the firewall rules.


        Returns -> ListFirewallRulesResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FirewallRules',
                   request='ListFirewallRules',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetFirewallRules(self, args=None):
        '''
        SetFirewallRules creates or updates the specified firewall rules.

        args : typing.Sequence[~FirewallRule]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='FirewallRules',
                   request='SetFirewallRules',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



class HostKeyReporterFacade(Type):
    name = 'HostKeyReporter'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'SSHHostKeySet': {'additionalProperties': False,
                                       'properties': {'entity-keys': {'items': {'$ref': '#/definitions/SSHHostKeys'},
                                                                      'type': 'array'}},
                                       'required': ['entity-keys'],
                                       'type': 'object'},
                     'SSHHostKeys': {'additionalProperties': False,
                                     'properties': {'public-keys': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                    'tag': {'type': 'string'}},
                                     'required': ['tag', 'public-keys'],
                                     'type': 'object'}},
     'properties': {'ReportKeys': {'description': 'ReportKeys sets the SSH host '
                                                  'keys for one or more entities.',
                                   'properties': {'Params': {'$ref': '#/definitions/SSHHostKeySet'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ReportKeys(self, entity_keys=None):
        '''
        ReportKeys sets the SSH host keys for one or more entities.

        entity_keys : typing.Sequence[~SSHHostKeys]
        Returns -> ErrorResults
        '''
        if entity_keys is not None and not isinstance(entity_keys, (bytes, str, list)):
            raise Exception("Expected entity_keys to be a Sequence, received: {}".format(type(entity_keys)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='HostKeyReporter',
                   request='ReportKeys',
                   version=1,
                   params=_params)
        _params['entity-keys'] = entity_keys
        reply = await self.rpc(msg)
        return reply



class ImageMetadataManagerFacade(Type):
    name = 'ImageMetadataManager'
    version = 1
    schema =     {'definitions': {'CloudImageMetadata': {'additionalProperties': False,
                                            'properties': {'arch': {'type': 'string'},
                                                           'image-id': {'type': 'string'},
                                                           'priority': {'type': 'integer'},
                                                           'region': {'type': 'string'},
                                                           'root-storage-size': {'type': 'integer'},
                                                           'root-storage-type': {'type': 'string'},
                                                           'series': {'type': 'string'},
                                                           'source': {'type': 'string'},
                                                           'stream': {'type': 'string'},
                                                           'version': {'type': 'string'},
                                                           'virt-type': {'type': 'string'}},
                                            'required': ['image-id',
                                                         'region',
                                                         'version',
                                                         'series',
                                                         'arch',
                                                         'source',
                                                         'priority'],
                                            'type': 'object'},
                     'CloudImageMetadataList': {'additionalProperties': False,
                                                'properties': {'metadata': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                            'type': 'array'}},
                                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ImageMetadataFilter': {'additionalProperties': False,
                                             'properties': {'arches': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                            'region': {'type': 'string'},
                                                            'root-storage-type': {'type': 'string'},
                                                            'series': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                            'stream': {'type': 'string'},
                                                            'virt-type': {'type': 'string'}},
                                             'type': 'object'},
                     'ListCloudImageMetadataResult': {'additionalProperties': False,
                                                      'properties': {'result': {'items': {'$ref': '#/definitions/CloudImageMetadata'},
                                                                                'type': 'array'}},
                                                      'required': ['result'],
                                                      'type': 'object'},
                     'MetadataImageIds': {'additionalProperties': False,
                                          'properties': {'image-ids': {'items': {'type': 'string'},
                                                                       'type': 'array'}},
                                          'required': ['image-ids'],
                                          'type': 'object'},
                     'MetadataSaveParams': {'additionalProperties': False,
                                            'properties': {'metadata': {'items': {'$ref': '#/definitions/CloudImageMetadataList'},
                                                                        'type': 'array'}},
                                            'type': 'object'}},
     'properties': {'Delete': {'description': 'Delete deletes cloud image metadata '
                                              'for given image ids.\n'
                                              'It supports bulk calls.',
                               'properties': {'Params': {'$ref': '#/definitions/MetadataImageIds'},
                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                               'type': 'object'},
                    'List': {'description': 'List returns all found cloud image '
                                            'metadata that satisfy\n'
                                            'given filter.\n'
                                            'Returned list contains metadata '
                                            'ordered by priority.',
                             'properties': {'Params': {'$ref': '#/definitions/ImageMetadataFilter'},
                                            'Result': {'$ref': '#/definitions/ListCloudImageMetadataResult'}},
                             'type': 'object'},
                    'Save': {'description': 'Save stores given cloud image '
                                            'metadata.\n'
                                            'It supports bulk calls.',
                             'properties': {'Params': {'$ref': '#/definitions/MetadataSaveParams'},
                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Delete(self, image_ids=None):
        '''
        Delete deletes cloud image metadata for given image ids.
        It supports bulk calls.

        image_ids : typing.Sequence[str]
        Returns -> ErrorResults
        '''
        if image_ids is not None and not isinstance(image_ids, (bytes, str, list)):
            raise Exception("Expected image_ids to be a Sequence, received: {}".format(type(image_ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadataManager',
                   request='Delete',
                   version=1,
                   params=_params)
        _params['image-ids'] = image_ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ListCloudImageMetadataResult)
    async def List(self, arches=None, region=None, root_storage_type=None, series=None, stream=None, virt_type=None):
        '''
        List returns all found cloud image metadata that satisfy
        given filter.
        Returned list contains metadata ordered by priority.

        arches : typing.Sequence[str]
        region : str
        root_storage_type : str
        series : typing.Sequence[str]
        stream : str
        virt_type : str
        Returns -> ListCloudImageMetadataResult
        '''
        if arches is not None and not isinstance(arches, (bytes, str, list)):
            raise Exception("Expected arches to be a Sequence, received: {}".format(type(arches)))

        if region is not None and not isinstance(region, (bytes, str)):
            raise Exception("Expected region to be a str, received: {}".format(type(region)))

        if root_storage_type is not None and not isinstance(root_storage_type, (bytes, str)):
            raise Exception("Expected root_storage_type to be a str, received: {}".format(type(root_storage_type)))

        if series is not None and not isinstance(series, (bytes, str, list)):
            raise Exception("Expected series to be a Sequence, received: {}".format(type(series)))

        if stream is not None and not isinstance(stream, (bytes, str)):
            raise Exception("Expected stream to be a str, received: {}".format(type(stream)))

        if virt_type is not None and not isinstance(virt_type, (bytes, str)):
            raise Exception("Expected virt_type to be a str, received: {}".format(type(virt_type)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadataManager',
                   request='List',
                   version=1,
                   params=_params)
        _params['arches'] = arches
        _params['region'] = region
        _params['root-storage-type'] = root_storage_type
        _params['series'] = series
        _params['stream'] = stream
        _params['virt-type'] = virt_type
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Save(self, metadata=None):
        '''
        Save stores given cloud image metadata.
        It supports bulk calls.

        metadata : typing.Sequence[~CloudImageMetadataList]
        Returns -> ErrorResults
        '''
        if metadata is not None and not isinstance(metadata, (bytes, str, list)):
            raise Exception("Expected metadata to be a Sequence, received: {}".format(type(metadata)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ImageMetadataManager',
                   request='Save',
                   version=1,
                   params=_params)
        _params['metadata'] = metadata
        reply = await self.rpc(msg)
        return reply



class KeyManagerFacade(Type):
    name = 'KeyManager'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ListSSHKeys': {'additionalProperties': False,
                                     'properties': {'entities': {'$ref': '#/definitions/Entities'},
                                                    'mode': {'type': 'boolean'}},
                                     'required': ['entities', 'mode'],
                                     'type': 'object'},
                     'ModifyUserSSHKeys': {'additionalProperties': False,
                                           'properties': {'ssh-keys': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                          'user': {'type': 'string'}},
                                           'required': ['user', 'ssh-keys'],
                                           'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'}},
     'properties': {'AddKeys': {'description': 'AddKeys adds new authorised ssh '
                                               'keys for the specified user.',
                                'properties': {'Params': {'$ref': '#/definitions/ModifyUserSSHKeys'},
                                               'Result': {'$ref': '#/definitions/ErrorResults'}},
                                'type': 'object'},
                    'DeleteKeys': {'description': 'DeleteKeys deletes the '
                                                  'authorised ssh keys for the '
                                                  'specified user.',
                                   'properties': {'Params': {'$ref': '#/definitions/ModifyUserSSHKeys'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'ImportKeys': {'description': 'ImportKeys imports new '
                                                  'authorised ssh keys from the '
                                                  'specified key ids for the '
                                                  'specified user.',
                                   'properties': {'Params': {'$ref': '#/definitions/ModifyUserSSHKeys'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'ListKeys': {'description': 'ListKeys returns the authorised '
                                                'ssh keys for the specified users.',
                                 'properties': {'Params': {'$ref': '#/definitions/ListSSHKeys'},
                                                'Result': {'$ref': '#/definitions/StringsResults'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AddKeys(self, ssh_keys=None, user=None):
        '''
        AddKeys adds new authorised ssh keys for the specified user.

        ssh_keys : typing.Sequence[str]
        user : str
        Returns -> ErrorResults
        '''
        if ssh_keys is not None and not isinstance(ssh_keys, (bytes, str, list)):
            raise Exception("Expected ssh_keys to be a Sequence, received: {}".format(type(ssh_keys)))

        if user is not None and not isinstance(user, (bytes, str)):
            raise Exception("Expected user to be a str, received: {}".format(type(user)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyManager',
                   request='AddKeys',
                   version=1,
                   params=_params)
        _params['ssh-keys'] = ssh_keys
        _params['user'] = user
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DeleteKeys(self, ssh_keys=None, user=None):
        '''
        DeleteKeys deletes the authorised ssh keys for the specified user.

        ssh_keys : typing.Sequence[str]
        user : str
        Returns -> ErrorResults
        '''
        if ssh_keys is not None and not isinstance(ssh_keys, (bytes, str, list)):
            raise Exception("Expected ssh_keys to be a Sequence, received: {}".format(type(ssh_keys)))

        if user is not None and not isinstance(user, (bytes, str)):
            raise Exception("Expected user to be a str, received: {}".format(type(user)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyManager',
                   request='DeleteKeys',
                   version=1,
                   params=_params)
        _params['ssh-keys'] = ssh_keys
        _params['user'] = user
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ImportKeys(self, ssh_keys=None, user=None):
        '''
        ImportKeys imports new authorised ssh keys from the specified key ids for the specified user.

        ssh_keys : typing.Sequence[str]
        user : str
        Returns -> ErrorResults
        '''
        if ssh_keys is not None and not isinstance(ssh_keys, (bytes, str, list)):
            raise Exception("Expected ssh_keys to be a Sequence, received: {}".format(type(ssh_keys)))

        if user is not None and not isinstance(user, (bytes, str)):
            raise Exception("Expected user to be a str, received: {}".format(type(user)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyManager',
                   request='ImportKeys',
                   version=1,
                   params=_params)
        _params['ssh-keys'] = ssh_keys
        _params['user'] = user
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsResults)
    async def ListKeys(self, entities=None, mode=None):
        '''
        ListKeys returns the authorised ssh keys for the specified users.

        entities : Entities
        mode : bool
        Returns -> StringsResults
        '''
        if entities is not None and not isinstance(entities, (dict, Entities)):
            raise Exception("Expected entities to be a Entities, received: {}".format(type(entities)))

        if mode is not None and not isinstance(mode, bool):
            raise Exception("Expected mode to be a bool, received: {}".format(type(mode)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyManager',
                   request='ListKeys',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        _params['mode'] = mode
        reply = await self.rpc(msg)
        return reply



class KeyUpdaterFacade(Type):
    name = 'KeyUpdater'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'},
                     'StringsResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/StringsResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'}},
     'properties': {'AuthorisedKeys': {'description': 'AuthorisedKeys reports the '
                                                      'authorised ssh keys for the '
                                                      'specified machines.\n'
                                                      'The current implementation '
                                                      'relies on global authorised '
                                                      'keys being stored in the '
                                                      'model config.\n'
                                                      'This will change as new '
                                                      'user management and '
                                                      'authorisation functionality '
                                                      'is added.',
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/StringsResults'}},
                                       'type': 'object'},
                    'WatchAuthorisedKeys': {'description': 'WatchAuthorisedKeys '
                                                           'starts a watcher to '
                                                           'track changes to the '
                                                           'authorised ssh keys\n'
                                                           'for the specified '
                                                           'machines.\n'
                                                           'The current '
                                                           'implementation relies '
                                                           'on global authorised '
                                                           'keys being stored in '
                                                           'the model config.\n'
                                                           'This will change as '
                                                           'new user management '
                                                           'and authorisation '
                                                           'functionality is '
                                                           'added.',
                                            'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResults)
    async def AuthorisedKeys(self, entities=None):
        '''
        AuthorisedKeys reports the authorised ssh keys for the specified machines.
        The current implementation relies on global authorised keys being stored in the model config.
        This will change as new user management and authorisation functionality is added.

        entities : typing.Sequence[~Entity]
        Returns -> StringsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyUpdater',
                   request='AuthorisedKeys',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchAuthorisedKeys(self, entities=None):
        '''
        WatchAuthorisedKeys starts a watcher to track changes to the authorised ssh keys
        for the specified machines.
        The current implementation relies on global authorised keys being stored in the model config.
        This will change as new user management and authorisation functionality is added.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='KeyUpdater',
                   request='WatchAuthorisedKeys',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class LifeFlagFacade(Type):
    name = 'LifeFlag'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'Life': {'description': 'Life returns the life status of every '
                                            'supplied entity, where available.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'Watch': {'description': 'Watch starts an NotifyWatcher for '
                                             'each given entity.',
                              'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        Life returns the life status of every supplied entity, where available.

        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LifeFlag',
                   request='Life',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities=None):
        '''
        Watch starts an NotifyWatcher for each given entity.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LifeFlag',
                   request='Watch',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class LogForwardingFacade(Type):
    name = 'LogForwarding'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'LogForwardingGetLastSentParams': {'additionalProperties': False,
                                                        'properties': {'ids': {'items': {'$ref': '#/definitions/LogForwardingID'},
                                                                               'type': 'array'}},
                                                        'required': ['ids'],
                                                        'type': 'object'},
                     'LogForwardingGetLastSentResult': {'additionalProperties': False,
                                                        'properties': {'err': {'$ref': '#/definitions/Error'},
                                                                       'record-id': {'type': 'integer'},
                                                                       'record-timestamp': {'type': 'integer'}},
                                                        'required': ['record-id',
                                                                     'record-timestamp',
                                                                     'err'],
                                                        'type': 'object'},
                     'LogForwardingGetLastSentResults': {'additionalProperties': False,
                                                         'properties': {'results': {'items': {'$ref': '#/definitions/LogForwardingGetLastSentResult'},
                                                                                    'type': 'array'}},
                                                         'required': ['results'],
                                                         'type': 'object'},
                     'LogForwardingID': {'additionalProperties': False,
                                         'properties': {'model': {'type': 'string'},
                                                        'sink': {'type': 'string'}},
                                         'required': ['model', 'sink'],
                                         'type': 'object'},
                     'LogForwardingSetLastSentParam': {'additionalProperties': False,
                                                       'properties': {'LogForwardingID': {'$ref': '#/definitions/LogForwardingID'},
                                                                      'model': {'type': 'string'},
                                                                      'record-id': {'type': 'integer'},
                                                                      'record-timestamp': {'type': 'integer'},
                                                                      'sink': {'type': 'string'}},
                                                       'required': ['model',
                                                                    'sink',
                                                                    'LogForwardingID',
                                                                    'record-id',
                                                                    'record-timestamp'],
                                                       'type': 'object'},
                     'LogForwardingSetLastSentParams': {'additionalProperties': False,
                                                        'properties': {'params': {'items': {'$ref': '#/definitions/LogForwardingSetLastSentParam'},
                                                                                  'type': 'array'}},
                                                        'required': ['params'],
                                                        'type': 'object'}},
     'properties': {'GetLastSent': {'description': 'GetLastSent is a bulk call '
                                                   'that gets the log forwarding '
                                                   '"last sent"\n'
                                                   'record ID for each requested '
                                                   'target.',
                                    'properties': {'Params': {'$ref': '#/definitions/LogForwardingGetLastSentParams'},
                                                   'Result': {'$ref': '#/definitions/LogForwardingGetLastSentResults'}},
                                    'type': 'object'},
                    'SetLastSent': {'description': 'SetLastSent is a bulk call '
                                                   'that sets the log forwarding '
                                                   '"last sent"\n'
                                                   'record ID for each requested '
                                                   'target.',
                                    'properties': {'Params': {'$ref': '#/definitions/LogForwardingSetLastSentParams'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(LogForwardingGetLastSentResults)
    async def GetLastSent(self, ids=None):
        '''
        GetLastSent is a bulk call that gets the log forwarding "last sent"
        record ID for each requested target.

        ids : typing.Sequence[~LogForwardingID]
        Returns -> LogForwardingGetLastSentResults
        '''
        if ids is not None and not isinstance(ids, (bytes, str, list)):
            raise Exception("Expected ids to be a Sequence, received: {}".format(type(ids)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LogForwarding',
                   request='GetLastSent',
                   version=1,
                   params=_params)
        _params['ids'] = ids
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetLastSent(self, params=None):
        '''
        SetLastSent is a bulk call that sets the log forwarding "last sent"
        record ID for each requested target.

        params : typing.Sequence[~LogForwardingSetLastSentParam]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='LogForwarding',
                   request='SetLastSent',
                   version=1,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



class LoggerFacade(Type):
    name = 'Logger'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'}},
     'properties': {'LoggingConfig': {'description': 'LoggingConfig reports the '
                                                     'logging configuration for '
                                                     'the agents specified.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/StringResults'}},
                                      'type': 'object'},
                    'WatchLoggingConfig': {'description': 'WatchLoggingConfig '
                                                          'starts a watcher to '
                                                          'track changes to the '
                                                          'logging config\n'
                                                          'for the agents '
                                                          'specified..  '
                                                          'Unfortunately the '
                                                          'current infrastructure '
                                                          'makes\n'
                                                          'watching parts of the '
                                                          'config non-trivial, so '
                                                          'currently any change to '
                                                          'the\n'
                                                          'config will cause the '
                                                          'watcher to notify the '
                                                          'client.',
                                           'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringResults)
    async def LoggingConfig(self, entities=None):
        '''
        LoggingConfig reports the logging configuration for the agents specified.

        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Logger',
                   request='LoggingConfig',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchLoggingConfig(self, entities=None):
        '''
        WatchLoggingConfig starts a watcher to track changes to the logging config
        for the agents specified..  Unfortunately the current infrastructure makes
        watching parts of the config non-trivial, so currently any change to the
        config will cause the watcher to notify the client.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Logger',
                   request='WatchLoggingConfig',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MachineActionsFacade(Type):
    name = 'MachineActions'
    version = 1
    schema =     {'definitions': {'Action': {'additionalProperties': False,
                                'properties': {'name': {'type': 'string'},
                                               'parameters': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                               'receiver': {'type': 'string'},
                                               'tag': {'type': 'string'}},
                                'required': ['tag', 'receiver', 'name'],
                                'type': 'object'},
                     'ActionExecutionResult': {'additionalProperties': False,
                                               'properties': {'action-tag': {'type': 'string'},
                                                              'message': {'type': 'string'},
                                                              'results': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'},
                                                              'status': {'type': 'string'}},
                                               'required': ['action-tag', 'status'],
                                               'type': 'object'},
                     'ActionExecutionResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/ActionExecutionResult'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'ActionMessage': {'additionalProperties': False,
                                       'properties': {'message': {'type': 'string'},
                                                      'timestamp': {'format': 'date-time',
                                                                    'type': 'string'}},
                                       'required': ['timestamp', 'message'],
                                       'type': 'object'},
                     'ActionResult': {'additionalProperties': False,
                                      'properties': {'action': {'$ref': '#/definitions/Action'},
                                                     'completed': {'format': 'date-time',
                                                                   'type': 'string'},
                                                     'enqueued': {'format': 'date-time',
                                                                  'type': 'string'},
                                                     'error': {'$ref': '#/definitions/Error'},
                                                     'log': {'items': {'$ref': '#/definitions/ActionMessage'},
                                                             'type': 'array'},
                                                     'message': {'type': 'string'},
                                                     'output': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                             'type': 'object'}},
                                                                'type': 'object'},
                                                     'started': {'format': 'date-time',
                                                                 'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'type': 'object'},
                     'ActionResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                  'type': 'array'}},
                                       'type': 'object'},
                     'ActionsByReceiver': {'additionalProperties': False,
                                           'properties': {'actions': {'items': {'$ref': '#/definitions/ActionResult'},
                                                                      'type': 'array'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'receiver': {'type': 'string'}},
                                           'type': 'object'},
                     'ActionsByReceivers': {'additionalProperties': False,
                                            'properties': {'actions': {'items': {'$ref': '#/definitions/ActionsByReceiver'},
                                                                       'type': 'array'}},
                                            'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'}},
     'properties': {'Actions': {'description': 'Actions returns the Actions by '
                                               'Tags passed and ensures that the '
                                               'machine asking\n'
                                               'for them is the machine that has '
                                               'the actions',
                                'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/ActionResults'}},
                                'type': 'object'},
                    'BeginActions': {'description': 'BeginActions marks the '
                                                    'actions represented by the '
                                                    'passed in Tags as running.',
                                     'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'FinishActions': {'description': 'FinishActions saves the '
                                                     'result of a completed Action',
                                      'properties': {'Params': {'$ref': '#/definitions/ActionExecutionResults'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'RunningActions': {'description': 'RunningActions lists the '
                                                      'actions running for the '
                                                      'entities passed in.\n'
                                                      'If we end up needing more '
                                                      'than ListRunning at some '
                                                      'point we could '
                                                      'follow/abstract\n'
                                                      "what's done in the client "
                                                      'actions package.',
                                       'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/ActionsByReceivers'}},
                                       'type': 'object'},
                    'WatchActionNotifications': {'description': 'WatchActionNotifications '
                                                                'returns a '
                                                                'StringsWatcher '
                                                                'for observing\n'
                                                                'incoming action '
                                                                'calls to a '
                                                                'machine.',
                                                 'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ActionResults)
    async def Actions(self, entities=None):
        '''
        Actions returns the Actions by Tags passed and ensures that the machine asking
        for them is the machine that has the actions

        entities : typing.Sequence[~Entity]
        Returns -> ActionResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions',
                   request='Actions',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def BeginActions(self, entities=None):
        '''
        BeginActions marks the actions represented by the passed in Tags as running.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions',
                   request='BeginActions',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def FinishActions(self, results=None):
        '''
        FinishActions saves the result of a completed Action

        results : typing.Sequence[~ActionExecutionResult]
        Returns -> ErrorResults
        '''
        if results is not None and not isinstance(results, (bytes, str, list)):
            raise Exception("Expected results to be a Sequence, received: {}".format(type(results)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions',
                   request='FinishActions',
                   version=1,
                   params=_params)
        _params['results'] = results
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ActionsByReceivers)
    async def RunningActions(self, entities=None):
        '''
        RunningActions lists the actions running for the entities passed in.
        If we end up needing more than ListRunning at some point we could follow/abstract
        what's done in the client actions package.

        entities : typing.Sequence[~Entity]
        Returns -> ActionsByReceivers
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions',
                   request='RunningActions',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchActionNotifications(self, entities=None):
        '''
        WatchActionNotifications returns a StringsWatcher for observing
        incoming action calls to a machine.

        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineActions',
                   request='WatchActionNotifications',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MachineUndertakerFacade(Type):
    name = 'MachineUndertaker'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesResult': {'additionalProperties': False,
                                        'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                    'type': 'array'},
                                                       'error': {'$ref': '#/definitions/Error'}},
                                        'required': ['entities'],
                                        'type': 'object'},
                     'EntitiesResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/EntitiesResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ProviderInterfaceInfo': {'additionalProperties': False,
                                               'properties': {'interface-name': {'type': 'string'},
                                                              'mac-address': {'type': 'string'},
                                                              'provider-id': {'type': 'string'}},
                                               'required': ['interface-name',
                                                            'mac-address',
                                                            'provider-id'],
                                               'type': 'object'},
                     'ProviderInterfaceInfoResult': {'additionalProperties': False,
                                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                    'interfaces': {'items': {'$ref': '#/definitions/ProviderInterfaceInfo'},
                                                                                   'type': 'array'},
                                                                    'machine-tag': {'type': 'string'}},
                                                     'required': ['machine-tag',
                                                                  'interfaces'],
                                                     'type': 'object'},
                     'ProviderInterfaceInfoResults': {'additionalProperties': False,
                                                      'properties': {'results': {'items': {'$ref': '#/definitions/ProviderInterfaceInfoResult'},
                                                                                 'type': 'array'}},
                                                      'required': ['results'],
                                                      'type': 'object'}},
     'properties': {'AllMachineRemovals': {'description': 'AllMachineRemovals '
                                                          'returns tags for all of '
                                                          'the machines that have\n'
                                                          'been marked for removal '
                                                          'in the requested model.',
                                           'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/EntitiesResults'}},
                                           'type': 'object'},
                    'CompleteMachineRemovals': {'description': 'CompleteMachineRemovals '
                                                               'removes the '
                                                               'specified machines '
                                                               'from the\n'
                                                               'model database. It '
                                                               'should only be '
                                                               'called once any '
                                                               'provider-level\n'
                                                               'cleanup has been '
                                                               'done for those '
                                                               'machines.',
                                                'properties': {'Params': {'$ref': '#/definitions/Entities'}},
                                                'type': 'object'},
                    'GetMachineProviderInterfaceInfo': {'description': 'GetMachineProviderInterfaceInfo '
                                                                       'returns '
                                                                       'the '
                                                                       'provider '
                                                                       'details '
                                                                       'for\n'
                                                                       'all '
                                                                       'network '
                                                                       'interfaces '
                                                                       'attached '
                                                                       'to the '
                                                                       'machines '
                                                                       'requested.',
                                                        'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                       'Result': {'$ref': '#/definitions/ProviderInterfaceInfoResults'}},
                                                        'type': 'object'},
                    'WatchMachineRemovals': {'description': 'WatchMachineRemovals '
                                                            'returns a watcher '
                                                            'that will signal each '
                                                            'time a\n'
                                                            'machine is marked for '
                                                            'removal.',
                                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                            'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(EntitiesResults)
    async def AllMachineRemovals(self, entities=None):
        '''
        AllMachineRemovals returns tags for all of the machines that have
        been marked for removal in the requested model.

        entities : typing.Sequence[~Entity]
        Returns -> EntitiesResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineUndertaker',
                   request='AllMachineRemovals',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def CompleteMachineRemovals(self, entities=None):
        '''
        CompleteMachineRemovals removes the specified machines from the
        model database. It should only be called once any provider-level
        cleanup has been done for those machines.

        entities : typing.Sequence[~Entity]
        Returns -> None
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineUndertaker',
                   request='CompleteMachineRemovals',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ProviderInterfaceInfoResults)
    async def GetMachineProviderInterfaceInfo(self, entities=None):
        '''
        GetMachineProviderInterfaceInfo returns the provider details for
        all network interfaces attached to the machines requested.

        entities : typing.Sequence[~Entity]
        Returns -> ProviderInterfaceInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineUndertaker',
                   request='GetMachineProviderInterfaceInfo',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMachineRemovals(self, entities=None):
        '''
        WatchMachineRemovals returns a watcher that will signal each time a
        machine is marked for removal.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MachineUndertaker',
                   request='WatchMachineRemovals',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MachinerFacade(Type):
    name = 'Machiner'
    version = 1
    schema =     {'definitions': {'APIHostPortsResult': {'additionalProperties': False,
                                            'properties': {'servers': {'items': {'items': {'$ref': '#/definitions/HostPort'},
                                                                                 'type': 'array'},
                                                                       'type': 'array'}},
                                            'required': ['servers'],
                                            'type': 'object'},
                     'Address': {'additionalProperties': False,
                                 'properties': {'scope': {'type': 'string'},
                                                'space-id': {'type': 'string'},
                                                'space-name': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'value': {'type': 'string'}},
                                 'required': ['value', 'type', 'scope'],
                                 'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'HostPort': {'additionalProperties': False,
                                  'properties': {'Address': {'$ref': '#/definitions/Address'},
                                                 'port': {'type': 'integer'},
                                                 'scope': {'type': 'string'},
                                                 'space-id': {'type': 'string'},
                                                 'space-name': {'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'value': {'type': 'string'}},
                                  'required': ['value',
                                               'type',
                                               'scope',
                                               'Address',
                                               'port'],
                                  'type': 'object'},
                     'JobsResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'jobs': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['jobs'],
                                    'type': 'object'},
                     'JobsResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/JobsResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'LifeResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'life': {'type': 'string'}},
                                    'required': ['life'],
                                    'type': 'object'},
                     'LifeResults': {'additionalProperties': False,
                                     'properties': {'results': {'items': {'$ref': '#/definitions/LifeResult'},
                                                                'type': 'array'}},
                                     'required': ['results'],
                                     'type': 'object'},
                     'MachineAddresses': {'additionalProperties': False,
                                          'properties': {'addresses': {'items': {'$ref': '#/definitions/Address'},
                                                                       'type': 'array'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag', 'addresses'],
                                          'type': 'object'},
                     'NetworkConfig': {'additionalProperties': False,
                                       'properties': {'address': {'type': 'string'},
                                                      'cidr': {'type': 'string'},
                                                      'config-type': {'type': 'string'},
                                                      'device-index': {'type': 'integer'},
                                                      'disabled': {'type': 'boolean'},
                                                      'dns-search-domains': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                      'dns-servers': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                      'gateway-address': {'type': 'string'},
                                                      'interface-name': {'type': 'string'},
                                                      'interface-type': {'type': 'string'},
                                                      'is-default-gateway': {'type': 'boolean'},
                                                      'mac-address': {'type': 'string'},
                                                      'mtu': {'type': 'integer'},
                                                      'no-auto-start': {'type': 'boolean'},
                                                      'parent-interface-name': {'type': 'string'},
                                                      'provider-address-id': {'type': 'string'},
                                                      'provider-id': {'type': 'string'},
                                                      'provider-network-id': {'type': 'string'},
                                                      'provider-space-id': {'type': 'string'},
                                                      'provider-subnet-id': {'type': 'string'},
                                                      'provider-vlan-id': {'type': 'string'},
                                                      'routes': {'items': {'$ref': '#/definitions/NetworkRoute'},
                                                                 'type': 'array'},
                                                      'vlan-tag': {'type': 'integer'}},
                                       'required': ['device-index',
                                                    'mac-address',
                                                    'cidr',
                                                    'mtu',
                                                    'provider-id',
                                                    'provider-network-id',
                                                    'provider-subnet-id',
                                                    'provider-space-id',
                                                    'provider-address-id',
                                                    'provider-vlan-id',
                                                    'vlan-tag',
                                                    'interface-name',
                                                    'parent-interface-name',
                                                    'interface-type',
                                                    'disabled'],
                                       'type': 'object'},
                     'NetworkRoute': {'additionalProperties': False,
                                      'properties': {'destination-cidr': {'type': 'string'},
                                                     'gateway-ip': {'type': 'string'},
                                                     'metric': {'type': 'integer'}},
                                      'required': ['destination-cidr',
                                                   'gateway-ip',
                                                   'metric'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetMachineNetworkConfig': {'additionalProperties': False,
                                                 'properties': {'config': {'items': {'$ref': '#/definitions/NetworkConfig'},
                                                                           'type': 'array'},
                                                                'tag': {'type': 'string'}},
                                                 'required': ['tag', 'config'],
                                                 'type': 'object'},
                     'SetMachinesAddresses': {'additionalProperties': False,
                                              'properties': {'machine-addresses': {'items': {'$ref': '#/definitions/MachineAddresses'},
                                                                                   'type': 'array'}},
                                              'required': ['machine-addresses'],
                                              'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringsResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'result': {'items': {'type': 'string'},
                                                                 'type': 'array'}},
                                       'type': 'object'}},
     'properties': {'APIAddresses': {'properties': {'Result': {'$ref': '#/definitions/StringsResult'}},
                                     'type': 'object'},
                    'APIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/APIHostPortsResult'}},
                                     'type': 'object'},
                    'EnsureDead': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'Jobs': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/JobsResults'}},
                             'type': 'object'},
                    'Life': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/LifeResults'}},
                             'type': 'object'},
                    'ModelUUID': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                  'type': 'object'},
                    'SetMachineAddresses': {'properties': {'Params': {'$ref': '#/definitions/SetMachinesAddresses'},
                                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                                            'type': 'object'},
                    'SetObservedNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/SetMachineNetworkConfig'}},
                                                 'type': 'object'},
                    'SetProviderNetworkConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                 'type': 'object'},
                    'SetStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'UpdateStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'Watch': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'},
                    'WatchAPIHostPorts': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                          'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsResult)
    async def APIAddresses(self):
        '''

        Returns -> StringsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='APIAddresses',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(APIHostPortsResult)
    async def APIHostPorts(self):
        '''

        Returns -> APIHostPortsResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='APIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnsureDead(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='EnsureDead',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(JobsResults)
    async def Jobs(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> JobsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='Jobs',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(LifeResults)
    async def Life(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> LifeResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='Life',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def ModelUUID(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='ModelUUID',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMachineAddresses(self, machine_addresses=None):
        '''
        machine_addresses : typing.Sequence[~MachineAddresses]
        Returns -> ErrorResults
        '''
        if machine_addresses is not None and not isinstance(machine_addresses, (bytes, str, list)):
            raise Exception("Expected machine_addresses to be a Sequence, received: {}".format(type(machine_addresses)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetMachineAddresses',
                   version=1,
                   params=_params)
        _params['machine-addresses'] = machine_addresses
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetObservedNetworkConfig(self, config=None, tag=None):
        '''
        config : typing.Sequence[~NetworkConfig]
        tag : str
        Returns -> None
        '''
        if config is not None and not isinstance(config, (bytes, str, list)):
            raise Exception("Expected config to be a Sequence, received: {}".format(type(config)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetObservedNetworkConfig',
                   version=1,
                   params=_params)
        _params['config'] = config
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetProviderNetworkConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetProviderNetworkConfig',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='SetStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='UpdateStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='Watch',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchAPIHostPorts(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Machiner',
                   request='WatchAPIHostPorts',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class MeterStatusFacade(Type):
    name = 'MeterStatus'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'MeterStatusResult': {'additionalProperties': False,
                                           'properties': {'code': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'info': {'type': 'string'}},
                                           'required': ['code', 'info'],
                                           'type': 'object'},
                     'MeterStatusResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/MeterStatusResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'GetMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/MeterStatusResults'}},
                                       'type': 'object'},
                    'WatchMeterStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                        'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                         'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MeterStatusResults)
    async def GetMeterStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> MeterStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MeterStatus',
                   request='GetMeterStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchMeterStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MeterStatus',
                   request='WatchMeterStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MetricsManagerFacade(Type):
    name = 'MetricsManager'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'}},
     'properties': {'AddJujuMachineMetrics': {'description': 'AddJujuMachineMetrics '
                                                             'adds a metric that '
                                                             'counts the number '
                                                             'of\n'
                                                             'non-container '
                                                             'machines in the '
                                                             'current model.',
                                              'type': 'object'},
                    'CleanupOldMetrics': {'description': 'CleanupOldMetrics '
                                                         'removes old metrics from '
                                                         'the collection.\n'
                                                         'The single arg params is '
                                                         'expected to contain and '
                                                         'model uuid.\n'
                                                         'Even though the call '
                                                         'will delete all metrics '
                                                         'across models\n'
                                                         'it serves to validate '
                                                         'that the connection has '
                                                         'access to at least one '
                                                         'model.',
                                          'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                         'Result': {'$ref': '#/definitions/ErrorResults'}},
                                          'type': 'object'},
                    'SendMetrics': {'description': 'SendMetrics will send any '
                                                   'unsent metrics onto the metric '
                                                   'collection service.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def AddJujuMachineMetrics(self):
        '''
        AddJujuMachineMetrics adds a metric that counts the number of
        non-container machines in the current model.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsManager',
                   request='AddJujuMachineMetrics',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def CleanupOldMetrics(self, entities=None):
        '''
        CleanupOldMetrics removes old metrics from the collection.
        The single arg params is expected to contain and model uuid.
        Even though the call will delete all metrics across models
        it serves to validate that the connection has access to at least one model.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsManager',
                   request='CleanupOldMetrics',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SendMetrics(self, entities=None):
        '''
        SendMetrics will send any unsent metrics onto the metric collection service.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MetricsManager',
                   request='SendMetrics',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MigrationFlagFacade(Type):
    name = 'MigrationFlag'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'PhaseResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'phase': {'type': 'string'}},
                                     'type': 'object'},
                     'PhaseResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/PhaseResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'}},
     'properties': {'Phase': {'description': 'Phase returns the current migration '
                                             'phase or an error for every\n'
                                             'supplied entity.',
                              'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/PhaseResults'}},
                              'type': 'object'},
                    'Watch': {'description': 'Watch returns an id for use with the '
                                             'NotifyWatcher facade, or an\n'
                                             'error, for every supplied entity.',
                              'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(PhaseResults)
    async def Phase(self, entities=None):
        '''
        Phase returns the current migration phase or an error for every
        supplied entity.

        entities : typing.Sequence[~Entity]
        Returns -> PhaseResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationFlag',
                   request='Phase',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def Watch(self, entities=None):
        '''
        Watch returns an id for use with the NotifyWatcher facade, or an
        error, for every supplied entity.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationFlag',
                   request='Watch',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class MigrationMasterFacade(Type):
    name = 'MigrationMaster'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'MasterMigrationStatus': {'additionalProperties': False,
                                               'properties': {'migration-id': {'type': 'string'},
                                                              'phase': {'type': 'string'},
                                                              'phase-changed-time': {'format': 'date-time',
                                                                                     'type': 'string'},
                                                              'spec': {'$ref': '#/definitions/MigrationSpec'}},
                                               'required': ['spec',
                                                            'migration-id',
                                                            'phase',
                                                            'phase-changed-time'],
                                               'type': 'object'},
                     'MigrationModelInfo': {'additionalProperties': False,
                                            'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                           'controller-agent-version': {'$ref': '#/definitions/Number'},
                                                           'name': {'type': 'string'},
                                                           'owner-tag': {'type': 'string'},
                                                           'uuid': {'type': 'string'}},
                                            'required': ['uuid',
                                                         'name',
                                                         'owner-tag',
                                                         'agent-version',
                                                         'controller-agent-version'],
                                            'type': 'object'},
                     'MigrationSpec': {'additionalProperties': False,
                                       'properties': {'model-tag': {'type': 'string'},
                                                      'target-info': {'$ref': '#/definitions/MigrationTargetInfo'}},
                                       'required': ['model-tag', 'target-info'],
                                       'type': 'object'},
                     'MigrationTargetInfo': {'additionalProperties': False,
                                             'properties': {'addrs': {'items': {'type': 'string'},
                                                                      'type': 'array'},
                                                            'auth-tag': {'type': 'string'},
                                                            'ca-cert': {'type': 'string'},
                                                            'controller-alias': {'type': 'string'},
                                                            'controller-tag': {'type': 'string'},
                                                            'macaroons': {'type': 'string'},
                                                            'password': {'type': 'string'}},
                                             'required': ['controller-tag',
                                                          'addrs',
                                                          'ca-cert',
                                                          'auth-tag'],
                                             'type': 'object'},
                     'MinionReports': {'additionalProperties': False,
                                       'properties': {'failed': {'items': {'type': 'string'},
                                                                 'type': 'array'},
                                                      'migration-id': {'type': 'string'},
                                                      'phase': {'type': 'string'},
                                                      'success-count': {'type': 'integer'},
                                                      'unknown-count': {'type': 'integer'},
                                                      'unknown-sample': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                       'required': ['migration-id',
                                                    'phase',
                                                    'success-count',
                                                    'unknown-count',
                                                    'unknown-sample',
                                                    'failed'],
                                       'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'SerializedModel': {'additionalProperties': False,
                                         'properties': {'bytes': {'items': {'type': 'integer'},
                                                                  'type': 'array'},
                                                        'charms': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                        'resources': {'items': {'$ref': '#/definitions/SerializedModelResource'},
                                                                      'type': 'array'},
                                                        'tools': {'items': {'$ref': '#/definitions/SerializedModelTools'},
                                                                  'type': 'array'}},
                                         'required': ['bytes',
                                                      'charms',
                                                      'tools',
                                                      'resources'],
                                         'type': 'object'},
                     'SerializedModelResource': {'additionalProperties': False,
                                                 'properties': {'application': {'type': 'string'},
                                                                'application-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'charmstore-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'name': {'type': 'string'},
                                                                'unit-revisions': {'patternProperties': {'.*': {'$ref': '#/definitions/SerializedModelResourceRevision'}},
                                                                                   'type': 'object'}},
                                                 'required': ['application',
                                                              'name',
                                                              'application-revision',
                                                              'charmstore-revision',
                                                              'unit-revisions'],
                                                 'type': 'object'},
                     'SerializedModelResourceRevision': {'additionalProperties': False,
                                                         'properties': {'description': {'type': 'string'},
                                                                        'fingerprint': {'type': 'string'},
                                                                        'origin': {'type': 'string'},
                                                                        'path': {'type': 'string'},
                                                                        'revision': {'type': 'integer'},
                                                                        'size': {'type': 'integer'},
                                                                        'timestamp': {'format': 'date-time',
                                                                                      'type': 'string'},
                                                                        'type': {'type': 'string'},
                                                                        'username': {'type': 'string'}},
                                                         'required': ['revision',
                                                                      'type',
                                                                      'path',
                                                                      'description',
                                                                      'origin',
                                                                      'fingerprint',
                                                                      'size',
                                                                      'timestamp'],
                                                         'type': 'object'},
                     'SerializedModelTools': {'additionalProperties': False,
                                              'properties': {'uri': {'type': 'string'},
                                                             'version': {'type': 'string'}},
                                              'required': ['version', 'uri'],
                                              'type': 'object'},
                     'SetMigrationPhaseArgs': {'additionalProperties': False,
                                               'properties': {'phase': {'type': 'string'}},
                                               'required': ['phase'],
                                               'type': 'object'},
                     'SetMigrationStatusMessageArgs': {'additionalProperties': False,
                                                       'properties': {'message': {'type': 'string'}},
                                                       'required': ['message'],
                                                       'type': 'object'}},
     'properties': {'Export': {'properties': {'Result': {'$ref': '#/definitions/SerializedModel'}},
                               'type': 'object'},
                    'MigrationStatus': {'properties': {'Result': {'$ref': '#/definitions/MasterMigrationStatus'}},
                                        'type': 'object'},
                    'MinionReports': {'properties': {'Result': {'$ref': '#/definitions/MinionReports'}},
                                      'type': 'object'},
                    'ModelInfo': {'properties': {'Result': {'$ref': '#/definitions/MigrationModelInfo'}},
                                  'type': 'object'},
                    'Prechecks': {'type': 'object'},
                    'Reap': {'type': 'object'},
                    'SetPhase': {'properties': {'Params': {'$ref': '#/definitions/SetMigrationPhaseArgs'}},
                                 'type': 'object'},
                    'SetStatusMessage': {'properties': {'Params': {'$ref': '#/definitions/SetMigrationStatusMessageArgs'}},
                                         'type': 'object'},
                    'Watch': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                              'type': 'object'},
                    'WatchMinionReports': {'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(SerializedModel)
    async def Export(self):
        '''

        Returns -> SerializedModel
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='Export',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MasterMigrationStatus)
    async def MigrationStatus(self):
        '''

        Returns -> MasterMigrationStatus
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='MigrationStatus',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MinionReports)
    async def MinionReports(self):
        '''

        Returns -> MinionReports
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='MinionReports',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(MigrationModelInfo)
    async def ModelInfo(self):
        '''

        Returns -> MigrationModelInfo
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='ModelInfo',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Prechecks(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='Prechecks',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Reap(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='Reap',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetPhase(self, phase=None):
        '''
        phase : str
        Returns -> None
        '''
        if phase is not None and not isinstance(phase, (bytes, str)):
            raise Exception("Expected phase to be a str, received: {}".format(type(phase)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='SetPhase',
                   version=1,
                   params=_params)
        _params['phase'] = phase
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetStatusMessage(self, message=None):
        '''
        message : str
        Returns -> None
        '''
        if message is not None and not isinstance(message, (bytes, str)):
            raise Exception("Expected message to be a str, received: {}".format(type(message)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='SetStatusMessage',
                   version=1,
                   params=_params)
        _params['message'] = message
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def Watch(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='Watch',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def WatchMinionReports(self):
        '''

        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMaster',
                   request='WatchMinionReports',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class MigrationMinionFacade(Type):
    name = 'MigrationMinion'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'MinionReport': {'additionalProperties': False,
                                      'properties': {'migration-id': {'type': 'string'},
                                                     'phase': {'type': 'string'},
                                                     'success': {'type': 'boolean'}},
                                      'required': ['migration-id',
                                                   'phase',
                                                   'success'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'}},
     'properties': {'Report': {'description': 'Report allows a migration minion to '
                                              'submit whether it succeeded or\n'
                                              'failed for a specific migration '
                                              'phase.',
                               'properties': {'Params': {'$ref': '#/definitions/MinionReport'}},
                               'type': 'object'},
                    'Watch': {'description': 'Watch starts watching for status '
                                             'updates for a migration attempt\n'
                                             'for the model. It will report when a '
                                             'migration starts and when its\n'
                                             'status changes (including when it '
                                             'finishes). An initial event will\n'
                                             'be fired if there has ever been a '
                                             'migration attempt for the model.\n'
                                             '\n'
                                             'The MigrationStatusWatcher facade '
                                             'must be used to receive events\n'
                                             'from the watcher.',
                              'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResult'}},
                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Report(self, migration_id=None, phase=None, success=None):
        '''
        Report allows a migration minion to submit whether it succeeded or
        failed for a specific migration phase.

        migration_id : str
        phase : str
        success : bool
        Returns -> None
        '''
        if migration_id is not None and not isinstance(migration_id, (bytes, str)):
            raise Exception("Expected migration_id to be a str, received: {}".format(type(migration_id)))

        if phase is not None and not isinstance(phase, (bytes, str)):
            raise Exception("Expected phase to be a str, received: {}".format(type(phase)))

        if success is not None and not isinstance(success, bool):
            raise Exception("Expected success to be a bool, received: {}".format(type(success)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMinion',
                   request='Report',
                   version=1,
                   params=_params)
        _params['migration-id'] = migration_id
        _params['phase'] = phase
        _params['success'] = success
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResult)
    async def Watch(self):
        '''
        Watch starts watching for status updates for a migration attempt
        for the model. It will report when a migration starts and when its
        status changes (including when it finishes). An initial event will
        be fired if there has ever been a migration attempt for the model.

        The MigrationStatusWatcher facade must be used to receive events
        from the watcher.


        Returns -> NotifyWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationMinion',
                   request='Watch',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class MigrationStatusWatcherFacade(Type):
    name = 'MigrationStatusWatcher'
    version = 1
    schema =     {'definitions': {'MigrationStatus': {'additionalProperties': False,
                                         'properties': {'attempt': {'type': 'integer'},
                                                        'migration-id': {'type': 'string'},
                                                        'phase': {'type': 'string'},
                                                        'source-api-addrs': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                        'source-ca-cert': {'type': 'string'},
                                                        'target-api-addrs': {'items': {'type': 'string'},
                                                                             'type': 'array'},
                                                        'target-ca-cert': {'type': 'string'}},
                                         'required': ['migration-id',
                                                      'attempt',
                                                      'phase',
                                                      'source-api-addrs',
                                                      'source-ca-cert',
                                                      'target-api-addrs',
                                                      'target-ca-cert'],
                                         'type': 'object'}},
     'properties': {'Next': {'description': 'Next returns when the status for a '
                                            'model migration for the\n'
                                            'associated model changes. The current '
                                            'details for the active\n'
                                            'migration are returned.',
                             'properties': {'Result': {'$ref': '#/definitions/MigrationStatus'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MigrationStatus)
    async def Next(self):
        '''
        Next returns when the status for a model migration for the
        associated model changes. The current details for the active
        migration are returned.


        Returns -> MigrationStatus
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationStatusWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationStatusWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class MigrationTargetFacade(Type):
    name = 'MigrationTarget'
    version = 1
    schema =     {'definitions': {'AdoptResourcesArgs': {'additionalProperties': False,
                                            'properties': {'model-tag': {'type': 'string'},
                                                           'source-controller-version': {'$ref': '#/definitions/Number'}},
                                            'required': ['model-tag',
                                                         'source-controller-version'],
                                            'type': 'object'},
                     'BytesResult': {'additionalProperties': False,
                                     'properties': {'result': {'items': {'type': 'integer'},
                                                               'type': 'array'}},
                                     'required': ['result'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'MigrationModelInfo': {'additionalProperties': False,
                                            'properties': {'agent-version': {'$ref': '#/definitions/Number'},
                                                           'controller-agent-version': {'$ref': '#/definitions/Number'},
                                                           'name': {'type': 'string'},
                                                           'owner-tag': {'type': 'string'},
                                                           'uuid': {'type': 'string'}},
                                            'required': ['uuid',
                                                         'name',
                                                         'owner-tag',
                                                         'agent-version',
                                                         'controller-agent-version'],
                                            'type': 'object'},
                     'ModelArgs': {'additionalProperties': False,
                                   'properties': {'model-tag': {'type': 'string'}},
                                   'required': ['model-tag'],
                                   'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'SerializedModel': {'additionalProperties': False,
                                         'properties': {'bytes': {'items': {'type': 'integer'},
                                                                  'type': 'array'},
                                                        'charms': {'items': {'type': 'string'},
                                                                   'type': 'array'},
                                                        'resources': {'items': {'$ref': '#/definitions/SerializedModelResource'},
                                                                      'type': 'array'},
                                                        'tools': {'items': {'$ref': '#/definitions/SerializedModelTools'},
                                                                  'type': 'array'}},
                                         'required': ['bytes',
                                                      'charms',
                                                      'tools',
                                                      'resources'],
                                         'type': 'object'},
                     'SerializedModelResource': {'additionalProperties': False,
                                                 'properties': {'application': {'type': 'string'},
                                                                'application-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'charmstore-revision': {'$ref': '#/definitions/SerializedModelResourceRevision'},
                                                                'name': {'type': 'string'},
                                                                'unit-revisions': {'patternProperties': {'.*': {'$ref': '#/definitions/SerializedModelResourceRevision'}},
                                                                                   'type': 'object'}},
                                                 'required': ['application',
                                                              'name',
                                                              'application-revision',
                                                              'charmstore-revision',
                                                              'unit-revisions'],
                                                 'type': 'object'},
                     'SerializedModelResourceRevision': {'additionalProperties': False,
                                                         'properties': {'description': {'type': 'string'},
                                                                        'fingerprint': {'type': 'string'},
                                                                        'origin': {'type': 'string'},
                                                                        'path': {'type': 'string'},
                                                                        'revision': {'type': 'integer'},
                                                                        'size': {'type': 'integer'},
                                                                        'timestamp': {'format': 'date-time',
                                                                                      'type': 'string'},
                                                                        'type': {'type': 'string'},
                                                                        'username': {'type': 'string'}},
                                                         'required': ['revision',
                                                                      'type',
                                                                      'path',
                                                                      'description',
                                                                      'origin',
                                                                      'fingerprint',
                                                                      'size',
                                                                      'timestamp'],
                                                         'type': 'object'},
                     'SerializedModelTools': {'additionalProperties': False,
                                              'properties': {'uri': {'type': 'string'},
                                                             'version': {'type': 'string'}},
                                              'required': ['version', 'uri'],
                                              'type': 'object'}},
     'properties': {'Abort': {'description': 'Abort removes the specified model '
                                             'from the database. It is an error '
                                             'to\n'
                                             'attempt to Abort a model that has a '
                                             'migration mode other than importing.',
                              'properties': {'Params': {'$ref': '#/definitions/ModelArgs'}},
                              'type': 'object'},
                    'Activate': {'description': 'Activate sets the migration mode '
                                                'of the model to "none", meaning '
                                                'it\n'
                                                'is ready for use. It is an error '
                                                'to attempt to Abort a model that\n'
                                                'has a migration mode other than '
                                                'importing.',
                                 'properties': {'Params': {'$ref': '#/definitions/ModelArgs'}},
                                 'type': 'object'},
                    'AdoptResources': {'description': 'AdoptResources asks the '
                                                      'cloud provider to update '
                                                      'the controller\n'
                                                      "tags for a model's "
                                                      'resources. This prevents '
                                                      'the resources from\n'
                                                      'being destroyed if the '
                                                      'source controller is '
                                                      'destroyed after the\n'
                                                      'model is migrated away.',
                                       'properties': {'Params': {'$ref': '#/definitions/AdoptResourcesArgs'}},
                                       'type': 'object'},
                    'CACert': {'description': 'CACert returns the certificate used '
                                              'to validate the state connection.',
                               'properties': {'Result': {'$ref': '#/definitions/BytesResult'}},
                               'type': 'object'},
                    'CheckMachines': {'description': 'CheckMachines compares the '
                                                     'machines in state with the '
                                                     'ones reported\n'
                                                     'by the provider and reports '
                                                     'any discrepancies.',
                                      'properties': {'Params': {'$ref': '#/definitions/ModelArgs'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'Import': {'description': 'Import takes a serialized Juju '
                                              'model, deserializes it, and\n'
                                              'recreates it in the receiving '
                                              'controller.',
                               'properties': {'Params': {'$ref': '#/definitions/SerializedModel'}},
                               'type': 'object'},
                    'LatestLogTime': {'description': 'LatestLogTime returns the '
                                                     'time of the most recent log '
                                                     'record\n'
                                                     'received by the logtransfer '
                                                     'endpoint. This can be used '
                                                     'as the start\n'
                                                     'point for streaming logs '
                                                     'from the source if the '
                                                     'transfer was\n'
                                                     'interrupted.\n'
                                                     '\n'
                                                     'For performance reasons, not '
                                                     'every time is tracked, so if '
                                                     'the\n'
                                                     'target controller died '
                                                     'during the transfer the '
                                                     'latest log time\n'
                                                     'might be up to 2 minutes '
                                                     'earlier. If the transfer was '
                                                     'interrupted\n'
                                                     'in some other way (like the '
                                                     'source controller going away '
                                                     'or a\n'
                                                     'network partition) the time '
                                                     'will be up-to-date.\n'
                                                     '\n'
                                                     'Log messages are assumed to '
                                                     'be sent in time order (which '
                                                     'is how\n'
                                                     'debug-log emits them). If '
                                                     "that isn't the case then "
                                                     'this mechanism\n'
                                                     "can't be used to avoid "
                                                     'duplicates when logtransfer '
                                                     'is restarted.\n'
                                                     '\n'
                                                     'Returns the zero time if no '
                                                     'logs have been transferred.',
                                      'properties': {'Params': {'$ref': '#/definitions/ModelArgs'},
                                                     'Result': {'format': 'date-time',
                                                                'type': 'string'}},
                                      'type': 'object'},
                    'Prechecks': {'description': 'Prechecks ensure that the target '
                                                 'controller is ready to accept a\n'
                                                 'model migration.',
                                  'properties': {'Params': {'$ref': '#/definitions/MigrationModelInfo'}},
                                  'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Abort(self, model_tag=None):
        '''
        Abort removes the specified model from the database. It is an error to
        attempt to Abort a model that has a migration mode other than importing.

        model_tag : str
        Returns -> None
        '''
        if model_tag is not None and not isinstance(model_tag, (bytes, str)):
            raise Exception("Expected model_tag to be a str, received: {}".format(type(model_tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget',
                   request='Abort',
                   version=1,
                   params=_params)
        _params['model-tag'] = model_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Activate(self, model_tag=None):
        '''
        Activate sets the migration mode of the model to "none", meaning it
        is ready for use. It is an error to attempt to Abort a model that
        has a migration mode other than importing.

        model_tag : str
        Returns -> None
        '''
        if model_tag is not None and not isinstance(model_tag, (bytes, str)):
            raise Exception("Expected model_tag to be a str, received: {}".format(type(model_tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget',
                   request='Activate',
                   version=1,
                   params=_params)
        _params['model-tag'] = model_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def AdoptResources(self, model_tag=None, source_controller_version=None):
        '''
        AdoptResources asks the cloud provider to update the controller
        tags for a model's resources. This prevents the resources from
        being destroyed if the source controller is destroyed after the
        model is migrated away.

        model_tag : str
        source_controller_version : Number
        Returns -> None
        '''
        if model_tag is not None and not isinstance(model_tag, (bytes, str)):
            raise Exception("Expected model_tag to be a str, received: {}".format(type(model_tag)))

        if source_controller_version is not None and not isinstance(source_controller_version, (dict, Number)):
            raise Exception("Expected source_controller_version to be a Number, received: {}".format(type(source_controller_version)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget',
                   request='AdoptResources',
                   version=1,
                   params=_params)
        _params['model-tag'] = model_tag
        _params['source-controller-version'] = source_controller_version
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BytesResult)
    async def CACert(self):
        '''
        CACert returns the certificate used to validate the state connection.


        Returns -> BytesResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget',
                   request='CACert',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def CheckMachines(self, model_tag=None):
        '''
        CheckMachines compares the machines in state with the ones reported
        by the provider and reports any discrepancies.

        model_tag : str
        Returns -> ErrorResults
        '''
        if model_tag is not None and not isinstance(model_tag, (bytes, str)):
            raise Exception("Expected model_tag to be a str, received: {}".format(type(model_tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget',
                   request='CheckMachines',
                   version=1,
                   params=_params)
        _params['model-tag'] = model_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Import(self, bytes_=None, charms=None, resources=None, tools=None):
        '''
        Import takes a serialized Juju model, deserializes it, and
        recreates it in the receiving controller.

        bytes_ : typing.Sequence[int]
        charms : typing.Sequence[str]
        resources : typing.Sequence[~SerializedModelResource]
        tools : typing.Sequence[~SerializedModelTools]
        Returns -> None
        '''
        if bytes_ is not None and not isinstance(bytes_, (bytes, str, list)):
            raise Exception("Expected bytes_ to be a Sequence, received: {}".format(type(bytes_)))

        if charms is not None and not isinstance(charms, (bytes, str, list)):
            raise Exception("Expected charms to be a Sequence, received: {}".format(type(charms)))

        if resources is not None and not isinstance(resources, (bytes, str, list)):
            raise Exception("Expected resources to be a Sequence, received: {}".format(type(resources)))

        if tools is not None and not isinstance(tools, (bytes, str, list)):
            raise Exception("Expected tools to be a Sequence, received: {}".format(type(tools)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget',
                   request='Import',
                   version=1,
                   params=_params)
        _params['bytes'] = bytes_
        _params['charms'] = charms
        _params['resources'] = resources
        _params['tools'] = tools
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(str)
    async def LatestLogTime(self, model_tag=None):
        '''
        LatestLogTime returns the time of the most recent log record
        received by the logtransfer endpoint. This can be used as the start
        point for streaming logs from the source if the transfer was
        interrupted.

        For performance reasons, not every time is tracked, so if the
        target controller died during the transfer the latest log time
        might be up to 2 minutes earlier. If the transfer was interrupted
        in some other way (like the source controller going away or a
        network partition) the time will be up-to-date.

        Log messages are assumed to be sent in time order (which is how
        debug-log emits them). If that isn't the case then this mechanism
        can't be used to avoid duplicates when logtransfer is restarted.

        Returns the zero time if no logs have been transferred.

        model_tag : str
        Returns -> str
        '''
        if model_tag is not None and not isinstance(model_tag, (bytes, str)):
            raise Exception("Expected model_tag to be a str, received: {}".format(type(model_tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget',
                   request='LatestLogTime',
                   version=1,
                   params=_params)
        _params['model-tag'] = model_tag
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Prechecks(self, agent_version=None, controller_agent_version=None, name=None, owner_tag=None, uuid=None):
        '''
        Prechecks ensure that the target controller is ready to accept a
        model migration.

        agent_version : Number
        controller_agent_version : Number
        name : str
        owner_tag : str
        uuid : str
        Returns -> None
        '''
        if agent_version is not None and not isinstance(agent_version, (dict, Number)):
            raise Exception("Expected agent_version to be a Number, received: {}".format(type(agent_version)))

        if controller_agent_version is not None and not isinstance(controller_agent_version, (dict, Number)):
            raise Exception("Expected controller_agent_version to be a Number, received: {}".format(type(controller_agent_version)))

        if name is not None and not isinstance(name, (bytes, str)):
            raise Exception("Expected name to be a str, received: {}".format(type(name)))

        if owner_tag is not None and not isinstance(owner_tag, (bytes, str)):
            raise Exception("Expected owner_tag to be a str, received: {}".format(type(owner_tag)))

        if uuid is not None and not isinstance(uuid, (bytes, str)):
            raise Exception("Expected uuid to be a str, received: {}".format(type(uuid)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='MigrationTarget',
                   request='Prechecks',
                   version=1,
                   params=_params)
        _params['agent-version'] = agent_version
        _params['controller-agent-version'] = controller_agent_version
        _params['name'] = name
        _params['owner-tag'] = owner_tag
        _params['uuid'] = uuid
        reply = await self.rpc(msg)
        return reply



class ModelConfigFacade(Type):
    name = 'ModelConfig'
    version = 1
    schema =     {'definitions': {'ConfigValue': {'additionalProperties': False,
                                     'properties': {'source': {'type': 'string'},
                                                    'value': {'additionalProperties': True,
                                                              'type': 'object'}},
                                     'required': ['value', 'source'],
                                     'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'ModelConfigResults': {'additionalProperties': False,
                                            'properties': {'config': {'patternProperties': {'.*': {'$ref': '#/definitions/ConfigValue'}},
                                                                      'type': 'object'}},
                                            'required': ['config'],
                                            'type': 'object'},
                     'ModelSLA': {'additionalProperties': False,
                                  'properties': {'ModelSLAInfo': {'$ref': '#/definitions/ModelSLAInfo'},
                                                 'creds': {'items': {'type': 'integer'},
                                                           'type': 'array'}},
                                  'required': ['ModelSLAInfo', 'creds'],
                                  'type': 'object'},
                     'ModelSLAInfo': {'additionalProperties': False,
                                      'properties': {'level': {'type': 'string'},
                                                     'owner': {'type': 'string'}},
                                      'required': ['level', 'owner'],
                                      'type': 'object'},
                     'ModelSet': {'additionalProperties': False,
                                  'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                         'type': 'object'}},
                                                            'type': 'object'}},
                                  'required': ['config'],
                                  'type': 'object'},
                     'ModelUnset': {'additionalProperties': False,
                                    'properties': {'keys': {'items': {'type': 'string'},
                                                            'type': 'array'}},
                                    'required': ['keys'],
                                    'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'}},
     'properties': {'ModelGet': {'properties': {'Result': {'$ref': '#/definitions/ModelConfigResults'}},
                                 'type': 'object'},
                    'ModelSet': {'properties': {'Params': {'$ref': '#/definitions/ModelSet'}},
                                 'type': 'object'},
                    'ModelUnset': {'properties': {'Params': {'$ref': '#/definitions/ModelUnset'}},
                                   'type': 'object'},
                    'SLALevel': {'properties': {'Result': {'$ref': '#/definitions/StringResult'}},
                                 'type': 'object'},
                    'SetSLALevel': {'properties': {'Params': {'$ref': '#/definitions/ModelSLA'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResults)
    async def ModelGet(self):
        '''

        Returns -> ModelConfigResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='ModelGet',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelSet(self, config=None):
        '''
        config : typing.Mapping[str, typing.Any]
        Returns -> None
        '''
        if config is not None and not isinstance(config, dict):
            raise Exception("Expected config to be a Mapping, received: {}".format(type(config)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='ModelSet',
                   version=1,
                   params=_params)
        _params['config'] = config
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ModelUnset(self, keys=None):
        '''
        keys : typing.Sequence[str]
        Returns -> None
        '''
        if keys is not None and not isinstance(keys, (bytes, str, list)):
            raise Exception("Expected keys to be a Sequence, received: {}".format(type(keys)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='ModelUnset',
                   version=1,
                   params=_params)
        _params['keys'] = keys
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResult)
    async def SLALevel(self):
        '''

        Returns -> StringResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='SLALevel',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def SetSLALevel(self, modelslainfo=None, creds=None):
        '''
        modelslainfo : ModelSLAInfo
        creds : typing.Sequence[int]
        Returns -> None
        '''
        if modelslainfo is not None and not isinstance(modelslainfo, (dict, ModelSLAInfo)):
            raise Exception("Expected modelslainfo to be a ModelSLAInfo, received: {}".format(type(modelslainfo)))

        if creds is not None and not isinstance(creds, (bytes, str, list)):
            raise Exception("Expected creds to be a Sequence, received: {}".format(type(creds)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelConfig',
                   request='SetSLALevel',
                   version=1,
                   params=_params)
        _params['ModelSLAInfo'] = modelslainfo
        _params['creds'] = creds
        reply = await self.rpc(msg)
        return reply



class ModelGenerationFacade(Type):
    name = 'ModelGeneration'
    version = 1
    schema =     {'definitions': {'BoolResult': {'additionalProperties': False,
                                    'properties': {'error': {'$ref': '#/definitions/Error'},
                                                   'result': {'type': 'boolean'}},
                                    'required': ['result'],
                                    'type': 'object'},
                     'BranchArg': {'additionalProperties': False,
                                   'properties': {'branch': {'type': 'string'}},
                                   'required': ['branch'],
                                   'type': 'object'},
                     'BranchInfoArgs': {'additionalProperties': False,
                                        'properties': {'branches': {'items': {'type': 'string'},
                                                                    'type': 'array'},
                                                       'detailed': {'type': 'boolean'}},
                                        'required': ['branches', 'detailed'],
                                        'type': 'object'},
                     'BranchTrackArg': {'additionalProperties': False,
                                        'properties': {'branch': {'type': 'string'},
                                                       'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                    'type': 'array'}},
                                        'required': ['branch', 'entities'],
                                        'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Generation': {'additionalProperties': False,
                                    'properties': {'applications': {'items': {'$ref': '#/definitions/GenerationApplication'},
                                                                    'type': 'array'},
                                                   'branch': {'type': 'string'},
                                                   'created': {'type': 'integer'},
                                                   'created-by': {'type': 'string'}},
                                    'required': ['branch',
                                                 'created',
                                                 'created-by',
                                                 'applications'],
                                    'type': 'object'},
                     'GenerationApplication': {'additionalProperties': False,
                                               'properties': {'application': {'type': 'string'},
                                                              'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                      'type': 'object'}},
                                                                         'type': 'object'},
                                                              'pending': {'items': {'type': 'string'},
                                                                          'type': 'array'},
                                                              'progress': {'type': 'string'},
                                                              'tracking': {'items': {'type': 'string'},
                                                                           'type': 'array'}},
                                               'required': ['application',
                                                            'progress',
                                                            'config'],
                                               'type': 'object'},
                     'GenerationResults': {'additionalProperties': False,
                                           'properties': {'error': {'$ref': '#/definitions/Error'},
                                                          'generations': {'items': {'$ref': '#/definitions/Generation'},
                                                                          'type': 'array'}},
                                           'required': ['generations'],
                                           'type': 'object'},
                     'IntResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'type': 'integer'}},
                                   'required': ['result'],
                                   'type': 'object'}},
     'properties': {'AddBranch': {'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                 'Result': {'$ref': '#/definitions/ErrorResult'}},
                                  'type': 'object'},
                    'BranchInfo': {'properties': {'Params': {'$ref': '#/definitions/BranchInfoArgs'},
                                                  'Result': {'$ref': '#/definitions/GenerationResults'}},
                                   'type': 'object'},
                    'CommitBranch': {'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                    'Result': {'$ref': '#/definitions/IntResult'}},
                                     'type': 'object'},
                    'HasActiveBranch': {'properties': {'Params': {'$ref': '#/definitions/BranchArg'},
                                                       'Result': {'$ref': '#/definitions/BoolResult'}},
                                        'type': 'object'},
                    'TrackBranch': {'properties': {'Params': {'$ref': '#/definitions/BranchTrackArg'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def AddBranch(self, branch=None):
        '''
        branch : str
        Returns -> ErrorResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='AddBranch',
                   version=1,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(GenerationResults)
    async def BranchInfo(self, branches=None, detailed=None):
        '''
        branches : typing.Sequence[str]
        detailed : bool
        Returns -> GenerationResults
        '''
        if branches is not None and not isinstance(branches, (bytes, str, list)):
            raise Exception("Expected branches to be a Sequence, received: {}".format(type(branches)))

        if detailed is not None and not isinstance(detailed, bool):
            raise Exception("Expected detailed to be a bool, received: {}".format(type(detailed)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='BranchInfo',
                   version=1,
                   params=_params)
        _params['branches'] = branches
        _params['detailed'] = detailed
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IntResult)
    async def CommitBranch(self, branch=None):
        '''
        branch : str
        Returns -> IntResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='CommitBranch',
                   version=1,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(BoolResult)
    async def HasActiveBranch(self, branch=None):
        '''
        branch : str
        Returns -> BoolResult
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='HasActiveBranch',
                   version=1,
                   params=_params)
        _params['branch'] = branch
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def TrackBranch(self, branch=None, entities=None):
        '''
        branch : str
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if branch is not None and not isinstance(branch, (bytes, str)):
            raise Exception("Expected branch to be a str, received: {}".format(type(branch)))

        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelGeneration',
                   request='TrackBranch',
                   version=1,
                   params=_params)
        _params['branch'] = branch
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class ModelSummaryWatcherFacade(Type):
    name = 'ModelSummaryWatcher'
    version = 1
    schema =     {'definitions': {'ModelAbstract': {'additionalProperties': False,
                                       'properties': {'admins': {'items': {'type': 'string'},
                                                                 'type': 'array'},
                                                      'annotations': {'patternProperties': {'.*': {'type': 'string'}},
                                                                      'type': 'object'},
                                                      'cloud': {'type': 'string'},
                                                      'controller': {'type': 'string'},
                                                      'credential': {'type': 'string'},
                                                      'messages': {'items': {'$ref': '#/definitions/ModelSummaryMessage'},
                                                                   'type': 'array'},
                                                      'name': {'type': 'string'},
                                                      'region': {'type': 'string'},
                                                      'removed': {'type': 'boolean'},
                                                      'size': {'$ref': '#/definitions/ModelSummarySize'},
                                                      'status': {'type': 'string'},
                                                      'uuid': {'type': 'string'}},
                                       'required': ['uuid'],
                                       'type': 'object'},
                     'ModelSummaryMessage': {'additionalProperties': False,
                                             'properties': {'agent': {'type': 'string'},
                                                            'message': {'type': 'string'}},
                                             'required': ['agent', 'message'],
                                             'type': 'object'},
                     'ModelSummarySize': {'additionalProperties': False,
                                          'properties': {'applications': {'type': 'integer'},
                                                         'containers': {'type': 'integer'},
                                                         'machines': {'type': 'integer'},
                                                         'relations': {'type': 'integer'},
                                                         'units': {'type': 'integer'}},
                                          'type': 'object'},
                     'SummaryWatcherNextResults': {'additionalProperties': False,
                                                   'properties': {'models': {'items': {'$ref': '#/definitions/ModelAbstract'},
                                                                             'type': 'array'}},
                                                   'required': ['models'],
                                                   'type': 'object'}},
     'properties': {'Next': {'description': 'Next will return the current state of '
                                            'everything on the first call\n'
                                            'and subsequent calls will return just '
                                            'those model summaries that have\n'
                                            'changed.',
                             'properties': {'Result': {'$ref': '#/definitions/SummaryWatcherNextResults'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(SummaryWatcherNextResults)
    async def Next(self):
        '''
        Next will return the current state of everything on the first call
        and subsequent calls will return just those model summaries that have
        changed.


        Returns -> SummaryWatcherNextResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelSummaryWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelSummaryWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ModelUpgraderFacade(Type):
    name = 'ModelUpgrader'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'IntResult': {'additionalProperties': False,
                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                  'result': {'type': 'integer'}},
                                   'required': ['result'],
                                   'type': 'object'},
                     'IntResults': {'additionalProperties': False,
                                    'properties': {'results': {'items': {'$ref': '#/definitions/IntResult'},
                                                               'type': 'array'}},
                                    'required': ['results'],
                                    'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetModelEnvironVersion': {'additionalProperties': False,
                                                'properties': {'model-tag': {'type': 'string'},
                                                               'version': {'type': 'integer'}},
                                                'required': ['model-tag',
                                                             'version'],
                                                'type': 'object'},
                     'SetModelEnvironVersions': {'additionalProperties': False,
                                                 'properties': {'models': {'items': {'$ref': '#/definitions/SetModelEnvironVersion'},
                                                                           'type': 'array'}},
                                                 'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'}},
     'properties': {'ModelEnvironVersion': {'description': 'ModelEnvironVersion '
                                                           'returns the current '
                                                           'version of the environ '
                                                           'corresponding\n'
                                                           'to each specified '
                                                           'model.',
                                            'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                           'Result': {'$ref': '#/definitions/IntResults'}},
                                            'type': 'object'},
                    'ModelTargetEnvironVersion': {'description': 'ModelTargetEnvironVersion '
                                                                 'returns the '
                                                                 'target version '
                                                                 'of the environ\n'
                                                                 'corresponding to '
                                                                 'each specified '
                                                                 'model. The '
                                                                 'target version '
                                                                 'is the\n'
                                                                 'environ '
                                                                 "provider's "
                                                                 'version.',
                                                  'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                 'Result': {'$ref': '#/definitions/IntResults'}},
                                                  'type': 'object'},
                    'SetModelEnvironVersion': {'description': 'SetModelEnvironVersion '
                                                              'sets the current '
                                                              'version of the '
                                                              'environ '
                                                              'corresponding\n'
                                                              'to each specified '
                                                              'model.',
                                               'properties': {'Params': {'$ref': '#/definitions/SetModelEnvironVersions'},
                                                              'Result': {'$ref': '#/definitions/ErrorResults'}},
                                               'type': 'object'},
                    'SetModelStatus': {'description': 'SetModelStatus sets the '
                                                      'status of each given model.',
                                       'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'WatchModelEnvironVersion': {'description': 'WatchModelEnvironVersion '
                                                                'watches for '
                                                                'changes to the '
                                                                'environ version '
                                                                'of the\n'
                                                                'specified '
                                                                'models.\n'
                                                                '\n'
                                                                'NOTE(axw) this is '
                                                                'currently '
                                                                'implemented in '
                                                                'terms of '
                                                                'state.Model.Watch, '
                                                                'so\n'
                                                                'the client may be '
                                                                'notified of '
                                                                'changes unrelated '
                                                                'to the environ '
                                                                'version.',
                                                 'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(IntResults)
    async def ModelEnvironVersion(self, entities=None):
        '''
        ModelEnvironVersion returns the current version of the environ corresponding
        to each specified model.

        entities : typing.Sequence[~Entity]
        Returns -> IntResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelUpgrader',
                   request='ModelEnvironVersion',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(IntResults)
    async def ModelTargetEnvironVersion(self, entities=None):
        '''
        ModelTargetEnvironVersion returns the target version of the environ
        corresponding to each specified model. The target version is the
        environ provider's version.

        entities : typing.Sequence[~Entity]
        Returns -> IntResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelUpgrader',
                   request='ModelTargetEnvironVersion',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModelEnvironVersion(self, models=None):
        '''
        SetModelEnvironVersion sets the current version of the environ corresponding
        to each specified model.

        models : typing.Sequence[~SetModelEnvironVersion]
        Returns -> ErrorResults
        '''
        if models is not None and not isinstance(models, (bytes, str, list)):
            raise Exception("Expected models to be a Sequence, received: {}".format(type(models)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelUpgrader',
                   request='SetModelEnvironVersion',
                   version=1,
                   params=_params)
        _params['models'] = models
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetModelStatus(self, entities=None):
        '''
        SetModelStatus sets the status of each given model.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelUpgrader',
                   request='SetModelStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchModelEnvironVersion(self, entities=None):
        '''
        WatchModelEnvironVersion watches for changes to the environ version of the
        specified models.

        NOTE(axw) this is currently implemented in terms of state.Model.Watch, so
        the client may be notified of changes unrelated to the environ version.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ModelUpgrader',
                   request='WatchModelEnvironVersion',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class NotifyWatcherFacade(Type):
    name = 'NotifyWatcher'
    version = 1
    schema =     {'properties': {'Next': {'description': 'Next returns when a change has '
                                            'occurred to the\n'
                                            'entity being watched since the most '
                                            'recent call to Next\n'
                                            'or the Watch call that created the '
                                            'NotifyWatcher.',
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Next(self):
        '''
        Next returns when a change has occurred to the
        entity being watched since the most recent call to Next
        or the Watch call that created the NotifyWatcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='NotifyWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='NotifyWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class OfferStatusWatcherFacade(Type):
    name = 'OfferStatusWatcher'
    version = 1
    schema =     {'definitions': {'EntityStatus': {'additionalProperties': False,
                                      'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                           'type': 'object'}},
                                                              'type': 'object'},
                                                     'info': {'type': 'string'},
                                                     'since': {'format': 'date-time',
                                                               'type': 'string'},
                                                     'status': {'type': 'string'}},
                                      'required': ['status', 'info', 'since'],
                                      'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'OfferStatusChange': {'additionalProperties': False,
                                           'properties': {'offer-name': {'type': 'string'},
                                                          'status': {'$ref': '#/definitions/EntityStatus'}},
                                           'required': ['offer-name', 'status'],
                                           'type': 'object'},
                     'OfferStatusWatchResult': {'additionalProperties': False,
                                                'properties': {'changes': {'items': {'$ref': '#/definitions/OfferStatusChange'},
                                                                           'type': 'array'},
                                                               'error': {'$ref': '#/definitions/Error'},
                                                               'watcher-id': {'type': 'string'}},
                                                'required': ['watcher-id',
                                                             'changes'],
                                                'type': 'object'}},
     'properties': {'Next': {'description': 'Next returns when a change has '
                                            'occurred to an entity of the\n'
                                            'collection being watched since the '
                                            'most recent call to Next\n'
                                            'or the Watch call that created the '
                                            'srvOfferStatusWatcher.',
                             'properties': {'Result': {'$ref': '#/definitions/OfferStatusWatchResult'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(OfferStatusWatchResult)
    async def Next(self):
        '''
        Next returns when a change has occurred to an entity of the
        collection being watched since the most recent call to Next
        or the Watch call that created the srvOfferStatusWatcher.


        Returns -> OfferStatusWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='OfferStatusWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='OfferStatusWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class PayloadsFacade(Type):
    name = 'Payloads'
    version = 1
    schema =     {'definitions': {'Payload': {'additionalProperties': False,
                                 'properties': {'class': {'type': 'string'},
                                                'id': {'type': 'string'},
                                                'labels': {'items': {'type': 'string'},
                                                           'type': 'array'},
                                                'machine': {'type': 'string'},
                                                'status': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'unit': {'type': 'string'}},
                                 'required': ['class',
                                              'type',
                                              'id',
                                              'status',
                                              'labels',
                                              'unit',
                                              'machine'],
                                 'type': 'object'},
                     'PayloadListArgs': {'additionalProperties': False,
                                         'properties': {'patterns': {'items': {'type': 'string'},
                                                                     'type': 'array'}},
                                         'required': ['patterns'],
                                         'type': 'object'},
                     'PayloadListResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/Payload'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'List': {'description': 'List builds the list of payloads '
                                            'being tracked for\n'
                                            'the given unit and IDs. If no IDs are '
                                            'provided then all tracked\n'
                                            'payloads for the unit are returned.',
                             'properties': {'Params': {'$ref': '#/definitions/PayloadListArgs'},
                                            'Result': {'$ref': '#/definitions/PayloadListResults'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(PayloadListResults)
    async def List(self, patterns=None):
        '''
        List builds the list of payloads being tracked for
        the given unit and IDs. If no IDs are provided then all tracked
        payloads for the unit are returned.

        patterns : typing.Sequence[str]
        Returns -> PayloadListResults
        '''
        if patterns is not None and not isinstance(patterns, (bytes, str, list)):
            raise Exception("Expected patterns to be a Sequence, received: {}".format(type(patterns)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Payloads',
                   request='List',
                   version=1,
                   params=_params)
        _params['patterns'] = patterns
        reply = await self.rpc(msg)
        return reply



class PayloadsHookContextFacade(Type):
    name = 'PayloadsHookContext'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'LookUpPayloadArg': {'additionalProperties': False,
                                          'properties': {'id': {'type': 'string'},
                                                         'name': {'type': 'string'}},
                                          'required': ['name', 'id'],
                                          'type': 'object'},
                     'LookUpPayloadArgs': {'additionalProperties': False,
                                           'properties': {'args': {'items': {'$ref': '#/definitions/LookUpPayloadArg'},
                                                                   'type': 'array'}},
                                           'required': ['args'],
                                           'type': 'object'},
                     'Payload': {'additionalProperties': False,
                                 'properties': {'class': {'type': 'string'},
                                                'id': {'type': 'string'},
                                                'labels': {'items': {'type': 'string'},
                                                           'type': 'array'},
                                                'machine': {'type': 'string'},
                                                'status': {'type': 'string'},
                                                'type': {'type': 'string'},
                                                'unit': {'type': 'string'}},
                                 'required': ['class',
                                              'type',
                                              'id',
                                              'status',
                                              'labels',
                                              'unit',
                                              'machine'],
                                 'type': 'object'},
                     'PayloadResult': {'additionalProperties': False,
                                       'properties': {'Entity': {'$ref': '#/definitions/Entity'},
                                                      'error': {'$ref': '#/definitions/Error'},
                                                      'not-found': {'type': 'boolean'},
                                                      'payload': {'$ref': '#/definitions/Payload'},
                                                      'tag': {'type': 'string'}},
                                       'required': ['tag',
                                                    'Entity',
                                                    'payload',
                                                    'not-found'],
                                       'type': 'object'},
                     'PayloadResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/PayloadResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'SetPayloadStatusArg': {'additionalProperties': False,
                                             'properties': {'Entity': {'$ref': '#/definitions/Entity'},
                                                            'status': {'type': 'string'},
                                                            'tag': {'type': 'string'}},
                                             'required': ['tag',
                                                          'Entity',
                                                          'status'],
                                             'type': 'object'},
                     'SetPayloadStatusArgs': {'additionalProperties': False,
                                              'properties': {'args': {'items': {'$ref': '#/definitions/SetPayloadStatusArg'},
                                                                      'type': 'array'}},
                                              'required': ['args'],
                                              'type': 'object'},
                     'TrackPayloadArgs': {'additionalProperties': False,
                                          'properties': {'payloads': {'items': {'$ref': '#/definitions/Payload'},
                                                                      'type': 'array'}},
                                          'required': ['payloads'],
                                          'type': 'object'}},
     'properties': {'List': {'description': 'List builds the list of payload being '
                                            'tracked for\n'
                                            'the given unit and IDs. If no IDs are '
                                            'provided then all tracked\n'
                                            'payloads for the unit are returned.',
                             'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/PayloadResults'}},
                             'type': 'object'},
                    'LookUp': {'description': 'LookUp identifies the payload with '
                                              'the provided name and raw ID.',
                               'properties': {'Params': {'$ref': '#/definitions/LookUpPayloadArgs'},
                                              'Result': {'$ref': '#/definitions/PayloadResults'}},
                               'type': 'object'},
                    'SetStatus': {'description': 'SetStatus sets the raw status of '
                                                 'a payload.',
                                  'properties': {'Params': {'$ref': '#/definitions/SetPayloadStatusArgs'},
                                                 'Result': {'$ref': '#/definitions/PayloadResults'}},
                                  'type': 'object'},
                    'Track': {'description': 'Track stores a payload to be tracked '
                                             'in state.',
                              'properties': {'Params': {'$ref': '#/definitions/TrackPayloadArgs'},
                                             'Result': {'$ref': '#/definitions/PayloadResults'}},
                              'type': 'object'},
                    'Untrack': {'description': 'Untrack marks the identified '
                                               'payload as no longer being '
                                               'tracked.',
                                'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                               'Result': {'$ref': '#/definitions/PayloadResults'}},
                                'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(PayloadResults)
    async def List(self, entities=None):
        '''
        List builds the list of payload being tracked for
        the given unit and IDs. If no IDs are provided then all tracked
        payloads for the unit are returned.

        entities : typing.Sequence[~Entity]
        Returns -> PayloadResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext',
                   request='List',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PayloadResults)
    async def LookUp(self, args=None):
        '''
        LookUp identifies the payload with the provided name and raw ID.

        args : typing.Sequence[~LookUpPayloadArg]
        Returns -> PayloadResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext',
                   request='LookUp',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PayloadResults)
    async def SetStatus(self, args=None):
        '''
        SetStatus sets the raw status of a payload.

        args : typing.Sequence[~SetPayloadStatusArg]
        Returns -> PayloadResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext',
                   request='SetStatus',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PayloadResults)
    async def Track(self, payloads=None):
        '''
        Track stores a payload to be tracked in state.

        payloads : typing.Sequence[~Payload]
        Returns -> PayloadResults
        '''
        if payloads is not None and not isinstance(payloads, (bytes, str, list)):
            raise Exception("Expected payloads to be a Sequence, received: {}".format(type(payloads)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext',
                   request='Track',
                   version=1,
                   params=_params)
        _params['payloads'] = payloads
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PayloadResults)
    async def Untrack(self, entities=None):
        '''
        Untrack marks the identified payload as no longer being tracked.

        entities : typing.Sequence[~Entity]
        Returns -> PayloadResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='PayloadsHookContext',
                   request='Untrack',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class PingerFacade(Type):
    name = 'Pinger'
    version = 1
    schema =     {'properties': {'Ping': {'type': 'object'}, 'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(None)
    async def Ping(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Pinger',
                   request='Ping',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Pinger',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ProxyUpdaterFacade(Type):
    name = 'ProxyUpdater'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'ProxyConfig': {'additionalProperties': False,
                                     'properties': {'ftp': {'type': 'string'},
                                                    'http': {'type': 'string'},
                                                    'https': {'type': 'string'},
                                                    'no-proxy': {'type': 'string'}},
                                     'required': ['http',
                                                  'https',
                                                  'ftp',
                                                  'no-proxy'],
                                     'type': 'object'},
                     'ProxyConfigResult': {'additionalProperties': False,
                                           'properties': {'apt-proxy-settings': {'$ref': '#/definitions/ProxyConfig'},
                                                          'error': {'$ref': '#/definitions/Error'},
                                                          'proxy-settings': {'$ref': '#/definitions/ProxyConfig'}},
                                           'required': ['proxy-settings',
                                                        'apt-proxy-settings'],
                                           'type': 'object'},
                     'ProxyConfigResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/ProxyConfigResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'}},
     'properties': {'ProxyConfig': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ProxyConfigResults'}},
                                    'type': 'object'},
                    'WatchForProxyConfigAndAPIHostPortChanges': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                                'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ProxyConfigResults)
    async def ProxyConfig(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ProxyConfigResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ProxyUpdater',
                   request='ProxyConfig',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchForProxyConfigAndAPIHostPortChanges(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ProxyUpdater',
                   request='WatchForProxyConfigAndAPIHostPortChanges',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class RelationStatusWatcherFacade(Type):
    name = 'RelationStatusWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'RelationLifeSuspendedStatusChange': {'additionalProperties': False,
                                                           'properties': {'key': {'type': 'string'},
                                                                          'life': {'type': 'string'},
                                                                          'suspended': {'type': 'boolean'},
                                                                          'suspended-reason': {'type': 'string'}},
                                                           'required': ['key',
                                                                        'life',
                                                                        'suspended',
                                                                        'suspended-reason'],
                                                           'type': 'object'},
                     'RelationLifeSuspendedStatusWatchResult': {'additionalProperties': False,
                                                                'properties': {'changes': {'items': {'$ref': '#/definitions/RelationLifeSuspendedStatusChange'},
                                                                                           'type': 'array'},
                                                                               'error': {'$ref': '#/definitions/Error'},
                                                                               'watcher-id': {'type': 'string'}},
                                                                'required': ['watcher-id',
                                                                             'changes'],
                                                                'type': 'object'}},
     'properties': {'Next': {'description': 'Next returns when a change has '
                                            'occurred to an entity of the\n'
                                            'collection being watched since the '
                                            'most recent call to Next\n'
                                            'or the Watch call that created the '
                                            'srvRelationStatusWatcher.',
                             'properties': {'Result': {'$ref': '#/definitions/RelationLifeSuspendedStatusWatchResult'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RelationLifeSuspendedStatusWatchResult)
    async def Next(self):
        '''
        Next returns when a change has occurred to an entity of the
        collection being watched since the most recent call to Next
        or the Watch call that created the srvRelationStatusWatcher.


        Returns -> RelationLifeSuspendedStatusWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RelationStatusWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RelationStatusWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class RelationUnitsWatcherFacade(Type):
    name = 'RelationUnitsWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'RelationUnitsChange': {'additionalProperties': False,
                                             'properties': {'app-changed': {'patternProperties': {'.*': {'type': 'integer'}},
                                                                            'type': 'object'},
                                                            'changed': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitSettings'}},
                                                                        'type': 'object'},
                                                            'departed': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                             'required': ['changed'],
                                             'type': 'object'},
                     'RelationUnitsWatchResult': {'additionalProperties': False,
                                                  'properties': {'changes': {'$ref': '#/definitions/RelationUnitsChange'},
                                                                 'error': {'$ref': '#/definitions/Error'},
                                                                 'watcher-id': {'type': 'string'}},
                                                  'required': ['watcher-id',
                                                               'changes'],
                                                  'type': 'object'},
                     'UnitSettings': {'additionalProperties': False,
                                      'properties': {'version': {'type': 'integer'}},
                                      'required': ['version'],
                                      'type': 'object'}},
     'properties': {'Next': {'description': 'Next returns when a change has '
                                            'occurred to an entity of the\n'
                                            'collection being watched since the '
                                            'most recent call to Next\n'
                                            'or the Watch call that created the '
                                            'srvRelationUnitsWatcher.',
                             'properties': {'Result': {'$ref': '#/definitions/RelationUnitsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RelationUnitsWatchResult)
    async def Next(self):
        '''
        Next returns when a change has occurred to an entity of the
        collection being watched since the most recent call to Next
        or the Watch call that created the srvRelationUnitsWatcher.


        Returns -> RelationUnitsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RelationUnitsWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RelationUnitsWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class RemoteApplicationWatcherFacade(Type):
    name = 'RemoteApplicationWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RemoteApplicationChange': {'additionalProperties': False,
                                                 'properties': {'application-tag': {'type': 'string'},
                                                                'life': {'type': 'string'},
                                                                'relations': {'$ref': '#/definitions/RemoteRelationsChange'}},
                                                 'required': ['application-tag',
                                                              'life',
                                                              'relations'],
                                                 'type': 'object'},
                     'RemoteApplicationWatchResult': {'additionalProperties': False,
                                                      'properties': {'change': {'$ref': '#/definitions/RemoteApplicationChange'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'id': {'type': 'string'}},
                                                      'required': ['id'],
                                                      'type': 'object'},
                     'RemoteEntityId': {'additionalProperties': False,
                                        'properties': {'model-uuid': {'type': 'string'},
                                                       'token': {'type': 'string'}},
                                        'required': ['model-uuid', 'token'],
                                        'type': 'object'},
                     'RemoteRelationChange': {'additionalProperties': False,
                                              'properties': {'changed-units': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteRelationUnitChange'}},
                                                                               'type': 'object'},
                                                             'departed-units': {'items': {'type': 'string'},
                                                                                'type': 'array'},
                                                             'id': {'type': 'integer'},
                                                             'life': {'type': 'string'}},
                                              'required': ['id', 'life'],
                                              'type': 'object'},
                     'RemoteRelationUnitChange': {'additionalProperties': False,
                                                  'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                                 'unit-id': {'$ref': '#/definitions/RemoteEntityId'}},
                                                  'required': ['unit-id'],
                                                  'type': 'object'},
                     'RemoteRelationsChange': {'additionalProperties': False,
                                               'properties': {'changed': {'items': {'$ref': '#/definitions/RemoteRelationChange'},
                                                                          'type': 'array'},
                                                              'initial': {'type': 'boolean'},
                                                              'removed': {'items': {'type': 'integer'},
                                                                          'type': 'array'}},
                                               'required': ['initial'],
                                               'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/RemoteApplicationWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RemoteApplicationWatchResult)
    async def Next(self):
        '''

        Returns -> RemoteApplicationWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteApplicationWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteApplicationWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class RemoteRelationWatcherFacade(Type):
    name = 'RemoteRelationWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RemoteRelationChangeEvent': {'additionalProperties': False,
                                                   'properties': {'application-settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                                        'type': 'object'}},
                                                                                           'type': 'object'},
                                                                  'application-token': {'type': 'string'},
                                                                  'bakery-version': {'type': 'integer'},
                                                                  'changed-units': {'items': {'$ref': '#/definitions/RemoteRelationUnitChange'},
                                                                                    'type': 'array'},
                                                                  'departed-units': {'items': {'type': 'integer'},
                                                                                     'type': 'array'},
                                                                  'force-cleanup': {'type': 'boolean'},
                                                                  'life': {'type': 'string'},
                                                                  'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                                'type': 'array'},
                                                                  'relation-token': {'type': 'string'},
                                                                  'suspended': {'type': 'boolean'},
                                                                  'suspended-reason': {'type': 'string'},
                                                                  'unit-count': {'type': 'integer'}},
                                                   'required': ['relation-token',
                                                                'application-token',
                                                                'life'],
                                                   'type': 'object'},
                     'RemoteRelationUnitChange': {'additionalProperties': False,
                                                  'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                                 'unit-id': {'type': 'integer'}},
                                                  'required': ['unit-id'],
                                                  'type': 'object'},
                     'RemoteRelationWatchResult': {'additionalProperties': False,
                                                   'properties': {'changes': {'$ref': '#/definitions/RemoteRelationChangeEvent'},
                                                                  'error': {'$ref': '#/definitions/Error'},
                                                                  'watcher-id': {'type': 'string'}},
                                                   'required': ['watcher-id',
                                                                'changes'],
                                                   'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/RemoteRelationWatchResult'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RemoteRelationWatchResult)
    async def Next(self):
        '''

        Returns -> RemoteRelationWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelationWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelationWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class RemoteRelationsFacade(Type):
    name = 'RemoteRelations'
    version = 1
    schema =     {'definitions': {'ControllerAPIInfoResult': {'additionalProperties': False,
                                                 'properties': {'addresses': {'items': {'type': 'string'},
                                                                              'type': 'array'},
                                                                'cacert': {'type': 'string'},
                                                                'error': {'$ref': '#/definitions/Error'}},
                                                 'required': ['addresses',
                                                              'cacert'],
                                                 'type': 'object'},
                     'ControllerAPIInfoResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/ControllerAPIInfoResult'},
                                                                             'type': 'array'}},
                                                  'required': ['results'],
                                                  'type': 'object'},
                     'ControllerConfigResult': {'additionalProperties': False,
                                                'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                       'type': 'object'}},
                                                                          'type': 'object'}},
                                                'required': ['config'],
                                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityMacaroonArg': {'additionalProperties': False,
                                           'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                          'tag': {'type': 'string'}},
                                           'required': ['macaroon', 'tag'],
                                           'type': 'object'},
                     'EntityMacaroonArgs': {'additionalProperties': False,
                                            'properties': {'Args': {'items': {'$ref': '#/definitions/EntityMacaroonArg'},
                                                                    'type': 'array'}},
                                            'required': ['Args'],
                                            'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'GetTokenArg': {'additionalProperties': False,
                                     'properties': {'tag': {'type': 'string'}},
                                     'required': ['tag'],
                                     'type': 'object'},
                     'GetTokenArgs': {'additionalProperties': False,
                                      'properties': {'Args': {'items': {'$ref': '#/definitions/GetTokenArg'},
                                                              'type': 'array'}},
                                      'required': ['Args'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RelationUnit': {'additionalProperties': False,
                                      'properties': {'relation': {'type': 'string'},
                                                     'unit': {'type': 'string'}},
                                      'required': ['relation', 'unit'],
                                      'type': 'object'},
                     'RelationUnits': {'additionalProperties': False,
                                       'properties': {'relation-units': {'items': {'$ref': '#/definitions/RelationUnit'},
                                                                         'type': 'array'}},
                                       'required': ['relation-units'],
                                       'type': 'object'},
                     'RelationUnitsChange': {'additionalProperties': False,
                                             'properties': {'app-changed': {'patternProperties': {'.*': {'type': 'integer'}},
                                                                            'type': 'object'},
                                                            'changed': {'patternProperties': {'.*': {'$ref': '#/definitions/UnitSettings'}},
                                                                        'type': 'object'},
                                                            'departed': {'items': {'type': 'string'},
                                                                         'type': 'array'}},
                                             'required': ['changed'],
                                             'type': 'object'},
                     'RelationUnitsWatchResult': {'additionalProperties': False,
                                                  'properties': {'changes': {'$ref': '#/definitions/RelationUnitsChange'},
                                                                 'error': {'$ref': '#/definitions/Error'},
                                                                 'watcher-id': {'type': 'string'}},
                                                  'required': ['watcher-id',
                                                               'changes'],
                                                  'type': 'object'},
                     'RelationUnitsWatchResults': {'additionalProperties': False,
                                                   'properties': {'results': {'items': {'$ref': '#/definitions/RelationUnitsWatchResult'},
                                                                              'type': 'array'}},
                                                   'required': ['results'],
                                                   'type': 'object'},
                     'RemoteApplication': {'additionalProperties': False,
                                           'properties': {'is-consumer-proxy': {'type': 'boolean'},
                                                          'life': {'type': 'string'},
                                                          'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                          'model-uuid': {'type': 'string'},
                                                          'name': {'type': 'string'},
                                                          'offer-uuid': {'type': 'string'},
                                                          'status': {'type': 'string'}},
                                           'required': ['name',
                                                        'offer-uuid',
                                                        'model-uuid',
                                                        'is-consumer-proxy'],
                                           'type': 'object'},
                     'RemoteApplicationResult': {'additionalProperties': False,
                                                 'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                'result': {'$ref': '#/definitions/RemoteApplication'}},
                                                 'type': 'object'},
                     'RemoteApplicationResults': {'additionalProperties': False,
                                                  'properties': {'results': {'items': {'$ref': '#/definitions/RemoteApplicationResult'},
                                                                             'type': 'array'}},
                                                  'type': 'object'},
                     'RemoteEndpoint': {'additionalProperties': False,
                                        'properties': {'interface': {'type': 'string'},
                                                       'limit': {'type': 'integer'},
                                                       'name': {'type': 'string'},
                                                       'role': {'type': 'string'}},
                                        'required': ['name',
                                                     'role',
                                                     'interface',
                                                     'limit'],
                                        'type': 'object'},
                     'RemoteEntityTokenArg': {'additionalProperties': False,
                                              'properties': {'tag': {'type': 'string'},
                                                             'token': {'type': 'string'}},
                                              'required': ['tag'],
                                              'type': 'object'},
                     'RemoteEntityTokenArgs': {'additionalProperties': False,
                                               'properties': {'Args': {'items': {'$ref': '#/definitions/RemoteEntityTokenArg'},
                                                                       'type': 'array'}},
                                               'required': ['Args'],
                                               'type': 'object'},
                     'RemoteRelation': {'additionalProperties': False,
                                        'properties': {'application-name': {'type': 'string'},
                                                       'endpoint': {'$ref': '#/definitions/RemoteEndpoint'},
                                                       'id': {'type': 'integer'},
                                                       'key': {'type': 'string'},
                                                       'life': {'type': 'string'},
                                                       'remote-application-name': {'type': 'string'},
                                                       'remote-endpoint-name': {'type': 'string'},
                                                       'source-model-uuid': {'type': 'string'},
                                                       'suspended': {'type': 'boolean'}},
                                        'required': ['life',
                                                     'suspended',
                                                     'id',
                                                     'key',
                                                     'application-name',
                                                     'endpoint',
                                                     'remote-application-name',
                                                     'remote-endpoint-name',
                                                     'source-model-uuid'],
                                        'type': 'object'},
                     'RemoteRelationChangeEvent': {'additionalProperties': False,
                                                   'properties': {'application-token': {'type': 'string'},
                                                                  'changed-units': {'items': {'$ref': '#/definitions/RemoteRelationUnitChange'},
                                                                                    'type': 'array'},
                                                                  'departed-units': {'items': {'type': 'integer'},
                                                                                     'type': 'array'},
                                                                  'force-cleanup': {'type': 'boolean'},
                                                                  'life': {'type': 'string'},
                                                                  'macaroons': {'items': {'$ref': '#/definitions/Macaroon'},
                                                                                'type': 'array'},
                                                                  'relation-token': {'type': 'string'},
                                                                  'suspended': {'type': 'boolean'},
                                                                  'suspended-reason': {'type': 'string'}},
                                                   'required': ['relation-token',
                                                                'application-token',
                                                                'life'],
                                                   'type': 'object'},
                     'RemoteRelationResult': {'additionalProperties': False,
                                              'properties': {'error': {'$ref': '#/definitions/Error'},
                                                             'result': {'$ref': '#/definitions/RemoteRelation'}},
                                              'type': 'object'},
                     'RemoteRelationResults': {'additionalProperties': False,
                                               'properties': {'results': {'items': {'$ref': '#/definitions/RemoteRelationResult'},
                                                                          'type': 'array'}},
                                               'required': ['results'],
                                               'type': 'object'},
                     'RemoteRelationUnitChange': {'additionalProperties': False,
                                                  'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                                 'unit-id': {'type': 'integer'}},
                                                  'required': ['unit-id'],
                                                  'type': 'object'},
                     'RemoteRelationsChanges': {'additionalProperties': False,
                                                'properties': {'changes': {'items': {'$ref': '#/definitions/RemoteRelationChangeEvent'},
                                                                           'type': 'array'}},
                                                'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'SettingsResult': {'additionalProperties': False,
                                        'properties': {'error': {'$ref': '#/definitions/Error'},
                                                       'settings': {'patternProperties': {'.*': {'type': 'string'}},
                                                                    'type': 'object'}},
                                        'required': ['settings'],
                                        'type': 'object'},
                     'SettingsResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/SettingsResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'},
                     'StringsWatchResults': {'additionalProperties': False,
                                             'properties': {'results': {'items': {'$ref': '#/definitions/StringsWatchResult'},
                                                                        'type': 'array'}},
                                             'required': ['results'],
                                             'type': 'object'},
                     'TokenResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'},
                                                    'token': {'type': 'string'}},
                                     'type': 'object'},
                     'TokenResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/TokenResult'},
                                                                 'type': 'array'}},
                                      'type': 'object'},
                     'UnitSettings': {'additionalProperties': False,
                                      'properties': {'version': {'type': 'integer'}},
                                      'required': ['version'],
                                      'type': 'object'}},
     'properties': {'ConsumeRemoteRelationChanges': {'properties': {'Params': {'$ref': '#/definitions/RemoteRelationsChanges'},
                                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                     'type': 'object'},
                    'ControllerAPIInfoForModels': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                  'Result': {'$ref': '#/definitions/ControllerAPIInfoResults'}},
                                                   'type': 'object'},
                    'ControllerConfig': {'properties': {'Result': {'$ref': '#/definitions/ControllerConfigResult'}},
                                         'type': 'object'},
                    'ExportEntities': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/TokenResults'}},
                                       'type': 'object'},
                    'GetTokens': {'properties': {'Params': {'$ref': '#/definitions/GetTokenArgs'},
                                                 'Result': {'$ref': '#/definitions/StringResults'}},
                                  'type': 'object'},
                    'ImportRemoteEntities': {'properties': {'Params': {'$ref': '#/definitions/RemoteEntityTokenArgs'},
                                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                                             'type': 'object'},
                    'RelationUnitSettings': {'properties': {'Params': {'$ref': '#/definitions/RelationUnits'},
                                                            'Result': {'$ref': '#/definitions/SettingsResults'}},
                                             'type': 'object'},
                    'Relations': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                 'Result': {'$ref': '#/definitions/RemoteRelationResults'}},
                                  'type': 'object'},
                    'RemoteApplications': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/RemoteApplicationResults'}},
                                           'type': 'object'},
                    'SaveMacaroons': {'properties': {'Params': {'$ref': '#/definitions/EntityMacaroonArgs'},
                                                     'Result': {'$ref': '#/definitions/ErrorResults'}},
                                      'type': 'object'},
                    'SetRemoteApplicationsStatus': {'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                    'type': 'object'},
                    'WatchLocalRelationUnits': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/RelationUnitsWatchResults'}},
                                                'type': 'object'},
                    'WatchRemoteApplicationRelations': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                       'Result': {'$ref': '#/definitions/StringsWatchResults'}},
                                                        'type': 'object'},
                    'WatchRemoteApplications': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                                'type': 'object'},
                    'WatchRemoteRelations': {'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def ConsumeRemoteRelationChanges(self, changes=None):
        '''
        changes : typing.Sequence[~RemoteRelationChangeEvent]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ConsumeRemoteRelationChanges',
                   version=1,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerAPIInfoResults)
    async def ControllerAPIInfoForModels(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ControllerAPIInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ControllerAPIInfoForModels',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ControllerConfigResult)
    async def ControllerConfig(self):
        '''

        Returns -> ControllerConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ControllerConfig',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(TokenResults)
    async def ExportEntities(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> TokenResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ExportEntities',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def GetTokens(self, args=None):
        '''
        args : typing.Sequence[~GetTokenArg]
        Returns -> StringResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='GetTokens',
                   version=1,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def ImportRemoteEntities(self, args=None):
        '''
        args : typing.Sequence[~RemoteEntityTokenArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='ImportRemoteEntities',
                   version=1,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SettingsResults)
    async def RelationUnitSettings(self, relation_units=None):
        '''
        relation_units : typing.Sequence[~RelationUnit]
        Returns -> SettingsResults
        '''
        if relation_units is not None and not isinstance(relation_units, (bytes, str, list)):
            raise Exception("Expected relation_units to be a Sequence, received: {}".format(type(relation_units)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='RelationUnitSettings',
                   version=1,
                   params=_params)
        _params['relation-units'] = relation_units
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteRelationResults)
    async def Relations(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> RemoteRelationResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='Relations',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RemoteApplicationResults)
    async def RemoteApplications(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> RemoteApplicationResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='RemoteApplications',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SaveMacaroons(self, args=None):
        '''
        args : typing.Sequence[~EntityMacaroonArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='SaveMacaroons',
                   version=1,
                   params=_params)
        _params['Args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetRemoteApplicationsStatus(self, entities=None):
        '''
        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='SetRemoteApplicationsStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(RelationUnitsWatchResults)
    async def WatchLocalRelationUnits(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> RelationUnitsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='WatchLocalRelationUnits',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResults)
    async def WatchRemoteApplicationRelations(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringsWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='WatchRemoteApplicationRelations',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchRemoteApplications(self):
        '''

        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='WatchRemoteApplications',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchRemoteRelations(self):
        '''

        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelations',
                   request='WatchRemoteRelations',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class RemoteRelationsWatcherFacade(Type):
    name = 'RemoteRelationsWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'RemoteEntityId': {'additionalProperties': False,
                                        'properties': {'model-uuid': {'type': 'string'},
                                                       'token': {'type': 'string'}},
                                        'required': ['model-uuid', 'token'],
                                        'type': 'object'},
                     'RemoteRelationChange': {'additionalProperties': False,
                                              'properties': {'changed-units': {'patternProperties': {'.*': {'$ref': '#/definitions/RemoteRelationUnitChange'}},
                                                                               'type': 'object'},
                                                             'departed-units': {'items': {'type': 'string'},
                                                                                'type': 'array'},
                                                             'id': {'type': 'integer'},
                                                             'life': {'type': 'string'}},
                                              'required': ['id', 'life'],
                                              'type': 'object'},
                     'RemoteRelationUnitChange': {'additionalProperties': False,
                                                  'properties': {'settings': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                           'type': 'object'}},
                                                                              'type': 'object'},
                                                                 'unit-id': {'$ref': '#/definitions/RemoteEntityId'}},
                                                  'required': ['unit-id'],
                                                  'type': 'object'},
                     'RemoteRelationsChange': {'additionalProperties': False,
                                               'properties': {'changed': {'items': {'$ref': '#/definitions/RemoteRelationChange'},
                                                                          'type': 'array'},
                                                              'initial': {'type': 'boolean'},
                                                              'removed': {'items': {'type': 'integer'},
                                                                          'type': 'array'}},
                                               'required': ['initial'],
                                               'type': 'object'},
                     'RemoteRelationsWatchResult': {'additionalProperties': False,
                                                    'properties': {'RemoteRelationsWatcherId': {'type': 'string'},
                                                                   'change': {'$ref': '#/definitions/RemoteRelationsChange'},
                                                                   'error': {'$ref': '#/definitions/Error'}},
                                                    'required': ['RemoteRelationsWatcherId'],
                                                    'type': 'object'}},
     'properties': {'Next': {'properties': {'Result': {'$ref': '#/definitions/RemoteRelationsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RemoteRelationsWatchResult)
    async def Next(self):
        '''

        Returns -> RemoteRelationsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelationsWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''

        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RemoteRelationsWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class ResourcesFacade(Type):
    name = 'Resources'
    version = 1
    schema =     {'definitions': {'AddCharmWithAuthorization': {'additionalProperties': False,
                                                   'properties': {'channel': {'type': 'string'},
                                                                  'force': {'type': 'boolean'},
                                                                  'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                                  'url': {'type': 'string'}},
                                                   'required': ['url',
                                                                'channel',
                                                                'macaroon',
                                                                'force'],
                                                   'type': 'object'},
                     'AddPendingResourcesArgs': {'additionalProperties': False,
                                                 'properties': {'AddCharmWithAuthorization': {'$ref': '#/definitions/AddCharmWithAuthorization'},
                                                                'Entity': {'$ref': '#/definitions/Entity'},
                                                                'channel': {'type': 'string'},
                                                                'force': {'type': 'boolean'},
                                                                'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                                'resources': {'items': {'$ref': '#/definitions/CharmResource'},
                                                                              'type': 'array'},
                                                                'tag': {'type': 'string'},
                                                                'url': {'type': 'string'}},
                                                 'required': ['tag',
                                                              'Entity',
                                                              'url',
                                                              'channel',
                                                              'macaroon',
                                                              'force',
                                                              'AddCharmWithAuthorization',
                                                              'resources'],
                                                 'type': 'object'},
                     'AddPendingResourcesResult': {'additionalProperties': False,
                                                   'properties': {'ErrorResult': {'$ref': '#/definitions/ErrorResult'},
                                                                  'error': {'$ref': '#/definitions/Error'},
                                                                  'pending-ids': {'items': {'type': 'string'},
                                                                                  'type': 'array'}},
                                                   'required': ['ErrorResult',
                                                                'pending-ids'],
                                                   'type': 'object'},
                     'CharmResource': {'additionalProperties': False,
                                       'properties': {'description': {'type': 'string'},
                                                      'fingerprint': {'items': {'type': 'integer'},
                                                                      'type': 'array'},
                                                      'name': {'type': 'string'},
                                                      'origin': {'type': 'string'},
                                                      'path': {'type': 'string'},
                                                      'revision': {'type': 'integer'},
                                                      'size': {'type': 'integer'},
                                                      'type': {'type': 'string'}},
                                       'required': ['name',
                                                    'type',
                                                    'path',
                                                    'origin',
                                                    'revision',
                                                    'fingerprint',
                                                    'size'],
                                       'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ListResourcesArgs': {'additionalProperties': False,
                                           'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                       'type': 'array'}},
                                           'required': ['entities'],
                                           'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'Resource': {'additionalProperties': False,
                                  'properties': {'CharmResource': {'$ref': '#/definitions/CharmResource'},
                                                 'application': {'type': 'string'},
                                                 'description': {'type': 'string'},
                                                 'fingerprint': {'items': {'type': 'integer'},
                                                                 'type': 'array'},
                                                 'id': {'type': 'string'},
                                                 'name': {'type': 'string'},
                                                 'origin': {'type': 'string'},
                                                 'path': {'type': 'string'},
                                                 'pending-id': {'type': 'string'},
                                                 'revision': {'type': 'integer'},
                                                 'size': {'type': 'integer'},
                                                 'timestamp': {'format': 'date-time',
                                                               'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'username': {'type': 'string'}},
                                  'required': ['name',
                                               'type',
                                               'path',
                                               'origin',
                                               'revision',
                                               'fingerprint',
                                               'size',
                                               'CharmResource',
                                               'id',
                                               'pending-id',
                                               'application',
                                               'username',
                                               'timestamp'],
                                  'type': 'object'},
                     'ResourcesResult': {'additionalProperties': False,
                                         'properties': {'ErrorResult': {'$ref': '#/definitions/ErrorResult'},
                                                        'charm-store-resources': {'items': {'$ref': '#/definitions/CharmResource'},
                                                                                  'type': 'array'},
                                                        'error': {'$ref': '#/definitions/Error'},
                                                        'resources': {'items': {'$ref': '#/definitions/Resource'},
                                                                      'type': 'array'},
                                                        'unit-resources': {'items': {'$ref': '#/definitions/UnitResources'},
                                                                           'type': 'array'}},
                                         'required': ['ErrorResult',
                                                      'resources',
                                                      'charm-store-resources',
                                                      'unit-resources'],
                                         'type': 'object'},
                     'ResourcesResults': {'additionalProperties': False,
                                          'properties': {'results': {'items': {'$ref': '#/definitions/ResourcesResult'},
                                                                     'type': 'array'}},
                                          'required': ['results'],
                                          'type': 'object'},
                     'UnitResources': {'additionalProperties': False,
                                       'properties': {'Entity': {'$ref': '#/definitions/Entity'},
                                                      'download-progress': {'patternProperties': {'.*': {'type': 'integer'}},
                                                                            'type': 'object'},
                                                      'resources': {'items': {'$ref': '#/definitions/Resource'},
                                                                    'type': 'array'},
                                                      'tag': {'type': 'string'}},
                                       'required': ['tag',
                                                    'Entity',
                                                    'resources',
                                                    'download-progress'],
                                       'type': 'object'}},
     'properties': {'AddPendingResources': {'description': 'AddPendingResources '
                                                           'adds the provided '
                                                           'resources (info) to '
                                                           'the Juju\n'
                                                           'model in a pending '
                                                           'state, meaning they '
                                                           'are not available '
                                                           'until\n'
                                                           'resolved.',
                                            'properties': {'Params': {'$ref': '#/definitions/AddPendingResourcesArgs'},
                                                           'Result': {'$ref': '#/definitions/AddPendingResourcesResult'}},
                                            'type': 'object'},
                    'ListResources': {'description': 'ListResources returns the '
                                                     'list of resources for the '
                                                     'given application.',
                                      'properties': {'Params': {'$ref': '#/definitions/ListResourcesArgs'},
                                                     'Result': {'$ref': '#/definitions/ResourcesResults'}},
                                      'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddPendingResourcesResult)
    async def AddPendingResources(self, addcharmwithauthorization=None, entity=None, channel=None, force=None, macaroon=None, resources=None, tag=None, url=None):
        '''
        AddPendingResources adds the provided resources (info) to the Juju
        model in a pending state, meaning they are not available until
        resolved.

        addcharmwithauthorization : AddCharmWithAuthorization
        entity : Entity
        channel : str
        force : bool
        macaroon : Macaroon
        resources : typing.Sequence[~CharmResource]
        tag : str
        url : str
        Returns -> AddPendingResourcesResult
        '''
        if addcharmwithauthorization is not None and not isinstance(addcharmwithauthorization, (dict, AddCharmWithAuthorization)):
            raise Exception("Expected addcharmwithauthorization to be a AddCharmWithAuthorization, received: {}".format(type(addcharmwithauthorization)))

        if entity is not None and not isinstance(entity, (dict, Entity)):
            raise Exception("Expected entity to be a Entity, received: {}".format(type(entity)))

        if channel is not None and not isinstance(channel, (bytes, str)):
            raise Exception("Expected channel to be a str, received: {}".format(type(channel)))

        if force is not None and not isinstance(force, bool):
            raise Exception("Expected force to be a bool, received: {}".format(type(force)))

        if macaroon is not None and not isinstance(macaroon, (dict, Macaroon)):
            raise Exception("Expected macaroon to be a Macaroon, received: {}".format(type(macaroon)))

        if resources is not None and not isinstance(resources, (bytes, str, list)):
            raise Exception("Expected resources to be a Sequence, received: {}".format(type(resources)))

        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        if url is not None and not isinstance(url, (bytes, str)):
            raise Exception("Expected url to be a str, received: {}".format(type(url)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Resources',
                   request='AddPendingResources',
                   version=1,
                   params=_params)
        _params['AddCharmWithAuthorization'] = addcharmwithauthorization
        _params['Entity'] = entity
        _params['channel'] = channel
        _params['force'] = force
        _params['macaroon'] = macaroon
        _params['resources'] = resources
        _params['tag'] = tag
        _params['url'] = url
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ResourcesResults)
    async def ListResources(self, entities=None):
        '''
        ListResources returns the list of resources for the given application.

        entities : typing.Sequence[~Entity]
        Returns -> ResourcesResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Resources',
                   request='ListResources',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class ResourcesHookContextFacade(Type):
    name = 'ResourcesHookContext'
    version = 1
    schema =     {'definitions': {'CharmResource': {'additionalProperties': False,
                                       'properties': {'description': {'type': 'string'},
                                                      'fingerprint': {'items': {'type': 'integer'},
                                                                      'type': 'array'},
                                                      'name': {'type': 'string'},
                                                      'origin': {'type': 'string'},
                                                      'path': {'type': 'string'},
                                                      'revision': {'type': 'integer'},
                                                      'size': {'type': 'integer'},
                                                      'type': {'type': 'string'}},
                                       'required': ['name',
                                                    'type',
                                                    'path',
                                                    'origin',
                                                    'revision',
                                                    'fingerprint',
                                                    'size'],
                                       'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ListUnitResourcesArgs': {'additionalProperties': False,
                                               'properties': {'resource-names': {'items': {'type': 'string'},
                                                                                 'type': 'array'}},
                                               'required': ['resource-names'],
                                               'type': 'object'},
                     'Resource': {'additionalProperties': False,
                                  'properties': {'CharmResource': {'$ref': '#/definitions/CharmResource'},
                                                 'application': {'type': 'string'},
                                                 'description': {'type': 'string'},
                                                 'fingerprint': {'items': {'type': 'integer'},
                                                                 'type': 'array'},
                                                 'id': {'type': 'string'},
                                                 'name': {'type': 'string'},
                                                 'origin': {'type': 'string'},
                                                 'path': {'type': 'string'},
                                                 'pending-id': {'type': 'string'},
                                                 'revision': {'type': 'integer'},
                                                 'size': {'type': 'integer'},
                                                 'timestamp': {'format': 'date-time',
                                                               'type': 'string'},
                                                 'type': {'type': 'string'},
                                                 'username': {'type': 'string'}},
                                  'required': ['name',
                                               'type',
                                               'path',
                                               'origin',
                                               'revision',
                                               'fingerprint',
                                               'size',
                                               'CharmResource',
                                               'id',
                                               'pending-id',
                                               'application',
                                               'username',
                                               'timestamp'],
                                  'type': 'object'},
                     'UnitResourceResult': {'additionalProperties': False,
                                            'properties': {'ErrorResult': {'$ref': '#/definitions/ErrorResult'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'resource': {'$ref': '#/definitions/Resource'}},
                                            'required': ['ErrorResult', 'resource'],
                                            'type': 'object'},
                     'UnitResourcesResult': {'additionalProperties': False,
                                             'properties': {'ErrorResult': {'$ref': '#/definitions/ErrorResult'},
                                                            'error': {'$ref': '#/definitions/Error'},
                                                            'resources': {'items': {'$ref': '#/definitions/UnitResourceResult'},
                                                                          'type': 'array'}},
                                             'required': ['ErrorResult',
                                                          'resources'],
                                             'type': 'object'}},
     'properties': {'GetResourceInfo': {'description': 'GetResourceInfo returns '
                                                       'the resource info for each '
                                                       'of the given\n'
                                                       'resource names (for the '
                                                       'implicit application). If '
                                                       'any one is missing then\n'
                                                       'the corresponding result '
                                                       'is set with '
                                                       'errors.NotFound.',
                                        'properties': {'Params': {'$ref': '#/definitions/ListUnitResourcesArgs'},
                                                       'Result': {'$ref': '#/definitions/UnitResourcesResult'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(UnitResourcesResult)
    async def GetResourceInfo(self, resource_names=None):
        '''
        GetResourceInfo returns the resource info for each of the given
        resource names (for the implicit application). If any one is missing then
        the corresponding result is set with errors.NotFound.

        resource_names : typing.Sequence[str]
        Returns -> UnitResourcesResult
        '''
        if resource_names is not None and not isinstance(resource_names, (bytes, str, list)):
            raise Exception("Expected resource_names to be a Sequence, received: {}".format(type(resource_names)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='ResourcesHookContext',
                   request='GetResourceInfo',
                   version=1,
                   params=_params)
        _params['resource-names'] = resource_names
        reply = await self.rpc(msg)
        return reply



class RetryStrategyFacade(Type):
    name = 'RetryStrategy'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'RetryStrategy': {'additionalProperties': False,
                                       'properties': {'jitter-retry-time': {'type': 'boolean'},
                                                      'max-retry-time': {'type': 'integer'},
                                                      'min-retry-time': {'type': 'integer'},
                                                      'retry-time-factor': {'type': 'integer'},
                                                      'should-retry': {'type': 'boolean'}},
                                       'required': ['should-retry',
                                                    'min-retry-time',
                                                    'max-retry-time',
                                                    'jitter-retry-time',
                                                    'retry-time-factor'],
                                       'type': 'object'},
                     'RetryStrategyResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'result': {'$ref': '#/definitions/RetryStrategy'}},
                                             'type': 'object'},
                     'RetryStrategyResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/RetryStrategyResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'}},
     'properties': {'RetryStrategy': {'description': 'RetryStrategy returns '
                                                     'RetryStrategyResults that '
                                                     'can be used by any code that '
                                                     'uses\n'
                                                     'to configure the retry timer '
                                                     "that's currently in juju "
                                                     'utils.',
                                      'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/RetryStrategyResults'}},
                                      'type': 'object'},
                    'WatchRetryStrategy': {'description': 'WatchRetryStrategy '
                                                          'watches for changes to '
                                                          'the model. Currently we '
                                                          'only allow\n'
                                                          'changes to the boolean '
                                                          'that determines whether '
                                                          'retries should be '
                                                          'attempted or not.',
                                           'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                          'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                           'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(RetryStrategyResults)
    async def RetryStrategy(self, entities=None):
        '''
        RetryStrategy returns RetryStrategyResults that can be used by any code that uses
        to configure the retry timer that's currently in juju utils.

        entities : typing.Sequence[~Entity]
        Returns -> RetryStrategyResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RetryStrategy',
                   request='RetryStrategy',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchRetryStrategy(self, entities=None):
        '''
        WatchRetryStrategy watches for changes to the model. Currently we only allow
        changes to the boolean that determines whether retries should be attempted or not.

        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='RetryStrategy',
                   request='WatchRetryStrategy',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SSHClientFacade(Type):
    name = 'SSHClient'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SSHAddressResult': {'additionalProperties': False,
                                          'properties': {'address': {'type': 'string'},
                                                         'error': {'$ref': '#/definitions/Error'}},
                                          'type': 'object'},
                     'SSHAddressResults': {'additionalProperties': False,
                                           'properties': {'results': {'items': {'$ref': '#/definitions/SSHAddressResult'},
                                                                      'type': 'array'}},
                                           'required': ['results'],
                                           'type': 'object'},
                     'SSHProxyResult': {'additionalProperties': False,
                                        'properties': {'use-proxy': {'type': 'boolean'}},
                                        'required': ['use-proxy'],
                                        'type': 'object'},
                     'SSHPublicKeysResult': {'additionalProperties': False,
                                             'properties': {'error': {'$ref': '#/definitions/Error'},
                                                            'public-keys': {'items': {'type': 'string'},
                                                                            'type': 'array'}},
                                             'type': 'object'},
                     'SSHPublicKeysResults': {'additionalProperties': False,
                                              'properties': {'results': {'items': {'$ref': '#/definitions/SSHPublicKeysResult'},
                                                                         'type': 'array'}},
                                              'required': ['results'],
                                              'type': 'object'}},
     'properties': {'PrivateAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                       'type': 'object'},
                    'Proxy': {'properties': {'Result': {'$ref': '#/definitions/SSHProxyResult'}},
                              'type': 'object'},
                    'PublicAddress': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/SSHAddressResults'}},
                                      'type': 'object'},
                    'PublicKeys': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/SSHPublicKeysResults'}},
                                   'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(SSHAddressResults)
    async def PrivateAddress(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> SSHAddressResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='PrivateAddress',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHProxyResult)
    async def Proxy(self):
        '''

        Returns -> SSHProxyResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='Proxy',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHAddressResults)
    async def PublicAddress(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> SSHAddressResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='PublicAddress',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(SSHPublicKeysResults)
    async def PublicKeys(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> SSHPublicKeysResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='SSHClient',
                   request='PublicKeys',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class SingularFacade(Type):
    name = 'Singular'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'SingularClaim': {'additionalProperties': False,
                                       'properties': {'controller-tag': {'type': 'string'},
                                                      'duration': {'type': 'integer'},
                                                      'model-tag': {'type': 'string'}},
                                       'required': ['model-tag',
                                                    'controller-tag',
                                                    'duration'],
                                       'type': 'object'},
                     'SingularClaims': {'additionalProperties': False,
                                        'properties': {'claims': {'items': {'$ref': '#/definitions/SingularClaim'},
                                                                  'type': 'array'}},
                                        'required': ['claims'],
                                        'type': 'object'}},
     'properties': {'Claim': {'properties': {'Params': {'$ref': '#/definitions/SingularClaims'},
                                             'Result': {'$ref': '#/definitions/ErrorResults'}},
                              'type': 'object'},
                    'Wait': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                            'Result': {'$ref': '#/definitions/ErrorResults'}},
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def Claim(self, claims=None):
        '''
        claims : typing.Sequence[~SingularClaim]
        Returns -> ErrorResults
        '''
        if claims is not None and not isinstance(claims, (bytes, str, list)):
            raise Exception("Expected claims to be a Sequence, received: {}".format(type(claims)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Singular',
                   request='Claim',
                   version=1,
                   params=_params)
        _params['claims'] = claims
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def Wait(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Singular',
                   request='Wait',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class StringsWatcherFacade(Type):
    name = 'StringsWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'Next': {'description': 'Next returns when a change has '
                                            'occurred to an entity of the\n'
                                            'collection being watched since the '
                                            'most recent call to Next\n'
                                            'or the Watch call that created the '
                                            'srvStringsWatcher.',
                             'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(StringsWatchResult)
    async def Next(self):
        '''
        Next returns when a change has occurred to an entity of the
        collection being watched since the most recent call to Next
        or the Watch call that created the srvStringsWatcher.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StringsWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='StringsWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class UndertakerFacade(Type):
    name = 'Undertaker'
    version = 1
    schema =     {'definitions': {'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'ModelConfigResult': {'additionalProperties': False,
                                           'properties': {'config': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                                  'type': 'object'}},
                                                                     'type': 'object'}},
                                           'required': ['config'],
                                           'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'UndertakerModelInfo': {'additionalProperties': False,
                                             'properties': {'force-destroyed': {'type': 'boolean'},
                                                            'global-name': {'type': 'string'},
                                                            'is-system': {'type': 'boolean'},
                                                            'life': {'type': 'string'},
                                                            'name': {'type': 'string'},
                                                            'uuid': {'type': 'string'}},
                                             'required': ['uuid',
                                                          'name',
                                                          'global-name',
                                                          'is-system',
                                                          'life',
                                                          'force-destroyed'],
                                             'type': 'object'},
                     'UndertakerModelInfoResult': {'additionalProperties': False,
                                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                  'result': {'$ref': '#/definitions/UndertakerModelInfo'}},
                                                   'required': ['result'],
                                                   'type': 'object'}},
     'properties': {'ModelConfig': {'description': 'ModelConfig returns the '
                                                   "model's configuration.",
                                    'properties': {'Result': {'$ref': '#/definitions/ModelConfigResult'}},
                                    'type': 'object'},
                    'ModelInfo': {'description': 'ModelInfo returns information on '
                                                 'the model needed by the '
                                                 'undertaker worker.',
                                  'properties': {'Result': {'$ref': '#/definitions/UndertakerModelInfoResult'}},
                                  'type': 'object'},
                    'ProcessDyingModel': {'description': 'ProcessDyingModel checks '
                                                         'if a dying model has any '
                                                         'machines or '
                                                         'applications.\n'
                                                         'If there are none, the '
                                                         "model's life is changed "
                                                         'from dying to dead.',
                                          'type': 'object'},
                    'RemoveModel': {'description': 'RemoveModel removes any '
                                                   'records of this model from '
                                                   'Juju.',
                                    'type': 'object'},
                    'SetStatus': {'description': 'SetStatus sets the status of '
                                                 'each given entity.',
                                  'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                 'Result': {'$ref': '#/definitions/ErrorResults'}},
                                  'type': 'object'},
                    'UpdateStatus': {'description': 'UpdateStatus updates the '
                                                    'status data of each given '
                                                    'entity.\n'
                                                    'TODO(fwereade): WTF. This '
                                                    'method exists *only* for the '
                                                    'convenience of the\n'
                                                    '*client* API -- and is itself '
                                                    'completely broken -- but we '
                                                    'still expose it\n'
                                                    'in every facade with a '
                                                    'StatusSetter? FFS.',
                                     'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                    'Result': {'$ref': '#/definitions/ErrorResults'}},
                                     'type': 'object'},
                    'WatchModelResources': {'description': 'WatchModelResources '
                                                           'creates watchers for '
                                                           'changes to the '
                                                           'lifecycle of an\n'
                                                           "model's machines and "
                                                           'services.',
                                            'properties': {'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                            'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ModelConfigResult)
    async def ModelConfig(self):
        '''
        ModelConfig returns the model's configuration.


        Returns -> ModelConfigResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker',
                   request='ModelConfig',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UndertakerModelInfoResult)
    async def ModelInfo(self):
        '''
        ModelInfo returns information on the model needed by the undertaker worker.


        Returns -> UndertakerModelInfoResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker',
                   request='ModelInfo',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def ProcessDyingModel(self):
        '''
        ProcessDyingModel checks if a dying model has any machines or applications.
        If there are none, the model's life is changed from dying to dead.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker',
                   request='ProcessDyingModel',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def RemoveModel(self):
        '''
        RemoveModel removes any records of this model from Juju.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker',
                   request='RemoveModel',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetStatus(self, entities=None):
        '''
        SetStatus sets the status of each given entity.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker',
                   request='SetStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def UpdateStatus(self, entities=None):
        '''
        UpdateStatus updates the status data of each given entity.
        TODO(fwereade): WTF. This method exists *only* for the convenience of the
        *client* API -- and is itself completely broken -- but we still expose it
        in every facade with a StatusSetter? FFS.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker',
                   request='UpdateStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchModelResources(self):
        '''
        WatchModelResources creates watchers for changes to the lifecycle of an
        model's machines and services.


        Returns -> NotifyWatchResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Undertaker',
                   request='WatchModelResources',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class UnitAssignerFacade(Type):
    name = 'UnitAssigner'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityStatusArgs': {'additionalProperties': False,
                                          'properties': {'data': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                               'type': 'object'}},
                                                                  'type': 'object'},
                                                         'info': {'type': 'string'},
                                                         'status': {'type': 'string'},
                                                         'tag': {'type': 'string'}},
                                          'required': ['tag',
                                                       'status',
                                                       'info',
                                                       'data'],
                                          'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'SetStatus': {'additionalProperties': False,
                                   'properties': {'entities': {'items': {'$ref': '#/definitions/EntityStatusArgs'},
                                                               'type': 'array'}},
                                   'required': ['entities'],
                                   'type': 'object'},
                     'StringsWatchResult': {'additionalProperties': False,
                                            'properties': {'changes': {'items': {'type': 'string'},
                                                                       'type': 'array'},
                                                           'error': {'$ref': '#/definitions/Error'},
                                                           'watcher-id': {'type': 'string'}},
                                            'required': ['watcher-id'],
                                            'type': 'object'}},
     'properties': {'AssignUnits': {'description': 'AssignUnits assigns the units '
                                                   'with the given ids to the '
                                                   'correct machine. The\n'
                                                   ' error results are returned in '
                                                   'the same order as the given '
                                                   'entities.',
                                    'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'SetAgentStatus': {'description': 'SetAgentStatus will set '
                                                      'status for agents of Units '
                                                      'passed in args, if one\n'
                                                      'of the args is not an Unit '
                                                      'it will fail.',
                                       'properties': {'Params': {'$ref': '#/definitions/SetStatus'},
                                                      'Result': {'$ref': '#/definitions/ErrorResults'}},
                                       'type': 'object'},
                    'WatchUnitAssignments': {'description': 'WatchUnitAssignments '
                                                            'returns a strings '
                                                            'watcher that is '
                                                            'notified when new '
                                                            'unit\n'
                                                            'assignments are added '
                                                            'to the db.',
                                             'properties': {'Result': {'$ref': '#/definitions/StringsWatchResult'}},
                                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def AssignUnits(self, entities=None):
        '''
        AssignUnits assigns the units with the given ids to the correct machine. The
         error results are returned in the same order as the given entities.

        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UnitAssigner',
                   request='AssignUnits',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetAgentStatus(self, entities=None):
        '''
        SetAgentStatus will set status for agents of Units passed in args, if one
        of the args is not an Unit it will fail.

        entities : typing.Sequence[~EntityStatusArgs]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UnitAssigner',
                   request='SetAgentStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringsWatchResult)
    async def WatchUnitAssignments(self):
        '''
        WatchUnitAssignments returns a strings watcher that is notified when new unit
        assignments are added to the db.


        Returns -> StringsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UnitAssigner',
                   request='WatchUnitAssignments',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



class UpgradeSeriesFacade(Type):
    name = 'UpgradeSeries'
    version = 1
    schema =     {'definitions': {'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesResult': {'additionalProperties': False,
                                        'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                    'type': 'array'},
                                                       'error': {'$ref': '#/definitions/Error'}},
                                        'required': ['entities'],
                                        'type': 'object'},
                     'EntitiesResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/EntitiesResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'PinApplicationResult': {'additionalProperties': False,
                                              'properties': {'application-name': {'type': 'string'},
                                                             'error': {'$ref': '#/definitions/Error'}},
                                              'required': ['application-name'],
                                              'type': 'object'},
                     'PinApplicationsResults': {'additionalProperties': False,
                                                'properties': {'results': {'items': {'$ref': '#/definitions/PinApplicationResult'},
                                                                           'type': 'array'}},
                                                'required': ['results'],
                                                'type': 'object'},
                     'PinnedLeadershipResult': {'additionalProperties': False,
                                                'properties': {'result': {'patternProperties': {'.*': {'items': {'type': 'string'},
                                                                                                       'type': 'array'}},
                                                                          'type': 'object'}},
                                                'type': 'object'},
                     'StringResult': {'additionalProperties': False,
                                      'properties': {'error': {'$ref': '#/definitions/Error'},
                                                     'result': {'type': 'string'}},
                                      'required': ['result'],
                                      'type': 'object'},
                     'StringResults': {'additionalProperties': False,
                                       'properties': {'results': {'items': {'$ref': '#/definitions/StringResult'},
                                                                  'type': 'array'}},
                                       'required': ['results'],
                                       'type': 'object'},
                     'UpdateSeriesArg': {'additionalProperties': False,
                                         'properties': {'force': {'type': 'boolean'},
                                                        'series': {'type': 'string'},
                                                        'tag': {'$ref': '#/definitions/Entity'}},
                                         'required': ['tag', 'force', 'series'],
                                         'type': 'object'},
                     'UpdateSeriesArgs': {'additionalProperties': False,
                                          'properties': {'args': {'items': {'$ref': '#/definitions/UpdateSeriesArg'},
                                                                  'type': 'array'}},
                                          'required': ['args'],
                                          'type': 'object'},
                     'UpgradeSeriesStartUnitCompletionParam': {'additionalProperties': False,
                                                               'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                                           'type': 'array'},
                                                                              'message': {'type': 'string'}},
                                                               'required': ['entities',
                                                                            'message'],
                                                               'type': 'object'},
                     'UpgradeSeriesStatusParam': {'additionalProperties': False,
                                                  'properties': {'entity': {'$ref': '#/definitions/Entity'},
                                                                 'message': {'type': 'string'},
                                                                 'status': {'type': 'string'}},
                                                  'required': ['entity',
                                                               'status',
                                                               'message'],
                                                  'type': 'object'},
                     'UpgradeSeriesStatusParams': {'additionalProperties': False,
                                                   'properties': {'params': {'items': {'$ref': '#/definitions/UpgradeSeriesStatusParam'},
                                                                             'type': 'array'}},
                                                   'required': ['params'],
                                                   'type': 'object'},
                     'UpgradeSeriesStatusResult': {'additionalProperties': False,
                                                   'properties': {'error': {'$ref': '#/definitions/Error'},
                                                                  'status': {'type': 'string'}},
                                                   'type': 'object'},
                     'UpgradeSeriesStatusResults': {'additionalProperties': False,
                                                    'properties': {'results': {'items': {'$ref': '#/definitions/UpgradeSeriesStatusResult'},
                                                                               'type': 'array'}},
                                                    'type': 'object'}},
     'properties': {'FinishUpgradeSeries': {'properties': {'Params': {'$ref': '#/definitions/UpdateSeriesArgs'},
                                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                                            'type': 'object'},
                    'MachineStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/UpgradeSeriesStatusResults'}},
                                      'type': 'object'},
                    'PinMachineApplications': {'properties': {'Result': {'$ref': '#/definitions/PinApplicationsResults'}},
                                               'type': 'object'},
                    'PinnedLeadership': {'properties': {'Result': {'$ref': '#/definitions/PinnedLeadershipResult'}},
                                         'type': 'object'},
                    'SetMachineStatus': {'properties': {'Params': {'$ref': '#/definitions/UpgradeSeriesStatusParams'},
                                                        'Result': {'$ref': '#/definitions/ErrorResults'}},
                                         'type': 'object'},
                    'SetUpgradeSeriesUnitStatus': {'properties': {'Params': {'$ref': '#/definitions/UpgradeSeriesStatusParams'},
                                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                                   'type': 'object'},
                    'StartUnitCompletion': {'properties': {'Params': {'$ref': '#/definitions/UpgradeSeriesStartUnitCompletionParam'},
                                                           'Result': {'$ref': '#/definitions/ErrorResults'}},
                                            'type': 'object'},
                    'TargetSeries': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                    'Result': {'$ref': '#/definitions/StringResults'}},
                                     'type': 'object'},
                    'UnitsCompleted': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/EntitiesResults'}},
                                       'type': 'object'},
                    'UnitsPrepared': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                     'Result': {'$ref': '#/definitions/EntitiesResults'}},
                                      'type': 'object'},
                    'UnpinMachineApplications': {'properties': {'Result': {'$ref': '#/definitions/PinApplicationsResults'}},
                                                 'type': 'object'},
                    'UpgradeSeriesUnitStatus': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                               'Result': {'$ref': '#/definitions/UpgradeSeriesStatusResults'}},
                                                'type': 'object'},
                    'WatchUpgradeSeriesNotifications': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                                       'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResults)
    async def FinishUpgradeSeries(self, args=None):
        '''
        args : typing.Sequence[~UpdateSeriesArg]
        Returns -> ErrorResults
        '''
        if args is not None and not isinstance(args, (bytes, str, list)):
            raise Exception("Expected args to be a Sequence, received: {}".format(type(args)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='FinishUpgradeSeries',
                   version=1,
                   params=_params)
        _params['args'] = args
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpgradeSeriesStatusResults)
    async def MachineStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> UpgradeSeriesStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='MachineStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PinApplicationsResults)
    async def PinMachineApplications(self):
        '''

        Returns -> PinApplicationsResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='PinMachineApplications',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PinnedLeadershipResult)
    async def PinnedLeadership(self):
        '''

        Returns -> PinnedLeadershipResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='PinnedLeadership',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetMachineStatus(self, params=None):
        '''
        params : typing.Sequence[~UpgradeSeriesStatusParam]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='SetMachineStatus',
                   version=1,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetUpgradeSeriesUnitStatus(self, params=None):
        '''
        params : typing.Sequence[~UpgradeSeriesStatusParam]
        Returns -> ErrorResults
        '''
        if params is not None and not isinstance(params, (bytes, str, list)):
            raise Exception("Expected params to be a Sequence, received: {}".format(type(params)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='SetUpgradeSeriesUnitStatus',
                   version=1,
                   params=_params)
        _params['params'] = params
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def StartUnitCompletion(self, entities=None, message=None):
        '''
        entities : typing.Sequence[~Entity]
        message : str
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        if message is not None and not isinstance(message, (bytes, str)):
            raise Exception("Expected message to be a str, received: {}".format(type(message)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='StartUnitCompletion',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        _params['message'] = message
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(StringResults)
    async def TargetSeries(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> StringResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='TargetSeries',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(EntitiesResults)
    async def UnitsCompleted(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> EntitiesResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='UnitsCompleted',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(EntitiesResults)
    async def UnitsPrepared(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> EntitiesResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='UnitsPrepared',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(PinApplicationsResults)
    async def UnpinMachineApplications(self):
        '''

        Returns -> PinApplicationsResults
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='UnpinMachineApplications',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UpgradeSeriesStatusResults)
    async def UpgradeSeriesUnitStatus(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> UpgradeSeriesStatusResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='UpgradeSeriesUnitStatus',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchUpgradeSeriesNotifications(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSeries',
                   request='WatchUpgradeSeriesNotifications',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class UpgradeStepsFacade(Type):
    name = 'UpgradeSteps'
    version = 1
    schema =     {'definitions': {'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'}},
     'properties': {'ResetKVMMachineModificationStatusIdle': {'properties': {'Params': {'$ref': '#/definitions/Entity'},
                                                                             'Result': {'$ref': '#/definitions/ErrorResult'}},
                                                              'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(ErrorResult)
    async def ResetKVMMachineModificationStatusIdle(self, tag=None):
        '''
        tag : str
        Returns -> ErrorResult
        '''
        if tag is not None and not isinstance(tag, (bytes, str)):
            raise Exception("Expected tag to be a str, received: {}".format(type(tag)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UpgradeSteps',
                   request='ResetKVMMachineModificationStatusIdle',
                   version=1,
                   params=_params)
        _params['tag'] = tag
        reply = await self.rpc(msg)
        return reply



class UpgraderFacade(Type):
    name = 'Upgrader'
    version = 1
    schema =     {'definitions': {'Binary': {'additionalProperties': False,
                                'properties': {'Arch': {'type': 'string'},
                                               'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Number': {'$ref': '#/definitions/Number'},
                                               'Patch': {'type': 'integer'},
                                               'Series': {'type': 'string'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build',
                                             'Number',
                                             'Series',
                                             'Arch'],
                                'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'EntitiesVersion': {'additionalProperties': False,
                                         'properties': {'agent-tools': {'items': {'$ref': '#/definitions/EntityVersion'},
                                                                        'type': 'array'}},
                                         'required': ['agent-tools'],
                                         'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityVersion': {'additionalProperties': False,
                                       'properties': {'tag': {'type': 'string'},
                                                      'tools': {'$ref': '#/definitions/Version'}},
                                       'required': ['tag', 'tools'],
                                       'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'NotifyWatchResult': {'additionalProperties': False,
                                           'properties': {'NotifyWatcherId': {'type': 'string'},
                                                          'error': {'$ref': '#/definitions/Error'}},
                                           'required': ['NotifyWatcherId'],
                                           'type': 'object'},
                     'NotifyWatchResults': {'additionalProperties': False,
                                            'properties': {'results': {'items': {'$ref': '#/definitions/NotifyWatchResult'},
                                                                       'type': 'array'}},
                                            'required': ['results'],
                                            'type': 'object'},
                     'Number': {'additionalProperties': False,
                                'properties': {'Build': {'type': 'integer'},
                                               'Major': {'type': 'integer'},
                                               'Minor': {'type': 'integer'},
                                               'Patch': {'type': 'integer'},
                                               'Tag': {'type': 'string'}},
                                'required': ['Major',
                                             'Minor',
                                             'Tag',
                                             'Patch',
                                             'Build'],
                                'type': 'object'},
                     'Tools': {'additionalProperties': False,
                               'properties': {'sha256': {'type': 'string'},
                                              'size': {'type': 'integer'},
                                              'url': {'type': 'string'},
                                              'version': {'$ref': '#/definitions/Binary'}},
                               'required': ['version', 'url', 'size'],
                               'type': 'object'},
                     'ToolsResult': {'additionalProperties': False,
                                     'properties': {'disable-ssl-hostname-verification': {'type': 'boolean'},
                                                    'error': {'$ref': '#/definitions/Error'},
                                                    'tools': {'items': {'$ref': '#/definitions/Tools'},
                                                              'type': 'array'}},
                                     'required': ['tools',
                                                  'disable-ssl-hostname-verification'],
                                     'type': 'object'},
                     'ToolsResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ToolsResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Version': {'additionalProperties': False,
                                 'properties': {'version': {'$ref': '#/definitions/Binary'}},
                                 'required': ['version'],
                                 'type': 'object'},
                     'VersionResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'version': {'$ref': '#/definitions/Number'}},
                                       'type': 'object'},
                     'VersionResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/VersionResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'}},
     'properties': {'DesiredVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                      'Result': {'$ref': '#/definitions/VersionResults'}},
                                       'type': 'object'},
                    'SetTools': {'properties': {'Params': {'$ref': '#/definitions/EntitiesVersion'},
                                                'Result': {'$ref': '#/definitions/ErrorResults'}},
                                 'type': 'object'},
                    'Tools': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                             'Result': {'$ref': '#/definitions/ToolsResults'}},
                              'type': 'object'},
                    'WatchAPIVersion': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                       'Result': {'$ref': '#/definitions/NotifyWatchResults'}},
                                        'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(VersionResults)
    async def DesiredVersion(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> VersionResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Upgrader',
                   request='DesiredVersion',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetTools(self, agent_tools=None):
        '''
        agent_tools : typing.Sequence[~EntityVersion]
        Returns -> ErrorResults
        '''
        if agent_tools is not None and not isinstance(agent_tools, (bytes, str, list)):
            raise Exception("Expected agent_tools to be a Sequence, received: {}".format(type(agent_tools)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Upgrader',
                   request='SetTools',
                   version=1,
                   params=_params)
        _params['agent-tools'] = agent_tools
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ToolsResults)
    async def Tools(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ToolsResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Upgrader',
                   request='Tools',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(NotifyWatchResults)
    async def WatchAPIVersion(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> NotifyWatchResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='Upgrader',
                   request='WatchAPIVersion',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



class UserManagerFacade(Type):
    name = 'UserManager'
    version = 1
    schema =     {'definitions': {'AddUser': {'additionalProperties': False,
                                 'properties': {'display-name': {'type': 'string'},
                                                'password': {'type': 'string'},
                                                'username': {'type': 'string'}},
                                 'required': ['username', 'display-name'],
                                 'type': 'object'},
                     'AddUserResult': {'additionalProperties': False,
                                       'properties': {'error': {'$ref': '#/definitions/Error'},
                                                      'secret-key': {'items': {'type': 'integer'},
                                                                     'type': 'array'},
                                                      'tag': {'type': 'string'}},
                                       'type': 'object'},
                     'AddUserResults': {'additionalProperties': False,
                                        'properties': {'results': {'items': {'$ref': '#/definitions/AddUserResult'},
                                                                   'type': 'array'}},
                                        'required': ['results'],
                                        'type': 'object'},
                     'AddUsers': {'additionalProperties': False,
                                  'properties': {'users': {'items': {'$ref': '#/definitions/AddUser'},
                                                           'type': 'array'}},
                                  'required': ['users'],
                                  'type': 'object'},
                     'Entities': {'additionalProperties': False,
                                  'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                              'type': 'array'}},
                                  'required': ['entities'],
                                  'type': 'object'},
                     'Entity': {'additionalProperties': False,
                                'properties': {'tag': {'type': 'string'}},
                                'required': ['tag'],
                                'type': 'object'},
                     'EntityPassword': {'additionalProperties': False,
                                        'properties': {'password': {'type': 'string'},
                                                       'tag': {'type': 'string'}},
                                        'required': ['tag', 'password'],
                                        'type': 'object'},
                     'EntityPasswords': {'additionalProperties': False,
                                         'properties': {'changes': {'items': {'$ref': '#/definitions/EntityPassword'},
                                                                    'type': 'array'}},
                                         'required': ['changes'],
                                         'type': 'object'},
                     'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'$ref': '#/definitions/ErrorInfo'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'ErrorInfo': {'additionalProperties': False,
                                   'properties': {'macaroon': {'$ref': '#/definitions/Macaroon'},
                                                  'macaroon-path': {'type': 'string'}},
                                   'type': 'object'},
                     'ErrorResult': {'additionalProperties': False,
                                     'properties': {'error': {'$ref': '#/definitions/Error'}},
                                     'type': 'object'},
                     'ErrorResults': {'additionalProperties': False,
                                      'properties': {'results': {'items': {'$ref': '#/definitions/ErrorResult'},
                                                                 'type': 'array'}},
                                      'required': ['results'],
                                      'type': 'object'},
                     'Macaroon': {'additionalProperties': False, 'type': 'object'},
                     'UserInfo': {'additionalProperties': False,
                                  'properties': {'access': {'type': 'string'},
                                                 'created-by': {'type': 'string'},
                                                 'date-created': {'format': 'date-time',
                                                                  'type': 'string'},
                                                 'disabled': {'type': 'boolean'},
                                                 'display-name': {'type': 'string'},
                                                 'last-connection': {'format': 'date-time',
                                                                     'type': 'string'},
                                                 'username': {'type': 'string'}},
                                  'required': ['username',
                                               'display-name',
                                               'access',
                                               'created-by',
                                               'date-created',
                                               'disabled'],
                                  'type': 'object'},
                     'UserInfoRequest': {'additionalProperties': False,
                                         'properties': {'entities': {'items': {'$ref': '#/definitions/Entity'},
                                                                     'type': 'array'},
                                                        'include-disabled': {'type': 'boolean'}},
                                         'required': ['entities',
                                                      'include-disabled'],
                                         'type': 'object'},
                     'UserInfoResult': {'additionalProperties': False,
                                        'properties': {'error': {'$ref': '#/definitions/Error'},
                                                       'result': {'$ref': '#/definitions/UserInfo'}},
                                        'type': 'object'},
                     'UserInfoResults': {'additionalProperties': False,
                                         'properties': {'results': {'items': {'$ref': '#/definitions/UserInfoResult'},
                                                                    'type': 'array'}},
                                         'required': ['results'],
                                         'type': 'object'}},
     'properties': {'AddUser': {'properties': {'Params': {'$ref': '#/definitions/AddUsers'},
                                               'Result': {'$ref': '#/definitions/AddUserResults'}},
                                'type': 'object'},
                    'DisableUser': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'EnableUser': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'RemoveUser': {'properties': {'Params': {'$ref': '#/definitions/Entities'},
                                                  'Result': {'$ref': '#/definitions/ErrorResults'}},
                                   'type': 'object'},
                    'SetPassword': {'properties': {'Params': {'$ref': '#/definitions/EntityPasswords'},
                                                   'Result': {'$ref': '#/definitions/ErrorResults'}},
                                    'type': 'object'},
                    'UserInfo': {'properties': {'Params': {'$ref': '#/definitions/UserInfoRequest'},
                                                'Result': {'$ref': '#/definitions/UserInfoResults'}},
                                 'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(AddUserResults)
    async def AddUser(self, users=None):
        '''
        users : typing.Sequence[~AddUser]
        Returns -> AddUserResults
        '''
        if users is not None and not isinstance(users, (bytes, str, list)):
            raise Exception("Expected users to be a Sequence, received: {}".format(type(users)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='AddUser',
                   version=1,
                   params=_params)
        _params['users'] = users
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def DisableUser(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='DisableUser',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def EnableUser(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='EnableUser',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def RemoveUser(self, entities=None):
        '''
        entities : typing.Sequence[~Entity]
        Returns -> ErrorResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='RemoveUser',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(ErrorResults)
    async def SetPassword(self, changes=None):
        '''
        changes : typing.Sequence[~EntityPassword]
        Returns -> ErrorResults
        '''
        if changes is not None and not isinstance(changes, (bytes, str, list)):
            raise Exception("Expected changes to be a Sequence, received: {}".format(type(changes)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='SetPassword',
                   version=1,
                   params=_params)
        _params['changes'] = changes
        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(UserInfoResults)
    async def UserInfo(self, entities=None, include_disabled=None):
        '''
        entities : typing.Sequence[~Entity]
        include_disabled : bool
        Returns -> UserInfoResults
        '''
        if entities is not None and not isinstance(entities, (bytes, str, list)):
            raise Exception("Expected entities to be a Sequence, received: {}".format(type(entities)))

        if include_disabled is not None and not isinstance(include_disabled, bool):
            raise Exception("Expected include_disabled to be a bool, received: {}".format(type(include_disabled)))

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='UserManager',
                   request='UserInfo',
                   version=1,
                   params=_params)
        _params['entities'] = entities
        _params['include-disabled'] = include_disabled
        reply = await self.rpc(msg)
        return reply



class VolumeAttachmentPlansWatcherFacade(Type):
    name = 'VolumeAttachmentPlansWatcher'
    version = 1
    schema =     {'definitions': {'Error': {'additionalProperties': False,
                               'properties': {'code': {'type': 'string'},
                                              'info': {'patternProperties': {'.*': {'additionalProperties': True,
                                                                                    'type': 'object'}},
                                                       'type': 'object'},
                                              'message': {'type': 'string'}},
                               'required': ['message', 'code'],
                               'type': 'object'},
                     'MachineStorageId': {'additionalProperties': False,
                                          'properties': {'attachment-tag': {'type': 'string'},
                                                         'machine-tag': {'type': 'string'}},
                                          'required': ['machine-tag',
                                                       'attachment-tag'],
                                          'type': 'object'},
                     'MachineStorageIdsWatchResult': {'additionalProperties': False,
                                                      'properties': {'changes': {'items': {'$ref': '#/definitions/MachineStorageId'},
                                                                                 'type': 'array'},
                                                                     'error': {'$ref': '#/definitions/Error'},
                                                                     'watcher-id': {'type': 'string'}},
                                                      'required': ['watcher-id',
                                                                   'changes'],
                                                      'type': 'object'}},
     'properties': {'Next': {'description': 'Next returns when a change has '
                                            'occurred to an entity of the\n'
                                            'collection being watched since the '
                                            'most recent call to Next\n'
                                            'or the Watch call that created the '
                                            'srvMachineStorageIdsWatcher.',
                             'properties': {'Result': {'$ref': '#/definitions/MachineStorageIdsWatchResult'}},
                             'type': 'object'},
                    'Stop': {'description': 'Stop stops the watcher.',
                             'type': 'object'}},
     'type': 'object'}
    

    @ReturnMapping(MachineStorageIdsWatchResult)
    async def Next(self):
        '''
        Next returns when a change has occurred to an entity of the
        collection being watched since the most recent call to Next
        or the Watch call that created the srvMachineStorageIdsWatcher.


        Returns -> MachineStorageIdsWatchResult
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='VolumeAttachmentPlansWatcher',
                   request='Next',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply



    @ReturnMapping(None)
    async def Stop(self):
        '''
        Stop stops the watcher.


        Returns -> None
        '''

        # map input types to rpc msg
        _params = dict()
        msg = dict(type='VolumeAttachmentPlansWatcher',
                   request='Stop',
                   version=1,
                   params=_params)

        reply = await self.rpc(msg)
        return reply


