# ATTENTION
# This file was generated by tools/generate_stubs.py
from __future__ import annotations
from pathlib import Path
import typing
import numpy
from ..typing import MetaDataMap, VariableLike
_Shape = typing.Tuple[int, ...]

__all__ = [
    "BinEdgeError",
    "BinnedDataError",
    "CoordError",
    "Coords",
    "Coords_items_view",
    "Coords_keys_view",
    "Coords_values_view",
    "DType",
    "DTypeError",
    "DataArray",
    "DataArrayError",
    "Dataset",
    "DatasetError",
    "Dataset_items_view",
    "Dataset_keys_view",
    "Dataset_values_view",
    "DefaultUnit",
    "DimensionError",
    "ElementArrayView_DataArray",
    "ElementArrayView_DataArray_const",
    "ElementArrayView_Dataset",
    "ElementArrayView_Dataset_const",
    "ElementArrayView_Eigen_Matrix3d",
    "ElementArrayView_Eigen_Matrix3d_const",
    "ElementArrayView_Eigen_Vector3d",
    "ElementArrayView_Eigen_Vector3d_const",
    "ElementArrayView_PyObject",
    "ElementArrayView_PyObject_const",
    "ElementArrayView_Variable",
    "ElementArrayView_Variable_const",
    "ElementArrayView_bin_DataArray",
    "ElementArrayView_bin_DataArray_const",
    "ElementArrayView_bin_Dataset",
    "ElementArrayView_bin_Dataset_const",
    "ElementArrayView_bin_Variable",
    "ElementArrayView_bin_Variable_const",
    "ElementArrayView_bool",
    "ElementArrayView_bool_const",
    "ElementArrayView_double",
    "ElementArrayView_double_const",
    "ElementArrayView_float",
    "ElementArrayView_float_const",
    "ElementArrayView_int32",
    "ElementArrayView_int32_const",
    "ElementArrayView_int64",
    "ElementArrayView_int64_const",
    "ElementArrayView_string",
    "ElementArrayView_string_const",
    "GroupByDataArray",
    "GroupByDataset",
    "Masks",
    "Masks_items_view",
    "Masks_keys_view",
    "Masks_values_view",
    "Slice",
    "Unit",
    "UnitError",
    "Variable",
    "VariableError",
    "VariancesError"
]
class BinEdgeError(RuntimeError, Exception, BaseException):
    """
    Inappropriate bin-edge coordinate.
    """
    pass
class BinnedDataError(RuntimeError, Exception, BaseException):
    """
    Incorrect use of binned data.
    """
    pass
class CoordError(RuntimeError, Exception, BaseException):
    """
    Bad coordinate values or mismatching coordinates.
    """
    pass
class Coords():
    """
    dict-like collection of meta data

    Returned by :py:func:`DataArray.coords`, :py:func:`DataArray.attrs`, :py:func:`DataArray.meta`,
    and the corresponding properties of :py:class:`Dataset`.
    """
    def __contains__(self, arg0: str) -> bool: ...
    def __delitem__(self, arg0: str) -> None: ...
    def __eq__(self, arg0: Coords) -> bool: ...
    def __getitem__(self, arg0: str) -> Variable: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: Coords) -> bool: ...
    def __setitem__(self, arg0: str, arg1: Variable) -> None: ...
    def _ipython_key_completions_(self) -> list: ...
    def _pop(self, k: str) -> object: ...
    def is_edges(self, key: str, dim: typing.Optional[str] = None) -> bool: 
        """
        Return True if the given key contains bin-edges in the given dim.
        """
    def items(self) -> Coords_items_view: 
        """
        view on self's items
        """
    def keys(self) -> Coords_keys_view: 
        """
        view on self's keys
        """
    def update(self, other: object = None, /, **kwargs) -> None: 
        """
        Update items from dict-like or iterable.

        If ``other`` has a .keys() method, then update does:
        ``for k in other.keys(): self[k] = other[k]``.

        If ``other`` is given but does not have a .keys() method, then update does:
        ``for k, v in other: self[k] = v``.

        In either case, this is followed by:
        ``for k in kwargs: self[k] = kwargs[k]``.

        See Also
        --------
        dict.update
        """
    def values(self) -> Coords_values_view: 
        """
        view on self's values
        """
    __hash__ = None
    pass
    def get(self, key, default=None): ...
    def pop(self, key, default=NotSpecified): ...
class Coords_items_view():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    pass
class Coords_keys_view():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    pass
class Coords_values_view():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    pass
class DType():
    """
    Representation of a data type of a Variable in scipp.
    See https://scipp.github.io/reference/dtype.html for details.

    The data types ``VariableView``, ``DataArrayView``, and ``DatasetView`` are used for
    objects containing binned data. They cannot be used directly to create arrays of bins.
    """
    def __eq__(self, arg0: object) -> bool: ...
    def __init__(self, arg0: object) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...
    DataArray: DType # value = DType('DataArray')
    DataArrayView: DType # value = DType('DataArrayView')
    Dataset: DType # value = DType('Dataset')
    DatasetView: DType # value = DType('DatasetView')
    PyObject: DType # value = DType('PyObject')
    Variable: DType # value = DType('Variable')
    VariableView: DType # value = DType('VariableView')
    __hash__ = None
    affine_transform3: DType # value = DType('affine_transform3')
    bool: DType # value = DType('bool')
    datetime64: DType # value = DType('datetime64')
    float32: DType # value = DType('float32')
    float64: DType # value = DType('float64')
    int32: DType # value = DType('int32')
    int64: DType # value = DType('int64')
    linear_transform3: DType # value = DType('linear_transform3')
    rotation3: DType # value = DType('rotation3')
    string: DType # value = DType('string')
    translation3: DType # value = DType('translation3')
    vector3: DType # value = DType('vector3')
    pass
class DTypeError(TypeError, Exception, BaseException):
    """
    Inappropriate dtype.
    """
    pass
class DataArray():
    """
    Named variable with associated coords, masks, and attributes.
    """
    def __abs__(self) -> DataArray: ...
    @staticmethod
    @typing.overload
    def __add__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __add__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __add__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __add__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __add__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __and__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __and__(self, arg0: Variable) -> DataArray: ...
    def __bool__(self) -> None: ...
    def __copy__(self) -> DataArray: 
        """
        Return a (shallow) copy.
        """
    def __deepcopy__(self, arg0: dict) -> DataArray: 
        """
        Return a (deep) copy.
        """
    @typing.overload
    def __eq__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __eq__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __floordiv__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __floordiv__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __floordiv__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __floordiv__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __ge__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __ge__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: ellipsis) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: slice) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: typing.List[int]) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, Variable]) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, int]) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, slice]) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, typing.List[int]]) -> DataArray: ...
    @typing.overload
    def __gt__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __gt__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __iadd__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __iadd__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __iadd__(self, arg0: float) -> object: ...
    @typing.overload
    def __iadd__(self, arg0: int) -> object: ...
    @typing.overload
    def __iand__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __iand__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __imod__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __imod__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __imod__(self, arg0: float) -> object: ...
    @typing.overload
    def __imod__(self, arg0: int) -> object: ...
    @typing.overload
    def __imul__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __imul__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __imul__(self, arg0: float) -> object: ...
    @typing.overload
    def __imul__(self, arg0: int) -> object: ...
    def __init__(self, data: Variable, coords: typing.Union[typing.Mapping[str, Variable], typing.Iterable[typing.Tuple[str, Variable]]] = {}, masks: typing.Union[typing.Mapping[str, Variable], typing.Iterable[typing.Tuple[str, Variable]]] = {}, attrs: typing.Union[typing.Mapping[str, Variable], typing.Iterable[typing.Tuple[str, Variable]]] = {}, name: str = '') -> None: 
        """
        DataArray initializer.

        Parameters
        ----------
        data:
            Data and optionally variances.
        coords:
            Coordinates referenced by dimension.
        masks:
            Masks referenced by name.
        attrs:
            Attributes referenced by dimension.
        name:
            Name of the data array.
        """
    def __invert__(self) -> DataArray: ...
    @typing.overload
    def __ior__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __ior__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __isub__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __isub__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __isub__(self, arg0: float) -> object: ...
    @typing.overload
    def __isub__(self, arg0: int) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: float) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: int) -> object: ...
    @typing.overload
    def __ixor__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __ixor__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __le__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __le__(self, arg0: Variable) -> DataArray: ...
    def __len__(self) -> int: ...
    @typing.overload
    def __lt__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __lt__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __mod__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __mod__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __mod__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __mod__(self, arg0: int) -> DataArray: ...
    @staticmethod
    @typing.overload
    def __mul__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __mul__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __mul__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __mul__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __mul__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __ne__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __ne__(self, arg0: Variable) -> DataArray: ...
    def __neg__(self) -> DataArray: ...
    @typing.overload
    def __or__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __or__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __pow__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __pow__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __pow__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __pow__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __radd__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __radd__(self, arg0: int) -> DataArray: ...
    def __repr__(self) -> str: ...
    @typing.overload
    def __rfloordiv__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __rfloordiv__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __rmod__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __rmod__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __rmul__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __rmul__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __rpow__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __rpow__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __rsub__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __rsub__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __rtruediv__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __rtruediv__(self, arg0: int) -> DataArray: ...
    @staticmethod
    @typing.overload
    def __setitem__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __setitem__(self, arg0: ellipsis, arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: int, arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: slice, arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: typing.Tuple[str, int], arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: typing.Tuple[str, slice], arg1: object) -> None: ...
    @staticmethod
    @typing.overload
    def __sub__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __sub__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __sub__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __sub__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __sub__(self, arg0: int) -> DataArray: ...
    @staticmethod
    @typing.overload
    def __truediv__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __truediv__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __truediv__(self, arg0: Variable) -> DataArray: ...
    @typing.overload
    def __truediv__(self, arg0: float) -> DataArray: ...
    @typing.overload
    def __truediv__(self, arg0: int) -> DataArray: ...
    @typing.overload
    def __xor__(self, arg0: DataArray) -> DataArray: ...
    @typing.overload
    def __xor__(self, arg0: Variable) -> DataArray: ...
    def _ipython_key_completions_(self) -> list: ...
    def astype(self, type: object, *, copy: bool = True) -> DataArray: 
        """
        Converts a Variable or DataArray to a different dtype.

        If the dtype is unchanged and ``copy`` is `False`, the object
        is returned without making a deep copy.

        :param type: Target dtype.
        :param copy: If `False`, return the input object if possible.
                     If `True`, the function always returns a new object.
        :raises: If the data cannot be converted to the requested dtype.
        :return: New variable or data array with specified dtype.
        :rtype: Union[scipp.Variable, scipp.DataArray]
        """
    def copy(self, deep: bool = True) -> DataArray: 
        """
        Return a (by default deep) copy.

        If `deep=True` (the default), a deep copy is made. Otherwise, a shallow
        copy is made, and the returned data (and meta data) values are new views
        of the data and meta data values of this object.
        """
    def rename_dims(self, dims_dict: typing.Dict[str, str], /) -> DataArray: 
        """
        Rename dimensions.
        """
    def underlying_size(self) -> int: ...
    @property
    def attrs(self) -> Coords:
        """
        Dict of attrs.

        :type: Coords
        """
    @property
    def bins(self) -> None:
        """
            Returns helper :py:class:`scipp.Bins` allowing bin-wise operations
            to be performed or `None` if not binned data.
            

        :type: None
        """
    @property
    def coords(self) -> Coords:
        """
        Dict of aligned coords.

        :type: Coords
        """
    @property
    def data(self) -> Variable:
        """
        Underlying data item.

        :type: Variable
        """
    @data.setter
    def data(self, arg1: Variable) -> None:
        """
        Underlying data item.
        """
    @property
    def dim(self) -> str:
        """
        The only dimension label for 1-dimensional data, raising an exception if the data is not 1-dimensional.

        :type: str
        """
    @property
    def dims(self) -> tuple:
        """
        Dimension labels of the data (read-only).

        :type: tuple
        """
    @property
    def dtype(self) -> DType:
        """
        Data type contained in the variable.

        :type: DType
        """
    @property
    def masks(self) -> Masks:
        """
        Dict of masks.

        :type: Masks
        """
    @property
    def meta(self) -> Coords:
        """
        Dict of coords and attrs.

        :type: Coords
        """
    @property
    def name(self) -> str:
        """
        The name of the held data.

        :type: str
        """
    @name.setter
    def name(self, arg1: str) -> None:
        """
        The name of the held data.
        """
    @property
    def ndim(self) -> int:
        """
        Number of dimensions of the data (read-only).

        :type: int
        """
    @property
    def shape(self) -> tuple:
        """
        Shape of the data (read-only).

        :type: tuple
        """
    @property
    def sizes(self) -> dict:
        """
        dict mapping dimension labels to dimension sizes (read-only).

        :type: dict
        """
    @property
    def unit(self) -> object:
        """
        Physical unit of the data.

        :type: object
        """
    @unit.setter
    def unit(self, arg1: typing.Union[str, Unit, None, DefaultUnit]) -> None:
        """
        Physical unit of the data.
        """
    @property
    def value(self) -> object:
        """
        The only value for 0-dimensional data, raising an exception if the data is not 0-dimensional.

        :type: object
        """
    @value.setter
    def value(self, arg1: object) -> None:
        """
        The only value for 0-dimensional data, raising an exception if the data is not 0-dimensional.
        """
    @property
    def values(self) -> object:
        """
        Array of values of the data.

        :type: object
        """
    @values.setter
    def values(self, arg1: object) -> None:
        """
        Array of values of the data.
        """
    @property
    def variance(self) -> object:
        """
        The only variance for 0-dimensional data, raising an exception if the data is not 0-dimensional.

        :type: object
        """
    @variance.setter
    def variance(self, arg1: object) -> None:
        """
        The only variance for 0-dimensional data, raising an exception if the data is not 0-dimensional.
        """
    @property
    def variances(self) -> object:
        """
        Array of variances of the data.

        :type: object
        """
    @variances.setter
    def variances(self, arg1: object) -> None:
        """
        Array of variances of the data.
        """
    __array_ufunc__ = None
    __hash__ = None
    pass
    def all(self, dim: 'typing.Optional[str]' = None) -> 'Variable': ...
    def any(self, dim: 'typing.Optional[str]' = None) -> 'Variable': ...
    def broadcast(self, dims: typing.Union[typing.List[str], typing.Tuple[str, ...], None] = None, shape: typing.Union[typing.Sequence[int], None] = None, sizes: typing.Union[typing.Dict[str, int], None] = None) -> ~VariableLikeType: ...
    def ceil(self, *, out: 'typing.Optional[VariableLike]' = None) -> 'VariableLike': ...
    def flatten(self, dims: typing.Union[typing.List[str], typing.Tuple[str, ...], None] = None, to: typing.Union[str, None] = None) -> ~VariableLikeType: ...
    def floor(self, *, out: 'typing.Optional[VariableLike]' = None) -> 'VariableLike': ...
    def fold(self, dim: str, sizes: typing.Union[typing.Dict[str, int], None] = None, dims: typing.Union[typing.List[str], typing.Tuple[str, ...], None] = None, shape: typing.Union[typing.Sequence[int], None] = None) -> ~VariableLikeType: ...
    def groupby(self, /, group: typing.Union[Variable, str], *, bins: typing.Union[Variable, None] = None) -> typing.Union[GroupByDataArray, GroupByDataset]: ...
    def mean(self, dim: 'typing.Optional[str]' = None) -> 'VariableLikeType': ...
    def nanmean(self, dim: 'typing.Optional[str]' = None) -> 'VariableLikeType': ...
    def nansum(self, dim: 'typing.Optional[str]' = None) -> 'VariableLikeType': ...
    def plot(*args, **kwargs): ...
    def rename(self, dims_dict: typing.Dict[str, str] = None, /, **names: str) -> DataArray: ...
    def round(self, *, out: 'typing.Optional[VariableLike]' = None) -> 'VariableLike': ...
    def squeeze(self, dim: typing.Union[str, typing.List[str], typing.Tuple[str, ...], None] = None) -> ~VariableLikeType: ...
    def sum(self, dim: 'typing.Optional[str]' = None) -> 'VariableLikeType': ...
    def to(self, *, unit: 'typing.Optional[typing.Union[Unit, str]]' = None, dtype: 'typing.Optional[Any]' = None, copy: 'bool' = True) -> 'VariableLikeType': ...
    def to_hdf5(self, filename: 'typing.Union[str, Path]'): ...
    def transform_coords(self, targets: typing.Union[str, typing.Iterable[str]], graph: typing.Dict[typing.Union[str, typing.Tuple[str, ...]], typing.Union[str, typing.Callable]], *, rename_dims: bool = True, keep_aliases: bool = True, keep_intermediate: bool = True, keep_inputs: bool = True, quiet: bool = False) -> typing.Union[DataArray, Dataset]: ...
    def transpose(self, dims: typing.Union[typing.List[str], typing.Tuple[str, ...], None] = None) -> ~VariableLikeType: ...
class DataArrayError(RuntimeError, Exception, BaseException):
    """
    Incorrect use of scipp.DataArray.
    """
    pass
class Dataset():
    """
    Dict of data arrays with aligned dimensions.
    """
    def __abs__(self) -> Dataset: ...
    @typing.overload
    def __add__(self, arg0: DataArray) -> Dataset: ...
    @typing.overload
    def __add__(self, arg0: Dataset) -> Dataset: ...
    @typing.overload
    def __add__(self, arg0: Variable) -> Dataset: ...
    def __bool__(self) -> None: ...
    def __contains__(self, arg0: str) -> bool: ...
    def __copy__(self) -> Dataset: 
        """
        Return a (shallow) copy.
        """
    def __deepcopy__(self, arg0: dict) -> Dataset: 
        """
        Return a (deep) copy.
        """
    def __delitem__(self, arg0: str) -> None: ...
    @typing.overload
    def __getitem__(self, arg0: Variable) -> Dataset: ...
    @typing.overload
    def __getitem__(self, arg0: ellipsis) -> Dataset: ...
    @typing.overload
    def __getitem__(self, arg0: int) -> Dataset: ...
    @typing.overload
    def __getitem__(self, arg0: slice) -> Dataset: ...
    @typing.overload
    def __getitem__(self, arg0: str) -> DataArray: ...
    @typing.overload
    def __getitem__(self, arg0: typing.List[int]) -> Dataset: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, Variable]) -> Dataset: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, int]) -> Dataset: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, slice]) -> Dataset: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, typing.List[int]]) -> Dataset: ...
    @typing.overload
    def __iadd__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __iadd__(self, arg0: Dataset) -> object: ...
    @typing.overload
    def __iadd__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __iadd__(self, arg0: float) -> object: ...
    @typing.overload
    def __iadd__(self, arg0: int) -> object: ...
    @typing.overload
    def __imul__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __imul__(self, arg0: Dataset) -> object: ...
    @typing.overload
    def __imul__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __imul__(self, arg0: float) -> object: ...
    @typing.overload
    def __imul__(self, arg0: int) -> object: ...
    def __init__(self, data: typing.Union[typing.Mapping[str, typing.Union[Variable, DataArray]], typing.Iterable[typing.Tuple[str, typing.Union[Variable, DataArray]]]] = {}, coords: typing.Union[typing.Mapping[str, Variable], typing.Iterable[typing.Tuple[str, Variable]]] = {}) -> None: 
        """
        Dataset initializer.

        Parameters
        ----------
        data:
            Dictionary of name and data pairs.
        coords:
            Dictionary of name and coord pairs.
        """
    @typing.overload
    def __isub__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __isub__(self, arg0: Dataset) -> object: ...
    @typing.overload
    def __isub__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __isub__(self, arg0: float) -> object: ...
    @typing.overload
    def __isub__(self, arg0: int) -> object: ...
    def __iter__(self) -> typing.Iterator: ...
    @typing.overload
    def __itruediv__(self, arg0: DataArray) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: Dataset) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: float) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: int) -> object: ...
    def __len__(self) -> int: ...
    @typing.overload
    def __mul__(self, arg0: DataArray) -> Dataset: ...
    @typing.overload
    def __mul__(self, arg0: Dataset) -> Dataset: ...
    @typing.overload
    def __mul__(self, arg0: Variable) -> Dataset: ...
    def __repr__(self) -> str: ...
    @staticmethod
    @typing.overload
    def __setitem__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __setitem__(self, arg0: ellipsis, arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: int, arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: slice, arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: str, arg1: DataArray) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: str, arg1: Variable) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: typing.Tuple[str, int], arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: typing.Tuple[str, slice], arg1: object) -> None: ...
    @typing.overload
    def __sub__(self, arg0: DataArray) -> Dataset: ...
    @typing.overload
    def __sub__(self, arg0: Dataset) -> Dataset: ...
    @typing.overload
    def __sub__(self, arg0: Variable) -> Dataset: ...
    @typing.overload
    def __truediv__(self, arg0: DataArray) -> Dataset: ...
    @typing.overload
    def __truediv__(self, arg0: Dataset) -> Dataset: ...
    @typing.overload
    def __truediv__(self, arg0: Variable) -> Dataset: ...
    def _ipython_key_completions_(self) -> list: ...
    def _pop(self, k: str) -> object: ...
    def clear(self) -> None: 
        """
        Removes all data, preserving coordinates.
        """
    def copy(self, deep: bool = True) -> Dataset: 
        """
        Return a (by default deep) copy.

        If `deep=True` (the default), a deep copy is made. Otherwise, a shallow
        copy is made, and the returned data (and meta data) values are new views
        of the data and meta data values of this object.
        """
    def items(self) -> Dataset_items_view: 
        """
        view on self's items
        """
    def keys(self) -> Dataset_keys_view: 
        """
        view on self's keys
        """
    def rename_dims(self, dims_dict: typing.Dict[str, str], /) -> Dataset: 
        """
        Rename dimensions.
        """
    def underlying_size(self) -> int: ...
    def update(self, other: object = None, /, **kwargs) -> None: 
        """
        Update items from dict-like or iterable.

        If ``other`` has a .keys() method, then update does:
        ``for k in other.keys(): self[k] = other[k]``.

        If ``other`` is given but does not have a .keys() method, then update does:
        ``for k, v in other: self[k] = v``.

        In either case, this is followed by:
        ``for k in kwargs: self[k] = kwargs[k]``.

        See Also
        --------
        dict.update
        """
    def values(self) -> Dataset_values_view: 
        """
        view on self's values
        """
    @property
    def bins(self) -> None:
        """
            Returns helper :py:class:`scipp.Bins` allowing bin-wise operations
            to be performed or `None` if not binned data.
            

        :type: None
        """
    @property
    def coords(self) -> Coords:
        """
              Dict of coordinates.

        :type: Coords
        """
    @property
    def dim(self) -> str:
        """
        The only dimension label for 1-dimensional data, raising an exception if the data is not 1-dimensional.

        :type: str
        """
    @property
    def dims(self) -> tuple:
        """
        Dimension labels of the data (read-only).

        :type: tuple
        """
    @property
    def meta(self) -> Coords:
        """
              Dict of coordinates.

        :type: Coords
        """
    @property
    def ndim(self) -> int:
        """
        Number of dimensions of the data (read-only).

        :type: int
        """
    @property
    def shape(self) -> tuple:
        """
        Shape of the data (read-only).

        :type: tuple
        """
    @property
    def sizes(self) -> dict:
        """
        dict mapping dimension labels to dimension sizes (read-only).

        :type: dict
        """
    __array_ufunc__ = None
    pass
    def get(self, key, default=None): ...
    def groupby(self, /, group: typing.Union[Variable, str], *, bins: typing.Union[Variable, None] = None) -> typing.Union[GroupByDataArray, GroupByDataset]: ...
    def plot(*args, **kwargs): ...
    def pop(self, key, default=NotSpecified): ...
    def rename(self, dims_dict: typing.Dict[str, str] = None, /, **names: str) -> Dataset: ...
    def squeeze(self, dim: typing.Union[str, typing.List[str], typing.Tuple[str, ...], None] = None) -> ~VariableLikeType: ...
    def to_hdf5(self, filename: 'typing.Union[str, Path]'): ...
    def transform_coords(self, targets: typing.Union[str, typing.Iterable[str]], graph: typing.Dict[typing.Union[str, typing.Tuple[str, ...]], typing.Union[str, typing.Callable]], *, rename_dims: bool = True, keep_aliases: bool = True, keep_intermediate: bool = True, keep_inputs: bool = True, quiet: bool = False) -> typing.Union[DataArray, Dataset]: ...
class DatasetError(RuntimeError, Exception, BaseException):
    """
    Incorrect use of scipp.Dataset.
    """
    pass
class Dataset_items_view():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    pass
class Dataset_keys_view():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    pass
class Dataset_values_view():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    pass
class DefaultUnit():
    def __repr__(self) -> str: ...
    pass
class DimensionError(RuntimeError, Exception, BaseException):
    """
    Inappropriate dimension labels and/or shape.
    """
    pass
class ElementArrayView_DataArray():
    def __getitem__(self, arg0: int) -> DataArray: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: DataArray) -> None: ...
    pass
class ElementArrayView_DataArray_const():
    def __getitem__(self, arg0: int) -> DataArray: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: DataArray) -> None: ...
    pass
class ElementArrayView_Dataset():
    def __getitem__(self, arg0: int) -> Dataset: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: Dataset) -> None: ...
    pass
class ElementArrayView_Dataset_const():
    def __getitem__(self, arg0: int) -> Dataset: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: Dataset) -> None: ...
    pass
class ElementArrayView_Eigen_Matrix3d():
    def __getitem__(self, arg0: int) -> numpy.ndarray[numpy.float64, _Shape[3, 3]]: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: numpy.ndarray[numpy.float64, _Shape[3, 3]]) -> None: ...
    pass
class ElementArrayView_Eigen_Matrix3d_const():
    def __getitem__(self, arg0: int) -> numpy.ndarray[numpy.float64, _Shape[3, 3]]: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: numpy.ndarray[numpy.float64, _Shape[3, 3]]) -> None: ...
    pass
class ElementArrayView_Eigen_Vector3d():
    def __getitem__(self, arg0: int) -> numpy.ndarray[numpy.float64, _Shape[3, 1]]: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: numpy.ndarray[numpy.float64, _Shape[3, 1]]) -> None: ...
    pass
class ElementArrayView_Eigen_Vector3d_const():
    def __getitem__(self, arg0: int) -> numpy.ndarray[numpy.float64, _Shape[3, 1]]: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: numpy.ndarray[numpy.float64, _Shape[3, 1]]) -> None: ...
    pass
class ElementArrayView_PyObject():
    def __getitem__(self, arg0: int) -> object: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: object) -> None: ...
    pass
class ElementArrayView_PyObject_const():
    def __getitem__(self, arg0: int) -> object: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: object) -> None: ...
    pass
class ElementArrayView_Variable():
    def __getitem__(self, arg0: int) -> Variable: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: Variable) -> None: ...
    pass
class ElementArrayView_Variable_const():
    def __getitem__(self, arg0: int) -> Variable: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: Variable) -> None: ...
    pass
class ElementArrayView_bin_DataArray():
    def __getitem__(self, arg0: int) -> DataArray: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def __setitem__(*args, **kwargs) -> typing.Any: ...
    pass
class ElementArrayView_bin_DataArray_const():
    def __getitem__(self, arg0: int) -> DataArray: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def __setitem__(*args, **kwargs) -> typing.Any: ...
    pass
class ElementArrayView_bin_Dataset():
    def __getitem__(self, arg0: int) -> Dataset: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def __setitem__(*args, **kwargs) -> typing.Any: ...
    pass
class ElementArrayView_bin_Dataset_const():
    def __getitem__(self, arg0: int) -> Dataset: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def __setitem__(*args, **kwargs) -> typing.Any: ...
    pass
class ElementArrayView_bin_Variable():
    def __getitem__(self, arg0: int) -> Variable: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def __setitem__(*args, **kwargs) -> typing.Any: ...
    pass
class ElementArrayView_bin_Variable_const():
    def __getitem__(self, arg0: int) -> Variable: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def __setitem__(*args, **kwargs) -> typing.Any: ...
    pass
class ElementArrayView_bool():
    def __getitem__(self, arg0: int) -> bool: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: bool) -> None: ...
    pass
class ElementArrayView_bool_const():
    def __getitem__(self, arg0: int) -> bool: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: bool) -> None: ...
    pass
class ElementArrayView_double():
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: float) -> None: ...
    pass
class ElementArrayView_double_const():
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: float) -> None: ...
    pass
class ElementArrayView_float():
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: float) -> None: ...
    pass
class ElementArrayView_float_const():
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: float) -> None: ...
    pass
class ElementArrayView_int32():
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    pass
class ElementArrayView_int32_const():
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    pass
class ElementArrayView_int64():
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    pass
class ElementArrayView_int64_const():
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    pass
class ElementArrayView_string():
    def __getitem__(self, arg0: int) -> str: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: str) -> None: ...
    pass
class ElementArrayView_string_const():
    def __getitem__(self, arg0: int) -> str: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __setitem__(self, arg0: int, arg1: str) -> None: ...
    pass
class GroupByDataArray():
    """
    GroupBy object implementing split-apply-combine mechanism.
    """
    def all(self, dim: str) -> DataArray: 
        """
        Element-wise all over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the all.
        :type dim: Dim
        :return: The computed all over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: DataArray
        """
    def any(self, dim: str) -> DataArray: 
        """
        Element-wise any over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the any.
        :type dim: Dim
        :return: The computed any over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: DataArray
        """
    def concat(self, dim: str) -> DataArray: 
        """
        Element-wise concat over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the concat.
        :type dim: Dim
        :return: The computed concat over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: DataArray
        """
    def copy(self, group: int) -> DataArray: 
        """
        Extract group as new data array or dataset.

        :param group: Index of groupy to extract
        :type group: 
        :rtype: DataArray
        """
    def max(self, dim: str) -> DataArray: 
        """
        Element-wise max over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the max.
        :type dim: Dim
        :return: The computed max over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: DataArray
        """
    def mean(self, dim: str) -> DataArray: 
        """
        Element-wise mean over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the mean.
        :type dim: Dim
        :return: The computed mean over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: DataArray
        """
    def min(self, dim: str) -> DataArray: 
        """
        Element-wise min over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the min.
        :type dim: Dim
        :return: The computed min over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: DataArray
        """
    def sum(self, dim: str) -> DataArray: 
        """
        Element-wise sum over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the sum.
        :type dim: Dim
        :return: The computed sum over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: DataArray
        """
    @property
    def bins(self) -> None:
        """
        :type: None
        """
    pass
class GroupByDataset():
    """
    GroupBy object implementing split-apply-combine mechanism.
    """
    def all(self, dim: str) -> Dataset: 
        """
        Element-wise all over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the all.
        :type dim: Dim
        :return: The computed all over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: Dataset
        """
    def any(self, dim: str) -> Dataset: 
        """
        Element-wise any over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the any.
        :type dim: Dim
        :return: The computed any over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: Dataset
        """
    def concat(self, dim: str) -> Dataset: 
        """
        Element-wise concat over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the concat.
        :type dim: Dim
        :return: The computed concat over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: Dataset
        """
    def copy(self, group: int) -> Dataset: 
        """
        Extract group as new data array or dataset.

        :param group: Index of groupy to extract
        :type group: 
        :rtype: Dataset
        """
    def max(self, dim: str) -> Dataset: 
        """
        Element-wise max over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the max.
        :type dim: Dim
        :return: The computed max over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: Dataset
        """
    def mean(self, dim: str) -> Dataset: 
        """
        Element-wise mean over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the mean.
        :type dim: Dim
        :return: The computed mean over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: Dataset
        """
    def min(self, dim: str) -> Dataset: 
        """
        Element-wise min over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the min.
        :type dim: Dim
        :return: The computed min over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: Dataset
        """
    def sum(self, dim: str) -> Dataset: 
        """
        Element-wise sum over the specified dimension within a group.

        :param dim: Dimension to reduce when computing the sum.
        :type dim: Dim
        :return: The computed sum over each group, combined along the dimension specified when calling :py:func:`scipp.groupby`.
        :rtype: Dataset
        """
    @property
    def bins(self) -> None:
        """
        :type: None
        """
    pass
class Masks():
    """
    dict-like collection of masks.

    Returned by :py:func:`DataArray.masks`
    """
    def __contains__(self, arg0: str) -> bool: ...
    def __delitem__(self, arg0: str) -> None: ...
    def __eq__(self, arg0: Masks) -> bool: ...
    def __getitem__(self, arg0: str) -> Variable: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: Masks) -> bool: ...
    def __setitem__(self, arg0: str, arg1: Variable) -> None: ...
    def _ipython_key_completions_(self) -> list: ...
    def _pop(self, k: str) -> object: ...
    def is_edges(self, key: str, dim: typing.Optional[str] = None) -> bool: 
        """
        Return True if the given key contains bin-edges in the given dim.
        """
    def items(self) -> Masks_items_view: 
        """
        view on self's items
        """
    def keys(self) -> Masks_keys_view: 
        """
        view on self's keys
        """
    def update(self, other: object = None, /, **kwargs) -> None: 
        """
        Update items from dict-like or iterable.

        If ``other`` has a .keys() method, then update does:
        ``for k in other.keys(): self[k] = other[k]``.

        If ``other`` is given but does not have a .keys() method, then update does:
        ``for k, v in other: self[k] = v``.

        In either case, this is followed by:
        ``for k in kwargs: self[k] = kwargs[k]``.

        See Also
        --------
        dict.update
        """
    def values(self) -> Masks_values_view: 
        """
        view on self's values
        """
    __hash__ = None
    pass
    def get(self, key, default=None): ...
    def pop(self, key, default=NotSpecified): ...
class Masks_items_view():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    pass
class Masks_keys_view():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    pass
class Masks_values_view():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    pass
class Slice():
    pass
class Unit():
    """
    A physical unit.
    """
    def __add__(self, arg0: Unit) -> Unit: ...
    def __eq__(self, arg0: Unit) -> bool: ...
    def __hash__(self) -> int: ...
    def __init__(self, arg0: str) -> None: ...
    def __mul__(self, arg0: Unit) -> Unit: ...
    def __ne__(self, arg0: Unit) -> bool: ...
    def __pow__(self, arg0: int) -> Unit: ...
    def __repr__(self) -> str: ...
    def __sub__(self, arg0: Unit) -> Unit: ...
    def __truediv__(self, arg0: Unit) -> Unit: ...
    @property
    def name(self) -> str:
        """
        A read-only string describing the type of unit.

        :type: str
        """
    __array_ufunc__ = None
    pass
class UnitError(RuntimeError, Exception, BaseException):
    """
    Inappropriate unit.
    """
    pass
class Variable():
    """
    Array of values with dimension labels and a unit, optionally including an array
    of variances.
    """
    def __abs__(self) -> Variable: ...
    @staticmethod
    @typing.overload
    def __add__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __add__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __add__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __add__(self, arg0: int) -> Variable: ...
    def __and__(self, arg0: Variable) -> Variable: ...
    def __bool__(self) -> None: ...
    def __copy__(self) -> Variable: 
        """
        Return a (shallow) copy.
        """
    def __deepcopy__(self, arg0: dict) -> Variable: 
        """
        Return a (deep) copy.
        """
    @typing.overload
    def __eq__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __eq__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __eq__(self, arg0: int) -> Variable: ...
    @staticmethod
    @typing.overload
    def __floordiv__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __floordiv__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __floordiv__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __floordiv__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __ge__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __ge__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __ge__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __getitem__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __getitem__(self, arg0: ellipsis) -> Variable: ...
    @typing.overload
    def __getitem__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __getitem__(self, arg0: slice) -> Variable: ...
    @typing.overload
    def __getitem__(self, arg0: typing.List[int]) -> Variable: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, int]) -> Variable: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, slice]) -> Variable: ...
    @typing.overload
    def __getitem__(self, arg0: typing.Tuple[str, typing.List[int]]) -> Variable: ...
    @typing.overload
    def __gt__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __gt__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __gt__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __iadd__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __iadd__(self, arg0: float) -> object: ...
    @typing.overload
    def __iadd__(self, arg0: int) -> object: ...
    def __iand__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __imod__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __imod__(self, arg0: float) -> object: ...
    @typing.overload
    def __imod__(self, arg0: int) -> object: ...
    @typing.overload
    def __imul__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __imul__(self, arg0: float) -> object: ...
    @typing.overload
    def __imul__(self, arg0: int) -> object: ...
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: 
        """
        Initialize a variable with values and/or variances.

        At least one argument of ``values`` and ``variances`` must be used.
        if you want to preallocate memory to fill later, use :py:func:`scipp.empty`.

        Attention
        ---------
        This constructor is meant primarily for internal use.
        Use one of the Specialized
        `creation functions <../../reference/creation-functions.rst>`_ instead.
        See in particular :py:func:`scipp.array` and :py:func:`scipp.scalar`.

        Parameters
        ----------
        dims:
           Dimension labels.
        values:
           Sequence of values for constructing an array variable.
        variances:
           Sequence of variances for constructing an array variable.
        unit:
           Physical unit, defaults to ``scipp.units.dimensionless``.
        dtype:
           Type of the variable's elements. Is deduced from other arguments
           in most cases. Defaults to ``sc.DType.float64`` if no deduction is
           possible.
        """
    def __invert__(self) -> Variable: ...
    def __ior__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __ipow__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __ipow__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __ipow__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __isub__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __isub__(self, arg0: float) -> object: ...
    @typing.overload
    def __isub__(self, arg0: int) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: float) -> object: ...
    @typing.overload
    def __itruediv__(self, arg0: int) -> object: ...
    def __ixor__(self, arg0: Variable) -> object: ...
    @typing.overload
    def __le__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __le__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __le__(self, arg0: int) -> Variable: ...
    def __len__(self) -> int: ...
    @typing.overload
    def __lt__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __lt__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __lt__(self, arg0: int) -> Variable: ...
    @staticmethod
    @typing.overload
    def __mod__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __mod__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __mod__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __mod__(self, arg0: int) -> Variable: ...
    @staticmethod
    @typing.overload
    def __mul__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __mul__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __mul__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __mul__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __ne__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __ne__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __ne__(self, arg0: int) -> Variable: ...
    def __neg__(self) -> Variable: ...
    def __or__(self, arg0: Variable) -> Variable: ...
    @staticmethod
    @typing.overload
    def __pow__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __pow__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __pow__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __pow__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __radd__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __radd__(self, arg0: int) -> Variable: ...
    def __repr__(self) -> str: ...
    @typing.overload
    def __rfloordiv__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __rfloordiv__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __rmod__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __rmod__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __rmul__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __rmul__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __rpow__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __rpow__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __rsub__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __rsub__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __rtruediv__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __rtruediv__(self, arg0: int) -> Variable: ...
    @typing.overload
    def __setitem__(self, arg0: ellipsis, arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: int, arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: slice, arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: typing.Tuple[str, int], arg1: object) -> None: ...
    @typing.overload
    def __setitem__(self, arg0: typing.Tuple[str, slice], arg1: object) -> None: ...
    @staticmethod
    @typing.overload
    def __sub__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __sub__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __sub__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __sub__(self, arg0: int) -> Variable: ...
    @staticmethod
    @typing.overload
    def __truediv__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __truediv__(self, arg0: Variable) -> Variable: ...
    @typing.overload
    def __truediv__(self, arg0: float) -> Variable: ...
    @typing.overload
    def __truediv__(self, arg0: int) -> Variable: ...
    def __xor__(self, arg0: Variable) -> Variable: ...
    def _ipython_key_completions_(self) -> list: ...
    def astype(self, type: object, *, copy: bool = True) -> Variable: 
        """
        Converts a Variable or DataArray to a different dtype.

        If the dtype is unchanged and ``copy`` is `False`, the object
        is returned without making a deep copy.

        :param type: Target dtype.
        :param copy: If `False`, return the input object if possible.
                     If `True`, the function always returns a new object.
        :raises: If the data cannot be converted to the requested dtype.
        :return: New variable or data array with specified dtype.
        :rtype: Union[scipp.Variable, scipp.DataArray]
        """
    def copy(self, deep: bool = True) -> Variable: 
        """
        Return a (by default deep) copy.

        If `deep=True` (the default), a deep copy is made. Otherwise, a shallow
        copy is made, and the returned data (and meta data) values are new views
        of the data and meta data values of this object.
        """
    def rename_dims(self, dims_dict: typing.Dict[str, str], /) -> Variable: 
        """
        Rename dimensions.
        """
    def underlying_size(self) -> int: ...
    @property
    def bins(self) -> None:
        """
            Returns helper :py:class:`scipp.Bins` allowing bin-wise operations
            to be performed or `None` if not binned data.
            

        :type: None
        """
    @property
    def dim(self) -> str:
        """
        The only dimension label for 1-dimensional data, raising an exception if the data is not 1-dimensional.

        :type: str
        """
    @property
    def dims(self) -> tuple:
        """
        Dimension labels of the data (read-only).

        :type: tuple
        """
    @property
    def dtype(self) -> DType:
        """
        Data type contained in the variable.

        :type: DType
        """
    @property
    def fields(self) -> None:
        """
        Provides access to fields of structured types such as vectors or matrices.

        :type: None
        """
    @property
    def ndim(self) -> int:
        """
        Number of dimensions of the data (read-only).

        :type: int
        """
    @property
    def shape(self) -> tuple:
        """
        Shape of the data (read-only).

        :type: tuple
        """
    @property
    def sizes(self) -> dict:
        """
        dict mapping dimension labels to dimension sizes (read-only).

        :type: dict
        """
    @property
    def unit(self) -> object:
        """
        Physical unit of the data.

        :type: object
        """
    @unit.setter
    def unit(self, arg1: typing.Union[str, Unit, None, DefaultUnit]) -> None:
        """
        Physical unit of the data.
        """
    @property
    def value(self) -> object:
        """
        The only value for 0-dimensional data, raising an exception if the data is not 0-dimensional.

        :type: object
        """
    @value.setter
    def value(self, arg1: object) -> None:
        """
        The only value for 0-dimensional data, raising an exception if the data is not 0-dimensional.
        """
    @property
    def values(self) -> object:
        """
        Array of values of the data.

        :type: object
        """
    @values.setter
    def values(self, arg1: object) -> None:
        """
        Array of values of the data.
        """
    @property
    def variance(self) -> object:
        """
        The only variance for 0-dimensional data, raising an exception if the data is not 0-dimensional.

        :type: object
        """
    @variance.setter
    def variance(self, arg1: object) -> None:
        """
        The only variance for 0-dimensional data, raising an exception if the data is not 0-dimensional.
        """
    @property
    def variances(self) -> object:
        """
        Array of variances of the data.

        :type: object
        """
    @variances.setter
    def variances(self, arg1: object) -> None:
        """
        Array of variances of the data.
        """
    __array_ufunc__ = None
    __hash__ = None
    pass
    def all(self, dim: 'typing.Optional[str]' = None) -> 'Variable': ...
    def any(self, dim: 'typing.Optional[str]' = None) -> 'Variable': ...
    def broadcast(self, dims: typing.Union[typing.List[str], typing.Tuple[str, ...], None] = None, shape: typing.Union[typing.Sequence[int], None] = None, sizes: typing.Union[typing.Dict[str, int], None] = None) -> ~VariableLikeType: ...
    def ceil(self, *, out: 'typing.Optional[VariableLike]' = None) -> 'VariableLike': ...
    def cumsum(self, dim: typing.Union[str, None] = None, mode: Literal['exclusive', 'inclusive'] = 'inclusive') -> Variable: ...
    def flatten(self, dims: typing.Union[typing.List[str], typing.Tuple[str, ...], None] = None, to: typing.Union[str, None] = None) -> ~VariableLikeType: ...
    def floor(self, *, out: 'typing.Optional[VariableLike]' = None) -> 'VariableLike': ...
    def fold(self, dim: str, sizes: typing.Union[typing.Dict[str, int], None] = None, dims: typing.Union[typing.List[str], typing.Tuple[str, ...], None] = None, shape: typing.Union[typing.Sequence[int], None] = None) -> ~VariableLikeType: ...
    def max(self, dim: 'typing.Optional[str]' = None) -> 'Variable': ...
    def mean(self, dim: 'typing.Optional[str]' = None) -> 'VariableLikeType': ...
    def min(self, dim: 'typing.Optional[str]' = None) -> 'Variable': ...
    def nanmax(self, dim: 'typing.Optional[str]' = None) -> 'Variable': ...
    def nanmean(self, dim: 'typing.Optional[str]' = None) -> 'VariableLikeType': ...
    def nanmin(self, dim: 'typing.Optional[str]' = None) -> 'Variable': ...
    def nansum(self, dim: 'typing.Optional[str]' = None) -> 'VariableLikeType': ...
    def plot(*args, **kwargs): ...
    def rename(self, dims_dict: typing.Dict[str, str] = None, /, **names: str) -> Variable: ...
    def round(self, *, out: 'typing.Optional[VariableLike]' = None) -> 'VariableLike': ...
    def squeeze(self, dim: typing.Union[str, typing.List[str], typing.Tuple[str, ...], None] = None) -> ~VariableLikeType: ...
    def sum(self, dim: 'typing.Optional[str]' = None) -> 'VariableLikeType': ...
    def to(self, *, unit: 'typing.Optional[typing.Union[Unit, str]]' = None, dtype: 'typing.Optional[Any]' = None, copy: 'bool' = True) -> 'VariableLikeType': ...
    def to_hdf5(self, filename: 'typing.Union[str, Path]'): ...
    def transpose(self, dims: typing.Union[typing.List[str], typing.Tuple[str, ...], None] = None) -> ~VariableLikeType: ...
class VariableError(RuntimeError, Exception, BaseException):
    """
    Incorrect use of scipp.Variable.
    """
    pass
class VariancesError(RuntimeError, Exception, BaseException):
    """
    Variances used where they are not supported or not used where they are required.
    """
    pass