"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
const extensions = require("./extensions");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const stack = new cdk.Stack(app, 'demo-stack');
        // prepare the `modify resonse header` extension
        // const modifyRespHeader = new extensions.ModifyResponseHeader(stack, 'ModifyResp');
        // prepare the `anti-hotlinking` extension
        // const antiHotlinking = new extensions.AntiHotlinking(stack, 'AntiHotlink', {
        //   referer: [
        //     'example.com',
        //     'exa?ple.*',
        //   ],
        // });
        // prepare the security headers extension
        const securityHeaders = new extensions.SecurtyHeaders(stack, 'SecurityHeaders');
        const mulOrgIpRetry = new extensions.MultipleOriginIpRetry(stack, 'MulOrgIpRetry', {
            originIp: ['1.2.3.4'],
            originProtocol: 'https',
        });
        const normQueStr = new extensions.NormalizeQueryString(stack, 'NormalizeQueryString');
        // create the cloudfront distribution with extension(s)
        new _1.Distribution(stack, 'dist', {
            defaultBehavior: {
                origin: new origins.HttpOrigin('aws.amazon.com'),
                edgeLambdas: [
                    // modifyRespHeader,
                    // viewer request
                    //antiHotlinking,
                    // origin response
                    securityHeaders,
                    mulOrgIpRetry,
                    normQueStr,
                ],
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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