"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalDataIngestion = exports.OAuth2AuthorizationCodeGrant = exports.SimpleLambdaEdge = exports.RedirectByGeolocation = exports.AccessOriginByGeolocation = exports.CustomErrorPage = exports.DefaultDirIndex = exports.Custom = exports.NormalizeQueryString = exports.MultipleOriginIpRetry = exports.SecurtyHeaders = exports.AntiHotlinking = exports.ModifyResponseHeader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cf = require("@aws-cdk/aws-cloudfront");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
/**
 * The directory for all extensions lambda assets
 */
const EXTENSION_ASSETS_PATH = path.join(__dirname, '../lambda-assets/extensions');
;
/**
 * The modify response header extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header
 * @stability stable
 */
class ModifyResponseHeader extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.ModifyResponseHeaderFunctionARN').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.ModifyResponseHeader = ModifyResponseHeader;
_a = JSII_RTTI_SYMBOL_1;
ModifyResponseHeader[_a] = { fqn: "cdk-cloudfront-plus.ModifyResponseHeader", version: "0.2.6" };
/**
 * The Anti-Hotlinking extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking
 * @stability stable
 */
class AntiHotlinking extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking',
            semanticVersion: '1.2.5',
            parameters: {
                RefererList: props.referer.join(','),
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AntiHotlinking').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.AntiHotlinking = AntiHotlinking;
_b = JSII_RTTI_SYMBOL_1;
AntiHotlinking[_b] = { fqn: "cdk-cloudfront-plus.AntiHotlinking", version: "0.2.6" };
/**
 * Security Headers extension.
 *
 * @see https://aws.amazon.com/tw/blogs/networking-and-content-delivery/adding-http-security-headers-using-lambdaedge-and-amazon-cloudfront/
 * @stability stable
 */
class SecurtyHeaders extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/add-security-headers',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AddSecurityHeaderFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.SecurtyHeaders = SecurtyHeaders;
_c = JSII_RTTI_SYMBOL_1;
SecurtyHeaders[_c] = { fqn: "cdk-cloudfront-plus.SecurtyHeaders", version: "0.2.6" };
/**
 * Multiple Origin IP Retry extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/multiple-origin-IP-retry
 * @stability stable
 */
class MultipleOriginIpRetry extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/multiple-origin-IP-retry',
            semanticVersion: '1.0.1',
            parameters: {
                OriginIPList: props.originIp.join(';'),
                OriginProtocol: props.originProtocol,
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.MultipleOriginIPRetry').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_REQUEST;
    }
}
exports.MultipleOriginIpRetry = MultipleOriginIpRetry;
_d = JSII_RTTI_SYMBOL_1;
MultipleOriginIpRetry[_d] = { fqn: "cdk-cloudfront-plus.MultipleOriginIpRetry", version: "0.2.6" };
/**
 * Normalize Query String extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/normalize-query-string
 * @stability stable
 */
class NormalizeQueryString extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/normalize-query-string',
            semanticVersion: '1.0.1',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.NormalizeQueryStringFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.NormalizeQueryString = NormalizeQueryString;
_e = JSII_RTTI_SYMBOL_1;
NormalizeQueryString[_e] = { fqn: "cdk-cloudfront-plus.NormalizeQueryString", version: "0.2.6" };
/**
 * Custom extension sample.
 *
 * @stability stable
 */
class Custom extends cdk.NestedStack {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _p, _q, _r, _s, _t, _u, _v;
        super(scope, id, props);
        this.props = props;
        const func = (_p = props === null || props === void 0 ? void 0 : props.func) !== null && _p !== void 0 ? _p : new lambda.Function(this, 'CustomFunc', {
            code: (_q = props === null || props === void 0 ? void 0 : props.code) !== null && _q !== void 0 ? _q : lambda.Code.fromAsset(path.join(__dirname, '../lambda/function')),
            runtime: (_r = props === null || props === void 0 ? void 0 : props.runtime) !== null && _r !== void 0 ? _r : lambda.Runtime.PYTHON_3_8,
            handler: (_s = props === null || props === void 0 ? void 0 : props.handler) !== null && _s !== void 0 ? _s : 'index.lambda_handler',
            timeout: (_t = props === null || props === void 0 ? void 0 : props.timeout) !== null && _t !== void 0 ? _t : cdk.Duration.seconds(5),
        });
        this.functionArn = func.functionArn;
        this.functionVersion = func.currentVersion;
        this.eventType = (_u = props === null || props === void 0 ? void 0 : props.eventType) !== null && _u !== void 0 ? _u : cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
        this.includeBody = (_v = props === null || props === void 0 ? void 0 : props.includeBody) !== null && _v !== void 0 ? _v : false;
        this._addDescription();
        this._outputSolutionId();
    }
    _addDescription() {
        this.templateOptions.description = `(${this.props.solutionId}) ${this.props.templateDescription}`;
    }
    _outputSolutionId() {
        if (this.props.solutionId) {
            new cdk.CfnOutput(this, 'SolutionId', {
                value: this.props.solutionId,
                description: 'Solution ID',
            });
        }
    }
}
exports.Custom = Custom;
_f = JSII_RTTI_SYMBOL_1;
Custom[_f] = { fqn: "cdk-cloudfront-plus.Custom", version: "0.2.6" };
/**
 * Generate a lambda function version from the given function ARN
 * @param scope
 * @param id
 * @param functionArn The lambda function ARN
 * @returns lambda.Version
 */
function bumpFunctionVersion(scope, id, functionArn) {
    return new lambda.Version(scope, `LambdaVersion${id}`, {
        lambda: lambda.Function.fromFunctionArn(scope, `FuncArn${id}`, functionArn),
    });
}
/**
 * Default Directory Indexes in Amazon S3-backed Amazon CloudFront Origins.
 *
 * use case - see https://aws.amazon.com/tw/blogs/compute/implementing-default-directory-indexes-in-amazon-s3-backed-amazon-cloudfront-origins-using-lambdaedge/
 *
 * @stability stable
 */
class DefaultDirIndex extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'DefaultDirIndexFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-default-dir-index/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8134',
            templateDescription: 'Cloudfront extension with AWS CDK - Default Directory Index for Amazon S3 Origin.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.DefaultDirIndex = DefaultDirIndex;
_g = JSII_RTTI_SYMBOL_1;
DefaultDirIndex[_g] = { fqn: "cdk-cloudfront-plus.DefaultDirIndex", version: "0.2.6" };
;
/**
 * Display customized error pages, or mask 4XX error pages, based on where the error originated.
 *
 * use case - see https://aws.amazon.com/blogs/networking-and-content-delivery/customize-403-error-pages-from-amazon-cloudfront-origin-with-lambdaedge/
 *
 * @stability stable
 */
class CustomErrorPage extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            runtime: lambda.Runtime.PYTHON_3_7,
            handler: 'index.handler',
            code: lambda.AssetCode.fromAsset(`${EXTENSION_ASSETS_PATH}/cf-custom-error-page`),
            eventType: cf.LambdaEdgeEventType.ORIGIN_RESPONSE,
            solutionId: 'SO8136',
            templateDescription: 'Cloudfront extension with AWS CDK - Custom Error Page',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.CustomErrorPage = CustomErrorPage;
_h = JSII_RTTI_SYMBOL_1;
CustomErrorPage[_h] = { fqn: "cdk-cloudfront-plus.CustomErrorPage", version: "0.2.6" };
;
/**
 * (SO8118)Access Origin by Geolocation.
 *
 * @stability stable
 */
class AccessOriginByGeolocation extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'AccessOriginByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-access-origin-by-geolocation/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': jsonStringifiedBundlingDefinition(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'S08118',
            templateDescription: 'Cloudfront extension with AWS CDK - Access Origin by Geolocation',
        });
    }
}
exports.AccessOriginByGeolocation = AccessOriginByGeolocation;
_j = JSII_RTTI_SYMBOL_1;
AccessOriginByGeolocation[_j] = { fqn: "cdk-cloudfront-plus.AccessOriginByGeolocation", version: "0.2.6" };
;
/**
 * Forward request to the nearest PoP as per geolocation.
 *
 * @stability stable
 */
class RedirectByGeolocation extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'RedirectByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-redirect-by-geolocation/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': jsonStringifiedBundlingDefinition(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8135',
            templateDescription: 'Cloudfront extension with AWS CDK - Redirect by Geolocation',
        });
    }
}
exports.RedirectByGeolocation = RedirectByGeolocation;
_k = JSII_RTTI_SYMBOL_1;
RedirectByGeolocation[_k] = { fqn: "cdk-cloudfront-plus.RedirectByGeolocation", version: "0.2.6" };
/**
 * Simple content generation.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/simple-lambda-edge
 * @stability stable
 */
class SimpleLambdaEdge extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'SimpleLambdaEdgeFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/simple-lambda-edge/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: '',
            templateDescription: 'Cloudfront extension with AWS CDK - Simple Lambda Edge.',
        });
    }
}
exports.SimpleLambdaEdge = SimpleLambdaEdge;
_l = JSII_RTTI_SYMBOL_1;
SimpleLambdaEdge[_l] = { fqn: "cdk-cloudfront-plus.SimpleLambdaEdge", version: "0.2.6" };
;
function jsonStringifiedBundlingDefinition(value) {
    return JSON.stringify(value)
        .replace(/"/g, '\\"')
        .replace(/,/g, '\\,');
}
/**
 * OAuth2 Authentication - Authorization Code Grant.
 *
 * @stability stable
 */
class OAuth2AuthorizationCodeGrant extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'OAuth2AuthorizationCodeGrantFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-authentication-by-oauth2/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.CLIENT_ID': jsonStringifiedBundlingDefinition(props.clientId),
                    'process.env.CLIENT_SECRET': jsonStringifiedBundlingDefinition(props.clientSecret),
                    'process.env.CLIENT_DOMAIN': jsonStringifiedBundlingDefinition(props.clientDomain),
                    'process.env.CLIENT_PUBLIC_KEY': jsonStringifiedBundlingDefinition(props.clientPublicKey),
                    'process.env.CALLBACK_PATH': jsonStringifiedBundlingDefinition(props.callbackPath),
                    'process.env.JWT_ARGORITHM': jsonStringifiedBundlingDefinition(props.jwtArgorithm),
                    'process.env.AUTHORIZE_URL': jsonStringifiedBundlingDefinition(props.authorizeUrl),
                    'process.env.AUTHORIZE_PARAMS': jsonStringifiedBundlingDefinition(props.authorizeParams),
                    'process.env.DEBUG_ENABLE': jsonStringifiedBundlingDefinition(props.debugEnable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: 'SO8131',
            templateDescription: 'Cloudfront extension with AWS CDK - OAuth2 Authentication - Authorization Code Grant.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.OAuth2AuthorizationCodeGrant = OAuth2AuthorizationCodeGrant;
_m = JSII_RTTI_SYMBOL_1;
OAuth2AuthorizationCodeGrant[_m] = { fqn: "cdk-cloudfront-plus.OAuth2AuthorizationCodeGrant", version: "0.2.6" };
;
;
/**
 * Ingest data to Kinesis Firehose by nearest cloudfront edge.
 *
 * @see https://aws.amazon.com/blogs/networking-and-content-delivery/global-data-ingestion-with-amazon-cloudfront-and-lambdaedge/
 * @stability stable
 */
class GlobalDataIngestion extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _p;
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'GlobalDataIngestionFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-global-data-ingestion/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.DELIVERY_STREAM_NAME': jsonStringifiedBundlingDefinition(props.firehoseStreamName),
                },
            },
        });
        (_p = func.role) === null || _p === void 0 ? void 0 : _p.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonKinesisFirehoseFullAccess'));
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            includeBody: true,
            solutionId: 'SO8133',
            templateDescription: 'Cloudfront extension with AWS CDK - Global Data Ingestion',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.GlobalDataIngestion = GlobalDataIngestion;
_o = JSII_RTTI_SYMBOL_1;
GlobalDataIngestion[_o] = { fqn: "cdk-cloudfront-plus.GlobalDataIngestion", version: "0.2.6" };
//# sourceMappingURL=data:application/json;base64,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