"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
require("@aws-cdk/assert/jest");
const cf = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const extensions = require("../extensions");
test('minimal usage', () => {
    // GIVEN
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'demo-stack');
    // WHEN
    // create the cloudfront distribution with extension(s)
    const ext = new extensions.AccessOriginByGeolocation(stack, 'AccessOriginByGeolocation', {
        countryTable: {
            US: 'mock-api.com',
            CN: 'mock-api.com.cn',
        },
    });
    const policy = new cf.OriginRequestPolicy(stack, 'OrigReqPolicy', {
        headerBehavior: cf.OriginRequestHeaderBehavior.allowList('cloudfront-viewer-country'),
    });
    // create the cloudfront distribution with extension(s)
    const dist = new cf.Distribution(stack, 'dist', {
        defaultBehavior: {
            origin: new origins.HttpOrigin('aws.amazon.com'),
            edgeLambdas: [ext],
            originRequestPolicy: {
                originRequestPolicyId: policy.originRequestPolicyId,
            },
        },
    });
    new cdk.CfnOutput(stack, 'distributionDomainName', {
        value: dist.distributionDomainName,
    });
    // THEN
    expect(assert_1.SynthUtils.synthesize(stack).template).toMatchSnapshot();
    expect(stack).toHaveResourceLike('AWS::CloudFront::Distribution', {
        DistributionConfig: {
            DefaultCacheBehavior: {
                LambdaFunctionAssociations: [
                    {
                        EventType: 'origin-request',
                        LambdaFunctionARN: {
                            Ref: 'AccessOriginByGeolocationFuncCurrentVersion7A43964926ff9673ff9d57ebbcfdc0d371e33129',
                        },
                    },
                ],
                ViewerProtocolPolicy: 'allow-all',
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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