/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sources;

import cats.effect.kernel.Async;
import com.github.takezoe.scaladoc.Scaladoc;
import com.jayway.jsonpath.JsonPath;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.GraphBuilder;
import com.raphtory.api.input.Source;
import com.raphtory.api.input.Spout;
import com.raphtory.api.input.Type;
import com.raphtory.protocol.PartitionService;
import com.raphtory.sources.JSONSource$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.Value$;

@Scaladoc(value="/**\n  * * Specific format: NetworkX Node Link Data Format\n  * https://networkx.org/documentation/stable/reference/readwrite/generated/networkx.readwrite.json_graph.node_link_data.html\n  *\n  * This is a generic source to ingest data and build a graph in Raphtory, assuming the data is in Network X JSON node link format,\n  *\n  * You can configure source and target type and edge relationship type when calling this source in your Runner.\n  * You can also configure the key of your time value and edge type value if that exists in your data.\n  * Properties and keys of properties in your NetworkX graph will need to be added manually.\n  *\n  * @param spout : state where to ingest your data from (Mandatory field)\n  * @param sourceKey : state the key of the source ID in your JSON data (default = \"source\")\n  * @param sourceType : state what type of value the source is (default = None)\n  * @param targetKey : state the key of the target ID in your JSON data (default = \"target\")\n  * @param targetType : state what type of value the target is (default = None)\n  * @param edgeKey : state the key of the edge type/relationship in your JSON data (default = None)\n  * @param timeKey : state the key of the timestamp in your JSON data (default = 1)\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u001c8\u0001yB\u0001\"\u0014\u0001\u0003\u0006\u0004%\tE\u0014\u0005\t;\u0002\u0011\t\u0011)A\u0005\u001f\"Aa\f\u0001B\u0001B\u0003%!\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003S\u0011!\u0001\u0007A!A!\u0002\u0013\u0011\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\u0006O\u0002!\t\u0001[\u0003\u0005e\u0002\u0001#\u000bC\u0005t\u0001\u0001\u0007\t\u0019!C\u0005i\"IQ\u000f\u0001a\u0001\u0002\u0004%IA\u001e\u0005\ny\u0002\u0001\r\u0011!Q!\nIC\u0011\" \u0001A\u0002\u0003\u0007I\u0011\u0002;\t\u0013y\u0004\u0001\u0019!a\u0001\n\u0013y\bBCA\u0002\u0001\u0001\u0007\t\u0011)Q\u0005%\"I\u0011Q\u0001\u0001A\u0002\u0013%\u0011q\u0001\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0003\u0017Aq!a\u0004\u0001A\u0003&1\rC\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0003\u0002\u0014!I\u0011Q\u0004\u0001A\u0002\u0013%\u0011q\u0004\u0005\t\u0003G\u0001\u0001\u0015)\u0003\u0002\u0016!9\u0011Q\u0005\u0001\u0005B\u0005\u001draBA&o!\u0005\u0011Q\n\u0004\u0007m]B\t!a\u0014\t\r\u001dLB\u0011AA)\u0011\u001d\t\u0019&\u0007C\u0001\u0003+B\u0011\"!\u001a\u001a#\u0003%\t!a\u001a\t\u0013\u0005u\u0014$%A\u0005\u0002\u0005\u001d\u0004\"CA@3E\u0005I\u0011AA4\u0011%\t\t)GI\u0001\n\u0003\t9\u0007C\u0005\u0002\u0004f\t\n\u0011\"\u0001\u0002\u0006\"I\u0011\u0011R\r\u0012\u0002\u0013\u0005\u0011Q\u0011\u0005\b\u0003\u0017KB\u0011AAG\u0011%\ty*GI\u0001\n\u0003\t9\u0007C\u0005\u0002\"f\t\n\u0011\"\u0001\u0002h!I\u00111U\r\u0012\u0002\u0013\u0005\u0011q\r\u0005\n\u0003KK\u0012\u0013!C\u0001\u0003OB\u0011\"a*\u001a#\u0003%\t!!\"\t\u0013\u0005%\u0016$%A\u0005\u0002\u0005\u0015\u0005bBAV3\u0011\u0005\u0011Q\u0016\u0005\n\u0003{K\u0012\u0013!C\u0001\u0003OB\u0011\"a0\u001a#\u0003%\t!a\u001a\t\u0013\u0005\u0005\u0017$%A\u0005\u0002\u0005\u001d\u0004\"CAb3E\u0005I\u0011AA4\u0011%\t)-GI\u0001\n\u0003\t)\tC\u0005\u0002Hf\t\n\u0011\"\u0001\u0002\u0006\"I\u0011\u0011Z\r\u0012\u0002\u0013\u0005\u0011q\r\u0005\n\u0003\u0017L\u0012\u0013!C\u0001\u0003OB\u0011\"!4\u001a#\u0003%\t!a\u001a\t\u0013\u0005=\u0017$%A\u0005\u0002\u0005\u001d\u0004\"CAi3E\u0005I\u0011AAC\u0011%\t\u0019.GI\u0001\n\u0003\t)I\u0001\u0006K'>s5k\\;sG\u0016T!\u0001O\u001d\u0002\u000fM|WO]2fg*\u0011!hO\u0001\te\u0006\u0004\b\u000e^8ss*\tA(A\u0002d_6\u001c\u0001aE\u0002\u0001\u007f\u0015\u0003\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013a!\u00118z%\u00164\u0007C\u0001$L\u001b\u00059%B\u0001%J\u0003\u0015Ig\u000e];u\u0015\tQ\u0015(A\u0002ba&L!\u0001T$\u0003\rM{WO]2f\u0003\u0015\u0019\bo\\;u+\u0005y\u0005c\u0001$Q%&\u0011\u0011k\u0012\u0002\u0006'B|W\u000f\u001e\t\u0003'js!\u0001\u0016-\u0011\u0005U\u000bU\"\u0001,\u000b\u0005]k\u0014A\u0002\u001fs_>$h(\u0003\u0002Z\u0003\u00061\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI\u0016)\u0001\u0004ta>,H\u000fI\u0001\ng>,(oY3LKf\f!b]8ve\u000e,G+\u001f9f\u0003%!\u0018M]4fi.+\u00170\u0001\u0006uCJ<W\r\u001e+za\u0016\fq!\u001a3hK.+\u0017\u0010E\u0002AIJK!!Z!\u0003\r=\u0003H/[8o\u0003\u001d!\u0018.\\3LKf\fa\u0001P5oSRtD\u0003C5lY6tw\u000e]9\u0011\u0005)\u0004Q\"A\u001c\t\u000b5K\u0001\u0019A(\t\u000fyK\u0001\u0013!a\u0001%\"9q,\u0003I\u0001\u0002\u0004\u0011\u0006b\u00021\n!\u0003\u0005\rA\u0015\u0005\bC&\u0001\n\u00111\u0001S\u0011\u001d\u0011\u0017\u0002%AA\u0002\rDqAZ\u0005\u0011\u0002\u0003\u00071MA\u0006NKN\u001c\u0018mZ3UsB,\u0017AB:pkJ\u001cW-F\u0001S\u0003)\u0019x.\u001e:dK~#S-\u001d\u000b\u0003oj\u0004\"\u0001\u0011=\n\u0005e\f%\u0001B+oSRDqa\u001f\u0007\u0002\u0002\u0003\u0007!+A\u0002yIE\nqa]8ve\u000e,\u0007%\u0001\u0004uCJ<W\r^\u0001\u000bi\u0006\u0014x-\u001a;`I\u0015\fHcA<\u0002\u0002!91pDA\u0001\u0002\u0004\u0011\u0016a\u0002;be\u001e,G\u000fI\u0001\u0005if\u0004X-F\u0001d\u0003!!\u0018\u0010]3`I\u0015\fHcA<\u0002\u000e!91PEA\u0001\u0002\u0004\u0019\u0017!\u0002;za\u0016\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0006\u0011\t\u0001#\u0017q\u0003\t\u0004\u0001\u0006e\u0011bAA\u000e\u0003\n!Aj\u001c8h\u0003!!\u0018.\\3`I\u0015\fHcA<\u0002\"!A10FA\u0001\u0002\u0004\t)\"A\u0003uS6,\u0007%A\u0004ck&dG-\u001a:\u0016\u0005\u0005%\u0002\u0003\u0002$\u0002,IK1!!\fH\u000519%/\u00199i\u0005VLG\u000eZ3sQ\u001d\u0001\u0011\u0011GA#\u0003\u000f\u0002B!a\r\u0002B5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\tY$!\u0010\u0002\u000fQ\f7.\u001a>pK*\u0019\u0011qH\u001e\u0002\r\u001dLG\u000f[;c\u0013\u0011\t\u0019%!\u000e\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!!\u0013\u0002\u0013w{#F\u000b\u0006!A)\u0002#\u0006I*qK\u000eLg-[2!M>\u0014X.\u0019;;A9+Go^8sWb\u0003cj\u001c3fA1Kgn\u001b\u0011ECR\f\u0007ER8s[\u0006$(\u0002\t\u0011+A!$H\u000f]:;_=rW\r^<pe.Dhf\u001c:h_\u0011|7-^7f]R\fG/[8o_M$\u0018M\u00197f_I,g-\u001a:f]\u000e,wF]3bI^\u0014\u0018\u000e^30O\u0016tWM]1uK\u0012|c.\u001a;x_J\\\u0007P\f:fC\u0012<(/\u001b;f])\u001cxN\\0he\u0006\u0004\bN\f8pI\u0016|F.\u001b8l?\u0012\fG/\u0019\u0018ii6d'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t+iSN\u0004\u0013n\u001d\u0011bA\u001d,g.\u001a:jG\u0002\u001ax.\u001e:dK\u0002\"x\u000eI5oO\u0016\u001cH\u000f\t3bi\u0006\u0004\u0013M\u001c3!EVLG\u000e\u001a\u0011bA\u001d\u0014\u0018\r\u001d5!S:\u0004#+\u00199ii>\u0014\u0018\u0010\f\u0011bgN,X.\u001b8hAQDW\r\t3bi\u0006\u0004\u0013n\u001d\u0011j]\u0002rU\r^<pe.\u0004\u0003\f\t&T\u001f:\u0003cn\u001c3fA1Lgn\u001b\u0011g_Jl\u0017\r\u001e\u0017\u000bA\u0001R#\u0002\t\u0011+Ae{W\u000fI2b]\u0002\u001awN\u001c4jOV\u0014X\rI:pkJ\u001cW\rI1oI\u0002\"\u0018M]4fi\u0002\"\u0018\u0010]3!C:$\u0007%\u001a3hK\u0002\u0012X\r\\1uS>t7\u000f[5qAQL\b/\u001a\u0011xQ\u0016t\u0007eY1mY&tw\r\t;iSN\u00043o\\;sG\u0016\u0004\u0013N\u001c\u0011z_V\u0014\bEU;o]\u0016\u0014hF\u0003\u0011!U\u0001Jv.\u001e\u0011dC:\u0004\u0013\r\\:pA\r|gNZ5hkJ,\u0007\u0005\u001e5fA-,\u0017\u0010I8gAe|WO\u001d\u0011uS6,\u0007E^1mk\u0016\u0004\u0013M\u001c3!K\u0012<W\r\t;za\u0016\u0004c/\u00197vK\u0002Jg\r\t;iCR\u0004S\r_5tiN\u0004\u0013N\u001c\u0011z_V\u0014\b\u0005Z1uC:R\u0001\u0005\t\u0016!!J|\u0007/\u001a:uS\u0016\u001c\b%\u00198eA-,\u0017p\u001d\u0011pM\u0002\u0002(o\u001c9feRLWm\u001d\u0011j]\u0002Jx.\u001e:!\u001d\u0016$xo\u001c:l1\u0002:'/\u00199iA]LG\u000e\u001c\u0011oK\u0016$\u0007\u0005^8!E\u0016\u0004\u0013\r\u001a3fI\u0002j\u0017M\\;bY2LhF\u0003\u0011!U)\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011ta>,H\u000f\t\u001e!gR\fG/\u001a\u0011xQ\u0016\u0014X\r\t;pA%tw-Z:uAe|WO\u001d\u0011eCR\f\u0007E\u001a:p[\u0002BS*\u00198eCR|'/\u001f\u0011gS\u0016dG-\u000b\u0006!A)\u0002\u0003\t]1sC6\u00043o\\;sG\u0016\\U-\u001f\u0011;AM$\u0018\r^3!i\",\u0007e[3zA=4\u0007\u0005\u001e5fAM|WO]2fA%#\u0005%\u001b8!s>,(\u000f\t&T\u001f:\u0003C-\u0019;bA!\"WMZ1vYR\u0004S\b\t\u0012t_V\u00148-\u001a\u0012*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000eI:pkJ\u001cW\rV=qK\u0002R\u0004e\u001d;bi\u0016\u0004s\u000f[1uAQL\b/\u001a\u0011pM\u00022\u0018\r\\;fAQDW\rI:pkJ\u001cW\rI5tA!\"WMZ1vYR\u0004S\b\t(p]\u0016L#\u0002\t\u0011+A\u0001\u0003\u0018M]1nAQ\f'oZ3u\u0017\u0016L\bE\u000f\u0011ti\u0006$X\r\t;iK\u0002ZW-\u001f\u0011pM\u0002\"\b.\u001a\u0011uCJ<W\r\u001e\u0011J\t\u0002Jg\u000eI=pkJ\u0004#jU(OA\u0011\fG/\u0019\u0011)I\u00164\u0017-\u001e7uAu\u0002#\u0005^1sO\u0016$(%\u000b\u0006!A)\u0002\u0003\t]1sC6\u0004C/\u0019:hKR$\u0016\u0010]3!u\u0001\u001aH/\u0019;fA]D\u0017\r\u001e\u0011usB,\u0007e\u001c4!m\u0006dW/\u001a\u0011uQ\u0016\u0004C/\u0019:hKR\u0004\u0013n\u001d\u0011)I\u00164\u0017-\u001e7uAu\u0002cj\u001c8fS)\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011fI\u001e,7*Z=!u\u0001\u001aH/\u0019;fAQDW\rI6fs\u0002zg\r\t;iK\u0002*GmZ3!if\u0004Xm\f:fY\u0006$\u0018n\u001c8tQ&\u0004\b%\u001b8!s>,(\u000f\t&T\u001f:\u0003C-\u0019;bA!\"WMZ1vYR\u0004S\b\t(p]\u0016L#\u0002\t\u0011+A\u0001\u0003\u0018M]1nAQLW.Z&fs\u0002R\u0004e\u001d;bi\u0016\u0004C\u000f[3!W\u0016L\be\u001c4!i\",\u0007\u0005^5nKN$\u0018-\u001c9!S:\u0004\u0013p\\;sA)\u001bvJ\u0014\u0011eCR\f\u0007\u0005\u000b3fM\u0006,H\u000e\u001e\u0011>AEJ#\u0002\t\u0011+_\u0005Q!jU(O'>,(oY3\u0011\u0005)L2CA\r@)\t\ti%A\u0003baBd\u0017\u0010F\bj\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011MA2\u0011\u0015i5\u00041\u0001P\u0011\u001dq6\u0004%AA\u0002ICqaX\u000e\u0011\u0002\u0003\u0007!\u000bC\u0004a7A\u0005\t\u0019\u0001*\t\u000f\u0005\\\u0002\u0013!a\u0001%\"9!m\u0007I\u0001\u0002\u0004\u0019\u0007b\u00024\u001c!\u0003\u0005\raY\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u000e\u0016\u0004%\u0006-4FAA7!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]\u0014)\u0001\u0006b]:|G/\u0019;j_:LA!a\u001f\u0002r\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\b*\u001a1-a\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uI]\n\u0001B\u001a:p[\u001aKG.\u001a\u000b\u0010S\u0006=\u00151SAK\u0003/\u000bI*a'\u0002\u001e\"1\u0011\u0011\u0013\u0012A\u0002I\u000bA\u0001]1uQ\"9aL\tI\u0001\u0002\u0004\u0011\u0006bB0#!\u0003\u0005\rA\u0015\u0005\bA\n\u0002\n\u00111\u0001S\u0011\u001d\t'\u0005%AA\u0002ICqA\u0019\u0012\u0011\u0002\u0003\u00071\rC\u0004gEA\u0005\t\u0019A2\u0002%\u0019\u0014x.\u001c$jY\u0016$C-\u001a4bk2$HEM\u0001\u0013MJ|WNR5mK\u0012\"WMZ1vYR$3'\u0001\nge>lg)\u001b7fI\u0011,g-Y;mi\u0012\"\u0014A\u00054s_64\u0015\u000e\\3%I\u00164\u0017-\u001e7uIU\n!C\u001a:p[\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005\u0011bM]8n\r&dW\r\n3fM\u0006,H\u000e\u001e\u00138\u000311'o\\7SKN|WO]2f)=I\u0017qVAY\u0003g\u000b),a.\u0002:\u0006m\u0006BBAIS\u0001\u0007!\u000bC\u0004_SA\u0005\t\u0019\u0001*\t\u000f}K\u0003\u0013!a\u0001%\"9\u0001-\u000bI\u0001\u0002\u0004\u0011\u0006bB1*!\u0003\u0005\rA\u0015\u0005\bE&\u0002\n\u00111\u0001d\u0011\u001d1\u0017\u0006%AA\u0002\r\faC\u001a:p[J+7o\\;sG\u0016$C-\u001a4bk2$HEM\u0001\u0017MJ|WNU3t_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u00051bM]8n%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$C'\u0001\fge>l'+Z:pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00136\u0003Y1'o\\7SKN|WO]2fI\u0011,g-Y;mi\u00122\u0014A\u00064s_6\u0014Vm]8ve\u000e,G\u0005Z3gCVdG\u000fJ\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\u000e")
public class JSONSource
implements Source {
    private final Spout<String> spout;
    private final String sourceKey;
    private final String sourceType;
    private final String targetKey;
    private final String targetType;
    private final Option<String> edgeKey;
    private final Option<String> timeKey;
    private String source;
    private String target;
    private Option<String> type;
    private Option<Object> time;

    public static Option<String> $lessinit$greater$default$7() {
        return JSONSource$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<String> $lessinit$greater$default$6() {
        return JSONSource$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return JSONSource$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return JSONSource$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return JSONSource$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return JSONSource$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<String> fromResource$default$7() {
        return JSONSource$.MODULE$.fromResource$default$7();
    }

    public static Option<String> fromResource$default$6() {
        return JSONSource$.MODULE$.fromResource$default$6();
    }

    public static String fromResource$default$5() {
        return JSONSource$.MODULE$.fromResource$default$5();
    }

    public static String fromResource$default$4() {
        return JSONSource$.MODULE$.fromResource$default$4();
    }

    public static String fromResource$default$3() {
        return JSONSource$.MODULE$.fromResource$default$3();
    }

    public static String fromResource$default$2() {
        return JSONSource$.MODULE$.fromResource$default$2();
    }

    public static JSONSource fromResource(String path, String sourceKey, String sourceType, String targetKey, String targetType, Option<String> edgeKey, Option<String> timeKey) {
        return JSONSource$.MODULE$.fromResource(path, sourceKey, sourceType, targetKey, targetType, edgeKey, timeKey);
    }

    public static Option<String> fromFile$default$7() {
        return JSONSource$.MODULE$.fromFile$default$7();
    }

    public static Option<String> fromFile$default$6() {
        return JSONSource$.MODULE$.fromFile$default$6();
    }

    public static String fromFile$default$5() {
        return JSONSource$.MODULE$.fromFile$default$5();
    }

    public static String fromFile$default$4() {
        return JSONSource$.MODULE$.fromFile$default$4();
    }

    public static String fromFile$default$3() {
        return JSONSource$.MODULE$.fromFile$default$3();
    }

    public static String fromFile$default$2() {
        return JSONSource$.MODULE$.fromFile$default$2();
    }

    public static JSONSource fromFile(String path, String sourceKey, String sourceType, String targetKey, String targetType, Option<String> edgeKey, Option<String> timeKey) {
        return JSONSource$.MODULE$.fromFile(path, sourceKey, sourceType, targetKey, targetType, edgeKey, timeKey);
    }

    public static Option<String> apply$default$7() {
        return JSONSource$.MODULE$.apply$default$7();
    }

    public static Option<String> apply$default$6() {
        return JSONSource$.MODULE$.apply$default$6();
    }

    public static String apply$default$5() {
        return JSONSource$.MODULE$.apply$default$5();
    }

    public static String apply$default$4() {
        return JSONSource$.MODULE$.apply$default$4();
    }

    public static String apply$default$3() {
        return JSONSource$.MODULE$.apply$default$3();
    }

    public static String apply$default$2() {
        return JSONSource$.MODULE$.apply$default$2();
    }

    public static JSONSource apply(Spout<String> spout, String sourceKey, String sourceType, String targetKey, String targetType, Option<String> edgeKey, Option<String> timeKey) {
        return JSONSource$.MODULE$.apply(spout, sourceKey, sourceType, targetKey, targetType, edgeKey, timeKey);
    }

    @Override
    public Class<?> getBuilderClass() {
        return Source.getBuilderClass$(this);
    }

    @Override
    public <F> F make(String graphID, int id, Map<Object, PartitionService<F>> partitions, Async<F> evidence$1) {
        return (F)Source.make$(this, graphID, id, partitions, evidence$1);
    }

    public Spout<String> spout() {
        return this.spout;
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private String target() {
        return this.target;
    }

    private void target_$eq(String x$1) {
        this.target = x$1;
    }

    private Option<String> type() {
        return this.type;
    }

    private void type_$eq(Option<String> x$1) {
        this.type = x$1;
    }

    private Option<Object> time() {
        return this.time;
    }

    private void time_$eq(Option<Object> x$1) {
        this.time = x$1;
    }

    public GraphBuilder<String> builder() {
        return new GraphBuilder<String>(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ JSONSource $outer;

            public final <F> F make(String graphID, int sourceID, Map<Object, PartitionService<F>> partitions, Async<F> evidence$1) {
                return (F)GraphBuilder.make$(this, graphID, sourceID, partitions, evidence$1);
            }

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public void apply$mcVII$sp(int v1, int v2) {
                Function2.apply$mcVII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Graph, Function1<String, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Graph, String>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public final void apply(Graph v1, String v2) {
                this.$outer.com$raphtory$sources$JSONSource$$$anonfun$builder$1(v1, v2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Function2.$init$((Function2)this);
                GraphBuilder.$init$(this);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$builder$2(JSONSource $this, Graph graph$1, Value json) {
        block4: {
            $this.source_$eq(JsonPath.read((String)json.toString(), (String)new StringBuilder(2).append("$.").append($this.sourceKey).toString()).toString());
            $this.target_$eq(JsonPath.read((String)json.toString(), (String)new StringBuilder(2).append("$.").append($this.targetKey).toString()).toString());
            if ($this.timeKey.nonEmpty()) {
                $this.time_$eq((Option<Object>)StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(JsonPath.read((String)json.toString(), (String)new StringBuilder(2).append("$.").append($this.timeKey).toString()).toString())));
            }
            if ($this.edgeKey.nonEmpty()) {
                $this.type_$eq((Option<String>)Option$.MODULE$.apply((Object)JsonPath.read((String)json.toString(), (String)new StringBuilder(2).append("$.").append($this.edgeKey).toString()).toString()));
            }
            long srcID = Graph$.MODULE$.assignID($this.source());
            long dstID = Graph$.MODULE$.assignID($this.target());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString($this.source()))) {
                graph$1.addVertex(BoxesRunTime.unboxToLong((Object)$this.time().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L)), srcID, new Type($this.sourceType));
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString($this.target()))) {
                graph$1.addVertex(BoxesRunTime.unboxToLong((Object)$this.time().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L)), dstID, new Type($this.targetType));
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString($this.source())) || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString($this.target()))) break block4;
            graph$1.addEdge(BoxesRunTime.unboxToLong((Object)$this.time().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L)), srcID, dstID, new Type((String)$this.type().getOrElse((Function0 & Serializable)() -> "")));
        }
    }

    public final /* synthetic */ void com$raphtory$sources$JSONSource$$$anonfun$builder$1(Graph graph, String jsonString) {
        Seq networkXGraph = ((Value)Value$.MODULE$.apply((Readable)Readable$.MODULE$.fromString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(jsonString))))).obj().values().toSeq();
        ((Value)networkXGraph.apply(4)).arr().map((Function1 & Serializable)json -> {
            JSONSource.$anonfun$builder$2(this, graph, json);
            return BoxedUnit.UNIT;
        });
    }

    public JSONSource(Spout<String> spout, String sourceKey, String sourceType, String targetKey, String targetType, Option<String> edgeKey, Option<String> timeKey) {
        this.spout = spout;
        this.sourceKey = sourceKey;
        this.sourceType = sourceType;
        this.targetKey = targetKey;
        this.targetType = targetType;
        this.edgeKey = edgeKey;
        this.timeKey = timeKey;
        Source.$init$(this);
        this.type = None$.MODULE$;
        this.time = None$.MODULE$;
    }
}

