/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.graph;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Type;
import com.raphtory.internals.components.querymanager.GenericVertexMessage;
import com.raphtory.internals.graph.GraphPartition$;
import com.raphtory.internals.graph.LensInterface;
import com.raphtory.internals.management.Partitioner;
import com.raphtory.internals.management.Partitioner$;
import com.raphtory.internals.management.Scheduler;
import com.raphtory.internals.storage.arrow.ArrowGraphLens;
import com.raphtory.internals.storage.arrow.ArrowPartition;
import com.raphtory.internals.storage.pojograph.PojoBasedPartition;
import com.raphtory.internals.storage.pojograph.PojoGraphLens;
import com.raphtory.internals.storage.pojograph.entities.external.vertex.PojoExVertex;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Scaladoc(value="/** Singleton representing the Storage for the entities\n  */")
@ScalaSignature(bytes="\u0006\u0005\tuaAB\u000b\u0017\u0003\u0003Qb\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003(\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u000b}\u0002A\u0011\u0001!\t\u000f\u0019\u0003!\u0019!C\u0001\u000f\"1a\n\u0001Q\u0001\n!CQa\u0014\u0001\u0007\u0002ACQ!\u001d\u0001\u0007\u0002IDQ\u0001 \u0001\u0007\u0002uDq!a\u0003\u0001\r\u0003\ti\u0001C\u0004\u0002\u001e\u00011\t!a\b\t\u0013\u0005}\u0003A1A\u0005\n\u0005\u0005\u0004\u0002CA8\u0001\u0001\u0006I!a\u0019\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAB\u0001\u0011\u0005\u0011QQ\u0004\b\u0005\u000f1\u0002\u0012\u0001B\u0005\r\u0019)b\u0003#\u0001\u0003\f!1qH\u0005C\u0001\u0005\u001bAqAa\u0004\u0013\t\u0003\u0011\tB\u0001\bHe\u0006\u0004\b\u000eU1si&$\u0018n\u001c8\u000b\u0005]A\u0012!B4sCBD'BA\r\u001b\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002\u001c9\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u001e\u0003\r\u0019w.\\\n\u0003\u0001}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0017aB4sCBD\u0017\nR\u0002\u0001!\tAsF\u0004\u0002*[A\u0011!&I\u0007\u0002W)\u0011AFJ\u0001\u0007yI|w\u000e\u001e \n\u00059\n\u0013A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!AL\u0011\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u0012\t\u0003AQJ!!N\u0011\u0003\u0007%sG/\u0001\u0003d_:4\u0007C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0019\u0019wN\u001c4jO*\u0011A\bH\u0001\tif\u0004Xm]1gK&\u0011a(\u000f\u0002\u0007\u0007>tg-[4\u0002\rqJg.\u001b;?)\u0011\t5\tR#\u0011\u0005\t\u0003Q\"\u0001\f\t\u000b\u0015\"\u0001\u0019A\u0014\t\u000bI\"\u0001\u0019A\u001a\t\u000bY\"\u0001\u0019A\u001c\u0002\r1|wmZ3s+\u0005A\u0005CA%M\u001b\u0005Q%BA&<\u00031\u00198-\u00197bY><w-\u001b8h\u0013\ti%J\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003%\tG\r\u001a,feR,\u0007\u0010F\u0004R)f[VlX5\u0011\u0005\u0001\u0012\u0016BA*\"\u0005\u0011)f.\u001b;\t\u000bU;\u0001\u0019\u0001,\u0002\u0011M|WO]2f\u0013\u0012\u0003\"\u0001I,\n\u0005a\u000b#\u0001\u0002'p]\u001eDQAW\u0004A\u0002Y\u000bq!\\:h)&lW\rC\u0003]\u000f\u0001\u0007a+A\u0003j]\u0012,\u0007\u0010C\u0003_\u000f\u0001\u0007a+A\u0003te\u000eLE\rC\u0003a\u000f\u0001\u0007\u0011-\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u000b%t\u0007/\u001e;\u000b\u0005\u0019T\u0012aA1qS&\u0011\u0001n\u0019\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u00026\b\u0001\u0004Y\u0017A\u0003<feR,\u0007\u0010V=qKB\u0019\u0001\u0005\u001c8\n\u00055\f#AB(qi&|g\u000e\u0005\u0002c_&\u0011\u0001o\u0019\u0002\u0005)f\u0004X-\u0001\u0007bI\u0012dunY1m\u000b\u0012<W\r\u0006\u0005RgR,ho^={\u0011\u0015)\u0006\u00021\u0001W\u0011\u0015Q\u0006\u00021\u0001W\u0011\u0015a\u0006\u00021\u0001W\u0011\u0015q\u0006\u00021\u0001W\u0011\u0015A\b\u00021\u0001W\u0003\u0015!7\u000f^%e\u0011\u0015\u0001\u0007\u00021\u0001b\u0011\u0015Y\b\u00021\u0001l\u0003!)GmZ3UsB,\u0017aD1eI>+HoZ8j]\u001e,EmZ3\u0015\u001bEsx0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0011\u0015)\u0016\u00021\u0001W\u0011\u0015Q\u0016\u00021\u0001W\u0011\u0015a\u0016\u00021\u0001W\u0011\u0015q\u0016\u00021\u0001W\u0011\u0015A\u0018\u00021\u0001W\u0011\u0015\u0001\u0017\u00021\u0001b\u0011\u0015Y\u0018\u00021\u0001l\u0003=\tG\rZ%oG>l\u0017N\\4FI\u001e,GcD)\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\t\u000bUS\u0001\u0019\u0001,\t\u000biS\u0001\u0019\u0001,\t\u000bqS\u0001\u0019\u0001,\t\u000byS\u0001\u0019\u0001,\t\u000baT\u0001\u0019\u0001,\t\u000b\u0001T\u0001\u0019A1\t\u000bmT\u0001\u0019A6\u0002\u0017\u001d,GOV3si&\u001cWm\u001d\u000b\t\u0003C\ti%a\u0016\u0002\\A9\u00111EA\u0017-\u0006ERBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u000f5,H/\u00192mK*\u0019\u00111F\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00020\u0005\u0015\"aA'baB!\u00111GA%\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012A\u0002<feR,\u0007P\u0003\u0003\u0002<\u0005u\u0012\u0001C3yi\u0016\u0014h.\u00197\u000b\t\u0005}\u0012\u0011I\u0001\tK:$\u0018\u000e^5fg*!\u00111IA#\u0003%\u0001xN[8he\u0006\u0004\bNC\u0002\u0002Ha\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002L\u0005U\"\u0001\u0004)pU>,\u0005PV3si\u0016D\bbBA(\u0017\u0001\u0007\u0011\u0011K\u0001\u0011OJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016\u00042AQA*\u0013\r\t)F\u0006\u0002\u000e\u0019\u0016t7/\u00138uKJ4\u0017mY3\t\r\u0005e3\u00021\u0001W\u0003\u0015\u0019H/\u0019:u\u0011\u0019\tif\u0003a\u0001-\u0006\u0019QM\u001c3\u0002\u0017A\f'\u000f^5uS>tWM]\u000b\u0003\u0003G\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003SB\u0012AC7b]\u0006<W-\\3oi&!\u0011QNA4\u0005-\u0001\u0016M\u001d;ji&|g.\u001a:\u0002\u0019A\f'\u000f^5uS>tWM\u001d\u0011\u0002\u001d\u001d,G\u000fU1si&$\u0018n\u001c8J\tV\t1'A\u0004jg2{7-\u00197\u0015\t\u0005e\u0014q\u0010\t\u0004A\u0005m\u0014bAA?C\t9!i\\8mK\u0006t\u0007BBAA\u001f\u0001\u0007a+\u0001\u0002jI\u0006!A.\u001a8t)A\t\t&a\"\u0002\f\u0006=\u00151SAL\u0003\u0013\f\t\u000f\u0003\u0004\u0002\nB\u0001\raJ\u0001\u0006U>\u0014\u0017\n\u0012\u0005\u0007\u0003\u001b\u0003\u0002\u0019\u0001,\u0002\u0017\u0005\u001cG/^1m'R\f'\u000f\u001e\u0005\u0007\u0003#\u0003\u0002\u0019\u0001,\u0002\u0013\u0005\u001cG/^1m\u000b:$\u0007BBAK!\u0001\u00071'A\u0005tkB,'o\u0015;fa\"9\u0011\u0011\u0014\tA\u0002\u0005m\u0015aC:f]\u0012lUm]:bO\u0016\u0004b\u0001IAO\u0003C\u000b\u0016bAAPC\tIa)\u001e8di&|g.\r\u0019\u0005\u0003G\u000b9\f\u0005\u0004\u0002&\u0006=\u00161W\u0007\u0003\u0003OSA!!+\u0002,\u0006a\u0011/^3ss6\fg.Y4fe*\u0019\u0011Q\u0016\r\u0002\u0015\r|W\u000e]8oK:$8/\u0003\u0003\u00022\u0006\u001d&\u0001F$f]\u0016\u0014\u0018n\u0019,feR,\u00070T3tg\u0006<W\r\u0005\u0003\u00026\u0006]F\u0002\u0001\u0003\r\u0003s\u000b9*!A\u0001\u0002\u000b\u0005\u00111\u0018\u0002\u0004?\u0012\n\u0014\u0003BA_\u0003\u0007\u00042\u0001IA`\u0013\r\t\t-\t\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u0013QY\u0005\u0004\u0003\u000f\f#aA!os\"9\u00111\u001a\tA\u0002\u00055\u0017\u0001D3se>\u0014\b*\u00198eY\u0016\u0014\bC\u0002\u0011\u0002\u001e\u0006=\u0017\u000b\u0005\u0003\u0002R\u0006mg\u0002BAj\u0003/t1AKAk\u0013\u0005\u0011\u0013bAAmC\u00059\u0001/Y2lC\u001e,\u0017\u0002BAo\u0003?\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005e\u0017\u0005C\u0004\u0002dB\u0001\r!!:\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA3\u0003OLA!!;\u0002h\tI1k\u00195fIVdWM\u001d\u0015\b\u0001\u00055(\u0011\u0001B\u0002!\u0011\ty/!@\u000e\u0005\u0005E(\u0002BAz\u0003k\f\u0001b]2bY\u0006$wn\u0019\u0006\u0005\u0003o\fI0A\u0004uC.,'p\\3\u000b\u0007\u0005mH$\u0001\u0004hSRDWOY\u0005\u0005\u0003\u007f\f\tP\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\t\u0011)!\u0001\u001f0U)\u00023+\u001b8hY\u0016$xN\u001c\u0011sKB\u0014Xm]3oi&tw\r\t;iK\u0002\u001aFo\u001c:bO\u0016\u0004cm\u001c:!i\",\u0007%\u001a8uSRLWm\u001d\u0006!A)z\u0013AD$sCBD\u0007+\u0019:uSRLwN\u001c\t\u0003\u0005J\u0019\"AE\u0010\u0015\u0005\t%\u0011\u0001C2iK\u000e\\Gi\u001d;\u0015\u0011\u0005e$1\u0003B\f\u00057AaA!\u0006\u0015\u0001\u00041\u0016!\u00023ti&#\u0005B\u0002B\r)\u0001\u00071'A\bu_R\fG\u000eU1si&$\u0018n\u001c8t\u0011\u0015\u0011D\u00031\u00014\u0001")
public abstract class GraphPartition {
    private final int partitionID;
    private final Config conf;
    private final Logger logger;
    private final Partitioner partitioner;

    public static boolean checkDst(long dstID, int totalPartitions, int partitionID) {
        return GraphPartition$.MODULE$.checkDst(dstID, totalPartitions, partitionID);
    }

    public Logger logger() {
        return this.logger;
    }

    public abstract void addVertex(long var1, long var3, long var5, long var7, Properties var9, Option<Type> var10);

    public abstract void addLocalEdge(long var1, long var3, long var5, long var7, long var9, Properties var11, Option<Type> var12);

    public abstract void addOutgoingEdge(long var1, long var3, long var5, long var7, long var9, Properties var11, Option<Type> var12);

    public abstract void addIncomingEdge(long var1, long var3, long var5, long var7, long var9, Properties var11, Option<Type> var12);

    public abstract Map<Object, PojoExVertex> getVertices(LensInterface var1, long var2, long var4);

    private Partitioner partitioner() {
        return this.partitioner;
    }

    public int getPartitionID() {
        return this.partitionID;
    }

    public boolean isLocal(long id) {
        return this.partitioner().getPartitionForId(id) == this.partitionID;
    }

    public LensInterface lens(String jobID, long actualStart, long actualEnd, int superStep, Function1<GenericVertexMessage<?>, BoxedUnit> sendMessage, Function1<Throwable, BoxedUnit> errorHandler, Scheduler scheduler) {
        Product product;
        GraphPartition graphPartition = this;
        if (graphPartition instanceof ArrowPartition) {
            ArrowPartition arrowPartition = (ArrowPartition)graphPartition;
            product = new ArrowGraphLens(jobID, actualStart, actualEnd, superStep, arrowPartition, sendMessage, errorHandler, scheduler);
        } else if (graphPartition instanceof PojoBasedPartition) {
            PojoBasedPartition pojoBasedPartition = (PojoBasedPartition)graphPartition;
            product = new PojoGraphLens(jobID, actualStart, actualEnd, 0, pojoBasedPartition, this.conf, sendMessage, errorHandler, scheduler);
        } else {
            throw new MatchError((Object)graphPartition);
        }
        return product;
    }

    public GraphPartition(String graphID, int partitionID, Config conf) {
        this.partitionID = partitionID;
        this.conf = conf;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        this.partitioner = Partitioner$.MODULE$.apply(conf);
    }
}

