/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.components.partition;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import com.raphtory.internals.components.partition.Writer$;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.graph.GraphPartition;
import com.raphtory.internals.management.Partitioner;
import com.raphtory.internals.management.Partitioner$;
import com.raphtory.internals.management.telemetry.TelemetryReporter$;
import com.raphtory.protocol.GraphAlterations;
import com.raphtory.protocol.PartitionService;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import io.prometheus.client.Counter;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00055h!\u0002\u000e\u001c\u0001\u0005*\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011i\u0002!\u0011!Q\u0001\nmB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"Aa\n\u0001B\u0001B\u0003-q\nC\u0003m\u0001\u0011\u0005Q\u000eC\u0004w\u0001\t\u0007I\u0011B<\t\ry\u0004\u0001\u0015!\u0003y\u0011!y\bA1A\u0005\n\u0005\u0005\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0001\t\u0013\u0005u\u0001A1A\u0005\n\u0005\u0005\u0001\u0002CA\u0010\u0001\u0001\u0006I!a\u0001\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0002\u0002CA\u0019\u0001\u0001\u0006I!!\n\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011q\n\u0001\u0005\n\u0005E\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003{\u0002A\u0011AA@\u000f\u001d\tYi\u0007E\u0001\u0003\u001b3aAG\u000e\t\u0002\u0005=\u0005B\u00027\u0015\t\u0003\t\t\nC\u0005\u0002\"Q\u0011\r\u0011\"\u0003\u0002$!A\u0011\u0011\u0007\u000b!\u0002\u0013\t)\u0003C\u0004\u0002\u0014R!\t!!&\t\u000f\u0005-G\u0003\"\u0003\u0002N\n1qK]5uKJT!\u0001H\u000f\u0002\u0013A\f'\u000f^5uS>t'B\u0001\u0010 \u0003)\u0019w.\u001c9p]\u0016tGo\u001d\u0006\u0003A\u0005\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005\t\u001a\u0013\u0001\u0003:ba\"$xN]=\u000b\u0003\u0011\n1aY8n+\t1\u0003m\u0005\u0002\u0001OA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\fqa\u001a:ba\"LEi\u0001\u0001\u0011\u0005A:dBA\u00196!\t\u0011\u0014&D\u00014\u0015\t!d&\u0001\u0004=e>|GOP\u0005\u0003m%\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011a'K\u0001\fa\u0006\u0014H/\u001b;j_:LE\t\u0005\u0002)y%\u0011Q(\u000b\u0002\u0004\u0013:$\u0018aB:u_J\fw-\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005~\tQa\u001a:ba\"L!\u0001R!\u0003\u001d\u001d\u0013\u0018\r\u001d5QCJ$\u0018\u000e^5p]\u0006!1m\u001c8g!\t9E*D\u0001I\u0015\tI%*\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u0017\u000e\n\u0001\u0002^=qKN\fg-Z\u0005\u0003\u001b\"\u0013aaQ8oM&<\u0017!\u0001$\u0011\u0007A[fL\u0004\u0002R1:\u0011!+\u0016\b\u0003eMK\u0011\u0001V\u0001\u0005G\u0006$8/\u0003\u0002W/\u00061QM\u001a4fGRT\u0011\u0001V\u0005\u00033j\u000bq\u0001]1dW\u0006<WM\u0003\u0002W/&\u0011A,\u0018\u0002\u0006\u0003NLhn\u0019\u0006\u00033j\u0003\"a\u00181\r\u0001\u0011)\u0011\r\u0001b\u0001E\n\ta)\u0006\u0002dUF\u0011Am\u001a\t\u0003Q\u0015L!AZ\u0015\u0003\u000f9{G\u000f[5oOB\u0011\u0001\u0006[\u0005\u0003S&\u00121!\u00118z\t\u0015Y\u0007M1\u0001d\u0005\u0011yF\u0005J\u0019\u0002\rqJg.\u001b;?)\u0015q'o\u001d;v)\ty\u0017\u000fE\u0002q\u0001yk\u0011a\u0007\u0005\u0006\u001d\u001a\u0001\u001da\u0014\u0005\u0006[\u0019\u0001\ra\f\u0005\u0006u\u0019\u0001\ra\u000f\u0005\u0006}\u0019\u0001\ra\u0010\u0005\u0006\u000b\u001a\u0001\rAR\u0001\fa\u0006\u0014H/\u001b;j_:,'/F\u0001y!\tIH0D\u0001{\u0015\tYx$\u0001\u0006nC:\fw-Z7f]RL!! >\u0003\u0017A\u000b'\u000f^5uS>tWM]\u0001\ra\u0006\u0014H/\u001b;j_:,'\u000fI\u0001\u0014m\u0016\u0014H/\u001a=BI\u0012LG/[8o\u0007>,h\u000e^\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00185\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0004D_VtG/\u001a:\u000b\t\u00055\u0011qB\u0001\u0007G2LWM\u001c;\u000b\t\u0005E\u00111C\u0001\u000baJ|W.\u001a;iKV\u001c(BAA\u000b\u0003\tIw.\u0003\u0003\u0002\u001a\u0005\u001d!!B\"iS2$\u0017\u0001\u0006<feR,\u00070\u00113eSRLwN\\\"pk:$\b%\u0001\u0007fI\u001e,\u0017\t\u001a3D_VtG/A\u0007fI\u001e,\u0017\t\u001a3D_VtG\u000fI\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-\"*\u0001\u0007tG\u0006d\u0017\r\\8hO&tw-\u0003\u0003\u00020\u0005%\"A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u001dA\u0014xnY3tgV\u0003H-\u0019;fgR!\u0011qGA !\u0011y\u0006-!\u000f\u0011\u0007!\nY$C\u0002\u0002>%\u0012A!\u00168ji\"9\u0011\u0011I\bA\u0002\u0005\r\u0013a\u0001:fcB!\u0011QIA&\u001b\t\t9EC\u0002\u0002J\u0005\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003\u001b\n9E\u0001\tHe\u0006\u0004\b.\u00117uKJ\fG/[8og\u00061\u0002.\u00198eY\u0016dunY1m\u00032$XM]1uS>t7\u000f\u0006\u0003\u0002:\u0005M\u0003bBA+!\u0001\u0007\u00111I\u0001\u0005[N<7/\u0001\tqe>\u001cWm]:WKJ$X\r_!eIR!\u0011\u0011HA.\u0011\u001d\ti&\u0005a\u0001\u0003?\na!\u001e9eCR,\u0007\u0003BA1\u0003orA!a\u0019\u0002t9!\u0011QMA9\u001d\u0011\t9'a\u001c\u000f\t\u0005%\u0014Q\u000e\b\u0004e\u0005-\u0014\"\u0001\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\t\u0011u$C\u0002\u0002v\u0005\u000bqb\u0012:ba\"\fE\u000e^3sCRLwN\\\u0005\u0005\u0003s\nYHA\u0005WKJ$X\r_!eI*\u0019\u0011QO!\u0002\u001dA\u0014xnY3tg\u0016#w-Z!eIR!\u0011\u0011HAA\u0011\u001d\t\u0019I\u0005a\u0001\u0003\u000b\u000b1!\u001e9e!\u0011\t\t'a\"\n\t\u0005%\u00151\u0010\u0002\b\u000b\u0012<W-\u00113e\u0003\u00199&/\u001b;feB\u0011\u0001\u000fF\n\u0003)\u001d\"\"!!$\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005]\u00151\u0015\u000b\r\u00033\u000b\u0019,!.\u00028\u0006e\u0016\u0011\u001a\u000b\u0005\u00037\u000bi\u000bE\u0004Q\u0003;\u000b\t+a+\n\u0007\u0005}UL\u0001\u0005SKN|WO]2f!\ry\u00161\u0015\u0003\u0007Cb\u0011\r!!*\u0016\u0007\r\f9\u000bB\u0004\u0002*\u0006\r&\u0019A2\u0003\t}#CE\r\t\u0005a\u0002\t\t\u000bC\u0005\u00020b\t\t\u0011q\u0001\u00022\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\tA[\u0016\u0011\u0015\u0005\u0006[a\u0001\ra\f\u0005\u0006ua\u0001\ra\u000f\u0005\u0006}a\u0001\ra\u0010\u0005\b\u0003wC\u0002\u0019AA_\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007a\u0005}6(a1\n\u0007\u0005\u0005\u0017HA\u0002NCB\u0004b!!\u0012\u0002F\u0006\u0005\u0016\u0002BAd\u0003\u000f\u0012\u0001\u0003U1si&$\u0018n\u001c8TKJ4\u0018nY3\t\u000b\u0015C\u0002\u0019\u0001$\u0002\u001dM$\u0018M\u001d;va6+7o]1hKV!\u0011qZAk)\u0019\t\t.!:\u0002jR!\u00111[Ao!\u0015y\u0016Q[A\u001d\t\u0019\t\u0017D1\u0001\u0002XV\u00191-!7\u0005\u000f\u0005m\u0017Q\u001bb\u0001G\n!q\f\n\u00134\u0011%\ty.GA\u0001\u0002\b\t\t/\u0001\u0006fm&$WM\\2fII\u0002B\u0001U.\u0002dB\u0019q,!6\t\r\u0005\u001d\u0018\u00041\u00010\u0003\u001d9'/\u00199i\u0013\u0012Da!a;\u001a\u0001\u0004Y\u0014a\u00039beRLG/[8o\u0013\u0012\u0004")
public class Writer<F> {
    private final int partitionID;
    private final GraphPartition storage;
    private final Async<F> F;
    private final Partitioner partitioner;
    private final Counter.Child vertexAdditionCount;
    private final Counter.Child edgeAddCount;
    private final Logger logger;

    public static <F> Resource<F, Writer<F>> apply(String graphID, int partitionID, GraphPartition storage, Map<Object, PartitionService<F>> partitions, Config conf, Async<F> evidence$1) {
        return Writer$.MODULE$.apply(graphID, partitionID, storage, partitions, conf, evidence$1);
    }

    private Partitioner partitioner() {
        return this.partitioner;
    }

    private Counter.Child vertexAdditionCount() {
        return this.vertexAdditionCount;
    }

    private Counter.Child edgeAddCount() {
        return this.edgeAddCount;
    }

    private Logger logger() {
        return this.logger;
    }

    public F processUpdates(GraphAlterations req) {
        return (F)package$.MODULE$.Async().apply(this.F).blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> this.handleLocalAlterations(req));
    }

    private void handleLocalAlterations(GraphAlterations msgs) {
        msgs.alterations().view().map((Function1 & Serializable)x$1 -> x$1.alteration()).foreach((Function1 & Serializable)x0$1 -> {
            Writer.$anonfun$handleLocalAlterations$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void processVertexAdd(GraphAlteration.VertexAdd update) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Partition {}: Received VertexAdd message '{}'.", new Object[]{BoxesRunTime.boxToInteger((int)this.partitionID), update});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.storage.addVertex(update.sourceID(), update.updateTime(), update.index(), update.srcId(), update.properties(), update.vType());
        this.vertexAdditionCount().inc();
    }

    public void processEdgeAdd(GraphAlteration.EdgeAdd upd) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Partition {}: Received EdgeAdd message '{}'.", new Object[]{BoxesRunTime.boxToInteger((int)this.partitionID), upd});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int srcPartition = this.partitioner().getPartitionForId(upd.srcId());
        int dstPartition = this.partitioner().getPartitionForId(upd.dstId());
        if (srcPartition == this.partitionID && dstPartition == this.partitionID) {
            this.storage.addLocalEdge(upd.sourceID(), upd.updateTime(), upd.index(), upd.srcId(), upd.dstId(), upd.properties(), upd.eType());
        } else if (srcPartition == this.partitionID) {
            this.storage.addOutgoingEdge(upd.sourceID(), upd.updateTime(), upd.index(), upd.srcId(), upd.dstId(), upd.properties(), upd.eType());
        } else {
            this.storage.addIncomingEdge(upd.sourceID(), upd.updateTime(), upd.index(), upd.srcId(), upd.dstId(), upd.properties(), upd.eType());
        }
        this.edgeAddCount().inc();
    }

    public static final /* synthetic */ void $anonfun$handleLocalAlterations$2(Writer $this, GraphAlteration x0$1) {
        GraphAlteration graphAlteration = x0$1;
        if (graphAlteration instanceof GraphAlteration.VertexAdd) {
            GraphAlteration.VertexAdd vertexAdd = (GraphAlteration.VertexAdd)graphAlteration;
            $this.processVertexAdd(vertexAdd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (graphAlteration instanceof GraphAlteration.EdgeAdd) {
            GraphAlteration.EdgeAdd edgeAdd = (GraphAlteration.EdgeAdd)graphAlteration;
            $this.processEdgeAdd(edgeAdd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)graphAlteration);
        }
    }

    public Writer(String graphID, int partitionID, GraphPartition storage, Config conf, Async<F> F) {
        this.partitionID = partitionID;
        this.storage = storage;
        this.F = F;
        this.partitioner = Partitioner$.MODULE$.apply(conf);
        this.vertexAdditionCount = (Counter.Child)TelemetryReporter$.MODULE$.writerVertexAdditions().labels(new String[]{Integer.toString(partitionID), graphID});
        this.edgeAddCount = (Counter.Child)TelemetryReporter$.MODULE$.writerEdgeAdditions().labels(new String[]{Integer.toString(partitionID), graphID});
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
    }
}

