/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.time;

import com.github.takezoe.scaladoc.Scaladoc;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base trait for classes representing an interval.\n  *\n  * An interval is the space between two points in time.\n  * The dimension of this time space might be expressed in terms of the the actual one or using an alternative scale,\n  * but `toString` must return a representation in accordance.\n  *\n  * Implementations of this trait must override `toString`, `*`, and `/` methods.\n  */")
@ScalaSignature(bytes="\u0006\u0005\u00194qa\u0002\u0005\u0011\u0002\u0007\u0005\u0012\u0003C\u0003'\u0001\u0011\u0005q\u0005C\u0003,\u0001\u0019\u0005A\u0006C\u0003D\u0001\u0019\u0005A\tC\u0003N\u0001\u0019\u0005a\nC\u0003T\u0001\u0019EA\u000bC\u0003V\u0001\u0011\u0005cK\u0001\u0005J]R,'O^1m\u0015\tI!\"\u0001\u0003uS6,'BA\u0006\r\u0003\r\t\u0007/\u001b\u0006\u0003\u001b9\t\u0001B]1qQR|'/\u001f\u0006\u0002\u001f\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\rI\u0012\u0005\n\b\u00035}q!a\u0007\u0010\u000e\u0003qQ!!\b\t\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012B\u0001\u0011\u0015\u0003\u001d\u0001\u0018mY6bO\u0016L!AI\u0012\u0003\u000f=\u0013H-\u001a:fI*\u0011\u0001\u0005\u0006\t\u0003K\u0001i\u0011\u0001C\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003!\u0002\"aE\u0015\n\u0005)\"\"\u0001B+oSR\f\u0001\u0002^8TiJLgnZ\u000b\u0002[A\u0011aF\r\b\u0003_A\u0002\"a\u0007\u000b\n\u0005E\"\u0012A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u000b)\t\t1\u0004)\u0011\t\u0003oyj\u0011\u0001\u000f\u0006\u0003si\n\u0001b]2bY\u0006$wn\u0019\u0006\u0003wq\nq\u0001^1lKj|WM\u0003\u0002>\u001d\u00051q-\u001b;ik\nL!a\u0010\u001d\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013AQ\u0001=_)R\u0003EU3ukJt7\u000fI1!AN#(/\u001b8hA\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:\u0004sN\u001a\u0011uQ&\u001c\b\u0005Y%oi\u0016\u0014h/\u00197a]\u0001Rs&\u0001\u0004%i&lWm\u001d\u000b\u0003I\u0015CQAR\u0002A\u0002\u001d\u000baA\\;nE\u0016\u0014\bCA\nI\u0013\tIEC\u0001\u0003M_:<\u0007\u0006B\u00027\u0001.\u000b\u0013\u0001T\u0001V_)R\u0003EU3ukJt7\u000f\t;iK\u0002\u0002\u0017J\u001c;feZ\fG\u000e\u0019\u0011sKN,H\u000e^5oO\u00022'o\\7![VdG/\u001b9ms&tw\r\t;iSN\u0004\u0003-\u00138uKJ4\u0018\r\u001c1!Ef\u0004\u0003M\\;nE\u0016\u0014\bM\f\u0011+_\u0005!A\u0005Z5w)\t!s\nC\u0003G\t\u0001\u0007q\t\u000b\u0003\u0005m\u0001\u000b\u0016%\u0001*\u0002]>R#\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0003-\u00138uKJ4\u0018\r\u001c1!e\u0016\u001cX\u000f\u001c;j]\u001e\u0004cM]8nA\u0011Lg/\u001b3j]\u001e\u0004C\u000f[5tA\u0001Le\u000e^3sm\u0006d\u0007\r\t2zA\u0001tW/\u001c2fe\u0002\u0004\u0003&\\5hQR\u0004#-\u001a\u0011b]\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^5p]&r\u0003EK\u0018\u0002\rQ|Gj\u001c8h+\u00059\u0015aB2p[B\f'/\u001a\u000b\u0003/j\u0003\"a\u0005-\n\u0005e#\"aA%oi\")1L\u0002a\u0001I\u0005!A\u000f[1uS\u0011\u0001QlX1\n\u0005yC!\u0001\u0005#jg\u000e\u0014X\r^3J]R,'O^1m\u0015\t\u0001\u0007\"\u0001\u0007Ok2d\u0017J\u001c;feZ\fG.\u0003\u0002c\u0011\taA+[7f\u0013:$XM\u001d<bY\"\"\u0001A\u000e!eC\u0005)\u0017aa\u00010U)\u0002#)Y:fAQ\u0014\u0018-\u001b;!M>\u0014\be\u00197bgN,7\u000f\t:faJ,7/\u001a8uS:<\u0007%\u00198!S:$XM\u001d<bY:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003%\u00118!S:$XM\u001d<bY\u0002J7\u000f\t;iK\u0002\u001a\b/Y2fA\t,Go^3f]\u0002\"xo\u001c\u0011q_&tGo\u001d\u0011j]\u0002\"\u0018.\\3/\u0015\u0001\u0002#\u0006\t+iK\u0002\"\u0017.\\3og&|g\u000eI8gAQD\u0017n\u001d\u0011uS6,\u0007e\u001d9bG\u0016\u0004S.[4ii\u0002\u0012W\rI3yaJ,7o]3eA%t\u0007\u0005^3s[N\u0004sN\u001a\u0011uQ\u0016\u0004C\u000f[3!C\u000e$X/\u00197!_:,\u0007e\u001c:!kNLgn\u001a\u0011b]\u0002\nG\u000e^3s]\u0006$\u0018N^3!g\u000e\fG.\u001a\u0017\u000bA\u0001R\u0003EY;uA\u0001$xn\u0015;sS:<\u0007\rI7vgR\u0004#/\u001a;ve:\u0004\u0013\r\t:faJ,7/\u001a8uCRLwN\u001c\u0011j]\u0002\n7mY8sI\u0006t7-\u001a\u0018\u000bA\u0001R#\u0002\t\u0011+A%k\u0007\u000f\\3nK:$\u0018\r^5p]N\u0004sN\u001a\u0011uQ&\u001c\b\u0005\u001e:bSR\u0004S.^:uA=4XM\u001d:jI\u0016\u0004\u0003\r^8TiJLgn\u001a1-A\u0001T\u0003\r\f\u0011b]\u0012\u0004\u0003m\f1![\u0016$\bn\u001c3t])\u0001\u0003EK\u0018")
public interface Interval
extends Ordered<Interval> {
    @Scaladoc(value="/** Returns a `String` representation of this `Interval`. */")
    public String toString();

    @Scaladoc(value="/** Returns the `Interval` resulting from multiplying this `Interval` by `number`. */")
    public Interval $times(long var1);

    @Scaladoc(value="/** Returns the `Interval` resulting from dividing this `Interval` by `number` (might be an approximation). */")
    public Interval $div(long var1);

    public long toLong();

    public static /* synthetic */ int compare$(Interval $this, Interval that) {
        return $this.compare(that);
    }

    default public int compare(Interval that) {
        return (int)(this.toLong() - that.toLong());
    }

    public static void $init$(Interval $this) {
    }
}

