/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.output.sink;

import com.github.takezoe.scaladoc.Scaladoc;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base trait for sink connectors.\n  *\n  * A `SinkConnector` enables implementations of `Format` to write just one or a collection of textual items.\n  *\n  * An item is a piece of information meaningful by itself and isolated from all other other entities from the perspective of the format.\n  * Entities can be separated automatically from the others if such a concept exists in the underlying sinks technology.\n  * For instance, in a message system such as Pulsar, each item might be sent in a separate message.\n  * If this doesn't exist, a delimiter may instead be used.\n  * For instance, in a file sink, a newline character delimiter `\"\\n\"` can be used.\n  *\n  * Implementations of this trait are intended to be used by calling `write` one or more times to compose an item\n  * and `closeItem` when the current item is completed.\n  * Some formats might want to output just one item if its output cannot be split.\n  *\n  * @see [[com.raphtory.api.output.format.Format Format]]\n  *      [[com.raphtory.api.output.sink.Sink Sink]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\t3q\u0001B\u0003\u0011\u0002G\u0005\u0001\u0003C\u0003\u0018\u0001\u0019\u0005\u0001\u0004C\u00037\u0001\u0019\u0005q\u0007C\u0003<\u0001\u0019\u0005qGA\u0007TS:\\7i\u001c8oK\u000e$xN\u001d\u0006\u0003\r\u001d\tAa]5oW*\u0011\u0001\"C\u0001\u0007_V$\b/\u001e;\u000b\u0005)Y\u0011aA1qS*\u0011A\"D\u0001\te\u0006\u0004\b\u000e^8ss*\ta\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001#A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\fQa\u001e:ji\u0016$\"!\u0007\u000f\u0011\u0005IQ\u0012BA\u000e\u0014\u0005\u0011)f.\u001b;\t\u000bu\t\u0001\u0019\u0001\u0010\u0002\u000bY\fG.^3\u0011\u0005}1cB\u0001\u0011%!\t\t3#D\u0001#\u0015\t\u0019s\"\u0001\u0004=e>|GOP\u0005\u0003KM\ta\u0001\u0015:fI\u00164\u0017BA\u0014)\u0005\u0019\u0019FO]5oO*\u0011Qe\u0005\u0015\u0005\u0003)jB\u0007\u0005\u0002,e5\tAF\u0003\u0002.]\u0005A1oY1mC\u0012|7M\u0003\u00020a\u00059A/Y6fu>,'BA\u0019\u000e\u0003\u00199\u0017\u000e\u001e5vE&\u00111\u0007\f\u0002\t'\u000e\fG.\u00193pG\u0006\nQ'A,0U)\u0002\u0013\t\u001d9f]\u0012\u001c\b%\u0019\u0011am\u0006dW/\u001a1!i>\u0004C\u000f[3!GV\u0014(/\u001a8uA%$X-\u001c\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t<bYV,\u0007\u0005\u001e5fAY\fG.^3!i>\u0004\u0013\r\u001d9f]\u0012T\u0001\u0005\t\u0011!U=\n\u0011b\u00197pg\u0016LE/Z7\u0015\u0003eACA\u0001\u0016\u001es\u0005\n!(\u0001\u00190U)\u00023i\\7qY\u0016$Xm\u001d\u0011uQ\u0016\u0004sO]5uS:<\u0007e\u001c4!i\",\u0007eY;se\u0016tG\u000fI5uK6\u0004#fL\u0001\u0006G2|7/\u001a\u0015\u0005\u0007)jR(I\u0001?\u0003\u0001|#F\u000b\u0011F]N,(/Z:!i\"\fG\u000f\t;iK\u0002zW\u000f\u001e9vi\u0002zg\r\t;iSN\u00043/\u001b8lA\r|W\u000e\u001d7fi\u0016$\u0007%\u00198eA\u0019\u0014X-Z:!kB\u0004\u0013\r\u001c7!i\",\u0007E]3t_V\u00148-Z:!kN,G\r\t2zA%$h\u0006\t\u00160Q\u0011\u0001!&\b!\"\u0003\u0005\u000b\u00012C\u0018+U\u0001\u0012\u0015m]3!iJ\f\u0017\u000e\u001e\u0011g_J\u00043/\u001b8lA\r|gN\\3di>\u00148O\f\u0006!A)R\u0001\u0005\t\u0016!\u0003\u0002\u00027+\u001b8l\u0007>tg.Z2u_J\u0004\u0007%\u001a8bE2,7\u000fI5na2,W.\u001a8uCRLwN\\:!_\u001a\u0004\u0003MR8s[\u0006$\b\r\t;pA]\u0014\u0018\u000e^3!UV\u001cH\u000fI8oK\u0002z'\u000fI1!G>dG.Z2uS>t\u0007e\u001c4!i\u0016DH/^1mA%$X-\\:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\ne\u000eI5uK6\u0004\u0013n\u001d\u0011bAALWmY3!_\u001a\u0004\u0013N\u001c4pe6\fG/[8oA5,\u0017M\\5oO\u001a,H\u000e\t2zA%$8/\u001a7gA\u0005tG\rI5t_2\fG/\u001a3!MJ|W\u000eI1mY\u0002zG\u000f[3sA=$\b.\u001a:!K:$\u0018\u000e^5fg\u00022'o\\7!i\",\u0007\u0005]3sgB,7\r^5wK\u0002zg\r\t;iK\u00022wN]7bi:R\u0001\u0005\t\u0016!\u000b:$\u0018\u000e^5fg\u0002\u001a\u0017M\u001c\u0011cK\u0002\u001aX\r]1sCR,G\rI1vi>l\u0017\r^5dC2d\u0017\u0010\t4s_6\u0004C\u000f[3!_RDWM]:!S\u001a\u00043/^2iA\u0005\u00043m\u001c8dKB$\b%\u001a=jgR\u001c\b%\u001b8!i\",\u0007%\u001e8eKJd\u00170\u001b8hAMLgn[:!i\u0016\u001c\u0007N\\8m_\u001eLhF\u0003\u0011!U\u00012uN\u001d\u0011j]N$\u0018M\\2fY\u0001Jg\u000eI1![\u0016\u001c8/Y4fAML8\u000f^3nAM,8\r\u001b\u0011bg\u0002\u0002V\u000f\\:be2\u0002S-Y2iA%$X-\u001c\u0011nS\u001eDG\u000f\t2fAM,g\u000e\u001e\u0011j]\u0002\n\u0007e]3qCJ\fG/\u001a\u0011nKN\u001c\u0018mZ3/\u0015\u0001\u0002#\u0006I%gAQD\u0017n\u001d\u0011e_\u0016\u001chn\n;!KbL7\u000f\u001e\u0017!C\u0002\"W\r\\5nSR,'\u000fI7bs\u0002Jgn\u001d;fC\u0012\u0004#-\u001a\u0011vg\u0016$gF\u0003\u0011!U\u00012uN\u001d\u0011j]N$\u0018M\\2fY\u0001Jg\u000eI1!M&dW\rI:j].d\u0003%\u0019\u0011oK^d\u0017N\\3!G\"\f'/Y2uKJ\u0004C-\u001a7j[&$XM\u001d\u0011aEqs'\u0005\u0019\u0011dC:\u0004#-\u001a\u0011vg\u0016$gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011J[BdW-\\3oi\u0006$\u0018n\u001c8tA=4\u0007\u0005\u001e5jg\u0002\"(/Y5uA\u0005\u0014X\rI5oi\u0016tG-\u001a3!i>\u0004#-\u001a\u0011vg\u0016$\u0007EY=!G\u0006dG.\u001b8hA\u0001<(/\u001b;fA\u0002zg.\u001a\u0011pe\u0002jwN]3!i&lWm\u001d\u0011u_\u0002\u001aw.\u001c9pg\u0016\u0004\u0013M\u001c\u0011ji\u0016l'\u0002\t\u0011+A\u0005tG\r\t1dY>\u001cX-\u0013;f[\u0002\u0004s\u000f[3oAQDW\rI2veJ,g\u000e\u001e\u0011ji\u0016l\u0007%[:!G>l\u0007\u000f\\3uK\u0012t#\u0002\t\u0011+AM{W.\u001a\u0011g_Jl\u0017\r^:![&<\u0007\u000e\u001e\u0011xC:$\b\u0005^8!_V$\b/\u001e;!UV\u001cH\u000fI8oK\u0002JG/Z7!S\u001a\u0004\u0013\u000e^:!_V$\b/\u001e;!G\u0006tgn\u001c;!E\u0016\u00043\u000f\u001d7ji:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005Q:fK\u0002Z6lY8n]I\f\u0007\u000f\u001b;peft\u0013\r]5/_V$\b/\u001e;/M>\u0014X.\u0019;/\r>\u0014X.\u0019;!\r>\u0014X.\u0019;^;*\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003eW.d_6t#/\u00199ii>\u0014\u0018PL1qS:zW\u000f\u001e9vi:\u001a\u0018N\\6/'&t7\u000eI*j].lVL\u0003\u0011!U=\u0002")
public interface SinkConnector {
    @Scaladoc(value="/** Appends a `value` to the current item\n    * @param value the value to append\n    */")
    public void write(String var1);

    @Scaladoc(value="/** Completes the writing of the current item */")
    public void closeItem();

    @Scaladoc(value="/** Ensures that the output of this sink completed and frees up all the resources used by it. */")
    public void close();
}

