/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.table;

import com.github.takezoe.scaladoc.Scaladoc;
import com.google.protobuf.ByteString;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.RowImplementation;
import com.raphtory.internals.components.querymanager.ProtoField;
import com.raphtory.internals.serialisers.KryoSerialiser;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalapb.TypeMapper;

@Scaladoc(value="/** Factory object for Rows */")
public final class Row$
implements ProtoField<Row> {
    public static final Row$ MODULE$ = new Row$();
    private static final Logger logger;
    private static final ThreadLocal<ArrayBuffer<RowImplementation>> pool;
    private static KryoSerialiser com$raphtory$internals$components$querymanager$ProtoField$$kryo;
    private static TypeMapper<ByteString, Row> tmf;

    static {
        ProtoField.$init$(MODULE$);
        logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(MODULE$.getClass()));
        pool = ThreadLocal.withInitial(() -> ArrayBuffer$.MODULE$.empty());
    }

    @Override
    public KryoSerialiser com$raphtory$internals$components$querymanager$ProtoField$$kryo() {
        return com$raphtory$internals$components$querymanager$ProtoField$$kryo;
    }

    @Override
    public TypeMapper<ByteString, Row> tmf() {
        return tmf;
    }

    @Override
    public final void com$raphtory$internals$components$querymanager$ProtoField$_setter_$com$raphtory$internals$components$querymanager$ProtoField$$kryo_$eq(KryoSerialiser x$1) {
        com$raphtory$internals$components$querymanager$ProtoField$$kryo = x$1;
    }

    @Override
    public void com$raphtory$internals$components$querymanager$ProtoField$_setter_$tmf_$eq(TypeMapper<ByteString, Row> x$1) {
        tmf = x$1;
    }

    private Logger logger() {
        return logger;
    }

    public ThreadLocal<ArrayBuffer<RowImplementation>> pool() {
        return pool;
    }

    /*
     * WARNING - void declaration
     */
    @Scaladoc(value="/** Create a new Row object */")
    public Row apply(Seq<Object> values) {
        void var3_4;
        RowImplementation rowImplementation;
        ArrayBuffer<RowImplementation> localPool = this.pool().get();
        if (localPool.isEmpty()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("new row object initialised on thread {}", (Object)Thread.currentThread().getName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            rowImplementation = new RowImplementation();
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Row object reused on thread {}, pool size = {}", new Object[]{Thread.currentThread().getName(), BoxesRunTime.boxToInteger((int)localPool.size())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            RowImplementation row = (RowImplementation)localPool.last();
            localPool.dropRightInPlace(1);
            rowImplementation = row;
        }
        RowImplementation row = rowImplementation;
        row.init(values);
        return var3_4;
    }

    private Row$() {
    }
}

