/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.temporal.Descendants$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.HistoricEvent;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`Descendants(seed:String, time:Long, delta:Long=Long.MaxValue, directed:Boolean=true)`\n  *  : find all descendants of a vertex at a given time point\n  *\n  * The descendants of a seed vertex are defined as those vertices which can be reached from the seed vertex\n  * via a temporal path (in a temporal path the time of the next edge is always later than the time of the previous edge)\n  * starting after the specified time.\n  *\n  * ## Parameters\n  *\n  *  {s}`seed: String`\n  *    : The name of the target vertex\n  *\n  *  {s}`time: Long`\n  *    : The time of interest\n  *\n  *  {s}`delta: Long = Long.MaxValue`\n  *    : The maximum timespan for the temporal path. This is currently exclusive of the newest time\n  *       i.e. if looking forward a minute it will not include events that happen exactly 1 minute into the future.\n  *\n  *  {s}`directed: Boolean = true`\n  *    : whether to treat the network as directed\n  *\n  *  {s}`strict: Boolean = true`\n  *    : Whether firstActivityAfter is strict in its following of paths that happen exactly at the given time. True will not follow, False will.\n  *\n  * ## States\n  *\n  *  {s}`descendant: Boolean`\n  *    : flag indicating that the vertex is a descendant of {s}`seed`\n  *\n  * ## Returns\n  *\n  *  | vertex name       | is descendant of seed?   |\n  *  | ----------------- | ---------------------- |\n  *  | {s}`name: String` | {s}`descendant: Boolean` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\u000b\u0016\u0001yA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013\t\u0005\"B#\u0001\t\u00031\u0005\"\u0002(\u0001\t\u0003z\u0005\"B/\u0001\t\u0003rv!\u0002;\u0016\u0011\u0003)h!\u0002\u000b\u0016\u0011\u00031\b\"B#\u000b\t\u0003y\bB\u0002(\u000b\t\u0003\t\t\u0001C\u0005\u0002\u000e)\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0006\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003WQ\u0011\u0013!C\u0001\u0003OA\u0011\"!\f\u000b#\u0003%\t!a\u0004\t\u0013\u0005=\"\"%A\u0005\u0002\u0005\u001d\u0002\"CA\u0019\u0015E\u0005I\u0011AA\u0014\u0011%\t\u0019DCA\u0001\n\u0013\t)DA\u0006EKN\u001cWM\u001c3b]R\u001c(B\u0001\f\u0018\u0003!!X-\u001c9pe\u0006d'B\u0001\r\u001a\u0003)\tGnZ8sSRDWn\u001d\u0006\u00035m\t\u0001B]1qQR|'/\u001f\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1S&D\u0001(\u0015\tA\u0013&A\u0005bY\u001e|'/\u001b;i[*\u0011!fK\u0001\tC:\fG._:jg*\u0011A&G\u0001\u0004CBL\u0017B\u0001\u0018(\u0005\u001d9UM\\3sS\u000e\fAa]3fIB\u0011\u0011\u0007\u000f\b\u0003eY\u0002\"aM\u0011\u000e\u0003QR!!N\u000f\u0002\rq\u0012xn\u001c;?\u0013\t9\u0014%\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c\"\u0003\u0011!\u0018.\\3\u0011\u0005\u0001j\u0014B\u0001 \"\u0005\u0011auN\\4\u0002\u000b\u0011,G\u000e^1\u0002\u0011\u0011L'/Z2uK\u0012\u0004\"\u0001\t\"\n\u0005\r\u000b#a\u0002\"p_2,\u0017M\\\u0001\u0007gR\u0014\u0018n\u0019;\u0002\rqJg.\u001b;?)\u00199\u0015JS&M\u001bB\u0011\u0001\nA\u0007\u0002+!)qF\u0002a\u0001a!)1H\u0002a\u0001y!9qH\u0002I\u0001\u0002\u0004a\u0004b\u0002!\u0007!\u0003\u0005\r!\u0011\u0005\b\t\u001a\u0001\n\u00111\u0001B\u0003\u0015\t\u0007\u000f\u001d7z)\t\u00016\u000b\u0005\u0002R7:\u0011!k\u0015\u0007\u0001\u0011\u0015!v\u00011\u0001V\u0003\u00159'/\u00199i!\t1\u0016,D\u0001X\u0015\tA\u0016&A\u0005he\u0006\u0004\bN^5fo&\u0011!l\u0016\u0002\u0011\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016L!\u0001X-\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0002\u0015Q\f'-\u001e7be&\u001cX\r\u0006\u0002`KB\u0011\u0001mY\u0007\u0002C*\u0011!-K\u0001\u0006i\u0006\u0014G.Z\u0005\u0003I\u0006\u0014Q\u0001V1cY\u0016DQ\u0001\u0016\u0005A\u0002UCC\u0001A4reB\u0011\u0001n\\\u0007\u0002S*\u0011!n[\u0001\tg\u000e\fG.\u00193pG*\u0011A.\\\u0001\bi\u0006\\WM_8f\u0015\tq7$\u0001\u0004hSRDWOY\u0005\u0003a&\u0014\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0002g\u0006Yya\f\u0016+\u0015\u0001\u0002#\u0006I>t{\u0002$Um]2f]\u0012\fg\u000e^:)g\u0016,GMO*ue&tw\r\f\u0011uS6,'\bT8oO2\u0002C-\u001a7uCjbuN\\4>\u0019>twML'bqZ\u000bG.^3-A\u0011L'/Z2uK\u0012T$i\\8mK\u0006tW\b\u001e:vK&\u0002'\u0002\t\u0011+A\u0001R\u0004EZ5oI\u0002\nG\u000e\u001c\u0011eKN\u001cWM\u001c3b]R\u001c\be\u001c4!C\u00022XM\u001d;fq\u0002\nG\u000fI1!O&4XM\u001c\u0011uS6,\u0007\u0005]8j]RT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00165fA\u0011,7oY3oI\u0006tGo\u001d\u0011pM\u0002\n\u0007e]3fI\u00022XM\u001d;fq\u0002\n'/\u001a\u0011eK\u001aLg.\u001a3!CN\u0004C\u000f[8tK\u00022XM\u001d;jG\u0016\u001c\be\u001e5jG\"\u00043-\u00198!E\u0016\u0004#/Z1dQ\u0016$\u0007E\u001a:p[\u0002\"\b.\u001a\u0011tK\u0016$\u0007E^3si\u0016D(\u0002\t\u0011+AYL\u0017\rI1!i\u0016l\u0007o\u001c:bY\u0002\u0002\u0018\r\u001e5!Q%t\u0007%\u0019\u0011uK6\u0004xN]1mAA\fG\u000f\u001b\u0011uQ\u0016\u0004C/[7fA=4\u0007\u0005\u001e5fA9,\u0007\u0010\u001e\u0011fI\u001e,\u0007%[:!C2<\u0018-_:!Y\u0006$XM\u001d\u0011uQ\u0006t\u0007\u0005\u001e5fAQLW.\u001a\u0011pM\u0002\"\b.\u001a\u0011qe\u00164\u0018n\\;tA\u0015$w-Z\u0015\u000bA\u0001R\u0003e\u001d;beRLgn\u001a\u0011bMR,'\u000f\t;iK\u0002\u001a\b/Z2jM&,G\r\t;j[\u0016t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AA\u000b'/Y7fi\u0016\u00148O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\bm]3fIj\u00023\u000b\u001e:j]\u001e\u0004'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011UQ\u0016\u0004c.Y7fA=4\u0007\u0005\u001e5fAQ\f'oZ3uAY,'\u000f^3y\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?ai&lWM\u000f\u0011M_:<\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!)\",\u0007\u0005^5nK\u0002zg\rI5oi\u0016\u0014Xm\u001d;\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1eK2$\u0018M\u000f\u0011M_:<\u0007%\u0010\u0011M_:<g&T1y-\u0006dW/\u001a1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\"\u0006.\u001a\u0011nCbLW.^7!i&lWm\u001d9b]\u00022wN\u001d\u0011uQ\u0016\u0004C/Z7q_J\fG\u000e\t9bi\"t\u0003\u0005\u00165jg\u0002J7\u000fI2veJ,g\u000e\u001e7zA\u0015D8\r\\;tSZ,\u0007e\u001c4!i\",\u0007E\\3xKN$\b\u0005^5nK*\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005I5/K:\u0002\u0013N\u001a\u0011m_>\\\u0017N\\4!M>\u0014x/\u0019:eA\u0005\u0004S.\u001b8vi\u0016\u0004\u0013\u000e\u001e\u0011xS2d\u0007E\\8uA%t7\r\\;eK\u0002*g/\u001a8ug\u0002\"\b.\u0019;!Q\u0006\u0004\b/\u001a8!Kb\f7\r\u001e7zAE\u0002S.\u001b8vi\u0016\u0004\u0013N\u001c;pAQDW\r\t4viV\u0014XM\f\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00193je\u0016\u001cG/\u001a3;A\t{w\u000e\\3b]\u0002j\u0004\u0005\u001e:vK\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI<iKRDWM\u001d\u0011u_\u0002\"(/Z1uAQDW\r\t8fi^|'o\u001b\u0011bg\u0002\"\u0017N]3di\u0016$'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u00047\u000f\u001e:jGRT\u0004EQ8pY\u0016\fg\u000eI\u001f!iJ,X\r\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A]CW\r\u001e5fe\u00022\u0017N]:u\u0003\u000e$\u0018N^5us\u00063G/\u001a:!SN\u00043\u000f\u001e:jGR\u0004\u0013N\u001c\u0011jiN\u0004cm\u001c7m_^Lgn\u001a\u0011pM\u0002\u0002\u0018\r\u001e5tAQD\u0017\r\u001e\u0011iCB\u0004XM\u001c\u0011fq\u0006\u001cG\u000f\\=!CR\u0004C\u000f[3!O&4XM\u001c\u0011uS6,g\u0006\t+sk\u0016\u0004s/\u001b7mA9|G\u000f\t4pY2|w\u000f\f\u0011GC2\u001cX\rI<jY2t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AM#\u0018\r^3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?aI\u0016\u001c8-\u001a8eC:$(\b\t\"p_2,\u0017M\u001c1\u000bA\u0001R\u0003\u0005\t\u0011!u\u00012G.Y4!S:$\u0017nY1uS:<\u0007\u0005\u001e5bi\u0002\"\b.\u001a\u0011wKJ$X\r\u001f\u0011jg\u0002\n\u0007\u0005Z3tG\u0016tG-\u00198uA=4\u0007e_:~AN,W\r\u001a1\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003EU3ukJt7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!y\u00022XM\u001d;fq\u0002r\u0017-\\3!A\u0001\u0002\u0003\u0005\t\u0011}A%\u001c\b\u0005Z3tG\u0016tG-\u00198uA=4\u0007e]3fI~\u0002\u0003\u0005\t?\u000bA\u0001R\u0003\u0005\t?![5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.AqT\u0001\u0005\t\u0016!Aq\u00043p]?a]\u0006lWM\u000f\u0011TiJLgn\u001a1!y\u0002Z8/ 1eKN\u001cWM\u001c3b]RT\u0004EQ8pY\u0016\fg\u000e\u0019\u0011}\u0015\u0001\u0002#fL\u0001\f\t\u0016\u001c8-\u001a8eC:$8\u000f\u0005\u0002I\u0015M\u0019!bH<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018AA5p\u0015\u0005a\u0018\u0001\u00026bm\u0006L!A`=\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003U$2bRA\u0002\u0003\u000b\t9!!\u0003\u0002\f!)q\u0006\u0004a\u0001a!)1\b\u0004a\u0001y!9q\b\u0004I\u0001\u0002\u0004a\u0004b\u0002!\r!\u0003\u0005\r!\u0011\u0005\b\t2\u0001\n\u00111\u0001B\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aTCAA\tU\ra\u00141C\u0016\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0005v]\u000eDWmY6fI*\u0019\u0011qD\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002$\u0005e!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'\u0006\u0002\u0002*)\u001a\u0011)a\u0005\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003o\u0001B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{Y\u0018\u0001\u00027b]\u001eLA!!\u0011\u0002<\t1qJ\u00196fGR\u0004")
public class Descendants
implements Generic {
    private final String seed;
    private final long time;
    private final long delta;
    private final boolean directed;
    private final boolean strict;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static boolean $lessinit$greater$default$5() {
        return Descendants$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return Descendants$.MODULE$.$lessinit$greater$default$4();
    }

    public static long $lessinit$greater$default$3() {
        return Descendants$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean apply$default$5() {
        return Descendants$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return Descendants$.MODULE$.apply$default$4();
    }

    public static long apply$default$3() {
        return Descendants$.MODULE$.apply$default$3();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        ConcreteGraphPerspective qual$1 = graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Descendants.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)vertex -> {
            Descendants.$anonfun$apply$3(this, vertex);
            return BoxedUnit.UNIT;
        };
        boolean x$2 = true;
        int x$3 = 100;
        return qual$1.iterate(x$1, 100, true);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(vertex.name$default$1()), ((EntityVisitor)((Object)vertex)).getStateOrElse("descendant", BoxesRunTime.boxToBoolean((boolean)false), ((EntityVisitor)((Object)vertex)).getStateOrElse$default$3())})));
    }

    public static final /* synthetic */ void $anonfun$apply$2(Descendants $this, Vertex vertex$1, ConcreteEdge e) {
        Option<HistoricEvent> option = ((EntityVisitor)((Object)e)).firstActivityAfter($this.time, $this.strict);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            HistoricEvent event = (HistoricEvent)some.value();
            if (event.time() < $this.time + $this.delta) {
                vertex$1.messageVertex(e.ID(), BoxesRunTime.boxToLong((long)event.time()), SchemaProviderInstances$.MODULE$.longSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$1(Descendants $this, Vertex vertex) {
        block0: {
            String string = vertex.name(vertex.name$default$1());
            String string2 = $this.seed;
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            ($this.directed ? vertex.outEdges() : vertex.edges()).foreach((Function1 & Serializable)e -> {
                Descendants.$anonfun$apply$2($this, vertex, e);
                return BoxedUnit.UNIT;
            });
            ((EntityVisitor)((Object)vertex)).setState("descendant", BoxesRunTime.boxToBoolean((boolean)false));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(Descendants $this, Vertex vertex$2, ConcreteEdge e) {
        Option<HistoricEvent> option = ((EntityVisitor)((Object)e)).firstActivityAfter($this.time, $this.strict);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            HistoricEvent event = (HistoricEvent)some.value();
            if (event.time() < $this.time + $this.delta) {
                vertex$2.messageVertex(e.ID(), BoxesRunTime.boxToLong((long)event.time()), SchemaProviderInstances$.MODULE$.longSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$3(Descendants $this, Vertex vertex) {
        long earliestTime = BoxesRunTime.unboxToLong((Object)vertex.messageQueue().min((Ordering)Ordering.Long$.MODULE$));
        ((EntityVisitor)((Object)vertex)).setState("descendant", BoxesRunTime.boxToBoolean((boolean)true));
        ($this.directed ? vertex.outEdges() : vertex.edges()).foreach((Function1 & Serializable)e -> {
            Descendants.$anonfun$apply$4($this, vertex, e);
            return BoxedUnit.UNIT;
        });
    }

    public Descendants(String seed, long time, long delta, boolean directed, boolean strict) {
        this.seed = seed;
        this.time = time;
        this.delta = delta;
        this.directed = directed;
        this.strict = strict;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

