/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.motif.LocalTriangleCount$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`GlobalTriangleCount()`\n  *  : Returns the total number of undirected triangles in the graph.\n  *\n  * ## States\n  *\n  *  {s}`triangles: Int`\n  *    : three times the number of triangles (but returned in output without the factor of three).\n  *\n  * ## Returns\n  *\n  *  | total triangles      |\n  *  | -------------------- |\n  *  | {s}`triangles: Int`  |\n  *\n  * ```{note}\n  *  Edges here are treated as undirected, so if the underlying network is directed here,\n  * 'neighbours' refers to the union of in-neighbours and out-neighbours.\n  * ``\n  */")
public final class GlobalTriangleCount$
implements Generic {
    public static final GlobalTriangleCount$ MODULE$ = new GlobalTriangleCount$();
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private static Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    static {
        BaseAlgorithm.$init$(MODULE$);
        Generic.$init$(MODULE$);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return LocalTriangleCount$.MODULE$.apply(graph).setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            state.newAdder("triangles", true, Numeric.IntIsIntegral$.MODULE$);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            GlobalTriangleCount$.$anonfun$apply$2(vertex, state);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.globalSelect((Function1<GraphState, Row>)(Function1 & Serializable)state -> {
            int totalTri = BoxesRunTime.unboxToInt(state.apply("triangles").value());
            return Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(totalTri / 3))}));
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GlobalTriangleCount$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex, GraphState state) {
        int tri = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("triangleCount", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        state.apply("triangles").$plus$eq$mcI$sp(tri);
    }

    private GlobalTriangleCount$() {
    }
}

