/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.centrality.PageRank$;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`PageRank(dampingFactor:Double = 0.85, iterateSteps:Int = 100)`\n  *  : Compute PageRank for all nodes\n  *\n  * Page Rank algorithm ranks nodes depending on their connections to determine how important\n  * the node is. This assumes a node is more important if it receives more connections from others.\n  * Each vertex begins with an initial state. If it has any neighbours, it sends them a message\n  * which is the initial label / the number of neighbours.\n  * Each vertex, checks its messages and computes a new label based on: the total value of\n  * messages received and the damping factor. This new value is propogated to all outgoing neighbours.\n  * A vertex will stop propogating messages if its value becomes stagnant (i.e. has a change of less\n  * than 0.00001) This process is repeated for a number of iterate step times. Most algorithms should\n  * converge after approx. 20 iterations.\n  *\n  * ## Parameters\n  *\n  *  {s}`dampingFactor: Double = 0.85`\n  *    : Probability that a node will be randomly selected by a user traversing the graph, defaults to 0.85.\n  *\n  *  {s}`iterateSteps: Int = 100`\n  *    : Maximum number of iterations for the algorithm to run.\n  *\n  * ## States\n  *\n  *  {s}`prlabel: Double`\n  *    : PageRank of the node\n  *\n  * ## Returns\n  *\n  *  | vertex name       | PageRank             |\n  *  | ----------------- | -------------------- |\n  *  | {s}`name: String` | {s}`prlabel: Double` |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.centrality.WeightedPageRank\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001B\t\u0013\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!AQ\u0006\u0001B\u0001B\u0003%1\u0005C\u0003/\u0001\u0011\u0005q\u0006C\u00036\u0001\u0011\u0005cgB\u0003W%!\u0005qKB\u0003\u0012%!\u0005\u0001\fC\u0003/\u000f\u0011\u0005A\rC\u00036\u000f\u0011\u0005Q\rC\u0004j\u000fE\u0005I\u0011\u00016\t\u000fU<\u0011\u0013!C\u0001m\"9\u0001pBI\u0001\n\u0003Q\u0007bB=\b#\u0003%\tA\u001b\u0005\bu\u001e\t\n\u0011\"\u0001w\u0011\u001dYx!%A\u0005\u0002)Dq\u0001`\u0004\u0002\u0002\u0013%QP\u0001\u0005QC\u001e,'+\u00198l\u0015\t\u0019B#\u0001\u0006dK:$(/\u00197jifT!!\u0006\f\u0002\u000f\u001d,g.\u001a:jG*\u0011q\u0003G\u0001\u000bC2<wN]5uQ6\u001c(BA\r\u001b\u0003!\u0011\u0018\r\u001d5u_JL(\"A\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010!\u001b\u0005!\u0012BA\u0011\u0015\u0005!qu\u000eZ3MSN$\u0018!\u00043b[BLgn\u001a$bGR|'\u000f\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004E_V\u0014G.Z\u0001\rSR,'/\u0019;f'R,\u0007o\u001d\t\u0003I-J!\u0001L\u0013\u0003\u0007%sG/A\u0002u_2\fa\u0001P5oSRtD\u0003\u0002\u00193gQ\u0002\"!\r\u0001\u000e\u0003IAqA\t\u0003\u0011\u0002\u0003\u00071\u0005C\u0004*\tA\u0005\t\u0019\u0001\u0016\t\u000f5\"\u0001\u0013!a\u0001G\u0005)\u0011\r\u001d9msR\u0011qG\u000f\t\u0003q\u0019s!!\u000f\u001e\r\u0001!)1(\u0002a\u0001y\u0005)qM]1qQB\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\nOJ\f\u0007\u000f\u001b<jK^T!!\u0011\"\u0002\u0011\u0005t\u0017\r\\=tSNT!a\u0011\r\u0002\u0007\u0005\u0004\u0018.\u0003\u0002F}\t\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0003\u000f\u0012\u0013Qa\u0012:ba\"DC\u0001A%T)B\u0011!*U\u0007\u0002\u0017*\u0011A*T\u0001\tg\u000e\fG.\u00193pG*\u0011ajT\u0001\bi\u0006\\WM_8f\u0015\t\u0001&$\u0001\u0004hSRDWOY\u0005\u0003%.\u0013\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0002+\u0006YIp\f\u0016+\u0015\u0001\u0002#\u0006I>t{\u0002\u0004\u0016mZ3SC:\\\u0007\u0006Z1na&twMR1di>\u0014(\bR8vE2,\u0007%\u0010\u00111]a*D\u0006I5uKJ\fG/Z*uKB\u001c((\u00138uAu\u0002\u0013\u0007\r\u0019*A*\u0001\u0003E\u000b\u0011!u\u0001\u001au.\u001c9vi\u0016\u0004\u0003+Y4f%\u0006t7\u000e\t4pe\u0002\nG\u000e\u001c\u0011o_\u0012,7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011QC\u001e,\u0007EU1oW\u0002\nGnZ8sSRDW\u000e\t:b].\u001c\bE\\8eKN\u0004C-\u001a9f]\u0012Lgn\u001a\u0011p]\u0002\"\b.Z5sA\r|gN\\3di&|gn\u001d\u0011u_\u0002\"W\r^3s[&tW\r\t5po\u0002JW\u000e]8si\u0006tGO\u0003\u0011!U\u0001\"\b.\u001a\u0011o_\u0012,\u0007%[:/AQC\u0017n\u001d\u0011bgN,X.Z:!C\u0002rw\u000eZ3!SN\u0004Sn\u001c:fA%l\u0007o\u001c:uC:$\b%\u001b4!SR\u0004#/Z2fSZ,7\u000fI7pe\u0016\u00043m\u001c8oK\u000e$\u0018n\u001c8tA\u0019\u0014x.\u001c\u0011pi\",'o\u001d\u0018\u000bA\u0001R\u0003%R1dQ\u00022XM\u001d;fq\u0002\u0012WmZ5og\u0002:\u0018\u000e\u001e5!C:\u0004\u0013N\\5uS\u0006d\u0007e\u001d;bi\u0016t\u0003%\u00134!SR\u0004\u0003.Y:!C:L\bE\\3jO\"\u0014w.\u001e:tY\u0001JG\u000fI:f]\u0012\u001c\b\u0005\u001e5f[\u0002\n\u0007%\\3tg\u0006<WM\u0003\u0011!U\u0001:\b.[2iA%\u001c\b\u0005\u001e5fA%t\u0017\u000e^5bY\u0002b\u0017MY3mA=\u0002C\u000f[3!]Vl'-\u001a:!_\u001a\u0004c.Z5hQ\n|WO]:/\u0015\u0001\u0002#\u0006I#bG\"\u0004c/\u001a:uKbd\u0003e\u00195fG.\u001c\b%\u001b;tA5,7o]1hKN\u0004\u0013M\u001c3!G>l\u0007/\u001e;fg\u0002\n\u0007E\\3xA1\f'-\u001a7!E\u0006\u001cX\r\u001a\u0011p]j\u0002C\u000f[3!i>$\u0018\r\u001c\u0011wC2,X\rI8g\u0015\u0001\u0002#\u0006I7fgN\fw-Z:!e\u0016\u001cW-\u001b<fI\u0002\ng\u000e\u001a\u0011uQ\u0016\u0004C-Y7qS:<\u0007EZ1di>\u0014h\u0006\t+iSN\u0004c.Z<!m\u0006dW/\u001a\u0011jg\u0002\u0002(o\u001c9pO\u0006$X\r\u001a\u0011u_\u0002\nG\u000e\u001c\u0011pkR<w.\u001b8hA9,\u0017n\u001a5c_V\u00148O\f\u0006!A)\u0002\u0013\t\t<feR,\u0007\u0010I<jY2\u00043\u000f^8qAA\u0014x\u000e]8hCRLgn\u001a\u0011nKN\u001c\u0018mZ3tA%4\u0007%\u001b;tAY\fG.^3!E\u0016\u001cw.\\3tAM$\u0018m\u001a8b]R\u0004\u0003&\u001b\u0018f]\u0001B\u0017m\u001d\u0011bA\rD\u0017M\\4fA=4\u0007\u0005\\3tg*\u0001\u0003E\u000b\u0011uQ\u0006t\u0007\u0005\r\u00181aA\u0002\u0014'\u000b\u0011UQ&\u001c\b\u0005\u001d:pG\u0016\u001c8\u000fI5tAI,\u0007/Z1uK\u0012\u0004cm\u001c:!C\u0002rW/\u001c2fe\u0002zg\rI5uKJ\fG/\u001a\u0011ti\u0016\u0004\b\u0005^5nKNt\u0003%T8ti\u0002\nGnZ8sSRDWn\u001d\u0011tQ>,H\u000e\u001a\u0006!A)\u00023m\u001c8wKJ<W\rI1gi\u0016\u0014\b%\u00199qe>Dh\u0006\t\u001a1A%$XM]1uS>t7O\f\u0006!A)R\u0001\u0005\t\u0016!G\r\u0002\u0003+\u0019:b[\u0016$XM]:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1eC6\u0004\u0018N\\4GC\u000e$xN\u001d\u001e!\t>,(\r\\3!{\u0001\u0002d\u0006O\u001ba\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002\u0003K]8cC\nLG.\u001b;zAQD\u0017\r\u001e\u0011bA9|G-\u001a\u0011xS2d\u0007EY3!e\u0006tGm\\7ms\u0002\u001aX\r\\3di\u0016$\u0007EY=!C\u0002*8/\u001a:!iJ\fg/\u001a:tS:<\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5-A\u0011,g-Y;miN\u0004Co\u001c\u00111]a*dF\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b-\u001b;fe\u0006$Xm\u0015;faNT\u0004%\u00138uAu\u0002\u0013\u0007\r\u0019a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002S*\u0019=j[Vl\u0007E\\;nE\u0016\u0014\be\u001c4!SR,'/\u0019;j_:\u001c\bEZ8sAQDW\rI1mO>\u0014\u0018\u000e\u001e5nAQ|\u0007E];o])\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00199sY\u0006\u0014W\r\u001c\u001e!\t>,(\r\\3a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002\u0003+Y4f%\u0006t7\u000eI8gAQDW\r\t8pI\u0016T\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!%\u0016$XO\u001d8t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002C\u0010\t<feR,\u0007\u0010\t8b[\u0016\u0004\u0003\u0005\t\u0011!A\u0001b\b\u0005U1hKJ\u000bgn\u001b\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?\u000bA\u0001R\u0003\u0005\t?!wNl\bM\\1nKj\u00023\u000b\u001e:j]\u001e\u0004\u0007\u0005 \u0011|gv\u0004\u0007O\u001d7bE\u0016d'\b\t#pk\ndW\r\u0019\u0011}\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0007\rY>tK\u0016\fGn]8~\u0015\u0001\u0002#\u0006I.^Q\r|WN\f:ba\"$xN]=/C2<wN]5uQ6\u001chfZ3oKJL7ML2f]R\u0014\u0018\r\\5us::V-[4ii\u0016$\u0007+Y4f%\u0006t7N\u0003\u0011!U\u0001\u0002\u0007\r\u0019\u0006!A)z\u0013\u0001\u0003)bO\u0016\u0014\u0016M\\6\u0011\u0005E:1cA\u0004Z9B\u0011AEW\u0005\u00037\u0016\u0012a!\u00118z%\u00164\u0007CA/c\u001b\u0005q&BA0a\u0003\tIwNC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rt&\u0001D*fe&\fG.\u001b>bE2,G#A,\u0015\tA2w\r\u001b\u0005\bE%\u0001\n\u00111\u0001$\u0011\u001dI\u0013\u0002%AA\u0002)Bq!L\u0005\u0011\u0002\u0003\u00071%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005Y'FA\u0012mW\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003%)hn\u00195fG.,GM\u0003\u0002sK\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Q|'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'F\u0001xU\tQC.A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,G#\u0001@\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u00011\u0002\t1\fgnZ\u0005\u0005\u0003\u000f\t\tA\u0001\u0004PE*,7\r\u001e")
public class PageRank
extends NodeList {
    private final double dampingFactor;
    private final int iterateSteps;
    private final double tol;

    public static double $lessinit$greater$default$3() {
        return PageRank$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return PageRank$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$1() {
        return PageRank$.MODULE$.$lessinit$greater$default$1();
    }

    public static double apply$default$3() {
        return PageRank$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return PageRank$.MODULE$.apply$default$2();
    }

    public static double apply$default$1() {
        return PageRank$.MODULE$.apply$default$1();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            state.newAdder("dangling", Numeric.DoubleIsFractional$.MODULE$);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            PageRank.$anonfun$apply$2(vertex, state);
            return BoxedUnit.UNIT;
        }).iterate((Function2 & Serializable)(vertex, state) -> {
            PageRank.$anonfun$apply$3(this, vertex, state);
            return BoxedUnit.UNIT;
        }, this.iterateSteps, false);
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex, GraphState state) {
        double initLabel = 1.0;
        ((EntityVisitor)((Object)vertex)).setState("prlabel", BoxesRunTime.boxToDouble((double)initLabel));
        int outDegree = vertex.outDegree();
        if ((double)outDegree > 0.0) {
            vertex.messageOutNeighbours(BoxesRunTime.boxToDouble((double)(initLabel / (double)outDegree)), SchemaProviderInstances$.MODULE$.doubleSchemaProvider());
        } else {
            state.apply("dangling").$plus$eq(BoxesRunTime.boxToDouble((double)(initLabel / (double)state.nodeCount())));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$3(PageRank $this, Vertex vertex, GraphState state) {
        block2: {
            double currentLabel = BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("prlabel", ((EntityVisitor)((Object)vertex)).getState$default$2()));
            double dangling = BoxesRunTime.unboxToDouble(state.apply("dangling").value());
            Seq queue = vertex.messageQueue();
            double newLabel = 1.0 - $this.dampingFactor + $this.dampingFactor * (BoxesRunTime.unboxToDouble((Object)queue.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + dangling);
            ((EntityVisitor)((Object)vertex)).setState("prlabel", BoxesRunTime.boxToDouble((double)newLabel));
            int outDegree = vertex.outDegree();
            if (outDegree > 0) {
                vertex.messageOutNeighbours(BoxesRunTime.boxToDouble((double)(newLabel / (double)outDegree)), SchemaProviderInstances$.MODULE$.doubleSchemaProvider());
            } else {
                state.apply("dangling").$plus$eq(BoxesRunTime.boxToDouble((double)(newLabel / (double)state.nodeCount())));
            }
            if (!(Math.abs(newLabel - currentLabel) < $this.tol)) break block2;
            vertex.voteToHalt();
        }
    }

    public PageRank(double dampingFactor, int iterateSteps, double tol) {
        this.dampingFactor = dampingFactor;
        this.iterateSteps = iterateSteps;
        this.tol = tol;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"prlabel"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

