/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.NonversionedField;
import com.raphtory.arrowcore.implementation.SchemaFieldAccessor;
import java.util.List;
import java.util.function.Supplier;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class NonversionedEnumField
extends NonversionedField {
    protected final int _maxOrdinal;
    protected final Enum<?>[] _enumValues;

    public <T extends Enum<T>> NonversionedEnumField(String string, Class<T> clazz) {
        super(string, clazz);
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        int n = 0;
        for (Enum enum_ : enumArray) {
            if (enum_.ordinal() <= n) continue;
            n = enum_.ordinal();
        }
        this._maxOrdinal = n;
        this._enumValues = new Enum[this._maxOrdinal + 1];
        Enum[] enumArray2 = enumArray;
        int n2 = enumArray2.length;
        for (int i = 0; i < n2; ++i) {
            Enum enum_;
            this._enumValues[enum_.ordinal()] = enum_ = enumArray2[i];
        }
    }

    @Override
    public void addToSchema(List<Field> list) {
        Field field = this._maxOrdinal <= 255 ? new Field(this._name, new FieldType(false, (ArrowType)((Supplier)_typeMap.get(Byte.TYPE)).get(), null), null) : (this._maxOrdinal <= 65535 ? new Field(this._name, new FieldType(false, (ArrowType)((Supplier)_typeMap.get(Short.TYPE)).get(), null), null) : new Field(this._name, new FieldType(false, (ArrowType)((Supplier)_typeMap.get(Integer.TYPE)).get(), null), null));
        list.add(field);
    }

    @Override
    public SchemaFieldAccessor getNewSchemaFieldAccessor(VectorSchemaRoot vectorSchemaRoot) {
        EnumSchemaFieldAccessor enumSchemaFieldAccessor = new EnumSchemaFieldAccessor();
        enumSchemaFieldAccessor.initialise(this._maxOrdinal);
        enumSchemaFieldAccessor.initialise(vectorSchemaRoot, this._parentSchemaFieldIndex);
        return enumSchemaFieldAccessor;
    }

    @Override
    public EntityFieldAccessor getNewEntityFieldAccessor() {
        EnumEntityFieldAccessor enumEntityFieldAccessor = new EnumEntityFieldAccessor(this);
        return enumEntityFieldAccessor;
    }

    public static final class EnumEntityFieldAccessor
    extends EntityFieldAccessor {
        private int _ordinal;
        private final NonversionedEnumField _field;

        public EnumEntityFieldAccessor(NonversionedEnumField nonversionedEnumField) {
            this._field = nonversionedEnumField;
        }

        @Override
        public void setEnum(int n) {
            this._ordinal = n;
            this._isSet = true;
        }

        @Override
        public void setEnum(Enum<?> enum_) {
            if (enum_ != null) {
                if (enum_.getClass() != this._field._class) {
                    throw new IllegalArgumentException("wrong enum");
                }
                this._ordinal = enum_.ordinal();
                this._isSet = true;
            } else {
                this.reset();
            }
        }

        @Override
        public Enum<?> getEnum() {
            if (this._ordinal >= 0 && this._ordinal <= this._field._maxOrdinal) {
                return this._field._enumValues[this._ordinal];
            }
            return null;
        }

        @Override
        public void reset() {
            super.reset();
            this._ordinal = -1;
        }
    }

    private static class EnumSchemaFieldAccessor
    extends SchemaFieldAccessor {
        private int _maxOrdinal;
        private TinyIntVector _byteVector;
        private SmallIntVector _shortVector;
        private IntVector _intVector;
        private BaseFixedWidthVector _vector;

        private EnumSchemaFieldAccessor() {
        }

        protected void initialise(int n) {
            this._maxOrdinal = n;
        }

        @Override
        protected void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
            super.initialise(vectorSchemaRoot, n);
            this._byteVector = null;
            this._shortVector = null;
            this._intVector = null;
            this._vector = null;
            FieldVector fieldVector = vectorSchemaRoot.getVector(n);
            if (this._maxOrdinal <= 255 && fieldVector instanceof TinyIntVector) {
                this._byteVector = (TinyIntVector)fieldVector;
                this._vector = this._byteVector;
            } else if (this._maxOrdinal <= 65535 && fieldVector instanceof SmallIntVector) {
                this._shortVector = (SmallIntVector)fieldVector;
                this._vector = this._shortVector;
            } else if (fieldVector instanceof IntVector) {
                this._intVector = (IntVector)fieldVector;
                this._vector = this._intVector;
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void store(EntityFieldAccessor entityFieldAccessor, int n) {
            if (entityFieldAccessor.isSet()) {
                EnumEntityFieldAccessor enumEntityFieldAccessor = (EnumEntityFieldAccessor)entityFieldAccessor;
                if (this._maxOrdinal <= 255) {
                    this._byteVector.setSafe(n, enumEntityFieldAccessor.getEnum().ordinal());
                } else if (this._maxOrdinal <= 65535) {
                    this._shortVector.setSafe(n, enumEntityFieldAccessor.getEnum().ordinal());
                } else {
                    this._intVector.setSafe(n, enumEntityFieldAccessor.getEnum().ordinal());
                }
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(EntityFieldAccessor entityFieldAccessor, int n) {
            if (!this._vector.isNull(n)) {
                EnumEntityFieldAccessor enumEntityFieldAccessor = (EnumEntityFieldAccessor)entityFieldAccessor;
                if (this._maxOrdinal <= 255) {
                    enumEntityFieldAccessor.setEnum(this._byteVector.get(n) & 0xFF);
                } else if (this._maxOrdinal <= 65535) {
                    enumEntityFieldAccessor.setEnum(this._shortVector.get(n) & 0xFFFF);
                } else {
                    enumEntityFieldAccessor.setEnum(this._intVector.get(n));
                }
            } else {
                entityFieldAccessor.reset();
            }
        }
    }
}

