# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulpcore.api_client import ApiClient
from pulpcore.client.pulpcore.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class UsersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def list(self, **kwargs):  # noqa: E501
        """List users  # noqa: E501

        ViewSet for User.  NOTE: This API endpoint is in \"tech preview\" and subject to change  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str email: Filter results where email matches value
        :param str email__contains: Filter results where email contains value
        :param str email__icontains: Filter results where email contains value
        :param str email__iexact: Filter results where email matches value
        :param list[str] email__in: Filter results where email is in a comma-separated list of values
        :param str first_name: Filter results where first_name matches value
        :param str first_name__contains: Filter results where first_name contains value
        :param str first_name__icontains: Filter results where first_name contains value
        :param str first_name__iexact: Filter results where first_name matches value
        :param list[str] first_name__in: Filter results where first_name is in a comma-separated list of values
        :param bool is_active: Filter results where is_active matches value
        :param bool is_staff: Filter results where is_staff matches value
        :param str last_name: Filter results where last_name matches value
        :param str last_name__contains: Filter results where last_name contains value
        :param str last_name__icontains: Filter results where last_name contains value
        :param str last_name__iexact: Filter results where last_name matches value
        :param list[str] last_name__in: Filter results where last_name is in a comma-separated list of values
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str username: Filter results where username matches value
        :param str username__contains: Filter results where username contains value
        :param str username__icontains: Filter results where username contains value
        :param str username__iexact: Filter results where username matches value
        :param list[str] username__in: Filter results where username is in a comma-separated list of values
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PaginatedUserResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_with_http_info(**kwargs)  # noqa: E501

    def list_with_http_info(self, **kwargs):  # noqa: E501
        """List users  # noqa: E501

        ViewSet for User.  NOTE: This API endpoint is in \"tech preview\" and subject to change  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str email: Filter results where email matches value
        :param str email__contains: Filter results where email contains value
        :param str email__icontains: Filter results where email contains value
        :param str email__iexact: Filter results where email matches value
        :param list[str] email__in: Filter results where email is in a comma-separated list of values
        :param str first_name: Filter results where first_name matches value
        :param str first_name__contains: Filter results where first_name contains value
        :param str first_name__icontains: Filter results where first_name contains value
        :param str first_name__iexact: Filter results where first_name matches value
        :param list[str] first_name__in: Filter results where first_name is in a comma-separated list of values
        :param bool is_active: Filter results where is_active matches value
        :param bool is_staff: Filter results where is_staff matches value
        :param str last_name: Filter results where last_name matches value
        :param str last_name__contains: Filter results where last_name contains value
        :param str last_name__icontains: Filter results where last_name contains value
        :param str last_name__iexact: Filter results where last_name matches value
        :param list[str] last_name__in: Filter results where last_name is in a comma-separated list of values
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str username: Filter results where username matches value
        :param str username__contains: Filter results where username contains value
        :param str username__icontains: Filter results where username contains value
        :param str username__iexact: Filter results where username matches value
        :param list[str] username__in: Filter results where username is in a comma-separated list of values
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PaginatedUserResponseList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'email',
            'email__contains',
            'email__icontains',
            'email__iexact',
            'email__in',
            'first_name',
            'first_name__contains',
            'first_name__icontains',
            'first_name__iexact',
            'first_name__in',
            'is_active',
            'is_staff',
            'last_name',
            'last_name__contains',
            'last_name__icontains',
            'last_name__iexact',
            'last_name__in',
            'limit',
            'offset',
            'ordering',
            'username',
            'username__contains',
            'username__icontains',
            'username__iexact',
            'username__in',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'email' in local_var_params and local_var_params['email'] is not None:  # noqa: E501
            query_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'email__contains' in local_var_params and local_var_params['email__contains'] is not None:  # noqa: E501
            query_params.append(('email__contains', local_var_params['email__contains']))  # noqa: E501
        if 'email__icontains' in local_var_params and local_var_params['email__icontains'] is not None:  # noqa: E501
            query_params.append(('email__icontains', local_var_params['email__icontains']))  # noqa: E501
        if 'email__iexact' in local_var_params and local_var_params['email__iexact'] is not None:  # noqa: E501
            query_params.append(('email__iexact', local_var_params['email__iexact']))  # noqa: E501
        if 'email__in' in local_var_params and local_var_params['email__in'] is not None:  # noqa: E501
            query_params.append(('email__in', local_var_params['email__in']))  # noqa: E501
            collection_formats['email__in'] = 'csv'  # noqa: E501
        if 'first_name' in local_var_params and local_var_params['first_name'] is not None:  # noqa: E501
            query_params.append(('first_name', local_var_params['first_name']))  # noqa: E501
        if 'first_name__contains' in local_var_params and local_var_params['first_name__contains'] is not None:  # noqa: E501
            query_params.append(('first_name__contains', local_var_params['first_name__contains']))  # noqa: E501
        if 'first_name__icontains' in local_var_params and local_var_params['first_name__icontains'] is not None:  # noqa: E501
            query_params.append(('first_name__icontains', local_var_params['first_name__icontains']))  # noqa: E501
        if 'first_name__iexact' in local_var_params and local_var_params['first_name__iexact'] is not None:  # noqa: E501
            query_params.append(('first_name__iexact', local_var_params['first_name__iexact']))  # noqa: E501
        if 'first_name__in' in local_var_params and local_var_params['first_name__in'] is not None:  # noqa: E501
            query_params.append(('first_name__in', local_var_params['first_name__in']))  # noqa: E501
            collection_formats['first_name__in'] = 'csv'  # noqa: E501
        if 'is_active' in local_var_params and local_var_params['is_active'] is not None:  # noqa: E501
            query_params.append(('is_active', local_var_params['is_active']))  # noqa: E501
        if 'is_staff' in local_var_params and local_var_params['is_staff'] is not None:  # noqa: E501
            query_params.append(('is_staff', local_var_params['is_staff']))  # noqa: E501
        if 'last_name' in local_var_params and local_var_params['last_name'] is not None:  # noqa: E501
            query_params.append(('last_name', local_var_params['last_name']))  # noqa: E501
        if 'last_name__contains' in local_var_params and local_var_params['last_name__contains'] is not None:  # noqa: E501
            query_params.append(('last_name__contains', local_var_params['last_name__contains']))  # noqa: E501
        if 'last_name__icontains' in local_var_params and local_var_params['last_name__icontains'] is not None:  # noqa: E501
            query_params.append(('last_name__icontains', local_var_params['last_name__icontains']))  # noqa: E501
        if 'last_name__iexact' in local_var_params and local_var_params['last_name__iexact'] is not None:  # noqa: E501
            query_params.append(('last_name__iexact', local_var_params['last_name__iexact']))  # noqa: E501
        if 'last_name__in' in local_var_params and local_var_params['last_name__in'] is not None:  # noqa: E501
            query_params.append(('last_name__in', local_var_params['last_name__in']))  # noqa: E501
            collection_formats['last_name__in'] = 'csv'  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'ordering' in local_var_params and local_var_params['ordering'] is not None:  # noqa: E501
            query_params.append(('ordering', local_var_params['ordering']))  # noqa: E501
        if 'username' in local_var_params and local_var_params['username'] is not None:  # noqa: E501
            query_params.append(('username', local_var_params['username']))  # noqa: E501
        if 'username__contains' in local_var_params and local_var_params['username__contains'] is not None:  # noqa: E501
            query_params.append(('username__contains', local_var_params['username__contains']))  # noqa: E501
        if 'username__icontains' in local_var_params and local_var_params['username__icontains'] is not None:  # noqa: E501
            query_params.append(('username__icontains', local_var_params['username__icontains']))  # noqa: E501
        if 'username__iexact' in local_var_params and local_var_params['username__iexact'] is not None:  # noqa: E501
            query_params.append(('username__iexact', local_var_params['username__iexact']))  # noqa: E501
        if 'username__in' in local_var_params and local_var_params['username__in'] is not None:  # noqa: E501
            query_params.append(('username__in', local_var_params['username__in']))  # noqa: E501
            collection_formats['username__in'] = 'csv'  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/users/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedUserResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permissions(self, auth_user_href, **kwargs):  # noqa: E501
        """permissions  # noqa: E501

        List user permissions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions(auth_user_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str auth_user_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.permissions_with_http_info(auth_user_href, **kwargs)  # noqa: E501

    def permissions_with_http_info(self, auth_user_href, **kwargs):  # noqa: E501
        """permissions  # noqa: E501

        List user permissions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_with_http_info(auth_user_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str auth_user_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PermissionResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'auth_user_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permissions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'auth_user_href' is set
        if self.api_client.client_side_validation and ('auth_user_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['auth_user_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `auth_user_href` when calling `permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_user_href' in local_var_params:
            path_params['auth_user_href'] = local_var_params['auth_user_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{auth_user_href}permissions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read(self, auth_user_href, **kwargs):  # noqa: E501
        """Inspect an user  # noqa: E501

        ViewSet for User.  NOTE: This API endpoint is in \"tech preview\" and subject to change  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(auth_user_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str auth_user_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_with_http_info(auth_user_href, **kwargs)  # noqa: E501

    def read_with_http_info(self, auth_user_href, **kwargs):  # noqa: E501
        """Inspect an user  # noqa: E501

        ViewSet for User.  NOTE: This API endpoint is in \"tech preview\" and subject to change  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(auth_user_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str auth_user_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UserResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'auth_user_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'auth_user_href' is set
        if self.api_client.client_side_validation and ('auth_user_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['auth_user_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `auth_user_href` when calling `read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_user_href' in local_var_params:
            path_params['auth_user_href'] = local_var_params['auth_user_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{auth_user_href}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
