This is the example of silicon calculation. The supercell is 2x2x2 of the
conventional unit cell. The VASP calculation was made for force calculations
with 300 eV, 2x2x2 off-Gamma-centre k-point sampling mesh for the supercell, and
PBE-sol. Silicon crystal is F-centre, so there is the transformation matrix from
the conventional unit cell to the primitive cell.

`phono3py_disp.yaml` is generated by

```
% phono3py -d --dim="2 2 2" -c POSCAR-unitcell --pa="F"
```

To create `fc3.hdf5` and `fc2.hdf5`,

```
% phono3py --sym-fc
```

Using 11x11x11 sampling mesh, lattice thermal conductivity is calculated by

```
% phono3py --mesh 11 11 11 --fc3 --fc2 --br
```

`kappa-m111111.hdf5` is written as the result. The lattice thermal conductivity
is calculated as 109.0 W/m-K at 300 K. This becomes, with 19x19x19 sampling
mesh, 123.2 W/m-K.

Accumulated lattice thermal conductivity is calculated using `phono3py-kaccum`
script.

```
% phono3py-kaccum kappa-m111111.hdf5 |tee kaccum.dat
```

`kaccum.dat` is plotted using gnuplot by

```
gnuplot> p 'kaccum.dat' i 30 u 1:2 w l, 'kaccum.dat' i 30 u 1:8 w l
```

![Si-kaccum.png](Si-kaccum.png)

It is found that most of the lattice thermal conductivity owes the phonon modes
below 6 THz.

`fc2.hdf5` can be read by harmonic phonopy to rename it to force_constants.hdf5.
The phonon band structure and DOS are plotted by

```
% ln -s fc2.hdf5 force_constants.hdf5
% phonopy --mesh 19 19 19 --band 1/2 1/2 0 0 0 0 1/2 1/2 1/2 --hdf5 --readfc -p
```

![Si-band-DOS.png](Si-band-DOS.png)

The shape of phonon DOS below 6 THz is similar to the derivative of the
accumulated lattice thermal conductivity, i.e., the heat is conducted by the low
frequency longitudinal-acoustic-like modes.

The file `vasprun_xmls.tar.lzma` in this example contains VASP output files of
`vasprun.xml`s that are used to generate `FORCES_FC3`. To test the `FORCES_FC3`
generation, after decompressing this file, the following command is executed at
current directory:

```
% phono3py --cf3 vasprun_xmls/disp-{00001..00111}/vasprun.xml
```
