This is the example of silicon calculation. The supercell is 2x2x2 of the
conventional unit cell. The VASP calculation was made for force calculations
with 300 eV, 2x2x2 off-Gamma-centre k-point sampling mesh for the supercell, and
LDA. Silicon crystal is F-centre, so there is the transformation matrix from the
conventional unit cell to the primitive cell.

`phono3py_disp.yaml` is generated by

```
% phono3py -d --dim 2 2 2 -c POSCAR-unitcell --pa auto
```

To create `fc3.hdf5` and `fc2.hdf5`,

```
% phono3py --sym-fc
```

Using 11x11x11 sampling mesh, lattice thermal conductivity is calculated by

```
% phono3py --mesh 11 11 11 --fc3 --fc2 --br
```

`kappa-m111111.hdf5` is written as the result. The lattice thermal conductivity
is calculated as 112.5 W/m-K at 300 K. This becomes, with 19x19x19 sampling
mesh, 127.0 W/m-K.

Accumulated lattice thermal conductivity is calculated using `phono3py-kaccum`
script.

```
% phono3py-kaccum kappa-m111111.hdf5 |tee kaccum.dat
```

The file `vasprun_xmls.tar.lzma` in this example contains `vasprun.xml`s that
are used to generate `FORCES_FC3`. To test the `FORCES_FC3` generation, after
decompressing this file, the following command is executed at current directory:

```
% phono3py --cf3 vasprun_xmls/disp-{00001..00111}/vasprun.xml
```
