#!/usr/bin/env python3
# Copyright 2020, Boling Consulting Solutions
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# pylint: skip-file

from twisted.internet import reactor
from twisted.web import server, resource


class Simple(resource.Resource):
    isLeaf = False

    def render_GET(self, request):
        return "<html>Hello, world!</html>"


if __name__ == '__main__':
    import warnings
    msg = 'These tests will be removed in a future release of the txrestserver'
    warnings.warn(msg, DeprecationWarning)
    site = server.Site(Simple())
    reactor.listenTCP(8780, site)
    reactor.run()
    print('done')
