# Autonomous Vehicle Toolbox

The Autonomous Vehicle Toolbox, dubbed `avtoolbox`, is meant to be a simplified mechansim for quickly setting up and developing a ROS 2 based control stack. The `avtoolbox` platform is under activate development by the [Simulation Based Engineering Laboratory](https://sbel.wisc.edu) at the [University of Wisconsin-Madison](https://wisc.edu). 

## Background

The `avtoolbox` platform provides the following resources for expediting development of autonomous algorithms:
1. A development workflow for writing ROS 2 code and various already implemented algorithms
2. A database system to expedite data recording and parsing and an accompaning command line interface

Furthermore, the [MiniAV platform](https://github.com/uwsbel/miniav), which utilizes this toolbox, provides the following functionality:
1. A parts list and instructions on how to build the physical platform
2. A high-fidelity simulation environment built using [Chrono](https://projectchrono.org) to test autonomous algorithms

For more information about the design considerations and purpose for this project, see the [background](https://projects.sbel.org/av-toolkiit/background.html) section.

## Support

Contact the [Simulation Based Engineering Laboratory](mailto:negrut@wisc.edu) for any questions or concerns regarding the contents of this repository.

## See Also

Visit our website at [sbel.wisc.edu](https://sbel.wisc.edu)!

<br>

<div>
	<img src="https://github.com/uwsbel/avtoolbox/blob/master/docs/_static/SBEL-dark.png?raw=true" alt="Simulation Based Engineering Lab Logo" class="readme-img" height="100px">  
	<img src="https://github.com/uwsbel/avtoolbox/blob/master/docs/_static/UWCrest.png?raw=true" alt="University of Wisconsin - Madison Crest" class="readme-img" height="100px" align="right">
</div>
