# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ListVideosRequest(JDCloudRequest):
    """
    查询视频列表信息。
允许通过条件过滤查询，支持的过滤字段如下：
  - status[eq] 按视频状态精确查询
  - categoryId[eq] 按分类ID精确查询
  - videoId[eq] 按视频ID精确查询
  - name[eq] 按视频名称精确查询

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ListVideosRequest, self).__init__(
            '/videos', 'GET', header, version)
        self.parameters = parameters


class ListVideosParameters(object):

    def __init__(self, ):
        """
        """

        self.pageNumber = None
        self.pageSize = None
        self.filters = None
        self.sorts = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码；默认值为 1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小；默认值为 10；取值范围 [10, 100]
        """
        self.pageSize = pageSize

    def setFilters(self, filters):
        """
        :param filters: (Optional) 
        """
        self.filters = filters

    def setSorts(self, sorts):
        """
        :param sorts: (Optional) 
        """
        self.sorts = sorts

