# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateInstanceTemplateRequest(JDCloudRequest):
    """
    创建一个指定参数的启动模板，启动模板中包含创建云主机时的大部分配置参数，避免每次创建云主机时的重复性工作。<br>
如果是使用启动模板创建云主机，如果指定了某些参数与模板中的参数相冲突，那么新指定的参数会替换模板中的参数。<br>
如果是使用启动模板创建云主机，如果指定了镜像ID与模板中的镜像ID不一致，那么模板中的dataDisks参数会失效。<br>
如果使用高可用组(Ag)创建云主机，那么Ag所关联的模板中的参数都不可以被调整，只能以模板为准。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateInstanceTemplateRequest, self).__init__(
            '/regions/{regionId}/instanceTemplates', 'POST', header, version)
        self.parameters = parameters


class CreateInstanceTemplateParameters(object):

    def __init__(self, regionId, instanceTemplateData, name, ):
        """
        :param regionId: 地域ID
        :param instanceTemplateData: 启动模板的数据
        :param name: 启动模板的名称，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。
        """

        self.regionId = regionId
        self.instanceTemplateData = instanceTemplateData
        self.name = name
        self.description = None

    def setDescription(self, description):
        """
        :param description: (Optional) 启动模板的描述，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。
        """
        self.description = description

