# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateImageRequest(JDCloudRequest):
    """
    为云主机创建私有镜像。云主机状态必须为<b>stopped</b>。<br>
云主机没有正在进行中的任务才可制作镜像。<br>
制作镜像以备份系统盘为基础，在此之上可选择全部或部分挂载数据盘制作整机镜像（如不做任何更改将默认制作整机镜像），制作镜像过程会为所挂载云硬盘创建快照并与镜像关联。<br>
调用接口后，需要等待镜像状态变为<b>ready</b>后，才能正常使用镜像。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateImageRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:createImage', 'POST', header, version)
        self.parameters = parameters


class CreateImageParameters(object):

    def __init__(self, regionId, instanceId, name, ):
        """
        :param regionId: 地域ID
        :param instanceId: 云主机ID
        :param name: 镜像名称，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.name = name
        self.description = None
        self.dataDisks = None

    def setDescription(self, description):
        """
        :param description: (Optional) 镜像描述，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。
        """
        self.description = description

    def setDataDisks(self, dataDisks):
        """
        :param dataDisks: (Optional) 数据盘列表，可以在实例已挂载数据盘的基础上，额外增加新的快照、空盘、或排除云主机中的数据盘。
        """
        self.dataDisks = dataDisks

