# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class GetPipelineInstancesByUuidsRequest(JDCloudRequest):
    """
    根据条件查询流水线执行历史

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(GetPipelineInstancesByUuidsRequest, self).__init__(
            '/regions/{regionId}/instances', 'GET', header, version)
        self.parameters = parameters


class GetPipelineInstancesByUuidsParameters(object):

    def __init__(self, regionId, uuids, ):
        """
        :param regionId: Region ID
        :param uuids: 流水线执行实例ID，多个ID用逗号分隔
        """

        self.regionId = regionId
        self.uuids = uuids
        self.isSimple = None
        self.pageNumber = None
        self.pageSize = None
        self.sorts = None
        self.filters = None

    def setIsSimple(self, isSimple):
        """
        :param isSimple: (Optional) 流水线执行的状态，如果isSimple是true，只显示每个stage的状态, 而stage中的action状态将被忽略
        """
        self.isSimple = isSimple

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码；默认为1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小；默认为10；取值范围[10, 100]
        """
        self.pageSize = pageSize

    def setSorts(self, sorts):
        """
        :param sorts: (Optional) 
        """
        self.sorts = sorts

    def setFilters(self, filters):
        """
        :param filters: (Optional) 根据流水线名称查询
        """
        self.filters = filters

