# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateTranscodeTemplateRequest(JDCloudRequest):
    """
    完整更新转码模板
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(UpdateTranscodeTemplateRequest, self).__init__(
            '/transcodeTemplates/{templateId}', 'PUT', header, version)
        self.parameters = parameters


class UpdateTranscodeTemplateParameters(object):

    def __init__(self, templateId, ):
        """
        :param templateId: 模板ID
        """

        self.templateId = templateId
        self.title = None
        self.video = None
        self.audio = None
        self.container = None
        self.encryption = None
        self.definition = None
        self.transcodeType = None

    def setTitle(self, title):
        """
        :param title: (Optional) 模板标题。长度不超过 128 个字符，最少 2 个字符。UTF-8 编码。

        """
        self.title = title

    def setVideo(self, video):
        """
        :param video: (Optional) 视频参数配置
        """
        self.video = video

    def setAudio(self, audio):
        """
        :param audio: (Optional) 音频参数配置
        """
        self.audio = audio

    def setContainer(self, container):
        """
        :param container: (Optional) 封装容器配置
        """
        self.container = container

    def setEncryption(self, encryption):
        """
        :param encryption: (Optional) 加密配置
        """
        self.encryption = encryption

    def setDefinition(self, definition):
        """
        :param definition: (Optional) 清晰度规格标记。取值范围：
  SD - 标清
  HD - 高清
  FHD - 超清
  2K
  4K

        """
        self.definition = definition

    def setTranscodeType(self, transcodeType):
        """
        :param transcodeType: (Optional) 转码方式。取值范围：
  normal - 普通转码
  jdchd - 京享超清
  jdchs - 极速转码

        """
        self.transcodeType = transcodeType

