# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateThumbnailTaskRequest(JDCloudRequest):
    """
    创建截图任务，创建成功时返回任务ID。本接口用于截取指定时间点的画面。
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateThumbnailTaskRequest, self).__init__(
            '/regions/{regionId}/thumbnail', 'POST', header, version)
        self.parameters = parameters


class CreateThumbnailTaskParameters(object):

    def __init__(self, regionId, source, target, ):
        """
        :param regionId: region id
        :param source: 
        :param target: 
        """

        self.regionId = regionId
        self.taskID = None
        self.status = None
        self.errorCode = None
        self.createdTime = None
        self.lastUpdatedTime = None
        self.source = source
        self.target = target
        self.rule = None

    def setTaskID(self, taskID):
        """
        :param taskID: (Optional) 任务ID (readonly)
        """
        self.taskID = taskID

    def setStatus(self, status):
        """
        :param status: (Optional) 状态 (SUCCESS, ERROR, PENDDING, RUNNING) (readonly)
        """
        self.status = status

    def setErrorCode(self, errorCode):
        """
        :param errorCode: (Optional) 错误码 (readonly)
        """
        self.errorCode = errorCode

    def setCreatedTime(self, createdTime):
        """
        :param createdTime: (Optional) 任务创建时间 时间格式(GMT): yyyy-MM-dd’T’HH:mm:ss.SSS’Z’  (readonly)
        """
        self.createdTime = createdTime

    def setLastUpdatedTime(self, lastUpdatedTime):
        """
        :param lastUpdatedTime: (Optional) 任务创建时间 时间格式(GMT): yyyy-MM-dd’T’HH:mm:ss.SSS’Z’  (readonly)
        """
        self.lastUpdatedTime = lastUpdatedTime

    def setRule(self, rule):
        """
        :param rule: (Optional) 
        """
        self.rule = rule

