# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AddCustomLiveStreamWatermarkTemplateRequest(JDCloudRequest):
    """
    添加用户自定义水印模板

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(AddCustomLiveStreamWatermarkTemplateRequest, self).__init__(
            '/watermarkCustoms:template', 'POST', header, version)
        self.parameters = parameters


class AddCustomLiveStreamWatermarkTemplateParameters(object):

    def __init__(self, offsetX, offsetY, width, height, template, url):
        """
        :param offsetX: x轴偏移量
- 取值范围
  percent: (0,100]
  pixel: (0,1920]

        :param offsetY: y轴偏移量:
- 取值范围
  percent: (0,100]
  pixel: (0,1920]

        :param width: 水印宽度:
- 取值范围
  percent: (0,100]
  pixel: (0,1920]

        :param height: 水印高度:
- 取值范围
  percent: (0,100]
  pixel: (0,1920]

        :param template: 自定义水印模板名称
-&ensp;取值要求: 数字、大小写字母、短横线("-")、下划线("_"),
&ensp;&ensp;首尾不能有特殊字符("-"),
&ensp;&ensp;不超过50字符,utf-8格式
-&ensp;<b>注意: 不能与已定义命名重复</b>

        :param url: 水印地址<br>-&ensp;以&ensp;http:// 开头,可公开访问地址<br>
        """

        self.position = None
        self.offsetUnit = None
        self.offsetX = offsetX
        self.offsetY = offsetY
        self.sizeUnit = None
        self.width = width
        self.height = height
        self.template = template
        self.uploadId = None
        self.url = url

    def setPosition(self, position):
        """
        :param position: (Optional) 水印位置
- 取值范围：左上：1，右上：3， 左下：7，右下：9，默认：1

        """
        self.position = position

    def setOffsetUnit(self, offsetUnit):
        """
        :param offsetUnit: (Optional) 偏移量单位
- 取值: percent,pixel
- percent:按百分比; pixel:像素 默认:pixel

        """
        self.offsetUnit = offsetUnit

    def setSizeUnit(self, sizeUnit):
        """
        :param sizeUnit: (Optional) 水印大小单位
- 取值: percent,pixel
- percent:按百分比; pixel:像素 默认:pixel

        """
        self.sizeUnit = sizeUnit

    def setUploadId(self, uploadId):
        """
        :param uploadId: (Optional) 创建上传任务时返回的uploadId参数，当通过接口上传水印图片时，uploadId必填

        """
        self.uploadId = uploadId

