# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class DBInstanceSpec(object):

    def __init__(self, nodeType, nodeNumber, azId, vpcId, subnetId, chargeSpec, instanceName=None, accountName=None, accountPassword=None):
        """
        :param instanceName: (Optional) 实例名称，名称只支持数字、小写字母、中文及英文下划线，且不少于2字符不超过32字符；未填写取实例ID作为实例名称
        :param nodeType:  节点规格，目前支持jdw.dc1.4xlarge
        :param nodeNumber:  节点数量，目前支持3个
        :param azId:  可用区
        :param vpcId:  VPCID
        :param subnetId:  子网ID
        :param accountName: (Optional) 数据库账号，账号只支持数字、大小写字母及英文下划线“_”，不超过16字符 ，非必填
        :param accountPassword: (Optional) 数据库密码，密码必须包含且只支持大小写字母及数字，不少于8字符不超过16字符，非必填，可创建后设置
        :param chargeSpec:  计费规格，包括计费类型，计费周期等
        """

        self.instanceName = instanceName
        self.nodeType = nodeType
        self.nodeNumber = nodeNumber
        self.azId = azId
        self.vpcId = vpcId
        self.subnetId = subnetId
        self.accountName = accountName
        self.accountPassword = accountPassword
        self.chargeSpec = chargeSpec
