# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeStacksRequest(JDCloudRequest):
    """
    查询资源栈列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeStacksRequest, self).__init__(
            '/regions/{regionId}/stacks', 'GET', header, version)
        self.parameters = parameters


class DescribeStacksParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: 地域 ID
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.stackName = None
        self.action = None
        self.status = None
        self.createStartTime = None
        self.createEndTime = None
        self.updateStartTime = None
        self.updateEndTime = None
        self.sortField = None
        self.sortBy = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 当前所在页，默认为1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 页面大小，默认为20；取值范围[1, 100]
        """
        self.pageSize = pageSize

    def setStackName(self, stackName):
        """
        :param stackName: (Optional) 资源栈名称
        """
        self.stackName = stackName

    def setAction(self, action):
        """
        :param action: (Optional) 资源栈正在执行的动作
        """
        self.action = action

    def setStatus(self, status):
        """
        :param status: (Optional) 资源栈正在执行的动作的状态
        """
        self.status = status

    def setCreateStartTime(self, createStartTime):
        """
        :param createStartTime: (Optional) 创建开始时间
        """
        self.createStartTime = createStartTime

    def setCreateEndTime(self, createEndTime):
        """
        :param createEndTime: (Optional) 创建结束时间
        """
        self.createEndTime = createEndTime

    def setUpdateStartTime(self, updateStartTime):
        """
        :param updateStartTime: (Optional) 更新开始时间
        """
        self.updateStartTime = updateStartTime

    def setUpdateEndTime(self, updateEndTime):
        """
        :param updateEndTime: (Optional) 更新结束时间
        """
        self.updateEndTime = updateEndTime

    def setSortField(self, sortField):
        """
        :param sortField: (Optional) 排序字段, createtime, updatetime
        """
        self.sortField = sortField

    def setSortBy(self, sortBy):
        """
        :param sortBy: (Optional) 排序方式，asc，desc
        """
        self.sortBy = sortBy

