# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DeleteSecurityGroupsRuleRequest(JDCloudRequest):
    """
    删除安全组规则
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DeleteSecurityGroupsRuleRequest, self).__init__(
            '/regions/{regionId}/vpc_securityGroups/{id}/rule', 'DELETE', header, version)
        self.parameters = parameters


class DeleteSecurityGroupsRuleParameters(object):

    def __init__(self, regionId, id, ruleType, protocol, fromPort, toPort, ):
        """
        :param regionId: 地域ID
        :param id: 安全组ID
        :param ruleType: 规则类型，ingress、egress
        :param protocol: 协议，tcp、udp、icmp 或者 all
        :param fromPort: 起始端口
        :param toPort: 终止端口
        """

        self.regionId = regionId
        self.id = id
        self.ruleType = ruleType
        self.protocol = protocol
        self.fromPort = fromPort
        self.toPort = toPort
        self.nicType = None
        self.policy = None
        self.priority = None
        self.cidrIp = None

    def setNicType(self, nicType):
        """
        :param nicType: (Optional) 网络类型，internet、intranet
        """
        self.nicType = nicType

    def setPolicy(self, policy):
        """
        :param policy: (Optional) 认证策略，accept、drop
        """
        self.policy = policy

    def setPriority(self, priority):
        """
        :param priority: (Optional) 认证策略的权重，1-100
        """
        self.priority = priority

    def setCidrIp(self, cidrIp):
        """
        :param cidrIp: (Optional) 目标IP地址范围
        """
        self.cidrIp = cidrIp

